#!/bin/sh
# cleanup
gprclean -q -Psimulation
rm -f obj/gnatinspect.db

# build and run gnatinspect the first time
gprbuild -f -q -p -Psimulation
gnatinspect --exit -Psimulation

# check whether there are duplicated rows in entity_refs

size=`wc -c obj/gnatinspect.db`

request="select count(*), * from entity_refs group by entity, file, line, kind, caller, from_instantiation having count(*) > 1;"

# Do not run sqlite itself, since some build machines have an old version
# on the command line, which will think the database is corrupted
#echo "$request" | sqlite3 obj/gnatinspect.db

# make sure timestamps get updated
sleep 2

# rebuild and relaunch gnatinspect
gprbuild -f -q -Psimulation
gnatinspect --exit -Psimulation
size2=`wc -c obj/gnatinspect.db`

if [ "$size" != "$size2" ]; then
   echo "Size of database has changed after rebuilding separates"
fi

# at this stage there are duplications in entity_refs
#echo "$request" | sqlite3 obj/gnatinspect.db
