--  This test makes sure that if no config file is parsed (not
--  even a default one), then nothing is ever output on stdout.
--  This prevents processes from blocking on I/O when the
--  application might not expect it.

with GNATCOLL.Traces; use GNATCOLL.Traces;

procedure Nofile is
   Me1 : constant Trace_Handle := Create ("ME1");
   Me2 : constant Trace_Handle := Create ("ME2", On);
   Me3 : constant Trace_Handle := Create ("ME3", Off);
begin
   --  All of these are invisible because we haven't parse the
   --  config file.
   Trace (Me1, "Should not output anything");
   Trace (Me2, "Me2 is activated, on default stream, but no config file");
   Trace (Me3, "Should not output anything");

   --  Pretend we parse a config file, but there is none to
   --  be found
   Parse_Config_File (Force_Activation => False);

   --  None of these are visible, since we failed to parse the
   --  config file.
   Trace (Me1, "Still should not output anything");
   Trace (Me2, "Still Me2 is activated");
   Trace (Me3, "Still should not output anything");
end Nofile;
