------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2006-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Email;         use GNATCOLL.Email;
with GNATCOLL.VFS;           use GNATCOLL.VFS;
with Ada.Calendar;           use Ada.Calendar;
with Ada.Strings.Unbounded;  use Ada.Strings.Unbounded;
with Ada.Text_IO;            use Ada.Text_IO;

procedure Test_Email3 is
   function "-" (Str : Unbounded_String) return String
                 renames Ada.Strings.Unbounded.To_String;

   Msg, Reply : Message;
   Output     : Unbounded_String;
   Date : constant Time := Time_Of (2006, 06, 19, 9.0 * 3600.0 + 15.0 * 60.0);

begin
   Msg := New_Message;
   Set_Default_Headers
      (Msg, From_Email => "briot@adacore.com",
       From_Real_Name  => "Emmanuel Briot",
       Subject         => "Photo",
       Local_Date      => Date);
   Set_Boundary (Msg, "Hello");  --  Test that =_ is properly added (optional)

   Add_Header (Msg, Create ("To", "foo@bar.com"));  --  Test the reply to
   Add_Header (Msg, Create ("CC", "bar@foo.com"));  --  Test the reply to

   Set_Text_Payload (Msg, "This is a recent picture of"
                          & ASCII.LF & "--Hello" & ASCII.LF);
   Attach (Msg, Path => Create (+"hello.jpg"),
           Mime_Type   => Image_Jpeg,
           Description => "Hello picture",
           Disposition => Disposition_Inline);

   To_String (Msg, Envelope => True, Result => Output);
   Put_Line (-Output);

   Reply := Reply_To (Msg, From_Email => "me@nowhere.com",
                      Reply_All => True, Quote => True,
                      Local_Date => Date + 3600.0);
   To_String (Reply, Envelope => True, Result => Output);
   Put_Line (-Output);
end Test_Email3;
