/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Locale;

import net.noderunner.http.ServerResponse;

import junit.framework.TestCase;

public class HttpServletResponseImplTest extends TestCase {
	
	HttpServletResponseImpl res = new HttpServletResponseImpl();

	public void testSimple() throws Exception {
		ServerResponse response = res.createServerResponse();
		assertEquals("HTTP/1.1 200 OK", response.getStatusLine().toString());
	}
	
	public void testSimple2() throws Exception {
		assertSame(res.getOutputStream(), res.getOutputStream());
		assertSame(res.getWriter(), res.getWriter());
		res.getOutputStream().write((byte)'!');
		res.getWriter().write("Hi");
		ServerResponse response = res.createServerResponse();
		assertEquals("HTTP/1.1 200 OK", response.getStatusLine().toString());
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		response.getDataPoster().sendData(os);
		assertEquals("!Hi", os.toString());
	}
	
	public void testEnc() throws IOException {
		res.setContentType("text/xml; encoding=UTF-8");
		res.getWriter().append('\u2668');
		assertEquals("UTF-8", res.getCharacterEncoding());
	}
	
	public void testCoverage() throws IOException {
		res.setLocale(Locale.CANADA);
		assertEquals(Locale.CANADA, res.getLocale());
		assertEquals("ISO-8859-1", res.getCharacterEncoding());
		res.setCharacterEncoding("UTF-8");
		assertEquals("UTF-8", res.getCharacterEncoding());
		res.setBufferSize(100);
		res.getOutputStream().write(5);
		res.resetBuffer();
		res.getOutputStream().write(5);
		res.reset();
		res.addDateHeader("foo", new Date().getTime());
		res.setDateHeader("foo", new Date().getTime());
		res.addIntHeader("bar", 5);
		res.setIntHeader("bar", 5);
		ByteArrayOutputStream os = new ByteArrayOutputStream();
		ServerResponse response = res.createServerResponse();
		response.getDataPoster().sendData(os);
		assertEquals("", os.toString());
	}
	
}
