/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MemberCollection {
    private Set members = new HashSet();

    public void addMember(MemberDescription member) {
        if (MemberType.CLASS == member.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.add(member);
    }

    public void updateMember(MemberDescription member) {
        if (MemberType.CLASS == member.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        this.members.remove(member);
        this.members.add(member);
    }

    public Collection getAllMembers() {
        return this.members;
    }

    public boolean contains(MemberDescription newMember) {
        return this.members.contains(newMember);
    }

    public Iterator iterator() {
        return this.members.iterator();
    }

    public void changeMember(MemberDescription oldMember, MemberDescription newMember) {
        if (MemberType.CLASS == newMember.getMemberType()) {
            throw new IllegalArgumentException("Instances of ClassDescription are not allowed here!");
        }
        if (!this.contains(oldMember)) {
            throw new IllegalArgumentException("Member " + oldMember + " not found!");
        }
        this.members.remove(oldMember);
        this.members.add(newMember);
    }

    public MemberDescription find(MemberDescription mr) {
        Iterator e = this.members.iterator();
        while (e.hasNext()) {
            MemberDescription member = (MemberDescription)e.next();
            if (!member.equals(mr)) continue;
            return member;
        }
        return null;
    }

    public MemberDescription findSimilar(MemberDescription mr) {
        Iterator e = this.members.iterator();
        while (e.hasNext()) {
            MemberDescription member = (MemberDescription)e.next();
            if (!member.getType().equals(mr.getType()) || !member.getName().equals(mr.getName())) continue;
            return member;
        }
        return null;
    }

    public int getMembersCount(MemberType memberType, String fqname) {
        int count = 0;
        Iterator e = this.members.iterator();
        while (e.hasNext()) {
            MemberDescription member = (MemberDescription)e.next();
            if (memberType != null && memberType != member.getMemberType() || !fqname.equals(member.getQualifiedName())) continue;
            ++count;
        }
        return count;
    }
}

