/*! 
* This Source Code Form is subject to the terms of the Mozilla Public
* License, v. 2.0. If a copy of the MPL was not distributed with this file,
* You can obtain one at http://mozilla.org/MPL/2.0/.
*
* Copyright(c) 2009 Apogee Instruments, Inc. 
* \class CLibCurlWrap 
* \brief C++ wrapper for the libcurl c interface 
* 
*/ 


#ifndef CLIBCURLWRAP_INCLUDE_H__ 
#define CLIBCURLWRAP_INCLUDE_H__ 

#include "curl/curl.h"
#include <string>
#include <vector>
#include <stdint.h>

class CLibCurlWrap 
{ 
    public: 
        CLibCurlWrap();
        virtual ~CLibCurlWrap(); 

        void HttpGet(const std::string & url,
            std::string & result);

        void HttpGet(const std::string & url,
            std::vector<uint8_t> & result);

        void HttpPost(const std::string & url,
            const std::string & postFields, 
            std::string & result);

        void HttpPost(const std::string & url,
            const std::string & postFields, 
            std::vector<uint8_t> & result);

		void setTimeout( int timeout );
		unsigned int getTimeout();

        std::string GetVerison();
    private:
		unsigned int m_timeout;

        void CurlSetupStrWrite(const std::string & url);
        std::string ExecuteStr();

        void CurlSetupVectWrite(const std::string & url, const std::vector<uint8_t> & result);
        void ExecuteVect(std::vector<uint8_t> & result);

        CURL * m_curlHandle;
        const std::string m_fileName;

        //disable the copy ctor and assignment operator
        //generated by the compiler
        //Effective C++ Item 6
        CLibCurlWrap(const CLibCurlWrap&);
        CLibCurlWrap& operator=(CLibCurlWrap&);
}; 

#endif
