/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag.layout;

import java.io.IOException;
import java.util.Map;
import java.util.Stack;
import javax.servlet.jsp.JspException;
import net.sourceforge.stripes.tag.StripesTagSupport;
import net.sourceforge.stripes.tag.layout.LayoutContext;
import net.sourceforge.stripes.util.Log;

public class LayoutDefinitionTag
extends StripesTagSupport {
    private static final Log log = Log.getInstance(LayoutDefinitionTag.class);
    public static final String PREFIX = "stripes.layout.";
    private LayoutContext context;

    public int doStartTag() throws JspException {
        try {
            this.getPageContext().getOut().clearBuffer();
        }
        catch (IOException ioe) {
            log.warn("Could not clear buffer before rendering a layout.", ioe);
        }
        String name = (String)this.getPageContext().getRequest().getAttribute("javax.servlet.include.servlet_path");
        Stack stack = (Stack)this.getPageContext().getRequest().getAttribute(PREFIX + name);
        this.context = (LayoutContext)stack.peek();
        for (Map.Entry<String, Object> entry : this.context.getParameters().entrySet()) {
            this.getPageContext().setAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.context.getComponents().entrySet()) {
            this.getPageContext().setAttribute(entry.getKey(), entry.getValue());
        }
        this.context.setRendered(true);
        return 1;
    }

    public int doEndTag() throws JspException {
        return 5;
    }

    public boolean permissionToRender(String componentName) throws JspException {
        if (this.context.getComponents().containsKey(componentName)) {
            try {
                this.getPageContext().getOut().write(this.context.getComponents().get(componentName));
            }
            catch (IOException ioe) {
                throw new JspException("Could not output overridden layout component.", (Throwable)ioe);
            }
            return false;
        }
        return true;
    }
}

