/*
 * File    : ProjectLibraryEditorPanel.java
 * Created : 10-jun-2002 13:36
 * By      : fbusquets
 *
 * JClic - Authoring and playing system for educational activities
 *
 * Copyright (C) 2000 - 2005 Francesc Busquets & Departament
 * d'Educacio de la Generalitat de Catalunya
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details (see the LICENSE file).
 */

package edu.xtec.jclic.project;

import edu.xtec.jclic.edit.*;
import edu.xtec.util.Options;


/**
 *
 * @author Francesc Busquets (fbusquets@xtec.cat)
 * @version 13.08.29
 */
public class ProjectLibraryEditorPanel extends EditorPanel {

    /** Creates new form ProjectLibraryEditorPanel */
    public ProjectLibraryEditorPanel(Options options) {
        super(options);
        ProjectLibraryEditor.createActions(options);
        initComponents();
        postInit(250, true, false );
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel titleLb;

        mainPanel = new javax.swing.JPanel();
        titleLb = new javax.swing.JLabel();
        titleText = new javax.swing.JTextField();
        titleText.getDocument().addDocumentListener(this);

        setLayout(new java.awt.BorderLayout());

        mainPanel.setLayout(new java.awt.GridBagLayout());

        mainPanel.setOpaque(false);
        titleLb.setText(options.getMsg("edit_name"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 2, 2);
        mainPanel.add(titleLb, gridBagConstraints);

        titleText.setToolTipText(options.getMsg("library_dlg_name_tooltip"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 2, 2, 4);
        mainPanel.add(titleText, gridBagConstraints);

        add(mainPanel, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents

    public boolean checkIfEditorValid(Editor e) {
        return e instanceof ProjectLibraryEditor;
    }   
    
    protected ProjectLibrary getProjectLibrary(){
        if(editor==null)
            return null;
        else
            return ((ProjectLibraryEditor)editor).getProjectLibrary();
            //return (ProjectLibrary)editor.getData();
    }
    
    public void fillData(){
        ProjectLibrary p=getProjectLibrary();
        titleText.setText(p==null ? options.getMsg("UNNAMED") : p.settings.title);
    }
    
    public void saveData(){
        ProjectLibrary p=getProjectLibrary();
        if(p!=null){
            p.settings.title=checkEmptyString(titleText.getText(), true, options.getMsg("UNNAMED"));
            titleText.setText(p.settings.title);
        }
    }
    
    /*
    public boolean isModified(){
        boolean result=super.isModified();
        if(!result && getProjectLibrary()!=null){
            result=!(Utils.compareObjects
            (titleText.getText()
            , getProjectLibrary().settings.title));
        }
        return result;        
    } 
     */   
    
    @Override
    protected javax.swing.Icon getIcon(){
        return ProjectLibraryEditor.getIcon();
    }
    
    @Override
    protected String getTitle(){
        return options.getMsg("library_dlg_title");
    }        

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel mainPanel;
    private javax.swing.JTextField titleText;
    // End of variables declaration//GEN-END:variables

}
