package CParse::Function;

use 5.6.0;
use strict;
use warnings;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $specifiers = shift;
    my $declarator = shift;
    my $declarations = shift;

    my $self = {specifiers => $specifiers,
                declarator => $declarator,
                declarations => $declarations,
               };
    bless $self, $class;

    if (scalar @$declarations)
      {
        print STDERR $self->dump_c;
        die "K&R function definition, go away";
      }

    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $specifiers = join(' ', grep {$_} map {$_->dump_c} @{$self->{specifiers}});
    my $declarator = $self->{declarator}->dump_c;
    my $declarations = join('', map {'  ' . $_->dump_c . "\n"} @{$self->{declarations}});

    return "$specifiers\n$declarator\n$declarations\{\n  /* ... */\n}\n";
  }

sub set_location
  {
    my $self = shift;
    $self->{file} = shift;
    $self->{line} = shift;
    $self->{pos} = shift;
  }

sub process
  {
    my $self = shift;
    my $namespace = shift;

    my $storage_class;
    my $inline;
    my @attributes;
    my @specifiers;

    my @process_specifiers;

    $CParse::current_location = $self;

    foreach my $specifier (@{$self->{specifiers}})
      {
        if ($specifier->isa('CParse::StorageClass'))
          {
            if ($storage_class)
              {
                print STDERR "$self->{file}:$self->{line}:$self->{pos}: multiple storage class specifiers\n";
                print STDERR "$self->{file}:$self->{line}:$self->{pos}:  in " . $self->dump_c;
                exit 1;
              }
            $storage_class = $specifier;
          }
        elsif ($specifier->isa('CParse::FunctionSpecifier'))
          {
            if ($specifier->name ne 'inline')
              {
                die "Internal error: unrecognised storage class specifier " . $specifier->name;
              }
            $inline = 1;
          }
        elsif ($specifier->isa('CParse::AttributeList'))
          {
            push @attributes, $specifier->attributes;
          }
        elsif ($specifier->isa('CParse::Struct') or $specifier->isa('CParse::Union'))
          {
            push @specifiers, $specifier;
            push @process_specifiers, $specifier;
          }
        else
          {
            push @specifiers, $specifier;
          }
      }

    eval
      {
        $_->process($namespace) foreach @process_specifiers;
        $self->{declarator}->process_decl($namespace, $storage_class, \@specifiers, $inline, \@attributes);
      };
    if ($@)
      {
        my $err = $@;
        $err =~ s/\n*$//;
        my @err = split /\n/, $err;
        print STDERR "$self->{file}:$self->{line}:$self->{pos}: $_\n" foreach @err;
        my $dump = eval {$self->dump_c};
        if ($dump)
          {
            my @dump = split /\n/, $dump;
            my $first = 1;
            foreach (@dump)
              {
                print STDERR "$self->{file}:$self->{line}:$self->{pos}:  " . ($first ? "in" : "  ") . " $_\n";
                $first = 0;
              }
          }
        exit 1;
      }

    $CParse::current_location = undef;
  }

1;
