# List of examples

| Example                                          | Description                                                               | Level              |
|:-------------------------------------------------|:--------------------------------------------------------------------------|:-------------------|
|[icehello](./icehello/)                           | Sending data to another process                                           | :star:             |
|[icedelivery](./icedelivery/)                     | Sending and receiving data using C++                                      | :star:             |
|[icedelivery_in_c](./icedelivery_in_c/)           | Sending and receiving data using C                                        | :star:             |
|[icedocker](./icedocker/)                         | Sending and receiving data across multiple docker instances               | :star:             |
|[iceoptions](./iceoptions/)                       | Configuring pub/sub settings like history cache size or startup behaviour | :star:             |
|[complexdata](./complexdata/)                     | Sending/receiving some of the iceoryx STL container surrogates            | :star:             |
|[request_response](./request_response/)           | Delivering data on demand (Client/Server) using C++                       | :star:             |
|[request_response_in_c](./request_response_in_c/) | Delivering data on demand (Client/Server) using C                         | :star:             |
|[callbacks](./callbacks/)                         | Implementing event triggered callbacks using C++                          | :star::star:       |
|[callbacks_in_c](./callbacks_in_c/)               | Implementing event triggered callbacks using C                            | :star::star:       |
|[waitset](./waitset/)                             | Waiting for events like arrival of data using C++                         | :star::star:       |
|[waitset_in_c](./waitset_in_c/)                   | Waiting for events like arrival of data using C                           | :star::star:       |
|[iceensemble](./iceensemble/)                     | Using multiple publishers for one topic                                   | :star::star:       |
|[singleprocess](./singleprocess/)                 | Communicating in a single process between threads                         | :star::star:       |
|[user_header](./user_header/)                     | Using a user-header for additional meta-information like timestamps       | :star::star:       |
|[icediscovery](./icediscovery)                    | Searching for currently available services                                | :star::star:       |
|[icediscovery_in_c](./icediscovery_in_c/)         | Searching for currently available services using C                        | :star::star:       |
|[ice_access_control](./ice_access_control/)       | Configuring access rights for shared memory segments                      | :star::star::star: |
|[iceperf](./iceperf/)                             | Measuring the latency of different IPC mechanisms                         | :star::star::star: |
|[icecrystal](./icecrystal/)                       | Using the introspection client for debugging                              | :star::star::star: |
