#! /usr/bin/env python
# Build file for Python modules
import sys
from re import compile
from distutils.core import setup, Extension

inc_re = compile('^--include-dirs=(.*)$')
lib_re = compile('^--library-dirs=(.*)$')
exlib_re = compile('^--extra-library=(.*)$')
old_argv = sys.argv
sys.argv = []
inc_dirs = ['.']
lib_dirs = []
libs = ['sidl']

for i in old_argv:
  m = inc_re.match(i)
  if (m):
    if (len(m.group(1))): inc_dirs.append(m.group(1))
  else:
    m = lib_re.match(i)
    if (m):
      if (len(m.group(1))): lib_dirs.append(m.group(1))
    else:
      m = exlib_re.match(i)
      if (m):
        if (len(m.group(1))): libs.append(m.group(1))
      else:
        sys.argv.append(i)
setup(name='babel',
  include_dirs=inc_dirs,
  headers = [
    'bHYPRE_BiCGSTAB_Module.h',
    'bHYPRE_BoomerAMG_Module.h',
    'bHYPRE_CGNR_Module.h',
    'bHYPRE_CoefficientAccess_Module.h',
    'bHYPRE_ErrorHandler_Module.h',
    'bHYPRE_Euclid_Module.h',
    'bHYPRE_GMRES_Module.h',
    'bHYPRE_HGMRES_Module.h',
    'bHYPRE_HPCG_Module.h',
    'bHYPRE_Hybrid_Module.h',
    'bHYPRE_IJMatrixView_Module.h',
    'bHYPRE_IJParCSRMatrix_Module.h',
    'bHYPRE_IJParCSRVector_Module.h',
    'bHYPRE_IJVectorView_Module.h',
    'bHYPRE_IdentitySolver_Module.h',
    'bHYPRE_MPICommunicator_Module.h',
    'bHYPRE_MatrixVectorView_Module.h',
    'bHYPRE_Operator_Module.h',
    'bHYPRE_PCG_Module.h',
    'bHYPRE_ParCSRDiagScale_Module.h',
    'bHYPRE_ParaSails_Module.h',
    'bHYPRE_Pilut_Module.h',
    'bHYPRE_PreconditionedSolver_Module.h',
    'bHYPRE_ProblemDefinition_Module.h',
    'bHYPRE_SStructDiagScale_Module.h',
    'bHYPRE_SStructGraph_Module.h',
    'bHYPRE_SStructGrid_Module.h',
    'bHYPRE_SStructMatrixVectorView_Module.h',
    'bHYPRE_SStructMatrixView_Module.h',
    'bHYPRE_SStructMatrix_Module.h',
    'bHYPRE_SStructParCSRMatrix_Module.h',
    'bHYPRE_SStructParCSRVector_Module.h',
    'bHYPRE_SStructSplit_Module.h',
    'bHYPRE_SStructStencil_Module.h',
    'bHYPRE_SStructVectorView_Module.h',
    'bHYPRE_SStructVector_Module.h',
    'bHYPRE_Schwarz_Module.h',
    'bHYPRE_Solver_Module.h',
    'bHYPRE_StructDiagScale_Module.h',
    'bHYPRE_StructGrid_Module.h',
    'bHYPRE_StructJacobi_Module.h',
    'bHYPRE_StructMatrixView_Module.h',
    'bHYPRE_StructMatrix_Module.h',
    'bHYPRE_StructPFMG_Module.h',
    'bHYPRE_StructSMG_Module.h',
    'bHYPRE_StructStencil_Module.h',
    'bHYPRE_StructVectorView_Module.h',
    'bHYPRE_StructVector_Module.h',
    'bHYPRE_Vector_Module.h'
  ],
  packages = [
    'bHYPRE'
  ],
  ext_modules = [
    Extension('bHYPRE.BiCGSTAB',
      ["bHYPRE/bHYPRE_BiCGSTAB_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.BoomerAMG',
      ["bHYPRE/bHYPRE_BoomerAMG_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.CGNR',
      ["bHYPRE/bHYPRE_CGNR_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.CoefficientAccess',
      ["bHYPRE/bHYPRE_CoefficientAccess_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.ErrorHandler',
      ["bHYPRE/bHYPRE_ErrorHandler_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Euclid',
      ["bHYPRE/bHYPRE_Euclid_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.GMRES',
      ["bHYPRE/bHYPRE_GMRES_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.HGMRES',
      ["bHYPRE/bHYPRE_HGMRES_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.HPCG',
      ["bHYPRE/bHYPRE_HPCG_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Hybrid',
      ["bHYPRE/bHYPRE_Hybrid_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.IJMatrixView',
      ["bHYPRE/bHYPRE_IJMatrixView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.IJParCSRMatrix',
      ["bHYPRE/bHYPRE_IJParCSRMatrix_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.IJParCSRVector',
      ["bHYPRE/bHYPRE_IJParCSRVector_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.IJVectorView',
      ["bHYPRE/bHYPRE_IJVectorView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.IdentitySolver',
      ["bHYPRE/bHYPRE_IdentitySolver_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.MPICommunicator',
      ["bHYPRE/bHYPRE_MPICommunicator_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.MatrixVectorView',
      ["bHYPRE/bHYPRE_MatrixVectorView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Operator',
      ["bHYPRE/bHYPRE_Operator_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.PCG',
      ["bHYPRE/bHYPRE_PCG_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.ParCSRDiagScale',
      ["bHYPRE/bHYPRE_ParCSRDiagScale_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.ParaSails',
      ["bHYPRE/bHYPRE_ParaSails_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Pilut',
      ["bHYPRE/bHYPRE_Pilut_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.PreconditionedSolver',
      ["bHYPRE/bHYPRE_PreconditionedSolver_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.ProblemDefinition',
      ["bHYPRE/bHYPRE_ProblemDefinition_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructDiagScale',
      ["bHYPRE/bHYPRE_SStructDiagScale_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructGraph',
      ["bHYPRE/bHYPRE_SStructGraph_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructGrid',
      ["bHYPRE/bHYPRE_SStructGrid_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructMatrix',
      ["bHYPRE/bHYPRE_SStructMatrix_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructMatrixVectorView',
      ["bHYPRE/bHYPRE_SStructMatrixVectorView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructMatrixView',
      ["bHYPRE/bHYPRE_SStructMatrixView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructParCSRMatrix',
      ["bHYPRE/bHYPRE_SStructParCSRMatrix_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructParCSRVector',
      ["bHYPRE/bHYPRE_SStructParCSRVector_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructSplit',
      ["bHYPRE/bHYPRE_SStructSplit_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructStencil',
      ["bHYPRE/bHYPRE_SStructStencil_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructVector',
      ["bHYPRE/bHYPRE_SStructVector_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.SStructVectorView',
      ["bHYPRE/bHYPRE_SStructVectorView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Schwarz',
      ["bHYPRE/bHYPRE_Schwarz_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Solver',
      ["bHYPRE/bHYPRE_Solver_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructDiagScale',
      ["bHYPRE/bHYPRE_StructDiagScale_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructGrid',
      ["bHYPRE/bHYPRE_StructGrid_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructJacobi',
      ["bHYPRE/bHYPRE_StructJacobi_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructMatrix',
      ["bHYPRE/bHYPRE_StructMatrix_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructMatrixView',
      ["bHYPRE/bHYPRE_StructMatrixView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructPFMG',
      ["bHYPRE/bHYPRE_StructPFMG_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructSMG',
      ["bHYPRE/bHYPRE_StructSMG_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructStencil',
      ["bHYPRE/bHYPRE_StructStencil_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructVector',
      ["bHYPRE/bHYPRE_StructVector_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.StructVectorView',
      ["bHYPRE/bHYPRE_StructVectorView_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs),
    Extension('bHYPRE.Vector',
      ["bHYPRE/bHYPRE_Vector_Module.c"
      ],
      library_dirs=lib_dirs,
      libraries=libs)
  ])
