//
// URL.h
//
// URL: A URL parsing class, implementing as closely as possible the standard
//      laid out in RFC2396 (e.g. http://www.faqs.org/rfcs/rfc2396.html)
//      including support for multiple schemes.
//
// Part of the ht://Dig package   <http://www.htdig.org/>
// Copyright (c) 1999 The ht://Dig Group
// Some Portions Copyright (c) 2008 Devise.IT srl <http://www.devise.it/>
// For copyright details, see the file COPYING in your distribution
// or the GNU Public License version 2 or later 
// <http://www.gnu.org/copyleft/gpl.html>
//
// $Id: URL.h,v 1.10 2008-11-16 18:28:52 angusgb Exp $
//

#ifndef _URL_h_
#define _URL_h_

#include "htString.h"
#include "Configuration.h"

class URL
{
public:
    URL();
    URL(const char* url);
    URL(const URL &url);
    URL(const String &ref, const URL &parent);

    void parse(const char* url);

    const String &host() const      {return _host;}
    void host(const String &h)      {_host = h;}
    
    int port() const                {return _port;}
    void port(const int p)          {_port = p;}
    
    const String &service() const   {return _service;}
    void service(const String &s)   {_service = s;}

    const String &path() const      {return _path;}
    void path(const String &p);
    
    int hopcount() const            {return _hopcount;}
    void hopcount(int h)            {_hopcount = h;}
    
    const String &user() const      {return _user;}
    void user(const String &u)      {_user = u;}

    const String &get() const {return _url;}
    void dump();
    void normalize();
    const String &signature();
    int		DefaultPort();
    
    static void SetConfiguration(Configuration& c)
            { _config = &c; }

private:
    String		_url;
    String		_path;
    String		_service;
    String		_host;
    int			_port;
    int			_normal;
    int			_hopcount;
    String		_signature;
    String		_user;
    static Configuration*    _config;

    void		removeIndex(String &);
    void                normalizePath();
    void		ServerAlias();
    void		constructURL();
};

#endif


