<?php

//    showacheck.php
//    Shows information about a URL with an accessibility error
//
//    Part of the ht://Check package
//
//    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
//    Author: Valentina Del Sapio - Prato - Italy
//
//    For copyright details, see the file COPYING in your distribution
//    or the GNU General Public License version 2 or later 
//    <http://www.gnu.org/copyleft/gpl.html>
//
//    $Id: showacheck.php,v 1.2 2004/05/26 09:38:56 angusgb Exp $

///////
   //    Global settings
///////

include ("./include/global.inc.php");

eval("\$strhome = \"$strDBHome \";");
$linkbar = "<a href=\"index.php?dbname=". $dbname . "\">". $strhome ."</A>";
$linkbar .= " | <a href=\"javascript:history.go(-1)\">" . $strBack . "</A>";

include ("./include/header.inc.php");

if (!isset($dbname))
{
   // Error
   DisplayErrMsg($strErrorNoDBSelected);
   echo "<a href=\"index.php\">" . $strMainPage . "</A>";
   die;
}
else
{
   if (!isset($IDUrl) || !isset($acheckcode))
   {
      // Error
      DisplayErrMsg($strMissingInfo);
      echo "<a href=\"index.php?dbname=". $dbname . "\">". $strhome."</A>";
      die;
   }

   $strselect = '';
   $strfrom = '';
   $strwhere = '';

   if (!empty($AttrPosition))
   {
      $strselect .= ", ha.Attribute, ha.Content";
      $strfrom .= " JOIN HtmlAttribute ha USING (IDUrl, TagPosition, AttrPosition)";
      $strwhere .= " AND a.AttrPosition = " . $AttrPosition;
   }
   else
      $strwhere .= " AND a.AttrPosition IS NULL";

   if (!empty($TagPosition))
   {
      $strselect .= ", hs.Statement, hs.Row";
      $strfrom .= " JOIN HtmlStatement hs USING (IDUrl, TagPosition)";
      $strwhere .= " AND a.TagPosition = " . $TagPosition;
   }
   else
      $strwhere .= " AND a.TagPosition IS NULL";

   $strSQL = "SELECT Url.Url"
      . $strselect
      . " FROM Url, Accessibility a"
      . $strfrom
      . " WHERE a.IDUrl =" . $IDUrl . " AND a.Code =" . $acheckcode
      . $strwhere
      . " AND Url.IDUrl =" . $IDUrl;

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if (! $num=$MyDB->NumRows())
   {
      DisplayErrMsg($strNoOccurrencies);
      die;
   }

   $row = $MyDB->FetchArray();

   include ("./include/header.inc.php");
?>
<h3><?php echo WriteHTML($row['Url']); ?></h3>
<div class="header">
<h4><?php echo $strAcheckInfo; ?></h4>
</div>

<div class="content">
<?php
if ($row['Statement'])
{ ?>
   <strong><?php echo $strHTMLStatement; ?></strong>: &lt;<?php 
   echo WriteHTML($row['Statement']); ?>&gt;<br>
   <?php
}
if ($row['Attribute'])
{ ?>
   <strong><?php echo $strHTMLAttribute; ?></strong>: <?php 
   echo WriteHTML($row['Attribute']); ?>="<?php echo WriteHTML($row["Content"]); ?>"<br>
   <?php
}
if ($row['Row'])
{ ?>
   <strong><?php echo $strHTMLStatementRow; ?></strong>: <?php echo WriteHTML($row["Row"]); ?><br>
   <?php
} ?>
<br>
<strong><?php echo $strAcheckError; ?>:</strong> <?php echo $strAchecks[$acheckcode]['error']; ?><br>
<strong><?php echo $strAcheckDescription; ?>:</strong> <?php echo $strAchecks[$acheckcode]['description']; ?><br>
<strong><?php echo $strAcheckHowToRepair; ?>: </strong> <?php echo $strAchecks[$acheckcode]['repair']; ?><br>
</div>

<div class="header">
<h4><?php echo $strOperations; ?></h4>
</div>

<div class="content">
<ul>
<?php

   $MyDB->Free();

   $strSQL = "Select IDUrl from Url WHERE IDUrl=$IDUrl AND Contents IS NOT NULL";

   $result=$MyDB->Query($dbname, $strSQL);
   
   if ($result)
   {
      DisplayErrMsg($MyDB->errmsg);
      die;
   }
   
   if ($num=$MyDB->NumRows())
      $DisplaySource = true;
   else
      $DisplaySource = false;

   $MyDB->Free();

if ($DisplaySource)
{
?>
<li><a href="showsource.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDUrl; ?>&RowNumber=<?php echo $row['Row']; ?>#<?php echo $row['Row']; ?>" target="_urlsource"><?php echo $strShowThisUrlSource; ?></a></li>
<?php
} 
?>
<li><a href="showurl.php?dbname=<?php echo $dbname; ?>&IDUrl=<?php echo $IDUrl; ?>"><?php echo $strShowUrl; ?></a></li>
</ul>
</div>
<?php      
}
include ("./include/footer.inc.php"); ?>
