#ifndef ML99_NAT_DIV_H
#define ML99_NAT_DIV_H

#include <metalang99/priv/bool.h>
#include <metalang99/priv/util.h>

#include <metalang99/maybe.h>
#include <metalang99/tuple.h>

#define ML99_div_IMPL(x, y)                                                                        \
    ML99_matchWithArgs_IMPL(ML99_PRIV_DIV_CHECKED(x, y), ML99_PRIV_DIV_, x, y)
#define ML99_PRIV_DIV_nothing_IMPL(_, x, y) ML99_fatal(ML99_div, x is not divisible by y)
#define ML99_PRIV_DIV_just_IMPL(n, _x, _y)  v(n)

#define ML99_PRIV_DIV_CHECKED(x, y)                                                                \
    ML99_PRIV_IF(                                                                                  \
        ML99_PRIV_NAT_EQ(y, 1),                                                                    \
        ML99_JUST(x),                                                                              \
        ML99_PRIV_IF(                                                                              \
            ML99_PRIV_NAT_EQ(x, y),                                                                \
            ML99_JUST(1),                                                                          \
            ML99_UNTUPLE(ML99_PRIV_SND(ML99_PRIV_DIV_##x##_##y, (ML99_NOTHING())))))

#define ML99_PRIV_DIV_4_2 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_6_2 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_6_3 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_8_2 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_8_4 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_9_3 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_10_2 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_10_5 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_12_2 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_12_3 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_12_4 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_12_6 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_14_2 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_14_7 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_15_3 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_15_5 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_16_2 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_16_4 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_16_8 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_18_2 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_18_3 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_18_6 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_18_9 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_20_2  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_20_4  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_20_5  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_20_10 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_21_3 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_21_7 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_22_2  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_22_11 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_24_2  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_24_3  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_24_4  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_24_6  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_24_8  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_24_12 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_25_5 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_26_2  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_26_13 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_27_3 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_27_9 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_28_2  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_28_4  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_28_7  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_28_14 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_30_2  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_30_3  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_30_5  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_30_6  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_30_10 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_30_15 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_32_2  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_32_4  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_32_8  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_32_16 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_33_3  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_33_11 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_34_2  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_34_17 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_35_5 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_35_7 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_36_2  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_36_3  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_36_4  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_36_6  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_36_9  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_36_12 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_36_18 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_38_2  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_38_19 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_39_3  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_39_13 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_40_2  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_40_4  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_40_5  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_40_8  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_40_10 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_40_20 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_42_2  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_42_3  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_42_6  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_42_7  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_42_14 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_42_21 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_44_2  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_44_4  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_44_11 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_44_22 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_45_3  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_45_5  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_45_9  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_45_15 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_46_2  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_46_23 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_48_2  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_48_3  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_48_4  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_48_6  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_48_8  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_48_12 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_48_16 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_48_24 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_49_7 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_50_2  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_50_5  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_50_10 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_50_25 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_51_3  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_51_17 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_52_2  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_52_4  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_52_13 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_52_26 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_54_2  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_54_3  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_54_6  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_54_9  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_54_18 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_54_27 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_55_5  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_55_11 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_56_2  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_56_4  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_56_7  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_56_8  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_56_14 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_56_28 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_57_3  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_57_19 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_58_2  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_58_29 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_60_2  ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_60_3  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_60_4  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_60_5  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_60_6  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_60_10 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_60_12 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_60_15 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_60_20 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_60_30 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_62_2  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_62_31 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_63_3  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_63_7  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_63_9  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_63_21 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_64_2  ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_64_4  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_64_8  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_64_16 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_64_32 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_65_5  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_65_13 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_66_2  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_66_3  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_66_6  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_66_11 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_66_22 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_66_33 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_68_2  ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_68_4  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_68_17 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_68_34 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_69_3  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_69_23 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_70_2  ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_70_5  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_70_7  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_70_10 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_70_14 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_70_35 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_72_2  ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_72_3  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_72_4  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_72_6  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_72_8  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_72_9  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_72_12 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_72_18 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_72_24 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_72_36 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_74_2  ~, (ML99_JUST(37))
#define ML99_PRIV_DIV_74_37 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_75_3  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_75_5  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_75_15 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_75_25 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_76_2  ~, (ML99_JUST(38))
#define ML99_PRIV_DIV_76_4  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_76_19 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_76_38 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_77_7  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_77_11 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_78_2  ~, (ML99_JUST(39))
#define ML99_PRIV_DIV_78_3  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_78_6  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_78_13 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_78_26 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_78_39 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_80_2  ~, (ML99_JUST(40))
#define ML99_PRIV_DIV_80_4  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_80_5  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_80_8  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_80_10 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_80_16 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_80_20 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_80_40 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_81_3  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_81_9  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_81_27 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_82_2  ~, (ML99_JUST(41))
#define ML99_PRIV_DIV_82_41 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_84_2  ~, (ML99_JUST(42))
#define ML99_PRIV_DIV_84_3  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_84_4  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_84_6  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_84_7  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_84_12 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_84_14 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_84_21 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_84_28 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_84_42 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_85_5  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_85_17 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_86_2  ~, (ML99_JUST(43))
#define ML99_PRIV_DIV_86_43 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_87_3  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_87_29 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_88_2  ~, (ML99_JUST(44))
#define ML99_PRIV_DIV_88_4  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_88_8  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_88_11 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_88_22 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_88_44 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_90_2  ~, (ML99_JUST(45))
#define ML99_PRIV_DIV_90_3  ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_90_5  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_90_6  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_90_9  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_90_10 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_90_15 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_90_18 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_90_30 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_90_45 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_91_7  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_91_13 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_92_2  ~, (ML99_JUST(46))
#define ML99_PRIV_DIV_92_4  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_92_23 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_92_46 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_93_3  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_93_31 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_94_2  ~, (ML99_JUST(47))
#define ML99_PRIV_DIV_94_47 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_95_5  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_95_19 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_96_2  ~, (ML99_JUST(48))
#define ML99_PRIV_DIV_96_3  ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_96_4  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_96_6  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_96_8  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_96_12 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_96_16 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_96_24 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_96_32 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_96_48 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_98_2  ~, (ML99_JUST(49))
#define ML99_PRIV_DIV_98_7  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_98_14 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_98_49 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_99_3  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_99_9  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_99_11 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_99_33 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_100_2  ~, (ML99_JUST(50))
#define ML99_PRIV_DIV_100_4  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_100_5  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_100_10 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_100_20 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_100_25 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_100_50 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_102_2  ~, (ML99_JUST(51))
#define ML99_PRIV_DIV_102_3  ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_102_6  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_102_17 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_102_34 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_102_51 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_104_2  ~, (ML99_JUST(52))
#define ML99_PRIV_DIV_104_4  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_104_8  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_104_13 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_104_26 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_104_52 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_105_3  ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_105_5  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_105_7  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_105_15 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_105_21 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_105_35 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_106_2  ~, (ML99_JUST(53))
#define ML99_PRIV_DIV_106_53 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_108_2  ~, (ML99_JUST(54))
#define ML99_PRIV_DIV_108_3  ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_108_4  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_108_6  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_108_9  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_108_12 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_108_18 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_108_27 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_108_36 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_108_54 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_110_2  ~, (ML99_JUST(55))
#define ML99_PRIV_DIV_110_5  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_110_10 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_110_11 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_110_22 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_110_55 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_111_3  ~, (ML99_JUST(37))
#define ML99_PRIV_DIV_111_37 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_112_2  ~, (ML99_JUST(56))
#define ML99_PRIV_DIV_112_4  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_112_7  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_112_8  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_112_14 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_112_16 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_112_28 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_112_56 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_114_2  ~, (ML99_JUST(57))
#define ML99_PRIV_DIV_114_3  ~, (ML99_JUST(38))
#define ML99_PRIV_DIV_114_6  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_114_19 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_114_38 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_114_57 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_115_5  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_115_23 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_116_2  ~, (ML99_JUST(58))
#define ML99_PRIV_DIV_116_4  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_116_29 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_116_58 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_117_3  ~, (ML99_JUST(39))
#define ML99_PRIV_DIV_117_9  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_117_13 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_117_39 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_118_2  ~, (ML99_JUST(59))
#define ML99_PRIV_DIV_118_59 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_119_7  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_119_17 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_120_2  ~, (ML99_JUST(60))
#define ML99_PRIV_DIV_120_3  ~, (ML99_JUST(40))
#define ML99_PRIV_DIV_120_4  ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_120_5  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_120_6  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_120_8  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_120_10 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_120_12 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_120_15 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_120_20 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_120_24 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_120_30 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_120_40 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_120_60 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_121_11 ~, (ML99_JUST(11))

#define ML99_PRIV_DIV_122_2  ~, (ML99_JUST(61))
#define ML99_PRIV_DIV_122_61 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_123_3  ~, (ML99_JUST(41))
#define ML99_PRIV_DIV_123_41 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_124_2  ~, (ML99_JUST(62))
#define ML99_PRIV_DIV_124_4  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_124_31 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_124_62 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_125_5  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_125_25 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_126_2  ~, (ML99_JUST(63))
#define ML99_PRIV_DIV_126_3  ~, (ML99_JUST(42))
#define ML99_PRIV_DIV_126_6  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_126_7  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_126_9  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_126_14 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_126_18 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_126_21 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_126_42 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_126_63 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_128_2  ~, (ML99_JUST(64))
#define ML99_PRIV_DIV_128_4  ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_128_8  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_128_16 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_128_32 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_128_64 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_129_3  ~, (ML99_JUST(43))
#define ML99_PRIV_DIV_129_43 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_130_2  ~, (ML99_JUST(65))
#define ML99_PRIV_DIV_130_5  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_130_10 ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_130_13 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_130_26 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_130_65 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_132_2  ~, (ML99_JUST(66))
#define ML99_PRIV_DIV_132_3  ~, (ML99_JUST(44))
#define ML99_PRIV_DIV_132_4  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_132_6  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_132_11 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_132_12 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_132_22 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_132_33 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_132_44 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_132_66 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_133_7  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_133_19 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_134_2  ~, (ML99_JUST(67))
#define ML99_PRIV_DIV_134_67 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_135_3  ~, (ML99_JUST(45))
#define ML99_PRIV_DIV_135_5  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_135_9  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_135_15 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_135_27 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_135_45 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_136_2  ~, (ML99_JUST(68))
#define ML99_PRIV_DIV_136_4  ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_136_8  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_136_17 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_136_34 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_136_68 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_138_2  ~, (ML99_JUST(69))
#define ML99_PRIV_DIV_138_3  ~, (ML99_JUST(46))
#define ML99_PRIV_DIV_138_6  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_138_23 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_138_46 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_138_69 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_140_2  ~, (ML99_JUST(70))
#define ML99_PRIV_DIV_140_4  ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_140_5  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_140_7  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_140_10 ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_140_14 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_140_20 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_140_28 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_140_35 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_140_70 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_141_3  ~, (ML99_JUST(47))
#define ML99_PRIV_DIV_141_47 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_142_2  ~, (ML99_JUST(71))
#define ML99_PRIV_DIV_142_71 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_143_11 ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_143_13 ~, (ML99_JUST(11))

#define ML99_PRIV_DIV_144_2  ~, (ML99_JUST(72))
#define ML99_PRIV_DIV_144_3  ~, (ML99_JUST(48))
#define ML99_PRIV_DIV_144_4  ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_144_6  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_144_8  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_144_9  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_144_12 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_144_16 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_144_18 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_144_24 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_144_36 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_144_48 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_144_72 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_145_5  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_145_29 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_146_2  ~, (ML99_JUST(73))
#define ML99_PRIV_DIV_146_73 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_147_3  ~, (ML99_JUST(49))
#define ML99_PRIV_DIV_147_7  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_147_21 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_147_49 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_148_2  ~, (ML99_JUST(74))
#define ML99_PRIV_DIV_148_4  ~, (ML99_JUST(37))
#define ML99_PRIV_DIV_148_37 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_148_74 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_150_2  ~, (ML99_JUST(75))
#define ML99_PRIV_DIV_150_3  ~, (ML99_JUST(50))
#define ML99_PRIV_DIV_150_5  ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_150_6  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_150_10 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_150_15 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_150_25 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_150_30 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_150_50 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_150_75 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_152_2  ~, (ML99_JUST(76))
#define ML99_PRIV_DIV_152_4  ~, (ML99_JUST(38))
#define ML99_PRIV_DIV_152_8  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_152_19 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_152_38 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_152_76 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_153_3  ~, (ML99_JUST(51))
#define ML99_PRIV_DIV_153_9  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_153_17 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_153_51 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_154_2  ~, (ML99_JUST(77))
#define ML99_PRIV_DIV_154_7  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_154_11 ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_154_14 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_154_22 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_154_77 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_155_5  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_155_31 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_156_2  ~, (ML99_JUST(78))
#define ML99_PRIV_DIV_156_3  ~, (ML99_JUST(52))
#define ML99_PRIV_DIV_156_4  ~, (ML99_JUST(39))
#define ML99_PRIV_DIV_156_6  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_156_12 ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_156_13 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_156_26 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_156_39 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_156_52 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_156_78 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_158_2  ~, (ML99_JUST(79))
#define ML99_PRIV_DIV_158_79 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_159_3  ~, (ML99_JUST(53))
#define ML99_PRIV_DIV_159_53 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_160_2  ~, (ML99_JUST(80))
#define ML99_PRIV_DIV_160_4  ~, (ML99_JUST(40))
#define ML99_PRIV_DIV_160_5  ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_160_8  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_160_10 ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_160_16 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_160_20 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_160_32 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_160_40 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_160_80 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_161_7  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_161_23 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_162_2  ~, (ML99_JUST(81))
#define ML99_PRIV_DIV_162_3  ~, (ML99_JUST(54))
#define ML99_PRIV_DIV_162_6  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_162_9  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_162_18 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_162_27 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_162_54 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_162_81 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_164_2  ~, (ML99_JUST(82))
#define ML99_PRIV_DIV_164_4  ~, (ML99_JUST(41))
#define ML99_PRIV_DIV_164_41 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_164_82 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_165_3  ~, (ML99_JUST(55))
#define ML99_PRIV_DIV_165_5  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_165_11 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_165_15 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_165_33 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_165_55 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_166_2  ~, (ML99_JUST(83))
#define ML99_PRIV_DIV_166_83 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_168_2  ~, (ML99_JUST(84))
#define ML99_PRIV_DIV_168_3  ~, (ML99_JUST(56))
#define ML99_PRIV_DIV_168_4  ~, (ML99_JUST(42))
#define ML99_PRIV_DIV_168_6  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_168_7  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_168_8  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_168_12 ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_168_14 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_168_21 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_168_24 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_168_28 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_168_42 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_168_56 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_168_84 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_169_13 ~, (ML99_JUST(13))

#define ML99_PRIV_DIV_170_2  ~, (ML99_JUST(85))
#define ML99_PRIV_DIV_170_5  ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_170_10 ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_170_17 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_170_34 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_170_85 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_171_3  ~, (ML99_JUST(57))
#define ML99_PRIV_DIV_171_9  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_171_19 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_171_57 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_172_2  ~, (ML99_JUST(86))
#define ML99_PRIV_DIV_172_4  ~, (ML99_JUST(43))
#define ML99_PRIV_DIV_172_43 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_172_86 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_174_2  ~, (ML99_JUST(87))
#define ML99_PRIV_DIV_174_3  ~, (ML99_JUST(58))
#define ML99_PRIV_DIV_174_6  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_174_29 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_174_58 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_174_87 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_175_5  ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_175_7  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_175_25 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_175_35 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_176_2  ~, (ML99_JUST(88))
#define ML99_PRIV_DIV_176_4  ~, (ML99_JUST(44))
#define ML99_PRIV_DIV_176_8  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_176_11 ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_176_16 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_176_22 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_176_44 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_176_88 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_177_3  ~, (ML99_JUST(59))
#define ML99_PRIV_DIV_177_59 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_178_2  ~, (ML99_JUST(89))
#define ML99_PRIV_DIV_178_89 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_180_2  ~, (ML99_JUST(90))
#define ML99_PRIV_DIV_180_3  ~, (ML99_JUST(60))
#define ML99_PRIV_DIV_180_4  ~, (ML99_JUST(45))
#define ML99_PRIV_DIV_180_5  ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_180_6  ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_180_9  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_180_10 ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_180_12 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_180_15 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_180_18 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_180_20 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_180_30 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_180_36 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_180_45 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_180_60 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_180_90 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_182_2  ~, (ML99_JUST(91))
#define ML99_PRIV_DIV_182_7  ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_182_13 ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_182_14 ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_182_26 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_182_91 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_183_3  ~, (ML99_JUST(61))
#define ML99_PRIV_DIV_183_61 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_184_2  ~, (ML99_JUST(92))
#define ML99_PRIV_DIV_184_4  ~, (ML99_JUST(46))
#define ML99_PRIV_DIV_184_8  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_184_23 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_184_46 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_184_92 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_185_5  ~, (ML99_JUST(37))
#define ML99_PRIV_DIV_185_37 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_186_2  ~, (ML99_JUST(93))
#define ML99_PRIV_DIV_186_3  ~, (ML99_JUST(62))
#define ML99_PRIV_DIV_186_6  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_186_31 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_186_62 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_186_93 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_187_11 ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_187_17 ~, (ML99_JUST(11))

#define ML99_PRIV_DIV_188_2  ~, (ML99_JUST(94))
#define ML99_PRIV_DIV_188_4  ~, (ML99_JUST(47))
#define ML99_PRIV_DIV_188_47 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_188_94 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_189_3  ~, (ML99_JUST(63))
#define ML99_PRIV_DIV_189_7  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_189_9  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_189_21 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_189_27 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_189_63 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_190_2  ~, (ML99_JUST(95))
#define ML99_PRIV_DIV_190_5  ~, (ML99_JUST(38))
#define ML99_PRIV_DIV_190_10 ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_190_19 ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_190_38 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_190_95 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_192_2  ~, (ML99_JUST(96))
#define ML99_PRIV_DIV_192_3  ~, (ML99_JUST(64))
#define ML99_PRIV_DIV_192_4  ~, (ML99_JUST(48))
#define ML99_PRIV_DIV_192_6  ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_192_8  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_192_12 ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_192_16 ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_192_24 ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_192_32 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_192_48 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_192_64 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_192_96 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_194_2  ~, (ML99_JUST(97))
#define ML99_PRIV_DIV_194_97 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_195_3  ~, (ML99_JUST(65))
#define ML99_PRIV_DIV_195_5  ~, (ML99_JUST(39))
#define ML99_PRIV_DIV_195_13 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_195_15 ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_195_39 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_195_65 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_196_2  ~, (ML99_JUST(98))
#define ML99_PRIV_DIV_196_4  ~, (ML99_JUST(49))
#define ML99_PRIV_DIV_196_7  ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_196_14 ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_196_28 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_196_49 ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_196_98 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_198_2  ~, (ML99_JUST(99))
#define ML99_PRIV_DIV_198_3  ~, (ML99_JUST(66))
#define ML99_PRIV_DIV_198_6  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_198_9  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_198_11 ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_198_18 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_198_22 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_198_33 ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_198_66 ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_198_99 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_200_2   ~, (ML99_JUST(100))
#define ML99_PRIV_DIV_200_4   ~, (ML99_JUST(50))
#define ML99_PRIV_DIV_200_5   ~, (ML99_JUST(40))
#define ML99_PRIV_DIV_200_8   ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_200_10  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_200_20  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_200_25  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_200_40  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_200_50  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_200_100 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_201_3  ~, (ML99_JUST(67))
#define ML99_PRIV_DIV_201_67 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_202_2   ~, (ML99_JUST(101))
#define ML99_PRIV_DIV_202_101 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_203_7  ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_203_29 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_204_2   ~, (ML99_JUST(102))
#define ML99_PRIV_DIV_204_3   ~, (ML99_JUST(68))
#define ML99_PRIV_DIV_204_4   ~, (ML99_JUST(51))
#define ML99_PRIV_DIV_204_6   ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_204_12  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_204_17  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_204_34  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_204_51  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_204_68  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_204_102 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_205_5  ~, (ML99_JUST(41))
#define ML99_PRIV_DIV_205_41 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_206_2   ~, (ML99_JUST(103))
#define ML99_PRIV_DIV_206_103 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_207_3  ~, (ML99_JUST(69))
#define ML99_PRIV_DIV_207_9  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_207_23 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_207_69 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_208_2   ~, (ML99_JUST(104))
#define ML99_PRIV_DIV_208_4   ~, (ML99_JUST(52))
#define ML99_PRIV_DIV_208_8   ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_208_13  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_208_16  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_208_26  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_208_52  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_208_104 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_209_11 ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_209_19 ~, (ML99_JUST(11))

#define ML99_PRIV_DIV_210_2   ~, (ML99_JUST(105))
#define ML99_PRIV_DIV_210_3   ~, (ML99_JUST(70))
#define ML99_PRIV_DIV_210_5   ~, (ML99_JUST(42))
#define ML99_PRIV_DIV_210_6   ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_210_7   ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_210_10  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_210_14  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_210_15  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_210_21  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_210_30  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_210_35  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_210_42  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_210_70  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_210_105 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_212_2   ~, (ML99_JUST(106))
#define ML99_PRIV_DIV_212_4   ~, (ML99_JUST(53))
#define ML99_PRIV_DIV_212_53  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_212_106 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_213_3  ~, (ML99_JUST(71))
#define ML99_PRIV_DIV_213_71 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_214_2   ~, (ML99_JUST(107))
#define ML99_PRIV_DIV_214_107 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_215_5  ~, (ML99_JUST(43))
#define ML99_PRIV_DIV_215_43 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_216_2   ~, (ML99_JUST(108))
#define ML99_PRIV_DIV_216_3   ~, (ML99_JUST(72))
#define ML99_PRIV_DIV_216_4   ~, (ML99_JUST(54))
#define ML99_PRIV_DIV_216_6   ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_216_8   ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_216_9   ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_216_12  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_216_18  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_216_24  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_216_27  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_216_36  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_216_54  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_216_72  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_216_108 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_217_7  ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_217_31 ~, (ML99_JUST(7))

#define ML99_PRIV_DIV_218_2   ~, (ML99_JUST(109))
#define ML99_PRIV_DIV_218_109 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_219_3  ~, (ML99_JUST(73))
#define ML99_PRIV_DIV_219_73 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_220_2   ~, (ML99_JUST(110))
#define ML99_PRIV_DIV_220_4   ~, (ML99_JUST(55))
#define ML99_PRIV_DIV_220_5   ~, (ML99_JUST(44))
#define ML99_PRIV_DIV_220_10  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_220_11  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_220_20  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_220_22  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_220_44  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_220_55  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_220_110 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_221_13 ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_221_17 ~, (ML99_JUST(13))

#define ML99_PRIV_DIV_222_2   ~, (ML99_JUST(111))
#define ML99_PRIV_DIV_222_3   ~, (ML99_JUST(74))
#define ML99_PRIV_DIV_222_6   ~, (ML99_JUST(37))
#define ML99_PRIV_DIV_222_37  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_222_74  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_222_111 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_224_2   ~, (ML99_JUST(112))
#define ML99_PRIV_DIV_224_4   ~, (ML99_JUST(56))
#define ML99_PRIV_DIV_224_7   ~, (ML99_JUST(32))
#define ML99_PRIV_DIV_224_8   ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_224_14  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_224_16  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_224_28  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_224_32  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_224_56  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_224_112 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_225_3  ~, (ML99_JUST(75))
#define ML99_PRIV_DIV_225_5  ~, (ML99_JUST(45))
#define ML99_PRIV_DIV_225_9  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_225_15 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_225_25 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_225_45 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_225_75 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_226_2   ~, (ML99_JUST(113))
#define ML99_PRIV_DIV_226_113 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_228_2   ~, (ML99_JUST(114))
#define ML99_PRIV_DIV_228_3   ~, (ML99_JUST(76))
#define ML99_PRIV_DIV_228_4   ~, (ML99_JUST(57))
#define ML99_PRIV_DIV_228_6   ~, (ML99_JUST(38))
#define ML99_PRIV_DIV_228_12  ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_228_19  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_228_38  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_228_57  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_228_76  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_228_114 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_230_2   ~, (ML99_JUST(115))
#define ML99_PRIV_DIV_230_5   ~, (ML99_JUST(46))
#define ML99_PRIV_DIV_230_10  ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_230_23  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_230_46  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_230_115 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_231_3  ~, (ML99_JUST(77))
#define ML99_PRIV_DIV_231_7  ~, (ML99_JUST(33))
#define ML99_PRIV_DIV_231_11 ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_231_21 ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_231_33 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_231_77 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_232_2   ~, (ML99_JUST(116))
#define ML99_PRIV_DIV_232_4   ~, (ML99_JUST(58))
#define ML99_PRIV_DIV_232_8   ~, (ML99_JUST(29))
#define ML99_PRIV_DIV_232_29  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_232_58  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_232_116 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_234_2   ~, (ML99_JUST(117))
#define ML99_PRIV_DIV_234_3   ~, (ML99_JUST(78))
#define ML99_PRIV_DIV_234_6   ~, (ML99_JUST(39))
#define ML99_PRIV_DIV_234_9   ~, (ML99_JUST(26))
#define ML99_PRIV_DIV_234_13  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_234_18  ~, (ML99_JUST(13))
#define ML99_PRIV_DIV_234_26  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_234_39  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_234_78  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_234_117 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_235_5  ~, (ML99_JUST(47))
#define ML99_PRIV_DIV_235_47 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_236_2   ~, (ML99_JUST(118))
#define ML99_PRIV_DIV_236_4   ~, (ML99_JUST(59))
#define ML99_PRIV_DIV_236_59  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_236_118 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_237_3  ~, (ML99_JUST(79))
#define ML99_PRIV_DIV_237_79 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_238_2   ~, (ML99_JUST(119))
#define ML99_PRIV_DIV_238_7   ~, (ML99_JUST(34))
#define ML99_PRIV_DIV_238_14  ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_238_17  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_238_34  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_238_119 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_240_2   ~, (ML99_JUST(120))
#define ML99_PRIV_DIV_240_3   ~, (ML99_JUST(80))
#define ML99_PRIV_DIV_240_4   ~, (ML99_JUST(60))
#define ML99_PRIV_DIV_240_5   ~, (ML99_JUST(48))
#define ML99_PRIV_DIV_240_6   ~, (ML99_JUST(40))
#define ML99_PRIV_DIV_240_8   ~, (ML99_JUST(30))
#define ML99_PRIV_DIV_240_10  ~, (ML99_JUST(24))
#define ML99_PRIV_DIV_240_12  ~, (ML99_JUST(20))
#define ML99_PRIV_DIV_240_15  ~, (ML99_JUST(16))
#define ML99_PRIV_DIV_240_16  ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_240_20  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_240_24  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_240_30  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_240_40  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_240_48  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_240_60  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_240_80  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_240_120 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_242_2   ~, (ML99_JUST(121))
#define ML99_PRIV_DIV_242_11  ~, (ML99_JUST(22))
#define ML99_PRIV_DIV_242_22  ~, (ML99_JUST(11))
#define ML99_PRIV_DIV_242_121 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_243_3  ~, (ML99_JUST(81))
#define ML99_PRIV_DIV_243_9  ~, (ML99_JUST(27))
#define ML99_PRIV_DIV_243_27 ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_243_81 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_244_2   ~, (ML99_JUST(122))
#define ML99_PRIV_DIV_244_4   ~, (ML99_JUST(61))
#define ML99_PRIV_DIV_244_61  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_244_122 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_245_5  ~, (ML99_JUST(49))
#define ML99_PRIV_DIV_245_7  ~, (ML99_JUST(35))
#define ML99_PRIV_DIV_245_35 ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_245_49 ~, (ML99_JUST(5))

#define ML99_PRIV_DIV_246_2   ~, (ML99_JUST(123))
#define ML99_PRIV_DIV_246_3   ~, (ML99_JUST(82))
#define ML99_PRIV_DIV_246_6   ~, (ML99_JUST(41))
#define ML99_PRIV_DIV_246_41  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_246_82  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_246_123 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_247_13 ~, (ML99_JUST(19))
#define ML99_PRIV_DIV_247_19 ~, (ML99_JUST(13))

#define ML99_PRIV_DIV_248_2   ~, (ML99_JUST(124))
#define ML99_PRIV_DIV_248_4   ~, (ML99_JUST(62))
#define ML99_PRIV_DIV_248_8   ~, (ML99_JUST(31))
#define ML99_PRIV_DIV_248_31  ~, (ML99_JUST(8))
#define ML99_PRIV_DIV_248_62  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_248_124 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_249_3  ~, (ML99_JUST(83))
#define ML99_PRIV_DIV_249_83 ~, (ML99_JUST(3))

#define ML99_PRIV_DIV_250_2   ~, (ML99_JUST(125))
#define ML99_PRIV_DIV_250_5   ~, (ML99_JUST(50))
#define ML99_PRIV_DIV_250_10  ~, (ML99_JUST(25))
#define ML99_PRIV_DIV_250_25  ~, (ML99_JUST(10))
#define ML99_PRIV_DIV_250_50  ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_250_125 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_252_2   ~, (ML99_JUST(126))
#define ML99_PRIV_DIV_252_3   ~, (ML99_JUST(84))
#define ML99_PRIV_DIV_252_4   ~, (ML99_JUST(63))
#define ML99_PRIV_DIV_252_6   ~, (ML99_JUST(42))
#define ML99_PRIV_DIV_252_7   ~, (ML99_JUST(36))
#define ML99_PRIV_DIV_252_9   ~, (ML99_JUST(28))
#define ML99_PRIV_DIV_252_12  ~, (ML99_JUST(21))
#define ML99_PRIV_DIV_252_14  ~, (ML99_JUST(18))
#define ML99_PRIV_DIV_252_18  ~, (ML99_JUST(14))
#define ML99_PRIV_DIV_252_21  ~, (ML99_JUST(12))
#define ML99_PRIV_DIV_252_28  ~, (ML99_JUST(9))
#define ML99_PRIV_DIV_252_36  ~, (ML99_JUST(7))
#define ML99_PRIV_DIV_252_42  ~, (ML99_JUST(6))
#define ML99_PRIV_DIV_252_63  ~, (ML99_JUST(4))
#define ML99_PRIV_DIV_252_84  ~, (ML99_JUST(3))
#define ML99_PRIV_DIV_252_126 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_253_11 ~, (ML99_JUST(23))
#define ML99_PRIV_DIV_253_23 ~, (ML99_JUST(11))

#define ML99_PRIV_DIV_254_2   ~, (ML99_JUST(127))
#define ML99_PRIV_DIV_254_127 ~, (ML99_JUST(2))

#define ML99_PRIV_DIV_255_3  ~, (ML99_JUST(85))
#define ML99_PRIV_DIV_255_5  ~, (ML99_JUST(51))
#define ML99_PRIV_DIV_255_15 ~, (ML99_JUST(17))
#define ML99_PRIV_DIV_255_17 ~, (ML99_JUST(15))
#define ML99_PRIV_DIV_255_51 ~, (ML99_JUST(5))
#define ML99_PRIV_DIV_255_85 ~, (ML99_JUST(3))

#endif // ML99_NAT_DIV_H
