/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.progress;

/**
 * <p>Die Klasse <code>ProgressListener</code> stellt eine Schnittstelle zur
 * Verfügung um Fortschrittsereignisse (<code>ProgressEvent</code>) zu
 * empfangen.</p>
 *
 * <p>Eine Klasse, die an Fortschrittsereignissen interessiert ist,
 * implementiert diese Schnittstelle. Eine Instanz dieser Klasse wird dann bei
 * einem Objekt mit Fortschrittsbearbeitung registiert. Wenn ein
 * Fortschrittsereignis erzeugt wird, wird dann die Methode
 * <code>progress</code> der <code>ProgressListener</code> Instanz aufgerufen.</p>
 */
public interface ProgressVetoListener extends ProgressListener {

    /**
     * Vor einem Verarbeitungsschritt kann der Sender nachfragen, ob der
     * Empfänger ein Veto für diesen Schritt einlegen will und eventuell die
     * Verarbeitung für diesen Schritt übergehen.
     *
     * <p>Sollen zum Beispiel Dateien in ein Zielverzeichnis kopiert werden,
     * kann der Sender für jede Datei nachfragen, ob der Kopiervorgang
     * ausgeführt werden soll. Der Empfänger kann dann prüfen, ob die Datei im
     * Zielverzeichnis bereits existiert und gegebenfalls den Benutzer fragen,
     * ob die Datei überschrieben werden darf. Falls der Benutzer dies für diese
     * und vielleicht auch alle weiteren Dateien verneint, wird ein Veto
     * eingelegt.
     */
    public boolean veto(ProgressEvent event);

    /**
     * Mit Hilfe der Methode <code>isCanceled</code> kann der ProgressListener
     * dem Aufrufer signalisieren, dass der Benutzer die Verarbeitung abbrechen
     * will, z.B. durch betätigen einer Schaltfläche "Abbrechen" einer
     * Fortschrittsanzeige.
     */
    public boolean isCanceled();

}
