/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "octreeDataPoint.H"

#include <OpenFOAM/labelList.H>
#include "treeBoundBox.H"
#include "octree.H"
#include <OpenFOAM/linePointRef.H>
#include <OpenFOAM/pointHit.H>

// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

// Construct from components
Foam::octreeDataPoint::octreeDataPoint(const pointField& points)
:
    points_(points)
{}


// * * * * * * * * * * * * * * * Member Functions  * * * * * * * * * * * * * //

//- Get type of volume
Foam::label Foam::octreeDataPoint::getSampleType
(
    const octree<octreeDataPoint>&,
    const point&
) const
{
    return octree<octreeDataPoint>::UNKNOWN;
}


bool Foam::octreeDataPoint::overlaps
(
    const label index,
    const treeBoundBox& sampleBb
) const
{
    return sampleBb.contains(points_[index]);
}


bool Foam::octreeDataPoint::contains
(
    const label,
    const point&
) const
{
    notImplemented
    (
        "octreeDataPoint::contains(const label, const point&)"
    );

    return false;
}


bool Foam::octreeDataPoint::intersects
(
    const label,
    const point&,
    const point&,
    point&
) const
{
    notImplemented
    (
        "octreeDataPoint::intersects(const label, const point&,"
        "const point&, point&)"
    );

    return false;
}


bool Foam::octreeDataPoint::findTightest
(
    const label,
    const point&,
    treeBoundBox&
) const
{
    notImplemented
    (
        "octreeDataPoint::findTightest(const label, const point&,"
        "treeBoundBox&)"
    );

    return false;
}


Foam::scalar Foam::octreeDataPoint::calcSign
(
    const label,
    const point&,
    vector& n
) const
{
    n = vector::zero;

    return 1;
}


// Calculate nearest point on/in shapei
inline Foam::scalar Foam::octreeDataPoint::calcNearest
(
    const label index,
    const point& sample,
    point& nearest
) const
{
    nearest = points_[index];
    return magSqr(points_[index] - sample);
}


void Foam::octreeDataPoint::write
(
    Ostream& os,
    const label index
) const
{
    if ((index < 0) || (index > points().size()))
    {
        FatalErrorIn("octreeDataPoint::write(Ostream&, const label)")
            << "Index " << index << " outside 0.." << points().size()
            << abort(FatalError);
    }
    os << ' ' << points()[index];
}


// Calculate nearest point on/in shapei
Foam::scalar Foam::octreeDataPoint::calcNearest
(
    const label index,
    const linePointRef& ln,
    point& linePt,
    point& shapePt
) const
{
    // Nearest point on shape
    shapePt = points_[index];

    // Nearest point on line
    pointHit pHit = ln.nearestDist(shapePt);

    linePt = pHit.rawPoint();

    return pHit.distance();
}


// * * * * * * * * * * * * * * * Friend Operators  * * * * * * * * * * * * * //

Foam::Ostream& Foam::operator<<
(
    Foam::Ostream& os,
    const Foam::octreeDataPoint& ocPts
)
{
    return os << ocPts.points();
}


// ************************ vim: set sw=4 sts=4 et: ************************ //
