/*
 * $Id: arch_gen_cpu_x86_sim_fast.h,v 1.4 2009-01-23 10:34:54 potyra Exp $
 *
 * Derived from QEMU sources.
 * Modified for FAUmachine by Volkmar Sieh.
 *  
 *  Copyright (c) 2005-2009 FAUmachine Team.
 *  Copyright (c) 2003 Fabrice Bellard.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
 * USA
 */

#ifndef FAST
#error "Don't include in non-fast modules."
#endif

#ifndef __CPU_SIM_FAST_H_INCLUDED
#define __CPU_SIM_FAST_H_INCLUDED

#include "assert.h"
#include "stdio.h"

#include "arch_gen_cpu_x86_core.h"
#include "arch_gen_cpu_x86_core_fast.h"
#include "arch_gen_cpu_x86_mmu_fast.h"


/*
 * Types
 */
typedef struct CCTable {
	int (*compute_all)(void); /* return all the flags */
	int (*compute_c)(void);  /* return the C flag */
} CCTable;

/*
 * Variables
 */
extern const CCTable NAME_(cc_table)[];


/*
 * Macros
 */
/* XXX: add a is_user flag to have proper security support */
#define PUSHW(ssp, sp, sp_mask, val)\
{\
	sp -= 2;\
	stw_kernel((ssp) + (sp & (sp_mask)), (val));\
}

#define PUSHL(ssp, sp, sp_mask, val)\
{\
	sp -= 4;\
	stl_kernel((ssp) + (sp & (sp_mask)), (val));\
}

#define POPW(ssp, sp, sp_mask, val)\
{\
	val = lduw_kernel((ssp) + (sp & (sp_mask)));\
	sp += 2;\
}

#define POPL(ssp, sp, sp_mask, val)\
{\
	val = (uint32_t)ldl_kernel((ssp) + (sp & (sp_mask)));\
	sp += 4;\
}

#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT

#define PUSHQ(sp, val)\
{\
    sp -= 8;\
    stq_kernel(sp, (val));\
}

#define POPQ(sp, val)\
{\
    val = ldq_kernel(sp);\
    sp += 8;\
}

#endif /* CONFIG_CPU_LM_SUPPORT */

/*
 * Inline functions
 */
static inline unsigned int
get_sp_mask(unsigned int e2)
{
	if (e2 & DESC_B_MASK)
		return 0xffffffff;
	else
		return 0xffff;
}

static inline __attribute__((__always_inline__)) void
get_ss_esp_from_tss(uint32_t *ss_ptr, uint32_t *esp_ptr, int dpl)
{
	int type, index_, shift;

#if 0
	{
		int i;
		printf("TR: base=%p limit=%x\n", env->tr.base, env->tr.limit);
		for(i=0;i<env->tr.limit;i++) {
			printf("%02x ", env->tr.base[i]);
			if ((i & 7) == 7) printf("\n");
		}
		printf("\n");
	}
#endif

	assert(env->tr.flags & DESC_P_MASK);
	type = (env->tr.flags >> DESC_TYPE_SHIFT) & 0xf;
	assert((type & 7) == 1);
	shift = type >> 3;
	index_ = (dpl * 4 + 2) << shift;
	if (index_ + (4 << shift) - 1 > env->tr.limit)
		NAME_(raise_exception_err)(CPU_FAULT_TS, env->tr.selector & 0xfffc);
	if (shift == 0) {
		*esp_ptr = lduw_kernel(env->tr.base + index_);
		*ss_ptr = lduw_kernel(env->tr.base + index_ + 2);
	} else {
		*esp_ptr = ldl_kernel(env->tr.base + index_);
		*ss_ptr = lduw_kernel(env->tr.base + index_ + 4);
	}
}


/*
 * Global functions
 */
extern void NAME_(load_seg)(int seg_reg, int selector);
extern void NAME_(helper_ljmp_protected_T0_T1)(int next_eip_addend);
extern void NAME_(helper_lcall_real_T0_T1)(int shift, int next_eip);
extern void NAME_(helper_lcall_protected_T0_T1)(int shift, int next_eip_addend);
extern void NAME_(helper_iret_real)(int shift);
extern void NAME_(helper_iret_protected)(int shift, int next_eip);
extern void NAME_(helper_lret_protected)(int shift, int addend);
extern void NAME_(helper_lldt_T0)(void);
extern void NAME_(helper_ltr_T0)(void);
extern void NAME_(helper_movl_crN_T0)(int reg);
extern void NAME_(helper_movl_drN_T0)(int reg);
extern void NAME_(helper_invlpg)(target_ulong addr);
extern void NAME_(lock)(void);
extern void NAME_(unlock)(void);

extern void NAME_(switch_tss)(int tss_selector, uint32_t e1, uint32_t e2,
	int source, uint32_t next_eip);

extern void NAME_(helper_divl_EAX_T0)(void);
extern void NAME_(helper_idivl_EAX_T0)(void);
#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
extern void NAME_(helper_divq_EAX_T0)(void);
extern void NAME_(helper_idivq_EAX_T0)(void);
extern void NAME_(helper_mulq_EAX_T0)(void);
extern void NAME_(helper_imulq_EAX_T0)(void);
extern void NAME_(helper_imulq_T0_T1)(void);
extern void NAME_(helper_bswapq_T0)(void);
#endif /* CONFIG_CPU_LM_SUPPORT */
extern void NAME_(helper_cmpxchg8b)(void);
extern void NAME_(helper_cpuid)(void);
extern void NAME_(helper_enter_level)(int level, int data32);
#if CONFIG_CPU >= 80486 && CONFIG_CPU_LM_SUPPORT
extern void NAME_(helper_enter64_level)(int level, int data64);
#endif /* CONFIG_CPU_LM_SUPPORT */
extern void NAME_(helper_syscall)(int next_eip_addend);
extern void NAME_(helper_sysret)(int dflag);
extern void NAME_(helper_sysenter)(void);
extern void NAME_(helper_sysexit)(void);
extern void NAME_(helper_rdtsc)(void);
extern void NAME_(helper_rdmsr)(void);
extern void NAME_(helper_wrmsr)(void);
extern void NAME_(helper_lsl)(void);
extern void NAME_(helper_lar)(void);
extern void NAME_(helper_verr)(void);
extern void NAME_(helper_verw)(void);
extern void NAME_(helper_rsm)(void);

extern void NAME_(check_iob_T0)(void);
extern void NAME_(check_iow_T0)(void);
extern void NAME_(check_iol_T0)(void);
extern void NAME_(check_iob_DX)(void);
extern void NAME_(check_iow_DX)(void);
extern void NAME_(check_iol_DX)(void);

extern void
NAME_(leave_smm)(void);

#endif /* __CPU_SIM_FAST_H_INCLUDED */
