/* $Id: ConstArray.hpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * A constant array (with constant values), AST node.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __CONST_ARRAY_HPP_INCLUDED
#define __CONST_ARRAY_HPP_INCLUDED

#include "frontend/ast/ConstInteger.hpp"
#include <vector>
#include <cassert>

namespace ast {

//! a constant array with constant elements.
class ConstArray : public Expression {
public:
	//! c'tor
	/** @param elements array elements.
	 *  @param loc Location of the array.
	 */
	ConstArray(
		std::vector<ConstInteger *> *elems,
		Location loc
		) : 	Expression(BASE_TYPE_ARRAY, loc),
			elements(elems) {

		assert(elems != NULL);
	}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "ConstArray FIXME";
	}

	/** Interprete the ConstArray as a string, regardless of the actual
	 *  type it has. Should be used only, if the array is known to refer
	 *  to a textual type.
	 *  @return string representation of the array.
	 */
	std::string unsafeMakeString(void) const {
		assert(this->elements != NULL);
		std::string ret = std::string();

		for (std::vector<ConstInteger*>::const_iterator i = 
			this->elements->begin(); 
			i != this->elements->end(); i++) {

			char c = static_cast<char>((*i)->value);
			ret += c;
		}

		return ret;
	}

	std::vector<ConstInteger *> *elements;

protected:
	/** destructor */
	virtual ~ConstArray() {
		for (std::vector<ConstInteger*>::iterator i = 
			this->elements->begin();
			i != this->elements->end();
			i++) {

			util::MiscUtil::terminate(*i);
		}

		delete elements;
	}
};

}; /* namespace ast */

#endif /* __CONST_ARRAY_HPP_INCLUDED */
