/////////////////////////////////////////////////////////////
//                                                         //
// Copyright (c) 2003-2013 by The University of Queensland //
// Earth Systems Science Computational Centre (ESSCC)      //
// http://www.uq.edu.au/esscc                              //
//                                                         //
// Primary Business: Brisbane, Queensland, Australia       //
// Licensed under the Open Software License version 3.0    //
// http://www.opensource.org/licenses/osl-3.0.php          //
//                                                         //
/////////////////////////////////////////////////////////////

#include "FitPlane.h"

// --- project includes ---
#include "Geometry/PointCloud.h"

Plane3D fitPlaneToFracture(const vector<FracFrame::fdata>& fd)
{
  PointCloud PC;

  for(vector<FracFrame::fdata>::const_iterator iter=fd.begin();
      iter!=fd.end();
      iter++){
    PC.addPoint(iter->pos);
  }

  return PC.getFitPlane();
}
