<?php

#  Copyright (C) 2008-2011 Neil Williams <codehelp@debian.org>
#
#  This package is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 3 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program.  If not, see <http://www.gnu.org/licenses/>.

# A few notes:
# 1. There is one file / data source per suite - the reprepro logs.
# 2. Configuration is internal

##### config #####
$buildlog_path = "/srv/grip/grip/logs/";
$template_file = "/var/www/toolchains/emdebian.php";
$default_days = 7;
$supported_arches = array ("i386", "amd64", "arm", "armel",
 "powerpc", "mips", "mipsel" );
$components = array ("main", "dev", "doc", "debug");
#### end config ##

$SELF = "http://".$_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"];
$now = date("D, d M Y H:i:s T");
$num_days = $default_days;
if (($_GET['days'] != '')) {
	$num_days = htmlspecialchars ($_GET['days']);
	$num_days = preg_replace ('/\.+\/+/', "", $num_days);
}
$suite="sid-grip";
if (($_GET['suite'] != '')) {
	$suite = htmlspecialchars ($_GET['suite']);
	$suite = preg_replace ('/\.+\/+/', "", $suite);
}
$feed = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">
<html lang=\"en\">
<head>
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">
<title>Emdebian Grip - $suite</title>
  <link rev=\"made\" href=\"mailto:debian-embedded@lists.debian.org\">
  <link href=\"../debian.css\" rel=\"stylesheet\" type=\"text/css\">
  <link href=\"../debian-en.css\" rel=\"stylesheet\" type=\"text/css\" media=\"all\">
</head>
<body>
<div id=\"header\">
   <div id=\"upperheader\">
   <div id=\"logo\">
  <a href=\"../\" title=\"Emdebian Home\"><img src=\"../Pics/openlogo-50.png\" alt=\"Emdebian\" width=\"62\" height=\"47\"></a>
  </div> <!-- end logo -->
<!--UdmComment-->
<div id=\"navbar\">
<p class=\"hidecss\"><a href=\"#inner\"><skipquicknav></a></p>
<ul>
   <li><a href=\"../about\">About Emdebian</a></li>
   <li><a href=\"../News/\">News</a></li>
   <li><a href=\"../crosstools.html\">Toolchain</a></li>
   <li><a href=\"../emdebian/flavours.html\">Distributions</a></li>
   <li><a href=\"../tools.html\">Development</a></li>
   <li><a href=\"../docs.html\">Documentation</a></li>
   <li><a href=\"../support.html\">Support</a></li>
   <li><a href=\"../search.html\">Search</a></li>
</ul>
</div> <!-- end navbar -->
	 <p id=\"breadcrumbs\">$suite activity logs</p>
</div> <!-- end header -->
<!--/UdmComment-->
<div id=\"content\">
<h1 id=\"top\">Emdebian Grip repository - $suite activity logs</h1>\n";
$loglist = array ();
if (!is_dir ("$buildlog_path")) {
	$feed .= "<p>Cannot find $buildlog_path!</p>";
	echo $feed;
	exit;
}
$logfile = "$buildlog_path"."$suite"."-log";
$files = array ();
$cut_off = date ("U") - (60*60*24*$num_days);
$total = array ();

$feed .= "<hr><h2>Suite selection</h2>\n";
if ($suite == "sid-grip") {
	$feed .= "<p>[ <a href=\"$SELF?suite=jessie-grip\">Jessie Grip</a> ] ";
	$feed .= "[ <b>Sid Grip</b> ]</p>\n";
}
if ($suite == "jessie-grip") {
	$feed .= "<p>[ <b>Jessie Grip</b> ] ";
	$feed .= "[ <a href=\"$SELF?suite=sid-grip\">Sid-Grip</a> ]</p>\n";
}

$feed .= "<h2>Time Filter</h2>\n";
if ($num_days > 0) {
	$feed .= "<p>Only logs from the last $num_days days are shown.\n";
	$feed .="<a href=\"$SELF?days=0&amp;suite=$suite\">Show all logs</a>, or \n";
	if ($num_days == $default_days) {
		$feed .= "<a href=\"$SELF?days=28&amp;suite=$suite\">show logs for 28 days</a>.</p>\n";
	} else {
		$feed .= "<a href=\"$SELF?days=$default_days&amp;suite=$suite\">show logs for $default_days days</a>.</p>\n";
	}
} else {
	$feed .= "<p>Showing all logs. \n";
	$feed .= "<a href=\"$SELF?days=$default_days&amp;suite=$suite\">Show the last $default_days days</a>.</p>\n";
}

$contents = file ("$logfile");
rsort ($contents);
$arches = array();
$oldpkg = "";
$c = 0;
$output = array ();
$dates=array();
$l = 0;
$pubdate=0;
$addcss = "<span style=\"color:green;font-weight:700\">";
$replacecss = "<span style=\"color:navy;font-weight:700\">";
$removecss = "<span style=\"color:red;font-weight:700\">";
$check = 0;
foreach ($contents as $line) {
	$last_log=0;
	$matches = split (" ", $line);
	$time = $matches[1];
	$day = $matches[0];
	$thisdate = strtotime ("$day $time");
	if ($pubdate < $thisdate) {
		$pubdate = $thisdate;
	}
	$action = $matches[2];
	$cmpnt = $matches[5];
	$oldversion = rtrim($matches[9]);
	if ($action == "add") {
		$action = "${addcss}has been added</span> to <b>$cmpnt</b>";
	}
	if ($action == "remove") {
		$action = "${removecss}has been removed</span> from $suite (<b>$cmpnt</b>)";
	}
	if ($action == "replace") {
		$action = "${replacecss}replaces $oldversion</span> in <b>$cmpnt</b>";
	}
	$package = $matches[7];
	$newversion = rtrim($matches[8]);
	$arch = $matches[6];
	if (in_array($arch, $arches)) {
		$arches{"$arch"} = $arches{"$arch"} + 1;
	} else {
		$arches{"$arch"} = 1;
	}
	# catch the first package
	if ($c == 0) {
		$oldpkg = $package;
		$c++;
	}
	if ($oldpkg == $package) {
		$id = preg_replace ("/\++/", "", $package);
		$k = array_keys($arches);
		$a = $k[0];
		if ($a == "") {
			$a = "armel";
		}
		$url="http://www.emdebian.org/grip/search.php?arch=$a&distro=$suite&package=$package";
		$str = "<li><b><a href=\"$url\">$package</a></b> ($newversion)";
		$end = "$action.</li>";
		continue;
	}
	$list = join (", ", array_keys ($arches));
	if (count(array_keys ($arches)) > 0) {
		$list = "{<i>".$list."</i>}";
		$c = 0;
	}
	if ($str != "") {
		$str = "$str $list $end";
	}
	$arches = array();
	$oldpkg = $package;
	if ($last_log > $thisdate) { continue; }
	# add a 7 day cut-off
	$last_log = $thisdate;
	$total[$check] = $logfile;
	if (($num_days > 0) and ($cut_off > $thisdate))  { continue; }
	$dates["$day"][$l] = $str;
	$list = $str = $end = "";
	$l++;
	$check++;
}

krsort ($dates);
$feed .= "<p>";
foreach ($dates as $key => $line) {
	$feed .= "[&nbsp;<a href=\"#d$key\">$key</a>&nbsp;]\n";
}
$feed .= "</p>\n<hr>\n";

foreach ($dates as $key => $line) {
	preg_match ("/([0-9]{4})-([0-9]{2})-([0-9]{2})/", "$key", $match);
	$year = $match[1];
	$month = $match[2];
	$day = $match[3];
	$thisdate = mktime (0,0,0,$month,$day,$year);
	$datestr = date("D, d F Y.", $thisdate);
	$feed .= "<h2 id=\"d$key\">Updates in $suite for $datestr</h2>\n";
	$feed .= "<p><a href=\"#top\">Top</a></p>\n";
	asort ($line);
	$feed .= "<ol>";
	foreach ($line as $l => $str) {
		if ($str !== "") {
			$feed .= "$str\n";
		}
	}
	$feed .= "</ol>";
}
echo $feed;
?>
<!--/UdmComment-->
</div> <!-- end footermap -->
<hr noshade width="100%" size="1">
<div id="fineprint">
  <p>To report a problem with the web site, e-mail <a
  href="mailto:debian-embedded@lists.debian.org">debian-embedded@lists.debian.org</a>. For other contact information,
  see the Emdebian <a href="../about/contacts.html">contact page</a>.</p>
<p>
<?php
echo "Generated: ".date("r", $_SERVER['REQUEST_TIME']);
?>
  <br>
  Copyright &copy; 2000-2011
 The Embedded Debian Project;<br>
  Debian is a registered <a href="../trademark">trademark</a> of Software in the Public Interest, Inc.
</p>
</div>
</div> <!-- end footer -->
</body></html>
