/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.action;

import java.util.Vector;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSEncryptionPart;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.action.Action;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandler;
import org.apache.ws.security.message.WSSecSignature;
import org.apache.ws.security.message.WSSecUsernameToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class UsernameTokenSignedAction
implements Action {
    public void execute(WSHandler handler, int actionToDo, Document doc, RequestData reqData) throws WSSecurityException {
        String password = handler.getPassword(reqData.getUsername(), actionToDo, "passwordCallbackClass", "passwordCallbackRef", reqData).getPassword();
        WSSecUsernameToken builder = new WSSecUsernameToken();
        builder.setWsConfig(reqData.getWssConfig());
        builder.setPasswordType(reqData.getPwType());
        builder.setUserInfo(reqData.getUsername(), password);
        builder.addCreated();
        builder.addNonce();
        builder.prepare(doc);
        WSSecSignature sign = new WSSecSignature();
        sign.setWsConfig(reqData.getWssConfig());
        sign.setUsernameToken(builder);
        sign.setKeyIdentifierType(7);
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sign.prepare(doc, null, reqData.getSecHeader());
        sign.prependToHeader(reqData.getSecHeader());
        builder.prependToHeader(reqData.getSecHeader());
        Vector<WSEncryptionPart> parts = null;
        if (reqData.getSignatureParts().size() > 0) {
            parts = reqData.getSignatureParts();
        } else {
            SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
            parts = new Vector<WSEncryptionPart>();
            WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
            parts.add(encP);
        }
        sign.addReferencesToSign(parts, reqData.getSecHeader());
        try {
            sign.computeSignature();
            reqData.getSignatureValues().add(sign.getSignatureValue());
        }
        catch (WSSecurityException e) {
            throw new WSSecurityException("WSHandler: Error during UsernameTokenSignature", e);
        }
    }
}

