/*******************************************************************************
 * Copyright (c) 2009 Andrey Loskutov.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * Contributor:  Andrey Loskutov - initial API and implementation
 *******************************************************************************/
package de.loskutov.anyedit.jdt;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.workingsets.WorkingSetModel;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

import de.loskutov.anyedit.AnyEditToolsPlugin;
import de.loskutov.anyedit.ui.wizards.IWSAction;

/**
 * Thic class is a dirty way to activate imported working sets into the Package Explorer
 *
 * @author Andrey
 */
public class SelectWorkingSetsAction extends Action implements IWSAction {

    private IWorkingSet[] workingSets;

    public SelectWorkingSetsAction() {
        super();
    }

    @Override
    public void run() {
        if (workingSets == null || workingSets.length == 0) {
            return;
        }
        try {
            IViewPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow()
                    .getActivePage().showView(JavaUI.ID_PACKAGES);
            if (!(part instanceof PackageExplorerPart)) {
                return;
            }
            PackageExplorerPart viewPart = (PackageExplorerPart) part;
            int showWS = PackageExplorerPart.WORKING_SETS_AS_ROOTS;
            if (viewPart.getRootMode() != showWS) {
                viewPart.rootModeChanged(showWS);
            }
            WorkingSetModel workingSetModel = viewPart.getWorkingSetModel();
            IWorkingSet[] active = workingSetModel.getActiveWorkingSets();
            List<IWorkingSet> all = new ArrayList<IWorkingSet>();
            for (int i = 0; i < active.length; i++) {
                all.add(active[i]);
            }
            IWorkingSet[] existing = workingSetModel.getAllWorkingSets();
            for (int i = 0; i < workingSets.length; i++) {
                IWorkingSet set = workingSets[i];
                set = lookupName(existing, set);
                if (set != null && !all.contains(set)) {
                    all.add(set);
                }
            }
            if (all.size() > 0) {
                workingSetModel.setActiveWorkingSets(all
                        .toArray(new IWorkingSet[all.size()]));
                TreeViewer viewer = viewPart.getTreeViewer();
                viewer.getControl().setRedraw(false);
                viewer.refresh();
                viewer.getControl().setRedraw(true);
            }
        } catch (PartInitException e) {
            AnyEditToolsPlugin.logError(null, e);
        }
    }

    private IWorkingSet lookupName(IWorkingSet[] all, IWorkingSet set) {
        String name = set.getName();
        if (name == null) {
            return null;
        }
        for (int i = 0; i < all.length; i++) {
            if (name.equals(all[i].getName())) {
                return all[i];
            }
        }
        return null;
    }

    public void setWorkingSets(List<IWorkingSet> sets) {
        this.workingSets = sets.toArray(new IWorkingSet[sets.size()]);
    }
}
