@rem = '--*-Perl-*--
@echo off
if "%OS%" == "Windows_NT" goto WinNT
perl -x -S "%0" %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
:WinNT
perl -x -S %0 %*
if NOT "%COMSPEC%" == "%SystemRoot%\system32\cmd.exe" goto endofperl
if %errorlevel% == 9009 echo You do not have Perl in your PATH.
if errorlevel 1 goto script_failed_so_exit_with_non_zero_val 2>nul
goto endofperl
@rem ';
#!/usr/bin/perl -w
#line 15
#
# ecaccess: Display ECaccess Information
#
# Laurent.Gougeon@ecmwf.int - 2010-10-15

use ECMWF::ECaccess;
use Getopt::Long;
use Pod::Usage;

my %opt = ( version => 0 );

GetOptions(
	\%opt,
	qw(
	  version
	  )
);

# Display version if requested
die ECMWF::ECaccess->VERSION . "\n" if ( $opt{version} );

# Display documentation
pod2usage( -noperldoc => 1, -exit => 1, verbose => 2 );

__END__

=head1 NAME

ECaccess Tools (ECTools) - The ECaccess Tools gives Member States (in the following
"Member States" (MS) includes "Co-operating States") and other ECMWF users batch access
to the ECMWF computing and archiving facilities for the management of files, file
transfers and jobs. Access is available via the Internet as well as via RMDCN.

=head1 AUTHENTICATION

=head2 ECaccess Certificate

Using the ECaccess Tools requires a valid ECaccess Certificate.

The ECaccess Certificate is a standard X509 digital Certificate saved on the user's
computer as a file. It identifies a user to the ECaccess Gateway. The ECaccess Certification
Authority (ECCA) signs each Certificate. Therefore, when a user provides his Certificate
to the gateway, its signature is checked using the ECCA public key for verification.

The ECaccess certificate is by default valid for 7 days for all services.

The ECaccess Tools are also available at ECMWF. As you have already been validated to enter
ECMWF, you will not need a Certificate when using these ECaccess shell commands localy.

=head2 Creating a Certificate

The ECaccess Certificate must be stored in the "$HOME/.eccert.crt" file and can be created
with one of the following method (both methods requires an ECMWF user identifier and token
PASSCODE):

=head3 Using the "ecaccess-certificate-create" command:

Please refer to the man page of the command for more details.

=head3 Using the Web interface:

Login to the Web server and in the menu click the "Get Certificate" option to download the
new ECaccess Certificate.

=head1 ECACCESS FILE SYSTEM

When accessing FILEs at ECMWF through the ECtools, the following domains are available:

   HOME: the $HOME directory (home:)
   SCRATCH: the $SCRATCH directory (scratch:)
   ECFS: the ECFS directory (ec:)
   ECTMP: the ECTMP directory (ectmp:)
   HOST: any server at ECMWF ({host-name}:)

=head2 Path

The format of the path is the following: "[domain:][/user-id/]path"

If no user-id is specified then the current user-id is selected by default. The user-id
parameter is not valid with the HOST domain.

If no domain is specified then an absolute path will translate to an absolute path on the
ecgate server and a relative path will translate to a path in the HOME directory of the
current user.

=head2 Exemples

   "bin/a.out"                           a.out file in the $HOME/bin directory of the current user
   "home:bin/a.out"                      a.out file in the $HOME/bin directory of the current user
   "/tmp/a.out"                          a.out file in the /tmp directory on ecgate
   "home:/xyz/bin/a.out"                 a.out file in the $HOME/bin directory of user xyz
   "ec:bin/a.out"                        a.out file in the ECFS bin directory of the current user
   "ec:/xyz/bin/a.out"                   a.out file in the ECFS bin directory of user xyz
   "c1a:/c1a/tmp/systems/xyz/a.out"      a.out file in the /c1a/tmp/systems/xyz/ directory of c1a

=head2 Commands

In the DESCRIPTION section you will find the FILEs commands which can be used to manage the files at ECMWF. Whenever a parameter
or an option refer to an ECaccess File then the "[domain:][/user-id/]path" syntax apply.

=head1 ECTRANS

ECtrans refers to unattended file transfers initiated from ECMWF.

ECtrans allows transfering files between ECMWF and remote sites. Like the UNIX "rcp" command, ECtrans requires no password to be
specified on the command line for the remote host: the ECaccess gateway performs the security checking. Unlike standard FTP, ECtrans is
suitable for unattended file transfers in scripts, cron jobs, etc., as it avoids the problems inherent in storing passwords in text files
and sending passwords across networks.

Even if you don't have a local gateway installed, you can benefit from ECtrans by using the ECMWF ECaccess gateway. Please note that in
this case the transfer is not as secured as when a Member State ECaccess gateway is used.

=head2 Target location

Users who wish to transfer files between ECMWF and Member State servers need to declare one or more remote Member State users (msuser
association) for the storage/retrieval of the remote file. This can be done through the ECaccess Web interface of the target gateway.
For every "msuser" declaration, the hostname and the login username and password need to be specified.

After the ECaccess gateway installation, the Member State ECaccess system administrator can customise the access methods for file
transfers. These will be displayed through the ECaccess Web interface. Several schemes can be implemented, such as:

B<1> - The target directory for a particular destination is a sub-directory of a central directory configured by the administrator,
with the sub-directory name matching the msuser name.
B<2> - The target directory for all file transfers to a given destination is a sub-directory of the msusers home directory.
The administrator configures the sub-directory name.
B<3> - The target directory for a given destination is configurable by the user. The administrator determines whether or not the user
is allowed to include ".." in the directory path.

Target directories can be located on:

B<1> - Member State servers running a standard FTP service accessible from the ECaccess gateway. This is known as a "genericFtp"
destination and is the most convenient way of getting the files to the system you want, under the specified user ID.
B<2> - The server running the ECaccess gateway. This is known as a "genericFile" destination. All users will share in a common
directory the files transferred using this destination.
B<3> - Member State servers running a proprietary application. The administrator provides ectrans with the implementation of the
access protocol. The administrator can also use more complex rules to define special target locations for ECMWF users,
Member State users or groups of Member State users. The command "ectinfo" described in the next section can be used to get
the translated URL of a target location, giving a Member State user identifier and a destination name (passwords are
displayed as ***).

=head2 Commands

In the DESCRIPTION section you will find the ECtrans Association and Transfer Management commands which can be used to manage the
ECtrans Associations and associated Transfers.

=head1 EVENTS

ECMWF maintains some notifications (events) which are linked to ECMWF's operational activity and offers the service for time-critical
jobs. This service is also available to MS users who maintain their own notifications and can therefore create simple dependencies
between different activities, at ECMWF and remote sites.

=head2 Commands

In the DESCRIPTION section you will find the Events Management commands which can be used to manage such Events.

=head1 DESCRIPTION

The ECaccess Tools are organized under nine categories covering access to the whole
computing and archiving facilities of ECMWF. Each command is documented with its own
man page which provide explanation as well as examples on how to use it.

The following options are common to all the ECtools:

=over 8

=item B<-help>

Print a brief help message and exits.

=item B<-manual>

Prints the manual page and exits.

=item B<-retry> I<count>

Number of SSL connection retries per 5s to ECMWF. This parameter only apply to the
initial SSL connection initiated by the command to the ECMWF server. It does not
apply to all the subsequent requests made afteward as it is mainly targeting errors
that can happen from time to time during the SSL handshake. Default is no retry.

=item B<-debug>

Display the SOAP and SSL messages exchanged.

=back

=head2 Shell commands for certificate management (ecaccess-certificate-*)

   ecaccess-certificate-create	- Create Certificate for the ECtools
   ecaccess-certificate-list	- List Available Operations

=head2 Shell commands for file management (ecaccess-file-*)

   ecaccess-file-chmod 		- Change ECaccess File Mode Bits
   ecaccess-file-copy		- Copy an ECaccess File
   ecaccess-file-delete		- Remove an ECaccess File
   ecaccess-file-dir		- List ECaccess Directory Contents
   ecaccess-file-get		- Download an ECaccess File
   ecaccess-file-mdelete	- Delete Multiple ECaccess Files at once
   ecaccess-file-mget		- Download Multiple ECaccess Files at once
   ecaccess-file-mkdir		- Make a Directory on the ECaccess File System
   ecaccess-file-modtime	- Show the Last Modification Time of an ECaccess File
   ecaccess-file-move		- Move or Rename ECaccess Files
   ecaccess-file-mput		- Upload Multiple Local Files on the ECaccess File System at once
   ecaccess-file-put		- Upload a File on the ECaccess File System
   ecaccess-file-rmdir		- Remove a Directory on the ECaccess File System
   ecaccess-file-size		- Show the Size of an ECaccess File

=head2 Shell commands for batch job management (ecaccess-job/queue-*)

   ecaccess-job-delete		- Delete an ECaccess Job
   ecaccess-job-get		- Download a Job Output/Input/Error File
   ecaccess-job-list		- List all ECaccess Jobs
   ecaccess-job-restart		- Restart an ECaccess Job
   ecaccess-job-submit		- Submit a new ECaccess Job
   ecaccess-queue-list		- List available queues

=head2 Shell commands for management of events at ECMWF (ecaccess-event-*)

   ecaccess-event-list		- List available events
   ecaccess-event-send		- Trigger an ECaccess Event

=head2 Shell commands for management of ECtrans Associations (ecaccess-association-*)

   ecaccess-association-delete	- Delete Association
   ecaccess-association-get	- Get the Association Descriptive File
   ecaccess-association-list	- List your ECtrans associations
   ecaccess-association-protocol- List the supported ECtrans Protocol
   ecaccess-association-put	- Update/Create an Association

=head2 Shell commands for management of ECtrans Transfers (ecaccess-ectrans-*)

   ecaccess-ectrans-delete	- Delete ECtrans
   ecaccess-ectrans-list	- List all ectrans transfers
   ecaccess-ectrans-request	- Request a new ECtrans transfer
   ecaccess-ectrans-restart	- Restart an existing ECtrans transfer

=head2 Shell commands for getting ECaccess Gateways information (ecaccess-gateway-*)

   ecaccess-gateway-list	- List the ECaccess Gateways
   ecaccess-gateway-name	- Display the name of the default ECaccess Gateway
   ecaccess-gateway-connected	- Display the ECaccess Gateway Connection Status

=head2 Shell commands for general information at ECMWF

   ecaccess-cosinfo		- Display ConsInfo from ECMWF

=head1 SEE ALSO

B<ecaccess-association-delete>, B<ecaccess-association-get>, B<ecaccess-association-list>, B<ecaccess-association-protocol>,
B<ecaccess-association-put>, B<ecaccess-certificate-create>, B<ecaccess-certificate-list>, B<ecaccess-cosinfo>,
B<ecaccess-ectrans-delete>, B<ecaccess-ectrans-list>, B<ecaccess-ectrans-request>, B<ecaccess-ectrans-restart>,
B<ecaccess-event-list>, B<ecaccess-event-send>, B<ecaccess-file-chmod>, B<ecaccess-file-copy>, B<ecaccess-file-delete>,
B<ecaccess-file-dir>, B<ecaccess-file-get>, B<ecaccess-file-mdelete>, B<ecaccess-file-mget>, B<ecaccess-file-mkdir>,
B<ecaccess-file-modtime>, B<ecaccess-file-move>, B<ecaccess-file-mput>, B<ecaccess-file-put>, B<ecaccess-file-rmdir>,
B<ecaccess-file-size>, B<ecaccess-gateway-list>, B<ecaccess-gateway-name>, B<ecaccess-job-delete>, B<ecaccess-job-get>,
B<ecaccess-job-list>, B<ecaccess-job-restart>, B<ecaccess-job-submit> and B<ecaccess-queue-list>.

=cut

__END__
:endofperl
