﻿' Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com 

Imports System
Imports System.Collections.Generic
Imports System.IO
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Config
Imports Db4objects.Db4o.IO
Imports Db4objects.Db4o.Query

Namespace Db4odoc.Storage
    Class CachingStorageExample


        Private Const Db4oFileName As String = "reference.db4o"
        Private Const ObjectCount As Integer = 10000

        Private Const PageCount As Integer = 6
        Private Const PageSize As Integer = 1024


        Public Shared Sub Main(ByVal args As String())
            CreateDatabase(GetFileStorageConfig())
            QueryDatabase(GetFileStorageConfig())
            CreateDatabase(GetConfig())
            QueryDatabase(GetConfig())
            CreateDatabase(GetDefaultConfig())
            QueryDatabase(GetDefaultConfig())
        End Sub
        ' end main


        Private Shared Function GetConfig() As IEmbeddedConfiguration
            Dim config As IEmbeddedConfiguration = Db4oEmbedded.NewConfiguration()
            config.File.Storage = New CachingStorage(New FileStorage(), PageCount, PageSize)
            Return config
        End Function
        ' end GetConfig

        Private Shared Function GetFileStorageConfig() As IEmbeddedConfiguration
            Dim config As IEmbeddedConfiguration = Db4oEmbedded.NewConfiguration()
            config.File.Storage = New FileStorage()
            Return config
        End Function
        ' end GetFileStorageConfig

        Private Shared Function GetDefaultConfig() As IEmbeddedConfiguration
            Dim config As IEmbeddedConfiguration = Db4oEmbedded.NewConfiguration()
            Return config
        End Function
        ' end GetDefaultConfig


        Private Shared Sub CreateDatabase(ByVal config As IEmbeddedConfiguration)
            File.Delete(Db4oFileName)

            Dim startTime As Long = DateTime.Now.Ticks
            Dim container As IObjectContainer = Db4oEmbedded.OpenFile(config, Db4oFileName)
            Try
                Dim itemStore As New ItemStore()
                For i As Integer = 0 To ObjectCount - 1
                    itemStore.AddItem(New Item(i, "title" & i))
                Next
                container.Store(itemStore)
                Dim item As Item = DirectCast(container.QueryByExample(New Item(1, "title1"))(0), Item)
                System.Console.WriteLine(item)
            Finally
                container.Close()
            End Try
            System.Console.WriteLine([String].Format("Time to create a database: {0} ms", (DateTime.Now.Ticks - startTime) / TimeSpan.TicksPerMillisecond))
        End Sub
        ' end CreateDatabase



        Private Shared Sub QueryDatabase(ByVal config As IEmbeddedConfiguration)

            Dim container As IObjectContainer = Db4oEmbedded.OpenFile(config, Db4oFileName)
            Try
                Dim temp As New List(Of Item)()
                Dim startTime As Long = DateTime.Now.Ticks
                Dim q As IQuery = container.Query()
                q.Constrain(GetType(Item))
                q.Descend("id").Constrain(1).Greater()
                Dim result As IObjectSet = q.Execute()
                For Each i As Item In result
                    temp.Add(i)
                Next
                System.Console.WriteLine([String].Format("Time to get an objects first time: {0} ms", (DateTime.Now.Ticks - startTime) / TimeSpan.TicksPerMillisecond))
                '
                temp = New List(Of Item)()
                startTime = DateTime.Now.Ticks
                For Each i As Item In result
                    temp.Add(i)
                Next
                System.Console.WriteLine([String].Format("Time to get an objects second time: {0} ms", (DateTime.Now.Ticks - startTime) / TimeSpan.TicksPerMillisecond))
            Finally
                container.Close()
            End Try
        End Sub
        ' end QueryDatabase

        Private Class Item
            Private id As Integer
            Private name As [String]

            Public Sub New(ByVal id As Integer, ByVal name As [String])
                Me.id = id
                Me.name = name
            End Sub


            Public Overloads Overrides Function ToString() As String
                Return [String].Format("{0} [{1}]", name, id)
            End Function
        End Class
        ' end Item

        Private Class ItemStore
            Private items As List(Of Item)

            Public Sub New()
                Me.items = New List(Of Item)()
            End Sub

            Public Sub AddItem(ByVal item As Item)
                Me.items.Add(item)
            End Sub
        End Class
        ' end ItemStore

    End Class
End Namespace
