/* Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com */
package com.db4odoc.MemoryStorage;

import java.io.*;
import java.util.*;

import com.db4o.*;
import com.db4o.config.*;
import com.db4o.io.*;
import com.db4o.query.*;

public class CachingStorageExample {

	private final static String DB4O_FILE_NAME = "reference.db4o";
	private final static int OBJECT_COUNT = 10000;
	
	private static int PAGE_COUNT = 6;
	private static int PAGE_SIZE = 1024;
	

	public static void main(String[] args) throws IOException {
//		createDatabase(getFileStorageConfig());
//		queryDatabase(getFileStorageConfig());
		createDatabase(getConfig());
		queryDatabase(getConfig());
//		createDatabase(getDefaultConfig());
//		queryDatabase(getDefaultConfig());
	}
	// end main


	private static EmbeddedConfiguration getConfig() {
		EmbeddedConfiguration config = Db4oEmbedded.newConfiguration();
		config.file().storage(new CachingStorage(new FileStorage(), PAGE_COUNT, PAGE_SIZE));
		return config;
	}
	// end getConfig
	
	private static EmbeddedConfiguration getFileStorageConfig() {
		EmbeddedConfiguration config = Db4oEmbedded.newConfiguration();
		config.file().storage(new FileStorage());
		return config;
	}
	// end getFileStorageConfig
	
	private static EmbeddedConfiguration getDefaultConfig() {
		EmbeddedConfiguration config = Db4oEmbedded.newConfiguration();
		return config;
	}
	// end getDefaultConfig


	private static void createDatabase(EmbeddedConfiguration config) {
		new File(DB4O_FILE_NAME).delete();

		long startTime = System.currentTimeMillis();
		ObjectContainer container = Db4oEmbedded.openFile(config, DB4O_FILE_NAME);
		try {
			ItemStore itemStore = new ItemStore();
			for (int i = 0; i < OBJECT_COUNT; i++) {
				itemStore.addItem(new Item(i, "title" + i));
			}
			container.store(itemStore);
			Item item  = (Item) container.queryByExample(
					new Item(1, "title1")).get(0);
			System.out.println(item);
		} finally {
			container.close();
		}
		System.out.println(String.format("Time to create a database: %d ms",
				System.currentTimeMillis() - startTime));
	}
	// end createDatabase


//	private static void queryDatabase(EmbeddedConfiguration config) {
//
//		ObjectContainer container = Db4oEmbedded
//				.openFile(config, DB4O_FILE_NAME);
//		try {
//			long startTime = System.currentTimeMillis();
//			Item item = (Item) container.queryByExample(
//					new Item(9999, "title9999")).get(0);
//			System.out.println(item);
//			System.out.println(String.format("Time to get an object: %d ms",
//					System.currentTimeMillis() - startTime));
//		} finally {
//			container.close();
//		}
//	}
//	// end queryDatabase

	private static void queryDatabase(EmbeddedConfiguration config) {

		ObjectContainer container = Db4oEmbedded
				.openFile(config, DB4O_FILE_NAME);
		try {
			ArrayList<Item> temp = new ArrayList<Item>();
			long startTime = System.currentTimeMillis();
			Query q = container.query();
			q.constrain(Item.class);
			q.descend("id").constrain(1).greater();
			ObjectSet <Item> result = q.execute();
			for (Item i: result){
				temp.add(i);
			}
			System.out.println(String.format("Time to get an objects first time: %d ms",
					System.currentTimeMillis() - startTime));
			//
			temp = new ArrayList<Item>();
			startTime = System.currentTimeMillis();
			for (Item i: result){
				temp.add(i);
			}
			System.out.println(String.format("Time to get an objects second time: %d ms",
					System.currentTimeMillis() - startTime));
		} finally {
			container.close();
		}
	}
	// end queryDatabase

	private static class Item{
		int id;
		String name;
		
		public Item(int id, String name){
			this.id = id;
			this.name = name;
		}
		
		public String toString(){
			return String.format("%s {%d}", name, id);
		}
	}
	// end Item
	
	private static class ItemStore{
		ArrayList<Item> items;
		
		public ItemStore(){
			this.items = new ArrayList<Item>();
		}
		
		public void addItem(Item item){
			this.items.add(item);
		}
	}
	// end ItemStore
}
