#include "thread"
#include "sys/sys"

void *Thread::_run (void *data) {
    Thread *t = (Thread*) data;

    debugmsg(Mstr("Thread: starting run\n"));
    Threadlist::enregister();    
    try {
	t->execute();
    } catch (Error const &e) {
	lock(&cerr);
	cerr << e.what() << "\n";
	unlock(&cerr);
    }
    Threadlist::deregister();
    debugmsg(Mstr("Thread: ending run\n"));

    // Cleanups
    delete (t);

    // To satisfy the prototype
    return (0);
}

