/*
 * Author: Andrei Zavada <johnhommer@gmail.com>
 *         building on original work by Thomas Nowotny
 *
 * License: GPL-2+
 *
 * Initial version: 2008-09-23
 *
 * A Runge-Kutta 6-5 integrator
 */


#ifndef LIBCN_INTEGRATE_RK65_H
#define LIBCN_INTEGRATE_RK65_H

#include <vector>
#include "integrate-base.hh"

#include "config.h"

namespace CNRun {

class CIntegrateRK65
  : public CIntegrate_base {

    public:
	double	_dt_max_cap;

	CIntegrateRK65( double dt_min = 1e-6, double dt_max = .5, double dt_max_cap = 5,
			double eps = 1e-8,  double eps_abs = 1e-12, double eps_rel = 1e-6,
			bool inis_owned = true)
	      : CIntegrate_base (dt_min, dt_max, eps, eps_abs, eps_rel, is_owned),
		_dt_max_cap (dt_max_cap)
		{}

	void cycle() __attribute__ ((hot));
	void fixate() __attribute__ ((hot));
	void prepare();

    private:
	std::vector<double> Y[9], F[9], y5;
};


}

#endif

// EOF
