// Copyright 2013 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Created by postproc-cld2 4.0 on 2013-07-15 14:43:59
// From command line:
//  --cld2 --cc --just_read_raw --quad --standard --minchars=2 --mincount=2
//  --max_items_per_langscript=6000 --flatmap --rr_alloc --freq_alloc
//  --boostcloseweakerpercent=00 --indirectbits=16 --thresh=224 --v25
//  --kentries=256 --tablename=QuadChrome0715 --remap=xxx-Latn=>ut-Latn
//  sh-Latn=>hr-Latn sh-Cyrl=>sr-Cyrl    nn-Latn=>no-Latn mo-Cyrl=>ro-Cyrl
//    --include=af-Latn ar-Arab be-Cyrl bg-Cyrl ca-Latn cs-Latn cy-Latn
//  da-Latn de-Latn el-Grek en-Latn es-Latn et-Latn fa-Arab fi-Latn fr-Latn
//    ga-Latn gd-Latn hi-Deva hr-Latn hu-Latn id-Latn is-Latn it-Latn
//  iw-Hebr    ja-Hani ko-Hani lg-Latn lt-Latn lv-Latn mk-Cyrl ms-Latn
//  nl-Latn no-Latn    pl-Latn pt-Latn ro-Latn ro-Cyrl ru-Cyrl rw-Latn
//  sh-Cyrl sh-Latn sk-Latn sl-Latn sr-Cyrl    sv-Latn sw-Latn th-Thai
//  tl-Latn tr-Latn uk-Cyrl vi-Latn yi-Hebr    zh-Hani zh-TW    sq-Latn
//  az-Latn eu-Latn bn-Beng gl-Latn ht-Latn mt-Latn sr-Latn ur-Arab
//  bh-Deva mr-Deva ne-Deva lg-Latn rw-Latn gd-Latn    ut-Latn ut-Deva
//  ceb-Latn blu-Latn jw-Latn  --ko_english --force_to_lang_soft
//  --nosoft_cram2 --nomsidlevel --shapeflatprob --langpriorpercent=10
//  --skipnuc --noshapeforcetop --noshapeeventop --noshapesteep2
//  --langcounts --writebin --list_items=120 --max_langs_per_item=3
//  i18n/encodings/cld2/prob_data/vetted_quad_prob_20130527.utf8
//
#include "cld2tablesummary.h"
namespace CLD2 {

// For this build date, looking up 'qpdbmrmxyzptlkuuddlrlrbas' gives WELSH
static const uint32 kQuadChrome0715BuildDate = 20130715;    // yyyymmdd


// Of 367242 offered items into 262144 table entries:
// 240494 filled (65%), 651 merged (0%), 126097 dropped (34%)

// Nil-grams: 19 languages
//     GREEK MALAYALAM TELUGU TAMIL GUJARATI THAI KANNADA PUNJABI
//     GEORGIAN SINHALESE ARMENIAN LAOTHIAN KHMER DHIVEHI CHEROKEE
//     SYRIAC LIMBU ORIYA INUKTITUT

// Uni-grams: 4 languages
//     Japanese Korean Chinese ChineseT

// Words/Quads: 60 languages in range ENGLISH..HMONG:
//     ENGLISH DANISH DUTCH FINNISH FRENCH GERMAN HEBREW ITALIAN
//     NORWEGIAN POLISH PORTUGUESE RUSSIAN SPANISH SWEDISH CZECH
//     ICELANDIC LATVIAN LITHUANIAN ROMANIAN HUNGARIAN ESTONIAN
//     BULGARIAN CROATIAN SERBIAN IRISH GALICIAN TAGALOG TURKISH
//     UKRAINIAN HINDI MACEDONIAN BENGALI INDONESIAN MALAY WELSH
//     NEPALI ALBANIAN BELARUSIAN JAVANESE URDU BIHARI ARABIC CATALAN
//     BASQUE SCOTS_GAELIC SWAHILI SLOVENIAN MARATHI MALTESE
//     VIETNAMESE SLOVAK AZERBAIJANI PERSIAN YIDDISH AFRIKAANS
//     HAITIAN_CREOLE KINYARWANDA GANDA CEBUANO HMONG

//  ENGLISH 3815
//  DANISH 3854
//  DUTCH 3771
//  FINNISH 3867
//  FRENCH 3835
//  GERMAN 3777
//  HEBREW 3805
//  ITALIAN 2773
//  NORWEGIAN 3850
//  POLISH 3862
//  PORTUGUESE 3860
//  RUSSIAN 3879
//  SPANISH 3326
//  SWEDISH 3930
//  CZECH 7715
//  ICELANDIC 3812
//  LATVIAN 3877
//  LITHUANIAN 3819
//  ROMANIAN 7682
//  HUNGARIAN 3832
//  ESTONIAN 3794
//  BULGARIAN 3872
//  CROATIAN 7685
//  SERBIAN 6930
//  IRISH 3849
//  GALICIAN 3667
//  TAGALOG 2941
//  TURKISH 3799
//  UKRAINIAN 3818
//  HINDI 7683
//  MACEDONIAN 3811
//  BENGALI 3837
//  INDONESIAN 3487
//  MALAY 2284
//  WELSH 3758
//  NEPALI 3775
//  ALBANIAN 3905
//  BELARUSIAN 3853
//  JAVANESE 3800
//  URDU 3843
//  BIHARI 4148
//  ARABIC 3810
//  CATALAN 3767
//  BASQUE 3800
//  SCOTS_GAELIC 3839
//  SWAHILI 3798
//  SLOVENIAN 3851
//  MARATHI 3786
//  MALTESE 3796
//  VIETNAMESE 3847
//  SLOVAK 3843
//  AZERBAIJANI 3914
//  PERSIAN 3817
//  YIDDISH 3828
//  AFRIKAANS 3797
//  HAITIAN_CREOLE 3796
//  KINYARWANDA 3760
//  GANDA 3823
//  CEBUANO 2513
//  HMONG 2280



// Recognized language-script combinations [62]:
static const char* const kQuadChrome0715RecognizedLangScripts =
  "af-Latn ar-Arab az-Latn be-Cyrl bg-Cyrl bh-Deva blu-Latn bn-Beng "
  "ca-Latn ceb-Latn cs-Latn cy-Latn da-Latn de-Latn en-Latn es-Latn "
  "et-Latn eu-Latn fa-Arab fi-Latn fr-Latn ga-Latn gd-Latn gl-Latn "
  "hi-Deva hr-Latn ht-Latn hu-Latn id-Latn is-Latn it-Latn iw-Hebr "
  "jw-Latn lg-Latn lt-Latn lv-Latn mk-Cyrl mr-Deva ms-Latn mt-Latn "
  "ne-Deva nl-Latn no-Latn pl-Latn pt-Latn ro-Cyrl ro-Latn ru-Cyrl "
  "rw-Latn sk-Latn sl-Latn sq-Latn sr-Cyrl sr-Latn sv-Latn sw-Latn "
  "tl-Latn tr-Latn uk-Cyrl ur-Arab vi-Latn yi-Hebr ";

static const uint32 kQuadChrome0715Size = 65536;    // Bucket count
static const uint32 kQuadChrome0715KeyMask = 0xffff0000;    // Mask hash key

static const IndirectProbBucket4 kQuadChrome0715[kQuadChrome0715Size] = {
  // hash_indirect[4], tokens[4] in UTF-8
   {{0xe9da0002,0x7c2e0003,0x65630004,0x394a0005}},	// [000] вка_, ssbr, kenh, _pcbs_,
   {{0x20070006,0xbddb0007,0x63bb0008,0x27ed0009}},	//   _kuni_, stèr, hiun, _ahen_,
   {{0xddc4000a,0x6563000b,0x02e2000c,0xbddb000d}},	//   _križ, denh, _पर्न, ptèr,
   {{0x63bb000e,0x2007000f,0x6e240010,0xeb9a0011}},	//   jiun, _muni_, _kwib, _рим_,
   {{0x20070012,0x63a90013,0x27ed0014,0x63bb0015}},	//   _luni_, dhen, _dhen_, diun,
   {{0x65630016,0x64430017,0x6fdd0018,0x24510019}},	//   genh, funi, léct, _bơm_,
   {{0x6443001a,0x24510019,0x26cd001b,0x2007001c}},	//   guni, _cơm_, _exeo_, _nuni_,
   {{0x63bb001d,0x63a9001e,0xf743001f,0x6fdd0020}},	//   giun, ghen, _месо, néct,
   {{0x36670021,0x65630022,0x21270023,0x69dc0024}},	//   _като_, benh, _benh_, _kkre,
   {{0x20070025,0x0f1f0026,0x65630009,0x6f040027}},	//   _buni_, पर्स_, cenh, _agic,
   {{0x2b9c0028,0x75280029,0x63bb002a,0x6aad002b}},	//   _tích_, _iedz, biun, zzaf,
   {{0x63a9002c,0x63bb002d,0x4ea7002e,0x2007002f}},	//   chen, ciun, арга, _duni_,
   {{0x75280030,0x6d470031,0x69c50032,0xc6080033}},	//   _kedz, tgja, ynhe, রীরা_,
   {{0x6e240034,0x75280035,0x20070036,0x71730037}},	//   _dwib, _jedz, _funi_, _وهنا,
   {{0x75280038,0x212c0014,0x6d470039,0xddc4003a}},	//   _medz, madh_, rgja, _friž,
   {{0x212c003b,0x69c5003c,0xddc4003d,0x6d47003e}},	//   ladh_, wnhe, _griž, sgja,
   {{0x6b8d003f,0x64430040,0xafb80041,0x69d70042}},	// [010] rjag, zuni, _خطوط_, toxe,
   {{0x63bb0043,0x212c003b,0x7ac40044,0x27ed0045}},	//   ziun, nadh_, істе, _shen_,
   {{0x69d70046,0x65630047,0x27ed0048,0x69c50049}},	//   roxe, venh, _phen_, rnhe,
   {{0x212c004a,0xa804004b,0xc7c4004c,0x6443004d}},	//   hadh_, ізіл, осчи, vuni,
   {{0x7528004e,0xd6ab004f,0x672b0050,0x69d70051}},	//   _bedz, خدام_, ragj, poxe,
   {{0x27ed0052,0x64430053,0x26df0054,0x672b0055}},	//   _when_, tuni, _vyuo_, sagj,
   {{0x27ed0056,0x65630057,0x212c0058,0x63bb0043}},	//   _then_, renh, dadh_, tiun,
   {{0x65630059,0x6443005a,0x7e6d005b,0xb385005c}},	//   senh, runi, _osap, слил,
   {{0x63a9005d,0x6443005e,0x63bb005f,0x212c0037}},	//   rhen, suni, riun, fadh_,
   {{0x64430060,0x212c003b,0x63bb0061,0x20070062}},	//   puni, gadh_, siun, _puni_,
   {{0xddc40063,0x63bb0064,0x7e6d0065,0x15ed0066}},	//   _priž, piun, _asap, _चीयर_,
   {{0xedb20067,0x66010068,0x7f4d0069,0x06ae0033}},	//   ुच्छ, _hilk, _ccaq, _ছুটি,
   {{0x6601006a,0x212c006b,0x7e6d006c,0x6729006d}},	//   _kilk, badh_, _csap, _meej,
   {{0x212c006e,0x6729006f,0xb2760070,0x00000000}},	//   cadh_, _leej, _לענג_, --,
   {{0x10150071,0xfce60072,0xdca30073,0x7e6d0074}},	//   _ابتد, сово, пари, _esap,
   {{0x69dc0075,0xee3f0076,0x67290077,0x66010078}},	//   _skre, brý_, _neej, _lilk,
   {{0x6d410079,0xddc4007a,0x6e24007b,0x00000000}},	// [020] ólac, _kriż, _uwib, --,
   {{0x46db007c,0x6601007d,0x31a9007e,0x7995007f}},	//   _बड़ह, _nilk, _fúze_, _cozw,
   {{0x75280080,0xdceb0009,0x4d7b0070,0xd7ef0081}},	//   _redz, _ćiće, _ערטע, зу_,
   {{0xbb860082,0x06d10083,0xa3e70084,0xf7460085}},	//   _الحي, ়েছি, _मील_, седо,
   {{0x65940086,0x66010087,0xe9440088,0x16340089}},	//   жалу, _bilk, _ورسی, целя,
   {{0xdb16008a,0x69dc008b,0x6609008c,0xdb0d008d}},	//   ábær, _ukre, _duek, lnað,
   {{0x6601008e,0xe644008f,0xb8960037,0x44250090}},	//   _dilk, ğlığ, _الزع, _cwl_,
   {{0x52140091,0xe6440092,0xdb0d0093,0xddc40024}},	//   одит, şlığ, nnað, _ariż,
   {{0x212c0094,0x6fc80095,0x59bf0096,0x00000000}},	//   tadh_, rıcl, ्वचर, --,
   {{0x20090009,0xddcd0097,0x44250098,0x26f60099}},	//   _čair_, _krať, _fwl_, ेशीर_,
   {{0x212c003b,0x1bf8009a,0xdb0d0093,0x6729009b}},	//   radh_, ंगाल_, knað, _yeej,
   {{0x212c009c,0x7f9f0031,0x00000000,0x00000000}},	//   sadh_, _këqi, --, --,
   {{0x212c009d,0xeabf009e,0xddc4009f,0x27fc00a0}},	//   padh_, _ceùl_, _friż, ívny_,
   {{0xa2c500a1,0xddc4009f,0x9f4900a2,0x98b800a3}},	//   ापर्, _griż, _thaï_, _ları_,
   {{0x7995006a,0x63b9001e,0x5ba700a4,0x31bb00a5}},	//   _rozw, _ymwn, браз, _תזונ,
   {{0xdb0d0093,0x2d8c00a6,0x00000000,0x00000000}},	//   gnað, öder_, --, --,
   {{0x7995004e,0x7e6d00a7,0x681500a8,0x74df00a9}},	// [030] _pozw, _usap, _işdə, _पुनः,
   {{0x5a3400aa,0x672900ab,0xaa7b00ac,0x00000000}},	//   янут, _seej, _ozýv, --,
   {{0xe71900ad,0xa3ca0026,0x98b800ae,0x9b9500af}},	//   ليات_, ोवा_, _barı_, _динц,
   {{0x660100b0,0xe00b00b1,0xd3660088,0x00000000}},	//   _silk, _संसद_, _غه_, --,
   {{0xd24600b2,0x660100b3,0xf1d800b4,0xe77800b5}},	//   _تن_, _pilk, डवान, صلوں_,
   {{0xcfcf0083,0x441500b6,0x00000000,0x00000000}},	//   রতিন, офит, --, --,
   {{0x660100b7,0x5fd900b8,0x672900b9,0xddc4009f}},	//   _vilk, णकाल, _teej, _rriż,
   {{0x36d500ba,0x660100bb,0xe3b100bc,0x57a400af}},	//   _добр, _wilk, برت_, _ешуа,
   {{0x660100bd,0x660900be,0xb5fd005f,0xddc4009f}},	//   _tilk, _uuek, _apše, _priż,
   {{0xd19900af,0x00000000,0x00000000,0x00000000}},	//   ртич_, --, --, --,
   {{0xe2a800bf,0xfbd900c0,0x98b800c1,0x00000000}},	//   لاین_, भकाम, _yarı_, --,
   {{0x14d600c2,0x225900c3,0x63b90027,0x00000000}},	//   _וועל_, _виды_, _umwn, --,
   {{0xc8e600c4,0xddc400c5,0x00000000,0x00000000}},	//   _कर्म_, _asiš, --, --,
   {{0xa0a500c6,0x853c00c7,0x00000000,0x00000000}},	//   _малд, _alėj, --, --,
   {{0x09c400c8,0x3b9600c9,0x8b9600ca,0xdb0d0093}},	//   ্তমা, ојат, орач, tnað,
   {{0x7c3a00cb,0xc05200a5,0xe8e000cc,0x00000000}},	//   štro, _חזה_, liệu_, --,
   {{0xdb0d0093,0x7c2900cd,0x00000000,0x00000000}},	// [040] rnað, ćera, --, --,
   {{0xbd4600ce,0xed5a00cf,0x98b800d0,0x2b5800d1}},	//   _بندي, _тоо_, _sarı_, _گیرد_,
   {{0xc8ca00d2,0x00000000,0x00000000,0x00000000}},	//   جوان_, --, --, --,
   {{0x81c10033,0x00000000,0x00000000,0x00000000}},	//   ূতি_, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe5a3002d,0xddcd00ac,0x00000000,0x00000000}},	//   мичи, _trať, --, --,
   {{0x07a600d3,0x00000000,0x00000000,0x00000000}},	//   _давн, --, --, --,
   {{0x81e70083,0xd32600d4,0xaa7b00d5,0x68b700a5}},	//   _মূল_, цьки, _vzýv, _וללא_,
   {{0x672200d6,0xdcfe0029,0x9f400098,0x2c1100ab}},	//   mboj, _kopē, _fhiú_, _दूनू_,
   {{0x2a6200d7,0xd25700d8,0x27e600d9,0xdb230079}},	//   _mpkb_, іцы_, llon_, árúc,
   {{0x201800da,0x26100019,0xdb06006c,0x6ac600db}},	//   ëri_, _hào_, _elké, लपुर,
   {{0x28bd00dc,0x27e600dd,0x75ed00de,0x09a700df}},	//   ्पति, nlon_, púzc, _गत्य,
   {{0xd250004f,0xa2d600d1,0x230900e0,0x201800e1}},	//   _أنت_, _بيشت, _اتمي_, ūri_,
   {{0x261000e2,0x00000000,0x00000000,0x00000000}},	//   _mào_, --, --, --,
   {{0x27e600e3,0x26100019,0x2ca500e4,0x6f1600e5}},	//   klon_, _lào_, áld_, _ffyc,
   {{0x27e600e6,0x2a6200e7,0x764200ce,0x201e004b}},	//   jlon_, _bpkb_, kroy, mpti_,
   {{0x261000e8,0x291c0095,0x27e600e9,0xdc3c00ea}},	// [050] _nào_, ıvan_, dlon_, kšķe,
   {{0xceb20070,0x7e7f0069,0x764200eb,0xdcfe00ec}},	//   _ניי_, _irqp, droy, _copē,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x26100019,0x27e600e9,0x201e00c7,0x00000000}},	//   _bào_, glon_, ipti_, --,
   {{0xff7c0070,0x26100023,0x79a700ed,0x31a900ee}},	//   יטאמ, _cào_, _дрве, _lúza_,
   {{0x5a3400ef,0x996400f0,0xbafa00a5,0x9f4000f1}},	//   _інст, _отсл, _להרש, _dhiù_,
   {{0x27e600f2,0x057400f3,0xdce500f4,0x00000000}},	//   blon_, باند, _dahć, --,
   {{0xd90e00f5,0x764200f6,0x9f40009e,0x00000000}},	//   _لیے_, broy, _fhiù_, --,
   {{0x764200f7,0x35b5002d,0x261000e2,0x78b800f4}},	//   croy, _ебар, _gào_, ćavš,
   {{0xd6c600f8,0x661b00f9,0x14190037,0x00000000}},	//   _عملی, _ituk, _هيئة_, --,
   {{0x3cdb00fa,0x00000000,0x00000000,0x00000000}},	//   _खुले_, --, --, --,
   {{0x6d4100fb,0xe3b300fc,0x00000000,0x00000000}},	//   ólan, _غرض_, --, --,
   {{0x26100023,0xb2c700fd,0xdd1100fe,0x705200ff}},	//   _xào_, _بغاو, _hýři, ونیا,
   {{0xdd9200bf,0x427a0100,0x64430101,0x672200cd}},	//   روز_, _לאנג, orni, zboj,
   {{0xa0a50102,0x661b0103,0x0c790104,0x00000000}},	//   _хайд, _ltuk, осты_, --,
   {{0x5f760105,0x64430106,0xbebb0031,0x3c180107}},	//   _رابر, irni, mbën, _nčve_,
   {{0xeb970108,0xa9a60109,0x661b010a,0x4a46010b}},	// [060] чит_, пиад, _ntuk, янав,
   {{0x2d96010c,0x7e64010d,0x26100023,0xfa490037}},	//   _хрис, _ipip, _rào_, تشفى_,
   {{0xfce6010e,0x661b010f,0x6d5c0110,0x261000e2}},	//   _хоно, _atuk, mfra, _sào_,
   {{0x2d9a00a5,0x76420111,0xe7370112,0xa2dc0099}},	//   _hope_, troy, зец_, _पडल्,
   {{0x67220029,0x64430113,0xd90d00fd,0xf99100fd}},	//   rboj, erni, ایہ_, ربے_,
   {{0x6d4e0114,0x261000e8,0x6d5c0115,0x27e60116}},	//   ngba, _vào_, nfra, slon_,
   {{0x27e60117,0x290a0118,0x661b0119,0x29180044}},	//   plon_, _igba_, _etuk, _ifra_,
   {{0x69de011a,0x7642011b,0x7e64011c,0xa857011d}},	//   lope, proy, _opip, _מילה_,
   {{0x321f011e,0x41e600d8,0x04fe0033,0x00000000}},	//   gpuy_, зіна, ুরের_, --,
   {{0x69de011f,0x6d4e0120,0x56370070,0x64430121}},	//   nope, jgba, _מאמע_, brni,
   {{0xf9930122,0x6d5c0123,0xe8df0019,0x64430124}},	//   תרת_, dfra, _trục_, crni,
   {{0xd36f0125,0x69de0126,0xd9b90127,0xbddb0118}},	//   _مهم_, hope, _आष्ट, grèn,
   {{0x6d5c0128,0x644a0129,0xe3b300c2,0x69de012a}},	//   ffra, lufi, _אױף_, kope,
   {{0x72eb012b,0x2d9a012c,0x00000000,0x00000000}},	//   _פֿאַ, _cope_, --, --,
   {{0xd5c800e8,0x6458012d,0x7c29012e,0x515b00a5}},	//   yền_, ntvi, ćero, _הכוו,
   {{0x7e64012f,0x6d4e0130,0xa3be0066,0xc17800c7}},	//   _fpip, agba, ुचि_, ldė_,
   {{0xb9990131,0xdb0d0132,0xdcfd00a8,0x6d5c0110}},	// [070] овах_, nhaé, ızıs, bfra,
   {{0x5c070133,0x64430134,0x64580135,0xc178010b}},	//   _няма, yrni, ktvi, ndė_,
   {{0x3ea60080,0x661b0136,0xa3be0099,0x75ed00ac}},	//   _ļoti_, _stuk, ुचा_, fúzn,
   {{0x6443008b,0x2d9a0065,0xdc360070,0x64580137}},	//   vrni, _zope_, _קארט_, dtvi,
   {{0x7bdf0138,0x69de0139,0x7bcd013a,0x3f8900ee}},	//   moqu, bope, mnau, _mnau_,
   {{0x6458008c,0xddd60097,0x3f9b013b,0x00000000}},	//   ftvi, _kryš, _loqu_, --,
   {{0x6458013c,0x6443013d,0xbddb00a2,0x7bcd013e}},	//   gtvi, urni, yrèn, onau,
   {{0x7bcd013f,0x64430140,0x260a0141,0x22150142}},	//   nnau, rrni, ादशी_, мфор,
   {{0x6d5c001e,0xd24e0079,0x661b0143,0x42540144}},	//   yfra, لني_, _utuk, нтэт,
   {{0x23c30107,0x10a50145,0x6d410146,0x644a007b}},	//   _bèjè_, дион, ólal, bufi,
   {{0x54550002,0x2d9a0147,0x00000000,0x00000000}},	//   _цвет, _rope_, --, --,
   {{0xd24e0148,0x20180149,0x69de002f,0xe291014a}},	//   دنی_, íria_, zope, _لذت_,
   {{0x6d5c014b,0x69de0054,0x7bdf014c,0x2d9a0147}},	//   tfra, yope, doqu, _pope_,
   {{0x90c5014d,0x7ae6014e,0x3f89014f,0xdce500a0}},	//   _обле, _rykt, _enau_, _dohľ,
   {{0xfce30150,0x6d5c0151,0x7bdf0152,0x1d070153}},	//   воро, rfra, foqu, дери_,
   {{0x7bcd0154,0x764b0155,0x8ffa00d1,0x7c220156}},	//   gnau, kugy, _برتر_, _čord,
   {{0x69de0157,0x2d9a0158,0x3207007b,0x00000000}},	// [080] tope, _tope_, _kiny_, --,
   {{0x764b0159,0x7bcd0051,0x320f0118,0xddd6007e}},	//   dugy, anau, _mugy_, _fryš,
   {{0xeb9a0012,0x8b26015a,0x69de015b,0x2ade0096}},	//   _дин_, _одне, rope, _कुरु_,
   {{0xfaa6004b,0x46ea015c,0x69de015d,0x7bdf015e}},	//   _жамо, оден_, sope, coqu,
   {{0x69de015f,0xe6770160,0x00000000,0x00000000}},	//   pope, _aţâţ, --, --,
   {{0x64580161,0x28d90162,0x644a0163,0x00000000}},	//   ttvi, _बुकि, tufi, --,
   {{0xd90d0164,0x00000000,0x00000000,0x00000000}},	//   _ایم_, --, --, --,
   {{0x02a60165,0xc2740166,0x28bd0167,0x320f0168}},	//   дром, елиј, ्परि, _bugy_,
   {{0x64580169,0x6aa4016a,0xba9b016b,0x65af008c}},	//   stvi, nyif, ַסטי, _søhe,
   {{0xb5aa004f,0x2fc0016c,0xd25000fd,0x00000000}},	//   _بارك_, _amig_, پنگ_, --,
   {{0x26ee007c,0x3207016d,0x799c016e,0xc17800c7}},	//   _जरुर_, _diny_, _morw, rdė_,
   {{0xdce5016f,0x2d9e0170,0x33830171,0x73360172}},	//   _pohľ, öten_, _аушв, _آرائ,
   {{0x799c0173,0xa3e70174,0x7bdf0175,0x69cb00b5}},	//   _oorw, _मीट_, voqu, égek,
   {{0x290700d8,0x32070176,0x442c0177,0x62820178}},	//   žnai_, _giny_, _kwd_, _iroo,
   {{0x7bdf0179,0x00000000,0x00000000,0x00000000}},	//   toqu, --, --, --,
   {{0x62820006,0x26ee017a,0x6608017b,0x764b0159}},	//   _kroo, _जरूर_, _lidk, yugy,
   {{0x7bcd017c,0x799c017d,0xdee7017e,0xa3d6017f}},	// [090] rnau, _borw, _تأثي, _सदन_,
   {{0xf9930180,0x6e2d0010,0x7bdf0181,0xdb0d00f7}},	//   خبر_, _iwab, soqu, chaî,
   {{0x20090182,0x7bdf0183,0x23b10184,0xddcd005f}},	//   _kiai_, poqu, _háje_, _kraž,
   {{0xa6350185,0x6e2d0186,0x68e70187,0x764b0188}},	//   енді, _kwab, _vyjd, tugy,
   {{0x62820189,0x799c00a5,0x2009018a,0x68e70067}},	//   _nroo, _forw, _miai_, _wyjd,
   {{0x6b9d018b,0x6e2d018c,0xba43010b,0x799c00e9}},	//   _hosg, _mwab, žįst, _gorw,
   {{0x6282018d,0x6e2d018e,0x7659001e,0x69c5018f}},	//   _aroo, _lwab, stwy, mihe,
   {{0xe2990036,0x6f0d0190,0x62820191,0xe64b00a8}},	//   заи_, _ngac, _broo, şdığ,
   {{0x02050192,0x09c40033,0x62820147,0x00000000}},	//   нзин, ্তরা, _croo, --,
   {{0x62820136,0x6b9d0193,0x6f0d0010,0x69c50194}},	//   _droo, _losg, _agac, nihe,
   {{0x6e2d0195,0x62820196,0x320700ac,0xddcd0197}},	//   _awab, _eroo, _viny_, _braž,
   {{0x6e2d0198,0x69c50199,0x6b9d002a,0x6282019a}},	//   _bwab, hihe, _nosg, _froo,
   {{0xee37019b,0x6282019c,0x69c5019d,0x6145019e}},	//   ння_, _groo, kihe, _зела,
   {{0x236d019f,0x4cc10033,0x6f0d0176,0x7c2201a0}},	//   leej_, _শুধু, _egac, _čorb,
   {{0x61e101a1,0x69c501a2,0x6b9d01a3,0x61d600a5}},	//   moll, dihe, _bosg, _אוסף_,
   {{0x63a901a4,0x200901a5,0xddcd00d8,0x6b9d01a6}},	//   nken, _giai_, _graž, _cosg,
   {{0x6b63005f,0x799c01a7,0x6e2d01a8,0x6b9d009e}},	// [0a0] ыкта, _porw, _gwab, _dosg,
   {{0x236d01a9,0x61e101aa,0x63a901ab,0x69c501ac}},	//   heej_, noll, hken, gihe,
   {{0x63a901ad,0x799c01ae,0x6b9d01a6,0x574601af}},	//   kken, _vorw, _fosg, енеб,
   {{0x61e101b0,0x63a901b1,0x1bba01b2,0x224d01a3}},	//   holl, jken, _راجع_, kuek_,
   {{0x61e101b3,0x63a901b4,0x9980010b,0x69c501b5}},	//   koll, dken, usių_, bihe,
   {{0x63a901b6,0x224d01b7,0x00000000,0x00000000}},	//   eken, duek_, --, --,
   {{0x186701b8,0x61e101b9,0x316c01ba,0x63a90051}},	//   _пари_, doll, vedz_, fken,
   {{0x645c00ab,0x628201bb,0x6f0900f4,0x00000000}},	//   _ärim, _proo, žeci, --,
   {{0xd2570043,0x6d41008d,0x224d0065,0x660801bc}},	//   нцэ_, ólak, guek_, _tidk,
   {{0xbddb01bd,0x61e101be,0x6e2d0010,0x628201bf}},	//   trèm, goll, _rwab, _vroo,
   {{0xddcd01c0,0x6e2d01c1,0x200900d7,0x316c00ea}},	//   _praž, _swab, _piai_, redz_,
   {{0x645a01c2,0x63a901c3,0xd469004f,0x657a01c4}},	//   _iqti, cken, _تحكم_, _hath,
   {{0x657a01c5,0xddcd01c6,0x61e101c7,0x71a601c8}},	//   _kath, _vraž, boll, _падз,
   {{0x61e101c9,0xd12f01ca,0x657a01cb,0x40940037}},	//   coll, _همه_, _jath, _للتر,
   {{0xddcd01cc,0x6b9d01cd,0x657a01ce,0x628001cf}},	//   _traž, _posg, _math, lvmo,
   {{0x657a0014,0x6e2d01d0,0xddcd00d5,0x09bb01d1}},	//   _lath, _twab, _uraž, ोच्य,
   {{0x245a01d2,0x3df501d3,0x6b9d01d4,0x6e2d01d5}},	// [0b0] hëm_, _изис, _vosg, _uwab,
   {{0xdb0d004f,0x3eb301d6,0x63a901d7,0xc4b00035}},	//   mhaí, ıntı_, zken, जनाओ,
   {{0x69c501d8,0x63a901d9,0x6b9d01da,0x00000000}},	//   rihe, yken, _tosg, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe6180044,0x8b9a0122,0x8a1801db,0x657a01dc}},	//   еді_, _חברת, _пояс_, _bath,
   {{0x61e101dd,0x657a01de,0x1a6801df,0x659401e0}},	//   xoll, _cath, _سیمی_, лачу,
   {{0x657a01e1,0x61e101e2,0x63a901e3,0x69d501e4}},	//   _dath, voll, tken, _ijze,
   {{0xc17801c8,0x657a01e5,0x68e301ae,0x224d01d7}},	//   klės_, _eath, ündu, tuek_,
   {{0x61e101e6,0x853c010b,0xddcd007a,0x00000000}},	//   toll, _plėt, _braż, --,
   {{0x63a901e7,0x9264004f,0x236d01e8,0x777b01d7}},	//   sken, اديم, seej_, _haux,
   {{0x63a901e9,0x00000000,0x00000000,0x00000000}},	//   pken, --, --, --,
   {{0x61e101ea,0x00000000,0x00000000,0x00000000}},	//   soll, --, --, --,
   {{0x61e101eb,0x657a01ec,0xddcd007a,0x224d01ed}},	//   poll, _yath, _fraż, quek_,
   {{0x614501ee,0xdb0d01ef,0x7e7600d5,0x777b00e2}},	//   _река, diañ, _vsyp, _laux,
   {{0xb02400e8,0xfce601f0,0x1fb601f1,0x2b3a00af}},	//   _trườ, тово, _аспр, дязэ_,
   {{0xf4130083,0x69d501f2,0x8e4a0037,0xdb0d0079}},	//   _সবার_, _ajze, _قلبك_, bhaí,
   {{0xc33201f3,0x245a01f4,0xdcfe00ea,0xb5fd013a}},	// [0c0] יון_, zëm_, _kopī, _apšm,
   {{0x2d9501f5,0xe9d701f6,0xa92300af,0x9f4001f7}},	//   _брюс, вку_, идул, _thió_,
   {{0x657a01f8,0x2fd70088,0x777b01f9,0x00000000}},	//   _rath, _سوید_, _baux, --,
   {{0x657a01fa,0x7bda000d,0xb09a0070,0xe3b801fb}},	//   _sath, étud, ויער, _atın_,
   {{0x657a01fc,0xeb9701fd,0x00000000,0x00000000}},	//   _path, _рия_, --, --,
   {{0x245a01d2,0x7c3a01fe,0x645c00ab,0xceb3016b}},	//   tëm_, štru, _ärik, סיג_,
   {{0x629d01ff,0xd4670200,0x657a0201,0x00000000}},	//   äson, вије_, _vath, --,
   {{0x07a30202,0x245a0055,0x657a0203,0xc7a30204}},	//   _касн, rëm_, _wath, _киск,
   {{0x657a0205,0xa6650206,0x245a0031,0x7c290207}},	//   _tath, _مطلو, sëm_, ćeri,
   {{0x657a004f,0x601e0029,0x00000000,0x00000000}},	//   _uath, _līme, --, --,
   {{0x9f350208,0x8f350209,0x255a0107,0x00000000}},	//   лені, ленц, _vņlč_, --,
   {{0xdb0d004f,0xddcd0035,0x67f800b8,0x1fa7020a}},	//   thaí, _wraż, bíje, трог,
   {{0x7c22020b,0x386a0009,0xecdb0067,0x798e0107}},	//   _čora, _lpbr_, _मुजफ, _onbw,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3d6020c,0xa3c6020d,0xc1f70070,0x3ead020e}},	//   _सदा_, _उगा_, _שמוץ_, šet_,
   {{0x644a0037,0x7d0800b5,0x23b1007e,0x00000000}},	//   irfi, _sérü, _kája_, --,
   {{0x777b020f,0xaa5c0210,0x6284010b,0x23b100fe}},	// [0d0] _raux, метi, _šioj, _jája_,
   {{0x23b101ba,0x39580211,0x4c950212,0x00000000}},	//   _mája_, _ccrs_, _биос, --,
   {{0x2907013c,0x443e0213,0x98140037,0x4cc10033}},	//   äna_, _nvt_, لبنا, _শুরু,
   {{0xc8640214,0x9b95002d,0xdb0d01ed,0x00000000}},	//   ртфи, _симц, piañ, --,
   {{0x4993006c,0x75ed0215,0x7bda000d,0x9f44000d}},	//   _پیار, lúzi, étue, ômé_,
   {{0x6d550216,0x601e00ea,0xbebb0031,0x27310023}},	//   ngza, _zīme, rbëh, ạn_,
   {{0xe89400c3,0x69d80099,0x2a790207,0x00000000}},	//   _карь, _मदती, _hssb_, --,
   {{0x58d40217,0x2907010b,0x00000000,0x00000000}},	//   _тост, žnas_, --, --,
   {{0x443e0218,0x644a0219,0x36d50043,0xdb06008c}},	//   _evt_, arfi, _соар, _elkæ,
   {{0xdb040037,0x05b7021a,0x443e0044,0x6d550051}},	//   thiú, _अतिब, _fvt_, jgza,
   {{0xcea900c2,0x8fa6021b,0x443e021c,0x00000000}},	//   _צי_, гане, _gvt_, --,
   {{0x261900e2,0xdb0f00a2,0x6563021d,0x3c18021e}},	//   _kèo_, _ulcè, lfnh, _sčvo_,
   {{0x2bc60141,0xe1ee021f,0xe28e0210,0x00000000}},	//   रोफा, _гг_, _уа_, --,
   {{0xd00e0220,0x237d0221,0x26190019,0x5fc600ab}},	//   _کلي_, _hawj_, _mèo_, _लगवल,
   {{0x225f0222,0x00000000,0x00000000,0x00000000}},	//   ltuk_, --, --, --,
   {{0xc0520052,0x6d550223,0x00000000,0x00000000}},	//   _הזה_, agza, --, --,
   {{0x225f0224,0x261900e2,0xdd040225,0x00000000}},	// [0e0] ntuk_, _nèo_, ırıs, --,
   {{0x237d01e8,0x6e2401d6,0x8d560226,0x00000000}},	//   _lawj_, _itib, _стич, --,
   {{0xdca60227,0x39580183,0x601e0228,0x3136016b}},	//   _сани, _vcrs_, _tīme, רנעם_,
   {{0x237d0221,0x261900e2,0x225f0229,0xfaff0055}},	//   _nawj_, _bèo_, ktuk_, _ibën_,
   {{0x569400af,0x443e022a,0x96e7022b,0xe5a6022c}},	//   ралт, _svt_, льша_, лиди,
   {{0x443e022d,0x281600d1,0x2a60022e,0x6e24002f}},	//   _pvt_, _موسس, mtib_, _mtib,
   {{0xdd3200a8,0x00000000,0x00000000,0x00000000}},	//   zəşt, --, --, --,
   {{0x6d55022f,0x7f440031,0x644a0230,0x722a0231}},	//   zgza, _ndiq, rrfi, нцов_,
   {{0x6e240232,0x27e60233,0x237d006d,0x85560071}},	//   _ntib, moon_, _dawj_, _مخاط,
   {{0x27e60234,0xd6cf0041,0x104a0235,0x463b0070}},	//   loon_, _عقل_, нями_, _נעבע,
   {{0x6e240236,0xb6030237,0x5f950043,0x2a6000be}},	//   _atib, íšen, аинт, htib_,
   {{0x27e60238,0x2a600239,0x2366023a,0x00000000}},	//   noon_, ktib_, _uboj_, --,
   {{0x6e2400d5,0x6234002d,0xcae300b4,0x44ce013b}},	//   _ctib, _телу, _कुंड_, _hə_,
   {{0x63a2007c,0x27e6023b,0x7bc6023c,0x00000000}},	//   _hoon, hoon_, _amku, --,
   {{0x63a2007c,0x27e6023d,0x6e240095,0x2a6b01da}},	//   _koon, koon_, _etib, _spcb_,
   {{0x764b016e,0x63a2023e,0x44ce00a8,0x27e6023f}},	//   yrgy, _joon, _mə_, joon_,
   {{0x27e6010d,0x38c9006c,0x44ce00a8,0x65af008c}},	// [0f0] doon_, ھائی_, _lə_, _bøhl,
   {{0x2bc60240,0x63a20241,0x7e6d0242,0x26180243}},	//   रोबा, _loon, _ipap, _पढ़ी_,
   {{0x44ce01c2,0x27e60244,0x6d450245,0xa2cb0246}},	//   _nə_, foon_, _idha, _तेन्,
   {{0x63a20247,0xbddb0248,0x68ee0249,0x4427024a}},	//   _noon, ssèd, _dybd, vpn_,
   {{0x69cb00b5,0x6e240183,0xbb3a024b,0x00000000}},	//   éges, _xtib, _שעשי, --,
   {{0xce3800a5,0x9f420187,0x3a2900d7,0x7e6d024c}},	//   נאות_, roké_, mpap_, _mpap,
   {{0x63a2024d,0x27e600d7,0x9f42024e,0x6d45024f}},	//   _boon, boon_, soké_, _mdha,
   {{0x44ce0250,0x225f00b5,0xc2450251,0x261900e2}},	//   _də_, ttuk_, аник, _tèo_,
   {{0x63a200b9,0x6d450252,0xa3d60253,0x7e6d0159}},	//   _doon, _odha, _सदर_, _npap,
   {{0xb5fd0254,0x7aef00d7,0x6d4500f8,0x44270255}},	//   _opši, _myct, _ndha, ppn_,
   {{0x225f0256,0x7e6d0257,0x237d006f,0xe1f6002d}},	//   stuk_, _apap, _tawj_, ргэ_,
   {{0x6d450258,0xe7b50066,0x8e860259,0xc49a025a}},	//   _adha, ंसिप, агме, _בשעת,
   {{0x7c25025b,0x7aef00d7,0x69c7025c,0x7f440055}},	//   _athr, _nyct, _omje, _vdiq,
   {{0x63a2025d,0x7bc600d7,0x27e60223,0x44ce00a8}},	//   _zoon, _smku, zoon_, _yə_,
   {{0x63a2025e,0x27e60107,0x417400d1,0x30790070}},	//   _yoon, yoon_, _دانس, _יאַנ,
   {{0x63a200cc,0x4b26010b,0x00000000,0x00000000}},	//   _xoon, рмав, --, --,
   {{0x4425025f,0x6a83002d,0x3f92010d,0x98b10260}},	// [100] _ltl_, олта, _inyu_, _dezč_,
   {{0x27e60261,0x2a600262,0x644100b8,0xd9460263}},	//   woon_, rtib_, _ovli, режи,
   {{0x27e60264,0xb6070029,0xe73a0265,0xa3e50266}},	//   toon_, _mašī, вее_, पका_,
   {{0xb6cb006c,0xd62a0267,0xc6a60268,0xbebb0031}},	//   ھانے_, воде_, ирли, rbëv,
   {{0x27e60269,0x6441026a,0x8884026b,0x00000000}},	//   roon_, _avli, _گیان, --,
   {{0xbebb01d2,0x27e6026c,0x224d026d,0x4425026e}},	//   mbët, soon_, drek_, _btl_,
   {{0x63a2026f,0x27e60270,0xb7960200,0x00000000}},	//   _poon, poon_, _краћ, --,
   {{0x44ce0271,0x32660272,0x660301e8,0x7bd60273}},	//   _və_, атов, amnk, nnyu,
   {{0x644100d0,0xe57a0274,0x00000000,0x00000000}},	//   _evli, _иза_, --, --,
   {{0x63a20261,0x2ade007c,0x2bc60275,0x44ce013b}},	//   _woon, _कुछु_, रोता, _tə_,
   {{0x63a20276,0x66e200fe,0x6d45008c,0x09f70277}},	//   _toon, _díků, _rdha, שמים_,
   {{0xc4770122,0x224d0278,0x3f800279,0x4fc70012}},	//   _כתבו_, brek_, _caiu_, рсоа,
   {{0x4425027a,0xef1f027b,0x7c25009e,0x224d027c}},	//   _ztl_, rcü_, _sthr, crek_,
   {{0xdb0d0279,0x4425027d,0x3f82027e,0x3f920103}},	//   lhaç, _ytl_, adku_, _enyu_,
   {{0x8bc7027f,0xab950274,0xd1380067,0xddc40139}},	//   асад, бављ, ając_, _spiţ,
   {{0x69c70280,0x5b150281,0x61e80282,0xdb0d0132}},	//   _smje, смат, lodl, nhaç,
   {{0x2bc600a1,0x7e6d0283,0x2fc90284,0x6d41008a}},	// [110] रोधा, _upap, _imag_, ólas,
   {{0x6d450245,0x28870200,0x00000000,0x00000000}},	//   _udha, ићев, --, --,
   {{0x2fc9023a,0xcd7600a5,0x4dda00a5,0x00000000}},	//   _kmag_, _העתק_, _תחתו, --,
   {{0x44250285,0xd3660286,0x61e8024e,0xc60f0287}},	//   _rtl_, _عه_, hodl, ाद्य_,
   {{0x7bcd00d8,0x2d81007c,0x61e80288,0x5a440144}},	//   miau, _kahe_, kodl, _мэра,
   {{0x69c70289,0x2d83028a,0x7bcd00d8,0x4425028b}},	//   _umje, ndje_, liau, _ptl_,
   {{0xf773028c,0x2d8100b9,0x2d830223,0xaa8600d5}},	//   _وار_, _mahe_, idje_, rkýž,
   {{0x224d028d,0x7bcd028e,0x2d81007c,0xe3b1028f}},	//   trek_, niau, _lahe_, ثرت_,
   {{0x27ed0290,0x6aad01d5,0x1309002d,0x00000000}},	//   _iken_, nyaf, ыний_, --,
   {{0x224d0291,0xddc40292,0x61e80293,0x3f800294}},	//   rrek_, _opiš, godl, _saiu_,
   {{0x600a0267,0x7bcd0295,0x44250103,0x27ed0296}},	//   лном_, kiau, _utl_, _kken_,
   {{0x25a50297,0xdb0d0279,0x224d0298,0x2d830223}},	//   _holl_, chaç, prek_, edje_,
   {{0x4ac70299,0x2169029a,0x25a5029b,0x7bcd029c}},	//   _रेलव, _били_, _koll_, diau,
   {{0x2d83029d,0x63bb029e,0x4126029f,0x2fc902a0}},	//   gdje_, lhun, _лошо_, _emag_,
   {{0x601e013a,0x27ed02a1,0x705500b5,0x628b022f}},	//   _tīma, _oken_, _انعا, _hrgo,
   {{0x7bcd00d8,0x25a500be,0x2d8302a2,0x6d410093}},	//   giau, _loll_, adje_, ólar,
   {{0xdb0f0132,0x3946010b,0x63bb02a3,0xe9da02a4}},	// [120] _alcâ, йнаг, ihun, гка_,
   {{0x645c02a5,0x25a502a6,0x0d8300c3,0x628b02a7}},	//   _årig, _noll_, _ельн, _mrgo,
   {{0x6c860082,0x27ff02a8,0x7bcd010b,0x63bb02a9}},	//   _الجم, _bhun_, biau, khun,
   {{0x27ff02aa,0x7bcd02ab,0x628b02ac,0x2bfb00e7}},	//   _chun_, ciau, _orgo, ्षणं_,
   {{0x63bb00f8,0x6b840176,0x95ca02ad,0x25a502ae}},	//   dhun, mdig, лука_, _boll_,
   {{0x6b8402af,0x27ed02b0,0x27ff01d7,0x63bb02b1}},	//   ldig, _eken_, _ehun_, ehun,
   {{0x628b01d3,0x31cd00c8,0x61e802b2,0x6d5e01ed}},	//   _argo, রকাশ, vodl, _mcpa,
   {{0x63bb02b3,0x78a101f7,0x291500c1,0xe81d02b4}},	//   ghun, _àlva, ğdaş_, _बंता_,
   {{0x1a9a02b5,0xd130004f,0x6b8402b6,0x25a502b7}},	//   ריִע, ومة_, idig, _foll_,
   {{0x361b02b8,0x25a500e9,0x2fc902b9,0x154302ba}},	//   _עובד, _goll_, _smag_, _неум,
   {{0x2ed1021a,0x63bb0079,0x61e80282,0x9f9902bb}},	//   सप्त, bhun, rodl, авну_,
   {{0x63bb02bc,0xf8b30122,0x753a02bd,0x03a30009}},	//   chun, פשר_, _hetz, _нихо,
   {{0x6b8402be,0xddc401ba,0x7bcd00c7,0x20000211}},	//   ddig, _spiš, viau, _dhii_,
   {{0x753a02bf,0x6b8402c0,0x0dc802c1,0x645c018d}},	//   _jetz, edig, буси_, _äris,
   {{0x7bcd02c2,0x2d8302c3,0x753a0110,0x2d8100be}},	//   tiau, rdje_, _metz, _vahe_,
   {{0x753a02bf,0x69dc02c4,0x6b8402c5,0xddc402c6}},	//   _letz, _ajre, gdig, _vpiš,
   {{0x7bcd01c8,0x6e3602c7,0x0dcb02c8,0x2d81018d}},	// [130] riau, _gwyb, _буни_, _tahe_,
   {{0x753a02c9,0x213e00f1,0x6b8402ca,0x7bcd010b}},	//   _netz, nath_, adig, siau,
   {{0xddc40254,0x27ff0019,0x6aad012f,0x8af000a8}},	//   _upiš, _phun_, syaf, lgəl,
   {{0x25a502c9,0x64c302cb,0x6b8400f6,0xd5b800ec}},	//   _soll_, _वेगळ, cdig, _alā_,
   {{0xb5fd02cc,0x25a502cd,0x1c1f0299,0x959902ce}},	//   _opšt, _poll_, _मंडल_, итку_,
   {{0x7afd02cf,0x3c1802d0,0x59dd02d1,0x00000000}},	//   _izst, _sčvi_, _मदिर, --,
   {{0x63bb02d2,0x25a501ae,0x27ff02d3,0x799501ae}},	//   thun, _voll_, _thun_, _inzw,
   {{0xdcfc02d4,0x753a0051,0xb22502d5,0x422502d6}},	//   ndrā, _eetz, омил, одив,
   {{0x59dd0066,0x248c02d7,0x25a502d8,0x00000000}},	//   _मदार, _erdm_, _toll_, --,
   {{0x63bb02d9,0x628b025c,0xdb1d0093,0x6b8400ae}},	//   shun, _vrgo, _umsæ, zdig,
   {{0xc95202da,0x6b8402db,0x63bb02dc,0x00e200d8}},	//   ומי_, ydig, phun, джэн,
   {{0x628b02dd,0xe3b302de,0x661b0086,0x644302df}},	//   _trgo, _عرض_, _kuuk, msni,
   {{0x614502e0,0x333f02e1,0x6443013c,0x661b00ab}},	//   _дела, maux_, lsni, _juuk,
   {{0x661b02e2,0x00000000,0x00000000,0x00000000}},	//   _muuk, --, --, --,
   {{0x8fa602e3,0x1dbb02e4,0x644302e5,0xdb0f0176}},	//   _маке, _उतरत, nsni, _alcà,
   {{0x333f0248,0x6b8402e6,0xbebb01f4,0x26360035}},	//   naux_, udig, rbër, yło_,
   {{0x49ca0200,0x37cf0033,0xba2902e7,0x00000000}},	// [140] алан_, িকার, مسلم_, --,
   {{0x644302e8,0x23b80118,0x00000000,0x00000000}},	//   ksni, _méja_, --, --,
   {{0x2d9500d8,0xdb0601f4,0x3e6400c3,0xa2cb01c0}},	//   _хрыс, _kokë, löt_, _तेस्,
   {{0x753a02c9,0xbddb02e9,0xddc400d5,0x661b02ea}},	//   _setz, nsèn, _sviň, _buuk,
   {{0x6d5c02eb,0x25e6009a,0x2b4002ec,0x667602ed}},	//   ogra, टवली_, maic_, تدار,
   {{0x27380028,0x6593005f,0xc7b900b5,0xdb0402ee}},	//   ẩn_, дашу, _elő_, rkiä,
   {{0xe73a02ef,0x2636004e,0x291802f0,0x6d5c02f1}},	//   _веб_, sło_, _igra_, igra,
   {{0x66e602f2,0x938a02f3,0x661b02f4,0x2b400037}},	//   _доба, рска_, _fuuk, naic_,
   {{0xbddb01f7,0x00000000,0x00000000,0x00000000}},	//   krèp, --, --, --,
   {{0x23b800f7,0x201a0118,0x00000000,0x00000000}},	//   _déja_, _épik_, --, --,
   {{0x213e02f5,0x6d5c02f6,0xdfd10037,0x333f00a2}},	//   rath_, dgra, فيد_, baux_,
   {{0xa2cb02cb,0x333f0248,0x442e02f7,0x645802f8}},	//   _तेव्, caux_, mpf_, muvi,
   {{0xdefb00c7,0x645802f9,0xdcfe02fa,0x229402fb}},	//   рын_, luvi, _dapč, _хиля,
   {{0x6d5c02fc,0x29180282,0xdce5013a,0xe2a902fd}},	//   ggra, _ngra_, _abhā, _دامن_,
   {{0xe0d402b5,0x5ba702fe,0x645802ff,0x602100ea}},	//   _מײַ_, ораз, nuvi, _tēma,
   {{0x6d5c0082,0xc053011d,0xdb0f0300,0x2d9e0301}},	//   agra, _חזק_, _alcá, öter_,
   {{0x2bbc0302,0x201c007c,0x6d5c02d7,0x64580303}},	// [150] _ईतरा, _huvi_, bgra, huvi,
   {{0x64430304,0x64580086,0x6d5c0305,0xbddb0176}},	//   ysni, kuvi, cgra, crèp,
   {{0x333f00f7,0xe7190037,0x7d7a00a5,0xf8b10105}},	//   yaux_, ميات_, _הנתו, رکس_,
   {{0x6c7a02b5,0x5c7a02b5,0x661b005b,0x64580306}},	//   _פארפ, _פארה, _puuk, duvi,
   {{0x333f02e1,0x7afd0029,0xcb9a0122,0x64430159}},	//   vaux_, _uzst, _הסרט, wsni,
   {{0x64430307,0x201c0279,0x3d190035,0xdb0401ef}},	//   tsni, _ouvi_, _दलों_, chiñ,
   {{0x333f0248,0x22460260,0x23b100d5,0x64580308}},	//   taux_, _avok_, _háji_, guvi,
   {{0x64430309,0x6d5c030a,0x3a39028b,0x661b030b}},	//   rsni, zgra, _kwsp_, _tuuk,
   {{0x6443030c,0x333f0248,0xd54b0088,0x224600d5}},	//   ssni, raux_, _نجام_, _cvok_,
   {{0x644301c8,0x6578027d,0x201c030d,0x332600ee}},	//   psni, cevh, _buvi_, _efox_,
   {{0x645c007c,0x333f00f7,0xc9520070,0x64580139}},	//   _ärip, paux_, עמט_, cuvi,
   {{0xbebb01f4,0xb4fa00a5,0x6d5c00e5,0x3e64030e}},	//   rcën, _הפעי, wgra, töt_,
   {{0xcaea030f,0x3fc900f8,0x00000000,0x00000000}},	//   _झुंड_, تگوی_, --, --,
   {{0xda1f0299,0x6d5c0310,0x00000000,0x00000000}},	//   _बढ़त_, ugra, --, --,
   {{0x9f920311,0xdb0601f4,0x31560070,0x2246008b}},	//   lší_, _tokë, _זיצן_, _zvok_,
   {{0x6561011e,0x9f420097,0x3a2b0312,0x00000000}},	//   _lclh, boká_, _btcp_, --,
   {{0x6e46004f,0x6d5c0313,0x9f920314,0x2b400315}},	// [160] _عندم, pgra, nší_, raic_,
   {{0x2b400316,0x00000000,0x00000000,0x00000000}},	//   saic_, --, --, --,
   {{0x9d1b0317,0x2b400318,0x00000000,0x00000000}},	//   _לויט, paic_, --, --,
   {{0xdc9b0319,0x6a86031a,0x6b5a00af,0xab65013a}},	//   _היטל, _елма, _ушор_, _ceļā,
   {{0x9f92031b,0x394100d7,0x656d0124,0x7f8d016b}},	//   jší_, bahs_, đahn, ינאַ,
   {{0x6458031c,0x8afb0122,0x9f92031d,0x00000000}},	//   tuvi, _להכי, dší_, --,
   {{0x69ce031e,0x80d000c8,0xdd570070,0x98b8023a}},	//   _imbe, _সুন্, לבסט_, _kerč_,
   {{0x6458031f,0xdb06027a,0x7d070320,0x00000000}},	//   ruvi, _pokè, léré, --,
   {{0x6b860321,0x64580322,0x201c0323,0x98b10160}},	//   _makg, suvi, _suvi_, _teză_,
   {{0x7d0700f7,0x00000000,0x00000000,0x00000000}},	//   néré, --, --, --,
   {{0x26150324,0xf99300a5,0x00000000,0x00000000}},	//   _फूटी_, גרת_, --, --,
   {{0x09b90325,0x602801c0,0x78fb02b5,0x333d0024}},	//   _इत्य, _něme, מפיו, _gewx_,
   {{0x69ce0326,0x9f4b02d7,0x9f590079,0x5f94027a}},	//   _ombe, nocé_, omsú_, хият,
   {{0x9f420187,0x127b016b,0x442c0327,0x62820328}},	//   roká_, _לאדע, _ktd_, _isoo,
   {{0x9f42024e,0x7d0700f7,0x6b860329,0x00000000}},	//   soká_, déré, _bakg, --,
   {{0x442c032a,0x69ce032b,0x00000000,0x00000000}},	//   _mtd_, _ambe, --, --,
   {{0x442c032c,0xdcf200ea,0x6b86032d,0x7d07000d}},	// [170] _ltd_, īgāk, _dakg, féré,
   {{0xceb202b5,0x6e2d032e,0x64480124,0x7d0700a2}},	//   _סיי_, _itab, _ovdi, géré,
   {{0xd7fb032f,0xa3be0035,0xf1b30070,0x442c00cc}},	//   буд_, ीफा_, עסע_, _ntd_,
   {{0x69ce0330,0x256f00d0,0x62820331,0x68f50097}},	//   _embe, zılı_, _osoo, _vyzd,
   {{0xd2460332,0x442c0333,0x644802c6,0x256f01d6}},	//   _جن_, _atd_, _avdi, yılı_,
   {{0xcb120052,0x79e7006c,0x9f920334,0x68f500a0}},	//   _שלך_, _روزہ_, vší_, _tyzd,
   {{0x62820335,0xa5060336,0x442c0337,0x24090338}},	//   _asoo, меша_, _ctd_, онки_,
   {{0x442c01e0,0x9f9201c0,0xc2e60083,0x6e2d001c}},	//   _dtd_, tší_, খেছি_, _otab,
   {{0x6e2d0232,0x2a690339,0xd76600b5,0x67290069}},	//   _ntab, ntab_, _تنقی, _ifej,
   {{0x9f92033a,0xab5b033b,0x442c033c,0x00000000}},	//   rší_, _flüg, _ftd_, --,
   {{0xd3710082,0x6e2d033d,0x256f033e,0x6282018e}},	//   _لها_, _atab, rılı_, _esoo,
   {{0x2a69033f,0x9f92033a,0x67290024,0x7987021e}},	//   ktab_, pší_, _jfej, _lajw,
   {{0x6e2d009e,0xee370340,0xc61f0033,0x63ab0341}},	//   _ctab, мня_, নীরা_, _iogn,
   {{0x7987006a,0x6e2d0037,0x6b860342,0x63ab0343}},	//   _najw, _dtab, _sakg, _hogn,
   {{0x6e2d0344,0x98ba013a,0x2c8700b8,0x6b860345}},	//   _etab, kapā_, vídá_, _pakg,
   {{0xeb970346,0x67290024,0x31b20160,0x00000000}},	//   мис_, _nfej, _râzi_, --,
   {{0x63ab0347,0xf1e100b4,0x63a6022a,0x7d070348}},	// [180] _mogn, _पदान, ökni, téré,
   {{0x63ab0349,0x00000000,0x00000000,0x00000000}},	//   _logn, --, --, --,
   {{0x7649000d,0x2d9a0183,0x98b8034a,0xe786034b}},	//   _avey, _inpe_, _terč_, дуло,
   {{0x2a69034c,0xb7be0033,0x442c034d,0x63ab0298}},	//   btab_, েক্ট, _rtd_, _nogn,
   {{0x4cd300c8,0x442c034e,0x7d07000d,0x473301e0}},	//   _দুপু, _std_, péré, тніс,
   {{0x69ce034f,0x63ab009e,0x00000000,0x00000000}},	//   _umbe, _aogn, --, --,
   {{0x63ab0350,0x76490107,0xb8f30033,0x442c021d}},	//   _bogn, _evey, _হু_, _qtd_,
   {{0x63ab0351,0x00000000,0x00000000,0x00000000}},	//   _cogn, --, --, --,
   {{0x9f550093,0x05660352,0x63ab0353,0xe7bd0354}},	//   ófíl_, _ован, _dogn, ्फरप,
   {{0x26c602d7,0x60280355,0xea9b016b,0x00000000}},	//   mzoo_, _němc, קסיש, --,
   {{0x39570052,0x63ab0356,0x195700a5,0x2c1a021a}},	//   ושים_, _fogn, וביל_, _मंगू_,
   {{0xe29a01c8,0x62820189,0x26c6006d,0x63ab0036}},	//   _мае_, _tsoo, ozoo_, _gogn,
   {{0xdde20124,0x25ac00fe,0x00000000,0x00000000}},	//   _šušk, _kodl_, --, --,
   {{0xe0cf0357,0x63ab0358,0x00000000,0x00000000}},	//   ازی_, _zogn, --, --,
   {{0xdb06006c,0x79870260,0x00000000,0x00000000}},	//   _elkü, _rajw, --, --,
   {{0x3eae0031,0x2d9a0359,0x2cac01ff,0x6e2d018e}},	//   ëjtë_, _enpe_, ädda_, _ttab,
   {{0x6e2d035a,0x26c601e8,0x27ef035b,0xdd95010b}},	// [190] _utab, jzoo_, vogn_, _запы,
   {{0x2a69035c,0x00000000,0x00000000,0x00000000}},	//   rtab_, --, --, --,
   {{0x2a690006,0x22510035,0x917b00e2,0x00000000}},	//   stab_, ązki_, _hệ_, --,
   {{0x2a690359,0x25ac0176,0xaad0035d,0x00000000}},	//   ptab_, _aodl_, _सेवक, --,
   {{0xcb36035e,0x7987035f,0x1fc10083,0x63ab0360}},	//   _ראשי_, _tajw, _উদাস, _rogn,
   {{0x63ab0361,0xd7c900e0,0x65940362,0x00000000}},	//   _sogn, _کوره_, качу, --,
   {{0x63ab0363,0x00000000,0x00000000,0x00000000}},	//   _pogn, --, --, --,
   {{0x26c601e8,0x00000000,0x00000000,0x00000000}},	//   bzoo_, --, --, --,
   {{0xd24e017e,0x645c0364,0x63ab01b4,0x7bdf00f6}},	//   مني_, _årin, _vogn, inqu,
   {{0x63ab0051,0xe5070365,0x00000000,0x00000000}},	//   _wogn, _قباي, --, --,
   {{0x67240366,0x63ab0367,0xe0d600af,0x00000000}},	//   žije, _togn, евэ_, --,
   {{0x8fa60368,0xd9cc0253,0x93bc0160,0x00000000}},	//   хаме, _ाष्ट, _stăv, --,
   {{0xe2990369,0xf1a801cb,0x00000000,0x00000000}},	//   _хал_, سایه_, --, --,
   {{0x92c1036a,0xdd92036b,0xc0e5036c,0x7bdf036d}},	//   ığın, دوس_, _полк, enqu,
   {{0xfce3036e,0xddcd002d,0x61e600b5,0xeb9a036f}},	//   горо, _spaţ, ékle, пив_,
   {{0xa2d40302,0x7a160260,0x00000000,0x00000000}},	//   _बेड्, _pņto, --, --,
   {{0xf41202b5,0xdbdd008d,0x39560370,0x6e930037}},	// [1a0] רפן_, ráðs, ењет, _مليا,
   {{0xac860370,0x6f040371,0x26c6006d,0xdcfe00af}},	//   _згол, _izic, vzoo_, _capă,
   {{0xc17200a5,0xa81a0372,0x2fc001ed,0x68e700f6}},	//   רחב_, ستار_, _klig_, _cxjd,
   {{0xfaa60373,0xe6660374,0x00000000,0x00000000}},	//   _замо, етко, --, --,
   {{0x98ac0095,0x7bd600e0,0x25ac0375,0x00000000}},	//   ğlıq_, miyu, _podl_, --,
   {{0xe5a30376,0x98ac0095,0x7bd60088,0x2fc00176}},	//   личи, şlıq_, liyu, _llig_,
   {{0x26c6006d,0x6c7a016b,0x00000000,0x00000000}},	//   szoo_, לאַפ, --, --,
   {{0x7bd60371,0x00000000,0x00000000,0x00000000}},	//   niyu, --, --, --,
   {{0x66e30377,0x6f040371,0x00000000,0x00000000}},	//   _бота, _nzic, --, --,
   {{0xb5ca0332,0xbbad0378,0x64a60379,0xef1f037a}},	//   _عوام_, _टक्क, _паза, rdüm_,
   {{0xdb12008a,0x9f35004b,0x6f04037b,0x3f890176}},	//   _ágæt, кені, _azic, _paau_,
   {{0x09dd01d1,0x00000000,0x00000000,0x00000000}},	//   _मद्य, --, --, --,
   {{0x661a037c,0x644a037d,0xddcd004b,0x2c1a021a}},	//   _kitk, lsfi, _apaš, _मंजू_,
   {{0x9f4b01c0,0x661a037e,0x443e0088,0x2fc0008c}},	//   mocí_, _jitk, _kwt_, _elig_,
   {{0x661a037f,0xf1a90088,0xb3a40380,0x6f040381}},	//   _mitk, _تانه_, _खचाख, _ezic,
   {{0x7bdf0382,0x7bc40383,0x7b6400af,0xd138010b}},	//   unqu, ghiu, лтуе, lbą_,
   {{0x66d3006c,0x9f4b00de,0x6d5a0079,0x5b150384}},	// [1b0] _műkö, nocí_, ótac, тмат,
   {{0x661a0385,0xd8e70044,0x317e033b,0x00000000}},	//   _nitk, нцеп, netz_, --,
   {{0x20090028,0x6d470386,0xa3c00387,0x201b00a2}},	//   _khai_, maja, ँसा_, _épis_,
   {{0x6d470388,0x2009006d,0x7bc40389,0x661a009e}},	//   laja, _jhai_, chiu, _aitk,
   {{0x661a038a,0x6b9d02c9,0x6b8d038b,0x644a01ef}},	//   _bitk, _insg, mdag, esfi,
   {{0xb90700c8,0x6d47038c,0x6b8d038d,0x661a00ec}},	//   _পর_, naja, ldag, _citk,
   {{0xab5b02c9,0x644a038e,0x80d00033,0x443e038f}},	//   _glüc, gsfi, _সুস্, _cwt_,
   {{0xe2990390,0x69d70391,0x6d4702c6,0x443e0298}},	//   даи_, lixe, haja, _dwt_,
   {{0xdb0f0392,0x661a0393,0x443e00d5,0x64580328}},	//   _alcú, _fitk, _ewt_, arvi,
   {{0x6d470394,0x27fd00e9,0x2fc0009e,0x93bc0395}},	//   jaja, llwn_, _slig_, _stăt,
   {{0x2fc001a9,0x6d470396,0xf9920397,0x6b8d0398}},	//   _plig_, daja, ברי_, kdag,
   {{0x20090399,0x6b8d02a2,0x69d701b7,0x00000000}},	//   _chai_, jdag, hixe, --,
   {{0x63a9039a,0x93b60052,0x6b8d039b,0xddcd0254}},	//   mjen, _שלנו_, ddag, _spaš,
   {{0x63a9039c,0x6d47039d,0x7bd60010,0xfce6039e}},	//   ljen, gaja, wiyu, вого,
   {{0xdc670369,0x69d7039f,0x22510035,0x7bd60371}},	//   кард_, dixe, ązku_, tiyu,
   {{0x63a903a0,0x63bb03a1,0x6b8d03a2,0xa00a0037}},	//   njen, nkun, gdag, _تقبل_,
   {{0x6d470083,0x4b2300d4,0x63bb03a3,0x6f0403a4}},	// [1c0] baja, рмув, ikun, _uzic,
   {{0x6d4703a5,0x63a903a6,0x91d40084,0x765900e9}},	//   caja, hjen, योपै, drwy,
   {{0x63bb03a7,0x661a03a8,0x63a903a9,0x00000000}},	//   kkun, _ritk, kjen, --,
   {{0x6e240054,0x661a03aa,0x63bb03ab,0xe73a0009}},	//   _kuib, _sitk, jkun, фед_,
   {{0x63a903ac,0x661a03ad,0x76590297,0x63bb03ae}},	//   djen, _pitk, grwy, dkun,
   {{0x69c503af,0x645803b0,0xd49a03b1,0x9866006c}},	//   chhe, trvi, дри_, _لیئے_,
   {{0x18a303b2,0x98a30369,0x2cb8009e,0x63bb03b3}},	//   _карм, _кире, nyrd_, fkun,
   {{0x63a903b4,0x63bb03b5,0x61e103b6,0x6d4703b7}},	//   gjen, gkun, enll, zaja,
   {{0xfbd30052,0x20090297,0x661a03b8,0x6d47002f}},	//   יתה_, _rhai_, _titk, yaja,
   {{0xa3f5000c,0x661a0136,0x6b8d00fd,0x200903b9}},	//   ější_, _uitk, zdag, _shai_,
   {{0x6d4703ba,0x63a903bb,0xd13800d8,0x6b8d03bc}},	//   vaja, bjen, rbą_, ydag,
   {{0x63a903bd,0x317e01ae,0x63bb02c9,0x225f03be}},	//   cjen, setz_, ckun, buuk_,
   {{0x6d4703bf,0x6e2403c0,0x6b8d03c1,0x00000000}},	//   taja, _cuib, vdag, --,
   {{0x6e24006b,0x69d703c2,0xbf9b0345,0x00000000}},	//   _duib, xixe, dlêe, --,
   {{0x6d4703c3,0x6b8d03c4,0x80a303c5,0x4fc703c6}},	//   raja, tdag, _نمون, _аспа,
   {{0x5f7703c7,0x6d4703c8,0x20090054,0x8bc4004b}},	//   _شاعر, saja, _uhai_, асуд,
   {{0x6d4703c9,0xf96b03ca,0x2a6000d7,0x6e2400f6}},	// [1d0] paja, дрей_, guib_, _guib,
   {{0x63bb03cb,0x6b8d03cc,0x63a9035f,0x68fc03cd}},	//   zkun, sdag, zjen, _byrd,
   {{0x3eb903ce,0x63bb0282,0x69d703cf,0xa2d4035d}},	//   lyst_, ykun, rixe, _बेस्,
   {{0x7659001e,0x69c50031,0xe115016b,0x321c03d0}},	//   trwy, shhe, אַנז_, _livy_,
   {{0x6d4503d1,0x63a903d2,0xe78403d3,0x61e100e9}},	//   _keha, vjen, рухо, ynll,
   {{0xa93403d4,0x6d4503d5,0xa50903d6,0xe61801e0}},	//   _верш, _jeha, нела_, вді_,
   {{0x7afd03d7,0x63a903d8,0x63bb03d9,0x765900e9}},	//   _hyst, tjen, tkun, srwy,
   {{0x7c2503da,0x6d45026b,0x7afd03db,0x93bc00af}},	//   _muhr, _leha, _kyst, _stăr,
   {{0x63a903dc,0x63bb03dd,0x59b703de,0x7afd008c}},	//   rjen, rkun, _आकार, _jyst,
   {{0x63bb03df,0x004700b5,0x6d4503e0,0x63a903e1}},	//   skun, نیتي_, _neha, sjen,
   {{0x1c1f03e2,0x63a903e3,0x7afd03e4,0x046703e5}},	//   _मंगल_, pjen, _lyst, _штам,
   {{0xdb0f03e6,0x44250043,0xc43a02b8,0xdb0603e7}},	//   _você, _iul_, _נתני, _ilkö,
   {{0x442503e8,0x6d4503e9,0x7afd03ea,0x69d50120}},	//   _hul_, _beha, _nyst, _omze,
   {{0x442503eb,0x614503e6,0x4ed501e0,0x425203ec}},	//   _kul_, _сека, рюют, _انور,
   {{0x442503ed,0x30790070,0x00000000,0x00000000}},	//   _jul_, _טאַנ, --, --,
   {{0x7afd03ee,0x44250006,0x69d50160,0x7dd40095}},	//   _byst, _mul_, _amze, _müsə,
   {{0x7afd03ef,0xdcfc024e,0x442503f0,0x6fc601ef}},	// [1e0] _cyst, merč, _lul_, _cóce,
   {{0x6d4502c0,0x7afd03f1,0x3f8203f2,0x442503f3}},	//   _geha, _dyst, leku_, _oul_,
   {{0xdb06024e,0x7afd03f4,0x31ba02b5,0xdcf800b5}},	//   _doká, _eyst, עזענ, _شہرت_,
   {{0x6d450291,0x224d01d6,0x46ea03f5,0x3f8203f6}},	//   _zeha, ksek_, нден_, neku_,
   {{0x7f3b02b5,0x7c25028b,0x7afd00e9,0x68fc00e9}},	//   גענו, _zuhr, _gyst, _wyrd,
   {{0x442503f7,0x659403f8,0x3861012f,0xd5b10019}},	//   _bul_, раку, buhr_, _có_,
   {{0x442503f9,0xd46703fa,0xe56f03fb,0x888403fc}},	//   _cul_, гије_, سطو_, _خیان,
   {{0x44250082,0x3f8203fd,0x539803fe,0x93b4002d}},	//   _dul_, jeku_, твия_, рбиц,
   {{0x798e03ff,0xbebb0031,0x6441003c,0x44250400}},	//   _kabw, ncët, _ewli, _eul_,
   {{0x44250401,0x60210029,0xc05a0402,0xdb0f0310}},	//   _ful_, _lēmu, нім_, _docè,
   {{0x44250403,0x798e0404,0x09f700a5,0xdfd10405}},	//   _gul_, _mabw, רמים_, قيد_,
   {{0x6d450406,0x7c25033b,0xddc40024,0x98b8010b}},	//   _seha, _ruhr, _epiż, _gerą_,
   {{0x44250407,0x6d45011c,0x7c250408,0xb5fd0409}},	//   _zul_, _peha, _suhr, _apšy,
   {{0xbb1b0248,0x798e018c,0x7afd040a,0xeb9f01e0}},	//   _maît, _nabw, _ryst, _snø_,
   {{0x6d450060,0x3ebf040b,0x3f82040c,0x48bf0033}},	//   _veha, šut_, beku_, _আশ্র,
   {{0xc4c4040d,0x7afd0086,0x246e0095,0x798e0103}},	//   _ہے_, _pyst, _cəmi_, _aabw,
   {{0x6d45007c,0x2d85000d,0x798e018c,0xdb0600ac}},	// [1f0] _teha, ôles_, _babw, _poká,
   {{0x7afd040e,0xdcf500ea,0x00000000,0x00000000}},	//   _vyst, udzē, --, --,
   {{0x7afd006a,0x2d830232,0xdb06040f,0xd7c800f8}},	//   _wyst, meje_, _voká, گونه_,
   {{0x2d830410,0x31e100a1,0x7afd0411,0xe719004f}},	//   leje_, _पद्ध, _tyst, نيات_,
   {{0x44250412,0xd7c80413,0x98aa00ea,0xa2d400df}},	//   _sul_, دونه_, ējām_, _बेल्,
   {{0x44250095,0x2d830414,0x2d910415,0xf4830416}},	//   _pul_, neje_, ndze_, ماعی,
   {{0x44250417,0x00000000,0x00000000,0x00000000}},	//   _qul_, --, --, --,
   {{0x44250244,0xdb1d0093,0xbb1b000d,0x2d830418}},	//   _vul_, _umsó, _faît, heje_,
   {{0x6b8f0419,0x3f82041a,0x290c004f,0x798e041b}},	//   _macg, veku_, _údar_, _yabw,
   {{0x2d83041c,0x4425041d,0x224d041e,0x41b502fb}},	//   jeje_, _tul_, rsek_, рсит,
   {{0x3f8202f6,0x2d83041f,0x66ca00b5,0x224d0420}},	//   teku_, deje_, _töké, ssek_,
   {{0xe0d602fb,0x52d90421,0x00000000,0x00000000}},	//   рвю_, _имею_, --, --,
   {{0x2bc900be,0x00000000,0x00000000,0x00000000}},	//   रसना, --, --, --,
   {{0x628b0090,0x3f820422,0x6cc6005f,0x2d8301d5}},	//   _isgo, seku_, айга, geje_,
   {{0x8c460268,0xdd0e027d,0x3f820207,0x93bc0139}},	//   ребе, _dışa, peku_, _ouăl,
   {{0xc0520122,0x798e0008,0xb7b00033,0x00000000}},	//   _וזה_, _sabw, _কষ্ট, --,
   {{0xeab70423,0x09c10083,0x39460424,0x2d830425}},	// [200] айт_, োচনা, инаг, beje_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdca60426,0x798e0103,0xc8ca0427,0xdb0401ed}},	//   _тани, _vabw, خوان_, rkiñ,
   {{0x628b00e9,0x798e0428,0x00000000,0x00000000}},	//   _osgo, _wabw, --, --,
   {{0xb8fd0429,0x23a902e4,0x6724042a,0x6b840093}},	//   _ते_, कानद, žijo, meig,
   {{0x6b84042b,0xb866042c,0x00000000,0x00000000}},	//   leig, _پاسو, --, --,
   {{0x26c0042d,0x92e200c8,0x292701ba,0x628b0176}},	//   šio_, _ধরে_, ávať_, _asgo,
   {{0x6b84042e,0x0fc10083,0x290a042f,0x87f900af}},	//   neig, _উদ্ধ, _izba_, _бэут_,
   {{0xa3c70299,0x27e60430,0xc1a60431,0xe61a0432}},	//   _उतर_, mnon_, ајни, _ада_,
   {{0xda160433,0xddd6005f,0x629900e5,0x00000000}},	//   थगित_, _asyž, _drwo, --,
   {{0x628b0434,0xc953011d,0x2d830435,0x5f9500af}},	//   _esgo, חמת_, veje_, бинт,
   {{0x27e60436,0xa3d20437,0x78a1008d,0x00000000}},	//   nnon_, होश_, _álve, --,
   {{0x63a20438,0x91e60439,0x2d83043a,0x5f940133}},	//   _inon, _коде, teje_, цият,
   {{0x7bc603ad,0xa3d2043b,0x63a201ba,0xdcfe00ee}},	//   _alku, होर_, _hnon, _dopľ,
   {{0x2d83043c,0xf2e80033,0x705400b2,0x63a20107}},	//   reje_, _পরিণ, _انبا, _knon,
   {{0x628b02c7,0xe45702b5,0x248c012f,0x2ba403e6}},	//   _ysgo, יילט_, _msdm_, ојув,
   {{0x27e6043d,0x2905043e,0x2d8300d5,0x2b1a021a}},	// [210] dnon_, _šla_, peje_, _मृदु_,
   {{0x3947043f,0x780f0440,0x2d830031,0x00000000}},	//   úns_, िष्क_, qeje_, --,
   {{0x6b8400ea,0x63a20441,0x6d5700a8,0xbef8042c}},	//   beig, _onon, _idxa, _مریض_,
   {{0x27e60442,0x20140443,0xdc9a0070,0x7d0800be}},	//   gnon_, _èxit_, _עירל, üdse,
   {{0xc9870043,0xb7bd0160,0x00000000,0x00000000}},	//   _куви, _niţe, --, --,
   {{0x63a20444,0x7c94042c,0x6833009f,0xdcfe00b8}},	//   _anon, _اشیا, _aħde, _napě,
   {{0x057400d1,0x27e6011e,0x97a70265,0x79850159}},	//   تاند, bnon_, _крал, mehw,
   {{0xab5b00ab,0xdcfc00ea,0xc24501e0,0x69c700cd}},	//   _olüm, nerā, бник, _hlje,
   {{0xe730006c,0x77050118,0xe1f90445,0xdd2c00d8}},	//   _آصف_, _اژان, лги_, vėži,
   {{0x6b840446,0x63a20447,0x7dc200ee,0x00000000}},	//   zeig, _enon, _rôso, --,
   {{0x69c7003a,0xf076006c,0x7dc201ba,0xab5b0448}},	//   _mlje, میوں_, _dôsl, _alüm,
   {{0x7dc2016f,0x6d5701dd,0x63a200ee,0x9f420097}},	//   _pôso, _adxa, _gnon, boký_,
   {{0x6fc60037,0x69c70449,0xdcfc00ea,0x6b84003e}},	//   _cóca, _olje, derā, veig,
   {{0x6b84044a,0xb6da0070,0x6feb0067,0xa2c4021a}},	//   weig, אַלט, ręca, िनर्,
   {{0x6b84044b,0x7d090355,0x27e6044c,0xacea01fd}},	//   teig, řesn, ynon_, умва_,
   {{0xdcfe00a0,0x6fc60079,0x00000000,0x00000000}},	//   _topľ, _fóca, --, --,
   {{0x69c7044d,0x6b84044e,0x7f3b0070,0x27e60124}},	// [220] _blje, reig, _געפו, vnon_,
   {{0x6b84044f,0x5d86004f,0x3f920118,0x7e660450}},	//   seig, _الدل, _hayu_, mukp,
   {{0x6d4e0451,0x3f920452,0x6fc60453,0x291c0454}},	//   maba, _kayu_, _zóca, äva_,
   {{0x6d4e0455,0x7bc6023a,0x00000000,0x00000000}},	//   laba, _ulku, --, --,
   {{0x3f92030d,0xa3ab0456,0x7e660159,0xdd070457}},	//   _mayu_, खान_, nukp, _köşk,
   {{0x6d4e0458,0x225f0459,0x27e6045a,0x3f92045b}},	//   naba, druk_, snon_, _layu_,
   {{0x2bbf045c,0x69de045d,0xef1f045e,0x6d4e0042}},	//   _एकमा, mipe, ndür_, iaba,
   {{0x69de045f,0x6d4e0460,0xa8570122,0xa3d20461}},	//   lipe, haba, _לילה_, हों_,
   {{0x6d4e0462,0x7dcb0463,0xaade00a1,0xe64303e6}},	//   kaba, _hüse, _नेमक, _нетп,
   {{0x6d4e0464,0x8c000083,0x69de0465,0x9f420187}},	//   jaba, ্দিন_, nipe, roký_,
   {{0x64a30466,0x6d4e0467,0x9f420187,0x672d0121}},	//   _нафа, daba, soký_, žaje,
   {{0x69de002d,0x63a20468,0x225f0469,0x443c01ef}},	//   hipe, _unon, bruk_, mpv_,
   {{0x3f92046a,0x394a046b,0x2bbf046c,0x06bc0033}},	//   _dayu_, _oebs_, _एकबा, _আইডি,
   {{0x6d4e046d,0x7de703d0,0x30a6046e,0xea010023}},	//   gaba, сімд, _грив, _đắp_,
   {{0x61fa0176,0x69de046f,0x2a6000ab,0x6ae1022e}},	//   motl, dipe, erib_, पप्र,
   {{0x69c70470,0x61fa0471,0xa3ab00ab,0x6fc6002a}},	//   _slje, lotl, खाय_, _tóca,
   {{0x6d4e0472,0x69c70254,0x8d8700af,0x59d900d8}},	// [230] baba, _plje, _лунд, адаў_,
   {{0x6d4e0473,0x61fa0474,0x6f0d0475,0x7f4f027a}},	//   caba, notl, _izac, lacq,
   {{0x2fc90476,0x61e80477,0x69c70478,0x6d41027b}},	//   _klag_, indl, _vlje, ılad,
   {{0x1da7009a,0x61fa0479,0x7f4f0036,0x2d9301ed}},	//   खावत, hotl, nacq, _haxe_,
   {{0x7bdf047a,0x7bcd047b,0x61fa03e0,0x00000000}},	//   miqu, mhau, kotl, --,
   {{0x7bdf047c,0x69c7047d,0x69de047e,0x61e80009}},	//   liqu, _ulje, cipe, jndl,
   {{0xddcc00d8,0x99650355,0x00000000,0x00000000}},	//   _žiūr, _kůži_, --, --,
   {{0x7bdf047f,0xe3b90480,0x6d4e0481,0x7bcd0482}},	//   niqu, рби_, zaba, nhau,
   {{0x6603016f,0x6d4e0483,0x27ff0484,0x7dcb00a8}},	//   plnk, yaba, _ikun_, _müsb,
   {{0x6d4e0485,0x2fc90486,0x7bdf00f7,0x3f920487}},	//   xaba, _alag_, hiqu, _sayu_,
   {{0x2fc90488,0x6d4e0489,0x3f92048a,0xe10900af}},	//   _blag_, vaba, _payu_, ренд_,
   {{0x6d4e048b,0x27ff048c,0x69de048d,0x225f01cb}},	//   waba, _jkun_, zipe, pruk_,
   {{0x7bdf048e,0x61fa048f,0xf8a60099,0x2d930490}},	//   diqu, botl, _गप्प, _baxe_,
   {{0x61fa01da,0xdb0f01ef,0x3f920118,0x27ed0207}},	//   cotl, _cocí, _wayu_, _ljen_,
   {{0x6d4e0491,0x7bdf0492,0x2b4b00d7,0xcfaa0493}},	//   raba, fiqu, _becc_, _ناظم_,
   {{0x6d4e0494,0x7bdf0495,0x27ed0496,0x6d41003e}},	//   saba, giqu, _njen_, ðlar,
   {{0xe9da0497,0x6d4e0498,0xed5a0499,0x2d93049a}},	// [240] ака_, paba, _коп_, _faxe_,
   {{0x6d4e013b,0x27ff049b,0x27ed0118,0x84e9049c}},	//   qaba, _akun_, _ajen_, टपाट_,
   {{0x088a00af,0x7bcd049d,0x69de049e,0xe8f7049f}},	//   рбей_, bhau, ripe, олф_,
   {{0x394a04a0,0xeb9a04a1,0x7bcd04a2,0x290301f4}},	//   _webs_, _тим_, chau, _dyja_,
   {{0x61fa0381,0x363304a3,0x2bbf00b8,0x00000000}},	//   yotl, وروس, _एकता, --,
   {{0x69de01d2,0x27ed04a4,0x3a230051,0xfc4b0355}},	//   qipe, _ejen_, _gijp_, říž_,
   {{0x69dc004f,0xab5b02b1,0x60280355,0x4ade00ab}},	//   _imre, _blüh, _těmi, _नेतव,
   {{0x78a104a5,0xa3ba004f,0x6b9604a6,0x27ed04a7}},	//   _álva, شاعر_, ndyg, _gjen_,
   {{0xa3db030f,0x61fa04a8,0x6f0404a9,0xaabc04aa}},	//   _डगर_, totl, _nyic, ोनिक,
   {{0x61e801ae,0x00000000,0x00000000,0x00000000}},	//   undl, --, --, --,
   {{0xeb070299,0x2fc904ab,0xdb0f04ac,0x399b0070}},	//   _शर्त_, _plag_, _rocí, בייד,
   {{0x932500bf,0x32050122,0x7bdf0248,0xea010019}},	//   _فرهن, ally_, xiqu, _đập_,
   {{0x7bcd04ad,0x7bdf04ae,0x6b96001e,0x69dc04af}},	//   vhau, viqu, ddyg, _omre,
   {{0x442c0478,0x72e902b5,0x7f4f0036,0x20000103}},	//   _kud_, _פֿײַ, sacq, _ekii_,
   {{0x7bdf04b0,0x442c002d,0x7bcd04b1,0x3a230223}},	//   tiqu, _jud_, thau, _rijp_,
   {{0x5a3504b2,0x69dc04b3,0x3ea60009,0x7bcd04b4}},	//   знат, _amre, _šote_, uhau,
   {{0x7bdf04b5,0x7bcd04b6,0x442c04b7,0x2d9304b8}},	// [250] riqu, rhau, _lud_, _taxe_,
   {{0x7bdf04b9,0x7bcd04ba,0x442c0136,0x6833007a}},	//   siqu, shau, _oud_, _aħda,
   {{0x6e2d01e8,0x7bdf04bb,0x20ca04bc,0x442c04bd}},	//   _huab, piqu, ानिध, _nud_,
   {{0x6e2d04be,0x69dc0225,0x62820118,0x00000000}},	//   _kuab, _emre, _opoo, --,
   {{0x27ed00da,0xf7700180,0xd6db04bf,0x442c04c0}},	//   _vjen_, ضان_, јте_, _aud_,
   {{0x442c04c1,0x6e2d04c2,0x20ca04aa,0xdcf50228}},	//   _bud_, _muab, ानाध, jdzī,
   {{0x27ff048c,0xddcd04c3,0xd838004b,0xc44700b5}},	//   _tkun_, _opaž, _мэт_, زیشن_,
   {{0x442c04c4,0x69c504c5,0x6fc601ef,0x799504c6}},	//   _dud_, lkhe, _cócl, _hazw,
   {{0x79950371,0x644804c7,0x442c04c8,0x67290371}},	//   _kazw, _ewdi, _eud_, _igej,
   {{0x442c004f,0x69c504c9,0xdb0601ba,0x5bb80266}},	//   _fud_, nkhe, _pokú, _इक्व,
   {{0x442c04ca,0x2a690189,0x6e2d009e,0x7bc4010b}},	//   _gud_, huab_, _auab, ykiu,
   {{0x7649018e,0x60330139,0x6e2d026e,0x00000000}},	//   _kwey, _căma, _buab, --,
   {{0x6e2d04cb,0x46bd04cc,0xd1bb04cd,0x6729034d}},	//   _cuab, ्निह, _پاشا_, _mgej,
   {{0x7995006a,0x69c504ce,0x6e2d022e,0x442c011e}},	//   _nazw, jkhe, _duab, _yud_,
   {{0x61e104cf,0xdca300ca,0x7649001c,0xc18300fd}},	//   mill, нари, _lwey, _فیکٹ,
   {{0x61e104d0,0x69dc04d1,0x672900f8,0x60d600a5}},	//   lill, _smre, _ngej, _מוצא_,
   {{0x61e104d2,0x3c1900d8,0x49ca02c4,0x27fd04d3}},	// [260] oill, іўся_, блан_, down_,
   {{0x6d4104d4,0x63b90069,0xa96a0037,0x61e104d5}},	//   ılac, _lown, إمام_, nill,
   {{0x7649034d,0x799502b1,0x2d8a0176,0x00000000}},	//   _awey, _dazw, mebe_, --,
   {{0x442c04d6,0x3ea00009,0x2d9804d7,0x764901a8}},	//   _rud_, _krit_, ldre_, _bwey,
   {{0x61e104d8,0xc6150083,0x2a690221,0x659404d9}},	//   kill, াদনা_, cuab_, далу,
   {{0x2d9804da,0x61e104db,0x67290009,0x442c04dc}},	//   ndre_, jill, _egej, _pud_,
   {{0x628204dd,0xf74604de,0xb4c6000c,0x7c2604df}},	//   _spoo, _нево, उने_, _kikr,
   {{0x7dcb01c2,0x9f590248,0x442c04e0,0x2d8a04e1}},	//   _müsa, posé_, _vud_, hebe_,
   {{0x63b904e2,0x61e104e3,0xe3af0037,0xf1aa0286}},	//   _down, fill, ارى_, ماده_,
   {{0x442c04e4,0xa63b011d,0x2d8a0124,0xdcf500ea}},	//   _tud_, _לגמר, jebe_, udzī,
   {{0xdcf50080,0x442c04e5,0x03260217,0x60330160}},	//   rdzī, _uud_, _еден, _păma,
   {{0x61e104e6,0x7c260069,0x00000000,0x00000000}},	//   aill, _nikr, --, --,
   {{0x71a604e7,0x1ee704e8,0x539b00a5,0x23a904e9}},	//   _надз, سوسی_, _ליאו, कारद,
   {{0x61e104ea,0x57b904eb,0x442604ec,0x3ea004ed}},	//   cill, _आव्ह, _hio_, _drit_,
   {{0x3ea004ee,0x48dc04ef,0x7c2604f0,0x717b00a5}},	//   _erit_, _गेलो_, _bikr, _הנוס,
   {{0xcf27004f,0x2d980382,0x6e2d04f1,0x3ea004f2}},	//   _عربي, adre_, _tuab, _frit_,
   {{0x442604f3,0x3ea004f4,0x2d8a04f5,0x7c2604f6}},	// [270] _mio_, _grit_, bebe_, _dikr,
   {{0x2d8a03e6,0xfbd000b5,0x6ff200ec,0x764904f7}},	//   cebe_, پتہ_, māca, _rwey,
   {{0x7c2604f8,0x2a69006f,0x2d810211,0x00000000}},	//   _fikr, suab_, _ibhe_, --,
   {{0x61e104f9,0x442604fa,0xc794010b,0x7c2604fb}},	//   zill, _nio_, ершы, _gikr,
   {{0x63b904fc,0x920c0324,0x61e104fd,0xcb9a00a5}},	//   _rown, हताज_, yill, _וסרט,
   {{0xd1260082,0x7c2604fe,0x06f400f8,0x601f04ff}},	//   _لم_, _zikr, رسنج, _dūmi,
   {{0x44260500,0xdb0602d0,0x6fc60079,0x3f8b0501}},	//   _bio_, _ankè, _sócm, kecu_,
   {{0x44260502,0x3f8b022f,0x2d8a0503,0x291102a7}},	//   _cio_, jecu_, zebe_, _izza_,
   {{0x61e10504,0x44260505,0x24890168,0x3f8b0506}},	//   till, _dio_, ňam_, decu_,
   {{0x61e10507,0x3ea00031,0x629b010b,0x7dd00508}},	//   uill, _rrit_, rvuo, _käse,
   {{0x61e10509,0x7dd003ad,0x4426050a,0x63b9050b}},	//   rill, _jäse, _fio_, _town,
   {{0x61e1050c,0x4426050d,0x60c1008c,0xdee6050e}},	//   sill, _gio_, rylm, доми,
   {{0x7dd0013c,0x2d8a050f,0x6fc601dd,0x9f420055}},	//   _läse, tebe_, _hóck, likë_,
   {{0x61e10510,0x44260511,0x7c260512,0xb4f90070}},	//   qill, _zio_, _sikr, ַפּי,
   {{0x2d980513,0x3b960370,0x2d8a0010,0x44260260}},	//   rdre_, мјат, rebe_, _yio_,
   {{0x6ff60514,0xea010019,0x2d8a0515,0x7dcb013b}},	//   _تستط, _đạp_, sebe_, _vüsa,
   {{0x7c2602d0,0x3b0701d3,0x29110516,0xfbdf0517}},	// [280] _vikr, дето_, _azza_, _नगरम,
   {{0x7c26022e,0xc9860037,0x00000000,0x00000000}},	//   _wikr, بشري, --, --,
   {{0x8cb50518,0x7c2601c8,0xdb0f0519,0x19b9051a}},	//   _उपयो, _tikr, _vocá, чуть_,
   {{0x6aa90009,0x672d011c,0xb0b60070,0xf0b6016b}},	//   _šefe, žajn, ופעס_, ולער_,
   {{0x4426051b,0xdb0f0138,0x2911030d,0x12e80033}},	//   _rio_, _tocá, _ezza_, _পর্দ,
   {{0x4426000e,0xe5a3002d,0xb7bd0139,0x60330139}},	//   _sio_, кичи, _fiţo, _nămo,
   {{0x69ce051c,0xd497021f,0x52b8051d,0xe5a30200}},	//   _ilbe, дры_, ेन्स, тији,
   {{0x29180067,0x00000000,0x00000000,0x00000000}},	//   ągać_, --, --, --,
   {{0x8cb5051e,0x4426051f,0xdb0d003e,0x3f8b0520}},	//   _उपभो, _vio_, nkað, vecu_,
   {{0x7c3e0521,0xe29f008a,0x76420522,0x7dd00523}},	//   _otpr, æða_, mpoy, _läsb,
   {{0x44260524,0xf9930122,0xd36f0132,0x00000000}},	//   _tio_, דרת_, _ич_, --,
   {{0x443e0332,0x72c60525,0xdb0d0093,0x3ea60009}},	//   _itt_, _обез, kkað, _šota_,
   {{0x441b00c2,0x69ce0526,0x64580527,0xa3ab0084}},	//   _וואס, _olbe, lsvi, खार_,
   {{0x7ae90280,0x3f8b0528,0x443e0529,0x7c3e0036}},	//   _žeto, secu_, _ktt_, _btpr,
   {{0xc04f0210,0xc178010b,0x245a02d4,0xac19052a}},	//   _ші_, snės_, nīm_, зову_,
   {{0x7dd00282,0x5bc90099,0x645804d5,0x00000000}},	//   _räse, रसेव, isvi, --,
   {{0x6feb006a,0xbbbf052b,0x9f4201f4,0xda15052c}},	// [290] jęci, _एकीक, zikë_, едањ,
   {{0x443e052d,0x6277011d,0xc5f30033,0x00000000}},	//   _ott_, וגמא_, _চীনা_, --,
   {{0x443e052e,0x645e00ac,0xab5b033b,0xa3c0052f}},	//   _ntt_, ápil, _blüt, ुसा_,
   {{0x6d550530,0x69ce0531,0x64580532,0x7dd001ff}},	//   laza, _elbe, dsvi, _väse,
   {{0x443e0533,0x6fc6004f,0x645a02a7,0xb9060534}},	//   _att_, _dóch, _avti, _बे_,
   {{0x6d550535,0x443e0536,0x9f4200da,0xdcee010b}},	//   naza, _btt_, tikë_, gebė,
   {{0x26c90537,0xa3ab009a,0x64580538,0x443e0539}},	//   šao_, खाल_, gsvi, _ctt_,
   {{0x6d55053a,0x443e053b,0x9f4201f4,0xabcc0070}},	//   haza, _dtt_, rikë_, ַציִ,
   {{0x443e053c,0x644e0484,0x6016053d,0x6458053e}},	//   _ett_, _ħbie, náme, asvi,
   {{0xf1b1004f,0x443e0036,0x6b8d053f,0x765b007b}},	//   اءة_, _ftt_, heag, _ivuy,
   {{0x6d550540,0x14740079,0x672400b8,0x6b8d0541}},	//   daza, _لانج, žijt, keag,
   {{0x649a0122,0x64430542,0x00000000,0x00000000}},	//   _מסעד, mpni, --, --,
   {{0xe1ee01d3,0x7124006c,0x6d41037a,0x3f9e00b8}},	//   _бг_, ٹریل, ılan, ětu_,
   {{0x7bcf0543,0x6d550544,0x68330024,0x200b030a}},	//   _alcu, gaza, _aħdm, alci_,
   {{0xb0420028,0xafe60545,0x6b8d0211,0xdb860212}},	//   _trưở, _покл, feag, нгви,
   {{0x6b8d008c,0x00000000,0x00000000,0x00000000}},	//   geag, --, --, --,
   {{0xada60546,0x6d550547,0x20020548,0x00000000}},	// [2a0] _запл, baza, moki_, --,
   {{0xdb0d00fb,0x64580549,0x6d55054a,0x2002054b}},	//   rkað, ysvi, caza, loki_,
   {{0x7dcb00d0,0xdb0d008d,0x6b8d054c,0x2d9a0176}},	//   _müsl, skað, beag, _iape_,
   {{0x48c30083,0x6016054d,0x2ca5054e,0x2d9a054f}},	//   ্পূর, lámb, ælde_, _hape_,
   {{0x2d9a0550,0x443e0551,0x64580552,0x00000000}},	//   _kape_, _stt_, wsvi, --,
   {{0x20020553,0x63ab0554,0x64580555,0xab5b01ae}},	//   hoki_, _angn, tsvi, _flüs,
   {{0x2d9a0556,0x200201d7,0xa3ab00ab,0xc7b0006c}},	//   _mape_, koki_, खां_, _پڑا_,
   {{0x64580557,0x443e0558,0x9f5900de,0x2d9a0559}},	//   rsvi, _vtt_, tosí_, _lape_,
   {{0x6d55055a,0x6458055b,0x443e055c,0x9f4201cb}},	//   yaza, ssvi, _wtt_, ciké_,
   {{0x27e6055d,0x2d9a055e,0x6b8d01d7,0x6724055f}},	//   lion_, _nape_, zeag, žijs,
   {{0xc0570560,0x6d550561,0x443e00ea,0x20020562}},	//   нія_, vaza, _utt_, foki_,
   {{0x27e60563,0x6d550564,0x6b8d01a3,0x25be023a}},	//   nion_, waza, xeag, _hotl_,
   {{0x6d550565,0x15e40066,0x2d9a0566,0xf8ad0099}},	//   taza, _कगार_, _bape_, _टप्प,
   {{0xa19302c4,0x2bc90567,0x7d030568,0x5bc90569}},	//   _башч, रस्थ, _ønsk, रस्व,
   {{0x26ec056a,0x27e6056b,0x2002056c,0x6b8d056d}},	//   जपुर_, kion_, boki_, teag,
   {{0x27e6021e,0x6d5a056e,0x6d55056f,0xfc300037}},	//   jion_, ótar, saza, صحف_,
   {{0x27e60570,0x6b8d0571,0x49750572,0x99670573}},	// [2b0] dion_, reag, клас, етел,
   {{0x60160574,0x6b8d0575,0xab5b0576,0xd9fa0577}},	//   ráme, seag, _plüs, ्तगत_,
   {{0x4ddc0122,0x6fc603e6,0x27e6001e,0x7dd0033b}},	//   _מחזו, _sóci, fion_, _wäsc,
   {{0x27e60578,0x765900e9,0x7dc2021d,0xb8d900ab}},	//   gion_, tswy, _fôss, _अऊ_,
   {{0x7e7d0579,0x9f4b0453,0x05be021a,0x3f9b0024}},	//   ntsp, locó_, ्संब, _maqu_,
   {{0xd5bb057a,0x7e7d057b,0xeabf00e2,0xa2cf057c}},	//   ясе_, itsp, _ngùi_, धनस्,
   {{0x02c9057c,0x27e6001e,0xd90f03fc,0x52c9057c}},	//   िन्न, bion_, _ایا_, िन्स,
   {{0x27e6057d,0x6443057e,0x7e7d057f,0x7dcb027d}},	//   cion_, rpni, ktsp, _süsl,
   {{0x7dd0022a,0xa2830580,0x0ee00581,0x2a690582}},	//   _läsa, ایتو, _पेंड, nrab_,
   {{0x64430583,0x7e7d0584,0x00000000,0x00000000}},	//   ppni, dtsp, --, --,
   {{0x66030585,0x20020586,0xf076006c,0x7dd0017b}},	//   monk, toki_, نیوں_, _näsa,
   {{0xb4bf0587,0x7e7d0588,0x64410260,0x2d9a0589}},	//   ुनी_, ftsp, _itli, _sape_,
   {{0x2002058a,0x29c40523,0xbddb0176,0x00000000}},	//   roki_, _köat_, rpèn, --,
   {{0x27e6058b,0x212e0051,0xd65600a5,0x00000000}},	//   zion_, _ggfh_, כישת_, --,
   {{0x2d9a058c,0x7e7d058d,0x2002058e,0x1d07058f}},	//   _vape_, atsp, poki_, вери_,
   {{0x27e602e1,0x66030590,0x601601ef,0x2d9a023c}},	//   xion_, honk, sámb, _wape_,
   {{0xf1b50591,0x27e602ee,0x7e7d0223,0x501b00a5}},	// [2c0] _अचान, vion_, ctsp, _קופו,
   {{0xd9460592,0xdcfc0029,0x261600ab,0x24920067}},	//   тежи, ndrī, _पीढी_, łymi_,
   {{0x27e60593,0x8e3a0594,0x66030595,0xdb060035}},	//   tion_, _عسکر_, donk, _pokó,
   {{0x46ea0009,0x00000000,0x00000000,0x00000000}},	//   мден_, --, --, --,
   {{0x27e60596,0xa3ab0299,0x64410597,0x66030598}},	//   rion_, खाई_, _atli, fonk,
   {{0x27e60599,0x6603059a,0xd943059b,0xd64500b5}},	//   sion_, gonk, _вери, ائنٹ,
   {{0x27e6059c,0x65610036,0x09e3059d,0xe7f40099}},	//   pion_, _ddlh, _торн, ेकदा_,
   {{0x799c059e,0xdb1d0118,0xc27403e6,0x7bd6055c}},	//   _harw, _bosè, глиј, nhyu,
   {{0x6441059f,0x877b02b5,0x660305a0,0x762605a1}},	//   _etli, _קאמי, bonk, _амаз,
   {{0xbbbf05a2,0x2fc00211,0xf1a605a3,0x799c01cb}},	//   _एक्क, _aoig_, трин, _jarw,
   {{0x799c05a4,0x2fc00392,0x2fd205a5,0xc60e05a6}},	//   _marw, _boig_, _blyg_, ितीय_,
   {{0x7e7d05a7,0x9f4b00de,0x2fc00284,0x6d41033e}},	//   ttsp, vocó_, _coig_, ılam,
   {{0xdbdc0093,0x00000000,0x00000000,0x00000000}},	//   _ráðn, --, --, --,
   {{0x2d850187,0xdd11024e,0x799c05a8,0x00000000}},	//   ýle_, _výži, _narw, --,
   {{0xf41402b5,0x61e805a9,0x2fd2013c,0x7e7d05aa}},	//   ָפּ_, midl, _flyg_, stsp,
   {{0x3ec701c8,0x2a690279,0xef6701d3,0x2fc00392}},	//   _асоб, trab_, _ръко, _goig_,
   {{0x20090118,0x799c05ab,0x5b1505ac,0x660305ad}},	// [2d0] _ikai_, _barw, умат, yonk,
   {{0x799c05ae,0xdd910098,0x2a6905af,0xc27b011d}},	//   _carw, _اود_, rrab_, ורמי,
   {{0x2d910010,0x48c30083,0x7bd60118,0x660305b0}},	//   meze_, ্প্র, bhyu, vonk,
   {{0x2d9105b1,0x4cdc0033,0x7bd600d7,0x61e805b2}},	//   leze_, _মুকু, chyu, hidl,
   {{0xd2460332,0x660305b3,0x799c00e9,0x6b9d01a6}},	//   _دن_, tonk, _farw, _iasg,
   {{0x2d9105b4,0x799c00d1,0x09ad0083,0xca7a0070}},	//   neze_, _garw, _গতকা, _אנשט,
   {{0x660305b5,0x6b9d05b6,0xb4bf05b7,0x61e80097}},	//   ronk, _kasg, ुने_, didl,
   {{0x2d9105b8,0x799c007b,0x7d08018d,0xe2b90200}},	//   heze_, _zarw, üdsi, ећој_,
   {{0x2fc00443,0x6b9d05b9,0x2d9105ba,0x660305bb}},	//   _roig_, _masg, keze_, ponk,
   {{0x61e801a2,0xe57305bc,0x2d9105bd,0x6b9d05be}},	//   gidl, _خطر_, jeze_, _lasg,
   {{0x80ad02e4,0x7bcd0086,0x437501b2,0x6f0d05bf}},	//   टमें, kkau, _مهار, _ayac,
   {{0x527505c0,0x7bcd006d,0x6f0d01d5,0xbb1b000d}},	//   _буку, jkau, _byac, _abîm,
   {{0x6f0d0010,0xe81a0067,0x61e805c1,0x60330395}},	//   _cyac, _फीफा_, bidl, _mămi,
   {{0x409505c2,0x63bb05c3,0x2d910232,0x200901ed}},	//   _брит, ljun, geze_, _ekai_,
   {{0x8fa605c4,0x6f0d00de,0x320500b5,0x6b9d05c5}},	//   _байе, _eyac, moly_, _basg,
   {{0x63bb05c6,0xeb9705c7,0x6b9d001e,0x7bcd05c8}},	//   njun, лис_, _casg, gkau,
   {{0xc332035e,0x601605c9,0x799c05ca,0x6b9d0090}},	// [2e0] מון_, cáma, _parw, _dasg,
   {{0x7bd60232,0x629905cb,0xfd4a00d4,0x6b9d0341}},	//   shyu, _mswo, _язок_, _easg,
   {{0x63bb0093,0x6b9d05cc,0x00000000,0x00000000}},	//   kjun, _fasg, --, --,
   {{0x61e805cd,0x799c05ce,0x6b9d00e9,0x60330395}},	//   zidl, _warw, _gasg, _cămi,
   {{0x6b840009,0x63bb05cf,0x799c05d0,0x320505d1}},	//   mfig, djun, _tarw, koly_,
   {{0xd49a05d2,0x7dd000a0,0x00000000,0x00000000}},	//   ери_, _mäso, --, --,
   {{0x61e805d3,0x395a05d4,0x62990051,0x6aa40036}},	//   vidl, maps_, _aswo, lvif,
   {{0x2d9105d5,0x6b8405d6,0x291800d7,0x395a05d7}},	//   zeze_, nfig, _izra_, laps_,
   {{0xd130004f,0xdb1d00f7,0x46a305d8,0xdb0f000d}},	//   يمة_, _posé, _латв, _ancê,
   {{0x7a7b016b,0x6f0d04fb,0xda7b016b,0x60330160}},	//   עריס, _ryac, עניר, _zămi,
   {{0x2d9105d9,0x63bb0024,0x61e805da,0x62990107}},	//   veze_, bjun, ridl, _eswo,
   {{0x09c100a1,0x2d9105db,0x5faf05dc,0x61e805dd}},	//   _शक्य, weze_, टाइल, sidl,
   {{0x3205040f,0x2d9105de,0x6b9d05df,0x61e805e0}},	//   boly_, teze_, _rasg, pidl,
   {{0x7dcb0006,0x232705e1,0x6aa905e2,0x6f0d05e3}},	//   _küsi, _сочи_, _šefo, _vyac,
   {{0x2d9105e4,0xa1570122,0x6b9d05e5,0xd13f0035}},	//   reze_, _גבוה_, _pasg, łącz_,
   {{0x2d9105e6,0x261605e7,0x672d0121,0x6b8400fd}},	//   seze_, _पीसी_, žaji, gfig,
   {{0x995505e8,0x7bcd05e9,0xf96b05ea,0x2d910160}},	// [2f0] икац, rkau, ерей_, peze_,
   {{0x7bcd05eb,0x6b9d05ec,0x62800051,0x995400af}},	//   skau, _wasg, itmo, йкуц,
   {{0x6b9d0014,0x3ea905ed,0x63bb05ee,0x84e3021a}},	//   _tasg, _hrat_, yjun, _केंट_,
   {{0x3ea905ef,0x6b9d0037,0x290f0228,0x6d5705f0}},	//   _krat_, _uasg, āga_, _hexa,
   {{0x291805f1,0x6d5701a3,0x395a0176,0x60330160}},	//   _ezra_, _kexa, baps_, _vămi,
   {{0x4ade00b4,0x5e5802b5,0xb5fd00b8,0xe5a502c8}},	//   _नेटव, ריגע_, _ovše, рики,
   {{0xdb06006c,0x23d505f2,0x6d5700a8,0x63bb05f3}},	//   _inká, ицир, _mexa, tjun,
   {{0xea0100e8,0x626505f4,0x3ea905f5,0xd2650382}},	//   _đẹp_, авиа, _orat_, акий,
   {{0x320505f6,0xd7f8010b,0xe3b6057a,0x00000000}},	//   toly_, _сур_, рбы_, --,
   {{0xbbd205f7,0x5bd205f8,0x98a105f9,0xa3d900b4}},	//   _सत्क, _सत्व, lahı_, डोज_,
   {{0xf9920122,0x7dd0013c,0x6ff20029,0x320505fa}},	//   חרי_, _säso, lāci, roly_,
   {{0x3ea905fb,0xf1d905fc,0x7c2f0211,0x543a0070}},	//   _brat_, योजन, _nicr, _סענא,
   {{0x320505fd,0x6ff20029,0x628005fe,0x442f05ff}},	//   poly_, nāci, ctmo, _iig_,
   {{0xc5f20070,0x7c2f026e,0x00000000,0x00000000}},	//   ַדן_, _aicr, --, --,
   {{0x3ea90600,0xa3cc000c,0x442f0601,0x2d9e01ba}},	//   _erat_, _रकम_, _kig_, ľte_,
   {{0x442f0602,0x0b460603,0x6ff20029,0x2d9e053d}},	//   _jig_, рнан, kāci, žte_,
   {{0x442f0604,0x3ea90605,0x7c2f01cb,0x3e7f00af}},	// [300] _mig_, _grat_, _dicr, cît_,
   {{0x442f0606,0xe9d70607,0x6ff20228,0x7c2f0211}},	//   _lig_, аку_, dāci, _eicr,
   {{0x442f0608,0xd9100609,0x6fcd00a2,0x2bbf060a}},	//   _oig_, سیر_, _bûch, _एकचा,
   {{0x7afd0069,0x69d5060b,0x225f0008,0xcc3b0070}},	//   _fxst, _elze, ksuk_, _שעכט,
   {{0x7c24060c,0x7ae9011c,0xeb9702fb,0x6ff200ea}},	//   mmir, _žetv, _тия_, gāci,
   {{0x6d5c060d,0x442f060e,0x7c240095,0x7dcb007c}},	//   nara, _aig_, lmir, _püsi,
   {{0x442f060f,0x601d02e1,0x3958012f,0xdb0f00e0}},	//   _big_, léme, _iers_, _ancè,
   {{0x938a0610,0x442f0611,0x80a90026,0x2b400612}},	//   тска_, _cig_, टिने, ncic_,
   {{0x442f0613,0x6d5c03d0,0x3c3c05ee,0x05160083}},	//   _dig_, kara, _lív_, াশের_,
   {{0x6d5c0614,0x442f0615,0x60330395,0x3958008c}},	//   jara, _eig_, _lămu, _jers_,
   {{0x39580616,0x442f0617,0x3ea90618,0xdfd10037}},	//   _mers_, _fig_, _srat_, كيد_,
   {{0x6d570619,0x3ea9061a,0x6fc6061b,0x395801f7}},	//   _sexa, _prat_, _sócr, _lers_,
   {{0xdefb061c,0x6d5c061d,0x7c2f0382,0xdb1d0036}},	//   тын_, fara, _ricr, _così,
   {{0x6d5c061e,0x442f061f,0x3ea90620,0x7c2f0297}},	//   gara, _zig_, _vrat_, _sicr,
   {{0x442f006f,0x6ff20080,0x6d570621,0x61ef00f7}},	//   _yig_, zāci, _vexa, ècle,
   {{0x7c2401a2,0x6d4e0069,0x69d500d5,0x3ea90622}},	//   gmir, abba, _slze, _trat_,
   {{0x6d5c0623,0x69d501c0,0x8d870009,0x6d570624}},	// [310] bara, _plze, _кунд, _texa,
   {{0xe29f00fb,0xc17801c8,0x44240159,0x7f5d0625}},	//   æði_, ngė_, hmm_, lasq,
   {{0x3958027d,0x7c2f0176,0xf7730079,0x9f4200ac}},	//   _ders_, _ticr, قاش_, liká_,
   {{0x39580626,0x22460627,0x6ff20029,0x7c240628}},	//   _eers_, _otok_, tāci, cmir,
   {{0x9f420187,0x601600b5,0x395800a2,0x442f0629}},	//   niká_, zámo, _fers_, _rig_,
   {{0x442f062a,0x6ff20080,0x3958062b,0xd877042c}},	//   _sig_, rāci, _gers_, _پاسب,
   {{0xe3b1004f,0x601601ef,0x442f062c,0x98aa009f}},	//   كرة_, xámo, _pig_, _rebħ_,
   {{0x6d5c062d,0x442f01e8,0xb7bd0395,0x3a390282}},	//   zara, _qig_, _piţu, _kusp_,
   {{0x442f062e,0x36d401e0,0xa56701cb,0xdcfe00ea}},	//   _vig_, _дотр, _ندان, _papī,
   {{0x7c240029,0x6d5c062f,0xdb1d0097,0xf1b10630}},	//   zmir, xara, _nosí, जाइन,
   {{0x442f0631,0x2ed0018d,0x1bf90632,0x225f00b5}},	//   _tig_, हन्त, ्काल_, ssuk_,
   {{0xcdc90052,0x6d5c0633,0xdb0f0634,0x672d00cd}},	//   _אך_, wara, _encé, žaju,
   {{0x6d5c0635,0x539a00a5,0xdb24045e,0x2b400207}},	//   tara, _תינו, üsün, vcic_,
   {{0x32b80037,0x6139016b,0x60160042,0x7dd00421}},	//   _خدمة_, _גײַס, pámo, _täsm,
   {{0x6d5c0636,0xc8850095,0x7c240637,0x8c460279}},	//   rara, naşı_, tmir, себе,
   {{0x9f82008a,0x2b590638,0x2a600639,0x7dd003a6}},	//   _góð_, _cesc_, tsib_, _käsk,
   {{0x7c24063a,0x2b40063b,0xdb1d063c,0x0936063d}},	// [320] rmir, rcic_, _fosí, مراج,
   {{0x7dd0063e,0x2a60063f,0x601d0640,0x3a3100fe}},	//   _mäsk, rsib_, réme, _cizp_,
   {{0x39580641,0xfbd20642,0x2a600643,0x601d00f7}},	//   _vers_, _فتح_, ssib_, séme,
   {{0xc8850644,0x9f4b0031,0x7f440069,0x395800e5}},	//   daşı_, vicë_, _jfiq, _wers_,
   {{0xe5c60645,0x39580646,0xe77500a8,0xada90647}},	//   йско, _ters_, zıçı, _صدیق_,
   {{0x6b96008e,0x7e6402a7,0x00000000,0x00000000}},	//   leyg, _mvip, --, --,
   {{0x7bc60648,0xe9d701e0,0x66d100b5,0x00000000}},	//   _koku, _укр_, tókö, --,
   {{0x6b960649,0x7e6403d0,0x7bc6064a,0x2b590176}},	//   neyg, _ovip, _joku, _xesc_,
   {{0x7ae9064b,0x7bc60486,0x60290035,0x7dcb064c}},	//   _þett, _moku, _uśmi, _küst,
   {{0x7bc6064d,0x104a0352,0x6d5a0093,0x644a03d0}},	//   _loku, лями_, ðtal, ppfi,
   {{0xe452064e,0x7dcb064f,0x672d0650,0x9f4b0453}},	//   _رضا_, _xüsu, žajt, licé_,
   {{0x7bc60651,0x94260652,0xb4d40653,0x660a0207}},	//   _noku, _умее, हनी_, lofk,
   {{0xdb1d0654,0x2246043d,0x601d0118,0x00000000}},	//   _posí, _utok_, témb, --,
   {{0x270700e8,0x63a20655,0x2b590279,0xe9df0300}},	//   ống_, _haon, _sesc_, _atún_,
   {{0x7bc60656,0x7f5d0036,0x7a29010b,0x3a39021d}},	//   _boku, pasq, _užti, _susp_,
   {{0x1b020033,0xdb1d0183,0x7dd00282,0x660a0298}},	//   লেছে_, _rosâ, _läsh, hofk,
   {{0x63a20657,0x200b0658,0x394100f7,0x7dcb0659}},	// [330] _maon, moci_, tchs_, _büst,
   {{0x2ba9065a,0x200b065b,0x63a2065c,0x39410110}},	//   _चोरा, loci_, _laon, uchs_,
   {{0x3941065d,0x7dcb065e,0x9982004b,0x00000000}},	//   rchs_, _düst, _aukų_, --,
   {{0x61c5065f,0x63a20054,0x200b0660,0x39410110}},	//   _लक्ष, _naon, noci_, schs_,
   {{0x25ed02cb,0x4ae401c8,0xb5fd024e,0x961d021e}},	//   _अगदी_, _еўра, _avša, _opņt,
   {{0x7bc60661,0xdcfc0029,0x3e5c0070,0x96280037}},	//   _zoku, cerē, נדוס, مكنك_,
   {{0x7bc60662,0x200b0663,0x67d50664,0xdb0601ff}},	//   _yoku, koci_, _дову, _enkä,
   {{0xc2450665,0x69c70666,0x7dcb0508,0x63a20667}},	//   оник, _hoje, _küss, _caon,
   {{0x69c70668,0x64480669,0x63a2066a,0x85b9066b}},	//   _koje, _etdi, _daon, _клас_,
   {{0x7dcb02c9,0xd24e00f8,0x69c700d7,0x7dd0013c}},	//   _müss, کنی_, _joje, _väsk,
   {{0x69c7066c,0xcea90397,0x7e64008a,0x645e00a0}},	//   _moje, _שי_, _svip, špir,
   {{0x6d450244,0x200b0443,0x246500ea,0xd00a066d}},	//   _afha, goci_, mēm_, реме_,
   {{0xa29400ef,0xd9fb00a1,0x6d450341,0x246500ea}},	//   _наці, ्वात_, _bfha, lēm_,
   {{0x7dd0066e,0x4129066f,0x7bc60670,0xed570671}},	//   _käsi, _коло_, _soku, жор_,
   {{0x7bc60672,0x7dcb0673,0x8c430674,0x63a20675}},	//   _poku, _rüst, десе, _yaon,
   {{0xb06803c5,0x7dcb007c,0x200b0676,0x3d1a00ab}},	//   _اصول_, _süst, coci_, _धरीं_,
   {{0x69c702f6,0x7dcb00ab,0xed360677,0x19c60678}},	// [340] _boje, _püst, _мэнэ, обам,
   {{0x7bc60679,0x3ea002e9,0x7dcb01ae,0x69c7067a}},	//   _woku, _isit_, _düss, _coje,
   {{0x69c7067b,0x7bc6067c,0x601d067d,0x5faf0099}},	//   _doje, _toku, léma, _जोडल,
   {{0x2d98067e,0x510c00c2,0x224d067f,0x7dcb02b1}},	//   lere_, נהאַ, kpek_, _wüst,
   {{0xd5ba03ad,0x69c70009,0x63a20680,0x601d00f7}},	//   иск_, _foje, _raon, néma,
   {{0x2d980681,0x6448012f,0x69c70682,0xe4520037}},	//   nere_, _ptdi, _goje, وضع_,
   {{0xb4d40683,0x601d0684,0x63a20036,0x2d980685}},	//   हने_, héma, _paon, iere_,
   {{0x2d980686,0x32660072,0x9faf01c0,0x6aa9030a}},	//   here_, отов, tří_, _šefi,
   {{0x2d980687,0xdb1d006c,0x00000000,0x00000000}},	//   kere_, _kosá, --, --,
   {{0x2d980688,0x63a20054,0xcb1300a5,0x3f80010b}},	//   jere_, _waon, ולח_, _aciu_,
   {{0x2d980689,0x63a20269,0x200b042a,0x246500ea}},	//   dere_, _taon, toci_, cēm_,
   {{0xdb1d01ef,0x00000000,0x00000000,0x00000000}},	//   _losá, --, --, --,
   {{0x2d98068a,0x200b068b,0x00000000,0x00000000}},	//   fere_, roci_, --, --,
   {{0x2d98068c,0xddcf002d,0x61ea00af,0xdb1d068d}},	//   gere_, ducţ, _umfl, _nosá,
   {{0xa1770052,0xfbd30082,0xc05a0044,0x69c7068e}},	//   _ועוד_, وتر_, _тіл_, _roje,
   {{0x69c7068f,0xdb1d0176,0x7dcb00be,0x320c0147}},	//   _soje, _posà, _püss, lody_,
   {{0x69c70690,0x2d980232,0x3f990691,0xdb1d00d5}},	// [350] _poje, bere_, mesu_, _bosá,
   {{0x2d980692,0x3f990693,0xdb1d0079,0xdb0f0176}},	//   cere_, lesu_, _cosá, _socó,
   {{0x76490694,0x69c7024e,0x2d81009e,0xdb1d00b8}},	//   _stey, _voje, _iche_, _dosá,
   {{0x320c0076,0x3f990695,0x69c7004e,0x4c9a02b8}},	//   hody_, nesu_, _woje, _פברו,
   {{0x320c0067,0x00000000,0x00000000,0x00000000}},	//   kody_, --, --, --,
   {{0x27ef024b,0x24650029,0x69de0696,0x85e801e0}},	//   sign_, tēm_, chpe, одів_,
   {{0xf7730697,0x2d81023c,0xd5ae0698,0x00000000}},	//   _يار_, _mche_, طفي_, --,
   {{0x3cfc0100,0x61fa0699,0x2d980010,0x3f99003a}},	//   ילונ, entl, zere_, jesu_,
   {{0x37da0070,0x27ed069a,0x2d810036,0x2d9801e0}},	//   _פֿלע, _imen_, _oche_, yere_,
   {{0x2d980051,0x320c0035,0x6d48027b,0x224d01ed}},	//   xere_, gody_, ıdak, rpek_,
   {{0x2d98069b,0x6016069c,0x224d069d,0x2fc90211}},	//   vere_, lámi, spek_, _boag_,
   {{0x2d98069e,0xd8d60122,0x25a500a5,0x224d00b5}},	//   were_, פורט_, _hall_, ppek_,
   {{0x25a5069f,0x320c06a0,0x02a700af,0x27ed0107}},	//   _kall_, body_, _фрем, _mmen_,
   {{0x6b8f0168,0x27ff0024,0x7bcb008d,0x7dd001ff}},	//   _abcg, _ljun_, ögun, _läsv,
   {{0x2d9806a1,0x27ed06a2,0xdb1d06a3,0x25a5024b}},	//   rere_, _omen_, _rosá, _mall_,
   {{0x2d9806a4,0x4a4606a5,0x9e6606a6,0x27ed010d}},	//   sere_, знав, _евид, _nmen_,
   {{0x2d9806a7,0x6d4106a8,0xe9da06a9,0xdb1d0187}},	// [360] pere_, ılar, бка_, _posá,
   {{0xdb0406aa,0x27ff06ab,0x8af000a8,0x25a506ac}},	//   ndié, _ajun_, vbəd, _nall_,
   {{0x6d5e0029,0x6d3b00a5,0xdb1d00d5,0x63760457}},	//   _iepa, _לתינ, _vosá, nünü,
   {{0xf1ba0019,0x69de0031,0x25a500e5,0x7bdf02b1}},	//   _nhơn_, shpe, _aall_, chqu,
   {{0x6d5e06ad,0xb4e40066,0x25a506ae,0x27ff007a}},	//   _kepa, _पेड़_, _ball_, _djun_,
   {{0x6d5e00a1,0x7c3e06af,0x25a506b0,0x3f9901d7}},	//   _jepa, _kupr, _call_, zesu_,
   {{0x25a50133,0x320c033a,0x3f9906b1,0x7ae406b2}},	//   _dall_, vody_, yesu_, lzit,
   {{0x6d5e06b3,0x320c0035,0x25a500ab,0x7bd606b4}},	//   _lepa, wody_, _eall_, nkyu,
   {{0x320c04aa,0x25a506b5,0xdb0400f7,0x3f99023a}},	//   tody_, _fall_, udiè, vesu_,
   {{0x64a606b6,0x6d5e06b7,0x200301cc,0x672003fd}},	//   _наза, _nepa, čkim_, _izmj,
   {{0x9316006c,0x320c05d1,0xef1f06b8,0x63760448}},	//   _کوشش, rody_, rfüm_, günü,
   {{0x672002e4,0x2d810110,0x443e06b9,0x27ed055c}},	//   _बराक_, _sche_, _iut_, _xmen_,
   {{0x6d5e06ba,0xb80d06bb,0xe80d06bc,0x7c3e0248}},	//   _bepa, िकतम_, िकता_, _aupr,
   {{0x6d5e0388,0x443e06bd,0x224b01ba,0x3f9900e9}},	//   _cepa, _kut_, ícke_, sesu_,
   {{0x7c3e0043,0x9f4b0355,0x443e00b5,0x3f9906be}},	//   _cupr, licí_, _jut_, pesu_,
   {{0x443e06bf,0x69dc06c0,0xd1170317,0x6d5e0159}},	//   _mut_, _alre, _מקוה_, _eepa,
   {{0x443e06c1,0x5a3506c2,0x25ed0461,0x69dc009e}},	// [370] _lut_, днат, _अगली_, _blre,
   {{0x443e01f3,0x6d5e06c3,0x2ca1022e,0x7bdf06c4}},	//   _out_, _gepa, _tshd_, shqu,
   {{0x25a506c5,0x69dc0211,0x7c670427,0x443e06c6}},	//   _rall_, _dlre, _عادل, _nut_,
   {{0x69dc00b5,0x601601ef,0x00000000,0x00000000}},	//   _elre, támi, --, --,
   {{0xf7700206,0x443e06bc,0x637600d0,0x25a506c7}},	//   طان_, _aut_, zünü, _pall_,
   {{0x443e01f3,0x601606c8,0xf65006c9,0x6d470035}},	//   _but_, rámi, ائن_, ncja,
   {{0x25a50443,0x443e00a5,0x64a202fb,0x601d02d7}},	//   _vall_, _cut_, ваща, jémo,
   {{0x443e0291,0x741506ca,0x7dd006cb,0x601d01dd}},	//   _dut_, بوعا, _häst, démo,
   {{0x644906cc,0x91e506cd,0x443e00f7,0x6d470067}},	//   _žlič, допе, _eut_, kcja,
   {{0x443e06ce,0x5ef101c0,0xdb0402b1,0x63760448}},	//   _fut_, ँछन्_, heiß, tünü,
   {{0x656306cf,0x7bdd06d0,0x443e06d1,0x7ae4027a}},	//   manh, _olsu, _gut_, zzit,
   {{0x5ec600c8,0x7dd006d2,0x637606d3,0x7bcb0093}},	//   _লেগে, _läst, rünü, ögul,
   {{0x6d5e06d4,0x7c3e06d5,0x8af0013b,0x2e2402b1}},	//   _pepa, _supr, naət, höfe_,
   {{0x63a906d6,0x7dd006d7,0x518706d8,0x2be006d9}},	//   lden, _näst, _худа, नसभा,
   {{0x628906da,0x601d002a,0x6b8d06db,0x443e01f7}},	//   lteo, cémo, ffag, _xut_,
   {{0x63a906dc,0x7ae401d7,0x673b06dd,0x656306de}},	//   nden, tzit, _nguj, hanh,
   {{0x7dd006d7,0x6d5e06df,0x628906e0,0x63a906e1}},	// [380] _bäst, _tepa, nteo, iden,
   {{0x7ae406e2,0x673b06e3,0x62890037,0x22590097}},	//   rzit, _aguj, iteo, ásky_,
   {{0x59c40026,0xdb0f0392,0x0c2606e4,0xab670228}},	//   लॉगर, _encà, _омон, _beļģ,
   {{0x63a906e5,0x443e06e6,0x3eb206e7,0x6fde0026}},	//   jden, _rut_, _kryt_, मसिं,
   {{0x443e0297,0x7dd0013c,0x656306e8,0x63a906e9}},	//   _sut_, _fäst, fanh, dden,
   {{0x7dd006ea,0x63a906eb,0x443e06ec,0xa2ac0026}},	//   _gäst, eden, _put_, जिस्,
   {{0x443e012f,0x7dd006ed,0x7845010b,0xf77206ee}},	//   _qut_, _häss, _tėva, _لاء_,
   {{0x443e06ef,0x600800c1,0x63a906f0,0x00000000}},	//   _vut_, nımd, gden, --,
   {{0xa80206d3,0x291806f1,0x656306f2,0x443e06f3}},	//   ğıda, _hyra_, banh, _wut_,
   {{0x443e06f4,0x63a906f5,0x7dd006f6,0x601d05c9}},	//   _tut_, aden, _mäss, témo,
   {{0x7dd002c9,0x443e007c,0xf1a301f1,0x201902c4}},	//   _läss, _uut_, трын, tlsi_,
   {{0x291806f7,0x601d06f8,0x3eb20185,0x764006f9}},	//   _myra_, rémo, _bryt_, _kumy,
   {{0x442606fa,0x7dd006fb,0x628906fc,0xa30800b5}},	//   _iho_, _näss, cteo, _عرصے_,
   {{0x442606fd,0x02ca06fe,0x764006ff,0xdb0402b1}},	//   _hho_, िहीन, _mumy, weiß,
   {{0x44260700,0x6d470701,0x2bbb0037,0x9e3400af}},	//   _kho_, rcja, يارة_, терч,
   {{0xdb0601cb,0x00000000,0x00000000,0x00000000}},	//   _kakè, --, --, --,
   {{0x656302b3,0x69c50069,0xa3d6030f,0x6b8d0702}},	// [390] yanh, tjhe, _हवन_, rfag,
   {{0x44260703,0x63a90704,0x49740705,0x7e7d03a6}},	//   _lho_, zden, клус, musp,
   {{0x7dd0022a,0x44260706,0x63a90707,0x65630708}},	//   _väst, _oho_, yden, vanh,
   {{0x44260709,0xdb0f01dd,0xddcd0097,0x291801bc}},	//   _nho_, _encá, _staň, _dyra_,
   {{0x7c2d0533,0x200301cc,0x7dd0070a,0x656306f2}},	//   mmar, čkih_, _täst, tanh,
   {{0x4426070b,0x2918022a,0x00000000,0x00000000}},	//   _aho_, _fyra_, --, --,
   {{0x4426004a,0x6563070c,0xfc4601ba,0x63a9070d}},	//   _bho_, ranh, žíva_, tden,
   {{0x4426070e,0x7c2d070f,0x65630710,0x62890711}},	//   _cho_, nmar, sanh, tteo,
   {{0x66f30712,0x65630370,0x2a690713,0xe7840714}},	//   _अधिक_, panh, nsab_, _шуро,
   {{0x62890715,0x60080716,0x7e7d00ab,0xdb060260}},	//   rteo, zımd, dusp, _dakè,
   {{0x62890717,0x7c2d0718,0xdb0601f4,0x44260719}},	//   steo, kmar, _pakë, _fho_,
   {{0x64410012,0x7c2d071a,0x6561071b,0x2a6900ab}},	//   _iuli, jmar, _helh, ksab_,
   {{0x442d071c,0x644100a7,0x81d5071d,0x6561071e}},	//   mme_, _huli, _подх, _kelh,
   {{0x644104be,0x7c26071f,0x270e0019,0xfbdf06f2}},	//   _kuli, _shkr, ộng_, _alê_,
   {{0x656100c9,0x64410720,0xfce60721,0xa3b40722}},	//   _melh, _juli, хово, _छोड_,
   {{0x442d0723,0x64410724,0x44260725,0xf06202fb}},	//   nme_, _muli, _xho_, _скъп,
   {{0x291e0537,0x160f0726,0xe9da014d,0x442d0727}},	// [3a0] _šta_, िवार_, пка_, ime_,
   {{0x442d0728,0x7c2d0729,0xdb0601c0,0x644103bc}},	//   hme_, amar, _jaké, _ouli,
   {{0x442d072a,0x6441072b,0x7c2d072c,0x2b4b00fe}},	//   kme_, _nuli, bmar, _ffcc_,
   {{0x442d072d,0x7dd003ad,0x3f82072e,0x2a69006d}},	//   jme_, _täss, ngku_, bsab_,
   {{0x4426072f,0x00000000,0x00000000,0x00000000}},	//   _rho_, --, --, --,
   {{0x64410730,0x442600ec,0x442d0731,0x991600d8}},	//   _buli, _sho_, eme_, _зьбі,
   {{0x64410732,0xd4970733,0xdcfc0029,0x7e7d0734}},	//   _culi, еры_, derī, zusp,
   {{0x442601a9,0x69ce0291,0x442d0735,0xdb0602d0}},	//   _qho_, _hobe, gme_, _pakè,
   {{0x65610332,0x69ce0736,0x64410737,0xf5ea00af}},	//   _felh, _kobe, _euli, _емал_,
   {{0x44260052,0x64410069,0x442d0738,0xf1ba0019}},	//   _who_, _fuli, ame_, _thơm_,
   {{0x44260739,0x6441073a,0xdfd10125,0x69ce073b}},	//   _tho_, _guli, ليد_, _mobe,
   {{0x7e7d073c,0x04db0122,0x442d073d,0xa2e6073e}},	//   tusp, _מקבל, cme_, _поед,
   {{0x0cc9073f,0x64410740,0x7c2d0282,0xa3d5007c}},	//   रह्म, _zuli, vmar, _सकत_,
   {{0x69ce0741,0x2d850742,0x7c2d0743,0x7afb011c}},	//   _nobe, üle_, wmar, _žuto,
   {{0x7e7d0744,0x64410745,0xac190746,0x00000000}},	//   susp, _xuli, дову_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7f490453,0x7f4d0024,0x9f4b00be,0x00000000}},	// [3b0] ñequ, _ifaq, öjõu_, --,
   {{0x69ce0747,0x9f590079,0x5b1400af,0x7e6d0065}},	//   _cobe, insí_, умут, _ivap,
   {{0xd3660118,0x69ce0748,0x2a690183,0xe3c30225}},	//   _په_, _dobe, ssab_, ngıç_,
   {{0x2d830044,0x7e6d0749,0x65610355,0x7f4d0024}},	//   lgje_, _kvap, _selh, _jfaq,
   {{0xe7e200b1,0x65610355,0x4b7a0070,0x85b800f8}},	//   _खतरा_, _pelh, _קאשו, کانس_,
   {{0x69ce074a,0x6441074b,0x888200b5,0x2d83074c}},	//   _gobe, _puli, _چیلن, ngje_,
   {{0x442d074d,0x6561074e,0x644100a8,0xb4db074f}},	//   tme_, _velh, _quli, डने_,
   {{0x7bcf0012,0x69ce0750,0x7e6d02c4,0x64410751}},	//   _jocu, _zobe, _ovap, _vuli,
   {{0x130902ce,0x9f4201f4,0x69d8006c,0x65610752}},	//   ьний_, shkë_, öveg, _telh,
   {{0x7bcf0012,0x64410753,0xfe7f0176,0xb6350754}},	//   _locu, _tuli, duï_, _شفاع,
   {{0xf8e10755,0x64410756,0xdb1d004f,0xd37100ce}},	//   पनिय, _uuli, _cosú, _نها_,
   {{0x2d830051,0x13a700f8,0x00000000,0x00000000}},	//   egje_, _سنتی_, --, --,
   {{0x69c406bc,0x3f8c0035,0xdb0601ba,0x15e5049c}},	//   रामी, ędu_, _také, _कतार_,
   {{0x827602b5,0x7e6d011c,0x63ab0093,0x9f4b0132}},	//   _יענע_, _dvap, _hagn, ricá_,
   {{0xa3d50035,0xa0a50757,0x4094010b,0x00000000}},	//   _सका_, _райд, _брыт, --,
   {{0x69ce0042,0xeb97002d,0xd00f004f,0x7bcf0758}},	//   _sobe, кис_, _ولو_, _cocu,
   {{0x69ce0759,0xd946075a,0xe7f70026,0x00000000}},	// [3c0] _pobe, вези, ूचना_, --,
   {{0xdb0d008a,0x63ab075b,0x7dd00282,0x00000000}},	//   rjað, _lagn, _gäsp, --,
   {{0x1d0a075c,0x69ce075d,0x00000000,0x00000000}},	//   _цени_, _vobe, --, --,
   {{0x63ab075e,0x69ce075f,0x27e00037,0x6ec60380}},	//   _nagn, _wobe, óin_, ामपु,
   {{0xe7f30035,0xe7370760,0x34da0761,0x23c5021a}},	//   _आगरा_, вец_, बन्द, वानद,
   {{0xa61300d8,0x5573002d,0x6b840762,0x00000000}},	//   аміч, агшт, lgig, --,
   {{0x63ab01d3,0x629902e9,0x04630763,0x442a00af}},	//   _bagn, _apwo, атым, мцим_,
   {{0x63ab0764,0x00000000,0x00000000,0x00000000}},	//   _cagn, --, --, --,
   {{0x63ab0765,0x41e600d8,0x99830409,0x6f090067}},	//   _dagn, віна, _gijų_, żecz,
   {{0xdb1d0766,0xf1ba0023,0x63ab0767,0x27e60768}},	//   _posú, _khơi_, _eagn, lhon_,
   {{0x601d0769,0xb97b0122,0x63ab0093,0xdb06033b}},	//   lémi, וניי, _fagn, _ankü,
   {{0x63ab076a,0x7ec900da,0x27e602b3,0x14d7076b}},	//   _gagn, _nëpë, nhon_, _שואל_,
   {{0xd250004f,0xd33600d8,0xf8bf04aa,0x601d076c}},	//   _انت_, _рэжы, _एप्प, némi,
   {{0x63a0076d,0x63ab076e,0x6280076f,0x7bcf0139}},	//   lemn, _zagn, mumo, _socu,
   {{0xa3d60591,0x7bcf0770,0x62800771,0x2d830772}},	//   _हवा_, _pocu, lumo, rgje_,
   {{0x6008027d,0x3ed50773,0x00000000,0x00000000}},	//   rımc, _مقبر, --, --,
   {{0x628001a2,0x27e60774,0x41a90775,0x00000000}},	// [3d0] numo, dhon_, _कसमस, --,
   {{0x601d0776,0x9f4001f7,0x3ea9067f,0x3f8901da}},	//   démi, _aliè_, _isat_, _hcau_,
   {{0xf1ba00e8,0x62800777,0xf77500d4,0x7bcf0778}},	//   _chơi_, humo, гулю, _tocu,
   {{0xf0930779,0x63a0077a,0x1a650332,0x6280077b}},	//   ינע_, jemn, _میری_, kumo,
   {{0x63ab077c,0x62800029,0x600804d4,0x7c3d00ab}},	//   _ragn, jumo, nıma, _iisr,
   {{0x63ab077d,0x27e6010d,0x2e240093,0x00000000}},	//   _sagn, ahon_, höfn_, --,
   {{0x63ab077e,0x20020035,0x478b0274,0x25ac077f}},	//   _pagn, ynki_, _осам_, _dadl_,
   {{0x27e60780,0x3f8901e8,0x25be0176,0x7c3d0781}},	//   chon_, _ncau_, _entl_, _jisr,
   {{0x63ab0782,0x67d4002d,0x601d0783,0x628004ff}},	//   _vagn, _тоту, cémi, gumo,
   {{0x10a50665,0xdb040784,0xddc40009,0xb0ae0785}},	//   гион, ndiá, _oviš, टिंग,
   {{0x54550786,0x63ab0787,0x69c402cb,0x228b02ce}},	//   _свет, _tagn, राती, søk_,
   {{0x62800788,0x92b50789,0xdb0d00be,0x7c3d007a}},	//   bumo, _محتا, ljaõ, _nisr,
   {{0xf1a80088,0x3ea9078a,0x62c70079,0x00000000}},	//   رایه_, _csat_, _جزاك, --,
   {{0x27e6078b,0x7c3d009e,0xc33200a5,0x3ea9008c}},	//   zhon_, _aisr, _הוד_, _dsat_,
   {{0xfce3078c,0x7c3d046a,0xd1b8006c,0x3ea9078d}},	//   боро, _bisr, _جانا_, _esat_,
   {{0xfaa6078e,0x81bc00ea,0xd0120037,0x1ee80088}},	//   лабо, smēt, _دلع_, _لوبی_,
   {{0xfe7200d2,0x6b84078f,0xdb060359,0x2fc00790}},	// [3e0] _ادب_, rgig, _ankò, _inig_,
   {{0x63a00791,0xf1ba0023,0x7a2200a0,0x69c4052b}},	//   zemn, _phơi_, rôto, राधी,
   {{0x27e60792,0x81bc0080,0xddc4023a,0x443d0793}},	//   thon_, slēg, _gviš, _oiw_,
   {{0x6d4e02c4,0x4b5502fb,0xdb1d0107,0x6e3e018d}},	//   lcba, _върт, _onsè, _hipb,
   {{0xcc3b02b5,0xdb06021e,0x6e3e008c,0x27e60794}},	//   _רעכט, _enkò, _kipb, rhon_,
   {{0xe9df004f,0x27e601f4,0x601d0795,0xb86602ed}},	//   _dtús_, shon_, rémi, _مارو,
   {{0xe0c70796,0x63a00797,0xdb1d02d0,0x601d000d}},	//   _از_, temn, _ansè, sémi,
   {{0xc2740798,0xb27406a6,0x75240355,0xedd101c0}},	//   алиј, алиш, řizo, _सक्छ,
   {{0x248e01a2,0x060a0799,0x443d02d0,0x6d5c079a}},	//   stfm_, _знак_, _diw_, kbra,
   {{0x6280079b,0x63a0079c,0x27e4028b,0xf1a6079d}},	//   rumo, semn, _hlmn_, урин,
   {{0x43860164,0x6280079e,0xb97b0070,0xdb1d021e}},	//   _ملاق, sumo, ענטי, _ensè,
   {{0x273a0092,0x9f5901f4,0x752800ea,0x6d5c079f}},	//   _günü_, misë_, _izdz, ebra,
   {{0x9f5901f4,0x98b8007a,0x741301cb,0x244a00e2}},	//   lisë_, _ferħ_, _اونا, _hùm_,
   {{0x2fc007a0,0xf1aa05f5,0x6d5c07a1,0x6008045e}},	//   _enig_, _ساته_, gbra, rıma,
   {{0x9f5900da,0xfaff00da,0xdb1d07a2,0xa2ac07a3}},	//   nisë_, _ndër_, _insé, जिक्,
   {{0x6d5c0608,0x3b5503e6,0x81bc0029,0x61fa07a4}},	//   abra, ркар, slēd, litl,
   {{0x6d5c01d3,0x9f49027d,0x3ea90392,0x661a0107}},	// [3f0] bbra, _amaç_, _usat_, _oktk,
   {{0x6d5c009e,0xdcfc0029,0x9f590031,0x61fa07a5}},	//   cbra, sgrā, kisë_, nitl,
   {{0xa3d50006,0xdb0407a6,0x9f5901f4,0xf9880037}},	//   _सकल_, rdiá, jisë_, انمي_,
   {{0x9f590031,0x61fa0225,0xa80200c1,0x69c807a7}},	//   disë_, hitl, şına, _òden,
   {{0xd90f07a8,0xe6110580,0x61fa027b,0x2246021e}},	//   _کیا_, يشت_, kitl, _nuok_,
   {{0x443d02d0,0xf98907a9,0x9f590031,0xaaa802fb}},	//   _siw_, _جنسي_, fisë_, _съюз_,
   {{0x7aed07aa,0x244a07ab,0x61fa07ac,0x7e7d033b}},	//   lzat, _cùm_, ditl, hrsp,
   {{0x7bcd07ad,0x2246011e,0x244a0019,0x6d5c07ae}},	//   njau, _buok_, _dùm_, zbra,
   {{0x7aed07af,0x11e507b0,0x59c90026,0x6d5c07b1}},	//   nzat, ижим, रापर, ybra,
   {{0x437500bf,0x846701d3,0x6d5c021d,0x20b5010b}},	//   _چهار, _бъде, xbra, аёмс,
   {{0x53c50026,0x9f5900da,0xe5c407b2,0x23c507b3}},	//   वादश, cisë_, _усто, वादद,
   {{0x6d5c0211,0x229507b4,0xb4b107b5,0xdb1d02d7}},	//   wbra, _видя, टटी_, _ensé,
   {{0x6d5c07b6,0x61fa05f9,0x5f19018d,0xceb4013b}},	//   tbra, bitl, _युद्_, _azər_,
   {{0xdb040132,0x601d0298,0x7aed07b7,0x00000000}},	//   ldiç, dému, dzat, --,
   {{0x6d5c07b8,0xdc6702ee,0xdca6066d,0x6f0d07b9}},	//   rbra, иард_, шави, _exac,
   {{0xdb040370,0x35c707ba,0x2fc00297,0x78ba01ba}},	//   ndiç, लाड़, _unig_, _štvo,

   {{0x896604bf,0xbea607bb,0x31670359,0x9f590031}},	// [400] икаж, _тапк, _kenz_, zisë_,
   {{0x69260409,0x27e4009e,0x48b602fb,0x00000000}},	//   амза, _slmn_, ищет, --,
   {{0x3205024b,0xac0a07bc,0x98740355,0x69de07bd}},	//   inly_, _анна_, _týče_, rkpe,
   {{0x244a0014,0x31670408,0x7e6404fb,0x9f590031}},	//   _rùm_, _lenz_, _kwip, visë_,
   {{0xe5c607be,0x61fa07bf,0x7aed0067,0xdcfe07c0}},	//   иско, yitl, czat, _napĺ,
   {{0xd49a07c1,0x5d7a00c2,0x672900ea,0x9f590031}},	//   ври_, דאַק, _dzej, tisë_,
   {{0x53e607c2,0x83f807c3,0x61fa07c4,0x67290103}},	//   ициа, лекс_, vitl, _ezej,
   {{0x9f5901d2,0x7afb011c,0x00000000,0x00000000}},	//   risë_, _žuti, --, --,
   {{0x9f5900da,0x316707c5,0x61fa07c6,0x66e307c7}},	//   sisë_, _benz_, titl, _дота,
   {{0x9f5907c8,0x244a00e2,0x00000000,0x00000000}},	//   pisë_, _tùm_, --, --,
   {{0x7aed07c9,0x9f5907ca,0x661807cb,0x00000000}},	//   zzat, lisé_, movk, --,
   {{0x661807cc,0x61fa07cd,0x656807ce,0x7aed07cf}},	//   lovk, sitl, _hedh, yzat,
   {{0x61fa07d0,0x9f5907d1,0x644807d2,0x656800d1}},	//   pitl, nisé_, _hudi, _kedh,
   {{0x644807d3,0x65680118,0x661805ed,0x7e6407d4}},	//   _kudi, _jedh, novk, _dwip,
   {{0x656807d5,0x31570122,0x7b670086,0x644807d6}},	//   _medh, _דיון_, итае, _judi,
   {{0x81e800c8,0x7aed07d7,0x644807d8,0x6008008f}},	//   _যদি_, tzat, _mudi, nıml,
   {{0x6e950514,0x644807d9,0x7bcd03ad,0x5e95004f}},	// [410] _الخا, _ludi, rjau, _الخط,
   {{0x201907da,0x7bcd07db,0x7aed07dc,0xa802033e}},	//   losi_, sjau, rzat, şıla,
   {{0x6618024e,0x6d4507dd,0x6008027d,0x3a33011e}},	//   dovk, _igha, kıml, rmxp_,
   {{0x201907de,0xb8ff07df,0x6568030d,0x00000000}},	//   nosi_, _तथ_, _aedh, --,
   {{0xef1f0644,0x656800f8,0x600800a8,0x00000000}},	//   zgün_, _bedh, dıml, --,
   {{0x644807e0,0xc9840185,0xbb3a0122,0x2019001e}},	//   _budi, _муси, _תעשי, hosi_,
   {{0x201907e1,0x644807e2,0x6d4507e3,0x656800e0}},	//   kosi_, _cudi, _mgha, _dedh,
   {{0xd77407e4,0x316707e5,0x201907e6,0xdce707e7}},	//   _واقع, _senz_, josi_, jajč,
   {{0x65680657,0x201907e8,0x69d507e9,0xdb040132}},	//   _fedh, dosi_, _koze, rdiç,
   {{0x69d507ea,0x6d45001e,0x27fd001e,0xbbd40325}},	//   _joze, _ngha, liwn_, _धक्क,
   {{0x273300e8,0x69d507eb,0x7e640602,0x64480053}},	//   _ảnh_, _moze, _swip, _gudi,
   {{0x6d4507ec,0xdb0607ed,0xfaff053e,0xef1f033e}},	//   _agha, _laká, _reën_, rgün_,
   {{0x69d50176,0xfaff053e,0x6d450024,0x6008013b}},	//   _ooze, _seën_, _bgha, sımo,
   {{0xc5f200c2,0x644807ee,0x9f590086,0x2be001c0}},	//   ִדן_, _yudi, ensä_, नस्थ,
   {{0xdcf701c2,0x764107ef,0x644807f0,0x20190195}},	//   _baxı, _mily, _xudi, bosi_,
   {{0x6618024e,0x776907f1,0x201907f2,0x2d8c0067}},	//   zovk, _neex, cosi_, żde_,
   {{0x69d507f3,0x6d450069,0xef1f07f4,0x4a4303e6}},	// [420] _boze, _fgha, ngül_, знув,
   {{0x3ea0010d,0xe9d707f5,0x9f59000d,0xa96a07f6}},	//   _ipit_, бку_, visé_, امام_,
   {{0x442f07f7,0xb86507f8,0xdb1d002a,0x6008037a}},	//   _ohg_, قانو, _bosó, yıml,
   {{0x644807f9,0x46ea07fa,0x9f59000d,0x76490138}},	//   _rudi, лден_, tisé_, _buey,
   {{0x6448011c,0x764107fb,0x661807fc,0xa6fa0037}},	//   _sudi, _bily, tovk, دعاء_,
   {{0x644807fd,0x7c2407fe,0x9f5902e1,0x442f010d}},	//   _pudi, llir, risé_, _ahg_,
   {{0xdcf701c2,0xd4670202,0x661807ff,0x7641001e}},	//   _yaxı, бије_, rovk, _dily,
   {{0xdb060076,0x32540800,0x77690801,0x938a05ac}},	//   _zaká, овир, _geex, уска_,
   {{0x20190802,0x6008033e,0x316c022e,0xaac80803}},	//   vosi_, rıml, tadz_, रमिक,
   {{0xc05a0804,0x64480805,0x7641001e,0x442f0159}},	//   лім_, _tudi, _gily, _ehg_,
   {{0x64480806,0x20190807,0x59c90808,0x3ea00809}},	//   _uudi, tosi_, रातर, _apit_,
   {{0x1ac800b8,0x7c24080a,0x00000000,0x00000000}},	//   रमाथ, jlir, --, --,
   {{0x2019080b,0x2d98080c,0x8af000a8,0x00000000}},	//   rosi_, ffre_, ncəd, --,
   {{0xddcd004e,0x6d48011c,0x2019080d,0x10f900b5}},	//   _stał, ždan, sosi_, ابیں_,
   {{0x69d5080e,0x7c24080f,0xd12f0810,0x9cc8010b}},	//   _roze, flir, _хх_, быта_,
   {{0x68e1007c,0x69d50811,0xdb0f0453,0x9b590812}},	//   _üldi, _soze, _hacé, риат_,
   {{0x69d50813,0xdd91004f,0x4424007c,0x77690814}},	// [430] _poze, _قوة_, ilm_, _reex,
   {{0x4424013c,0x6d45002f,0xceb4016b,0x00000000}},	//   hlm_, _ugha, _זיץ_, --,
   {{0x7c240815,0xdb1d0816,0x69d50817,0xdcf700a8}},	//   blir, _insí, _voze, _taxı,
   {{0x76410818,0x76b90819,0x764902d7,0x64420305}},	//   _sily, илер_, _puey, _nioi,
   {{0xdb2300f8,0x7641081a,0xdce50116,0x9a84081b}},	//   _روسی, _pily, _mehč, _нурл,
   {{0x27fd001e,0x442f081c,0x4efc011d,0xa2cc06fe}},	//   siwn_, _shg_, נהגו, तमन्,
   {{0x3623006c,0x628001bf,0x00000000,0x00000000}},	//   _ہورہ, ermo, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6442081d,0x7641008c,0x00000000,0x00000000}},	//   _dioi, _tily, --, --,
   {{0xe1f9081e,0xfaff053e,0xdb0f021d,0xef1f0448}},	//   рго_, _reël_, _cacé, rgül_,
   {{0x3ea0081f,0x600a0820,0xa06903fa,0x62800211}},	//   _spit_, ином_, јама_, armo,
   {{0xd9a60821,0x64420822,0x3ea0012f,0x7a30017b}},	//   _ऑस्ट, _gioi, _ppit_, mäte,
   {{0xdb0f01dd,0x11d50823,0x8db601e0,0x00000000}},	//   _facé, _мікр, осві, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x9d430009,0x00000000,0x00000000,0x00000000}},	//   дерд, --, --, --,
   {{0xdb0d0037,0xdb1d0824,0xfaff0298,0x00000000}},	//   adaí, _ensí, _teël_, --,
   {{0x533600c2,0xeab70036,0x7c360282,0x3ea00612}},	// [440] ַנען_, ойт_, rmyr, _upit_,
   {{0xa2cc0825,0xa6ca05f5,0xa2b10826,0x7a300827}},	//   _तपस्, یوال_, _अनन्, käte,
   {{0x7c240828,0xeb9a002d,0xa17a0070,0xb17a0070}},	//   plir, _кин_, שטעט, שטער,
   {{0xb09a0070,0xdb040079,0x7a300421,0x00000000}},	//   ייער, idiú, däte, --,
   {{0x7bc60829,0xdce700ea,0x00000000,0x00000000}},	//   _inku, majā, --, --,
   {{0x78af00c3,0xdce70228,0xfa67082a,0x00000000}},	//   äivä, lajā, _фарк_, --,
   {{0x37e600d4,0xdb0f002a,0xa6d80033,0x2be1021a}},	//   _довг, _racé, _দেশট, _नवमा,
   {{0x68e3082b,0x7dd000c3,0xdce70228,0x00000000}},	//   ønde, _väsy, najā, --,
   {{0x7762082c,0xc1a6052c,0xdceb082d,0x628003d0}},	//   mbox, ојни, _čiče, urmo,
   {{0x77620523,0x68e900b8,0x2be10035,0x64a6082e}},	//   lbox, _ředi, _नवभा, _маза,
   {{0x7bc6082f,0xc9530122,0xdce700ea,0x3d1a0099}},	//   _onku, ומת_, kajā, _मुले_,
   {{0x645a0095,0x80ab0026,0x68310830,0x6d4800f4}},	//   _itti, _जनरे, rådg, ždal,
   {{0xf7730122,0x11d30118,0x37bc0831,0x00000000}},	//   וקר_, ستید, _অকার, --,
   {{0x7bc60832,0x00000000,0x00000000,0x00000000}},	//   _anku, --, --, --,
   {{0xf1a90833,0xdb6b0834,0xdb0d0079,0x9b6b0279}},	//   _دانه_, ирал_, rdaí, ишаа_,
   {{0x3eb00086,0x3d1a00a1,0xf1e0021a,0x00000000}},	//   ältä_, _मुळे_, _पकडन, --,
   {{0x161a0835,0x2aab0836,0x776202d7,0x00000000}},	// [450] धवार_, штво_, dbox, --,
   {{0x645a0837,0x7bc60273,0x9998023a,0x657a00cc}},	//   _otti, _enku, _pirš_, _ndth,
   {{0x6d550035,0x00000000,0x00000000,0x00000000}},	//   mcza, --, --, --,
   {{0x27e900b5,0x9998010b,0x80380070,0x6d550067}},	//   óan_, _virš_, ַנגע_, lcza,
   {{0x645a0838,0x68e301b4,0xc21a0066,0x41bc012f}},	//   _atti, øndb, नकाब_, ्ञास,
   {{0x7a3001ae,0x6b8d0839,0x00000000,0x00000000}},	//   täte, lgag, --, --,
   {{0x69cd0099,0x00000000,0x00000000,0x00000000}},	//   साठी, --, --, --,
   {{0xf773083a,0x7a30083b,0x59c901d1,0x6aad023c}},	//   _زار_, räte, रावर, owaf,
   {{0x645a083c,0xdb0f0300,0x69c70009,0xc7b2011d}},	//   _etti, _incó, _knje, _אבן_,
   {{0x200b0067,0x765b083d,0x95c8083e,0x00000000}},	//   enci_, _ituy, _муха_, --,
   {{0x6d55004e,0xc617083f,0x69c70478,0x00000000}},	//   dcza, दकीय_, _mnje, --,
   {{0xdb040079,0x21e90168,0x6d550067,0x00000000}},	//   rdiú, _dúha_, ecza, --,
   {{0x63a90840,0xa3b4007c,0x33f40841,0xe1ee0842}},	//   meen, _छोट_, _تسلس, _зг_,
   {{0x63a90843,0xed570573,0x225f06d4,0x725a00a5}},	//   leen, зор_, mpuk_, _הכספ,
   {{0xdce700ea,0x8af000a8,0x800b00b5,0xa3cf00b4}},	//   tajā, hbət, _گروہ_, शाप_,
   {{0x69c70844,0x24510076,0x60dc0845,0x63a90846}},	//   _anje, _mám_, ärme, neen,
   {{0xfaa30847,0x765b0848,0x20020849,0xca86002d}},	// [460] нато, _ntuy, miki_, ягай,
   {{0x2002084a,0x14bd084b,0x63a90086,0x4efb00a5}},	//   liki_, ्माण, heen, _להפו,
   {{0x2451084c,0x69c7084d,0x63a9084e,0xf1d00023}},	//   _nám_, _dnje, keen, _hạch_,
   {{0x2002084f,0x69c70850,0x63a90851,0x7bc6007b}},	//   niki_, _enje, jeen, _unku,
   {{0x77620852,0xa3cf0084,0x63a90853,0xdb0601ff}},	//   rbox, शान_, deen, _bakå,
   {{0xf1d001a5,0xdb0f0391,0x9f590187,0x69c7003a}},	//   _mạch_, _encó, visí_, _gnje,
   {{0x245101a5,0x18a30854,0x247700af,0x765b0855}},	//   _cám_, _парм, găm_, _etuy,
   {{0x63a90856,0x24510857,0x20020858,0xa6d30033}},	//   geen, _dám_, jiki_, _দেওয়,
   {{0x36670859,0x2002085a,0x6d550035,0xdce500ea}},	//   _нато_, diki_, ycza, _mehā,
   {{0x683102df,0xe56100ee,0x00000000,0x00000000}},	//   råde, _päťč, --, --,
   {{0x80df00c8,0x63a9085b,0x2002085c,0x92cc0083}},	//   _ফেব্, been, fiki_, রনে_,
   {{0xf1d001a5,0x27e6085d,0x63a90139,0x2002085e}},	//   _bạch_, nkon_, ceen, giki_,
   {{0xf19400c3,0x00000000,0x00000000,0x00000000}},	//   _жиль, --, --, --,
   {{0xdb0f01f7,0x7a2b0225,0x27e6085f,0x00000000}},	//   _oncò, gütl, hkon_, --,
   {{0x20020860,0x24510019,0x6d550035,0x00000000}},	//   biki_, _xám_, rcza, --,
   {{0x69c7025c,0x27e60861,0x1bd40862,0x6b8d0863}},	//   _snje, jkon_, нося, ugag,
   {{0xf1d00019,0x27e600d5,0x00000000,0x00000000}},	// [470] _gạch_, dkon_, --, --,
   {{0x8af00095,0x2fc901e8,0x20b00864,0x321e0865}},	//   vbət, _hnag_, _जनाध, noty_,
   {{0x63a90866,0x4ddc00a5,0x67d50867,0x5c74002d}},	//   yeen, _לחזו, можу, _плэт,
   {{0xdb0f0033,0x321e0865,0x2a60006d,0x27e60008}},	//   _hací, hoty_, bpib_, gkon_,
   {{0x2451024e,0x9f4b0453,0x63a90868,0xdb0f0791}},	//   _sám_, licó_, veen, _kací,
   {{0x63a90869,0x2002086a,0x27e6029c,0x247700af}},	//   ween, ziki_, akon_, tăm_,
   {{0x63a9086b,0x5884086c,0x9f4b0453,0xdb0f0138}},	//   teen, _пыта, nicó_, _mací,
   {{0x2451086d,0x7a30086e,0xf8b200a5,0x247700af}},	//   _vám_, mäta, _בשל_, răm_,
   {{0x20020274,0x27ff05ca,0x765b0010,0x63a9086f}},	//   viki_, _imun_, _utuy, reen,
   {{0x81bc0080,0x13060086,0x68e1007c,0x63a90870}},	//   blēm, ьный_, _ülds, seen,
   {{0x66030871,0x20020872,0xf1d001a5,0x2fc901da}},	//   mink, tiki_, _sạch_, _bnag_,
   {{0x66030873,0x9f4b0831,0x2fc90874,0x351a0070}},	//   link, dicó_, _cnag_, _ווענ,
   {{0x20020875,0x62890876,0x8af001c2,0xddcd0877}},	//   riki_, queo, hbər, _svaš,
   {{0x66030878,0xc3320122,0x20020879,0x9f4b0831}},	//   nink, _סוג_, siki_, ficó_,
   {{0x27ed087a,0x8016087b,0x81bc0029,0x2002087c}},	//   _olen_, _офиц, klēj, piki_,
   {{0x6603087d,0x2d8401d6,0x22470523,0xbf9b0183}},	//   hink, şme_, _hink_, liên,
   {{0x6603087e,0xdb0f0391,0x78a900cb,0x2247087f}},	// [480] kink, _fací, _ćeva, _kink_,
   {{0xceb40669,0x66030880,0x27ff028b,0x27ed0881}},	//   _isə_, jink, _amun_, _alen_,
   {{0x66030882,0x16c60803,0x2fc9028b,0x27e60883}},	//   dink, लम्ब, _ynag_, tkon_,
   {{0xbf9b0023,0xfbdf0023,0x2b4b0176,0x9f4b027a}},	//   hiên, _hiên_, _ggcc_, licò_,
   {{0x27e60884,0xfbdf0019,0x8af000a8,0xdb1d01b4}},	//   rkon_, _kiên_, rbəs, _ansæ,
   {{0x27e60885,0x66030886,0x27ff01b7,0xdb0f0160}},	//   skon_, gink, _emun_, _facâ,
   {{0xbf9b03e6,0xc9270369,0xdcfe01d6,0x64a303fa}},	//   diên, _жорж_, _kapı, ваја,
   {{0xfbdf00e8,0x69dc0887,0x24800888,0xbf9b00f7}},	//   _liên_, _hore, čim_, nnêt,
   {{0x51860889,0x12be0033,0x22470051,0x23270274}},	//   муна, েন্দ, _bink_, моћи_,
   {{0xfbdf01a5,0x70c9045c,0x6603088a,0x69dc088b}},	//   _niên_, िमूल, cink, _jore,
   {{0x69dc088c,0x22470626,0x9f4b027a,0x321e088d}},	//   _more, _dink_, dicò_, roty_,
   {{0xe363088e,0x69dc088f,0xd011017e,0xa2a90354}},	//   _акци, _lore, الح_, _जैक्,
   {{0x3f8506d0,0xe81f0567,0xfbdf01a5,0xdb0f0890}},	//   ğlu_, यकता_, _biên_, _pací,
   {{0xbf9b0370,0x69dc0044,0x9f4b0453,0xdb060168}},	//   ciên, _nore, ticó_, _fakú,
   {{0x62860891,0xdb0f0020,0xdce70035,0x26c20355}},	//   škod, _vací, kają, _škol_,
   {{0x66030892,0xdb0d0370,0x22470893,0x1bb80037}},	//   zink, ndaç, _zink_, واقع_,
   {{0x66030894,0x63a20895,0x5a350896,0xdce7004e}},	// [490] yink, _mbon, енат, dają,
   {{0x69dc0897,0x7e6d0054,0xddc400cb,0x5887005f}},	//   _core, _iwap, _zviž, дыда,
   {{0x66030898,0x69dc0899,0x27ed089a,0x63a2089b}},	//   vink, _dore, _plen_, _obon,
   {{0x6603089c,0xdd0d004e,0x7e6d089d,0xdce70035}},	//   wink, półp, _kwap, gają,
   {{0x660301c8,0xf77005bc,0x3669089e,0x7af6004e}},	//   tink, شان_, чало_, czyt,
   {{0x69dc089f,0x7e6d08a0,0xfbdf00e2,0x00000000}},	//   _gore, _mwap, _xiên_, --,
   {{0xdcfe08a1,0x7bdd0306,0x764808a2,0x660308a3}},	//   _yapı, _kosu, _didy, rink,
   {{0x660308a4,0x7bdd0853,0xdb0601ba,0x69dc08a5}},	//   sink, _josu, _rakú, _zore,
   {{0x7bdd02b3,0xc24508a6,0x69c400b4,0x69dc08a7}},	//   _mosu, нник, राची, _yore,
   {{0x69dc0510,0xdb1d01ff,0x7bdd08a8,0xddc400ac}},	//   _xore, _insä, _losu, _sviž,
   {{0xbf9b0370,0x2000022e,0x91d00033,0x22470223}},	//   riên, _pmii_, িসংখ, _vink_,
   {{0x6e2502c2,0x34bd08a9,0x7bdd08aa,0x7e6d08ab}},	//   _akhb, ्मीद, _nosu, _bwap,
   {{0x22470176,0x63bb08ac,0x63b9016e,0x626401e0}},	//   _tink_, mdun, _iawn, _авіа,
   {{0x63bb08ad,0xf1d001a5,0x6fb20026,0x63b9003c}},	//   ldun, _hạnh_, _जसवं, _hawn,
   {{0xdca308ae,0xfbdf00e8,0x320508af,0x3d1a08b0}},	//   лари, _viên_, mily_, _मुखे_,
   {{0x63bb08b1,0xc4d200c2,0x7bdd08b2,0xdcfe00a8}},	//   ndun, נגן_, _cosu, _qapı,
   {{0x69dc08b3,0xc4bd00b4,0xfbdf0028,0x2ecb0387}},	// [4a0] _pore, ्मुख, _tiên_, ामृत,
   {{0xf1d001a5,0x81e10083,0x7ae4007b,0xdce70035}},	//   _lạnh_, নোর_, ryit, wają,
   {{0x69dc08b4,0xdcfe0716,0xc6d601cb,0xdce70035}},	//   _vore, _tapı, کتات, tają,
   {{0x764801a2,0x629b010b,0x672908b5,0x69dc08b6}},	//   _sidy, ktuo, _byej, _wore,
   {{0x69dc08b7,0x63bb08b8,0xdce70035,0x7c26009f}},	//   _tore, ddun, rają, _ikkr,
   {{0xb9060083,0x629b0430,0x7a300168,0xd5c70066}},	//   _বই_, dtuo, mäto, लागज,
   {{0x06d80083,0x764808b9,0x7bdd08ba,0xf7720037}},	//   _দেখি, _vidy, _yosu, _ماء_,
   {{0xf1d001a5,0x63bb0008,0x326608bb,0xd3700037}},	//   _cạnh_, gdun, нтов, جهة_,
   {{0x63b908bc,0x32050187,0x76480260,0x75280035}},	//   _dawn, fily_, _tidy, _wydz,
   {{0xa2b1035d,0x75280035,0x26c40065,0x7e6d0027}},	//   _अनर्, _tydz, _irmo_, _rwap,
   {{0xeb0d0084,0x68150035,0x63b90024,0x63bb0069}},	//   _सख्त_, ląda, _fawn, bdun,
   {{0x63a208bd,0x20d500c7,0x26c4023a,0x7e6d0107}},	//   _ubon, džią_, _krmo_, _pwap,
   {{0x32050076,0x91e608be,0x629b08bf,0x2d8508c0}},	//   bily_, _поде, ctuo, óleo_,
   {{0x92f2037a,0x7bdd08c1,0x00000000,0x00000000}},	//   ığım, _sosu, --, --,
   {{0x7bdd08c2,0xe5710070,0x63b908c3,0x442608c4}},	//   _posu, יַן_, _yawn, _kko_,
   {{0x7e6d08c5,0x4426023a,0x00000000,0x00000000}},	//   _twap, _jko_, --, --,
   {{0x16200066,0x7e6d08c6,0x442608c7,0xe9870274}},	// [4b0] मकार_, _uwap, _mko_, ећен,
   {{0x9999010b,0xafdb08c8,0x3ea90118,0x00000000}},	//   _rusų_, smød, _ipat_, --,
   {{0x44260202,0xd7c80118,0x78ba016f,0xa77508c9}},	//   _oko_, کونه_, _štvr, влеч,
   {{0x44260010,0x248e012f,0xfbdf0023,0x6b67000d}},	//   _nko_, dufm_, _kiêm_, _dégâ,
   {{0x7c2d08ca,0x212b0019,0x63b9007a,0x69c108cb}},	//   mlar, ́ch_, _rawn, _óleo,
   {{0x442608cc,0x7c2d08cd,0xe5a508ce,0xd12608cf}},	//   _ako_, llar, тики, _نم_,
   {{0x320508d0,0x34bd08d1,0xfbdf0019,0x66e700ea}},	//   vily_, ्मेद, _liêm_, _sīkā,
   {{0x7c2d08d2,0xd6d80083,0x629b08d3,0xe795006c}},	//   nlar, _দেওয, ttuo, _جاسک,
   {{0x63bb06a2,0x7c2d01d7,0x442608d4,0xfbdf0019}},	//   rdun, ilar, _dko_, _niêm_,
   {{0x3d1a006a,0x7c2d04d4,0x629b08d5,0x442608d6}},	//   _मुझे_, hlar, rtuo, _eko_,
   {{0x7c2d08d7,0x629b08d8,0xc95202b8,0x63b90024}},	//   klar, stuo, ימי_, _tawn,
   {{0x7c2d0723,0xdee608d9,0x629b0409,0x320500a5}},	//   jlar, воми, ptuo, sily_,
   {{0x443f08da,0x7c2d06d0,0x442d08db,0x20b00803}},	//   mmu_, dlar, mle_, _जनअध,
   {{0x644b08dc,0x3ea908dd,0x7c2d08de,0x62890079}},	//   _higi, _dpat_, elar, mreo,
   {{0x683808df,0x442d08e0,0x644b08e1,0x7c2d08e2}},	//   líde, ole_, _kigi, flar,
   {{0x2d8108e3,0x7c2d08e4,0xb7bc00c8,0x442d08e5}},	//   _edhe_, glar, _অক্ট, nle_,
   {{0x442d08e6,0xdb0f004f,0x201908e7,0x443f08e8}},	// [4c0] ile_, _pacá, érie_, imu_,
   {{0x644b08e9,0x442d08ea,0x443f08eb,0x00000000}},	//   _ligi, hle_, hmu_, --,
   {{0x7c2d08ec,0x443f08ed,0x442d08ee,0x7db500d8}},	//   blar, kmu_, kle_, _ёсьц,
   {{0x443f08ef,0x442d08f0,0x186708f1,0x7c2d08f2}},	//   jmu_, jle_, таци_, clar,
   {{0x442d000c,0x443f009f,0x6d5c0211,0x969601d3}},	//   dle_, dmu_, ocra, треш,
   {{0x442d08f3,0x442608f4,0x628908f5,0x443f08f6}},	//   ele_, _sko_, dreo, emu_,
   {{0x69ce08f7,0x644b0010,0x442d08f8,0xeb9f00d4}},	//   _inbe, _bigi, fle_, _kjøp_,
   {{0x68e308f9,0x7c2408fa,0xe4e300d4,0x644b0405}},	//   ände, noir, рішн, _cigi,
   {{0x1dc2021a,0x26c400be,0x00000000,0x00000000}},	//   शयात, _urmo_, --, --,
   {{0x442d08fb,0x7c2d08fc,0x644b08fd,0x443f01a8}},	//   ale_, zlar, _eigi, amu_,
   {{0x442d08fe,0x442608ff,0x7c2d0900,0xf9930122}},	//   ble_, _tko_, ylar, ברת_,
   {{0x4426070b,0x442d08fe,0x644b0901,0x62890037}},	//   _uko_, cle_, _gigi, breo,
   {{0x44240902,0x69ce0903,0x7c240904,0x7c2d0905}},	//   mom_, _onbe, doir, vlar,
   {{0x827700c2,0x644b0906,0x24580019,0xfbdf0019}},	//   _יעדע_, _zigi, _kém_, _viêm_,
   {{0x7c2d06a8,0x2bc40907,0x644b0908,0x7c24004f}},	//   tlar, _लोहा, _yigi, foir,
   {{0x69ce0909,0x0a6b052c,0xfbdf0023,0x7c2d0139}},	//   _anbe, држи_, _tiêm_, ular,
   {{0x7c2d090a,0x3b5406cd,0x3ea902b3,0x6d5c090b}},	// [4d0] rlar, ркур, _upat_, bcra,
   {{0x4424090c,0x7c2d090d,0x442d090e,0x00000000}},	//   hom_, slar, zle_, --,
   {{0x442d090f,0x44240910,0xf7730911,0x7c2d06d3}},	//   yle_, kom_, لاش_, plar,
   {{0x44240912,0x7c2d0669,0x69ce0913,0xb8db0914}},	//   jom_, qlar, _enbe, _अन_,
   {{0x442d0915,0xc178010b,0x644b0916,0x00000000}},	//   vle_, nkės_, _rigi, --,
   {{0x68380917,0x442d0918,0x69d8006c,0xdb0600b8}},	//   víde, wle_, övet, _jaký,
   {{0xd90f0919,0x442d091a,0x644b091b,0x443f091c}},	//   _بیا_, tle_, _pigi, tmu_,
   {{0x4424011c,0x6289091d,0x442d091e,0x443f091f}},	//   gom_, treo, ule_, umu_,
   {{0x442d0920,0x11d9004f,0x32d400d8,0x395102a7}},	//   rle_, فوظة_, ацэс, _kgzs_,
   {{0x442d0921,0x62890922,0xe0d90923,0x644b0924}},	//   sle_, rreo, ево_, _wigi,
   {{0x442d0925,0x44240926,0x3395006c,0x644b0927}},	//   ple_, bom_, _ملاز, _tigi,
   {{0x44240928,0x644b08c7,0x6838002a,0x00000000}},	//   com_, _uigi, píde, --,
   {{0x7c240248,0x3f9e0035,0x00000000,0x00000000}},	//   voir, ętu_, --, --,
   {{0x7bcf0929,0xdb04092a,0x645c0183,0x86350070}},	//   _ancu, leiç, _éric, טאָג_,
   {{0x7c2402e1,0x201900f7,0x0c79037c,0xa0a50812}},	//   toir, éric_, ксты_, _сайд,
   {{0xf0920122,0x6d5c092b,0x00000000,0x00000000}},	//   _הנה_, scra, --, --,
   {{0x7c24092c,0x00000000,0x00000000,0x00000000}},	// [4e0] roir, --, --, --,
   {{0x7bcf00c8,0x7c24092d,0x7a2b00ab,0x00000000}},	//   _encu, soir, kütu, --,
   {{0xdb04092e,0x2fd700d1,0x7c24000d,0x6fd80099}},	//   rdiñ, _شوید_, poir, यापू,
   {{0x27e000fb,0x61e005fc,0x78800076,0x4424092f}},	//   ðin_, _पक्ष, _návš, xom_,
   {{0x44240912,0x4a75086c,0x2bd10930,0xfbd10931}},	//   vom_, _выст, हारा, हारम,
   {{0x69ce02c9,0x442402b3,0x00000000,0x00000000}},	//   _unbe, wom_, --, --,
   {{0xa3cf021a,0xdb040279,0x356903d0,0xb4ce018d}},	//   शां_, feiç, трін_, शमे_,
   {{0x3a2a0932,0xd90d00d1,0x7e640933,0xf74607e5}},	//   _hkbp_, _تیم_, _otip, _бебо,
   {{0x81bc0029,0x644001a2,0x75d301cb,0x65960934}},	//   klēt, rmmi, _گيلا, _مجار,
   {{0x44240935,0x683800b8,0x245800a0,0xdd1f07c0}},	//   som_, bídc, _tém_, _líši,
   {{0x44240936,0x6ad102e4,0xf9930122,0x7e640937}},	//   pom_, _सप्र, זרת_, _atip,
   {{0xde5900d8,0x7e7d0938,0x1e1d0939,0xd36f017e}},	//   камі_, tssp, पक्ष_, _فهم_,
   {{0xbb1b0139,0x81e30033,0x00000000,0x00000000}},	//   _adîn, _নগর_, --, --,
   {{0xdb070332,0x7e7d093a,0xdb0600b5,0x52830037}},	//   ámít, rssp, _lakó, _الوك,
   {{0x7e640051,0x403505ac,0x9f520107,0x9998005f}},	//   _etip, _кекс, _olyè_, _birž_,
   {{0xf1d206bb,0xdb0600d0,0x7a2b033b,0x7a3001ba}},	//   तावन, _fakü, hütt, bätk,
   {{0x200b093b,0x4975093c,0xdb0601ba,0x7b640432}},	// [4f0] mici_, илас, _taký, стсе,
   {{0x200b093d,0xdd9101ca,0xd91b00c3,0x7e7b0009}},	//   lici_, _بود_, нье_, šups,
   {{0xd7e7093e,0x6d48093f,0x1a6505f5,0x00000000}},	//   лідо, ždar, _چیری_, --,
   {{0x200b0940,0x69d80941,0xf3f100e2,0x00000000}},	//   nici_, över, _mục_, --,
   {{0x7c3a00f7,0xdb1d0031,0xb5fd010b,0xdae600b5}},	//   ître, _masë, _atša, _پہلو_,
   {{0x48770206,0x7bd700d8,0x200b0942,0xdb0e0093}},	//   _مدرس, šbuč, hici_, _þjál,
   {{0xdb1d01b4,0x200b0943,0x25b60079,0x00000000}},	//   _ansø, kici_, شهيد_, --,
   {{0x200b0944,0x73e50945,0x69c90253,0x28e200ab}},	//   jici_, роиз, _होती, पहरि,
   {{0x200b0946,0x22150947,0x45d500af,0x00000000}},	//   dici_, ифор, _коас, --,
   {{0xe1250948,0x02050949,0x9f590036,0x7a3000c3}},	//   импи, рзон, misù_, vätk,
   {{0x200b094a,0xdb0602d0,0x7e64094b,0x6838094c}},	//   fici_, _jakò, _stip, lída,
   {{0x200b0676,0x7643094d,0xdb060359,0xf3f100e2}},	//   gici_, lmny, _makò, _dục_,
   {{0x3263006c,0xdb0602d0,0x2d9a01ef,0x326700ed}},	//   _انتہ, _lakò, _pcpe_, _стев,
   {{0x7e64024e,0x3f8c00a8,0x00000000,0x00000000}},	//   _vtip, şdu_, --, --,
   {{0x443d006f,0x7643022e,0x61e3094e,0x00000000}},	//   _khw_, imny, _ionl, --,
   {{0x61e3006c,0xab66094f,0x200b0950,0x7845010b}},	//   _honl, рвал, cici_, _tėvy,
   {{0x395600c9,0x7e64025c,0x61e3021e,0x7a2b006c}},	// [500] ањет, _utip, _konl, yütt,
   {{0x2fc001f7,0x61e30118,0xdb060260,0xdb1d0951}},	//   _haig_, _jonl, _bakò, _masè,
   {{0x61e30952,0x2cba002a,0x443d0051,0xdb1d0260}},	//   _monl, _uspd_, _ohw_, _lasè,
   {{0xb8ce0953,0x443d0297,0xe6660954,0x2d9802e9}},	//   _कह_, _nhw_, атко, lgre_,
   {{0xb86600b5,0x2fc00955,0xddd6024e,0x660a0034}},	//   _چارو, _maig_, _zvyš, tifk,
   {{0x200b0956,0xb8660957,0x2d980958,0x2fc00959}},	//   zici_, _نارو, ngre_, _laig_,
   {{0x660a095a,0x200b027d,0x3ea00024,0x7a300421}},	//   rifk, yici_, _lqit_, jäti,
   {{0xe8d70122,0x443d095b,0x7643006d,0x25a9011c}},	//   _דולר_, _chw_, amny, đala_,
   {{0x9f49027d,0x78af011c,0x443d095c,0x683801ef}},	//   _ilaç_, čivš, _dhw_, cída,
   {{0x95c7095d,0xc05a01c8,0x61e3095e,0x31600207}},	//   _клуб_, кім_, _conl, _đizs_,
   {{0x3a370397,0x61e3095f,0x3957011d,0xe97b0070}},	//   שרים_, _donl, ישים_, כניש,
   {{0x2fc0006d,0xf42700af,0x00000000,0x00000000}},	//   _caig_, _кохл_, --, --,
   {{0x200b0960,0x2fc00961,0x00000000,0x00000000}},	//   rici_, _daig_, --, --,
   {{0x200b0962,0x62800523,0x628201bf,0x2d8500a2}},	//   sici_, msmo, _ivoo, ûle_,
   {{0x52b60963,0x02b60964,0x6e270965,0x200b0966}},	//   _अनुस, _अनुन, rojb, pici_,
   {{0x3b550209,0xd0f700a5,0x2fc00176,0x61e302a2}},	//   скар, _כמות_, _gaig_, _zonl,
   {{0xa3a80967,0x62800968,0xdb1d0118,0x7d1e0282}},	// [510] ख्य_, nsmo, _kasé, _exps,
   {{0x99670969,0xf993096a,0x683800b8,0x628001ed}},	//   ртал, تبر_, vída, ismo,
   {{0x2fc001e8,0xdb1d096b,0xb9c40037,0x00000000}},	//   _yaig_, _masé, تقلي, --,
   {{0x2a69018d,0x62820207,0x00000000,0x00000000}},	//   ppab_, _ovoo, --, --,
   {{0x6fd800a1,0x27e400af,0xf9930037,0x26c901ef}},	//   यातू, _domn_, _وبس_, íao_,
   {{0x7aed096c,0x6280096d,0xa2b70355,0x00000000}},	//   myat, dsmo, ्टस्, --,
   {{0xfc3f0028,0x7aed096e,0x26c200f4,0x61e30069}},	//   _khí_, lyat, _škot_, _ronl,
   {{0x2489096f,0x81c30083,0xe3b90970,0x61e30971}},	//   čam_, _একই_, уби_, _sonl,
   {{0x7aed0452,0xdb1d0972,0xfc3f004f,0x61e30300}},	//   nyat, _basé, _mhí_, _ponl,
   {{0x6282082d,0x20090973,0x7a300974,0x61fa00a5}},	//   _dvoo, _amai_, täti, ghtl,
   {{0x628003bc,0x61e303f4,0x443d02b1,0x62820207}},	//   asmo, _vonl, _thw_, _evoo,
   {{0xfc3f0019,0xfbdf0023,0x7a300975,0x00000000}},	//   _nhí_, _kiêu_, räti, --,
   {{0x2fc00955,0x0cd00162,0x62800069,0x7a300086}},	//   _vaig_, हम्म, csmo, säti,
   {{0x61fa0976,0x7aed0977,0xfc3f0033,0xfbdf0023}},	//   chtl, dyat, _ahí_, _miêu_,
   {{0x40950514,0xfc3f0514,0x2fc001e8,0xfbdf0019}},	//   _العر, _bhí_, _taig_, _liêu_,
   {{0xfc3f0028,0x3ce5022a,0x7ff60609,0x79870359}},	//   _chí_, älva_, _دستا, _adjw,
   {{0x68e30301,0x7aed00fd,0x44c700e2,0x27e4009e}},	// [520] ändn, gyat, _lđ_, _romn_,
   {{0xc3320052,0x27e400af,0xdb04000d,0xddcd0097}},	//   לון_, _somn_, nfié, _zvaž,
   {{0xe93a015a,0x44c70023,0xb17a0070,0x9f490176}},	//   учај_, _nđ_, רטער, _plaç_,
   {{0x62800978,0x7aed0979,0x8b96097a,0x00000000}},	//   ysmo, byat, _уроч, --,
   {{0x7aed007b,0x673b0035,0x683800b8,0x00000000}},	//   cyat, _czuj, bídn, --,
   {{0x99d603c7,0xd49a097b,0x44c700e2,0x600f0359}},	//   _اتحا, гри_, _bđ_, _kòmè,
   {{0x320c0260,0x44c70019,0x758901e0,0xdb1d000d}},	//   vidy_, _cđ_, рсів_, _rasé,
   {{0xc7a3097c,0x6280097d,0x6286010b,0x07a303d0}},	//   _ниск, tsmo, škom, _насн,
   {{0x6d430097,0x320c097e,0xdb1d0118,0x00000000}},	//   _únav, tidy_, _pasé, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x20190370,0x44c700e2,0x3fd9002d,0x546a0279}},	//   ério_, _gđ_, амнэ_, _саем_,
   {{0x7aed01c2,0xf53700a5,0xdb0f0042,0x657a00e5}},	//   yyat, _פנאי_, _vacú, _heth,
   {{0x657a00d1,0x733600bf,0x8336097f,0x74c00355}},	//   _keth, _ارائ, _اراض, विकृ,
   {{0x329b02da,0x645a0980,0x657a0981,0x7aed0982}},	//   _עבוד, _kuti, _jeth, vyat,
   {{0xfc3f0028,0x657a0983,0xf1a900bf,0x645a0984}},	//   _phí_, _meth, _خانه_, _juti,
   {{0x645a0985,0x657a0986,0x317e01ae,0x7aed0987}},	//   _muti, _leth, latz_, tyat,
   {{0x645a0988,0x1a5b004f,0xed4e00b5,0x00000000}},	// [530] _luti, اشرة_, ٹھی_, --,
   {{0x645a02e1,0x317e0989,0x9f4b0355,0x657a098a}},	//   _outi, natz_, nkcí_, _neth,
   {{0xe8e0098b,0x2bc402cb,0xfbdf0023,0x3178004e}},	//   ười_, _लोका, _siêu_, órzy_,
   {{0x317e098c,0x657a098d,0x473503e6,0x00000000}},	//   hatz_, _aeth, онес, --,
   {{0x657a098e,0x6aa4098f,0x3f89002f,0x6286010b}},	//   _beth, ctif, _mdau_, škoj,
   {{0x645a0990,0x25a9044d,0x657a00d1,0x2bd106fe}},	//   _buti, đalo_, _ceth, हाका,
   {{0x69d50991,0x645a002d,0x8ccc0992,0x44290019}},	//   _inze, _cuti, हियो, _ưa_,
   {{0xfbdf0028,0x69c50993,0x657a0051,0x61f80223}},	//   _tiêu_, ldhe, _eeth, _alvl,
   {{0xe1f90994,0x6fdd02cb,0xdb1d0995,0x657a0996}},	//   иги_, यानं, _insó, _feth,
   {{0x69c50997,0x657a0998,0x00850036,0x44c700e2}},	//   ndhe, _geth, олоо, _tđ_,
   {{0xf99202da,0x69c5004a,0x645a0999,0x7a300086}},	//   ורי_, idhe, _guti, mätt,
   {{0x7a30099a,0x777b0248,0x81bc00ea,0x26cd02d7}},	//   lätt, _jeux, slēp, _kreo_,
   {{0xeef501c8,0x3f89001e,0x645a099b,0x69d5099c}},	//   пярэ, _ddau_, _zuti, _onze,
   {{0x317e034d,0x201901d1,0x442f0118,0x2d9e099d}},	//   catz_, ansi_, _hkg_, üte_,
   {{0x69c5099e,0x68e3033b,0xd1b8099f,0x271509a0}},	//   ddhe, ändl, _دانا_, तपुर_,
   {{0x69d502bf,0xa2cd00b8,0x6aa409a1,0x63a909a2}},	//   _anze, तिप्, ttif, nfen,
   {{0xb4b609a3,0x261a017a,0x7bc409a4,0xfaa309a5}},	// [540] _छन्_, _बदली_, rdiu, мато,
   {{0x69c509a6,0x8eb3006c,0xe9d709a7,0x99630097}},	//   gdhe, _کمیش, оку_, _píšu_,
   {{0x02b609a8,0xd910006c,0x7a300421,0x20dc00a0}},	//   _अन्न, ریر_, dätt, pšiť_,
   {{0x657a00f8,0x69c509a9,0x69d509aa,0x65630019}},	//   _seth, adhe, _enze, ecnh,
   {{0x26cd09ab,0x645a00d8,0x777b0248,0x657a09ac}},	//   _creo_, _suti, _deux, _peth,
   {{0x63a909ad,0x7c3609ae,0x7641016e,0x7aeb09af}},	//   efen, llyr, _chly, ägte,
   {{0x63a909b0,0x5fca09b1,0x6fca0325,0x5fdd084b}},	//   ffen, ियाल, ियां, यामल,
   {{0x657a09b2,0x63a9001e,0x26cd002a,0xdb1d0392}},	//   _weth, gfen, _freo_, _insò,
   {{0x657a09b3,0x26cd011e,0x7a300523,0x23a609b4}},	//   _teth, _greo_, bätt, क्षद,
   {{0x914a09b5,0x645a09b6,0x154600af,0x238c00c7}},	//   ична_, _tuti, _дезм, dėjų_,
   {{0x645a03ad,0x425400d1,0x317e09b7,0x1dde09b8}},	//   _uuti, _کنتر, ratz_, मानत,
   {{0x317e01ae,0xddc40160,0x765b0103,0x00000000}},	//   satz_, _puiş, _yuuy, --,
   {{0x41e600d8,0x00000000,0x00000000,0x00000000}},	//   _міка, --, --, --,
   {{0x81f809b9,0x3f84008d,0x386a0183,0x00000000}},	//   _دفتر_, ómur_, _otbr_, --,
   {{0x271c01a5,0x644209ba,0x71260037,0x00000000}},	//   ỉnh_, _khoi, _برشل, --,
   {{0x3958013a,0xdfd10079,0x929d0067,0x00000000}},	//   _agrs_, _أية_, szłe, --,
   {{0x34b7051d,0x644209bb,0x8af000a8,0xdb1d0260}},	// [550] _आन्द, _mhoi, dcəs, _ansò,
   {{0x78a500fb,0x25ef0380,0x59d201d1,0x683800ac}},	//   tthv, _अवधी_, सागर, sídl,
   {{0x69c509bc,0x290701da,0x26cd011c,0x9f400093}},	//   rdhe, àna_, _sreo_, _hlið_,
   {{0x26cd0009,0x78a509bd,0x76410031,0x69c50031}},	//   _preo_, rthv, _shly, sdhe,
   {{0x2bc40302,0x7c2d0074,0x7bda0122,0x7a300974}},	//   _लोटा, moar, _הקרו, tätt,
   {{0x7c2d09be,0x26cd0043,0x29070037,0x1dde021a}},	//   loar, _vreo_, únas_, मायत,
   {{0x7a3009bf,0x644202a8,0x6ab90095,0xdb1d05ed}},	//   rätt, _bhoi, şafı, _masí,
   {{0x7a3009bf,0x57b409c0,0x644209c1,0x7c2d06a2}},	//   sätt, _обст, _choi, noar,
   {{0xd5bb09c2,0x644209c3,0x63a909c4,0x7c2d01a3}},	//   _все_, _dhoi, rfen, ioar,
   {{0x7c2d09c5,0xdb0d09c6,0x00000000,0x00000000}},	//   hoar, ndañ, --, --,
   {{0xf9920779,0x6442003b,0x7c2d0291,0x3eb209c7}},	//   ערט_, _fhoi, koar, _spyt_,
   {{0xb4d70567,0xa3bb03c5,0x644209bb,0x7f85006c}},	//   ामी_, _خاطر_, _ghoi, ولپن,
   {{0x7c2d09c8,0x644909c9,0xdb1d09ca,0x317c023a}},	//   doar, mmei, _basí, _fevz_,
   {{0x644909cb,0xdb1d007e,0xfce609cc,0x8b080067}},	//   lmei, _casí, пого, nięż,
   {{0xe6b80240,0x7c2d09cd,0x1fb609ce,0x7c3a00a2}},	//   _इन्ज, foar, _еспр, îtro,
   {{0x644909cf,0x1e8609d0,0x7c2d09d1,0x00000000}},	//   nmei, _елим, goar, --,
   {{0x3f8209d2,0xdcfc0506,0x00000000,0x00000000}},	// [560] maku_, marč, --, --,
   {{0x3f820614,0x644909d3,0x442d09d4,0x386a0069}},	//   laku_, hmei, hoe_, _ptbr_,
   {{0x53bd0378,0x9f5900de,0xb3bd01d1,0x644909d5}},	//   ्याश, cisó_, ्याख, kmei,
   {{0x3f8209d6,0x7a3001ae,0xdb1d00b8,0x7c2d0171}},	//   naku_, täts, _zasí, coar,
   {{0x442d09d7,0x5fdd00a1,0x644909d8,0x2907008d}},	//   doe_, यातल, dmei, únar_,
   {{0x7bc609d9,0x644209c3,0xe5340572,0x3f8209da}},	//   _haku, _shoi, мель, haku_,
   {{0x7bc609db,0x6442066a,0x3f8209dc,0x6449095a}},	//   _kaku, _phoi, kaku_, fmei,
   {{0x293702b5,0x7bc609dd,0x00000000,0x00000000}},	//   _זאלן_, _jaku, --, --,
   {{0x7bc609de,0xdb0d0093,0x64a000f4,0x00000000}},	//   _maku, ndað, dšiš, --,
   {{0x7bc609df,0x7c2d09e0,0x6e2e09e1,0x644209e2}},	//   _laku, zoar, jobb, _whoi,
   {{0x644209e3,0x5f9509e4,0x6e2e09e5,0x442d09e6}},	//   _thoi, минт, dobb, boe_,
   {{0x7c2d06a2,0x3f8209e7,0x04db00a5,0xab5b01f7}},	//   xoar, gaku_, _לקבל, _caül,
   {{0x7c2d002d,0x63a209e8,0xdb0d0279,0xdb1d00a0}},	//   voar, _icon, meaç, _pasí,
   {{0x91e309e9,0x611409ea,0x7bc6010d,0x9f590079}},	//   _поче, _одлу, _aaku, mhsí_,
   {{0x7c2d09eb,0x7bc609ec,0x3f8209ed,0x7d2406e4}},	//   toar, _baku, baku_, ефте,
   {{0x7bc609ee,0x61ea09ef,0x2c0d0099,0x3f8209f0}},	//   _caku, _hofl, _सगळं_, caku_,
   {{0x4a5509f1,0x7c2d06a2,0x7bc609f2,0xb3a90033}},	// [570] дкас, roar, _daku, _খোঁজ,
   {{0x7c2d09f3,0x6838000c,0x7e6d09f4,0x5a3403fa}},	//   soar, bídk, _itap, енут,
   {{0x7bc609f5,0x2d8309f6,0x41ae0967,0x7c2d09f7}},	//   _faku, maje_, ज्यस, poar,
   {{0x27e9064b,0x2d9c06d7,0x2d8309f8,0x6568028b}},	//   ðan_, _över_, laje_, _afdh,
   {{0x6fa509f9,0x442d02c4,0x7e69002d,0xe69b0067}},	//   _कानू, voe_, _împă, _żołą,
   {{0x7bc609fa,0x2d8309fb,0xdcfc02a7,0x7e6d08c7}},	//   _zaku, naje_, zarč, _mtap,
   {{0x7bc606f9,0x442d09fc,0x644909fd,0x7e6d028b}},	//   _yaku, toe_, tmei, _ltap,
   {{0x69c709fe,0x7e6d09ff,0x2d830a00,0x9cd8024b}},	//   _haje, _otap, haje_, לווה_,
   {{0x69c70a01,0x64490a02,0x442d095e,0xdcfc0a03}},	//   _kaje, rmei, roe_, varč,
   {{0xa8790070,0x3f820a04,0x69c70a05,0x442d0a06}},	//   ֿאָר, waku_, _jaje, soe_,
   {{0x3f820118,0x9327006c,0x63a20a07,0x7e6d0a08}},	//   taku_, _کران, _fcon, _atap,
   {{0x69c700bf,0x63a20037,0x68380355,0xa2cd06bc}},	//   _laje, _gcon, vídk, तिद्,
   {{0x63bb023c,0xb5fd0a09,0x00000000,0x00000000}},	//   meun, _atši, --, --,
   {{0x7bc60a0a,0x69c70a0b,0x3f820a0c,0x2d830a0d}},	//   _saku, _naje, saku_, gaje_,
   {{0xed570272,0x7bc60a0e,0x3f820a0f,0x6e2e0a10}},	//   дор_, _paku, paku_, robb,
   {{0x6e2e0a11,0x8c4306e4,0xaac902b4,0x00000000}},	//   sobb, весе, रिंक, --,
   {{0x69c70a12,0x7bc60a13,0x2d830a14,0xc222006c}},	// [580] _baje, _vaku, baje_, _سکیو,
   {{0x7bc60a15,0x7c290a16,0x68380279,0x69c70a17}},	//   _waku, čera, mídi, _caje,
   {{0xb4d707b5,0x69c70a18,0x1c460a19,0x00000000}},	//   ामो_, _daje, _оном, --,
   {{0x63bb0a1a,0x00000000,0x00000000,0x00000000}},	//   jeun, --, --, --,
   {{0xa3e1035d,0x63bb0a1b,0x69c70a1c,0x6b840a1d}},	//   दान_, deun, _faje, maig,
   {{0x6b84066a,0x69c70a1e,0x63a20a1f,0x00000000}},	//   laig, _gaje, _scon, --,
   {{0x628f0a20,0x61ea0a21,0xe9a30a22,0xdb0f00f6}},	//   ácon, _rofl, _шарп, _abcè,
   {{0x69c70a23,0x6b840a24,0x2d830a25,0xd9430a26}},	//   _zaje, naig, zaje_, _реси,
   {{0x752d00d0,0x2d830a27,0xdb1d00ac,0x69c70a28}},	//   ğaza, yaje_, _kasá, _yaje,
   {{0x27e60a29,0x6b840a2a,0x24f60a2b,0x683801ef}},	//   ljon_, haig, _очер, dídi,
   {{0xdb1d024e,0x2d830a2c,0x6b840a2d,0x7e6d0a2e}},	//   _masá, vaje_, kaig, _stap,
   {{0x68e30a2f,0x83fc044d,0x63bb01ef,0x2d830a30}},	//   ändi, _buđe, ceun, waje_,
   {{0x2d830a31,0x6b840a32,0xfe6e00b5,0xe46a0093}},	//   taje_, daig, یگی_, blöð_,
   {{0x02bc0026,0x61ac0033,0xdb1d0097,0x26c4021d}},	//   ्टीन, _কোরআ, _nasá, _msmo_,
   {{0x2d830a33,0x6b840037,0x7c84002d,0x3f800211}},	//   raje_, faig, куте, _feiu_,
   {{0x2d830a34,0xa3e10324,0xa008004f,0x69c70a35}},	//   saje_, दाय_, _يقول_, _saje,
   {{0x69c70a36,0x7e6d0a37,0x2d830a38,0x68380a39}},	// [590] _paje, _utap, paje_, cídi,
   {{0x2fc90a3a,0x1e14002d,0xb5fd0207,0xdb1d0a3b}},	//   _haag_, _амья, _kuše, _casá,
   {{0x6b8400d8,0x61e7013c,0x69c70a3c,0x26c401a3}},	//   baig, öjli, _vaje, _asmo_,
   {{0x69c70a3d,0x6b840a3e,0x2fc9053e,0x27e60a3f}},	//   _waje, caig, _jaag_, gjon_,
   {{0xb4d70a40,0xdb1d0a41,0xd7c80a42,0x2fc90a43}},	//   ाम्_, _ansö, بونه_, _maag_,
   {{0xa2cd0a44,0x7a2b01ae,0x2fc902e6,0x69c708c7}},	//   तिस्, hütz, _laag_, _uaje,
   {{0x63bb0a45,0x2d8100ab,0x97a70a46,0x6fa500a1}},	//   teun, _mehe_, _орал, _काढू,
   {{0x2d810a47,0x321e0355,0xee3f01ba,0x75fd0260}},	//   _lehe_, enty_, dtým_, _dèza,
   {{0xc6a4087b,0x63bb0a48,0xb06500c3,0x17f80037}},	//   _архи, reun, kyää, _غرفة_,
   {{0xddc401cc,0x63bb0a49,0xdb040a4a,0xb5fd0a4b}},	//   _otiš, seun, nfiá, _buše,
   {{0x83fc0254,0xdcfc013a,0x27ff02a7,0x00000000}},	//   _suđe, karā, _klun_, --,
   {{0xb5fd0a4c,0x2fc901e8,0x6838002a,0x27ed0328}},	//   _duše, _caag_, tídi, _joen_,
   {{0x2fc90a4d,0x79850a4e,0x2d8101a3,0x25f500b4}},	//   _daag_, kahw, _behe_, ्सपी_,
   {{0x68380a4f,0x27ff001e,0x20020a50,0x11d90037}},	//   rídi, _llun_, shki_, _روعة_,
   {{0x6b840a51,0xc5f200c2,0x64590a52,0x7c290a53}},	//   taig, נדל_, _kiwi, čern,
   {{0x68380a54,0x64590118,0x83fc011c,0x27ed0a55}},	//   pídi, _jiwi, _tuđe, _noen_,
   {{0x64590a56,0x6b840a57,0x499600af,0xda650286}},	// [5a0] _miwi, raig, ешет, نالي,
   {{0x6b84009c,0x2d8101ae,0x27ff0a58,0x62890037}},	//   saig, _gehe_, _alun_, iseo,
   {{0x6d5e02b3,0x7d7b00a5,0xdb1d00b5,0x6b840a59}},	//   _igpa, _מניו, _vasá, paig,
   {{0x1dde052f,0x25a500e5,0x64590a5a,0x27ff00e5}},	//   मावत, _acll_, _niwi, _clun_,
   {{0x27ed019c,0x6d5e012f,0x79850010,0x27e60a5b}},	//   _doen_, _kgpa, bahw, rjon_,
   {{0x27e60a55,0x25a50176,0x2d810065,0x3e6600e2}},	//   sjon_, _ccll_, _xehe_, _môt_,
   {{0xd9430a5c,0x69dc0a5d,0x8cd30a5e,0x6d5e010d}},	//   _бери, _inre, डियो, _mgpa,
   {{0xb5fd01a0,0xb4b00006,0x27ff05b9,0x64590a5f}},	//   _ruše, _ओही_, _glun_, _ciwi,
   {{0x7ae4043f,0xa2cd035d,0x64590a60,0xaac901c0}},	//   nxit, तिष्, _diwi, रिएक,
   {{0xb5fd0a61,0x44ce004e,0x171b0070,0x2fc90a62}},	//   _puše, _tę_, _זומע, _saag_,
   {{0x7a2b02c9,0x200001da,0x2d810a63,0x98b300cd}},	//   tütz, _blii_, _rehe_, čeće_,
   {{0x2d8101ae,0x20000211,0x64590090,0x00000000}},	//   _sehe_, _clii_, _giwi, --,
   {{0x69dc03c4,0xddc40a16,0xdcfc02d4,0x20000211}},	//   _onre, _stiš, varā, _dlii_,
   {{0xa2cd0a64,0x62860a65,0xb5fd0a66,0x80d0021a}},	//   तिर्, škos, _tuše, धिदे,
   {{0x2fc9006d,0x765a0a67,0x9c47021f,0xd24d05f5}},	//   _taag_, _mity, ехал, _بچي_,
   {{0x69dc0a68,0x7c290a69,0xd7cf007c,0xc178010b}},	//   _anre, čero, _सोंच, lbė_,
   {{0x3b550a6a,0x5a3506c2,0x2d810a6b,0xa3e105f7}},	// [5b0] ткар, внат, _tehe_, दात_,
   {{0x27ed0a6c,0x765a0088,0x61fa0a6d,0xb4b0007c}},	//   _soen_, _nity, nktl, _ओहू_,
   {{0x79850a6e,0xdcfc00ea,0xe61100b5,0x27ed0a6f}},	//   rahw, parā, یشت_, _poen_,
   {{0x69dc0a70,0x87e40a71,0x2000009e,0xe7190037}},	//   _enre, люче, _xlii_, ويات_,
   {{0xf7700a72,0x7bdd0a73,0x765a0a74,0x00000000}},	//   صان_, _insu, _bity, --,
   {{0x0c7400bf,0x6aad002f,0x248c0168,0x27e000ea}},	//   _جدید, mtaf, _bvdm_, ķina_,
   {{0xdb04008a,0x27ed0a75,0x765a00f8,0x6aad0a76}},	//   leið, _toen_, _dity, ltaf,
   {{0xc447006c,0x7bcd0a77,0x27ff07d4,0x1958021f}},	//   ریشن_, ndau, _ulun_, _часы_,
   {{0x24800a78,0x3863012f,0x7c3a0248,0x6459002f}},	//   ćima_, _hujr_, îtri, _viwi,
   {{0x62890a79,0x645900bf,0x765a0a7a,0x7bdd0430}},	//   rseo, _wiwi, _gity, _lnsu,
   {{0x7bdd0a7b,0x34940a7c,0x62890a7d,0x67290069}},	//   _onsu, _бахр, sseo, _hxej,
   {{0xdb040093,0xb4bd00ab,0x6289018d,0x00000000}},	//   keið, इबी_, pseo, --,
   {{0x6d450a7e,0x764800c3,0x62860207,0x00000000}},	//   _azha, _yhdy, škor, --,
   {{0x7bdd0a7f,0x51870a80,0x7af60421,0x00000000}},	//   _ansu, _чуда, vyyt, --,
   {{0x6e3c00e5,0x15f40a5e,0x75fd0260,0x6aad0a81}},	//   rlrb, _अवसर_, _lèzo, etaf,
   {{0x3e660a82,0x7ae401d7,0x7bcd043d,0x9f060088}},	//   _tôt_, txit, gdau, _لوبو,
   {{0xdfd20332,0x6d4500d7,0xa9a6081b,0x00000000}},	// [5c0] _ميں_, _ezha, киад, --,
   {{0xfe9b02b8,0xafdb0185,0x7bdd0a83,0x6d5e011e}},	//   _קיימ, smøt, _ensu, _ugpa,
   {{0x83fc025c,0x7e640086,0x7af600c3,0xeb9f08c8}},	//   _luđa, _huip, syyt, _blød_,
   {{0xdb04003e,0x7e640a84,0x660100ab,0x765a02d0}},	//   beið, _kuip, _allk, _sity,
   {{0x765a0a85,0x77910a86,0xc17800d8,0xc7a30a87}},	//   _pity, صیلا, ybė_, ричк,
   {{0x68380279,0x69dc0a88,0x9633010b,0x00000000}},	//   vídu, _unre, аніц, --,
   {{0x38630118,0x7e640a89,0xeb9f0a8a,0x765a0a8b}},	//   _gujr_, _luip, _flød_, _vity,
   {{0x83fc0009,0xeb9f0a8c,0x59e001d1,0x656a0098}},	//   _buđa, _glød_, नावर, scfh,
   {{0x2a660079,0x765a030d,0x00000000,0x00000000}},	//   íobh_, _tity, --, --,
   {{0x320500a5,0x765a021e,0x00000000,0x00000000}},	//   ghly_, _uity, --, --,
   {{0xa99b02b5,0x68380279,0x61fa0a8d,0xbb1b00af}},	//   וביר, sídu, rktl, _neîn,
   {{0xc05801c8,0x66180a8e,0xeb9f0a8a,0x00000000}},	//   кія_, livk, _kløe_, --,
   {{0x442600f8,0xa29400d8,0x7e640118,0x00000000}},	//   _ijo_, _салі, _cuip, --,
   {{0x273101a5,0x32050a8f,0xdb040093,0xb5fd0506}},	//   ỡng_, chly_, veið, _kuša,
   {{0x4426071f,0xab9502bb,0xb4b0052f,0xe6bf0a90}},	//   _kjo_, ливі, _ओहो_, _एन्ज,
   {{0x6aad0a91,0x2cba0160,0xb5fd0a92,0xa4b700a5}},	//   ttaf, _dppd_, _muša, כללה_,
   {{0xab840a93,0x20190a94,0x7e640a95,0x44260282}},	// [5d0] руск, misi_, _guip, _mjo_,
   {{0xdb040093,0xb5fd0009,0x7bcd0a96,0x661808b7}},	//   reið, _ouša, sdau, jivk,
   {{0x6aad0a97,0x44260a98,0x9964021d,0x67d503e6}},	//   staf, _ojo_, ртул, ложу,
   {{0x7bdd0a99,0x20190a9a,0xc79400d8,0xba77017e}},	//   _unsu, nisi_, аршы, _لاست,
   {{0x4b7a02da,0xa3e1017a,0xdb1d0523,0x3a840104}},	//   _ראשו, दास_, _baså, _высв,
   {{0xd1260a9b,0x4426071f,0xa2b8051d,0x2019000e}},	//   _هم_, _ajo_, ्बन्, hisi_,
   {{0x2baa0355,0x20190a9c,0x442606f2,0xb4bd00ab}},	//   ङ्का, kisi_, _bjo_, इबे_,
   {{0x20190a9d,0x957c005f,0x6e350065,0x00000000}},	//   jisi_, _anąd, hozb, --,
   {{0x20190a9e,0xe3b6021f,0x44260260,0x55a500b5}},	//   disi_, убы_, _djo_, _مجاہ,
   {{0x44260010,0xa3e104bc,0x6e3500cd,0x60e90a9f}},	//   _ejo_, दाह_, jozb, емом_,
   {{0x20190aa0,0x7c2903ab,0xb5fd0009,0x7e6409a9}},	//   fisi_, čerj, _guša, _suip,
   {{0xc50c0070,0x20190aa1,0xbb1b00af,0x7e64026e}},	//   _קלאָ, gisi_, _reîn, _puip,
   {{0x443f0aa2,0xd24e00f8,0x7e6400f6,0x2cba00d7}},	//   mlu_, تنی_, _quip, _sppd_,
   {{0x443f0aa3,0x831a02b5,0xdca60281,0x2292004f}},	//   llu_, _אונז, лаги, _الوس,
   {{0x20190aa4,0x443f018d,0x00000000,0x00000000}},	//   bisi_, olu_, --, --,
   {{0x443f0aa5,0x20190aa6,0x3ec900c3,0x68380138}},	//   nlu_, cisi_, ättä_, hídr,
   {{0x2baa0355,0xfbaa0355,0x443f0aa7,0x8eb300f8}},	// [5e0] ङ्गा, ङ्गम, ilu_, _هميش,
   {{0x443f0aa8,0xd8390107,0x7a30033b,0x00000000}},	//   hlu_, _akō_, lätz, --,
   {{0x443f0aa9,0xb8650aaa,0x3ea20aab,0xad5a0210}},	//   klu_, لانو, lukt_, _ярих_,
   {{0x443f0aac,0x2bab0aad,0x2d8a0273,0x2a69006d}},	//   jlu_, _छाया, labe_, bqab_,
   {{0x443f0aae,0x60060aaf,0xb5fd0ab0,0xa3d70826}},	//   dlu_, _góme, _suša, ायन_,
   {{0x45d40ab1,0x7a3001ae,0x7c24002d,0x443f0ab2}},	//   рокс, hätz, lnir, elu_,
   {{0x20190ab3,0x443f0ab4,0x5faa00a1,0x7c240ab5}},	//   yisi_, flu_, _काढल, onir,
   {{0x69ce0ab6,0x7c240ab7,0x68e30ab8,0x2d8a0ab9}},	//   _habe, nnir, ånde, habe_,
   {{0x69ce0aba,0x20190abb,0x6b8602c4,0x2d8a0abc}},	//   _kabe, visi_, _mekg, kabe_,
   {{0x69ce06a2,0x32b7004f,0x20190abd,0x443f0abe}},	//   _jabe, ادية_, wisi_, alu_,
   {{0x20190abf,0x44260ac0,0x03140722,0x69ce0ac1}},	//   tisi_, _tjo_, _तेरह_, _mabe,
   {{0x443f0ac2,0x69ce0ac3,0x7c240254,0x9f490093}},	//   clu_, _labe, jnir, _blað_,
   {{0xa3e10ac4,0x20190ac5,0x4ea7002d,0x80ca0033}},	//   दार_, risi_, ырна, িমধ্,
   {{0x20190ac6,0xd250004f,0x64400ac7,0x2fcd0254}},	//   sisi_, _بنت_, llmi, žeg_,
   {{0x021700a5,0x2a69006d,0xafdb01b4,0x6b860298}},	//   _תחום_, wqab_, rløb, _bekg,
   {{0xfbdf0028,0x69a70006,0x69ce08c8,0x6b750009}},	//   _thêm_, _चाही, _aabe, рлау,
   {{0x3f8b0ac8,0x2d8a0ac9,0x6b860051,0x7c28000d}},	// [5f0] macu_, babe_, _dekg, édra,
   {{0x69ce0aca,0x3b540acb,0x5fd900dc,0x443f0acc}},	//   _cabe, скур, _बोतल, zlu_,
   {{0x69ce0acd,0x443f0ace,0x7a300421,0x00000000}},	//   _dabe, ylu_, näty, --,
   {{0x8d7400d1,0x600602d7,0x443f00a8,0x6c7a016b}},	//   _پایا, _tóme, xlu_, _שארפ,
   {{0x66e50acf,0xb5fd00fe,0x443f0ad0,0x00000000}},	//   рола, _dušn, vlu_, --,
   {{0x69ce0ad1,0x64400479,0x7bcf0371,0x00000000}},	//   _gabe, elmi, _hacu, --,
   {{0x62820ad2,0x7bcf0ad3,0x3dd70083,0x2aaf0095}},	//   _awoo, _kacu, _সকাল, lüb_,
   {{0x443f0ad4,0x2d8a0ad5,0x6282073a,0x3f8b00cd}},	//   ulu_, zabe_, _bwoo, jacu_,
   {{0x443f0ad6,0x02050431,0x491900a1,0x69ce018c}},	//   rlu_, изин, _येतो_, _yabe,
   {{0x443f0ad7,0x7bcf0ad8,0xd24e0ad9,0xbb1b0139}},	//   slu_, _lacu, وني_, _neîm,
   {{0x443f0ada,0x61450adb,0x7bcf0adc,0xd00a0274}},	//   plu_, рена, _oacu, вене_,
   {{0xdcfe00ea,0x7bcf0add,0x2004003e,0xc059010b}},	//   _nepā, _nacu, ómi_, ліў_,
   {{0x91e50ade,0xf38c0070,0x44d500ec,0x2d8a0adf}},	//   _воле, _טראָ, _hā_, tabe_,
   {{0x44d50ae0,0x21660009,0x7a3002c9,0xee370ae1}},	//   _kā_, _киши_, sätz, иня_,
   {{0x2d8a02c6,0x44d50029,0x69ce0ae2,0x7bcf0ae3}},	//   rabe_, _jā_, _rabe, _bacu,
   {{0x69ce0ae4,0x44d500ec,0x31c500b4,0x7bcf0ae5}},	//   _sabe, _mā_, _वसुध, _cacu,
   {{0xfaa60ae6,0xcb00004e,0x70530ae7,0x69ce0ae8}},	// [600] разо, लैंड_, _بنيا, _pabe,
   {{0x69ce0484,0x2d960ae9,0x7bcf0aea,0x0b590aeb}},	//   _qabe, _трис, _eacu, урсы_,
   {{0x44d5013a,0xfce60aec,0x44c700b5,0x7bcf0aed}},	//   _nā_, _тоно, _nő_, _facu,
   {{0x69ce0aee,0xfaa60aef,0x7bcf0af0,0xf0b60070}},	//   _wabe, _камо, _gacu, ילער_,
   {{0x6abd00ee,0x6716073f,0x00000000,0x00000000}},	//   _gpsf, _देशक_, --, --,
   {{0xa61302ce,0xb5fd0af1,0x7bcf0af2,0x3f8b0af3}},	//   оміч, _dušo, _zacu, zacu_,
   {{0xa3e100b4,0x291e013c,0x7bcf007b,0x64aa00a8}},	//   दां_, _äta_, _yacu, _rəis,
   {{0x07a30af4,0x00000000,0x00000000,0x00000000}},	//   _масн, --, --, --,
   {{0xe5a60af5,0x41e600d8,0x521400c3,0xa3200af6}},	//   _визи, аіна, йдит, मपेज_,
   {{0x44c7006c,0x83fc00cd,0x3f8b04fb,0xd257002d}},	//   _fő_, _tuđo, wacu_, ицэ_,
   {{0x7e760af7,0xf99300a5,0x64c60af8,0x69d90070}},	//   _atyp, חרת_, _خيال, אַרו,
   {{0xa3e10096,0xa3d70af9,0xb5fc007a,0xa2b80afa}},	//   दाः_, ायण_, _diġe, ्बद्,
   {{0x69a70775,0xc7b30122,0x3f8b0afb,0x7bc407f2}},	//   _चाली, חבר_, racu_, deiu,
   {{0x272301a5,0x82330af8,0x6aa40afc,0x3f8b0207}},	//   ằng_, _وروا, duif, sacu_,
   {{0x40940514,0x6adf0437,0x4c9400c3,0x3f8b012f}},	//   _البر, नम्र, жисс, pacu_,
   {{0x95fe0083,0x3ced0254,0xb5fc035f,0x41a600be}},	//   ্চিম_, ćev_, _jiġb, _खाँस,
   {{0x99670afd,0xa3d7017f,0x671600ab,0xddcd003c}},	// [610] ател, ायत_, _देलक_, _kważ,
   {{0x2aaf00a8,0x7bcf0afe,0x2b8500cc,0x00000000}},	//   rüb_, _wacu, ặc_, --,
   {{0x7bcf0aff,0xc7c70b00,0x00000000,0x00000000}},	//   _tacu, исди, --, --,
   {{0x44d502d4,0x7bc400af,0x5f0a0033,0x60060260}},	//   _rā_, ceiu, রপরও_, _kóma,
   {{0xa3ea035d,0x6b8d0b01,0xd6d9004e,0x44d5013a}},	//   मान_, maag, _była_, _sā_,
   {{0x44d5013a,0x6b8d0b02,0x39b7007e,0xb8cd0033}},	//   _pā_, laag, _děsí_, _কন_,
   {{0x69c50b03,0xcd9800a5,0x18a4010b,0x00000000}},	//   mehe, בדות_, _маём, --,
   {{0x6b8d0b04,0x44d502d4,0x69c50b05,0x53c90820}},	//   naag, _vā_, lehe, угим_,
   {{0x60060b06,0x659500af,0x00000000,0x00000000}},	//   _nóma, _газу, --, --,
   {{0x44d50ae0,0xa2050b07,0x6b8d0b08,0x69c500d4}},	//   _tā_, спод, haag, nehe,
   {{0x3f890b09,0x6b8d0b0a,0x629d0187,0x7e760067}},	//   _beau_, kaag, ásob, _styp,
   {{0x69c50b0b,0xdb040b0c,0x3f890160,0xdcfe0139}},	//   hehe, rfiú, _ceau_, _lepă,
   {{0x6b8d0b0d,0x69c50b0e,0xaac60084,0xe1ee002d}},	//   daag, kehe, _रैंक, _ег_,
   {{0x63a90b0f,0x60060093,0x69c501f4,0x3f9e01d6}},	//   lgen, _dóma, jehe, ştu_,
   {{0x61e30b10,0x61fc0b11,0xeb9a0b12,0x63a90b13}},	//   _innl, örle, лив_, ogen,
   {{0x63a90b14,0x6b8d0b15,0x78a50b16,0xa3ea022e}},	//   ngen, gaag, duhv, माय_,
   {{0x63a90b17,0xfe720037,0x7bc40160,0x60060b18}},	// [620] igen, _عدة_, reiu, _góma,
   {{0x69c50b19,0x443d033b,0x20020421,0xb5fd0b1a}},	//   gehe, _lkw_, lkki_, _bušm,
   {{0xa3d70755,0x395c013c,0x26cd00de,0xdcfe002d}},	//   ाया_, ävs_, _aseo_, _depă,
   {{0x20020086,0x63a90b1b,0xb5fd00cd,0x07a60272}},	//   nkki_, jgen, _dušm, садн,
   {{0xadec0b1c,0x69c50b1d,0x6aa40176,0xb4e007df}},	//   ञापन_, behe, quif, दम्_,
   {{0x63a90b1e,0x25db0864,0xb8660a42,0x386d00d5}},	//   egen, _गोदी_, _هارو, _červ_,
   {{0x63a90b1f,0x7c290187,0x7d7b0070,0x18a3010b}},	//   fgen, červ, אנצו, _нарм,
   {{0x63a90b20,0x83fc003a,0x6815004e,0x3a3a013c}},	//   ggen, _tuđm, ządz, lopp_,
   {{0x443d0345,0xfbd300a5,0x00000000,0x00000000}},	//   _dkw_, לתה_, --, --,
   {{0x63a90b21,0xddcd0009,0xd9cf0033,0x60060b22}},	//   agen, _otaš, রাথম, _róma,
   {{0x3f890248,0x6b8d0b23,0x66080b24,0x00000000}},	//   _peau_, yaag, _ildk, --,
   {{0x82a60b25,0x3a3a01ff,0x61e30044,0xc4d300a5}},	//   _гадж, hopp_, _ennl, _מגע_,
   {{0x3f89000d,0x69c50b26,0xddcd0b27,0x00000000}},	//   _veau_, yehe, _ataš, --,
   {{0xddcd004e,0x6b8d0b28,0xa1580b29,0x3878009e}},	//   _uważ, waag, _калу_, _otrr_,
   {{0x6b8d0273,0x69c50b2a,0x00000000,0x00000000}},	//   taag, vehe, --, --,
   {{0x321e0b2b,0x69c50b2c,0x27e40159,0x60060b2d}},	//   lity_, wehe, _nnmn_, _tóma,
   {{0x6b8d0b2e,0x69c502c9,0xfaff01f4,0x15fa0761}},	// [630] raag, tehe, _afër_, ्सार_,
   {{0x321e0b2f,0xddab0b30,0x6b8d0b31,0x59e0018d}},	//   nity_, _стил_, saag, नागर,
   {{0x094b0b32,0x69c50b33,0x6b8d0b34,0x237f0067}},	//   учаи_, rehe, paag, ybuj_,
   {{0x69c502bf,0xb8f10b35,0xad1a0122,0x2679002d}},	//   sehe, _वन_, _כותר, аскэ_,
   {{0x63a90b36,0x8f9c076b,0x69c505f5,0x00000000}},	//   vgen, רידי, pehe, --,
   {{0x2009001e,0x601602c4,0x443d0345,0xb5fd0116}},	//   _llai_, ršmi, _skw_, _tušm,
   {{0x63a90b37,0x443d0b38,0x20020093,0x321e06a0}},	//   tgen, _pkw_, ykki_, dity_,
   {{0x5fd90b39,0x66830332,0xdb0d0033,0x07350b3a}},	//   _बोलल, _فیصل, leañ, _дебю,
   {{0x23290b3b,0x66f4002d,0x320700ac,0x42090200}},	//   ропи_, _епту, _plny_, инио_,
   {{0xb5fd01cc,0x63a90b3c,0x20090b3d,0x312500c3}},	//   _mušk, sgen, _alai_, ждог,
   {{0xafdb0b3e,0x32070097,0xd12e00b5,0x20090b3f}},	//   rløn, _vlny_, ہمی_, _blai_,
   {{0xa3ea0b40,0xb4d508b6,0xafdb0b41,0x443d0b42}},	//   माण_, िटी_, sløn, _ukw_,
   {{0xe2da0332,0x20020086,0xb5fd02a7,0x00000000}},	//   _پانچ_, rkki_, _nušk, --,
   {{0x27380028,0x321e0b2b,0x27e000ea,0xfc3f0168}},	//   ứng_, city_, ķini_, _akí_,
   {{0xed5a0652,0xdbc7008a,0x3e6f018d,0x00000000}},	//   ров_, töðu, _eüt_, --,
   {{0xc4d2011d,0x1c46093e,0xb5fd0b43,0x20090090}},	//   וגל_, інам, _bušk, _glai_,
   {{0xa3ea00a1,0x3a3a0b44,0x00000000,0x00000000}},	// [640] मात_, topp_, --, --,
   {{0xb5fd01a0,0xa2a104e9,0xc18c0070,0x00000000}},	//   _dušk, _खिन्, ָטאָ, --,
   {{0xd6d9006a,0x6e3c0b45,0x00000000,0x00000000}},	//   _było_, morb, --, --,
   {{0x321e0187,0x386d00ac,0x8c460043,0x00000000}},	//   zity_, _čert_, _феме, --,
   {{0x628600b8,0x00000000,0x00000000,0x00000000}},	//   škoz, --, --, --,
   {{0xd49a0b46,0x2ba80b47,0x321e0b48,0x5d7a016b}},	//   ари_, गलवा, xity_, באַק,
   {{0x25a00723,0x321e0b49,0x1db20b4a,0xd5ad006c}},	//   ğil_, vity_, _जानत, اہم_,
   {{0x25a0027d,0xaa7b00b8,0x6e3c026e,0x321e0067}},	//   şil_, _frýd, horb, wity_,
   {{0x24890254,0x6e3c0b4b,0x6ab60035,0x1dca0099}},	//   ćama_, korb, ntyf, ाजात,
   {{0xdb1d0168,0x00000000,0x00000000,0x00000000}},	//   _nasý, --, --, --,
   {{0x321e0052,0x60060b4c,0x104b0086,0xa3ea0b4d}},	//   rity_, _cómo, иями_, माद_,
   {{0xf1ae018d,0xdb210187,0x321e0b4e,0x320c0b4f}},	//   ज्जन, _štíh, sity_, shdy_,
   {{0x6e3c0b50,0x185b016b,0x00000000,0x00000000}},	//   forb, יכטע, --, --,
   {{0xf2870332,0x6e3c0b51,0x00000000,0x00000000}},	//   _بھٹو_, gorb, --, --,
   {{0x48c50b52,0x2009012f,0x00000000,0x00000000}},	//   _এপ্র, _tlai_, --, --,
   {{0x7aed0b53,0x83fc0009,0x7bd6011e,0x61f80185}},	//   txat, _buđi, gdyu, _hovl,
   {{0xf96b004c,0x7f4d00a8,0x6e3c0b4b,0x00000000}},	// [650] арей_, _uzaq, borb, --,
   {{0x527b00c2,0xa2b20b54,0x38640160,0x91ed07b5}},	//   ינמא, _आमन्, _aimr_, जायज_,
   {{0x2d910b55,0x2d8301f4,0x81bc00ea,0x603200ea}},	//   maze_, mbje_, tnēj, sāme,
   {{0x2d910b56,0x61f8082b,0x7c290187,0x80c40083}},	//   laze_, _lovl, čers, ষিপ্,
   {{0xeb760070,0x4dff046c,0xb5fc007a,0x00000000}},	//   _מערץ_, _ईकाई_, _siġa, --,
   {{0xe61801e0,0x61f800f4,0x2d9105ad,0xb5fd00f4}},	//   оді_, _novl, naze_, _kuši,
   {{0x7e6d022e,0xf50500d8,0x92aa0033,0xf8b4002d}},	//   _luap, язко, খবো_, _обрэ,
   {{0x25db0b57,0xfbdf0023,0x2d9104fb,0x3ea20b58}},	//   _गोरी_, _thêu_, haze_, yrkt_,
   {{0x69d50b59,0x600602d7,0x26d902d7,0x29ff0067}},	//   _kaze, _sómo, _éso_, ałań_,
   {{0x69d50b5a,0xddc40254,0x11d5004f,0x2d910b5b}},	//   _jaze, _stiž, ستخد, jaze_,
   {{0x69d50b5c,0x6d450221,0x61f80b5d,0xb5fd0b5e}},	//   _maze, _nyha, _dovl, _nuši,
   {{0x69d50b5f,0x7e6d00d7,0x6e3c033b,0xdbf7021a}},	//   _laze, _buap, worb, ीसोड_,
   {{0x63bb0b60,0xa2e50b61,0xdb1d0138,0x932702fd}},	//   mfun, _холд, _masó, _بران,
   {{0x2d8c0b62,0x63bb0b63,0x7e6d022e,0xb5fd012e}},	//   úde_, lfun, _duap, _buši,
   {{0xe16600bf,0x61420b64,0x59df073f,0x63bb0b65}},	//   _عضوی, _пеша, _नफ़र, ofun,
   {{0xc4d20779,0xbc630b66,0xb5fd0b67,0x80b10083}},	//   עגן_, евск, _duši, _জনপ্,
   {{0x7e6d0b68,0x2fc00269,0x2d910b69,0x63bb0b6a}},	// [660] _guap, _ibig_, baze_, ifun,
   {{0xa3e20066,0x4a430b6b,0x25db00b1,0x6ab60035}},	//   _फोन_, енув, _गोली_, rtyf,
   {{0x38b50b6c,0xdb1d0b6d,0x63bb0b6e,0xb5fd012e}},	//   går_, _basó, kfun, _guši,
   {{0xde6d01a5,0xdb1d0b6f,0x83fc0254,0x63bb0b70}},	//   _hươn, _obsè, _tuđi, jfun,
   {{0x69d500c9,0x6b840b71,0x6d4000d0,0xa3ea0b72}},	//   _faze, mbig, şmad, मास_,
   {{0x69d50b73,0x6b840b74,0x281604cd,0x442f0b75}},	//   _gaze, lbig, _کورس, _ajg_,
   {{0xdb0f02e1,0xa3d7012f,0xdb1d0310,0x63bb0b76}},	//   _accè, ायं_, _absè, ffun,
   {{0xde6d01a5,0x6b840b77,0x69d5003d,0x02a60b78}},	//   _lươn, nbig, _zaze, пром,
   {{0x61f80b79,0xa3e10b7a,0x81d50083,0x93c8006c}},	//   _povl, दाज_, হান_, ماکہ_,
   {{0xdb0d03e6,0x7e6d009e,0x6faa05e7,0xde6d0023}},	//   sfaç, _ruap, _काउं, _nươn,
   {{0x6aa40b7b,0x7e6d0b7c,0x7336006c,0xd250006c}},	//   hrif, _suap, _کرائ, ٹنگ_,
   {{0xe45a0b7d,0x2ee0001e,0xdb1d002a,0xe7ef021a}},	//   _уже_, _brif_, _xasó, छाया_,
   {{0xf2060021,0xb5fd0b7e,0x2ee00036,0xe2da00b5}},	//   _няко, _suši, _crif_, _دباؤ_,
   {{0xb5fd0b7f,0xde6d0019,0x9c8301ba,0x6aa40b80}},	//   _puši, _cươn, účov, drif,
   {{0xde6d0028,0x69d50b81,0xc1bb0122,0x00000000}},	//   _dươn, _raze, _המוש, --,
   {{0x6aa40297,0x6b8400a7,0xdfd10b82,0x69d50b83}},	//   frif, gbig, _شيخ_, _saze,
   {{0x6aa40b84,0x8f9c0122,0x2ee00b85,0x69d50b86}},	// [670] grif, _היחי, _grif_, _paze,
   {{0x38b50b87,0xde6d01a5,0xb5fd003d,0x62800b88}},	//   tår_, _gươn, _tuši, ipmo,
   {{0x29070b89,0x6b84013c,0x798e021e,0xe3c7010b}},	//   ána_, bbig, _debw, ščių_,
   {{0x29070484,0x69d50054,0x764100d8,0x38b50830}},	//   ġna_, _waze, _skly, rår_,
   {{0x29070888,0x7c2d0b8a,0xdb1d0b8b,0x603200ea}},	//   šna_, mnar, _obsé, nāma,
   {{0xde6d0019,0x68e100b5,0x7c2d0b8c,0xb9c50b8d}},	//   _xươn, _áldo, lnar, _تقسي,
   {{0x2489044d,0xd7fb00af,0x00000000,0x00000000}},	//   ćamo_, _луа_, --, --,
   {{0x7c2d0b8e,0xdb0f0b8f,0x67d40b90,0x603200ec}},	//   nnar, _accé, _посу, kāma,
   {{0x63bb0b91,0x7c2d0b92,0x7c28002a,0x00000000}},	//   rfun, inar, édri, --,
   {{0x3eab0b93,0xb5fd04d9,0x644201d7,0x7c2d0b94}},	//   duct_, _aušv, _ekoi, hnar,
   {{0xc60902e4,0x63bb0b95,0x7c2d0b96,0xa3ea0354}},	//   वसीय_, pfun, knar, माश_,
   {{0x2ee00297,0x81b50083,0xe3b0004f,0xde6d0019}},	//   _prif_, _চোখ_, _مره_, _sươn,
   {{0xe28e0b97,0xa3ea0066,0x443f0b98,0x7c2d02c6}},	//   _ша_, मार_, mou_, dnar,
   {{0x64490b99,0x442d0b9a,0x7c2d0b9b,0x6b9d0044}},	//   llei, lne_, enar, _adsg,
   {{0x442d0021,0xe1f0028c,0x3eb904ce,0xde6d01a5}},	//   one_, _حسن_, atst_, _vươn,
   {{0x64490151,0x7c2d0b9c,0x443f0b9d,0xa3b1018d}},	//   nlei, gnar, nou_, ञ्च_,
   {{0x442d0b9e,0xde6d0028,0x443f0b9f,0x64490ba0}},	// [680] ine_, _tươn, iou_, ilei,
   {{0x6aa40ba1,0x443f0ba2,0x6b840036,0x2b8c0028}},	//   rrif, hou_, sbig, ếc_,
   {{0x443f0ba3,0x442d0ba4,0x851c0299,0x64490ba5}},	//   kou_, kne_, _भेंट_, klei,
   {{0x442d0ba6,0x798e0136,0x443f0ba7,0xc3140033}},	//   jne_, _webw, jou_, াপতি_,
   {{0x442d0ba8,0x443f0ba9,0xb86502fd,0x7c240baa}},	//   dne_, dou_, رامو, miir,
   {{0x442d0bab,0x64490bac,0x44ce0355,0x443f0345}},	//   ene_, elei, _př_, eou_,
   {{0x1dc00bad,0x443f0bae,0xa3ea0808,0x3e7401ff}},	//   श्यत, fou_, माल_, _lät_,
   {{0x442d0baf,0xe73a0009,0x443f0bb0,0x64490bb1}},	//   gne_, _деб_, gou_, glei,
   {{0x3e7401ff,0x00000000,0x00000000,0x00000000}},	//   _nät_, --, --, --,
   {{0x442d0bb2,0x7c240bb3,0x7c2d0124,0x64490421}},	//   ane_, hiir, znar, alei,
   {{0x85060bb4,0x442d0bb5,0x443f0bb6,0x64490bb7}},	//   _توان, bne_, bou_, blei,
   {{0x442d0bb8,0x443f0bb9,0x603202d4,0x7c240103}},	//   cne_, cou_, tāma, jiir,
   {{0x64400bba,0x7c2d0bbb,0x628b01ef,0xdefb0bbc}},	//   momi, vnar, _gwgo, цын_,
   {{0x64400bbd,0x60320029,0xddc40228,0x60060098}},	//   lomi, rāma, _puiš, _lómh,
   {{0x7c2401a8,0x61ea0bbe,0x7c2d0bbf,0x6032013a}},	//   fiir, _infl, tnar, sāma,
   {{0x2bdf06bc,0x7c2d0bc0,0xfc3006c9,0x80c40033}},	//   _पोशा, unar, لحق_, ষিদ্,
   {{0xa3b60bc1,0x4424009e,0xcd0400b8,0x8fa40274}},	// [690] _जान_, iim_, vněž_, _рање,
   {{0x442d042f,0x443f0bc2,0x7c2d0bc3,0x644000cd}},	//   zne_, zou_, snar, homi,
   {{0x442d0bc4,0x644000ab,0xf77300f3,0xb5fd0bc5}},	//   yne_, komi, ناش_, _mušt,
   {{0x44240bc6,0x27e90bc7,0x443f0bc8,0x6440010b}},	//   jim_, ñan_, xou_, jomi,
   {{0x442d0bc9,0x443f0bca,0x7bcd00f7,0x644903bc}},	//   vne_, vou_, meau, vlei,
   {{0x442d006a,0x443f0359,0x7bcd00a2,0xb5fd0124}},	//   wne_, wou_, leau, _nušt,
   {{0x443f0bcb,0x442d0bcc,0x60060082,0x64490bcd}},	//   tou_, tne_, _fómh, tlei,
   {{0x442d0043,0x64400bce,0xf1d70266,0x61ea0bcf}},	//   une_, gomi, _भोजन, _anfl,
   {{0x442d0bd0,0x64490bd1,0x63a60bd2,0x96350272}},	//   rne_, rlei, ókna, _знац,
   {{0x442d0936,0x443f0bd3,0xe1f1004f,0x442404e6}},	//   sne_, sou_, اسة_, aim_,
   {{0x44240bd4,0x64400bd5,0x443f0bd6,0x60260bd7}},	//   bim_, bomi, pou_, една,
   {{0x64400bd8,0x44240bd9,0xa3ea021a,0xa3b60bda}},	//   comi, cim_, माः_, _जाय_,
   {{0x7bcd0bdb,0x7c240bdc,0x2ac300ea,0x4f070036}},	//   deau, viir, nībā_, енян_,
   {{0xa3d70bdd,0xb5fd0bde,0xdd920bdf,0x2d9e00f7}},	//   ायक_, _gušt, طور_, ûte_,
   {{0x1b1d00c8,0x7c240be0,0xa3b6073f,0xd00a03fa}},	//   _ভুলে_, tiir, _जाम_, _неке_,
   {{0x2c75029e,0x00000000,0x00000000,0x00000000}},	//   _dåd_, --, --, --,
   {{0x7c24018e,0xf41202b5,0x60060be1,0x1f6601e0}},	// [6a0] riir, אפן_, _nómi, _яким,
   {{0x44240be2,0x7c240be3,0xe9d70be4,0x5fc101c0}},	//   zim_, siir, нку_, ष्ठल,
   {{0x44240be5,0x7c240be6,0x7bcd0be7,0x1bea0be8}},	//   yim_, piir, beau, _едни_,
   {{0x44240be9,0xc5fa0825,0x95fa04bc,0x59ac0380}},	//   xim_, ्स्य_, ्स्ट_, _चाकर,
   {{0x44240496,0x6440061c,0x60060b4c,0x00000000}},	//   vim_, vomi, _cómi, --,
   {{0x44240bea,0x6b960159,0x6006003e,0x2ba8021a}},	//   wim_, layg, _dómi, गलका,
   {{0x7c2f004f,0x04660beb,0xb5fd0097,0x00000000}},	//   _áirí, нтим, _rušt, --,
   {{0xb5fd0bec,0xccf30bed,0xd4670202,0x64400036}},	//   _sušt, רכה_, није_, uomi,
   {{0x44240bee,0xb5fd0a78,0x2ac30029,0x00000000}},	//   rim_, _pušt, cībā_, --,
   {{0x64400bef,0x00000000,0x00000000,0x00000000}},	//   somi, --, --, --,
   {{0x44240bf0,0x64400bf1,0x2a6a0036,0x64a30bf2}},	//   pim_, pomi, _mibb_, _баха,
   {{0x929d004e,0x2c750bf3,0x44240bf4,0xdfd10bf5}},	//   syła, _råd_, qim_, جيح_,
   {{0x7bcd0bf6,0x1acf0026,0xdcfc02d4,0x6b960bf7}},	//   veau, _सैंथ, karē, dayg,
   {{0x61ea0107,0xaa7b008d,0x00000000,0x00000000}},	//   _unfl, _brýn, --, --,
   {{0x7bcd0bf8,0x71f700b5,0x00000000,0x00000000}},	//   teau, _سروس_, --, --,
   {{0x59c60026,0x7c8403e6,0x99d70088,0x00000000}},	//   _रॉबर, ѓусе, کترا, --,
   {{0x7bcd0bf9,0x7b740037,0xab380bfa,0x23c20067}},	// [6b0] reau, اطفا, епту_, व्यद,
   {{0x7bcd0bfb,0x13d90033,0x49d80bfc,0x00000000}},	//   seau, থায়, ндую_, --,
   {{0x7bcd0bfd,0x5d550bfe,0x48ab0bff,0x00000000}},	//   peau, _шкот, ятам_, --,
   {{0xfbab03ad,0xa2a104bc,0x629d00b5,0x200b00b8}},	//   _этой_, _खिल्, ások, nkci_,
   {{0x79a70798,0x6aad027a,0xc66b0421,0x00000000}},	//   _прве, quaf, чшее_, --,
   {{0xd5490c00,0x60060300,0x2ac300ea,0xb5fd00c7}},	//   мпле_, _vómi, rībā_, _aušr,
   {{0xda34021f,0x2d930132,0x2ac300ea,0x70af0387}},	//   _серы, _mexe_, sībā_, _झमेल,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x69c100a9,0x961d0228,0x00000000,0x00000000}},	//   र्थी, _atņe, --, --,
   {{0x85b80c01,0x2d9301f7,0x27ff0260,0x00000000}},	//   _плус_, _nexe_, _houn_, --,
   {{0x76430c02,0x27ff0260,0x00000000,0x00000000}},	//   mony, _koun_, --, --,
   {{0x27ff0107,0x69c10c03,0x00000000,0x00000000}},	//   _joun_, र्ती, --, --,
   {{0xa3b60c04,0x27ff0c05,0x20190031,0x764308c7}},	//   _जात_, _moun_, ëria_, oony,
   {{0xed5a0c06,0x76430c07,0x27ff00fe,0x00000000}},	//   дог_, nony, _loun_, --,
   {{0xdcfc0029,0x629b010b,0x27ed0c08,0xef1f0457}},	//   varē, lsuo, _onen_, lbül_,
   {{0x27ff0c09,0x7ae90c0a,0x76430c0b,0xa3ea00dc}},	//   _noun_, _šeta, hony, माए_,
   {{0xee3a0c0c,0xe9da0c0d,0xab270c0e,0x76430c0f}},	// [6c0] _они_, мка_, вота_, kony,
   {{0x27ed0031,0x20000118,0x7d0700d5,0x48e60200}},	//   _anen_, _hoii_, byjs, козв,
   {{0x2d980c10,0x76430c11,0x27ff0107,0x940c00a8}},	//   mare_, dony, _boun_, _evdə_,
   {{0x2d980c12,0x629b0c13,0x661d010b,0xe72a027a}},	//   lare_, ksuo, _įska, моед_,
   {{0x2a6a00a8,0x27ff01ed,0x00000000,0x00000000}},	//   _tibb_, _doun_, --, --,
   {{0x2d9803d0,0xc8aa04bc,0xe5340c14,0x00000000}},	//   nare_, _चटपट, лель, --,
   {{0x69dc0065,0xb5fc035f,0x00000000,0x00000000}},	//   _iare, _jiġi, --, --,
   {{0x2d980c15,0x64590c16,0x69dc0c17,0x38bc0c18}},	//   hare_, _chwi, _hare, mír_,
   {{0x51860409,0x69dc0c19,0x2d980c1a,0x76430c1b}},	//   куна, _kare, kare_, bony,
   {{0x69dc0c1c,0x2d980c1d,0x69de0c1e,0x76430067}},	//   _jare, jare_, ndpe, cony,
   {{0x27ff0c1f,0x2d980c20,0x98c50c21,0x6d5a07c0}},	//   _youn_, dare_, čuće_, ýtal,
   {{0x69dc0c22,0x2d930c23,0x03260923,0x249e0176}},	//   _lare, _sexe_, _иден, _ivtm_,
   {{0x63a20c24,0x2d980c25,0x69dc00af,0xdcf50029}},	//   _idon, fare_, _oare, pazī,
   {{0x69dc02dd,0x2d980533,0xc0aa0357,0xa3ea00be}},	//   _nare, gare_, _قابل_, माक_,
   {{0x20d30c26,0x6d400c27,0xdd940c28,0x7ae60c29}},	//   _نتيج, şman, расы, _arkt,
   {{0x76430c2a,0xec340c2b,0xb5fc035f,0x69dc0c2c}},	//   zony, ансь, _diġi, _aare,
   {{0x69dc0c2d,0x2d980c2e,0x81d500c8,0x76430c2f}},	// [6d0] _bare, bare_, হার_, yony,
   {{0x2d980c30,0x69dc0c31,0x6006008d,0x6282021d}},	//   care_, _care, _dómu, _mtoo,
   {{0x69dc0c32,0x9967081b,0x63a20c33,0x7ae60044}},	//   _dare, ттал, _odon, _erkt,
   {{0x63a20c34,0x69dc0c35,0x764301a8,0xac1900d4}},	//   _ndon, _eare, wony, _чому_,
   {{0xf7700c36,0x501c0c37,0xe5a5083e,0x6282006f}},	//   زان_, וואו, гили, _ntoo,
   {{0x63a20c38,0x69dc0c39,0x6272004e,0x7bdd0c3a}},	//   _adon, _gare, _młod, _hasu,
   {{0x7bdd0c3b,0x25a90092,0x5e5802b5,0x62820c3c}},	//   _kasu, ğal_, דיגע_, _atoo,
   {{0x69dc0c3d,0x2d980012,0xa3ea0c3e,0x27ed0c3f}},	//   _zare, zare_, माग_, _unen_,
   {{0x7bdd0c40,0x69dc0c41,0x224700d7,0x2d980c42}},	//   _masu, _yare, _pknk_, yare_,
   {{0x386d0c43,0x611301c2,0x63a201d7,0x2d980c44}},	//   _hier_, lələ, _edon, xare_,
   {{0x2d980c45,0x62820103,0x629b0c46,0x69c70031}},	//   vare_, _etoo, ssuo, _mbje,
   {{0x7bdd0c47,0x66010c48,0x3f9902f6,0x611300a8}},	//   _nasu, _holk, gasu_, nələ,
   {{0x2d980c49,0x386d0c4a,0x7ae90254,0x20550144}},	//   tare_, _mier_, _šetn, ртэр,
   {{0x61130095,0xddcd0c4b,0x51870c4c,0x386d0c4d}},	//   hələ, _etaž, _руда, _lier_,
   {{0x2d980c4e,0x7bdd0c4f,0x611301c2,0x69dc0c50}},	//   rare_, _basu, kələ, _rare,
   {{0x69dc0c51,0x2d980c52,0x44e30723,0x600602d7}},	//   _sare, sare_, _mı_, _pómu,
   {{0x79950c1f,0x2d980c53,0x61130095,0x7bdd0118}},	// [6e0] _bezw, pare_, dələ, _dasu,
   {{0x7bdd0312,0x69dc0c54,0x2d980031,0x3ea00160}},	//   _easu, _qare, qare_, _ivit_,
   {{0x386d0c55,0x69de0c56,0x61130095,0x778608f1}},	//   _bier_, rdpe, fələ, глез,
   {{0xe73a03ad,0xb8dc0c57,0x765a01d2,0x69dc0c58}},	//   нее_, _आम_, _shty, _ware,
   {{0x69dc0c59,0x386d03c4,0x63a2009e,0xc7a30c5a}},	//   _tare, _dier_, _rdon, сичк,
   {{0x7ae40c5b,0x386d0c5c,0x69dc009e,0x38bc0c5d}},	//   mvit, _eier_, _uare, pír_,
   {{0x386d0c5e,0x7ae40c5f,0x3f9900e7,0x7bdd0b69}},	//   _fier_, lvit, yasu_, _yasu,
   {{0x611301c2,0x386d0035,0x8d5b0070,0x28030355}},	//   cələ, _gier_, עכקי, ěrná_,
   {{0xe737081b,0x66010c60,0x22450c61,0x7ae40c62}},	//   _бет_, _folk, folk_, nvit,
   {{0xddcd0c63,0xa3b60006,0x66010c64,0x40860c65}},	//   _staž, _जाव_, _golk, лумб,
   {{0x7c260c66,0x59c60c67,0x3f9900ab,0x3ea00260}},	//   _omkr, र्यर, tasu_, _avit_,
   {{0x660100d7,0x7ae40c68,0x63a20c69,0x7e760b88}},	//   _zolk, kvit, _udon, _buyp,
   {{0x44260c6a,0x7bdd072e,0x6d4006d3,0x3ea00124}},	//   _imo_, _rasu, şmal, _cvit_,
   {{0x7bdd0c6b,0x44260189,0x273101a5,0x44e3027d}},	//   _sasu, _hmo_, ạng_, _yı_,
   {{0x3ea00c6c,0x7bdd0c6d,0xdb0d004f,0x317b0319}},	//   _evit_, _pasu, rgaí, _ארומ,
   {{0x60060093,0xddcd0c6e,0x4426023c,0x7bdd0c6f}},	//   _dóms, _utaž, _jmo_, _qasu,
   {{0x7bdd0c70,0xafdb0c71,0x611300a8,0xdcfc00c7}},	// [6f0] _vasu, sløs, vələ, karė,
   {{0x7bdd0c72,0xe29f0093,0xdb16008d,0x442603d0}},	//   _wasu, áði_, reyð, _lmo_,
   {{0x7bdd0006,0x61130095,0x7ae40c73,0x636b00a8}},	//   _tasu, tələ, avit, _könü,
   {{0x20da0129,0x2ee90a4e,0xe84b0c74,0x66010c75}},	//   mšić_, _kraf_, رجان_, _solk,
   {{0x386d02c0,0x6b8d0c76,0x66010c77,0x61130095}},	//   _vier_, mbag, _polk, rələ,
   {{0x386d0223,0x6b8d0c78,0x611301c2,0x66010510}},	//   _wier_, lbag, sələ, _qolk,
   {{0x66010c79,0x19580bbc,0x224503bc,0xf8c907b5}},	//   _volk, _бары_, volk_, _रहिय,
   {{0x66010c7a,0x61130095,0x69c50c7b,0x22450c7c}},	//   _wolk, qələ, lfhe, wolk_,
   {{0x2bc702cb,0x66010c7d,0xa3b60324,0x21f501e0}},	//   ऱ्या, _tolk, _जार_, аїнс,
   {{0x032200d8,0x2fc90159,0x20da011c,0x42250c7e}},	//   ідэн, _abag_, kšić_, рдов,
   {{0x7ae40528,0x3ea00c7f,0x2ee9016e,0x6aad0098}},	//   zvit, _svit_, _araf_, hraf,
   {{0xa4fa02b5,0x6aad0c80,0x504600af,0x2ee900e9}},	//   _בלעט, kraf, ремб, _braf_,
   {{0x636b06d3,0x1f56021f,0xc7d600a5,0x60320228}},	//   _dönü, ртнё, בורי_, nāmi,
   {{0x91fc0ae0,0x62890c81,0x6aad0c82,0x2ee90c83}},	//   rmāc, mpeo, draf, _draf_,
   {{0x3b960c84,0xa3ea009a,0x7c2600e7,0x2ee90c85}},	//   ијат, माच_, _pmkr, _eraf_,
   {{0xe8e001a5,0x6b8d0c86,0x636b027d,0xafdb0c71}},	//   _hiệp_, gbag, _gönü, slør,
   {{0x7bc405f5,0xa3d6045c,0x6da60c87,0xada60c88}},	// [700] rfiu, ाजत_, _кипа, _капл,
   {{0x7ae40c89,0xac7600f8,0x6006008d,0x00000000}},	//   rvit, _پادش, _tóms, --,
   {{0x68460c8a,0xdb0d0187,0xa3b60534,0x7ae40c8b}},	//   анжа, čkác, _जाल_, svit,
   {{0xbc7b0052,0x3ead0c8c,0x6aad008c,0xebe60c8d}},	//   _שנכת, šete_, braf, _томп,
   {{0x6032013a,0x2bdf0099,0x2c7c0c8e,0x9f400312}},	//   gāmi, _पोटा, _híd_, _aniú_,
   {{0x44260c8f,0x7aeb01b4,0xe4a60c90,0x25a50090}},	//   _smo_, ægte, арио, _cdll_,
   {{0xd4970c91,0x44260c92,0x18a30c93,0x98a30c94}},	//   ары_, _pmo_, _марм, _мире,
   {{0xa6860859,0x7c36001e,0xf2c60c95,0xddcd0035}},	//   _влад, nnyr, асон, _staż,
   {{0x20190031,0x00000000,0x00000000,0x00000000}},	//   ërim_, --, --, --,
   {{0x44260c96,0x387801f4,0x1db20c97,0x64a60c98}},	//   _wmo_, _kurr_, _जागत, _важа,
   {{0x80270180,0xe8e00023,0xe3ba0be8,0x6b8d0159}},	//   لرحم, _diệp_, _абе_, ybag,
   {{0x7c3b0c99,0x59c6021a,0x2ee900af,0x4426023c}},	//   čurk, र्तर, _praf_, _umo_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x71260088,0x6aad0036,0x6f1d02b1,0xa3b600be}},	//   _پرتل, vraf, rzsc, _जाँ_,
   {{0x6b8d0c9a,0xac190274,0x245100e2,0xdde100fd}},	//   tbag, гову_, _sơmi_, ítői,
   {{0x6aad0c9b,0xa3b60084,0x20da0124,0x2ee90c9c}},	//   traf, जलि_, ršić_, _traf_,
   {{0x6b8d0406,0xda780c9d,0x00000000,0x00000000}},	// [710] rbag, аях_, --, --,
   {{0xd9990c9e,0x3da70c9f,0xa3c80026,0x38780ca0}},	//   انات_, _триб, _लॉस_, _burr_,
   {{0x69c50079,0x290700af,0xf0930070,0xa3b60ca1}},	//   rfhe, âna_, ַנס_, जला_,
   {{0x6aad0ca2,0x628901a2,0x24850848,0x00000000}},	//   praf, ypeo, _rtlm_, --,
   {{0x7c2d0ca3,0x6aad00a8,0xfaff0031,0x00000000}},	//   miar, qraf, _egër_, --,
   {{0x929d004e,0x70b60266,0x38780069,0x4aac0ca4}},	//   syłk, _अमूल, _furr_, _चितव,
   {{0x610a00a8,0xd90f0987,0x7c2d0065,0x00000000}},	//   nəld, _تیا_, oiar, --,
   {{0xf77f0092,0xa95400d4,0x7c2d0ca5,0x00000000}},	//   _üç_, _єкті, niar, --,
   {{0xa3d60299,0xa71503fa,0x26cd002f,0xa3c800ab}},	//   ाज़_, _удаљ, _upeo_, _लउर_,
   {{0xe1f90ca6,0x7c2d0ca7,0xe6130ca8,0x69ca0380}},	//   уго_, hiar, _بشر_, स्पी,
   {{0x7c2d06a2,0x7c360ca9,0xd24e00d1,0x62720035}},	//   kiar, ynyr, رچه_, _płoc,
   {{0x60060caa,0x9f060037,0xc50c0070,0x644b0159}},	//   _cómp, موجو, _שלאָ, _ukgi,
   {{0x7c2d0cab,0x91e50cac,0x201e01c8,0x5285004f}},	//   diar, _голе, ėti_, _التك,
   {{0x442d0cad,0x64490cae,0x62720035,0xe29f0093}},	//   lie_, loei, _włoc, áðu_,
   {{0x69ca00dc,0x7c2d01b7,0x442d0caf,0x0c7900c3}},	//   स्फी, fiar, oie_, исты_,
   {{0x442d0cb0,0x7c2d0cb1,0xb5fc035f,0x75fd0107}},	//   nie_, giar, _jiġr, _vèzy,
   {{0x63a60cb2,0x7c36010b,0x442d0cb3,0x00000000}},	// [720] ókni, rnyr, iie_, --,
   {{0x442d0cb4,0x38780211,0x64490223,0xc3010033}},	//   hie_, _purr_, hoei, এনপি_,
   {{0x8c460cb5,0x442d0cb6,0x7c2d0cb7,0x1d0a02c4}},	//   _гене, kie_, biar, _сени_,
   {{0x442d0cb8,0x2d9a08dd,0x6e2e0cb9,0xa3b600ab}},	//   jie_, _hepe_, libb, _जाइ_,
   {{0x3ea20cba,0xdcfc0029,0xddc400ea,0xf62a01e0}},	//   nskt_, karī, _muiž, ліки_,
   {{0x6e2e0484,0x27e00cbb,0x9e7b0070,0x19fa00af}},	//   nibb, žin_, אנספ, _сэмь_,
   {{0x442d0cbc,0xdcfc0080,0x344a0183,0x2d9a0118}},	//   fie_, darī, лчин_, _mepe_,
   {{0x442d0cbd,0x2d9a0cbe,0x6e2e00d7,0x64490015}},	//   gie_, _lepe_, hibb, goei,
   {{0x3866013c,0x600601ef,0x6e2e0103,0x610a00a8}},	//   mmor_, _rómp, kibb, zəld,
   {{0x7c2d0cbf,0x442d0cc0,0x7c3b0cc1,0x7ae90cc2}},	//   ziar, aie_, čuri, _šetk,
   {{0x442d0cc3,0xa1580cc4,0xa3b60cc5,0x69ca09b1}},	//   bie_, рану_, _जाऊ_, स्यी,
   {{0x442d0cc6,0xe29a0cc7,0x7c2d0cc8,0x395700a5}},	//   cie_, _бад_, xiar, משים_,
   {{0x7c2d0cc9,0x799e0cca,0x6e2e0ccb,0x2d9a0118}},	//   viar, kapw, fibb, _bepe_,
   {{0xdb0d03e6,0x6e2e0cb9,0x2d9a0814,0x7c2d0067}},	//   lgaç, gibb, _cepe_, wiar,
   {{0x7c2d0ccc,0x386600d7,0x2d9a0ccd,0x00000000}},	//   tiar, kmor_, _depe_, --,
   {{0x388101c8,0xdb0d0cce,0x00000000,0x00000000}},	//   _nėra_, ngaç, --, --,
   {{0x7c2d0291,0xa3b60ccf,0x99990cd0,0xda670cd1}},	// [730] riar, _जाई_, икат_, مائي,
   {{0x442d0cd2,0x6fb50357,0x7c2d0cd3,0xff180122}},	//   zie_, _امکا, siar, _לקחת_,
   {{0x442d0cd4,0x9f520359,0x3c59002d,0x764a0051}},	//   yie_, _anyè_, _винэ_, dofy,
   {{0x28ba046c,0x6449002a,0x442d0cd5,0x81be0831}},	//   _उमरि, xoei, xie_, ঁজি_,
   {{0x442d0cd6,0xc98701ee,0xb6c70421,0x09ce0033}},	//   vie_, _губи, ссей, রয়া,
   {{0x442d0cd7,0xd9fd00c0,0x2d83004e,0x853c00d8}},	//   wie_, _उचित_, ncje_, _idėj,
   {{0x442d0cd8,0x00000000,0x00000000,0x00000000}},	//   tie_, --, --, --,
   {{0x3ea20cd9,0x52a90cda,0x69d70cdb,0x00000000}},	//   yskt_, авим_, lexe, --,
   {{0x2d83004e,0x644909a6,0x59c60a64,0x130600c3}},	//   kcje_, roei, र्वर, жный_,
   {{0x442d0cdc,0x69d70cdd,0x9f49021d,0x91fc013a}},	//   sie_, nexe, _joaõ_, smān,
   {{0x442d0cde,0x2d9a081b,0x7bd60cdf,0xdbc600be}},	//   pie_, _repe_, yeyu, mööd,
   {{0xa3b60953,0xa2b202cb,0x2d9a023a,0xe29f0093}},	//   _जाए_, _आमच्, _sepe_, áðs_,
   {{0x2d9a0ce0,0xe2990336,0x6d580355,0xa3e200b4}},	//   _pepe_, _тал_, _úvaz, _फोट_,
   {{0x63bb0ce1,0x71250987,0x3ea20ce2,0x00000000}},	//   lgun, _ورغل, rskt_, --,
   {{0xc5f20122,0xfce30ce3,0x69d70ce4,0x3866016e}},	//   ודם_, моро, dexe, ymor_,
   {{0x63bb0ce5,0x3ead040b,0x320700ac,0x6e2e073a}},	//   ngun, šeta_, _hony_, sibb,
   {{0x61e30ce6,0x81dc0083,0x32070ce7,0x799e08dd}},	// [740] _kanl, ডার_, _kony_, tapw,
   {{0x63bb0ce8,0x20020ce9,0x00000000,0x00000000}},	//   hgun, ljki_, --, --,
   {{0x5fc10cea,0xa3e90ceb,0x61e30cec,0x00000000}},	//   ष्कल, मया_, _manl, --,
   {{0xb8f20755,0x46ea0ced,0x61e30cee,0x6d5e0cef}},	//   _वह_, иден_, _lanl, _izpa,
   {{0x38660cf0,0x70b600dc,0x4e0e08b6,0xe66601f0}},	//   rmor_, _अम्ल, _हवाई_, отко,
   {{0xb0a90cf1,0x61e30cf2,0x63bb0cf3,0x6aa4002f}},	//   _किंग, _nanl, egun, msif,
   {{0xf8b000b5,0x9f4500b8,0x443d0051,0xa3d60387}},	//   _سکا_, ělé_, _bjw_, ाजल_,
   {{0x2fc00189,0x61e30136,0x799c0cf4,0x02a601f0}},	//   _ncig_, _aanl, _herw, ором,
   {{0x61e30cf5,0x2d830035,0x75d60833,0x32070096}},	//   _banl, ycje_, _ويرا, _bony_,
   {{0x61e30cf6,0x3218006a,0x320701f7,0xd25a0166}},	//   _canl, óry_, _cony_, јци_,
   {{0x61e30cf7,0x63bb06a2,0xb97b02b8,0x799c053e}},	//   _danl, bgun, יניי, _merw,
   {{0x69ca09b8,0x68e3054e,0x27e60cf8,0x660800ac}},	//   स्ती, ændi, ndon_, _hodk,
   {{0x91e60cf9,0x7336006c,0x32070168,0x799c0cfa}},	//   _моде, _برائ, _fony_, _oerw,
   {{0x63a00cfb,0x61e3001e,0xd34400bf,0x799c0035}},	//   lamn, _ganl, _ویژه_, _nerw,
   {{0x27e6011e,0x2cb80cfc,0x64b800b4,0x66080cfd}},	//   kdon_, gurd_, _इमोश, _modk,
   {{0x27e40533,0xe3ac0033,0x63a00cfe,0x27e60987}},	//   _namn_, ক্রব, namn, jdon_,
   {{0x799c0cff,0xa3cc0d00,0x0dcb06e4,0x69d70391}},	// [750] _berw, श्य_, _куни_, texe,
   {{0x3eb90d01,0xaaac0437,0x63a00d02,0x61e3013b}},	//   must_, _चिरक, hamn, _xanl,
   {{0x25fe02e4,0x3eb90d03,0x799c0d04,0x69d70485}},	//   लानी_, lust_, _derw, rexe,
   {{0xa3b60907,0x69ce0d05,0x69d70d06,0x27e60107}},	//   _जाग_, _ebbe, sexe, gdon_,
   {{0xd6db0d07,0x799c0d08,0xd7c80934,0x2009012f}},	//   рте_, _ferw, تونه_, _moai_,
   {{0x95cb0036,0x62720035,0x20090023,0xd5b10037}},	//   руда_, _słon, _loai_, رفع_,
   {{0x1c0f0953,0x32070107,0x91fc0029,0x27e40d09}},	//   _सवाल_, _rony_, rmāl, _famn_,
   {{0x61e30d0a,0xd7c900bf,0x3eb9007c,0xe2990d0b}},	//   _sanl, _دوره_, kust_, баи_,
   {{0x63bb0d0c,0x61e30d0d,0x6608008c,0x799c030d}},	//   rgun, _panl, _fodk, _yerw,
   {{0x321e0d0e,0x2ea806bb,0x3eb90d01,0x66080c60}},	//   ghty_, _कटौत, dust_, _godk,
   {{0x61e30d0f,0x610a00a8,0x33750d10,0xd87400b5}},	//   _vanl, vəlc, _егер, _راہب,
   {{0x22800c1f,0x63a0022e,0x6b9d01ef,0x54370416}},	//   _fòk_, camn, _nesg, _برطر,
   {{0x61e30d11,0xe8030d12,0x320705f0,0x2f560d13}},	//   _tanl, _रचना_, _tony_, ятос,
   {{0x321e0d14,0xfc3f02d7,0x91e50d15,0x273800e2}},	//   chty_, _ají_, _хоке, ẩng_,
   {{0x27e60d16,0xed5a0d17,0xd3470088,0xdbd9008a}},	//   ydon_, сов_, _دیکه_, tæðu,
   {{0x799c006a,0x6aa40d18,0x3eb90d19,0x6b9d0d1a}},	//   _serw, tsif, bust_, _cesg,
   {{0x0b430d1b,0x799c0d1c,0x6b840d1d,0xdbd900fb}},	// [760] ентн, _perw, rcig, ræðu,
   {{0x6aa40d1e,0xa3ab0d1f,0x09e30144,0x6b840d20}},	//   rsif, कृत_, ноун, scig,
   {{0x799c0d21,0x1b040083,0x6aa40d22,0x63ab02a7}},	//   _verw, _রেখে_, ssif, _odgn,
   {{0xdcf5004e,0x799c0d23,0x27e60d24,0x79850d25}},	//   jczę, _werw, udon_, achw,
   {{0x799c0d26,0x660805d1,0x15fa00dc,0x27e60d27}},	//   _terw, _podk, _एचआर_, rdon_,
   {{0x98a605a1,0xd49a0d28,0x26c60086,0x6aa20009}},	//   _ниге, бри_, rtoo_, šofs,
   {{0x26c60d29,0x628b00e9,0x27e6011e,0x25fe0d2a}},	//   stoo_, _atgo, pdon_, लाबी_,
   {{0xa3b60299,0xa2d3000c,0xb6030029,0x046301f1}},	//   _जाओ_, _बैङ्, īšan, нтым,
   {{0x2bce02cb,0x27f7000c,0x18670044,0xd70700af}},	//   ह्या, šení_, _хати_, _енте_,
   {{0xe8e001a5,0x59cf0d2b,0x3eb9007c,0x63a00093}},	//   _nhịp_, स्पर, vust_, samn,
   {{0x3eb90120,0x69c10d2c,0x00000000,0x00000000}},	//   wust_, र्टी, --, --,
   {{0x3eb90006,0x5ed60033,0x2bce0b35,0x8fa40166}},	//   tust_, দিনে, ह्मा, наџе,
   {{0x6b9d0d2d,0x24490987,0x798500e9,0x7a200523}},	//   _resg, _بجلي_, ychw, _götg,
   {{0x99ce00c8,0x6b9d0d2e,0x3eb90d2f,0x00000000}},	//   রযুক, _sesg, rust_, --,
   {{0x61f802e6,0x3eb9007c,0x248c027a,0xddde00fd}},	//   _invl, sust_, _jtdm_, _cipő,
   {{0x5c740d30,0x3eb90d31,0xb15700a5,0x25fe01c0}},	//   елст, pust_, _מסוג_, लाडी_,
   {{0x3a75034b,0x3eb90d32,0x00000000,0x00000000}},	// [770] длар, qust_, --, --,
   {{0xdce70723,0x9967002d,0xa3cc0722,0xdcf50035}},	//   sajı, птел, श्त_, zczę,
   {{0x3ea9008e,0x02d90311,0x79850d33,0x201900c7}},	//   _hvat_, _भन्न, rchw, ūriu_,
   {{0x798502c9,0x69c10d34,0x69c8027d,0x00000000}},	//   schw, र्जी, _öden, --,
   {{0x601f00da,0x61f80d35,0x00000000,0x00000000}},	//   _këmb, _onvl, --, --,
   {{0x8afa00a5,0x00000000,0x00000000,0x00000000}},	//   _והשי, --, --, --,
   {{0x20f001f2,0x7aed09e8,0x8ca6073f,0x00000000}},	//   nđić_, lvat, _छिछो, --,
   {{0xfcaa0779,0x3ea90d36,0x61f8021e,0x657a03bc}},	//   קיפּ, _ovat_, _anvl, _egth,
   {{0x7aed0d37,0x00000000,0x00000000,0x00000000}},	//   nvat, --, --, --,
   {{0xf0a90217,0xbebb0055,0x00000000,0x00000000}},	//   окол_, tzën, --, --,
   {{0x7aed0d38,0x6d45006d,0xa06a0d39,0x349402fb}},	//   hvat, _nxha, жана_, _захр,
   {{0xe4d4006c,0x00000000,0x00000000,0x00000000}},	//   _ستمب, --, --, --,
   {{0x7aed00f4,0x3ea90207,0x628b0d3a,0x6d450c6f}},	//   jvat, _cvat_, _utgo, _axha,
   {{0x7a20006c,0x59cf05a6,0x7aed0d3b,0x6d570282}},	//   _köte, स्मर, dvat, _byxa,
   {{0x442f0553,0x4252006c,0x7aed00a0,0x7bcd0d3c}},	//   _kmg_, _جنور, evat, ffau,
   {{0x7a20022a,0xc1720122,0x201901f4,0x09a60099}},	//   _möte, _בחו_, ërit_, खण्य,
   {{0xfaa30d3d,0x7aed0d3e,0x6d450d3f,0x2eff02b1}},	// [780] като, gvat, _exha, äuft_,
   {{0x442f02c4,0xe9d70d40,0x601f01f4,0x00000000}},	//   _lmg_, мку_, _vëme, --,
   {{0x41cf0d41,0xf1cf00e7,0x3ea9022f,0x7aed081b}},	//   त्यस, त्यन, _zvat_, avat,
   {{0x6d4006d0,0x9f400d42,0x6a860009,0xb9060d43}},	//   şmas, _unió_, _олма, _भन_,
   {{0xc7a30d44,0xa3c8004e,0xd6d00609,0x7aed0d45}},	//   тичк, _लॉग_, اقت_, cvat,
   {{0x7a2001ff,0x3eaf01b4,0x6b96038d,0xe8df00e2}},	//   _böte, _ægte_, lbyg, _luộc_,
   {{0xa5c40067,0xf8d2018d,0x00000000,0x00000000}},	//   _राठौ, _सहिय, --, --,
   {{0xd4670274,0x6b9600d4,0x00000000,0x00000000}},	//   мије_, nbyg, --, --,
   {{0x42740d46,0x07a30009,0x86c60d47,0x39580282}},	//   нгис, _шатн, _زيان, _hyrs_,
   {{0x61e800e5,0xf8d208b6,0xdb1500f7,0x3ea90207}},	//   uddl, _सहाय, ébéc, _rvat_,
   {{0xd1300514,0x7a20022a,0x7aed0254,0xe8df01a5}},	//   امج_, _göte, zvat, _buộc_,
   {{0xe8df0028,0x7aed024e,0x4de7046c,0x00000000}},	//   _cuộc_, yvat, _छोड़े_, --,
   {{0xd6d9004e,0x6b960d48,0x2ef200e9,0x00000000}},	//   _były_, dbyg, _cryf_, --,
   {{0x7aed03c1,0x6ab603bc,0x2ef203bc,0xa3d60437}},	//   vvat, dryf, _dryf_, ाजक_,
   {{0xfe2400c3,0x1bd502fb,0x645c00ea,0x34dc021a}},	//   тьян, новя, _īrij, _मनोद,
   {{0x91ca0355,0x21b7006c,0x20f00009,0x7aed0d49}},	//   त्रै, _ٹھیک_, rđić_, tvat,
   {{0x2ef20d4a,0x201900e1,0xc054024b,0x00000000}},	// [790] _gryf_, ūris_, _בזק_, --,
   {{0x6d450d4b,0xe9d30037,0xc95b010b,0x00000000}},	//   _txha, ضغط_, оўе_, --,
   {{0x7aed0d4c,0x5884021f,0x5c7500cf,0x3958099e}},	//   svat, выча, _плот, _cyrs_,
   {{0x20190d4d,0xda090118,0x3958008c,0x00000000}},	//   nksi_, _کيسه_, _dyrs_, --,
   {{0x442f022e,0x201900c3,0x59c70d4e,0x97350d4f}},	//   _rmg_, iksi_, _लापर, رکرا,
   {{0x68e30d50,0x644200c3,0x649902c4,0x39580d51}},	//   ænds, _ajoi, птир_, _fyrs_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe73900e9,0x58d40746,0xc2fa0033,0x00000000}},	//   _ddŵr_, _шост, েননি_, --,
   {{0x7c3a03e6,0xf6b500b5,0x9f9d008a,0x95cb0d52}},	//   étri, _سماج, væði_, _мужа_,
   {{0x5694027a,0x20190086,0x7a20033b,0x41050aec}},	//   _рафт, eksi_, _töte, езов,
   {{0x6e3501a0,0x00000000,0x00000000,0x00000000}},	//   dizb, --, --, --,
   {{0xcdc90052,0x80a0006a,0x59cf0d53,0x3cf90066}},	//   _לך_, _खबरे, स्तर, _उपजे_,
   {{0xef1703ad,0x9f9d008a,0x93240312,0x00000000}},	//   емя_, ræði_, _لرون, --,
   {{0xfce60d54,0x91e20183,0xc6920070,0x201900c3}},	//   ного, _боше, ראם_, aksi_,
   {{0xa3cc0d55,0x81c80083,0x9d430009,0x621a0319}},	//   श्व_, _লোক_, герд, _מוסק,
   {{0x443f0d56,0x0eaa00af,0xfbdf0298,0x853c005f}},	//   nnu_, _екий_, _skêr_, _idėt,
   {{0x34dc00c0,0x6b960d57,0x443f0d58,0xbdfa00b2}},	// [7a0] _मन्द, rbyg, inu_, _فردا_,
   {{0x443f0d59,0x8e9700a5,0x6b960d5a,0x6d40013b}},	//   hnu_, _רדיו_, sbyg, şmaq,
   {{0x2d980d5b,0x69c801d6,0xf1c205fc,0xd7fa0043}},	//   mbre_, _ödem, _शासन, зул_,
   {{0x443f0d5c,0x41cf00a1,0x7afb02f6,0xf1cf007e}},	//   jnu_, त्तस, _šute, त्तन,
   {{0x443f0d5d,0xc879033e,0x645b01bf,0x00000000}},	//   dnu_, _diş_, dlui, --,
   {{0x443f0d5e,0x2d980d5f,0x857400b5,0x9f400176}},	//   enu_, nbre_, نگائ, _maià_,
   {{0x1dd20d60,0x645b0d61,0x443f0d62,0x5fc600a1}},	//   द्यत, flui, fnu_, _वाढल,
   {{0x66e60d63,0x443f0b79,0x25fe00a1,0x6b7b016b}},	//   _поба, gnu_, लाही_, ּרינ,
   {{0xe7d506d3,0x00000000,0x00000000,0x00000000}},	//   lığı, --, --, --,
   {{0x443f002d,0x9fd00083,0x69de0d64,0x1fa90355}},	//   anu_, িযোগ, nepe, कण्ड,
   {{0x443f0d5c,0x7c24005d,0x3a370122,0x610a00a8}},	//   bnu_, khir, תרים_, cəll,
   {{0x645b0d65,0x443f0d66,0x69de0d67,0x351b00a5}},	//   clui, cnu_, hepe, _מובנ,
   {{0x7c240d68,0x69de0d69,0x20190d6a,0x4ea7010b}},	//   dhir, kepe, rksi_, эрна,
   {{0xa3cc0bc1,0x932500b5,0x69de0d6b,0x127b0070}},	//   श्र_, _جرمن, jepe, _זאגע,
   {{0x63a20d6c,0x69de0d6d,0x62820118,0xc0e30d6e}},	//   _keon, depe, _huoo, _бојк,
   {{0xe7d50d6f,0x61ea0d70,0x63a200cc,0x7c240d71}},	//   dığı, _hafl, _jeon, ghir,
   {{0xf1a40084,0x61ea0093,0xc87f00d0,0x9f4001f7}},	// [7b0] _खजान, _kafl, ışma_, _gaià_,
   {{0x443f0d5c,0x69de0d72,0x5a340d73,0x7c240054}},	//   znu_, gepe, гнут, ahir,
   {{0x443f0297,0x7c2400f1,0x7ae603d0,0xdb1600fd}},	//   ynu_, bhir, _eskt, rgyá,
   {{0x7c240d74,0x61ea0d75,0x610a00a8,0x28d200ab}},	//   chir, _lafl, vəll, _सहरि,
   {{0x44240082,0x443f011c,0x69de09a6,0x66e50409}},	//   dhm_, vnu_, bepe, тола,
   {{0x27e901cc,0xe6180185,0x69de0d76,0xcfea0083}},	//   žan_, нді_, cepe, গায়_,
   {{0x443f0d77,0x645b053e,0x6e200031,0x3eb902b1}},	//   tnu_, tlui, ëmbi, hrst_,
   {{0x7bdf0183,0x443f0d78,0x00000000,0x00000000}},	//   nequ, unu_, --, --,
   {{0x443f0d79,0xd7c800e0,0x63a20d7a,0x645b0d7b}},	//   rnu_, _سوله_, _deon, rlui,
   {{0xd24e0ad9,0x645b0d26,0x443f0d7c,0x7bdf0d7d}},	//   يني_, slui, snu_, hequ,
   {{0x443f0d7e,0x61ea00e9,0x25fe00ab,0x59c609b1}},	//   pnu_, _dafl, लारी_, र्टर,
   {{0x9f400176,0x69de0d7f,0x7a20017b,0x6d5a018d}},	//   _paià_, zepe, _möta, ütam,
   {{0x69c70c21,0x7bdf0d80,0x69de0d81,0x69d50168}},	//   _ocje, dequ, yepe, _obze,
   {{0xdd920d82,0x61ea0d83,0x00000000,0x00000000}},	//   شور_, _gafl, --, --,
   {{0xed570b46,0x7c24000e,0x27310019,0xada30d84}},	//   вор_, thir, ạnh_, расл,
   {{0x60d60d85,0x1c430043,0x8c4303e6,0x63a20042}},	//   _יוצא_, ансм, аесе, _xeon,
   {{0xeab10332,0xc1e5083f,0x7c24099e,0x00000000}},	// [7c0] یعے_, _कसाब_, rhir, --,
   {{0x7c240d86,0x61ea01b7,0xceb9000c,0x68f5024e}},	//   shir, _xafl, áře_, _brzd,
   {{0x69de0d87,0x291c0d88,0x00000000,0x00000000}},	//   repe, áva_, --, --,
   {{0x69de0d89,0xe73a0d8a,0x3ea002d0,0x7ae6010d}},	//   sepe, мее_, _kwit_, _tskt,
   {{0x63a20d8b,0x6272004e,0xa6fa0037,0x69de0d8c}},	//   _reon, _głow, بعاء_, pepe,
   {{0xaa460d8d,0x4a750086,0x63a20d8e,0x7ae4035a}},	//   _регл, _быст, _seon, mwit,
   {{0x98a306cd,0x7a20013c,0x7ae403bc,0xdb040d8f}},	//   _висе, _göta, lwit, rgiõ,
   {{0x61ea0297,0xa7850082,0x7bc40d90,0x44f10024}},	//   _safl, _مشكو, ngiu, _dġ_,
   {{0x59cf0d91,0x268a00b5,0x7c230043,0x7ae40d92}},	//   स्वर, _آخري_, _înre, nwit,
   {{0x610a0095,0x63a20453,0x3f800183,0x61ea0024}},	//   səlm, _weon, _agiu_, _qafl,
   {{0x85060d93,0x9f4e024e,0x3ea00d94,0x63a200d7}},	//   _جوان, čným_, _awit_, _teon,
   {{0xc9530052,0x7ae40d95,0x7d0301f7,0x628f002a}},	//   ימת_, kwit, _ànsi, ícoc,
   {{0x05c90d96,0x61ea0d97,0x00000000,0x00000000}},	//   _रामब, _tafl, --, --,
   {{0xf7730bed,0x6e9400c3,0x7bc40d98,0x00000000}},	//   יקר_, риру, egiu, --,
   {{0x6272006a,0x7bdf0d99,0x1dd209b1,0x7ae40110}},	//   _słow, tequ, द्धत, ewit,
   {{0x7bc401d3,0xd10f0d00,0xa17700a5,0x217700a5}},	//   ggiu, ाहरण_, _בעוד_, _בתור_,
   {{0x41cf007e,0xf1cf0355,0xdb1d0260,0x3c5800af}},	// [7d0] त्वस, त्वन, _absò, титэ_,
   {{0x7bdf0d9a,0x200b0bc6,0x2ee900e9,0xf7f400d1}},	//   sequ, ljci_, _isaf_, یسند,
   {{0x386f0069,0x7bdf0d9b,0x2d810371,0x6d4105ee}},	//   tmgr_, pequ, _ighe_, úlad,
   {{0x787a01c0,0x200b0169,0xc8640d9c,0x7ae40d9d}},	//   _důvo, njci_, атчи, bwit,
   {{0x81d200e2,0x00000000,0x00000000,0x00000000}},	//   _rồng, --, --, --,
   {{0x69c7012e,0x6b8d0036,0x26360035,0xc9870d9e}},	//   _ucje, lcag, słon_, _шуми,
   {{0x6aad0d9f,0xd5ae0a42,0x00000000,0x00000000}},	//   lsaf, سفي_, --, --,
   {{0x2fc9006d,0x69c50da0,0xd4660da1,0x32cb02ce}},	//   _ncag_, lghe, лище_, tøy_,
   {{0x2bd500a1,0x6aad0da2,0x27ff01ed,0x65950da3}},	//   ड्या, nsaf, _inun_, _базу,
   {{0x2d810028,0x27ed0da4,0x95d80421,0xc5fb0698}},	//   _nghe_, _haen_, _идут_, _تعرض_,
   {{0xe4cb0357,0x69c50094,0x2ee90da5,0x27ed0159}},	//   _زبان_, ighe, _asaf_, _kaen_,
   {{0xf3f0004f,0x27ed0da6,0x24850036,0x25a506c6}},	//   _وأن_, _jaen_, _iulm_, _hell_,
   {{0x25a50da7,0x27ed001e,0x63a90da8,0x645901d5}},	//   _kell_, _maen_, maen, _ikwi,
   {{0x63a90da9,0x6aad0a8a,0x25a5055c,0x27ed0daa}},	//   laen, dsaf, _jell_, _laen_,
   {{0x61e10dab,0x27ff0dac,0x03e60083,0xdcee04d4}},	//   mell, _onun_, কারী_, tabı,
   {{0x41cf0a90,0x7afb0129,0x61e10dad,0x63a90dae}},	//   त्रस, _šuta, lell, naen,
   {{0xab660daf,0x7643046a,0x6459023c,0x3ea000e0}},	// [7e0] увал, knny, _mkwi, _uwit_,
   {{0x25a50133,0x787a01c0,0xdcee04d4,0x27ed0a8a}},	//   _nell_, _půvo, sabı, _aaen_,
   {{0x60c10db0,0x61e102fb,0x610a0095,0x63a90db1}},	//   nulm, iell, vəlk, kaen,
   {{0x6b8d0db2,0x61e10db3,0x27ed0db4,0xe4f9012f}},	//   ccag, hell, _caen_, ्मनि_,
   {{0x61e10db5,0x6d5e0db6,0x63a9016e,0x25a50db7}},	//   kell, _hypa, daen, _bell_,
   {{0x7e7e0484,0x25a50db8,0x61e10db9,0xa8a600b5}},	//   _jipp, _cell_, jell, _مصرو,
   {{0x61e10dba,0x25a50dbb,0x63a90dbc,0x83fd006c}},	//   dell, _dell_, faen, klőd,
   {{0x3a3a0dbd,0x7643005d,0x4422006c,0x61e10086}},	//   lipp_, anny, ók_, eell,
   {{0x61e10dbe,0x610a0095,0x57460dbf,0xe3af0dc0}},	//   fell, məli, _снаб, سري_,
   {{0x61e10dc1,0xf1c601c0,0x64590dc2,0x2000002d}},	//   gell, _část_, _ekwi, _anii_,
   {{0x63a90dc3,0x20120b13,0x00000000,0x00000000}},	//   baen, _boyi_, --, --,
   {{0x0eeb0086,0x7e7e01e0,0x25a50dc4,0x610a013b}},	//   ньги_, _aipp, _zell_, nəli,
   {{0xe2960370,0x6aa30437,0x6fc60785,0x6d5e0be2}},	//   _среќ, _ओबेर, _वारं, _aypa,
   {{0x61e10dc5,0x7e7e0dc6,0x2fc9021d,0x25a501f7}},	//   cell, _cipp, _wcag_, _xell_,
   {{0x7e7e0dc7,0x23b800ab,0x00000000,0x00000000}},	//   _dipp, _इयाद, --, --,
   {{0x60df006c,0x7e7e02a7,0x6d5e0055,0x00000000}},	//   őzmé, _eipp, _dypa, --,
   {{0x5a350dc8,0x765a0d32,0x7e7e0dc9,0x76430dca}},	// [7f0] анат, _okty, _fipp, ynny,
   {{0x27ed01dd,0x6b8d027a,0x6aad0dcb,0x321e0035}},	//   _saen_, scag, rsaf, nkty_,
   {{0xa3e50299,0x69c50dcc,0x6aad0dcd,0x63a908c7}},	//   _फसल_, rghe, ssaf, yaen,
   {{0x765a0dce,0x61e10dcf,0x67d50dd0,0x6272004e}},	//   _akty, zell, роду, _złot,
   {{0x25a503b6,0x61e10dd1,0x60c10644,0x63a9018d}},	//   _pell_, yell, zulm, vaen,
   {{0xf7700dd2,0x60c10644,0x7643022e,0x672b01f4}},	//   سان_, yulm, unny, rzgj,
   {{0x63a90dd3,0x25a50dd4,0x61e10dd5,0x76430dd6}},	//   taen, _vell_, vell, rnny,
   {{0x25a50052,0x61e10dd7,0xb6c900b5,0x321e0067}},	//   _well_, well, _لائے_, ekty_,
   {{0x61e10dd8,0xcb1202b5,0x25a50122,0x74120c74}},	//   tell, ַלט_, _tell_, تويا,
   {{0x60c10dd9,0x63a90dda,0xdb0d0ddb,0x22150ddc}},	//   tulm, saen, ngañ, рфир,
   {{0xc5fa02b5,0xb5fa02b5,0x386d0107,0x69ca00b4}},	//   _שפעט, _שלעכ, _kher_, स्टी,
   {{0x61e10ddd,0x43750dde,0x60c106d0,0x64590010}},	//   sell, _култ, rulm, _ukwi,
   {{0xe7d70302,0x7afb025c,0x7e7e0ddf,0xeac00083}},	//   ण्यप, _šutn, _pipp, _উন্ম,
   {{0x51870de0,0x387f0034,0x6da302f3,0x60c100b9}},	//   _суда, _liur_, жира, pulm,
   {{0xed5a0de1,0xe8160302,0xdca60de2,0x6286024e}},	//   тов_, _थकला_, раби, íkov,
   {{0x1e860de3,0x20000de4,0x6d5e0333,0x387f009e}},	//   _клим, _unii_, _vypa, _niur_,

   {{0x7e7e0de5,0x6272004e,0x6d5e004e,0xdee60de6}},	// [800] _tipp, _głos, _wypa, _топи,
   {{0x6d41004f,0x3ead003c,0x3c3f00c3,0x64950069}},	//   úlac, ġett_, tävä_, _iġif,
   {{0x6fd30026,0x6e3c0de7,0xa3e50067,0x610a013b}},	//   ध्वं, mirb, _फसं_, təli,
   {{0x386d02e1,0xd7f9005f,0x1dd20de8,0x387f0160}},	//   _cher_, луі_, द्रत, _ciur_,
   {{0x66f40de9,0x386d0dea,0x387f009e,0xc6a3051a}},	//   сплу, _dher_, _diur_, орщи,
   {{0xfaa30deb,0x386d02c9,0xdb060031,0xc8960dec}},	//   _фаро, _eher_, _lekë, _врањ,
   {{0xd9430ded,0x386d0069,0x00000000,0x00000000}},	//   _дери, _fher_, --, --,
   {{0x6a6b033b,0x387f0036,0x986a00af,0xe8df00e2}},	//   rüfe, _giur_, _рибб_, _guốc_,
   {{0xf5ea0dee,0xdb0d0093,0x00000000,0x00000000}},	//   _имал_, ngað, --, --,
   {{0xd4d600d8,0x387f01a3,0x00000000,0x00000000}},	//   _відэ, _ziur_, --, --,
   {{0x6e3c0def,0x741600f8,0x765800ac,0x00000000}},	//   dirb, _پوشا, movy, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x22940514,0x44260df0,0x3294004f,0xd0420095}},	//   _التس, _ilo_, _التأ, ntlə,
   {{0x4426006f,0x7c26030d,0x765800ac,0x00000000}},	//   _hlo_, _alkr, novy, --,
   {{0x442603ad,0x2ba70798,0x6272004e,0xe7d70bad}},	//   _klo_, ијав, _włos, ण्डप,
   {{0xf21c0299,0x717b0122,0x5bb80086,0xd04200a8}},	//   _पकड़_, _בנוס, ился_, ktlə,
   {{0xb06600ab,0xaed50274,0x442608c7,0xe9870274}},	// [810] svää, _уопш, _mlo_, аћен,
   {{0x44260df1,0x7ac40dba,0x7c260523,0xeb9f0a8a}},	//   _llo_, юссе, _elkr, _snød_,
   {{0xda78071d,0x44260df2,0x4f580df3,0x98b9081b}},	//   рят_, _olo_, _مجید_, улет_,
   {{0xd12600f5,0xe8df00e8,0x44260df4,0x00000000}},	//   _ہم_, _quốc_, _nlo_, --,
   {{0x6eaa0243,0xba770088,0x610a013b,0x6f1d00d5}},	//   जीपु, _ناست, məlu, nysc,
   {{0x44260df5,0x386d0159,0xcb12011d,0xe5a20df6}},	//   _alo_, _wher_, _צלם_, пиши,
   {{0x4426008b,0x95c80009,0x29070df7,0x81ac0033}},	//   _blo_, руча_, ånad_, গলা_,
   {{0x43690df8,0x44260df9,0x5fc60026,0x13e9081b}},	//   лайн_, _clo_, _वाइल, умий_,
   {{0xd8380409,0x44260c1f,0x00000000,0x00000000}},	//   _тэр_, _dlo_, --, --,
   {{0x44260dfa,0x00000000,0x00000000,0x00000000}},	//   _elo_, --, --, --,
   {{0x7afb0124,0x1b1b0033,0x6d40045e,0x786a00ac}},	//   _šutl, _নেমে_, şmaz, lýva,
   {{0x44260dfb,0xdee60dfc,0x9f4200ac,0x6e3c02b1}},	//   _glo_, боми, leké_, wirb,
   {{0x2bcb0067,0x6e3c0dfd,0x00000000,0x00000000}},	//   िलना, tirb, --, --,
   {{0xe29c02b5,0x44260a18,0x7d1c0dfe,0x51950037}},	//   _ישׂר, _zlo_, tyrs, _الغذ,
   {{0x82340dff,0x1d1902ce,0xdca302c8,0x6e3c0093}},	//   _برنا, ають_, заси, rirb,
   {{0x61b700a1,0x3b860b5e,0x65610e00,0x6f1d0e01}},	//   _आयुष, слаг, _mylh, bysc,
   {{0xe9da0e02,0xc0530122,0x62720035,0x3b070be8}},	// [820] лка_, _מזה_, _kłop, бето_,
   {{0xdb0d008d,0x7dea0421,0x00000000,0x00000000}},	//   rgað, _смог_, --, --,
   {{0xd23a02b5,0xe80400a1,0x00000000,0x00000000}},	//   נגעל, ळाला_, --, --,
   {{0xa2aa0066,0x3ebf0506,0x20f70139,0x64950069}},	//   _फ़िल्, šute_, _măi_, _mġid,
   {{0x2907013c,0x00000000,0x00000000,0x00000000}},	//   änar_, --, --, --,
   {{0x44260e03,0xd0420095,0x644b0176,0xcff10033}},	//   _slo_, rtlə, _ajgi, টায়_,
   {{0xd0420095,0x26190e04,0x6f1d004e,0xd49700d8}},	//   stlə, _बकरी_, zysc, бры_,
   {{0xb2b80e05,0x786a0e06,0x2905012e,0x941800c3}},	//   алиф_, býva, _šlag_, ржит_,
   {{0x59cf051e,0x6a7001ff,0x44260051,0xd37700af}},	//   स्कर, räff, _vlo_, йчь_,
   {{0x6d4006d3,0x20f70395,0xf2380279,0x09e60831}},	//   şmay, _băi_, рпош_, নাকা,
   {{0x69dc0e07,0x44260254,0x20f70395,0xc0aa0079}},	//   _mbre, _tlo_, _căi_, داخل_,
   {{0x4386004f,0x69d80963,0x44260e08,0x44200019}},	//   _الإق, न्ती, _ulo_, _ôi_,
   {{0x69dc0e09,0x00000000,0x00000000,0x00000000}},	//   _obre, --, --, --,
   {{0xdd940409,0x44f80019,0x13ad0033,0x25fe00b4}},	//   зары, _kĩ_, _গায়, लाटी_,
   {{0x786a0334,0xe6a50026,0x2d910035,0xb4250035}},	//   zýva, _ऑब्ज, rcze_, łżeń,
   {{0xa3cc021a,0x27e6012f,0x44f80023,0x69ce00cc}},	//   श्च_, jeon_, _mĩ_, _acbe,
   {{0x7b670e0a,0x69dc0024,0x64950024,0x68fc0c6f}},	// [830] стве, _bbre, _iġie, _arrd,
   {{0x69dc0e0b,0x00000000,0x00000000,0x00000000}},	//   _cbre, --, --, --,
   {{0xdd920919,0xa3e8018d,0x4e940088,0x7c230395}},	//   _توپ_, मजा_, _وشیر, _înro,
   {{0x7c670e0c,0x69dc0e0d,0x7aee00c3,0x7d1a0e0e}},	//   _داخل, _ebre, äntä, ätse,
   {{0x7c2d0e0f,0xdcf5045e,0x65610088,0x6495009f}},	//   mhar, mazı, _sylh, _mġie,
   {{0x7afd02ee,0x69d800c0,0x786a0097,0x7aef021d}},	//   _irst, न्दी, rýva, _isct,
   {{0x240907bc,0x1ddb07df,0xafdb08c8,0x7afd0791}},	//   инки_, म्यत, rnøj, _hrst,
   {{0x7afd0902,0x7c2d0e10,0x601f00da,0x44f80019}},	//   _krst, nhar, _fëmi, _dĩ_,
   {{0xc7b9006c,0x7afb022f,0x20f700af,0x00000000}},	//   _idő_, _šutj, _săi_, --,
   {{0x1ddb0e11,0x80cd0033,0xdcf501fb,0x20f70395}},	//   म्मत, ়বস্, hazı, _păi_,
   {{0x7bcf0e12,0x71690036,0x629b0421,0x00000000}},	//   _occu, ранг_, spuo, --,
   {{0xe8e000e2,0x20f70160,0xe8df00cc,0x00000000}},	//   _chộp_, _văi_, _chỉa_, --,
   {{0x7c2d0a12,0x442d006e,0x6d410e13,0xc7d600a5}},	//   dhar, mhe_, úlan, חורי_,
   {{0x443f0e14,0x442d0370,0x7bcf0e15,0x628b0e16}},	//   liu_, lhe_, _accu, _iugo,
   {{0x7afd007c,0x628308dd,0x64950024,0x64490e17}},	//   _arst, _iino, _fġie, onei,
   {{0x443f0e18,0x62830e19,0x7c2d0e1a,0x64490e1b}},	//   niu_, _hino, ghar, nnei,
   {{0x628b0e1c,0xda050e1d,0x63ab0332,0x64490e1e}},	// [840] _jugo, रांत_, _megn, inei,
   {{0x63ab0e1f,0x442d0e20,0x628300b8,0x64490e21}},	//   _legn, hhe_, _jino, hnei,
   {{0x7afd0938,0x7c2d0e22,0x443f01c8,0x78a7006d}},	//   _erst, bhar, kiu_, _cwjv,
   {{0x62830e23,0x7c2d0e24,0x442d0051,0x60da0070}},	//   _lino, char, jhe_, יקענ,
   {{0x442d0e25,0x443f0e26,0x44f80028,0x27e60e27}},	//   dhe_, diu_, _sĩ_, reon_,
   {{0x62830e28,0x7c24007c,0x27e60e29,0x8c1f0033}},	//   _nino, lkir, seon_, নোদন_,
   {{0x7a2001ae,0x628b00ea,0x443f00a0,0x291c00ab}},	//   _nöti, _augo, fiu_, ävad_,
   {{0x442d0e2a,0x443f0e2b,0x628b0e2c,0x62830086}},	//   ghe_, giu_, _bugo, _aino,
   {{0x63ab0e2d,0x7c2401a8,0x628b0124,0x2bcb0d1f}},	//   _degn, ikir, _cugo, िलता,
   {{0x38660e2e,0x628b0e2f,0x64490e30,0x7afb0e31}},	//   llor_, _dugo, anei, _šutk,
   {{0x93540332,0x443f0e32,0xf9930052,0x442d0094}},	//   _کراچ, biu_, ורת_, bhe_,
   {{0x443f0e33,0x63ab0e34,0x64490211,0x7c2402c4}},	//   ciu_, _gegn, cnei, jkir,
   {{0x62830e35,0xc7b30052,0x64400e36,0xe1ef01ca}},	//   _fino, ובר_, mimi, رسی_,
   {{0x7c2d01a2,0x62830e37,0x64400e38,0x63ab008c}},	//   whar, _gino, limi, _zegn,
   {{0x7c2d0e39,0xfe6e0e3a,0x61e8071b,0x7c240024}},	//   thar, دگي_, medl, fkir,
   {{0x59dd0e3b,0x628b022e,0x62830e3c,0x386601f2}},	//   न्नर, _yugo, _zino, jlor_,
   {{0xdceb06d3,0x8d870466,0xdcf505f9,0x628b01ef}},	// [850] ınız, _мунд, razı, _xugo,
   {{0x7afd0e3d,0x7c2d0e3e,0x61e80e3f,0x442d00da}},	//   _vrst, shar, nedl, zhe_,
   {{0x64400e40,0x3ea9012f,0xf8b10416,0x58d40036}},	//   kimi, _hwat_, عکس_, дохт,
   {{0xdce50028,0x443f0e41,0x7afd0e42,0x64400e43}},	//   _nghĩ, xiu_, _trst, jimi,
   {{0x443f0e44,0x63ab0e45,0x660501d3,0xe8e00019}},	//   viu_, _regn, зпла, _khớp_,
   {{0x63ab0133,0x61e80e46,0x628b0e47,0x656500ab}},	//   _segn, jedl, _rugo, ühho,
   {{0x442d0e48,0x443f0e49,0x628b0e4a,0x64400e4b}},	//   the_, tiu_, _sugo, fimi,
   {{0x64400e4c,0x7bcd0e4d,0x628b0cca,0x7aed0e4e}},	//   gimi, ngau, _pugo, owat,
   {{0x63ab00fb,0x443f0e4f,0x62830e50,0x442d0e51}},	//   _vegn, riu_, _pino, rhe_,
   {{0x442d0e52,0x443f0e53,0x63ab0e54,0x64400079}},	//   she_, siu_, _wegn, aimi,
   {{0x442d0e55,0x64400e56,0x63ab0b20,0x443f0e57}},	//   phe_, bimi, _tegn, piu_,
   {{0x644000c8,0x7aed0273,0x628b0e58,0x3ea902e9}},	//   cimi, kwat, _tugo, _bwat_,
   {{0x62830e59,0x6299004e,0x628b0159,0x61e80009}},	//   _tino, _utwo, _uugo, bedl,
   {{0x7aed0e5a,0x3ea902e9,0xe8020084,0xe8e00023}},	//   dwat, _dwat_, _रोना_, _chớp_,
   {{0x7aed0e5b,0x32070035,0x38660e5c,0x7c240e5d}},	//   ewat, _inny_, ylor_, tkir,
   {{0x5fc600a1,0xdddc0187,0x3ebf0e5e,0x7bcd081b}},	//   _वाटल, zorň, šuta_, ggau,
   {{0x7c240e5f,0x6e460e60,0x70db0e61,0x6fa20e62}},	// [860] rkir, _неиз, _बहुल, _क्यू,
   {{0x64400e63,0x7c2408d8,0x4efb02b5,0x1efb0070}},	//   zimi, skir, _פליג, _פליע,
   {{0x64400e64,0xae1b02b5,0xa3ae018d,0xfaff0031}},	//   yimi, _הויכ, करम_, _erë_,
   {{0x7aed0e65,0x00000000,0x00000000,0x00000000}},	//   bwat, --, --, --,
   {{0x64400e66,0x38660e67,0xa2bd0e68,0xb86600b5}},	//   vimi, rlor_, _शिष्, _ہارو,
   {{0x28c90026,0x16030354,0x00000000,0x00000000}},	//   ांशि, लागर_, --, --,
   {{0x443d0e69,0x61e80e6a,0xb8660e6b,0x64400b73}},	//   _bmw_, vedl, _فارو, timi,
   {{0x7afb003a,0x329803e6,0x60c80e6c,0x443d0345}},	//   _šuti, овиќ_, vudm, _cmw_,
   {{0x443d00d5,0x787a00fe,0x61e80e6d,0x00000000}},	//   _dmw_, _důvt, tedl, --,
   {{0x64400e6e,0x80c00e6f,0x248c0a4e,0xf8e007b5}},	//   simi, _विदे, _tudm_, _नहाय,
   {{0x859b0122,0x64400e70,0x64a30e71,0x6608054e}},	//   _השבו, pimi, _заха, _indk,
   {{0x7aed006a,0x35d20243,0x64400e72,0xa3e30d2a}},	//   ywat, _साड़, qimi, _पॉप_,
   {{0x661a0e73,0x82fa02fd,0xaa7b00ee,0x00000000}},	//   _kotk, _دراز_, _osýp, --,
   {{0x661a03ad,0xe3b00416,0x00000000,0x00000000}},	//   _jotk, _سرچ_, --, --,
   {{0x61db0bed,0x601f00da,0x7bcd005f,0x7aed0e74}},	//   _הקוד, _sëmu, tgau, wwat,
   {{0x7bcd00c7,0x00000000,0x00000000,0x00000000}},	//   ugau, --, --, --,
   {{0x3b540e75,0xa3de0835,0x35d20299,0x601f01f4}},	// [870] ектр, द्य_, _साढ़, _dëmt,
   {{0x24860082,0x91fc0080,0x7c870043,0x661a0e76}},	//   _liom_, klām, _нуме, _notk,
   {{0x7aed0e77,0xf9880037,0x9f5200a2,0x41d4007e}},	//   swat, أنمي_, _rayé_, _दानस,
   {{0xa2bd0ac4,0xa3de060a,0x66080e78,0x6fad021a}},	//   _शिल्, द्म_, _andk, चरिं,
   {{0xd6db0e79,0x2366006d,0x661a0e7a,0x9f5200f7}},	//   сте_, _nyoj_, _botk, _payé_,
   {{0x95cb0e7b,0x661a023a,0x59c70066,0x00000000}},	//   суда_, _cotk, _लाटर, --,
   {{0x661a0e7c,0x2486007e,0x80db073f,0xd5b8013a}},	//   _dotk, _biom_, _बहें, _alās_,
   {{0x3e6400b5,0x00000000,0x00000000,0x00000000}},	//   lött_, --, --, --,
   {{0x661a0e7d,0xe1f200b5,0x00000000,0x00000000}},	//   _fotk, چسپ_, --, --,
   {{0x200901b7,0x80d901e0,0x7a20008d,0x00000000}},	//   _anai_, оєму_, _fötu, --,
   {{0x443d027a,0x2486027a,0x7a200093,0xb7bd00af}},	//   _tmw_, _fiom_, _götu, _alţi,
   {{0x59dd06d9,0x76430e7e,0xa3ae0e7f,0x46d10066}},	//   न्तर, liny, करण_, _समाह,
   {{0xd09201c2,0x7a200e80,0xdb0600de,0x9f5f008d}},	//   _müəy, _kött, _pekí, ðuð_,
   {{0xfce600d4,0x1e83010b,0x3e6400b5,0x7a2000b5}},	//   мого, клям, jött_, _jött,
   {{0x91fc0029,0x41b200ce,0x7a200e81,0x3e6400b5}},	//   klāj, _شمير, _mött, dött_,
   {{0x601f0031,0x7a200e82,0x00000000,0x00000000}},	//   _dëms, _lött, --, --,
   {{0x76430e83,0xdd8f0332,0xcb670e84,0x13e00033}},	// [880] kiny, اوہ_, дате_, _মোড়,
   {{0x76430e85,0xda050026,0x6722002f,0x3e6400b5}},	//   jiny, रागत_, vyoj, gött_,
   {{0x76430e86,0x661a0e87,0x6ab60282,0x00000000}},	//   diny, _rotk, ssyf, --,
   {{0x3b0a0e88,0x50c5018d,0x27e005ee,0x80c000be}},	//   _демо_, _विनष, ýin_, _विसे,
   {{0x76430e89,0x24860e8a,0x00000000,0x00000000}},	//   finy, _riom_, --, --,
   {{0xd49a0e8b,0x59dd051d,0x9d45006c,0x2d980e8c}},	//   ори_, न्दर, _آئین, ncre_,
   {{0xf9830e8d,0x661a0e8e,0x7a20017b,0x00000000}},	//   _агро, _votk, _dött, --,
   {{0x764300d7,0xa80301d3,0xb7fb0afa,0x00000000}},	//   ainy, _изсл, _एफएम_, --,
   {{0x20090e8f,0x7a2001ff,0x76430e90,0xe3af0098}},	//   _rnai_, _fött, biny, جرى_,
   {{0x7a20064c,0x20090036,0x7643007b,0x00000000}},	//   _gött, _snai_, ciny, --,
   {{0x24860211,0x00000000,0x00000000,0x00000000}},	//   _tiom_, --, --, --,
   {{0x3e640332,0x53460340,0xdb0f021d,0x00000000}},	//   zött_, _охла, _decê, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x69de0051,0x00000000,0x00000000,0x00000000}},	//   jfpe, --, --, --,
   {{0xdb0600d5,0x463b016b,0x00000000,0x00000000}},	//   _odkó, קעלע, --, --,
   {{0x76430e91,0x61f80e92,0x20090e93,0x69de0223}},	//   ziny, _havl, _unai_, efpe,
   {{0x76430e94,0x3a750947,0x0c840409,0x3e6400b5}},	// [890] yiny, елар, тырм, tött_,
   {{0x61f80a78,0x61fa082b,0x00000000,0x00000000}},	//   _javl, ndtl, --, --,
   {{0xa3ae0ccf,0x76430e95,0x64dd0e96,0x7a200301}},	//   करा_, viny, _महेश, _rött,
   {{0x2c2702ce,0x61f80e97,0xfc3f00b8,0x6d570024}},	//   _цьог, _lavl, _umí_, _ixxa,
   {{0x76430e98,0x6b9a00a5,0x00000000,0x00000000}},	//   tiny, _משרד, --, --,
   {{0xf7700357,0x321c0bca,0x7643012f,0x249e055c}},	//   جام_, _novy_, uiny, _bttm_,
   {{0x76430e99,0x9f4e0355,0x00000000,0x00000000}},	//   riny, čném_, --, --,
   {{0x76430e9a,0xc7c400af,0x26c60207,0x9f4b021d}},	//   siny, _асфи, broo_, recê_,
   {{0xa3de0e9b,0x76430e9c,0x25f7045c,0xddde0e9d}},	//   द्ध_, piny, _एसपी_, _lipš,
   {{0x80c0074f,0x61f80e9e,0xf5270e9f,0xaac70bdd}},	//   _विशे, _cavl, _офен, _लिनक,
   {{0xa06a0ea0,0xe0460ea1,0x64450ea2,0x321c0051}},	//   зана_, енни, éhis, _dovy_,
   {{0x44f10a93,0xdb06016f,0xb4fa00a5,0x80c00ea3}},	//   _iš_, _leká, _מפעי, _विरे,
   {{0xc2c803c7,0xd12e0164,0x442f01ef,0x93270ca8}},	//   _قبول_, لمی_, _ilg_, _تران,
   {{0x2d8c035b,0x7c2f0282,0x61f8093a,0x00000000}},	//   øde_, _alcr, _gavl, --,
   {{0xdb0400c8,0xb4ad0006,0x32d902e9,0x1d070ea4}},	//   mbié, _कबो_, lèy_, нери_,
   {{0x44f10187,0x59dd0569,0x3c2e00a0,0x00000000}},	//   _mš_, न्सर, _býva_, --,
   {{0x442f0ea5,0x2903003c,0x77690282,0x00000000}},	// [8a0] _mlg_, _arja_, _nyex, --,
   {{0x44f10528,0x7c2f0176,0x4a4303e6,0x2d9a0183}},	//   _oš_, _elcr, гнув, _ufpe_,
   {{0x4c860ea6,0xd8260ea7,0xdb06040f,0x6f0400d5}},	//   _плов, нджи, _deká, _hric,
   {{0x6f040ea8,0x69d50ea9,0xa01b0eaa,0xdc9b0070}},	//   _kric, _ecze, rmög, _מיטל,
   {{0xdcfc0669,0x44f101c8,0xa01b033b,0xdb0600d5}},	//   marı, _aš_, smög, _feká,
   {{0xdcfc0eab,0x80c00026,0xceb30317,0x6f0400e0}},	//   ları, _विले, ריג_, _mric,
   {{0xdb1d0107,0x6e200055,0x442f0553,0x20d801ef}},	//   _adsè, ëmby, _blg_, xéi_,
   {{0x6f040012,0x61f80eac,0xdcfc00c1,0x442f0098}},	//   _oric, _savl, narı, _clg_,
   {{0x5334002d,0x44f100f4,0x99610228,0x00000000}},	//   тепт, _eš_, _cīņa_, --,
   {{0xdb0f0176,0x2d8c0bca,0x442f0ead,0xdb0400a2}},	//   _decè, ždej_, _elg_, rbiè,
   {{0x40350607,0xdcfc01d6,0x6f040eae,0x3a370122}},	//   венс, karı, _aric, גרים_,
   {{0x6f040eaf,0x00000000,0x00000000,0x00000000}},	//   _bric, --, --, --,
   {{0x44f1024e,0x61f80eb0,0x6d4805c9,0x93460eb1}},	//   _zš_, _tavl, údan, _янде,
   {{0x6f04013c,0xbe8800c3,0x00000000,0x00000000}},	//   _dric, ессе_, --, --,
   {{0xf1b302b8,0xcfb00083,0x2d850eb2,0xdb040183}},	//   _עסק_, _কারন, äle_, caiú,
   {{0x6f040eb3,0x3ea00484,0xac1803fa,0x656500be}},	//   _fric, _ftit_, носу_, ühhi,
   {{0x06e800c8,0x6c540eb4,0xf9c70eb5,0x6f040eb6}},	// [8b0] পিডি, укту, ещен, _gric,
   {{0x60c80223,0x00000000,0x00000000,0x00000000}},	//   ordm, --, --, --,
   {{0x628a0eb7,0xdcfc045e,0x98b9002d,0x00000000}},	//   _mifo, barı, флет_, --,
   {{0x69d5004e,0x9964002d,0x628a0eb8,0xdcfc00a8}},	//   _wcze, утул, _lifo, carı,
   {{0xe8df01a5,0x44f100ac,0x80380070,0x799c001e}},	//   _thỏa_, _sš_, ענדע_, _ffrw,
   {{0x69d5004e,0xb5c20eb9,0x442f023a,0x628a0064}},	//   _ucze, айшл, _slg_, _nifo,
   {{0x442f0eba,0x00000000,0x00000000,0x00000000}},	//   _plg_, --, --, --,
   {{0x13090ebb,0xd138004e,0x32d902d0,0x44f10097}},	//   дний_, dzą_, tèy_, _vš_,
   {{0x628a013c,0x27ef008c,0x35f50ebc,0x95d903e6}},	//   _bifo, megn_, _ипар, _одат_,
   {{0xdcfc0463,0x32d902e9,0x628a09c8,0x644201d7}},	//   zarı, rèy_, _cifo, _emoi,
   {{0xa2bd0ebd,0xf9920122,0x628a0044,0xdcfc00d0}},	//   _शिक्, ירי_, _difo, yarı,
   {{0x6f040ebe,0xdcfc0095,0x3ea00ebf,0x22450a8a}},	//   _pric, xarı, _ptit_, silk_,
   {{0x63a90ec0,0x539a0bed,0xdcfc00d0,0x26cf0ec1}},	//   mben, _חינו, varı, nugo_,
   {{0x63a90ec2,0x6fa202e4,0x628a0371,0x78780ec3}},	//   lben, _क्रू, _gifo, míve,
   {{0xdcfc0ec4,0xd1380035,0xd7b30ec5,0x78780ec6}},	//   tarı, czą_, ुणाच, líve,
   {{0x218800c2,0x51840131,0x31560070,0x26cf0ec7}},	//   _אָפּ, _суча, _שיקן_, kugo_,
   {{0x78780370,0x27fd0297,0xa3c40084,0xdcfc04d4}},	// [8c0] níve, ddwn_, ौलत_, rarı,
   {{0xdcfc01d6,0x26cf0ec8,0x00000000,0x00000000}},	//   sarı, dugo_, --, --,
   {{0xd7fa0ec9,0x28c90380,0xdcfc00c1,0xee3700af}},	//   дул_, ांगि, parı, _рнэ_,
   {{0x26cf0054,0x63a90eca,0x00000000,0x00000000}},	//   fugo_, jben, --, --,
   {{0x63a9068b,0xfaa60dec,0x00000000,0x00000000}},	//   dben, _јаго, --, --,
   {{0x63a901ae,0x787800b8,0x6442009e,0x00000000}},	//   eben, díve, _smoi, --,
   {{0xd9460ecb,0x628a046f,0xdb0f0ecc,0xaa430ecd}},	//   _реви, _rifo, _recé, _терл,
   {{0x13f40036,0x7c360297,0xa5070202,0xd7060ece}},	//   узия, nhyr, ђења_, _изби,
   {{0x26dd004e,0xa6860ecf,0x97ea0095,0xe0ae0083}},	//   ctwo_, _алад, ışdı, _কমেন,
   {{0x620601e0,0x00000000,0x00000000,0x00000000}},	//   тчиз, --, --, --,
   {{0x1be20141,0xc4c50c26,0x64570138,0x6d480138}},	//   खभाल_, _متنو, éxic, údal,
   {{0x74130088,0x14d7011d,0x78780132,0xd1380035}},	//   _پوها, _יובל_, bíve, rzą_,
   {{0xd138004e,0x628a0ed0,0x78780183,0xdd3a0139}},	//   szą_, _tifo, cíve, _păşe,
   {{0xa3de04aa,0x5bcb00b4,0x00000000,0x00000000}},	//   द्र_, िल्व, --, --,
   {{0xa2f200dc,0x69c80225,0x00000000,0x00000000}},	//   _अनुज_, _ödey, --, --,
   {{0xc61f0ed1,0xdb0f00af,0x00000000,0x00000000}},	//   _भव्य_, _decî, --, --,
   {{0x06d70083,0x9f520176,0xeb0d01c0,0x00000000}},	// [8d0] _দৈনি, _gayà_, समेत_, --,
   {{0x63a9029d,0x26cf0010,0xbdf500ed,0x5a340ed2}},	//   zben, vugo_, _спој, анут,
   {{0x63a90ed3,0x27ef082b,0x00000000,0x00000000}},	//   yben, tegn_, --, --,
   {{0xdb060ed4,0x00000000,0x00000000,0x00000000}},	//   _bekä, --, --, --,
   {{0x27ef0075,0x7c2d0ed5,0x78780132,0x26cf0207}},	//   regn_, mkar, xíve, uugo_,
   {{0xd774004f,0x26cf0ed6,0xbb3a0070,0x78780183}},	//   جامع, rugo_, _טערי, víve,
   {{0xd4690ed7,0x26dd0035,0x245a00ea,0xa3ae022e}},	//   нике_, stwo_, zīme_, करं_,
   {{0x78780ed8,0x63a90ed9,0xc6a7002d,0xa3e300b4}},	//   tíve, uben, _аржи, _पॉश_,
   {{0x63a90eda,0x7c2d0edb,0xc7b20122,0x6ae10033}},	//   rben, ikar, _לבן_, নিকো,
   {{0x63a90edc,0x96f80d82,0x7c2d0edd,0x00000000}},	//   sben, _جعفر_, hkar, --,
   {{0x7c2d0ede,0x78780279,0x9f4e00b8,0x69d80035}},	//   kkar, síve, čním_, न्टी,
   {{0xd5df0edf,0xddd501c0,0xdb0a0187,0x7c2d0ee0}},	//   प्रज, mozř, šnéh, jkar,
   {{0x91e50ee1,0x442d0ee2,0x7c2d0ee3,0x644901ef}},	//   _боле, mke_, dkar, miei,
   {{0xdd920082,0xf7760070,0xd5b1055c,0x00000000}},	//   صور_, טערי_, _bói_, --,
   {{0x442d0ee4,0x7c360ee5,0x09b20083,0xed570ee6}},	//   oke_, thyr, _চালা, гор_,
   {{0x7c2d0ee7,0xaca9006c,0x09cc0099,0x8c430652}},	//   gkar, کھیے_, ाल्य, бесе,
   {{0x9b93004f,0x442d0ee8,0x7c360ee9,0xed1700b5}},	// [8e0] إلكت, ike_, rhyr, نہیں_,
   {{0xe9d7051b,0x9a6a0eea,0x3b830eeb,0x442d0eec}},	//   лку_, رمال_, слуг, hke_,
   {{0x442d0eed,0x7c2d00a8,0x8c460eee,0xf4be0033}},	//   kke_, bkar, _бене, _আহ্ব,
   {{0x442d0eef,0x7c2d0ef0,0xa3e302e4,0x3eb20b88}},	//   jke_, ckar, _पॉल_, _kwyt_,
   {{0x442d0ef1,0xd7070421,0x00000000,0x00000000}},	//   dke_, лнце_, --, --,
   {{0x442d0903,0x38c80ef2,0x9f5b0031,0x00000000}},	//   eke_, _لاری_, _saqë_, --,
   {{0x6449001e,0x7af600e9,0x04660ef3,0x629d0138}},	//   fiei, lwyt, лтим, íson,
   {{0x25f0004e,0x7bd6043d,0x442d0ef4,0xd46703fa}},	//   _इसकी_, ngyu, gke_, лије_,
   {{0xa6ca0ef5,0xd5d6006c,0x3866081f,0x05d6004f}},	//   _سوال_, _متاث, moor_, _مزاج,
   {{0xd6cf0c9e,0xe29f00fb,0x7c2d0291,0x442d0ef6}},	//   _رقم_, íða_, zkar, ake_,
   {{0xf5930082,0xa1580de0,0x05560ef7,0x09de0033}},	//   _المج, тану_, _стая, ড়পা,
   {{0x442d0ef8,0x764a02e9,0x557700c2,0x38660173}},	//   cke_, lify, _געבן_, noor_,
   {{0x80c00433,0x09cc0083,0x7c2d0ef9,0xbf0f0efa}},	//   _विके, র্যা, vkar, ामेन_,
   {{0xe80b0299,0x38660173,0x764a0efb,0x7c2d0efc}},	//   _सोना_, hoor_, nify, wkar,
   {{0x16d10efd,0x7c2d0efe,0x25f70066,0x28c900b4}},	//   _सम्ब, tkar, _एससी_, ांछि,
   {{0x09cc0083,0xa3e70eff,0x38660b88,0xd175010b}},	//   র্মা, म्प_, joor_, _тычы,
   {{0x38660f00,0x3c58002d,0x00000000,0x00000000}},	// [8f0] door_, уитэ_, --, --,
   {{0x7c2d0f01,0x6d410f02,0x442d0f03,0xdfd1006c}},	//   skar, úlas, zke_, _ايک_,
   {{0x764a02d0,0x442d0f04,0x09cc0033,0x38660298}},	//   dify, yke_, র্ভা, foor_,
   {{0x386603bc,0x00000000,0x00000000,0x00000000}},	//   goor_, --, --, --,
   {{0x442d0f05,0x2ba5022e,0x64490952,0x6f1b033b}},	//   vke_, गुणा, viei, äuch,
   {{0x80aa0b52,0x09cc00c8,0xa3e7045c,0xc9870369}},	//   _কিন্, র্বা, म्न_, _буби,
   {{0x442d0bcc,0x3d080f06,0x386601bf,0x84590382}},	//   tke_, हिये_, boor_, крит_,
   {{0x442d0f07,0x6a6b033b,0x14250f08,0x91fc0228}},	//   uke_, rüfu, рдим, klās,
   {{0xe80b0f09,0x64490f0a,0x7cec00b5,0x7a32008c}},	//   _सोया_, riei, _körö, _mætn,
   {{0x442d0f0b,0x3d080302,0x27ff0328,0xdb0f0097}},	//   ske_, हिमे_, _haun_, _necí,
   {{0xc32300c8,0x442d0f0c,0x787800de,0x69dd0f0d}},	//   _বেশি_, pke_, líva, _पानी,
   {{0xdb0f03e6,0x27ff0f0e,0x5f060210,0x6495005f}},	//   _mecâ, _jaun_, азма, _ašig,
   {{0x92b70082,0x63bb0f0f,0x27ff0f10,0x248f01ef}},	//   _إحصا, maun, _maun_, _iigm_,
   {{0x40950cb5,0xed5a0202,0x63bb0f11,0x27ff0f12}},	//   _крит, вог_, laun, _laun_,
   {{0x61420f13,0xdb0f0f14,0x629b0176,0x32f60067}},	//   _меша, _decí, lquo, _zły_,
   {{0x63bb0f15,0x229b0345,0x27ff0065,0x00000000}},	//   naun, _kêk_, _naun_, --,
   {{0xe9da0f16,0xa3e705f8,0xeb970043,0x38660120}},	// [900] кка_, म्य_, риу_, voor_,
   {{0x63bb043d,0x7af6001e,0x787800b8,0x20000088}},	//   haun, rwyt, díva, _haii_,
   {{0x41dd0f17,0x63bb0f18,0x26190632,0xf1dd08b6}},	//   _मानस, kaun, पानी_, _मानन,
   {{0xdb0f0043,0x63bb0029,0xa3e7000c,0x20020f19}},	//   _decâ, jaun, म्म_, ndki_,
   {{0x27ff0f1a,0x38660626,0x764a0f1b,0x63bb0f1c}},	//   _daun_, roor_, tify, daun,
   {{0x7cec00b5,0x69dd052f,0xb8dc0831,0x00000000}},	//   _görö, _पायी, _আম_, --,
   {{0x01bb0b52,0x764a0f1d,0x38660f1e,0x26df0f1f}},	//   ংলাদ, rify, poor_, _equo_,
   {{0x27ff0f20,0x63bb0f21,0x290a0118,0x00000000}},	//   _gaun_, gaun, _irba_, --,
   {{0xd3770f22,0x6459012f,0x46a30f23,0x07a30f24}},	//   ичь_, _djwi, _матв, _фаун,
   {{0x20120f25,0xdb0401ef,0x27ff0110,0x00000000}},	//   _anyi_, laió, _zaun_, --,
   {{0x7bc60f26,0x20000160,0x9f4b02d7,0x64a30f27}},	//   _odku, _baii_, recí_, _даха,
   {{0x78a100b5,0x27e600e9,0x920200ea,0x20000395}},	//   _élve, nfon_, _šāda, _caii_,
   {{0x200500b8,0x629b00f6,0x44f800e2,0xa85700a5}},	//   ěli_, cquo, _hũ_, שיכה_,
   {{0x2005006a,0x290a012f,0x20120cdf,0xf1dd0f06}},	//   śli_, _orba_, _enyi_, _मायन,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8f470f28,0x1dd30084,0x44f80019,0x705500d1}},	//   _вход, _ताकत, _mũ_, _دنبا,
   {{0x290a01c8,0x207c02b5,0x905c0122,0x44f80019}},	// [910] _arba_, _באהא, _שכחת, _lũ_,
   {{0x39a70f29,0x63bb01b7,0x7a380f2a,0x27ff0f2b}},	//   ршав, zaun, апур_, _saun_,
   {{0x27ff0f2c,0x7cec00b5,0x69dd0099,0x9f40021d}},	//   _paun_, _vörö, _पाठी, _ibiá_,
   {{0xdd1c00b8,0xd7c80698,0x629b00f6,0x78780f2d}},	//   _nářa, لومه_, yquo, tíva,
   {{0xd6db0f2e,0xe5a509d0,0x290a0f2f,0x8c1a0122}},	//   тте_, били, _erba_, _עושי,
   {{0xd6ce0098,0x63a20f30,0x7afd0f31,0x69dc0079}},	//   رقى_, _afon, _isst, _gcre,
   {{0x27ff00bf,0x44f801a5,0x290a0f32,0x63bb0f33}},	//   _taun_, _cũ_, _grba_, taun,
   {{0xed580122,0x80c00967,0x6d480037,0x61ea02b1}},	//   יבור_, _विजे, údai, _abfl,
   {{0x63bb0f34,0x386d0f35,0x86980f36,0xdb060f37}},	//   raun, _iker_, _вкус_, _sekú,
   {{0x629b02e1,0xe4e702ce,0xdb0f0310,0x63a20f38}},	//   rquo, _відн, _mecà, _efon,
   {{0x92d700c8,0x26190f39,0x63bb0f3a,0x63a2001e}},	//   াবে_, पाठी_, paun, _ffon,
   {{0x66010f3b,0x44e10f3c,0x6e25009e,0xaac70f3d}},	//   _halk, mó_, _aohb, _लिंक,
   {{0x69c70f3e,0x44e10f3f,0x539a00a5,0x7afd03d0}},	//   _odje, ló_, _עיסו, _nsst,
   {{0x69c701d2,0x6da30d28,0x66010086,0xada3027a}},	//   _ndje, зира, _jalk, зарл,
   {{0x2d8c01ff,0x44e10f40,0x80ce0066,0x386d01a3}},	//   äde_, nó_, _थिये, _oker_,
   {{0x69dc0f41,0x62990f42,0x7aef0f43,0xbea60e9f}},	//   _scre, _kuwo, _bpct, _лаик,
   {{0x290a0f44,0xa3df0299,0x63b9001e,0x6299012f}},	// [920] _srba_, _तान_, _mewn, _juwo,
   {{0xbf9b0370,0x69dd00a1,0xdb0f01f7,0x386d08d7}},	//   ndên, _पाणी, _decà, _aker_,
   {{0x31ba00c2,0x93f900a1,0x44e10f45,0x629900d7}},	//   רזענ, ्याच_, jó_, _luwo,
   {{0x387f0f46,0x44e10f47,0xe73a03ad,0x44f80019}},	//   _chur_, dó_, лее_, _rũ_,
   {{0x27e60f48,0x387f0f49,0x629900e0,0x00000000}},	//   rfon_, _dhur_, _nuwo, --,
   {{0x7ae40f4a,0xfaa30f4b,0x386d0f4c,0xceb30317}},	//   mtit, _харо, _eker_, ליד_,
   {{0x44e10f4d,0x96c4004e,0x7c260f4e,0x7ae40f4f}},	//   gó_, _रिकॉ, _kokr, ltit,
   {{0x44f80028,0x69c70f50,0x62990f51,0x7c260f52}},	//   _vũ_, _zdje, _buwo, _jokr,
   {{0x8c1b0052,0x66010f53,0x82380421,0x326601d3}},	//   רופי, _falk, изис_, йтов,
   {{0x41dd02cb,0x66010f54,0x44e10f55,0x8afb02b5}},	//   _माणस, _galk, bó_, נהיי,
   {{0x04960082,0x44e10033,0xdb0f0f56,0x7ae40421}},	//   _الصح, có_, _mecá, htit,
   {{0x6e2501d6,0x7ae40f57,0x7c260044,0x787801ba}},	//   _sohb, ktit, _nokr, zívn,
   {{0x447b00c2,0xdb1d0097,0x6299001c,0xdb0401ed}},	//   _ענדע, _odsá, _guwo, kaiñ,
   {{0x7ae40f58,0x63b90035,0x2b400f59,0xbc9503e6}},	//   dtit, _zewn, dzic_, жавј,
   {{0x44260f5a,0x90a606ca,0x7c260f5b,0x7ae40223}},	//   _koo_, _احتم, _bokr, etit,
   {{0x44260f5c,0x7c260f5d,0x7ae40160,0x7a200f5e}},	//   _joo_, _cokr, ftit, _götz,
   {{0x44260189,0x2fc90f5f,0x44e10332,0x78780038}},	// [930] _moo_, _idag_, zó_, tívn,
   {{0x44260f60,0x386d0f61,0x98b80463,0x44e10831}},	//   _loo_, _sker_, _ayrı_, yó_,
   {{0x7ae40036,0xda780f62,0xdb0f0f63,0x6f0d0187}},	//   atit, сят_, _decá, _hrac,
   {{0x44260f64,0x6f0d0f65,0x44e10f40,0x66010f66}},	//   _noo_, _krac, vó_, _salk,
   {{0x66010f67,0xf6e70f68,0xe61000b5,0xd36600bc}},	//   _palk, сцен, کشن_, _آه_,
   {{0x44e100f5,0x69c70f69,0xd1260bdf,0x6f0d0f6a}},	//   tó_, _udje, _قم_, _mrac,
   {{0x63b9006a,0x66010f6b,0xe3b1004f,0x5e580070}},	//   _pewn, _valk, ورة_, זיגע_,
   {{0x44e10f6c,0xf4290f6d,0x64950009,0x66010f6e}},	//   ró_, роил_, _ašic, _walk,
   {{0xe81602cb,0x44e10f6f,0x66010f70,0x68e50f71}},	//   णारा_, só_, _talk, lthd,
   {{0x2fc900fd,0x63b90035,0x44e10f72,0x317c0124}},	//   _adag_, _wewn, pó_, _bzvz_,
   {{0x6f0d0f73,0x3ea90043,0x0ef40026,0x7a3b00f7}},	//   _arac, _atat_, ेट्स_, _gîte,
   {{0xa06a010c,0x68e500e9,0x44c500ea,0x44260147}},	//   рама_, ithd, mē_, _goo_,
   {{0x44c50029,0x644b009f,0x6f0d0f74,0x6495035f}},	//   lē_, _imgi, _crac, _eġit,
   {{0x7ae40523,0x44260f75,0x64a300f4,0x00000000}},	//   vtit, _zoo_, _gđic, --,
   {{0x44260f76,0x8c0100c8,0x27ed02bf,0x3ea90f77}},	//   _yoo_, _একজন_, _oben_, _etat_,
   {{0x6a7002c9,0x4426006d,0xeb970f78,0x27ed01ed}},	//   häft, _xoo_, жит_, _nben_,
   {{0x6f0d0f79,0x7ae40453,0x3b0706c2,0x3a260f7a}},	// [940] _grac, utit, оето_, омаг,
   {{0x7ae40f7b,0x78780f7c,0x27ed008c,0x3205024b}},	//   rtit, tívo, _aben_, ndly_,
   {{0x7ae40f7d,0xe8fa0f7e,0x644b0f7f,0xe81600a1}},	//   stit, рле_, _omgi, णाला_,
   {{0x7ae40f80,0xdb24006c,0xb6c800b5,0x44c500ea}},	//   ptit, _فوجی, ماتے_, dē_,
   {{0x44260f81,0xaac701c0,0xdb0401ed,0x00000000}},	//   _roo_, _लिएक, paiñ, --,
   {{0x27ed0f82,0x3af902b5,0xa3e702b4,0x644b0008}},	//   _eben_, _פּרע, म्स_, _amgi,
   {{0x44260f83,0xd4970733,0xd0b100a8,0x00000000}},	//   _poo_, оры_, _təəs, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44260f84,0x69da0225,0x2fc9008c,0x00000000}},	//   _voo_, _ötes, _rdag_, --,
   {{0x81d20083,0x23dc012f,0x44260f85,0x6f0d0031}},	//   হ্ন_, _यावद, _woo_, _rrac,
   {{0x4a7b00c2,0x44260122,0xfbca0967,0x649500b8}},	//   שריב, _too_, िणाम, _všic,
   {{0x6f0d0f86,0x403400c3,0x35e0073f,0x00000000}},	//   _prac, деюс, _नाड़, --,
   {{0xa3df01d1,0x2fc90345,0xa3e3021a,0x00000000}},	//   _तात_, _vdag_, _पॉट_, --,
   {{0xdef801c8,0x64950207,0x00000000,0x00000000}},	//   цыю_, _ušic, --, --,
   {{0xdd9400c7,0x6f0d0f87,0x6ce400d4,0x40350f88}},	//   дары, _wrac, міте, _некс,
   {{0x6f0d0f89,0xafdb0c71,0x26110f8a,0x69dd0099}},	//   _trac, riøs, _धोनी_, _पाही,
   {{0x6f0d0f8b,0x97ea033e,0x44c500ea,0x5a350f8c}},	// [950] _urac, ışlı, zē_, пнат,
   {{0x78a300fd,0xd042013b,0x00000000,0x00000000}},	//   ínvo, drlə, --, --,
   {{0x6aad0036,0x7a32008c,0x64950168,0xa3da00be}},	//   spaf, _mæth, _ošia, ़ला_,
   {{0xdb1f01f4,0x68e50f8d,0xa8020225,0x9cd6076b}},	//   naqë, rthd, _çılg, _צורה_,
   {{0x8c1a0122,0x00000000,0x00000000,0x00000000}},	//   _הורי, --, --, --,
   {{0x386600f4,0x00000000,0x00000000,0x00000000}},	//   čora_, --, --, --,
   {{0x6a700f8e,0x25ec007c,0x19580f8f,0x7af901fb}},	//   räft, _आउरी_, _дары_, şatı,
   {{0x44390f90,0x26190f91,0x57f40166,0xf99200a5}},	//   ós_, पाही_, _опст, _טרם_,
   {{0xf7490082,0x051b0033,0x44c500ea,0x45d50043}},	//   _الذي_, তনের_, sē_, _ноас,
   {{0x363700bf,0xc2420f92,0xd5b100e2,0x32050f93}},	//   _بررس, еньк, _góp_, udly_,
   {{0x21690500,0x3205024b,0x86220647,0xdb1f0055}},	//   сини_, rdly_, _سکول, faqë,
   {{0x293602b5,0x3e76008d,0x00000000,0x00000000}},	//   פארן_, mæti_, --, --,
   {{0x20040038,0xb4bb0380,0x3e76008d,0x00000000}},	//   ľmi_, _अबु_, læti_, --,
   {{0x3d080930,0x161e00b4,0x00000000,0x00000000}},	//   हिले_, पायर_, --, --,
   {{0xc6920122,0x91ba00a5,0xed5200b5,0x20560f94}},	//   תאם_, _המצי, رپر_, _нтир,
   {{0x443f0f95,0x4ac70722,0xaac70066,0x645b0f96}},	//   nhu_, _लिखव, _लिखक, nnui,
   {{0x6b630f97,0xe0850f98,0x998306fe,0x00000000}},	// [960] екта, _تجوي, _bojů_, --,
   {{0xd042013b,0x499a0f99,0x00000000,0x00000000}},	//   vrlə, стая_, --, --,
   {{0x443f0f9a,0x290e0093,0xd88a00b5,0xa96a0079}},	//   khu_, ífa_, مپئن_, حمام_,
   {{0xfc32004f,0xdb040120,0x26110b4d,0x7a32008d}},	//   _أحد_, ncië, _धोबी_, _mæti,
   {{0xfbd30052,0x443f0f9b,0x628300d5,0xf3f900af}},	//   _אתר_, dhu_, _ohno, deţ_,
   {{0xe8df0028,0xdb0f0279,0x4b7b00a5,0x7c2401a0}},	//   _giữa_, _secç, _לאכו, ljir,
   {{0x9f590298,0x00000000,0x00000000,0x00000000}},	//   gesê_, --, --, --,
   {{0x7c240010,0x443f003c,0xb3c60f9c,0x43940f9d}},	//   njir, ghu_, रृंख, майс,
   {{0xdb06006c,0x00000000,0x00000000,0x00000000}},	//   _nekü, --, --, --,
   {{0x6283006b,0x443f034d,0x31340f9e,0x61f300d5}},	//   _chno, ahu_, деор, _čelí,
   {{0xf1dd0084,0x26190f9f,0x443f0fa0,0x00000000}},	//   _मारन, पारी_, bhu_, --,
   {{0x443f0fa1,0xc4860733,0x39570122,0xe1ef006c}},	//   chu_, _элек, לשים_, پسی_,
   {{0x69dd00b4,0x26c600b9,0xee870421,0x7a320a8a}},	//   _पाली, nsoo_, зыво, _tæth,
   {{0xd2500fa2,0x6ece0f8a,0x628300f1,0x6ca705e8}},	//   _جنت_, _तिरु, _ghno, зраж,
   {{0x61fa0fa3,0xa1570fa4,0xe9ff0019,0xf27b011d}},	//   metl, _нашу_, _ngạc_, _הרגש,
   {{0x61fa0fa5,0x31c601c0,0x415b00a5,0x7c240055}},	//   letl, bízí_, _לדוג, gjir,
   {{0xdb040248,0xa3df00a1,0x7b1800af,0xdb06033b}},	// [970] nciè, _तास_, потр_, _gekü,
   {{0x61fa0fa6,0x443f00ec,0xe29f008d,0x7c24002f}},	//   netl, zhu_, íði_, ajir,
   {{0xb4bb0437,0x6ca40fa7,0x7c380138,0xa3bc007c}},	//   _अबे_, _пряж, ñará, अरा_,
   {{0xf77000d1,0x61fa0fa8,0xdb0d0138,0x9f590031}},	//   گام_, hetl, lbaí, jesë_,
   {{0x26190fa9,0x61fa0723,0x6440004f,0xdb060faa}},	//   पाली_, ketl, dhmi, _dekó,
   {{0x61fa0280,0xf7700fab,0x60da046a,0xa3df0066}},	//   jetl, دام_, kutm, _ताह_,
   {{0x443f0fac,0x61fa0fad,0x00000000,0x00000000}},	//   thu_, detl, --, --,
   {{0xc9520122,0xdb1d01f4,0x6283078b,0x7bdf0fae}},	//   _סמן_, _nesë, _shno, ngqu,
   {{0x36d40faf,0x443f0fb0,0x130600c3,0x61fa027d}},	//   _потр, rhu_, дный_, fetl,
   {{0x443f0fb1,0xa3df0864,0x645b002d,0x68e1013c}},	//   shu_, _ताव_, snui, _älds,
   {{0xa2cf0d2a,0x3de30083,0x443f0fb2,0xdb1d0031}},	//   _दिव्, য়াল, phu_, _besë,
   {{0xcdc90052,0x64400fb3,0x261100ab,0x831900b5}},	//   _כך_, chmi, _धोती_, _وقار_,
   {{0xdb060c1f,0x43740166,0x09d50083,0xdb0401e4}},	//   _lekò, _пушт, স্যা, rcië,
   {{0x29110160,0x00000000,0x00000000,0x00000000}},	//   _orza_, --, --, --,
   {{0x6da30fb4,0x1d0707c3,0x64850079,0xa2d90ac4}},	//   тиса, мери_, róif, फूर्,
   {{0x32070fb5,0x6e210093,0xdb1d0fb6,0x41dd00b4}},	//   _hany_, ölbr, _gesë, _माँस,
   {{0x7c240fb7,0x29030fb8,0xfaff00ea,0x29110088}},	// [980] rjir, _asja_, šīnu_, _arza_,
   {{0x6f040fb9,0x7c360fba,0x320700ac,0x2911011c}},	//   _isic, skyr, _jany_, _brza_,
   {{0xeb9a0e0a,0x32070052,0x8c460fbb,0xae1b02b5}},	//   _мин_, _many_, _жене, _וויכ,
   {{0x32070176,0x3ea00fbc,0x9f5902e9,0x61fa0fbd}},	//   _lany_, _kuit_, fesè_, zetl,
   {{0x41dd0808,0x61fa0fbe,0x15fc00b4,0x00000000}},	//   _मांस, yetl, _एसआर_, --,
   {{0x6f040054,0x28db0fbf,0x2fc001a6,0x443d00e9}},	//   _msic, मूहि, _leig_, _alw_,
   {{0x5e5700c2,0x61fa0fc0,0x64400fc1,0x9f5901f4}},	//   ויסע_, vetl, thmi, tesë_,
   {{0x7bc40fc2,0xdb1d0118,0x672d0031,0x3d0f018d}},	//   naiu, _besè, ënjë, डिते_,
   {{0xa3df0fc3,0x3ea002e1,0x61fa0fc4,0x68e1022a}},	//   _तार_, _nuit_, tetl, _äldr,
   {{0xa6830fc5,0x644001f4,0x2fc00176,0xdb1d0fc6}},	//   _алуд, shmi, _aeig_, _desè,
   {{0x61fa0fc7,0xae220722,0x443d0183,0x661a009f}},	//   retl, मानन_, _flw_, _intk,
   {{0x61fa0fc8,0x68e1022a,0xf9930122,0x3ea00fc9}},	//   setl, _ålde, כרת_, _buit_,
   {{0x61fa0fca,0x69ce01ba,0x3ea00fcb,0xdb0d00a8}},	//   petl, _odbe, _cuit_, çkün,
   {{0x3ea00fcc,0x32070107,0x00000000,0x00000000}},	//   _duit_, _gany_, --, --,
   {{0xd30800e8,0x24860221,0x2bd00fcd,0x6f040036}},	//   _hệ_, _khom_, तृभा, _esic,
   {{0x3ea00fce,0xdb0602e9,0x69ce01a2,0xd3080019}},	//   _fuit_, _rekò, _adbe, _kệ_,
   {{0x661a03c4,0xae0c0fcf,0x7a320093,0xb4bb0387}},	// [990] _ontk, िएशन_, _lætu, _अब्_,
   {{0x200903bc,0x62980069,0xdb060107,0x00000000}},	//   _haai_, _jivo, _pekò, --,
   {{0xd30801a5,0xa3df0fd0,0x386f0009,0x62980987}},	//   _lệ_, _ताल_, togr_, _mivo,
   {{0xa2cf0fd1,0xec3500c2,0x315702b5,0x62980fd2}},	//   _दिल्, _נאָר_, ויבן_, _livo,
   {{0x66080fd3,0x20090fd4,0x00000000,0x00000000}},	//   _badk, _maai_, --, --,
   {{0x62980fd5,0x2ca1012f,0x660800d5,0x2009053e}},	//   _nivo, _kuhd_, _cadk, _laai_,
   {{0x660800ee,0x6d470484,0x69c50fd6,0x9f5902e9}},	//   _dadk, nzja, mahe, sesè_,
   {{0xcd9802da,0x24860fd7,0x69c50fd8,0x2ca1028b}},	//   ודות_, _chom_, lahe, _muhd_,
   {{0x32070176,0x443d0fd9,0xfe0f0fd0,0xf7730fda}},	//   _pany_, _vlw_, ायास_, _شار_,
   {{0x3ea00fdb,0x66080fdc,0xfc3f0176,0x649500c7}},	//   _ruit_, _gadk, _llí_, _išim,
   {{0x09d500c8,0xdb1d07a6,0x2009053e,0xd00a0fdd}},	//   স্থা, _desé, _baai_, пене_,
   {{0x7a3200fb,0x7878024e,0x69c50fde,0x23600187}},	//   _hætt, tívi, hahe, _žije_,
   {{0x20090173,0x63a90fdf,0x64850fe0,0x2fc00443}},	//   _daai_, mcen, róid, _veig_,
   {{0x09d500c8,0xfc3f043f,0x3ea00443,0xe29f0093}},	//   স্তা, _alí_, _vuit_, íðu_,
   {{0x75f30463,0x69c50fe1,0x7a32008a,0x63a90fe2}},	//   mızı, dahe, _mætt, ocen,
   {{0x62980fe3,0x63a90fe4,0x98a700b8,0x3ea00fe5}},	//   _zivo, ncen, šně_, _tuit_,
   {{0xfc3f004f,0xf1d30035,0x1e960b90,0x764300d7}},	// [9a0] _dlí_, _दयान, _прор, khny,
   {{0x19b901c8,0x69c50fe6,0xd9460fe7,0x75f300d0}},	//   дуць_, gahe, нези, nızı,
   {{0xa3df0099,0x660800ac,0x7bc400d7,0xba3b0fe8}},	//   तला_, _radk, paiu, _suïc,
   {{0xc18c02b5,0x59e20026,0x63a903e0,0xe78601e0}},	//   קטאָ, _पावर, jcen, нуло,
   {{0xe7370fe9,0x69c50fea,0x26dd0feb,0x660803bc}},	//   нец_, bahe, guwo_, _padk,
   {{0x63a90fec,0x69ce01b4,0x69c500cc,0xfc3f00ac}},	//   ecen, _udbe, cahe, _zlí_,
   {{0x62980fed,0x2486006f,0xdb1d002a,0x649500f4}},	//   _rivo, _phom_, _resé, _išij,
   {{0x62980fee,0x76430fef,0xdb0f002a,0x63a90a8a}},	//   _sivo, ahny, _recú, gcen,
   {{0xa01b008a,0x885700a5,0xdb08000d,0x2009053e}},	//   llög, _נשמע_, élèv, _raai_,
   {{0xd3080028,0x63a90ff0,0x20090b0d,0x2486024b}},	//   _vệ_, acen, _saai_, _whom_,
   {{0xa3e80e04,0x63a90ff1,0xb7bd002d,0x20090ff2}},	//   _बाप_, bcen, _soţi, _paai_,
   {{0x23660d4b,0xd30801a5,0x63a9027a,0x44cc01c0}},	//   _txoj_, _tệ_, ccen, mě_,
   {{0x62980ff3,0x69c50ff4,0x998300ee,0x00000000}},	//   _tivo, yahe, _mojš_, --,
   {{0x61460248,0xfc3f0037,0x2009053e,0x657a0ff5}},	//   _célé, _slí_, _waai_, _kyth,
   {{0x69c50006,0x44cc01c0,0xbd680ff6,0x614600f7}},	//   vahe, ně_, ерте_, _délé,
   {{0x9f5200de,0x3f15034b,0x69c50ff7,0xb17b011d}},	//   _cayó_, _адис, wahe, _מטור,
   {{0x69c50ff8,0x3a75021d,0x657a016e,0x614600fd}},	// [9b0] tahe, влар, _lyth, _félé,
   {{0xddc70129,0x99670ff9,0xbbeb00bf,0x61460118}},	//   bojš, нтел, _کردم_, _gélé,
   {{0x7a3205ee,0x69c50ffa,0xe61f01a5,0x996704d9}},	//   _rætt, rahe, _đô_, хтал,
   {{0xb9090ac4,0x7a320ffb,0x44cc000c,0x69c50ffc}},	//   _मम_, _sætt, dě_, sahe,
   {{0xd90f00f5,0xab840ffd,0x00000000,0x00000000}},	//   _گیا_, _бурк, --, --,
   {{0x7aed006c,0x657a0ffe,0x6495031d,0xa3b30fff}},	//   mtat, _byth, _všim, जुन_,
   {{0xd90f00f5,0x657a00e5,0xd4691000,0x00000000}},	//   _دیا_, _cyth, мике_, --,
   {{0x6d581001,0x64950009,0x7aed027a,0x00000000}},	//   _žvak, _išik, otat, --,
   {{0x657a008e,0x7a3208c8,0x64951002,0x7c2f1003}},	//   _eyth, _tætt, _ušim, _mocr,
   {{0x7aed1004,0x7c2f1005,0x248d0edf,0x44cc0355}},	//   itat, _locr, smem_, bě_,
   {{0x7aed01f4,0xa06a1006,0x63a9017b,0x76411007}},	//   htat, дана_, pcen, _illy,
   {{0x614600a2,0x7c2f0118,0x75f31008,0x00000000}},	//   _sélé, _nocr, sızı, --,
   {{0xe28e1009,0x09cc0033,0x00000000,0x00000000}},	//   _ва_, র্টা, --, --,
   {{0xc0a801ca,0x82d6100a,0x7aed100b,0x64950207}},	//   بایل_, _יונג_, dtat, _ošik,
   {{0x1fb6100c,0x7aed09f3,0x217502b5,0xdca60814}},	//   _испр, etat, _בײַם_, таби,
   {{0x442f100d,0xe8df0019,0x7aed100e,0xbc630212}},	//   _jog_, _nhựa_, ftat, авск,
   {{0x442f100f,0x61461010,0x7aed1011,0x160104bc}},	// [9c0] _mog_, _télé, gtat, लजार_,
   {{0x442f0122,0x4a431012,0xd5e0045c,0xa01b01ff}},	//   _log_, анув, _नाइज, smöt,
   {{0x2dd902b5,0x4dd902b5,0x442f0136,0x7769002a}},	//   _אַרב, _אַרױ, _oog_, _axex,
   {{0x44cc000c,0x76411013,0x657a00f7,0x6f160d14}},	//   vě_, _ally, _ryth, _kryc,
   {{0x7aed1014,0xb8651015,0x657a1016,0x4af900af}},	//   ctat, دالو, _syth, _пэря_,
   {{0x09cc0083,0x44cc01c0,0x64950506,0x442f0211}},	//   র্জা, tě_, _ušij, _aog_,
   {{0x442f1017,0x046608f1,0x7769002a,0x7f4a00a8}},	//   _bog_, ктим, _exex, _əfqa,
   {{0x442f0189,0x6f160176,0x7a320a8a,0x00000000}},	//   _cog_, _oryc, _tæts, --,
   {{0x657a0297,0x42740132,0x65c61018,0x442f00a5}},	//   _wyth, лгис, _абза, _dog_,
   {{0x44cc0355,0x442f1019,0x657a03d0,0x00000000}},	//   pě_, _eog_, _tyth, --,
   {{0x442f006c,0x7aed101a,0x320a01ba,0x3a3700a5}},	//   _fog_, ztat, ľby_, דרים_,
   {{0x320a086d,0x7658000e,0xe53702b5,0x6f16101b}},	//   žby_, livy, _שטאט_, _bryc,
   {{0x6442101c,0xdb0d101d,0xdd3b0139,0x6f160090}},	//   _iloi, mbaç, _băşt, _cryc,
   {{0x442f01a9,0x7c2f101e,0x6f16101f,0xdd3b0139}},	//   _zog_, _socr, _dryc, _căşt,
   {{0x442f1020,0x16df00c0,0x6442012f,0x7c2f00c5}},	//   _yog_, _नम्ब, _kloi, _pocr,
   {{0x7aed1021,0x3d0800a1,0x46d21022,0x09cb0099}},	//   ttat, हिजे_, _सिंह, ाण्य,
   {{0x5b151023,0x7aed002d,0xc4c400b5,0x4c9400c3}},	// [9d0] ымат, utat, _ڈے_, ритс,
   {{0x7aed1024,0x1db7021a,0x3eda0070,0x9f590138}},	//   rtat, _अभित, _אַטא, nesí_,
   {{0x7aed1025,0xda7807b0,0xdd911026,0x6f161027}},	//   stat, тят_, _دود_, _zryc,
   {{0x7aed1028,0xdb1d01ef,0x00000000,0x00000000}},	//   ptat, _hesí, --, --,
   {{0x442f1029,0x442101a5,0xdcfe00ea,0x00000000}},	//   _rog_, _đh_, _izpā, --,
   {{0x644203ad,0x69dd02cb,0x6d5800d8,0x442f102a}},	//   _aloi, _पाटी, _žvai, _sog_,
   {{0x442f102b,0x6442102c,0xdb1d0138,0xb7bd00af}},	//   _pog_, _bloi, _mesí, _soţu,
   {{0x442f0221,0x6442102d,0x13090263,0xe80b0461}},	//   _qog_, _cloi, ений_, _सोचा_,
   {{0x628a0082,0x97ea01d6,0x442f102e,0x26cd011c}},	//   _bhfo, ıştı, _vog_, _uveo_,
   {{0x42250439,0xa3df04bc,0x442f102f,0xa3e800b4}},	//   удов, _ताक_, _wog_, _बाथ_,
   {{0x442f1030,0xa2cf0f39,0xa2d80066,0x56940183}},	//   _tog_, _दिक्, _मिथ्, _тафт,
   {{0x64421031,0x6f161032,0x68fb00f4,0x00000000}},	//   _gloi, _pryc, _ćudl, --,
   {{0xa3e81033,0x63bb1034,0x60da01e4,0xba3b1035}},	//   _बात_, mbun, artm, _ruïn,
   {{0xa2d80127,0xfce61036,0x63bb1037,0x7e7501a3}},	//   _मित्, лого, lbun, gozp,
   {{0xdb1d00b8,0x9d430d46,0x27200067,0x00000000}},	//   _desí, берд, _मप्र_, --,
   {{0x6e3c1038,0x6f161039,0x2a78008b,0x409500d8}},	//   skrb, _tryc, _skrb_, _крыт,
   {{0x63bb02c9,0xc0530122,0x3a310097,0x3b86005f}},	// [9e0] ibun, _לזה_, _bozp_, улаг,
   {{0x200200d1,0x01d50033,0x00000000,0x00000000}},	//   leki_, ত্রদ, --, --,
   {{0x291e103a,0x46c600b4,0x38cb103b,0x00000000}},	//   _štab_, रीनह, فانی_, --,
   {{0x2002103c,0x6495007a,0xdb1d021d,0x8176016b}},	//   neki_, _eġiz, _desâ, אגעס_,
   {{0xa2cf0325,0x601b00c3,0x00000000,0x00000000}},	//   _दिग्, _hämä, --, --,
   {{0x644204e6,0x7bc601f4,0x2002103d,0xa5f8103e}},	//   _sloi, _heku, heki_, теку_,
   {{0xa3e8103f,0x7bc60464,0x6442002d,0x765802d0}},	//   _बाद_, _keku, _ploi, rivy,
   {{0x76581040,0xb50902e4,0x63bb1041,0x20021042}},	//   sivy, विजय_, gbun, jeki_,
   {{0x38550021,0xc1ea01c8,0x200201d6,0x05240083}},	//   _търс, ньне_, deki_, বনের_,
   {{0x7bc61043,0x64a600d4,0x27e61044,0x69c8018d}},	//   _leku, _бажа, lgon_, _õded,
   {{0xdb1d0279,0x601b0328,0x00000000,0x00000000}},	//   _resí, _nämä, --, --,
   {{0x7bc61045,0x27e61046,0x20021047,0x6485063d}},	//   _neku, ngon_, geki_, lóin,
   {{0xa85700a5,0x63a21048,0x27e600e2,0x00000000}},	//   ריכה_, _igon, igon_, --,
   {{0x539b0100,0x291801a6,0xc6940070,0xdb1d0279}},	//   _ניגו, _orra_, יאָ_, _lesã,
   {{0xdb1d01dd,0x7bc601e9,0x7e750e7d,0x20021049}},	//   _vesí, _beku, rozp, beki_,
   {{0x200201d6,0x6aa60db6,0xade904aa,0x7a32008c}},	//   ceki_, _bukf, ञ्जन_, _sætp,
   {{0x2918006c,0x63a20054,0x7bc6104a,0xba550836}},	// [9f0] _arra_, _mgon, _deku, авај,
   {{0x05e0018d,0x2b4b00e2,0x00000000,0x00000000}},	//   _नागब, _đhcđ_, --, --,
   {{0x6485104b,0x63bb0067,0x3eb90228,0x63a2104c}},	//   dóin, ybun, lpst_, _ogon,
   {{0x7bc60a81,0x63a2104d,0x68fc022e,0x27e601cb}},	//   _geku, _ngon, _dprd, ggon_,
   {{0x2918104e,0x7c2d104f,0x68fc00fe,0x61f808b7}},	//   _erra_, mjar, _eprd, _obvl,
   {{0x63a21050,0x20021051,0xd00e0083,0xe7361052}},	//   _agon, zeki_, ষায়_, реш_,
   {{0x7bc60095,0xce380122,0x63a20159,0x63bb01bf}},	//   _yeku, ראות_, _bgon, tbun,
   {{0x7afd011e,0xd3f9010b,0x00000000,0x00000000}},	//   _kpst, тэкі_, --, --,
   {{0x63bb0408,0x69c70858,0xc2451053,0xa3b407b5}},	//   rbun, _keje, иник, झड़_,
   {{0x69c71054,0xdb041055,0x63a206a2,0xab5b0176}},	//   _jeje, nciá, _egon, _reül,
   {{0x21691056,0x7c2d1057,0xafdb01b4,0x69c71058}},	//   тини_, kjar, dkøb, _meje,
   {{0x7afd1059,0x6603105a,0x69c7105b,0x2056105c}},	//   _opst, lenk, _leje, ртор,
   {{0x387e105d,0x443f0e7d,0x7c2d105e,0x442d105f}},	//   _être_, mku_, djar, mje_,
   {{0x442d0fd5,0x64491060,0x443f1061,0x69c701c0}},	//   lje_, lhei, lku_, _neje,
   {{0x7afd0080,0x7c2d0093,0xdd921062,0x64a30009}},	//   _apst, fjar, زور_, _eđiv,
   {{0x442d02dd,0x443f0a4e,0x64491063,0x44f101a5}},	//   nje_, nku_, nhei, _mơ_,
   {{0x69c70332,0x207b02b5,0x443f1064,0x68fc012e}},	// [a00] _beje, _באקא, iku_, _sprd,
   {{0xba231065,0x442d1066,0x601b03ad,0x443f1067}},	//   одук, hje_, _tämä, hku_,
   {{0x442d0044,0x443f1068,0x7bc61069,0x64490626}},	//   kje_, kku_, _teku, khei,
   {{0x1ae60d36,0x443f011c,0xf09302b5,0x64490120}},	//   _комм, jku_, ַנג_, jhei,
   {{0x442d106a,0x443f0f86,0x27e6106b,0x6449106c}},	//   dje_, dku_, rgon_, dhei,
   {{0x6603106d,0x443f0029,0x442d004e,0x44f10023}},	//   genk, eku_, eje_, _bơ_,
   {{0x44f100e8,0x443f0393,0x7ae4106e,0x6449004f}},	//   _cơ_, fku_, luit, fhei,
   {{0x442d106f,0x64491070,0x62810033,0x443f1071}},	//   gje_, ghei, ello, gku_,
   {{0x66031072,0x23380086,0xdc370070,0x32661073}},	//   benk, уппы_, שאפט_, итов,
   {{0x442d1074,0xe617002d,0xe5a3002d,0x660300d5}},	//   aje_, _кду_, _дифи, cenk,
   {{0x443f0736,0x85060148,0x442d008b,0x644900f1}},	//   bku_, _خوان, bje_, bhei,
   {{0x442d0755,0x443f1075,0x38661076,0x64491077}},	//   cje_, cku_, nnor_, chei,
   {{0x7c2d0024,0x38660159,0x7ae41078,0x62810031}},	//   vjar, inor_, juit, bllo,
   {{0x7ae41079,0x30a6107a,0x66fa0228,0x6e950ef3}},	//   duit, _крив, mākā, сигу,
   {{0x8bc7107b,0x7c2d107c,0x69c7107d,0x44f10023}},	//   исад, tjar, _reje, _xơ_,
   {{0xe5170bc1,0x69c7107e,0x6603107f,0x64401080}},	//   थिति_, _seje, zenk, nkmi,
   {{0x7ae41081,0x7c2d1082,0xdb0f1083,0x66031084}},	// [a10] guit, rjar, _recó, yenk,
   {{0x442d1085,0x443f1086,0x7c2d1087,0x656d00a8}},	//   zje_, zku_, sjar, şahi,
   {{0x69c71088,0x442d00d8,0x64490173,0x9f4b0132}},	//   _veje, yje_, yhei, pecó_,
   {{0x3ea90464,0x7ae41089,0x38660382,0x6603018e}},	//   _kuat_, buit, gnor_, wenk,
   {{0x443f0097,0x66030aeb,0x44f100e8,0x442d108a}},	//   vku_, tenk, _sơ_, vje_,
   {{0x3ea9108b,0x64a50c88,0xba4500b5,0x2fc90719}},	//   _muat_, бака, _انسٹ, _leag_,
   {{0x442d108c,0x6449108d,0x3ea90043,0x38660009}},	//   tje_, thei, _luat_, bnor_,
   {{0xa2d8046c,0x6603108e,0x442d00d8,0x443f108f}},	//   _मिश्, senk, uje_, uku_,
   {{0x64491090,0xa3e81033,0x66030882,0x3ea90176}},	//   rhei, _बार_, penk, _nuat_,
   {{0x442d1091,0xa2d80953,0x64491092,0x44f10019}},	//   sje_, _मिर्, shei, _tơ_,
   {{0x2fc91093,0x442d1094,0x3f861095,0x846701d3}},	//   _beag_, pje_, _šou_, _къде,
   {{0x3ea91096,0x64401097,0x442d01f4,0x00000000}},	//   _buat_, ckmi, qje_, --,
   {{0x02a70ff6,0x1474004f,0x9e660037,0x6f0d026b}},	//   _трем, _بالج, ماسن, _csac,
   {{0xa3b3009a,0x3866002a,0x6d4e033b,0xed5a1098}},	//   जुर_, znor_, tzba, гог_,
   {{0x50b51099,0x386601a2,0x27ed109a,0xc2120122}},	//   _услу, ynor_, _ocen_, _זהו_,
   {{0x7ae4109b,0xb603053d,0x68e5011e,0xdb0f01f7}},	//   tuit, _hráč, duhd, _recò,
   {{0xab270e8b,0x6fbe0026,0x9ce80033,0xb6030097}},	// [a20] бота_, _व्यू, খবেন_, _kráč,
   {{0x27ed109c,0x78a0109d,0x239b00c7,0x3205109e}},	//   _acen_, _simv, mąjį_, nely_,
   {{0x7ae4109f,0xa3e800b1,0xb60300ac,0x645902a2}},	//   suit, _बाल_, _mráč, _omwi,
   {{0xa2d8000c,0x320500b5,0x2012021e,0x317a016b}},	//   _मिल्, hely_, _jayi_, ארעמ,
   {{0x386610a0,0x78bb0f44,0x201210a1,0x320500a5}},	//   rnor_, _čuve, _mayi_, kely_,
   {{0x3205007e,0x645910a2,0xdb1d08c8,0x27ed0055}},	//   jely_, _amwi, _besæ, _ecen_,
   {{0x78a00019,0x186a0274,0x320510a3,0xaa4710a4}},	//   _timv, _бави_, dely_, _упра_,
   {{0xe8e001a5,0x66fa00ea,0xa2b40923,0xfbdf016e}},	//   _chụp_, tākā, обич, _llên_,
   {{0x6440008a,0x661100c3,0x32050f00,0x00000000}},	//   rkmi, ökkä, fely_, --,
   {{0x6440007c,0x66fa00ea,0xc50a0fab,0xd6cf0037}},	//   skmi, rākā, _متصل_, _أقل_,
   {{0x53160148,0x20121034,0x09d50033,0xb60300d5}},	//   _گذار, _bayi_, স্কা, _dráč,
   {{0x6f0d06bc,0x3ea90118,0xfe7f01f7,0xa2e6010b}},	//   _psac, _puat_, duïa_, _годд,
   {{0x32050355,0x3ea900cc,0x28af0354,0x649510a5}},	//   bely_, _quat_, _जूनि, _všit,
   {{0x6d1410a6,0xfbdf099e,0x320510a7,0x00000000}},	//   डिंग_, _clên_, cely_, --,
   {{0x64a30506,0x60b404cd,0x20120027,0x463b016b}},	//   _uđit, _بمبئ, _fayi_, נעלע,
   {{0x0ca8014d,0x649500ac,0xb7bd0160,0x00000000}},	//   стри_, _ušit, _onţa, --,
   {{0x6a350274,0x765a026a,0x09d20831,0x2baa021a}},	// [a30] онађ, _omty, ালনা, _कलरा,
   {{0x27ed10a8,0x6aad0031,0xfe7f0176,0xfbdf099e}},	//   _scen_, rqaf, buïa_, _glên_,
   {{0x20120088,0xa3e80d2a,0x27ed008c,0x00000000}},	//   _yayi_, बला_, _pcen_, --,
   {{0xac1910a9,0xb90110aa,0xf99010ab,0xc0b200e2}},	//   _тому_, _दि_, ربل_, _sưởi_,
   {{0xd6db10ac,0xb06600c3,0x68e500c3,0x1dbf05f7}},	//   уте_, ltää, suhd, ्रपत,
   {{0xf77010ad,0x1a94010b,0x00000000,0x00000000}},	//   ران_, _наяў, --, --,
   {{0x32050122,0x91fc0029,0xb0660086,0x27ed0036}},	//   vely_, rnāl, ntää, _tcen_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x320510ae,0x201210af,0x52a610b0,0xe7330d93}},	//   tely_, _rayi_, овым_, _عصر_,
   {{0xa2bf0324,0x229200ce,0x201210b1,0x225e01ed}},	//   लीग्, وليس, _sayi_, gitk_,
   {{0x69d80370,0x386d108a,0x320500a5,0x7d0202c4}},	//   óvei, _kjer_, rely_, _ćoso,
   {{0xdb1d03ad,0x64590010,0x60dc10b2,0xef1a0421}},	//   _kesä, _umwi, árma, амм_,
   {{0x6e370069,0x32050187,0x2d8510b3,0x44f30183}},	//   _boxb, pely_, ülen_, lã_,
   {{0xdca610b4,0xe8df00cc,0xa01b10b5,0x15ed021a}},	//   жави, _chừa_, llöl, च्चर_,
   {{0xdfd2006c,0x2d8c02df,0x201210b6,0x6da30610}},	//   _ہيں_, åde_, _tayi_, дира,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xe7ff10b7,0xd0420095,0xa09b016b,0x49ca10b8}},	// [a40] ोजना_, xslə, _דיקט, илан_,
   {{0x25fb00c0,0x387f10b9,0x5e57004f,0x386d06dd}},	//   ल्मी_, _akur_, _وليس_, _ajer_,
   {{0x291c10ba,0xda1b0084,0x57a60763,0xe7aa10bb}},	//   íva_, _नफरत_, ошла, авел_,
   {{0xdb1d0ef0,0xa3e800b4,0xfe7f01f7,0x25b4022e}},	//   _besä, _बाइ_, nuïn_, ुर्ण,
   {{0x7c2610bc,0x386d00e0,0x00000000,0x00000000}},	//   _inkr, _djer_, --, --,
   {{0x386d01b4,0x963300d8,0xc4da0274,0x6b8b10bd}},	//   _ejer_, мніц, ађи_, ügge,
   {{0x3af40282,0x344a10be,0x867500d8,0xdb070093}},	//   läp_, ичин_, чыцц, élög,
   {{0x9cd70122,0x386d0044,0x7e7c10bf,0x66e60f88}},	//   קופה_, _gjer_, horp, _моба,
   {{0x213e001e,0xdb1d10c0,0x7e7c10c1,0x166601d3}},	//   wyth_, _gesä, korp, _двам,
   {{0x7af601c8,0x51860036,0xb06600c3,0x44f3021d}},	//   ityt, жума, ytää, bã_,
   {{0x7c2610c2,0x6e3710c3,0x7e7c01bf,0x00000000}},	//   _onkr, _roxb, dorp, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdefb00c7,0x09d50083,0x7e7c10c4,0x442610c5}},	//   шын_, স্টা, forp, _ino_,
   {{0x442610c6,0x3f850080,0x7e7c0065,0xb06600c3}},	//   _hno_, ālu_, gorp, ttää,
   {{0xa3de00e7,0x25b900a8,0x91bb00a5,0x00000000}},	//   _तया_, _əsl_, _דמוי, --,
   {{0xa3b300b4,0x8cdc0127,0x1bbb0079,0x00000000}},	//   _ज्ञ_, _फिरो, شارع_, --,
   {{0xe8df01a5,0x442610c7,0xb0660086,0xdce70644}},	// [a50] _thừa_, _mno_, stää, ğlıd,
   {{0x09e30083,0x7c2602c6,0x7e7c0720,0x539b00a5}},	//   ন্না, _enkr, corp, שימו,
   {{0x442610c8,0x386d10c9,0x3a3803c4,0x99910355}},	//   _ono_, _pjer_, _dorp_, _vozů_,
   {{0x442601a8,0x3a380211,0xdb1d0421,0x00000000}},	//   _nno_, _eorp_, _pesä, --,
   {{0x2b520035,0x58bb00fd,0xab840d6e,0x00000000}},	//   czyc_, _چارج_, _журк, --,
   {{0x442610ca,0xd126004f,0x3a380051,0x44f30183}},	//   _ano_, _كم_, _gorp_, tã_,
   {{0xe5a2021d,0x386d0055,0x442610cb,0x044510cc}},	//   ниши, _tjer_, _bno_, зейн,
   {{0x387f10cd,0x4426009e,0x44f30132,0x290302a7}},	//   _ukur_, _cno_, rã_, _ipja_,
   {{0x27ff10ce,0x6ed70066,0x28af0387,0x00000000}},	//   _ibun_, _बिगु, _जूति, --,
   {{0x442610cf,0x64aa007e,0x00000000,0x00000000}},	//   _eno_, _břid, --, --,
   {{0x7e7c10d0,0xf8cb046c,0x00000000,0x00000000}},	//   vorp, ाठिय, --, --,
   {{0x44d70043,0xe8df0019,0xbbaa04cc,0x5baa00b4}},	//   mă_, _chứa_, _कलेक, _कलेव,
   {{0x7d1e10d1,0x644b10d2,0x44d70012,0x09e30083}},	//   _srps, _ilgi, lă_, ন্যা,
   {{0x629d01c0,0x2911012f,0x00000000,0x00000000}},	//   ůsob, _osza_, --, --,
   {{0x44d70012,0x4426001e,0x00000000,0x00000000}},	//   nă_, _yno_, --, --,
   {{0x09e30083,0x7e7c10d3,0xc7a500fd,0x00000000}},	//   ন্মা, sorp, _لڑ_, --,
   {{0xeb9710d4,0x78bb0a78,0xe9da10d5,0x7af610d6}},	// [a60] зит_, _čuva, йка_, utyt,
   {{0x3af4017b,0x6f040176,0x00000000,0x00000000}},	//   räp_, _ipic, --, --,
   {{0xe8fa10d7,0x7af610d8,0x644b10d9,0x44d700af}},	//   сле_, styt, _olgi, jă_,
   {{0xfaa610da,0xa3ea0246,0x44d7002d,0xafdb10db}},	//   _намо, _टाइप_, dă_, lhør,
   {{0xdd8f0118,0xf74310dc,0x3a3810dd,0x00000000}},	//   _لوی_, нецо, _torp_, --,
   {{0x644b10de,0x44260523,0x27ff0118,0x7ae410df}},	//   _algi, _sno_, _ebun_, mrit,
   {{0x44260159,0x44d7002d,0x7ae410e0,0x69ce035f}},	//   _pno_, gă_, lrit, _iebe,
   {{0xb6030080,0x68e30f56,0x6f040a69,0x69ce10e1}},	//   ēšan, ánde, _opic, _hebe,
   {{0x69ce0464,0x7ae410e2,0x66e310e3,0x442610e4}},	//   _kebe, nrit, _пота, _vno_,
   {{0x69ce10e5,0x64aa000c,0x644b10e6,0x200010e7}},	//   _jebe, _přid, _elgi, _abii_,
   {{0x44d70012,0x7ae402c9,0x55bb0122,0x442610e8}},	//   că_, hrit, _המבו, _tno_,
   {{0x442610e9,0x69ce10ea,0x7d1c10eb,0x69dc03d0}},	//   _uno_, _lebe, dvrs, _ldre,
   {{0x69dc10ec,0xddc502c4,0xa85700a5,0x69ce0118}},	//   _odre, _ajhš, ליטה_, _oebe,
   {{0xbeed0e1d,0x69ce10ed,0x8cb10378,0x626610ee}},	//   _जमीन_, _nebe, _आंदो, _عاشق,
   {{0x6f0410ef,0x7ae40006,0xd7cc00a1,0x09e30033}},	//   _epic, erit, ाराच, ন্ডা,
   {{0x7ae410f0,0x69ce01d7,0xdb0d10f1,0x3cfe07b5}},	//   frit, _aebe, scaí, _लहरे_,
   {{0x69ce10f2,0x44d70012,0x6fc30534,0x91fc00ea}},	// [a70] _bebe, ză_, _व्यं, ciāc,
   {{0x19ab03e6,0x200b10f3,0x69ce10f4,0x00000000}},	//   стап_, leci_, _cebe, --,
   {{0x69ce10f5,0x394710f6,0xdb1d10f7,0x7ae410f8}},	//   _debe, áns_, _jesú, arit,
   {{0xa3e8017a,0x44d7002d,0x9cd600a5,0x200b10f9}},	//   _बाग_, vă_, _קורה_, neci_,
   {{0x69ce10fa,0x7bdd0176,0x00000000,0x00000000}},	//   _febe, _idsu, --, --,
   {{0x69ce10fb,0x1dbf0864,0x44d70012,0xcb12011d}},	//   _gebe, ्रित, tă_, _שלם_,
   {{0x7bcf0464,0x78a2024e,0xdb1d01ba,0x00000000}},	//   _kecu, ňova, _nesú, --,
   {{0x200b0c21,0x44d70012,0x69ce10fc,0x27ff012f}},	//   jeci_, ră_, _zebe, _ubun_,
   {{0x44d70043,0x1dbf00a1,0x7bcf09ba,0x200b10fd}},	//   să_, ्रात, _mecu, deci_,
   {{0xe0d910fe,0x44d7002d,0x69ce013b,0xbbaa0af9}},	//   ово_, pă_, _xebe, _कल्क,
   {{0x69c501a6,0x7ae401ba,0x200b10ff,0x00000000}},	//   ibhe, zrit, feci_, --,
   {{0x7bcf002d,0xdb1d0176,0x7ae400c3,0x6aa702a2}},	//   _necu, _desú, yrit, _lijf,
   {{0xdb040098,0x998300c7,0x00000000,0x00000000}},	//   sciú, _kojų_, --, --,
   {{0x09e30083,0x7ae41100,0x01650214,0x6f0400d5}},	//   ন্তা, vrit, _окло, _vpic,
   {{0x7bcf1101,0xbea31102,0x69ce1103,0x7d05008c}},	//   _becu, тарк, _rebe, _cphs,
   {{0x69ce1104,0xd9f00006,0xdd8f07f6,0x7bcf0395}},	//   _sebe, _चाहत_, شوق_, _cecu,
   {{0x78ae1105,0x7bcf09ce,0xfeba03fc,0x7bc4004b}},	// [a80] _subv, _decu, _بابت_, rbiu,
   {{0x7ae41106,0xe8df01a5,0x6aa70120,0xff5f0248}},	//   rrit, _chữa_, _cijf, raît_,
   {{0x69ce1107,0xfbc61108,0x2d961109,0xdb1d01dd}},	//   _vebe, _обно, _юрис, _xesú,
   {{0xab2a110a,0x313600c2,0xa3c302e4,0x7ae4110b}},	//   _дома_, ונעם_, ्रफ_, prit,
   {{0x09e30083,0x69ce110c,0xe737110d,0x6283110e}},	//   ন্ধা, _tebe, мец_, _okno,
   {{0x659400af,0x69dc110f,0x200b1110,0x66840088}},	//   налу, _udre, zeci_, ریال,
   {{0xdb060b3e,0x69350355,0x00000000,0x00000000}},	//   _afkø, _přeš, --, --,
   {{0x64aa00b8,0xdb1d1111,0x09e30033,0xd7060274}},	//   _přib, _resú, ন্দা, _озби,
   {{0x41e61112,0x200b0160,0x25fb007c,0x64aa0355}},	//   міна, veci_, ल्ही_, _břic,
   {{0xd25000bf,0xd626017e,0x63ab0159,0xf5e7002d}},	//   اند_, _تعري, _eggn, _омул_,
   {{0x200b1113,0xa01b00c3,0x629a0282,0x63b90090}},	//   teci_, llöi, rmto, _ffwn,
   {{0xc32a004f,0xa3e8051d,0xd5b100e2,0x00000000}},	//   _وكان_, _बाट_, _tác_, --,
   {{0xa2d80299,0x7bcf1114,0x200b1115,0x41bf035d}},	//   _मिट्, _recu, reci_, _श्वस,
   {{0x200b05e2,0x7bcf1116,0x00000000,0x00000000}},	//   seci_, _secu, --, --,
   {{0x38b7048c,0x320c1117,0x6d550036,0x3a2d1118}},	//   _oħra_, medy_, uzza, _đep_,
   {{0xa3c31119,0x28d8111a,0x00000000,0x00000000}},	//   ्रय_, _डिजि, --, --,
   {{0x7bcf0029,0x7b670166,0xa3b3111b,0xfe6e00fd}},	// [a90] _vecu, фтве, जुट_, شگی_,
   {{0x1600021a,0x00000000,0x00000000,0x00000000}},	//   ल्मर_, --, --, --,
   {{0xa3c305f7,0x69c5111c,0x1bd5111d,0x7bcf0395}},	//   ्रम_, rbhe, _поня, _tecu,
   {{0x2aad023a,0x6aa70223,0x00000000,0x00000000}},	//   _ažbe_, _wijf, --, --,
   {{0x7d020b16,0x320c016f,0xa3e8111e,0x7c3d111f}},	//   _ćosi, kedy_, _बाज_, _iosr,
   {{0x2451033a,0x7aed1120,0x46e000ab,0x00000000}},	//   _máme_, muat, _निरह, --,
   {{0x7aed1121,0x7c3d1122,0x2451063c,0x00000000}},	//   luat, _kosr, _láme_, --,
   {{0xdb1d1123,0xe7f9000c,0xe8cb00a1,0x00000000}},	//   _besø, _एउटा_, ाठीच, --,
   {{0x64aa00b8,0x7c3d1124,0x25a900d1,0x3f89034d}},	//   _přic, _mosr, _فضای_, _nyau_,
   {{0x291e010b,0x320c0147,0x00000000,0x00000000}},	//   _štai_, gedy_, --, --,
   {{0x7aed1125,0x7c3d0345,0x00000000,0x00000000}},	//   huat, _oosr, --, --,
   {{0x7aed0f1a,0x1b060033,0x78a9005f,0x4375027a}},	//   kuat, রিতে_, _jiev, _пулт,
   {{0xe80102cb,0x7aed0831,0x23291126,0x6449033b}},	//   ळ्या_, juat, _холи_, mkei,
   {{0x443d0052,0x78a91127,0x644900c3,0x7aed1128}},	//   _how_, _liev, lkei, duat,
   {{0x7c961129,0x443d112a,0xda02112b,0x7c3d0223}},	//   ерац, _kow_, र्फत_, _bosr,
   {{0x7aed0657,0x628101d7,0x78a9112c,0x6449112d}},	//   fuat, lolo, _niev, nkei,
   {{0xfe720332,0x3b070133,0x7aed112e,0xadee00a1}},	// [aa0] _مدد_, нето_, guat, _जाऊन_,
   {{0x6281112f,0x443d0122,0x9b93004f,0x64491130}},	//   nolo, _low_, الكت, hkei,
   {{0x64491131,0xd94300af,0xeabf0211,0x64850079}},	//   kkei, лефи, _crùb_, nóis,
   {{0x443d0052,0x7aed1132,0x38600014,0x78a900a0}},	//   _now_, buat, òir_, _ciev,
   {{0x78a91133,0x7aed1134,0x91fc0029,0x3f89006d}},	//   _diev, cuat, onāt, _xyau_,
   {{0x25fb0fd1,0x62811135,0x443d1136,0x00000000}},	//   ल्ली_, jolo, _aow_, --,
   {{0x291e008d,0x7c3d02c2,0x3eb20b88,0x443d062c}},	//   _éta_, _yosr, _luyt_, _bow_,
   {{0x644902bf,0x18a3081b,0x98a310ac,0x78a9011e}},	//   gkei, _басм, _бисе, _giev,
   {{0x62811137,0x0edc0243,0x68e101ff,0x57cc00a9}},	//   folo, _बिगड, _åldr, ारीह,
   {{0x62811138,0x7bd61139,0x78a9005f,0x24510168}},	//   golo, hayu, _ziev, _ráme_,
   {{0x7bd6113a,0x320c07c0,0x00000000,0x00000000}},	//   kayu, redy_, --, --,
   {{0x44fa071f,0xa3c30355,0xd2500105,0x64490110}},	//   më_, ्रण_, انگ_, ckei,
   {{0x661a113b,0x44fa00da,0xc43b0122,0x320c113c}},	//   _katk, lë_, _מתאי, pedy_,
   {{0x661a03ad,0x7c3d05ca,0x3866113d,0x443d0051}},	//   _jatk, _sosr, hior_, _zow_,
   {{0x44fa071f,0x661a113e,0x7c3d02dd,0xfd10006c}},	//   në_, _matk, _posr, یجہ_,
   {{0x7bd6113f,0x661a1140,0x24860069,0xdc88002d}},	//   gayu, _latk, _jkom_, есул_,
   {{0x44fa01f4,0x38660051,0x78a91141,0xeab30037}},	// [ab0] hë_, dior_, _riev, اعر_,
   {{0x78a90080,0x44fa00da,0xda781142,0x7aed1143}},	//   _siev, kë_, нях_, ruat,
   {{0xdd911144,0x78a90ae0,0x44fa01d2,0x7aed0f1a}},	//   _خود_, _piev, jë_, suat,
   {{0x6485004f,0x7aed0453,0x44fa0031,0x7e670051}},	//   hóir, puat, dë_, lijp,
   {{0x44fa053e,0x62811145,0xdb0700c3,0x443d024b}},	//   eë_, yolo, ämäs, _row_,
   {{0x443d1146,0x62811147,0xa50900c9,0xcf940070}},	//   _sow_, xolo, дека_, נטס_,
   {{0x443d1148,0x6485004f,0x44fa00da,0x69d70282}},	//   _pow_, dóir, gë_, maxe,
   {{0x38661149,0x6281114a,0xed640097,0x00000000}},	//   cior_, wolo, loží_, --,
   {{0x6449114b,0x661a01f4,0xf7730037,0x248600e0}},	//   rkei, _fatk, _صار_, _dkom_,
   {{0x69d7043f,0x6485004f,0x6449114c,0x07080088}},	//   naxe, góir, skei, _سيمي_,
   {{0x201b046a,0x7bd601a2,0xa3c30380,0x44fa0031}},	//   _baqi_, yayu, ्रद_, cë_,
   {{0x2004114d,0xa3d2114e,0x6281114f,0x3f6a1150}},	//   ými_, वरण_, solo, димо_,
   {{0x62811151,0x249f1152,0x661a1008,0x60da1153}},	//   polo, mmum_, _yatk, astm,
   {{0x248d1154,0x63bb01d3,0xfce600aa,0x9f6100b5}},	//   llem_, lcun, кого, ását_,
   {{0x7bd61155,0xfc3f0392,0xfd79027a,0x8d631156}},	//   tayu, _boí_, естъ_, авре,
   {{0x63bb1157,0x3ce500b5,0x2cab0051,0x960e00b4}},	//   ncun, álva_, _cicd_, _िस्ट_,
   {{0xdca31158,0xcb671159,0xa3d202e4,0x44fa01f4}},	// [ac0] рати, вате_, वरत_, zë_,
   {{0x7bd603be,0xbea60112,0x6fa70461,0x248d115a}},	//   sayu, _шапк, _गणतं, hlem_,
   {{0xa3c300e7,0x661a0086,0x7bd6115b,0x249f1051}},	//   ्रा_, _ratk, payu, kmum_,
   {{0x5ee90066,0x44fa01f4,0xb90a115c,0x248d0009}},	//   _जिम्_, vë_, _मि_, jlem_,
   {{0x3866115d,0x248d115e,0x69ca008a,0x2ca000ab}},	//   rior_, dlem_, ðfes, mmid_,
   {{0x44fa071f,0x2486115f,0x2ca000be,0xe7370274}},	//   të_, _skom_, lmid_, тељ_,
   {{0x81d70083,0x386601ff,0x64aa007e,0x00000000}},	//   িলা_, pior_, _dřin, --,
   {{0x44fa071f,0x29181160,0x661a1161,0x4394005f}},	//   rë_, _isra_, _watk, лайс,
   {{0x44fa071f,0x661a1162,0x6d47004e,0x6485004f}},	//   së_, _tatk, zyja, tóir,
   {{0x91fc0080,0xae041163,0xd05d0095,0x60c41164}},	//   ciāl, श्मन_, əyəc, _čimb,
   {{0xb6a300af,0x6485004f,0x67221165,0x44fa0031}},	//   _тифл, róir, lvoj, që_,
   {{0xdb041166,0x64850037,0x60da1167,0x855400b5}},	//   nció, sóir, rstm, _لیڈر_,
   {{0xf09f0310,0x73361168,0xdb040300,0x657a009e}},	//   rmà_, _جرائ, ició, _hxth,
   {{0x52d70122,0x2ca000ab,0xc6940070,0x33260168}},	//   _יודע_, emid_, טאָ_, _irox_,
   {{0x4fc71169,0xdb04006c,0x2918021d,0x201b0c6f}},	//   _испа, kció, _nsra_, _taqi_,
   {{0x09cb0fcf,0x57cc0761,0x30a400d8,0x3f8500a8}},	//   िर्य, ारोह, _крыв, ğlub_,
   {{0x69d7116a,0x3a75116b,0x6e450037,0x245100fe}},	// [ad0] taxe, глар, _منظم, _jáma_,
   {{0x68e3116c,0x6722116d,0x99d51062,0x2ca0116e}},	//   ándo, dvoj, اقات, amid_,
   {{0x69d7116f,0xa3d208b0,0x248d0edf,0x8af000a8}},	//   raxe, वरा_, ylem_, lzəl,
   {{0x69d70391,0x69ca008a,0xa01b00a6,0x00000000}},	//   saxe, ðfer, mlös, --,
   {{0x7c2f1170,0xa3c3045c,0x64aa01c0,0xa01b1171}},	//   _incr, ्रस_, _přin, llös,
   {{0xe29a00e8,0xdb0409ab,0x45191172,0xf3f900af}},	//   _như_, ació, еция_, miţi_,
   {{0xa8a70d46,0x91fc0080,0xa01b1173,0x58d41174}},	//   _арак, riāl, nlös, _вост,
   {{0xdb041175,0x69d51176,0x33260024,0x00000000}},	//   cció, _heze, _brox_, --,
   {{0x248d1177,0x69d5006c,0xf3f900af,0xa3e401c0}},	//   rlem_, _keze, niţi_, _भएर_,
   {{0x69d51178,0x63bb1179,0xa3c305f7,0x24510097}},	//   _jeze, scun, ्रह_, _dáma_,
   {{0x10a6117a,0x69d5117b,0x248d117c,0xe0d600af}},	//   лион, _meze, plem_, лвэ_,
   {{0xcea90779,0x69d50a75,0xf99202b8,0xdd410103}},	//   _זי_, _leze, מרי_, _eŋŋe,
   {{0x442f0796,0xe28e117d,0x26df02c4,0x16000084}},	//   _ing_, _га_, _jvuo_, ल्वर_,
   {{0xa01b01ae,0x7c2f117e,0x00000000,0x00000000}},	//   flös, _ancr, --, --,
   {{0x6722117f,0x1d071180,0xed5a1181,0x2d8c054e}},	//   zvoj, лери_, хов_, æde_,
   {{0x09cd0083,0xfe7f0310,0xaab500b4,0x63ad021d}},	//   _লাগা, duïu_, _अंशक, _ºand,
   {{0x69d51182,0x2ca000be,0x705301b2,0x442f1183}},	// [ae0] _beze, rmid_, _دنيا, _mng_,
   {{0x442f00a7,0x57cc012f,0x2ca01184,0x00000000}},	//   _lng_, ार्ह, smid_, --,
   {{0x442f0b04,0x69d51185,0x9d460fc5,0xdb1d1186}},	//   _ong_, _deze, _сенд, _besó,
   {{0x442f1187,0x3e6d00d5,0x00000000,0x00000000}},	//   _nng_, ržte_, --, --,
   {{0xdb040caa,0xdb1d02d7,0x69d50183,0x764100fd}},	//   rció, _desó, _feze, _boly,
   {{0x442f1188,0x69d51189,0x6722118a,0x20d1118b}},	//   _ang_, _geze, rvoj, kši_,
   {{0xdb0409ab,0x6722118c,0x20d1108a,0x442f118d}},	//   pció, svoj, jši_, _bng_,
   {{0x69d501d7,0x44de003c,0x3326118e,0x6d5c00ec}},	//   _zeze, rċ_, _prox_, izra,
   {{0x76410332,0x32540043,0x78a2118f,0x69d51190}},	//   _foly, ивир, mmov, _yeze,
   {{0x78a20936,0x76410297,0xda140035,0xdb040042}},	//   lmov, _goly, ड़ित_, nciñ,
   {{0xd48f1191,0x2d8c0035,0x6244009e,0x741300d1}},	//   _гр_, żdej_, _bòor, _گونا,
   {{0xd0e506bc,0x78a20300,0x442f08dd,0xb4c20a64}},	//   _किरण_, nmov, _gng_, ्ठी_,
   {{0xe29a0028,0xdd250029,0x9f5902d7,0x75280168}},	//   _thư_, dīša, vesó_, _hrdz,
   {{0x98bc01c0,0x64421192,0x78a20725,0xa01b1193}},	//   ávě_, _hooi, hmov, tlös,
   {{0x442f02c7,0x78a202c6,0x644202a2,0xeabf01da}},	//   _yng_, kmov, _kooi, _crùn_,
   {{0x78a200cd,0xa01b1173,0x78b502c4,0xda020066}},	//   jmov, rlös, _ruzv, र्सत_,
   {{0xa01b0ed4,0x64420244,0x909810ad,0x69d501d7}},	// [af0] slös, _mooi, _حضور_, _peze,
   {{0xdb1d0310,0xf3f9002d,0xa01b01ff,0x9f40033b}},	//   _besò, riţi_, plös, _heiß_,
   {{0x69d51194,0x9851004e,0x39151195,0x76410a2d}},	//   _veze, nąć_, рмер, _roly,
   {{0x64420d26,0x69d51196,0x76411197,0xc9050d12}},	//   _nooi, _weze, _soly, _रहीम_,
   {{0x7bda1198,0x442f00ee,0xf6e71199,0x1707042c}},	//   _בקרו, _rng_, уцен, افتی_,
   {{0x7aed119a,0x7bcd119b,0x6d480508,0x78a200ac}},	//   mrat, lbau, ädag, amov,
   {{0xe3b10514,0x7a4100b8,0x7641119c,0x64420051}},	//   يرة_, _vítě, _voly, _booi,
   {{0x20d101cc,0x7bcd119d,0x7aed119e,0x130900d4}},	//   vši_, nbau, orat, вний_,
   {{0x6442053e,0x7aed119f,0x442f11a0,0x764111a1}},	//   _dooi, nrat, _vng_, _toly,
   {{0x248001cc,0x6aae01e8,0xdd250029,0x7aed11a2}},	//   čima_, _xibf, zīša, irat,
   {{0x290111a3,0x27e00093,0x7aed0168,0xdddc011c}},	//   ntha_, ðing_, hrat, jorš,
   {{0x442f11a4,0x672911a5,0x20d111a6,0x644201e4}},	//   _ung_, _krej, rši_, _gooi,
   {{0x99980116,0x00000000,0x00000000,0x00000000}},	//   _morš_, --, --, --,
   {{0x21a50009,0x20d1030a,0x78a20097,0x8cb10035}},	//   _килм, pši_, zmov, _आंखो,
   {{0xada61109,0xdb1200fb,0x7aed016f,0x6da611a7}},	//   равл, _ágús, erat, рива,
   {{0x3b00007a,0x6729112c,0x7bcd11a8,0x32050a8a}},	//   ttiq_, _orej, gbau, lfly_,
   {{0x7aed11a9,0x2d850ab6,0xfe7f0443,0xdd2500ea}},	// [b00] grat, üler_, tuït_, rīša,
   {{0x09e611aa,0x8d7600fd,0x00000000,0x00000000}},	//   рожн, _ناجا, --, --,
   {{0x2901004f,0xe8fa11ab,0x7aed0382,0xaa7b01c0}},	//   gtha_, тле_, arat, _svýc,
   {{0x672911ac,0x64aa0355,0x00000000,0x00000000}},	//   _brej, _přim, --, --,
   {{0x78a2024e,0x2bd30378,0x29010094,0x644211ad}},	//   rmov, तररा, atha_, _rooi,
   {{0x6729071f,0x29010079,0x644211ae,0x245800a2}},	//   _drej, btha_, _sooi, _méme_,
   {{0xa3c300e7,0x25080164,0xb4c200b4,0x29010037}},	//   ्रं_, ارتی_, ्ठे_, ctha_,
   {{0x672911af,0x32050f00,0x249d0090,0x00000000}},	//   _frej, efly_, _chwm_, --,
   {{0x672911b0,0xd1ca11b1,0xa2b300c3,0x32050312}},	//   _grej, кунд_, обыч, ffly_,
   {{0x166311b2,0x6f0d01da,0x64aa007e,0x00000000}},	//   _двум, _rpac, _křik, --,
   {{0x7aed00ee,0x6f0d11b3,0x672901ba,0x91a90023}},	//   zrat, _spac, _zrej, _đã_,
   {{0xa3c31140,0x7aed11b4,0xdd30007e,0x00000000}},	//   ्रः_, yrat, _běžt, --,
   {{0xfe7f0392,0x00000000,0x00000000,0x00000000}},	//   duïr_, --, --, --,
   {{0x7aed0ba8,0x9f4002c9,0x2d8401d6,0x69d8008a}},	//   vrat, _weiß_, ğmen_, ðvel,
   {{0x7aed0024,0x25fb11b5,0x228b0185,0xb7bd0139}},	//   wrat, ल्टी_, røkt_, _haţe,
   {{0x7aed11b6,0x00000000,0x00000000,0x00000000}},	//   trat, --, --, --,
   {{0x7bcd11b7,0x6f0d0452,0x64aa01c0,0x7aed11b8}},	// [b10] rbau, _upac, _přij, urat,
   {{0xe9ab09b9,0x6288001e,0xab8411b9,0x7aed11ba}},	//   ندان_, nodo, цуск, rrat,
   {{0x628801ef,0x672902c4,0x7aed11bb,0x39470395}},	//   iodo, _srej, srat, âns_,
   {{0x62880252,0x672911bc,0x7aed11bd,0x290111be}},	//   hodo, _prej, prat, rtha_,
   {{0x290111bf,0x07090698,0xfe04021a,0xf77011c0}},	//   stha_, ايتي_, श्वस_, واه_,
   {{0xb60711c1,0xdd280029,0x6288012f,0x29010037}},	//   рядк, lēša, jodo, ptha_,
   {{0x628811c2,0xd46911c3,0xa3d2012f,0x48ab005f}},	//   dodo, лике_, वरं_, _атам_,
   {{0x672911c4,0xdd280029,0x00000000,0x00000000}},	//   _trej, nēša, --, --,
   {{0x6288001e,0x672902c6,0x9f4404d4,0xd5b100cc}},	//   fodo, _urej, ümü_, _lái_,
   {{0x8b5800a5,0x00000000,0x00000000,0x00000000}},	//   ייחס_, --, --, --,
   {{0xf5950082,0x0086036c,0x00000000,0x00000000}},	//   _الاج, йлоо, --, --,
   {{0x205611c5,0x237d0221,0x7ae211c6,0xb7bd0160}},	//   стор, _txwj_, šoti, _faţe,
   {{0x628811c7,0x443f11c8,0x645b04e6,0xdd2800ea}},	//   bodo, mju_, mhui, dēša,
   {{0xb6cc0644,0x741300b5,0x645b11c9,0x00000000}},	//   _şükü, _دوچا, lhui, --,
   {{0xed5711ca,0x443f00d8,0xdd9205bc,0xafdb11cb}},	//   бор_, oju_, سور_, rkør,
   {{0x645b0120,0x78a311cc,0x245800a0,0xd5b10023}},	//   nhui, ïnvl, _téme_, _cái_,
   {{0x8c4311cd,0xbbb80099,0x09e6002d,0x645b0298}},	// [b20] чете, _अलीक, йоан, ihui,
   {{0x443f007c,0x64aa00b8,0xe9d711ce,0xda6511cf}},	//   hju_, _přik, йку_, يالي,
   {{0x645b0fdb,0x443f008d,0x090611d0,0x08fa0ae7}},	//   khui, kju_, спен, طراب_,
   {{0x443f11d1,0xb8eb006c,0xdd2800ea,0xc7a600af}},	//   jju_, ابلے_, cēša, биек,
   {{0x443f11d2,0xf3ff0083,0x645b11d3,0x7c2411d4}},	//   dju_, ্যার_, dhui, mdir,
   {{0x7c2411d5,0x443f11d6,0x89f500d8,0x645b0130}},	//   ldir, eju_, _мясц, ehui,
   {{0x628811d7,0x69de11d8,0x645b11d9,0x6d4e11da}},	//   vodo, mape, fhui, nyba,
   {{0x7c2411db,0x24800528,0x6288004e,0xa3a900b1}},	//   ndir, čimo_, wodo, _गृह_,
   {{0x35fa036b,0x98a300af,0x00000000,0x00000000}},	//   _مراد_, _хите, --, --,
   {{0x69de11dc,0x443f11dd,0xdd2800ea,0x00000000}},	//   nape, aju_, zēša, --,
   {{0x628811de,0x443f11df,0x7c24037a,0x00000000}},	//   rodo, bju_, kdir, --,
   {{0x628811e0,0x69de11e1,0x645b11e2,0x443f11e3}},	//   sodo, hape, chui, cju_,
   {{0x69de11e4,0x628811e5,0x7c2411e6,0x09e30083}},	//   kape, podo, ddir, ন্টা,
   {{0x3dd900c8,0xdce501ba,0x5eb80033,0x69de11e7}},	//   _তাহল, _vzhľ, _অবশে, jape,
   {{0x69de11e8,0x64aa000c,0xd12f0aeb,0x260008a9}},	//   dape, _přih, _эх_, _रानी_,
   {{0x7c2411e9,0x60c700b8,0xa17700a5,0x00000000}},	//   gdir, íjme, _לעוד_, --,
   {{0xdd280029,0x7d1e011e,0xeabf0023,0xf3fa0033}},	// [b30] rēša, _esps, _trùm_, _আসার_,
   {{0x443f0484,0x7b74004f,0x69de11ea,0x00000000}},	//   zju_, أطفا, gape, --,
   {{0x78bb0207,0x6d4e0027,0x00000000,0x00000000}},	//   _čuvs, cyba, --, --,
   {{0x19a811eb,0xaae20380,0x987c0355,0x00000000}},	//   ступ_, _पिचक, bíč_, --,
   {{0xe73911ec,0x443f11ed,0x4424012f,0x69de11ee}},	//   рел_, vju_, ddm_, bape,
   {{0xdb1d06d7,0x7bdf11ef,0x1b060033,0x69de11f0}},	//   _besö, laqu, রিখে_, cape,
   {{0xf53200c9,0x443f11f1,0x8459002d,0x645b11f2}},	//   дејќ, tju_, ирит_, thui,
   {{0x7bdf11f3,0x94790274,0x443f0e3c,0x00000000}},	//   naqu, јску_, uju_, --,
   {{0x443f11f4,0x645b02e6,0x727900af,0xa5f90274}},	//   rju_, rhui, исос_, _везу_,
   {{0x443f11f5,0x645b11f6,0xdd1c0187,0x7c2411f7}},	//   sju_, shui, váže, zdir,
   {{0x443f11f8,0x932702fd,0x7c2401fb,0xda0b021a}},	//   pju_, _گران, ydir, स्यत_,
   {{0x69de11f9,0x1faa031a,0xbbb804bc,0x00000000}},	//   zape, икни_, _अलेक, --,
   {{0x7bdf11fa,0x9327042c,0x7c2411fb,0x64590024}},	//   daqu, _دران, vdir, _ilwi,
   {{0xda0b0084,0x6d4e11fc,0xa3c30d34,0xdd1c031d}},	//   स्मत_, tyba, ्रक_, ráže,
   {{0xa3bd02cb,0x69de11fd,0x7bdf0031,0x7c240510}},	//   _आला_, vape, faqu, tdir,
   {{0x69de11fe,0x22470051,0x6d4e11ff,0x7c241200}},	//   wape, _honk_, ryba, udir,
   {{0xe9da1199,0x7c241201,0xf41202da,0x200501c2}},	// [b40] ика_, rdir, ופן_, əli_,
   {{0x2247053e,0x7c241202,0xee0a00af,0x49960d6e}},	//   _jonk_, sdir, _теол_, ошет,
   {{0x69de1203,0x6da60525,0x8c461204,0xdd0f01d6}},	//   rape, _фина, _дене, mışt,
   {{0xdd0f01d6,0x7c2400a8,0x9f480023,0x394701ff}},	//   lışt, qdir, _điêu_, änsa_,
   {{0xcfbc0033,0x64aa0355,0xfaa61205,0x60c402a7}},	//   _অজান, _křiv, _мамо, _čimm,
   {{0x7ae40037,0x64590069,0xdd0f0225,0xf4ea0421}},	//   msit, _alwi, nışt, афий_,
   {{0xd90d0164,0x7ae41206,0x81cf0083,0x69dc1207}},	//   _میل_, lsit, ষণা_, _iere,
   {{0x7bc41208,0x7ae41209,0x245800fe,0x4adf021a}},	//   nciu, osit, _béma_, _पौडव,
   {{0x69dc042c,0x7ae4120a,0x22470159,0x7bc4010b}},	//   _kere, nsit, _bonk_, iciu,
   {{0x69dc120b,0x7ae4120c,0x24510037,0x4424012f}},	//   _jere, isit, _lámh_, sdm_,
   {{0x69dc120d,0xd2570a93,0x224702e9,0x7bdf120e}},	//   _mere, іць_, _donk_, yaqu,
   {{0x69dc120f,0xe0cf064e,0x7bdf014c,0x66181210}},	//   _lere, کزی_, xaqu, levk,
   {{0x69dc008c,0x7ae400f4,0x78bc03c1,0x20050067}},	//   _oere, jsit, _lurv, ęli_,
   {{0x248901ba,0x76480359,0x5bd302b4,0xbbd30b35}},	//   čame_, _jody, तर्व, तर्क,
   {{0x7bdf0248,0x16d702e4,0x7ae41211,0xec6b1212}},	//   taqu, _डब्ब, esit, арак_,
   {{0x69dc01d3,0x67200c21,0x3ced068b,0xa0680836}},	//   _aere, _osmj, čev_, _маја_,
   {{0x20191213,0x7bdf1214,0x7ae4010d,0xb60601ba}},	// [b50] mesi_, raqu, gsit, _kráľ,
   {{0x20191215,0x66180bde,0x69dc1216,0x7bc4027a}},	//   lesi_, jevk, _cere, aciu,
   {{0x69dc1217,0x7bdf0300,0xfe7000bc,0x48151218}},	//   _dere, paqu, _جدي_, змес,
   {{0x765a1219,0x2019121a,0x7ae4121b,0xb17b02b5}},	//   _alty, nesi_, bsit, סטאר,
   {{0x2ca90e89,0x69dc121c,0x27e0008a,0xf770042c}},	//   mmad_, _fere, ðina_, پان_,
   {{0x69dc121d,0x7bdd121e,0x2019121f,0x2ca900ab}},	//   _gere, _hesu, hesi_, lmad_,
   {{0x69c51220,0x7bdd1221,0x6e250024,0x20191222}},	//   mche, _kesu, _mahb, kesi_,
   {{0x7bdd1223,0x69c50b84,0x20191224,0x68e31225}},	//   _jesu, lche, jesi_, ándu,
   {{0x2bdc0302,0x69dc1226,0x76d500ad,0x20191227}},	//   बरता, _yere, _رياض, desi_,
   {{0x7bdd1228,0x69c51229,0x69dc122a,0x09af0083}},	//   _lesu, nche, _xere, _চ্যা,
   {{0x69c5122b,0x2019122c,0x387f02c4,0x69d80093}},	//   iche, fesi_, _kjur_, ðvei,
   {{0x2458122d,0x7bdd122e,0x2019122f,0x7ae41230}},	//   _téma_, _nesu, gesi_, ysit,
   {{0x24511231,0x64aa00b8,0x248d012f,0x91cc0b35}},	//   _námi_, _přiv, moem_, _द्वै,
   {{0x69c51232,0x6e25009e,0x248d01bf,0x2ca900be}},	//   jche, _cahb, loem_, emad_,
   {{0x61e103ad,0x69dc1233,0x7bdd1234,0x6abd02c9}},	//   mall, _rere, _besu, _ausf,
   {{0x7ae41235,0x61e11236,0x20191237,0x8c431238}},	//   tsit, lall, cesi_, несе,
   {{0x7bdd054e,0x7bc4006c,0x78bc1239,0x2d9e0187}},	// [b60] _desu, rciu, _surv, ťte_,
   {{0x7bc4123a,0x61e1123b,0x78bc123c,0x386d123d}},	//   sciu, nall, _purv, _amer_,
   {{0x7ae4123e,0x764800d8,0xda020d91,0x7bdd123f}},	//   ssit, _rody, र्गत_, _fesu,
   {{0x61e11240,0x69dc1241,0x7bdd1242,0x7ae41243}},	//   hall, _were, _gesu, psit,
   {{0x61e1052a,0x387f013c,0x69c51244,0x76481245}},	//   kall, _djur_, bche, _pody,
   {{0x78bc1246,0x61e11247,0x7bdd0103,0x69c501d3}},	//   _turv, jall, _zesu, cche,
   {{0x20c100e8,0x7bdd1248,0x20191249,0xfaa3124a}},	//   _nói_, _yesu, yesi_, _чаро,
   {{0x066601df,0x7bdd0042,0x6d4100c3,0x32c00107}},	//   _کارپ, _xesu, älai, _pòy_,
   {{0x6618124b,0x61e1124c,0x6720124d,0x00000000}},	//   pevk, fall, _usmj, --,
   {{0x61e1124e,0x2019124f,0x20c10019,0x3f850225}},	//   gall, wesi_, _bói_, şluk_,
   {{0x6e251250,0x20191251,0xcfe10083,0x60cd011c}},	//   _rahb, tesi_, _ভাবন, _čamc,
   {{0xe3a70332,0xb6060187,0x3dd90033,0x20c10132}},	//   _کشمی, _dráž, _তাইল, _dói_,
   {{0x61e11252,0x20191253,0xaa7b00b8,0x00000000}},	//   ball, resi_, _svým, --,
   {{0x44260657,0x7bdd124f,0x61e10122,0x8ca20026}},	//   _hao_, _sesu, call, _कीबो,
   {{0x44261254,0x20c101a5,0x7bdd1255,0x20191256}},	//   _kao_, _gói_, _pesu, pesi_,
   {{0x7c261257,0x44261258,0x20190031,0x3a380160}},	//   _cakr, _jao_, qesi_, _anrp_,
   {{0xd6d70b52,0x44260430,0x69c51259,0x2ca9125a}},	// [b70] _সম্প, _mao_, tche, rmad_,
   {{0x4426125b,0x27e000fb,0x69c5125c,0x386d125d}},	//   _lao_, ðinn_, uche, _smer_,
   {{0x69c50599,0x29190ca8,0x7bdd125e,0xfaa80037}},	//   rche, تقاد_, _tesu, أهلي_,
   {{0x69c5125f,0x44261260,0xd12604cd,0x7bdd00e7}},	//   sche, _nao_, _یم_, _uesu,
   {{0x69c51261,0x61e1045e,0x79950067,0x00000000}},	//   pche, yall, _wyzw, --,
   {{0x7c26088d,0x61e11262,0xf1ba0023,0x660d00cd}},	//   _zakr, xall, _ngơ_, đako,
   {{0x61e11263,0x44260028,0x7c3a0079,0x00000000}},	//   vall, _bao_, _úcrá, --,
   {{0x442600e8,0x61e11264,0x2458000d,0x20c11265}},	//   _cao_, wall, _démo_, _rói_,
   {{0x44261266,0x27ed1267,0x20c10019,0x3b0900a8}},	//   _dao_, _iden_, _sói_, ntaq_,
   {{0x81bc00ea,0x25a00355,0x44261268,0x00000000}},	//   ldēj, řila_, _eao_, --,
   {{0x26cd1269,0x61e1126a,0x64aa00b8,0x3555126b}},	//   _hteo_, rall, _přit, _تناز,
   {{0x61e1126c,0xd36e00bf,0x20e700cd,0x387d016e}},	//   sall, اهی_, rđi_, nnwr_,
   {{0x61e1126d,0xe28e126e,0x7c26126f,0x00000000}},	//   pall, _аа_, _rakr, --,
   {{0x44260657,0x6da604b2,0x13e20083,0x61e10be2}},	//   _zao_, дига, _যায়, qall,
   {{0x44260657,0x7c261270,0x644b01ef,0x27ed0523}},	//   _yao_, _pakr, _kogi, _oden_,
   {{0x44260023,0x8af000a8,0x27ed027d,0x26cd00cd}},	//   _xao_, yyəd, _nden_, _oteo_,
   {{0x1e860948,0x644b1271,0xeb971272,0x7c260185}},	// [b80] _олим, _mogi, дит_, _vakr,
   {{0x7c260054,0x63bc0355,0xcf9300a5,0x00000000}},	//   _wakr, ěrni, _בטח_, --,
   {{0x7c261273,0xa80601c8,0x26cd0159,0xa3bd00a1}},	//   _takr, дзел, _ateo_, _आलं_,
   {{0x644b1274,0xd7ef0037,0x27ed008c,0x00000000}},	//   _nogi, لكم_, _cden_, --,
   {{0x44260028,0x47360037,0xdb1d08c8,0x245100fe}},	//   _rao_, براز, _afsæ, _jámu_,
   {{0x44261275,0x27ed1276,0xdd1d0333,0xd0270033}},	//   _sao_, _eden_, lášt, যায়_,
   {{0x44261277,0x644b1278,0x245100ee,0x00000000}},	//   _pao_, _bogi, _lámu_, --,
   {{0xe9a31279,0x644b127a,0xfc3f00e2,0x7af60067}},	//   _расп, _cogi, _khía_, oryt,
   {{0x4426127b,0x84ea0c57,0xd7030382,0xd5cf0d60}},	//   _vao_, _टिकट_, _изти, _स्वज,
   {{0x44260657,0x64aa01c0,0x24890254,0x65790037}},	//   _wao_, _přis, čama_, ábhá,
   {{0xd48f0012,0x4426127c,0x09f70052,0xb42300fd}},	//   _ар_, _tao_, ומים_, رٹیو,
   {{0xdbd6127d,0x644b00e5,0x44260176,0x00000000}},	//   _jääd, _gogi, _uao_, --,
   {{0xfe730125,0x00000000,0x00000000,0x00000000}},	//   ندس_, --, --, --,
   {{0x245100d5,0x63a2127e,0x6a600282,0x00000000}},	//   _dámu_, _izon, _löfb, --,
   {{0xdd9401c8,0x2d850381,0xdc140448,0x00000000}},	//   вары, çle_, _ağız, --,
   {{0x7af601f4,0xaa7b0187,0x7bd60298,0x00000000}},	//   fryt, _zvýh, gbyu, --,
   {{0x5a3502fb,0x5b150677,0xf09400a5,0x7af6127f}},	// [b90] ннат, эмат, _בנק_, gryt,
   {{0x3b090024,0x00000000,0x00000000,0x00000000}},	//   rtaq_, --, --, --,
   {{0x80e00033,0x3b091280,0x00000000,0x00000000}},	//   পূর্, staq_, --, --,
   {{0x7af61281,0xc19b00a5,0x00000000,0x00000000}},	//   bryt, חשבי, --, --,
   {{0x6d5500b5,0xa3c21282,0x629a0009,0x387d016e}},	//   lyza, ंशन_, klto, rnwr_,
   {{0xe5a51283,0x629a0051,0x00000000,0x00000000}},	//   нили, jlto, --, --,
   {{0x63a20332,0x644b1284,0x04b51285,0x4adb021a}},	//   _azon, _pogi, нсия, मीरव,
   {{0x03251286,0x27ed0022,0x63a2035f,0xc3250432}},	//   един, _uden_, _bzon, емик,
   {{0xe6100e3a,0x64aa00b8,0x200c00b5,0x662800c3}},	//   _چشم_, _přir, ődik_, öskä,
   {{0x63a21287,0x64b100ea,0x60c701ba,0x00000000}},	//   _dzon, _jāiz, íjmo, --,
   {{0x9f4201cb,0x644b1288,0x63a21289,0x00000000}},	//   maké_, _togi, _ezon, --,
   {{0xe7300332,0x2cb90211,0x2004128a,0x00000000}},	//   _حصہ_, _nisd_, ümi_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2cb90211,0x60c40116,0x00000000,0x00000000}},	//   _aisd_, _čimv, --, --,
   {{0x40960525,0xdd92128b,0x9f420118,0x00000000}},	//   _прит, اوز_, iaké_, --,
   {{0xfc3f01a5,0x6aa80246,0x9f4200d1,0x7af60f31}},	//   _phía_, कग्र, haké_, tryt,
   {{0x9f4201ca,0x7bd6010d,0xc2cc016b,0x00000000}},	// [ba0] kaké_, rbyu, ַמאָ, --,
   {{0x9f42024e,0xcfb70122,0xdbd60086,0x7af6128c}},	//   jaké_, _אלפי_, _sääd, rryt,
   {{0x69a5021a,0x8d76128d,0xdbd61130,0x9f4201cb}},	//   _करणी, _سادا, _pääd, daké_,
   {{0x27e0128e,0x2002128f,0xe3a7036b,0xfc3f00e2}},	//   úin_, ngki_, _مر_, _thía_,
   {{0x81d60033,0x9f4201cb,0x00000000,0x00000000}},	//   িণত_, faké_, --, --,
   {{0x9f4201cb,0x00000000,0x00000000,0x00000000}},	//   gaké_, --, --, --,
   {{0xa9a30009,0xe9a30036,0x6593005f,0x22990118}},	//   _бирд, _барп, лашу, cèki_,
   {{0x62830009,0x25a000b8,0x3eba1290,0x69a51291}},	//   _ajno, řilo_, _lipt_, _करती,
   {{0x087702b5,0x68fe005f,0xb5fc007a,0x27e61292}},	//   _נעמט_, lupd, _alġe, maon_,
   {{0x325405c2,0x27e61293,0x3eba0051,0x9f4200e0}},	//   твор, laon_, _nipt_, caké_,
   {{0xf0e71294,0xd5a40a44,0x2d9a03d0,0x00000000}},	//   ньяк_, _ओरिज, _nype_, --,
   {{0x27e61295,0x62830009,0x25a1033b,0x20b4010b}},	//   naon_, _ejno, ühle_, лёўс,
   {{0xf1d100b8,0x3ce30099,0x2cb90027,0x63a2007b}},	//   _द्वन, टीने_, _risd_, _uzon,
   {{0x27e6043d,0xfc3f0019,0x6d550035,0x611400d8}},	//   haon_, _chín_, tyza, _адку,
   {{0x321e0e7d,0x27e61296,0x7e751297,0x00000000}},	//   mety_, kaon_, rizp, --,
   {{0x6d55004e,0x321e1298,0xc5e60033,0x00000000}},	//   ryza, lety_, নলিপ, --,
   {{0x200c0095,0x00000000,0x00000000,0x00000000}},	// [bb0] ədi_, --, --, --,
   {{0x321e1299,0x06cf0831,0x00000000,0x00000000}},	//   nety_, _রিলি, --, --,
   {{0xa3e00722,0xa3c2129a,0xfe7f0176,0x00000000}},	//   थरा_, ्डा_, duïx_, --,
   {{0x99980009,0xab5b0183,0x69d8008d,0x80a70067}},	//   _forž_, _agüe, ðver, _टीमे,
   {{0x321e024e,0x7c2d129b,0x58b8004f,0x99980009}},	//   kety_, mdar, رامج_, _gorž_,
   {{0x7c2d129c,0xe73607e5,0xf1b2022e,0x00000000}},	//   ldar, теш_, ुखान, --,
   {{0x64aa000c,0x27e6129d,0x60cd02c4,0xc984129e}},	//   _přip, baon_, _čamo, _бути,
   {{0x2489129f,0x3d190067,0x00000000,0x00000000}},	//   čamo_, _पहने_, --, --,
   {{0x9f4200d1,0x321e0122,0xd5bb0546,0x130600c3}},	//   paké_, fety_, _есе_, вный_,
   {{0xa77412a0,0x7c2d12a1,0x78aa00a0,0x68e108c8}},	//   _случ, hdar, čovň, _ælds,
   {{0x320b004e,0x216912a2,0x7c2d12a3,0x33260044}},	//   ęcy_, фини_, kdar, _esox_,
   {{0x7c2d12a4,0x2056081b,0x2bd30099,0x00000000}},	//   jdar, ттор, धुमा, --,
   {{0xf8b200c2,0x7c2d12a5,0x442d08d7,0xe81300a1}},	//   ישט_, ddar, mde_, ण्या_,
   {{0x7c3d03d0,0x2d9a0b88,0x00000000,0x00000000}},	//   _ansr, _pype_, --, --,
   {{0x1d0705c7,0x442d12a6,0x67220035,0xfc3f01ef}},	//   кери_, ode_, zwoj, _chío_,
   {{0x7c2d0dc3,0x61e312a7,0x644912a8,0x645b00c3}},	//   gdar, _henl, njei, nkui,
   {{0xc0530122,0xe9d2026e,0x628112a9,0x61e300cc}},	// [bc0] _כזה_, لغا_, onlo, _kenl,
   {{0x442d0086,0x7c2d12aa,0x628100d4,0x7c3d0a8a}},	//   hde_, adar, nnlo, _ensr,
   {{0x27e60d0d,0x442d053d,0x7c2d12ab,0xbf9b0279}},	//   taon_, kde_, bdar, ngên,
   {{0x442d12ac,0x38600082,0x321e12ad,0x61e30159}},	//   jde_, óir_, zety_, _lenl,
   {{0x442d12ae,0xe1e70148,0x2ee002e9,0xf11e051d}},	//   dde_, _پس_, _jwif_, _बन्द_,
   {{0x442d12af,0x27e61296,0x443d0051,0x645b0b88}},	//   ede_, saon_, _anw_, ekui,
   {{0x442d12b0,0x321e00d5,0x29180009,0xa80612b1}},	//   fde_, vety_, _upra_, _извл,
   {{0x442d12b2,0x78bb0139,0x6abb002a,0x443d00f6}},	//   gde_, _giuv, _éufr, _cnw_,
   {{0xd70712b3,0x68e1054e,0x799c001e,0x61e312b4}},	//   _инте_, _ældr, _hyrw, _benl,
   {{0x442d12b5,0x386600c9,0x7c2d12b6,0x443d0297}},	//   ade_, lhor_, zdar, _enw_,
   {{0x26c412b7,0x442d0249,0x321e12b8,0x7c2d0381}},	//   _humo_, bde_, rety_, ydar,
   {{0xf993035e,0x386603e6,0x68e312b9,0x61e312ba}},	//   ירת_, nhor_, ândi, _eenl,
   {{0x321e1298,0x61e3021e,0x69ce0093,0x7c2d12bb}},	//   pety_, _fenl, _ofbe, vdar,
   {{0xdce50038,0x61e312bc,0x27e4002d,0x26c4011e}},	//   _vyhľ, _genl, _lemn_, _mumo_,
   {{0xac1912bd,0x61e812be,0x7c2d12bf,0xa3e60084}},	//   нову_, madl, tdar, _बजा_,
   {{0xfbd30148,0x7c2d12c0,0x69ce0a75,0x660d022f}},	//   شتر_, udar, _afbe, đaki,
   {{0x386612c1,0x200901ef,0x00000000,0x00000000}},	// [bd0] dhor_, _icai_, --, --,
   {{0x442d12c2,0xf09f12c3,0x61e812c4,0x7c2d12c5}},	//   zde_, llà_, nadl, sdar,
   {{0x442d12c6,0x9f4e006c,0xb7bd0160,0xdbd100be}},	//   yde_, önöm_, _haţi, _küüd,
   {{0x248603fd,0x61e80008,0x7c3d12c7,0x26c4022f}},	//   _njom_, hadl, _unsr, _bumo_,
   {{0x442d070f,0x61e812c8,0x6abc03d0,0xdbd100ab}},	//   vde_, kadl, _firf, _müüd,
   {{0x442d12c9,0x7aed12ca,0x6a60008d,0x00000000}},	//   wde_, msat, _höfn, --,
   {{0x260900a1,0x442d12cb,0x26c401f7,0x27e40107}},	//   _साठी_, tde_, _eumo_, _femn_,
   {{0x628104e2,0x61e312cc,0x290112cd,0x26c412ce}},	//   wnlo, _senl, muha_, _fumo_,
   {{0x7aed12cf,0x387c00f7,0x645b12d0,0x3e66000d}},	//   nsat, èvre_, rkui, _hôte_,
   {{0x442d12d1,0xb7bd0043,0x645b12d2,0x61e80211}},	//   sde_, _naţi, skui, gadl,
   {{0x61e312d3,0x442d12d4,0x2901121e,0x26c412d5}},	//   _venl, pde_, nuha_, _zumo_,
   {{0x44e101c8,0xbf9b03e6,0x83350ca8,0x349403c6}},	//   mų_, rgên, _مرتض, _кахр,
   {{0x27e005ee,0x44e100d8,0xa3c20b35,0x09ca0033}},	//   ðini_, lų_, ्डर_, ষরতা,
   {{0x249f12d6,0x290112d7,0x7aed12d8,0x3f9e0029}},	//   llum_, kuha_, dsat, ātu_,
   {{0x44e101c8,0x7aed12d9,0xf09f0176,0x10f5010b}},	//   nų_, esat, blà_, _сяля,
   {{0xc00612da,0x290112db,0xa3e60299,0x6b9d016e}},	//   _спик, duha_, _बड़ा_, _bysg,
   {{0xfc3f0076,0xcb6712dc,0x7aed12dd,0x7fe912de}},	// [be0] _dní_, гате_, gsat, _شريف_,
   {{0xfeba064e,0x44e101c8,0x6b9d0297,0x26c40279}},	//   _ثابت_, kų_, _dysg, _rumo_,
   {{0x44e101c8,0x386612df,0x7aed12e0,0x3e660248}},	//   jų_, thor_, asat, _côte_,
   {{0x8c460b32,0x6abc12e1,0x44e1010b,0x7aed12e2}},	//   _семе, _wirf, dų_, bsat,
   {{0x09e800c8,0x7aed00fd,0xe73712e3,0x6b9d016e}},	//   _পাঠা, csat, лец_, _gysg,
   {{0x290112e4,0x2ca012e5,0x38660c6f,0x00000000}},	//   buha_, llid_, shor_, --,
   {{0x61e812e6,0x44e100d8,0x2ca0018d,0xa3c212e7}},	//   vadl, gų_, olid_, ्डल_,
   {{0x26090bc1,0x249f0093,0x545412e8,0x61e802b3}},	//   _साथी_, glum_, рвит, wadl,
   {{0x61e812e9,0x18670274,0x41e612ea,0x2ca0018d}},	//   tadl, _сати_, ліна, ilid_,
   {{0x471b0100,0xdbd1007c,0x44e1010b,0x171b0070}},	//   _אומג, _süüd, bų_, _אומע,
   {{0x3de212eb,0x2ca0007c,0x249f0118,0xdbd100ab}},	//   _বাংল, klid_, blum_, _püüd,
   {{0x7aed05ee,0xfc3f01a5,0x442012ec,0x61e812ed}},	//   ysat, _phím_, _úi_, sadl,
   {{0x543b00c2,0x61e80e6a,0x087702b5,0xf09f12ee}},	//   _רעדא, padl, רעכט_, rlà_,
   {{0x2ca012ef,0x6a60008d,0x00000000,0x00000000}},	//   elid_, _söfn, --, --,
   {{0xf09f0392,0x00000000,0x00000000,0x00000000}},	//   plà_, --, --, --,
   {{0x7aed12f0,0x2ca0007c,0x6b9d001e,0x00000000}},	//   tsat, glid_, _pysg, --,
   {{0x3a750de2,0x0ca800c3,0xb7bd0160,0x7aed0a63}},	// [bf0] алар, утри_, _taţi, usat,
   {{0x7aed03d0,0x290112f1,0x7ed4004f,0x2ca000be}},	//   rsat, tuha_, _ازيا, alid_,
   {{0x7aed12f2,0xc98412f3,0x47d512f4,0x667500d1}},	//   ssat, буци, ليار, یدتر,
   {{0x7aed12f5,0x290112f6,0x2ca012f7,0x2c2702ce}},	//   psat, ruha_, clid_, _сьог,
   {{0xf74512f8,0x290101a2,0x26000af6,0xd6db02fb}},	//   рело, suha_, _राखी_, хте_,
   {{0xa2c30e1d,0x44e101c8,0x09df0083,0x290112f9}},	//   रदस्, tų_, _ঢাকা, puha_,
   {{0x58d412fa,0xa8a712fb,0x249f12fc,0xdb1d0a8a}},	//   _гост, _брак, tlum_, _afsø,
   {{0x99840082,0x44e100d8,0x60c408b7,0x3ce80324}},	//   _الفو, rų_, _čimp, _जबसे_,
   {{0x76b9027a,0x09e80083,0xc8641012,0xd2650036}},	//   _алар_, _পাতা, _утри, икий,
   {{0x7c2f0af5,0xaa7b0187,0x249f0093,0x425512fd}},	//   _lacr, _zvýr, slum_, ртит,
   {{0xa06a12fe,0xc4f800ad,0xd6680312,0x249f027d}},	//   вана_, _معنا_, _حملو_, plum_,
   {{0xb4c10fd1,0x54a70e6b,0xcea902b8,0x7c2f01a0}},	//   ंदी_, _صحاف, _חי_, _nacr,
   {{0x442f12ff,0x00000000,0x00000000,0x00000000}},	//   _iag_, --, --, --,
   {{0x442f1300,0x3ebe07ed,0xa2d21301,0x00000000}},	//   _hag_, ött_, _بيوت, --,
   {{0x442f1302,0xfce61303,0x94ee013b,0xc27a0277}},	//   _kag_, робо, _bəə_, _שרצי,
   {{0x442f1304,0xbc6312a0,0xa3ac0e1d,0x2fdf008d}},	//   _jag_, овск, _गरम_, ðugt_,

   {{0x76411305,0xb4c102e4,0x91fc0029,0x6b850037}},	// [c00] _only, ंदु_, bkād, مشكل,
   {{0xe9d71306,0x442f1307,0x7ea0022a,0x4a431308}},	//   ику_, _lag_, köpi, онув,
   {{0x9d460970,0xa9261309,0x442f046d,0xdca607bc}},	//   _тенд, рдел, _oag_, _вани,
   {{0x442f130a,0x4907007c,0x6d5c130b,0x00000000}},	//   _nag_, _हमरो_, myra, --,
   {{0x7c24130c,0xd70710ac,0x28130af8,0x00000000}},	//   meir, инце_, تونس, --,
   {{0x7c24130d,0xb4c10785,0x80db0083,0x7c2f00cb}},	//   leir, ंदू_, _ভিন্, _zacr,
   {{0x3947022a,0xa3c1012f,0x442f130e,0x2bd307b5}},	//   änst_, ःखं_, _bag_, धुवा,
   {{0x7c24130f,0x442f1310,0x8af00095,0x2c6700be}},	//   neir, _cag_, yyəl, _tõde_,
   {{0x27e0008a,0xd5b10023,0x6d5c00e9,0x78a21311}},	//   ðinu_, _máy_, hyra, mlov,
   {{0x80ca0ca1,0x442f1312,0x7c241313,0x59aa0785}},	//   _संदे, _eag_, heir, _करार,
   {{0x3a370052,0x442f1314,0x51861315,0x6d5c0031}},	//   ברים_, _fag_, рупа, jyra,
   {{0x78a21316,0x7c241317,0x6d5c108c,0x1b1d0033}},	//   nlov, jeir, dyra, নিতে_,
   {{0x7c241318,0x44241319,0x236d004e,0x78a20187}},	//   deir, mem_, czej_, ilov,
   {{0x7c2f131a,0x442f131b,0xa2c3131c,0x78a20187}},	//   _sacr, _zag_, रदर्, hlov,
   {{0x442f131d,0x7c240297,0x78a200ac,0x6d5c131e}},	//   _yag_, feir, klov, gyra,
   {{0x4424131f,0x7c241320,0x245801ba,0x78a21321}},	//   nem_, geir, _tému_, jlov,
   {{0x78a2024e,0x44241322,0x80ca018d,0xf9c7111d}},	// [c10] dlov, iem_, _सूते, ащен,
   {{0x44241323,0x753a01b7,0x00000000,0x00000000}},	//   hem_, _ortz, --, --,
   {{0x44241324,0x7c240bc8,0x26000026,0x7c2f1325}},	//   kem_, beir, _राजी_, _tacr,
   {{0x7c241326,0x00000000,0x00000000,0x00000000}},	//   ceir, --, --, --,
   {{0x442f1327,0x753a01d7,0xfe701328,0x7d1e02a7}},	//   _rag_, _artz, _ردی_, _zpps,
   {{0x64420514,0x442f1329,0x00000000,0x00000000}},	//   _anoi, _sag_, --, --,
   {{0x442f132a,0xb4c100a1,0x4424132b,0x9608010b}},	//   _pag_, ंदे_, fem_, рэча_,
   {{0x4424132c,0x442f01e8,0xe3e9132d,0xe894010b}},	//   gem_, _qag_, اکان_, _дась,
   {{0x442f132e,0xe2990714,0xdbf40083,0x753a06a2}},	//   _vag_, лаи_, ঙ্কস_, _ertz,
   {{0x442f132f,0x7c2403e6,0x9f42031d,0x673b01b7}},	//   _wag_, zeir, jaká_, _iruj,
   {{0x442f1330,0x44241331,0x236d004e,0x291306a2}},	//   _tag_, bem_, szej_, ntxa_,
   {{0x44241332,0x442f1333,0x7c240bc8,0x673b0031}},	//   cem_, _uag_, xeir, _kruj,
   {{0x43741334,0x7c241335,0x7e7c1336,0x6d5c00e9}},	//   _мушт, veir, tirp, wyra,
   {{0xda03009a,0x6d5c1337,0x1d0a1338,0x78a21339}},	//   _लागत_, tyra, леги_, zlov,
   {{0x7c240bb0,0x78a2133a,0x3ce300b8,0x00000000}},	//   teir, ylov, टीले_, --,
   {{0x3fe6052c,0x673b0103,0x00000000,0x00000000}},	//   _ужив, _oruj, --, --,
   {{0x7c24133b,0x387d001e,0x64aa00b8,0x00000000}},	// [c20] reir, diwr_, _přiz, --,
   {{0x7c24133c,0x09e80083,0x00000000,0x00000000}},	//   seir, _পাহা, --, --,
   {{0x7d1e133d,0x78a20d5c,0x4424133e,0xed5a12e3}},	//   _upps, tlov, yem_, _сон_,
   {{0x4424133f,0x673b1340,0x16050006,0xb4c1052f}},	//   xem_, _bruj, _राउर_, ंदो_,
   {{0x44241341,0x78a21342,0x7bc6011e,0x673b0453}},	//   vem_, rlov, _igku, _cruj,
   {{0x78a20a0b,0x4424004e,0xd9460368,0x13e00b35}},	//   slov, wem_, _леги, नर्भ,
   {{0x26091343,0x7bc6011e,0x9ac3003c,0x00000000}},	//   _सारी_, _kgku, ċċes, --,
   {{0x44241344,0xddc500fe,0x00000000,0x00000000}},	//   uem_, _dohř, --, --,
   {{0xe73703ad,0x673b1345,0x53341346,0x66e31347}},	//   _лет_, _gruj, цепт, _нота,
   {{0x44241348,0x3d190755,0x6f061349,0x929d0067}},	//   sem_, _पहले_, dukc, tuła,
   {{0x4424134a,0x3a370122,0x1a9b02b5,0x753a01a3}},	//   pem_, זרים_, רייע, _urtz,
   {{0x5edd0083,0xc95300a5,0x9f4b000d,0x44240031}},	//   _বিবে, למת_, lacé_, qem_,
   {{0xa3bc134b,0xafdb03d0,0x987b016b,0xa3ac01c0}},	//   _आणि_, fjør, ראכט, _गरि_,
   {{0x63a2134c,0xafdb01e0,0x9f4001f7,0x92a40067}},	//   _iyon, gjør, _deià_, ółdz,
   {{0x865b134d,0xdd3a00af,0x00000000,0x00000000}},	//   נדלי, văţa, --, --,
   {{0x63a20273,0x4fc7002d,0x3a3100ee,0x00000000}},	//   _kyon, _уска, _sazp_, --,
   {{0xafdb082b,0x6288134e,0x26090914,0x61ea0093}},	// [c30] bjør, ondo, _साली_, _kefl,
   {{0x80db0083,0xa9c7005f,0xe9ab00f8,0x00000000}},	//   _ভিত্, ссак, هدان_, --,
   {{0x63a2134f,0x99d40079,0x628801bf,0x09e80033}},	//   _lyon, ستلا, indo, _পাশা,
   {{0x629a1350,0xf7700a86,0x27e91351,0x6e271352}},	//   hoto, کام_, úan_, lejb,
   {{0x387d00e9,0x65c51353,0xd9e80033,0x9f4b00a2}},	//   riwr_, обла, _পারম, facé_,
   {{0xe6180210,0x34b305e7,0xddc50355,0x62880223}},	//   йді_, ुद्द, _pohř, jndo,
   {{0x63a2018e,0xdffb0066,0x69c702ce,0x00000000}},	//   _ayon, ्लाद_, _igje, --,
   {{0x673b1354,0x63a209d6,0xe4591355,0x06d80083}},	//   _truj, _byon, ржи_, _সিরি,
   {{0x60ca01ae,0x27ef008d,0x63a201d5,0x6e2700ac}},	//   _aufm, magn_, _cyon, kejb,
   {{0x629a1356,0x63a2021e,0x60d80176,0x7d070055}},	//   goto, _dyon, _btvm, kujs,
   {{0x60261357,0x63a21358,0xdddc010b,0x00000000}},	//   одна, _eyon, sirū, --,
   {{0x27ef0f20,0x628807e5,0x504603fa,0xe45f00ab}},	//   nagn_, ando, цемб, ööd_,
   {{0x63a201a8,0x00000000,0x00000000,0x00000000}},	//   _gyon, --, --, --,
   {{0x6f061359,0x2bbf0930,0xfbbf112b,0x61ea135a}},	//   rukc, ्शना, ्शनम, _gefl,
   {{0xed570390,0x2c6700be,0x09e80033,0x8c7a02fb}},	//   оор_, _sõda_, _পালা, ащат_,
   {{0x69c700da,0x69d501e4,0xc5f30033,0x8c43135b}},	//   _agje, _afze, চ্চা_, месе,
   {{0x2ea700b5,0x20e700b5,0x00000000,0x00000000}},	// [c40] _ڈپٹی_, lői_, --, --,
   {{0x752100d5,0x89f5010b,0x00000000,0x00000000}},	//   _oplz, зяцц, --, --,
   {{0x38cb0a86,0x2901012f,0x60c4135c,0xc7c60a80}},	//   لانی_, grha_, _kiim, осли,
   {{0xdca6135d,0x69da0fd1,0x629a0054,0x186a0370}},	//   _фами, _प्री, zoto, јади_,
   {{0x41c9114e,0xf1c9135e,0x629a000e,0xc5f30083}},	//   रशास, रशान, yoto, চ্ছা_,
   {{0x473302ce,0x7c3603c1,0x60c4135f,0x63a204c6}},	//   ьніс, ldyr, _liim, _ryon,
   {{0x629a05ed,0x00000000,0x00000000,0x00000000}},	//   voto, --, --, --,
   {{0x69c701d2,0x7c361360,0x60c41361,0x6d4e01f7}},	//   _zgje, ndyr, _niim, ixba,
   {{0x629a00a7,0x2451007e,0x00000000,0x00000000}},	//   toto, _jámy_, --, --,
   {{0xd25a1362,0x62880183,0x245100ac,0x60c400f6}},	//   рци_, undo, _mámy_, _aiim,
   {{0x6288038d,0xfc3f00e2,0x5bb70099,0x00000000}},	//   rndo, _khít_, _अण्व, --,
   {{0x63a20159,0x7ea001ff,0x629a1363,0x6a60008d}},	//   _tyon, köps, soto, _döfi,
   {{0x60c40ce8,0x629a1364,0x63a2011e,0x628f000d}},	//   _diim, poto, _uyon, écoc,
   {{0x5edd0083,0xf8ca018d,0x271e00ec,0x69da1365}},	//   _বিদে, िदाय, mānā_, _प्ली,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x60c40008,0x00000000,0x00000000,0x00000000}},	//   _giim, --, --, --,
   {{0x3f8c01c2,0x27ef1366,0x00000000,0x00000000}},	// [c50] şdur_, vagn_, --, --,
   {{0x3cfe1367,0x24510097,0x0b8801e0,0xea0000e2}},	//   štva_, _dámy_, істи_, _đản_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xb8f3065a,0xa3dc021a,0x2901012f,0xfc3f0023}},	//   _हं_, तुम_, rrha_, _chít_,
   {{0x49070035,0x87270037,0x69c70044,0xf72b00af}},	//   _हमको_, تعام, _tgje, рцей_,
   {{0xb9010033,0xd6291368,0x69c70185,0x00000000}},	//   _দি_, соке_, _ugje, --,
   {{0x22491369,0x2fc90159,0xb06600c3,0x00000000}},	//   _đak_, _ogag_, nsää, --,
   {{0x2fc90008,0x26c901ef,0x00000000,0x00000000}},	//   _ngag_, íaos_, --, --,
   {{0xeda8000c,0x3b09022e,0x66f4136a,0x60c4136b}},	//   _गर्छ, nuaq_, _опту, _riim,
   {{0x27ed02e6,0xcb120397,0x2fc90260,0x20e700b5}},	//   _heen_, עלי_, _agag_, tői_,
   {{0xa0a6136c,0x60c400ab,0x27ed0f00,0x2d840225}},	//   занд, _piim, _keen_, şmez_,
   {{0x26c50657,0xc4d20122,0x248902d7,0x27ed0051}},	//   _hilo_, _נגד_, _ñam_, _jeen_,
   {{0x60c4136d,0x27ed136e,0x00000000,0x00000000}},	//   _viim, _meen_, --, --,
   {{0x27ed136f,0xd35602b8,0x64591370,0x6fec0033}},	//   _leen_, _מיני_, _howi, কলেও_,
   {{0x64591371,0x2fcd0627,0x60c402e2,0x7c360d51}},	//   _kowi, žega_, _tiim, tdyr,
   {{0x62811372,0x27ed02a2,0xd0fa0070,0xa2c300e7}},	//   lilo, _neen_, _פּור, रदक्,
   {{0x64590067,0x2d85000d,0x201204fb,0x26c50065}},	// [c60] _mowi, ûler_, _icyi_, _oilo_,
   {{0x62810012,0xee3700af,0x6a600282,0x00000000}},	//   nilo, _ень_, _löfv, --,
   {{0x27ed0052,0x2f16054e,0x7c3603d0,0x3e5b024b}},	//   _been_, læg_, pdyr, _הדיס,
   {{0x62811373,0xc18c02b5,0x64591374,0x00000000}},	//   hilo, סטאָ, _nowi, --,
   {{0x62811375,0x26c51376,0xb8f30084,0x163403fe}},	//   kilo, _bilo_, _हू_, деля,
   {{0x6b89064b,0x98ac04d4,0x26c5022f,0x62811377}},	//   _þega, ılır_, _cilo_, jilo,
   {{0x349401c8,0x62811378,0x64591379,0x26c5137a}},	//   макр, dilo, _bowi, _dilo_,
   {{0x27ed137b,0xc955010b,0x18a3137c,0x00000000}},	//   _geen_, _ўтры, _засм, --,
   {{0x26c5137d,0x6459004e,0x3866137e,0x00000000}},	//   _filo_, _dowi, mkor_, --,
   {{0xa3dc02e4,0x628100af,0x25a51281,0x26c500e0}},	//   _त्र_, gilo, _fyll_, _gilo_,
   {{0x7648137f,0xfc3f0037,0xecbe02b4,0x2ee90359}},	//   _indy, _mhír_, ्दाफ, _swaf_,
   {{0xa3e608a9,0x38661380,0x7af600c3,0x7e7e02ee}},	//   _बजट_, nkor_, ksyt, _ampp,
   {{0x6a6000fb,0x5334029f,0xd04200a8,0x765a1381}},	//   _höfu, _целт, nqlə, _koty,
   {{0x6281002d,0x644700ea,0x64591136,0x00000000}},	//   cilo, ējie, _zowi, --,
   {{0x38661382,0x765a1383,0xe80d0084,0x645901cb}},	//   kkor_, _moty, _हाला_, _yowi,
   {{0xea000023,0x9f4b0e06,0x765a1384,0x4fc71385}},	//   _đạn_, lací_, _loty, _эска,
   {{0x27ed03bc,0x5a351386,0xb0660086,0x38661387}},	// [c70] _reen_, мнат, ssää, dkor_,
   {{0x32d20019,0x27ed0122,0x765a1388,0x9f4b0355}},	//   _mây_, _seen_, _noty, nací_,
   {{0x80a40148,0x26c5011e,0x32d20023,0x6dc30024}},	//   _زمین, _rilo_, _lây_, _qċaċ,
   {{0x38661389,0x6281138a,0x26c5138b,0x2c0900d1}},	//   gkor_, zilo, _silo_, _بعدی_,
   {{0xcc560d85,0x27ed0223,0x26c5138c,0x9f4b00b8}},	//   _חברי_, _veen_, _pilo_, kací_,
   {{0xe5a5135d,0x2ca9138d,0x6459138e,0x27ed138f}},	//   мили, llad_, _sowi, _ween_,
   {{0x64590755,0x765a12ad,0x62811390,0x27ed1391}},	//   _powi, _doty, vilo, _teen_,
   {{0x3866022a,0x61e40200,0x32d201a5,0x76481392}},	//   ckor_, _đila, _bây_, _endy,
   {{0x62811393,0x32d20028,0x2ca9001e,0x26c51394}},	//   tilo, _cây_, ilad_, _tilo_,
   {{0x32d201a5,0x2ca91395,0x00000000,0x00000000}},	//   _dây_, hlad_, --, --,
   {{0x628109eb,0x2ca91396,0x356b0384,0xd5671397}},	//   rilo, klad_, _уран_, _этап,
   {{0x62811398,0x62790187,0x1de60b54,0xd59a00a5}},	//   silo, jňov, कर्ष_, _ובעל,
   {{0x32d201a5,0x62790187,0x248d1399,0xd3d80037}},	//   _gây_, dňov, mnem_, _ربنا_,
   {{0x5edd00c8,0x7cd500d8,0x248d139a,0x249f139b}},	//   _বিশে, _sąra, lnem_, loum_,
   {{0x248d01f7,0x6da30896,0x2ca907df,0x386d139c}},	//   onem_, вира, flad_, _oler_,
   {{0x3cfe139d,0x248d139e,0x2ca9139f,0x4e1f13a0}},	//   štvo_, nnem_, glad_, म्बई_,
   {{0x32d20028,0xa5a400c0,0xdca313a1,0x3ced0254}},	// [c80] _xây_, _चुनौ, тати, ćeva_,
   {{0x2bde0d00,0x248d13a2,0x386d01f7,0x7af60035}},	//   _फ्रा, hnem_, _aler_, rsyt,
   {{0x248d13a3,0x2ca913a4,0x386d13a5,0x9f4200a0}},	//   knem_, blad_, _bler_, jakú_,
   {{0x20d301a5,0x315602b5,0x249f00d7,0x9f4b00b8}},	//   _mãi_, ויען_, joum_, zací_,
   {{0x248d13a6,0x20d30019,0x386613a7,0xfc3f0079}},	//   dnem_, _lãi_, rkor_, _thír_,
   {{0x386613a8,0xa3c10f8a,0xd04200a8,0x00000000}},	//   skor_, ंधन_, rqlə, --,
   {{0x386d06d7,0xceb300c2,0x9f4b031b,0x656300e9}},	//   _fler_, דיג_, vací_, gynh,
   {{0x248d13a9,0x38b50307,0x628f000d,0x68430f88}},	//   gnem_, gård_, écon, _инса,
   {{0x27e613aa,0xd626004f,0x41c913ab,0x3a3813ac}},	//   mbon_, _يعطي, रशंस, _karp_,
   {{0x20d30019,0x518613ad,0x27e601d7,0x2ca013ae}},	//   _bãi_, дума, lbon_, hoid_,
   {{0x2ca0012f,0x20d30023,0x248d13af,0x9f4b00b8}},	//   koid_, _cãi_, bnem_, rací_,
   {{0x27e613b0,0x32d20028,0x248d13b1,0x2bde111a}},	//   nbon_, _tây_, cnem_, _फ्ला,
   {{0x80ca009a,0x44fa00ea,0x6279031d,0x200500c1}},	//   _संके, lī_, vňov, ğli_,
   {{0x2ca9016e,0x200504d4,0x8d6b0370,0x91f2046c}},	//   wlad_, şli_, ојба_, _आजिज_,
   {{0x44fa0228,0x62790bca,0x20d300cc,0x27e60223}},	//   nī_, tňov, _gãi_, kbon_,
   {{0x8af00669,0xfc3f0023,0xa3b50066,0x2ca00553}},	//   yyət, _chíp_, छेक_, goid_,
   {{0x7b180086,0x29180484,0x2d9e13b2,0x2ca913b3}},	// [c90] мотр_, _aqra_, üter_, rlad_,
   {{0xd5a400f5,0x248d13b4,0x2ca0009e,0x62790097}},	//   _نہ_, znem_, aoid_, sňov,
   {{0x62790187,0x249f13b5,0x386d13b6,0x00000000}},	//   pňov, youm_, _pler_, --,
   {{0x59df111b,0x00000000,0x00000000,0x00000000}},	//   _प्रर, --, --, --,
   {{0xf62511ca,0x7c2d13b7,0x248d02c6,0x38b5013c}},	//   едло, mear, vnem_, vård_,
   {{0xb0cf09b1,0x8cb90534,0xe61000a8,0xb05b13b8}},	//   _संलग, ्दको, rüşə, lmäd,
   {{0xe5a200d4,0x248d13b9,0x64a513ba,0x27e610a7}},	//   лиши, tnem_, нака, bbon_,
   {{0x7c2d13bb,0x387f1034,0x20d30023,0x27e600e2}},	//   near, _umur_, _rãi_, cbon_,
   {{0x248d13bc,0x249f0282,0x27ff008c,0x00000000}},	//   rnem_, roum_, _idun_, --,
   {{0x7c2d009c,0x248d13bd,0x00000000,0x00000000}},	//   hear, snem_, --, --,
   {{0x248d13be,0x7c2d01a3,0x00861159,0x2c0f08b0}},	//   pnem_, kear, елно, िलां_,
   {{0x20d30023,0x7c2d13bf,0x38be00fe,0x00000000}},	//   _vãi_, jear, _fůru_, --,
   {{0x7c2d13c0,0x270d00a1,0xf8b2016b,0x00000000}},	//   dear, _समोर_, טשט_, --,
   {{0x442d13c1,0x82350220,0x00000000,0x00000000}},	//   lee_, _سرتا, --, --,
   {{0x261713c2,0x8af00095,0x7c2d13c3,0x27ff10b1}},	//   _नानी_, yyəs, fear, _odun_,
   {{0x442d13c4,0x7c2d13c5,0xdca600b6,0x3a380381}},	//   nee_, gear, хаби, _sarp_,
   {{0x2ca013c6,0xdb1c00a8,0xac0700d8,0xab2713c7}},	// [ca0] roid_, _özüm, энта_, нота_,
   {{0x442d13c8,0x27ff13c9,0x7f44009e,0x00000000}},	//   hee_, _adun_, _iriq, --,
   {{0x442d13ca,0x7c2d13cb,0x644b13cc,0x27e00c22}},	//   kee_, bear, _ongi, ñino_,
   {{0x7c2d13cd,0xb05b0553,0x6e2e13ce,0x00000000}},	//   cear, rmäg, lebb, --,
   {{0xdd8f13cf,0x3a3800d8,0x7d0e13d0,0xb5fc0024}},	//   _نوی_, _tarp_, lubs, _joġg,
   {{0x644b13d1,0x7ae413d2,0x44fa0228,0xe45f00c3}},	//   _angi, mpit, tī_, öön_,
   {{0x7ae413d3,0x2b4013d4,0x69dc13d5,0x7d0e13d6}},	//   lpit, lvic_, _ifre, nubs,
   {{0x442d0626,0x7ae40054,0x6e2e13d7,0x44fa0228}},	//   gee_, opit, hebb, rī_,
   {{0x7ae413d8,0x760a00af,0x96ba0841,0x00000000}},	//   npit, _неаг_, _فائز_, --,
   {{0x644b13d9,0xda100632,0x7c2d06a2,0x75d60037}},	//   _engi, ालित_, zear, _أيضا,
   {{0xd48f0de3,0x7f440183,0x7c2d108c,0x06d80831}},	//   _бр_, _ariq, year, _সিটি,
   {{0x442d13da,0x7f4413db,0x7c2d01a3,0xf99300a5}},	//   cee_, _briq, xear, טרת_,
   {{0x69dc09ab,0x7c2d13dc,0x7f4413dd,0x00000000}},	//   _ofre, vear, _criq, --,
   {{0x7c2d0069,0x6e2e00b5,0x78a2018d,0xa3dc13de}},	//   wear, gebb, hoov, तुर_,
   {{0x30a713df,0x7c2d13e0,0xdd9400c7,0x3ced011c}},	//   _прив, tear, гары, ćevo_,
   {{0x69dc13e1,0xa01b01ff,0x00000000,0x00000000}},	//   _afre, rnös, --, --,
   {{0x7c2d13e2,0xddc501ba,0x7ae41292,0x7a3900af}},	// [cb0] rear, _dlhš, gpit, мпар_,
   {{0x7c2d13e3,0x442d13e4,0x6f0f0036,0x6f1d02b1}},	//   sear, zee_, mucc, mtsc,
   {{0x6f0f13e5,0x7c2d13e6,0x6f1d033b,0x442d13e7}},	//   lucc, pear, ltsc, yee_,
   {{0x442d13e8,0xdddc00d8,0x69dc0107,0x6d4513e9}},	//   xee_, mirš, _efre, _irha,
   {{0xd3660118,0x6f1d13ea,0x442d13eb,0x6f0f027a}},	//   _ئه_, ntsc, vee_, nucc,
   {{0x442d13ec,0x6d4a004f,0x6f1d033b,0x79e700fd}},	//   wee_, _áfac, itsc, _سورہ_,
   {{0x442d13ed,0x6f1d13ee,0x644b13ef,0xc44700b5}},	//   tee_, htsc, _pngi, ٹیشن_,
   {{0x6d4500ee,0x00000000,0x00000000,0x00000000}},	//   _mrha, --, --, --,
   {{0x2ba713f0,0x36d502ce,0x442d13f1,0x9f4b0453}},	//   _कुमा, _розр, ree_, yacá_,
   {{0x6f0f13f2,0x442d13f3,0xcb1402b5,0x6d450225}},	//   ducc, see_, אלץ_, _orha,
   {{0x442d13f4,0x2000046a,0x6d4501e8,0xd00a13f5}},	//   pee_, _pdii_, _nrha, мене_,
   {{0x6e2e001c,0x644b13f6,0x6f1d10c0,0x261701d1}},	//   webb, _ungi, ftsc, _नाडी_,
   {{0x6d4513f7,0x547a00a5,0x6e2e030d,0xa3a80099}},	//   _arha, _קטנו, tebb, _खुप_,
   {{0xdee313f8,0x00000000,0x00000000,0x00000000}},	//   рори, --, --, --,
   {{0x6e2e0133,0x6da613f9,0x7afd13fa,0x6f1d0120}},	//   rebb, тива, _avst, atsc,
   {{0x7f44007a,0x69dc13fb,0x6e2e13fc,0x7ae40107}},	//   _triq, _sfre, sebb, tpit,
   {{0x7d0e13fd,0x6b6313fe,0x6d4502c9,0x6f1d0051}},	// [cc0] subs, акта, _erha, ctsc,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3a8009a,0x7afd02c4,0x1bea0421,0x63ab13ff}},	//   _खुन_, _evst, _одни_, _lygn,
   {{0xe7861400,0x66e61401,0xa3c10026,0x7ae41402}},	//   куло, вода, ंधा_, ppit,
   {{0x628300a0,0x00000000,0x00000000,0x00000000}},	//   _omno, --, --, --,
   {{0xb7d20083,0x20ee00b8,0x78a200ab,0x09e308ce}},	//   ারেট, yři_, soov, _ворн,
   {{0x6f0f0036,0x91fc00ea,0x00000000,0x00000000}},	//   zucc, skāk, --, --,
   {{0x63ab0c61,0x62830cd4,0x394708c8,0x7434002d}},	//   _bygn, _amno, ænse_, униф,
   {{0x872501b2,0xa7a71403,0x36c600c7,0xc7b000fd}},	//   _معلم, _акта_, _абаг, _اڑا_,
   {{0x63ab013c,0x6fec0033,0xf4870088,0x00000000}},	//   _dygn, _কাগজ_, _یانی, --,
   {{0x60f800d8,0x26171404,0x7c261405,0x00000000}},	//   эння_, _नाती_, _obkr, --,
   {{0x6f0f027a,0xdddc1406,0x6f1d10c0,0x64a3010b}},	//   tucc, virš, ttsc, _каха,
   {{0x44261407,0xd36f0c74,0x6f1d033b,0x2d9a01ed}},	//   _ibo_, _وهم_, utsc, _axpe_,
   {{0x6f0f1408,0x6f1d02bf,0x2c75054e,0x9f5202d0}},	//   rucc, rtsc, _måde_, _meyè_,
   {{0x26cc1409,0x2bc50380,0x6f1d140a,0x4426140b}},	//   _mido_, लेना, stsc, _kbo_,
   {{0x26cc140c,0x6f1d033b,0x6d4500ac,0x628303e0}},	//   _lido_, ptsc, _vrha, _zmno,
   {{0x201e0669,0x09bd01c0,0x4426140d,0x26cc00de}},	// [cd0] əti_, ्ख्य, _mbo_, _oido_,
   {{0x9967140e,0x6288140f,0x26cc1410,0x2ba700a1}},	//   ктел, nido, _nido_, _कुणा,
   {{0x67291411,0x7ac41412,0x49a4015a,0x60cd1413}},	//   _spej, рсте, ајца, _kiam,
   {{0x2c750bf3,0x2458016f,0x44260223,0x9f520107}},	//   _både_, _témy_, _nbo_, _beyè_,
   {{0x60cd1414,0x2617009a,0xb8fa0e04,0xef1f033e}},	//   _miam, _नादी_, _डू_, ntü_,
   {{0x44261415,0x60cd1416,0x98b306d0,0xa3ac00a1}},	//   _abo_, _liam, ıdır_, _गरज_,
   {{0x62881417,0x7c3d1418,0x63ab0035,0x44261419}},	//   dido, _kasr, _sygn, _bbo_,
   {{0x60cd141a,0x26cc01dd,0x9f520260,0x00000000}},	//   _niam, _eido_, _feyè_, --,
   {{0x26cc141b,0x7c3d141c,0x42c9141d,0x2c750b3e}},	//   _fido_, _masr, нгин_, _gåde_,
   {{0x6288141e,0x78a2141f,0x44261420,0xe3b61023}},	//   gido, čove, _ebo_, ыбы_,
   {{0x78bb006d,0x60cd0107,0x64150037,0x1a9c016b}},	//   _khuv, _biam, _مواط, ויזע,
   {{0x7c3d1421,0xdee61422,0x60cd01a6,0x2056002d}},	//   _nasr, ломи, _ciam, утор,
   {{0x62881423,0x443f1424,0x60cd1425,0xb4c10067}},	//   bido, mdu_, _diam, ूदी_,
   {{0x443f1426,0x62881423,0x7c26022e,0x6283011c}},	//   ldu_, cido, _sbkr, _umno,
   {{0x443d1427,0x443f00d8,0x7c960889,0x60cd1428}},	//   _kaw_, odu_, грац, _fiam,
   {{0x60cd1429,0x7c3d0211,0x41df142a,0x443d142b}},	//   _giam, _casr, पुरस, _jaw_,
   {{0x4bd9142c,0x3eba01a5,0x443d001e,0x443f142d}},	// [ce0] ться_, _thpt_, _maw_, idu_,
   {{0x443d0122,0x443f142e,0xfaaa00d1,0x78a9005f}},	//   _law_, hdu_, رهاي_, _akev,
   {{0x9f52142f,0x26cc0359,0x09060810,0x443f00d7}},	//   _seyè_, _rido_, упен, kdu_,
   {{0x26cc1430,0x386000fb,0x443f1431,0x78bb1432}},	//   _sido_, ðir_, jdu_, _chuv,
   {{0x443f1433,0x26cc1434,0x7c241435,0x38cb00e0}},	//   ddu_, _pido_, mfir, رامی_,
   {{0x0f370052,0x443f1436,0x62880391,0x7c241437}},	//   טרנט_, edu_, xido, lfir,
   {{0x62881438,0x443d1439,0xaad8143a,0x00000000}},	//   vido, _baw_, _भूतक, --,
   {{0x443d006f,0xdd0401c8,0x7c24143b,0x2fcd022f}},	//   _caw_, ūrėt, nfir, žegi_,
   {{0x62881423,0x443d143c,0xb274015a,0x60cd009c}},	//   tido, _daw_, илиш, _riam,
   {{0x60cd143d,0x7c240526,0x443f00e9,0x7d01143e}},	//   _siam, hfir, adu_, álsk,
   {{0x60cd143f,0x75d312de,0x443f007a,0x1da40f06}},	//   _piam, _ايما, bdu_, _खुलत,
   {{0xf5370052,0x62881440,0x60cd00d7,0x443d0fde}},	//   _תנאי_, sido, _qiam, _gaw_,
   {{0x9f590055,0x00000000,0x00000000,0x00000000}},	//   masë_, --, --, --,
   {{0x64401441,0x6e3e1442,0xef1f0381,0x35a9073f}},	//   ldmi, _capb, rtü_, _चुड़,
   {{0x60cd1443,0x61fa01c2,0x7c241444,0x7c3d1445}},	//   _tiam, matl, ffir, _pasr,
   {{0x61fa1446,0x64401447,0x443d006d,0xaed50279}},	//   latl, ndmi, _xaw_, _коиш,
   {{0x3b5503fa,0x50b80071,0x999000cb,0x6e9500d4}},	// [cf0] шкар, _حدود_, _čaša_, _випу,
   {{0x443f1061,0x61fa1448,0x78bb028b,0xda780f92}},	//   zdu_, natl, _shuv, лях_,
   {{0x39471449,0x443f144a,0x628f00f7,0x999800fe}},	//   íns_, ydu_, écoi, _darů_,
   {{0x2617134b,0x61fa0acc,0x62980009,0x443f00a8}},	//   _नाही_, hatl, _ljvo, xdu_,
   {{0xe739144b,0x443f144c,0x61fa144d,0x07a50798}},	//   тел_, vdu_, katl, јалн,
   {{0xa509144e,0x61fa023a,0x443d00a5,0x00000000}},	//   века_, jatl, _saw_, --,
   {{0x61fa144f,0x443d1080,0x3e7400ab,0x78bb00cc}},	//   datl, _paw_, _jäta_, _thuv,
   {{0x443f1450,0xc6060083,0x3e7401ff,0xfbb91451}},	//   udu_, ল্লা_, _mäta_, _आराम,
   {{0x443f1452,0xfc3f064b,0xe456004b,0xa3a80c57}},	//   rdu_, _maí_, ржы_, _खुद_,
   {{0xc6a71453,0x61fa006c,0x64401454,0x673b0009}},	//   _срби, gatl, admi, _isuj,
   {{0x443d1455,0x7c240093,0xfba7046c,0x09d30387}},	//   _taw_, yfir, _कुसम, _तलैय,
   {{0x62980009,0x443f035f,0x44f300af,0x10a61456}},	//   _ejvo, qdu_, mţ_, римн,
   {{0x61fa05f9,0x6e3e0345,0x00000000,0x00000000}},	//   batl, _papb, --, --,
   {{0x200c0095,0xfcaa05f5,0x673b034d,0x00000000}},	//   şdi_, چارو_, _msuj, --,
   {{0x82340088,0x44f300af,0x8d631457,0xa3dc0930}},	//   _درنا, nţ_, овре, तुक_,
   {{0xb05b1458,0x61e40009,0xfc3f1459,0x673b00cd}},	//   lmän, _đili, _caí_, _osuj,
   {{0xfc3f0279,0x63880228,0x673b073a,0x00000000}},	// [d00] _daí_, cīnī, _nsuj, --,
   {{0xa3e5145a,0x7c24145b,0x7bdf07e5,0xab27145c}},	//   बुत_, sfir, acqu, рофа_,
   {{0xd00f07e4,0x19b900d8,0x7c2401d5,0x673b145d}},	//   _علی_, гуць_, pfir, _asuj,
   {{0x8c460431,0x61fa145e,0x2ba70387,0xa01b0421}},	//   _теме, zatl, _कुवा, tiöi,
   {{0x61fa06d3,0x27e90083,0xbb4300d4,0xeb97145f}},	//   yatl, ñana_, _деяк, _вия_,
   {{0x3cfe0496,0x2913002a,0xbb4303e6,0x24860b88}},	//   štvu_, buxa_, _ќерк, _smom_,
   {{0x26170299,0xd49a1460,0x5e57016b,0x00000000}},	//   _नारी_, кри_, ייסע_, --,
   {{0x98a300d4,0x18671461,0x2c750523,0x00000000}},	//   _дисе, _каси_, _kåda_, --,
   {{0x61fa1462,0xc17800d8,0x3ced011c,0x66e31463}},	//   tatl, ybės_, ćevi_, _мота,
   {{0x09ca0083,0x67221464,0x44240107,0x00000000}},	//   _ল্যা, mtoj, sfm_, --,
   {{0x61fa1465,0x705500b2,0x272002d0,0x67221466}},	//   ratl, مندا, lòn_, ltoj,
   {{0x672200d8,0x2486040b,0x61fa1465,0x44320023}},	//   otoj, _umom_, satl, _úy_,
   {{0x67221467,0x61fa1468,0xfc3f021d,0x00000000}},	//   ntoj, patl, _raí_, --,
   {{0xea0000e8,0x61fa00a8,0x7ae9027d,0xfc3f0132}},	//   _đến_, qatl, _çeti, _saí_,
   {{0xb2bb0122,0xbd680012,0x25fe04bc,0x67221469}},	//   _שמור, арте_, _रजनी_, htoj,
   {{0x6722146a,0x2c75022a,0xdb0f0138,0x5c74146b}},	//   ktoj, _båda_, _azcá, олст,
   {{0x3a7502c4,0x672201f4,0xa9e70037,0x00000000}},	// [d10] блар, jtoj, لثان, --,
   {{0x61f80009,0x6d43146c,0x00000000,0x00000000}},	//   _jevl, _šnau, --, --,
   {{0xdd91146d,0x2ba7000c,0x06e60033,0x61f8146e}},	//   _روح_, _कुरा, _নিষি, _mevl,
   {{0x315700c2,0x20191221,0x272002d0,0x672201f4}},	//   ייבן_, ngsi_, fòn_, ftoj,
   {{0xf7450e88,0xd838005f,0x25b2013b,0x00000000}},	//   село, рэх_, əyli_, --,
   {{0x2ca9146f,0x78a20076,0xbb3a02b5,0x291301ef}},	//   load_, čova, _געשי, puxa_,
   {{0xfbdb009a,0x28f81470,0xd5490088,0x499301cb}},	//   _भलाम, _весь_, البو_, _بیار,
   {{0x673b1471,0x29010054,0x6722006d,0x4adb00ab}},	//   _tsuj, msha_, btoj, _बढाव,
   {{0x29010c6f,0x61f81472,0x9f590118,0x00000000}},	//   lsha_, _bevl, basé_, --,
   {{0x425505d2,0x38bc004f,0x290108c7,0x61f8023a}},	//   стит, ríre_, osha_, _cevl,
   {{0x61f81473,0xa06a1474,0xb05b1475,0x00000000}},	//   _devl, гана_, rmän, --,
   {{0xf99200a5,0x29011476,0xb05b1477,0x00000000}},	//   לרי_, isha_, smän, --,
   {{0x248d0ae0,0x76411478,0x889a0317,0x6fa50067}},	//   miem_, _kaly, רברי, _गुआं,
   {{0x29010118,0x248d0029,0x61f80b0d,0xb05b00c3}},	//   ksha_, liem_, _gevl, lmäl,
   {{0x76411479,0xfce6147a,0x01c50033,0x916800e2}},	//   _maly, собо, _শ্রদ, _tức_,
   {{0x248d147b,0x672200d8,0xb05b013c,0x00000000}},	//   niem_, ytoj, nmäl, --,
   {{0x29010159,0xf1bf00b8,0xd5b10023,0x29070009}},	// [d20] esha_, řád_, _lý_, šnal_,
   {{0x6f040a78,0x248d147c,0x29010031,0xb05b147d}},	//   _ivic, hiem_, fsha_, hmäl,
   {{0xfe370052,0x248d147e,0xdca609cc,0xbd46147f}},	//   _פרטי_, kiem_, _гани, _انجي,
   {{0x248d0ae0,0xd7f70009,0x91fc0029,0x69d51480}},	//   jiem_, буш_, nkār, _egze,
   {{0x501b0bed,0x248d0080,0x76411481,0x67221482}},	//   רונו, diem_, _baly, utoj,
   {{0x67221483,0x1ae3001f,0x7c361484,0x00000000}},	//   rtoj, _хорм, leyr, --,
   {{0x67220690,0x76410a93,0x9f591485,0x6f0400fe}},	//   stoj, _daly, rasé_, _lvic,
   {{0x248d1486,0x672200da,0xb1760019,0x2bc50a44}},	//   giem_, ptoj, _ngượ, लेवा,
   {{0xa3a80953,0x00000000,0x00000000,0x00000000}},	//   _खुश_, --, --, --,
   {{0x76411487,0xda7b0070,0x066500f8,0x00000000}},	//   _galy, ָנטר, _والپ, --,
   {{0xd0110bdf,0x248d1488,0x69c100ac,0x959a002d}},	//   ولد_, biem_, _úlet, _стау_,
   {{0x248d1489,0x76410103,0x00000000,0x00000000}},	//   ciem_, _zaly, --, --,
   {{0x5f9402fb,0x6f04148a,0x3e970037,0x9f4001ed}},	//   зият, _cvic, مؤسس, _beiñ_,
   {{0xfbbe00dc,0x29010159,0x64420315,0x2bbe00e7}},	//   ्धनम, ysha_, _haoi, ्धना,
   {{0x90e605bc,0x628a02d7,0x7c360093,0x6e3500f4}},	//   _استن, _imfo, feyr, rezb,
   {{0x7f950409,0x00000000,0x00000000,0x00000000}},	//   _майх, --, --, --,
   {{0x6442148b,0x5eb80083,0xd9f9075a,0x9b950421}},	// [d30] _maoi, _ইংরে, инац_, циац,
   {{0x7f4d0095,0x2901148c,0x644209c3,0x248d148d}},	//   _iraq, tsha_, _laoi, ziem_,
   {{0x6f0401f4,0x27e9148e,0xa01b008d,0xdb060097}},	//   _zvic, ñano_, rhöf, _vyká,
   {{0x6d400080,0x764100e0,0xdb0f0248,0x6442148f}},	//   āmat, _saly, _lycé, _naoi,
   {{0x248d1490,0xa3a80299,0x764100d8,0x29011491}},	//   viem_, _खुल_, _paly, ssha_,
   {{0xf1c8051e,0x248d004e,0x00000000,0x00000000}},	//   रधान, wiem_, --, --,
   {{0x248d0080,0x9f40008a,0x76411492,0xf5560037}},	//   tiem_, _leið_, _valy, قلوب_,
   {{0x13091493,0x644202a8,0x7b08008a,0x2b4900cd}},	//   аний_, _caoi, _ástæ, ovac_,
   {{0x6442003b,0x76411494,0x248d1490,0x7aed1495}},	//   _daoi, _taly, riem_, npat,
   {{0x248d0029,0x7aed1496,0x20090054,0x2f100093}},	//   siem_, ipat, _adai_, _lögð_,
   {{0x6442006e,0x7f4d1497,0x645d01ae,0x6d5c0069}},	//   _faoi, _araq, ösis, xxra,
   {{0x43750fbb,0x644209bb,0xf485006c,0x9fca0265}},	//   _мулт, _gaoi, _بائی, игна_,
   {{0xaad8009a,0xe28e00d8,0x7f4d1498,0x083a0070}},	//   _भूंक, _жа_, _craq, בערל,
   {{0x7f4d027a,0x7aed0af9,0x91fc0228,0xc5f9016b}},	//   _draq, dpat, skār, יפֿט,
   {{0xa3c102e4,0xa01b00a6,0x9d431499,0x00000000}},	//   ंधक_, giös, мерд, --,
   {{0x7f4d149a,0x6f040260,0x00000000,0x00000000}},	//   _fraq, _tvic, --, --,
   {{0x7aed149b,0x7c36008a,0x8eba002d,0x6f040176}},	// [d40] gpat, reyr, _вынт_, _uvic,
   {{0xf2210324,0xf992149c,0xa2da0067,0x25a00225}},	//   _माफ़_, وبا_, नदत्, şili_,
   {{0x64970029,0xed5a13c7,0x6ee50919,0x05a907b5}},	//   rģij, _тон_, _وسیل, _चुलब,
   {{0x7aed149d,0xcfad0033,0xd7ef0037,0xae2000ab}},	//   bpat, _গণতন, نكم_, _बाडन_,
   {{0xa6ca02c4,0x644200f1,0x8af0013b,0x00000000}},	//   алда_, _raoi, yyəy, --,
   {{0x6442009c,0x6b63010b,0x00000000,0x00000000}},	//   _saoi, _ўкра, --, --,
   {{0xd8390107,0x385a149e,0x6923031a,0x92e60033}},	//   _djōb_, _краю_, _омра, _বটে_,
   {{0xa3e50d4e,0xe81405a6,0x00000000,0x00000000}},	//   बुल_, _डाटा_, --, --,
   {{0x533400af,0x00000000,0x00000000,0x00000000}},	//   чепт, --, --, --,
   {{0x3f82042f,0x026a00d4,0x00000000,0x00000000}},	//   dzku_, рший_, --, --,
   {{0x2ee9149f,0x3a370122,0x644214a0,0x8cd60067}},	//   _staf_, חרים_, _taoi, _मंगो,
   {{0x232a14a1,0x7aed005f,0xb05b0421,0x00000000}},	//   _води_, ypat, mmäk, --,
   {{0xe29a0202,0xb05b0421,0xe7ca06fe,0x00000000}},	//   _кад_, lmäk, िधिप, --,
   {{0x29070332,0x63a201ed,0x9f5b0055,0x00000000}},	//   ának_, _ixon, _heqë_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa01b14a2,0x7f4d14a3,0xe57102b5,0x69d8010b}},	//   riös, _traq, ײַל_, žvel,
   {{0x3a750009,0xda67026e,0x9f5b0031,0x6d4801ff}},	// [d50] плар, يائي, _meqë_, ådar,
   {{0x68e30391,0x00000000,0x00000000,0x00000000}},	//   índo, --, --, --,
   {{0x05a902e4,0x629a00c3,0xa3ca00a1,0x7aed14a4}},	//   _चुंब, into, ळेत_, spat,
   {{0x7aed14a5,0x6d5814a6,0x7c590079,0x38be06fe}},	//   ppat, _švag, _الحر_, _kůry_,
   {{0xfc5a00a5,0x00000000,0x00000000,0x00000000}},	//   _הכרמ, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d830035,0x26c7080a,0x00000000,0x00000000}},	//   nzje_, rmno_, --, --,
   {{0x629a14a7,0x00000000,0x00000000,0x00000000}},	//   ento, --, --, --,
   {{0xf77308cf,0x3834093e,0x00000000,0x00000000}},	//   _غار_, _інфр, --, --,
   {{0x629a008c,0xaabd112b,0x2bbe06fe,0xb05b0a48}},	//   gnto, ्गिक, ्धता, lmäh,
   {{0x27e002dd,0x85050a86,0x63a214a8,0x91fc0029}},	//   žine_, _روشن, _exon, rkāp,
   {{0x8fa614a9,0x55ba00a5,0x61ee00a8,0xb05b02b1}},	//   заме, _המעו, ıbla, nmäh,
   {{0xc3190083,0x442f14aa,0x09b801c0,0x52750009}},	//   _তৈরি_, _ibg_, _अर्य, _нуку,
   {{0x68e901a0,0x442f0282,0x00000000,0x00000000}},	//   _čedn, _hbg_, --, --,
   {{0x670214ab,0xdd9214ac,0xddc507c0,0x00000000}},	//   _रौनक_, رور_, _jahň, --,
   {{0x442f025c,0xaf060525,0x00000000,0x00000000}},	//   _jbg_, _епил, --, --,
   {{0x3aeb0332,0x200214ad,0x60c414ae,0x207b0070}},	// [d60] مبلی_, maki_, _ihim, _לאקא,
   {{0x200214af,0x442f0009,0xdb060035,0xa6e90023}},	//   laki_, _lbg_, _szkó, _khươ,
   {{0xceb314b0,0x4ddb00a5,0x442f0183,0x8d760934}},	//   _איז_, _לחיו, _obg_, _رادا,
   {{0x38cb03c5,0xdca611d0,0xda1e00ab,0x442f14b1}},	//   مانی_, _хами, _पावत_, _nbg_,
   {{0x629a0090,0xfbb900b4,0x60c414b2,0x00000000}},	//   ynto, _आरएम, _mhim, --,
   {{0x200214b3,0xd6d900d4,0x6b840009,0x81bc0831}},	//   haki_, іті_, mzig, _অলস_,
   {{0xe9a314b4,0x442f14b5,0x00000000,0x00000000}},	//   _зарп, _bbg_, --, --,
   {{0x399b0122,0x200214b6,0x2bc30066,0x291a08dd}},	//   _הילד, jaki_, _शरमा, mupa_,
   {{0x20020723,0x291a14b7,0x6b8414b8,0x98a3002d}},	//   daki_, lupa_, nzig, _чите,
   {{0x2a6a14b9,0xb05b03ad,0x877b0397,0x629a14ba}},	//   _jobb_, mmäi, _האמי, unto,
   {{0x2bb90567,0xa6e90028,0x249700bf,0x60c40118}},	//   _आर्थ, _chươ, _کنند_, _bhim,
   {{0x27e614bb,0x60c414bc,0x442f017b,0xfbbe142a}},	//   ncon_, _chim, _gbg_, ्धाम,
   {{0x60c400da,0x6b8404ce,0x291a010d,0xeaae0009}},	//   _dhim, jzig, hupa_, koй_,
   {{0x291a14bd,0xd35700a5,0xf1e00835,0x00000000}},	//   kupa_, _מידי_, _नलिन, --,
   {{0x200214be,0x27e600d7,0x68e914bf,0x78a20506}},	//   baki_, kcon_, _čedo, čovj,
   {{0x30a401c8,0x60c414c0,0x60d60225,0x00000000}},	//   _прыв, _ghim, _giym, --,
   {{0x3f9e01d6,0x7c2f14c1,0x00000000,0x00000000}},	// [d70] ştur_, _vbcr, --, --,
   {{0x291a002f,0x6d410093,0x1ab4002d,0x00000000}},	//   fupa_, ælas, ебуя, --,
   {{0x290701c0,0x27e60bf0,0x291a010d,0x8cd60067}},	//   éna_, fcon_, gupa_, _मंचो,
   {{0x3869064b,0x6a73033e,0x00000000,0x00000000}},	//   ðar_, _sıfı, --, --,
   {{0x7c2d14c2,0x649700af,0xf72b010b,0x28d9021a}},	//   mfar, nţie, сцей_, _बंकि,
   {{0x200214c3,0x442f14c4,0x7c2d14c5,0x00000000}},	//   zaki_, _sbg_, lfar, --,
   {{0xa93414c6,0x200214c7,0x291a14c8,0xe1ab073f}},	//   _перш, yaki_, cupa_, _घुंघ,
   {{0x7c2d14c9,0x20020132,0x00000000,0x00000000}},	//   nfar, xaki_, --, --,
   {{0x20020a2c,0x7c2d14ca,0x00000000,0x00000000}},	//   vaki_, ifar, --, --,
   {{0xa6e90028,0x60c414cb,0x200214cc,0x00000000}},	//   _phươ, _shim, waki_, --,
   {{0x660314cd,0x200214ce,0x27ff008c,0x60c400cc}},	//   mank, taki_, _keun_, _phim,
   {{0x660314cf,0x60d601c2,0x205614d0,0x27ff00f6}},	//   lank, _qiym, фтор, _jeun_,
   {{0x64490297,0x200214d1,0x645914d2,0x7c2d14d3}},	//   mdei, raki_, _inwi, dfar,
   {{0x200214d4,0x442d02bf,0xa6e900e8,0x660314d5}},	//   saki_, lfe_, _thươ, nank,
   {{0x200214d6,0x60c414d7,0x2a6a14d8,0xed35002d}},	//   paki_, _thim, _robb_, нэтэ,
   {{0x644914d9,0x442d14da,0x6b8414db,0x39940006}},	//   ndei, nfe_, tzig, _तs_,
   {{0x06e30083,0x3e7400ab,0x6d4105ee,0x6497002d}},	// [d80] নীতি, _läti_, ælar, cţie,
   {{0xe9d2026e,0x291a14dc,0x628100e2,0x22470069}},	//   نغا_, tupa_, nhlo, _jank_,
   {{0x660314dd,0x7e7e022e,0x2ee014de,0x224702d0}},	//   dank, _ilpp, _ভবিষ, _mank_,
   {{0x291a14df,0x22470173,0x7d1c14e0,0x39430009}},	//   rupa_, _lank_, murs, _dsjs_,
   {{0x44e302d7,0x073a0789,0x2ee014e1,0x64490090}},	//   _añ_, تساب_, _juif_, ddei,
   {{0x6e3c14e2,0x26c505b9,0x660314e3,0x44fa00ec}},	//   nerb, _chlo_, gank, tū_,
   {{0x442d14e4,0x69dc0bb0,0x26c500d7,0x64490051}},	//   ffe_, _igre, _dhlo_, fdei,
   {{0x3ae4022a,0x6e3c14e5,0x27ff00cc,0x6f0900f4}},	//   _köp_, herb, _geun_, šeci,
   {{0x6e3c14e6,0x224700a5,0x7ae20079,0xb5fc007a}},	//   kerb, _bank_, íoth, _loġi,
   {{0x6e3c0009,0x442d14e7,0x64490015,0x290a0345}},	//   jerb, afe_, adei, _kvba_,
   {{0x224714e8,0x7c2d001e,0x765a14e9,0x018a00c3}},	//   _dank_, yfar, _inty, ющий_,
   {{0x7d1c14ea,0x1c1d14eb,0x386614ec,0x73c60f98}},	//   durs, _फाइल_, njor_, _قيام,
   {{0x69dc14ed,0x6e3c14ee,0x22470009,0x764814ef}},	//   _ogre, ferb, _fank_, _kady,
   {{0x628114f0,0x6e3c14f1,0x69dc14f2,0x224714f3}},	//   chlo, gerb, _ngre, _gank_,
   {{0xc3480019,0xf1aa00d1,0x764814f4,0x7d1c14f5}},	//   _hổ_, _باشه_, _mady, gurs,
   {{0x660314f6,0x69dc14f7,0x6e3c0036,0x2ee00051}},	//   zank, _agre, aerb, _fuif_,
   {{0x3ec714f8,0x4abd0355,0x7c2d14f9,0x765a0b88}},	// [d90] _особ, ्गलव, rfar, _onty,
   {{0x27ff0173,0x68fc001e,0xadf3020d,0x764801cb}},	//   _seun_, _bwrd, _अभिन_, _nady,
   {{0x6f1d14fa,0x481514fb,0x6449001e,0x6e2514fc}},	//   lusc, емес, ydei, _ichb,
   {{0x6d4514fd,0xb8e70299,0x765a14fe,0x660314ff}},	//   _isha, _उठ_, _anty, wank,
   {{0x7648129d,0xc3480019,0x7bdd02b3,0x569512ea}},	//   _bady, _nổ_, _igsu, надт,
   {{0x68fc00e9,0x6459009e,0x00000000,0x00000000}},	//   _fwrd, _snwi, --, --,
   {{0x76481500,0x224700a5,0x68fc00e9,0x27ff0223}},	//   _dady, _rank_, _gwrd, _teun_,
   {{0x93451501,0x61ea1502,0xc34801a5,0x6d45000e}},	//   ение, _affl, _bổ_, _msha,
   {{0x64490434,0xc3480028,0x442d1503,0x66031504}},	//   rdei, _cổ_, rfe_, pank,
   {{0x2729116c,0x66031505,0x764802d0,0x64491506}},	//   mún_, qank, _gady, sdei,
   {{0x6d451507,0x27290037,0x22470160,0x442d1508}},	//   _nsha, lún_, _vank_, pfe_,
   {{0x6e3c02c9,0x386d0453,0xf09f0176,0x6f1d0036}},	//   werb, _joer_, gnà_, fusc,
   {{0x66011509,0x6d4508bd,0x249f008d,0x386d150a}},	//   _kelk, _asha, mnum_, _moer_,
   {{0x7d1c150b,0x6601150c,0x249f0093,0x386d03bc}},	//   turs, _jelk, lnum_, _loer_,
   {{0x387f0d6f,0x320501ba,0x6da3150d,0xed57150e}},	//   _olur_, maly_, гира, нор_,
   {{0x249f00fb,0x6e3c150f,0x6601006c,0x386d1510}},	//   nnum_, serb, _lelk, _noer_,
   {{0x6d4501d5,0x249f0093,0xc3480019,0x69dc1511}},	// [da0] _esha, inum_, _xổ_, _pgre,
   {{0x6d4500da,0x387f1512,0x32051513,0x66011514}},	//   _fsha, _alur_, naly_, _nelk,
   {{0x76481515,0x386d1516,0x249f008a,0xdb060a8a}},	//   _rady, _boer_, knum_, _lykø,
   {{0x76480dc3,0x3ae4008e,0xd7061517,0x32051518}},	//   _sady, _töp_, езди, haly_,
   {{0x272909ab,0x61360332,0x66011519,0x3205151a}},	//   gún_, _külö, _belk, kaly_,
   {{0x6601114d,0xc3480023,0x3205151b,0x69dc0210}},	//   _celk, _rổ_, jaly_, _ugre,
   {{0xc34801a5,0x2ca000ab,0xfaa3151c,0x249f008a}},	//   _sổ_, onid_, _саро, fnum_,
   {{0x249f008a,0x5454151d,0x660100ab,0x2ca000ab}},	//   gnum_, твит, _eelk, nnid_,
   {{0x7648151e,0x6601006c,0xc7a30674,0xfe200084}},	//   _tady, _felk, _битк, _बांस_,
   {{0x2c7c1111,0x2ca00079,0x00000000,0x00000000}},	//   _oído_, hnid_, --, --,
   {{0xb05b022a,0xbbbe018d,0x2b9101ba,0x5a170070}},	//   nläg, ्धुक, môcť_, עקטן_,
   {{0xc3480028,0x6f1d038e,0xbebb01f4,0x399b0070}},	//   _tổ_, tusc, ntëv, לייד,
   {{0x4426151f,0x32051520,0xb05b01ae,0x2c7c02d7}},	//   _ico_, baly_, hläg, _aído_,
   {{0x6f1d1521,0xa01b033b,0x7c261522,0xb05b017b}},	//   rusc, chön, _ackr, kläg,
   {{0xac951523,0x00000000,0x00000000,0x00000000}},	//   вавш, --, --, --,
   {{0x6f1d1524,0xdcb801d3,0x9404013b,0x00000000}},	//   pusc, ещу_, timə_, --,
   {{0x64970043,0x00d800b5,0x44260088,0x92de0033}},	// [db0] nţia, _ثبوت_, _mco_, _তবু_,
   {{0x6d450d4b,0x3b091525,0x24840159,0x6f0d00ee}},	//   _tsha, rsaq_, hhmm_, _ivac,
   {{0x3b09007a,0x6d451526,0x44261527,0x387f1528}},	//   ssaq_, _usha, _oco_, _plur_,
   {{0x442601a9,0x66010086,0x672b0044,0x27291529}},	//   _nco_, _selk, ttgj, tún_,
   {{0xf745152a,0x386d152b,0x66010086,0xb05b152c}},	//   тело, _voer_, _pelk, lmäs,
   {{0x2729152d,0xe9d300f8,0x69351108,0x386d0345}},	//   rún_, _مغز_, _ингу, _woer_,
   {{0x6601152e,0x3205152f,0x386d053e,0x249f0093}},	//   _velk, valy_, _toer_, tnum_,
   {{0x660106ba,0x58d40374,0x3e7402b1,0x387f0031}},	//   _welk, _бост, _hätt_, _ulur_,
   {{0x249f008a,0x32051530,0xd8420355,0x44261531}},	//   rnum_, taly_, áčů_, _dco_,
   {{0x44261532,0x249f1533,0x00000000,0x00000000}},	//   _eco_, snum_, --, --,
   {{0x32051534,0xb05b1535,0x249f0093,0x4e1b00ab}},	//   raly_, kläd, pnum_, _बाड़े_,
   {{0x32051536,0x3e74022a,0x339213cf,0xdee60f6d}},	//   saly_, _lätt_, الیز, коми,
   {{0x443f1537,0x10a31538,0x320500ac,0x6f0d00d5}},	//   meu_, риян, paly_, _cvac,
   {{0x443f1539,0x644b153a,0x6da60f94,0x332d153b}},	//   leu_, _hagi, вига, mtex_,
   {{0x6f0d153c,0x644b0c02,0x27ed02b1,0x817403fc}},	//   _evac, _kagi, _ofen_, _منوچ,
   {{0x443f153d,0x7f86004f,0x6f960037,0x7cdc009e}},	//   neu_, _للبن, _للعض, _cōra,
   {{0x644b153e,0x443f0310,0x7c2b0014,0xb05b153f}},	// [dc0] _magi, ieu_, ògra, rmät,
   {{0x644b1540,0xaa7b0093,0x443f1541,0x9c8502d4}},	//   _lagi, _stýr, heu_, _ančā,
   {{0x6f0d0cc1,0xaa4302ee,0x00000000,0x00000000}},	//   _zvac, рехл, --, --,
   {{0x644b1542,0x63a4008a,0xb05b1543,0x7f5601f4}},	//   _nagi, _þing, rläg, _kryq,
   {{0x443f1544,0x27e01545,0xb05b01ff,0xbebb0031}},	//   deu_, žino_, släg, rtëv,
   {{0x7c24010b,0xddc50c99,0x7bc602c6,0xbebb01f4}},	//   lgir, _hohš, _izku, stëv,
   {{0x92de0b52,0x644b1546,0xc5d500c8,0x443f1547}},	//   _তবে_, _bagi, _স্বপ, feu_,
   {{0x7c241548,0x443f1549,0x38c80148,0x644b027a}},	//   ngir, geu_, _سازی_, _cagi,
   {{0x644b154a,0xf2c6154b,0x66e6126e,0xb05b01ff}},	//   _dagi, ксон, _роза, kmär,
   {{0x78a2154c,0x6f0d022f,0x644b154d,0x649700af}},	//   lnov, _rvac, _eagi, rţia,
   {{0x443f154e,0x6f0d154f,0x6d581550,0x518609a5}},	//   beu_, _svac, _švan, тупа,
   {{0x04460500,0x443f1551,0x78a21552,0x61f500d0}},	//   _једн, ceu_, nnov, ızla,
   {{0x78a200ac,0x6440027d,0x00000000,0x00000000}},	//   inov, memi, --, --,
   {{0x64970043,0x644b1553,0xd13001cb,0x4ea40409}},	//   nţin, _zagi, _همت_, арса,
   {{0x3e7406d7,0x644b0a74,0x7bc601a3,0xac2703e6}},	//   _rätt_, _yagi, _azku, кфак,
   {{0x78a21554,0x64401555,0x3e7406d7,0x6abd1556}},	//   jnov, nemi, _sätt_, ्ग्र,
   {{0x4ea7082a,0x5a3507c1,0xbebb0031,0xb05b01ff}},	// [dd0] _арна, лнат, ftët, smäs,
   {{0x64401557,0x443f0043,0xf8cb0355,0xdce70035}},	//   hemi, zeu_, िष्प, zyję,
   {{0x39151558,0x7bc601d7,0x443f1559,0x6440155a}},	//   умер, _ezku, yeu_, kemi,
   {{0x78a2155b,0x443f0443,0x6440155c,0x648701a3}},	//   gnov, xeu_, jemi, _iñig,
   {{0x644b1530,0x443f155d,0x291a027a,0xd366017e}},	//   _ragi, veu_, arpa_, _اه_,
   {{0x644b155e,0xe5a5155f,0x332d0024,0x00000000}},	//   _sagi, лили, vtex_, --,
   {{0x644b1560,0x443f1561,0x78a20334,0x64401562}},	//   _pagi, teu_, bnov, femi,
   {{0x64401563,0x69c70169,0x332d0484,0x78a21564}},	//   gemi, _izje, ttex_, cnov,
   {{0x443f1565,0x67d4002d,0x91e51566,0xbebb0055}},	//   reu_, _воту, лопе, ntës,
   {{0x443f1567,0x644b1568,0xb6340754,0xd2a600af}},	//   seu_, _wagi, _نعمت, лкые_,
   {{0x644b1569,0x443f156a,0xab5b0332,0xe4e702ce}},	//   _tagi, peu_, _szül, _різн,
   {{0xa3550041,0xbebb0031,0xc879156b,0x644b023c}},	//   _مختص, ktës, _fişe_, _uagi,
   {{0xbebb00da,0x6d5700a8,0x6d4101fb,0x99750067}},	//   jtës, _arxa, çlan, nęła_,
   {{0x78a20169,0xdee3156c,0x539a0319,0x00000000}},	//   znov, сори, _אינו, --,
   {{0x5bbe0ac4,0x6497002d,0x7c24156d,0x78a2156e}},	//   ्ध्व, nţio, tgir, ynov,
   {{0xb05b007c,0xdd8f0037,0xbebb0031,0xa3d700b4}},	//   smär, سوق_, ftës, _ाणा_,
   {{0x78a2156f,0xb05b013c,0x69c7009f,0x2c7503d0}},	// [de0] vnov, pmär, _azje, _rådt_,
   {{0x7c241570,0x64401571,0x2d9e00a2,0x8af0013b}},	//   sgir, zemi, ûtes_, vvəd,
   {{0x64401572,0x7c240392,0x673b1573,0xdce80029}},	//   yemi, pgir, _apuj, ēlēt,
   {{0xe3a701ca,0xd70a1574,0x78a21575,0x644001ed}},	//   _هر_, енде_, unov, xemi,
   {{0xb8eb0e04,0x2bba0037,0x7bc61576,0x00000000}},	//   _री_, _ساحة_, _uzku, --,
   {{0x78a21577,0x09e31578,0x00000000,0x00000000}},	//   snov, _горн, --, --,
   {{0x64400723,0xafdb0c61,0x2bbe1579,0x649700af}},	//   temi, ndør, ्धका, rţin,
   {{0x62830861,0x6497002d,0x78a20187,0x00000000}},	//   _alno, sţin, čovs, --,
   {{0xb5fc0069,0x6d580eac,0x7ae60069,0xf20610a4}},	//   _anġe, _šval, _jukt, ляно,
   {{0x6722010b,0x86c60037,0x64400d19,0x00000000}},	//   muoj, _صيان, semi, --,
   {{0x6440157a,0x27e9068b,0x7ae6157b,0x6497002d}},	//   pemi, žane_, _lukt, cţio,
   {{0xf99302b8,0x6497002d,0x660a008c,0x9f590079}},	//   מרת_, nţil, lafk, masú_,
   {{0x672200d8,0x26de157c,0xf4870416,0x7ae6002f}},	//   nuoj, _kito_, _حالی, _nukt,
   {{0x0cbf157d,0x81d41283,0x660a046a,0xb05b01ae}},	//   ्ष्म, _колх, nafk, fläc,
   {{0x629a157e,0x7ae6157f,0xc27b0070,0x6ca71580}},	//   mito, _aukt, _ארגי, граж,
   {{0x7ae61581,0x26de1582,0x1f751583,0x44ea0019}},	//   _bukt, _lito_, _влия, _mù_,
   {{0x200b1584,0x26de0bc8,0x660a1585,0x60cd1586}},	// [df0] maci_, _oito_, kafk, _iham,
   {{0x44ea1010,0x200b1587,0x26de0269,0x7ae61588}},	//   _où_, laci_, _nito_, _dukt,
   {{0x60cd1589,0x81b60083,0xbebb0031,0x2aa8052a}},	//   _kham, চের_, stës, утто_,
   {{0x200b0d5c,0x8934004f,0x629a158a,0x394a008c}},	//   naci_, إعلا, hito, _dsbs_,
   {{0x629a158b,0x6722010b,0x60cd158c,0x26de158d}},	//   kito, guoj, _mham, _bito_,
   {{0x629a158e,0x44ea0019,0x870400c3,0x26de158f}},	//   jito, _bù_, сяце, _cito_,
   {{0x26de0269,0x44ea1590,0x200b00b8,0x6f1d01ae}},	//   _dito_, _cù_, kaci_, hrsc,
   {{0x200b0936,0x44ea01a5,0x67221591,0x628800c3}},	//   jaci_, _dù_, buoj, ehdo,
   {{0x200b1592,0x6b8d1593,0x26de1594,0x6283024e}},	//   daci_, nzag, _fito_, _plno,
   {{0x65951595,0x68e700da,0x60cd1596,0x26de043c}},	//   _казу, _kujd, _aham, _gito_,
   {{0x76431597,0x6f1d1598,0x4254010b,0x200b1599}},	//   meny, ersc, стыт, faci_,
   {{0x60cd159a,0x200b159b,0x26de08c7,0x7523159c}},	//   _cham, gaci_, _zito_, munz,
   {{0x60cd159d,0xe1ee159e,0xdee6159f,0x22490ebc}},	//   _dham, _мг_, роги, _апли_,
   {{0x628815a0,0x78a9003a,0x764301a8,0x29030051}},	//   chdo, _ljev, neny, _owja_,
   {{0x752315a1,0x78bb09d6,0x200b0a78,0x672200d8}},	//   nunz, _okuv, baci_, zuoj,
   {{0x200b15a2,0x60cd15a3,0x764315a4,0x3ceb00ac}},	//   caci_, _gham, heny, _živí_,
   {{0x764315a5,0x4e1a0086,0xbebb01f4,0x752301d5}},	// [e00] keny, _июня_, rtër, hunz,
   {{0x75230010,0x78a90009,0x2b590a69,0xef1f00b5}},	//   kunz, _ajev, _drsc_, zzük_,
   {{0x2bb80299,0x26de15a6,0xfe3702b5,0x3eb815a7}},	//   _आडवा, _rito_, _דריי_, mort_,
   {{0x26de0133,0x628801d2,0x629a15a8,0x313602b5}},	//   _sito_, zhdo, zito, ינעם_,
   {{0x78a915a9,0x26de15aa,0x87030a2b,0x6497002d}},	//   _djev, _pito_, ояще, rţil,
   {{0x752315ab,0x200b00b8,0x672200d8,0x629a0300}},	//   funz, zaci_, ruoj, xito,
   {{0x629a0690,0x660a15ac,0x3218004e,0x6d5815ad}},	//   vito, rafk, órym_, _švaj,
   {{0x7c3605ee,0x26de0054,0x98a615ae,0x6b9b01f2}},	//   nfyr, _wito_, _тибе, _žugi,
   {{0x629a15af,0x26de15b0,0x60cd15b1,0x320715b2}},	//   tito, _tito_, _rham, _beny_,
   {{0x320715b3,0x60cd15b4,0xab5b0332,0x44ea0019}},	//   _ceny_, _sham, _szük, _tù_,
   {{0x200b15b5,0x68e0037a,0x60cd15b6,0x6b8d027a}},	//   taci_, _kimd, _pham, zzag,
   {{0x859b0122,0x629a15b7,0x6f0401d5,0x757b0070}},	//   _בשבו, sito, _bwic, _שטאפ,
   {{0x200b15b8,0x3eb81229,0xfa110033,0x68e0009f}},	//   raci_, fort_, স্টল_, _mimd,
   {{0x6f1d15b9,0x6608023a,0x61e30103,0x00000000}},	//   rrsc, _jedk, _ggnl, --,
   {{0xa3ea0429,0x60cd15ba,0x200b15bb,0x320c15bc}},	//   _मला_, _tham, paci_, mady_,
   {{0x320c15bd,0x60cd0af0,0x3d180084,0x6b8d01d7}},	//   lady_, _uham, _फिरे_, tzag,
   {{0x24860221,0xa3ca00a1,0x764315be,0xc8790160}},	// [e10] _mlom_, ळेच_, yeny, _nişa_,
   {{0x78a903fd,0x78bb15bf,0x628601f4,0x248601f7}},	//   _sjev, _skuv, ëkoh, _llom_,
   {{0x78a9029d,0x996715c0,0xbebb00da,0x6f0415c1}},	//   _pjev, штал, rrëd, _zwic,
   {{0x320c15c2,0x764315c3,0x660801ed,0x254700fd}},	//   hady_, weny, _aedk, _ről_,
   {{0x78a9025c,0xa01b033b,0x66080298,0x62980fdb}},	//   _vjev, rhöh, _bedk, _omvo,
   {{0x752315c4,0x7bda0122,0x24860d35,0xa01b02b1}},	//   tunz, _תקשו, _alom_, shöh,
   {{0x32070260,0x248615c5,0x764315c6,0x2bdb0099}},	//   _reny_, _blom_, reny, _मृता,
   {{0x764315c7,0x629815c8,0x78bb0010,0x68e000d8}},	//   seny, _amvo, _ukuv, _gimd,
   {{0x752315c9,0x7aed007a,0x764315ca,0x648702d7}},	//   sunz, nqat, peny, _añic,
   {{0xf674004f,0x75230010,0x68e00298,0x320c00ac}},	//   _والخ, punz, _zimd, gady_,
   {{0x555500e0,0xd00a15cb,0xb80b007c,0x248603d0}},	//   _دپار, лене_, _हजाम_, _flom_,
   {{0x3eb802c9,0xb7bd0043,0x200900af,0x00000000}},	//   wort_, _acţi, _ceai_, --,
   {{0x320705f5,0xd12e0148,0x3eb815cc,0x42d500d4}},	//   _teny_, ومی_, tort_, _ліку,
   {{0x201e15cd,0x248615ce,0x2009009e,0xddde0160}},	//   şti_, _zlom_, _eeai_, _copş,
   {{0xb05b017b,0x2d7e011c,0x3eb815cf,0x80f50037}},	//   mlän, _oćeš_, rort_, _استض,
   {{0x27e002dd,0xb05b15d0,0x3eb815d1,0x6f0415d2}},	//   žini_, llän, sort_, _twic,
   {{0x3eb815d3,0x7c3615d4,0xcb6715d5,0x68e015d6}},	// [e20] port_, rfyr, бате_, _rimd,
   {{0xb05b00a6,0x62810fbc,0xa96a12fd,0x34d30066}},	//   nlän, nklo, лиза_, दगुद,
   {{0x6608008b,0xb05b1173,0xfeba00fd,0x62810345}},	//   _redk, ilän, _لاگت_, iklo,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x68fb0528,0xb05b0ef0,0x00000000,0x00000000}},	//   _čude, klän, --, --,
   {{0xfd650028,0x628102c4,0x248600cd,0x00000000}},	//   _nguồ, jklo, _slom_, --,
   {{0x99860514,0x27e915d7,0x320c15d8,0x5d7a0070}},	//   _الأو, žana_, vady_, טאַק,
   {{0x62810345,0x00000000,0x00000000,0x00000000}},	//   eklo, --, --, --,
   {{0xc44500d1,0x778603fa,0xf3ef0037,0xd20a0409}},	//   زیون_, _улаз, رأي_, лэнд_,
   {{0x326615d9,0x2732002d,0xb05b1173,0xe5a60192}},	//   стив, mân_, glän, _лизи,
   {{0x27320d11,0x320c12ad,0xe3b200b5,0xd25700d8}},	//   lân_, rady_, _کرا_, сцы_,
   {{0x320c15da,0x629d00f7,0x62810345,0x00000000}},	//   sady_, ésor, aklo, --,
   {{0x320c15db,0xdb0f021d,0x937a15dc,0x00000000}},	//   pady_, _excê, _حصار_, --,
   {{0xacf915dd,0xddde0260,0x00000000,0x00000000}},	//   ингу_, _enpō, --, --,
   {{0x403515de,0x273200e9,0x20090160,0x00000000}},	//   _дейс, hân_, _teai_, --,
   {{0xa0a400c9,0xd011042c,0xce3300d1,0xef1f0225}},	//   _најд, _کلک_, _کودک, prü_,
   {{0x3a7515df,0x1eab00f3,0xf09f0310,0x7f4d15e0}},	// [e30] олар, _مادي_, mià_, _usaq,
   {{0x9e0715e1,0xf09f0443,0x99670036,0x2eb407df}},	//   _учил, lià_, йтел, ंकृत,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x50c906bc,0xb0c904e9,0xf09f0392,0x00000000}},	//   रतिष, रतिग, nià_, --,
   {{0xf1050fd1,0x7aed0024,0x628115e2,0xb05b02ee}},	//   _शब्द_, qqat, yklo, ylän,
   {{0x451915e3,0x2ca915e4,0xfdfb021a,0x00000000}},	//   ация_, lnad_, ्रिस_, --,
   {{0x2ca9026e,0x00000000,0x00000000,0x00000000}},	//   onad_, --, --, --,
   {{0x2ca9007c,0x52b3012f,0x833903e6,0xf1c30355}},	//   nnad_, ुत्स, ачот_, _liší_,
   {{0xb05b0ef0,0x2d8c0300,0x649700af,0xf09f0392}},	//   tlän, údez_, nţii, dià_,
   {{0xe29903fa,0x2ca9001e,0x7c2f0345,0x00000000}},	//   рао_, hnad_, _lccr, --,
   {{0xb05b15e5,0xc66800c9,0xe04609c0,0x628115e6}},	//   rlän, _уште_, онни, rklo,
   {{0x628115e7,0x61fc04d4,0xb05b15e8,0x7e6500cc}},	//   sklo, ırla, slän, _anhp,
   {{0xb05b15e9,0x7e770282,0x443d0103,0x00000000}},	//   plän, _boxp, _ibw_, --,
   {{0x7c2f15ea,0x2eb4004e,0x0eba15eb,0x3f8c0035}},	//   _accr, ंकेत, румы_, ądu_,
   {{0x1d0a0214,0xe7fc01c0,0x00000000,0x00000000}},	//   реби_, उँमा_, --, --,
   {{0x90c315de,0x9f5202e9,0x248d15ec,0x2ca915ed}},	//   _обще, _deyò_, nhem_, gnad_,
   {{0xdca30279,0x8af70095,0x2d910036,0x443d0345}},	// [e40] фати, _şəra, azze_, _mbw_,
   {{0xa01b15ee,0x443d15ef,0x2ca915f0,0x6f1600ee}},	//   nkön, _lbw_, anad_, _ivyc,
   {{0x443d0273,0x02b60070,0xdb0601ff,0x57ea083e}},	//   _obw_, קלעך_, _nykö, адем_,
   {{0x442f01ef,0xab2a15f1,0x6d5e005f,0x00000000}},	//   _ncg_, _кома_, _irpa, --,
   {{0x05260083,0x6497002d,0x248d15f2,0xa01b15f3}},	//   _মনের_, cţii, dhem_, kkön,
   {{0x057615f4,0x63a400d8,0x442f0211,0x6d5e15f5}},	//   قاعد, _žino, _acg_, _krpa,
   {{0x442f030d,0x00000000,0x00000000,0x00000000}},	//   _bcg_, --, --, --,
   {{0x69ce15f6,0x442f0211,0x443d15f7,0x684300af}},	//   _izbe, _ccg_, _cbw_, _онса,
   {{0x684301c8,0x926a0dbf,0xe3af006c,0xd7ef0037}},	//   _інфа, арна_, ہری_, _شكل_,
   {{0xa5f703fa,0x2ca00553,0x443d0345,0xd25015f8}},	//   _међу_, hiid_, _ebw_, رنج_,
   {{0xdb0f15f9,0x67220009,0xe3af02fd,0x00000000}},	//   _excè, lroj, فری_, --,
   {{0x248d15fa,0x27e00254,0xb4e6143a,0x490c0246}},	//   chem_, žinu_, पदी_, डीयो_,
   {{0x2ca00103,0x672215fb,0xb4c806bc,0xf09f0310}},	//   diid_, nroj, ोगी_, rià_,
   {{0x62631052,0x9f520260,0x00000000,0x00000000}},	//   _овча, _peyò_, --, --,
   {{0x2d8505d3,0x66cd016f,0xb05b1535,0x628a15fc}},	//   ále_, núka, lläm, _ilfo,
   {{0xbca50037,0x6fd30b7a,0x672215fd,0x6d5e0207}},	//   أمري, _सरपं, kroj, _drpa,
   {{0x7de715fe,0x2d850ce9,0x6d5e15ff,0x2a781600}},	// [e50] _мінд, šle_, _erpa, _borb_,
   {{0x249f02c2,0x67221601,0x2a781602,0xc5e400b5}},	//   zium_, droj, _corb_, _لۓ_,
   {{0x248d1603,0xdcef00ea,0x6aae0a8a,0x00000000}},	//   yhem_, ēdēt, _djbf, --,
   {{0x63ad008a,0x25fd1604,0x228907c0,0x00000000}},	//   _þang, रुनी_, _múka_, --,
   {{0x69ce1605,0xae1f00b1,0x2289148a,0x27e901a0}},	//   _ezbe, _बयान_, _lúka_, žano_,
   {{0x7bda0122,0x442f1606,0x249f0098,0x00000000}},	//   _לקרו, _scg_, wium_, --,
   {{0x070b0026,0xa8a71607,0x20020067,0x67220176}},	//   _सौरव_, _драк, ybki_, aroj,
   {{0x628a1608,0x6722011c,0xddc700a0,0x00000000}},	//   _alfo, broj, rejň, --,
   {{0x7c2d1609,0x248d160a,0x443d0051,0xf5590647}},	//   igar, rhem_, _vbw_, _گلاب_,
   {{0x248d00da,0xa5670bf5,0x7c2d001e,0xc879027d}},	//   shem_, _ودان, hgar, _hoş_,
   {{0x63ad160b,0x648e009e,0xe1f600af,0xe3b00088}},	//   _žand, _bùid, ягэ_, _یره_,
   {{0x2eb609a8,0x628a006c,0xdb0f0815,0x443d01d5}},	//   ृत्त, _elfo, _excé, _ubw_,
   {{0xe28e0b46,0x44f100c9,0x6d5e029d,0xc8790395}},	//   _за_, _há_, _srpa, _moş_,
   {{0x442d160c,0x7c2d160d,0x6449160e,0x228900ee}},	//   lge_, egar, leei, _fúka_,
   {{0x44f1160f,0x2ca001ed,0x672202c4,0x648e0211}},	//   _já_, tiid_, zroj, _fùid,
   {{0x7c2d1610,0xb5fc007a,0xeb9a0009,0x768f0185}},	//   ggar, _anġl, биб_, _høyd,
   {{0x44f11611,0x442d1612,0x20d2004f,0xfbd1006c}},	// [e60] _lá_, ige_, ráid_, ہتے_,
   {{0x7c2d01a6,0x20d20037,0x6d5e1554,0x09b00831}},	//   agar, sáid_, _trpa, _করবা,
   {{0x44f11613,0xd7fa1614,0x7c2d00ac,0xc879037a}},	//   _ná_, бул_, bgar, _boş_,
   {{0x67221615,0xc8791616,0x9f5902d7,0xb05b02ee}},	//   troj, _coş_, casó_, yläm,
   {{0x442d0052,0x27e003ad,0x6d5c053e,0xf0930070}},	//   dge_, äin_, lvra, ענד_,
   {{0x44f11617,0xa96a0610,0x67221618,0x442d1619}},	//   _bá_, _лига_, rroj, ege_,
   {{0xd943161a,0x44f1161b,0x6d5c0a75,0x9c8303ab}},	//   _пери, _cá_, nvra, ščev,
   {{0x44f1161c,0x442d161d,0x26c70528,0xb4c802b4}},	//   _dá_, gge_, alno_, ोगे_,
   {{0x768f03d0,0x00000000,0x00000000,0x00000000}},	//   _bøyd, --, --, --,
   {{0x44f1161e,0xaabe09b1,0x442d161f,0x7c2d1620}},	//   _fá_, ्तिक, age_, zgar,
   {{0x44f10082,0x7c2d1621,0x04461622,0x768f0044}},	//   _gá_, ygar, _нежн, _døyd,
   {{0x6d5c0345,0x78a203ee,0xc87900a8,0x63ad1623}},	//   dvra, niov, _xoş_, _žane,
   {{0x4abe0567,0xaabe0afa,0xb05b00c3,0x44f100d5}},	//   ्ताव, ्ताक, lläk, _zá_,
   {{0x68fc00ea,0x44f102d7,0x2ee5033b,0x00000000}},	//   _otrd, _yá_, ölf_, --,
   {{0x291c006c,0xd23b0122,0xdb1d01c0,0x44f10019}},	//   ával_, _הגול, _vysí, _xá_,
   {{0x7c2d1624,0xd13800c7,0x3e740168,0x3f820118}},	//   ugar, mtą_, _mäty_, byku_,
   {{0x7c2d1625,0x78a211fa,0x64970043,0x2918027a}},	// [e70] rgar, diov, cţiu, _avra_,
   {{0x7c2d0291,0x442d1626,0x6ce700d4,0xd1381627}},	//   sgar, zge_, _німе, otą_,
   {{0x442d11cb,0xd13800d8,0x9f591628,0x00000000}},	//   yge_, ntą_, pasó_, --,
   {{0x44f11629,0x78a2162a,0x6d450132,0xd138010b}},	//   _rá_, giov, _ipha, itą_,
   {{0xb8f4162b,0x44f100fb,0x2d8301c8,0x00000000}},	//   _सी_, _sá_, lyje_, --,
   {{0x44f1162c,0xd13800d8,0x61ea0118,0x00000000}},	//   _pá_, ktą_, _ngfl, --,
   {{0x442d162d,0x2d8300d8,0xe61001b2,0x3f82162e}},	//   tge_, nyje_, اشه_, zyku_,
   {{0x44f1162f,0x442d1630,0x78a20237,0x29011631}},	//   _vá_, uge_, ciov, mpha_,
   {{0x6d45012f,0x44f10023,0x6d5c00cd,0x26c70097}},	//   _lpha, _wá_, zvra, plno_,
   {{0x44f102aa,0x6d451632,0x442d01a6,0x7d1a0334}},	//   _tá_, _opha, sge_, átsk,
   {{0x6d450221,0xbebb0031,0x7ae71633,0x00000000}},	//   _npha, trën, _mijt, --,
   {{0xbe250083,0x8fa600af,0xa06a0274,0x7afd00be}},	//   ম্মদ_, даме, цама_, _otst,
   {{0x6fde00b4,0x7afd0298,0x3ea31634,0xdd9200fd}},	//   _नृशं, _ntst, fijt_, ھور_,
   {{0x68fb1635,0xdd9202fd,0x6d5c1636,0x768f0044}},	//   _čudn, پور_, tvra, _føye,
   {{0xdee31637,0x8db50044,0x7afd1638,0xed5713a1}},	//   тори, есті, _atst, мор_,
   {{0x69da03e6,0x6d5c1639,0x291c00a0,0x27e901a0}},	//   _útei, rvra, ávam_, žanj_,
   {{0x60c4163a,0x68fc02a7,0x7ae7163b,0x6abe163c}},	// [e80] _ikim, _strd, _bijt, topf,
   {{0x68ee0107,0x7bc6163d,0xab5b00b5,0x9a6a00fd}},	//   _pubd, _vyku, _gyüm, غمال_,
   {{0xceb300c2,0xbebb01f4,0x6abe02b1,0x994a0c26}},	//   _ביז_, ytëz, ropf, تلال_,
   {{0x672b163e,0x7aef0160,0xb4b700b8,0x00000000}},	//   fugj, _fuct, चको_, --,
   {{0x78a2163f,0x7afd0051,0x7bc6027d,0x60c408c7}},	//   riov, _gtst, _uyku, _mkim,
   {{0xd1381640,0xa9260d6e,0x3e740168,0x00000000}},	//   ytą_, _одгл, _päty_, --,
   {{0x98a61641,0x250700b5,0x764a016e,0x60c4001c}},	//   _живе, ورٹی_, refy, _okim,
   {{0x7ae70223,0x60c41642,0x3d110387,0x399b024b}},	//   _zijt, _nkim, _तबसे_, _וילד,
   {{0x6b841643,0x98a305ac,0xb05b01ff,0x00000000}},	//   nyig, _рите, släk, --,
   {{0x60c41644,0x3254093e,0xa01b02b1,0x32050b88}},	//   _akim, хвор, rköm, gbly_,
   {{0xb05b0421,0x60f81645,0x6b8404fb,0x40351646}},	//   lläi, яння_, hyig, ненс,
   {{0xd1381647,0x60d6001e,0x42ce0033,0x2d8300c7}},	//   rtą_, _chym, রদেশ, vyje_,
   {{0xd1381648,0x00000000,0x00000000,0x00000000}},	//   stą_, --, --, --,
   {{0x2bd51649,0x60c4164a,0x2d8300d8,0xd13800c7}},	//   _दरबा, _ekim, tyje_, ptą_,
   {{0x7aef0602,0x68fb0169,0x6d58164b,0x7ae701e4}},	//   _suct, _čudo, _švar, _rijt,
   {{0x96140083,0x2d83010b,0x7ae70051,0x8f35002d}},	//   সলিম_, ryje_, _sijt, _зеиц,
   {{0x3f4f0484,0x7ebf00b8,0x92c20033,0x7ae70c8c}},	// [e90] _użu_, tápě, ্দী_, _pijt,
   {{0x2d8300d8,0x6f0d0010,0x2fc90159,0xdddc011c}},	//   pyje_, _iwac, _iyag_, skrš,
   {{0xdc0300d5,0x00000000,0x00000000,0x00000000}},	//   lčík, --, --, --,
   {{0xc87906d0,0x38690f56,0x80d10083,0x69c70187}},	//   _kişi_, ñar_, _সূত্, _vyje,
   {{0x7afd053c,0x59d4164c,0x6b84007b,0xfc3f00b5}},	//   _utst, _थरथर, cyig, _amíg_,
   {{0x2901055c,0x0555164d,0xaa450086,0x6f0d164e}},	//   ppha_, етия, ävää_, _mwac,
   {{0xaabe06d9,0xa2c200ab,0x4abe164f,0x00000000}},	//   ्तरक, रकन्, ्तरव, --,
   {{0xa3ba0bda,0xf992011d,0x00000000,0x00000000}},	//   _आँख_, _ערן_, --, --,
   {{0x27ed1650,0x6442009e,0xdc0300d5,0x60d61651}},	//   _igen_, _dboi, jčík, _rhym,
   {{0x68e91652,0x00000000,0x00000000,0x00000000}},	//   _hied, --, --, --,
   {{0x68e9006a,0x32051653,0x21691654,0x2bcc060a}},	//   _kied, rbly_, чини_, _ार्थ,
   {{0x6f0d01d5,0x22800260,0x037b03fc,0x62881655}},	//   _bwac, _bòks_, _وحشت_, akdo,
   {{0x68e91656,0xe8100380,0x6f0d0103,0x443f023c}},	//   _mied, ारता_, _cwac, mfu_,
   {{0x523900c2,0x443f1657,0x68e90b3c,0x64590487}},	//   _זײַנ, lfu_, _lied, _hawi,
   {{0xfaff01d2,0x64591658,0x7bcb01ae,0x27ed0120}},	//   _atë_, _kawi, ügun, _ogen_,
   {{0x68e91659,0x60c4000e,0x63a401c8,0x6459165a}},	//   _nied, _ukim, _žini, _jawi,
   {{0x6d410723,0x64590054,0x443f0054,0x00000000}},	// [ea0] çlar, _mawi, ifu_, --,
   {{0x27ed1034,0x6459165b,0x00000000,0x00000000}},	//   _agen_, _lawi, --, --,
   {{0x68e9165c,0xd7fa002d,0x35c40084,0xdb1d0bca}},	//   _bied, пул_, _लुढ़, _vysá,
   {{0x7e7e165d,0x6459004e,0xb5fc035f,0xa29f02b4}},	//   _hopp, _nawi, _inġi, गोत्,
   {{0x7e7e165e,0xd7070384,0x175400c3,0xe7c00033}},	//   _kopp, енче_, твля, েশ্য,
   {{0x27ed165f,0x443f05db,0x6459067f,0x68e90345}},	//   _egen_, efu_, _aawi, _eied,
   {{0x80d100c8,0x443f1660,0x7e7e1661,0x6abe1662}},	//   _সংস্, ffu_, _mopp, ्तीर,
   {{0xd4971663,0x7e7e1664,0x645900e0,0x68e91665}},	//   ерь_, _lopp, _cawi, _gied,
   {{0x64591666,0x82a61667,0x7e7e1668,0x00000000}},	//   _dawi, ешне, _oopp, --,
   {{0x68e91669,0x443f166a,0x6f0d01d5,0x3d1100ab}},	//   _zied, afu_, _rwac, _तबले_,
   {{0x13ea00af,0x64420211,0xc5690079,0x00000000}},	//   _емей_, _tboi, _يحمل_, --,
   {{0x64590269,0x6abe166b,0x765a081b,0x92c20033}},	//   _gawi, ्तुर, _haty, ্দে_,
   {{0x765a166c,0x768f03d0,0x6d5800f4,0x00000000}},	//   _katy, _høya, _švap, --,
   {{0x6459004e,0xa6e70023,0x7e7e0dbb,0x2bdb012f}},	//   _zawi, _nhữ, _copp, _मृगा,
   {{0x7e7e166d,0x765a166e,0xa2af143a,0x20d20037}},	//   _dopp, _maty, ुवर्, máin_,
   {{0x765a166f,0x27e90bc6,0x20d20079,0x645900ee}},	//   _laty, žani_, láin_, _xawi,
   {{0x68e91670,0xfaf30a72,0x6abe0026,0x5a350f8c}},	// [eb0] _ried, اثر_, ्तूर, кнат,
   {{0x765a1671,0x68e91672,0x20d20037,0x645b00af}},	//   _naty, _sied, náin_, zdui,
   {{0x68e91673,0x394712c3,0x7cd900af,0x48151583}},	//   _pied, ïns_, _омор_, вмес,
   {{0x20d20514,0xe0df02e9,0x26c50187,0x7e7e1674}},	//   háin_, nmò_, _sklo_, _zopp,
   {{0x68e91675,0x765a0186,0x20d90037,0xe7391676}},	//   _vied, _baty, méid_, фел_,
   {{0x68e91677,0x645901ca,0x945d004e,0x20d90037}},	//   _wied, _sawi, końc, léid_,
   {{0x68e90d36,0x645914d6,0x443f1678,0x20d20037}},	//   _tied, _pawi, tfu_, dáin_,
   {{0x27ed01b4,0x20d90079,0xa564026e,0x672400cd}},	//   _ugen_, néid_, ادون, šija,
   {{0xe2990424,0x645b1679,0x443f167a,0x23db073f}},	//   дап_, rdui, rfu_, मेंद,
   {{0x09e50083,0x6459000e,0x20d20037,0x387f00a5}},	//   _প্যা, _wawi, gáin_, _hour_,
   {{0x81c90b52,0x20120c05,0x443f0010,0x6459167b}},	//   লেন_, _peyi_, pfu_, _tawi,
   {{0x387f1010,0x7e7e167c,0x10a6167d,0xa3ba167e}},	//   _jour_, _sopp, тимн, _आँच_,
   {{0xa4d402ce,0x087602b5,0x047800b5,0x80d10033}},	//   _соці, דערט_, _سلوک_, _সংশ্,
   {{0x9f9e0370,0x387f0260,0xe0df027a,0x20d2104b}},	//   _ação_, _lour_, amò_, cáin_,
   {{0x71640037,0x00000000,0x00000000,0x00000000}},	//   _مايك, --, --, --,
   {{0x09b00083,0xeaed0edf,0x1f6602ee,0x3ceb021d}},	//   _করলা, जदूत_, _аким, _cicv_,
   {{0x7e7e167f,0xf41200c2,0xfce306cd,0x69d51680}},	// [ec0] _topp, יפן_, рото, _azze,
   {{0x386d1681,0x0d861682,0x3ceb0027,0xdee6167d}},	//   _aner_, _алон, _eicv_, _шопи,
   {{0x386d0118,0x649500d5,0x387f0160,0xceb90355}},	//   _bner_, _káid, _bour_, éře_,
   {{0x765a1683,0x387f0248,0x20d90079,0x00000000}},	//   _saty, _cour_, céid_, --,
   {{0x765a00d8,0x69d5006c,0x929d0035,0xb8f91604}},	//   _paty, _ezze, zpła, _ठी_,
   {{0x6f020723,0x6495004f,0xb05b153f,0x386d0168}},	//   _çocu, _láid, llät, _ener_,
   {{0xc60b0083,0x387f0122,0x64b3002d,0xfaa3151c}},	//   _রাখা_, _four_, răin, _таро,
   {{0xd90d00e0,0xb4cc0099,0x00000000,0x00000000}},	//   _ریه_, ळते_, --, --,
   {{0x20d20037,0x765a1684,0xd2500037,0xdc0300ac}},	//   táin_, _taty, منة_, nčák,
   {{0x7c2900ea,0x69da00ac,0x00000000,0x00000000}},	//   _ķerm, _útes, --, --,
   {{0x387f01f3,0x63ad00fb,0x20d21685,0xe1341686}},	//   _your_, _þann, ráin_, ынны,
   {{0x20d20082,0x63a401c8,0x2ebd0fcf,0x44f80176}},	//   sáin_, _žinu, ोत्त, _ié_,
   {{0xe0df07e5,0x20d20079,0x00000000,0x00000000}},	//   rmò_, máil_, --, --,
   {{0x6fe900ea,0x44f81687,0x20d20079,0x2fcd0067}},	//   _rīcī, _ké_, láil_, żego_,
   {{0x44f81688,0x3f8d00f4,0x3ead0207,0x00000000}},	//   _jé_, šeu_, đet_, --,
   {{0x44f80514,0x273b00e8,0x80d10033,0x20d20079}},	//   _mé_, yên_, _সূর্, náil_,
   {{0x44f81689,0x6618168a,0x30840698,0x00000000}},	// [ed0] _lé_, kavk, _خليف, --,
   {{0x20d20082,0x44f80037,0x7e5500d4,0xb05b033b}},	//   háil_, _oé_, _своє, rläu,
   {{0x387f168b,0x44f8168c,0x6618024e,0x2bd50591}},	//   _pour_, _né_, davk, _दरवा,
   {{0xdb1d00c3,0x05b60067,0xb4cc0099,0x00000000}},	//   _pysä, _अख़ब, ळतो_, --,
   {{0xfeb801ca,0x9cd6168d,0x20d2004f,0x23660221}},	//   _سایت_, _תורה_, dáil_, _nroj_,
   {{0x2ca902c7,0x44f8168e,0x2019168f,0x25570095}},	//   liad_, _bé_, hasi_, _hələ_,
   {{0x20191690,0x44f80082,0x387f1691,0x64a51692}},	//   kasi_, _cé_, _tour_, лака,
   {{0x23660537,0x20d20082,0x2ca90297,0x44f80571}},	//   _broj_, gáil_, niad_, _dé_,
   {{0x20191693,0x69da1694,0x6618011c,0x648e009e}},	//   dasi_, _úter, bavk, _tùin,
   {{0x44f81695,0x20190043,0x2ca900e9,0x00000000}},	//   _fé_, easi_, hiad_, --,
   {{0x20190657,0x44f80098,0xa29f00dc,0xe43500b5}},	//   fasi_, _gé_, गोष्, _مفاد,
   {{0x20191696,0x20d2004f,0x672b0031,0x27e900cd}},	//   gasi_, cáil_, orgj, žanu_,
   {{0x32450dc8,0x2ca902c7,0x44f803e6,0x14b200b4}},	//   _белг, diad_, _zé_, ुकरण,
   {{0xed5a0202,0x248d01c0,0xf2070352,0x44f81697}},	//   ног_, lkem_, _рядо, _yé_,
   {{0x2ca9001e,0x20191698,0x2b4b0176,0x5cf500af}},	//   fiad_, basi_, _apcc_, ияту,
   {{0x6abe0311,0x2ca90297,0x7d1c1699,0x39580132}},	//   ्त्र, giad_, rsrs, _rsrs_,
   {{0x7c2b169a,0xab6615eb,0xeb970f08,0xab27020a}},	// [ee0] ógra, ывал, гит_, лота_,
   {{0x248d0006,0x394a012f,0x68f5169b,0xb8650105}},	//   hkem_, _ppbs_, _buzd, یانو,
   {{0xb05b01ae,0x648e009e,0x2ca900e9,0xdca60ea0}},	//   plät, _bùil, biad_, _бани,
   {{0xb05b169c,0x44f8169d,0x648e0211,0x2ca9016e}},	//   llär, _ré_, _cùil, ciad_,
   {{0x44f8169e,0x6618030a,0x248d00b8,0xc60b0033}},	//   _sé_, tavk, dkem_, _রাজা_,
   {{0x44f8169f,0x4ab80569,0x201900ae,0xaab816a0}},	//   _pé_, _आदिव, zasi_, _आदिक,
   {{0x20190ec4,0x20d20082,0x2b4016a1,0x68f50207}},	//   yasi_, táil_, ltic_, _guzd,
   {{0x44f801a5,0x6f0416a2,0x768f0044,0x2b4016a3}},	//   _vé_, _otic, _høyl, otic_,
   {{0x20d20082,0x363616a4,0xb05b02c9,0xe80a02cb}},	//   ráil_, _مراس, klär, _ह्या_,
   {{0x44f816a5,0x68e216a6,0x20d2004f,0x201916a7}},	//   _té_, lmod, sáil_, wasi_,
   {{0x326300d8,0x7aee0036,0x44f80183,0x20d20098}},	//   стыв, _mibt, _ué_, páil_,
   {{0x68e216a8,0x7aee0069,0x6f1d16a9,0x248d16aa}},	//   nmod, _libt, tssc, ckem_,
   {{0xb4c00953,0x236601f4,0xb4c200a1,0x6f0402d7}},	//   ंकी_, _uroj_, ृती_, _ctic,
   {{0x201916ab,0x25630723,0x2ca904fc,0x3eaa033b}},	//   sasi_, _yıl_, wiad_, gibt_,
   {{0x6f0416ac,0xdd940409,0x2ca900e9,0x69ce038d}},	//   _etic, бары, tiad_, _nybe,
   {{0xb05b16ad,0x81ab0033,0xd1380035,0x20191505}},	//   rläs, _খরচ_, rząd_, qasi_,
   {{0x2ca90297,0x68f516ae,0xb5fc0069,0xb05b038e}},	// [ef0] riad_, _suzd, _gaġg, släs,
   {{0x69ce0626,0x2ca9001e,0x8f9c02b5,0xdb1d0168}},	//   _bybe, siad_, _ריזי, _kysú,
   {{0x81e60033,0xb9b502e7,0x2ca916af,0x2b4011f0}},	//   যুর_, جماع, piad_, atic_,
   {{0x21370070,0x764816b0,0x68e216b1,0x69ce08c8}},	//   רטאל_, _abdy, gmod, _dybe,
   {{0x2b4016b2,0x656816b3,0xdc3600c2,0x648e009e}},	//   ctic_, _ardh, _דארט_, _cùim,
   {{0x7aee01ae,0x83fd00b5,0x8af000a8,0xab6600ea}},	//   _gibt, zdőd, rvət, _daļē,
   {{0xd618004f,0x248d16b4,0x291c00b8,0x648e009e}},	//   اتها_, tkem_, ávat_, _tùil,
   {{0x03250896,0x7f4d16b5,0xc48516b6,0x68e2013a}},	//   адин, _opaq, рлик, cmod,
   {{0x656800da,0xc6140083,0x248d16b7,0x527516b8}},	//   _erdh, _সারা_, rkem_, ауну,
   {{0x248d16b9,0x648700de,0x78ab16ba,0x7ea90009}},	//   skem_, _añit, ligv, džpo,
   {{0x26c716bb,0xe0da16bc,0x394116bd,0x6f0416be}},	//   mono_, кво_, nths_, _stic,
   {{0x6f040496,0x6e250014,0x26c716bf,0x4f960336}},	//   _ptic, _adhb, lono_, аргу,
   {{0xe28e16c0,0xa3e916c1,0x7d050037,0xa85600a5}},	//   _да_, _मणि_, _aths, בירה_,
   {{0x91e50faf,0x26c716c2,0x539a00a5,0x60c600d7}},	//   _коле, nono_, _בינו, sokm,
   {{0xb05b0523,0xa2c20d91,0x26c707e5,0x68e216c3}},	//   rlär, रकर्, iono_, ymod,
   {{0x7aee16c4,0xb05b0ef0,0x628316c5,0x26c716c6}},	//   _sibt, slär, _hono, hono_,
   {{0x6f0403fa,0x628316c7,0x26c716c8,0xb05b16c9}},	// [f00] _utic, _kono, kono_, plär,
   {{0x2b4016ca,0x26c700d8,0x68e20051,0x628316cb}},	//   rtic_, jono_, wmod, _jono,
   {{0x2b4016cc,0x26c716cd,0xd83a0409,0x20d903e6}},	//   stic_, dono_, вэл_, léia_,
   {{0x69ce0076,0xb5fc0024,0xddde0260,0xa01b16ce}},	//   _vybe, _maġe, _rapň, lkör,
   {{0x26c716cf,0xbebb00da,0x77690176,0x20d90132}},	//   fono_, rrëv, _crex, néia_,
   {{0x68e2038d,0x628316d0,0x69ce01a7,0x00000000}},	//   smod, _nono, _tybe, --,
   {{0x68e216d1,0xa01b01ff,0x768f0044,0xd5af11c0}},	//   pmod, ljöe, _gøym, وفه_,
   {{0xd7061583,0x776901ed,0x64b2111a,0xb4c00f06}},	//   _взаи, _frex, ुकेश, ंके_,
   {{0x628316d2,0xa2c216d3,0xf74900d1,0x26c716d4}},	//   _bono, रकल्, _مجله_, bono_,
   {{0x628316d5,0x2bde009a,0x26c716d6,0xe5a6059d}},	//   _cono, _मरना, cono_, _кизи,
   {{0x628316d7,0xd48f16d8,0x99f70122,0x7c2616d9}},	//   _dono, _др_, יזיה_, _odkr,
   {{0xdcee00d8,0x75d300d1,0x672d02f6,0xb97b00a5}},	//   mybė, _بيما, šaje, דנטי,
   {{0x628316da,0xe3b203c7,0xbfa813df,0xdcee00c7}},	//   _fono, _برا_, атре_, lybė,
   {{0x628316db,0x6b5d008c,0xef1f0225,0x4426007e}},	//   _gono, _lægå, rsü_, _hdo_,
   {{0x442616dc,0xdcee010b,0x6ca7010b,0xeca70d6e}},	//   _kdo_, nybė, араж, ајан,
   {{0x80d10083,0x26c716dd,0x30150132,0x628316de}},	//   _সংক্, zono_, _удир, _zono,
   {{0x26c707ee,0x394116df,0x60cd16e0,0x6d48027d}},	// [f10] yono_, wths_, _ikam, çdar,
   {{0x996700f0,0x44260183,0x3b0900a8,0xdcee010b}},	//   ител, _ldo_, rpaq_, kybė,
   {{0xd3660796,0x26c701d3,0x44260e9d,0x161a0035}},	//   _که_, vono_, _odo_, _नज़र_,
   {{0xa3cc0066,0x44260054,0x776901dd,0x649c0037}},	//   _शुभ_, _ndo_, _prex, _héif,
   {{0x26c716e1,0xcc76011d,0x60cd002f,0xdb1d008c}},	//   tono_, _הערה_, _mkam, _nysø,
   {{0xc98716e2,0x2bb402e4,0x442616e3,0x60cd0069}},	//   _куби, ंपरा, _ado_, _lkam,
   {{0x09e50b52,0x60cd024e,0x99850082,0x26c716e4}},	//   _প্রা, _okam, _الزو, rono_,
   {{0x442600da,0xa8a41112,0x26c716e5,0xe57016e6}},	//   _cdo_, _друк, sono_, بطه_,
   {{0x26c716e7,0x6b8d16e8,0x442616e9,0x78a916ea}},	//   pono_, nyag, _ddo_, _imev,
   {{0x60cd15c4,0x442603cb,0x80d10083,0xafdb0c61}},	//   _akam, _edo_, _সংগ্, rføl,
   {{0x62830031,0x2c170067,0x442602d7,0xb5a716eb}},	//   _vono, तरां_, _fdo_, _трай,
   {{0x656e0514,0x160b12e7,0x628316ec,0x20d90132}},	//   _ábha, _स्तर_, _wono, téia_,
   {{0x232916ed,0x80d10083,0x443d012f,0xafdb01b4}},	//   _соли_, _সংখ্, _icw_, lføj,
   {{0x629a16ee,0x60cd00d7,0x20d90132,0xb05b01ff}},	//   chto, _ekam, réia_, släp,
   {{0x69a70299,0x753c01ae,0x7c9616ef,0xa01b16f0}},	//   _टेली, _ärzt, брац, rkör,
   {{0x20d90132,0xa92401ba,0xa01b16f1,0xdca3083e}},	//   péia_, _úžit, skör, паси,
   {{0xc9f6004f,0x09e50033,0x5f4600fd,0x00000000}},	// [f20] مساع, _প্লা, _انخل, --,
   {{0xe8100bdd,0x78101343,0x78a9002f,0x2bac00a1}},	//   ार्थ_, ार्क_, _amev, _घेणा,
   {{0x81c90b52,0x443d16f2,0x00000000,0x00000000}},	//   লের_, _ocw_, --, --,
   {{0x6d5e16f3,0xa01b022a,0x443d006d,0x38cb01cb}},	//   _ispa, nköp, _ncw_, هانی_,
   {{0x649c0098,0x78bb16f4,0x6b8d007b,0x00000000}},	//   _héig, _djuv, cyag, --,
   {{0xdcee01c8,0xa01b0086,0x44260031,0xb4c207df}},	//   tybė, hköp, _sdo_, ृत्_,
   {{0xdcfc010b,0x2bac0099,0x26de0051,0xeae416f5}},	//   tyrę, _घेता, _vhto_, कगीत_,
   {{0x69dc03ba,0x442616f6,0x629d0055,0x00000000}},	//   _izre, _qdo_, ëson, --,
   {{0x649c004f,0x57fb0317,0xa3e30026,0xd6d20d93}},	//   _léig, _תלמו, फेल_, _فقر_,
   {{0x60cd16f7,0x6d5e16f8,0x3218016f,0xe7b300b5}},	//   _skam, _ospa, úry_, _عملد,
   {{0x80c5009a,0x672200ea,0x4426021d,0x38cb00b5}},	//   रवले, lsoj, _tdo_, _شاہی_,
   {{0x557700c2,0x661a1246,0x629a00da,0x442616f9}},	//   _לעבן_, _hetk, shto, _udo_,
   {{0x6d5e16fa,0x7e2b00d8,0xeaae0009,0xe819046c}},	//   _aspa, ліва_, kiй_, दरता_,
   {{0x24860221,0xa19412a2,0x0dcb16fb,0x20020a8a}},	//   _hoom_, _малч, губи_, acki_,
   {{0x248601a9,0x321e16fc,0x661a030a,0xdd94004b}},	//   _koom_, maty_, _metk, пары,
   {{0x6d5e16fd,0x60cd16fe,0x6b8d16ff,0x661a1700}},	//   _dspa, _ukam, tyag, _letk,
   {{0x6d5e1701,0xfbd30bdf,0x2486055c,0x3cfa1702}},	// [f30] _espa, ستر_, _moom_, _eupv_,
   {{0x661a029d,0xbebb01f4,0x6b8d007b,0x321e0067}},	//   _netk, rrës, ryag, naty_,
   {{0x2bd50722,0x6f160035,0x290701f4,0x69dc00fe}},	//   _दरका, _zwyc, ëna_, _czre,
   {{0x24860221,0x321e00d5,0x290700ea,0x66cd003e}},	//   _noom_, haty_, īna_, júkr,
   {{0xf1cf0299,0x321e0035,0x661a1703,0x649c0079}},	//   _सुनन, katy_, _betk, _méid,
   {{0xda7b00d8,0x661a1321,0x64950079,0x7bdd1704}},	//   _сям_, _cetk, _cáin, _izsu,
   {{0x24861705,0x78bb15ed,0x7d0200a0,0x321e00d5}},	//   _boom_, _tjuv, _čosk, daty_,
   {{0x62981706,0x25fd0907,0x6722006d,0x649c0312}},	//   _alvo, रुजी_, bsoj, _néid,
   {{0x64950037,0x254e00a8,0x20d90098,0x443d00cc}},	//   _fáin, _cəlb_, téin_, _vcw_,
   {{0x81bd0033,0x321e0067,0x52a900c3,0x31250d54}},	//   _আরব_, gaty_, рвом_, одог,
   {{0x2486006f,0x649c0312,0x6f160067,0x00000000}},	//   _foom_, _béid, _swyc, --,
   {{0x649c004f,0x6d5e012f,0x090e0033,0xf8c900b4}},	//   _réig, _rspa, _হিমু_, िकिय,
   {{0x661a1707,0x649c0341,0x2d850301,0xa01b1708}},	//   _yetk, _déid, älen_, rköp,
   {{0x24861709,0x2169170a,0x6449170b,0xfc3f0310}},	//   _zoom_, _вики_, lfei, _ací_,
   {{0x649c0514,0xf8c9170c,0xed5a01e0,0x71a5081b}},	//   _féid, िकाय, шов_, _файз,
   {{0x6449170d,0x2fc001e8,0x2486006d,0x20d90079}},	//   nfei, _txig_, _xoom_, néil_,
   {{0x6d5e004e,0xbb43170e,0x00000000,0x00000000}},	// [f40] _wspa, метк, --, --,
   {{0x649c004f,0x20d90098,0x00000000,0x00000000}},	//   _téig, héil_, --, --,
   {{0x661a170f,0x6d5e1710,0xf1cf05f8,0xa01b01ff}},	//   _retk, _uspa, _सुमन, ljöa,
   {{0x50ca006a,0x20ca0632,0x661a0761,0x67220421}},	//   रविष, रविध, _setk, tsoj,
   {{0x661a02f6,0x24861711,0x20d90037,0xe8e000e2}},	//   _petk, _room_, déil_, hiệt_,
   {{0x24861712,0x6b8b01ff,0x67221713,0x649c0183}},	//   _soom_, ägge, rsoj, _méie,
   {{0xd49a1714,0x24860639,0x69dc00ea,0x321e0097}},	//   ири_, _poom_, _uzre, vaty_,
   {{0xb1980019,0x734a002d,0x672d1715,0x20d90098}},	//   _ngưỡ, ачов_, šaja, géil_,
   {{0x61ef0095,0x68fc1716,0x649c0037,0x160b0518}},	//   əklə, _hurd, _réid, _स्वर_,
   {{0x68fc1717,0x3866053e,0x649c0098,0x386400fe}},	//   _kurd, ldor_, _séid, _hamr_,
   {{0x321e027e,0x24861718,0xe45a02ce,0x3b001719}},	//   raty_, _toom_, _вже_, hqiq_,
   {{0x68fc171a,0x7658171b,0x92ca0083,0x6d5c00e9}},	//   _murd, levy, লগে_, dwra,
   {{0x61010029,0x3866171c,0x9757016b,0x00000000}},	//   _vēla, idor_, ֿילו_, --,
   {{0x81c90083,0x76580054,0x3326021d,0xbbb40099}},	//   লেই_, nevy, _ivox_, ंपैक,
   {{0xbd68171d,0x009500af,0x6d5c00e5,0x68fc171e}},	//   орте_, _никэ, gwra, _nurd,
   {{0x90c40798,0x00000000,0x00000000,0x00000000}},	//   _обје, --, --, --,
   {{0x1eab004f,0x7bc10035,0x3866171f,0x68fc01ed}},	// [f50] _نادي_, _ślub, ddor_, _aurd,
   {{0x1b040083,0x68fc08cd,0x768f0044,0x2918099e}},	//   _লিখে_, _burd, _høyv, _bwra_,
   {{0x68fc009e,0xad2700d1,0x644900e9,0x20d90079}},	//   _curd, _برخو, yfei, héim_,
   {{0xe8f80560,0x6495004f,0x68fc033e,0x386603d0}},	//   ілі_, _cáil, _durd, gdor_,
   {{0xb9020380,0xcb4400c9,0x64950037,0x0c2400d8}},	//   _नी_, _охри, _dáil, _імён,
   {{0x7afd1720,0x38661721,0x8afa0122,0x9662081b}},	//   _iust, ador_, _להשי, екше,
   {{0xceb400c2,0x6495004f,0x8557064e,0x7afd1722}},	//   ויס_, _fáil, تیار_, _hust,
   {{0x7afd1723,0x7af506a2,0x81c20033,0xe29a055c}},	//   _kust, _hizt, ্ধা_, _alư_,
   {{0x64491724,0xe3b1004f,0x68fc1725,0x00000000}},	//   rfei, عرب_, _zurd, --,
   {{0xe29903fa,0x64491726,0x68fc00c1,0x6d5c1727}},	//   сао_, sfei, _yurd, ywra,
   {{0x68fc0391,0xc22205f5,0x76b20035,0x321c00ee}},	//   _xurd, رکوو, słyc, _devy_,
   {{0x7af50065,0x7b0900a0,0x69d50055,0x00000000}},	//   _lizt, _kľud, _myze, --,
   {{0x7afd01c8,0x3f8f003c,0xbf9b0279,0x00000000}},	//   _nust, _żgur_, scên, --,
   {{0x386600f4,0x91fc0228,0x00000000,0x00000000}},	//   zdor_, ndāl, --, --,
   {{0x7c961728,0x6495004f,0xe7eb1729,0xfce6172a}},	//   прац, _láim, जेता_, зово,
   {{0x249f0370,0xf09f009e,0xa3e200ab,0x6d5c172b}},	//   nhum_, chà_, _धरम_, rwra,
   {{0x7af5172c,0x7afd172d,0x649c0312,0xf1cf018d}},	// [f60] _bizt, _cust, _héic, _सुतन,
   {{0x5cf600af,0x7afd172e,0x64950098,0x00000000}},	//   _няму, _dust, _sáil, --,
   {{0x7afd01d7,0x249f012f,0x68fc00a8,0x7af501ed}},	//   _eust, khum_, _qurd, _dizt,
   {{0x7afd172f,0x68fc1730,0x20d21731,0x69d51732}},	//   _fust, _vurd, máis_, _dyze,
   {{0x68fc0446,0x38661733,0x672d0506,0xe7370012}},	//   _wurd, rdor_, šajn, зеч_,
   {{0x68fc1734,0x386600d7,0x2d8701f7,0x648e009e}},	//   _turd, sdor_, _ànec_, _lùit,
   {{0x7afd1735,0x64950037,0x321c1736,0xddc70067}},	//   _zust, _táil, _revy_, dejś,
   {{0x2ca0067f,0x7afd1737,0x7de7006c,0xf7461738}},	//   nhid_, _yust, lésé, _небо,
   {{0x7afd043f,0x00000000,0x00000000,0x00000000}},	//   _xust, --, --, --,
   {{0xcb1300a5,0x2cbf00f4,0x6d47008d,0x7de700fd}},	//   עלת_, čudi_, ytja, nésé,
   {{0x403508ae,0x648e0284,0x59be052b,0x20d202d7}},	//   менс, _bùit, ्थिर, jáis_,
   {{0x249f1739,0x7bc3002d,0x67240009,0x64a3010b}},	//   chum_, şnui, šiju, _паха,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7afd173a,0x6d47173b,0xddde0009,0xfd130c74}},	//   _rust, ttja, _sopš, فجر_,
   {{0x7afd173c,0x71f70bdf,0x7de7006c,0x20d20453}},	//   _sust, _عروس_, désé, gáis_,
   {{0x6d47173d,0x628a017b,0x9f400065,0x15e100b4}},	//   rtja, _hofo, _egiñ_, गेटर_,
   {{0x6d47173e,0xc6220083,0x7af501d7,0x628a173f}},	// [f70] stja, _নানা_, _pizt, _kofo,
   {{0x7afd1740,0xbd0202d7,0x00000000,0x00000000}},	//   _vust, ñéca, --, --,
   {{0xb5fc0484,0x628a1741,0xc95904a3,0x96220033}},	//   _paġn, _mofo, تلاش_, নলাম_,
   {{0xddde0bec,0x2ca01742,0x20d20037,0x69d501ba}},	//   _uopš, chid_, láir_, _vyze,
   {{0xf7450171,0x7afd018d,0x00000000,0x00000000}},	//   фело, _uust, --, --,
   {{0x628a00ea,0x20d2004f,0x64420042,0x768f01e0}},	//   _nofo, náir_, _acoi, _nøyt,
   {{0x249f0090,0xa8a70009,0x00000000,0x00000000}},	//   thum_, _ерак, --, --,
   {{0x6495004f,0x9f6501ba,0x13091743,0xc21f0324}},	//   _táim, _štýl_, оний_, _मजहब_,
   {{0x249f1744,0x628a1745,0x6f0d0010,0x20d2002a}},	//   rhum_, _bofo, _ntac, záis_,
   {{0x200901ef,0x644212ee,0xaabf0e61,0xd0480095}},	//   _afai_, _ecoi, ्विक, əməy,
   {{0x648e01a6,0xbbba0066,0x610100ea,0x00000000}},	//   _cùis, _इश्क, _vēlo, --,
   {{0x6442004f,0x7de7006c,0x20d20453,0x648e01da}},	//   _gcoi, zésé, váis_, _dùis,
   {{0x628a0132,0x4abf1746,0xaabf022e,0x10a31747}},	//   _fofo, ्वाव, ्वाक, тиян,
   {{0x12fa0122,0x443f1748,0x83fd006c,0x6f0d0037}},	//   _והסב, lgu_, zdől, _dtac,
   {{0x2ca0004a,0x443f1749,0x768f0185,0x00000000}},	//   thid_, ogu_, _høys, --,
   {{0x443f174a,0x20d2004f,0x2ca0046a,0x672900de}},	//   ngu_, ráis_, uhid_, _ovej,
   {{0x7de70332,0x9f4400c3,0xaec6174b,0x443f174c}},	// [f80] tésé, ämä_, _обил, igu_,
   {{0x2ca0174d,0xed5a11d0,0x629d0031,0x6b8b01ff}},	//   shid_, _доо_, ësoh, ägga,
   {{0x443f0a4e,0x610800b8,0xd7fa0043,0x8e7b00a5}},	//   kgu_, _těle, оул_, _וניה,
   {{0x648e01da,0x00000000,0x00000000,0x00000000}},	//   _lùir, --, --, --,
   {{0x7c24174e,0x768f03d0,0x921d00be,0x00000000}},	//   mair, _nøys, फराज_, --,
   {{0x7c24174f,0x64420082,0x443f1750,0x245801a5}},	//   lair, _scoi, egu_, _ẩm_,
   {{0x26ce1751,0xa01b008a,0x645b1752,0xd826052c}},	//   rofo_, fjöl, feui, _одви,
   {{0x7c241753,0x628a1754,0x26ce1755,0x443f1756}},	//   nair, _sofo, sofo_, ggu_,
   {{0x64420023,0x648e0284,0x628a1757,0x00000000}},	//   _vcoi, _bùir, _pofo, --,
   {{0x7c241758,0x628a0024,0x443f0409,0x648e0284}},	//   hair, _qofo, agu_, _cùir,
   {{0x3a371759,0x7c24175a,0x60cf002d,0x6f0d175b}},	//   ורים_, kair, tocm, _stac,
   {{0x78a2175c,0xe7f50066,0x645b175d,0x9f350210}},	//   nhov, ुँचा_, ceui, немі,
   {{0x7c24175e,0x23e200df,0x648e009e,0xb4ca175f}},	//   dair, _परिद, _fùir, लकी_,
   {{0x44241760,0x78a20553,0x768f00d4,0x00000000}},	//   lam_, hhov, _høyr, --,
   {{0x20c71761,0x7c241762,0x78a21763,0xa2cb0067}},	//   _осиг, fair, khov, सकर्,
   {{0x7c24066a,0xa3e204bc,0x64401764,0xfaff0031}},	//   gair, _धरा_, ngmi, _orët_,
   {{0x44241765,0x3b550144,0x6f0d1766,0xba2b104b}},	// [f90] iam_, экар, _utac, قسام_,
   {{0x44241767,0x81c90083,0x443f1768,0xe7d20084}},	//   ham_, লেও_, zgu_, _तड़प,
   {{0x44241769,0x6729176a,0x443f176b,0x3835176c}},	//   kam_, _svej, ygu_, енер,
   {{0x4424176d,0x7c24176e,0xe8c900a1,0x672d0b67}},	//   jam_, cair, िकेच, šajm,
   {{0xfe7000b5,0x00000000,0x00000000,0x00000000}},	//   _صدی_, --, --, --,
   {{0x4519176f,0x81c90033,0x443f0090,0xa01b00b5}},	//   пция_, লেট_, wgu_, gköz,
   {{0x44241770,0xddde0035,0x645b00f7,0x00000000}},	//   fam_, _zapł, teui, --,
   {{0x44241771,0x78a2086d,0xfdf80122,0x443f1772}},	//   gam_, chov, וצות_, ugu_,
   {{0x254e0095,0x645b1773,0x610100ea,0x00000000}},	//   _həll_, reui, _vēlm, --,
   {{0x443f0297,0x2d1f0324,0x236d01b4,0x57780079}},	//   sgu_, _बबूल_, rvej_, _تصفح_,
   {{0x236d01b4,0xa06a15c0,0x00000000,0x00000000}},	//   svej_, пана_, --, --,
   {{0x3cf9012f,0xd11b00b4,0x20050067,0x768f03d0}},	//   _nisv_, भीषण_, ślin_, _tøys,
   {{0x442f1774,0x41cf0246,0x7c2400ea,0x9f4c04d4}},	//   _idg_, _सुरस, vair, _ölüm_,
   {{0x78a2024e,0x7c241775,0xa3b80037,0xade400ab}},	//   zhov, wair, _تامر_, _गरदन_,
   {{0x7c241776,0x649c0312,0x69c700da,0x57dc08b0}},	//   tair, _méin, _nxje, _बर्ह,
   {{0x649c004f,0xa01b006c,0x23ce000c,0xda660118}},	//   _léin, zköz, _हुँद, کاري,
   {{0x7c241777,0x69cb027d,0xfa3600d2,0x60c40024}},	// [fa0] rair, şgel, فراد, _ijim,
   {{0x7c241778,0x4a430dee,0xd00f00f8,0xfaff0c6f}},	//   sair, лнув, _پلی_, _arës_,
   {{0x44241779,0x442f177a,0xf2960070,0x7c24177b}},	//   yam_, _odg_, עכער_, pair,
   {{0xafdb177c,0x4424177d,0xaca800b5,0xb05b033b}},	//   mfør, xam_, _کھڑے_, mnäc,
   {{0xe80f0084,0x78a2177e,0xa01b006c,0xaabf00b4}},	//   ाड़ा_, rhov, tköz, ्वशक,
   {{0x4424177f,0x78a21780,0xfaff0055,0x6101013a}},	//   wam_, shov, _erës_, _cēlk,
   {{0xb7bd002d,0x78a2013c,0x4abf021a,0xafdb1781}},	//   _reţe, phov, ्वरव, nfør,
   {{0x60c40496,0xb4ca1782,0x2a6a0024,0x18671783}},	//   _njim, लके_, _habb_, _паси_,
   {{0x64400006,0xe7370896,0x442f01f7,0x98a31784}},	//   rgmi, _пет_, _ddg_, _сите,
   {{0x44241785,0x649c0098,0x60d600ee,0x442f1786}},	//   sam_, _géin, _akym, _edg_,
   {{0xa2a600b4,0x648e009e,0x610800fe,0x3cf308b0}},	//   टोग्, _fùip, _běla, ंगमे_,
   {{0x395800e7,0xafdb10db,0x44241787,0x2a6a0d3e}},	//   _mprs_, dfør, qam_, _labb_,
   {{0x610801c0,0x2d8c1788,0x4477016b,0xb5fc009f}},	//   _děla, äden_, _רעדל_, _raġj,
   {{0x62340043,0xd36f00f8,0x60c4005f,0x00000000}},	//   _реку, _دهه_, _ejim, --,
   {{0xafdb082b,0x7c2f0027,0x00000000,0x00000000}},	//   gfør, _pdcr, --, --,
   {{0x11db0122,0x213e1789,0x225e011e,0x60c4178a}},	//   _מחוב, muth_, letk_, _gjim,
   {{0x213e14d8,0x6fb901e0,0x6ad90033,0x00000000}},	// [fb0] luth_, _ігор_, _ভূগো, --,
   {{0x629a178b,0x60dd038d,0xa9c70171,0x2ebe178c}},	//   nkto, llsm, нсек, ोवृत,
   {{0x649c178d,0xb8120033,0x2bd1018d,0x200b0036}},	//   _réin, _হয়ত_, _थुरा, occi_,
   {{0xb4ca0311,0x4c95095d,0x893407f8,0x00000000}},	//   लको_, _римс, اعلا, --,
   {{0x649c0037,0x442f007b,0x36690226,0x00000000}},	//   _péin, _rdg_, дало_, --,
   {{0x38690528,0x442f009e,0x368b083e,0x6e270e5e}},	//   žar_, _sdg_, ясен_, najb,
   {{0x6abf07b3,0x442f0fce,0x64a5178e,0x1958037c}},	//   ्वीर, _pdg_, кака, _пары_,
   {{0x29110065,0xd1381627,0xdce500f4,0x25ba178f}},	//   _itza_, drą_, _drhć, úpla_,
   {{0x3a230009,0xc48202ee,0x2a6a02ee,0x29031790}},	//   _kejp_, рлык, _yabb_, _huja_,
   {{0x2903000e,0x60d61791,0x649c0079,0xb92800e2}},	//   _kuja_, _skym, _héil, _nhuệ_,
   {{0xa0a61792,0x442f0176,0x10a600d4,0x6e271793}},	//   ванд, _tdg_, винн, dajb,
   {{0x92c30083,0x442f1794,0x29031795,0x4096136c}},	//   ্ষে_, _udg_, _muja_, трот,
   {{0x29030c06,0x6f6300d8,0x68fb0015,0x68e91796}},	//   _luja_, авяз, _miud, _mhed,
   {{0x76431201,0xed5a1797,0x68fb010b,0x200b027a}},	//   ngny, мог_, _liud, acci_,
   {{0x63a91798,0x29031799,0x59d0073f,0x60c40107}},	//   lzen, _nuja_, _तुंर, _tjim,
   {{0xafdb03db,0x6fb60037,0x27ff179a,0x649c0098}},	//   rfør, _لمعا, _ngun_, _néil,
   {{0x63a9179b,0xafdb11cb,0x2a6a0024,0xab27179c}},	// [fc0] nzen, sfør, _pabb_, кота_,
   {{0x63a913ee,0x68e9179d,0x68fb0069,0x27ff0118}},	//   izen, _ahed, _aiud, _agun_,
   {{0x6cc606d8,0x68e9009e,0x29030279,0x68fb010b}},	//   _айна, _bhed, _cuja_, _biud,
   {{0x68fb179e,0x649c0037,0x6f04002f,0x779400d1}},	//   _ciud, _céil, _kuic, هیزا,
   {{0x6d4e179f,0x649c0037,0x68e917a0,0x2d9800b5}},	//   ltba, _déil, _dhed, lyre_,
   {{0x63a917a1,0x27ff03cb,0x6d4e0345,0x6f040098}},	//   dzen, _egun_, otba, _muic,
   {{0x649c004f,0x2d9817a2,0x684617a3,0xb5fc035f}},	//   _féil, nyre_, _инва, _jaġi,
   {{0x68fb01d3,0x68e917a4,0x7afc17a5,0x3eb817a6}},	//   _giud, _ghed, _hirt, hirt_,
   {{0x69dc17a7,0x6f040160,0x6d4e17a8,0x44f71301}},	//   _hyre, _nuic, htba, خروج_,
   {{0x7afc007a,0xd13817a9,0x6d4e0532,0x61080355}},	//   _jirt, trą_, ktba, _děln,
   {{0x2d980031,0x63a901ed,0x6d4e0051,0x7afc08a3}},	//   jyre_, azen, jtba, _mirt,
   {{0x6f04004f,0x69dc17aa,0x213e006b,0x2366006d}},	//   _buic, _myre, ruth_, _tsoj_,
   {{0x63a90755,0x7afc09c3,0x6d4e17ab,0x6f040069}},	//   czen, _oirt, etba, _cuic,
   {{0x6f0417ac,0xf77300a5,0x6d4e06c6,0x00000000}},	//   _duic, בקש_, ftba, --,
   {{0x6fd30035,0xb5fc035f,0x69dc17ad,0x5c07021f}},	//   _धुरं, _baġi, _nyre, вяза,
   {{0x7afc0082,0x3eb80094,0x672d00ea,0x2fc9006d}},	//   _airt, airt_, šaji, _txag_,
   {{0x649c004f,0x7afc17ae,0x68e9001e,0x6f0417af}},	// [fd0] _réil, _birt, _rhed, _guic,
   {{0x68e917b0,0x290317b1,0x64950037,0x69dc17b2}},	//   _shed, _puja_, _háit, _byre,
   {{0xdd95081b,0x69dc17b3,0x63a917b4,0x68e9016e}},	//   _саны, _cyre, zzen, _phed,
   {{0x69dc17b5,0xf8d100c8,0x7afc05b9,0x20d917b6}},	//   _dyre, িষ্ঠ, _eirt, méis_,
   {{0xab8417b7,0x649c0037,0x68fb17b8,0x610100ea}},	//   _курк, _céim, _viud, _vēli,
   {{0xf77000d2,0x64950082,0x4aa700c0,0x0dba006c}},	//   غان_, _láit, _गतिव, _آئیں_,
   {{0x68e917b9,0x20d917ba,0x6fd50026,0xb8120033}},	//   _thed, néis_, _युसू, _হযরত_,
   {{0x2005004e,0x63a917bb,0x764800d7,0x7bdd01ba}},	//   ślij_, tzen, _ecdy, _kysu,
   {{0xe89400c3,0x69dc0055,0x659306fe,0x61080355}},	//   _тать, _zyre, _běhá, _bělo,
   {{0x63a917bc,0x454517bd,0x6f04009e,0x386d0312}},	//   rzen, _منطق, _ruic, _haer_,
   {{0x63a917be,0x386d0553,0x20d902d7,0x6d4e0282}},	//   szen, _kaer_, jéis_, xtba,
   {{0x20d917bf,0x237506c9,0x71a2010b,0x386d03d0}},	//   déis_, _ماتح, саюз, _jaer_,
   {{0x6f0417c0,0x386d0032,0x6e25013b,0xd12e00e0}},	//   _quic, _maer_, _behb, يمی_,
   {{0x2d9803b4,0x386d053e,0x6d4e17c1,0x332d0479}},	//   tyre_, _laer_, ttba, msex_,
   {{0xed5709eb,0x09be00c8,0x6da317c2,0x2d9e0237}},	//   лор_, _অর্থ, бира, áte_,
   {{0x6f0417c3,0x09e20033,0x7d0500e0,0x7bdd00e5}},	//   _tuic, _বললা, _duhs, _bysu,
   {{0x2d9e17c4,0x09be0931,0x7afc17c5,0x3eb801f4}},	// [fe0] šte_, ्थ्य, _pirt, pirt_,
   {{0x649c004f,0x20d917c6,0x0e6617c7,0x0d8617c8}},	//   _réim, béis_, _скон, _блон,
   {{0x386d0526,0x20d900de,0xddde00ea,0x649c0079}},	//   _baer_, céis_, _sapņ, _séim,
   {{0x7afc17c9,0x386d17ca,0x20d90037,0x64950037}},	//   _wirt, _caer_, léir_, _máis,
   {{0x7afc17cb,0x386d00e5,0x2b400176,0x69dc17cc}},	//   _tirt, _daer_, quic_, _wyre,
   {{0x356a141d,0xe94400f8,0x7afc0037,0x20d9004f}},	//   ерин_, _پرسی, _uirt, néir_,
   {{0x2aa40332,0x64950082,0x7c2607d4,0x776901ef}},	//   _több_, _náis, _kekr, _esex,
   {{0x386d016e,0xa01b17cd,0xb97b076b,0x297b016b}},	//   _gaer_, ljöv, _אנלי, _אטלא,
   {{0x6495004f,0x5c370070,0xae0400b4,0x7c2617ce}},	//   _ráit, ארפן_, लशान_, _mekr,
   {{0x59b80162,0x4154107a,0x7c2617cf,0x326617d0}},	//   _आधार, авос, _lekr, утив,
   {{0x6e2501d6,0xdd120095,0xba570070,0x5bc1046c}},	//   _rehb, _rüşv, נסטו_, _एश्व,
   {{0x7c2617d1,0x629d01f4,0x7d05027d,0x00000000}},	//   _nekr, ësor, _ruhs, --,
   {{0xe29a17d2,0xe0df027a,0x61080355,0x91fc00ea}},	//   _пад_, rlò_, _tělo, edāt,
   {{0x20d917d3,0x4ea705d8,0x44260019,0x7bdd0035}},	//   téis_, урма, _heo_, _rysu,
   {{0x7c260e45,0x442617d4,0x254e00a8,0x6e2517d5}},	//   _bekr, _keo_, _bəli_, _vehb,
   {{0x6495004f,0x20d917d6,0x44260506,0x3ce001cf}},	//   _háir, réis_, _jeo_, gliv_,
   {{0x7c2617d7,0x442617d8,0x20d917d9,0x2d8c01cf}},	// [ff0] _dekr, _meo_, séis_, øder_,
   {{0x442617da,0x20d917db,0x39a717dc,0x7bdd0097}},	//   _leo_, péis_, лшев, _vysu,
   {{0x64950037,0x7c260024,0x386d01f7,0xb5fc0024}},	//   _máir, _fekr, _paer_, _kaġu,
   {{0x4426004a,0x7c260136,0xddde01c0,0xb4c0000c}},	//   _neo_, _gekr, _např, ूको_,
   {{0xd3660796,0xddd701c2,0x2ca9004f,0x00000000}},	//   _به_, _yaxş, mhad_, --,
   {{0xd1260037,0x2ca90024,0x4426010d,0x9a8702a4}},	//   _وم_, lhad_, _aeo_, _сумл,
   {{0x442617dd,0x1ddb021a,0x00000000,0x00000000}},	//   _beo_, _मुमत, --, --,
   {{0xf1cf167e,0x44260f00,0xa4230831,0x00000000}},	//   _सुगन, _ceo_, ফল্য_, --,
   {{0x442617de,0xd05d0095,0x730500ed,0x64950079}},	//   _deo_, _üzər, јпоз, _báir,
   {{0x64950037,0xe29903fa,0x332d081c,0x7eab02b1}},	//   _páis, тао_, rsex_, _hüpf,
   {{0x008617df,0x44261725,0x91e517e0,0x067a0317}},	//   ално, _feo_, роне, _שנעל,
   {{0x2c150785,0x672d011c,0x00000000,0x00000000}},	//   _फ्लू_, šaju, --, --,
   {{0x81bd00c8,0x249f011e,0x20d90079,0x6459007b}},	//   _আরও_, mkum_, téir_, _ibwi,
   {{0xe29614a9,0x03a20036,0x249f05ee,0x64950037}},	//   _ваш_, _фишо, lkum_, _gáir,
   {{0x20d9004f,0x44260159,0x8cb617e1,0x3ce010fa}},	//   réir_, _yeo_, асач, tliv_,
   {{0x248d0496,0x44260391,0x2ca917e2,0x64ba0484}},	//   njem_, _xeo_, ghad_, nċip,

   {{0x3b0717e3,0x249f17e4,0x3b86005f,0x20d90079}},	// [1000] ието_, ikum_, шлаг, péir_,
   {{0x3ce00307,0x249f05f9,0x248d08c8,0x3f8f021d}},	//   sliv_, hkum_, hjem_, _àgua_,
   {{0x249f17e5,0x7c2601d6,0xb4f70d1f,0x186a11cd}},	//   kkum_, _tekr, ुदाय_, кажи_,
   {{0x315600c2,0x6d5e035f,0x2ca90014,0x248d0484}},	//   ייען_, _ippa, chad_, jjem_,
   {{0x248d17e6,0x91fc0029,0x00000000,0x00000000}},	//   djem_, ndār, --, --,
   {{0x442617e7,0x645917e8,0xfaa6075c,0x249f0051}},	//   _seo_, _abwi, _таго, ekum_,
   {{0x442617e9,0x26c000f4,0x8af0013b,0xfc3f07c0}},	//   _peo_, đio_, ttəf, _ulíc_,
   {{0xd7660332,0x248d0031,0x61130160,0xd4970421}},	//   _پارٹ, gjem_, _măld, иры_,
   {{0x64950082,0x442617ea,0xf2c60009,0xb5fc003c}},	//   _páir, _veo_, исон, _raġu,
   {{0x6d5e17eb,0x68e217ec,0x248d0207,0xd25701e0}},	//   _oppa, llod, ajem_, ацю_,
   {{0x442617ed,0x672d17ee,0x64a617ef,0x6913007a}},	//   _teo_, šajt, _кажа, _għed,
   {{0x644b011e,0x249f17f0,0xd83f053d,0xd13000b5}},	//   _gcgi, ckum_, _účtu_, _ہمت_,
   {{0x64950082,0x6d5e0dc5,0x58f70070,0x00000000}},	//   _táir, _appa, ימטע_, --,
   {{0xd0650095,0x539b00a5,0x3ea500b5,0x6101013a}},	//   _əsər, _בידו, ólt_, _cēls,
   {{0xdd980009,0x2ca901a6,0x3cf317f1,0x611300af}},	//   ашт_, thad_, ंगले_, _căld,
   {{0x76b20035,0xbd440037,0x00000000,0x00000000}},	//   pływ, تنفي, --, --,
   {{0x90a70493,0x2ca917f2,0x5a3502fb,0xb6030097}},	// [1010] _محکم, rhad_, йнат, áško,
   {{0xda780086,0x2ca917f3,0x657a17f4,0x249f0355}},	//   иях_, shad_, _orth, zkum_,
   {{0xceb2012b,0x83fd006c,0x249f17f5,0x7b090168}},	//   _זיי_, ndőr, ykum_, _kľuk,
   {{0x68e217f6,0x0a5505f5,0x00000000,0x00000000}},	//   glod, _گھرج, --, --,
   {{0x7c2d17f7,0xfc3f002a,0x291a0714,0x6d4105ee}},	//   maar, _glía_, appa_, álaf,
   {{0x7c2d0276,0x7b3d0139,0x00000000,0x00000000}},	//   laar, _căuş, --, --,
   {{0x63721505,0x248d008b,0x6d9e035f,0xd57517f8}},	//   yınç, tjem_, _għaġ, суль,
   {{0x58d417f9,0x7c2d17fa,0xc4850d6e,0x64950079}},	//   _дост, naar, слик, _cáip,
   {{0xf7730148,0x248d17fb,0x657a001e,0x249f0093}},	//   _باز_, rjem_, _erth, rkum_,
   {{0x249f17fc,0xd5bb00af,0x248d0a66,0x777b01ed}},	//   skum_, _исе_, sjem_, _irux,
   {{0x7c2d17fd,0x6f1617fe,0xfa98016b,0x00000000}},	//   kaar, _styc, ידזש_, --,
   {{0x64590232,0x7c2d17ff,0x777b0282,0x00000000}},	//   _ubwi, jaar, _krux, --,
   {{0x442d1800,0x7c2d1801,0xe28e0043,0xf45608cf}},	//   mae_, daar, _еа_, _طلوع_,
   {{0x442d1802,0x64491803,0xd8390107,0xc7d61804}},	//   lae_, lgei, _blōk_, מורי_,
   {{0x7c2d1805,0x6da30ece,0xf1cf112b,0xada31102}},	//   faar, пира, _सुचन, парл,
   {{0x7c2d1806,0x442d1807,0xdd8f0e6b,0x00000000}},	//   gaar, nae_, روق_, --,
   {{0x09b500c8,0xbebb00da,0x7e9a0a72,0x00000000}},	// [1020] _জুলা, rsër, _منظر_, --,
   {{0xe3a70332,0x442d1808,0x2ca000c4,0xe7db0387}},	//   _ہر_, hae_, skid_, _बड़प,
   {{0x9e7b02b5,0x7c2d11c9,0x6d5e1809,0x442d04be}},	//   _ענטפ, baar, _uppa, kae_,
   {{0x6c86180a,0x6e2e180b,0x442d0088,0xe3a7083a}},	//   _الحم, labb, jae_, _فر_,
   {{0x628311cc,0x777b01ef,0xddd50355,0xb8d00387}},	//   _onno, _crux, dezř, _ओत_,
   {{0x68e2180c,0xcd290ef5,0x5693059d,0x6e2e180d}},	//   slod, _حسین_, зашт, nabb,
   {{0x2b400815,0x64950037,0xb9960037,0x00000000}},	//   lric_, _páip, _الزب, --,
   {{0x6283180e,0x6e2e180f,0x290a011e,0x5fc800a9}},	//   _anno, habb, _iuba_, रपाल,
   {{0xdc9b00c2,0x213e0297,0x78a20187,0x657a001e}},	//   טיקל, wrth_, mkov, _wrth,
   {{0x290a1810,0x78a21811,0x6e2e1812,0x7c2d030d}},	//   _kuba_, lkov, jabb, zaar,
   {{0x290a0006,0x442d0269,0xd48f1813,0x867b0122}},	//   _juba_, bae_, _ер_, _תרבו,
   {{0x442d1814,0x6283018e,0x7d1c0097,0x290a1815}},	//   cae_, _enno, dprs, _muba_,
   {{0x7c2d1816,0x2bd80992,0x43941817,0x6e2e1818}},	//   vaar, _भुला, _фалс, fabb,
   {{0x29181819,0x7c2d0a45,0xa01b0093,0xe33700a5}},	//   _otra_, waar, gjör, _פרופ_,
   {{0x7c2d181a,0x8af00095,0x6ca700d4,0x2a710009}},	//   taar, ktəb, браж, _razb_,
   {{0x2b40053f,0xfc3f008d,0x00000000,0x00000000}},	//   fric_, _elín_, --, --,
   {{0x7c2d181b,0x78a2024e,0x2918099e,0x6e2e003c}},	// [1030] raar, dkov, _atra_, babb,
   {{0x7c2d181c,0xff50004f,0x290a181d,0x442d034d}},	//   saar, _أخي_, _buba_, zae_,
   {{0x290a181e,0x2918181f,0x78a21550,0x6d410079}},	//   _cuba_, _ctra_, fkov, álad,
   {{0x6d470805,0xec6b07b0,0xfc3f00b8,0x26cc023a}},	//   muja, _срок_, _zlín_, _ajdo_,
   {{0x6d5503cb,0x442d023c,0x60cd08c7,0x290a1820}},	//   ltza, vae_, _mjam, _euba_,
   {{0x442d0858,0x29071821,0x78a20168,0x2bc601c0}},	//   wae_, ínas_, akov, लपरा,
   {{0x6d5503cb,0x290a1822,0x78a20187,0x6d471823}},	//   ntza, _guba_, bkov, nuja,
   {{0x78a21824,0x67d50185,0x6d5506a2,0x60cd1825}},	//   ckov, _добу, itza, _njam,
   {{0x442d1826,0x98680332,0x290a1827,0x6d4711e7}},	//   rae_, _دینے_, _zuba_, huja,
   {{0xadf9045c,0x27ed01d7,0x64491828,0x60cd1829}},	//   ंधान_, _izen_, sgei, _ajam,
   {{0x208a02fb,0x6f1d0051,0x61130395,0x71b50421}},	//   айни_, epsc, _sălb, ющих,
   {{0x25d60779,0x6d47016f,0x3eba022e,0x6abe0371}},	//   _ווען_, duja, _smpt_, zipf,
   {{0x6e2e035f,0x60cd182a,0x78a9182b,0x61130139}},	//   tabb, _djam, _mlev, _bălc,
   {{0x78a9182c,0x6283182d,0x78a20187,0x224e0009}},	//   _llev, _unno, zkov, _gcfk_,
   {{0x6e2e182e,0x78a9066e,0xde0302ce,0x7c96182f}},	//   rabb, _olev, дпри, орац,
   {{0x290a1830,0x6e2e00b5,0x2b401831,0x8b260c46}},	//   _ruba_, sabb, tric_, ждае,
   {{0x78a200ac,0x6d5506a2,0x7eab01d6,0x765c008a}},	// [1040] vkov, atza, _süpe, _öryg,
   {{0x6d471832,0x2b400024,0x78a91833,0x61e30093}},	//   buja, rric_, _alev, _kynl,
   {{0x78a90022,0x656101e8,0x2d78011c,0xe96a150d}},	//   _blev, _nplh, _uče_, раел_,
   {{0x290a0010,0x80370070,0x13e10033,0xbb1b099e}},	//   _vuba_, ַנצע_, মেয়, _brîd,
   {{0x8af000a8,0x61e30b3e,0x236f034d,0x00000000}},	//   rtəb, _lynl, _nsgj_, --,
   {{0x78a21834,0x649c004f,0x7b091835,0x290a1836}},	//   skov, _léit, _džud, _tuba_,
   {{0x98a61837,0x27ed1838,0x78a91839,0xb8660427}},	//   _диве, _ezen_, _flev, _وارو,
   {{0x78a901f7,0xd91b011d,0x00000000,0x00000000}},	//   _glev, _כולל, --, --,
   {{0xccf30bed,0x316e00ee,0x00000000,0x00000000}},	//   וכה_, _ssfz_, --, --,
   {{0x60cd183a,0x78a906fe,0xc178010b,0x2904034d}},	//   _sjam, _zlev, tvė_, _hima_,
   {{0x61e302c7,0x290408c7,0x649c0079,0x52aa0387}},	//   _cynl, _kima_, _béit, _छतीस,
   {{0x7413183b,0x29040116,0x61130160,0x61e3099e}},	//   _قوما, _jima_, _sălc, _dynl,
   {{0x2486183c,0x78fb025a,0x649c183d,0x00000000}},	//   _inom_, יפטו, _déit, --,
   {{0x26dc05e2,0x6d47183e,0x00000000,0x00000000}},	//   novo_, tuja, --, --,
   {{0x61e3001e,0x361b0070,0xdcbb01d3,0x00000000}},	//   _gynl, שולד, аща_, --,
   {{0x5b15183f,0x290402c6,0x6d550291,0x62981840}},	//   змат, _nima_, rtza, _hovo,
   {{0x248603fd,0x62981841,0x63a00bca,0x6d551167}},	// [1050] _mnom_, _kovo, nymn, stza,
   {{0x62981842,0x78a901c0,0x6d471843,0x60dd1844}},	//   _jovo, _slev, puja, losm,
   {{0x29041845,0x24860254,0x26dc1846,0x89d9004f}},	//   _bima_, _onom_, dovo_, حوار_,
   {{0xf7710082,0x62980081,0x2904031a,0x6f0d000e}},	//   فات_, _lovo, _cima_, _kuac,
   {{0x7c220b4c,0x78a90355,0x0a6b0274,0x61130160}},	//   ñore, _vlev, _крви_, _măla,
   {{0xd6db1847,0x26dc1848,0x2486027c,0x6f0d1849}},	//   ште_, govo_, _anom_, _muac,
   {{0x6f0d009c,0x29040207,0x170500b5,0xa95401e0}},	//   _luac, _fima_, _کہتی_, _окрі,
   {{0x78bb0010,0x27ed01d7,0x2009184a,0x2904184b}},	//   _umuv, _tzen_, _ngai_, _gima_,
   {{0x6f0d0082,0x649c004f,0xf770006c,0x62981499}},	//   _nuac, _réit, _لال_, _bovo,
   {{0xd2a90086,0x6298184c,0x649c184d,0x248600f8}},	//   ское_, _covo, _béis, _enom_,
   {{0x6298184e,0x2b4902d7,0x6729009f,0x61130395}},	//   _dovo, huac_, _hwej, _băla,
   {{0x92cb0083,0x6f0d184f,0x61130139,0x649c0098}},	//   লতে_, _buac, _căla, _déis,
   {{0x61fe0076,0x6f0d1850,0x7ea200f7,0xb7bd0139}},	//   _úpln, _cuac, _hôpi, _beţi,
   {{0x62981851,0x523902b5,0x59bd052f,0xe3b00609}},	//   _govo, _הײַנ, ्पार, _جرم_,
   {{0xf3f9002d,0xb7bd002d,0x649c183d,0x610800fe}},	//   deţi_, _deţi, _géis, _bělu,
   {{0x649c004f,0x6ab40066,0x26dc1852,0x236d0035}},	//   _héir, ंफ्र, zovo_, owej_,
   {{0x6b631853,0x7b090409,0x69c30042,0x00000000}},	// [1060] нкта, _ažub, únen, --,
   {{0x6d410082,0x29041854,0xf3f900af,0x2cab00e0}},	//   álac, _sima_, geţi_, _elcd_,
   {{0xfe9b02b5,0x5e9b00a5,0x29041855,0x7e9b00a5}},	//   _היימ, _הביק, _pima_, _הסיו,
   {{0x649c0082,0xa2bb1856,0x7b090693,0x67291857}},	//   _léir, षोत्, _džub, _bwej,
   {{0x7c241642,0x26dc1851,0x66e61858,0x7eab018d}},	//   mbir, tovo_, пода, _hüpa,
   {{0x7c241859,0xb6030187,0xf3f9002d,0xd65e005f}},	//   lbir, _otáč, ceţi_, _мiнд,
   {{0x7d06185a,0x2904185b,0x24860009,0x6298185c}},	//   _kiks, _tima_, _pnom_, _rovo,
   {{0x7c24185d,0x649c0341,0x629802a7,0x7d06003c}},	//   nbir, _réis, _sovo, _jiks,
   {{0x629815d8,0x7d06185e,0x26dc02c4,0xe646185f}},	//   _povo, _miks, povo_, _неап,
   {{0x7d061860,0x649c1861,0x0bb700a5,0x2cfa111a}},	//   _liks, _céir, פלים_, ्दुल_,
   {{0x7c241862,0xb7bd00af,0x649c0098,0x6f0d1863}},	//   kbir, _reţi, _déir, _suac,
   {{0x7d061864,0x75d30037,0x2486043d,0x629802b1}},	//   _niks, _ثيما, _unom_, _wovo,
   {{0x7c241865,0x6298008b,0x6f0d1866,0xdfdb02fb}},	//   dbir, _tovo, _quac, сън_,
   {{0xd24f004f,0xdb23006c,0x7c241867,0xb60300ee}},	//   _منه_, ہوری, ebir, _ftáč,
   {{0xa2d90803,0x7d061868,0x51860368,0x3f80005f}},	//   नकर्, _biks, _хула, _eriu_,
   {{0x4424012f,0x6f0d1869,0x2a7f0225,0x00000000}},	//   nbm_, _tuac, _şub_, --,
   {{0x2d8c186a,0x7d06186b,0xddde00a8,0xf3f90043}},	// [1070] äder_, _diks, _tapş, teţi_,
   {{0xa577012e,0xed4e00b5,0x7c24018e,0x0dcb186c}},	//   ščić, دھی_, abir, _гуми_,
   {{0x7c24186d,0xa907186e,0x00000000,0x00000000}},	//   bbir, سبان, --, --,
   {{0xe9f801e0,0x00000000,0x00000000,0x00000000}},	//   їнці_, --, --, --,
   {{0x3b640021,0x6913007a,0x00000000,0x00000000}},	//   _първ, _għen, --, --,
   {{0x644700d8,0x4519186f,0x3ce901e9,0x00000000}},	//   ėjim, оция_, llav_, --,
   {{0x2d571870,0x7e771871,0x67240029,0x7c2f1872}},	//   nçe_, _maxp, ģija, _kecr,
   {{0xc95200a5,0x8af000a8,0x2d81023a,0x031900e0}},	//   _שמן_, ntən, _mrhe_, يتخت_,
   {{0x2d5701d6,0x645b009e,0x649c0079,0xfc3f00fe}},	//   hçe_, rfui, _péir, _alík_,
   {{0x2d57027d,0x3ce900d5,0x99910116,0x957c0067}},	//   kçe_, hlav_, _zdzš_, _cząs,
   {{0x3ce902d0,0x904600bf,0xa06a1873,0x9f49021d}},	//   klav_, ونده, оана_, _dzaí_,
   {{0xcea914b0,0x7c2f1874,0x7c24013b,0x3f800c6f}},	//   _די_, _necr, xbir, _priu_,
   {{0x7d061875,0x442f00ee,0x610800fe,0xe2a800e0}},	//   _riks, _ieg_, _běls, زاین_,
   {{0x7d061876,0x442f1877,0xc332025a,0xa1c501e0}},	//   _siks, _heg_, _יוד_, _облд,
   {{0xfce61878,0x69d5021d,0x8af0013b,0x00000000}},	//   дово, _nxze, ftən, --,
   {{0x442f1879,0x3ce9177a,0x3cf80035,0x7c2f187a}},	//   _jeg_, glav_, ंगें_, _cecr,
   {{0x442f187b,0x7c24187c,0x7c2f187d,0x46dd111a}},	// [1080] _meg_, rbir, _decr, यवाह,
   {{0x7d06187e,0x4a4303e6,0x7c24187f,0xda660037}},	//   _wiks, кнув, sbir, باري,
   {{0x7d061880,0xa96a1168,0x3ce901ed,0x00000000}},	//   _tiks, تمام_, blav_, --,
   {{0x442f02e9,0x3ce90314,0x7c2f1881,0x53ad00dc}},	//   _neg_, clav_, _gecr, टनाश,
   {{0xd7f70132,0x69d502b1,0x291c004b,0x00000000}},	//   муш_, _exze, ūva_, --,
   {{0x442f0006,0x64d60907,0x7c2f0103,0x00000000}},	//   _aeg_, डक्श, _zecr, --,
   {{0x442f1882,0x98560009,0xafdb0c71,0x443d0024}},	//   _beg_, _оташ, ngør, _bdw_,
   {{0x442f006f,0xb8660118,0xb05b1883,0x9855010b}},	//   _ceg_, _تاسو, nnät, _птуш,
   {{0x442f0a55,0xfc3f0093,0x443d0090,0x2a780069}},	//   _deg_, _slík_, _ddw_, _karb_,
   {{0x3958006d,0x67220409,0x00000000,0x00000000}},	//   _kqrs_, mpoj, --, --,
   {{0xa3de065a,0x67220080,0x443d00de,0x442f1884}},	//   _दुर_, lpoj, _fdw_, _feg_,
   {{0x3cfa004e,0x442f1885,0x3cf80035,0x14170037}},	//   ्दों_, _geg_, ंगों_, _قيمة_,
   {{0xceeb1629,0x7c2f047e,0x5f9402fb,0x26ce07e5}},	//   قرآن_, _recr, вият, onfo_,
   {{0x7c2f1886,0x442f0120,0x2d570225,0x00000000}},	//   _secr, _zeg_, tçe_, --,
   {{0x26ce1887,0x9d181888,0xafdb01b4,0x443d00e9}},	//   info_, дост_, ggør, _ydw_,
   {{0x2cb2001e,0x9f5500d4,0x2d571889,0x6aae0055}},	//   ghyd_, _звич, rçe_, _albf,
   {{0x7c22188a,0x7c2f0228,0x7e770f00,0x00000000}},	// [1090] ñora, _vecr, _taxp, --,
   {{0xe9ab0698,0x7d1e0051,0x672200d5,0x8af0013b}},	//   يدان_, _ftps, dpoj, stən,
   {{0x7c2f01d6,0x7b090009,0x2a78188b,0x3d250107}},	//   _tecr, _džua, _darb_, _dèwò_,
   {{0x2cb20297,0x628a011e,0x201900b5,0x2a78009e}},	//   chyd_, _lnfo, ncsi_, _earb_,
   {{0x442f188c,0x628a0069,0xb8d70299,0x23660221}},	//   _reg_, _onfo, _छत_, _npoj_,
   {{0x442f0a55,0x649c0079,0xddd500fd,0x9967188d}},	//   _seg_, _séip, lező, _отбл,
   {{0x26c90254,0x442f188e,0x00000000,0x00000000}},	//   đao_, _peg_, --, --,
   {{0x628a188f,0x2ca91890,0x00000000,0x00000000}},	//   _anfo, nkad_, --, --,
   {{0x442f1891,0x130502c4,0xe3b10037,0x29110027}},	//   _veg_, нзим, طرة_, _huza_,
   {{0x442f1892,0x291101d5,0x5fda052f,0x31250210}},	//   _weg_, _kuza_, _युगल, ндог,
   {{0x442f1893,0x2ca91894,0x2f1401ff,0x5fc500b4}},	//   _teg_, kkad_, _säg_, _लेबल,
   {{0x8cc10324,0xb05b02ee,0x628a1895,0x442f1896}},	//   रोमो, siän, _enfo, _ueg_,
   {{0xc00000c8,0xe3ae1897,0x2ca91898,0xd9bd018d}},	//   ূর্ণ_, _сб_, dkad_, ्पुट,
   {{0x539a1899,0x2f14022a,0xafdb08c8,0x29110260}},	//   _מינו, _väg_, tgør, _ouza_,
   {{0x98a700b8,0x6d41023a,0xacf610b4,0xc8790160}},	//   éně_, šlan, ечај, _oaş_,
   {{0x2ca9010d,0xfce30fc5,0xc8790160,0x2a780160}},	//   gkad_, госо, _naş_, _sarb_,
   {{0x60d700a5,0x3a31189a,0xca860409,0x4aaa081b}},	// [10a0] _רופא_, _bezp_, нгай, пкан_,
   {{0x2911189b,0x60c6189c,0x69130024,0x00000000}},	//   _buza_, likm, _iħej, --,
   {{0xc8790669,0xdca6189d,0xb05b0523,0xc8660c94}},	//   _baş_, _зани, mnär, етли,
   {{0x60c60464,0x6d4e189e,0x2ca9013c,0x48be0033}},	//   nikm, muba, ckad_, ইক্র,
   {{0x6d4e189f,0xb05b18a0,0x7c360430,0xc879013b}},	//   luba, onär, mayr, _daş_,
   {{0xb05b16c9,0x26ce18a1,0x7c36013b,0x2f3b016b}},	//   nnär, unfo_, layr, לגנד,
   {{0x672203a5,0x291118a2,0x550600af,0x00000000}},	//   spoj, _guza_, нчиа, --,
   {{0x6d5c18a3,0xb05b02b1,0x09e318a4,0x67220421}},	//   itra, hnär, _сосн, ppoj,
   {{0x6d4e18a5,0x68e200ab,0x00000000,0x00000000}},	//   huba, mood, --, --,
   {{0x6d4e18a6,0x8af00095,0x68e218a7,0x95e800b5}},	//   kuba, xtəl, lood, _قبضہ_,
   {{0xc87906d3,0x6d5c18a8,0xe3af0148,0x6d4e0088}},	//   _yaş_, jtra, لری_, juba,
   {{0xe61f0028,0x68e218a9,0x6d5c18aa,0xd138010b}},	//   _đôi_, nood, dtra, rsą_,
   {{0xb4be1404,0xdefb00c3,0x6d5c0553,0x6d4e18ab}},	//   ुची_, зыв_, etra, euba,
   {{0x6d5c18ac,0x628a00a5,0xbb1b0139,0xb8160033}},	//   ftra, _unfo, _brîn, ারিত_,
   {{0x6d5c18ad,0x6d4e18ae,0x68e218af,0x6e3518b0}},	//   gtra, guba, kood, razb,
   {{0x614303fa,0x8af00095,0xdef8003c,0x68e200be}},	//   _сећа, stəl, ċċa_, jood,
   {{0x29110c0a,0x6d5c0ca9,0x2ca918b1,0x3d11018d}},	// [10b0] _suza_, atra, rkad_, _दूरे_,
   {{0x2ca918b2,0xbb1b0160,0x8af0013b,0x29110207}},	//   skad_, _frîn, qtəl, _puza_,
   {{0xd5df0302,0x7c3618b3,0xc98418b4,0x67200118}},	//   _पुंज, bayr, луци, _atmj,
   {{0x61ea18b5,0xcd9600a5,0x7afe0b88,0x00000000}},	//   _myfl, _סדרת_, ampt, --,
   {{0x4c9a02b8,0xd7630220,0x00000000,0x00000000}},	//   _חברו, انتی, --, --,
   {{0x07a218b6,0xc66803fa,0xc7a20009,0xa3de01c0}},	//   рашн, ешће_, ришк, _दुइ_,
   {{0x68e201bf,0xc879027d,0x20e102b4,0x7ea200ee}},	//   bood, _taş_, नवाध, _kôpr,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa3de0084,0x6d4e18b7,0x6d5c18b8,0x67d418b9}},	//   _दुआ_, zuba, ztra, _боту,
   {{0x6d5c18ba,0x6d4e18bb,0x386f0124,0x8cc10067}},	//   ytra, yuba, legr_, रोतो,
   {{0x61ea02c7,0x26c718bc,0x60c618bd,0x3dc60033}},	//   _cyfl, mino_, tikm, _শুনল,
   {{0xf4850332,0x6d5c18be,0x2b490506,0x3cf90298}},	//   _جائی, vtra, krac_, _nhsv_,
   {{0x7fd603d0,0x6d5c18bf,0x3f8401c0,0x80ca0722}},	//   тіні, wtra, ímu_, ाचौं,
   {{0x6d5c18c0,0x6d4e18c1,0x60c618c2,0x2b490506}},	//   ttra, tuba, sikm, drac_,
   {{0x61ea0297,0xed5718c3,0xddc318c4,0x00000000}},	//   _gyfl, кор_, абри, --,
   {{0x6d4e18c5,0x26c718c6,0x6d5c18c7,0x8c430279}},	//   ruba, hino_, rtra, иесе,
   {{0x26c718c8,0x6d4e18c9,0x387d00e9,0x8af000a8}},	// [10c0] kino_, suba, ddwr_, stəm,
   {{0x26c718ca,0x7c3618cb,0x0f370070,0xbb1b0160}},	//   jino_, sayr, _שריט_, _trîn,
   {{0x26c718cc,0x68e200ab,0xa3de000c,0xfbd100b5}},	//   dino_, tood, _दुई_, لتے_,
   {{0xdca618cd,0xd30800e2,0x7641008c,0x26c701ef}},	//   _рами, _hệt_, _adly, eino_,
   {{0xdb0a0098,0x2c170067,0x60c4034d,0x00000000}},	//   únói, धुओं_, _mmim, --,
   {{0x26c718ce,0xb05b033b,0x68e218cf,0x00000000}},	//   gino_, hnäp, sood, --,
   {{0xceb30052,0xd3080019,0xd5af017e,0xd04800a8}},	//   שיו_, _mệt_, يفه_, şməy,
   {{0x98a318d0,0xb4be0b57,0x60c40159,0x982800fd}},	//   _кисе, ुचे_, _nmim, _سترہ_,
   {{0x26c718d1,0xf9f40033,0xd4670200,0x00000000}},	//   bino_, _জলিল_, тиње_, --,
   {{0x26c718d2,0x00000000,0x00000000,0x00000000}},	//   cino_, --, --, --,
   {{0x3a3700a5,0x403518d3,0xaa370070,0x78a0017b}},	//   כרים_, ленс, כטיק_, _komv,
   {{0x93461412,0x30a718d4,0x6abf045c,0x60c40031}},	//   _анде, тров, _एग्र, _cmim,
   {{0x2d8c0b6c,0x644218d5,0x2d9e18d6,0x7d0300d1}},	//   åden_, _idoi, äten_, _ènsi,
   {{0x41dd0e1d,0x60c418d7,0x61ea00d5,0x00000000}},	//   _नुकस, _emim, _tyfl, --,
   {{0x7b090df4,0xd3080019,0x2d850079,0x00000000}},	//   _džul, _dệt_, íle_, --,
   {{0xc0ab1328,0x2b4918d8,0x629a00cd,0x60d60031}},	//   _زابل_, trac_, ljto, _gjym,
   {{0x0bf518d9,0x59d50066,0x1be318da,0x3e1900af}},	// [10d0] упаю, _दशहर, _कुशल_, _попэ_,
   {{0x26c7002a,0xdd0300d0,0x629a0031,0x6d4818db}},	//   xino_, ırıc, njto, ádac,
   {{0x26c718dc,0x81e40083,0x6cd518dd,0x78a00223}},	//   vino_, পের_, _مقدا, _bomv,
   {{0x3cf601d1,0x26c704fb,0x78a018de,0x64420098}},	//   ्षणे_, wino_, _comv, _ndoi,
   {{0x3ea118df,0x7b0900c7,0x00000000,0x00000000}},	//   _koht_, _užuo, --, --,
   {{0x6442043f,0xfc3f00ee,0x00000000,0x00000000}},	//   _adoi, _elít_, --, --,
   {{0x26c718e0,0x00000000,0x00000000,0x00000000}},	//   rino_, --, --, --,
   {{0xf77300b5,0x00000000,0x00000000,0x00000000}},	//   _پار_, --, --, --,
   {{0x26c718e1,0xdce50080,0x68e9012f,0x130910be}},	//   pino_, _arhī, _iked, нний_,
   {{0xd7f818e2,0x6b6700ea,0x68fb030d,0x3ea102a7}},	//   _рус_, mīgā, _hhud, _noht_,
   {{0xa0a60763,0x245518dd,0x68fb00d7,0x27fa004e}},	//   ганд, _مناس, _khud, ępne_,
   {{0x5fc500ab,0x351a024b,0xd30800cc,0x00000000}},	//   _लेहल, _טוענ, _sệt_, --,
   {{0x7ae51246,0x27ed0107,0x68fb08c7,0x61130139}},	//   koht, _jyen_, _mhud, _măli,
   {{0x63a918e3,0x63bb08c7,0x7ae500c3,0x68fb009f}},	//   myen, mzun, joht, _lhud,
   {{0x27ed0c1f,0x8af00095,0x9256015a,0x270f051d}},	//   _lyen_, stək, _сајт_, ादुर_,
   {{0x60c418e4,0x27ed0453,0x7b0900f4,0x00000000}},	//   _umim, _oyen_, _džum, --,
   {{0x63bb18e5,0x8b2600d8,0xfc3f0176,0xf4120070}},	// [10e0] nzun, удзе, _alís_, מפן_,
   {{0xfeba00bf,0x290d0069,0x63bb18e6,0x68e918e7}},	//   _ساخت_, _aiea_, izun, _aked,
   {{0x6da618e8,0x27ed021e,0x68fb18e9,0x09f618ea}},	//   _сина, _ayen_, _bhud, учая,
   {{0xd7fa18eb,0x68fb18ec,0x7e7e18ed,0x27ed18ee}},	//   нул_, _chud, _happ, _byen_,
   {{0x7e7e18ef,0x68fb00e0,0x96ea18f0,0x7c9500d8}},	//   _kapp, _dhud, нька_, _трэц,
   {{0x7e7e003c,0xddc70e6a,0x6f1602d7,0xaf770070}},	//   _japp, lejš, _muyc, טענס_,
   {{0x7b090280,0x7e7e18f1,0x00000000,0x00000000}},	//   _ožuj, _mapp, --, --,
   {{0xddc718f2,0x7e7e18f3,0x3a3a0d3b,0x63bb02b1}},	//   nejš, _lapp, lapp_, fzun,
   {{0xa3de0c3e,0x63a918f4,0x6b8418f5,0xa3e700be}},	//   _दुख_, gyen, nvig, _मुद_,
   {{0x7e7e18f6,0x3a3a18f7,0xf12618f8,0x2258027d}},	//   _napp, napp_, льмо, ürk_,
   {{0x63a90298,0x6b8400be,0x00000000,0x00000000}},	//   ayen, hvig, --, --,
   {{0x7e7e0159,0x657a03d0,0x63a918f9,0xb3860698}},	//   _aapp, _isth, byen, _مجته,
   {{0x7e7e022e,0x7b090009,0xdb0418fa,0x3a3a18fb}},	//   _bapp, _džuj, nzió, kapp_,
   {{0x6b8418fc,0x7e7e18fd,0x6b890207,0x645903d0}},	//   dvig, _capp, _šego, _zcwi,
   {{0x7e7e18fe,0xccfb03fa,0x7eb000be,0x6b840051}},	//   _dapp, ећа_, _täpn, evig,
   {{0x61f815d7,0x00000000,0x00000000,0x00000000}},	//   _izvl, --, --, --,
   {{0x5a3518ff,0x7afc009e,0x68e9008c,0x00000000}},	// [10f0] инат, _bhrt, _rked, --,
   {{0x68e91900,0x7afc00d5,0x7e7e1901,0x6b6700ea}},	//   _sked, _chrt, _gapp, vīgā,
   {{0x4975034b,0x657a01e8,0x7afc0009,0x1ed81902}},	//   рлес, _nsth, _dhrt, _حبيب_,
   {{0xf7710206,0x27ed0107,0x00000000,0x00000000}},	//   قات_, _pyen_, --, --,
   {{0x7c2d1903,0x7e7e0159,0x69dc0176,0x4e1902b4}},	//   mbar, _yapp, _exre, _दलाई_,
   {{0x6b670029,0x63bb013b,0x61f800d5,0xe46305f9}},	//   rīgā, vzun, _ozvl, şmüş,
   {{0x7d0f006c,0x5e5802b5,0x7c2d009e,0x68fb1904}},	//   _kics, טיגע_, obar, _thud,
   {{0x63bb1905,0x93451906,0x63a91907,0x58d500d4}},	//   tzun, ание, tyen, _тобт,
   {{0x3f89006d,0xe2990009,0x7c2d1908,0x63bb1909}},	//   _nrau_, вап_, ibar, uzun,
   {{0x52a9190a,0x63a9190b,0x7c2d190c,0x387f01d7}},	//   твом_, ryen, hbar, _haur_,
   {{0x63a9190d,0x7c2d190e,0x7e7e190f,0x3f8901d7}},	//   syen, kbar, _rapp, _arau_,
   {{0x7c2d004e,0x3f891910,0xf8b507b5,0x859a00a5}},	//   jbar, _brau_, ंसिय, _בשעו,
   {{0x442d0c72,0x7e7e1911,0xddc71912,0x387f1913}},	//   mbe_, _papp, vejš, _maur_,
   {{0x442d1914,0x6b8407e5,0x387f1915,0x7b0900f4}},	//   lbe_, vvig, _laur_, _džuk,
   {{0x3f890043,0xddc71916,0x3c42006c,0x442d001c}},	//   _erau_, tejš, _lévő_, obe_,
   {{0x0c261917,0x442d0c1f,0x3f8902c9,0xed570370}},	//   рман, nbe_, _frau_, јот_,
   {{0x3f891918,0x7e7e1919,0xddc702c6,0x442d01ae}},	// [1100] _grau_, _tapp, rejš, ibe_,
   {{0x6281142b,0x00000000,0x00000000,0x00000000}},	//   ndlo, --, --, --,
   {{0x6e3c02df,0x7c2d191a,0x81e70083,0x02b60070}},	//   marb, bbar, _মৃত_, סלעך_,
   {{0x6e3c191b,0x442d191c,0x387f00ea,0x57a6081b}},	//   larb, jbe_, _caur_, ишла,
   {{0x442d03ab,0x387f0932,0xdddc006c,0xca76002d}},	//   dbe_, _daur_, merő, _кувы,
   {{0x7d04191d,0x442d01ae,0x6e3c191e,0x6b8b01b4}},	//   lmis, ebe_, narb, ægge,
   {{0xd943191f,0x385602fb,0x387f0139,0x00000000}},	//   _мери, _възс, _faur_, --,
   {{0x387f0291,0x29180168,0x6e3c1920,0x6d410037}},	//   _gaur_, _iura_, harb, álai,
   {{0x7d041921,0xb4d60084,0x29181922,0x38661923}},	//   imis, _सदी_, _hura_, mfor_,
   {{0x29181924,0xc5fd0083,0x7d04112d,0x6d411715}},	//   _kura_, ুড়া_, hmis, šlai,
   {{0x442d1925,0x6e3c1926,0xdb0401ed,0x00000000}},	//   bbe_, darb, nziñ, --,
   {{0x29181927,0xd5770122,0x62811928,0x38661929}},	//   _mura_, _כתבה_, adlo, nfor_,
   {{0x29180484,0x7d04007c,0x6e3c192a,0x6d48192b}},	//   _lura_, dmis, farb, ádan,
   {{0x6e3c192c,0x2bf00035,0x7d04192d,0x7c2d0223}},	//   garb, _आरजू_, emis, wbar,
   {{0x02fb0d85,0x7c2d192e,0x7d0f0987,0x29180510}},	//   _שלומ, tbar, _pics, _nura_,
   {{0xb035192f,0xc03504bf,0x7d041930,0x7c2d1931}},	//   _униш, _униј, gmis, ubar,
   {{0x29181932,0xfbc7020d,0x649c01dd,0x6d4e1933}},	// [1110] _aura_, _रेशम, _déix, arba,
   {{0x7c2d1934,0x442d1935,0x387f0118,0x7d040086}},	//   sbar, zbe_, _saur_, amis,
   {{0x29181936,0x442d1937,0x7d04024b,0x7c2d1938}},	//   _cura_, ybe_, bmis, pbar,
   {{0x386905ee,0x7c95004f,0x6d551939,0x620500a8}},	//   ýar_, _الحص, muza, ürlə,
   {{0x7bd801d6,0x442d193a,0x2918193b,0x3cf4193c}},	//   şvur, vbe_, _eura_, ंतरे_,
   {{0x2918193d,0x1fd90033,0x442d0260,0x69c30042}},	//   _fura_, _সরাস, wbe_, únes,
   {{0x6a220332,0x20d20038,0x2918193e,0x27fa0035}},	//   _رہنم, lšie_, _gura_, ępna_,
   {{0x442d01ae,0x6e3c193f,0x3a38003d,0x9dd800a5}},	//   ube_, zarb, _zerp_, יווק_,
   {{0x7c221111,0x6e3c027d,0x29181940,0x6d551941}},	//   ñori, yarb, _zura_, huza,
   {{0x7d041942,0x442d1943,0x6d551944,0xf42600ab}},	//   zmis, sbe_, kuza, ääri_,
   {{0x628111ad,0x7d040086,0xd29800d8,0x20d201ba}},	//   rdlo, ymis, ртыі_, hšie_,
   {{0x6d551945,0x2b400176,0x00000000,0x00000000}},	//   duza, ysic_, --, --,
   {{0x20d20038,0x6e3c1946,0xfbc700dc,0xd30800e2}},	//   jšie_, tarb, _रेलम, _tệp_,
   {{0x249f1947,0x6d551948,0x61130160,0x7e2310b4}},	//   ljum_, fuza, _bălt, здрж,
   {{0x7d040006,0x6e3c1949,0x6d55194a,0x6d4e194b}},	//   tmis, rarb, guza, urba,
   {{0x6e3c194c,0x3a38194d,0xceb40095,0x7d04194e}},	//   sarb, _serp_, _atət_, umis,
   {{0x7e7515b3,0x2918194f,0x6a1607f8,0xeb971950}},	// [1120] bezp, _sura_, مبار, бит_,
   {{0x3f8f0370,0x6d551951,0x61130139,0xb05b02b1}},	//   _água_, buza, _fălt, ghäf,
   {{0x5d86004f,0xd23a0070,0x249f0093,0x29180be2}},	//   _الجل, רגעל, kjum_, _qura_,
   {{0x29181952,0x3a3803bc,0x00000000,0x00000000}},	//   _vura_, _werp_, --, --,
   {{0x38661953,0x2918012f,0x3a38008c,0xdd8f0919}},	//   rfor_, _wura_, _terp_, _قوی_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x05860036,0x249f008d,0x3866021d,0x00000000}},	//   сулм, fjum_, pfor_, --,
   {{0x249f0093,0xb05b02ee,0x00000000,0x00000000}},	//   gjum_, niät, --, --,
   {{0x644f002a,0x6d5504fb,0x00000000,0x00000000}},	//   ócia, zuza, --, --,
   {{0x25610332,0xe3af0cd1,0x28c40bdd,0x224701ed}},	//   ból_, عري_, लोरि, _cdnk_,
   {{0x76480297,0xf09f12c3,0x6a9b0070,0x25610079}},	//   _iddy, tjà_, אשינ, cól_,
   {{0x2bfa00b4,0x64a31954,0x00000000,0x00000000}},	//   ्धां_, _наха, --, --,
   {{0x33f616e6,0x2ca0012f,0xc7b40070,0x61130139}},	//   _اساس, djid_, קבֿ_, _sălt,
   {{0x20d2016f,0x6d551955,0x31341956,0x3d110066}},	//   všie_, tuza, _декр, _दूजे_,
   {{0x3b110069,0x00000000,0x00000000,0x00000000}},	//   _rizq_, --, --, --,
   {{0x6d551957,0x8cf51958,0x853b02b5,0x26ce1959}},	//   ruza, ізац, טגלי, hifo_,
   {{0x7b14195a,0x7648195b,0xab8701d3,0x5b14195c}},	// [1130] здух, _oddy, щувк, змут,
   {{0x705504e8,0x20d2016f,0x6d55195d,0x249f0035}},	//   _انکا, ršie_, puza, zjum_,
   {{0xceb20d85,0x69c8011c,0x2d870051,0x00000000}},	//   _חיי_, _žder, _éne_, --,
   {{0x76480297,0x20d2016f,0x515b0319,0x8af000a8}},	//   _addy, pšie_, רכאו, ftəs,
   {{0xf745195e,0x6561195f,0x75280228,0x00000000}},	//   цело, _sqlh, _atdz, --,
   {{0x25610332,0xf770017e,0x7f3c0070,0x79820035}},	//   tól_, عان_, נעוו, łowa,
   {{0x04590037,0x00000000,0x00000000,0x00000000}},	//   للغة_, --, --, --,
   {{0xc3251960,0x25610332,0x03250beb,0x7eab00ab}},	//   омик, ról_, один, _küps,
   {{0x249f008a,0x7b090009,0x60cf0124,0x36d5002d}},	//   rjum_, _džuv, dicm, _доар,
   {{0x68eb1961,0x02c502ce,0x42c91783,0x6913035f}},	//   logd, ійно, ргон_, _għer,
   {{0x21691962,0xe0da0545,0x2bd00433,0xd4e702ce}},	//   шини_, иво_, _सेना, _люди,
   {{0x237d0189,0xd00a01fd,0x60cf00a2,0x6729009f}},	//   _tswj_, иене_, gicm, _ktej,
   {{0x443f1963,0x03a51964,0xe9ff0023,0xe2991461}},	//   mau_, _фило, _trặc_, _вал_,
   {{0x443f1965,0x645b1966,0x67291967,0x6aa70009}},	//   lau_, lgui, _mtej, _nojf,
   {{0x2d8c1968,0x62830160,0xfc3f01ef,0xa1560274}},	//   íde_, _iano, _soía_, _дају_,
   {{0x443f1969,0x6283196a,0x645b196b,0x3f8600f4}},	//   nau_, _hano, ngui, _šouu_,
   {{0x628303c1,0xeab2006c,0x5aca196c,0x6d45196d}},	// [1140] _kano, وٹر_, алам_, _evha,
   {{0x386d0446,0x443f196e,0x2ca0124f,0xb4d6022e}},	//   _aber_, hau_, sjid_, _सद्_,
   {{0x443f196f,0xdca60b07,0x6d41006c,0x62831970}},	//   kau_, _дани, álat, _mano,
   {{0x186a1971,0x443f1972,0x2cb902c4,0xb05b0508}},	//   ради_, jau_, _glsd_, chäd,
   {{0x443f1973,0x27e01974,0x473301e0,0x645b0282}},	//   dau_, çin_, дніс, dgui,
   {{0x62831975,0x290606a2,0x56930009,0x27e0003c}},	//   _nano, smoa_, дашт, ħin_,
   {{0x443f001e,0x68eb0124,0xe1e71062,0x7c240036}},	//   fau_, bogd, _آس_, ocir,
   {{0x7c240169,0x443f0297,0x20050095,0x26ce01ed}},	//   ncir, gau_, əlif_, sifo_,
   {{0x62831976,0x8af000a8,0xa3e7073f,0x00000000}},	//   _bano, qtəs, _मुआ_, --,
   {{0x62830090,0x78a218d4,0x00000000,0x00000000}},	//   _cano, ljov, --, --,
   {{0x443f0d04,0xe29a00e8,0x69c11977,0x645b1978}},	//   bau_, _chưa_, _žlez, bgui,
   {{0x443f1979,0x78a20009,0xf48700e0,0x00000000}},	//   cau_, njov, _وانی, --,
   {{0x6283197a,0x6440197b,0x34d90070,0xe3b2197c}},	//   _fano, mami, _פֿעב, _ترا_,
   {{0x6283197d,0xfc3f02d7,0x7c26197e,0xfbdf099e}},	//   _gano, _coín_, _afkr, _ddêl_,
   {{0xeca704bf,0x9c8300b8,0x6440002f,0x4426197f}},	//   ојан, íčov, oami, _kfo_,
   {{0x4c9400c3,0x62831980,0x6aaa01ae,0x00000000}},	//   мисс, _zano, öffn, --,
   {{0x60cd1981,0xdfd10b82,0x628318f9,0xba2b0312}},	// [1150] _imam, _سيد_, _yano, لسام_,
   {{0x64401982,0x442401a5,0x443f1983,0x6d411984}},	//   hami, hcm_, zau_, álas,
   {{0xceb20779,0x64401985,0xe2a600fb,0x6729000c}},	//   _ניט_, kami, _áður_, _stej,
   {{0x5d7a02b5,0x64401986,0x443f0221,0x7c240036}},	//   _פארק, jami, xau_, ccir,
   {{0x64401987,0x443f00d8,0x7b641988,0x1be30067}},	//   dami, vau_, _отре, _कुचल_,
   {{0x8af001c2,0xcf580122,0x443f1989,0x644002d7}},	//   stər, קבות_, wau_, eami,
   {{0x443f198a,0x6283198b,0x60cd198c,0x645b198d}},	//   tau_, _rano, _omam, tgui,
   {{0x6440198e,0x628303ad,0x44260602,0xb4e5198f}},	//   gami, _sano, _cfo_, पके_,
   {{0x443f02c7,0x7c3d104e,0x20d201ba,0x44260282}},	//   rau_, _mesr, jšia_, _dfo_,
   {{0x6283008c,0x443f1990,0x78a90a45,0x60cd1991}},	//   _qano, sau_, _hoev, _amam,
   {{0x62831992,0x443f1993,0x64401994,0x78a91995}},	//   _vano, pau_, bami, _koev,
   {{0x7c3d02dd,0x64401996,0x62831997,0x4424002f}},	//   _nesr, cami, _wano, ccm_,
   {{0x62830269,0x7c24025c,0x78bb01c0,0xa29500d4}},	//   _tano, vcir, _mluv, _наді,
   {{0x78bb0033,0xe29a0019,0x2bef007c,0x60cd1998}},	//   _lluv, _thưa_, _आड़ू_, _emam,
   {{0x443d02d0,0xde031999,0x6da6199a,0x78bb0273}},	//   _kew_, епри, чива, _oluv,
   {{0xdca30346,0x61fc01d6,0x8b2600c3,0xc5f200a5}},	//   наси, ürle, здае, גדל_,
   {{0x7c24199b,0x7c3d199c,0x6d41003e,0xeb97199d}},	// [1160] rcir, _desr, álar, пит_,
   {{0x6440199e,0x09e60b46,0x7c24199f,0x443d19a0}},	//   zami, позн, scir, _lew_,
   {{0x64401815,0x6b8f01f2,0x78a20453,0x78a90051}},	//   yami, _ercg, tjov, _boev,
   {{0x443d01f3,0x644019a1,0x78a919a2,0x7eab00ab}},	//   _new_, xami, _coev, _hüpp,
   {{0x8af00095,0x644019a3,0xe70400e0,0x78a90051}},	//   stəq, vami, وستی, _doev,
   {{0xd9460d6e,0x442619a4,0xab270133,0x644019a5}},	//   _неги, _sfo_, _хора_, wami,
   {{0x644019a6,0xe7ec046c,0x00000000,0x00000000}},	//   tami, _छुरा_, --, --,
   {{0x89db0122,0x78bb00cd,0xe29a055c,0x00000000}},	//   _החלי, _gluv, _chưn_, --,
   {{0x644019a7,0xe73703ad,0x68e30300,0x7b0900ee}},	//   rami, _нет_, énde, _ižur,
   {{0x644019a8,0x442400d7,0xbebb0031,0x78a90051}},	//   sami, scm_, hpër, _zoev,
   {{0x644019a9,0x443d0122,0x705507a9,0x7d1e018d}},	//   pami, _few_, وندا, _nups,
   {{0x442619aa,0x443d19ab,0x69c100ab,0xdfd500d8}},	//   _ufo_, _gew_, _ülee, домы,
   {{0x395a023a,0xdcb10023,0x2d8c08c8,0x74130098}},	//   hups_, ểm_, æden_, _كوما,
   {{0x7bc419ac,0x7c3d19ad,0x00000000,0x00000000}},	//   dziu, _sesr, --, --,
   {{0xdd94010b,0x443d18ae,0x7eb000ab,0x945d0067}},	//   нары, _yew_, _näpu, cińs,
   {{0x60cd08dd,0x20d200a0,0x7d1e19ae,0x00000000}},	//   _umam, pšia_, _dups, --,
   {{0x2bc70518,0x5b1519af,0x9f5400d8,0xfbd319b0}},	// [1170] _रेखा, дмат, _звыч, رتر_,
   {{0x7b0910ec,0x2d810221,0x628819b1,0xf8b5021a}},	//   _ažur, _tshe_, nddo, ंस्प,
   {{0x60dd19b2,0x2d8c0c60,0x62880345,0xfc3000fd}},	//   onsm, ådet_, iddo, ئحہ_,
   {{0x6d471228,0x6b890009,0x31570070,0x2904009e}},	//   msja, _šegu, ליבן_, _chma_,
   {{0x2bc819b3,0x629802e6,0x7b090009,0x60dd19b4}},	//   _еуро_, _onvo, _džur, insm,
   {{0x443d003c,0x6b8d01d5,0x6d5519b5,0x00000000}},	//   _sew_, mvag, orza, --,
   {{0x78a90261,0x7c22025c,0x58d500d4,0x291c0355}},	//   _toev, žore, _жовт, ívat_,
   {{0xe3b919b6,0x6288016e,0x6d480079,0x6add00b4}},	//   жби_, eddo, ádai, _मदुर,
   {{0xf7700041,0x27ff06d3,0xa3e719b7,0x628819b8}},	//   _مال_, _uzun_, _मुख_, fddo,
   {{0x25e807ba,0xfc3f17bf,0x04fd0033,0x6d4719b9}},	//   _चुकी_, _leí_, ঁদের_, ksja,
   {{0x764319ba,0x69c519bb,0x6d550035,0x6d4700cd}},	//   many, nzhe, jrza, jsja,
   {{0x629819bc,0x764319bd,0x644b054e,0x6d5519be}},	//   _envo, lany, _udgi, drza,
   {{0x7d1e19bf,0x6d550067,0x996200fe,0x945d0067}},	//   _sups, erza, _díře_, sińs,
   {{0x764319c0,0xe2990043,0x60dd0051,0x7d1e005f}},	//   nany, _фак_, ansm, _pups,
   {{0x9fa019c1,0x00000000,0x00000000,0x00000000}},	//   _méér_, --, --, --,
   {{0xc106004f,0xa2d502b4,0x00000000,0x00000000}},	//   _توبي, यचक्, --, --,
   {{0x764319c2,0x09ab0083,0xcb6719c3,0x6d4700be}},	// [1180] kany, _গেলা, мате_, asja,
   {{0x0f5700a5,0x7bc40409,0xbebb0055,0x6d550288}},	//   _קיים_, rziu, spër, brza,
   {{0x673b00f8,0x5e9b00a5,0x6b8d0629,0x00000000}},	//   _awuj, _וביק, avag, --,
   {{0x6d5c19c4,0x395a19c5,0xeb9a136c,0x9f990345}},	//   mura, rups_, _дим_, _háár_,
   {{0x764319c6,0x6d5c0ce8,0x628802c7,0xb90613f0}},	//   fany, lura, yddo, _पद_,
   {{0x764319c7,0x395a19c8,0x07a303fa,0x7e7c19c9}},	//   gany, pups_, таљн, nerp,
   {{0x6d5c19ca,0xf9830086,0x00000000,0x00000000}},	//   nura, _игро, --, --,
   {{0x2ebb074f,0x7e7c19cb,0x7b0900cb,0x00000000}},	//   _उत्त, herp, _užur, --,
   {{0x764319cc,0xc4450118,0x20c20098,0x00000000}},	//   bany, ریون_, _móid_, --,
   {{0xd25000bf,0x76430232,0xeb9102b5,0x234800fd}},	//   دند_, cany, אָט_, _ہستی_,
   {{0x62880297,0x20d219cd,0xf1aa00f8,0x2486026e}},	//   rddo, ršin_, زاده_, _taom_,
   {{0x6d5c19ce,0x6720002f,0x04930037,0x9fa00223}},	//   dura, _kumj, _للمح, _zéér_,
   {{0xfc3f02d7,0x7e7c0b17,0x2d6802b1,0x9343031a}},	//   _reí_, ferp, eße_, _анче,
   {{0x6d5c000e,0x7e7c19cf,0x6298033b,0x826800b5}},	//   fura, gerp, _unvo, _رشتہ_,
   {{0x9f990298,0x00000000,0x00000000,0x00000000}},	//   _dáár_, --, --, --,
   {{0x6d4719d0,0x764319d1,0x20c20037,0x7c3619d2}},	//   rsja, zany, _cóid_, gbyr,
   {{0x764319d3,0x2d9e01ae,0x2d8c0909,0x3f8500ea}},	// [1190] yany, äter_, åder_, ālus_,
   {{0x6d5c19d4,0x9af5004f,0x7f5d0176,0x7e7c19d5}},	//   bura, ركات, musq, cerp,
   {{0x764319d6,0x6d5c19d7,0x6b8d19d8,0xc98419d9}},	//   vany, cura, svag, куци,
   {{0x764319da,0x2bd019db,0xe0df07e5,0x2bcb0274}},	//   wany, _सेवा, nnò_, _дуго_,
   {{0x7d0d19dc,0x764319dd,0xf3880019,0x291c02d7}},	//   mmas, tany, _nợ_, ívar_,
   {{0x7d0d19de,0xddde0b16,0x672002d4,0x00000000}},	//   lmas, _hapš, _dumj, --,
   {{0x764319df,0xddde005f,0x00000000,0x00000000}},	//   rany, _kapš, --, --,
   {{0x7d0d19e0,0x764319e1,0xb38519e2,0x9fa01472}},	//   nmas, sany, елил, _wéér_,
   {{0x764319e3,0x7d0d19e4,0x375500f8,0x2b4900f6}},	//   pany, imas, _سپاس, nsac_,
   {{0x130603ad,0x6d5c19e5,0x7d0d19e6,0x237f0035}},	//   нный_, yura, hmas, rwuj_,
   {{0xe4a7002d,0xd12e0e3a,0x6d5c01d7,0xe1f900d8}},	//   _ордо, یمی_, xura, яго_,
   {{0x764100f5,0xf99200c2,0x2ec8004e,0x3cfb0035}},	//   _hely, ארט_, रफ्त, ्षों_,
   {{0x764119e7,0x42cd0033,0x75210051,0xbebb0031}},	//   _kely, রকৌশ, _hulz, rqën,
   {{0x91e50f94,0x6d5c16a3,0x3ebe0093,0x75210103}},	//   _поле, tura, ótt_, _kulz,
   {{0x764119e8,0xc5f20070,0x7e7c0a8c,0x00000000}},	//   _mely, ָדן_, rerp, --,
   {{0x7d0d19e9,0x7e7c19ea,0x7f5d00f6,0x764119eb}},	//   gmas, serp, busq, _lely,
   {{0x245a01d6,0x6d5c19ec,0x6b8900cd,0x75210055}},	// [11a0] lümü_, sura, _šegr, _lulz,
   {{0x6d5c19ed,0xb05b19ee,0x7c3617ad,0x7d0d19ef}},	//   pura, nhän, sbyr, amas,
   {{0x8c4619f0,0xcee900d1,0x02b60070,0x6d5c19f1}},	//   _пене, _ترين_, עלעך_, qura,
   {{0x7eb0007c,0x224503b3,0x7d0d19f2,0x20d200cd}},	//   _täps, halk_, cmas, kšim_,
   {{0x68e319f3,0xa2b401c0,0x00000000,0x00000000}},	//   énda, ेसम्, --, --,
   {{0x09bf0033,0xc8e90066,0x764119f4,0x0cc30033}},	//   _আশরা, टकॉम_, _cely, ্কৃত,
   {{0xf38801a5,0xceb30122,0x7641016e,0x80a300b4}},	//   _sợ_, ריו_, _dely, गामे,
   {{0x75210453,0xd3a6051a,0x69c100be,0x6720034d}},	//   _dulz, ероп, _ülea, _tumj,
   {{0xb05b02b1,0x764119f5,0x20d219f6,0x00000000}},	//   fhän, _fely, ršil_, --,
   {{0xf38801a5,0x764119f7,0x7d0d00c1,0x6aae08c8}},	//   _vợ_, _gely, zmas, _jobf,
   {{0x6d1f007c,0xba570070,0x75210051,0xf48400b5}},	//   _मूंग_, עסטו_, _gulz, _لاشی,
   {{0x254c00b8,0x7d0d00a8,0x61f800ac,0x00000000}},	//   měl_, xmas, _vyvl, --,
   {{0xe29a19f8,0xb05b01ae,0x213c012f,0xe0df07e5}},	//   _над_, bhän, _wwvh_, rnò_,
   {{0x6710009a,0x64420341,0x245a0225,0x7f5d00f6}},	//   ाषिक_, _heoi, bümü_, rusq,
   {{0x7d0d19f9,0x20240098,0x00000000,0x00000000}},	//   tmas, íriú_, --, --,
   {{0xdc8819fa,0x7d0d19fb,0xccf803fa,0x628a016e}},	//   нсул_, umas, ећу_, _hafo,
   {{0x7d0d19fc,0x628a02d0,0x64420341,0x3c5800af}},	// [11b0] rmas, _kafo, _meoi, эитэ_,
   {{0x644219fd,0x00000000,0x00000000,0x00000000}},	//   _leoi, --, --, --,
   {{0x764119fe,0xd999004f,0xddde19ff,0x7d0d1a00}},	//   _rely, بنات_, _tapš, pmas,
   {{0x628a1a01,0x76411a02,0x48cf0083,0x64421a03}},	//   _lafo, _sely, িক্র, _neoi,
   {{0x81bc00ea,0x7eb01a04,0x245a0448,0x75210b17}},	//   ucēj, _käpp, zümü_, _sulz,
   {{0x69d502cb,0x628a0097,0xf653006c,0x75211a05}},	//   _येथी, _nafo, ائش_, _pulz,
   {{0x6442004f,0x764100c7,0x00000000,0x00000000}},	//   _beoi, _vely, --, --,
   {{0x64420037,0xe7d20ed1,0x69cc00a0,0x7eb01a06}},	//   _ceoi, _देवप, ôlež, _läpp,
   {{0x64421a07,0xe3b10037,0x1309051a,0x69d50099}},	//   _deoi, شرة_, мний_, _येती,
   {{0x628a001e,0x7eb00196,0xb6060097,0x20d20207}},	//   _cafo, _näpp, _stáž, ršim_,
   {{0x628a00e5,0x644211d9,0xb05b1788,0x22580067}},	//   _dafo, _feoi, rhän, órka_,
   {{0x64420608,0xe3b003c5,0x20d2030a,0x290f0159}},	//   _geoi, _گرم_, pšim_, nmga_,
   {{0xb05b022a,0x2ca900be,0x22451a08,0xe3ae1a09}},	//   mhäl, djad_, palk_, _тб_,
   {{0x7982004e,0x628a001e,0x248d05a6,0x00000000}},	//   łowi, _gafo, ldem_, --,
   {{0xbea3052c,0x200401ba,0x8af0013b,0xb05b02b1}},	//   шарк, ťmi_, frən, chäo,
   {{0x248d1a0a,0x1fb61a0b,0xa3e50f06,0x00000000}},	//   ndem_, _асор, _नशा_, --,
   {{0x248d1a0c,0x236d006f,0x2c070096,0x628a0371}},	// [11c0] idem_, ntej_, _शरणं_, _yafo,
   {{0x3ced0528,0x6d4801dd,0x3ce01a0d,0x6a1600ce}},	//   čeva_, ádas, sniv_, نبار,
   {{0xae570122,0x19b91a0e,0x69230210,0x41c1021a}},	//   _בסיס_, нуць_, амха, शनिस,
   {{0x38cb0df3,0x248d1a0f,0xd7fa0043,0x79950035}},	//   وانی_, jdem_, мул_, _drzw,
   {{0x6d5a010b,0x23d00035,0x248d1a10,0xe7d209b8}},	//   štad, _तेंद, ddem_, _देशप,
   {{0x248d003c,0x254c00b8,0x64421a11,0x7ccc013b}},	//   edem_, těl_, _seoi, rşru,
   {{0xe9a30889,0xa2c506fe,0x628a008d,0xa9a3081b}},	//   _карп, िसन्, _rafo, _кирд,
   {{0x628a0297,0x2a070439,0xb8660df3,0xa2d4022e}},	//   _safo, _респ_, _جاسو, योन्,
   {{0x2c6d006c,0xaa820093,0xd62a1a12,0x06860036}},	//   lódó_, _þýsk, _жозе_, _иган,
   {{0x68e21a13,0x00000000,0x00000000,0x00000000}},	//   lnod, --, --, --,
   {{0x64421a14,0x9f4f008d,0xe3af0647,0x00000000}},	//   _teoi, _ágú_, مری_, --,
   {{0x9f351a15,0x68e200e9,0xe3ba0267,0x6b8401d5}},	//   лемі, nnod, _обе_, kwig,
   {{0x35a80953,0x628a016e,0xe70300e2,0x09d60033}},	//   _कपड़, _tafo, _hướ, _তুমা,
   {{0x6b841a16,0x7a4800ea,0x11d313cf,0x00000000}},	//   dwig, nūtē, اتید, --,
   {{0x8c670183,0x2ca900ab,0x20d200cd,0x1df80104}},	//   ктад, tjad_, kših_, веры_,
   {{0x20d2008b,0x2d9c00ac,0x021700a5,0x00000000}},	//   jših_, _švec_, _בחום_, --,
   {{0x68e20076,0x3a7500c3,0x2ca91a17,0x31e200b4}},	// [11d0] dnod, ллар, rjad_, _पशुध,
   {{0x5a341a18,0x2ca900be,0x248d1a19,0x00000000}},	//   инут, sjad_, zdem_, --,
   {{0x68e30f56,0x68e20297,0xceb202b8,0x8af000a8}},	//   éndo, fnod, _היי_, mrəl,
   {{0x3f89046a,0x68e2016e,0x6b84007b,0xa215016b}},	//   _ksau_, gnod, bwig, אַנס_,
   {{0xe9ff0019,0xa2c5164f,0x20c20132,0x27e91a1a}},	//   _trắc_, िसम्, _jóia_, çan_,
   {{0x7d1d1a1b,0x7c2d1315,0xe70300cc,0xda34010b}},	//   _hiss, lcar, _bướ, _веры,
   {{0xc9841a1c,0x68e20097,0xb05b01ae,0x45191a1d}},	//   _кути, bnod, thäl, нция_,
   {{0x7c2d1a1e,0xdb1e0187,0x7d1d003c,0xc48500af}},	//   ncar, _švéd, _jiss, улик,
   {{0x7d1d1a1f,0x248d1a20,0xb05b01ae,0x7c2d00c7}},	//   _miss, rdem_, rhäl, icar,
   {{0x248d0a21,0x236d1a21,0x27e00037,0x66150097}},	//   sdem_, rtej_, úine_, _úzko,
   {{0x291e02e1,0x7d1d1a22,0x3f8900e5,0xa06a13ba}},	//   _état_, _oiss, _asau_, нана_,
   {{0x7c2d1a23,0xd5ba02b5,0x20c2021d,0x00000000}},	//   jcar, _אזעל, _bóia_, --,
   {{0xe28e1a24,0x442d0690,0x7c2d1a25,0x61ea0523}},	//   _ла_, mce_, dcar, _exfl,
   {{0x442d1a26,0x66f5004e,0x35d80066,0x64490079}},	//   lce_, ेतिक_, _भेड़, laei,
   {{0x62811a27,0x7d1d1a28,0x3f890e5b,0x68e2001e}},	//   melo, _biss, _esau_, ynod,
   {{0x442d1a29,0x62811a2a,0x7d1d1a2b,0x6b9b012e}},	//   nce_, lelo, _ciss, _šuga,
   {{0x7d1d1a2c,0x442f01ae,0x60c41a2d,0x20d21a2e}},	// [11e0] _diss, _mfg_, _ilim, vših_,
   {{0x62811a2f,0x7bc001c2,0xc3320122,0x442d1a30}},	//   nelo, _ümum, צוב_, hce_,
   {{0x2d961a31,0x442d000c,0x7d1d1a32,0x68e20c7c}},	//   _српс, kce_, _fiss, tnod,
   {{0x6846002d,0x5ca61a33,0x7c2d1a34,0x62811a35}},	//   унда, _симб, ccar, helo,
   {{0x442d1a36,0x62811a37,0x6d4e1a38,0xd7f718c3}},	//   dce_, kelo, lsba, луш_,
   {{0x56941a39,0x62811a3a,0x6d5c1a3b,0x60c41a3c}},	//   ракт, jelo, orra, _llim,
   {{0x62811a3d,0x6d4e1a3e,0x20d20121,0xf1a70037}},	//   delo, nsba, pših_, _اء_,
   {{0x442f1a3f,0x6f1e004e,0x6d4e0a8d,0x64491a40}},	//   _cfg_, _lipc, isba, gaei,
   {{0xb4e40ec5,0x62811a41,0x6d5c01ae,0x8af000a8}},	//   _नदी_, felo, hrra, hrəm,
   {{0x62810a45,0x26c701c0,0x3866001e,0x6d4e1a42}},	//   gelo, chno_, lgor_, ksba,
   {{0x442d01c0,0x645d0138,0x6d4e1a43,0x7c2d062c}},	//   bce_, ósic, jsba, ycar,
   {{0x38661a44,0x442d01d3,0x6d4e1a45,0x6d5c0031}},	//   ngor_, cce_, dsba, drra,
   {{0x7d1d1a46,0x8af00095,0x6d4e0e54,0x6d5c1a47}},	//   _riss, stəy, esba, erra,
   {{0x7d1d0ccf,0x7c2d1a48,0x62341a49,0x3866016e}},	//   _siss, wcar, _теку, hgor_,
   {{0x60c4003c,0x7c2d01e4,0x6d5c010d,0x6d4e1a4a}},	//   _flim, tcar, grra, gsba,
   {{0x60c41a4b,0x3f890221,0x3ced1a4c,0x7d1d1505}},	//   _glim, _tsau_, čevo_, _qiss,
   {{0x7d1d1a4d,0x6d5c1a4e,0xa01b038e,0x4bdb00f8}},	// [11f0] _viss, arra, rdös, ربرد_,
   {{0x7d1d1a4f,0x442d1a50,0x7c2d012c,0x2a6a0183}},	//   _wiss, zce_, scar, _ccbb_,
   {{0x7d1d1a51,0x7c2d1a52,0xda780c8a,0x6d4e1a53}},	//   _tiss, pcar, ыят_, csba,
   {{0xa2d40026,0x62811a54,0x69c1007c,0x4c951a55}},	//   योत्, zelo, _ülem, _тимс,
   {{0x442d0097,0x07a51a56,0x36691169,0x499300b5}},	//   vce_, ралн, вало_, _گیار,
   {{0x055502fb,0x38690701,0x62811a57,0x442d0035}},	//   атия, żar_, xelo, wce_,
   {{0x62811a58,0x49931328,0x442d0803,0x3eb30024}},	//   velo, _دیار, tce_, _moxt_,
   {{0xed64024e,0x62811a59,0x47351a5a,0x442d1a5b}},	//   leží_, welo, _внас, uce_,
   {{0x628100af,0x442d1a5c,0xe7300ca8,0x64491a5d}},	//   telo, rce_, _فصل_, raei,
   {{0x442d1a5e,0x60c41a5f,0x27ff0095,0xd7f80043}},	//   sce_, _slim, _iyun_, _сус_,
   {{0x442d1a60,0x62811a61,0x60c40395,0x2009022e}},	//   pce_, relo, _plim, _azai_,
   {{0x62811a62,0x656303e6,0x272b01b4,0x8af000a8}},	//   selo, munh, _køn_, stəx,
   {{0x68e901f4,0x7bcd1a63,0x6f1e1a64,0x20c20079}},	//   _mjed, jzau, _pipc, _fóin_,
   {{0xed5a0500,0x6d4e1a65,0x59b5018d,0x2009021d}},	//   ког_, tsba, ंहार, _dzai_,
   {{0x68fb1a66,0x272b035b,0x68e900ac,0x6d5c1a67}},	//   _okud, _løn_, _ojed, urra,
   {{0x27ff1a68,0x60c4000e,0x68e91a69,0x22471a6a}},	//   _oyun_, _ulim, _njed, _henk_,
   {{0x63bb1a6b,0x6d4e0a6d,0x26c50391,0x63a91a6c}},	// [1200] nyun, ssba, _ollo_, nxen,
   {{0xc87901c2,0x68e900de,0xed461a6d,0x63a90310}},	//   _abş_, _ajed, _кноп, ixen,
   {{0x27ff0dc3,0x21270392,0x68e900f4,0x80aa0067}},	//   _ayun_, _junh_, _bjed, टापे,
   {{0x290d01dd,0x26c501d3,0x7bcd0221,0xe73a1a6e}},	//   _chea_, _allo_, bzau, вед_,
   {{0x68e9025c,0x1867117a,0x290d1a6f,0x2d9a022f}},	//   _djed, рачи_, _dhea_, _hrpe_,
   {{0x2d9a0a18,0x68e90b3e,0x68fb1a70,0x22470118}},	//   _krpe_, _ejed, _ekud, _nenk_,
   {{0x65631a71,0x09e31499,0x20d200a0,0x27ed0051}},	//   gunh, _дорн, lšiu_, _exen_,
   {{0x26c50083,0xd4971a72,0xb4c00fc3,0x272b008c}},	//   _ello_, арь_, ँसे_, _føn_,
   {{0x63bb00b5,0x22471a73,0x80aa021a,0x00000000}},	//   gyun, _benk_, टाने, --,
   {{0x291f0043,0x68e90f86,0x9f4f000d,0xb273021f}},	//   _ziua_, _zjed, _âgé_, ольш,
   {{0x22470a75,0x2ef81a74,0xadf21a75,0x21631a76}},	//   _denk_, dorf_, _आँगन_, отяг,
   {{0x64a31a77,0x26dc07fc,0xddc50355,0x63bb007b}},	//   _маха, livo_, _schů, byun,
   {{0xdc2e0095,0x76481a78,0xa29400d8,0x20d200a0}},	//   _sığo, _kedy, _галі, jšiu_,
   {{0x7648004e,0x7b1001ae,0x22471a79,0x0ea700dc}},	//   _jedy, läuf, _genk_, खाधड,
   {{0xe3e800c8,0x76481a7a,0x2d9a1a7b,0x00000000}},	//   _পরিব, _medy, _crpe_, --,
   {{0x50d41a7c,0x7528046a,0x6ca41a7d,0xc05b00d4}},	//   _وزير, _mudz, оруж, _рік_,
   {{0x75281a7e,0x2bba0035,0x290d1901,0x68e91a7f}},	// [1210] _ludz, jącą_, _rhea_, _rjed,
   {{0x68e91a80,0x26dc1851,0x69c100ab,0x68fb0d51}},	//   _sjed, jivo_, _ülek, _skud,
   {{0x26dc03c9,0x2484003c,0x272b035b,0xc8ab01d3}},	//   divo_, kemm_, _søn_, къде_,
   {{0xf77102aa,0x00000000,0x00000000,0x00000000}},	//   كات_, --, --, --,
   {{0x2bde09a3,0x68e901f4,0x75280029,0x7648077f}},	//   _नेपा, _vjed, _audz, _bedy,
   {{0x65630008,0x75281a81,0xdc3c009f,0x00000000}},	//   tunh, _budz, _iġġo, --,
   {{0x68e9029d,0xa8a71a82,0x75281a83,0xdddc0506}},	//   _tjed, _крак, _cudz, zdrž,
   {{0x68e90a78,0x224702e9,0x15b8004b,0x60dd1a84}},	//   _ujed, _senk_, рышы_, jism,
   {{0x26dc19be,0x764800e5,0x00000000,0x00000000}},	//   bivo_, _fedy, --, --,
   {{0x68f9007a,0x63a90391,0x26dc0881,0x656306e4}},	//   lowd, rxen, civo_, punh,
   {{0x63bb121e,0x386d0124,0x63a901ef,0x75280409}},	//   syun, _kcer_, sxen, _gudz,
   {{0x67211a85,0x297a0100,0x397a0122,0x60dd1a86}},	//   _hilj, נטרא, נטרנ, gism,
   {{0x443f1903,0x80aa0026,0x6d45011e,0x22471a87}},	//   mbu_, टाबे, _awha, _tenk_,
   {{0x443f1a88,0x6d451a89,0x63a41a8a,0x7d1800fd}},	//   lbu_, _bwha, _šing, _évsz,
   {{0x2d95107a,0xdca60652,0x60dd1a8b,0xdc3c003c}},	//   ортс, бави, bism, _aġġo,
   {{0x386d00d7,0x443f1a8c,0x67211a8d,0x0c261a8e}},	//   _ncer_, nbu_, _lilj, сман,
   {{0x1d07150d,0x443f1a8f,0x63a4009e,0x00000000}},	// [1220] сети_, ibu_, _àint, --,
   {{0x443f0024,0x8e860037,0x2d9a00cd,0x9e661a90}},	//   hbu_, _الده, _trpe_, _увод,
   {{0x76480107,0x24840159,0xef170043,0x499a037c}},	//   _redy, yemm_, _ымь_, ытая_,
   {{0x443f1a91,0x75281a92,0x20d200a0,0x6729008c}},	//   jbu_, _rudz, pšiu_, _buej,
   {{0x7d041a93,0x67290176,0x31650c9c,0xc0530070}},	//   mlis, _cuej, hulz_, לזא_,
   {{0x7d041a94,0x67211851,0x88841a95,0xf1ca000c}},	//   llis, _cilj, _ژیان, ानमन,
   {{0x26dc1a96,0x67211a97,0x2d981a98,0x60dd1a99}},	//   rivo_, _dilj, nvre_, yism,
   {{0x7d041a9a,0x443f01c1,0x7648001e,0x2d9800f7}},	//   nlis, gbu_, _wedy, ivre_,
   {{0x26dc1a9b,0x7d041a9c,0x47c60370,0xf7430de6}},	//   pivo_, ilis, _убав, _нето,
   {{0x7d041a9d,0x60dd022e,0x66011a9e,0x415410be}},	//   hlis, wism, _fylk, овос,
   {{0x443f1a9f,0x8afb02b5,0x8af000a8,0x00000000}},	//   bbu_, רהיי, msəd, --,
   {{0x67210c6f,0x00000000,0x00000000,0x00000000}},	//   _zilj, --, --, --,
   {{0x44261aa0,0xe6c400fb,0x7d04016f,0x6d5a01ba}},	//   _igo_, _þjóð, dlis, átan,
   {{0xf1a61aa1,0x7d16016f,0x60dd1aa2,0x7d041aa3}},	//   _грин, emys, sism, elis,
   {{0x6d5a116d,0xa2c500b4,0x7d041aa4,0x60dd1aa5}},	//   štan, िसर्, flis, pism,
   {{0xd9041aa6,0x7d041aa7,0xa2d400b8,0x442602d7}},	//   _سی_, glis, योर्, _jgo_,
   {{0x2d8c054e,0x88bd0035,0x75220176,0xceeb01cb}},	// [1230] æder_, _liśc, _mioz, _مردن_,
   {{0x443f1aa8,0x2d9800a2,0x386d0176,0x31790067}},	//   zbu_, bvre_, _scer_, ńsze_,
   {{0x7d041aa9,0x443f0097,0x20d20009,0x6ab500e2}},	//   blis, ybu_, mšir_, _vozf,
   {{0x442619dd,0x67211aaa,0x77991aab,0x00000000}},	//   _ngo_, _silj, икер_, --,
   {{0xd3660833,0x67290033,0x443f024e,0x67211aac}},	//   _ته_, _quej, vbu_, _pilj,
   {{0xd1260079,0x3ce900af,0xe80f0035,0xe0df0036}},	//   _يم_, lnav_, ़ेगा_, hiò_,
   {{0x67211aad,0x44261aae,0xa2ac021a,0x5fe000b4}},	//   _vilj, _bgo_, जान्, _पेनल,
   {{0x44260312,0x00000000,0x00000000,0x00000000}},	//   _cgo_, --, --, --,
   {{0x443f1aaf,0x7b1001ae,0x42c91402,0xb05b033b}},	//   rbu_, bäud, игин_, nhäu,
   {{0x66010755,0x443f1ab0,0x7d161ab1,0xb60700ec}},	//   _tylk, sbu_, zmys, _apšū,
   {{0x008617a3,0xd04f013b,0x00000000,0x00000000}},	//   олно, licə, --, --,
   {{0x2eb41ab2,0xe0df0036,0xdddc0009,0xc9520317}},	//   ुस्त, giò_, jerš, ומט_,
   {{0xbebb01f4,0xfc4601ba,0xdddc0009,0x7d041ab3}},	//   jqës, šíka_, derš, vlis,
   {{0x61451ab4,0x644b01d5,0x25de046c,0x75221ab5}},	//   _дека, _hegi, _केडी_, _zioz,
   {{0x644b0406,0x7e230370,0x2d981ab6,0xdddc00f4}},	//   _kegi, ддрж, uvre_, ferš,
   {{0x0ce80083,0xdca30336,0xb05b1ab7,0xe0df1ab8}},	//   পত্ত, маси, lkän, ciò_,
   {{0x7d041ab9,0x644b1aba,0xeb970086,0x8b2602ce}},	// [1240] rlis, _megi, оит_, ідже,
   {{0x7d041abb,0xda66004f,0x7d160355,0x63a40098}},	//   slis, تاري, smys, _áine,
   {{0x6459004e,0x1d0a0ec9,0xe9da0274,0xdddc068f}},	//   _odwi, _вени_, јке_, berš,
   {{0x644b1abc,0x53c90ea3,0xb17a0070,0xe8fa0c9f}},	//   _negi, िनाश, יטער, шле_,
   {{0x7522021d,0x1634027a,0x442600f6,0xf76f1abd}},	//   _rioz, пеля, _rgo_, ناو_,
   {{0x8f9b1abe,0xe0df07e5,0xbf9b025a,0x00000000}},	//   ייני, ziò_, יינש, --,
   {{0x2bde00c0,0xb05b013c,0x4426029e,0xe5a30200}},	//   _नेता, dkän, _pgo_, дији,
   {{0x644b01a7,0x18670eb4,0x00000000,0x00000000}},	//   _cegi, _маси_, --, --,
   {{0x644b1abf,0xe0df0036,0x00000000,0x00000000}},	//   _degi, viò_, --, --,
   {{0x3ce00006,0x8af001c2,0x3ced0bc6,0x29061ac0}},	//   hiiv_, qsəd, čevi_, lloa_,
   {{0x27300028,0x644b1ac1,0x7522021d,0x00000000}},	//   _hàn_, _fegi, _tioz, --,
   {{0x6ab70567,0x44261ac2,0xbebb01f4,0x644b1ac3}},	//   _आक्र, _ugo_, yqës, _gegi,
   {{0x6d5a1ac4,0x69c1007c,0x290601ed,0x27300107}},	//   štal, _ülev, iloa_, _jàn_,
   {{0xdefb1ac5,0x27300028,0x20050080,0xf1aa0088}},	//   рым_, _màn_, āli_, _نابه_,
   {{0x27301ac6,0x62881ac7,0xc8bc0567,0x290601a3}},	//   _làn_, medo, ्घाट, kloa_,
   {{0x62881ac8,0xe9ab01cb,0x00000000,0x00000000}},	//   ledo, یدان_, --, --,
   {{0x60c01ac9,0x27300023,0x3ce900b9,0x00000000}},	// [1250] ömme, _nàn_, rnav_, --,
   {{0x77621aca,0x62881acb,0x3ce900ec,0x7f840105}},	//   drox, nedo, snav_, _کلین,
   {{0xdc3f024e,0x41ca0d1f,0xb05b02b1,0x7c3a0160}},	//   líčk, ानिस, shäu, _ştre,
   {{0xd04f01c2,0x27301acc,0xb17b0070,0x628803d0}},	//   ticə, _bàn_, שטאר, hedo,
   {{0xdc3f0187,0xf7451acd,0x6d55006c,0xdc360070}},	//   níčk, чело, lsza, _מארט_,
   {{0x644b1ace,0x62881acf,0xf1ca1ad0,0x27301ad1}},	//   _segi, jedo, ानान, _dàn_,
   {{0x62881ad2,0x6b8d0a75,0x6d551ad3,0x00000000}},	//   dedo, lwag, nsza, --,
   {{0xe7871ad4,0x62880207,0x28f801e0,0x00000000}},	//   _музо, eedo, _десь_, --,
   {{0x644b1ad5,0x6b8d1ad6,0xdc3f0187,0xf41f00c3}},	//   _vegi, nwag, jíčk, ää_,
   {{0x62881ad7,0x04fd0083,0x42551172,0x2cb9009e}},	//   gedo, ুদের_, чтит, _losd_,
   {{0x644b1ad8,0x6b8d1ad9,0xb05b1ab7,0x68eb00e2}},	//   _tegi, hwag, rkän, ongd,
   {{0x6b8d1815,0x69c100be,0xeb9f008c,0x00000000}},	//   kwag, _üleu, _orø_, --,
   {{0xd7bd0567,0x7643006d,0x2004008a,0xa3d300a1}},	//   ्निच, obny, æmi_, _हेच_,
   {{0x6d5a1ada,0x2cb90211,0x62881adb,0x539a0277}},	//   štam, _aosd_, cedo, _לינו,
   {{0x2d9e0076,0x7643046a,0x6da30610,0x6d55006c}},	//   íte_, ibny, нира, gsza,
   {{0x2cb90211,0xb05b0421,0xd7bd0099,0xdc3f00ac}},	//   _cosd_, nkäl, ्नाच, bíčk,
   {{0x673b0221,0x6b8d1adc,0x00000000,0x00000000}},	// [1260] _ntuj, gwag, --, --,
   {{0x0e660086,0x80aa0302,0x3f9218ad,0x387f1add}},	//   _экон, टावे, _isyu_, _abur_,
   {{0x273001a5,0x3ebb0122,0xdebb0122,0x98b000cd}},	//   _sàn_, _הציב, _המיל, šači_,
   {{0x186a1ade,0x77621adf,0x6b8d1ae0,0x779400b5}},	//   сади_, trox, bwag, ویزا,
   {{0xfc3f1ae1,0x6563033b,0x473301e0,0x6b8d04fb}},	//   _unía_, ernh, еніс, cwag,
   {{0x2b401ae2,0x62881ae3,0x996400b8,0x290600be}},	//   mpic_, xedo, může_, sloa_,
   {{0xeafa065a,0x9d000033,0x673b0421,0x00000000}},	//   ्तीत_, ্দীন_, _etuj, --,
   {{0x62880297,0x27300019,0xe9d70104,0x77621ae4}},	//   wedo, _tàn_, _экс_, prox,
   {{0x6563009e,0x00000000,0x00000000,0x00000000}},	//   arnh, --, --, --,
   {{0xb6c80332,0x7afe1ae5,0x68e21ae6,0x86ea0037}},	//   _بارے_, nopt, liod, _اعرف_,
   {{0x62881ae7,0x6d5a01cc,0x6b8d1ae8,0x69c100ab}},	//   redo, štaj, zwag, _ület,
   {{0xeafa1ae9,0x62881aea,0x7afe0088,0x68e204fc}},	//   ्तुत_, sedo, hopt, niod,
   {{0x14a90099,0xa4b700a5,0x3eba01f7,0x98a7011c}},	//   कारण, _מלאה_, _bopt_, šići_,
   {{0x628801d2,0x6d551aeb,0x3eba1aec,0x68e21aed}},	//   qedo, tsza, _copt_, hiod,
   {{0xf29702b8,0x200c00a8,0x3ebe1aee,0x68eb1aef}},	//   _זכור_, ədim_, ötta_, yngd,
   {{0x6d551af0,0x6b8d1af1,0xfbde00a1,0xf1ba0023}},	//   rsza, twag, _नेहम, _ngơi_,
   {{0x6d550332,0xa3be08b0,0x46be112b,0x60cd1af2}},	// [1270] ssza, ीनि_, ्साह, _ilam,
   {{0x60cd1af3,0x6b8d1af4,0xb05b033b,0x6d5507cf}},	//   _hlam, rwag, chär, psza,
   {{0x60cd1af5,0xc17800d8,0xb05b0328,0xceb2016b}},	//   _klam, ntė_, ykäl, _סיט_,
   {{0xa3be1af6,0x2ee30120,0xc178010b,0xa3cc198f}},	//   ीना_, lijf_, itė_, रना_,
   {{0x60cd00d1,0x3a38007b,0x28f800af,0x00000000}},	//   _mlam, _ffrp_, чець_, --,
   {{0x60cd00c8,0x7afe1af7,0x25de000c,0x255700af}},	//   _llam, copt, _केही_, tăl_,
   {{0xf65010ee,0x60cd027d,0xb05b00c3,0x00000000}},	//   ائه_, _olam, tkäl, --,
   {{0x68e20043,0xe89401c8,0x387f1af8,0x2ee30120}},	//   ciod, _пась, _ubur_, hijf_,
   {{0xb05b16c9,0xc17800c7,0xd702010b,0x673b037b}},	//   rkäl, etė_, _кiра, _utuj,
   {{0x78bb1af9,0x69c1007c,0x130600c3,0x78a907c0}},	//   _houv, _üles, мный_, _hnev,
   {{0x78bb1afa,0x78a90051,0x60cd1afb,0x3eba0c6f}},	//   _kouv, _knev, _blam, _ropt_,
   {{0xafe602ce,0xd00a03e6,0x6d5a1abc,0x555800d8}},	//   домл, жеме_, štak, _хаця_,
   {{0x78bb1afc,0x60cd1afd,0x92b50037,0x853c0409}},	//   _mouv, _dlam, _يحتا, _grėb,
   {{0x78bb1afe,0x60cd007c,0x68e201b7,0xbb1b0160}},	//   _louv, _elam, ziod, _spîn,
   {{0x78a91aff,0x99980009,0x60cd1b00,0xb05b1b01}},	//   _onev, _serž_, _flam, rhär,
   {{0x78bb1b02,0x7afe0260,0x2b401b03,0x2b59055c}},	//   _nouv, wopt, tpic_, _bvsc_,
   {{0xb05b01ae,0x7afe0223,0xa2d40bdd,0x2b590176}},	// [1280] phär, topt, योक्, _cvsc_,
   {{0x78a90160,0x273b00af,0x25de00ab,0x2b400510}},	//   _anev, _mână_, _कइली_, rpic_,
   {{0x2d9c006c,0x33270069,0x7afe1b04,0xfbd1006c}},	//   _éve_, _minx_, ropt, نتے_,
   {{0x52bc009a,0x78bb0248,0x7afe19b2,0x5883021f}},	//   _ोत्स, _couv, sopt, выша,
   {{0x78a9068b,0x78bb02d0,0x711b0070,0x7afe00fe}},	//   _dnev, _douv, קונפ, popt,
   {{0x68e21b05,0x78a91b06,0xc178010b,0x00000000}},	//   siod, _enev, ytė_, --,
   {{0xdddc00d5,0x00000000,0x00000000,0x00000000}},	//   berť, --, --, --,
   {{0x78bb1b07,0x6abc008a,0x78a90f32,0x00000000}},	//   _gouv, _horf, _gnev, --,
   {{0x66cf0a55,0x69c100be,0x60cd0284,0x25de021a}},	//   _søke, _üler, _rlam, _केरी_,
   {{0x60cd1b08,0xf7431b09,0x6abc0176,0xc17a01e0}},	//   _slam, _рефо, _jorf, оїм_,
   {{0xa2d4175f,0xa50a002d,0xb05b1193,0x00000000}},	//   योग्, _дежа_, skäm, --,
   {{0x22490c99,0xc178010b,0x30a71b0a,0xd4c60037}},	//   _đake_, rtė_, фров, _تغطي,
   {{0x351b02b5,0xc17800d8,0x60cd1b0b,0x60c001ff}},	//   _וואנ, stė_, _vlam, ömma,
   {{0x3207001e,0x213c0023,0x00000000,0x00000000}},	//   _fyny_, _ttvh_, --, --,
   {{0x63a21b0c,0x27fa004e,0x67281b0d,0x60cd1b0e}},	//   _hron, ępny_, _midj, _tlam,
   {{0x60cd1b0f,0x629a04c5,0x6ee90124,0x66080118}},	//   _ulam, ldto, džbe, _mydk,
   {{0x62981b10,0x5b1519c3,0x78bb1b11,0x63a200d1}},	// [1290] _kavo, емат, _rouv, _jron,
   {{0x78bb1b12,0x6abc001e,0x290408dd,0x7f4d007a}},	//   _souv, _corf, _akma_, _iwaq,
   {{0x78bb1b13,0x25de0429,0x78a9008b,0x6abc033b}},	//   _pouv, _केली_, _pnev, _dorf,
   {{0x62980021,0x7d090484,0x200916ec,0xa01b01ff}},	//   _lavo, ċess, _kyai_, pföd,
   {{0x6abc0568,0xd3660365,0x672802d0,0x61ca022e}},	//   _forf, _حه_, _bidj, ानुष,
   {{0x6abc0297,0x7f4d007a,0x629a0051,0x25fa00ab}},	//   _gorf, _mwaq, jdto, _ऊँखी_,
   {{0x63a21b14,0xd5b11b15,0x78bb1b16,0x00000000}},	//   _aron, افع_, _touv, --,
   {{0xe3b90de3,0x273b0043,0x2129028b,0xf77001df}},	//   зби_, _până_, _niah_, _چال_,
   {{0x03251b17,0x65930095,0x20091b18,0x69c51b19}},	//   ндин, _məhə, _nyai_, lyhe,
   {{0x63a200e0,0x62980382,0x7dee006c,0x3f4d1b1a}},	//   _dron, _cavo, nősé, džu_,
   {{0x62981b1b,0x057411cf,0x69c50557,0xda1f0026}},	//   _davo, _لاند, nyhe, बधित_,
   {{0xf9da02b5,0x629a1b1c,0x0ef80f8a,0x6593013b}},	//   פֿיל, adto, ंक्स_, _nəhə,
   {{0x63a21b1d,0x21291b1e,0x6f0500cc,0x00000000}},	//   _gron, _diah_, _bkhc, --,
   {{0x248d1b1f,0xe3b004e8,0x629800c7,0x00000000}},	//   leem_, _خرم_, _gavo, --,
   {{0x57bd06d9,0xdd921b20,0x2ee10a8a,0xa2ac07df}},	//   ्नुह, دوز_, _dmhf_, जार्,
   {{0x248d0626,0x659300a8,0x91fc00ea,0x2cab0160}},	//   neem_, _cəhə, rgāt, _cncd_,
   {{0xc4d202b5,0x6abc1725,0x2cab02d7,0x63a2013b}},	// [12a0] אגן_, _porf, _dncd_, _xron,
   {{0x248d006f,0x62980176,0x09c40033,0x00000000}},	//   heem_, _xavo, _এইবা, --,
   {{0xa84a004f,0x6abc1b21,0x91fc00ea,0x2cab0260}},	//   كلام_, _vorf, lgār, _fncd_,
   {{0x67281b22,0xab2a021d,0x2129055c,0xa2a1035d}},	//   _sidj, _нома_, _xiah_, _कोस्,
   {{0x66e60b00,0x248d1b23,0x6abc1b24,0x1c1c00fa}},	//   нода, deem_, _torf, पेशल_,
   {{0x69370009,0x3cff0124,0x6593013b,0x69c51b25}},	//   _ićen, čuve_, _zəhə, byhe,
   {{0x67281b26,0x248d006d,0x63a20088,0x69c11b27}},	//   _vidj, feem_, _sron, _ülep,
   {{0x62981b28,0x67280feb,0x692c0395,0x00000000}},	//   _savo, _widj, _eşec, --,
   {{0x62981b29,0xe3b207f6,0x63a20069,0x2ab60b3e}},	//   _pavo, ارع_, _qron, _sæby_,
   {{0x63a21b2a,0x00000000,0x00000000,0x00000000}},	//   _vron, --, --, --,
   {{0x2129028b,0x63a200a5,0x6298081b,0x629a1b2b}},	//   _piah_, _wron, _vavo, rdto,
   {{0x63a2098b,0x3cfa0035,0xdfd10098,0x00000000}},	//   _tron, ंवों_, ليج_, --,
   {{0x09dd09b8,0x62981b2c,0xbfa81663,0x63a21b2d}},	//   _मध्य, _tavo, нтре_, _uron,
   {{0x63ad082d,0x61eb006c,0xb3e90037,0x659300a8}},	//   _šang, állá, _تعمل_, _səhə,
   {{0xe29b02b5,0x69370009,0x51861023,0x00000000}},	//   _זשור, _aćen, _чула, --,
   {{0xb05b00c3,0x00000000,0x00000000,0x00000000}},	//   kkäi, --, --, --,
   {{0x7dee0332,0xe7e00992,0xaa671b2e,0x2d9e15ed}},	// [12b0] tősé, _खेला_, етек, åter_,
   {{0x69111b2f,0x69c50031,0x3a740328,0x257a0055}},	//   gåen, tyhe, ллур, kël_,
   {{0x69370009,0x1df900c3,0x7ae51b30,0x20c20183}},	//   _ećen, _цены_, riht, _góis_,
   {{0xf7711b31,0xa90700d2,0x69c51b32,0x248d01e8}},	//   لات_, ربان, ryhe, xeem_,
   {{0x7d0d1b33,0x57bd01c0,0x257a03bc,0x00000000}},	//   mlas, ्नेह, eël_, --,
   {{0x7d0d1b34,0x00000000,0x00000000,0x00000000}},	//   llas, --, --, --,
   {{0x6d5a039a,0x257a00da,0x1af41b35,0xa2a10808}},	//   štav, gël_, _спря, _कोष्,
   {{0x7d0d1b36,0xa3be01d1,0x00000000,0x00000000}},	//   nlas, ीनं_, --, --,
   {{0x3f890189,0x248d1b37,0x0735172a,0x8af000a8}},	//   _npau_, reem_, _резю, ksəl,
   {{0x7d0d0076,0x248d1b38,0xc3c8004f,0x257a0031}},	//   hlas, seem_, عظيم_, bël_,
   {{0x7d0d1b39,0x3de10083,0x3f89046a,0xa06a1b3a}},	//   klas, _মুসল, _apau_, мана_,
   {{0xa2a102b4,0x34950bfe,0xfc3f00ee,0xf99200a5}},	//   _कोर्, _јадр, _dník_, ברט_,
   {{0xe28e1b3b,0x7d0d1b3c,0x64491b3d,0x2d8c003c}},	//   _ка_, dlas, mbei, ħdem_,
   {{0x200c00ea,0x20c20037,0x64491b3e,0xa3da0026}},	//   ādi_, _cóir_, lbei, _डेट_,
   {{0x442f0159,0xfc3f00a0,0x6281003e,0x443d1b3f}},	//   _kgg_, _kníh_, mflo, _kfw_,
   {{0x64491b40,0x753c00b5,0x98b800ea,0x442f0282}},	//   nbei, _érze, _otrā_, _jgg_,
   {{0x1d0713a1,0x69111b41,0x64491b42,0x60dd0031}},	// [12c0] тети_, tåen, ibei, ërme,
   {{0x6281035f,0x4a431012,0x7d0d1b43,0x692c0139}},	//   nflo, инув, alas, _aşea,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xf7461b44,0x6d5c008c,0x442f0118,0x8af0013b}},	//   ведо, msra, _ngg_, msəm,
   {{0xd7ef0082,0x7d041b45,0xb865006c,0x2bc90026}},	//   يكم_, mois, طانو, _रथया,
   {{0x7d041b46,0xa2a11b47,0x6d5a016f,0x442f027a}},	//   lois, _कोल्, štau, _agg_,
   {{0x1ae31b48,0x6d5c038e,0x0573183b,0x442f102f}},	//   _торм, nsra, لايد, _bgg_,
   {{0x7d041b49,0x22490129,0x62811b4a,0x69c300c3}},	//   nois, _đaka_, eflo, änee,
   {{0x613e00ea,0x62811b4b,0x64a310b4,0x00000000}},	//   _mīle, fflo, рања, --,
   {{0x02a61a76,0x7d0d1b4c,0x6d5c1789,0x7d041b4d}},	//   трим, zlas, ksra, hois,
   {{0x7d0d1b4e,0xd48f1b4f,0x7d040086,0xf48400d1}},	//   ylas, _кр_, kois, _ماشی,
   {{0x6d5c13a4,0x04461b50,0x7d040421,0x6ee90207}},	//   dsra, _редн, jois, džba,
   {{0x7d041b51,0xfbdf0298,0x6d5c0298,0x00000000}},	//   dois, _leêr_, esra, --,
   {{0x7658000e,0xf1a61b52,0x00000000,0x00000000}},	//   navy, _арин, --, --,
   {{0x2fcd01cc,0x7d0d1b53,0x6d5c1b54,0x442f0044}},	//   šeg_, tlas, gsra, _ygg_,
   {{0x7d041b55,0x656a0037,0x48bd0083,0x8c3b033b}},	//   gois, irfh, _আগ্র, _maßg,
   {{0x7d0d1b56,0x20c2004f,0xe7bd0083,0x3f89012f}},	// [12d0] rlas, _tóir_, _অধ্য, _upau_,
   {{0x7d0d0fd8,0x765808c7,0xf09f0392,0x00000000}},	//   slas, javy, ldà_, --,
   {{0x6f02004f,0x7d041b57,0x765800c7,0x24860168}},	//   _íoca, bois, davy, _obom_,
   {{0x7d0d1505,0xf09f0176,0x658a00a8,0x48e10033}},	//   qlas, ndà_, _məhd, যক্র,
   {{0x973504e8,0x6d5a1b58,0x628100e9,0xf094016b}},	//   اکرا, štat, yflo, ינף_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xceb41899,0x443d0051,0x940d00a8,0x00000000}},	//   ייס_, _pfw_, ənən_, --,
   {{0x26190461,0x8a180421,0x00000000,0x00000000}},	//   येगी_, _росс_, --, --,
   {{0x64491b59,0x27e0004f,0x76580054,0xf79400d8}},	//   rbei, úint_, bavy, _катэ,
   {{0x3ce901a9,0x64491b5a,0xf09f0443,0x7d04023c}},	//   hiav_, sbei, edà_, zois,
   {{0x62811b5b,0xdc100324,0x7d04002f,0x69370124}},	//   rflo, _ार्ड_, yois, _oćem,
   {{0x62810093,0x20c20037,0x273900e2,0xe7b70099}},	//   sflo, _cóip_, _kèn_, _आपाप,
   {{0xe3b00286,0x273902e9,0x6e290095,0x7d041b5c}},	//   _وره_, _jèn_, əmbə, vois,
   {{0xe2961b5d,0x249d0189,0x249f1b5e,0x6d5c1b5f}},	//   _баш_, _hawm_, ldum_, tsra,
   {{0xa0a61b60,0x249d01a9,0x7d040086,0x691102df}},	//   _байд, _kawm_, tois, tåel,
   {{0x249f00fb,0x6d5c1b61,0x7242006c,0x7b1001ae}},	//   ndum_, rsra, _پھیل, räum,
   {{0x7d041b62,0xcb671b63,0x237f1b64,0x6d5c0110}},	// [12e0] rois, лате_, ntuj_, ssra,
   {{0x249d0d4b,0xda650082,0x6d5a0391,0x8f9b0397}},	//   _lawm_, لامي, átas, _טיפי,
   {{0x7d041b65,0xbebb0055,0x9a1600af,0x00000000}},	//   pois, yqëz, уфаш, --,
   {{0x237f1b66,0x249d006d,0x27391b67,0x28df00b4}},	//   ktuj_, _nawm_, _bèn_, पोलि,
   {{0x27e00014,0x76581b68,0x249f1b69,0x00000000}},	//   àin_, tavy, ddum_, --,
   {{0xb8cb1b6a,0x2ca0007c,0x3b0a0086,0x27391b6b}},	//   _को_, ldid_, _чего_, _dèn_,
   {{0x76581b6c,0x45d41172,0x2ca000be,0x00000000}},	//   ravy, ройс, odid_, --,
   {{0x2ca01b6d,0x249d006f,0x76581040,0x8af0013b}},	//   ndid_, _cawm_, savy, ksək,
   {{0xc67600f5,0xe6461b6e,0x249d01e8,0x66760071}},	//   _مطاب, _безп, _dawm_, _مدار,
   {{0x63ad024e,0x4b7b0070,0x5b7b0070,0x2d9a1b6f}},	//   _šanc, עטיג, עריא, _ospe_,
   {{0x249d006d,0xf0b51b70,0xdb060055,0x5ab7016b}},	//   _fawm_, айнь, _arkë, אליע_,
   {{0x249d006d,0x273900bf,0xa2b0018d,0x00000000}},	//   _gawm_, _yèn_, _अचक्, --,
   {{0xf09f12c3,0x9f350185,0x2d9a1b71,0x2ca01b72}},	//   rdà_, регі, _aspe_, ddid_,
   {{0x741300f3,0x11d60041,0x249d006d,0x539b0d85}},	//   _اوها, _متعد, _zawm_, _ניוו,
   {{0x7f441b73,0x56370070,0x249d006f,0xf1a301f1}},	//   _etiq, ראלע_, _yawm_, _грын,
   {{0x25ec00ab,0x00000000,0x00000000,0x00000000}},	//   _अइनी_, --, --, --,
   {{0x4a5505c2,0x5f950036,0xba5500ed,0x6d471b74}},	// [12f0] икас, _типт, ивај, spja,
   {{0xb05b01ae,0x3ce9006d,0x27391b75,0x658a00a8}},	//   rkäu, siav_, _rèn_, _məhb,
   {{0x6d5a1b76,0x249f0448,0x853c004b,0x80aa0761}},	//   štar, ydum_, _brėm, _जोडे,
   {{0x6d451b77,0x237f0035,0x2739021e,0x00000000}},	//   _itha, ytuj_, _pèn_, --,
   {{0x0a6b1b78,0x249d01e8,0xb05b00c3,0xa2d700b8}},	//   _први_, _rawm_, lkäs, यसम्,
   {{0x249d0221,0xe73602fb,0xb6a51b79,0x00000000}},	//   _sawm_, шеш_, рикл, --,
   {{0xa564004f,0xb05b1b7a,0xb9250037,0x7d1d00fe}},	//   مدين, nkäs, _نفسي, _khss,
   {{0x3860004f,0xdb060118,0x6d451b7b,0xe79503fc}},	//   óirt_, _arkè, _mtha, _پارک,
   {{0x249f008f,0x6d45011e,0x7d1d0118,0x69370207}},	//   rdum_, _ltha, _mhss, _oćek,
   {{0x6d451b7c,0x237f0035,0x68eb1b7d,0x6ee90207}},	//   _otha, rtuj_, ligd, džbo,
   {{0x249d01a9,0x6d4501e8,0x25b901b2,0x7f440176}},	//   _tawm_, _ntha, _جهاد_, _stiq,
   {{0x20560185,0x68eb0c7c,0x25de09b4,0x00000000}},	//   штор, nigd, _केटी_, --,
   {{0x6d451b7e,0x60dd01f4,0x443f1b7f,0x00000000}},	//   _atha, ërma, mcu_, --,
   {{0x443f1b80,0x7d1d0211,0x68eb0008,0x00000000}},	//   lcu_, _ahss, higd, --,
   {{0x5046027a,0xa01b006c,0xddc31b81,0x68eb1b82}},	//   _кейб, lföl, обри, kigd,
   {{0x1c461b83,0x6d450211,0x645b0110,0x98aa1b84}},	//   рнам, _dtha, naui, _kubą_,
   {{0x2ca000ab,0x68eb1b85,0xb05b0328,0x6f071b86}},	// [1300] rdid_, digd, rkät, bojc,
   {{0xc332011d,0x60c41b87,0xb05b00be,0xe9d2026e}},	//   קוב_, _hoim, skät, يغا_,
   {{0x2d9a1b88,0x60d603d0,0x00000000,0x00000000}},	//   _uspe_, _klym, --, --,
   {{0x270e00dc,0x443f1b76,0x200c0095,0x186a0183}},	//   ित्र_, jcu_, ədir_, тади_,
   {{0x443f0bcc,0x02b50066,0x25de04aa,0x3f8200ac}},	//   dcu_, _अचंभ, _केजी_, ntku_,
   {{0x658a01c2,0x236d1b89,0xb4c00d1f,0x316b0035}},	//   _rəhb, drej_, ुस्_, ńczy_,
   {{0x6d450211,0x00000000,0x00000000,0x00000000}},	//   _xtha, --, --, --,
   {{0x399b1899,0x63ad1b8a,0xe3e70033,0x798e0118}},	//   _בילד, _šana, _পড়ব, _ipbw,
   {{0xf7430b00,0xdb060118,0x764100e5,0x00000000}},	//   _мето, _arké, _ffly, --,
   {{0x78a21b8b,0x443f1b8c,0xdce70067,0x00000000}},	//   ldov, acu_, mują, --,
   {{0x3a3702da,0x6f071b8d,0xaa370070,0x60c40b6d}},	//   ירים_, vojc, יטיק_, _boim,
   {{0x60c409e3,0x645b0176,0xd4671b8e,0x69de01d7}},	//   _coim, caui, _вице_, izpe,
   {{0x77f41b8f,0x6d450024,0x60c41b90,0xdce70035}},	//   _अशोक_, _stha, _doim, nują,
   {{0x0eeb1303,0x644002c4,0xb05b0421,0x6ee900ac}},	//   тьми_, lcmi, tkäs, ržbo,
   {{0xeda400d4,0xdef801c8,0xd2f8006c,0x60d6008c}},	//   ошто, рыя_, _لکھا_, _flym,
   {{0xdce7004e,0x60d61b91,0xb05b147d,0x8af0013b}},	//   kują, _glym, rkäs, mrəy,
   {{0x78a207e5,0x6d5a00cd,0x69de01ed,0x00000000}},	// [1310] ddov, štap, ezpe, --,
   {{0x6e95004f,0xdce704a8,0x443f1b92,0x39a7059d}},	//   _الدا, dują, zcu_, ишев,
   {{0x6d451b93,0x2b491b94,0x78a00371,0x3ea10160}},	//   _utha, spac_, _bamv, _iaht_,
   {{0x78a00176,0xa3c70324,0x78a200d5,0x00000000}},	//   _camv, _उथल_, gdov, --,
   {{0x2d831b95,0x07a50382,0x36691b96,0xdce70067}},	//   ltje_, салн, гало_, gują,
   {{0x98bc00ea,0x236d0009,0x78a21b97,0x6d48003e}},	//   īvā_, vrej_, adov, ídag,
   {{0x2d831b98,0x645b1b99,0x443f1b9a,0x3ea100be}},	//   ntje_, taui, tcu_, _maht_,
   {{0xfdf8011d,0x66cf054e,0x443f00ea,0x2d8302a2}},	//   ימוש_, _køkk, ucu_, itje_,
   {{0x443f1b9b,0x60c4006e,0x68e91b9c,0x81e40083}},	//   rcu_, _roim, _imed, _ভুল_,
   {{0x443f0012,0x236d1b9d,0xa01b1b9e,0x60d6060b}},	//   scu_, rrej_, rföl, _slym,
   {{0x60d61b9f,0x2d831ba0,0xa0a61ba1,0x60c41ba2}},	//   _plym, jtje_, банд, _poim,
   {{0x236d02c6,0xfd1f0023,0xa01b01ff,0x2d830051}},	//   prej_, _nhì_, pföl, dtje_,
   {{0x26c506e2,0x60c403ad,0x2d8302a2,0xb05b1ba3}},	//   _kolo_, _voim, etje_, tkär,
   {{0x68fb15d7,0x78a20e6a,0x291f006d,0x66cf00d4}},	//   _ljud, zdov, _lhua_, _søkj,
   {{0x60c41ba4,0x645906b3,0x3f821431,0xdcfc1075}},	//   _toim, _kewi, stku_, strč,
   {{0xeb9a14d0,0x26c51ba5,0xb05b013c,0xfd1f0023}},	//   либ_, _lolo_, skär, _chì_,
   {{0x63bb043f,0x64591ba6,0x2d830120,0xfc3f08bf}},	// [1320] nxun, _mewi, atje_, _anís_,
   {{0x68fb1ba7,0x64591ba8,0xf4120100,0x78a01ba9}},	//   _ajud, _lewi, לפן_, _samv,
   {{0x272201a5,0xdb041baa,0x68fb013c,0xdce70035}},	//   _hưng_, nvié, _bjud, wują,
   {{0x64590297,0x291f1bab,0x63ab1bac,0xd7fa09eb}},	//   _newi, _chua_, _orgn, лул_,
   {{0x26c50038,0x78a20664,0x96ea1bad,0x68fb0981}},	//   _bolo_, rdov, лька_, _djud,
   {{0x26c51bae,0x68e91baf,0xdce70035,0x68fb030d}},	//   _colo_, _emed, rują, _ejud,
   {{0xb0c8009a,0x64590b37,0x6b841bb0,0x27220019}},	//   _लवंग, _bewi, ltig, _lưng_,
   {{0xd4971bb1,0xdce70035,0x26c50036,0x39470079}},	//   брь_, pują, _eolo_, ínse_,
   {{0x64590297,0x68e300da,0xd250004f,0x26c50160}},	//   _dewi, ënde, ونة_, _folo_,
   {{0x6b8401ae,0x26c51bb2,0x63ab085e,0x15e300ab}},	//   itig, _golo_, _drgn, _केकर_,
   {{0x6b841bb3,0xd9fa01c0,0x70550312,0x60dd0055}},	//   htig, ्थित_, يندا, ërmo,
   {{0x64590b19,0x2ed108b0,0x6b841bb4,0x212002d7}},	//   _gewi, हस्त, ktig, _chih_,
   {{0x765a01f4,0xdfd801d3,0x27220023,0x6b84023a}},	//   _kety, бър_, _cưng_, jtig,
   {{0x69370009,0xd9fa1bb5,0x27220023,0x8c000033}},	//   _ićev, ्थात_, _dưng_, ্ধান_,
   {{0x765a1bb6,0x6b8411cc,0x69180453,0xfd1f0023}},	//   _mety, etig, víen, _phì_,
   {{0x2d830a75,0x7afc0009,0x3ea10159,0x09df0033}},	//   rtje_, _ajrt, _waht_, _বুঝা,
   {{0x6b841bb7,0x2d831bb8,0x3ea1035f,0x753a1a47}},	// [1330] gtig, stje_, _taht_, _lutz,
   {{0x433b0070,0x765a1bb9,0xf41a0033,0x291f1bba}},	//   טעמב, _nety, _ডলার_, _shua_,
   {{0xfd1f00e8,0x6b8414e7,0x753a02bf,0x291f01e8}},	//   _thì_, atig, _nutz, _phua_,
   {{0x26c51bbb,0x291f006f,0xa3b801c0,0x00000000}},	//   _solo_, _qhua_, ङमा_, --,
   {{0x66040092,0x6c7a02b5,0x765a165f,0x6b841bbc}},	//   şikl, _דארפ, _bety, ctig,
   {{0x321c00d5,0x2f5c1804,0x64591bbd,0x753a0110}},	//   _ozvy_, נדונ, _sewi, _butz,
   {{0x765a01d2,0x291f1bbe,0x26c51bbf,0xd05d0095}},	//   _dety, _thua_, _volo_, sisə,
   {{0x93451bc0,0xf9920d85,0x68e917c3,0x60dd0009}},	//   оние, _קרן_, _umed, jhsm,
   {{0x26c51bc1,0xdcfc00ea,0x03a51bc2,0x76b9002d}},	//   _tolo_, ntrā, ципо, _клар_,
   {{0xdddc006c,0x21201bc3,0x765a0d35,0x65951bc4}},	//   zerű, _shih_, _gety, _мазу,
   {{0x63a400f4,0x272200e2,0x63bb01ef,0xb05b13b8}},	//   _šint, _sưng_, sxun, tkäp,
   {{0x297a02b5,0x7985001e,0x63ab012e,0x7b10033b}},	//   סטרא, ithw, _trgn, läut,
   {{0xa3bb03c5,0xb4d50026,0x63ab0036,0xbf050099}},	//   _حاضر_, हसी_, _urgn, ळवून_,
   {{0x63a91bc5,0x673b08c7,0x161d1bc6,0x217500af}},	//   mven, _muuj, _फरार_, _дуир,
   {{0x63a91bc7,0x6da319c3,0xed5a15d6,0xada30384}},	//   lven, мира, роб_, марл,
   {{0x161e0066,0x27220023,0x63a91bc8,0x60dd0110}},	//   येटर_, _tưng_, oven, chsm,
   {{0x6b841bc9,0xab661bca,0x798500e9,0x0aea1bcb}},	// [1340] utig, ювал, ethw, адай_,
   {{0x6b841bcc,0x63a91bcd,0x6023010b,0x00000000}},	//   rtig, iven, _ідэа, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xac7600b5,0x765a1bce,0x6d4e008c,0x274a0fb4}},	//   _بادش, _sety, mpba, ачко_,
   {{0x63a90120,0x765a1bcf,0x7cf3003c,0x753a0065}},	//   jven, _pety, għru, _sutz,
   {{0x63a91bd0,0x356a1a5a,0x7d161bd1,0x645d008a}},	//   dven, арин_, llys, ðsin,
   {{0xd547051b,0x63a912b2,0xe6da0084,0xa9671bd2}},	//   опје_, even, _भतीज, _мира_,
   {{0x94aa0678,0x387f0037,0xa3d5022e,0x7d161bd3}},	//   ртка_, _gcur_, सनं_, nlys,
   {{0x63a91bd4,0xdb040176,0x00000000,0x00000000}},	//   gven, nviï, --, --,
   {{0x63a402c4,0x7d1600e9,0x6f020079,0x0bb700a5}},	//   _šins, hlys, _íoch, קלים_,
   {{0x6ebe0026,0x63a91bd5,0xdb0401ef,0x7d161bd6}},	//   शानु, aven, nxiñ, klys,
   {{0x63a91105,0x00000000,0x00000000,0x00000000}},	//   bven, --, --, --,
   {{0x63a90043,0x66cf0044,0x4ea7196c,0x691802d7}},	//   cven, _søki, орва, víel,
   {{0xe297146b,0xe7f2073f,0x7d160345,0x00000000}},	//   _мач_, _आइना_, elys, --,
   {{0x7b1001ae,0x78170808,0x75220345,0xddc50225}},	//   häus, _तर्क_, _khoz, _dehş,
   {{0xd5a407a8,0x69c300ab,0xdcee0228,0x00000000}},	//   _یہ_, änem, tubā, --,
   {{0x28ab0d00,0x6d4e0345,0x00000000,0x00000000}},	// [1350] _घोषि, apba, --, --,
   {{0x7e9904e8,0x69370124,0x3958099e,0x387f1bd7}},	//   _اندر_, _oćet, _bwrs_, _scur_,
   {{0xdcfc0080,0x3958001e,0x63a91bd8,0x658a00a8}},	//   strā, _cwrs_, zven, _səhn,
   {{0x79851bd9,0x236601cc,0x6ee90b16,0x63a91bda}},	//   rthw, _ovoj_, džbi, yven,
   {{0x7d0d0043,0xba7707f6,0x66dd01cb,0x98aa00fe}},	//   moas, _واست, _lèke, _hubě_,
   {{0x60dd01f4,0x63a91bdb,0x7d0d1bdc,0x752201d7}},	//   ërmj, vven, loas, _ahoz,
   {{0x3958001e,0x00000000,0x00000000,0x00000000}},	//   _gwrs_, --, --, --,
   {{0x63a902dd,0x7d0d1663,0x2ec805f7,0xb4d500ab}},	//   tven, noas, _रक्त, हसे_,
   {{0x63a90248,0x225c023a,0xdbe300f6,0x00000000}},	//   uven, _bevk_, _déço, --,
   {{0x67210a66,0x0322005f,0x2b4b00e2,0x2366063c}},	//   _uhlj, ндын, _mtcc_, _dvoj_,
   {{0xa0a60390,0x66dd0118,0x7d0d0421,0x00000000}},	//   панд, _cèke, koas, --,
   {{0x21061bdd,0x2b4b011e,0x00000000,0x00000000}},	//   रवेश_, _otcc_, --, --,
   {{0x087602b5,0xe45602b5,0xdfd2017e,0x2b590027}},	//   הערט_, _זינט_, ريس_, _nwsc_,
   {{0x75291bde,0x00000000,0x00000000,0x00000000}},	//   lmez, --, --, --,
   {{0x2cf9020d,0x412a0382,0x00000000,0x00000000}},	//   ्कूल_, _локо_, --, --,
   {{0x0b461bdf,0x201e01c2,0x2b59009f,0xb05b00c3}},	//   знан, ətin_, _bwsc_, ljän,
   {{0x7d161be0,0x2b59099e,0xfc030c90,0x98a4004b}},	// [1360] rlys, _cwsc_, епто, _gimę_,
   {{0x6d4e1be1,0x7d161be2,0x25ec00ab,0x00000000}},	//   ppba, slys, _अइली_, --,
   {{0xbe3b00a5,0x7d160304,0x75291be3,0xf1cb0099}},	//   _לעית, plys, kmez, ाहिन,
   {{0x7d0d1be4,0xc18c0070,0x658a013b,0x00000000}},	//   coas, שטאָ, _dəhl, --,
   {{0xdc3700c2,0x68e31be5,0x00000000,0x00000000}},	//   _מאכט_, ënda, --, --,
   {{0x7b10033b,0x66e3093e,0xa01b008d,0x658a013b}},	//   räus, ноча, sgög, _fəhl,
   {{0x23661be6,0x8af00095,0xceb30122,0x39e70382}},	//   _svoj_, ssəs, תיו_, _едро_,
   {{0x68130035,0x225c0225,0x00000000,0x00000000}},	//   _będą, _sevk_, --, --,
   {{0x2005027d,0x09c40033,0x66dd0118,0x225c02a7}},	//   ğlik_, _এইটা, _sèke, _pevk_,
   {{0x20050448,0x66dd0118,0xdb0f0090,0x00000000}},	//   şlik_, _pèke, _arcê, --,
   {{0x74160647,0x7d0d023c,0x00000000,0x00000000}},	//   _کوشا, yoas, --, --,
   {{0x69370a78,0x236601fe,0x09f700a5,0x55bb00a5}},	//   _kćer, _tvoj_, למים_, _למבו,
   {{0xa3cd0cea,0x00000000,0x00000000,0x00000000}},	//   रहण_, --, --, --,
   {{0xdefb06d8,0x63a21be7,0x9f4e05ee,0x00000000}},	//   сым_, _ison, ðnám_, --,
   {{0xbbc50355,0x7d0d1be8,0xec6b0210,0x629a0f93}},	//   लङ्क, toas, йрак_, meto,
   {{0xfc3f1be9,0x7aee01e4,0x51fb00a5,0x629a0cec}},	//   _baía_, _ambt, _להוצ, leto,
   {{0x7d0d002d,0x63a20069,0xfc3f1bea,0x2c22012f}},	// [1370] roas, _json, _caía_, _मरणं_,
   {{0x7f4d0132,0x63a2002f,0x80180b8d,0x7d0d1beb}},	//   _itaq, _mson, _عزيز_, soas,
   {{0x7d0d1bec,0x69da018d,0x75290031,0x00000000}},	//   poas, _ütel, ymez, --,
   {{0x3ce01bed,0x63a21bee,0x57f51347,0x629a1bef}},	//   chiv_, _oson, мпет, heto,
   {{0xd3660a42,0x629a1bf0,0x6d4a00da,0xdcfc002d}},	//   _جه_, keto, _çfar, stră,
   {{0x629a1bf1,0x658a01c2,0x2ca91bf2,0x66cf03d0}},	//   jeto, _təhl, ldad_, _nøkt,
   {{0x63a21bf3,0x65920274,0x7f4d009f,0x75291bf4}},	//   _ason, вају, _ltaq, tmez,
   {{0x2ca91bf5,0xddde0107,0x7f4d013b,0x81cb0033}},	//   ndad_, _depň, _otaq, _রইল_,
   {{0x75290484,0xb05b013c,0x2ca900de,0xe739001e}},	//   rmez, tjän, idad_, _grŵp_,
   {{0x2bdf000c,0x658a00a8,0xe3ca02d7,0x00000000}},	//   पैया, _zəhm, _soñó_, --,
   {{0x7f4d1423,0x63a21bf6,0x93ca006c,0xdb2400b5}},	//   _ataq, _eson, مایہ_, ésén,
   {{0x290f1bf7,0x6aa7023a,0x63a2005f,0x3cf90067}},	//   noga_, _lajf, _fson, ्कों_,
   {{0x2ca91bf8,0x03a5002d,0x00000000,0x00000000}},	//   ddad_, _цило, --, --,
   {{0x629a1bf9,0x6aa71bfa,0x2ca91bfb,0x290f1b68}},	//   ceto, _najf, edad_, hoga_,
   {{0x386d0446,0x290f1bfc,0x6f0e0076,0x3ce0006d}},	//   _oder_, koga_, robc, thiv_,
   {{0x386d01f4,0x00000000,0x00000000,0x00000000}},	//   _nder_, --, --, --,
   {{0x63a2027a,0xdb060097,0x658a00a8,0x394d08b7}},	// [1380] _xson, _arká, _rəhm, _česa_,
   {{0x3ce0006d,0xb05b01ff,0x658a00a8,0xe3a704cd}},	//   shiv_, hjäl, _səhm, _یر_,
   {{0x88861bfd,0x290f1bfe,0x62830453,0x00000000}},	//   длеж, foga_, _mcno, --,
   {{0x290f1bff,0xa3cd0e3b,0xa3bf0437,0x386d11cb}},	//   goga_, रहा_, ीहा_, _cder_,
   {{0x629a1c00,0xd70a00af,0x60dd0031,0x6aa7023a}},	//   yeto, онде_, ërmi, _fajf,
   {{0x386d1c01,0x473300d4,0x629a1c02,0x2b520176}},	//   _eder_, вніс, xeto, mpyc_,
   {{0x290f1c03,0x629a0fb0,0x63a2073a,0x00000000}},	//   boga_, veto, _sson, --,
   {{0x629a018e,0x66cf0185,0x290f0027,0x00000000}},	//   weto, _søkt, coga_, --,
   {{0xd90d1c04,0x629a1c05,0xa68612b1,0xb6cb00fd}},	//   _این_, teto, _олад, _ڈالے_,
   {{0xb6cb00f5,0x62830176,0x68e200ac,0x00000000}},	//   _والے_, _ccno, lhod, --,
   {{0x629a1c06,0x658a01c2,0x02a300d8,0x26cc1945}},	//   reto, _məhk, трым, _iodo_,
   {{0x63a21c07,0x629a1c08,0x7549006c,0x62830069}},	//   _tson, seto, őszö, _ecno,
   {{0x629a1c09,0x63a21c0a,0x04430b46,0x26cc1c0b}},	//   peto, _uson, _речн, _kodo_,
   {{0xe1ef1c0c,0x7ce30006,0x2cb91c0d,0x26cc122f}},	//   اسی_, _kõrg, _snsd_, _jodo_,
   {{0x26cc0f1f,0x9f3402ce,0xdc3a0723,0xc3270082}},	//   _modo_, тері, _açık, _تكون_,
   {{0x63ad0009,0xe7ab00a0,0x2ca902d7,0x68e200ac}},	//   _šani, _ďaľš, udad_, jhod,
   {{0x2ca91c0e,0x290f1c0f,0x68e21c10,0x6aa70282}},	// [1390] rdad_, voga_, dhod, _pajf,
   {{0x26cc1c11,0xcf27017e,0x60cd00cc,0x27e60118}},	//   _nodo_, _تربي, _hoam, dzon_,
   {{0x290f1c12,0x6aa70009,0x7ce300ab,0x68e31c13}},	//   toga_, _vajf, _nõrg, ëndo,
   {{0x2fe4027d,0xf8690037,0xa41e021a,0x00000000}},	//   _örgü_, سمتي_, _परंप_, --,
   {{0x26cc108a,0x6aa70478,0x60cd0160,0xf7f400fd}},	//   _bodo_, _tajf, _moam, پسند,
   {{0xf7700a42,0x26cc0453,0x6f020079,0x290f001c}},	//   شاه_, _codo_, _íoct, soga_,
   {{0x27e600d7,0x68e2023a,0x290f0124,0xa5641c14}},	//   azon_, bhod, poga_, ندين,
   {{0x68e21298,0x27e6027d,0xce38011d,0x26de00ee}},	//   chod, bzon_, ואות_, _elto_,
   {{0xe3b107f6,0x248d1c15,0x7d0301ef,0x628300ee}},	//   ارب_, rfem_, _ínsu, _pcno,
   {{0x26cc1c16,0x888100fd,0x00000000,0x00000000}},	//   _godo_, _شیڈن, --, --,
   {{0x78a900ab,0xcb12011d,0x78bb0298,0x60cd00f6}},	//   _kaev, רלי_, _knuv, _boam,
   {{0x26c701cc,0x6adc0355,0x98b80029,0xe45400d8}},	//   ljno_, _यत्र, _kurā_, _акцы,
   {{0x95221c17,0x60cd0043,0x26cc1c18,0xb05b00c3}},	//   _حکوم, _doam, _yodo_, nkäy,
   {{0x68e2114d,0xd36e11cf,0x78a9007c,0x628300d7}},	//   zhod, _اهو_, _laev, _ucno,
   {{0x60cd1c19,0x3eba0023,0x27e600b5,0x7d091c1a}},	//   _foam, _vnpt_, zzon_, česn,
   {{0xdca31c1b,0x78a91c1c,0x7693037a,0x64491c1d}},	//   ласи, _naev, lıyı, ncei,
   {{0xac070e75,0xeb971c1e,0x68e2024e,0x683601d6}},	// [13a0] ента_, нит_, vhod, _müdü,
   {{0x62811c1f,0x09e61c20,0x7693027b,0x4e1101c0}},	//   nglo, нозн, nıyı, _दुवै_,
   {{0xd9100332,0xae5b0122,0x26cc1c21,0x443d0273}},	//   لیس_, _מכיר, _rodo_, _ogw_,
   {{0x38600082,0xa01b022a,0x26cc1c22,0x68e200b8}},	//   úir_, mför, _sodo_, uhod,
   {{0xa01b013c,0x26cc1c23,0x68e203d0,0xcc3b016b}},	//   lför, _podo_, rhod, _מעכט,
   {{0x644b1c24,0x68e21321,0x569400cf,0x7ce300be}},	//   _afgi, shod, такт, _põrg,
   {{0xa01b1c25,0x68e20254,0x26cc008b,0x25a5021d}},	//   nför, phod, _vodo_, _csll_,
   {{0x28c70066,0x7ce300ab,0xe51006bc,0xd37a0279}},	//   _रचयि, _võrg, ावधि_, пчо_,
   {{0x26cc12d1,0x29041c26,0x00000000,0x00000000}},	//   _todo_, _ijma_, --, --,
   {{0x60cd0391,0xa01b013c,0x026a00c3,0x6281017b}},	//   _soam, kför, чший_, gglo,
   {{0x661100e0,0x60cd0160,0x00000000,0x00000000}},	//   _پژوا, _poam, --, --,
   {{0x73e61c27,0xa01b013c,0x443d030d,0x64490392}},	//   _поез, dför, _ggw_, ccei,
   {{0x63ad0009,0xddcc0355,0xef1f1c28,0xe3af0088}},	//   _šanv, _čišt, stüm_, _هرو_,
   {{0x661a1c29,0x673a0024,0x00000000,0x00000000}},	//   _kytk, _jitj, --, --,
   {{0xdd94004b,0x673a0955,0x60cd002d,0xfcd9006c}},	//   лары, _mitj, _toam, وارڈ_,
   {{0x673a1c2a,0x00000000,0x00000000,0x00000000}},	//   _litj, --, --, --,
   {{0x661a00ee,0x00000000,0x00000000,0x00000000}},	// [13b0] _lytk, --, --, --,
   {{0xff50004f,0x78a900b9,0x29041c2b,0x213b0069}},	//   _اخي_, _saev, _ajma_, _hiqh_,
   {{0x317e1c2c,0x00000000,0x00000000,0x00000000}},	//   nutz_, --, --, --,
   {{0x6ee201ba,0xda081c2d,0x6d550223,0x00000000}},	//   _vôbe, رينه_, mpza, --,
   {{0x317e01ae,0x07a51c2e,0x981401c8,0x7ce3007c}},	//   hutz_, талн, льшч, _võrd,
   {{0xcf9402b5,0x7e67012e,0x212900e0,0x317e01ed}},	//   רטס_, najp, _lhah_, kutz_,
   {{0x6b8d1c2f,0xceb402b8,0x24861b1c,0x673a1c30}},	//   ltag, טיס_, _bcom_, _ditj,
   {{0xdb0606d2,0x62811c31,0x24861c32,0x673a02a2}},	//   _erkä, wglo, _ccom_, _eitj,
   {{0x6b8d0dc5,0x64491c33,0x479418dd,0x6281099e}},	//   ntag, rcei, _مجلس, tglo,
   {{0x21291c34,0xd90d006c,0x64491c35,0x57f41c36}},	//   _ahah_, _ایچ_, scei, _спут,
   {{0x057400d1,0x69c50055,0x6b8d1c37,0x00000000}},	//   _ماند, nxhe, htag, --,
   {{0x212900d7,0x6b8d1c38,0x62811c39,0xa01b01ff}},	//   _chah_, ktag, sglo, vför,
   {{0xa8560122,0x33271c3a,0x660401d6,0x658a00a8}},	//   כירה_, _thnx_, şikt, _rəhi,
   {{0x658a01c2,0x6b8d1c3b,0xe1f101ca,0x249f1c3c}},	//   _səhi, dtag, _پست_, leum_,
   {{0x8d63192f,0x92580037,0x213b1c3d,0x98b80160}},	//   ивре, _أشهر_, _fiqh_, _jură_,
   {{0xa01b1c3e,0x98b80160,0x00000000,0x00000000}},	//   rför, _mură_, --, --,
   {{0xa01b022a,0x6b8d1c3f,0xcb671c40,0x6d5502a2}},	// [13c0] sför, gtag, кате_, apza,
   {{0xa01b01ff,0x00000000,0x00000000,0x00000000}},	//   pför, --, --, --,
   {{0xfaa31c41,0xa01b0093,0x673a0223,0xef1f00b5}},	//   рахо, ngön, _ritj, ztük_,
   {{0x673a1c42,0x6b8d1c43,0x080a00f8,0x00000000}},	//   _sitj, btag, وزشي_, --,
   {{0x2ca0007c,0x673a1c44,0x272901ba,0x98b80160}},	//   meid_, _pitj, kúnd_, _aură_,
   {{0x2ca01c45,0x98b80118,0x66dd0107,0xda650c74}},	//   leid_, _bură_, _dèko, _مافي,
   {{0x673a0044,0x442000d8,0x888402fd,0x5fa90035}},	//   _vitj, _ši_, _میان, _चैनल,
   {{0x442001a5,0x2ca000ab,0xb4dc0026,0xef1f00b5}},	//   _ơi_, neid_, डसे_, ttük_,
   {{0xccf30052,0xf7461c46,0x07a30132,0x2b46004f}},	//   יכה_, _резо, _катн, íoch_,
   {{0x2ca01c47,0x21291c48,0x2d9a0c61,0x673a1192}},	//   heid_, _shah_, _oppe_, _uitj,
   {{0x60f9019b,0xc486189d,0x2ca01c49,0x6b8d1c4a}},	//   ення_, _алек, keid_, ztag,
   {{0x6b8d010d,0x249f0067,0xdb040421,0x64a610b4}},	//   ytag, ceum_, lviä, _јада,
   {{0x2ca000ab,0x44200019,0x996200b8,0xddde0107}},	//   deid_, _ái_, _níže_, _depō,
   {{0x44260232,0x2d471c4b,0x6d430118,0x00000000}},	//   _izo_, _põe_, _énak, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6b8d1c4c,0x2ca000b9,0x2009006d,0x00000000}},	//   ttag, geid_, _txai_, --,
   {{0xbab91c4d,0x6b8d1786,0x00000000,0x00000000}},	// [13d0] нгах_, utag, --, --,
   {{0x6b8d1c4e,0x7a40024e,0x249f1c4f,0xbb19004f}},	//   rtag, vští, zeum_, رياض_,
   {{0x6b8d1b39,0x249f012f,0x2ca01c50,0x00000000}},	//   stag, yeum_, beid_, --,
   {{0xf7711c51,0x2ca0009e,0x60dd00d8,0x98ad004e}},	//   مات_, ceid_, nksm, _mieć_,
   {{0xb05b1c52,0x6d45023c,0x44260b13,0x00000000}},	//   rjäh, _huha, _nzo_, --,
   {{0x6d451c53,0x6f150033,0xd6db0352,0xc5f40033}},	//   _kuha, nozc, ьте_, _ছড়া_,
   {{0xa8a71c54,0x6d451c55,0x29881c56,0xf3f900af}},	//   _ирак, _juha, _исто_, maţi_,
   {{0xf3f9002d,0xd92800af,0x15b80409,0x60dd02a2}},	//   laţi_, _ацул_, тышы_, jksm,
   {{0x6d451c57,0xe796103b,0x42d5010b,0xf4950919}},	//   _luha, _مالک, гіну, نشکد,
   {{0xdb04051b,0x2fd90297,0x63ad18cc,0xf3f9002d}},	//   rviç, dysg_, _šans, naţi_,
   {{0x333c1c58,0x442601a8,0x658a00a8,0x6d451c59}},	//   _divx_, _ezo_, _səhv, _nuha,
   {{0xcea90052,0xf48711b9,0x7582006c,0x455a00a5}},	//   _מי_, _јужн, _ایٹم, _נכנס,
   {{0x645b1c5a,0x7760006d,0x7f441c5b,0x6d45021d}},	//   mbui, _xwmx, _quiq, _auha,
   {{0x201e0029,0x6d451c5c,0x645b1c5d,0xf3f900af}},	//   āti_, _buha, lbui, jaţi_,
   {{0xfce61c5e,0x2ca0007c,0xe29601d3,0xe8200127}},	//   гово, teid_, _сащ_, _बर्थ_,
   {{0x6d451c5f,0xee371c60,0x645b0223,0x61d6011d}},	//   _duha, унс_, nbui, _תוקף_,
   {{0x2ca01c61,0x6d45191c,0x8b65026e,0x0c261c62}},	// [13e0] reid_, _euha, لالم, уман,
   {{0x2ca00006,0x3f821c63,0xf3f900af,0xab771c64}},	//   seid_, muku_, gaţi_, املا_,
   {{0x3f821c65,0x6d450232,0x2d9a013c,0x658a00a8}},	//   luku_, _guha, _uppe_, _yəhu,
   {{0x7d7b0100,0xa3e3004e,0x00000000,0x00000000}},	//   _אנטו, नना_, --, --,
   {{0x3f821c66,0x6d451c67,0x69c318fb,0x3869008d}},	//   nuku_, _zuha, äner, ðara_,
   {{0xf3f9002d,0x645b0345,0x7d041c68,0x236d00a0}},	//   caţi_, ebui, lnis, dsej_,
   {{0x3f821c69,0x224e0065,0x98b8005f,0x44261c6a}},	//   huku_, _rffk_, _aurą_, _szo_,
   {{0x33741c6b,0x3f821c6c,0x7d040d19,0x2ed105fc}},	//   агир, kuku_, nnis, _सक्त,
   {{0x7d041c6d,0xd70a01b8,0xdb0600ee,0x98ad0067}},	//   inis, _знае_, _aské, _sieć_,
   {{0x7d041c6e,0x44260124,0x3f821c6f,0x92b60c74}},	//   hnis, _vzo_, duku_, احظا,
   {{0x6f150097,0x98b8004b,0x00000000,0x00000000}},	//   vozc, _eurą_, --, --,
   {{0x2ba50821,0x3386087b,0x6d451c70,0x7d0901c0}},	//   _ऑनला, _букв, _ruha, česk,
   {{0x6d451c71,0x60dd1c72,0x644202b3,0xe3b21c73}},	//   _suha, rksm, _igoi, _درا_,
   {{0x6d451c74,0x7d041c75,0xf1a61c76,0x78a20207}},	//   _puha, enis, _брин, heov,
   {{0x59a4004e,0x7d041c77,0x78a211f0,0x6f1500d5}},	//   _गैलर, fnis, keov, rozc,
   {{0xd9040df3,0x7d160159,0x3f8200f4,0x78a202c4}},	//   _ری_, goys, buku_, jeov,
   {{0x161b021a,0x78a21c78,0xf3f9002d,0xdbc601ae}},	// [13f0] _पुनर_, deov, taţi_, röße,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7d0402c9,0x658a0095,0xad270609,0xf3f9002d}},	//   bnis, _məhs, _مرحو, raţi_,
   {{0xd24601cb,0xe8200174,0x64421c79,0xf3f900af}},	//   _ژن_, _बरखा_, _ngoi, saţi_,
   {{0xd5b8013a,0x2d910291,0x62980e6a,0x47350b25}},	//   _arā_, ltze_, _obvo, андс,
   {{0x4b7a02b5,0x6aae0069,0x64421c7a,0x2d910065}},	//   _באשו, _gabf, _agoi, otze_,
   {{0x2d831c7b,0x2d9101d7,0x645b01bf,0x3f821c7c}},	//   nuje_, ntze_, tbui, zuku_,
   {{0x09e1004e,0x67d50369,0x78a2023a,0x2d9101b7}},	//   पनीय, _кобу, ceov, itze_,
   {{0x2d830991,0x645b1c7d,0xb4d50299,0xe787015a}},	//   huje_, rbui, _सकी_, _љубо,
   {{0x64421c7e,0x3ae4022a,0xa3c6007c,0x3f82011c}},	//   _egoi, _köpa_, _उपर_, vuku_,
   {{0x2d830d5c,0x645b1c7f,0x41061c80,0x3ea31c81}},	//   juje_, pbui, изов, dejt_,
   {{0x3f821c82,0xf530004f,0x00000000,0x00000000}},	//   tuku_, _فإن_, --, --,
   {{0x7d040124,0x8c3b02b1,0x3ae40523,0x00000000}},	//   vnis, _maßs, _löpa_, --,
   {{0x3f82039a,0xc8e2004e,0x2d8301d5,0xef17002d}},	//   ruku_, _खत्म_, fuje_, имя_,
   {{0x7d041c83,0xacf6192f,0x3f8201a8,0x6da61c84}},	//   tnis, ачај, suku_, шива,
   {{0x3f821c85,0xdb0f0176,0x7ce300ab,0x26f2073f}},	//   puku_, _arcà, _põra, _अग्र_,

   {{0x7d041c86,0x2d9101ed,0x78a200f4,0x00000000}},	// [1400] rnis, atze_, veov, --,
   {{0xeb971c87,0xba2600d8,0x658a00a8,0x00000000}},	//   риф_, адзк, _məhr, --,
   {{0x7e7b0122,0x78a20223,0xc8661c88,0xed5a1c89}},	//   _באיז, teov, атли, _шон_,
   {{0xd7fa1c8a,0x3ae40523,0x00000000,0x00000000}},	//   кул_, _döpa_, --, --,
   {{0x27e00514,0x78a2024b,0xb8ce0ec5,0x00000000}},	//   áin_, reov, _कस_, --,
   {{0x6442004a,0x6b84024a,0x00000000,0x00000000}},	//   _sgoi, muig, --, --,
   {{0x3567005f,0x27e002f6,0x6b841c8b,0xafdb08c8}},	//   арын_, šin_, luig, ncør,
   {{0xd9431c8c,0x658a00a8,0x63b90090,0x00000000}},	//   _фети, _bəhr, _brwn, --,
   {{0x667600bf,0x26161c8d,0xb4d600a1,0x1afb0033}},	//   _ندار, _पुरी_, _हवी_, ্তরে_,
   {{0x63ab008c,0x00000000,0x00000000,0x00000000}},	//   _dsgn, --, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d831c8e,0x6ee200ee,0xd5fb024b,0x63b9099e}},	//   vuje_, _bôbo, _בפבר, _frwn,
   {{0x658a01c2,0x89370070,0x61ff00a8,0x2d830035}},	//   _təhs, ירטע_, _əylə, wuje_,
   {{0xdefb01c8,0x539b011d,0x00000000,0x00000000}},	//   тым_, _סיוו, --, --,
   {{0x27290037,0x3ea301f4,0xcf8e00f8,0x8e380037}},	//   núna_, rejt_, وژی_, لسفر_,
   {{0x2d9101d7,0x3ea31c8f,0x6b840098,0x00000000}},	//   rtze_, sejt_, fuig, --,
   {{0x2d831c90,0x3ea300da,0x6f950037,0x6b841c91}},	// [1410] suje_, pejt_, _الخض, guig,
   {{0x2d83113c,0x3ce9006f,0x62881c92,0xed4e00b5}},	//   puje_, shav_, ngdo, بھی_,
   {{0xaf340a42,0xf9f902e7,0xdb2600fd,0x00000000}},	//   _بريت, دفاع_, حولی, --,
   {{0xb4d50c57,0x6d5701d7,0x6b840afc,0x00000000}},	//   _सके_, _itxa, buig, --,
   {{0x6d480187,0x395a0069,0xfbc800b8,0x00000000}},	//   ídav, apps_, रमणम, --,
   {{0x9a840431,0x29060065,0x00000000,0x00000000}},	//   _мусл, anoa_, --, --,
   {{0x25ac0023,0x00000000,0x00000000,0x00000000}},	//   _csdl_, --, --, --,
   {{0xe91900d4,0x00000000,0x00000000,0x00000000}},	//   _собі_, --, --, --,
   {{0x658a00a8,0xdd020124,0x2d7300f4,0x317e01ed}},	//   _qəhr, šuću, hće_, ertz_,
   {{0x6d5701a3,0x2d7300f4,0xa2e50279,0x00000000}},	//   _otxa, kće_, соод, --,
   {{0x6d570189,0xd9f90f06,0xb5fc0069,0x00000000}},	//   _ntxa, ्पित_, _leġj, --,
   {{0x62880223,0x658a013b,0x00000000,0x00000000}},	//   agdo, _təhr, --, --,
   {{0xe2990c93,0x2eea1c93,0x6d5701a3,0x5eb10033}},	//   _бал_, thbf_, _atxa, ঞানে,
   {{0x63a91c94,0xd9f90d2a,0x00000000,0x00000000}},	//   mwen, ्पात_, --, --,
   {{0x63a91c95,0xdef9010b,0x8db501e0,0x00000000}},	//   lwen, рыў_, ості, --,
   {{0x6b841c96,0xb4d507b5,0xa5da016b,0x79850027}},	//   tuig, _सको_, אַמי, duhw,
   {{0x60c41c97,0x3ce004ca,0x6d5701d7,0xd0fb0070}},	// [1420] _inim, rkiv_, _etxa, _תּור,
   {{0x60d60453,0xff260043,0x4bd90421,0x00000000}},	//   _hoym, _ымпо, шься_, --,
   {{0xbed702b5,0x60d6027d,0x63a9033b,0x29060009}},	//   _הויז_, _koym, hwen, tnoa_,
   {{0xb4d60b39,0x6d5c1c98,0x63a91c99,0xe89400d4}},	//   _हवे_, mpra, kwen, іаль,
   {{0x29061c9a,0x6fb800b4,0xb7960274,0xbcb700a5}},	//   rnoa_, इटिं, срећ, _הפכו_,
   {{0xef1f01d6,0x6ffc0029,0x63a9053e,0xfc3f01ef}},	//   ltür_, mācī, dwen, _caíu_,
   {{0x6d5c0c1f,0x60c40a78,0xc7af00b5,0x63a91c9b}},	//   npra, _onim, وڑے_, ewen,
   {{0xdbdd016f,0x98bc00ea,0x63a91c9c,0x98a600cd}},	//   zšír, īvē_, fwen, dmoć_,
   {{0x25ac022d,0x9696010e,0x63a91c9d,0x394a1c9e}},	//   _wsdl_, _греш, gwen, _hubs_,
   {{0xe73a08d9,0x68e21c9f,0x59dc00c0,0x6eeb1ca0}},	//   _сез_, lkod, _यथार, _kübe,
   {{0xba9b0070,0x658a00a8,0x5a9b0070,0x6d5c1140}},	//   נסטי, _təhq, נשטא, jpra,
   {{0x63a91ca1,0x68e21ca2,0x395802d7,0x692c00af}},	//   bwen, nkod, _mtrs_, _aşez,
   {{0x7afe00fb,0x5f94145f,0x6eeb1ca3,0x63a90027}},	//   kipt, пият, _lübe, cwen,
   {{0xff071ca4,0x39581ca5,0x60c41ca6,0x7afe0031}},	//   сямн, _otrs_, _enim, jipt,
   {{0x6d5c0e5b,0x0dc818c4,0xab5b1ca7,0x00000000}},	//   gpra, бути_, _krüg, --,
   {{0x9986006a,0x657c10db,0x25e01ca8,0x2d7300cd}},	//   łoś_, _århu, _कथनी_, rće_,
   {{0x09e100a1,0x8b580037,0x2a6a0090,0x8af91ca9}},	// [1430] पन्य, مجلس_, _bebb_, анас_,
   {{0x2d73029d,0xb4d500b4,0x7afe1caa,0x00000000}},	//   pće_, _सक्_, gipt, --,
   {{0x69de05f5,0x7f3c02b5,0x63a91cab,0x6d481cac}},	//   gype, _געזו, zwen, ídat,
   {{0x386900fb,0xad27064e,0xfc3f0391,0x9bc71482}},	//   úar_, _درخو, _saíu_, _лёгк,
   {{0x395801f7,0x00000000,0x00000000,0x00000000}},	//   _etrs_, --, --, --,
   {{0x7afe1cad,0xab5b02c9,0xe7391cae,0xb5791303}},	//   cipt, _prüf, шел_, ащих_,
   {{0x68e301e9,0x00000000,0x00000000,0x00000000}},	//   ënds, --, --, --,
   {{0x63a91caf,0x28040355,0x00000000,0x00000000}},	//   twen, ásná_, --, --,
   {{0x63a90120,0x6d5c1cb0,0x68fb00d7,0xd36e0098}},	//   uwen, zpra, _imud, نهي_,
   {{0x81d400c8,0x60c401cc,0x68e9000c,0x63a91cb1}},	//   _সেই_, _snim, _hled, rwen,
   {{0x63a91cb2,0x545506c2,0x68e91cb3,0x00000000}},	//   swen, _двет, _kled, --,
   {{0x60d60095,0x6d5c008b,0x68e90118,0x00000000}},	//   _qoym, vpra, _jled, --,
   {{0x2b591cb4,0xb05b1cb5,0xfc3f0042,0x00000000}},	//   _ntsc_, tjär, _maís_, --,
   {{0x6d5c1cb6,0x91e50226,0x68e21cb7,0x539a011d}},	//   tpra, _моле, zkod, _כינו,
   {{0x82370609,0x290d01ef,0x60d6021d,0x68fb01a8}},	//   _ارشا, _ojea_, _toym, _omud,
   {{0xb05b1cb8,0x39580009,0x6eeb02b1,0xdf4a00af}},	//   sjär, _rtrs_, _rübe, _кзид_,
   {{0x2a7801d1,0xa2cd178c,0x00000000,0x00000000}},	// [1440] _pdrb_, ताप्, --, --,
   {{0x6d5c1cb9,0x291f0088,0x68fb001c,0x290d01ed}},	//   ppra, _akua_, _amud, _ajea_,
   {{0x8c461cba,0x7afe1cbb,0x6f1c1cbc,0x68e21cbd}},	//   _мене, ript, morc, tkod,
   {{0x394d1cbe,0x319a0070,0x6f1c027a,0x69de1cbf}},	//   _čest_, יבענ, lorc, rype,
   {{0x7d090528,0x68e90118,0x7afe1cc0,0x68e20987}},	//   čest, _dled, pipt, rkod,
   {{0x7afe071f,0x68e21cc1,0x6f1c1cc2,0xf1c90ec5}},	//   qipt, skod, norc, िमान,
   {{0xc4480164,0xa2cd1cc3,0xbb4308a6,0xab5b007c}},	//   میان_, तान्, _церк, _prüg,
   {{0x68e91cc4,0xd4971663,0x1517004f,0x6f1c1cc5}},	//   _gled, орь_, يزية_, horc,
   {{0x6f1c0987,0x00000000,0x00000000,0x00000000}},	//   korc, --, --, --,
   {{0xb5fc035f,0xa3140067,0xe5a61566,0xe3af0286}},	//   _leġi, डवेज_, _мизи, ئري_,
   {{0x7ce300ab,0xab5b1cc6,0x00000000,0x00000000}},	//   _sõrm, _trüg, --, --,
   {{0x39440282,0x00000000,0x00000000,0x00000000}},	//   _jims_, --, --, --,
   {{0x6f1c1cc7,0xc49b00a5,0x00000000,0x00000000}},	//   forc, _כשאת, --, --,
   {{0x6f1c01a0,0x00000000,0x00000000,0x00000000}},	//   gorc, --, --, --,
   {{0x3eb30095,0x2b4b1cc8,0xdb0d0132,0xccfb0274}},	//   _vaxt_, _succ_, lvaç, аћа_,
   {{0x9f6b03fa,0x1fa70c9f,0x2016000d,0x7bcd1cc9}},	//   _кроз_, _дрог, écié_, txau,
   {{0x200c01c2,0x6f1c1cca,0xfc3f01ef,0x00000000}},	// [1450] şdir_, borc, _raís_, --,
   {{0x68e9117f,0x6f1c1ccb,0x2732002d,0xf43b00a5}},	//   _sled, corc, nând_, שתמש,
   {{0xa2b200b8,0xdcf50035,0x7f4d0069,0x3944008c}},	//   _असन्, erzą, _huaq, _bims_,
   {{0xaac90d53,0x63a21ccc,0x39440392,0xc23700a5}},	//   राहक, _opon, _cims_, קראו_,
   {{0x995400b8,0xa2cd164f,0x39440a8a,0x37ab001f}},	//   _výše_, ताम्, _dims_, ртен_,
   {{0x7f4d00d7,0xb3450132,0x7bda00a5,0x68e900e9}},	//   _muaq, _liçã, _הקשו, _wled,
   {{0x63a20370,0x39440260,0xd6ce0079,0xfc3f0183}},	//   _apon, _fims_, اقى_, _taís_,
   {{0x2ca919fd,0x68fb1ccd,0x6f1c1bfa,0x5fcb1cce}},	//   nead_, _umud, zorc, ामाल,
   {{0x291d0035,0x629a0103,0xe2990036,0x6f1c02d7}},	//   mowa_, ffto, бап_, yorc,
   {{0x2ca91ccf,0x386d152b,0x21201cd0,0x291d1cd1}},	//   head_, _heer_, _skih_, lowa_,
   {{0x386d1c47,0x63a21cd2,0x7d080187,0x6f1c1cd3}},	//   _keer_, _epon, édsk, vorc,
   {{0x291d1cd1,0x7cf11cd4,0x23751015,0xd59a00a5}},	//   nowa_, _hårf, _فاتح, _לבעל,
   {{0x386d1cd5,0xb5fc0484,0x7ce300be,0x7f4d0138}},	//   _meer_, _reġi, _tõrj, _cuaq,
   {{0x386d1cd6,0x2732002d,0x248d1cd7,0x835300b5}},	//   _leer_, când_, lgem_, _ٹھکا,
   {{0xa928024e,0x63bb008a,0x291d1cd8,0x2ca90037}},	//   ližš, lvun, kowa_, fead_,
   {{0x7afc1cd9,0x2ca90211,0x6f1c1cda,0x386d03c4}},	//   _smrt, gead_, sorc, _neer_,
   {{0x2d830c6f,0x291d004e,0xfc3f0391,0xa2b2111b}},	// [1460] arje_, dowa_, _saír_, _असम्,
   {{0xe81f0b4a,0x7cea0093,0x6b96013c,0x8b230086}},	//   _बड़ा_, _dýra, rtyg, едуе,
   {{0x6edb0122,0x39951cdb,0x6b961cdc,0x386d1cdd}},	//   _החיפ, gås_, styg, _beer_,
   {{0x2fc002df,0x3eaa033b,0x273200af,0x3e5700b8}},	//   _krig_, lebt_, zând_, pětí_,
   {{0xdcfc0ae0,0x4cbb0052,0x2d981cde,0x2d8a1cdf}},	//   strē, _הזכו, ltre_, lube_,
   {{0x6d461ce0,0xb4b40299,0x6b841ce1,0x7997006d}},	//   _hika, _छोड़_, mrig, btxw,
   {{0x6d461ce2,0x2d981ce3,0x61e1054e,0x6b840cfd}},	//   _kika, ntre_, jyll, lrig,
   {{0x6eeb01c2,0x6d46128f,0x38c8026b,0x94aa1ce4}},	//   _müba, _jika, _باسی_, стка_,
   {{0x6d461ce5,0x6b841ce6,0x2fc0006f,0x273200af}},	//   _mika, nrig, _nrig_, tând_,
   {{0x6d461ce7,0x386d0a75,0xdb0d03e6,0x248d03e6}},	//   _lika, _zeer_, rvaç, agem_,
   {{0x6b8401ae,0x2732002d,0x2d8a011e,0x64a61ce8}},	//   hrig, rând_, jube_, _нажа,
   {{0x6d461ce9,0x2fc00297,0xc0581a15,0x8504026b}},	//   _nika, _brig_, зір_, _کوچن,
   {{0x613f0080,0x38690093,0x2732002d,0x63a21cea}},	//   _jūli, ðari_, pând_, _upon,
   {{0x44261ceb,0x6b841cec,0x6d4603ad,0x61360093}},	//   _iyo_, drig, _aika, jálf,
   {{0x6d461ced,0x6b841cee,0x06fd00b8,0x2d8a1cef}},	//   _bika, erig, _říká_, gube_,
   {{0x6d46122c,0x442601a8,0x2d8300da,0x799701e8}},	//   _cika, _kyo_, rrje_, vtxw,
   {{0x6d460464,0x2d9c06d7,0x2ca91cf0,0x66dd02d0}},	// [1470] _dika, _även_, read_, _mèkr,
   {{0x7cea0076,0xf1b0018d,0x13df0083,0x386d0173}},	//   _výra, _जनान, _বেড়, _seer_,
   {{0x6d460523,0x291d1cf1,0xa2cd1662,0x75221cf2}},	//   _fika, towa_, तात्, _okoz,
   {{0xf771096a,0x6d460b04,0x6b841cf3,0xddde01c0}},	//   نات_, _gika, brig, _nepř,
   {{0x44261cf4,0x61120029,0x3f8b01d6,0xab5b01ae}},	//   _nyo_, nāla, nucu_, _drüc,
   {{0x386d019c,0x291d035d,0x6d461cf5,0xea63006c}},	//   _weer_, sowa_, _zika, _سپری,
   {{0x44261cf6,0xc9841cf7,0x672102c6,0x3f8b1cf8}},	//   _ayo_, _пути, _vklj, hucu_,
   {{0x7d0d1cf9,0x44260b55,0x04450423,0x61120228}},	//   nnas, _byo_, мейн, kāla,
   {{0x44260232,0x248d1cfa,0x61e1001e,0x3f8b0156}},	//   _cyo_, rgem_, wyll, jucu_,
   {{0x672101cc,0x7cf11cfb,0x7d0d0297,0x61e11cfc}},	//   _uklj, _hård, hnas, tyll,
   {{0x3dc1006d,0xa5670118,0x7d0d1cfd,0x44260273}},	//   _nrhw_, _ردان, knas, _eyo_,
   {{0x61e11cfe,0x7d0d1a8a,0x66dd0107,0x63a400af}},	//   ryll, jnas, _tèks, _ţine,
   {{0x61e102c7,0x6d461cff,0xdb0f1111,0xa2cd0355}},	//   syll, _rika, _escé, ताद्,
   {{0x2d981d00,0x75291d01,0x6d461d02,0x6b841be0}},	//   ttre_, llez, _sika, vrig,
   {{0x5f271858,0x6b841d03,0x311607b0,0x2fc00159}},	//   форм_, wrig, _офис, _wrig_,
   {{0x2d981d04,0xd1321d05,0x7d0d1d06,0x2d8a01d5}},	//   rtre_, _جمع_, gnas, rube_,
   {{0xeb971d07,0x6d461d08,0xddc71916,0x4426006d}},	// [1480] мит_, _vika, rajš, _xyo_,
   {{0x6d461d09,0xa01b0e80,0x7c260187,0x7d0d0ba0}},	//   _wika, rgöt, _vykr, anas,
   {{0x6d460ae0,0x6b841d0a,0x644b027a,0x7c260035}},	//   _tika, srig, _oggi, _wykr,
   {{0x6b841d0b,0x186703fa,0xa3bf06d9,0x644b00bf}},	//   prig, даци_, ुमा_, _nggi,
   {{0x7d04145d,0x753b0223,0xda660079,0x752900f4}},	//   miis, dmuz, _ياسي, dlez,
   {{0x644b0133,0x7d041d0c,0x7529000e,0x44260010}},	//   _aggi, liis, elez, _ryo_,
   {{0xa01b1d0d,0x7ae31d0e,0xdcf50035,0x442608dd}},	//   ngör, önte, erzę, _syo_,
   {{0x75291d0f,0x2902013c,0x7d041d10,0x7cf11b2f}},	//   glez, _öka_, niis, _gård,
   {{0x38661d11,0xdb0401ef,0x60cb009e,0x00000000}},	//   mbor_, lviñ, _ògmi, --,
   {{0x7d0400b9,0x6d5e0254,0x644b1d12,0x65c61d13}},	//   hiis, _otpa, _eggi, _обза,
   {{0x7d041d14,0xe8df0019,0x75291d15,0xd48f1d16}},	//   kiis, _hiền_, blez, _ир_,
   {{0x44261d17,0xf50302fb,0x75290036,0x61120228}},	//   _tyo_, _изхо, clez, tāla,
   {{0x7d041d18,0x6d5e1d19,0x7ce3007c,0xf4870118}},	//   diis, _atpa, _kõrv, _زانی,
   {{0xe8df01a5,0x3f991d1a,0x69c102c4,0x3f8b1d1b}},	//   _miền_, rtsu_, _šlem, rucu_,
   {{0x7d041d1c,0xc3480028,0xdd9401c8,0x7d0d1d1d}},	//   fiis, _nổi_, кары, tnas,
   {{0x7d041d1e,0x30a71a31,0x40351d1f,0x201e00af}},	//   giis, _цркв, _пейс, ştia_,
   {{0x7d0d1d20,0xfd4400d8,0xdb060523,0x00000000}},	// [1490] rnas, тэрн, _oskä, --,
   {{0x7d0d1d21,0x4ac90534,0x19eb0037,0x0dcb01d3}},	//   snas, राइव, يراً_, _думи_,
   {{0xceb202b5,0x7d04018f,0x212b00e9,0x5a4400af}},	//   _גיי_, biis, olch_, вэца,
   {{0x7d04013a,0xa81500af,0x7aee1d22,0x7cf10b3e}},	//   ciis, ндеш, _elbt, _båre,
   {{0x7cf1022a,0x8ccc0066,0x78ab03bc,0x2cb9021d}},	//   _vård, हारो, regv, _iasd_,
   {{0x6b8d002f,0x6d5800f7,0x7aee0069,0x7e750065}},	//   muag, _évac, _glbt, nazp,
   {{0xa2cd00e7,0x27e905e2,0x75290223,0x6b8d1d23}},	//   तास्, šan_, tlez, luag,
   {{0x3ce91d24,0x7cf1038d,0x672a01bf,0x7e7501ed}},	//   nkav_, _fåre, alfj, hazp,
   {{0x61360187,0x75290223,0x387f009f,0x753b0804}},	//   nále, rlez, _idur_, rmuz,
   {{0x752900b8,0x290f010d,0xaad21d25,0x7d041d26}},	//   slez, lnga_, सायक, ziis,
   {{0x91e50dba,0x290f0027,0x7cf10282,0x75291d27}},	//   хоне, onga_, _mårb, plez,
   {{0x290f01a2,0x644b0036,0x387f0024,0x6d5e021d}},	//   nnga_, _uggi, _jdur_, _rtpa,
   {{0x290f01e0,0x7d04127d,0x6b8d0453,0x13a700d1}},	//   inga_, viis, juag, _آنتی_,
   {{0x6136053d,0x7e7501a3,0x386614a6,0x2d550185}},	//   dále, gazp, zbor_, _båe_,
   {{0x7d041d28,0xdca61d29,0x6da30b46,0x4ac90026}},	//   tiis, нави, лира, राईव,
   {{0x7cea114d,0xa2cd018d,0xe05800d1,0x387f0024}},	//   _výro, ताव्, _زیست_, _ndur_,
   {{0x7d041d2a,0x61361d2b,0x2a710009,0x6b8d027a}},	// [14a0] riis, ráld, _bezb_, guag,
   {{0x7d041994,0x2cb90176,0x387f0bc0,0x00000000}},	//   siis, _easd_, _adur_, --,
   {{0x6d5e03d0,0x7d041d2c,0x88861d2d,0x7cf10b41}},	//   _utpa, piis, ележ, _såre,
   {{0xdd2f00b8,0x6b8d00d7,0x2cb901da,0x39510124}},	//   pěšn, buag, _gasd_, _duzs_,
   {{0x3c7700a5,0x387f1d2e,0x3eba0345,0x38660147}},	//   _אתכם_, _ddur_, _kapt_, rbor_,
   {{0xa82400d1,0x290f0037,0x7cf11d2f,0xe8df0023}},	//   _یکشن, anga_, _våre, _viền_,
   {{0x186a1d30,0x212b001e,0x6b491d31,0x7762002a}},	//   _нави_, ylch_, _užga, spox,
   {{0xe8df00e8,0xf3661d32,0xd943039e,0x7cf111cb}},	//   _tiền_, нтон, _беси, _tåre,
   {{0x7cf10a8a,0x7ce300be,0x2ca00098,0x290601b7}},	//   _hårc, _tõrv, ifid_, mioa_,
   {{0x877b02b8,0xdb9702b5,0x27e61d33,0x290601d7}},	//   _מאמי, עדיט_, myon_, lioa_,
   {{0xb05b017b,0x27e61d34,0x61360187,0xe6d90093}},	//   ndäg, lyon_, zále, _þráð,
   {{0x2b4a1d35,0x6b8d022e,0x29061176,0x00000000}},	//   _libc_, yuag, nioa_, --,
   {{0xa30b00f5,0xa2e61d36,0xe8df01a5,0x6d5a1d37}},	//   _کرنے_, _подд, _hiển_, ítan,
   {{0x9f3500d4,0x26de0054,0x290601ed,0xab5b0b74}},	//   тегі, _joto_, hioa_, _brün,
   {{0xa2cd0026,0x3eba1d38,0x7e751d39,0xf1a3002d}},	//   तार्, _dapt_, razp, _брын,
   {{0x26de1d3a,0x0ccf0083,0x6b8d1d3b,0x290601b7}},	//   _loto_, রস্ত, tuag, jioa_,
   {{0x60cd0232,0x26cc06a2,0x3eba0043,0x27e602e9}},	// [14b0] _inam, _ondo_, _fapt_, jyon_,
   {{0x26de1d3c,0x6b8d1d3d,0x00000000,0x00000000}},	//   _noto_, ruag, --, --,
   {{0xab5b02c9,0xdb04008d,0x6b8d1d3e,0x290f043d}},	//   _grün, rvið, suag, tnga_,
   {{0x6c7902b5,0xa95400d4,0x6b8d009e,0x290f002f}},	//   _קאָפ, укці, puag, unga_,
   {{0x27e60332,0x60cd0054,0x26de1d3f,0x6b8d11b8}},	//   gyon_, _mnam, _boto_, quag,
   {{0xd6db1d40,0xe8df0028,0x26de0b06,0x60df012f}},	//   яте_, _biển_, _coto_, _loqm,
   {{0xa8a71d41,0x5b141b78,0x27e6067f,0x29060065}},	//   _прак, _смрт, ayon_, bioa_,
   {{0x81c80033,0x60cd01a8,0x387f1d42,0xe8df00cc}},	//   োনা_, _nnam, _udur_, _diển_,
   {{0x249f1d43,0xf6990202,0xe78403d0,0x1fcb0099}},	//   rfum_, _овај_, _бухо, ामोड,
   {{0x60cd1d44,0x78bb1d45,0x00000000,0x00000000}},	//   _anam, _hauv, --, --,
   {{0x6723007a,0x6f0702f6,0xe4e701e0,0x60cd0044}},	//   monj, dijc, _підн, _bnam,
   {{0x67231d46,0x60cd009e,0xd00a03e6,0x8af0013b}},	//   lonj, _cnam, деме_, npər,
   {{0x78bb0248,0x3ae4013c,0x60cd00ee,0xe29903e6}},	//   _mauv, _köpt_, _dnam, _жал_,
   {{0x290603cb,0x60cd1d47,0x67230c6d,0x78bb1d48}},	//   zioa_, _enam, nonj, _lauv,
   {{0x27e61d49,0xeab200b5,0x81c700ec,0x00000000}},	//   zyon_, یٹر_, _blēž, --,
   {{0xfbe70023,0x645b1d4a,0x67231d4b,0x2d8400f4}},	//   _thể_, ncui, honj, čme_,
   {{0xdb0f01ef,0x3eba01e0,0x1c4611ab,0x00000000}},	// [14c0] _escí, _tapt_, тнам, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x26de1d4c,0x67231d4d,0x78bb02b1,0xdcee0225}},	//   _roto_, donj, _bauv, şkır,
   {{0x26de1d4e,0xa96710ac,0xe78600d8,0x27e602d0}},	//   _soto_, тица_, вуко, tyon_,
   {{0xa2b20429,0x26de1d4f,0x290606a2,0x27e60008}},	//   _असल्, _poto_, rioa_, uyon_,
   {{0x67231d50,0x7bc6035f,0x290606a2,0x27e60107}},	//   gonj, _irku, sioa_, ryon_,
   {{0x27e61d51,0x66e30370,0x290601a3,0x78bb00f6}},	//   syon_, роја, pioa_, _fauv,
   {{0x399c0443,0x6abc1d52,0x7bc60009,0x75390260}},	//   mís_, _harf, _krku, _chwz,
   {{0x26de1d53,0x29040484,0x6abc1d54,0x67231d55}},	//   _toto_, _imma_, _karf, bonj,
   {{0x78bb03fd,0x78a20187,0x60cd1d56,0x672300af}},	//   _zauv, lfov, _snam, conj,
   {{0x6abc1d57,0x68e01057,0x399c1d58,0x6d5a0093}},	//   _marf, _komd, nís_, ítal,
   {{0x7bc61d59,0x3ae40523,0x00000000,0x00000000}},	//   _orku, _köps_, --, --,
   {{0x399c004f,0x7bd6006d,0x53b60fbf,0x68e30132}},	//   hís_, jxyu, _अनिश, êndi,
   {{0x3d950e88,0x28a40026,0xdb1d00d5,0x6ee2021d}},	//   лигр, _गॉसि, _prsí, _sôbr,
   {{0xdef801c8,0x5e5802ce,0x29040069,0x6f0702a7}},	//   тыя_, тися_, _omma_, rijc,
   {{0x60cd1d5a,0x8c641d5b,0x399c1d5c,0x5183061c}},	//   _unam, итуд, dís_, _туша,
   {{0x6d58000d,0x7bc6023a,0x00000000,0x00000000}},	// [14d0] _évan, _crku, --, --,
   {{0x29041d5d,0x613600fb,0x78bb1d5e,0xe8df0028}},	//   _amma_, mála, _sauv, _miễn_,
   {{0xd36600f8,0x6abc1d5f,0x6136006c,0x78bb0248}},	//   _گه_, _darf, lála, _pauv,
   {{0xfc640133,0xfc3f00de,0x68e0026e,0x2d911d60}},	//   _върн, _maíz_, _comd, muze_,
   {{0xd36617bd,0x67231d61,0x9cd60122,0x6136006c}},	//   _ده_, tonj, _עושה_, nála,
   {{0x6abc1d62,0xa5b90274,0x3ae40523,0x00000000}},	//   _garf, ећих_, _döps_, --,
   {{0x399c1d63,0x6136004f,0x67231d64,0xd5af00b5}},	//   cís_, hála, ronj, تہا_,
   {{0x69c7046a,0x260200a1,0xe3b91d65,0x67231d66}},	//   _irje, _वेळी_, еби_, sonj,
   {{0x03251d67,0x67231d68,0xecc50033,0x6136008d}},	//   лдин, ponj, _একাড, jála,
   {{0xe8df00e8,0x645b1d69,0x61e80297,0x2d911d6a}},	//   _diễn_, scui, fydl, kuze_,
   {{0x394d0903,0x04951c51,0xb1461d6b,0x13a70647}},	//   _kies_, _ملاح, лнол, رنگی_,
   {{0xa6e200fb,0x2d8a022f,0x201e027d,0x69c7008c}},	//   _öðru, vrbe_, ştim_, _mrje,
   {{0x61361d6c,0x394d0086,0xdcfc0228,0x2d910051}},	//   gála, _mies_, strī, euze_,
   {{0x69c71d6d,0x27290391,0xe29917df,0xe8d013ab}},	//   _orje, múns_, _чак_, _सच्च,
   {{0x523900c2,0x2d911815,0xd33600a5,0x613d021d}},	//   _אײַנ, guze_, _גרסה_, délf,
   {{0x394d0484,0x399c1d6e,0xa3b700ab,0x6abc1d6f}},	//   _nies_, vís_, _चना_, _sarf,
   {{0x6abc1d70,0x69c71d71,0x68e0008c,0xdc75010b}},	// [14e0] _parf, _arje, _romd, рысь,
   {{0x80a000b1,0x89f601c8,0x2d911d72,0x399c1d73}},	//   ग्रे, ляец, buze_, tís_,
   {{0x6abc1d74,0x8cbf0722,0x7ce3007c,0xcd3602e7}},	//   _varf, _लोको, _võrr, _مرحب,
   {{0x399c0890,0x394d1d75,0xdb0f0310,0x673a0031}},	//   rís_, _cies_, _escà, _shtj,
   {{0x394d1d76,0x62830bc6,0x67d4002d,0x66e618d9}},	//   _dies_, _odno, ролу, лода,
   {{0xd5ba0970,0x394d0044,0x00000000,0x00000000}},	//   еси_, _eies_, --, --,
   {{0x69c7022f,0x394d04b4,0x7bc406d8,0xdb2300b5}},	//   _grje, _fies_, lviu, _óráj,
   {{0x29040657,0xc44800d1,0xfc3f0caa,0x6283001e}},	//   _umma_, نیان_, _raíz_, _adno,
   {{0x27291a71,0xd2500082,0xc6960180,0x9cd70122}},	//   gúns_, ينة_, _مشاع, רופה_,
   {{0xf746022c,0xe8df01a5,0x61e8013c,0x6136006c}},	//   _сезо, _viễn_, tydl, vála,
   {{0x62341d77,0x48fb1d78,0x546a10bb,0xe6160279}},	//   рену, लोको_, _заем_, _сфаќ,
   {{0x2d910232,0xe8df0023,0x62830260,0x61361d79}},	//   vuze_, _tiễn_, _edno, tála,
   {{0x8cbf006a,0xe47b0070,0x41b0018d,0x00000000}},	//   _लोगो, _טראכ, _जनकस, --,
   {{0x4383004f,0x6136004f,0xef1f0644,0xb3bb00a5}},	//   _الوق, rála, mrük_, _נמוכ,
   {{0x61361d7a,0x6d5802e1,0x5186005f,0x3f800176}},	//   máln, _éval, _сула, _eviu_,
   {{0x69c700da,0x557702b5,0x613600b5,0xf19300b5}},	//   _rrje, טעלן_, láln, _اُٹھ,
   {{0xe8df00e8,0x3a750368,0xdb1d01ef,0x1bd41d13}},	// [14f0] _hiện_, илар, _arsá, ботя,
   {{0x6136122d,0xe8df0028,0x394d1d7b,0x69c7003d}},	//   náln, _kiện_, _sies_, _prje,
   {{0x394d1d7c,0xc3330122,0x00000000,0x00000000}},	//   _pies_, צוע_, --, --,
   {{0x80d8073f,0x2fc90173,0x69c71d7d,0xe8df00e2}},	//   याये, _krag_, _vrje, _miện_,
   {{0x394d1d7e,0xdb0f0b4c,0x61361d7f,0x6ed9021a}},	//   _vies_, _escá, káln, मापु,
   {{0x6b8d0249,0x6d4f027b,0x2fc9009e,0x394d0110}},	//   mrag, _hica, _mrag_, _wies_,
   {{0x45191d80,0x25ac011e,0x80d8164f,0x8aa400d4}},	//   кция_, _cpdl_, यामे, _уряд,
   {{0x2bc91d81,0x6d571d82,0x7cf81d83,0x7e771d84}},	//   रिपा, _muxa, _vírg, _lexp,
   {{0x2fc9006d,0x28f80eb1,0xe69500af,0x61361534}},	//   _nrag_, _сеть_, _визы, fáln,
   {{0x6d4f0189,0x42550798,0x61361d85,0xe8df0019}},	//   _lica, штит, gáln, _biện_,
   {{0x7cf80332,0x6b8d1d86,0x2fc91d87,0xa06a1d88}},	//   _híre, hrag, _arag_, кана_,
   {{0xe8df0028,0x2fc90cfd,0x6b8d1d89,0xe046046e}},	//   _diện_, _brag_, krag, инни,
   {{0xf3670426,0x61361d8a,0x611200ea,0x2fc90211}},	//   _стен, báln, nāli, _crag_,
   {{0x6b8d1d8b,0x7d0600d7,0x7cf80037,0x2cb20090}},	//   drag, _smks, _míre, weyd_,
   {{0x2d9e0248,0x6d5701dd,0x6b8d1d8c,0x442f1d8d}},	//   îte_, _cuxa, erag, _hyg_,
   {{0x6b8d02bf,0xb4e300a1,0x3c66004b,0x2fc91d8e}},	//   frag, _नको_, ркаг, _frag_,
   {{0x6136006c,0xec4a19fa,0x6b8d0594,0x9f600421}},	// [1500] lálo, тзал_, grag, örät_,
   {{0xff7b02b5,0x78a91842,0x7bc41d8f,0x6d5701ef}},	//   _שטימ, _abev, rviu, _fuxa,
   {{0x6d4f1d90,0x442f02a4,0x613605fa,0xdca61d91}},	//   _fica, _lyg_, nálo, _кани,
   {{0xdbdc0076,0x7e7c1d92,0x6b8d1d93,0x3ead0254}},	//   lšíc, larp, brag, đete_,
   {{0x38691d94,0x6b8d00a2,0x263500e2,0x00000000}},	//   ñara_, crag, _áo_, --,
   {{0x7cf80082,0x7e7c05ee,0x613d006c,0x6d4f1d95}},	//   _díre, narp, méle, _zica,
   {{0x7cf80079,0x6d4f04fb,0xd5b00079,0x00000000}},	//   _tírd, _yica, سفة_, --,
   {{0x7d161d96,0x7e7c1d97,0x442f08c8,0xb8cb0033}},	//   nnys, harp, _byg_, _কো_,
   {{0x2bc906bc,0x61360076,0xfbc91371,0x00000000}},	//   रिया, táln, रियम, --,
   {{0xdbdc024e,0x6eeb1c28,0x00000000,0x00000000}},	//   jšíc, _tübi, --, --,
   {{0x61360076,0x7e7c1d98,0x8af000a8,0xdbdc0097}},	//   ráln, darp, vqəl, dšíc,
   {{0xb3560ef5,0xe8df0028,0xab5b02c9,0x03a60e05}},	//   _پیدا_, _viện_, _früh, _видо,
   {{0x6d4f1d99,0x7cf10909,0x7e7c00e9,0x6d440067}},	//   _rica, _dårl, farp, dmia,
   {{0xe8df01a5,0x6b8d1d9a,0x2fc91d9b,0x7e7c1d9c}},	//   _tiện_, vrag, _vrag_, garp,
   {{0x13b600e7,0x395814d8,0xab5b1d9d,0x61361d9e}},	//   _अनुभ, _nurs_, _trük, cálo,
   {{0x26f3012f,0x2fc91d9f,0x613600b5,0x00000000}},	//   _अत्र_, _trag_, náll, --,
   {{0x113c00a5,0xdbdc00ac,0xa2cb0099,0x3d08193c}},	// [1510] _בתהל, bšíc, _थोड्, _सगरे_,
   {{0x6b8d1da0,0xf9c70ebb,0x6d4f1da1,0x6d441da2}},	//   rrag, ищен, _wica, amia,
   {{0x39581da3,0x6d4f06d0,0x6b8d0110,0x7cf1029e}},	//   _curs_, _tica, srag, _hårm,
   {{0x39581da4,0x69c100ea,0x611200ea,0x9f4200d5}},	//   _durs_, _šles, tāli, myká_,
   {{0x7d0d004e,0x23660221,0x00000000,0x00000000}},	//   mias, _ntoj_, --, --,
   {{0x39581da5,0x7cf80079,0x611200ea,0x7cea008d}},	//   _furs_, _víre, rāli, _dýru,
   {{0xa5091da6,0x442f08c8,0x395802a7,0x00000000}},	//   лека_, _syg_, _gurs_, --,
   {{0x7d0d1da7,0x613600b5,0x201e0043,0x92c30033}},	//   nias, gáll, ştii_, _একে_,
   {{0x57f503e6,0xe3b10037,0x387d016e,0x00000000}},	//   _упат, سرة_, mawr_, --,
   {{0x81e200c8,0x61361721,0x7d0d0ec0,0x6d44004e}},	//   _নেই_, tálo, hias, zmia,
   {{0x7e7c008a,0x6d44001e,0x7d0d1da8,0x613d00fd}},	//   varp, ymia, kias, zéle,
   {{0x387d001e,0x5f0506d9,0x61361da9,0x2d5c0453}},	//   nawr_, होस्_, rálo, _ríe_,
   {{0x7e7c1daa,0x442f0a21,0x320b0035,0xdbdc1dab}},	//   tarp, _uyg_, ńcy_, tšíc,
   {{0xc8f418da,0x613d1dac,0x93240d47,0x3f5d00e2}},	//   _आत्म_, véle, _ورون, _dìu_,
   {{0x6d441dad,0x61460ece,0xdbdc0187,0x80d8166b}},	//   tmia, _лека, ršíc, यादे,
   {{0x7e7c0523,0x2a7801f4,0x7d0d1dae,0x4bda0086}},	//   sarp, _serb_, gias, льзя_,
   {{0x6d441daf,0x4aaa00c9,0xdbdc0187,0x7e7c1db0}},	// [1520] rmia, лкан_, pšíc, parp,
   {{0xaad21db1,0x3f821db2,0x39581db3,0x7d161627}},	//   साइक, msku_, _purs_, snys,
   {{0x7cf804a5,0x7d0d1db4,0xc87904d4,0x8e570070}},	//   _círc, bias, _beş_, _לייג_,
   {{0x2732002d,0x2b590036,0x7c9601d3,0xada600ee}},	//   mâni_, _fusc_, _уроц, _chúť,
   {{0x3f821db5,0x09e00083,0x613610b2,0x2bc9022e}},	//   nsku_, _যেখা, váll, रिणा,
   {{0xb8ef1db6,0xe3e80332,0x3ce018b0,0x3f820c13}},	//   _वो_, یکشن_, ljiv_, isku_,
   {{0xceb30122,0x23660207,0x39580223,0x3689005f}},	//   פיה_, _stoj_, _uurs_, рсін_,
   {{0xdb1d013c,0x18a31bfd,0x3ce000cd,0x4d7b016b}},	//   _ersä, _насм, njiv_, ארקע,
   {{0x3f820a78,0xe73a00c9,0x24181db7,0xe5090023}},	//   jsku_, _беа_, ропы_, vặt_,
   {{0x2bc90266,0x3f820254,0x27f900ab,0x39460f2d}},	//   रिता, dsku_, _üsna_, lmos_,
   {{0xd25010ad,0x00000000,0x00000000,0x00000000}},	//   بند_, --, --, --,
   {{0x3a3702da,0x463b02b5,0xca3700a5,0x613600b5}},	//   מרים_, _געבע, מניה_, lálj,
   {{0x39461db8,0x28cf00b4,0x00000000,0x00000000}},	//   imos_, _सोफि, --, --,
   {{0x6136006c,0x28cf1db9,0xdb1d0279,0xbb1b0139}},	//   nálj, _सोनि, _essê, _avîn,
   {{0xc27b0779,0x7d0d1dba,0x00000000,0x00000000}},	//   _גרוי, tias, --, --,
   {{0xdb0600b5,0x3f8200d5,0xe217024b,0x00000000}},	//   _eskü, bsku_, _לקוח_, --,
   {{0x6eeb00a8,0x212b1dbb,0xa2cd0099,0x7cf1029e}},	// [1530] _sübu, moch_, ताच्, _hårk,
   {{0x629a1dbc,0x7d0d1dbd,0xda670082,0x212b1dbe}},	//   ngto, sias, صائي, loch_,
   {{0xb9b51dbf,0x7d0d1dc0,0x9962024e,0xa2c01dc1}},	//   تماع, pias, _píše_, _वसन्,
   {{0x38351dc2,0x212b1dc3,0x319b016b,0x00000000}},	//   онер, noch_, רבאנ, --,
   {{0x656800da,0x7d1d1dc4,0x6fc9021a,0x2d830051}},	//   _atdh, _ijss, िटिं, lsje_,
   {{0x39461dc5,0x212b1dc6,0x613600fd,0x2d830223}},	//   amos_, hoch_, gálj, osje_,
   {{0x2d831dc7,0x13d106fe,0x212b016f,0x286b0431}},	//   nsje_, तम्भ, koch_, _брзо_,
   {{0xf8ae01cb,0x212b00a0,0x3f820096,0x2d8301e4}},	//   _لکه_, joch_, ysku_, isje_,
   {{0x290f1dc8,0x212b1dc9,0x7ae7006d,0xd7fb0819}},	//   miga_, doch_, _kojt, _сув_,
   {{0x290f1dca,0x2d830096,0xf6f500bf,0x13090086}},	//   liga_, ksje_, _بزرگ, рной_,
   {{0xf7480082,0x4615026e,0x7ae7063b,0x2d8302a2}},	//   _اللي_, _بوار, _mojt, jsje_,
   {{0x290f1dcb,0x3f820a78,0x7ae701f4,0xa4f700d1}},	//   niga_, tsku_, _lojt, _دکتر_,
   {{0x3f84031b,0x6136006c,0x6ef000be,0x2d830223}},	//   ému_, lálk, _häbi, esje_,
   {{0x3f8211d7,0x290f1dcc,0x7ae70009,0x6ef000b9}},	//   rsku_, higa_, _nojt, _käbi,
   {{0xdd9209b9,0x290f1dcd,0xddc30012,0xa2d600b4}},	//   ظور_, kiga_, мбри, बार्,
   {{0x290f1dce,0x3f821dcf,0x4c6a1dd0,0x212b1dd1}},	//   jiga_, psku_, риан_, coch_,
   {{0x290f1dd2,0x2d831c3a,0x6ef0007c,0x69c11dd3}},	// [1540] diga_, asje_, _läbi, _šlep,
   {{0x2d91004e,0xdcfc0029,0x38cb02fd,0x80d800a1}},	//   brze_, turē, یانی_, यावे,
   {{0x60c41dd4,0x3eb81dd5,0xfce61dd6,0xf86a0312}},	//   _kaim, mert_, _доно, لماي_,
   {{0xeb9a18c4,0x60c41dd7,0x290f1dd8,0x2d981dd9}},	//   _ким_, _jaim, giga_, mure_,
   {{0x39461dda,0xdb0409a6,0x39400029,0x2d981ddb}},	//   rmos_, ntië, ķis_, lure_,
   {{0x39461ddc,0x60c41ddd,0x6b84004f,0x3eb800d4}},	//   smos_, _laim, msig, nert_,
   {{0x290f1dde,0x2d981ddf,0x6b841de0,0x776914d8}},	//   biga_, nure_, lsig, _etex,
   {{0x60c41de1,0x443d02c9,0x3eb801ae,0x290f0b1a}},	//   _naim, _bzw_, hert_, ciga_,
   {{0x6b841de2,0x14a610aa,0x3eb81de3,0xa6861a56}},	//   nsig, क्षण, kert_, _млад,
   {{0xe73a1de4,0x6136006c,0x212b01ae,0x2d981de5}},	//   _тез_, lálh, woch_, kure_,
   {{0xd62a03ad,0x3eb81de6,0x60c41de7,0x1a9b0070}},	//   _тоже_, dert_, _baim, סיטע,
   {{0x613d008a,0x60c400f1,0x6136006c,0x2d981de8}},	//   féla, _caim, nálh, dure_,
   {{0x3eb81de9,0x60c41dea,0x212b1deb,0x6b8400cd}},	//   fert_, _daim, roch_, jsig,
   {{0x2d8302a2,0x6b841dec,0x3eb81ded,0x290f0b69}},	//   tsje_, dsig, gert_, ziga_,
   {{0x290f0186,0x2d981dee,0x60c41def,0x2d8500b5}},	//   yiga_, gure_, _faim, éle_,
   {{0x290f0c75,0x6b840210,0x613d002a,0x2d831df0}},	//   xiga_, fsig, béla, rsje_,
   {{0x6b840f3a,0x2002004e,0x290f1df1,0x2ca90312}},	// [1550] gsig, czki_, viga_, rfad_,
   {{0x3eb801f7,0xdb0400f7,0x80a71119,0x2d9804fb}},	//   cert_, ntiè, ट्रे, bure_,
   {{0x6b840b31,0x7ae71df2,0xfd10006c,0x3f991df3}},	//   asig, _vojt, رجہ_, lusu_,
   {{0x6b84139c,0x02b7018d,0x636701ba,0x7cf8002a}},	//   bsig, _अस्न, nčný, _tíra,
   {{0x290f1df4,0x6b841df5,0x69ce1df6,0x3f991df7}},	//   riga_, csig, _erbe, nusu_,
   {{0x290f1df8,0xc8790160,0x00000000,0x00000000}},	//   siga_, _moşi_, --, --,
   {{0x3f9919c6,0x2bc90bc1,0x290f0657,0x7cf800b8}},	//   husu_, रिवा, piga_, _mírn,
   {{0xd5ae00ad,0x61361df9,0x3f991dfa,0x628a1dfb}},	//   افي_, rálk, kusu_, _adfo,
   {{0x2d981dfc,0x48fa02b5,0x3ea10037,0xdb1d1dfd}},	//   zure_, _פּלא, _ocht_, _assé,
   {{0x60c41dfe,0x61361dff,0x613d1e00,0x68e91e01}},	//   _saim, máli, véla, _hoed,
   {{0x3eb81e02,0x60c41e03,0x68fb1e04,0xe8df00e2}},	//   vert_, _paim, _klud, _nhịn_,
   {{0x3eb801ae,0x6b8400e9,0x3ea11e05,0x7bcf143f}},	//   wert_, ysig, _acht_, _orcu,
   {{0xe28e1e06,0x68e90fdb,0x26c51e07,0x3eb81e08}},	//   _па_, _moed, _kalo_, tert_,
   {{0x2d981e09,0x60c4002f,0xdb0f0a17,0x68e91e0a}},	//   ture_, _waim, _escú, _loed,
   {{0x26c51e0b,0x62811e0c,0x60c41e0d,0x7bcf1e0e}},	//   _malo_, malo, _taim, _arcu,
   {{0x3ea11e0f,0x3eb802ce,0x3f991e10,0x26c50269}},	//   _echt_, sert_, busu_, _lalo_,
   {{0x2d981e11,0x2fc00cca,0x3f99045e,0x212001cb}},	// [1560] sure_, _usig_, cusu_, _ijih_,
   {{0x6b841e12,0x2d9801d3,0x68fb1e13,0x26c5002f}},	//   rsig, pure_, _alud, _nalo_,
   {{0x14bd0c67,0x68e91e14,0x00000000,0x00000000}},	//   ्याण, _boed, --, --,
   {{0x6d5e002a,0x61361e15,0x7e7e1e16,0x68fb00e9}},	//   _iupa, fáli, _hepp, _clud,
   {{0x7e7e008a,0x99930129,0x68e9001e,0x68e2003c}},	//   _kepp, češe_, _doed, rjod,
   {{0x6d5e1e17,0xf1db1e18,0x26c51e19,0x62811e1a}},	//   _kupa, यमान, _calo_, jalo,
   {{0x62811e1b,0x69da1e1c,0xbb431e1d,0x7e7e1167}},	//   dalo, _štef, _черк, _mepp,
   {{0x21201dce,0x68e91e1e,0x7e7e1e1f,0x6d5e1e20}},	//   _njih_, _goed, _lepp, _mupa,
   {{0x6d5e1e21,0x26c51e22,0xd46703fa,0x61360a54}},	//   _lupa, _falo_, чиње_, cáli,
   {{0xe3af1e23,0x62811e24,0x26c51e25,0x7e7e1de4}},	//   اري_, galo, _galo_, _nepp,
   {{0xd48f0ea7,0xb5ca0ae7,0x68e9012f,0xa50a1e26}},	//   _пр_, _دوام_, _yoed, _лежа_,
   {{0x64a600c7,0x3f991e27,0x38661e28,0x63a400af}},	//   _хада, tusu_, ncor_, _ţinu,
   {{0x6d5e1e29,0x7e7e1e2a,0xe50500d1,0x255500ea}},	//   _aupa, _bepp, _تبلي, _tālr_,
   {{0x6d5e1e2b,0x628a054e,0x26c50019,0x3f991e2c}},	//   _bupa, _udfo, _xalo_, rusu_,
   {{0x6d5e1e2d,0xa2a100a1,0x7e7e1e2e,0x3f991e2f}},	//   _cupa, _खात्, _depp, susu_,
   {{0x291c1e30,0x5d541e31,0xa3c000a1,0x7cf800fe}},	//   éval_, екст, _ंना_, _díro,
   {{0x68e902c7,0x201e0723,0xd00803fa,0x3b551b96}},	// [1570] _roed, ştir_, _неће_, дкар,
   {{0x68fb0080,0x61360faa,0x7cf8006c,0x68e91e32}},	//   _slud, váli, _hírl, _soed,
   {{0x68fb1e33,0xed580370,0x68e91e34,0x6d5e0afe}},	//   _plud, _ноќ_, _poed, _gupa,
   {{0xf9900fab,0x62811e35,0x61361e36,0x26c51e37}},	//   ابل_, zalo, táli, _salo_,
   {{0x2b9307e4,0x68e90244,0x37ab1e38,0x6d5e1e39}},	//   _سیاس, _voed, стен_, _zupa,
   {{0x61361055,0x628101ef,0x6d5e0138,0x68e911ad}},	//   ráli, xalo, _yupa, _woed,
   {{0x26c704c3,0x26c51e3a,0x273200af,0x68e91e3b}},	//   rdno_, _valo_, vânt_, _toed,
   {{0x26c51296,0x68fb027d,0x290d1e3c,0x62811e3d}},	//   _walo_, _ulud, _umea_, walo,
   {{0x26c51e3e,0xa2a1131c,0xf794010b,0x7f5f003c}},	//   _talo_, _खाद्, _патэ, _nuqq,
   {{0xaae0065a,0x21cc0355,0x7bcd1e3f,0x387f00f6}},	//   नायक, _běh_, ivau, _heur_,
   {{0x387f01bf,0x7e7e1e40,0x7cf1008c,0x05c101c0}},	//   _keur_, _repp, _håru, _शनिब,
   {{0x6d5e1e41,0x7e7e1e42,0xdb0400de,0x0cd80033}},	//   _rupa, _sepp, rtié, _সত্ত,
   {{0x6d5e1e43,0x387f1e44,0xe8df00e2,0x7e7e1e45}},	//   _supa, _meur_, _nhọn_, _pepp,
   {{0x387f1010,0x56b5016b,0x7cf1008c,0x00000000}},	//   _leur_, ופֿן_, _måru, --,
   {{0x6da31e46,0xdca61e47,0x00000000,0x00000000}},	//   кира, мави, --, --,
   {{0x249f00fb,0x20561e48,0x7cf81e49,0x387f1e4a}},	//   ngum_, _отпр, _víro, _neur_,
   {{0xe8df00e8,0x7e7e1ded,0x38c600c7,0x00000000}},	// [1580] _chọn_, _tepp, _jūrų_, --,
   {{0x6d5e1e4b,0x63a91e4c,0x6a160fda,0xc31f0033}},	//   _tupa, iten, وبار, _নীতি_,
   {{0x996503d0,0x80a50864,0x63a91e4d,0x6d5e08dd}},	//   етіл, _कामे, hten, _uupa,
   {{0x63a91e4e,0x274700fe,0x00000000,0x00000000}},	//   kten, _lůně_, --, --,
   {{0x387f1e4f,0x69da02f6,0x38660176,0x2ca0011e}},	//   _deur_, _šted, rcor_, mgid_,
   {{0x6136008a,0x38660392,0xdcfc010b,0x75240124}},	//   málu, scor_, turė, čizm,
   {{0x941801c2,0x63a90043,0xceb30122,0xfaa30d46}},	//   ərə_, eten, דיו_, _шаро,
   {{0x2ca01e50,0x63a91e51,0x387f1e52,0x6128033e}},	//   ngid_, ften, _geur_, nıld,
   {{0x63a91e53,0x2ca000ab,0x77910647,0x00000000}},	//   gten, igid_, _مینا, --,
   {{0x387f0051,0x7cf11e54,0xdcfe013a,0x00000000}},	//   _zeur_, _hårt, _appļ, --,
   {{0x6128027d,0x2b581e55,0x61151e56,0x00000000}},	//   kıld, _mirc_, едну, --,
   {{0x63a91e57,0x00000000,0x00000000,0x00000000}},	//   bten, --, --, --,
   {{0x63a91e58,0xa2941958,0x2bd20035,0x24f7010b}},	//   cten, _залі, सिफा, _іншы_,
   {{0x442601ed,0x2fd2017b,0x2ca0018d,0x6d461008}},	//   _ixo_, _dryg_, egid_, _ahka,
   {{0x929b00a5,0xfcc70274,0x5e5800af,0x00000000}},	//   _ויות, мљам, диря_, --,
   {{0x23d200e7,0x2b581e59,0x2ca01e5a,0x00000000}},	//   तिपद, _airc_, ggid_, --,
   {{0x2b580124,0x8ca50355,0x8aa71e5b,0x00000000}},	// [1590] _birc_, ङ्गो, дред, --,
   {{0x2d850831,0x7bcd18af,0xab9401e0,0x00000000}},	//   áles_, rvau, тифі, --,
   {{0x387f0248,0x63a91e5c,0x13b70033,0x6f1500ae}},	//   _peur_, zten, জিয়, mizc,
   {{0x09b10083,0x63a91e5d,0x6f1501d6,0xf77100ad}},	//   ছিলা, yten, lizc, هات_,
   {{0x6d4d145d,0x00000000,0x00000000,0x00000000}},	//   mmaa, --, --, --,
   {{0xd2461e5e,0x6d4d1e5f,0x6136006c,0xc87900af}},	//   _من_, lmaa, lált, _roşu_,
   {{0x44261e60,0x6d4d1e61,0x64420160,0x3860030a}},	//   _axo_, omaa, _azoi, žira_,
   {{0x6d4d1e62,0x6136006c,0xe3c800e2,0xc9840214}},	//   nmaa, nált, _bự_, _јури,
   {{0x249f008a,0x2bd213ab,0xe3c80023,0x6d4d1e63}},	//   rgum_, सिया, _cự_, imaa,
   {{0x63a91e64,0xe3c80028,0x8af00095,0x6d4d1413}},	//   rten, _dự_, qqət, hmaa,
   {{0xa0a61126,0x6d4d1e65,0xaae004aa,0x61280448}},	//   нанд, kmaa, नातक, yıld,
   {{0xcea901f3,0x7cf10a8a,0x00000000,0x00000000}},	//   _לי_, _mårs, --, --,
   {{0xc4cf006c,0x6d4d03c4,0xdb1d1e66,0x65610051}},	//   _مےں_, dmaa, _assí, _hulh,
   {{0x6d4601d2,0x65611e67,0x6d4d19c1,0x753b0c6f}},	//   _shka, _kulh, emaa, lluz,
   {{0x656100c9,0xe81607ba,0x612800d0,0x6136021d}},	//   _julh, _देना_, tıld, fált,
   {{0x656100c9,0x6d4d1e68,0x6b961e69,0x2fd20b3e}},	//   _mulh, gmaa, tryg, _tryg_,
   {{0x2ca01e6a,0xf1c901a5,0x612804d4,0xac0a03e6}},	// [15a0] rgid_, _hạ_, rıld, чнаа_,
   {{0x34bd0ea3,0x6d4d18af,0x6b960b3e,0x61280225}},	//   ्युद, amaa, rryg, sıld,
   {{0x753b1431,0x612800d0,0x613600fd,0x00000000}},	//   kluz, pıld, bált, --,
   {{0x6d4d013a,0xf1c90023,0x61361e6b,0x6d4600c3}},	//   cmaa, _mạ_, máls, _uhka,
   {{0xf1c901a5,0xe73a0665,0x00000000,0x00000000}},	//   _lạ_, пед_, --, --,
   {{0x7bc61e6c,0xe5c61a1c,0x6561024e,0x8f9b02b5}},	//   _isku, есио, _bulh, פיצי,
   {{0xaa431e6d,0xe3c800e8,0xf1c90023,0x24841ca0}},	//   _берл, _sự_, _nạ_, tamm_,
   {{0x2d981e6e,0x7d041e6f,0xcfe60033,0x38c800b5}},	//   irre_, nhis, _পেছন, _غازی_,
   {{0xd90d0357,0xe8b506d0,0x24841e70,0x00000000}},	//   _بین_, lışı, ramm_, --,
   {{0xf1c90019,0x7aee1e71,0xe816018d,0x23d2018d}},	//   _bạ_, _jobt, _देया_, तिबद,
   {{0xe8b50716,0x61361e72,0x6d4d1e73,0x7d041e74}},	//   nışı, jáls, ymaa, khis,
   {{0xe3c800e8,0x78a21e75,0x7bc6018d,0xf1c90019}},	//   _tự_, ngov, _osku, _dạ_,
   {{0x7d041e76,0x04570082,0x65611e77,0x613600b5}},	//   dhis, _كلمة_, _zulh, vált,
   {{0x3ea5006c,0xe8b5027d,0xbe0500b5,0x1ee700f8}},	//   ült_, kışı, پورٹ, روزی_,
   {{0x7bc600da,0x6d4d1e78,0x6abe0118,0x00000000}},	//   _asku, tmaa, depf, --,
   {{0x23b71e79,0x7d041e7a,0x6d4d1e7b,0xe8b501fb}},	//   _अहमद, ghis, umaa, dışı,
   {{0x6d4d1e7c,0x613607f8,0x78a204c3,0x2d9800f6}},	// [15b0] rmaa, rált, dgov, arre_,
   {{0x6d4d1e7d,0xadf501c8,0x0a6810ac,0x61361e15}},	//   smaa, _апош, ерци_, sált,
   {{0x7bc603cb,0x7d040014,0xf1c90023,0x6d4d1e7e}},	//   _esku, bhis, _xạ_, pmaa,
   {{0x7d041e7f,0x38c904e8,0xfe7005f5,0xf094016b}},	//   chis, بائی_, _پدی_, ָנס_,
   {{0xd3660088,0xdddc1e80,0x65611e81,0xa2a11e82}},	//   _خه_, marš, _sulh, _खाल्,
   {{0x3ce902f6,0x65611e83,0x00000000,0x00000000}},	//   ljav_, _pulh, --, --,
   {{0x2bc90f17,0x50b102b4,0x00000000,0x00000000}},	//   रिका, जभाष, --, --,
   {{0x69c7022f,0x3f990207,0x00000000,0x00000000}},	//   _isje, krsu_, --, --,
   {{0x3f8b004e,0xd468004f,0x7cf801f7,0x753b1e84}},	//   jscu_, رحيم_, _dírh, rluz,
   {{0x77900332,0x753b1e85,0x2bd20af9,0x466b0c4c}},	//   _ایوا, sluz, सिता, _храм_,
   {{0x3f8b1e86,0x65940409,0x7d041e87,0x412a0036}},	//   escu_, _баху, yhis, доно_,
   {{0xdddc0200,0x69d5068f,0xf1c900e2,0x741205f5}},	//   jarš, _mrze, _vạ_, اویا,
   {{0xc95202b5,0x03a5002d,0x00000000,0x00000000}},	//   ימט_, _рило, --, --,
   {{0x69c70280,0x78a20af1,0xf1c90019,0x69d50035}},	//   _osje, zgov, _tạ_, _orze,
   {{0x7d04004a,0x386d1e88,0x7aee1e89,0xe8b500a8}},	//   this, _ofer_, _robt, xışı,
   {{0x62831e8a,0x7aee0310,0x6ef9009e,0xad3901e0}},	//   _heno, _sobt, _lìbh, ечує_,
   {{0x62830118,0x7d041e8b,0x7aee01e8,0x6b630009}},	// [15c0] _keno, rhis, _pobt, икта,
   {{0x7d041e8c,0x62831e8d,0x386d1e8e,0x69d51e8f}},	//   shis, _jeno, _afer_, _brze,
   {{0x62831e90,0x7cf81d2b,0x1d0a0d28,0x23ab01b4}},	//   _meno, _líri, _жени_, høj_,
   {{0xe8b506d3,0x34bd00b4,0x69d50035,0x29000279}},	//   rışı, ्योद, _drze, óia_,
   {{0x69d51e91,0x98a31e92,0x66e61e93,0x628300a2}},	//   _erze, риче, кода, _oeno,
   {{0x62831e94,0x799e034d,0xa3d51e95,0x47330823}},	//   _neno, pupw, हिन_, аніс,
   {{0x69d5004e,0x27e00043,0x09e31e96,0xdb0f1e97}},	//   _grze, ţin_, _корн, _escó,
   {{0x3f4f0069,0x0eff021a,0x00000000,0x00000000}},	//   _jżur_, _उत्स_, --, --,
   {{0x62831e98,0x7d03002d,0x7cf80183,0x00000000}},	//   _beno, _înse, _círi, --,
   {{0x62830252,0x7cf80037,0x80a50006,0xe6c50037}},	//   _ceno, _díri, _काहे, _متمي,
   {{0x26de0052,0xe81610a6,0xcb13011d,0x4a9b0070}},	//   _into_, _देता_, שלת_, וייג,
   {{0x29061e99,0x7cf80037,0x628301bf,0x26cc1e9a}},	//   nhoa_, _fíri, _eeno, _hado_,
   {{0x26cc1e9b,0xfc3f01ef,0x43941e9c,0x29061e9d}},	//   _kado_, _acín_, _салс, ihoa_,
   {{0x62831e9e,0x04431e9f,0x26cc1ea0,0xe57100b5}},	//   _geno, _течн, _jado_, _خطے_,
   {{0x62881423,0x63a00600,0x823303c5,0xdddc024e}},	//   mado, lumn, _پروا, tarš,
   {{0x26cc0aca,0x7e620139,0x00000000,0x00000000}},	//   _lado_, _şopt, --, --,
   {{0x63a00034,0x2b4a0014,0x7c841ea1,0xac180274}},	// [15d0] numn, _bhbc_, русе, воту_,
   {{0x69d51ea2,0x62881ea3,0x26cc1a71,0x613d1ea4}},	//   _prze, nado, _nado_, déli,
   {{0xb0aa00a1,0x612804d4,0x60cd1ea5,0xed4e006c}},	//   _कामग, lıla, _kaam, تھی_,
   {{0x60cd1ea6,0xf1b302b5,0x63a01ea7,0xa3d50127}},	//   _jaam, יסע_, kumn, हिम_,
   {{0x26cc0657,0x60cd1ea8,0xb8cb1ea9,0x62881eaa}},	//   _bado_, _maam, _खा_, kado,
   {{0x69d5006a,0x62881eab,0x60cd1eac,0x69c71ead}},	//   _trze, jado, _laam, _tsje,
   {{0x26cc1423,0xdb040279,0x7cf81eae,0x69c7012e}},	//   _dado_, stiã, _síri, _usje,
   {{0x62831eaf,0x23ab054e,0x6d5d1eb0,0x612800d0}},	//   _seno, tøj_, _jisa, kıla,
   {{0x6b8d051b,0x62831eb1,0x613d1eb2,0x63a01eb3}},	//   nsag, _peno, céli, gumn,
   {{0x6d5d1eb4,0x61280463,0x26cc1eb5,0xd90d00b5}},	//   _lisa, dıla, _gado_, _بیچ_,
   {{0x628301ba,0x60cd1eb6,0x059600b5,0x5ed20033}},	//   _veno, _baam, _مانگ, _সকলে,
   {{0x6d5d1eb7,0x63a00ac8,0x60cd07a6,0x26cc0009}},	//   _nisa, bumn, _caam, _zado_,
   {{0x60cd1eb8,0x61280225,0xe2991eb9,0x00000000}},	//   _daam, gıla, _зал_, --,
   {{0x62880aca,0x6da61eba,0x3392004f,0x481602b5}},	//   cado, лига, _الوز, אַלן_,
   {{0x6d5d0b04,0x60cd073a,0xb1760019,0x6b8d1ebb}},	//   _bisa, _faam, _trượ, esag,
   {{0xa0a6081b,0x60cd001c,0x61fc008c,0x6b8d0093}},	//   _саид, _gaam, ørle, fsag,
   {{0x61281a68,0xeb97195a,0x6d5d1425,0x6b8d1ebc}},	// [15e0] cıla, лит_, _disa, gsag,
   {{0x78a90300,0x4e360071,0x2bc909b4,0x613d0093}},	//   _acev, _معجز, रिजा, véli,
   {{0x26cc1ebd,0x6d5d1ebe,0x60cd1ebf,0x2d9501fd}},	//   _rado_, _fisa, _yaam, _кряс,
   {{0x62880aca,0x613d1ec0,0x6d5d1ec1,0xfce61ec2}},	//   zado, téli, _gisa, _сомо,
   {{0x62881ec3,0x01370070,0xbcfb1485,0x26cc1ec4}},	//   yado, אָגט_, _diéd, _pado_,
   {{0x62881ec5,0x613d1ec6,0x6d5d018c,0xbcfb000d}},	//   xado, réli, _zisa, _piég,
   {{0xe1e71ec7,0x61280d6f,0x26cc0bff,0x80a508a9}},	//   _اس_, zıla, _vado_, _काले,
   {{0x26cc1ec8,0x443d0297,0x6d5d1505,0x80d4135e}},	//   _wado_, _byw_, _xisa, _बोले,
   {{0x62881423,0x29041ec9,0x60cd1eca,0x28e1051d}},	//   tado, _ilma_, _raam, फारि,
   {{0x60cd1ecb,0xc8790644,0x443d00e9,0xadf60066}},	//   _saam, _inşa_, _dyw_, ीनान_,
   {{0x60cd010d,0xba9b02b5,0x22581ecc,0x63a001a0}},	//   _paam, עסטי, ärk_, sumn,
   {{0x60cd0069,0x612806d3,0x6b8d0248,0x443d001e}},	//   _qaam, tıla, ysag, _fyw_,
   {{0x62881ecd,0x33f601b2,0x06fa0026,0x60cd1ece}},	//   pado, _حساس, _्ताव_, _vaam,
   {{0x6d5d1ecf,0x61280092,0x60cd05db,0x6b8d00d4}},	//   _sisa, rıla, _waam, vsag,
   {{0x60cd1ed0,0x69da1ed1,0xbcfb0248,0x6b4b033b}},	//   _taam, _šten, _liée, nüge,
   {{0x61280723,0x2fc9006d,0x6b8d1ed2,0x6d5d1ed3}},	//   pıla, _tsag_, tsag, _qisa,
   {{0x6d5d1ed4,0x5b151ed5,0x443d006d,0x6e950043}},	// [15f0] _visa, амат, _xyw_, _кипу,
   {{0x91a8009a,0xa3d5157d,0x6d5d1ed6,0x6b8d1ed7}},	//   _कमाई, हित_, _wisa, rsag,
   {{0x6b8d1ed8,0x6d5d1ed9,0xba47010b,0x64b40099}},	//   ssag, _tisa, ухай, ंभाळ,
   {{0xd7d503e6,0xc9130033,0x6b8d1eda,0xe81608b0}},	//   ижењ, িক্ত_, psag, _देहा_,
   {{0xdb040b06,0x21290051,0x75dc0139,0x00000000}},	//   stiá, _mjah_, _lăză, --,
   {{0x6b4b02c9,0x443d00e9,0x29041edb,0xa2a9057c}},	//   füge, _ryw_, _elma_, ज्ञ्,
   {{0x5a440a93,0xba740332,0x6ead00b8,0x256a00f1}},	//   _гэта, _چاہت, _जानु, _cùl_,
   {{0xb4650009,0x2d9e0200,0xe8161edc,0x195806d8}},	//   шкил, šteg_, _देवा_, _басы_,
   {{0xab5b00ab,0x394d01a3,0x67d400af,0xf770014a}},	//   _psüh, _ihes_, _лоту, _فال_,
   {{0x82f51edd,0x98140d82,0x21290118,0x57f40274}},	//   рчиц, _طبقا, _ajah_, _упут,
   {{0x394d0221,0xf8c91ede,0x3245141d,0x61fa099e}},	//   _khes_, _रसाय, ренг, gytl,
   {{0x33d50131,0x2486027a,0xa2a900e7,0xa3d51edf}},	//   _вікт, _geom_, ज्ज्, हिद_,
   {{0x955409b9,0xa93600a5,0x320c0035,0x00000000}},	//   _اخلا, שטרה_, azdy_, --,
   {{0x394d0279,0xa8560122,0xe299145c,0x00000000}},	//   _lhes_, יירה_, _рак_, --,
   {{0x21a50036,0x2cb90211,0x764e0097,0xe2da00fd}},	//   _тийм, _bbsd_, _úbyt, _جانچ_,
   {{0x25ed1ee0,0xd24e1ee1,0x395f1ee2,0x00000000}},	//   _अपनी_, _غني_, _nius_, --,
   {{0xed57051b,0xcb67002d,0x6b4b1ee3,0x81cc0033}},	// [1600] рот_, иате_, züge, রমণ_,
   {{0x0d861566,0x00000000,0x00000000,0x00000000}},	//   _клон, --, --, --,
   {{0x395f046a,0x6f1c1ee4,0x7e9b00a5,0xfe9b0070}},	//   _bius_, mirc, _בסיו, _ביימ,
   {{0x613d01ef,0x394d099e,0x395f005f,0x67280069}},	//   bélu, _ches_, _cius_, _sjdj,
   {{0x67d41a33,0x395f0310,0x394d0118,0x613d01ef}},	//   солу, _dius_, _dhes_, célu,
   {{0x7cf81ee5,0x6f1c1ee6,0x3ce20345,0xb8fd021a}},	//   _víru, nirc, _hnkv_, _थो_,
   {{0x4420002d,0x95ca1ee7,0x55060012,0x395f1ee8}},	//   _ţi_, тула_, ичиа, _fius_,
   {{0x764800ac,0xdb1d0523,0x75dc0160,0x00000000}},	//   _vzdy, _essä, _răză, --,
   {{0x6f1c1ee9,0xdcef00cd,0x00000000,0x00000000}},	//   kirc, žeće, --, --,
   {{0x21290051,0x00000000,0x00000000,0x00000000}},	//   _sjah_, --, --, --,
   {{0x8ad90070,0x98af00ea,0x05661eea,0x6f1c1eeb}},	//   אַרפ, logā_, _твен, dirc,
   {{0x236600c7,0x25be08c7,0x656801da,0xd5fb016b}},	//   _tuoj_, _iptl_, _iudh, _שפאר,
   {{0x65681eec,0x69da1eed,0x9f5900a2,0x853500b5}},	//   _hudh, _štel, lysé_, _اونچ,
   {{0x65681eee,0x31670069,0xe7f90266,0x7d061eef}},	//   _kudh, _funz_, ्नता_, _alks,
   {{0x51860395,0xe29703fa,0x3eba0159,0x31671ef0}},	//   _тула, _тај_, _dbpt_, _gunz_,
   {{0x656800d1,0x6f1c009e,0x67380207,0x00000000}},	//   _mudh, airc, hovj, --,
   {{0x67381ef1,0x2d581470,0x65681ef2,0x395f0310}},	// [1610] kovj, рить_, _ludh, _rius_,
   {{0x673800cb,0x21390031,0x65680d35,0x261700ab}},	//   jovj, losh_, _oudh, _भइली_,
   {{0x395f1ef3,0x6738003d,0x656800e0,0x3ce200fe}},	//   _pius_, dovj, _nudh, _fnkv_,
   {{0x80c50033,0xbcfb0118,0x21390031,0x00000000}},	//   ষাক্, _diéc, nosh_, --,
   {{0x395f0310,0x2d910067,0x6568034d,0x00000000}},	//   _vius_, lsze_, _audh, --,
   {{0x65681ef4,0x67380a16,0x612800a8,0xa3d51ef5}},	//   _budh, govj, yılo, हिस_,
   {{0x394d1ef6,0x213901f4,0xdcfb07b5,0xdb0d1ef7}},	//   _thes_, kosh_, _एकाध_, ltaï,
   {{0x2ca91ef8,0x28cf14ab,0x6ac70066,0xb9251ef9}},	//   ngad_, _सोचि, _रघुर, _افري,
   {{0x291d1efa,0x21391efb,0x6f1c0225,0x00000000}},	//   miwa_, dosh_, yirc, --,
   {{0x291d19c6,0xddde1efc,0x730512f8,0xdb041efd}},	//   liwa_, _lepš, споз, rtiç,
   {{0xdb040370,0x65681efe,0x7af51eff,0x2d910035}},	//   stiç, _gudh, _mozt, jsze_,
   {{0x291d0054,0x21390031,0x00000000,0x00000000}},	//   niwa_, gosh_, --, --,
   {{0xc50c0070,0xa2d20b35,0x9fd60033,0x00000000}},	//   _בלאָ, _भोक्, সঙ্গ, --,
   {{0xe3b00118,0x656816ec,0x291d1f00,0x644b03ab}},	//   _زره_, _yudh, hiwa_, _izgi,
   {{0x291d19c6,0x6b5006d7,0xf2d202b5,0x7d060029}},	//   kiwa_, lägg, _מעג_, _plks,
   {{0x3c6601c8,0x291d000e,0x2ca9022a,0xddde02d4}},	//   скаг, jiwa_, ggad_, _cepš,
   {{0x612806d3,0x291d000e,0x6f1c1f01,0x6d4f0211}},	// [1620] nılm, diwa_, pirc, _dhca,
   {{0x78bb0371,0xbcfb00a2,0x60c600fd,0x00000000}},	//   _abuv, _piéc, lekm, --,
   {{0x7c2f1f02,0x291d0054,0x8db600d4,0x67380506}},	//   _excr, fiwa_, _успі, vovj,
   {{0x98a61f03,0x65681ef2,0x291d1f04,0x6128027d}},	//   сиде, _rudh, giwa_, kılm,
   {{0xc7a311b9,0x65681f05,0x31b1006c,0x6738040b}},	//   зичк, _sudh, ház_, tovj,
   {{0x61280095,0x6d441f06,0x09e601d3,0x78bb018e}},	//   dılm, llia, _логн, _ebuv,
   {{0x6d440297,0x291d000e,0x38690bc6,0x69070279}},	//   olia, biwa_, žara_, órdã,
   {{0x69ce1f07,0x53981f08,0x6d441f09,0x21390031}},	//   _isbe, авия_, nlia, xosh_,
   {{0x67380c0a,0x2d850f56,0xe8df0019,0x6d441f0a}},	//   povj, ález_, _nhộn_, ilia,
   {{0x6d441f0b,0x65681f0c,0x00000000,0x00000000}},	//   hlia, _tudh, --, --,
   {{0xe3af07e4,0x6d441f0d,0x213901f4,0xf53900b8}},	//   وری_, klia, tosh_, boť_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d91006a,0x6d44001e,0x213901f4,0xb0aa0f06}},	//   wsze_, dlia, rosh_, _कारग,
   {{0xa3d5164f,0x291d1f0e,0x69dc1f0f,0x21390031}},	//   हिर_, ziwa_, _orre, sosh_,
   {{0x7af51b66,0x62980009,0x2d851f10,0x8cda00a1}},	//   _rozt, _idvo, èle_, _पोहो,
   {{0x6d440133,0x2d911f11,0x6442012f,0x50670009}},	//   glia, rsze_, _kyoi, _утка,
   {{0x69ce1f12,0x7af501a3,0x2ca91f13,0x291d034d}},	// [1630] _asbe, _pozt, rgad_, viwa_,
   {{0x2d91004e,0xaa671f14,0x6d441f15,0x69dc009e}},	//   psze_, стак, alia, _brre,
   {{0x291d000e,0x6128037a,0x7d0300af,0xd8790037}},	//   tiwa_, zılm, _înso, لمات_,
   {{0x612804d4,0x628a00b5,0x04fa0033,0xdcfc00ea}},	//   yılm, _lefo, ইফুর_, rurģ,
   {{0x69dc1f16,0x629807c0,0x291d1f17,0x69ce13dc}},	//   _erre, _odvo, riwa_, _esbe,
   {{0x7d0d0332,0x291d1f18,0xdb0d0037,0xab5b006c}},	//   lhas, siwa_, otaí, _csüt,
   {{0xceb402b8,0x24e90133,0xdb0d0037,0x291d08c7}},	//   פיק_, имки_, ntaí, piwa_,
   {{0x612806d3,0x7d0d1f19,0x6562009e,0x77690453}},	//   tılm, nhas, _cioh, _tuex,
   {{0x628a1f1a,0x13091f1b,0x248d0183,0xd6ab0413}},	//   _befo, иний_, raem_, _مدام_,
   {{0x61280dac,0xe299052c,0x248d0098,0x42250ef3}},	//   rılm, јан_, saem_, ждов,
   {{0x26c71f1c,0x7d0d1f1d,0x90c61f1e,0x6d44001e}},	//   meno_, khas, обне, ylia,
   {{0xf992035e,0x7bcf1f1f,0x6128008f,0x69da1f20}},	//   ורט_, _oscu, pılm, _štek,
   {{0x75290043,0x6b5006d2,0x7d0d00f8,0x60c6027d}},	//   mnez, läge, dhas, rekm,
   {{0xb4c90d1f,0x26c7000e,0xa3d60992,0x6d44001e}},	//   _लघु_, neno_, ाटर_, wlia,
   {{0x62811f21,0x7bcf0043,0x75291f22,0x7bdd14c0}},	//   mblo, _ascu, onez, _arsu,
   {{0x62811f23,0x7d0d1f24,0x6d441f25,0x75291f26}},	//   lblo, ghas, ulia, nnez,
   {{0x8c431f27,0x6d56026e,0x6d441f28,0x8eba002d}},	// [1640] дете, rmya, rlia, _кынт_,
   {{0x26c702dd,0xb0aa1f29,0x98ad00a0,0x00000000}},	//   jeno_, _काँग, _cieľ_, --,
   {{0x7bcf1111,0x26c715b5,0x6d441f2a,0x7d0d1f2b}},	//   _escu, deno_, plia, bhas,
   {{0x7d0d02a8,0x31ba02b5,0xdb04004f,0x752907e7}},	//   chas, יזענ, ntiú, jnez,
   {{0x765f01c2,0x75290359,0x62811f2c,0x26c71f2d}},	//   əyyə, dnez, kblo, feno_,
   {{0x7d040086,0x62811f2e,0x75291f2f,0x00000000}},	//   lkis, jblo, enez, --,
   {{0xb0aa00b1,0x69dc1f30,0x62811f31,0xaa431ec2}},	//   _कांग, _urre, dblo, _жерл,
   {{0x7d041f32,0x628a0260,0x62811f33,0xa3d51f34}},	//   nkis, _sefo, eblo, हिं_,
   {{0x26c71f35,0x628a0260,0x39461f36,0x25e60387}},	//   beno_, _pefo, mlos_, _झपकी_,
   {{0x39461f37,0x26c71f38,0x20d70023,0x7d04145d}},	//   llos_, ceno_, _ủi_, hkis,
   {{0xd48f0043,0x7d041f39,0xdb040453,0x753b06fe}},	//   _ор_, kkis, guié, bouz,
   {{0x394602c9,0x657a00b5,0x7d0d0c6f,0x386002c4}},	//   nlos_, _itth, xhas, žiru_,
   {{0x62811f3a,0x39461f3b,0x00000000,0x00000000}},	//   bblo, ilos_, --, --,
   {{0x62810310,0xdb041f3c,0x62981f3d,0xbcfb02d7}},	//   cblo, quiè, _udvo, _cién,
   {{0x7d0d1f3e,0xf27b0122,0x394601c8,0xc27b0070}},	//   thas, _דרוש, klos_, _דרוי,
   {{0xd9040220,0xdb04004f,0x26c701c0,0x3946006d}},	//   _شی_, ctiú, zeno_, jlos_,
   {{0x7d0d02cb,0xdb0d004f,0x39461f3f,0x00000000}},	// [1650] rhas, staí, dlos_, --,
   {{0x7d0d1f40,0x657a006c,0x26c70391,0x394605c9}},	//   shas, _otth, xeno_, elos_,
   {{0x7d04006d,0x7d0d1f41,0x753b08c7,0x00000000}},	//   bkis, phas, youz, --,
   {{0x39461f42,0x7d041f43,0xcdda02b5,0x6b501f44}},	//   glos_, ckis, _פֿיר, väge,
   {{0x657a012f,0x60dc02b5,0x26c71f45,0x66e50382}},	//   _atth, יקאנ, teno_, зола,
   {{0x628101b4,0xff7c0070,0x394607a6,0x00000000}},	//   xblo, סטומ, alos_, --,
   {{0x2bcf009a,0x80ac02cb,0x39461f46,0x7bcd1f47}},	//   _सैता, _झाले, blos_, lwau,
   {{0x39460473,0x61360332,0x6b5001ae,0xf8ae01cb}},	//   clos_, bály, räge, _مکه_,
   {{0x62811f48,0x26c71c1a,0x6b50191b,0x75290139}},	//   tblo, peno_, säge, rnez,
   {{0x753b0355,0x13091397,0x00000000,0x00000000}},	//   souz, сной_, --, --,
   {{0x7d041f49,0xcb1200a5,0xbcfb02d7,0x59de0067}},	//   ykis, גלי_, _rién, _नज़ार,
   {{0x62811f4a,0xbcfb0a17,0x00000000,0x00000000}},	//   sblo, _sién, --, --,
   {{0x4aac00a1,0xaaac111a,0xbcfb02d7,0xa3d6018d}},	//   _चालव, _चालक, _pién, ाटः_,
   {{0x3f9e024e,0x3ebe008d,0x63a908c7,0xe7f300be}},	//   čtu_, ýtt_, muen, _आपना_,
   {{0x7d041f4b,0xdb0400f7,0xbcfb0453,0xc27a00a5}},	//   tkis, quié, _vién, _פרקי,
   {{0x2571008a,0x61fc017b,0x41b20037,0x7c2900f4}},	//   _mál_, ärle, _أمير, _žera,
   {{0xeb9a0036,0x7d0404d5,0xfbdf0183,0x80bc022e}},	// [1660] сиз_, rkis, _crê_, ष्णे,
   {{0xa3dc1f4c,0x7d041f4d,0x60d61f4e,0xe81f04bc}},	//   डित_, skis, _haym, _मेधा_,
   {{0x9d460847,0x60d6027d,0x63a90138,0xfbdf021d}},	//   _неод, _kaym, huen, _erê_,
   {{0x60d6021d,0x7ae70031,0x613600b5,0x00000000}},	//   _jaym, _enjt, tály, --,
   {{0x39461f4f,0xe8160b47,0x2efa01ae,0xe0df02d0}},	//   rlos_, _देखा_, _kopf_, klòn_,
   {{0x613600b5,0x39461f50,0x4e7a0070,0x00000000}},	//   rály, slos_, זאַצ, --,
   {{0xb4d7009a,0x394610ca,0x257101ef,0x38c804cd}},	//   ायू_, plos_, _cál_, _واری_,
   {{0x399b0122,0x257100b8,0x63a91f51,0x290701f4}},	//   _לילד, _dál_, fuen, ënat_,
   {{0x63a91f52,0x2a6a012f,0x07a303e6,0x00000000}},	//   guen, _kgbb_, _патн, --,
   {{0xa3ab004e,0x877b0319,0x957c0067,0x25710098}},	//   गढ़_, _לאמי, _prąd, _fál_,
   {{0x29061f53,0xbcfb00a2,0x54360987,0x00000000}},	//   okoa_, _biél, _کرار, --,
   {{0x63a91ccb,0x29061f54,0x644e00a8,0x69c400ab}},	//   buen, nkoa_, əbin, _रहनी,
   {{0x63a91166,0x5f9401d3,0xbcfb1f55,0xe8df00e2}},	//   cuen, ният, _diél, _nhờn_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x2d9e0a78,0xb2bb0122,0x3cf90009,0x29060086}},	//   šten_, _המור, _posv_, kkoa_,
   {{0x614403e6,0x00000000,0x00000000,0x00000000}},	//   _пеја, --, --, --,
   {{0xa3d5006a,0x3c58002d,0xe8df00cc,0x00000000}},	// [1670] हिए_, зитэ_, _chờn_, --,
   {{0xc8790160,0x290601ed,0x00000000,0x00000000}},	//   _inşi_, ekoa_, --, --,
   {{0x63a901a3,0x30a600fd,0x60d6027b,0x777b00ee}},	//   zuen, _علیہ, _yaym, _stux,
   {{0xe6c50302,0x25e01a75,0x5fb10437,0x00000000}},	//   लज्ज, किनी_, _जमाल, --,
   {{0x25711f56,0x613601ef,0x333e01ed,0x00000000}},	//   _sál_, rálx, kotx_, --,
   {{0x290f1505,0xb9041f57,0x257100b5,0x9b580036}},	//   shga_, _भो_, _pál_, _ният_,
   {{0x69da108a,0x2002004e,0x00000000,0x00000000}},	//   _štev, zyki_, --, --,
   {{0x58d41f58,0x63a91f59,0xb4d70b4a,0x6b500282}},	//   _пост, tuen, ाये_, mäga,
   {{0x2be00e6f,0x68e91f5a,0xfbe00e61,0x195800c7}},	//   निया, _ined, नियम, _хаты_,
   {{0x68fb1f5b,0x63a91f5c,0x68e90501,0x60d6045e}},	//   _houd, ruen, _hned, _saym,
   {{0xa0a61f5d,0x68e90393,0x80d70083,0x68fb1f5e}},	//   манд, _kned, ধান্, _koud,
   {{0x2002004e,0x67231f5f,0x68fb1f60,0x63a902d7}},	//   tyki_, linj, _joud, puen,
   {{0x63a91c33,0x21221d11,0x68fb1f61,0xe2991f62}},	//   quen, rikh_, _moud, _дал_,
   {{0x29060291,0x67231f63,0x7f19010b,0x20020067}},	//   zkoa_, ninj, пісу_, ryki_,
   {{0xa3d50b54,0xdd1c024e,0x68e90168,0x60d61f64}},	//   हिक_, _vážn, _oned, _taym,
   {{0x67231f65,0xdb0d01ae,0x68fb1f66,0x68e905a0}},	//   hinj, traß, _noud, _nned,
   {{0xab661f67,0x672305e2,0x2efa02b1,0xe3b900b5}},	// [1680] двал, kinj, _topf_, ntű_,
   {{0x290d09d1,0x6723018e,0x68fb0024,0x68e91f68}},	//   _alea_, jinj, _aoud, _aned,
   {{0x67230888,0x68fb1f69,0x68e9007a,0x6b960b3e}},	//   dinj, _boud, _bned, ssyg,
   {{0xc7c61f6a,0x6603004e,0xb4d700b8,0x68fb00f7}},	//   дски, dynk, ायो_, _coud,
   {{0x4c3601c8,0x68fb1f6b,0x29061c9a,0x224700cc}},	//   _цэнт, _doud, rkoa_, _lynk_,
   {{0x67230528,0x290601d7,0x68e91f6c,0xdddc0067}},	//   ginj, skoa_, _ened, karż,
   {{0x8a06005f,0x68fb000d,0x7afc01ed,0xdd1d00ac}},	//   _ўзбе, _foud, _iort, lášs,
   {{0x7afc1f6d,0x68fb1f6e,0x25a01f6f,0xe81f05a2}},	//   _hort, _goud, čil_, _मेवा_,
   {{0x67231f70,0x644e004e,0x68431f71,0x06bd0831}},	//   binj, ębio, _анта, _আফরি,
   {{0x68fb0a75,0x67231f72,0x00000000,0x00000000}},	//   _zoud, cinj, --, --,
   {{0x7afc1f73,0x360601b2,0xbcfb0118,0x2d9e0355}},	//   _mort, _تواف, _diéj, átel_,
   {{0x7afc0291,0x7bc60051,0x849600b5,0x249d034d}},	//   _lort, _opku, _آجائ, _gdwm_,
   {{0x7afc0173,0x2d9e1942,0x611400af,0x7d030160}},	//   _oort, štel_, тдяу, _însi,
   {{0x7afc1f74,0x15f205dc,0x05c200b4,0x00000000}},	//   _nort, _अपार_, _शहाब, --,
   {{0xa3d60cf1,0x7bc600ea,0x64550067,0xdb0d0183}},	//   ाटक_, _apku, ęzie, ltaç,
   {{0x7afc1f75,0x50670de3,0x6ca41f76,0x6b5001ff}},	//   _aort, _отпа, круж, väga,
   {{0xdb0d00c9,0x3b550012,0x68fb1f77,0x7afc0533}},	// [1690] ntaç, екар, _roud, _bort,
   {{0x68fb1f78,0xdb0d03e6,0x68e91f79,0x00000000}},	//   _soud, itaç, _sned, --,
   {{0x672302f6,0x68fb1f7a,0x7afc1f7b,0x2bab04bc}},	//   vinj, _poud, _dort, _चमका,
   {{0x6ebb035d,0x38351f7c,0xe7f30067,0x2d8301e4}},	//   श्रु, ннер, _आपदा_, mpje_,
   {{0x672301cc,0x69da0a78,0x68fb0248,0x941d0437}},	//   tinj, _štet, _voud, _बेंच_,
   {{0x7afc1f7d,0x68fb0d35,0xe7331d05,0x316900d5}},	//   _gort, _woud, خصص_, _liaz_,
   {{0xe81f006a,0x6723068e,0x236701f4,0x68fb0359}},	//   _मेरा_, rinj, _rinj_, _toud,
   {{0x6723003c,0x68e900e9,0x67d51f7e,0x7afc06a2}},	//   sinj, _uned, _побу, _zort,
   {{0x67231f7f,0x373500d8,0x7768002a,0x386d1f80}},	//   pinj, _знаё, _fidx, _iger_,
   {{0xcb1202b5,0x7afc003c,0xfbd20122,0xf77200a5}},	//   ָלט_, _xort, נתי_, _עקב_,
   {{0x76481f81,0x032200d8,0xe1261f82,0x7d0f006c}},	//   _gydy, удэн, емни, _olcs,
   {{0x75d301c2,0xab5b033b,0xe8df0023,0xbcfb0118}},	//   _nəzə, _spül, _khốn_, _diék,
   {{0x31691f83,0x2d8302a2,0x13f402fb,0xdb0d0183}},	//   _diaz_, epje_, _изця, ctaç,
   {{0x2d9e0254,0x63bb0b4f,0x69c70506,0x61ee0098}},	//   štem_, mtun, _opje, óilí,
   {{0x63bb1f84,0x2f14022a,0x2d8c0248,0xed5a0994}},	//   ltun, _lägg_, ède_, зов_,
   {{0xc5f202b5,0x00000000,0x00000000,0x00000000}},	//   נדן_, --, --, --,
   {{0xe81f06bc,0x60c40010,0x2d830051,0x67210282}},	// [16a0] _मेला_, _ibim, apje_, _omlj,
   {{0x7afc1f85,0x63bb1f86,0x386d1f87,0x4e1c0033}},	//   _qort, itun, _ager_, _দুঃখ_,
   {{0x7afc1f88,0x63bb1f89,0x39441f8a,0xfbdf0023}},	//   _vort, htun, _pkms_, _uyên_,
   {{0x76480297,0x61fc1f8b,0x7afc1f8c,0xf1b200a5}},	//   _rydy, ørli, _wort, רסא_,
   {{0x6d461f8d,0x69d51f8e,0x67d4002d,0x7afc10a7}},	//   _ikka, _esze, толу, _tort,
   {{0x386d1f8f,0x6b841f90,0x63bb1f91,0x98c50228}},	//   _eger_, mpig, dtun, ītās_,
   {{0x60c41f92,0xceb302b5,0x63bb1f93,0xdb04000d}},	//   _obim, טיג_, etun, vriè,
   {{0x63bb1f94,0x75d30095,0xa3dc167e,0x6b84023c}},	//   ftun, _xəzə, डिल_, opig,
   {{0xd4e30086,0x63bb1f95,0xdb041f96,0x61e309bd}},	//   ующи, gtun, triè, _arnl,
   {{0x60c41f97,0xdb0d1f98,0x0bb700a5,0x2d830031}},	//   _abim, rtaç, עלים_, ypje_,
   {{0x6d461f99,0xdb0402e1,0xdb0d03e6,0x3f8001ef}},	//   _okka, rriè, staç, _atiu_,
   {{0xdb0d03e6,0x6d46010d,0xdcdf0722,0x7c2902c4}},	//   ptaç, _nkka, _पोंछ, _žerm,
   {{0xa3e401c0,0xdb040042,0x63bb055c,0x61e30282}},	//   _पछि_, ntió, ctun, _ernl,
   {{0x6d461f9a,0x545302ce,0x60c401a8,0x32050355}},	//   _akka, _світ, _ebim, byly_,
   {{0x0dc81f9b,0x7c8703fa,0x720300b5,0x00000000}},	//   нути_, еузе, _مووم, --,
   {{0x2b58011e,0x38690121,0x75d300a8,0x00000000}},	//   _ahrc_, žari_, _qəzə, --,
   {{0x69c71f9c,0x8aa7093c,0xfaa703fe,0x6b8408dd}},	// [16b0] _spje, еред, ешен, gpig,
   {{0x60dd1f9d,0x2fc91292,0x6d4601a8,0x00000000}},	//   ldsm, _ipag_, _ekka, --,
   {{0xf9930206,0x7dc4006c,0x63bb1e5c,0x69da1f9e}},	//   ابط_, _یقین, ztun, _šter,
   {{0x60dd14c2,0x2d81009d,0x2fc9010d,0x63bb1f9f}},	//   ndsm, _ithe_, _kpag_, ytun,
   {{0xb8c90755,0x69d5004e,0xd24601df,0xb09c00a5}},	//   _गए_, _wsze, _چن_, ליאר,
   {{0x6d4d1fa0,0xd2461abd,0x7522073a,0x9f4000f6}},	//   llaa, _نن_, _amoz, _prié_,
   {{0xa3b300a1,0x6d460093,0xda090c74,0x798e016e}},	//   जून_, _ykka, _غيره_, _gwbw,
   {{0x63bb1fa1,0x386d1fa2,0x60dd01b4,0x6d4d1fa3}},	//   ttun, _uger_, jdsm, nlaa,
   {{0x63bb00c3,0x7d0300af,0xdb040132,0x7c290116}},	//   utun, _însu, quiã, _žerj,
   {{0x63bb06d1,0x613d0332,0x75221fa4,0x6d4d1fa5}},	//   rtun, mély, _emoz, hlaa,
   {{0x6d4d0006,0x63bb1fa6,0x3f800043,0x2d8101e8}},	//   klaa, stun, _stiu_, _nthe_,
   {{0xbcfb0132,0x3f800160,0x6d4d0051,0xdb0400f6}},	//   _fiéi, _ptiu_, jlaa, rrié,
   {{0x889a0122,0x6d4d1fa7,0x2f14013c,0x4ab30096}},	//   וברי, dlaa, _läge_, ुभाव,
   {{0x2be0009a,0xdb0402e1,0x656b1fa8,0x4ed51fa9}},	//   निसा, prié, _high, люст,
   {{0x656b1faa,0x60c4009e,0x6d4d1fab,0x3f6702ee}},	//   _kigh, _tbim, flaa, тиро_,
   {{0x6d4d1fac,0x63a91fad,0x657c00b5,0x6128027b}},	//   glaa, oren, _érhe, rıls,
   {{0x656b0122,0xeb971fae,0x765c00ac,0x2d811faf}},	// [16c0] _migh, кит_, _úryv, _ethe_,
   {{0x656b1fb0,0x613d006c,0x63a91fb1,0x6d4d1fb2}},	//   _ligh, dély, iren, alaa,
   {{0x63a91fb3,0x656b09bb,0x644b00d8,0x2be01fb4}},	//   hren, _oigh, _lygi, निहा,
   {{0x63a91fb5,0x656b1fb6,0xfbab0581,0x2bab0380}},	//   kren, _nigh, _चमचम, _चमचा,
   {{0x68430bbc,0x644b038d,0x613d00fd,0x00000000}},	//   анца, _nygi, gély, --,
   {{0x656b009d,0x6d441fb7,0xd09a00a8,0xdb0401f7}},	//   _aigh, loia, rçək, quià,
   {{0x63a91fb8,0xdb0409ab,0x656b0159,0x2be00275}},	//   eren, stió, _bigh, निवा,
   {{0x63a91fb9,0x6d441200,0x644b099e,0x7d030395}},	//   fren, noia, _bygi, _înst,
   {{0xa7661fba,0x63a91fbb,0xdce60009,0xdb0401ef}},	//   _акад, gren, _nikč, ltiñ,
   {{0x86ea004f,0x656b1fbc,0x6d441fbd,0x14ae0099}},	//   _تعرف_, _eigh, hoia, _टाकण,
   {{0xdb040391,0x63a91fbe,0x656b00a5,0x6d4401a3}},	//   ntiñ, aren, _figh, koia,
   {{0x94260086,0x6913027d,0x656b0211,0x6d4401ed}},	//   _имее, _içec, _gigh, joia,
   {{0x60dd1e74,0x6d441fbf,0x63a91fc0,0x00000000}},	//   rdsm, doia, cren, --,
   {{0xdce6005f,0x00000000,0x00000000,0x00000000}},	//   _dikč, --, --, --,
   {{0x7e281112,0x6e941edd,0x6d4d1fc1,0x6b500f8e}},	//   віта_, рису, tlaa, rägl,
   {{0xe7f300a1,0x6d441fc2,0x7d16016e,0xbcfb00f6}},	//   _आपला_, goia, ghys, _liév,
   {{0xdc55051b,0x6d4d0136,0x2571003a,0xfbd00037}},	// [16d0] увањ, rlaa, _išle_, يتك_,
   {{0x6d4d0a45,0xf1b61fc3,0x200402b1,0x00000000}},	//   slaa, _अमान, ämie_, --,
   {{0x6d4d1fc4,0x2d81022e,0x63a91fc5,0x6d441fc6}},	//   plaa, _uthe_, zren, boia,
   {{0x7d160097,0xe0df1fc7,0xa3d2007c,0x6d441599}},	//   chys, ndò_, _हईं_, coia,
   {{0x656b0052,0xfd5602b5,0x4993006c,0x7d0d1fc8}},	//   _righ, _תשרי_, _چیئر, mkas,
   {{0x656b1fc9,0x2be0022e,0xe8df00cc,0x00000000}},	//   _sigh, निरा, _phồn_, --,
   {{0x996705a1,0xdb041fca,0x656b1fcb,0x25710124}},	//   _атал, quiá, _pigh, _ošle_,
   {{0x7d0d1fcc,0x257800b5,0x693c00cd,0x680a00ec}},	//   nkas, _dél_, včeg, _bēdā,
   {{0x63a91fcd,0x7d0d1fce,0x38351fcf,0x2c4a005f}},	//   uren, ikas, _снар, _gėdą_,
   {{0xe1f903ad,0x63a91fd0,0x2578006c,0x6d441fb7}},	//   его_, rren, _fél_, zoia,
   {{0x7d0d1b34,0x63a91fd1,0x656b1fd2,0x9afa00a5}},	//   kkas, sren, _tigh, תפתח,
   {{0x7d0d18b0,0x64550095,0x63a91fd3,0x656b1fd4}},	//   jkas, əzin, pren, _uigh,
   {{0x03a509a5,0x7d0d1fd5,0x00000000,0x00000000}},	//   _сило, dkas, --, --,
   {{0x75291fd6,0x69c400ab,0xfd6500e2,0x00000000}},	//   liez, _रहली, _truồ, --,
   {{0xc0e61fd7,0xdd1d00b8,0xdb040279,0xdca61fd8}},	//   _бойк, lářs, luiç, лави,
   {{0x7529018a,0x7d0d1fd9,0x7e7c0124,0x9f400176}},	//   niez, gkas, scrp, _triï_,
   {{0x0aea1fda,0x6eac0939,0xdb040279,0xdd1d00b8}},	// [16e0] ндай_, _जयपु, nuiç, nářs,
   {{0x7d0d0086,0x945d0035,0x6d4401a3,0x8a3a00c3}},	//   akas, leńs, soia, няет_,
   {{0x888601d3,0x7d16062c,0x80d70033,0x7d0d005f}},	//   глеж, phys, ধার্, bkas,
   {{0xc9550409,0x7d0d1fdb,0xdb041fdc,0x7aeb0228}},	//   атчы, ckas, rtiñ, ēgta,
   {{0xa3d21ea2,0x6ac900c8,0xdb041fdc,0x257800e0}},	//   _हैं_, রয়ো, stiñ, _sél_,
   {{0xdd1d00b8,0x3ce01fdd,0xda6600ce,0x00000000}},	//   dářs, ldiv_, _مازي, --,
   {{0x645d064b,0xceb30122,0x2d7802a7,0xe5c61fde}},	//   ýsin, ציה_, _očem_, усло,
   {{0x752901a3,0x3ce00553,0x25781fdf,0x00000000}},	//   giez, ndiv_, _vél_, --,
   {{0x28dd1fe0,0xdb040279,0x46b605bc,0xf3660c06}},	//   _नोटि, guiç, _محاس, лтон,
   {{0x39461fe1,0x25781fe2,0x9bbb02b5,0x81cd0033}},	//   loos_, _tél_, עציפ, রিন_,
   {{0xaac6142a,0x80de00c8,0x4ac60c67,0xd25000bf}},	//   र्यक, যান্, र्यव, تند_,
   {{0xdb040370,0x26de1fe3,0x75291fe4,0xdd1d0355}},	//   buiç, _hato_, ciez, bářs,
   {{0xa3b30299,0x7d0d1fe5,0x26de1fe6,0x09d10380}},	//   जूद_, vkas, _kato_, _सन्य,
   {{0x26de0fc5,0x4ac6022e,0x3dda02b1,0x39461fe7}},	//   _jato_, र्मव, _bspw_, hoos_,
   {{0xc27b0779,0x26de1fe8,0xdd950409,0x7d0d1fe9}},	//   _ארוי, _mato_, рабы, tkas,
   {{0xf1a9004e,0x26de1fea,0x629a1feb,0x25710ce9}},	//   _कितन, _lato_, lato, _ušle_,
   {{0x39461fec,0x212b1fed,0xaac6007e,0x00000000}},	// [16f0] doos_, mich_, र्भक, --,
   {{0x212b0446,0x7d0d1fee,0x00000000,0x00000000}},	//   lich_, skas, --, --,
   {{0x7d0d1fef,0x00000000,0x00000000,0x00000000}},	//   pkas, --, --, --,
   {{0x629a1ff0,0x212b01a6,0x00000000,0x00000000}},	//   hato, nich_, --, --,
   {{0x26de1ff1,0xbcfb1ff2,0x75291ff3,0xab5b0176}},	//   _bato_, _diét, viez, _aqüe,
   {{0x7ceb06d7,0xd6291a33,0x212b1ff4,0x945d004e}},	//   _förä, коле_, hich_, zeńs,
   {{0x212b006a,0x26de1ff5,0x629a1ff6,0xbcfb0042}},	//   kich_, _dato_, dato, _chég,
   {{0xdb040370,0x212b086d,0x81cd0033,0x2bac021a}},	//   tuiç, jich_, রিম_, _चिमा,
   {{0x212b1ff7,0x26de0370,0x75291ff8,0x80de0083}},	//   dich_, _fato_, riez, যাম্,
   {{0x032500d4,0x26de1ff9,0xa1c501c8,0x13090086}},	//   рдон, _gato_, абод, тной_,
   {{0xcb140052,0x75291ffa,0xe1f60043,0x00000000}},	//   מלץ_, piez, агэ_, --,
   {{0x26de1ffb,0x75ca01c2,0x212b1ffc,0x95670133}},	//   _zato_, _qəze, gich_, _създ,
   {{0x4ac602e4,0x248d1ffd,0x5edf0083,0x2fdb0024}},	//   र्डव, mbem_, মানে, _csqg_,
   {{0xb05b1788,0x91e50f08,0x39460042,0xf8d20026}},	//   pfän, _воке, zoos_, _सस्प,
   {{0xde0312b3,0x212b0260,0xb05b0f8e,0x78bb0124}},	//   опри, bich_, lfäl, _ocuv,
   {{0x212b016f,0xac86081b,0x39461ffe,0x4fea05a1}},	//   cich_, ргал, xoos_, _амин_,
   {{0x998d0470,0xac071fff,0x3ce02000,0xbea61e38}},	// [1700] _ćeš_, анта_, rdiv_, _капк,
   {{0x6d5d2001,0x8d7603fc,0xfaa60466,0xdb040421}},	//   _ehsa, _پادا, ражо, htiö,
   {{0xa2bd051d,0x26de1f3b,0xbcfb000d,0xa96a0036}},	//   _शान्, _rato_, _piét, вижа_,
   {{0x629a193d,0xfce60dfc,0x26de2002,0x497300d8}},	//   zato, _томо, _sato_, іліс,
   {{0x2d780009,0x39462003,0xa81a05bc,0x629a2004}},	//   _oček_, roos_, ختار_, yato,
   {{0x212b0223,0x3946006d,0x629a2005,0x38af0225}},	//   zich_, soos_, xato, törü_,
   {{0xfaa312f8,0x212b046a,0x26de023a,0xaac6164f}},	//   _фасо, yich_, _vato_, र्णक,
   {{0x629a2006,0xbcfb2007,0xb4e0012f,0xd9432008}},	//   wato, _hiér, दये_, _деси,
   {{0x26de01c0,0xaac60567,0x2fc001e8,0x539700d8}},	//   _tato_, र्थक, _nqig_, авыя_,
   {{0x68e02009,0x2904002f,0x64590067,0x00000000}},	//   _hamd, _homa_, _dzwi, --,
   {{0xbcfb200a,0x2904200b,0x212b200c,0x68e0200d}},	//   _miér, _koma_, tich_, _kamd,
   {{0x68e200da,0x4ac6175f,0x29040228,0x443d00fe}},	//   ndod, र्तव, _joma_, _fxw_,
   {{0x212b200e,0x2f14022a,0x2571200f,0xa3dc00a1}},	//   rich_, _säga_, _išla_, डिओ_,
   {{0x212b01a6,0x63a22010,0x29042011,0x69dc008b}},	//   sich_, _ivon, _loma_, _osre,
   {{0x2d850a45,0x4d2703e6,0xa3d20067,0x70950382}},	//   ële_, аќаа, हौर_, _лайф,
   {{0x2f140006,0x5c752012,0x29042013,0x629800c3}},	//   _väga_, слат, _noma_, _hevo,
   {{0x68e2001e,0xa3dc0518,0x5ecc0033,0x645c00a8}},	// [1710] ddod, डिट_, ায়ে, əric,
   {{0xf1da006a,0x629804c4,0xa3d70099,0xdce6013a}},	//   _बनान, _jevo, ाबत_, _vikā,
   {{0x29042014,0x25710124,0xceb20070,0xf8750079}},	//   _boma_, _ošla_, _ציט_, مهاج,
   {{0x29041a71,0x62982015,0xc8790ec4,0x68e02016}},	//   _coma_, _levo, _başa_, _camd,
   {{0x27e92017,0x29042018,0x68e000a7,0x80bc112b}},	//   ían_, _doma_, _damd, ष्टे,
   {{0x62982019,0x7bdd0052,0x81cd0083,0xc72401e0}},	//   _nevo, _issu, রিত_, одій,
   {{0x63a2201a,0xe7f3004e,0x212900bf,0x80de0033}},	//   _avon, _आपका_, _omah_, যাত্,
   {{0xce3802da,0x25a9201b,0xb05b1788,0xd5b80354}},	//   יאות_, čal_, tfäl, _इमरज,
   {{0x6298201c,0xa3d20299,0xb3820bbc,0x443d0118}},	//   _bevo, हौल_, плыл, _qxw_,
   {{0xf7700082,0xc2e90332,0xb05b0ed4,0x63a2201d}},	//   _قال_, اعظم_, rfäl, _dvon,
   {{0x7c3b00fb,0x395f006d,0x68e0012f,0x290400d7}},	//   _þurf, _khus_, _yamd, _yoma_,
   {{0x443d006d,0x628e0093,0x7bdd0103,0xc8790457}},	//   _txw_, ðbor, _ossu, _yaşa_,
   {{0xe28e0896,0x43850514,0x638503fa,0x21290176}},	//   _на_, _التق, _угла, _dmah_,
   {{0x6298201e,0xe7fa00a1,0xe299201f,0x61ea0156}},	//   _gevo, ्हता_, _сак_, _frfl,
   {{0x63a215b5,0x7bdd2020,0xa3b30591,0xfc3f0176}},	//   _zvon, _assu, जूर_, _axí_,
   {{0x31a3036a,0x62810814,0x61432021,0x2bac012f}},	//   mız_, lclo, _неща, _चिदा,
   {{0x29042022,0xed5700c9,0x68e00dc3,0x75ca00a8}},	// [1720] _roma_, сот_, _ramd, _məza,
   {{0x62812023,0x290416a7,0x68e00c53,0x394d0118}},	//   nclo, _soma_, _samd, _akes_,
   {{0x31a32024,0x5886010b,0x7bdd09d6,0x395f006b}},	//   nız_, была, _essu, _bhus_,
   {{0x75ca0095,0x61fc0301,0xc879033e,0xc8b60037}},	//   _nəza, ärli, _paşa_, إصاب,
   {{0xe1e70ef5,0x68e22025,0x765a2026,0x69dc009e}},	//   _کس_, rdod, _szty, _wsre,
   {{0x27e613b8,0x997600af,0xdb040138,0x612f021e}},	//   rvon_, _гуаш, briá, _kòlè,
   {{0x63a200fb,0x29040995,0x6d4100fb,0x69dc03fd}},	//   _svon, _toma_, élag, _usre,
   {{0x75ca0095,0x7d062027,0x186a2028,0x7644027d}},	//   _cəza, _joks, _баби_, şiyo,
   {{0x7d0601c8,0x5edf0033,0x68fd0211,0x00000000}},	//   _moks, মাতে, _òsda, --,
   {{0x62812029,0x7d06202a,0xfc3f002a,0xaab301c0}},	//   gclo, _loks, _odín_, ुभएक,
   {{0x60f9019b,0x14ca03ad,0x2d9e000d,0x8afb1804}},	//   ання_, _были_, âtel_, אליז,
   {{0x63a2202b,0x7d0601e0,0x657a0211,0x00000000}},	//   _tvon, _noks, _iuth, --,
   {{0x25710254,0x6298202c,0x321e0035,0x4ad80775}},	//   _ušla_, _tevo, szty_, ड़ाव,
   {{0x657a104d,0x543b02b5,0x31a30381,0x612f021e}},	//   _kuth, _געדא, bız_, _bòlè,
   {{0x918618dd,0x7d06202d,0x98bd0067,0x00000000}},	//   _اجتم, _boks, lową_, --,
   {{0x5d55093e,0x212900e0,0x00000000,0x00000000}},	//   ікат, _umah_, --, --,
   {{0x657a202e,0x2d5808a6,0x2d9e202f,0x60cd2030}},	// [1730] _luth, сить_, áter_, _ibam,
   {{0x657a0282,0x2dd52031,0x67380009,0x3f89021d}},	//   _outh, _джор, jnvj, _itau_,
   {{0x395f006d,0x5edf0083,0x657a0118,0x2d9e02f6}},	//   _phus_, মাদে, _nuth, šter_,
   {{0xfbd000b5,0xa3e80026,0x26cc00f6,0x7644027d}},	//   بتہ_, मटा_, _abdo_, ğiyl,
   {{0x657a0052,0x7bc42032,0x2b930a86,0x628104f4}},	//   _auth, ctiu, _ریاس, yclo,
   {{0x6b8d2033,0x657a2034,0x31a300d0,0xa2ca01d1}},	//   mpag, _buth, yız_, त्म्,
   {{0x6b8d2035,0x45192036,0x657a0211,0xceb40100}},	//   lpag, иция_, _cuth, ליס_,
   {{0x69c52037,0x6b8d2038,0x657a2039,0x75ca0095}},	//   mthe, opag, _duth, _qəza,
   {{0x3f890d4b,0x69c5203a,0x4ac60d34,0x6b8d203b}},	//   _ntau_, lthe, र्वव, npag,
   {{0x69c5203c,0x60cd203d,0x693c05cd,0x6b8d203e}},	//   othe, _abam, nčen, ipag,
   {{0x3f89203f,0x657a2040,0x69c52041,0x7ae5006b}},	//   _atau_, _guth, nthe, idht,
   {{0x69c50a24,0xe56e0a55,0x27ed00d7,0x25712042}},	//   ithe, _із_, _kren_, _išlo_,
   {{0x31a306d3,0x69c52043,0xb05b02b1,0x62830065}},	//   sız_, hthe, nfäh, _tfno,
   {{0xe3b00a42,0x6b8d2044,0x249f2045,0x69c52046}},	//   _سره_, dpag, laum_, kthe,
   {{0x78a92047,0x693c0187,0xec9a0279,0x6b8d0223}},	//   _odev, dčen, итај_, epag,
   {{0x27ed2048,0xa01b2049,0x311e0096,0x2d7800cd}},	//   _oren_, rbör, _पतिः_, _očev_,
   {{0x8e76002d,0x6b8d204a,0xdee6204b,0x7d060909}},	// [1740] _мунч, gpag, _допи, _voks,
   {{0x249f0189,0x78a90012,0xab5b033b,0xfc3f01f7}},	//   haum_, _adev, _spür, _idíl_,
   {{0x7bc4204c,0xed5a204d,0xe9da204e,0x69c5204f}},	//   stiu, _вон_, рке_, gthe,
   {{0x6b8d2050,0x7bc42051,0x27ed00e5,0x7c3b03c9}},	//   bpag, ptiu, _bren_, _žure,
   {{0x2ca02052,0x657a2053,0x27ed0042,0xc7a3083e}},	//   maid_, _suth, _cren_, дичк,
   {{0x657a2054,0x6d562055,0x4ac61604,0xfdfe0456}},	//   _puth, llya, र्शव, _उपास_,
   {{0x27ed2056,0xd5b0004f,0x69c52057,0x25dd0127}},	//   _eren_, رفة_, cthe, _कैदी_,
   {{0x291d2058,0x4ac60f09,0x2ca02059,0x98bd0035}},	//   chwa_, र्रव, naid_, tową_,
   {{0xdddc011c,0x657a0118,0x27ed205a,0x2be00099}},	//   jbrž, _wuth, _gren_, निटा,
   {{0xbcfb004f,0x657a205b,0x78a900ac,0xa3cb205c}},	//   _mhéa, _tuth, _zdev, _लहर_,
   {{0x3f89002d,0x2ca000ab,0x249f205d,0xdcfc010b}},	//   _stau_, kaid_, baum_, sprę,
   {{0x645c0669,0x2ca0007c,0x00000000,0x00000000}},	//   ərin, jaid_, --, --,
   {{0xc05b0044,0xb4b61db9,0x5f940382,0xa2e61f39}},	//   рін_, जली_, мият, _модд,
   {{0xf6510332,0xa3d70c57,0x764d013b,0xc44400fd}},	//   _آئے_, ाबर_, şaye, _ویژن_,
   {{0x6b8d205e,0x69c5205f,0xf1c300b8,0x693c15ce}},	//   wpag, xthe, _vaší_, včen,
   {{0x6b8d0051,0xbcfb0037,0x2ca02060,0x81cd0033}},	//   tpag, _bhéa, gaid_, রিশ_,
   {{0xbcfb0082,0x7c3b012e,0x0ca801d3,0x6b8d2061}},	// [1750] _chéa, _žurb, ютри_, upag,
   {{0xbcfb0514,0x6b8d2062,0x81cd0083,0x249f006d}},	//   _dhéa, rpag, রির_, zaum_,
   {{0xa2bd0e1d,0x69c52063,0x13d30083,0x291d0345}},	//   _शास्, uthe, ়িয়, thwa_,
   {{0xa2ca2064,0xbcfb0082,0x2ca02065,0x69c52066}},	//   त्त्, _fhéa, caid_, rthe,
   {{0x6cfa00a5,0x693c201d,0xbcfb0079,0x27ed0183}},	//   _הפרס, pčen, _ghéa, _qren_,
   {{0x291d2067,0x65620371,0xb05b02b1,0x00000000}},	//   shwa_, _ahoh, rfäh, --,
   {{0x6ecd09b1,0xb05b033b,0x00000000,0x00000000}},	//   द्यु, sfäh, --, --,
   {{0xdb040279,0xd4d900d4,0x2e3c0070,0xa3d70bad}},	//   triç, ські_, יגונ, ाबल_,
   {{0x249f0938,0x6562022e,0x27ed2068,0xe3b1004f}},	//   raum_, _dhoh, _uren_, ررة_,
   {{0x249f01e8,0x00000000,0x00000000,0x00000000}},	//   saum_, --, --, --,
   {{0xdb0d0f56,0x06760070,0x257100f4,0x6562009e}},	//   ntañ, _זײער_, _ušlo_, _fhoh,
   {{0xdb0d2069,0x00000000,0x00000000,0x00000000}},	//   kraï, --, --, --,
   {{0x2ca0007c,0x20561eb9,0x2458010b,0x645d00be}},	//   vaid_, ятор, _даць_, üsid,
   {{0xb4d60066,0xd34300b5,0x6569206a,0x00000000}},	//   ाड़ी_, _تفتی, lmeh, --,
   {{0x551f0311,0xdb0d0248,0xbcfb0079,0x12fa00a5}},	//   _बताए_, traî, _shéa, _להסב,
   {{0x753b027a,0xec7a0ecf,0x3b8605e8,0x6569206b}},	//   nnuz, спа_, злаг, nmeh,
   {{0x25dd05e7,0x6d56010d,0x1d07206c,0x2ca0206d}},	// [1760] _कैसी_, rlya, чети_, raid_,
   {{0x2ca00d8e,0x6b5001ff,0xdb1c027b,0x00000000}},	//   said_, vägs, _üzüm, --,
   {{0x6d561a22,0x7e7b00a5,0x49ca1052,0x1e9700a5}},	//   plya, _לאיז, слен_, _מכיל_,
   {{0xbcfb004f,0x203300b5,0x00000000,0x00000000}},	//   _théa, _آفیس, --, --,
   {{0x80ce03de,0xdb04053e,0x24c30033,0x5edf0831}},	//   ध्ये, nsië, ্যাহ, মারে,
   {{0x656200da,0xdbc700ab,0x7d04206e,0xa9a6206f}},	//   _shoh, tööt, ljis, _нигд,
   {{0xdb04013c,0x7c24002d,0xc1da0035,0x9f4003bc}},	//   rriä, lzir, _बनेग, _asië_,
   {{0xb4d6065a,0xdce403fa,0x48e32070,0x7d042071}},	//   ाजे_, kmič, _посв, njis,
   {{0x7c242072,0xd9431362,0xa2bd0253,0xa3b30246}},	//   nzir, _чети, _शाश्, जंग_,
   {{0x645c01c2,0xdb0d0093,0x98bd0035,0xdce42073}},	//   əril, ntað, dowę_, dmič,
   {{0x867501c8,0x65622074,0xa2bd2075,0x00000000}},	//   _жыцц, _thoh, _शार्, --,
   {{0x2d5701d6,0x78a2023c,0x7aeb00ea,0x3a3700a5}},	//   rçek_, naov, ēgti, לרים_,
   {{0x50642076,0x75ca00a8,0xf4871328,0xdb0d003e}},	//   етра, _məzm, _رانی, ktað,
   {{0x7c242077,0x70770416,0xbcfb00f6,0x00000000}},	//   dzir, _کاغذ, _chén, --,
   {{0x97570d85,0x00000000,0x00000000,0x00000000}},	//   פילו_, --, --, --,
   {{0x7d0401d2,0x9f49021d,0x3a3f00f4,0x9ce400af}},	//   gjis, _iraí_, _ćup_, нцул,
   {{0xdb0d0132,0x6f0100b5,0x693c080a,0x00000000}},	// [1770] nuaç, ölcs, rčel, --,
   {{0x501c00a5,0xdb0d01f7,0x00000000,0x00000000}},	//   _לוחו, rraï, --, --,
   {{0xceb20779,0xdb040248,0x89d9103b,0x99d906ee}},	//   _ביי_, isiè, توار_, تواء_,
   {{0xb4d60387,0x7d161ae2,0xdb0d0079,0x7c2400cd}},	//   ाजो_, ckys, mraí, bzir,
   {{0xdb0d2078,0x66e52079,0xa8780079,0xdce60207}},	//   stañ, дола, أحمر_, _sikć,
   {{0xdb0d03e6,0x8ae402ce,0x3ea3207a,0x3ce900ab}},	//   duaç, _післ, najt_, ldav_,
   {{0xdb0d0037,0xdce40121,0x2d7802a7,0x2d860207}},	//   nraí, zmič, _hčer_, _čoek_,
   {{0xa2ca0b35,0xfdf80122,0x7ae7207b,0x3ce900ab}},	//   त्स्, לצות_, _hajt, ndav_,
   {{0x04770332,0x6569207c,0x7ae7008b,0xdb0d0fe0}},	//   _ہلاک_, rmeh, _kajt, guaç,
   {{0x394f0029,0x6569207d,0xdb1602d7,0x81d60033}},	//   logs_, smeh, tuyé, সিন_,
   {{0xf74801b2,0x7ae7207e,0x645c0095,0x7d1d207f}},	//   _علمي_, _majt, ərim, _olss,
   {{0xcea901f3,0x7ae72080,0x8fa6031a,0xdce405e2}},	//   _כי_, _lajt, маме, tmič,
   {{0xbcfb0248,0xd9aa051d,0x25a000cd,0xdb0d021d}},	//   _phén, _चट्ट, ćile_, cuaç,
   {{0x69d50120,0xdce41bd8,0x7d1d008c,0x3cf908c8}},	//   _opze, rmič, _alss, _ansv_,
   {{0xdb0d0082,0x63bb0447,0xdce41977,0xc1060037}},	//   graí, luun, smič, _يوتي,
   {{0x7c2401d7,0x2f1400be,0x00000000,0x00000000}},	//   tzir, _mägi_, --, --,
   {{0x63bb2081,0x3ce60038,0x7d042082,0xdb0d008d}},	// [1780] nuun, ľov_, rjis, ttað,
   {{0x3ce601ba,0xd9100df3,0x6ecd021a,0x7ae72083}},	//   žov_, گیر_, द्दु, _cajt,
   {{0x7ae72084,0x3ce901a2,0x78a21b99,0x6e4618c4}},	//   _dajt, bdav_, taov, _ценз,
   {{0xdb0d008a,0x63bb2085,0xd9100416,0xd056013b}},	//   stað, kuun, دیر_, _sayə,
   {{0x87da2086,0x98a30d17,0x97da2087,0x31da2088}},	//   تباس_, тиче, تظار_, _बन्ध,
   {{0x63bb2089,0x7ae7208a,0x66e30274,0x758a208b}},	//   duun, _gajt, воља, осив_,
   {{0x60c4025c,0x6b840069,0x693c208c,0x2d7802c4}},	//   _ocim, lqig, nček, _učes_,
   {{0xdb0d0370,0x7ae701fe,0x60c40009,0x38ca006c}},	//   tuaç, _zajt, _ncim, _گاڑی_,
   {{0x7ae7006d,0x33740d6e,0x693c0355,0x63bb208d}},	//   _yajt, нгир, yčej, guun,
   {{0x60c40370,0x764d0463,0x59d213ab,0x1bfb0070}},	//   _acim, şaya, _सहार, קליב,
   {{0xe1350d36,0xdb04208e,0x3ea304c4,0x26dc0036}},	//   енны, friú, vajt_, mevo_,
   {{0x26dc208f,0x92be0083,0xdb0400f7,0x63bb001c}},	//   levo_, ঁজে_, ssiè, buun,
   {{0x78a02090,0xdb0d0279,0xc178010b,0x2eca0096}},	//   _memv, quaç, tvės_, िभूत,
   {{0xdef8081b,0x26dc2091,0x78a008c8,0x81d60033}},	//   мыс_, nevo_, _lemv, সিব_,
   {{0x7ae72092,0x3ea32093,0xdb040037,0x628a007a}},	//   _rajt, rajt_, briú, _iffo,
   {{0x7ae72094,0xa2ca2095,0xdb0d2096,0x3ea32097}},	//   _sajt, त्र्, rraí, sajt_,
   {{0x7ae72098,0x60dd01bf,0x3f800176,0xc179010b}},	// [1790] _pajt, mesm, _guiu_, svės_,
   {{0x26dc0690,0x60dd2099,0xbcfb0248,0xc879002d}},	//   jevo_, lesm, _théo, _iaşi_,
   {{0x7ae7209a,0x26dc209b,0x79e700b5,0x394f017b}},	//   _vajt, devo_, بوضہ_, togs_,
   {{0x25f4209c,0x60dd209d,0x25610093,0xbb1b0139}},	//   ्मनी_, nesm, kóla_, _atît,
   {{0x628a209e,0x06e80033,0x394f209f,0x00000000}},	//   _offo, পানি, rogs_, --,
   {{0x2571200f,0x7c200225,0x2d78023a,0x00000000}},	//   _išli_, _ümra, _učer_, --,
   {{0x60dd20a0,0x2d8120a1,0x9f40009e,0xc8790139}},	//   kesm, _juhe_, _criù_, _laşi_,
   {{0x63bb20a2,0xfba320a3,0x3ea120a4,0x2d8120a5}},	//   tuun, _ओबाम, _leht_, _muhe_,
   {{0x2fc9006d,0x36d520a6,0x4ac600b4,0xf7780024}},	//   _nqag_, _поар, र्कव, _fiħ_,
   {{0x291f0221,0x60c420a7,0x26dc0382,0x63bb20a8}},	//   _hlua_, _scim, cevo_, ruun,
   {{0x68fb20a9,0x68e91d11,0x63bb20aa,0x00000000}},	//   _knud, _kaed, suun, --,
   {{0xaacf20ab,0x4acf157d,0x60dd2063,0x628a20ac}},	//   स्तक, स्तव, gesm, _effo,
   {{0x7c3b20ad,0x653a02b5,0xbcfb00a0,0x80c10e96}},	//   _žurn, _צענד, _chém, _वारे,
   {{0x63a920ae,0xfd1f027a,0xe7f020af,0x2d8120b0}},	//   msen, _alì_, चिता_, _buhe_,
   {{0x63a91e54,0x523902b5,0x60dd20b1,0x68fb20b2}},	//   lsen, _מײַנ, besm, _onud,
   {{0xfce30f9e,0x693c016f,0x1d0705a1,0x2d8120b3}},	//   лосо, rček, неси_, _duhe_,
   {{0x63a9190f,0x6b4b00b5,0xab6620b4,0x78a00051}},	// [17a0] nsen, lügy, евал, _remv,
   {{0x3ea102bf,0x63a920b5,0x291f0065,0x68fb0103}},	//   _geht_, isen, _alua_, _anud,
   {{0x81cd0083,0x26dc07e5,0x25710009,0x78a000d7}},	//   রিক_, vevo_, _ešli_, _pemv,
   {{0xc7c620b6,0x63a920b7,0x80de0083,0x291f01f7}},	//   ески, ksen, যাক্, _clua_,
   {{0x26dc20b8,0x63a920b9,0xb05b01ff,0x64591766}},	//   tevo_, jsen, lfär, _nywi,
   {{0x63a901b4,0x290d0107,0x81d60033,0x75ca013b}},	//   dsen, _eoea_, সিত_, _həzi,
   {{0xd91007e4,0x26dc20ba,0x68e9104e,0x78a0008b}},	//   _پیش_, revo_, _faed, _temv,
   {{0xd90d04cd,0x44f40836,0xdb0401ef,0x68e920bb}},	//   _ویل_, тпис, muiñ, _gaed,
   {{0x645920bc,0x26dc0382,0x63a920bd,0x394701ef}},	//   _cywi, pevo_, gsen, énse_,
   {{0x2120005d,0x2f1400be,0x9f40009e,0x00000000}},	//   _alih_, _kägu_, _triù_, --,
   {{0x2258054e,0x75d3017e,0x60dd20be,0x63a920bf}},	//   ærk_, _ميلا, tesm, asen,
   {{0x2d8120c0,0x3ea102b1,0xaac720c1,0xc8790160}},	//   _ruhe_, _seht_, _लाभक, _saşi_,
   {{0x60dd20c2,0x645900e9,0x2d811a08,0x777a01ed}},	//   resm, _gywi, _suhe_, _kitx,
   {{0xb05b01ff,0x60dd0c2c,0x00000000,0x00000000}},	//   ffär, sesm, --, --,
   {{0xa01b006c,0x777a01a3,0x2ca20107,0x1df81ac5}},	//   nböz, _mitx, _bekd_, неры_,
   {{0x81cd0083,0xbcfb0248,0x2d8c1dad,0x212008b7}},	//   রিখ_, _thém, ídea_, _glih_,
   {{0x80de0033,0xfe7000b5,0x5c750382,0x7ff70079}},	// [17b0] যাখ্, لدہ_, тлат, _أسعا,
   {{0x79a720c3,0x2120011c,0xbb1b0160,0x291f0079}},	//   ерде, _zlih_, _atîr, _slua_,
   {{0xc3330122,0x291f01e8,0x290d0159,0xdb041e6e}},	//   נוע_, _plua_, _poea_, guiñ,
   {{0x6ecd009a,0x9f52021e,0x777a0065,0x63a920c4}},	//   द्रु, _aryè_, _aitx, ysen,
   {{0x672301f4,0x777a06a2,0x25710254,0x7afc009e}},	//   thnj, _bitx, _ušli_, _fnrt,
   {{0x7bcd20c5,0x61260093,0x45d50f8c,0x765a20c6}},	//   mtau, _gólf, вцит, _byty,
   {{0x7d0f00b5,0x7bcd20c7,0xb8950037,0x5a4400af}},	//   _kocs, ltau, _للأع, _бэта,
   {{0x63a920c8,0x672301f4,0x645901ef,0x68fb00a8}},	//   tsen, shnj, _pywi, _unud,
   {{0x777a20c9,0x49440d8a,0xab5b1eae,0xa775021d}},	//   _fitx, _сэрб, _aqüi, _алач,
   {{0x765a01f4,0x7d0f20ca,0x777a01d7,0x00000000}},	//   _fyty, _locs, _gitx, --,
   {{0x63a920cb,0x64590035,0x7bcd00c3,0x31690069}},	//   ssen, _wywi, htau, _bhaz_,
   {{0x63a920cc,0xa2bd1f57,0x7bcd0110,0x777a0065}},	//   psen, _शाक्, ktau, _zitx,
   {{0xa3e509a3,0x61e1001e,0x7bcd0009,0xab5b0183}},	//   _पनि_, swll, jtau, _eqüi,
   {{0x81bc00ea,0x7bcd20cd,0x777a0176,0xb46401e0}},	//   izēj, dtau, _xitx, _скіл,
   {{0xed5a20ce,0x7d0f20cf,0x2d9e20d0,0xb14620d1}},	//   дов_, _bocs, ète_, _инкл,
   {{0xed4320d2,0x693c0169,0xb05b0301,0x3169009f}},	//   ансп, lčev, rfär, _ghaz_,
   {{0xed57051b,0x75ca01c2,0xb05b038e,0xac830036}},	// [17c0] тот_, _vəzi, sfär, ргул,
   {{0x693c0496,0x81bc0029,0x387f01d7,0xdcef0395}},	//   nčev, dzēj, _agur_, _pică,
   {{0x18a620d3,0x7d0f20d4,0xb05b20d5,0x777a0065}},	//   ваем, _focs, ngän, _ritx,
   {{0x693c0009,0x672120d6,0xdcfe20d7,0x00000000}},	//   hčev, _allj, _kupč, --,
   {{0x2ba920d8,0xc0ad0070,0x765a0421,0x693c030a}},	//   _चौपा, ליאָ, _syty, kčev,
   {{0xcf9300c2,0x693c02f6,0x387f01b7,0xdcef0139}},	//   סטו_, jčev, _egur_, _tică,
   {{0x644e0095,0x19b900c3,0x777a0176,0xdb0420d9}},	//   əbiy, _путь_, _vitx, quiñ,
   {{0x291c00ea,0x765a00ac,0xaa4318e8,0x00000000}},	//   īvas_, _vyty, _тесл, --,
   {{0xf3660c4c,0x9f4000fe,0x00000000,0x00000000}},	//   ктон, _asií_, --, --,
   {{0x5186151c,0xd76400d1,0x81d60033,0x764d00b5}},	//   кума, _صنای, সিস_, ényé,
   {{0x69130723,0xaad40f9c,0x54c600af,0x6d4600f4}},	//   _içer, ठ्यक, _абеб, _ojka,
   {{0x7bcd010b,0xf48320da,0x00000000,0x00000000}},	//   ytau, _кушн, --, --,
   {{0x693c0a66,0x69c400b4,0xc05801e0,0x7d0f20db}},	//   bčev, ांडी, вір_, _rocs,
   {{0xdcfe0009,0x82330416,0x81cd0033,0xdb23027d}},	//   _dupč, اریا, রিজ_, örün,
   {{0xd37b1804,0x98ad20dc,0x00000000,0x00000000}},	//   _קרוט, _smeč_, --, --,
   {{0x7bcd0086,0xaac60d91,0xdb21027d,0x00000000}},	//   ttau, र्घक, ştür, --,
   {{0x2d5803ad,0x8aa703f5,0x213920dd,0x7bcd0024}},	// [17d0] тить_, вред, mish_, utau,
   {{0xd5a407a8,0x7bcd20de,0xdd110029,0xbcfb0037}},	//   _وہ_, rtau, _kļūd, _mhéi,
   {{0x7bcd20df,0x9f4901d6,0x6d4000f4,0xdcfe00cd}},	//   stau, _araç_, čmar, _zupč,
   {{0x213920e0,0x99d40118,0x9f490392,0x7bcd20e1}},	//   nish_, شتما, _braç_, ptau,
   {{0x2ca900ab,0x75ca00a8,0x2b58008c,0x8c67010b}},	//   maad_, _məzu, _fkrc_, _штод,
   {{0xd2460037,0x2ca91153,0x213920e2,0x366920e3}},	//   _هن_, laad_, hish_, нало_,
   {{0xa4930609,0x693c0169,0x442901ba,0x752220e4}},	//   لیات, včev, _ťa_, _bloz,
   {{0x2ca920e5,0xa3e918e0,0xdb0d0279,0x13e90fa7}},	//   naad_, едиа_, fraç, емий_,
   {{0xbcfb0082,0xdb0d0370,0x291d20e6,0x67380124}},	//   _chéi, graç, mkwa_, bivj,
   {{0x2ca920e7,0x201920e8,0xdcfe0124,0xbcfb0079}},	//   haad_, dysi_, _rupč, _dhéi,
   {{0xc69200c2,0xa0a60de3,0x693c129f,0xbbd001c0}},	//   _האב_, ланд, rčev, _सङ्क,
   {{0x85040118,0xbcfb004f,0xdb0d0279,0xb05b033b}},	//   _پوهن, _fhéi, braç, rgän,
   {{0x2ca90298,0x693c0121,0xf53901ba,0xbcfb0079}},	//   daad_, pčev, miť_, _ghéi,
   {{0xf539016f,0x248d20e9,0x752220ea,0x343a0070}},	//   liť_, lcem_, _zloz, _אײנע,
   {{0x63bb0029,0x2f1401ff,0xa30a00b5,0x715a0b25}},	//   lrun, _sägs_, _سروے_, _прис_,
   {{0x248d20eb,0xf539016f,0x693c0690,0x673820ec}},	//   ncem_, niť_, nčet, zivj,
   {{0xb7be00c8,0x6126171c,0x2d9301d7,0x63bb20ed}},	// [17e0] _ইন্ট, _cóle, _etxe_, nrun,
   {{0x81d60083,0x4f9b025a,0x00000000,0x00000000}},	//   সির_, _רביצ, --, --,
   {{0x63bb02bf,0x2ca91505,0x991603d0,0xeb75010b}},	//   hrun, baad_, льді, рытэ,
   {{0xf53901ba,0xb95a0037,0x248d20ee,0x63a4027b}},	//   jiť_, رجاء_, jcem_, _çing,
   {{0x6d4420ef,0xf539016f,0xb8dc0e68,0x645d00ab}},	//   mnia, diť_, _आय_, üsil,
   {{0x6d441647,0x21390031,0x63bb20f0,0x752220f1}},	//   lnia, zish_, drun, _sloz,
   {{0x63bb02c9,0x25a0011c,0x6d4400be,0xbcfb0098}},	//   erun, ćilo_, onia, _shéi,
   {{0x6d4420f2,0x6d5620f3,0xdb0d0279,0x7aee009f}},	//   nnia, noya, traç, _habt,
   {{0x63bb20f4,0xd90d0332,0x7aee043d,0x6d4420f5}},	//   grun, _تین_, _kabt, inia,
   {{0x6d560a2d,0xdb0d0279,0x6fdf0380,0x254c00b8}},	//   hoya, rraç, _पैगं, děle_,
   {{0x2d980274,0x6d5620f6,0xf539016f,0x2ca9034d}},	//   jpre_, koya, biť_, yaad_,
   {{0x46131a95,0x63bb20f7,0x6d44006f,0x752200cd}},	//   _دومر, brun, jnia, _uloz,
   {{0x63bb20f8,0x213920f9,0x6d441cca,0x29370070}},	//   crun, rish_, dnia, ראכן_,
   {{0x69dc20fa,0x2ca901bf,0xa29401c8,0x7aee01e8}},	//   _opre, waad_, _такі, _nabt,
   {{0x693c0df4,0x6d44001e,0x65600037,0x213901e9}},	//   nčes, fnia, olmh, pish_,
   {{0x6d5620fb,0x6ed609b4,0x6d4420fc,0x213901e9}},	//   goya, म्बु, gnia, qish_,
   {{0x69dc20fd,0x2ca917ff,0x81c60033,0x69ce035f}},	// [17f0] _apre, raad_, _উনি_, _aqbe,
   {{0xf539016f,0x2ca920fe,0x63a220ff,0x6d440d98}},	//   ziť_, saad_, _mwon, ania,
   {{0x6d442100,0x7aee0189,0x6d56011e,0x13c1164f}},	//   bnia, _dabt, boya, _शम्भ,
   {{0x2ba90324,0x57f52101,0x6d440035,0x9f4002d7}},	//   _चौथा, ипет, cnia, _frió_,
   {{0xf5390038,0x69dc2102,0x6b860118,0x00000000}},	//   viť_, _epre, _gukg, --,
   {{0x7d0d2103,0xc5f90083,0x291d0ed1,0xdb231a95}},	//   ljas, _অথবা_, skwa_, _اوسی,
   {{0xf539016f,0x63a22104,0x80ab0083,0x2ba90761}},	//   tiť_, _awon, _কান্, _चौता,
   {{0x63bb2105,0x7d0d2106,0xdb04069c,0x63a22107}},	//   trun, njas, brió, _bwon,
   {{0x7c2d2108,0xf576004f,0xf539016f,0x61f80282}},	//   nzar, جميع_, riť_, _arvl,
   {{0x63bb2109,0xc6a40370,0xadf7210a,0x248d210b}},	//   rrun, _грци, ुमान_, scem_,
   {{0x6d440297,0x248d210c,0xf539016f,0x6d560054}},	//   ynia, pcem_, piť_, yoya,
   {{0x63bb210d,0x7bdd008c,0x63a202d0,0x61f800f4}},	//   prun, _opsu, _fwon, _drvl,
   {{0xe28e210e,0x53a5210f,0xa6e80083,0x6d562110}},	//   _ма_, _талб, পারট, voya,
   {{0x26c72111,0x6d442112,0x08760070,0x753b2113}},	//   ngno_, wnia, יערט_, liuz,
   {{0x7aee003c,0x442d2114,0x7bdd2115,0xada601db}},	//   _rabt, lze_, _apsu, рабл,
   {{0x7aee20fb,0xef862116,0x06af0033,0x27e60090}},	//   _sabt, _клип, চ্চি, ywon_,

   {{0x2d9809eb,0x6d442117,0xafe61a1c,0x442d16a3}},	// [1800] spre_, rnia, _топл, nze_,
   {{0x25610093,0x69dc2118,0x693c00ac,0x7d0d2119}},	//   fólk_, _ppre, jčer, ajas,
   {{0x6d56211a,0x09e603fe,0xfc3f00de,0x7c2d01ef}},	//   poya, роен, _veía_, azar,
   {{0xe3a7211b,0x442d1b66,0x2900188a,0x753b0054}},	//   _ور_, kze_, ñia_, jiuz,
   {{0x7aee211c,0x442d211d,0x06af0083,0x7c2d0067}},	//   _tabt, jze_, চ্ছি, czar,
   {{0x442d211e,0xdb040300,0x501b0d85,0x699601e0}},	//   dze_, rrió, כונו, _врах,
   {{0xe1e7211f,0x69dc2120,0xf526019e,0xceb300a5}},	//   _بس_, _upre, ифин, קיה_,
   {{0x62832121,0x7c3b011c,0x63a202d0,0x75292122}},	//   _agno, _žuri, _pwon, ghez,
   {{0x39460f56,0x430601e0,0x5346126e,0x00000000}},	//   mnos_, аїна, ихоа, --,
   {{0xf3662123,0x394600e1,0x00000000,0x00000000}},	//   јтин, lnos_, --, --,
   {{0x79801cf5,0x26cc046a,0x442d030d,0x7c2d0a1f}},	//   _kimw, _icdo_, aze_, zzar,
   {{0x75290657,0x63a22124,0xd2571ca4,0x39462125}},	//   chez, _twon, рць_, nnos_,
   {{0x442d0755,0x63a22126,0x39462127,0x25a900cd}},	//   cze_, _uwon, inos_, ćale_,
   {{0xdced0076,0x6d482128,0x394600e9,0xd4670274}},	//   rmač, édan, hnos_, _тиче_,
   {{0x28d71f57,0xeca70798,0x6233021d,0x7d0d2129}},	//   ण्डि, ијан, _мешу, tjas,
   {{0x7c2d212a,0xc27b02b5,0x3946006c,0xdb0420d9}},	//   tzar, _ברוי, jnos_, driñ,
   {{0x7d0d212b,0x29e80043,0x67da00ea,0x7bc4212c}},	// [1810] rjas, _aşa_, nājā, guiu,
   {{0x7c2d212d,0x39460a09,0x6aa70031,0x7d0d212e}},	//   rzar, enos_, _qejf, sjas,
   {{0x442d212f,0x2b4a022e,0x79800010,0x7c2d2130}},	//   zze_, _djbc_, _bimw, szar,
   {{0x39462131,0x645d00ab,0x7980099e,0x00000000}},	//   gnos_, üsik, _cimw, --,
   {{0x6126008a,0x6d5d0430,0xa91d011c,0x79800260}},	//   _jóla, _iksa, _niže, _dimw,
   {{0x39462132,0xdb0401dd,0x6d5d011e,0x66e52133}},	//   anos_, briñ, _hksa, сока,
   {{0x60cd2134,0x3f890160,0x7afa0093,0xa3a92135}},	//   _ocam, _luau_, _ótta, गीन_,
   {{0x442d2136,0x7ae50f67,0x69c52137,0x22490124}},	//   tze_, leht, muhe, _ćak_,
   {{0xc95202da,0x442d2138,0xf79400d8,0x3d081b8f}},	//   _זמן_, uze_, _матэ, हाते_,
   {{0x442d0632,0x78a92139,0xa91d213a,0x798001d5}},	//   rze_, _heev, _diže, _zimw,
   {{0x442d213b,0x568c0070,0x75290110,0x78a900be}},	//   sze_, _סטאַ, phez, _keev,
   {{0x2d6802c9,0x6126213c,0x7ae501f4,0x614600af}},	//   eßen_, _bóla, heht, сема,
   {{0x78a9213d,0x3f810027,0x69c5213e,0x00000000}},	//   _meev, _bihu_, huhe, --,
   {{0x6d5d213f,0x539a0122,0x61262140,0x39462141}},	//   _aksa, _עיצו, _dóla, znos_,
   {{0xe16400d1,0xfbdf021d,0x853c00c7,0x394600c7}},	//   _وضعی, _apê_, _kvėp, ynos_,
   {{0x2ba90084,0x4c862142,0x61362143,0x60cd0098}},	//   _चौहा, слав, kšli, _gcam,
   {{0x79800010,0xf3880023,0xdb040132,0x3f891c5b}},	// [1820] _rimw, _lợn_, nsiç, _guau_,
   {{0xf1db0f39,0xdb0403e6,0x6ac6004f,0x79802144}},	//   _बहान, isiç, إقام, _simw,
   {{0x1efb02b5,0x27ed021e,0x69c52145,0x78a92146}},	//   _עלטע, _asen_, guhe, _beev,
   {{0x78a90221,0x1d0a2147,0xdb042148,0xbcfb2149}},	//   _ceev, _семи_, rriñ, _dhés,
   {{0x39462140,0x7bc41228,0xaab80609,0x27ed0036}},	//   rnos_, quiu, _نگار_, _csen_,
   {{0x96f8002d,0x254c00b8,0x69c5214a,0x3946005f}},	//   рект_, děla_, buhe, snos_,
   {{0x2d820054,0x39460282,0x78a9214b,0xa91d00ec}},	//   _kike_, pnos_, _feev, _siže,
   {{0x77860086,0x2ca003bc,0x78a90051,0x81bf0033}},	//   _глаз, nbid_, _geev, ুবা_,
   {{0x2d8200a5,0xccf3011d,0x4acf0026,0x2904214c}},	//   _mike_, לכה_, स्कव, _inma_,
   {{0x2d82214d,0xaaa80d53,0x78a90223,0x60cd214e}},	//   _like_, गरिक, _zeev, _scam,
   {{0xe7f01e79,0xd5b902ce,0x61260093,0x71270037}},	//   चिका_, _всі_, _sóla, مرحل,
   {{0x81bc0080,0x78a901e8,0x6126214f,0xa1592150}},	//   dzēt, _xeev, _póla, раму_,
   {{0xa2d31e79,0xd8d70070,0xf09f0176,0x00000000}},	//   _बॉक्, זוכט_, rbà_, --,
   {{0x437400bf,0xdb041ba3,0x6e940421,0x2d68033b}},	//   _بهتر, nsiä, зиру, ußen_,
   {{0xd0470095,0xe1890019,0x2d822151,0x9cf52152}},	//   _əməl, _hẳn_, _bike_, озві,
   {{0x2d820055,0x61440d6e,0x00000000,0x00000000}},	//   _cike_, _неја, --, --,
   {{0x5b151238,0x2d8201f4,0x7ae500c3,0xdb042153}},	// [1830] омат, _dike_, teht, trið,
   {{0xbcfb2154,0x78a92155,0x2d822156,0xdcfe0160}},	//   _chér, _seev, _eike_, _pupă,
   {{0x78a92157,0xd91b03d4,0x7ae51cfc,0x13e10033}},	//   _peev, льд_, reht, বিয়,
   {{0x69c52158,0xf38800e2,0x7ae52159,0x2d820371}},	//   ruhe, _rợn_, seht, _gike_,
   {{0xf771215a,0x6b8d0069,0x78a900be,0x212900e0}},	//   وات_, qqag, _veev, _mlah_,
   {{0xb6a5215b,0x290400d7,0x69c500c3,0x2129215c}},	//   цикл, _enma_, puhe, _llah_,
   {{0x2129149f,0x36fe0084,0x78a9215d,0xf59202e7}},	//   _olah_, लाड़ी_, _teev, ولوج,
   {{0x58d4215e,0xe3b90ef3,0x321e0035,0x254c00b8}},	//   _ност, аби_, dyty_, těla_,
   {{0x27ed215f,0x981700bf,0x395f06a2,0x2cab008c}},	//   _usen_, _ابزا, _ikus_, _mecd_,
   {{0xdb160086,0x21290088,0xaacc2160,0xf38800e2}},	//   styö, _alah_, ालयक, _tợn_,
   {{0x9f4901ae,0x81bc00ea,0xdcfd0409,0x21290147}},	//   _spaß_, dzēs, _aisč, _blah_,
   {{0x6f0500e2,0x00000000,0x00000000,0x00000000}},	//   _anhc, --, --, --,
   {{0x2d822161,0x28d10266,0x6f171505,0x200f0392}},	//   _rike_, _हानि, _boxc, _àgil_,
   {{0xe29913ad,0x05dd0b35,0x321e2162,0xdcfd02c4}},	//   _так_, _महाब, byty_, _disč,
   {{0x395f2163,0xad3a00d4,0x2ca00312,0x321e06bc}},	//   _okus_, ачає_, tbid_, cyty_,
   {{0x644a012e,0xc5f2011d,0x8d66010b,0x4d6602a4}},	//   šmiš, ודל_, івае, ікав,
   {{0xcb050461,0x25a0011c,0x4aaa18cd,0x2d820210}},	// [1840] रांड_, ćili_, икан_, _vike_,
   {{0x5ec10083,0x395f01e9,0x00000000,0x00000000}},	//   শ্বে, _akus_, --, --,
   {{0xa3a90f8a,0x2d822164,0x7f5c00f7,0xb9ea00af}},	//   गीत_, _tike_, morq, рмез_,
   {{0x6d4100f7,0x7f5c0036,0xdd0f0225,0x2006009e}},	//   élat, lorq, mışs, _àois_,
   {{0x7d0600c7,0xbcfb00f7,0x321e0067,0x00000000}},	//   _inks, _thér, zyty_, --,
   {{0xd5ba14a1,0xab2a0202,0x394d2165,0x3d080099}},	//   аси_, _тога_, _ejes_, हावे_,
   {{0x386d2166,0x76a900d4,0x7f5c002a,0x3eba00ee}},	//   _ezer_, стів_, iorq, _mdpt_,
   {{0xdb04081b,0x89d700fd,0x00000000,0x00000000}},	//   ssiä, _گوہر_, --, --,
   {{0x73fa0083,0x25a90254,0x78a22167,0xd7d10067}},	//   েন্ট_, ćala_, mbov, _समयच,
   {{0x5edf0033,0x2d9a0176,0x1fd00033,0xd370017e}},	//   _ফোনে, _otpe_, িবাস, عهد_,
   {{0x92581b17,0xaacf020d,0x6126021d,0x00000000}},	//   сант_, स्टक, _cólo, --,
   {{0xd13b0036,0x7bd608dd,0x69c308b7,0x78a22168}},	//   рхо_, ktyu, šneg, nbov,
   {{0xb97b0100,0xf8b30122,0x357300b5,0xb03400c3}},	//   ינטי, ושר_, _تھوڑ, дняш,
   {{0x7d0601c8,0x321e00a0,0x00000000,0x00000000}},	//   _anks, pyty_, --, --,
   {{0xdef801c8,0x61262169,0x6f17021d,0x00000000}},	//   цыя_, _gólo, _voxc, --,
   {{0x2129216a,0x254500ea,0x4add022e,0xaadd0355}},	//   _ulah_, tēli_, न्नव, न्नक,
   {{0xb7c50033,0x29fa00ee,0x78a200d5,0xa91d02a7}},	// [1850] _এন্ট, _aďa_, dbov, _niža,
   {{0xdea1006c,0xcb050026,0x6f05216b,0x395f0501}},	//   _سیری, राइड_, _unhc, _skus_,
   {{0x386d07cf,0x4c9500af,0x394d0031,0x78a2021d}},	//   _szer_, _нинс, _pjes_, fbov,
   {{0xdb0d0037,0xa91d0207,0x00000000,0x00000000}},	//   msaí, _biža, --, --,
   {{0x3d080299,0x8cd8007c,0x07a50be8,0x395f00ac}},	//   हारे_, मभरो, чалн, _vkus_,
   {{0x370700c3,0xa91d00ec,0x00000000,0x00000000}},	//   ючев, _diža, --, --,
   {{0x394d216c,0x7af501ed,0x98a600d5,0x67230207}},	//   _tjes_, _iazt, choď_, rknj,
   {{0x7af5216d,0x67d50664,0x395f011c,0x6126002a}},	//   _hazt, _нобу, _ukus_, _cóll,
   {{0x26de0051,0x7f5c0453,0x3a210159,0x6126143e}},	//   _fbto_, yorq, lyhp_, _sólo,
   {{0xfbd202b8,0x395d00a5,0x27ff01a3,0x6126021d}},	//   עתי_, lows_, _irun_, _pólo,
   {{0x644d01c8,0x4add01d1,0xaadd0569,0x69d701a3}},	//   _žaid, न्यव, न्यक, ntxe,
   {{0x395d0159,0x70c600a1,0x7af501a3,0x69d701ed}},	//   nows_, वलेल, _lazt, itxe,
   {{0x7f5c216e,0x4f96010b,0x80ab0831,0x00000000}},	//   torq, ярну, _কাশ্, --,
   {{0x2d96216f,0xe7e313a0,0x539a00a5,0x00000000}},	//   зрас, _गहना_, _היסו, --,
   {{0x80ab00c8,0x78bb0254,0x78a20097,0x69d701e8}},	//   _কার্, _oduv, ybov, jtxe,
   {{0x80da00c8,0x6d4f0176,0x7af501ed,0x69d70176}},	//   _বোর্, _cjca, _aazt, dtxe,
   {{0x7af506a2,0x3b182170,0xe8df0019,0x31db0099}},	// [1860] _bazt, _porq_, _ngựa_, _बहुध,
   {{0x7bd60159,0x59d00066,0xa91d02a7,0x00000000}},	//   rtyu, _हमदर, _riža, --,
   {{0x2730098b,0xe9da2171,0xdb0d0079,0x78a200d5}},	//   _hàng_, ске_, csaí, tbov,
   {{0x27ff2172,0xdb040079,0xd9100416,0xa91d20d7}},	//   _brun_, nsiú, خیر_, _piža,
   {{0x78a22173,0xdb040079,0x27ff01da,0xa09b025a}},	//   rbov, isiú, _crun_, ציסט,
   {{0x7af503cb,0x27300019,0xe3c30033,0x28d10066}},	//   _gazt, _màng_, ্বাব, _हाथि,
   {{0x09e30de1,0x273001a5,0x98a60346,0xa5d70037}},	//   _порн, _làng_, _ниве, كبير_,
   {{0x53982174,0x27ff017b,0x00000000,0x00000000}},	//   овия_, _frun_, --, --,
   {{0x273001a5,0x27ff2175,0x7af50103,0x00000000}},	//   _nàng_, _grun_, _yazt, --,
   {{0x59d01ee0,0x798e2176,0xaacc2177,0x96660043}},	//   _हमार, _kubw, ालिक, _екзе,
   {{0xc4862178,0x200000ea,0x00000000,0x00000000}},	//   _елек, _arii_, --, --,
   {{0x27300023,0x798e018c,0x7bc4004b,0x92ac0033}},	//   _bàng_, _mubw, kriu, গলে_,
   {{0xc05b00c7,0x273001a5,0xb4e804bc,0xe509021a}},	//   сін_, _càng_, मजी_, वारि_,
   {{0x7bc4010b,0x273001a5,0xa91d07c0,0x80cf00ab}},	//   driu, _dàng_, _nižn, _थावे,
   {{0x7bc4007c,0x798e0010,0x7af508b7,0x00000000}},	//   eriu, _nubw, _razt, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6c54135d,0xc1580052,0x705500d1,0x31ae0083}},	// [1870] екту, _משהו_, _زندا, _কমিশ,
   {{0x60dd2179,0x798e001c,0x00000000,0x00000000}},	//   lfsm, _bubw, --, --,
   {{0xa2cf0067,0x79a400c3,0x995e06fe,0x00000000}},	//   _दास्, ерче, _hůř_, --,
   {{0x7bc4217a,0x656201ac,0x63740310,0x69d701b7}},	//   briu, _nkoh, lànd, rtxe,
   {{0x7bc412c3,0x6d4d00ab,0x63740176,0x395d024b}},	//   criu, mnaa, càng, rows_,
   {{0x6d4d217b,0xf7730bf5,0x6562217c,0x00000000}},	//   lnaa, راش_, _akoh, --,
   {{0x6d4d1b43,0x25a9011c,0x798e0103,0x00000000}},	//   onaa, ćalo_, _gubw, --,
   {{0x6d4d217d,0x92ac0083,0x63bd0097,0x6298217e}},	//   nnaa, গলো_, ásno, _afvo,
   {{0x47d50082,0x6ece00a1,0x68eb0c99,0x5eb30083}},	//   _زيار, _तालु, megd, _জানে,
   {{0x70c6052f,0x27300019,0x68eb217f,0x20fa00e2}},	//   वल्ल, _ràng_, legd, _ỏi_,
   {{0x27300023,0x69c500e9,0x6d4d2180,0x60dd05aa}},	//   _sàng_, nrhe, knaa, ffsm,
   {{0xd7d10a5e,0xe7d10e6f,0x4add0355,0xaadd00b8}},	//   _समाच, _समाप, न्तव, न्तक,
   {{0x6d4d2181,0x69c501ae,0x316c0228,0x00000000}},	//   dnaa, hrhe, ēdz_, --,
   {{0x27300028,0x65692182,0xf1a801cb,0x6d4d2183}},	//   _vàng_, lleh, _کاوه_, enaa,
   {{0xa3a90d1f,0xa91d01a0,0x00000000,0x00000000}},	//   गीर_, _nižo, --, --,
   {{0x6d4d2184,0x27300019,0x65692185,0x69c500d5}},	//   gnaa, _tàng_, nleh, drhe,
   {{0x3b8607e5,0x6b870a75,0x2cb20159,0x8c432186}},	// [1880] длаг, _bijg, rayd_, вете,
   {{0x6d4d030d,0xdcfd0029,0xfaa300af,0x63740392}},	//   anaa, _visā, вафо, cànd,
   {{0xa91d02c4,0xaadd0355,0xfe720037,0x68eb0009}},	//   _vižn, न्धक, _جدة_, fegd,
   {{0x7bc400af,0x2d57003c,0xeb9f0c71,0x6fd2021a}},	//   priu, għed_, _brød_, _तमां,
   {{0x69c502e6,0x9f490176,0x65692187,0x6d4408c7}},	//   arhe, _graó_, dleh, miia,
   {{0x4add0edf,0x81e40033,0xaadd0edf,0xa91d0116}},	//   न्दव, নিত_, न्दक, _fižo,
   {{0xa3b02188,0x80cf000c,0xb05b191b,0xdce4031d}},	//   टीन_, _थाले, ngär, hlič,
   {{0xdce40693,0x6ba5013c,0x65692189,0xdb060185}},	//   klič, _åtgä, gleh, _avkø,
   {{0xd8d700c2,0x7c24218a,0xa3a900a1,0xeb9f1f8b}},	//   _קומט_, nyir, गील_, _grød_,
   {{0x612600fb,0xdce4031d,0x5214218b,0x00000000}},	//   _fólk, dlič, едот, --,
   {{0x656901a2,0x6d4d0345,0x7c240010,0xa2cf00c0}},	//   bleh, ynaa, hyir, _दार्,
   {{0xf3880028,0x6569218c,0x65620027,0x60dd02b1}},	//   _lợi_, cleh, _ukoh, ufsm,
   {{0xdce4024e,0x60dd008a,0x28d100b1,0x61ed0207}},	//   glič, rfsm, _हासि, _ćale,
   {{0x4424004e,0x272b0185,0x6560218d,0x00000000}},	//   mym_, _lønn_, lomh, --,
   {{0x4424218e,0x6d4d218f,0x6d5f0be2,0x200d002d}},	//   lym_, tnaa, toqa, ţei_,
   {{0xdce4039c,0x6d4d081b,0xa91d2190,0x5cc40d6e}},	//   blič, unaa, _rižo, ксуз,
   {{0x44242191,0x4ea72192,0x6d4d0130,0x31340036}},	// [1890] nym_, _орна, rnaa, _шеър,
   {{0xa3e60084,0x65600315,0x6d4d2193,0xdb1602d0}},	//   _पहन_, homh, snaa, nsyè,
   {{0x6d4d0223,0x44240168,0x6b870051,0x6569081b}},	//   pnaa, hym_, _vijg, yleh,
   {{0x7c240010,0x69c52194,0x6b9d011e,0x44240334}},	//   byir, rrhe, _ttsg, kym_,
   {{0xdb1602d0,0xa3b00026,0x7c2401d5,0x6b8702a2}},	//   ksyè, टीम_, cyir, _tijg,
   {{0x7d1d006c,0x44240297,0x96da021a,0x00000000}},	//   _hoss, dym_, प्लॉ, --,
   {{0xdce40888,0xf38801a5,0x65692195,0x3cf900be}},	//   zlič, _gợi_, tleh, _kasv_,
   {{0x7d1d03ad,0xa565132d,0x00000000,0x00000000}},	//   _joss, رگان, --, --,
   {{0x7d1d2196,0x65692197,0xa3c10722,0xa3a90066}},	//   _moss, rleh, ौंध_, गीं_,
   {{0x65692198,0xdce40169,0x657b08dd,0x7d1d2199}},	//   sleh, vlič, smuh, _loss,
   {{0xcb120bed,0x216a219a,0x79890298,0x7bcd021d}},	//   אלי_, зини_, _kiew, huau,
   {{0x7d1d00c9,0x4424219b,0xdce4219c,0x6126219d}},	//   _noss, bym_, tlič, _kóli,
   {{0xdce40129,0xb42703c7,0x4424004e,0x442701b2}},	//   ulič, _تعاو, cym_, _تراف,
   {{0x79890173,0x7529006c,0xdce4219e,0x7bcd00be}},	//   _liew, lkez, rlič, duau,
   {{0xdd9203c7,0xfce6219f,0xdce400ac,0x6e9321a0}},	//   اور_, ново, slič, الفا,
   {{0x7989004e,0x7d1d21a1,0x5ec10033,0x2d9e00ea}},	//   _niew, _coss, শ্লে, īte_,
   {{0x7d1d21a2,0xf3880019,0x2d9e0197,0x7ff60037}},	// [18a0] _doss, _sợi_, ūte_, _أسبا,
   {{0xe8030127,0x637401f7,0x272b0044,0x00000000}},	//   लिना_, mànc, _sønn_, --,
   {{0x3cfb08b0,0x7d1d09b5,0x3f92000e,0x4424004e}},	//   _लोके_, _foss, _huyu_, zym_,
   {{0x59d2083f,0x69c31111,0xed5a0210,0xdcfd0139}},	//   दंबर, ánea, _хом_, _visă,
   {{0x61261d2b,0x6f1e15bc,0x798921a3,0x28d1178c}},	//   _cóli, _kopc, _diew, _हारि,
   {{0xa847004f,0x57f303fa,0x254c0355,0x44240bca}},	//   علوم_, упшт, měli_, vym_,
   {{0x612621a4,0x4424006a,0x00000000,0x00000000}},	//   _eóli, wym_, --, --,
   {{0x61261d85,0xc44801cb,0x442421a5,0x752900b5}},	//   _fóli, ویان_, tym_, gkez,
   {{0x394621a6,0x84970037,0x3f920371,0x00000000}},	//   mios_, رئيس_, _nuyu_, --,
   {{0x394621a7,0x65600568,0x81e40083,0x2eaa01d1}},	//   lios_, somh, নিস_, करोत,
   {{0x041e0083,0x6ed721a8,0xd9430043,0xa15921a9}},	//   _বেশী_, _बाबु, _реӂи, дану_,
   {{0x394621aa,0xb7f40084,0x2a6a21ab,0x63740310}},	//   nios_, _इनाम_, _mybb_, fànc,
   {{0x7d1d21ac,0x5f940382,0xe803073f,0xb8030803}},	//   _ross, лият, लिया_, लियम_,
   {{0x39460608,0x254c00b8,0x539b0317,0xdefb00d8}},	//   hios_, děli_, _ציוו, чым_,
   {{0x7d1d21ad,0x394600d8,0xdb0d21ae,0x28d104aa}},	//   _poss, kios_, drað, _हालि,
   {{0x9d180896,0xe8030266,0xa91d063c,0x00000000}},	//   ност_, लिमा_, _pižm, --,
   {{0x39462140,0xdb0d1f98,0x7d1d21af,0x70bf1a75}},	// [18b0] dios_, nsaç, _voss, ्लील,
   {{0xdb0d0f56,0x798921b0,0x7bcd028b,0x7d1d081b}},	//   trañ, _siew, ruau, _woss,
   {{0x7d1d21b1,0xa2d821b2,0x394617db,0xa7fd006c}},	//   _toss, _मान्, fios_, _gyűj,
   {{0x394621b3,0x61260093,0x3f920118,0xdb0d21b4}},	//   gios_, _póli, _yuyu_, rrañ,
   {{0x79890052,0x2ca921b5,0x7c6721b6,0x00000000}},	//   _view, mbad_, _ساحل, --,
   {{0x2d8b0831,0x2ca9043d,0x366921b7,0x66e5052a}},	//   _hice_, lbad_, мало_, тока,
   {{0x75290332,0x79890345,0x2d8b005f,0x00000000}},	//   tkez, _tiew, _kice_, --,
   {{0x39460d65,0x2ca921b8,0x73e505c2,0x00000000}},	//   cios_, nbad_, воиз, --,
   {{0x80a204aa,0x752921b9,0x442b21ba,0x2d9321bb}},	//   _क्षे, rkez, ác_, _luxe_,
   {{0x2d8b0470,0x3eb30052,0x69ca0279,0x68fb2198}},	//   _lice_, _next_, áfeg, _haud,
   {{0x68fb21bc,0x2d8b21bd,0x3f9200d0,0xbcfb0168}},	//   _kaud, _oice_, _suyu_, _akém,
   {{0x2eaa0c67,0x614621be,0x236c21bf,0x629a0024}},	//   कर्त, тема, aldj_, acto,
   {{0x200421c0,0x291f006d,0x68fb21c1,0x2ca921c2}},	//   ími_, _moua_, _maud, dbad_,
   {{0x2d8b0094,0x80a20d00,0x394621c3,0x6f630421}},	//   _aice_, _क्रे, zios_, ивяз,
   {{0x63bb21c4,0x63a4003c,0x2d8b01d5,0x0cdd021a}},	//   lsun, _ħini, _bice_, मभूम,
   {{0x68fb21c5,0x291f0043,0x39460391,0x57d1052b}},	//   _naud, _noua_, xios_, _समूह,
   {{0x6f1e21c6,0x394621c7,0x61e40c99,0x63bb21c8}},	// [18c0] _topc, vios_, _ćili, nsun,
   {{0x5fb70122,0x6f1e025c,0x63bb21c9,0x81e40083}},	//   _שהיא_, _uopc, isun, নির_,
   {{0x39460995,0x68fb21ca,0x2ca921cb,0x7e56002d}},	//   tios_, _baud, bbad_, _штиц,
   {{0x3eb821cc,0xc7c6189d,0x1e570122,0x621a0070}},	//   lart_, вски, _ישיר_, וועק,
   {{0x39462132,0x68fb21cd,0x2d80053e,0x291f0012}},	//   rios_, _daud, mmie_, _doua_,
   {{0x394601c8,0x63bb21ce,0x2d8b002d,0xfaa321cf}},	//   sios_, dsun, _zice_, _варо,
   {{0x39461423,0x68fb0248,0xbb431ec2,0x7afc21d0}},	//   pios_, _faud, _терк, _iart,
   {{0x7afc21d1,0x29dc09ab,0x3eb8004a,0x68fb21d2}},	//   _hart, mía_, hart_, _gaud,
   {{0x29dc21d3,0x63bb05c8,0x3eb821d4,0x2c05012f}},	//   lía_, gsun, kart_, रियं_,
   {{0x68fb21d5,0x7afc06a2,0xa6c7150d,0xdb0d0132}},	//   _zaud, _jart, _алфа_, rsaç,
   {{0x29dc09ab,0x7c3a01c2,0x63bb02ee,0x69de21d6}},	//   nía_, _ətra, asun, ntpe,
   {{0x7afc01d2,0x64a621d7,0x68e200e9,0x2d800067}},	//   _lart, _рада, nfod, jmie_,
   {{0xb4ae0e1d,0xdb0409ab,0x29dc21d8,0x3eb8039b}},	//   करी_, nsió, hía_, fart_,
   {{0x63a20269,0x3eb821d9,0x2d8b01c0,0x63ad033e}},	//   _iton, gart_, _sice_, _çana,
   {{0x2d8b21da,0x29dc21db,0xdb0400a2,0x69de0031}},	//   _pice_, jía_, mpiè, jtpe,
   {{0x29dc09ab,0x7afc21dc,0xa3e600a1,0x63a20103}},	//   día_, _aart, _पहा_, _kton,
   {{0x3eb321dd,0x3eb821de,0x5c7521df,0x2ca921e0}},	// [18d0] _text_, bart_, улат, rbad_,
   {{0x29dc1f37,0x69de21e1,0xe4e20a5e,0x7e4721e2}},	//   fía_, ftpe, क्ति_, _ахме,
   {{0x29dc00c8,0x68e200e9,0x2d8b21e3,0x612601dd}},	//   gía_, ffod, _tice_, _vólv,
   {{0x63a221e4,0x7afc21e5,0x23c20099,0x63bb21e6}},	//   _oton, _eart, _शिंद, ysun,
   {{0xb8db0722,0x69dc21e7,0x68fb21e8,0x63a21642}},	//   _आज_, _eqre, _vaud, _nton,
   {{0x7afc21e9,0x29dc09ab,0x00000000,0x00000000}},	//   _gart, bía_, --, --,
   {{0x29dc09ab,0x63a221ea,0x74d70026,0x69de01e4}},	//   cía_, _aton, _यादृ, ctpe,
   {{0x7afc21eb,0x290d01a3,0x7995034d,0x00000000}},	//   _zart, _unea_, _iuzw, --,
   {{0xa8550d36,0x25be01ae,0x61ea009e,0xa91d0ce9}},	//   _скач, _evtl_, _apfl, _niži,
   {{0x63bb21ec,0x386d10c3,0x3169021e,0x79950027}},	//   rsun, _iyer_, _akaz_, _kuzw,
   {{0x63bb21ed,0x3eb821ee,0x63a221ef,0xe8df0023}},	//   ssun, vart_, _eton, _ngừa_,
   {{0x7fd61112,0x349503fa,0x8fa61ca4,0x63bb21f0}},	//   лігі, _садр, ламе, psun,
   {{0xa2e5034b,0x672121f1,0xc8d10026,0x00000000}},	//   _болд, _kolj, _हाईट, --,
   {{0x08760070,0x083a0070,0x612600b5,0xdbd102b1}},	//   טערט_, געשל, _rólu, _süße,
   {{0xa2d821f2,0x29dc1a71,0xe4f90edf,0x672104c3}},	//   _मात्, xía_, ्यपि_, _molj,
   {{0x7afc21f3,0x29dc0f56,0x5c160086,0xfc3f0453}},	//   _sart, vía_, льзу, _reír_,
   {{0x3eb800a2,0x2d8021f4,0x6ab500ee,0xbf9b0183}},	// [18e0] part_, rmie_, _bezf, lvên,
   {{0x7afc00da,0x29dc0b4c,0x0eaa00d8,0x2d8000a0}},	//   _qart, tía_, _якой_, smie_,
   {{0x7afc21f5,0x386d21f6,0xbf9b03e6,0x9d4621f7}},	//   _vart, _ayer_, nvên, _бенд,
   {{0x29dc1175,0x7afc21f8,0x386d0c71,0x69de21f9}},	//   ría_, _wart, _byer_, rtpe,
   {{0x7afc21fa,0x6846005f,0x67210888,0x6d460463}},	//   _tart, ында, _bolj, _imka,
   {{0xdb0409ab,0x29dc21fb,0x7afc0a8a,0x67210051}},	//   rsió, pía_, _uart, _colj,
   {{0xf41f0d36,0x672121fc,0xe9a300d8,0x63a221fd}},	//   ään_, _dolj, _гасп, _ston,
   {{0xb4ae21fe,0x60c40aee,0x80d600a1,0x63a201f7}},	//   करे_, _ndim, _भाषे, _pton,
   {{0x14d5164f,0x672121e7,0x68e400ab,0x7454026b}},	//   _धारण, _folj, õidu, جھائ,
   {{0xa3b5009a,0x60c421ff,0x672103ab,0x79822200}},	//   _जबर_, _adim, _golj, lmow,
   {{0xe6930514,0x41552201,0x6d462202,0x065600d8}},	//   _المد, ивос, _omka, _стаў,
   {{0x6ed72203,0x672100f4,0x63a2001c,0x00000000}},	//   _बाहु, _zolj, _tton, --,
   {{0x63a22204,0x5ede0033,0x60c42205,0x81e40033}},	//   _uton, য়নে, _ddim, নিই_,
   {{0x88bd004e,0x2fc008b7,0x6d462206,0x752203d0}},	//   _kośc, _dvig_, _amka, _hooz,
   {{0x2bc72207,0xd2b70070,0x57d11f57,0x2fc01e54}},	//   _लिहा, _גלות_, _सम्ह, _evig_,
   {{0x79820035,0xeb9f0a8a,0x79950371,0x3169068f}},	//   jmow, _drøn_, _ruzw, _ukaz_,
   {{0x7522006d,0x00000000,0x00000000,0x00000000}},	// [18f0] _mooz, --, --, --,
   {{0x2009000d,0x9b440037,0x386d0345,0xf09f0392}},	//   _irai_, منقو, _ryer_, lcà_,
   {{0xdb580086,0xeb9f035b,0x386d2208,0x2bc700b4}},	//   уют_, _grøn_, _syer_, _लिवा,
   {{0xb4ae018d,0x2009028b,0x7522073a,0xf09f0176}},	//   करो_, _krai_, _nooz, ncà_,
   {{0x67210496,0xdcef0067,0x00000000,0x00000000}},	//   _polj, _chcą, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x67212209,0x7bcd0093,0x236502c6,0x386d0b88}},	//   _volj, lrau, volj_, _wyer_,
   {{0x200900d8,0xf8b90722,0xddde00fe,0xa5250210}},	//   _orai_, _उजिय, _cypř, рмид,
   {{0x36d5220a,0xa3b000a1,0xe3b60104,0x6721220b}},	//   _возр, टील_, абы_, _tolj,
   {{0x6ac70083,0x7bcd220c,0xa3e6046c,0x27ed220d}},	//   র্রো, irau, _पहर_, _ipen_,
   {{0x88bd004e,0x7bcd220e,0x637d01cb,0x00000000}},	//   _gośc, hrau, hèng, --,
   {{0x291d1526,0x7bcd220f,0x0086117a,0x20090118}},	//   njwa_, krau, илно, _brai_,
   {{0x236501f2,0xa0760409,0x68e900f8,0x6126008d}},	//   polj_, рынш, _mbed, _sóls,
   {{0x82a503ad,0x56b502b5,0x7982004e,0x6d4600d7}},	//   _такж, יפֿן_, zmow, _smka,
   {{0x63a92210,0xa0a62211,0x69c30bc9,0x99d70033}},	//   lpen, _кайд, šnej, সবুক,
   {{0xf38800e8,0x27ed2212,0xf09f0036,0x2fc00132}},	//   _hợp_, _open_, ccà_, _tvig_,
   {{0xfc030424,0x7bcd2213,0x0b462214,0x4d6301e0}},	// [1900] опто, grau, анан, ікув,
   {{0x63a92215,0x68e92216,0xb4ab0093,0x09e60374}},	//   ipen, _abed, íþjó, иозн,
   {{0xe9da2217,0xa2d82218,0xfce61956,0x27ed0223}},	//   тке_, _मास्, _коно, _apen_,
   {{0x7bcd2219,0x57a61d99,0xa3e600c0,0x88e600c3}},	//   brau, ашка, _पहल_, ржде,
   {{0x7982006a,0x760000b8,0x25a50176,0xdced00a8}},	//   rmow, kázá, _atll_, lmağ,
   {{0x75220298,0x88bd0067,0x68e90381,0x00000000}},	//   _sooz, _pośc, _ebed, --,
   {{0xd5b7037c,0x6d56030d,0x27ed0051,0xdced00a8}},	//   асы_, onya, _epen_, nmağ,
   {{0x6d56221a,0x00000000,0x00000000,0x00000000}},	//   nnya, --, --, --,
   {{0x07a30132,0xe4e2021a,0xa3b004bc,0x63a9221b}},	//   _матн, क्षि_, टीं_, gpen,
   {{0x27390118,0xa91d0207,0x7522030d,0x00000000}},	//   _rèng_, _dižu, _wooz, --,
   {{0x7bcd00ea,0x2d9e0355,0xd25701e0,0x63a901ed}},	//   zrau, ítel_, ицю_, apen,
   {{0x249f0118,0xeb9f008c,0x2bc7221c,0x6126008d}},	//   ccum_, _brøl_, _लिला, _sólr,
   {{0xc05b0185,0xe53b0122,0x612601ef,0xb4c4049c}},	//   тін_, _בתאר, _cólq, ौली_,
   {{0x200902e1,0x637d00e0,0x3ef90043,0xe4e200b8}},	//   _vrai_, gènd, ынгэ_, क्रि_,
   {{0x937b016b,0x00000000,0x00000000,0x00000000}},	//   _שטות, --, --, --,
   {{0x7bcd221d,0x2009221e,0xc0cb0267,0x69c3221f}},	//   trau, _trai_, _руке_, šnek,
   {{0xe4f90b35,0x7bcd2220,0x2d9c00fd,0x00000000}},	// [1910] ्यति_, urau, _éven_, --,
   {{0x7bcd2221,0x6d562222,0xfaa72223,0x00000000}},	//   rrau, anya, ршан, --,
   {{0x81e400c8,0x63a906a2,0xceb20317,0x7bcd2224}},	//   নিক_, zpen, _מיי_, srau,
   {{0x63a92225,0x637d2226,0x2739000d,0x7bcd2227}},	//   ypen, mène, _mène_, prau,
   {{0xcce613cf,0x98e40037,0x9ac700b5,0x6d4d0328}},	//   _اسپي, تكنو, _نگاہ_, miaa,
   {{0x9b450580,0x00000000,0x00000000,0x00000000}},	//   _طنزو, --, --, --,
   {{0x80c200c8,0x7c2d2228,0x80dd0033,0x6d4d0051}},	//   ষ্ট্, lyar, _বসন্, oiaa,
   {{0x68e9042a,0x1e580122,0x63a92229,0xdced0097}},	//   _ubed, ישור_, tpen, klač,
   {{0x7c2d070b,0xe2990009,0x63a9222a,0x249f0471}},	//   nyar, лап_, upen, rcum_,
   {{0xf5e700d4,0x6d4d00be,0x63a9222b,0x85b8026b}},	//   _відм, hiaa, rpen, _چانس_,
   {{0xa2d80ac4,0x7c2d222c,0xdced013b,0x22490c98}},	//   _मार्, hyar, xmağ, упни_,
   {{0x63a9222d,0x645e0035,0x04950037,0xdced00d5}},	//   ppen, _śpie, _الإح, flač,
   {{0x6d4d222e,0x7c2d01d5,0xdced0207,0x00000000}},	//   diaa, jyar, glač, --,
   {{0x442d222f,0xdced00a8,0x31970160,0x00000000}},	//   mye_, tmağ, _lăzi_, --,
   {{0x442d2230,0x443f2231,0x6da60009,0x6d56012f}},	//   lye_, lzu_, сиба, tnya,
   {{0xe0da03fa,0xdced2232,0x443f0065,0x6d561855}},	//   _сви_, rmağ, ozu_, unya,
   {{0x442d2233,0x443f2234,0xec7a2235,0x7c2d0332}},	// [1920] nye_, nzu_, упа_, gyar,
   {{0x8a3a0086,0x442d054b,0x2ca0027b,0xdce400f4}},	//   ляет_, iye_, scid_, klić,
   {{0xb4f90f9f,0xd91000d1,0x442d0031,0xdce40124}},	//   ्याय_, ویس_, hye_, jlić,
   {{0x7c2d1cf5,0x6d4d0120,0x442d2236,0x00000000}},	//   byar, ciaa, kye_, --,
   {{0x2912037a,0x442d0a0d,0x2bba0037,0x443f0156}},	//   ıya_, jye_, _حاجة_, jzu_,
   {{0x2d9a2237,0x7d042238,0x443f0029,0x442d2239}},	//   _kupe_, ldis, dzu_, dye_,
   {{0xe7f40299,0x442d030d,0x2d9a223a,0xa3b000b4}},	//   _इनका_, eye_, _jupe_, टीई_,
   {{0x7d04223b,0x442d0c1f,0x3e83000d,0xa91d00ec}},	//   ndis, fye_, lété_, _dižs,
   {{0x442d223c,0x7d04223d,0x78a20187,0xf36603d0}},	//   gye_, idis, mcov, йтон,
   {{0xdced0496,0x78a20187,0x7d040086,0xd6d20fab}},	//   vlač, lcov, hdis, _رقص_,
   {{0x443f0176,0x442d223e,0x753b223f,0x65690118}},	//   azu_, aye_, bhuz, boeh,
   {{0x78a20076,0x442d19c7,0xd2570560,0xdced2240}},	//   ncov, bye_, сць_, tlač,
   {{0x7d042241,0x50670945,0x443f0035,0x85030088}},	//   ddis, стна, czu_, _روون,
   {{0x7bd6011e,0x6d5a2242,0xdced0009,0xa85700a5}},	//   duyu, étan, rlač, מיכה_,
   {{0x6d4d2243,0xdced00cd,0x8d7701b2,0x2d9a0139}},	//   tiaa, slač, مارا, _cupe_,
   {{0x7d042244,0xdced02c6,0x7c2d03d0,0x78a20334}},	//   gdis, plač, tyar, jcov,
   {{0x6d4d2245,0xac182246,0x78a20334,0x7bd62247}},	// [1930] riaa, боту_, dcov, guyu,
   {{0x6d4d2248,0x7c2d04fb,0x64402249,0x7d0400be}},	//   siaa, ryar, izmi, adis,
   {{0x443f029d,0x7c2d124f,0x637d12c3,0x442d02d0}},	//   zzu_, syar, lènc, zye_,
   {{0x273000e8,0x26de0f56,0x7bd605ca,0xcebc0095}},	//   _hành_, _acto_, buyu, _şəxs_,
   {{0x81e40083,0xb9010a40,0x18690166,0x637d0310}},	//   নিট_, _दा_, јали_, nènc,
   {{0x443f0095,0xe736224a,0x442d224b,0xdce400cd}},	//   vzu_, жеш_, vye_, tlić,
   {{0xf77000bf,0xca24224c,0x78a20bca,0x442d224d}},	//   راه_, _ефти, bcov, wye_,
   {{0x442d0c1f,0x443f06a2,0x27300019,0xb3c91583}},	//   tye_, tzu_, _lành_, ализ_,
   {{0x442d224e,0x753b00fd,0xdce400cd,0x00000000}},	//   uye_, rhuz, slić, --,
   {{0x442d224f,0x637d12c3,0x776a00de,0x78bb02a2}},	//   rye_, dènc, cofx, _heuv,
   {{0x442d2250,0x2d572251,0x5f1d09b4,0xe7842252}},	//   sye_, għek_, मान्_, _хуто,
   {{0x2d9a2253,0x3eba2254,0x442d02e9,0x216a1f9b}},	//   _rupe_, _sept_, pye_, рими_,
   {{0x41c50d00,0x2d9a2255,0x637d0443,0x28de00dc}},	//   _विकस, _supe_, gènc, फ्टि,
   {{0x78bb2256,0x27300023,0x3f81009e,0x00000000}},	//   _leuv, _cành_, _chhu_, --,
   {{0x27300028,0x78bb0248,0x6da3005c,0x272b11cb}},	//   _dành_, _oeuv, диса, _høns_,
   {{0x78bb2257,0x0d99021f,0x69d701ef,0x2fcd02c6}},	//   _neuv, стры_, duxe, šega_,
   {{0x637d12c3,0x78a20237,0x6abe1ad9,0xbcfb0168}},	// [1940] cènc, vcov, tapf, _akés,
   {{0x91ed0bc1,0x2d9a002f,0x7bd6037a,0x63a40079}},	//   _जहाज_, _tupe_, ruyu, _éine,
   {{0x78a20160,0x6abe01d5,0x3e83000d,0x78bb00f6}},	//   tcov, rapf, rété_, _beuv,
   {{0x7d041505,0x1d0a2258,0x3f93022e,0x7bd600d7}},	//   qdis, _теми_, _zixu_, puyu,
   {{0x78a22259,0xaae2012f,0xa81700fd,0x386000a8}},	//   rcov, _पापक, قتور_, çir_,
   {{0x78a2225a,0x00000000,0x00000000,0x00000000}},	//   scov, --, --, --,
   {{0xa3dc0785,0x78a20501,0x59d100ab,0x00000000}},	//   तून_, pcov, _हियर, --,
   {{0x6abc225b,0x7bc4010b,0x80d6164f,0x1c0e1f4c}},	//   _herf, osiu, _भागे, सिपल_,
   {{0x7bc4225c,0x6440042a,0x5454225d,0x6abc008a}},	//   nsiu, uzmi, явит, _kerf,
   {{0x290414cc,0x799c0232,0x27e60140,0x6abc009f}},	//   _hama_, _kurw, mton_, _jerf,
   {{0x2904225e,0x7bc40d6c,0x200006fe,0x2ef803bc}},	//   _kama_, hsiu, _asii_, derf_,
   {{0x09cf00c8,0x2904225f,0x29062260,0x637d0443}},	//   _রহমা, _jama_, ndoa_, tènc,
   {{0x29042261,0x6abc218e,0x00000000,0x00000000}},	//   _mama_, _oerf, --, --,
   {{0x29041201,0x26dc0409,0x637d0955,0x6abc2262}},	//   _lama_, ngvo_, rènc, _nerf,
   {{0x62660088,0x637d12c3,0xdcbb2263,0x31352264}},	//   _باشق, sènc, ища_, _некр,
   {{0x29040e9a,0x5c99086c,0x27e62265,0xa3ae1a75}},	//   _nama_, ская_, kton_, _ओझा_,
   {{0x6abc2266,0x27e62267,0x3fc90df3,0x7bc42268}},	// [1950] _berf, jton_, _ادبی_, gsiu,
   {{0x6abc2269,0x799c0b13,0x60dd049a,0x6e2a0031}},	//   _cerf, _burw, lgsm, ëmbë,
   {{0x78bb02e1,0x6abc226a,0x27e6226b,0x7bc400ab}},	//   _peuv, _derf, eton_, asiu,
   {{0x60dd11cb,0x29041430,0x27e6226c,0x673a0553}},	//   ngsm, _cama_, fton_, _altj,
   {{0x01e00083,0x2d89226d,0x27e60023,0x394f226e}},	//   ববিদ, mmae_, gton_, rigs_,
   {{0x69d701dd,0xb6a51765,0x2d89028b,0x27390107}},	//   puxe, чикл, lmae_, _bèna_,
   {{0x67280c21,0x27e60086,0x6b9d226f,0x7f3c0070}},	//   _dodj, aton_, _husg, שעוו,
   {{0x69c52270,0x6b9d0008,0x27e60430,0x6aa52271}},	//   mshe, _kusg, bton_, lchf,
   {{0x27ff07b5,0x36d500af,0x394d03d0,0x69c700fe}},	//   _usun_, _ноар, _imes_, _hvje,
   {{0x29042272,0x60dd2273,0xaacb00dc,0x6f05008c}},	//   _zama_, egsm, ाणिक, _nahc,
   {{0xe8030d53,0x69c52274,0x29042275,0x200000a2}},	//   लिका_, nshe, _yama_, _ssii_,
   {{0x67232276,0x7bc42277,0x2000022e,0x2ef81e7e}},	//   ljnj, ysiu, _psii_, werf_,
   {{0x88bd0035,0x200f2278,0x69c52279,0x23a0021e}},	//   _rośl, _ágil_, hshe, _gòj_,
   {{0x69c5227a,0x69c7025c,0x395f013c,0x2d9c00b5}},	//   kshe, _ovje, _ljus_, _évek_,
   {{0x6b9d02bf,0x69c5227b,0x6b40227c,0x88bd0067}},	//   _ausg, jshe, _högg, _pośl,
   {{0x6abc17b3,0x2bc7227d,0x7bc4189c,0x6b9d227e}},	//   _serf, _लिखा, tsiu, _busg,
   {{0xd00f00f8,0x2904227f,0x6abc2280,0x27e609b3}},	// [1960] _ملي_, _rama_, _perf, xton_,
   {{0xa3dc009a,0x7bc42281,0x799c2282,0x4a9a00d8}},	//   तंत_, rsiu, _purw, стаў_,
   {{0x6abc02bf,0x7bc42283,0x69c70c21,0x4ae202cb}},	//   _verf, ssiu, _cvje, _पाठव,
   {{0x27e62284,0x69c7012e,0x6abc2285,0x7bc42286}},	//   tton_, _dvje, _werf, psiu,
   {{0x67282287,0x29042288,0x6abc2289,0x69c50b88}},	//   _podj, _vama_, _terf, ashe,
   {{0x395f228a,0x28d80066,0x7d06228b,0x2904228c}},	//   _ejus_, _डाकि, _haks, _wama_,
   {{0x2904228d,0x7d06228e,0x27e6228f,0x56930d54}},	//   _tama_, _kaks, ston_, нашт,
   {{0x27e62290,0x7d062291,0xda5b011d,0x660100ee}},	//   pton_, _jaks, _הכלל, _dslk,
   {{0x69c7029d,0x00000000,0x00000000,0x00000000}},	//   _zvje, --, --, --,
   {{0x883b0122,0x637d02e9,0x00000000,0x00000000}},	//   _התמו, tèna, --, --,
   {{0x7643006a,0x26cc0297,0x6587008d,0x3253002d}},	//   czny, _iddo_, árhæ, евэр,
   {{0xf4872292,0x867b0070,0xfbb20033,0xa2d809b4}},	//   _کامی, _פראו, _চিনত, _माक्,
   {{0x60dd2293,0xfc3f0300,0xcfa70421,0x00000000}},	//   rgsm, _afín_, яшни, --,
   {{0x3da72294,0x7d0608dd,0x69c52295,0x6b9d01da}},	//   зраб, _aaks, yshe, _rusg,
   {{0xdef800d8,0x6303026e,0x6b950055,0x00000000}},	//   чыя_, _سويل, _rizg, --,
   {{0x6b9d0228,0x6b400282,0x00000000,0x00000000}},	//   _pusg, _lögd, --, --,
   {{0x69c72296,0xd11a112b,0xfe700332,0x2d89012f}},	// [1970] _svje, धारण_, ندہ_, rmae_,
   {{0x69c52297,0x23d409b1,0x69c30132,0x7d0603d0}},	//   tshe, _दिनद, âneo, _eaks,
   {{0x7d062298,0x6aa52299,0xf9f90c26,0x394d021d}},	//   _faks, rchf, تفاع_, _pmes_,
   {{0x69c500da,0xac191b3a,0x26cc229a,0x6aa5229b}},	//   rshe, _дому_, _addo_, schf,
   {{0x69c5229c,0x60cd0159,0x6d4f229d,0x394d08b7}},	//   sshe, _mdam, _imca, _vmes_,
   {{0xe29a0019,0x69c5229e,0x00000000,0x00000000}},	//   _ngư_, pshe, --, --,
   {{0x69c70280,0xba77064e,0x60cd229f,0x7d0622a0}},	//   _uvje, _راست, _odam, _yaks,
   {{0x60cd22a1,0xbe3c00a5,0x76430067,0xeb9f008c}},	//   _ndam, מעות, rzny, _drøv_,
   {{0xb4ad1db6,0x387f0fef,0x395d006d,0x67d42079}},	//   _कभी_, _uzur_, mnws_, _поту,
   {{0x60cd22a2,0x644d010b,0xd75b00d1,0xe0df0036}},	//   _adam, _žais, _اجرا_, egò_,
   {{0x61e8011e,0x00000000,0x00000000,0x00000000}},	//   gtdl, --, --, --,
   {{0xa3b022a3,0x00000000,0x00000000,0x00000000}},	//   टीङ_, --, --, --,
   {{0x7d060ae0,0x6b40013c,0x60cd22a4,0x00000000}},	//   _raks, _höge, _ddam, --,
   {{0x7d0622a5,0x6d4f22a6,0xe4e322a7,0x4f9500af}},	//   _saks, _amca, _गाडि_, ерсу,
   {{0x7d0622a8,0x2d9e02e1,0x1b060083,0x2d961fda}},	//   _paks, ête_, রামে_, драс,
   {{0x395d006d,0x6b4019ee,0x00000000,0x00000000}},	//   jnws_, _möge, --, --,
   {{0x7d0603d0,0x5ed30083,0xed5703e6,0x27390260}},	// [1980] _vaks, দ্ধে, фот_, _rènn_,
   {{0x5fd30084,0xf1c10084,0x27390107,0x00000000}},	//   _तितल, _शबान, _sènn_, --,
   {{0x7d060a1e,0x63740310,0xe800017f,0x752b0051}},	//   _taks, mànt, लौना_, _oogz,
   {{0x395d006d,0x63740392,0xa3ae0387,0x7d0603d0}},	//   gnws_, lànt, _ओझल_, _uaks,
   {{0xf74622a9,0x07fa0b8d,0xc7a31c20,0x07a322aa}},	//   медо, تراع_, вичк, вачн,
   {{0xeb9f177c,0xb8650647,0x6b4005aa,0x2fcf1b99}},	//   _prøv_, رانو, _böge, _ægge_,
   {{0x395d01e8,0x8a030272,0x752b22ab,0x00000000}},	//   bnws_, _изре, _bogz, --,
   {{0x49060066,0xa926010b,0x00000000,0x00000000}},	//   _सोचो_, _ўдал, --, --,
   {{0x671e0e1d,0x752b01e9,0x14180079,0x00000000}},	//   पादक_, _dogz, سيدة_, --,
   {{0xf772004f,0x778310ac,0x6b40017b,0x00000000}},	//   _شاء_, _алуз, _högb, --,
   {{0x2fc922ac,0x00000000,0x00000000,0x00000000}},	//   _svag_, --, --, --,
   {{0x92be00c8,0x914b1958,0xae0d00ab,0x00000000}},	//   ইলে_, ічна_, हिसन_, --,
   {{0xb4da046c,0x945d0067,0xf41f0421,0x6b4002b1}},	//   ़ली_, rańc, äät_, _zöge,
   {{0x6b400093,0x5f94027a,0x00000000,0x00000000}},	//   _lögb, кият, --, --,
   {{0xf20602fb,0x00000000,0x00000000,0x00000000}},	//   _цяло, --, --, --,
   {{0x9d1802fb,0x2c0b0099,0x00000000,0x00000000}},	//   мост_, हटलं_, --, --,
   {{0x63ad22ad,0x395d006d,0xfd1f0023,0x37be0033}},	// [1990] _çant, vnws_, _chìa_, _উৎসর,
   {{0xdb0d0093,0x63740176,0x00000000,0x00000000}},	//   gsað, cànt, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xa2d802cb,0x656201d2,0xdce4027d,0x00000000}},	//   _माझ्, _njoh, mliğ, --,
   {{0x7ac70de3,0xdce401d6,0x2ca90207,0x00000000}},	//   _осве, lliğ, mcad_, --,
   {{0x6d9101ba,0x395d006d,0xd7060044,0x8038016b}},	//   _sťah, snws_, енше_, ונדע_,
   {{0x58d5110a,0xdce401d6,0x2d9922ae,0x2ca902d7}},	//   _повт, nliğ, _kise_, ocad_,
   {{0x6b40033b,0xd6180c74,0x00000000,0x00000000}},	//   _vöge, بتها_, --, --,
   {{0x2d9922af,0x443922b0,0x47d5004f,0x6d5a02e1}},	//   _mise_, ás_, _سيار, étai,
   {{0x42251150,0x2d9922b1,0xdce4027d,0x00000000}},	//   едов, _lise_, kliğ, --,
   {{0x4ae2004e,0x78a422b2,0x2d9900f7,0x63a40037}},	//   _पासव, žive, _oise_, _éinn,
   {{0x2d9900f1,0xa06a0200,0x00000000,0x00000000}},	//   _nise_, зама_, --, --,
   {{0x98a400ea,0x1b060033,0xa07500af,0x2c6c06fe}},	//   _jomā_, রাতে_, вырш, _kódů_,
   {{0xa35700bf,0x657b22b3,0x2d9922b4,0xcad50033}},	//   _تخصص, lluh, _aise_, স্তফ,
   {{0x2d9922b5,0x00000000,0x00000000,0x00000000}},	//   _bise_, --, --, --,
   {{0x62830500,0x2d990211,0x00000000,0x00000000}},	//   _izno, _cise_, --, --,
   {{0xe7da00c8,0x2d9922b6,0x60c6128f,0x4f9618d0}},	// [19a0] _ধন্য, _dise_, makm, _проу,
   {{0x2d9903bc,0x657b0fa0,0x2d9e0132,0xdce405f9}},	//   _eise_, hluh, ítes_, bliğ,
   {{0x533600c2,0xdebb0319,0x657b0159,0xe8fa1738}},	//   ענען_, _ממיל, kluh, зле_,
   {{0xe1ff004e,0xeb9a1470,0xdb0d0093,0xfd1f0023}},	//   łów_, _ним_, ssað, _thìa_,
   {{0x6d5622b7,0x6d4422b8,0x3f9a136b,0x4e9600f8}},	//   miya, mhia, _kipu_, _تشکر,
   {{0x6d5622b9,0x6d4422ba,0x62830506,0x2d9900af}},	//   liya, lhia, _ozno, _zise_,
   {{0xceb30052,0x6b6322bb,0x850400b5,0xeb9f008c}},	//   ניה_, _скра, ہوںن, _frøs_,
   {{0x6d5622bc,0x5976010b,0x657b0a2d,0x6d4422bd}},	//   niya, _чыгу, gluh, nhia,
   {{0x75d401cb,0xe3af0148,0xa3e703fa,0x60c622be}},	//   ريکا, یری_, едња_, dakm,
   {{0x6d5622bf,0xfd1f0028,0x68e222c0,0x3f9a0118}},	//   hiya, _nhìn_, lgod, _nipu_,
   {{0x6d440ce8,0xf41f00be,0x00000000,0x00000000}},	//   khia, äär_, --, --,
   {{0x88bd004e,0x68e222c1,0x7afe22c2,0x846602fb}},	//   _dośw, ngod, hept, _пъле,
   {{0x6d5622c3,0x557702b5,0x543322c4,0x6d4422c5}},	//   diya, _װעגן_, _مرور, dhia,
   {{0x69de22c6,0x15f422c7,0x2d9922c8,0x00000000}},	//   kupe, _आहार_, _sise_, --,
   {{0x63a222c9,0x6d5622ca,0x2d991e85,0x69de056c}},	//   _huon, fiya, _pise_, jupe,
   {{0x63a219c6,0x6d5622cb,0x6d4422cc,0xdce401d6}},	//   _kuon, giya, ghia, rliğ,
   {{0x2d9922cd,0x2ca9026e,0x65600719,0x63a200c3}},	// [19b0] _vise_, rcad_, inmh, _juon,
   {{0xaa6710d4,0x63a222ce,0x6d6700ac,0xeb9f03d0}},	//   нтек, _muon, _špač, _brør_,
   {{0x4ae2009a,0xda6707f6,0x6d5622cf,0x63a203ad}},	//   _पारव, رائي, biya, _luon,
   {{0x6d4422d0,0x6d5610e7,0x637d0c1f,0xacbb0248}},	//   chia, ciya, vènm, _coût,
   {{0x63a222d1,0x7d0d0093,0x66e506e4,0xdb1d0523}},	//   _nuon, mdas, вола, _avså,
   {{0x7d0d22d2,0x7bdf0036,0x69de028b,0xf72b00d8}},	//   ldas, muqu, bupe, яцей_,
   {{0x7bdf22d3,0xae1422d4,0xc17900d8,0x657b0159}},	//   luqu, डियन_, ntės_, tluh,
   {{0x63a222d5,0x7d0d22d6,0xacbb00f7,0xc17900c7}},	//   _buon, ndas, _goût, itės_,
   {{0x63a20023,0x78a40124,0x6b4001ff,0x24560a8a}},	//   _cuon, živc, _höga, _rømø_,
   {{0x6d5622d7,0x6d4422d8,0x63a222d9,0x88bd0035}},	//   ziya, zhia, _duon, _pośw,
   {{0x216a22da,0x7d1d053e,0x61460265,0x6d5622db}},	//   дини_, _onss, вена, yiya,
   {{0x26c722dc,0x7afe22dd,0x6d56013b,0x85040647}},	//   lano_, zept, xiya, _مومن,
   {{0xf99200c2,0xa3a800a1,0x7d0d22de,0x6d5622df}},	//   ירט_, _खूप_, ddas, viya,
   {{0x68e222e0,0x26c722e1,0x75290a78,0x6d5600d6}},	//   zgod, nano_, ljez, wiya,
   {{0x6d440297,0x6d5622e2,0x6283042a,0x50b622e3}},	//   thia, tiya, _uzno, _испу,
   {{0x26c70010,0x7d0d067f,0x752922e4,0x63a20159}},	//   hano_, gdas, njez, _yuon,
   {{0x26c722e5,0x644902c9,0x6d44128f,0x7afe0043}},	// [19c0] kano_, nzei, rhia, tept,
   {{0x6d5622e6,0x6d440189,0x60c42129,0x69de22e7}},	//   siya, shia, _heim, tupe,
   {{0xa3a80e1d,0x26c722e8,0x3ed902b5,0x644901ae}},	//   _खून_, dano_, _אַרא, hzei,
   {{0xd7fa0009,0x7afe22e9,0x798922ea,0x6c86004f}},	//   дук_, sept, _chew, _للجم,
   {{0xb90a051d,0x69de22eb,0x26c722ec,0x798901ca}},	//   _मा_, supe, fano_, _dhew,
   {{0x6a86005f,0x60c422ed,0x68e222ee,0xa773010b}},	//   _алга, _leim, sgod, аліч,
   {{0x63a222ef,0x2d9c006c,0x24800029,0x2bda0099}},	//   _suon, _éves_, _šim_, यंका,
   {{0x6b9c0090,0x644901ae,0x00000000,0x00000000}},	//   _hirg, fzei, --, --,
   {{0x26c722f0,0x07a622f1,0x46ea0009,0x6b9c22f2}},	//   bano_, _разн, _одан_, _kirg,
   {{0x394600c9,0x7d0d0332,0x63a20086,0xdced0254}},	//   lhos_, zdas, _vuon, plać,
   {{0x53d400a1,0x6b9c22f3,0x7d0d0644,0x60c41ab9}},	//   _दिवश, _mirg, ydas, _beim,
   {{0x394600c9,0x51870202,0x63a222f4,0xdb0f01f7}},	//   nhos_, ђуна, _tuon, _etcè,
   {{0x14d702b5,0x60c422f5,0x93461053,0xe815046c}},	//   _יואל_, _deim, _инде, ढिया_,
   {{0x53330431,0x6b9c22f6,0x46b400ab,0x00000000}},	//   _вешт, _nirg, ुरिह, --,
   {{0x2fc022f7,0x3946012f,0xa3a8198f,0x8d770aaa}},	//   _ewig_, khos_, _खंड_, نارا,
   {{0x60c422f8,0x7bdf22f9,0xd7d200b4,0xc179010b}},	//   _geim, tuqu, _सिंच, rtės_,
   {{0x7d0d0f1a,0xdd94010b,0x6b9c22fa,0x26c722fb}},	// [19d0] rdas, раты, _birg, yano_,
   {{0x7d0d22fc,0x26c70485,0x7cde002d,0x6b9c0027}},	//   sdas, xano_, tărâ, _cirg,
   {{0x26c722fd,0x6b9c22fe,0x00000000,0x00000000}},	//   vano_, _dirg, --, --,
   {{0x26c71cf1,0x98a40139,0x00000000,0x00000000}},	//   wano_, _romă_, --, --,
   {{0x26c722ff,0x38692300,0x7bdf00a8,0x9bc400d8}},	//   tano_, çar_, ququ, _вёск,
   {{0xa03c0122,0x3869048c,0x00000000,0x00000000}},	//   ועדפ, ħar_, --, --,
   {{0x26c72301,0xa3a81163,0x78a401cc,0x7bcd1789}},	//   rano_, _खूब_, živa, lsau,
   {{0xf3ff2302,0x39462303,0x26c72304,0xb4ad02cb}},	//   ção_, chos_, sano_, कडे_,
   {{0x26c72305,0xf8ae006c,0x9f400093,0x68e90069}},	//   pano_, _رکن_, _opið_, _iced,
   {{0x644902bf,0x60c42306,0x753b01c0,0xe7300c26}},	//   rzei, _seim, skuz, _وصل_,
   {{0x64492307,0x7ae5184f,0x2fc02308,0x290d034d}},	//   szei, ight, _swig_, _kaea_,
   {{0xe4cb00bf,0x26c52309,0x68e90069,0x6d1200b4}},	//   _آبان_, _helo_, _jced, _ढोंग_,
   {{0xb4df02cb,0x25a5230a,0xdb0f1111,0xfd1f0023}},	//   तली_, _hull_, _etcé, _chìm_,
   {{0xe8e000b8,0x25a5048c,0x26c5230b,0x60c4230c}},	//   _पञ्च, _kull_, _jelo_, _weim,
   {{0x60c4230d,0x26c5230e,0x2009230f,0x160922d4}},	//   _teim, _melo_, _esai_, विटर_,
   {{0x2d8b1298,0x61e10328,0x68e90069,0x26c52310}},	//   _chce_, mull, _nced, _lelo_,
   {{0x61e12311,0x7bcd2312,0xac860eee,0x25a50523}},	// [19e0] lull, gsau, угал, _lull_,
   {{0xec772313,0x68e92314,0x5fbb00a5,0xaf062315}},	//   упу_, _aced, _רצינ, _спол,
   {{0x61e12316,0x212000b8,0x25a52317,0xe7c6021a}},	//   null, _knih_, _null_, रीनप,
   {{0x07a600d8,0x53d40026,0x23d400b4,0x68e92318}},	//   гадн, _दिलश, _दिलद, _cced,
   {{0x26c52319,0x6b9c0029,0x7e7e231a,0x2d80231b}},	//   _belo_, _tirg, _hypp, mlie_,
   {{0x61e101d2,0x26c502c6,0xfaa3231c,0x6b9c0211}},	//   kull, _celo_, _гаро, _uirg,
   {{0x21200a78,0x394601a2,0x26c5231d,0x61e1231e}},	//   _onih_, phos_, _delo_, jull,
   {{0x9d2200c8,0xa534231f,0x61e12320,0xd9430036}},	//   _নতুন_, рнич, dull, _леси,
   {{0x786613ad,0x7786185f,0x00000000,0x00000000}},	//   _сказ, _блаз, --, --,
   {{0x25a52321,0x26c52322,0x29260009,0x57fb00a5}},	//   _full_, _gelo_, štač_, _אלמו,
   {{0x61e12323,0x521300af,0xa3e50067,0x613f01e9}},	//   gull, бдэт, बूब_, _fëll,
   {{0x613f01e9,0x26c5108a,0x64a62324,0xa1592325}},	//   _gëll, _zelo_, _сада, таму_,
   {{0xd0e60e6f,0x54360fab,0x26c52326,0xdce600ec}},	//   _कारण_, _حرار, _yelo_, _dikļ,
   {{0xa2942327,0x2d800298,0x26c5002a,0x212008b7}},	//   _калі, elie_, _xelo_, _enih_,
   {{0x61e12328,0x1df8037c,0x00000000,0x00000000}},	//   cull, леры_, --, --,
   {{0x2d802329,0x7bcd232a,0x7e7e0a8a,0x00000000}},	//   glie_, tsau, _dypp, --,
   {{0x200900e7,0x6fd90e11,0x3b55061c,0x2bc0142a}},	// [19f0] _usai_, _भटिं, акар, शीला,
   {{0x7bcd09df,0x3ea1011e,0x290d0159,0x6d5a232b}},	//   rsau, _ught_, _saea_, étar,
   {{0x7bcd232c,0x2d80232d,0x26c5121e,0x9b6815df}},	//   ssau, blie_, _relo_, ушта_,
   {{0x26c5232e,0x98c7004f,0x78a4232f,0xfd1f0036}},	//   _selo_, اغان, živn, _unì_,
   {{0xf77102aa,0x26c5051b,0x25a501d3,0x61e12330}},	//   يات_, _pelo_, _sull_, zull,
   {{0xaae201c0,0x25a52331,0x6eba07df,0x45d51e46}},	//   _पाएक, _pull_, ्रयु, ацит,
   {{0x6b4002bf,0x26c52332,0x7d0f00fd,0x65c20c46}},	//   _mögl, _velo_, _kacs, обща,
   {{0xb4df2333,0x613f00da,0x61e12334,0x25a512c3}},	//   तले_, _qëll, vull, _vull_,
   {{0x26c51be6,0xa3e50fd1,0x613f00da,0x93451f08}},	//   _telo_, बंध_, _vëll, иние,
   {{0x61e12335,0x7d0f0176,0x25a52336,0x63a901f4}},	//   tull, _lacs, _tull_, rqen,
   {{0xe1262337,0x00000000,0x00000000,0x00000000}},	//   амни, --, --, --,
   {{0xa3e50026,0x00000000,0x00000000,0x00000000}},	//   बंद_, --, --, --,
   {{0x22590035,0x31690359,0x8fa60217,0x00000000}},	//   ńsk_, _djaz_, раге, --,
   {{0x61e12338,0x6fd7045c,0x3f9e2339,0xd0070200}},	//   pull, _बिरू, ötu_, јере_,
   {{0x427902b5,0x3f840029,0xed5a00c3,0xef170166}},	//   _באַג, ēmu_, вов_, јмс_,
   {{0x2056233a,0x2120023a,0xdca31f7c,0x00000000}},	//   _втор, _unih_, жати, --,
   {{0x0c260dfc,0xe4f8018d,0x6b400282,0x2ca70009}},	// [1a00] шман, ्जति_, _fögl, ркуп_,
   {{0x973c0124,0x00000000,0x00000000,0x00000000}},	//   _kiće, --, --, --,
   {{0xa3e50fd1,0x60d6028b,0x6edb00a5,0x2d8000a2}},	//   बूत_, _kdym, _בחיפ, plie_,
   {{0xd94603fa,0x387f0118,0xaae20099,0xdb060031}},	//   једи, _byur_, _पाकक, _kukë,
   {{0x7d04233b,0xfaa60373,0x4cbb00a5,0x88bd0035}},	//   meis, _ваго, _בזכו, _pośr,
   {{0xed5901ba,0x5777010b,0x00000000,0x00000000}},	//   ďže_, абіў_, --, --,
   {{0x645d008d,0x1c0e00b4,0x00000000,0x00000000}},	//   úsin, सिकल_, --, --,
   {{0x7d040086,0x2b58233c,0x00000000,0x00000000}},	//   neis, _hmrc_, --, --,
   {{0xf366141d,0x66e60166,0x6aa9233d,0x6b400093}},	//   итон, _воза, _şefi, _lögm,
   {{0x7d04233e,0x79820052,0x973c011c,0x16760274}},	//   heis, llow, _biće, _кћер,
   {{0x7d0415eb,0x6d460421,0x00000000,0x00000000}},	//   keis, _olka, --, --,
   {{0x855600fd,0x92570421,0xdb060055,0x7d040421}},	//   _خیبر_, рают_, _bukë, jeis,
   {{0x320201c0,0x7522233f,0x74160ef2,0x661a0009}},	//   ňky_, _inoz, _خوشا, _hrtk,
   {{0x6d462340,0x7d0f2341,0xc05801e0,0x6b400282}},	//   _alka, _sacs, рію_, _bögm,
   {{0xd37801cc,0x98bf0009,0xcda9183b,0x7d042342}},	//   moć_, _sluč_, اهره_, feis,
   {{0x929b0052,0x7d042343,0x7c872344,0xe29b011d}},	//   _ביות, geis, аузе, _בשור,
   {{0xdfd10c74,0x75221dab,0xfaa720b4,0x69de0051}},	// [1a10] _عيد_, _mnoz, ашен, erpe,
   {{0x6d462345,0x78a41851,0xd3782346,0xd5a4006c}},	//   _elka, živl, noć_, _يہ_,
   {{0x7d0f2347,0x3f830a78,0x7d042348,0x69d800c7}},	//   _tacs, mlju_, beis, šven,
   {{0xae1a00a5,0x3e160070,0xfcab103b,0x79820067}},	//   _עורכ, _פֿיל_, _جادو_, glow,
   {{0x1b0f0083,0xd378022f,0xf8072349,0x00000000}},	//   সাবে_, koć_, рчен, --,
   {{0xd246234a,0x75220027,0xdb230919,0x00000000}},	//   _فن_, _anoz, _بوسی, --,
   {{0x7982234b,0x69de0009,0xeb0322c7,0x6eba012f}},	//   blow, crpe, रजीत_, ्रतु,
   {{0xf8ab046c,0x7bdf0176,0x637d0118,0x00000000}},	//   _छलिय, orqu, hènt, --,
   {{0x973c01f2,0x142200d8,0x2eb70f17,0x52e2046c}},	//   _siće, здым, _अभूत, पलूस,
   {{0x7d04234c,0x973c00cd,0x27ff01cb,0xddde00fe}},	//   zeis, _piće, _ipun_, _expř,
   {{0xc4cf00b5,0x7d0408c7,0xdb0603d0,0x00000000}},	//   _ہےں_, yeis, _utkå, --,
   {{0x973c02c4,0x00000000,0x00000000,0x00000000}},	//   _viće, --, --, --,
   {{0x4429234d,0x0574004f,0x7d04234e,0xdb060107}},	//   _ça_, _بالد, veis, _fukè,
   {{0x63bb0b0e,0x7d0402c9,0x023916a4,0x1fa700af}},	//   mpun, weis, _مثبت_, скри_,
   {{0x7d04234f,0x68fb2350,0x6ade0083,0xeb9f0185}},	//   teis, _obud, ন্ডো, _esøk_,
   {{0xed570036,0x90c62351,0x2b58022f,0x27ff0139}},	//   бос_, _убие, _smrc_, _opun_,
   {{0x63bb2352,0x3f830a78,0x6d4600d5,0x6d5800c7}},	// [1a20] npun, blju_, _vlka, _įvad,
   {{0x69de2353,0x7d041246,0x68fb2354,0x798200fe}},	//   trpe, seis, _abud, wlow,
   {{0x27ff012f,0x7d042355,0xe9da0267,0x993a1958}},	//   _apun_, peis, уке_, ляду_,
   {{0x68fb009e,0x00000000,0x00000000,0x00000000}},	//   _cbud, --, --, --,
   {{0xe73a0ca6,0xacf700b5,0x18670274,0x6fcb0e61}},	//   лед_, _اسپت, баци_, तीपू,
   {{0x63bb017b,0x78250079,0x798207df,0x00000000}},	//   dpun, تعمل, slow, --,
   {{0xa96a2356,0xceb30319,0x8f9b100a,0x63bb0051}},	//   _бива_, ליג_, ניצי, epun,
   {{0x63bb2357,0x661a00d5,0x73d80d46,0x00000000}},	//   fpun, _vrtk, адир_, --,
   {{0x63bb2358,0x628a00ee,0x00000000,0x00000000}},	//   gpun, _szfo, --, --,
   {{0xaaba114e,0xdb04043f,0x27e602b3,0x68fb2359}},	//   ेरिक, mpió, muon_, _zbud,
   {{0x3f830a78,0x63bb01a3,0x4b7b0070,0x2e18021e}},	//   vlju_, apun, רטיג, _nčf_,
   {{0x73e601c8,0x1a9b0070,0xfbd9046c,0x71470421}},	//   _годз, טייע, _ढिलम, схож,
   {{0x7afc0528,0x27e602b3,0x3f8300f4,0x04960079}},	//   _obrt, nuon_, tlju_, _الشح,
   {{0x2e18021e,0xc9050066,0x00000000,0x00000000}},	//   _bčf_, _रस्म_, --, --,
   {{0x20000107,0x29060065,0x00000000,0x00000000}},	//   _epii_, keoa_, --, --,
   {{0x52830082,0x78a40c0a,0x27e60008,0x3f83219c}},	//   _عليك, živj, kuon_, slju_,
   {{0xfd4f01a5,0x26ce0103,0x290606a2,0x2000012f}},	// [1a30] _khiế, kafo_, deoa_, _gpii_,
   {{0x27e60a2d,0x321c00ee,0x00000000,0x00000000}},	//   duon_, _krvy_, --, --,
   {{0x27ff0043,0xc98710da,0x00000000,0x00000000}},	//   _spun_, буди, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6aa900af,0x6d4d07b6,0xdd980043,0x6d5f0510}},	//   _şefu, mhaa, _ышь_, miqa,
   {{0xfd4f0019,0x6d4d12ba,0x70b50325,0xdced0124}},	//   _nhiế, lhaa, ंडुल, mlađ,
   {{0xc5d501e0,0x7f3c016b,0x00000000,0x00000000}},	//   ціль, רעוו, --, --,
   {{0x63bb235a,0x68fb235b,0x6d4d235c,0x261a007c}},	//   tpun, _ubud, nhaa, _मछरी_,
   {{0x69da06d7,0x3834235d,0x86eb042c,0x63bb00c3}},	//   _åter, _ентр, _معاف_, upun,
   {{0xfd4f00e8,0x6d4d235e,0x63bb235f,0x95cb2360}},	//   _chiế, hhaa, rpun, _буда_,
   {{0x63bb2361,0x6d4d2362,0x6f0700b8,0xdced00cd}},	//   spun, khaa, dejc, hlađ,
   {{0x63bb2363,0x27e01851,0xdced011c,0xd24e00f8}},	//   ppun, šine_, klađ, خچه_,
   {{0x6d4d2364,0x23290a9f,0x297a016b,0x00000000}},	//   dhaa, _воли_, שטרא, --,
   {{0x6da62365,0x65692366,0x63ab0159,0xe2991566}},	//   жива, lneh, _iugn, _кал_,
   {{0x63ab2367,0xa3e50299,0x41760df3,0x8d5a2368}},	//   _hugn, बूर_, _وابس, ашат_,
   {{0x63a32369,0x6569236a,0x6d43002d,0x6d4d236b}},	//   _hinn, nneh, _înal, ghaa,
   {{0x63a3236c,0x443f236d,0x442d0391,0xfd1f0019}},	// [1a40] _kinn, nyu_, nxe_, _nhìu_,
   {{0x261a0992,0x63a3236e,0x63ab236f,0x62830e7d}},	//   _मछली_, _jinn, _mugn, _kyno,
   {{0xdce40292,0xdca60011,0x2d8c2370,0x63ab013c}},	//   lnič, _мани, ïdes_, _lugn,
   {{0x63a32371,0x6d4d0a75,0x443f2372,0x98a60dc8}},	//   _linn, chaa, kyu_, циде,
   {{0xd70a00af,0x186a0328,0x63ab08dd,0xd90d042c}},	//   инде_, шади_, _nugn, دیق_,
   {{0xd04e0095,0x501b02b8,0x6d442373,0x17542374}},	//   ükəs, יונו, lkia, явля,
   {{0xdce40888,0x26ce1d2b,0x56930d6e,0xd9462375}},	//   hnič, rafo_, машт, _деви,
   {{0x6d4400d8,0x7d162376,0x63a3184f,0xdb040300}},	//   nkia, ndys, _ainn, mpiñ,
   {{0x63a3201e,0xfd4f01a5,0xdce40254,0x63ad0098}},	//   _binn, _phiế, jnič, _éanl,
   {{0x63a304d6,0xdce4011c,0x63ab2377,0x2be2046c}},	//   _cinn, dnič, _dugn, _पिना,
   {{0x442d0391,0x6283001e,0x6d4400c3,0x63a32378}},	//   axe_, _cyno, kkia, _dinn,
   {{0x63a300fb,0x628300e9,0x656905ed,0x443f2379}},	//   _einn, _dyno, cneh, byu_,
   {{0x63a3237a,0xfd4f00e8,0x63ab027a,0x7d16237b}},	//   _finn, _thiế, _gugn, ddys,
   {{0xdced0c99,0x26cc1704,0x93770037,0x6560237c}},	//   vlađ, _jedo_, _وصور_, limh,
   {{0x26cc237d,0x6d5f0095,0x6d4d237e,0x6f07237f}},	//   _medo_, tiqa, thaa, rejc,
   {{0x63a32380,0xdce42381,0x91b70609,0x25ac0009}},	//   _zinn, bnič, _بطور_, _mudl_,
   {{0x6d4d2382,0x6d5f2383,0x6f071cb0,0x61e82384}},	// [1a50] rhaa, riqa, pejc, ludl,
   {{0x6d4d2385,0x26cc0009,0xce9501d3,0xbcfb2386}},	//   shaa, _nedo_, _напъ, _omég,
   {{0x60cd0452,0x2fc908dd,0x61e802b3,0x657b011e}},	//   _keam, _hwag_, nudl, youh,
   {{0x443f2387,0x6d442388,0x889500af,0xa3ad021a}},	//   yyu_, ckia, пиех, कदम_,
   {{0x88070a86,0x6d5d2389,0x2be2238a,0x657b238b}},	//   تظام, _imsa, _पिया, vouh,
   {{0x60cd04e6,0x61e80159,0x26cc238c,0x63ab0051}},	//   _leam, kudl, _cedo_, _rugn,
   {{0x26cc21a4,0xdce406e2,0x63a3238d,0x63ab238e}},	//   _dedo_, znič, _rinn, _sugn,
   {{0x60cd238f,0x63ab2390,0x442d2391,0x61e82392}},	//   _neam, _pugn, txe_, dudl,
   {{0x65692393,0xb4bb1033,0xb4ab0084,0x442d0279}},	//   rneh, _अभी_, _खली_, uxe_,
   {{0x442d0391,0x6d4406a2,0xaacb0d00,0x6d932394}},	//   rxe_, zkia, िरिक, lçad,
   {{0x63a32395,0x6d442396,0x443f2397,0x60cd06c6}},	//   _vinn, ykia, syu_, _beam,
   {{0x6d932398,0xdce401cc,0x216a2399,0x60cd0037}},	//   nçad, tnič, сими_, _ceam,
   {{0x60cd239a,0xe81e0174,0x2ba70066,0x823500d1}},	//   _deam, पिया_, _कंगा, زرگا,
   {{0x61e8239b,0x28db057c,0x6b40017b,0x63a300f1}},	//   budl, मृति, _högv, _uinn,
   {{0xdce41635,0x6146239c,0x60cd19fd,0x00000000}},	//   snič, _нека, _feam, --,
   {{0x60cd239d,0x78a40496,0xf8a503fc,0xdce4040b}},	//   _geam, živi, _لک_, pnič,
   {{0x6d44239e,0x7d161b84,0x2fc900e9,0xb05b038e}},	// [1a60] rkia, rdys, _gwag_, lbän,
   {{0x78a90382,0x6d441da8,0x6d5d1008,0x8eea00d4}},	//   _agev, skia, _emsa, _умов_,
   {{0x7ae3239f,0x64400e18,0x1d0a1309,0x00000000}},	//   ónta, zymi, _лени_, --,
   {{0xdb040138,0x26cc23a0,0x00000000,0x00000000}},	//   rpiñ, _sedo_, --, --,
   {{0x2d8223a1,0x26cc12d5,0x0c2300d8,0xdb0401ef}},	//   _ikke_, _pedo_, _змян, spiñ,
   {{0x6d930132,0x78a9008c,0x25ac23a2,0xa3e5060a}},	//   açad, _egev, _pudl_, बंई_,
   {{0x78ad0496,0x26cc23a3,0x945d0035,0x644001a7}},	//   žava, _vedo_, kańs, wymi,
   {{0xfaa323a4,0x644023a5,0xe5a30274,0x6d9300a2}},	//   _часо, tymi, нији, rçag,
   {{0x60cd23a6,0x7bd6011e,0x26cc023a,0x00000000}},	//   _ream, nsyu, _tedo_, --,
   {{0x60cd23a7,0x6560009f,0x61e802b3,0x394623a8}},	//   _seam, simh, tudl, lkos_,
   {{0x60cd007c,0x7bd6046a,0x62870484,0x6728003c}},	//   _peam, hsyu, żjon, _indj,
   {{0xf8cc0f9c,0x394600d8,0x61e823a9,0x673a055c}},	//   ारिय, nkos_, rudl, _hotj,
   {{0x60cd23aa,0x61e823ab,0x394623ac,0xb97b00a5}},	//   _veam, sudl, ikos_, מנטי,
   {{0x973c0009,0x2d820103,0x6d5d23ad,0x673a23ae}},	//   _mićo, _akke_, _smsa, _jotj,
   {{0xf8cc175f,0xfe700037,0x394623af,0x00000000}},	//   ाराय, هدف_, kkos_, --,
   {{0x6b40008a,0x2d580f78,0x2fc9010d,0x673a12ba}},	//   _mögu, пись_, _twag_, _lotj,
   {{0x6728025c,0x6b40008a,0x212923b0,0xb0c30380}},	// [1a70] _ondj, _lögu, _inah_, _व्यग,
   {{0x2aab03fa,0x2d8223b1,0xe1ab00ab,0x6b52008c}},	//   стао_, _ekke_, _घूँघ, _lægf,
   {{0x7f3c0122,0x62860035,0x442b0023,0x39460051}},	//   _לעזו, ękow, ̣c_, fkos_,
   {{0xbcfb0831,0x672823b2,0x6d5d23b3,0x2bb50026}},	//   _ejér, _andj, _umsa, _अंपा,
   {{0x24860221,0x6d9323b4,0x673a23b5,0xe73923b6}},	//   _nyom_, rçad, _botj, жел_,
   {{0x2be206bc,0x66e500af,0x00000000,0x00000000}},	//   _पिता, фока, --, --,
   {{0xf8ae0332,0x673a0124,0x25a6024b,0xe1ab0066}},	//   اکہ_, _dotj, _biol_, _घूंघ,
   {{0x27e023b7,0xe3b923b8,0x6b40008a,0xb9250372}},	//   šina_, оби_, _dögu, _تفري,
   {{0x395f23b9,0x25a623ba,0x0ebf021a,0x394d23bb}},	//   _imus_, _diol_, ्राड, _iles_,
   {{0x673a0009,0xf8680af8,0x00000000,0x00000000}},	//   _gotj, _عملي_, --, --,
   {{0x77900e3a,0x66f2111a,0x25a623bc,0x6f0c013b}},	//   _حیوا, _घातक_, _fiol_, _öncə,
   {{0x2ec60b54,0x69d803e6,0x764323bd,0x6b40013c}},	//   वर्त, ávei, myny, _högt,
   {{0x764323be,0x657c00fd,0x00000000,0x00000000}},	//   lyny, _írha, --, --,
   {{0x394d23bf,0x62650dbf,0x7763002a,0x25a601f7}},	//   _lles_, _овла, ninx, _ziol_,
   {{0x8fa323c0,0x764323c1,0xdef900d8,0x945d0067}},	//   таре, nyny, чыў_, pańs,
   {{0xa18702fb,0x00000000,0x00000000,0x00000000}},	//   _обща_, --, --, --,
   {{0x248601e8,0x6f170168,0x00000000,0x00000000}},	// [1a80] _xyom_, _faxc, --, --,
   {{0x394d0043,0x7bd606b3,0x76430328,0x5f06010b}},	//   _ales_, rsyu, kyny, _ўзна,
   {{0xa3cd009a,0x6b52054e,0x673a0051,0x394d23c2}},	//   षीत_, _lægg, _rotj, _bles_,
   {{0x78ad0888,0x394600d8,0x673a0176,0x394d00a2}},	//   žavn, ukos_, _sotj, _cles_,
   {{0x394623c3,0x673a23c4,0x6b40008a,0x25a60176}},	//   rkos_, _potj, _sögu, _riol_,
   {{0x394d0bb0,0xd5ba23c5,0x394623c6,0x25a623c7}},	//   _eles_, оси_, skos_, _siol_,
   {{0x764323c8,0x394d0130,0xfbb00033,0x09d80033}},	//   gyny, _fles_, _ছবিত, _সহকা,
   {{0xb4e80a5e,0x2d800036,0x394d0523,0x00000000}},	//   बले_, noie_, _gles_, --,
   {{0xd90d064e,0x25a623c9,0xdc1100a8,0x00000000}},	//   _دین_, _viol_, _məğl, --,
   {{0x25f605e7,0x628f0035,0x76430090,0x28cc0b35}},	//   _एमपी_, ęcon, byny, ारवि,
   {{0x6b40022a,0xe5a60009,0x25a6002a,0xbf9b0345}},	//   _högs, _жижи, _tiol_, kwêr,
   {{0x2d8023ca,0x2d470183,0x0566083e,0x00000000}},	//   joie_, _põem_, _ювен, --,
   {{0x6d430043,0x59ce00a1,0x104b01e0,0xdcfd007a}},	//   _înai, हीतर, іями_, _nisġ,
   {{0x2bb51e79,0x00000000,0x00000000,0x00000000}},	//   _अंबा, --, --, --,
   {{0x27e623cb,0x3da700d8,0x6f1700e0,0xbf9b0b88}},	//   hron_, драб, _vaxc, fwêr,
   {{0x212900d7,0x98a40260,0x6b52008c,0xbf9b0345}},	//   _unah_, _anmč_, _lægd, gwêr,
   {{0x27e623cc,0x21f80118,0x1eab0037,0x7c2900f4}},	// [1a90] jron_, léh_, _وادي_, _šerb,
   {{0x6ec002cb,0xa3e60534,0x7f5918cd,0x25ef046c}},	//   वडणु, _बटन_, _хаос_, _इमली_,
   {{0x27e60033,0x27e0004f,0x394d068f,0x1a65006c}},	//   eron_, áinn_, _ples_, ریری_,
   {{0x26de02b3,0xab5b0225,0x7e9a00a5,0x0e9a00a5}},	//   _adto_, _stüd, _מסתו, _משתל,
   {{0x7d0d23cd,0x6d4f027a,0xf2100066,0x78ad00cd}},	//   meas, _ilca, ़बड़_, žavo,
   {{0xf77307f6,0x7d0d23ce,0x76430086,0xae0317f1}},	//   خاص_, leas, tyny, _लहान_,
   {{0x27e623cf,0x776301dd,0x6d4f028b,0xb9050033}},	//   aron_, rinx, _klca, _বউ_,
   {{0x764300e5,0x7d0d23d0,0x00000000,0x00000000}},	//   ryny, neas, --, --,
   {{0x76430421,0x998500b5,0xf8b20317,0xa775010b}},	//   syny, _élő_, _תשמ_, _злач,
   {{0x7d0d23d1,0x7c200c21,0x6b40022a,0x6b5208c8}},	//   heas, _šmrk, _högr, _vægg,
   {{0xe1f60043,0x7d0d0086,0x26c7008b,0x6d4f23d2}},	//   нгэ_, keas, mbno_, _olca,
   {{0x361a0122,0x2611022f,0x7d0d0139,0xdb070055}},	//   _מועד, _išo_, jeas, _bijë,
   {{0x2d8023d3,0xdb061d8a,0x7d0d0727,0xd24e04cd}},	//   voie_, _luká, deas, لنی_,
   {{0x6d4f23d4,0x6b40008a,0x21f80118,0xa85600a5}},	//   _alca, _lögr, béh_, גישה_,
   {{0x2365022a,0x7d0d23d5,0x2d960c4c,0x6b52082b}},	//   milj_, feas, ерас, _jæge,
   {{0x27e623d6,0x1de10253,0xf11a0cd1,0x00000000}},	//   yron_, _फिरत, _رغبت_, --,
   {{0xec770012,0x6b52054e,0xed5723d7,0x00000000}},	// [1aa0] епт_, _læge, хот_, --,
   {{0x78ad23d8,0x261123d9,0x06e50033,0x00000000}},	//   žavl, _ošo_, প্তি, --,
   {{0x7d0d23da,0xeef700a5,0x2d73011c,0xdb070118}},	//   beas, _אמיר_, mćen_, _mijè,
   {{0x27e623db,0x6d4f009e,0xb4de018d,0x6eba04e9}},	//   tron_, _glca, _तये_, ्रकु,
   {{0x27e623dc,0x58831667,0xb865026b,0x2bd80594}},	//   uron_, лыша, پانو, _تاجک_,
   {{0xf09300c2,0x7bc423dd,0x27e623de,0x27e023df}},	//   אנד_, mpiu, rron_, šino_,
   {{0x3872002d,0x06cf0033,0xe1e70ca8,0x00000000}},	//   _ţară_, _রাশি, _حس_, --,
   {{0x260100c4,0x27e623e0,0x69dc23e1,0x85ba00b5}},	//   _शहरी_, pron_, _ivre, _ہاؤس_,
   {{0xb6030029,0x888100bf,0xd7ca0079,0x00000000}},	//   āšan, _پیون, _رواه_, --,
   {{0x26de011e,0x7982073a,0x41e6093e,0xb7d70037}},	//   _udto_, loow, німа, _أولا_,
   {{0xdb0723e2,0x2fc00090,0xf6290079,0x00000000}},	//   _dijè, _atig_, _يسمى_, --,
   {{0x613f00da,0x2902013c,0x21f80118,0xeb0d23e3}},	//   _pëlq, _ökad_, réh_, _हस्त_,
   {{0xe53b00a5,0x656223e4,0x7d0d00af,0x2bb50253}},	//   _מתאר, _imoh, veas, _अंधा,
   {{0x4ea71294,0xdb070055,0x69dc23e5,0x6b52008c}},	//   ерба, _vijë, _ovre, _lægb,
   {{0x7d0d23e6,0x3ea523e7,0xdcfd009f,0x00000000}},	//   teas, ält_, _jisħ, --,
   {{0x2bb50b7a,0xdb060187,0x3ceb0066,0x6ab90761}},	//   _अंदा, _ruká, टलें_, इड्र,
   {{0x69dc18fd,0xe7cf0035,0x7d0d23e8,0x00000000}},	// [1ab0] _avre, _सौंप, reas, --,
   {{0x7d0d23e9,0x29040051,0x64c40355,0x00000000}},	//   seas, _abma_, lčič, --,
   {{0x7d0d23ea,0xf8cc05f7,0x2ebf022e,0xdcfd00ea}},	//   peas, ारूप, ्रीत, _eksā,
   {{0x628a13da,0x64c423eb,0x3f8323ec,0x213923ed}},	//   _myfo, nčič, loju_, njsh_,
   {{0xb9090084,0x69dc23ee,0x399e0355,0xdb0f0183}},	//   _मय_, _evre, _růst_, _lucé,
   {{0x6562011e,0x3f8323ef,0x290400ee,0x34c923f0}},	//   _amoh, noju_, _ebma_, रर्द,
   {{0xda051163,0xf7700180,0xc8f50133,0x23650009}},	//   _रहित_, حان_, _извъ, vilj_,
   {{0x2ebf035d,0xab64045e,0xdb0f0118,0x6b400523}},	//   ्रुत, rmüş, _sucè, _högp,
   {{0x290f23f1,0x69c5009e,0x3f8323f2,0x236500f4}},	//   mega_, lphe, koju_, tilj_,
   {{0x290f23f3,0x656200e0,0x628a23f4,0x6b52008c}},	//   lega_, _emoh, _byfo, _tæge,
   {{0x2fc023f5,0x628a001e,0x63aa17a4,0xe5150043}},	//   _stig_, _cyfo, _difn, _афлэ,
   {{0x291d23f6,0x290f108a,0x2be2073f,0x628a001e}},	//   ndwa_, nega_, _पिला, _dyfo,
   {{0x61e823f7,0xc8da00a5,0x30760279,0x00000000}},	//   ardl, וקרט, тунс, --,
   {{0xdf1502ce,0x3f8300c5,0x2d990176,0x290f23f8}},	//   льсь, goju_, _ahse_, hega_,
   {{0x5ed40b52,0x290f108a,0x628a00e9,0x200901b7}},	//   _তাদে, kega_, _gyfo, _epai_,
   {{0x290f23f9,0x973c0207,0x7c2900f4,0x00000000}},	//   jega_, _pićk, _šera, --,
   {{0xc4d200c2,0x290f0006,0x6da30de2,0x291d09d6}},	// [1ac0] יגן_, dega_, рита, ddwa_,
   {{0x7bc400c7,0x00000000,0x00000000,0x00000000}},	//   rpiu, --, --, --,
   {{0xab5b01ae,0xe8fa01c8,0xbea60166,0xa9a602fb}},	//   _stüc, дле_, _јанк, вижд,
   {{0x290f23fa,0x81bc00ea,0xd7e60746,0x00000000}},	//   gega_, lvēc, віко, --,
   {{0xa41c00c8,0x79820103,0xe7b323fb,0x00000000}},	//   _তথ্য_, roow, لمند, --,
   {{0x6d9323fc,0xbcfb000c,0x69d8024e,0x69c501e8}},	//   nçan, _jmén, áves, bphe,
   {{0x6f030723,0x69c500f1,0x69dc0254,0x290f23fd}},	//   _önce, cphe, _uvre, bega_,
   {{0x1514002d,0xd9430dbf,0x973c0c99,0x38c804e8}},	//   удия, _кеси, _mići, _ساری_,
   {{0x98a323fe,0xdb0f002a,0xd9430f08,0xa96710da}},	//   _вите, _sucé, _тети, _рита_,
   {{0x5fdc0b4a,0x2bb50084,0xdc9b016b,0x00000000}},	//   _बिजल, _अंसा, ויפל, --,
   {{0x6d5600d7,0x3f831f45,0x973c01f2,0xe73723ff}},	//   khya, voju_, _nići, _шеф_,
   {{0xbcfb0248,0x27e918b0,0x044a0390,0x995e00fe}},	//   _amén, šane_, _опек_, _lůž_,
   {{0x6d562400,0x50642401,0x3f83025f,0xc0ab2402}},	//   dhya, атра, toju_, بادل_,
   {{0x442602b3,0x973c00cb,0x643b0070,0x2ebf0355}},	//   _iro_, _bići, _קעגנ, ्रेत,
   {{0x3f832403,0x00000000,0x00000000,0x00000000}},	//   roju_, --, --, --,
   {{0x44262404,0xf8cc157d,0xf1a41a0e,0x2caf0185}},	//   _kro_, ारोप, _крын, øgd_,
   {{0x290f2405,0x27e02406,0x442600e0,0xdb0f0160}},	// [1ad0] vega_, šinj_, _jro_, _ducî,
   {{0x69c52407,0x44260090,0x3b542408,0xdca40274}},	//   tphe, _mro_, акур, рађи,
   {{0x290f2409,0x7c26033b,0x7d060031,0x2bdf074f}},	//   tega_, _erkr, _fbks, _फटका,
   {{0x4426240a,0x00000000,0x00000000,0x00000000}},	//   _oro_, --, --, --,
   {{0x290f240b,0x4426240c,0x5fdc0066,0x69c511be}},	//   rega_, _nro_, _बिछल, sphe,
   {{0x6d4d240d,0x290f0ccf,0x778400ef,0xdced00cd}},	//   lkaa, sega_, аліз, inač,
   {{0x4426240e,0x644601e0,0x290f240f,0x7f3c0070}},	//   _aro_, økin, pega_, ועגו,
   {{0x6d4d2410,0xdb0d1166,0x44262411,0x7d1d035f}},	//   nkaa, mpañ, _bro_, _jass,
   {{0x38600037,0xaaa71371,0x00000000,0x00000000}},	//   úirt_, _कृतक, --, --,
   {{0x7d1d2412,0x44262413,0xdced0254,0x2ebf00db}},	//   _lass, _dro_, dnač, ्रोत,
   {{0x6d4d2414,0x44262415,0xfb1602b5,0x799b00d7}},	//   kkaa, _ero_, אַכט_, _khuw,
   {{0x442600e9,0xdce40009,0x00000000,0x00000000}},	//   _fro_, mnić, --, --,
   {{0x09e00302,0xd9e01e79,0x6d4d2416,0x44262417}},	//   _पट्य, _पट्ट, dkaa, _gro_,
   {{0x06e50083,0x65692418,0xd6e50033,0x3cf90345}},	//   প্রি, lieh, প্রয, _acsv_,
   {{0xfce62419,0x6d56009e,0x6d4d0d35,0x6d93241a}},	//   лово, thya, fkaa, rçan,
   {{0x7d1d241b,0x6d4d241c,0xbacd0083,0xe6d00d2a}},	//   _cass, gkaa, _লাগছ, _सज्ज,
   {{0x5f7606ca,0x645b241d,0x7d1d241e,0x0c2600d8}},	// [1ae0] _مادر, nzui, _dass, ыман,
   {{0x6d560232,0xe8cc021a,0x79890103,0x656902b1}},	//   shya, ार्च, _akew, hieh,
   {{0x6d4d241f,0x7d1d2420,0x799b022e,0x60d62421}},	//   bkaa, _fass, _bhuw, _keym,
   {{0x39400093,0x6d93092a,0x7d1d2422,0xdce40207}},	//   ðis_, nçal, _gass, dnić,
   {{0x6f1e00f5,0x799b00bf,0x65691736,0x7d040210}},	//   _kapc, _dhuw, dieh, mfis,
   {{0x7791064e,0x7c240010,0x7d1d1388,0x6f1e2423}},	//   قیقا, mvir, _zass, _japc,
   {{0xdced0097,0x44262424,0x6f1e2425,0x7d0408c7}},	//   znač, _sro_, _mapc, ofis,
   {{0x442609a3,0x69de2426,0x60d62427,0x7d1d2428}},	//   _pro_, mspe, _neym, _xass,
   {{0x7c242429,0x69de242a,0x136a07c1,0x385602fb}},	//   nvir, lspe, ешни_, _съвс,
   {{0xa3e51033,0x44260589,0xbcfb0248,0xe3bf0391}},	//   _फिर_, _vro_, _amél, íña_,
   {{0xe13503ad,0x92940b30,0x656901ba,0xa29412ea}},	//   анны, ранц, bieh, рані,
   {{0x4426242b,0xd25701c8,0x69de004f,0x51870370}},	//   _tro_, уць_, ispe, ѓуна,
   {{0x4426242c,0x644600ab,0x60d6242d,0x00000000}},	//   _uro_, äkid, _deym, --,
   {{0x2b8f02c9,0x7d1d242e,0x7c24242f,0x7c290009}},	//   rück_, _sass, dvir, _šero,
   {{0x7d042430,0xd9040332,0x6d4d2431,0x69de2432}},	//   ffis, _ٹی_, tkaa, jspe,
   {{0x62980bc6,0x69de071b,0x7d1d007a,0x7d042433}},	//   _izvo, dspe, _qass, gfis,
   {{0x81b600c8,0x7d1d2434,0x69de2435,0xd7e0018d}},	// [1af0] _ছবি_, _vass, espe, _निगच,
   {{0x7d1d2436,0x656902c9,0x6d4d2248,0xda7b00d8}},	//   _wass, zieh, skaa, няе_,
   {{0x7d1d2437,0xda150279,0x6d932438,0x6d4d2439}},	//   _tass, рдењ, lçam, pkaa,
   {{0x7c2401ef,0x973c02c4,0xe0e70033,0xa3e504bc}},	//   bvir, _miću, গ্রহ_, _फिल_,
   {{0x6d932398,0xdb0d1f51,0x69de243a,0x6569081b}},	//   nçam, spañ, aspe, vieh,
   {{0xb8ec074f,0x6d5801c8,0x69de243b,0x99d70d82}},	//   _श्_, _įvai, bspe, _مترا,
   {{0xb8db00c8,0xf8c90248,0x6569243c,0x00000000}},	//   _আজ_, _créé_, tieh, --,
   {{0x79a40370,0x7545174b,0x7bdf0a4f,0xdce4012e}},	//   _груе, рниз, osqu, rnić,
   {{0x65691be0,0xdb0f0300,0x7bdf02b1,0xdce40506}},	//   rieh, _lucí, nsqu, snić,
   {{0x7bdf0279,0x6569243d,0x60d6243e,0xe787243f}},	//   isqu, sieh, _seym, _субо,
   {{0x291f00ab,0x461508cf,0x7d042440,0x6dbc0009}},	//   _kaua_, _خوار, yfis, _ačan,
   {{0x6f1e2441,0xc4f80037,0x7c242442,0xdb0f0139}},	//   _sapc, _معها_, yvir, _jucâ,
   {{0xb4c304aa,0x291f0054,0x6d93037a,0x6f1e2443}},	//   ्री_, _maua_, rçal, _papc,
   {{0x2d8b000c,0x69de2444,0x291f2445,0x644600c3}},	//   _akce_, yspe, _laua_, äkie,
   {{0x7d042446,0x7bdf01ef,0x69de0282,0xbea62447}},	//   tfis, esqu, xspe, равк,
   {{0x27e01367,0x7c2401c8,0xccc614d0,0x291f0176}},	//   šini_, tvir, рбай, _naua_,
   {{0xdee62448,0x7d04008a,0xab662449,0x69de0973}},	// [1b00] _копи, rfis, авал, wspe,
   {{0x69de244a,0x68fb244b,0xd00f0e3a,0x7d040f0a}},	//   tspe, _acud, _کلی_, sfis,
   {{0xbd8a03c7,0x399c004f,0x291f0159,0x7d040d51}},	//   _لندن_, híse_, _baua_, pfis,
   {{0x06cf0033,0x6d43002d,0x68fb009e,0xc7c60432}},	//   _রাগি, _înap, _ccud, аски,
   {{0x27e0184f,0x77940df3,0xdb0d008d,0xdb0f0139}},	//   éin_, میرا, ppað, _ducâ,
   {{0xd70712a2,0x69de244c,0x00000000,0x00000000}},	//   инче_, pspe, --, --,
   {{0xdb0e01f4,0xcb670043,0x06d80033,0x09e3244d}},	//   _libë, _таре_, _সাদি, _морн,
   {{0x27e90ae0,0x399c0037,0xa5341b5d,0x291f01a3}},	//   šana_, físe_, снич, _gaua_,
   {{0xd4970043,0x973c00cd,0x362400fd,0x00000000}},	//   ирь_, _siću, _گواہ, --,
   {{0x316b004e,0x7338081b,0x39440176,0xb354244e}},	//   wicz_, узор_, _homs_, скош,
   {{0xe81e00df,0x44e80033,0x291f002f,0x394403bc}},	//   पिका_, ক্ষক_, _yaua_, _koms_,
   {{0x2b060162,0x7bc60a78,0x26dc244f,0x8c48037a}},	//   स्तु_, _otku, lavo_, _kağı,
   {{0xb4d22450,0x64a60274,0x1b1d0083,0x7afc00cd}},	//   वरी_, _тада, নাতে_, _ocrt,
   {{0x20050484,0x26dc2451,0xdb0e0055,0x27f92452}},	//   ċli_, navo_, _dibë, _åsne_,
   {{0x139b02b8,0x539b0122,0xc179010b,0x629800cd}},	//   _שבוע, _שיוו, urės_, _uzvo,
   {{0x39442453,0x26dc2454,0x3a2d07e7,0xaaa700b8}},	//   _noms_, havo_, _čep_, _कृषक,
   {{0x60dd010d,0x26dc2455,0x291f018d,0x31690b3f}},	// [1b10] masm, kavo_, _raua_, _imaz_,
   {{0x7bdf02e1,0x60dd2456,0x68fb2457,0x26dc2458}},	//   rsqu, lasm, _scud, javo_,
   {{0x26dc00d8,0x6f150300,0x79a70c98,0x7bc6005f}},	//   davo_, mezc, арде, _etku,
   {{0x8c4806d0,0x39442459,0xdb0e02e9,0x6f15245a}},	//   _bağı, _coms_, _libè, lezc,
   {{0xdc35012b,0x3944245b,0x27ff00a2,0xec35016b}},	//   _האָט_, _doms_, _qqun_, _האָר_,
   {{0x8c480092,0x26dc010b,0xf3fe0083,0x6f15245c}},	//   _dağı, gavo_, ্টার_, nezc,
   {{0x291f009e,0xb4d2009a,0xcf58011d,0xb3450183}},	//   _taua_, वरू_, שבות_, _loçã,
   {{0xb4c31bb5,0x7415004f,0xe3bf01dd,0x5e7800a5}},	//   ्रे_, موعا, íño_, יתון_,
   {{0x69c7029d,0x21200feb,0x26dc245d,0xb3450279}},	//   _htje, _raih_, bavo_, _noçã,
   {{0x26dc245e,0xda0e0fbf,0x437401e0,0x00000000}},	//   cavo_, _सहमत_, жуют, --,
   {{0xe695004f,0x6f150831,0xdb0e0118,0x00000000}},	//   _الاد, dezc, _dibè, --,
   {{0xf6520bed,0x6721245f,0x8c480644,0x92d70033}},	//   _מצב_, _halj, _yağı, িলে_,
   {{0x6721023f,0x98790070,0xc88200a8,0x297a016b}},	//   _kalj, ראָט, _peşə_, רטרא,
   {{0x20022460,0x69c7025c,0x398e003e,0x00000000}},	//   rtki_, _otje, lýst_, --,
   {{0x67212461,0xed5a2462,0x200207ba,0x6b6f010b}},	//   _malj, гов_, stki_, _mėgė,
   {{0x26dc2463,0x5d6700af,0xc21200a5,0x50b6021d}},	//   zavo_, бисм_, _זהה_, _уску,
   {{0x39442464,0xdca30210,0x629e00d5,0x69c72465}},	// [1b20] _roms_, зати, _úpor, _atje,
   {{0x67212466,0x39440903,0xef1a03fa,0xb05b013c}},	//   _nalj, _soms_, _смо_, rbät,
   {{0x26dc2467,0x3f8a2468,0x26010138,0x31690345}},	//   vavo_, mobu_, jóo_, _ymaz_,
   {{0xb4c30a64,0xd9100a86,0x3f8a00d5,0x69c30037}},	//   ्रो_, بیر_, lobu_, ínea,
   {{0x7d16048f,0xdb0e2469,0x2be20f8a,0x69c715a8}},	//   meys, _libé, _पिटा, _etje,
   {{0x7d16246a,0xa09b0c37,0x3f8a246b,0x06d80083}},	//   leys, ניסט, nobu_, _সাহি,
   {{0x26dc246c,0x6d46246d,0x67210121,0x3944246e}},	//   ravo_, _koka, _dalj, _toms_,
   {{0x7d16246f,0x6d462470,0x92d70083,0x26dc2471}},	//   neys, _joka, িলো_, savo_,
   {{0x6d462472,0x672101f4,0x3f8a2473,0x26dc0207}},	//   _moka, _falj, kobu_, pavo_,
   {{0x69c102e1,0x7d16081b,0x8c1b0122,0x60c42474}},	//   _élec, heys, נויי, _afim,
   {{0x60dd06a2,0x3f8a0187,0x6d462475,0x60c907a6}},	//   tasm, dobu_, _ooka, ñemo,
   {{0x67210496,0x27e00a78,0x6d462476,0xdb0e00e0}},	//   _zalj, šinu_, _noka, _dibé,
   {{0xc0581645,0x60dd2477,0xd4672399,0x7d160225}},	//   бір_, rasm, _лице_, deys,
   {{0x2bdb2478,0xc0580402,0x31690345,0x60dd2479}},	//   मीफा, сію_, _wmaz_, sasm,
   {{0x6d46247a,0x6f150033,0x2bdb020d,0xdb0e0118}},	//   _boka, rezc, मीना, _gibé,
   {{0x22ae0669,0x2b9400a6,0x00000000,0x00000000}},	//   mək_, bäck_, --, --,
   {{0x69c7247b,0x6d460888,0x6d931010,0xc17400a5}},	// [1b30] _stje, _doka, nçai, _מחק_,
   {{0x75221e77,0x2d55008c,0x8aa70279,0xdb07007e}},	//   _laoz, _gåen_, бред, _bijá,
   {{0x6721247c,0x2b580160,0xdb0f00fe,0xde4700e0}},	//   _ralj, _dlrc_, _cucá, _ایزو_,
   {{0x67212181,0x6dbc0254,0x7522016f,0xb4d20355}},	//   _salj, _očaj, _naoz, वरो_,
   {{0x6721247d,0x387f0024,0x00000000,0x00000000}},	//   _palj, _qxur_, --, --,
   {{0x7bcd247e,0x27e903ab,0x2fc9011e,0xdb0702d7}},	//   mpau, šano_, _mtag_, _fijá,
   {{0x672105e2,0x69c7029d,0x67230254,0x6d4601a8}},	//   _valj, _utje, rdnj, _yoka,
   {{0x22ae0095,0x672100e0,0xdb0e0e8c,0xd7c90079}},	//   dək_, _walj, _ribé, _نوره_,
   {{0xe3b6247f,0x7bcd2480,0x27e0004f,0x6721035f}},	//   обы_, npau, áint_, _talj,
   {{0x98ad01ba,0x798b2481,0x00000000,0x00000000}},	//   _hneď_, logw, --, --,
   {{0xe2991e46,0x44270e3a,0x7d160a21,0xd064013b}},	//   ран_, _گراف, yeys, ərəs,
   {{0xb81e0066,0xe435103b,0x00000000,0x00000000}},	//   _मैडम_, _وفاد, --, --,
   {{0x6d462482,0x2bb52483,0x656b2484,0x7bcd006d}},	//   _roka, _अंगा, _imgh, jpau,
   {{0x6d462485,0xbf9b0370,0x752202c4,0x83fd006c}},	//   _soka, stên, _zaoz, rződ,
   {{0x614617d0,0x22ae0669,0x3f8a01c6,0x7d160086}},	//   _мека, cək_, robu_, teys,
   {{0x68e900f8,0x2b9402b1,0x3f8a088a,0xdb0700ee}},	//   _nded, päck_, sobu_, _rijá,
   {{0x7d162486,0x0b460009,0xfc031fff,0x7bcd2487}},	// [1b40] reys, онан, мпто, gpau,
   {{0x290d0139,0x68e9141c,0x6d460067,0x4c6700af}},	//   _abea_, _aded, _woka, циун_,
   {{0x32050052,0x6d462488,0xc8ca2489,0x1d0a0336}},	//   ntly_, _toka, لوان_, _кени_,
   {{0xc27a0070,0x25ef0099,0x798b04fb,0x6d46248a}},	//   ברעי, ींनी_, gogw, _uoka,
   {{0x68e9248b,0x3ce0006d,0x6dbc01ba,0x881600d1}},	//   _dded, maiv_, _očak, تباط,
   {{0x05ea248c,0xe3a70180,0x00000000,0x00000000}},	//   афии_, _زر_, --, --,
   {{0xd6d90a55,0xd5b703ad,0xda0e09f9,0x00000000}},	//   сті_, осы_, _सहित_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x8d5b0070,0x1b1d0033,0x00000000,0x00000000}},	//   יכקי, নারে_, --, --,
   {{0x46a600d8,0x3ce001e8,0xc7b900b5,0xd764103b}},	//   _дазв, haiv_, _erős_, _عنای,
   {{0x2b9401ae,0x20120260,0x84ea1c73,0x00000000}},	//   räch_, _apyi_, _نفاق_, --,
   {{0x81bc0ae0,0x22ae01c2,0x6d930176,0x00000000}},	//   lvēk, rək_, lçav, --,
   {{0x3205024b,0x22ae013b,0x00000000,0x00000000}},	//   atly_, sək_, --, --,
   {{0xdefb00d8,0x6d93248d,0x7c3b01f7,0x389b016b}},	//   шым_, nçav, _àuri, ייכנ,
   {{0xd250004f,0x3205248e,0x20120107,0x6d5800c7}},	//   _سنة_, ctly_, _epyi_, _įvar,
   {{0x8d77006c,0x395d006d,0x6ecb111a,0x5cb9010b}},	//   زازا, xhws_, _त्रु, слаў_,
   {{0x4c940086,0x0cab248f,0x00000000,0x00000000}},	// [1b50] дитс, ртви_, --, --,
   {{0x69c3002a,0x88d70033,0xdc3102d4,0x399c008d}},	//   íneo, _হাইক, _aļģe, vísa_,
   {{0x7bcd00d8,0x39152490,0x0a680ef3,0x00000000}},	//   spau, змер, орци_, --,
   {{0x28f82491,0x7bcd2492,0xc8790160,0x628e0067}},	//   жець_, ppau, _leşe_, żbow,
   {{0xdd3a00a5,0x25fd00b4,0xe81e2493,0x798b2494}},	//   _הערכ, रूनी_, _मैदा_, rogw,
   {{0x9a872495,0x70b70761,0xc8791008,0x00000000}},	//   _дубл, ःशुल, _neşe_, --,
   {{0xd90f0332,0x80dc0083,0xb9010033,0x64460303}},	//   _لیا_, _ভাস্, _দা_, äkin,
   {{0xea000023,0xab5b02b1,0x6d93021d,0x00000000}},	//   _hiếp_, _stüh, açav, --,
   {{0x657e0248,0xea000023,0xf3f10037,0xb7d50833}},	//   épha, _kiếp_, رأة_, _رقاب,
   {{0xdce40225,0x00000000,0x00000000,0x00000000}},	//   kniğ, --, --, --,
   {{0x6b5203d0,0x00000000,0x00000000,0x00000000}},	//   _dægh, --, --, --,
   {{0x69d00084,0x9f4200b8,0x3205024b,0x00000000}},	//   डीटी, mské_, rtly_, --,
   {{0x9f42033a,0x32052496,0x23290227,0x659a1804}},	//   lské_, stly_, _голи_, _פינק,
   {{0x7d0f0168,0x442f03d0,0x80cc0067,0x6dbc023a}},	//   _abcs, _irg_, _थ्रे, _učak,
   {{0x9f4205d3,0x6da62497,0xd24e06ca,0x2bb50461}},	//   nské_, зива, _منو_, _अंजा,
   {{0xf8b90019,0x657b2498,0xc692025a,0x2bf0021a}},	//   _ngũ_, nnuh, גאל_, _चिदं_,
   {{0x27e9008b,0x442f0051,0xaaba2499,0x52de0033}},	// [1b60] šanj_, _jrg_, مدار_, _মাতৃ,
   {{0x8b2601c8,0xed160035,0x442f009e,0x8b231ac5}},	//   ядзе, _łódź_, _mrg_, ндуе,
   {{0x9f420187,0x442f061c,0x7c2f01ed,0x69da0037}},	//   jské_, _lrg_, _ercr, صباح_,
   {{0xa6d80083,0x9f420314,0xf99212de,0xf9830009}},	//   _সাইট, dské_, ربا_, нгхо,
   {{0x98a600af,0x28cb0084,0x7c290009,0x18180e3a}},	//   чиде, ाड़ि, _šerv, تراک_,
   {{0xbb4a0082,0x7bcb249a,0xf8af00fd,0x00000000}},	//   _الآن_, ígue, اکِ_, --,
   {{0x442f249b,0xfaa60009,0x6b52008d,0xdb0f021d}},	//   _arg_, _хаво, _nægi, _sucç,
   {{0x6d441b0f,0xceb302b8,0xd90d0609,0x6d56073a}},	//   njia, עיה_, _نیم_, nkya,
   {{0x9f59022a,0xdb0e00fe,0x00000000,0x00000000}},	//   ltså_, _libí, --, --,
   {{0x442f249c,0x68e2249d,0xdb1d0279,0x3254249e}},	//   _drg_, laod, _ausê, двор,
   {{0x442f0261,0x6d560103,0x27e6249f,0x98bf0024}},	//   _erg_, kkya, lson_, _qmuħ_,
   {{0x463b02b5,0x442f01ef,0x26de0dc3,0x55bb00a5}},	//   _לעבע, _frg_, _heto_, _המאו,
   {{0x27e624a0,0x26de01d2,0x24aa0083,0xdb050079}},	//   nson_, _keto_, _গ্রহ, smhé,
   {{0x27e602e1,0xd37000bf,0xbf9b000d,0xdb0e021d}},	//   ison_, _جهت_, ptêm, _libâ,
   {{0x80dc0083,0x2cb924a1,0x26de24a2,0x00000000}},	//   _ভার্, _pgsd_, _meto_, --,
   {{0x26de24a3,0x5d9901c8,0x61fa24a4,0x00000000}},	//   _leto_, ікаў_, mutl, --,
   {{0x27e602c4,0x68e224a5,0x61fa24a6,0x7bc0000d}},	// [1b70] json_, daod, lutl, _émul,
   {{0x26de24a7,0x8aa705c2,0x6d5624a8,0xbcfb00f6}},	//   _neto_, пред, akya, _amét,
   {{0x98bf002d,0x61fa24a9,0x00000000,0x00000000}},	//   _nouă_, nutl, --, --,
   {{0x9f42024e,0x1a680148,0x0dba006c,0x27e60282}},	//   vské_, سیقی_, _گئیں_, fson_,
   {{0xea0000e8,0x26de24aa,0x443f003c,0xbcfb1c02}},	//   _tiếp_, _beto_, xxu_, _alég,
   {{0x9f420076,0x26de24ab,0x7c2d24ac,0xe736010c}},	//   tské_, _ceto_, mvar, деш_,
   {{0x442f24ad,0x68e2012f,0xa3df0b54,0xe7080413}},	//   _srg_, baod, धीन_, ستون_,
   {{0x98bf0043,0x9f4205d3,0x443f06a2,0x53c90267}},	//   _două_, rské_, txu_, огим_,
   {{0xb4bd02cb,0x7c2d24ae,0xbcfb00b5,0x657b24af}},	//   _आली_, nvar, _elég, rnuh,
   {{0x04ff0083,0x9f4200b8,0xdb1d01ff,0xdced00ac}},	//   ্যের_, pské_, _utsä, diač,
   {{0x6d5d037a,0x61fa011e,0x7c2d24b0,0x7d0d0345}},	//   _olsa, gutl, hvar, kfas,
   {{0x442f24b1,0x6560184f,0xdb06002a,0x7dfe0160}},	//   _trg_, chmh, _yukó, _lăsî,
   {{0x7d0d008c,0xdb0e0168,0x00000000,0x00000000}},	//   dfas, _sibí, --, --,
   {{0xdfcf0082,0x7c2d1f9d,0x6d5d24b2,0x61fa24b3}},	//   شيف_, dvar, _alsa, butl,
   {{0x490e0066,0x7d0d24b4,0x7c2d00c7,0x78bb001c}},	//   ण्डो_, ffas, evar, _oguv,
   {{0x752924b5,0x78bb0657,0x6da324b6,0xf8a503fc}},	//   ndez, _nguv, виса, _مک_,
   {{0xdced24b7,0x7c2d2426,0x442d24b8,0x7b4a00af}},	// [1b80] znać, gvar, nve_, опаг_,
   {{0x442d24b9,0x6d5d24ba,0xbcfb01ef,0x995c0187}},	//   ive_, _elsa, _aléd, díš_,
   {{0xb4bd0992,0x26de0181,0x442d24bb,0x7c2d24bc}},	//   _आलू_, _reto_, hve_, avar,
   {{0x442d01cc,0x98a0008b,0x6f1c1008,0x75290051}},	//   kve_, žič_, lerc, jdez,
   {{0xa3f800c8,0x442d00da,0x8b660105,0x75290036}},	//   _অন্য_, jve_, _قاسم, ddez,
   {{0x27e6060e,0x442d24bd,0x28ce00b4,0x644600ab}},	//   rson_, dve_, _ह्रि, äkim,
   {{0xe1e700f5,0x442d24be,0x27e624bf,0x656011d9}},	//   _جس_, eve_, sson_, thmh,
   {{0xfaa324c0,0x6f1c00ac,0xbcfb0118,0x03c624c1}},	//   _расо, herc, _gléd, мсом,
   {{0x26de24c2,0xea000019,0x6f1c24c3,0x442d24c4}},	//   _teto_, _khắp_, kerc, gve_,
   {{0x6d9324c5,0x332701ef,0x68e024c6,0x61fa24c7}},	//   nçar, _canx_, _hemd, tutl,
   {{0x442d02fb,0x7d0d01d6,0x7c2d013a,0xf74324c8}},	//   ave_, yfas, zvar, _шефо,
   {{0x394624c9,0x9f4001f7,0x7c2d24ca,0x2fc003bc}},	//   njos_, _avià_, yvar, _buig_,
   {{0x386603e0,0x442d0160,0x6f1c0090,0x394624cb}},	//   nzor_, cve_, ferc, ijos_,
   {{0x6f1c24cc,0x61fa24cd,0x67280051,0x7c2d24ce}},	//   gerc, putl, _jadj, vvar,
   {{0x672824cf,0x7d0d0024,0x62660987,0x6e941218}},	//   _madj, tfas, _تاشق, виру,
   {{0x672824d0,0x27e90121,0x7aee0069,0x2fc001f7}},	//   _ladj, šani_, _adbt, _fuig_,
   {{0x7d0d02c9,0xdd941023,0x25a60719,0xe81e07b5}},	// [1b90] rfas, таты, _mhol_, _मैला_,
   {{0x6f1c24d1,0x672824d2,0x7d0d24d3,0x386624d4}},	//   cerc, _nadj, sfas, dzor_,
   {{0x442d24d5,0x7c2d24d6,0x2bdf0026,0xfe350070}},	//   zve_, svar, _पौरा, _װאָך_,
   {{0xb4bd02cb,0xdb1d24d7,0x8aa424d8,0x673a24d9}},	//   _आले_, _musé, труд, _antj,
   {{0xdd910332,0xe73924da,0x27e924db,0x672824dc}},	//   _لوگ_, зел_, éan_, _badj,
   {{0x25a6006c,0x9f59000d,0x442d24dd,0x21290118}},	//   _ahol_, fusé_, vve_, _laah_,
   {{0xf7700ca8,0xe61100d1,0x69dc001e,0x995c0187}},	//   جان_, اشت_, _gwre, síš_,
   {{0x6f1c114d,0x442d24de,0x942518ff,0x693424df}},	//   zerc, tve_, емие, _инсу,
   {{0x442d24e0,0x291d24e1,0x7529006c,0x96ca02e4}},	//   uve_, mewa_, rdez, _स्कॉ,
   {{0x291d0657,0x1b1d00c8,0xb6c9006c,0x672824e2}},	//   lewa_, নাকে_, _رائے_, _gadj,
   {{0x442d24e3,0x63b824e4,0x6f1c24e5,0x394d24e6}},	//   sve_, _divn, verc, _koes_,
   {{0x04c824e7,0x2fc00443,0x291d24e8,0x6f05009e}},	//   _قومي_, _puig_, newa_, _achc,
   {{0x25ad24e9,0x394d0626,0xdbd71c55,0x6f1c24ea}},	//   mmel_, _moes_, _jäät, terc,
   {{0x7ae524eb,0x63b824ec,0x291d04be,0x2bb20107}},	//   jaht, _givn, hewa_, _gņch_,
   {{0x291d24ed,0x41c607df,0xf1c601c0,0x6b520b3e}},	//   kewa_, _रूपस, _रूपन, _mægt,
   {{0xa0a6004b,0x6f1c1ab8,0x2fc003be,0xb4bd0099}},	//   _пайд, serc, _tuig_, _आलो_,
   {{0x6f1c06b3,0xac8624ee,0x291d24ef,0xd00f026e}},	// [1ba0] perc, хгал, dewa_, _هلي_,
   {{0xe6250028,0x395f24f0,0x31720097,0xbcfb0183}},	//   _đông_, _alus_, _hmyz_, _cléb,
   {{0x672824f1,0xfce624f2,0x68e00703,0x4ae10035}},	//   _radj, _поно, _pemd, _फ़रव,
   {{0x8c461056,0x02b60070,0x672824f3,0xab5b033b}},	//   _земе, גלעך_, _sadj, _stüt,
   {{0x394d24f4,0x3105012f,0x7ae524f5,0x2d8024f6}},	//   _does_, ष्टः_, baht, mnie_,
   {{0x2d80006a,0x395f0a47,0x69dc24f7,0x96f824f8}},	//   lnie_, _elus_, _twre, фект_,
   {{0xfaa324f9,0x56930b3b,0x395f003c,0x25a6009e}},	//   _баро, лашт, _flus_, _phol_,
   {{0x291d0ce8,0xa534117a,0x394d24fa,0x248601ef}},	//   cewa_, тнич, _goes_, _pxom_,
   {{0x63b80187,0x672823ca,0x6b520a8a,0x2bb20107}},	//   _pivn, _tadj, _fægt, _pņch_,
   {{0x2d8024fb,0x7c3b09ca,0x2d9204fb,0x3f8500f4}},	//   hnie_, _áure, hoye_, čluk_,
   {{0x7d0606d7,0x3f9100b8,0x63b801e8,0x2d9224fc}},	//   _ocks, vozu_, _vivn, koye_,
   {{0xea0000e8,0x25d900bf,0x2d80004e,0x24860189}},	//   _nhập_, _آهنگ_, jnie_, _txom_,
   {{0x2d80006a,0xe5a322a9,0x00000000,0x00000000}},	//   dnie_, _сици, --, --,
   {{0x442624fd,0x2d80004e,0x291d24fe,0x316024ff}},	//   _iso_, enie_, zewa_, _eliz_,
   {{0xbe882500,0x59b02501,0x3f912502,0x3da72503}},	//   есте_, जगार, rozu_, ераб,
   {{0x2d802504,0x44262505,0x2d922506,0xea0000e2}},	//   gnie_, _kso_, goye_, _chập_,
   {{0x44260009,0x7ae51b43,0xab640225,0xbcfb2507}},	// [1bb0] _jso_, taht, klüğ, _pléb,
   {{0x44260024,0x6d5a01d2,0x2d800035,0xae21007c}},	//   _mso_, ëtar, anie_, मबदन_,
   {{0x395f20ac,0xf771064e,0x2d920232,0x2d800035}},	//   _plus_, یات_, boye_, bnie_,
   {{0x44260291,0xdbd703ad,0x2d800035,0xd8790c9e}},	//   _oso_, _päät, cnie_, ومات_,
   {{0x291d2508,0xbcfb0f56,0x7ae503ad,0x44262509}},	//   rewa_, _eléc, paht, _nso_,
   {{0x394d250a,0x6dbc02c4,0x6d4f027d,0xbcfb000d}},	//   _woes_, _ičar, _hoca, _fléc,
   {{0x4426250b,0x291d000e,0x6d4f250c,0x6b5201b4}},	//   _aso_, pewa_, _koca, _vægt,
   {{0x4426250d,0x1da708a9,0x6d4f250e,0x7415250f}},	//   _bso_, _कीमत, _joca, نوعا,
   {{0x42d500d8,0xc9840d46,0xc3250033,0xe4c811c0}},	//   кіну, _сури, বাসি_, ربين_,
   {{0x6b520093,0x2d802510,0x60cd2511,0x316000d5}},	//   _hægr, znie_, _afam, _sliz_,
   {{0x4426182c,0x96ca1e79,0x36d40086,0x2d802512}},	//   _eso_, _स्टॉ, _сохр, ynie_,
   {{0x27e90080,0x6d4f2513,0x2902013c,0x6aba2514}},	//   šanu_, _noca, _ökat_, _útfe,
   {{0xd24e0a86,0x4426023a,0x25fd0067,0x2d920fce}},	//   منی_, _gso_, रूरी_, voye_,
   {{0x63640176,0x6b520093,0x3ebe01e0,0x2d80107d}},	//   _cònd, _lægr, øtt_, wnie_,
   {{0x6d4f00bf,0x2d80006a,0xfce62515,0xdee300c3}},	//   _boca, tnie_, ково, роси,
   {{0xc5f202b5,0xab64027d,0x16022516,0x2b14166b}},	//   ידל_, zlüğ, रंतर_, न्नु_,
   {{0x2d802517,0x00000000,0x00000000,0x00000000}},	// [1bc0] rnie_, --, --, --,
   {{0x998d2518,0x2d800035,0xab5b033b,0x6b632519}},	//   _češ_, snie_, _stür, акуа,
   {{0x6d4f0082,0xeb970202,0xea000019,0x27ed251a}},	//   _foca, њих_, _thập_, _aven_,
   {{0x6d4f251b,0x3236016b,0x00000000,0x00000000}},	//   _goca, כטען_, --, --,
   {{0xf74602e3,0x7c2603fd,0x6e930594,0x00000000}},	//   кедо, _uskr, _ملیا, --,
   {{0x7bd6251c,0x7d04251d,0x6d4f02d7,0x7c24251e}},	//   mpyu, lgis, _zoca, mwir,
   {{0x27ed0052,0xab6401d6,0x16020035,0x7c24251f}},	//   _even_, rlüğ, रंधर_, lwir,
   {{0x6d4f2520,0x00000000,0x00000000,0x00000000}},	//   _xoca, --, --, --,
   {{0x7c24033b,0x7bd6011e,0x872600af,0xd3a61b79}},	//   nwir, npyu, _имаж, кроп,
   {{0x4426008b,0x80dc0033,0x60cd0036,0x00000000}},	//   _vso_, _ভাগ্, _sfam, --,
   {{0x2b1404bc,0xd5af2521,0x81bc00ea,0xa26602fb}},	//   न्यु_, _вс_, evēr, тъпл,
   {{0x442601a9,0x7c240010,0x925700c3,0xd5e90037}},	//   _tso_, kwir, тают_, _أعلن_,
   {{0x6d4f2522,0x250b006c,0xf1c300ee,0x00000000}},	//   _roca, _آرمی_, _peší_, --,
   {{0x7c240069,0x656201ba,0x64a30200,0xc7b4016b}},	//   dwir, _hloh, _тача, רבֿ_,
   {{0xd3782523,0x798200a5,0x44240611,0xbcfb00f7}},	//   mić_, know, lwm_, _aléa,
   {{0xd3782524,0x7982004e,0x7d042525,0x9f59024e}},	//   lić_, jnow, ggis, musí_,
   {{0x6c542526,0x7c24018c,0x6562022f,0xd01102e7}},	// [1bd0] акту, gwir, _mloh, _الخ_,
   {{0xd3782527,0x7d042528,0xf0e30067,0x31792529}},	//   nić_, agis, _ख़ुद_, lisz_,
   {{0xdb050082,0x27ed252a,0x44240189,0xf8de022e}},	//   gmhá, _sven_, hwm_, मरूप,
   {{0x7c240232,0x50e3252b,0xd37800cd,0x9f421dab}},	//   bwir, परिष, hić_, mská_,
   {{0xd3780a78,0x9f42053d,0xbcfb0037,0x4424006d}},	//   kić_, lská_, _gléa, jwm_,
   {{0x66e20009,0xd3780a78,0x4908252c,0x628a252d}},	//   боша, jić_, _हाथो_, _oxfo,
   {{0x9f420076,0xd37801cc,0x2d55054e,0x65620298}},	//   nská_, dić_, _fået_, _bloh,
   {{0xdb1d0076,0x2d5501b4,0x442401e8,0x81bd00ea}},	//   _musí, _gået_, fwm_, zvēr,
   {{0xd378252e,0x3f83012e,0x6562252f,0xe70500f8}},	//   fić_, knju_, _dloh, _مسای,
   {{0x2902013c,0xd3780254,0x65622530,0x399c0093}},	//   _ökar_, gić_, _eloh, vísi_,
   {{0x3f8301cc,0x9f420334,0x6562033b,0x752b01a3}},	//   dnju_, jská_, _floh, _tagz,
   {{0x9f420187,0xf5300037,0xd4350d93,0x741200d1}},	//   dská_, _وإن_, _معتب, جویا,
   {{0xd3782531,0xa3df0567,0x4424001e,0x7d04045e}},	//   bić_, धीश_, cwm_, vgis,
   {{0xd378004e,0x2d992532,0x3f830207,0x00000000}},	//   cić_, _akse_, gnju_, --,
   {{0x31790035,0x79820035,0x81bd00ea,0xdb150355}},	//   bisz_, ynow, rvēr, _cizí,
   {{0x7c242533,0xbcfb0079,0xdb1d0097,0x6ed40f17}},	//   twir, _pléa, _dusí, _ब्रु,
   {{0x6da300af,0x09cc02cb,0x9db9005f,0x3f83012e}},	// [1be0] сита, ाऱ्य, тыру_, bnju_,
   {{0xfbcd00c8,0x7c242534,0x2122012f,0x2d990107}},	//   _লিখত, rwir, lekh_, _ekse_,
   {{0xe8fa2535,0x798207df,0x20022536,0x7c242537}},	//   еле_, tnow, luki_, swir,
   {{0xd3782531,0x786a00b5,0x88e600c3,0xa9670f7a}},	//   zić_, _növé, ужде, лиха_,
   {{0x2002011e,0xe3c801a5,0x4424006d,0x79822538}},	//   nuki_, _mực_, xwm_, rnow,
   {{0xe3c80028,0xdb1c00da,0xfee20033,0x79820035}},	//   _lực_, _mirë, _বাঁধ, snow,
   {{0x6b632539,0xd3780537,0xd6d901e0,0xb90a00c8}},	//   _укра, vić_, тті_, _মা_,
   {{0x7bc6253a,0x1db402cb,0xd378004e,0xbf9b0b88}},	//   _kuku, ंगित, wić_, ntêr,
   {{0xd3780a78,0xe6440463,0x7bc60054,0xa3df00a1}},	//   tić_, ılığ, _juku, धील_,
   {{0x2002253b,0x7bc619c7,0x4424001e,0x06b90033}},	//   duki_, _muku, rwm_, ঁড়ি,
   {{0xd3780a78,0x7bc6253c,0x3624006c,0x3f83025c}},	//   rić_, _luku, _خواہ, vnju_,
   {{0x2b140299,0xd3782527,0x9f420076,0xe3c80028}},	//   न्तु_, sić_, vská_, _cực_,
   {{0xd3782531,0x69c10248,0xf593004f,0x3f830254}},	//   pić_, _élev, _النج, tnju_,
   {{0x9f42024e,0x3179004e,0x63aa00d7,0x61fa0207}},	//   tská_, sisz_, _uhfn, prtl,
   {{0x3179004e,0x3f83011c,0x52370697,0x7bc60306}},	//   pisz_, rnju_, _مسيح_, _auku,
   {{0x7bc6253d,0x9f42024e,0x3cd5081b,0x3f830506}},	//   _buku, rská_, ржас, snju_,
   {{0x7bc6253e,0x3f83003a,0x20020009,0x00000000}},	// [1bf0] _cuku, pnju_, cuki_, --,
   {{0x7bc6043c,0x9f4200b8,0xa3e60433,0x332e009f}},	//   _duku, pská_, यीय_, _jafx_,
   {{0x8aa70009,0x0b88066d,0x2b140e6f,0xfaa7253f}},	//   урад, усти_, न्धु_, ушан,
   {{0xdc34024e,0x3835002d,0x2d9900be,0xf1c900e2}},	//   _zúča, инер, _ukse_, _hạc_,
   {{0x7bc62540,0xdb150139,0x00000000,0x00000000}},	//   _guku, _vizâ, --, --,
   {{0x290606a2,0x2b14210a,0x6d4d2541,0x28d50f06}},	//   agoa_, न्दु_, ljaa, _ड्रि,
   {{0x7bc601ae,0xcf580122,0xd0560095,0xf1c90019}},	//   _zuku, רבות_, _deyə, _mạc_,
   {{0xf1c90028,0x6d4d2542,0x69d52543,0xdd2100b8}},	//   _lạc_, njaa, _itze, _lůžk,
   {{0x7bc6021d,0x68eb0d0d,0x7ae72544,0xe3c80019}},	//   _xuku, magd, _kejt, _rực_,
   {{0x69c7000e,0x68eb057f,0xdced033e,0xdbd200ab}},	//   _kuje, lagd, ynağ, _rüüt,
   {{0x216a2545,0x67231b88,0xdb1c2546,0x75d10029}},	//   вини_, menj, _dirè, _bāze,
   {{0x69c700c8,0x672308b7,0xdc34016f,0x20022547}},	//   _muje, lenj, _súča, tuki_,
   {{0xe3c80028,0x66032548,0xf1c901a5,0x613b081b}},	//   _vực_, lunk, _bạc_, _sälä,
   {{0x7bc62549,0x2002254a,0x6723254b,0xdee3254c}},	//   _ruku, ruki_, nenj, жори,
   {{0x13da0b52,0x7bc6254d,0x20020388,0x799b09d6}},	//   _দিয়, _suku, suki_, _okuw,
   {{0x7bc6254e,0x6723254f,0x6446013c,0xdb1d0392}},	//   _puku, henj, åkig, _ausà,

   {{0x67231877,0x69d50291,0x64490391,0x68eb121e}},	// [1c00] kenj, _atze, nxei, dagd,
   {{0x67230888,0x66032550,0x65692551,0xaaba0609}},	//   jenj, kunk, hheh, ندار_,
   {{0x67230169,0x66032552,0x7ae72553,0x69c7025c}},	//   denj, junk, _dejt, _cuje,
   {{0x7bc62554,0xe3c801a5,0xd9100e3a,0x66032555}},	//   _tuku, _lựa_, ثیر_, dunk,
   {{0x38602556,0x6569002f,0x69d50065,0x290601a3}},	//   áir_, dheh, _etze, rgoa_,
   {{0x67232557,0x7ae72558,0xf1c900e2,0x799b073a}},	//   genj, _gejt, _xạc_, _ekuw,
   {{0xa2c402d1,0x660307cf,0x25fd0325,0x9f5900f7}},	//   रशस्, gunk, रंगी_, ursé_,
   {{0xb4c205e7,0x3f9801c0,0xa6e90019,0x60c400f8}},	//   ्डे_, horu_, _ngươ, _ngim,
   {{0x67232559,0xdb0705c9,0xdb1d1534,0x3f98255a}},	//   benj, _gijó, _husá, koru_,
   {{0x4aaa255b,0x60c4255c,0x69c0255d,0x67230bc6}},	//   _कराव, _agim, _hime, cenj,
   {{0x69c10332,0x69c0255e,0xe3c80019,0xa15901e0}},	//   _élet, _kime, _dựa_, гану_,
   {{0x69c0255f,0x506700c7,0xf1c90019,0x2c5e0029}},	//   _jime, атга, _sạc_, _kādā_,
   {{0x69c02560,0xb4c22561,0x938a01d3,0x8ca20722}},	//   _mime, ंशी_, _иска_, _खरगो,
   {{0x69c02562,0x09d70083,0x3f981e1a,0x2bb200a1}},	//   _lime, _হিসা, goru_, _जळगा,
   {{0x7ae72563,0xdef801c8,0xa18710b0,0x63640176}},	//   _rejt, шыя_, _выпл, _gòna,
   {{0x69c02564,0x6723040b,0x69c70160,0x7ae700b5}},	//   _nime, zenj, _ruje, _sejt,
   {{0x69c72565,0x2ac703fa,0x7ae7082d,0x66032566}},	// [1c10] _suje, аљев, _pejt, zunk,
   {{0x69c02567,0x6d4d0a43,0x69c701f7,0xaad2052f}},	//   _aime, sjaa, _puje, दुलक,
   {{0x67232568,0x69c02569,0xdb0f0176,0xc8790395}},	//   venj, _bime, _bucò, _ieşi_,
   {{0xdb0f02d7,0x69c700f4,0x98a900f4,0xb4c20b54}},	//   _pucó, _vuje, žač_, ्डो_,
   {{0xe8f8256a,0x67231a4c,0x7ae70038,0x68eb00a7}},	//   рлі_, tenj, _tejt, ragd,
   {{0x2fc901a9,0x69c7256b,0x6603256c,0x68eb256d}},	//   _muag_, _tuje, tunk, sagd,
   {{0x67230496,0x2fc901a9,0x69c00359,0x6569256e}},	//   renj, _luag_, _fime, theh,
   {{0x99850082,0x6603256f,0x67232570,0xe61600d8}},	//   _الرو, runk, senj, ёды_,
   {{0x66032571,0x681a0029,0x44392572,0x290d0176}},	//   sunk, gādā, ís_, _icea_,
   {{0x69c0000e,0x65692573,0x68e9001c,0xb4e60035}},	//   _zime, sheh, _heed, _बड़ी_,
   {{0xb63503c7,0xcb12011d,0x68e900be,0x69c02574}},	//   _دفاع, הלי_, _keed, _yime,
   {{0x68e9013a,0xd05d00a8,0x261c143a,0x3f980067}},	//   _jeed, lasə, _महती_, woru_,
   {{0x3f982575,0x3438006c,0x68e92576,0x2fc90189}},	//   toru_, _پسند_, _meed, _cuag_,
   {{0x68e9225f,0x50d806bc,0x98a00a78,0xf1cf00fa}},	//   _leed, _भ्रष, žić_, _संपन,
   {{0x25fd0084,0xc879002d,0xbcfb0320,0x00000000}},	//   रंटी_, _deşi_, _elém, --,
   {{0x68e90122,0xbf9b03e6,0x3f982577,0xc6920317}},	//   _need, quên, soru_, פאן_,
   {{0x69c02578,0x3f982579,0x7ff614ac,0x8c43002d}},	// [1c20] _rime, poru_, _اسبا, пете,
   {{0x290d002d,0x2b4301f7,0x00000000,0x00000000}},	//   _acea_, _cnjc_, --, --,
   {{0xcf5701f3,0xe80a0302,0x69c0257a,0x2fc90221}},	//   _הבית_, हूना_, _pime, _zuag_,
   {{0xb4e600c0,0x2fc90221,0xea000023,0x26c500ee}},	//   _बजे_, _yuag_, _nhấp_, _aglo_,
   {{0x69c00054,0x68e90f00,0x00000000,0x00000000}},	//   _vime, _deed, --, --,
   {{0xaa46257b,0xc4480118,0x681a0228,0x69c00371}},	//   _легл, ییان_, vādā, _wime,
   {{0x69c0257c,0x68e9257d,0x1b7b02b5,0x6b631397}},	//   _time, _feed, _עטלע, _экра,
   {{0xea0001a5,0x32050187,0xf3f80227,0x69c0257e}},	//   _chấp_, duly_, аниш_, _uime,
   {{0x7866257f,0x00000000,0x00000000,0x00000000}},	//   _указ, --, --, --,
   {{0x681a0080,0x2fc92580,0x68e90051,0x00000000}},	//   rādā, _ruag_, _zeed, --,
   {{0x6b9b02b5,0xcb9b0d85,0x320507df,0x681a00ec}},	//   רשיד, רסיט, guly_, sādā,
   {{0x2fc90189,0xe5722499,0x21672581,0x00000000}},	//   _puag_, _عطا_, стог, --,
   {{0x2fc9006d,0xf8ba1022,0x91ca051d,0x00000000}},	//   _quag_, ेशिय, _संवै, --,
   {{0x2fc9006f,0x995c0355,0x320500d5,0x25ef0099}},	//   _vuag_, jíž_, buly_, ींची_,
   {{0xf1c90028,0x995c0355,0x00000000,0x00000000}},	//   _hạn_, díž_, --, --,
   {{0x2fc92582,0xf1c90023,0x0dc8021d,0x00000000}},	//   _tuag_, _kạn_, сури_, --,
   {{0x68e92583,0xd05d01c2,0x3b5507bc,0x00000000}},	// [1c30] _reed, yasə, окар, --,
   {{0xf1c90019,0x68e92584,0xdb050079,0x88d20033}},	//   _mạn_, _seed, lmhú, ারফক,
   {{0x9d192585,0x6aba008d,0x2d8b0183,0x68e92586}},	//   _конт_, _útfl, _tjce_, _peed,
   {{0xad270416,0x9f520260,0xbcfb00b8,0x8ed80609}},	//   _اردو, _avyè_, _mlék, _پذیر_,
   {{0xf1c901a5,0xbae80083,0xb4e60461,0x31690506}},	//   _nạn_, _পারছ, _बड़े_, _mlaz_,
   {{0x7c2f0133,0xe7390204,0x45d51784,0xaded0324}},	//   _iscr, рек_, оцит, _जबान_,
   {{0x636d2587,0x68e900ab,0x27e00228,0x00000000}},	//   _húng, _teed, ģina_, --,
   {{0xf1c9098b,0xf7732588,0x160b0035,0xf1cf1140}},	//   _bạn_, _کار_, संबर_, _संबन,
   {{0x25fd0437,0xf1c90023,0xe70b0088,0x7c3b00cd}},	//   रूजी_, _cạn_, _متان_, _šurj,
   {{0x32050187,0x6d93003c,0x31690051,0xf1c900e2}},	//   tuly_, lħad, _alaz_, _dạn_,
   {{0xea0001a5,0xe12613a1,0x316902a7,0x00000000}},	//   _thấp_, омни, _blaz_, --,
   {{0x26130370,0x241900c3,0x8cd91119,0x61fc2589}},	//   mão_, _воды_, _फ्लो, árla,
   {{0x26130370,0x00000000,0x00000000,0x00000000}},	//   lão_, --, --, --,
   {{0x88ba00a5,0xfe460210,0x442f008e,0x53340421}},	//   יזרי, онго, _isg_, _нечт,
   {{0x3ebe258a,0x26130279,0x442f258b,0x443d258c}},	//   ätt_, não_, _hsg_, _hrw_,
   {{0x443d1ae2,0x9f4200a0,0xf1c900e2,0x3cf600ab}},	//   _krw_, nskú_, _hạo_, ेलें_,
   {{0xdca3258d,0x26130132,0x636d0079,0x00000000}},	// [1c40] дати, hão_, _cúng, --,
   {{0x443d258e,0x1dd20067,0x670e258f,0x69cb00ab}},	//   _mrw_, _दंपत, _साधक_, _तूही,
   {{0x26130279,0x2d9e00f7,0xf1c90023,0x442f102f}},	//   jão_, îtes_, _mạo_, _lsg_,
   {{0x8c460346,0x26130370,0x443d073a,0x00000000}},	//   _деме, dão_, _orw_, --,
   {{0x274a2590,0x6d462591,0x443d01ae,0x00000000}},	//   ичко_, _inka, _nrw_, --,
   {{0x29d7009f,0x26130132,0xf1c900e2,0x2b3a00af}},	//   _bħad_, fão_, _nạo_, _тямэ_,
   {{0x26130370,0xf1c901a5,0xa3e2020d,0xc2e80033}},	//   gão_, _sạn_, _फौज_, _খালি_,
   {{0x54541109,0x2240023a,0xdb1c01ef,0x442f2592}},	//   звит, _čik_, _mirí, _bsg_,
   {{0x68e22593,0xf1c90019,0x18672594,0x6d46030d}},	//   mbod, _bạo_, _дати_, _mnka,
   {{0x2d6801d6,0xf1c90023,0x26130279,0x68e20185}},	//   rşey_, _vạn_, bão_, lbod,
   {{0x31692595,0x26130279,0xf1c90019,0x443d2596}},	//   _plaz_, cão_, _dạo_, _erw_,
   {{0xdb1d02c9,0x68e22597,0x443d0010,0x2efa021d}},	//   _zusä, nbod, _frw_, _adpf_,
   {{0xdb1c0079,0x98c50009,0x00000000,0x00000000}},	//   _airí, šuća_, --, --,
   {{0x6d462598,0x53340705,0xf1c90019,0x59ca018d}},	//   _anka, _хект, _gạo_, िदार,
   {{0xdb1c01ef,0x9e34002d,0xa2da022e,0xcdd80274}},	//   _cirí, мерч, पुण्, жњу_,
   {{0xdb1c0b4c,0x31690254,0xd65700a5,0xdb1d03d0}},	//   _dirí, _ulaz_, חילת_, _muså,
   {{0x261303e6,0x2d890098,0x69de0a8a,0x636d0042}},	// [1c50] zão_, rnae_, eppe, _fúnd,
   {{0x6d462599,0xfaa70b00,0x8aa7117a,0x628b00cd}},	//   _enka, ошен, оред, šloš,
   {{0x26130370,0x2d5c01ef,0x539b00a5,0x00000000}},	//   xão_, _cíes_, סיבו, --,
   {{0xa2da143a,0x26130279,0x68e20282,0x2d5c0176}},	//   पुत्, vão_, gbod, _díes_,
   {{0xf745259a,0x69de0036,0x8ca20026,0x9cd6011d}},	//   зело, appe, _कुपो, _מורה_,
   {{0x261300c9,0x7d0d259b,0x7c2d259c,0x442f03bc}},	//   tão_, lgas, mwar, _rsg_,
   {{0xf99303c7,0xf1c600b4,0x7d0d0065,0x00000000}},	//   _قبر_, _रंगन, ogas, --,
   {{0x261300c9,0x7d0d259d,0x442f259e,0x2002008d}},	//   rão_, ngas, _psg_, yrki_,
   {{0x261300c9,0x7c2d259f,0x68fb010d,0xe80a046c}},	//   são_, nwar, _idud, हूदा_,
   {{0x31b606fe,0x261303e6,0x6d930484,0x77ad01ef}},	//   ृद्ध, pão_, nħab, búxa,
   {{0xe29925a0,0x7c2d25a1,0x636d0037,0x00000000}},	//   сан_, hwar, _rúnd, --,
   {{0x661c00be,0x3a3100b5,0xea0000e2,0x442f0110}},	//   _ärka, _mszp_, _chẹp_, _tsg_,
   {{0xf1c900e8,0x555200b5,0x81cc0083,0x645d01ae}},	//   _tạo_, _سپور, শীল_, äsid,
   {{0x442d25a2,0x7c2d25a3,0x752925a4,0xdc3a0095}},	//   mwe_, dwar, leez, xçıv,
   {{0x442d25a5,0xf2d202b5,0x2ca700a8,0x68e225a6}},	//   lwe_, _טעג_, əndi_, ybod,
   {{0x7d0d25a7,0x442d0035,0x636d01ef,0xdb1c25a8}},	//   ggas, owe_, _dúne, _virí,
   {{0x7c2d25a9,0x442d25aa,0x2b5825ab,0xed570370}},	// [1c60] gwar, nwe_, _porc_, чот_,
   {{0x636d25ac,0x7d0d25ad,0xf1c90023,0x442d25ae}},	//   _fúne, agas, _lạm_, iwe_,
   {{0xa9261eea,0x68e20051,0x442d25af,0xdb1c0183}},	//   здел, tbod, hwe_, _pirâ,
   {{0x442d25b0,0xfc3f0093,0xc7c60798,0x31b2053d}},	//   kwe_, _frí_, пски, báze_,
   {{0x6846061c,0x442d070b,0x07a61641,0x68e225b1}},	//   янда, jwe_, падн, rbod,
   {{0xe3a70e0c,0x501b0122,0x442d0107,0x656b25b2}},	//   _سر_, מונו, dwe_, _algh,
   {{0x442d0173,0xbcfb0037,0x00000000,0x00000000}},	//   ewe_, _sléi, --, --,
   {{0x69ce0043,0x6b9e0b3e,0x75290273,0xbcfb0079}},	//   _iube, lopg, geez, _pléi,
   {{0x442d0aee,0xa3e60324,0x69dc009e,0xdb1c021d}},	//   gwe_, यीं_, _htre, _girã,
   {{0x69ce0c1b,0x27f7000c,0xb4ac0311,0x798225b3}},	//   _kube, ření_, _गरी_, liow,
   {{0xcfc40083,0x442d25b4,0xe3b8037a,0x7c2d25b5}},	//   ্ঠান, awe_, rmı_, zwar,
   {{0x442d25b6,0x7982004e,0x69ce25b7,0xe3b8027d}},	//   bwe_, niow, _mube, smı_,
   {{0x69ce25b8,0x43460e0a,0x6b9e0a8a,0x24490286}},	//   _lube, _недв, kopg, _وجهي_,
   {{0x7aee00d7,0x69ce0103,0x00000000,0x00000000}},	//   _nebt, _oube, --, --,
   {{0xd78800e8,0x21200129,0x69ce0300,0x070500b4}},	//   yển_, _fbih_, _nube, _राघव_,
   {{0xbcfb00de,0x7d0d25b9,0x7aee0065,0x7c2d25ba}},	//   _llév, ugas, _aebt, twar,
   {{0x7d0d25bb,0x2d581470,0x69ce25bc,0x212b25bd}},	// [1c70] rgas, чить_, _aube, mech_,
   {{0x212b25be,0x69ce030d,0x7c2d1425,0x65a5006c}},	//   lech_, _bube, rwar, róhi,
   {{0x442d25bf,0x69ce25c0,0x7c2d08eb,0x3f8325c1}},	//   zwe_, _cube, swar, miju_,
   {{0xfc3f25c2,0x212b25c3,0x69ce25c4,0x442d25c5}},	//   _trí_, nech_, _dube, ywe_,
   {{0xf7700148,0x69dc25c6,0x201925c7,0x200b00cb}},	//   گان_, _etre, ntsi_, nuci_,
   {{0xf09402b5,0x3f830d77,0x7bdd25c8,0xb6a502ee}},	//   ענס_, niju_, _itsu, милл,
   {{0xf77005bc,0x442d053e,0x69ce00a1,0xa3c207b5}},	//   دان_, wwe_, _gube, ्दन_,
   {{0x442d19c7,0x3f8325c9,0x7982004e,0xbcfb25ca}},	//   twe_, hiju_, ciow, _elév,
   {{0x442d25cb,0x200b25cc,0x69ce25cd,0x212b01c0}},	//   uwe_, juci_, _zube, dech_,
   {{0xe1f91109,0x442d25ce,0x200b25cf,0xd2f7006c}},	//   ого_, rwe_, duci_, سکتا_,
   {{0x3f8311c6,0x442d01d5,0x7bc725d0,0xf1c901a5}},	//   diju_, swe_, _miju, _tạm_,
   {{0x290f0464,0x7bdd0006,0xdb1c02d7,0x442d25d1}},	//   ngga_, _otsu, _mirá, pwe_,
   {{0x7bdd01a9,0xbf9b03e6,0x3f8325d2,0x41cf018d}},	//   _ntsu, rrên, fiju_, _संवस,
   {{0x3f830a78,0x1b030033,0x7bc7023c,0x16210253}},	//   giju_, র্তে_, _niju, _महार_,
   {{0x7bcf1010,0x7bdd25d3,0x212b25d4,0xddd400a0}},	//   _aucu, _atsu, bech_, ňažn,
   {{0x7bcf09eb,0xc6920070,0x2019006f,0x29f801ba}},	//   _bucu, דאל_, btsi_, vča_,
   {{0x67211038,0x7bc725d5,0x1fb60210,0x3f8325c1}},	// [1c80] _oblj, _biju, _осор, biju_,
   {{0x3f8325d6,0x09e6172a,0x2c0b00b5,0x7bcf0371}},	//   ciju_, дожн, تعفی_, _ducu,
   {{0x7bc71b0f,0xed5a079d,0x69ce013b,0x00000000}},	//   _diju, _дон_, _qube, --,
   {{0x7aee25d7,0xdb1c0300,0x7bcf0211,0x2d8500fd}},	//   _webt, _dirá, _fucu, élet_,
   {{0xb4ac000c,0x7bcf0010,0x2baf25d8,0x38cb25d9}},	//   _गरे_, _gucu, _जीवा, زانی_,
   {{0x212b04aa,0x7bc7012f,0x29f80cc2,0x5b35002d}},	//   zech_, _giju, pča_, _пэсу,
   {{0x69dc25da,0x8b0301c0,0x7bcf0036,0x79820035}},	//   _utre, _úřad, _zucu, piow,
   {{0x3f8325c1,0xd8260431,0x7bc725db,0xdb070328}},	//   ziju_, _одби, _ziju, _ehjä,
   {{0xf8b20084,0x212b25dc,0x764100e9,0x7bc70371}},	//   _जरिय, vech_, _erly, _yiju,
   {{0xd37010ee,0x200b0c21,0x74150118,0x212b016e}},	//   اهد_, vuci_, روپا, wech_,
   {{0x212b25dd,0xa2da25de,0x3f830eac,0x63a825df}},	//   tech_, पुष्, viju_, rldn,
   {{0x80fb1cce,0xe7f50035,0x63640392,0x200b25e0}},	//   ्लेख_, ुंचा_, _mòni, tuci_,
   {{0x212b25e1,0x3f8325e2,0x320500a5,0xbcfb0118}},	//   rech_, tiju_, arly_, _mlét,
   {{0xa2940a93,0x442625e3,0x212b00b8,0x200b00cd}},	//   _палі, _ipo_, sech_, ruci_,
   {{0x3f8325d6,0x7bcf25e4,0x13e30083,0x290f014e}},	//   riju_, _sucu, _মিয়, ygga_,
   {{0x3f8325e5,0x7bc7000e,0x7bcf1034,0xa2da20ab}},	//   siju_, _siju, _pucu, पुर्,
   {{0x3f83180c,0x7bc725e6,0x60cd01d5,0x9f420314}},	// [1c90] piju_, _piju, _igam, lský_,
   {{0x09b9012f,0x442625e7,0x798025e8,0x00000000}},	//   ेद्य, _mpo_, _ammw, --,
   {{0x9f4205d3,0x752225e9,0x7bc725ea,0x291d021e}},	//   nský_, _oboz, _viju, tfwa_,
   {{0x4adf114e,0x1adf09a8,0x394909ab,0x7bcf25eb}},	//   _प्रव, _प्रथ, ñas_, _tucu,
   {{0x44260221,0x636d004f,0x7bc725ec,0xba7403c5}},	//   _npo_, _lúna, _tiju, _یافت,
   {{0xbcfb03e6,0xdb1c25ed,0x63640107,0x75220027}},	//   _elét, _tirá, _fòni, _aboz,
   {{0x4426071f,0x60cd25ee,0x9f420187,0xe5a525ef}},	//   _apo_, _ogam, jský_, ники,
   {{0x60cd25f0,0x77ad01dd,0x9f420187,0x644223e8}},	//   _ngam, púxo, dský_, _broi,
   {{0x6d5d25f1,0x644225f2,0x20fb0067,0x3f8111cb}},	//   _mosa, _croi, ्लैश_, _omhu_,
   {{0x64421079,0x60cd25f3,0xf1c901a5,0x442625f4}},	//   _droi, _agam, _hại_, _dpo_,
   {{0x636d0037,0x64421315,0x442625f5,0xdb050037}},	//   _cúna, _eroi, _epo_, lmhó,
   {{0x6d5d25f6,0x644225f7,0x27ed02d0,0x44261c35}},	//   _nosa, _froi, _kwen_, _fpo_,
   {{0xf1c90028,0x27ed02e9,0x60cd02d7,0x65690e0e}},	//   _mại_, _jwen_, _dgam, mkeh,
   {{0x27ed0c05,0xf1c900e8,0x443f0232,0x257101c0}},	//   _mwen_, _lại_, mvu_, _dále_,
   {{0x6d5d25f8,0x443f25f9,0x27ed02e9,0xf8a502fd}},	//   _bosa, lvu_, _lwen_, _چک_,
   {{0x6d5d25fa,0x753b25fb,0xed5725fc,0xf65202b5}},	//   _cosa, nduz, нос_, נצן_,
   {{0x6d5d25fd,0x443f0273,0xf1ca0019,0x4095002d}},	// [1ca0] _dosa, nvu_, _nại_, _арэт,
   {{0x5ba70043,0x99710067,0x909b00a5,0x00000000}},	//   екум_, jął_, _מספק, --,
   {{0x09062462,0x37090066,0xa3c025fe,0xbcfb1f55}},	//   епен, _साड़ी_, ंगत_, _boéd,
   {{0x443f01cc,0x7e61022a,0xf1ca0019,0x63a125ff}},	//   kvu_, älpe, _bại_, holn,
   {{0x63a12600,0x9f4200b8,0x69c92601,0x443f0009}},	//   koln, zský_, _diee, jvu_,
   {{0xb90700b4,0xf1ca0023,0x27ed0107,0x78a90260}},	//   _म्_, _dại_, _dwen_, _dyev,
   {{0xe5c60945,0x443f0d5e,0x27ed0211,0x44262602}},	//   нсио, evu_, _ewen_, _spo_,
   {{0x9f420076,0xdb1c01d6,0x636d2603,0xd5b70f99}},	//   vský_, _birç, _rúna, нсы_,
   {{0x70af1db1,0x27ed123d,0xbcfb00e0,0xe4522604}},	//   _घरेल, _gwen_, _klér, اضع_,
   {{0x88831fba,0x9f42024e,0x320c0159,0xbf9b0248}},	//   _служ, tský_, tudy_, trêm,
   {{0x25710097,0x66e30210,0x69c900e0,0x00000000}},	//   _sále_, _соха, _yiee, --,
   {{0x3202114d,0x64422605,0x9f420237,0x61e40009}},	//   čky_, _troi, rský_, _čild,
   {{0x38660443,0x63a1078a,0x44262606,0x25a60069}},	//   nyor_, boln, _upo_, _ikol_,
   {{0x6d5d2607,0xbf9b000d,0x9f421dab,0x00000000}},	//   _sosa, prêm, pský_, --,
   {{0xf1a72608,0x673a2609,0x64470029,0x1c03007c}},	//   _прин, _matj, ājie, _लिहल_,
   {{0x5ba921b2,0xbcfb1417,0x60cd260a,0x29d70024}},	//   कत्व, _alér, _ugam, _bħan_,
   {{0xfbd318dd,0x6d5d0443,0x6386000d,0xbcfb0118}},	// [1cb0] اتر_, _vosa, _génè, _roéd,
   {{0x673a029d,0xbcfb002a,0xf1bf0042,0x78bd00ac}},	//   _natj, _clér, lmá_, _úsvi,
   {{0x6d5d0082,0x61fa02c9,0x69c90080,0x27ed02e9}},	//   _tosa, nstl, _piee, _swen_,
   {{0xbcfb006c,0x27ed02e9,0xfaa40036,0x25a6023a}},	//   _elér, _pwen_, ушун, _nkol_,
   {{0xe7390f94,0xa3c20311,0xa3c004cc,0x29d7003c}},	//   дел_, ्दा_, ंगा_, _għan_,
   {{0xdb050037,0x25a61388,0x61fa260b,0x00000000}},	//   rmhó, _akol_, kstl, --,
   {{0x63a10314,0x673a01bf,0xf1bf00d5,0x00000000}},	//   voln, _datj, kmá_, --,
   {{0xf1ca00e8,0x443f0121,0x63a10035,0xa3cc0440}},	//   _tại_, tvu_, woln, _शंख_,
   {{0x02c9065f,0x656902c9,0xe3b912f3,0x210401c8}},	//   रश्न, rkeh, мби_, nčių_,
   {{0x443f260c,0x6569260d,0x2104010b,0x00000000}},	//   rvu_, skeh, ičių_, --,
   {{0x779009b9,0x3dcb00d7,0x443f260e,0xc0e6260f}},	//   _دیوا, _oicw_, svu_, конк,
   {{0x395f021e,0x63a100fd,0x638600a2,0x673a0207}},	//   _jous_, soln, _pénè, _zatj,
   {{0x63a1108a,0x62980176,0x61e4011c,0x395f00f6}},	//   poln, _exvo, _čile, _mous_,
   {{0x25ad2610,0x25a015d7,0x25bf002d,0x395f0260}},	//   llel_, čile_, lmul_, _lous_,
   {{0xe3c80019,0xbea62611,0x539a011d,0x394d00a5}},	//   _cựu_, тавк, _קיצו, _ones_,
   {{0x395f2612,0x41b6006c,0xa5c20093,0x6386000d}},	//   _nous_, _جمعر, _þótt, _ténè,
   {{0x636d0168,0x29d7013b,0x91bb00a5,0xbcfb00f6}},	// [1cc0] _júno, _aça_, _קמפי, _plér,
   {{0x09ca04cc,0x395f009e,0x394d0c6f,0x00000000}},	//   िद्य, _aous_, _anes_, --,
   {{0xc3320122,0x395f2613,0x673a0051,0x00000000}},	//   שוב_, _bous_, _ratj, --,
   {{0x395f0036,0x02b60070,0x394d216e,0x3866013b}},	//   _cous_, דלעך_, _cnes_, tyor_,
   {{0x395f2614,0x394d086d,0x261406bb,0x673a2615}},	//   _dous_, _dnes_, नूनी_, _patj,
   {{0x25a62616,0xbf9b0248,0x186703fa,0x394d2617}},	//   _skol_, quêt, ђаји_, _enes_,
   {{0xe9d70009,0x2bd80f8a,0x6aa301ae,0x395f000d}},	//   _акс_, _भंडा, ünft, _fous_,
   {{0x316001d7,0x2d922618,0x2ef8033b,0x395f1080}},	//   _noiz_, nnye_, harf_, _gous_,
   {{0x47c600d8,0xd0e30f9f,0x41cf00ab,0x00000000}},	//   _абав, _क्षण_, _संउस, --,
   {{0xbcfb0176,0x31bd1371,0x316001ed,0x63760139}},	//   _llép, ोद्ध, _aoiz_, _mâng,
   {{0xcb130122,0x2ef801ae,0x27e600d1,0x6376002d}},	//   בלת_, darf_, lpon_, _lâng,
   {{0x25a60dc3,0x2bd80e61,0x00000000,0x00000000}},	//   _ukol_, _भूभा, --, --,
   {{0x27e62619,0xf1bf0952,0x3a380211,0x00000000}},	//   npon_, rmá_, _lsrp_, --,
   {{0x29d70484,0x27e6010d,0x00000000,0x00000000}},	//   _bħal_, ipon_, --, --,
   {{0xd24f00f3,0x636d0037,0xc333011d,0x3da703e6}},	//   _ونه_, _múnl, _כוס_, враб,
   {{0x316001a3,0xa3c0021a,0x463b016b,0x00000000}},	//   _goiz_, ंगव_, ועלע, --,
   {{0x0dc80b07,0x4ec50033,0xc05b01e0,0x00000000}},	// [1cd0] тури_, ্রেল, _цій_, --,
   {{0x395f261a,0x2571261b,0x2d92018e,0xe3c80023}},	//   _sous_, _mála_, anye_, _tựu_,
   {{0x29d72251,0xe805045c,0x210400d8,0x395f261c}},	//   _għal_, _रिहा_, sčių_, _pous_,
   {{0x67d5261d,0x26de0312,0x00000000,0x00000000}},	//   году, _afto_, --, --,
   {{0x395f168b,0x6d4f261e,0xd825261f,0x63761bec}},	//   _vous_, _inca, удли, _gâng,
   {{0xf1ca01a5,0xa3b20084,0x394d016e,0x00000000}},	//   _hạt_, _झील_, _wnes_, --,
   {{0x395f105d,0x637600af,0x00000000,0x00000000}},	//   _tous_, _mând, --, --,
   {{0x224901cc,0x394d12c3,0x84590370,0x25711534}},	//   _čak_, _unes_, ерот_, _bála_,
   {{0xc9841f9b,0x25bf2620,0x7af501ed,0xf1ca00e2}},	//   _тури, rmul_, _kezt, _mạt_,
   {{0x25bf0043,0x25ad0187,0xf1ca0019,0x69d52621}},	//   smul_, slel_, _lạt_, _kuze,
   {{0x75150514,0x6d4f01cb,0x200b0035,0xa18a117a}},	//   _مواض, _onca, erci_, ебна_,
   {{0x69d52622,0x9f5e0355,0xdb1d02b1,0xd00a0f8c}},	//   _muze, čtí_, _ausü, неме_,
   {{0x69d52623,0x2d890118,0xe44e0a2b,0x63640392}},	//   _luze, diae_, _уж_, _còns,
   {{0x6d4f00c1,0x63762624,0x77ad002a,0x00000000}},	//   _anca, _când, fúxi, --,
   {{0xa3c20299,0x200b07e5,0x63760395,0xf1ca0023}},	//   ्दर_, arci_, _sâng, _bạt_,
   {{0xcd3600b5,0x22470009,0x261400a1,0x63760160}},	//   درآب, _irnk_, नंती_, _pâng,
   {{0x69d50139,0xf1ca00e2,0x1c46010b,0x7de9021e}},	// [1ce0] _auze, _dạt_, ынам, _pèsò,
   {{0x6d4f1083,0x69d52625,0x63760043,0x3a38023c}},	//   _enca, _buze, _gând, _psrp_,
   {{0xd9462626,0x68e40138,0x22f6016b,0x27ff0328}},	//   лежи, ñido, רזען_, _avun_,
   {{0x2d8901ef,0xed5718a4,0xf1ca0023,0x69d52627}},	//   ciae_, _бою_, _gạt_, _duze,
   {{0x27e60069,0x77610042,0xb6c800b5,0xe7860200}},	//   upon_, _bolx, ھاتے_, луко,
   {{0x7d162628,0x3f8a00ec,0x224702a7,0x07a31b60}},	//   lgys, nibu_, _ornk_, бачн,
   {{0x27e62629,0x2bd800e7,0xe1e7006c,0x2a350043}},	//   spon_, _भूता, _دس_, _кэтр,
   {{0x7bce0464,0x78b1008d,0x636d0079,0x3f8a08c7}},	//   _hibu, ðkvæ, _dúnm, hibu_,
   {{0x7bce262a,0x69d503cb,0xb716004f,0xa3c202cb}},	//   _kibu, _zuze, _مباش, ्दल_,
   {{0x3f8a0657,0x14c000e7,0x69c22069,0x28b9002d}},	//   jibu_, शेषण, lmoe, _русэ_,
   {{0x6b7b02b5,0x200002c4,0x2d5c215f,0x6376002d}},	//   גרינ, _avii_, _díez_, _rând,
   {{0x84461d05,0x7bce0635,0xdb1c2314,0x69c20b0d}},	//   _مختل, _libu, _cirú, nmoe,
   {{0x200b000d,0x2000009e,0x133900b5,0x63760139}},	//   urci_, _cvii_, رتیں_, _pând,
   {{0x447b0779,0x6562008c,0x7bce0010,0xf1ca00e2}},	//   _אנדע, _hooh, _nibu, _sạt_,
   {{0x2904025c,0x63030037,0x63760139,0x1b1a0033}},	//   _odma_, _طويل, _vând, ড়াই_,
   {{0x69d50add,0x7bce08c7,0x69c20051,0xfbdf00e5}},	//   _ruze, _aibu, jmoe, _drên_,
   {{0x7bce2107,0x69d50fd4,0x3f8a262b,0x29d70069}},	// [1cf0] _bibu, _suze, bibu_, _għaj_,
   {{0x7bce262c,0x34d1007c,0x59d902e4,0x2904262d}},	//   _cibu, _हल्द, _बंदर, _adma_,
   {{0x5a35262e,0x7bce0ce8,0x5f7400f3,0xf1ca00e2}},	//   рнет, _dibu, _داير, _tạt_,
   {{0xe9ab00f8,0x69c21e7e,0xe0df0036,0x6aae008c}},	//   ردان_, gmoe, ncò_, _dybf,
   {{0x68f9006a,0xf8071346,0x21290703,0x69da0248}},	//   rawd, учен, _mbah_, _éten,
   {{0x7bce03be,0x68f9001e,0xf745262f,0x69d52630}},	//   _gibu, sawd, реко, _tuze,
   {{0x7f3c02b5,0xfaa90413,0x9c8700d5,0x212900f8}},	//   געוו, _شهري_, bočí, _obah_,
   {{0x3f8a0273,0xdb15002a,0x7bce2631,0x05651e1d}},	//   zibu_, _tizó, _zibu, рвин,
   {{0x6562022e,0xa3c2012f,0x7bce01d5,0x320b0035}},	//   _dooh, ्दं_, _yibu, ącym_,
   {{0x25a0068b,0x42252632,0x21292633,0x2bd822a7}},	//   čila_, адов, _abah_, _भंसा,
   {{0xe29907be,0x45d52634,0xe3b6002d,0x00000000}},	//   тан_, _тоес, рбэ_, --,
   {{0x69d803e6,0x798b2635,0xa06a0274,0x00000000}},	//   ívei, nigw, вама_, --,
   {{0x3f8a0657,0x671c0e7f,0x320c0d14,0x00000000}},	//   tibu_, _नामक_, ardy_, --,
   {{0xb4c10821,0x224702c4,0x21292636,0x798b01d5}},	//   ंधी_, _trnk_, _ebah_, higw,
   {{0x3f8a0657,0x7bce06b3,0x0fc302ce,0x65622637}},	//   ribu_, _ribu, ійсн, _yooh,
   {{0x4aa90084,0x2571053d,0xb04a021d,0xe0df027a}},	//   _कड़व, _málo_, _азиз_, ccò_,
   {{0x3b8600d8,0x9c8700a0,0x7d160987,0x00000000}},	// [1d00] алаг, vočí, rgys, --,
   {{0xfbdf00e8,0xdcf610b1,0x1db80099,0x7bce0103}},	//   _trên_, ıcın, _आठवत, _qibu,
   {{0x69c20136,0x27e4012f,0x7bce2638,0x25780051}},	//   tmoe, _stmn_, _vibu, _héle_,
   {{0x27e4022e,0xc8ca0125,0xfd120037,0x7bce04fb}},	//   _ptmn_, نوان_, _بجد_, _wibu,
   {{0x7bce03be,0x69c202e6,0x97c6172a,0xa01b033b}},	//   _tibu, rmoe, айде, rzög,
   {{0x6376002d,0x69c22639,0x00000000,0x00000000}},	//   _mânc, smoe, --, --,
   {{0x9c87024e,0x656200fe,0xbcfb0118,0x798b263a}},	//   počí, _pooh, _moén, bigw,
   {{0x290401a2,0xa4f8042c,0x00000000,0x00000000}},	//   _udma_, اکار_, --, --,
   {{0x68ed0138,0xdb1c0044,0xa3e70274,0x00000000}},	//   ñade, _birø, адња_, --,
   {{0xf366263b,0x765500b5,0x00000000,0x00000000}},	//   ртин, ógyí, --, --,
   {{0x1b0300c8,0x0bb70122,0x81de0033,0xa2c905f8}},	//   র্কে_, שלים_, দীন_, _हृद्,
   {{0x672d00cd,0x51f71667,0x00000000,0x00000000}},	//   đaje, шнюю_, --, --,
   {{0x04140083,0x63760279,0xe0df027a,0x5064263c}},	//   _তৈরী_, _cânc, rcò_, отра,
   {{0x93fb0052,0x63760160,0x1ee713cf,0x25780355}},	//   _ילדי, _dânc, شوری_, _déle_,
   {{0x63a82182,0x59a602e4,0x00000000,0x00000000}},	//   modn, गकार, --, --,
   {{0x21290ec0,0x2baf0b4d,0x257800b5,0x00000000}},	//   _ubah_, _जीजा, _féle_, --,
   {{0x91bc00a5,0x00000000,0x00000000,0x00000000}},	// [1d10] _במהי, --, --, --,
   {{0x3b54263d,0x8ae702ce,0x3f152626,0x2d8c000d}},	//   окур, ріал, _удос, éder_,
   {{0xcfe20083,0x69da00b5,0x2d990183,0x2bc8263e}},	//   _বিএন, _étel, _tjse_, руто_,
   {{0x63a8201b,0xac95005f,0x00000000,0x00000000}},	//   hodn, _гамш, --, --,
   {{0x8d5a0052,0x63a805e2,0x66e5021d,0x41d000b8}},	//   _עכשי, kodn, бола, _संघस,
   {{0xcc3a00c2,0xdc3a00c2,0xf1ca0023,0x798b0651}},	//   _געשט, _געשר, _lạp_, sigw,
   {{0x798b000e,0xaac30067,0x6446008d,0xa3c00387}},	//   pigw, वेशक, ækin, ंगई_,
   {{0xf1ca0019,0x1e980277,0x00000000,0x00000000}},	//   _nạp_, יכול_, --, --,
   {{0x79890054,0x26130d2a,0xe80e00ab,0xa2c9178c}},	//   _imew, _धमकी_, _सिया_, हेन्,
   {{0xf7731c0c,0x63a8263f,0xc6a70166,0x78bb00f4}},	//   _بار_, godn, _креи, _izuv,
   {{0x636d2640,0x216a0812,0x61460f8c,0x00000000}},	//   _júni, гини_, бена, --,
   {{0x249d0189,0x636d20d9,0xdb0501ff,0xf1ca00e2}},	//   _txwm_, _múni, llhä, _cạp_,
   {{0x63a80690,0x636d0176,0x23291d30,0x2418010b}},	//   bodn, _lúni, _боли_, _вочы_,
   {{0x2bdb0953,0xdee32641,0x442f00d7,0x53341583}},	//   _बढ़ा, зори, _ipg_, _мечт,
   {{0x2bbd20af,0x3cf9008c,0x7c3d0282,0x22581788}},	//   ्गना, _besv_, _assr, ärkt_,
   {{0xf1d025d8,0xa1930798,0x1c030006,0x442f0159}},	//   _सूचन, _најч, _लिखल_, _kpg_,
   {{0x443d2642,0x00000000,0x00000000,0x00000000}},	// [1d20] _jsw_, --, --, --,
   {{0xf3f912eb,0x20021577,0x79890054,0x636d0093}},	//   _আমার_, mski_, _amew, _búni,
   {{0x20020fe2,0x6e4601ca,0x25710093,0x7c3d0036}},	//   lski_, _انجم, _páll_, _essr,
   {{0x9f49064b,0xf8fa0037,0x442f008c,0x08c6002d}},	//   _hvað_, اءات_, _opg_, ббен,
   {{0x200202dd,0x657b2643,0xbf9b000d,0x443d0f00}},	//   nski_, dhuh, prêt, _nsw_,
   {{0x6d440291,0x394000d8,0x7c242644,0x00000000}},	//   ldia, žis_, mtir, --,
   {{0x644b2645,0x443d2646,0x8afb02b8,0x65be00da}},	//   _argi, _asw_, _תהלי, hëhe,
   {{0x25a0108a,0x63a8004e,0xb996004f,0x7afe2647}},	//   čilo_, wodn, _الرب, lapt,
   {{0x20022648,0x7c242649,0x442f264a,0xf1ca0019}},	//   jski_, ntir, _cpg_, _rạp_,
   {{0x20020496,0x7afe264b,0x68e20223,0xf1ca0023}},	//   dski_, napt, lcod, _sạp_,
   {{0x63a82648,0x7c24264c,0x869a09eb,0x2002025c}},	//   rodn, htir, _стат_, eski_,
   {{0x20020fd5,0x7c24264d,0xf6510332,0x5a9b02b5}},	//   fski_, ktir, _کئے_, רשטא,
   {{0x6d4402c7,0x63a8003a,0x7afe264e,0x644b264f}},	//   ddia, podn, kapt, _grgi,
   {{0x60d6006c,0x6d440c73,0x29d70069,0x7c242650}},	//   _egym, edia, _għaw_, dtir,
   {{0x41e60a9b,0x7afe1162,0xf1ca01a5,0xdb1c0037}},	//   _استف, dapt, _tạp_, _ghré,
   {{0x161902cb,0xd011096a,0x7c240093,0x6d442637}},	//   नंतर_, _قلب_, ftir, gdia,
   {{0xe5200354,0x68e20051,0x7c2408dd,0xfe7000b5}},	// [1d30] _यानि_, dcod, gtir, ودہ_,
   {{0x69c01889,0x636d2651,0xda7b010b,0x68e22652}},	//   _ahme, _púni, ляе_, ecod,
   {{0x6d442653,0x7a350037,0x7bc52654,0xce590f8c}},	//   bdia, تفاص, rmhu, _танц_,
   {{0x69c000ac,0xac192655,0x68e22656,0x7c2400af}},	//   _chme, _кому_, gcod, btir,
   {{0x7afe2657,0x7c242658,0xe8f82659,0xa3b822c7}},	//   bapt, ctir, слі_, चता_,
   {{0xd7c81ee1,0x7afe265a,0x442f265b,0x636d265c}},	//   مونه_, capt, _rpg_, _túni,
   {{0x443d265d,0x00000000,0x00000000,0x00000000}},	//   _ssw_, --, --, --,
   {{0x2409265e,0x68e2027a,0x443d0036,0x442f0090}},	//   ании_, ccod, _psw_, _ppg_,
   {{0x75ca004e,0xdced0c99,0x00000000,0x00000000}},	//   _języ, jkač, --, --,
   {{0x657b000e,0x02050036,0x644b0009,0xb80e0066}},	//   shuh, озон, _vrgi, _सितम_,
   {{0x2002006a,0xcb1202da,0x6444160b,0x68fb00d7}},	//   wski_, ולי_, _šiit, _keud,
   {{0x200210ec,0x68fb02e1,0x443d006f,0xa4f70a86}},	//   tski_, _jeud, _tsw_, _اکثر_,
   {{0x443d01ae,0xbee500a1,0x7afe0a21,0x68fb00f1}},	//   _usw_, कडून_, yapt, _meud,
   {{0x68fb01a6,0xdb1c0037,0x9474126b,0x65be0031}},	//   _leud, _thré, _عدنا, rëhe,
   {{0xfc3f1166,0x6449265f,0xdce400cd,0x00000000}},	//   _así_, lvei, nkić, --,
   {{0x20020fd5,0x68fb0393,0x7c242660,0x291f006f}},	//   pski_, _neud, ttir, _ncua_,
   {{0xab662661,0x236710e5,0x64492662,0x2b43023a}},	// [1d40] овал, _konj_, nvei, _bajc_,
   {{0x6d442663,0x2fd700d1,0x2b4300fe,0x75e70225}},	//   sdia, _گوید_, _cajc_, _kızd,
   {{0x7c242664,0x68e20223,0xdce40c99,0x68fb2665}},	//   stir, tcod, jkić, _beud,
   {{0x671c007c,0x68fb00f1,0x7afe2666,0x23670107}},	//   _नाहक_, _ceud, sapt, _lonj_,
   {{0x68fb2667,0xa2c90026,0x68ed0b4c,0x183600ad}},	//   _deud, हेत्, ñada, تراح,
   {{0x68e22668,0x69d82669,0xbb560037,0x291f081b}},	//   scod, íves, _بنسب, _ecua_,
   {{0x7afc00af,0xd95a03fa,0x6996002d,0x6281201d}},	//   _iert, _краљ_, _драх, jzlo,
   {{0x1dbf0355,0x69dc09c5,0x8ebf0033,0x2578266a}},	//   ्षयत, _iure, _আলমগ, _béla_,
   {{0x7afc266b,0x69dc266c,0x6603006d,0x00000000}},	//   _kert, _hure, asnk, --,
   {{0x69dc266d,0x3946266e,0x7afc266f,0x68fb01d7}},	//   _kure, ldos_, _jert, _zeud,
   {{0xc4e617f9,0x39460138,0x6ab800b4,0x39442670}},	//   _джей, odos_, _अरोर, _kams_,
   {{0x69dc2671,0x442400d7,0x7afc01a3,0x39462672}},	//   _mure, ptm_, _lert, ndos_,
   {{0x39462673,0x43462674,0x81ba0083,0x8496006c}},	//   idos_, _медв, _অংশ_, _بجائ,
   {{0x69dc2675,0x25a92676,0x6738022f,0x7afc2677}},	//   _oure, čale_, nevj, _nert,
   {{0xccfb03fa,0xa3de0026,0xdced00cd,0xed8b01f2}},	//   ића_, _दूत_, skač, асак_,
   {{0x7afc2678,0x394400ea,0xfc3f1dab,0x1b150831}},	//   _aert, _nams_, _psí_, ড়ছে_,
   {{0x7afc2679,0x213901f4,0x0bd5004f,0xdcef00af}},	// [1d50] _bert, mesh_, سياح, _alcă,
   {{0x69dc267a,0x2019267b,0x7afc1691,0x394603e6}},	//   _bure, musi_, _cert, edos_,
   {{0x2019267c,0x7afc267d,0xea0001a5,0x3944012f}},	//   lusi_, _dert, _đảo_, _bams_,
   {{0x69dc267e,0xe9d801c8,0x2139267f,0x777a01d7}},	//   _dure, ікі_, nesh_, _altx,
   {{0x69dc2680,0x66e50e02,0x20190a09,0xe72e2681}},	//   _eure, пола, nusi_, не_,
   {{0x39460aca,0x7afc0291,0x213900da,0xe7392682}},	//   ados_, _gert, hesh_, сек_,
   {{0xf7700d82,0x69dc06a2,0x7c3901d6,0x7bdd2683}},	//   خان_, _gure, şarı, _husu,
   {{0x20192684,0x7afc2685,0x21390031,0x7e9c0070}},	//   kusi_, _zert, jesh_, יסוו,
   {{0x20192686,0x7bdd2687,0x69dc2688,0x75292689}},	//   jusi_, _jusu, _zure, rfez,
   {{0x6449268a,0x2571008a,0x7ae5268b,0x69dc268c}},	//   rvei, _máli_, ncht, _yure,
   {{0xcb120779,0x6449268d,0x7ae50014,0xa91d00d8}},	//   עלט_, svei, icht, _amži,
   {{0x291d08e1,0x241900c3,0x2019268e,0x7bd51297}},	//   ngwa_, _годы_, fusi_, _lizu,
   {{0x2019246d,0x7bdd268f,0x316901a3,0xfbbd09b4}},	//   gusi_, _nusu, _doaz_, ्गाम,
   {{0xdb1c0211,0x7bd52690,0x636d0079,0x98bf00d5}},	//   _chrì, _nizu, _cúnt, _nauč_,
   {{0xe2962691,0xed5a10fe,0x272f06d3,0x636d0037}},	//   _наш_, бов_, mını_, _dúnt,
   {{0x7afc2692,0x20192693,0xa0a60f9e,0x7bdd073a}},	//   _sert, busi_, _найд, _busu,
   {{0x7afc2694,0x7bdd0395,0xdca32695,0x7bd52696}},	// [1d60] _pert, _cusu, еати, _bizu,
   {{0xef8607f5,0x272f037a,0x316901b7,0x257100fe}},	//   _хлоп, nını_, _zoaz_, _dáli_,
   {{0x7afc0ddf,0x69dc2697,0x19ba2698,0x7bd506a2}},	//   _vert, _qure, будь_, _dizu,
   {{0x7ae50514,0x7afc2699,0x3946010b,0xada611d0}},	//   acht, _wert, udos_, _хамл,
   {{0x7afc1201,0x2d920010,0x25ad1516,0x7bdd0010}},	//   _tert, miye_, doel_, _gusu,
   {{0x6d46269a,0x272f01d6,0x2d92269b,0x4cbb0122}},	//   _haka, jını_, liye_, _לזכו,
   {{0x6d46269c,0xfaa31fba,0xe80e0324,0x272f04d4}},	//   _kaka, _заро, _सिवा_, dını_,
   {{0x6d46269d,0x7ec70332,0x2d92269e,0x7bd5269f}},	//   _jaka, lépé, niye_, _zizu,
   {{0x6d460c40,0x7bdd0be2,0x66180187,0xb4c800b4}},	//   _maka, _xusu, suvk, ोखे_,
   {{0x6d4626a0,0x201926a1,0xa87b00a5,0x2d920908}},	//   _laka, vusi_, _האמר, hiye_,
   {{0x213900da,0x2d920232,0x0cb909b1,0x25ad26a2}},	//   tesh_, kiye_, _आर्म, boel_,
   {{0x6d4626a3,0x201926a4,0x63640107,0x25ad00e0}},	//   _naka, tusi_, _jònz, coel_,
   {{0x2d9201d6,0x213901f4,0x272f045e,0xbbdb000c}},	//   diye_, resh_, bını_, _बढेक,
   {{0x201926a5,0x7bdd26a6,0x6d4608dd,0x1be30066}},	//   rusi_, _rusu, _aaka, _कंबल_,
   {{0x6d4626a7,0x201926a8,0x7bdd26a9,0x213900da}},	//   _baka, susi_, _susu, pesh_,
   {{0x6d4626aa,0x2d920232,0xf1a401c8,0xe3b80644}},	//   _caka, giye_, _прын, llı_,
   {{0x6d4626ab,0xea000028,0x7ae526ac,0x071c1404}},	// [1d70] _daka, _đạo_, tcht, _नांव_,
   {{0xe3b806a8,0xad2700fd,0x7ae501ae,0x6d4600be}},	//   nlı_, _کردو, ucht, _eaka,
   {{0x6d4626ad,0x7bd526ae,0x68ed0f56,0x7ae501ae}},	//   _faka, _vizu, ñado, rcht,
   {{0x7ae501ae,0xd2460ef2,0x64420086,0xe3b80716}},	//   scht, _ین_, _osoi, hlı_,
   {{0x442626af,0x25ad0136,0xe3b801d6,0xb9050324}},	//   _nqo_, voel_, klı_, _नल_,
   {{0x6d4626b0,0xe80e046c,0xe3b80448,0x00000000}},	//   _zaka, _सिरा_, jlı_, --,
   {{0x6d4626b1,0x25ad0fdb,0xda3400d8,0xe3b800a8}},	//   _yaka, toel_, _перы, dlı_,
   {{0x1dbf143a,0x2bbd0026,0x999809ce,0xa3de00b4}},	//   ्षित, ्गवा, _екст_, _दंश_,
   {{0xe3b80716,0x272f0463,0x290d26b2,0x637f0345}},	//   flı_, tını_, _idea_, _lêne,
   {{0x2d9226b3,0x27ed26b4,0x69cb26b5,0xd38900d4}},	//   ziye_, _iten_, lmge, ійне_,
   {{0x272f036a,0xda7a02b5,0x32050122,0x25ad0b88}},	//   rını_, ַנשר, usly_, poel_,
   {{0x272f06a8,0x7207006c,0x00000000,0x00000000}},	//   sını_, _ہفتہ_, --, --,
   {{0xe3ae0a93,0x6d4626b6,0xa01b0332,0x2d92027d}},	//   _аб_, _raka, szön, viye_,
   {{0xdb1c004f,0x2d920010,0x656b0211,0x753b26b7}},	//   _phrí, wiye_, _hogh, leuz,
   {{0x6d461aaf,0x59ad00c4,0xa2c90380,0x2d920010}},	//   _paka, टकार, हेश्, tiye_,
   {{0xed5705a1,0x656b26b8,0x27ed13d6,0x9f5900c3}},	//   мос_, _jogh, _oten_, essä_,
   {{0x6d4626b9,0x2d92070b,0x656b26ba,0x443f007a}},	// [1d80] _vaka, riye_, _mogh, nwu_,
   {{0x6d4626bb,0x25a018b0,0x656b26bc,0x2d9226bd}},	//   _waka, čili_, _logh, siye_,
   {{0x6d4626be,0x2d8026bf,0x637f26c0,0x443f046a}},	//   _taka, phie_, _gêne, hwu_,
   {{0xe3b8008f,0x443f26c1,0x656b0211,0x6d460027}},	//   zlı_, kwu_, _nogh, _uaka,
   {{0x7d0426c2,0xe3b806d0,0xd90d09b9,0x63760160}},	//   mais, ylı_, صیل_, _sânm,
   {{0x7d0426c3,0x752207e5,0x656b01da,0x69cb0298}},	//   lais, _scoz, _aogh, amge,
   {{0x27ed26c4,0x656b26c5,0xa3c326c6,0xa3c10d2a}},	//   _eten_, _bogh, ्षन_, ंतन_,
   {{0x7d0426c7,0x25780248,0x753b0054,0x656b05b9}},	//   nais, _vélo_, geuz, _cogh,
   {{0xe3b806d3,0x443f007a,0xa2d00864,0x656b0312}},	//   tlı_, gwu_, डेन्, _dogh,
   {{0x57c9021a,0x7d0426c8,0x636d0176,0x656b26c9}},	//   िगृह, hais, _búnq, _eogh,
   {{0x656b09e3,0xa3de0fd1,0x7d040d36,0xd5af2028}},	//   _fogh, _दूर_, kais, _ас_,
   {{0x7d0426ca,0xe3b80644,0xc5f3011d,0x2d9e006c}},	//   jais, slı_, _ידע_, étel_,
   {{0xe3b801fb,0x9f5900c3,0x637f0b88,0xdb1c009e}},	//   plı_, yssä_, _sêne, _ohrà,
   {{0xe3b80095,0x81bd0029,0xd2500dc0,0xd90400b5}},	//   qlı_, otēk, _منت_, _ھی_,
   {{0xdfd426cb,0xd9041aa6,0x656b0ac0,0x7d0426cc}},	//   торы, _پی_, _yogh, fais,
   {{0x7d0426cd,0x656b035f,0x00000000,0x00000000}},	//   gais, _xogh, --, --,
   {{0xfbdf26ce,0x79820118,0xdb1c00f1,0x3b5526cf}},	// [1d90] _quê_, dhow, _bhrà, нкар,
   {{0x31a4037a,0xa3c31fe0,0x60c026d0,0xdb1c01da}},	//   mıza_, ्षय_, ümme, _chrà,
   {{0xdb1c26d1,0x27ed26d2,0xc9150202,0x290d010d}},	//   _virð, _sten_, едећ, _pdea_,
   {{0x7d0426d3,0x00000000,0x00000000,0x00000000}},	//   cais, --, --, --,
   {{0x656b04d6,0x31a406d3,0xa3c30d00,0x69cb13ee}},	//   _rogh, nıza_, ्षम_, rmge,
   {{0x656b004f,0xf1ca01a5,0xdb1c00f1,0xf62501f5}},	//   _sogh, _dạy_, _ghrà, едко,
   {{0xd90f04e8,0x81bd0080,0xbbbd26d4,0x45d52351}},	//   _نیا_, rtēj, ्गीक, нцит,
   {{0x7982006a,0x443f0067,0x290d01ed,0x81bd0228}},	//   chow, twu_, _udea_, stēj,
   {{0x656b027a,0xfbdf0023,0x27ed02ce,0x753b26d5}},	//   _vogh, _trêu_, _uten_, reuz,
   {{0x2d8c000d,0xc8a800be,0x00000000,0x00000000}},	//   édez_, _छुटट, --, --,
   {{0x656b0037,0x68e400cb,0x032200d8,0x7d0426d6}},	//   _togh, žide, ыдэн, yais,
   {{0x92df0083,0x31a40225,0x00000000,0x00000000}},	//   তরে_, fıza_, --, --,
   {{0x7d0426d7,0x600702ce,0xa80602d7,0x00000000}},	//   vais, нням_, mañó, --,
   {{0xdb1c00ac,0x7d0426d8,0x00000000,0x00000000}},	//   _ohrá, wais, --, --,
   {{0x7d0426d9,0xa3ac0026,0xed5a1622,0xf7720317}},	//   tais, ककर_, пов_, נקל_,
   {{0x61ee05c9,0x7bc700be,0x5d67002d,0xdb1c0284}},	//   íble, _ahju, нисм_, _shrà,
   {{0x7d0426da,0xdee626db,0xc19b00a5,0xdb1c0211}},	// [1da0] rais, _попи, _משקי, _phrà,
   {{0x8fa60987,0x7d0426dc,0xd9ba1cce,0xdb1c0037}},	//   _سمجه, sais, ेष्ट, _bhrá,
   {{0xdb1c0076,0xe9da2171,0x7d0426dd,0x4efb00a5}},	//   _chrá, чке_, pais, _מהיו,
   {{0xfbdf0248,0x307a0070,0x2571008d,0x00000000}},	//   _prêt_, ּאַנ, _máls_, --,
   {{0xb8e80437,0x1dbf021a,0xdb1c00f1,0x00000000}},	//   _उर_, ्षरत, _thrà, --,
   {{0x38cb064e,0x60c40054,0xfc3f002a,0xdb1c0098}},	//   سانی_, _mzim, _uxía_, _fhrá,
   {{0xdb1c0079,0xe2870037,0x2b4a00fe,0x00000000}},	//   _ghrá, _إذ_, _iabc_, --,
   {{0x60c426de,0x00000000,0x00000000,0x00000000}},	//   _ozim, --, --, --,
   {{0x81e70083,0x60c426df,0x98a30fc5,0xd4970043}},	//   মীম_, _nzim, _бите, ерэ_,
   {{0xecc50084,0x290601ed,0x00000000,0x00000000}},	//   लेटफ, laoa_, --, --,
   {{0x60c426e0,0x6376021d,0x00000000,0x00000000}},	//   _azim, _jâni, --, --,
   {{0x4a9b02b5,0x3a38012f,0x546a01d3,0xc4860043}},	//   לייג, _mprp_, _наем_, _плек,
   {{0xc95302b8,0x257100b5,0x06d50033,0x741303fb}},	//   אמר_, _vált_, _স্পি, _مونا,
   {{0xa3c30567,0x60c40029,0x25a0008b,0x3dd90159}},	//   ्षण_, _dzim, čilu_, _sisw_,
   {{0x60c4018e,0x5e5800af,0x00000000,0x00000000}},	//   _ezim, ниря_, --, --,
   {{0x9f49021d,0x3eba0044,0x212f009e,0x00000000}},	//   _itaí_, _dypt_, _ùgh_, --,
   {{0x2ef50133,0xe80201c0,0xdb1c0098,0x321e0067}},	// [1db0] _изпр, रीमा_, _shrá, luty_,
   {{0xc5f60083,0x8aa71362,0x20190207,0x00000000}},	//   _ঘটনা_, нред, mrsi_, --,
   {{0xd5df0084,0x321e26e1,0xa3e70026,0x3f930069}},	//   _पूंज, nuty_, _मून_, _imxu_,
   {{0x3a38012f,0x27e60051,0x27e901ef,0x00000000}},	//   _dprp_, fqon_, íano_, --,
   {{0x6d5d26e2,0x200b0036,0x00000000,0x00000000}},	//   _insa, nsci_, --, --,
   {{0x7c2d01d2,0x6d4d03c4,0x394926e3,0xdb1c0037}},	//   mtar, ldaa, žas_, _thrá,
   {{0xfbdf0370,0xe7080125,0xcf580122,0xdb1c00ac}},	//   _três_, رتون_, תבות_, _uhrá,
   {{0x6d4d26e4,0x490416e6,0x99d406ca,0x7c2d26e5}},	//   ndaa, _موفق, _متقا, otar,
   {{0x200b26e6,0xd6db12b9,0x6d5d010d,0x628800a0}},	//   jsci_, _ете_, _mnsa, ezdo,
   {{0x7c2d26e7,0x6d4d02ec,0x69da26e8,0x00000000}},	//   itar, hdaa, _éter, --,
   {{0x7c2d26e9,0x69c901a9,0x6f07016f,0xdce60228}},	//   htar, _khee, dajc, _lokā,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6d4d01a8,0x656926ea,0x7c2d01f4,0x1b0c0083}},	//   ddaa, mjeh, jtar, স্টে_,
   {{0x6d5d26eb,0x6d4d26ec,0x425526ed,0x672300d7}},	//   _ansa, edaa, _атит, ngnj,
   {{0x7c2d26ee,0x201926ef,0x3f8107c0,0x637f00a2}},	//   etar, arsi_, _dlhu_, _gêna,
   {{0x656900da,0x69db26f0,0xe80200a1,0x6d4d190b}},	//   njeh, _niue, रीडा_, gdaa,
   {{0x60c426f1,0x7c2d26f2,0x1ae626f3,0x61e326f4}},	// [1dc0] _uzim, gtar, возм, _hunl,
   {{0x6d5d26f5,0xa3c10953,0x6d4d26f6,0x6f0726f7}},	//   _ensa, ंति_, adaa, cajc,
   {{0x442d26f8,0xbcfb1d2b,0x3f9826f9,0x7c2d26fa}},	//   hte_, _poét, miru_, atar,
   {{0x3f9826fb,0x69c926fc,0xa91d0097,0x63760183}},	//   liru_, _chee, _alžb, _vâni,
   {{0x442d0d66,0x69c901e8,0xa3c3017f,0x7c2d26fd}},	//   jte_, _dhee, ्षा_, ctar,
   {{0x3f98128f,0xf8a90088,0xa92501ba,0xbb7602fb}},	//   niru_, ردنه_, _rožň, _румъ,
   {{0x442d26fe,0xd6d50033,0xbf9b016b,0x00000000}},	//   ete_, _স্বয, ויסש, --,
   {{0x7bdc26ff,0x657b2700,0x3f9801a3,0xfaa32701}},	//   _hiru, gkuh, hiru_, _тасо,
   {{0x442d2702,0x7bdc2703,0x75e701d6,0x37e602ce}},	//   gte_, _kiru, _hızl, _розг,
   {{0x61e30d6f,0x75e701d6,0x2019022f,0x637f0132}},	//   _bunl, _kızl, vrsi_, _pêna,
   {{0x442d2704,0xf3630bbc,0xe5262705,0x7c2d1f8e}},	//   ate_, ртын, _адеп, ztar,
   {{0x442d2706,0x7c2d2707,0x29042708,0x7bdc2709}},	//   bte_, ytar, _jema_, _liru,
   {{0x442d270a,0x7c2d270b,0x29040054,0x3f8101e8}},	//   cte_, xtar, _mema_, _plhu_,
   {{0x7bdc08c6,0xe3af0312,0x3f98270c,0x61e30023}},	//   _niru, _ورو_, giru_, _funl,
   {{0xcddb0202,0x91e303fa,0x7c2d0035,0x25a6017b}},	//   дња_, _које, wtar, _kjol_,
   {{0x7c2d270d,0x2904270e,0x672d0254,0xdd1100a8}},	//   ttar, _nema_, đaji, _düşd,
   {{0x60990098,0x6d4d0244,0x69c9270f,0x7bdc2710}},	// [1dd0] _سندس_, rdaa, _rhee, _biru,
   {{0x09cb05f7,0xd9cb0e62,0x2d820d26,0x7bdc1417}},	//   िष्य, िष्ट, _elke_, _ciru,
   {{0x442d2711,0x7bdc2712,0x69c90189,0x6abc00e9}},	//   zte_, _diru, _phee, _cyrf,
   {{0x7c2d071f,0x6d5d0b04,0x6d4d0103,0x27e400e7}},	//   ptar, _unsa, qdaa, _bumn_,
   {{0x442d2713,0x7bdc2714,0xec3502b5,0xdc350070}},	//   xte_, _firu, _גאָר_, _גאָט_,
   {{0x442d024e,0xd7c80079,0x69c92715,0x7bdc2716}},	//   vte_, نونه_, _whee, _giru,
   {{0x69c9006f,0xc79400d1,0x442d2717,0x6abc001e}},	//   _thee, جشنب, wte_, _gyrf,
   {{0x2904022e,0x61e30176,0x69db009e,0x7bdc2718}},	//   _gema_, _runl, _uiue, _ziru,
   {{0x442d2719,0x77930164,0xf1bf0038,0xf770006c}},	//   ute_, _پیغا, dlá_, _ڈال_,
   {{0xf7700dc0,0x61e30cca,0x657b271a,0xe1f90374}},	//   _وال_, _punl, skuh, нго_,
   {{0x3f98271b,0x35f5271c,0x6569124d,0x29040453}},	//   viru_, _спер, pjeh, _yema_,
   {{0x2904002a,0x06d50033,0x00000000,0x00000000}},	//   _xema_, _স্থি, --, --,
   {{0x394d0297,0x442d01f4,0xdb150097,0xd0960aeb}},	//   _maes_, qte_, _ekzé, ушны,
   {{0x649a00c2,0x749a1899,0x61e30d92,0xe7c30761}},	//   _אינה, _אינפ, _tunl, षतिप,
   {{0xe1f11c04,0x2000271d,0x395f271e,0x61e308dd}},	//   _است_, _wwii_, _onus_, _uunl,
   {{0x0ce20083,0x3f9801a8,0x225801b4,0x7f9400a8}},	//   বর্ত, siru_, ærke_, _müqə,
   {{0x7bdc271f,0x29042720,0x3f980254,0xbcfb00a2}},	// [1de0] _piru, _rema_, piru_, _coéq,
   {{0xdd040dac,0x29042721,0x7bdc00d7,0x09dc0099}},	//   ısın, _sema_, _qiru, यद्य,
   {{0x7bdc2722,0x75e700a8,0x29042723,0x00000000}},	//   _viru, _qızl, _pema_, --,
   {{0xfe9b0319,0x394d014c,0x7bdc2724,0x27e40139}},	//   _טיימ, _caes_, _wiru, _pumn_,
   {{0x29040054,0x394d00ee,0x9f40009e,0xed572725}},	//   _vema_, _daes_, _stiù_, _соя_,
   {{0x7d062726,0xc3190083,0x29040054,0x6fb405e7}},	//   _heks, ত্তি_, _wema_, ंकिं,
   {{0x7d062727,0x394d00e9,0x637600af,0x00000000}},	//   _keks, _faes_, _mânt, --,
   {{0x78260082,0x5e5702b5,0x746a0086,0x81bd0029}},	//   _معطل, ריקע_, еров_, ntēt,
   {{0x4991026b,0x00000000,0x00000000,0x00000000}},	//   _بینر, --, --, --,
   {{0x7d060533,0x883b0122,0x25bf00af,0x316000fe}},	//   _leks, _אתמו, alul_, _aniz_,
   {{0x4ebf0083,0x877b016b,0x25a60298,0x65be0055}},	//   _আল্ল, _ראבי, _tjol_, hëhi,
   {{0x6fc001ff,0x00000000,0x00000000,0x00000000}},	//   böck, --, --, --,
   {{0x33f600af,0x63760139,0x637f021d,0x00000000}},	//   _счес, _bânt, _gêno, --,
   {{0x6376002d,0xf1bf0334,0x1b1a0033,0x00000000}},	//   _cânt, slá_, ন্তে_, --,
   {{0xa3c102cb,0x7d062728,0xa3c313f0,0x3da72729}},	//   ंतर_, _beks, ्षर_, граб,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xbcfb1111,0xd011132d,0x63760395,0xcb1b0279}},	// [1df0] _anéc, _بلخ_, _fânt, еќе_,
   {{0x7d060159,0x3dc008dd,0x395f21cc,0x00000000}},	//   _eeks, aliw_, _snus_, --,
   {{0xe8dd00b4,0x394d272a,0x7d0600fd,0x00000000}},	//   यश्च, _paes_, _feks, --,
   {{0x4dfa02b5,0x7d0612ba,0x49b80118,0xa907272b}},	//   _שפרא, _geks, هاند_, ابان,
   {{0x1b1a0033,0x6d4f0952,0x00000000,0x00000000}},	//   ন্ধে_, _iaca, --, --,
   {{0x7d0602c4,0xe739272c,0x25780118,0x07a503e6}},	//   _zeks, тек_, _mélu_, јакн,
   {{0x6d4f272d,0x25bf0043,0x7c3d01ed,0x27f808b7}},	//   _kaca, tlul_, _hpsr, _črne_,
   {{0x6d4f272e,0x1b1a0033,0x00000000,0x00000000}},	//   _jaca, ন্দে_, --, --,
   {{0x87272499,0x64a5010b,0x27f8024e,0x57270c26}},	//   _معام, рапа, čený_, _مراق,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x49b800b5,0x00000000,0x00000000,0x00000000}},	//   _شاہد_, --, --, --,
   {{0x249600bf,0x672d011c,0xe802073f,0xe296272f}},	//   انید_, đaju, रीवा_, раю_,
   {{0x764e008a,0x7d062730,0x63761e6d,0x00000000}},	//   _ábyr, _reks, _pânt, --,
   {{0x248d01e8,0x63760395,0x644b004b,0x00000000}},	//   mzem_, _dâns, _isgi, --,
   {{0x2d96010b,0x3ebe008a,0xe81c0084,0x7d062731}},	//   арас, ætt_, _निभा_, _peks,
   {{0x6d4f2732,0xa1930d6e,0x64590067,0x00000000}},	//   _caca, _мајч, _krwi, --,
   {{0x7d060044,0x81bd00ea,0x257800ee,0x6376021d}},	// [1e00] _veks, rtēt, _gélu_, _tânt,
   {{0x644b01ca,0x6d4f2733,0x2578008a,0xab63052a}},	//   _msgi, _eaca, _hélt_, овул,
   {{0x7d0603d0,0x6d4f0014,0x7c3d2734,0xeb9703fa}},	//   _teks, _faca, _epsr, јих_,
   {{0x6d4f25bf,0x2d89012f,0x323602b5,0x644b01ef}},	//   _gaca, chae_, יטען_, _osgi,
   {{0x6d442735,0x7c3d01ed,0x2d80034d,0xa01b00fd}},	//   meia, _gpsr, mkie_, szöv,
   {{0x6d4f2736,0x2d802737,0x6e3e012f,0x6d442738}},	//   _zaca, lkie_, _kppb, leia,
   {{0xfaa32739,0x7c24273a,0xeb970fdd,0x6d4f273b}},	//   _даро, luir, _тир_, _yaca,
   {{0x2d800626,0xdb070044,0x6d4f01ef,0x6d44273c}},	//   nkie_, _skjø, _xaca, neia,
   {{0xa3c301d1,0xb71600d1,0x69c200be,0xd3a60369}},	//   ्षं_, _نباش, mloe, ироп,
   {{0x443d012f,0x69c2001e,0x6e3e01e0,0x1c1e021a}},	//   _dpw_, lloe, _oppb, यूएल_,
   {{0x0cc300c0,0x672d0c21,0x2d800626,0xa69611b9}},	//   _शर्म, đajt, kkie_, _трај,
   {{0x7c240a66,0x765a01ef,0xa3e7046c,0xdb1c026e}},	//   kuir, _irty, _मूव_, _chrú,
   {{0x6d4f273d,0x6d44273e,0x248d0035,0x6e3e0282}},	//   _raca, deia, czem_, _appb,
   {{0xa3c3021a,0x7c24273f,0x8cb00006,0xdb05013c}},	//   ्षः_, duir, _अँजो, llhö,
   {{0x6d4f2740,0x8de80340,0x69c201a3,0xf20602fb}},	//   _paca, ифта_, kloe, _тяло,
   {{0x69c80080,0xdb1c0037,0xccf80274,0x6d442741}},	//   _ūden, _ghrú, ићу_, geia,
   {{0x44242742,0x65620076,0x69c300f7,0x5b152743}},	// [1e10] num_, _mnoh, înem, ймат,
   {{0x25a92744,0x6d4f2745,0x2d9b0055,0x69c20118}},	//   čali_, _waca, siqe_, eloe,
   {{0x6d4f0082,0x442403be,0x69c2099e,0x5a352746}},	//   _taca, hum_, floe, снет,
   {{0x44242747,0x2d802748,0x7c242749,0x79a4274a}},	//   kum_, ckie_, buir, орче,
   {{0x4424274b,0x765a006a,0x7d0d274c,0xbcfb0037}},	//   jum_, _arty, maas, _gnéa,
   {{0x4424274d,0xbb850514,0x7d0d274e,0xf745274f}},	//   dum_, _السي, laas, секо,
   {{0x69c22750,0x443d0223,0x7f3c016b,0x00000000}},	//   bloe, _spw_, דעוו, --,
   {{0x7d0d2751,0x442400fb,0xa01b01ae,0x248d0310}},	//   naas, fum_, nzös, tzem_,
   {{0x44242752,0xe3b92753,0x80d9021a,0x00000000}},	//   gum_, лби_, नेमे, --,
   {{0xd7740082,0x7d0d023f,0x248d2754,0x2d802755}},	//   _والع, haas, rzem_, zkie_,
   {{0x7d0d2756,0x248d1f11,0xdb1c0284,0x29d70024}},	//   kaas, szem_, _chrù, _bħax_,
   {{0x44240fe4,0x7d0d018e,0xdb1c0211,0x0f2000b4}},	//   bum_, jaas, _dhrù, बल्स_,
   {{0x44242757,0x55520332,0x645d01b4,0x645901d5}},	//   cum_, _رپور, æsid, _urwi,
   {{0xa02700fb,0x644900e9,0x7d0d018d,0x00000000}},	//   _stöð, mwei, eaas, --,
   {{0x51f517bd,0x64492758,0x7d0d2759,0xdb1c009e}},	//   _استر, lwei, faas, _ghrù,
   {{0x7d0d275a,0x7529275b,0x7c24275c,0x29d7003c}},	//   gaas, ngez, tuir, _għax_,
   {{0x644902c9,0x69c202e6,0x2d8003bc,0x3b86275d}},	// [1e20] nwei, vloe, rkie_, благ,
   {{0x2d80275e,0x7c24275f,0x4f2603fe,0xcb0a01cb}},	//   skie_, ruir, _удоб, ايان_,
   {{0x644902c9,0x44242760,0x7d0d2761,0x6e3e2762}},	//   hwei, zum_, baas, _uppb,
   {{0x44242763,0x7d0d0103,0xa91d00ee,0x645500ea}},	//   yum_, caas, _dlžo, āzij,
   {{0xe80b0299,0x7c241f74,0xa3e70d55,0x44242764}},	//   _सौदा_, quir, _मूल_, xum_,
   {{0x44242765,0x6449001e,0x9f400176,0x3e58007e}},	//   vum_, dwei, _juià_, _kčt_,
   {{0x44242766,0x69c22069,0x7529033b,0xd5ba0227}},	//   wum_, ploe, fgez, лси_,
   {{0x75292767,0x6449033b,0x9f8400c3,0x3e5802d0}},	//   ggez, fwei, löä_, _mčt_,
   {{0x644912e1,0x3f9a012f,0x39462768,0x81ae0033}},	//   gwei, _ompu_, meos_, কতা_,
   {{0x442408ee,0xf3662769,0x394607a6,0xa3e700a1}},	//   rum_, стин, leos_, _मूळ_,
   {{0x4424276a,0x7d0d001c,0xb7d7017e,0x3e580359}},	//   sum_, yaas, _اولا_, _nčt_,
   {{0x7982004e,0x44240093,0x3946276b,0x65620086}},	//   nkow, pum_, neos_, _unoh,
   {{0x54330357,0x7d0d276c,0x00000000,0x00000000}},	//   _فرور, vaas, --, --,
   {{0x7d0d276d,0x3e580359,0xdb1c0211,0x00000000}},	//   waas, _bčt_, _thrù, --,
   {{0x63ba0e7d,0x7d0d276e,0x7a1c002d,0xdb1c0260}},	//   motn, taas, nătă, _ikrè,
   {{0x63ba008b,0x71a40431,0xdb1701dd,0xdd9400c7}},	//   lotn, _најз, moxé, пасы,
   {{0x7d0d276f,0x79820035,0x2d580086,0xdb1701ef}},	// [1e30] raas, dkow, щить_, loxé,
   {{0x7d0d2761,0x5b1515d6,0x3e5802e9,0x63ba00d5}},	//   saas, імет, _fčt_, notn,
   {{0x27f802c6,0x39461111,0x7d0d00c3,0x6449033b}},	//   _črna_, feos_, paas, zwei,
   {{0x41c905fc,0xf1c909a8,0x63ba024e,0x61ea028b}},	//   रतिस, रतिन, hotn, _mufl,
   {{0x18692770,0x63ba2771,0x00000000,0x00000000}},	//   рали_, kotn, --, --,
   {{0x36190086,0xa09c0070,0xb09c016b,0x60cd023c}},	//   ацию_, ניגט, ניגר, _mzam,
   {{0x752901e4,0x39460300,0x994d00a0,0xf1c90099}},	//   tgez, beos_, môžu_, रतान,
   {{0xe5790ef3,0x64492772,0x39462773,0xdb1c23e2}},	//   рзи_, twei, ceos_, _akrè,
   {{0x290f2774,0xe1010083,0x61ea01ae,0x75292775}},	//   maga_, ্লাহ_, _aufl, rgez,
   {{0x290f2776,0x64492777,0x75292778,0x61ea0069}},	//   laga_, rwei, sgez, _bufl,
   {{0x64491fb3,0x76ab2779,0x60cd277a,0x7989277b}},	//   swei, _став_, _azam, _klew,
   {{0x290f19d4,0x98a4035f,0x61ea00f6,0x00000000}},	//   naga_, _qamħ_, _dufl, --,
   {{0x2bbe0567,0x637f00e2,0x799b001c,0x79890024}},	//   ्तमा, _lêni, _mmuw, _mlew,
   {{0x290f277c,0x3e8a00d8,0x7989016e,0x56b50070}},	//   haga_, айго_, _llew, ַפּן_,
   {{0xdee3277d,0x290f277e,0xe2960036,0x7989277f}},	//   дори, kaga_, _маш_, _olew,
   {{0xa0a62780,0x290f2781,0x7242006c,0xb4f90070}},	//   _майд, jaga_, _کھیل, שפּי,
   {{0x290f2782,0xada30183,0x9f8400c3,0xbcfb00a2}},	// [1e40] daga_, фатл, töä_, _inél,
   {{0x76410022,0x61e418af,0x3e5802d0,0x3f9a012f}},	//   _oply, _hiil, _tčt_, _umpu_,
   {{0x7982006a,0xe81c0302,0xfce61c80,0x8a060210}},	//   tkow, _निहा_, _моно, ізде,
   {{0xed5a2783,0x290f0010,0x5f460357,0x08c62784}},	//   _том_, gaga_, _انگل, обен,
   {{0x79822785,0x39461bea,0x764101ef,0x61e41986}},	//   rkow, reos_, _aply, _miil,
   {{0x39460b4c,0x7982004e,0x395200d8,0x79892786}},	//   seos_, skow, žys_, _elew,
   {{0x63ba031d,0x39460caa,0x290f050f,0x637f0132}},	//   votn, peos_, baga_, _gêni,
   {{0x6d562787,0x61e400c3,0x290f04fb,0x63ba0035}},	//   ndya, _niil, caga_, wotn,
   {{0x98a32788,0x7c36038d,0x61ea0043,0x60c42789}},	//   _жите, ntyr, _sufl, _nyim,
   {{0xd37a0432,0x61e4009e,0xdb170042,0x61ea0160}},	//   рчи_, _aiil, toxé, _pufl,
   {{0x63ba278a,0x60cd278b,0x326600d4,0x60c401a8}},	//   rotn, _szam, ітов, _ayim,
   {{0x63ba278c,0x60c404fb,0xdb170042,0x52ba021a}},	//   sotn, _byim, roxé, _उडीस,
   {{0x9f490279,0x63ba008b,0x1b110033,0x60c404fb}},	//   _itaú_, potn, ালতে_, _cyim,
   {{0x290f0010,0x60cd008b,0x644206fe,0x9294002d}},	//   zaga_, _vzam, _ipoi, _налц,
   {{0xdd9b278d,0x290f050f,0x3f830093,0x61e4278e}},	//   аша_, yaga_, rkju_, _fiil,
   {{0xf1a4002d,0x1b0400c8,0x3f831057,0x61e41b82}},	//   _орын, _লাগে_, skju_, _giil,
   {{0x6ebb0c57,0x60cd278f,0x290f2790,0x637f0132}},	// [1e50] _शुरु, _uzam, vaga_, _sêni,
   {{0x69c02791,0x290f2792,0xddeb00f8,0x637f0132}},	//   _akme, waga_, _پرده_, _pêni,
   {{0xdced039a,0xdb070093,0x290f2793,0xfc3f00cc}},	//   ljač, _skjó, taga_, _axít_,
   {{0xe81c0026,0x637f021d,0x00000000,0x00000000}},	//   _निशा_, _vêni, --, --,
   {{0x290f2794,0x64460095,0xdced0bc6,0xa80400d8}},	//   raga_, çkil, njač, дзіл,
   {{0x290f2795,0x637f0279,0x69c0027d,0x20091982}},	//   saga_, _têni, _ekme, _mwai_,
   {{0x64420bb0,0xf96b2796,0x290f2797,0x00000000}},	//   _apoi, _край_, paga_, --,
   {{0xe795064e,0x2bd9021a,0x764101ba,0x64420037}},	//   _کارک, भगवा, _vply, _bpoi,
   {{0xdced0254,0x68e90024,0x00000000,0x00000000}},	//   jjač, _iged, --, --,
   {{0x61e4005b,0x69d90067,0xdced00cd,0x6442021d}},	//   _siil, lmwe, djač, _dpoi,
   {{0x4b7c00c2,0x76410187,0x61e40196,0x2bbe2798}},	//   יאזו, _uply, _piil, ्तता,
   {{0xe8020632,0x644f01b4,0x7c360031,0x27ed00e0}},	//   रीका_, æcis, ytyr, _kuen_,
   {{0x64420159,0x61e42799,0xe5c4010b,0x27ed01ed}},	//   _gpoi, _viil, _ўсхо, _juen_,
   {{0x61e4081b,0x2d8b0036,0xdce400cd,0x00000000}},	//   _wiil, _alce_, ljić, --,
   {{0x63a1279a,0x257100ac,0x61e40421,0x68e9030d}},	//   miln, _sály_, _tiil, _oged,
   {{0x753b279b,0x68e900d1,0x63a1279c,0xdce4011c}},	//   nfuz, _nged, liln, njić,
   {{0x27ed06a2,0x8c43279d,0x27f8008b,0x8b2600d8}},	// [1e60] _nuen_, нете, _črno_, здзе,
   {{0xe7ef0084,0x7c36279e,0x63a10693,0xcd3613cf}},	//   _चढ़ा_, rtyr, niln, _کردب,
   {{0x7c36279f,0x6ac60037,0x5eda0033,0x290d023a}},	//   styr, أقام, _ব্রে, _beea_,
   {{0x27ed0083,0x290d0012,0x7e61054e,0xb4ea052f}},	//   _buen_, _ceea_, ælpe, _मले_,
   {{0x7d0427a0,0xa3cb0f19,0x63a127a1,0x2bbe0d34}},	//   mbis, लता_, kiln, ्तदा,
   {{0x27ed0291,0x26c5000c,0x80d90083,0x69d927a2}},	//   _duen_, _bylo_, ভুক্, amwe,
   {{0x63a127a3,0x68ed00b8,0xaa432725,0x27ed01ed}},	//   diln, žada, _перл, _euen_,
   {{0x7f8b0095,0xb60801c0,0x7d041a25,0xe944103b}},	//   _müqa, jišť, nbis, _ترسی,
   {{0xdb051111,0xbcfb00a0,0x7d0427a4,0x27ed27a5}},	//   cohó, _poéz, ibis, _guen_,
   {{0xfbbe142a,0x63a127a6,0x57fb0122,0x7d0407d4}},	//   ्तिम, giln, _ללמו, hbis,
   {{0x27ed03cb,0x200908c7,0x00000000,0x00000000}},	//   _zuen_, _swai_, --, --,
   {{0x27ed00d7,0x7c2427a7,0xdcef0160,0x63a10211}},	//   _yuen_, krir, _mocă, ailn,
   {{0x63a127a8,0xfbbe00b8,0x533400c3,0x7d040254}},	//   biln, ्ताम, _желт, dbis,
   {{0x63a127a9,0x7c2407e7,0xdced080a,0x00000000}},	//   ciln, drir, rjač, --,
   {{0x433b0122,0xe3b30070,0x777a27aa,0x26c500d5}},	//   _העוב, _אױס_, _motx, _xylo_,
   {{0x7c2427ab,0x7d042487,0x5bc5007e,0xbbc506fe}},	//   frir, gbis, वत्व, वत्क,
   {{0xb606011c,0x00000000,0x00000000,0x00000000}},	// [1e70] lošć, --, --, --,
   {{0x3b5427ac,0x4424066a,0xeb9b27ad,0x2fc700cc}},	//   нкур, irm_, حضرت_, _óng_,
   {{0xdd95005f,0x7d0427ae,0x7c24027a,0xb6060254}},	//   _жаны, bbis, arir, nošć,
   {{0xdb1c0079,0x442400ac,0xf1bf0183,0x00000000}},	//   _bhró, krm_, noá_, --,
   {{0x27ed27af,0xdb171a71,0xa7b90009,0x7c2400f7}},	//   _quen_, loxí, олду_, crir,
   {{0x777a12c3,0x3dc927b0,0xb6060124,0xf77107f6}},	//   _cotx, llaw_, košć, ضات_,
   {{0x63a1068b,0x7d0f00b5,0x777a01ed,0xb60600f4}},	//   viln, _kecs, _dotx, jošć,
   {{0x3dc9010d,0x63a10035,0x497500d8,0x68e90b3e}},	//   nlaw_, wiln, _ўлас, _uged,
   {{0x63a127b1,0xd7c800e0,0x69c300f7,0x47350036}},	//   tiln, _کوله_, îneu, _онас,
   {{0x645b217b,0x7d0411a2,0x7d0f00fd,0x00000000}},	//   rvui, zbis, _lecs, --,
   {{0x63a1008b,0x3dc90dc3,0x3ce601ba,0xa91d18b0}},	//   riln, klaw_, ľovi_, _alži,
   {{0xa0a60200,0x7c240093,0x7d0f0160,0x628127b2}},	//   дамд, yrir, _necs, rylo,
   {{0x63a127b3,0x3dc902b3,0xbcfb01ba,0x31b900ac}},	//   piln, dlaw_, _inéh, nézy_,
   {{0x7c2427b4,0x637f021d,0xf8ab00e2,0xb60600f4}},	//   vrir, _cênt, _đời_, bošć,
   {{0xafe30036,0x25ad27b5,0x02d100b4,0x7d0f27b6}},	//   торл, onel_, _हरिभ, _becs,
   {{0x25ad27b7,0x7c240055,0x7f8b013b,0x637f0183}},	//   nnel_, trir, _vüqa, _vênu,
   {{0x7d0427b8,0xdca327b9,0x629c00a0,0x7c2427ba}},	// [1e80] rbis, вати, úrov, urir,
   {{0x25bf0260,0x7c2406a2,0x637f021d,0xdcef0139}},	//   houl_, rrir, _tênu, _pocă,
   {{0xdb1c0284,0x3dc900e9,0x00000000,0x00000000}},	//   _bhrò, blaw_, --, --,
   {{0x7c2427bb,0xdb1c111f,0x3dc927bc,0xda650037}},	//   prir, _phró, claw_, عالي,
   {{0xb8f627bd,0xdb1c0211,0x6c0300af,0x777a0065}},	//   _हर_, _dhrò, _изяз, _potx,
   {{0xdcef0160,0x00000000,0x00000000,0x00000000}},	//   _tocă, --, --, --,
   {{0x9f8d008a,0x6b8e0069,0x00000000,0x00000000}},	//   nþá_, _ilbg, --, --,
   {{0x2bbe0569,0xb606011c,0xdb1c0284,0xbf0a0099}},	//   ्तवा, vošć, _ghrò, वरुन_,
   {{0x2906002f,0x777a0392,0x00000000,0x00000000}},	//   mboa_, _totx, --, --,
   {{0xb60600cd,0x2b5827be,0xa87b024b,0x42740421}},	//   tošć, _jarc_, _ואמר, егос,
   {{0x2b5827bf,0xa2c10af9,0x3218024e,0x25bf27c0}},	//   _marc_, _रुद्, éry_, boul_,
   {{0xe4a6174b,0xb606042a,0xc48600d4,0x5a170070}},	//   _орло, rošć, _олек, וקטן_,
   {{0xa3e72088,0xc05812ea,0xbf0a00a1,0x2d920027}},	//   _मंच_, мір_, वरून_, dhye_,
   {{0x0efb00dc,0x2b580fc2,0x3dc9010d,0xb6060124}},	//   ्रेस_, _narc_, wlaw_, pošć,
   {{0x3ceb27c1,0x9e34027a,0x5e5800af,0xf1bf0183}},	//   _pgcv_, керч, миря_, poá_,
   {{0x3dc9011e,0x637f0345,0xdb17002a,0xcdd80274}},	//   ulaw_, _fêns, roxí, дњу_,
   {{0x7d0227c2,0x7d0f27c3,0x2b58016e,0x3dc927c4}},	// [1e90] ñosa, _vecs, _barc_, rlaw_,
   {{0xdb1c01da,0xf4000831,0x00000000,0x00000000}},	//   _shrò, _এটার_, --, --,
   {{0xb50e0066,0x7d0f27c5,0xdb1c01a6,0x00000000}},	//   सराय_, _tecs, _phrò, --,
   {{0x645c00ea,0x25f227c6,0x00000000,0x00000000}},	//   ārij, ँदनी_, --, --,
   {{0x68ed024e,0x6cfa011d,0x201900c3,0x00000000}},	//   žado, _מפרס, nssi_, --,
   {{0x237c042a,0x7c2d27c7,0x00000000,0x00000000}},	//   _novj_, muar, --, --,
   {{0x7c2d27c8,0x2bbe20a3,0x7ac40202,0xfbbe00b8}},	//   luar, ्तरा, _асте, ्तरम,
   {{0x29060176,0xc8670382,0x00000000,0x00000000}},	//   cboa_, _отзи, --, --,
   {{0x38341837,0x25bf00af,0x68fb0027,0x25ad27c9}},	//   _интр, roul_, _ifud, rnel_,
   {{0x25ad27ca,0x69cb27cb,0xe2990274,0x27ff01a3}},	//   snel_, llge, зао_, _itun_,
   {{0x25ad27cc,0x7c2d27cd,0x00000000,0x00000000}},	//   pnel_, huar, --, --,
   {{0x7c2d27ce,0xa3cf0fbf,0x00000000,0x00000000}},	//   kuar, _वीर_, --, --,
   {{0x656b27cf,0xbcfb004f,0x80c80083,0xdb1c27d0}},	//   _ingh, _gnéi, রেন্, _skrí,
   {{0xdb1e00da,0x7c2d27d1,0x6d4d0159,0x442d27d2}},	//   ropë, duar, eeaa, mue_,
   {{0x442d27d3,0x2019027a,0x68fb030d,0x3c430228}},	//   lue_, assi_, _ofud, hīvā_,
   {{0x7c2d0079,0x6d4d0051,0x68fb073a,0x52740079}},	//   fuar, geaa, _nfud, _جاهز,
   {{0x2b5827d4,0x7c2d27d5,0x6aa8035d,0x442d0e15}},	// [1ea0] _parc_, guar, कप्र, nue_,
   {{0x2d920232,0xa3c100c0,0x68fb001c,0x291f023c}},	//   shye_, ूति_, _afud, _adua_,
   {{0x3ea60268,0xa9261108,0x27ff27d6,0x656b009e}},	//   _чинг, едел, _atun_, _ongh,
   {{0x442d27d7,0xb17b013c,0x7c2d27d8,0x00000000}},	//   kue_, rmåg, buar, --,
   {{0xc7c6110a,0xe80b009a,0x7d1627d9,0xa3c104bc}},	//   нски, सीला_, mays, ूता_,
   {{0x7d1627da,0x442d27db,0x656b27dc,0x290608cb}},	//   lays, due_, _angh, sboa_,
   {{0x442d27dd,0xbbbe0e61,0x00000000,0x00000000}},	//   eue_, ्तीक, --, --,
   {{0x7d160dc3,0x09e327de,0x7aee0051,0x442d27df}},	//   nays, _босн, _hgbt, fue_,
   {{0x442d27e0,0x39440282,0x00000000,0x00000000}},	//   gue_, _ibms_, --, --,
   {{0x7d160159,0x969609eb,0x656b001e,0x21200260}},	//   hays, _преш, _engh, _adih_,
   {{0x7d1627e1,0xd5af0036,0x7c2d27e2,0xbcfb000d}},	//   kays, _бс_, zuar, _inév,
   {{0x6e2e27e3,0xbbbe00b8,0xdce6021e,0x9c8700d5}},	//   dubb, ्तुक, _ankč, ničí,
   {{0x7d160381,0x442d27e4,0x7c2d27e5,0xf1a4010b}},	//   days, cue_, xuar, урэн,
   {{0x20190196,0xa3cb020c,0x7c2d27e6,0x00000000}},	//   rssi_, लतः_, vuar, --,
   {{0x656b0297,0x6f1527e7,0x6e2e27e8,0x5d6727e9}},	//   _yngh, razc, gubb, нтаз,
   {{0x7c22003c,0x7c2d27ea,0x40950037,0x00000000}},	//   ġorn, tuar, _للبر, --,
   {{0xb81c1556,0x6d4d07bd,0x00000000,0x00000000}},	// [1eb0] _निगम_, reaa, --, --,
   {{0x6e2e029d,0x7c2d1f30,0x3df527eb,0x7648008c}},	//   bubb, ruar, _изос, _opdy,
   {{0x442d06a2,0x6d4d0303,0x7dfc021e,0x00000000}},	//   zue_, peaa, _pčse, --,
   {{0x3c4300ea,0x7c2d27ec,0xfd1f0036,0xa91d008b}},	//   tīvā_, puar, _udì_, _možg,
   {{0x7c2d27ed,0xe10c02b5,0x442d27ee,0x8d8400af}},	//   quar, פּאָ, xue_, _суэд,
   {{0x442d27ef,0xb6a5081b,0xa3cf0035,0x3944010d}},	//   vue_, килл, _वीं_, _ebms_,
   {{0xead400c3,0x00000000,0x00000000,0x00000000}},	//   _борь, --, --, --,
   {{0x442d27f0,0x0565081e,0xa2c10edf,0x00000000}},	//   tue_, твин, _रुष्, --,
   {{0xe4320037,0x160d00ab,0x00000000,0x00000000}},	//   لفيد, _सबकर_, --, --,
   {{0x442d27f1,0x394f27f2,0xe1f90210,0x260e0099}},	//   rue_, legs_, мго_, णीही_,
   {{0x442d0122,0x2000002d,0x36750037,0xfbd200a5}},	//   sue_, _stii_, _جهاز, שתי_,
   {{0xdb1e27f3,0x656b27f4,0x0f0a02b4,0x00000000}},	//   ropé, _ungh, वर्स_, --,
   {{0x442d27f5,0x8edf00c8,0x2120023a,0x00000000}},	//   que_, _ব্লগ, _vdih_, --,
   {{0x7d160088,0xdb1c00ac,0x00000000,0x00000000}},	//   ways, _okrá, --, --,
   {{0x7d020b06,0x6da60923,0x7d161505,0x22470065}},	//   ñoso, вива, tays, _upnk_,
   {{0x12e802b5,0x320500a5,0xdd9227f6,0x00000000}},	//   _אַפּ, mply_, جور_, --,
   {{0xa91d01cc,0x2bf627f7,0x7d16034d,0x6721022f}},	// [1ec0] _možd, тябр, rays, _odlj,
   {{0x6e2e27f8,0x7d1627f9,0xaf0a0037,0x8c4327fa}},	//   pubb, says, _تقدم_, рефе,
   {{0x7d1600a2,0x00000000,0x00000000,0x00000000}},	//   pays, --, --, --,
   {{0x637e0355,0xdb1701ef,0x00000000,0x00000000}},	//   _záně, roxá, --, --,
   {{0xe947006c,0x25780168,0x00000000,0x00000000}},	//   ئرمی, _gély_, --, --,
   {{0xe81307b5,0x00000000,0x00000000,0x00000000}},	//   _डबरा_, --, --, --,
   {{0x6ae00083,0x98b2027d,0x00000000,0x00000000}},	//   _প্রো, ıyı_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdb1c00b8,0x00000000,0x00000000,0x00000000}},	//   _zkrá, --, --, --,
   {{0xf36627fb,0x27f900e0,0xa91d27fc,0x00000000}},	//   ттин, _ésna_, _požg, --,
   {{0xd625183b,0x79801857,0x00000000,0x00000000}},	//   _معني, _komw, --, --,
   {{0x316d0922,0xfbdf00e9,0x00000000,0x00000000}},	//   ñez_, _apêl_, --, --,
   {{0x60d60067,0x94760079,0x00000000,0x00000000}},	//   _czym, _جداا, --, --,
   {{0x547b0122,0x9f52021e,0x6d4627fd,0x32661403}},	//   _קטגו, _juyè_, _abka, _атив,
   {{0x63a80312,0x2bec00b4,0xdb060355,0x236e034d}},	//   midn, _अंजू_, ámýc, _infj_,
   {{0xa91d0187,0x7bc727fe,0x7e650009,0x62881019}},	//   _kože, _skju, _vrhp, mydo,
   {{0xdb1c27ff,0x62882800,0xa91d2801,0xfbd90214}},	// [1ed0] _skrá, lydo, _jože, едај_,
   {{0xa91d2802,0x4ea71999,0x61ed2803,0x8f5502ce}},	//   _može, _арма, _hial, _свої,
   {{0x61ed2804,0x75220926,0x7980099e,0x00000000}},	//   _kial, _odoz, _bomw, --,
   {{0x60cd01a8,0xafdb08c8,0xdb1c00d5,0x629a0065}},	//   _kyam, stød, _vkrá, izto,
   {{0xa3c202cb,0xa91d264f,0x6d5d0a32,0x61ed2805}},	//   ंवा_, _nože, _iasa, _mial,
   {{0x6d5d2806,0x75222807,0x61ed2808,0x60cd0371}},	//   _hasa, _adoz, _lial, _myam,
   {{0x6d5d2809,0xe5a5280a,0x27ec0122,0x3f8100b8}},	//   _kasa, лики, _didn_, _mohu_,
   {{0x61ed09c3,0x6d5d280b,0xa91d063c,0xe4590ece}},	//   _nial, _jasa, _bože, ежи_,
   {{0x6d5d280c,0x60cd280d,0xa91d01f2,0x69c9010d}},	//   _masa, _nyam, _vožd, _ikee,
   {{0x6d5d280e,0x2bd90b47,0x752206a2,0x490b000c}},	//   _lasa, _बीमा, _edoz, ारको_,
   {{0x61ed280f,0x60cd018e,0x7980030d,0x60d62810}},	//   _bial, _ayam, _yomw, _szym,
   {{0x6d5d2811,0x60cd2107,0x3cef00ab,0x6389055c}},	//   _nasa, _byam, _अलगे_, _bênê,
   {{0x44292812,0x343902b5,0x7bc52813,0x3f810097}},	//   _ía_, _נײַע, kohu, _bohu_,
   {{0x94740071,0x6d5d2814,0x443f2815,0x64592816}},	//   _خدما, _aasa, mtu_, _iswi,
   {{0x6d5d0483,0x61ed2817,0xa2ca0cf1,0xc2c503ec}},	//   _basa, _fial, _सुप्, _حيثي,
   {{0x5bbe0099,0x61ed2818,0x69c9006f,0xed572819}},	//   ्त्व, _gial, _nkee, лос_,
   {{0x443f18f9,0x6d5d1b0f,0x644b281a,0xbcfb0176}},	// [1ee0] ntu_, _dasa, _jpgi, _anés,
   {{0x443f281b,0x6d5d04e6,0xa09b0070,0x69c9281c}},	//   itu_, _easa, _נייט, _akee,
   {{0x443f281d,0x6da6049f,0x69db0037,0xee3700af}},	//   htu_, _бина, _bhue, _йнэ_,
   {{0x69db02d7,0x6d5d281e,0x644b08c8,0x27ec0223}},	//   _chue, _gasa, _opgi, _sidn_,
   {{0xa2ca111b,0x443f281f,0xbcfb0138,0x657b00be}},	//   _सुन्, jtu_, _enés, djuh,
   {{0x6d5d088d,0xdb1c01b4,0x7c2b2820,0xfbb82821}},	//   _zasa, _skræ, ágre, _आदिम,
   {{0x6d5d2822,0x63a80528,0xbb3b02b5,0xb8eb0d53}},	//   _yasa, vidn, _רעלי, _रु_,
   {{0x6d5d0510,0xa91d00cb,0x7df5010b,0x2bbe035d}},	//   _xasa, _pože, _sąsk, ्तका,
   {{0x61ed0514,0x7bdc2823,0x20e3112b,0x63a8013c}},	//   _rial, _khru, _गणेश_, tidn,
   {{0xa91d082d,0x61ed2824,0x2d822825,0x7f5e01ef}},	//   _vože, _sial, _loke_, _napq,
   {{0x61ed0464,0x60cd0ac8,0x443f2826,0x63a82827}},	//   _pial, _syam, atu_, ridn,
   {{0x62881826,0x3f812828,0x7bc5002f,0x98a400a8}},	//   rydo, _sohu_, zohu, _hamı_,
   {{0x6d5d2829,0x629a282a,0x61ed282b,0x7bc50054}},	//   _rasa, szto, _vial, yohu,
   {{0x6d5d282c,0x60cd000e,0xa91d023a,0x98a90067}},	//   _sasa, _vyam, _kožc, żać_,
   {{0xcddb282d,0x6d44282e,0x2d82282f,0x12fb00a5}},	//   ења_, ffia, _boke_, _אהוב,
   {{0x6d5d003c,0x2d582830,0x645900e9,0x5d5503e6}},	//   _qasa, лись_, _yswi, јкат,
   {{0x6d5d2831,0x5b152832,0x7bdc0094,0x7bc51e61}},	// [1ef0] _vasa, имат, _bhru, tohu,
   {{0x6d5d2833,0x7bdc2834,0x9d150083,0x69c92835}},	//   _wasa, _chru, িলেন_, _skee,
   {{0x6d5d2836,0x443f0291,0x7bdc006b,0xaa551a33}},	//   _tasa, ztu_, _dhru, рвеш,
   {{0x6d5d09c3,0xbcfb1bea,0x25fb05e7,0x6440017b}},	//   _uasa, _enér, _लंबी_, ktmi,
   {{0x443f024e,0xb8fd0c57,0x998700b5,0x7c87002d}},	//   xtu_, _डर_, énő_, _суне,
   {{0x7d0d2837,0x8ae71112,0x7bdc09c3,0x321e0035}},	//   lbas, _бібл, _ghru, ksty_,
   {{0x7d0d01ed,0x01d60033,0xdb05191b,0x61fc01ef}},	//   obas, _সংসদ, rnhä, írll,
   {{0x443f2838,0x14252839,0x7c2d283a,0x7bdc0314}},	//   ttu_, адим, orar, _zhru,
   {{0x99840082,0x443f283b,0x765a00e9,0xa2ca0edf}},	//   _القو, utu_, _esty, _सुब्,
   {{0x395f283c,0x443f283d,0x25a6283e,0x657b03a6}},	//   _haus_, rtu_, _emol_, sjuh,
   {{0x395f283f,0x65952840,0xe10a1e46,0x7d0d108c}},	//   _kaus_, _кажу, кенд_, kbas,
   {{0x443f2841,0x9f4900fb,0x7c2d2842,0x29350070}},	//   ptu_, _stað_, krar, סאָן_,
   {{0x395f2843,0x7d0d0f0a,0x2d82008b,0x6459002f}},	//   _maus_, dbas, _roke_, _uswi,
   {{0x395f0189,0xa2e52844,0x765a0297,0x442d2845}},	//   _laus_, _колд, _ysty, mre_,
   {{0xeab000c8,0xdee62846,0xa3c202cb,0x7c2d01d7}},	//   _কর্ম, рови, ंवर_, erar,
   {{0x7bdc2847,0x442d01d3,0x7d0d2848,0x395f2849}},	//   _shru, ore_, gbas, _naus_,
   {{0x442d284a,0x7c2d284b,0x6d44284c,0x6db7011c}},	// [1f00] nre_, grar, rfia, pćan,
   {{0x442d284d,0x3160284e,0x7d0d01a8,0x8b2601e0}},	//   ire_, _haiz_, abas, рдже,
   {{0x442d284f,0x7d0d2850,0x7c2d1de4,0x2d8201f4}},	//   hre_, bbas, arar, _toke_,
   {{0xd9461c80,0x395f2851,0x442d1fbb,0x7c2d2852}},	//   реди, _caus_, kre_, brar,
   {{0x395f0221,0x7c2d0043,0x442d01b4,0x31602853}},	//   _daus_, crar, jre_, _maiz_,
   {{0x442d1b99,0xa50e02e4,0x0eba0324,0x7df52854}},	//   dre_, सर्च_, _उखाड, _sąsi,
   {{0xd5ba010c,0x395f0221,0xe8fa0043,0x660303e6}},	//   кси_, _faus_, _алб_, опја,
   {{0x442d2855,0x6f1c2856,0x316006a2,0x8574027a}},	//   fre_, harc, _naiz_, слих,
   {{0x57ea2857,0x442d03d0,0x6fc600a1,0x765a0067}},	//   _адам_, gre_, लकां, _wsty,
   {{0x07a31400,0x46a601d3,0x395f0189,0x883b00a5}},	//   _даун, _казв, _zaus_, _בתמו,
   {{0x64402858,0x321e06fe,0x6f1c2859,0xaf370609}},	//   stmi, usty_, darc, یرست,
   {{0x442d285a,0x6f17285b,0x044607c1,0x395f006f}},	//   bre_, _sexc, _ведн, _xaus_,
   {{0x442d15f9,0x6f1c285c,0x2fc70023,0xdcef00ea}},	//   cre_, farc, _ưng_, ādīt,
   {{0x7c2d285d,0x533300af,0xa91d285e,0xa2c1035d}},	//   vrar, _дешт, _moža, _रुक्,
   {{0x31600716,0x7d0d285f,0xbe882860,0x22570911}},	//   _faiz_, tbas, асте_, _نجيب_,
   {{0xdd982861,0x527b0d85,0x00000000,0x00000000}},	//   ашу_, _ינוא, --, --,
   {{0x7d0d2862,0xdce600d8,0x395f2863,0x7c2d2864}},	// [1f10] rbas, _mokė, _raus_, urar,
   {{0x7c2d0065,0x6f1c2865,0x395f2866,0x7d0d2867}},	//   rrar, carc, _saus_, sbas,
   {{0x395f2868,0x7d0d0801,0x2bbe2869,0x442d00b5}},	//   _paus_, pbas, ्तजा, zre_,
   {{0x442d286a,0xa91d10ec,0x395f006d,0x7c2d286b}},	//   yre_, _boža, _qaus_, prar,
   {{0x395f006d,0x4dda00a5,0x67d503e6,0x9f400392}},	//   _vaus_, _תחרו, боду, _guió_,
   {{0x442d286c,0xa91d00ac,0x6747010b,0x61f80107}},	//   vre_, _doža, рэдз, _ouvl,
   {{0xa6c9247f,0x395f006f,0x361800d8,0x442d0103}},	//   ылка_, _taus_, ацыю_, wre_,
   {{0xa2c100a1,0x6f1c286d,0xa3cf00a1,0x91fc013a}},	//   _रुग्, zarc, _वीज_, tvān,
   {{0x442d286e,0x7f8b01c2,0x291d0269,0x2bbe14ab}},	//   ure_, _hüqu, mawa_, ्तचा,
   {{0x442d03d0,0x291d00a7,0x316002c2,0x61f800cd}},	//   rre_, lawa_, _saiz_, _buvl,
   {{0x442d006c,0x6f1c286f,0xa2ca00a1,0xe6b30609}},	//   sre_, varc, _सुद्, _بلاگ,
   {{0x442d2870,0x291d2871,0x568c02b5,0xd00a2872}},	//   pre_, nawa_, _שטאַ, леме_,
   {{0x6ad4046c,0x7dfc0359,0xa4d401e0,0x00000000}},	//   _थर्र, _pčso, _доці, --,
   {{0x291d2873,0xe8192874,0xafe6110a,0xdb1e1da9}},	//   hawa_, नीया_, согл, kopá,
   {{0x291d2875,0xe3b00088,0x2d96037c,0xc7d600a5}},	//   kawa_, _غره_, брас, מושי_,
   {{0x6da32876,0x6f1c2877,0x291d2878,0xdb1e0097}},	//   писа, sarc, jawa_, dopá,
   {{0x6f1c2879,0x291d287a,0x249f1f20,0xdd8f0037}},	// [1f20] parc, dawa_, nzum_, روك_,
   {{0xc91023e3,0xa3dd0127,0x7c2b01ef,0x3b18007a}},	//   ार्म_, _थीम_, ágra, _qerq_,
   {{0x25ad287b,0xdb07006c,0xa91d02a7,0x00000000}},	//   kiel_, ámár, _soža, --,
   {{0x291d287c,0xa91d06fe,0x3866287d,0x38cb0df3}},	//   gawa_, _poža, tvor_, گامی_,
   {{0x25ad016f,0x3946287e,0x6d56287f,0xb5fc035f}},	//   diel_, rfos_, meya, _irġi,
   {{0x6d562880,0x9b960037,0xaa0800b5,0xbb860037}},	//   leya, _الست, _نعرے_, _الآي,
   {{0x25ad0261,0x291d2881,0xf09f0036,0xdb1c07c0}},	//   fiel_, bawa_, zzà_, _okrú,
   {{0xd9430272,0x2d800298,0x25ad2882,0xa91d023a}},	//   _неси, njie_, giel_, _toža,
   {{0x76432883,0xf8dc007c,0x61f8011c,0x09e3027a}},	//   atny, _बरिय, _suvl, _хотн,
   {{0x5c5b02b5,0x388e0029,0x6d562884,0x00000000}},	//   נדיק, _vērā_, heya, --,
   {{0xa91d0e6a,0x25ad0c7c,0xcb130397,0x6d56027c}},	//   _možn, biel_, הלת_, keya,
   {{0x25ad2885,0xa91d00b8,0x7df5010b,0x00000000}},	//   ciel_, _ložn, _mąst, --,
   {{0x2d800173,0x6d5600f8,0x23e60823,0x7df500c7}},	//   djie_, deya, _лікв, _ląst,
   {{0x291d006a,0xdbf101c0,0xa91d2886,0x92940dee}},	//   zawa_, _příl, _nožn, _малц,
   {{0x65620d6c,0x291d2887,0xfdc40084,0x04b700b5}},	//   _kaoh, yawa_, वकूफ, _نھیں_,
   {{0x6d562888,0x2d800031,0xe3b80510,0x00000000}},	//   geya, gjie_, lnı_, --,
   {{0x2129046a,0xe7ba06fe,0x4dd40037,0x65622889}},	// [1f30] _idah_, ेवाप, ستفس, _maoh,
   {{0xdea403c5,0x291d288a,0xe3b8242d,0x25ad288b}},	//   _کیفی, wawa_, nnı_, ziel_,
   {{0x291d288c,0x9f8400ab,0xcae30084,0x6d56288d}},	//   tawa_, töö_, केंड_, beya,
   {{0x6ab90907,0x291d0054,0xe3b800a8,0xd7f100cc}},	//   _आशीर, uawa_, hnı_, _sĩ_,
   {{0xf7701c0c,0x291d288e,0xa2ca0ebd,0x25ad288f}},	//   کان_, rawa_, _सुस्, viel_,
   {{0x291d2890,0x25ad19c1,0x776100a8,0xdb150260}},	//   sawa_, wiel_, _qalx, _ekzò,
   {{0x25ad0c43,0x291d2891,0x1995010b,0x66e20036}},	//   tiel_, pawa_, _давя, моша,
   {{0x5589002d,0xdff900b4,0x7d1f0055,0x6562055c}},	//   рбим_, ंदाद_, naqs, _caoh,
   {{0x25ad2892,0x2ed62893,0x76432894,0xb17b2895}},	//   riel_, _धर्त, stny, rmål,
   {{0x2129046a,0x42252896,0x25ad2897,0x249f2898}},	//   _adah_, одов, siel_, rzum_,
   {{0x80d100c8,0x6d562899,0x25ad289a,0x2009289b}},	//   সেম্, yeya, piel_, _atai_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x6d56289c,0x10a300af,0x00000000,0x00000000}},	//   veya, диян, --, --,
   {{0x2d990176,0xaab919b7,0x6d56289d,0x753b01b7}},	//   _alse_, _आशंक, weya, lguz,
   {{0x59c90567,0x2d800626,0xa91d0a3c,0x6d56289e}},	//   िकार, tjie_, _rožn, teya,
   {{0x753b289f,0xef240069,0x00000000,0x00000000}},	//   nguz, _biżà_, --, --,
   {{0x8c431da6,0x6d5628a0,0x3b8628a1,0xae1a0066}},	// [1f40] мете, reya, олаг, _फौरन_,
   {{0xa91d28a2,0x2d9900a5,0x6d5628a3,0x09d20099}},	//   _božo, _else_, seya, तत्य,
   {{0xe8fa28a4,0xa91d02dd,0x6d5628a5,0x69cb28a6}},	//   але_, _vožn, peya, foge,
   {{0x69cb038d,0xf1ca112b,0xfd120037,0x7d1f00a8}},	//   goge, रविन, _تجد_, caqs,
   {{0x386d2314,0x7d0428a7,0xa91d08b7,0xbcfb0118}},	//   _crer_, mcis, _tožn, _kaén,
   {{0x7c24184f,0x7d0428a8,0x394d008c,0x81c20831}},	//   msir, lcis, _ebes_, ্গি_,
   {{0x69cb28a9,0x41ca035d,0x7c2425ea,0x29000453}},	//   boge, रवास, lsir, ñias_,
   {{0x69cb28aa,0x7d0407d6,0x386d0107,0x0d970070}},	//   coge, ncis, _frer_, ַכים_,
   {{0x7c240b56,0xc31e0083,0xdb1e01b4,0x7d0428ab}},	//   nsir, _দাবি_, ropæ, icis,
   {{0x926a28ac,0x779200bf,0x7c2428ad,0x2bbf022e}},	//   арма_, _زیبا, isir, ्वया,
   {{0xe3b828ae,0x200928af,0x7dfc0260,0x8afb0070}},	//   rnı_, _stai_, _dčsk, יליז,
   {{0x96330eb9,0xa19412ea,0x3f9a00ec,0x7d040207}},	//   _ініц, даюч, _alpu_, jcis,
   {{0x78a228b0,0x48b80083,0x5064021d,0x2bbf035d}},	//   nzov, _জরুর, мтра, ्वमा,
   {{0x69cb02c9,0x09b728b1,0xc05800d4,0x7d0400ea}},	//   zoge, _अद्य, цію_, ecis,
   {{0x69cb0273,0x21291d2b,0x442628b2,0xddab002d}},	//   yoge, _tdah_, _hvo_, атал_,
   {{0x7c2428b3,0x212900e7,0x442604e0,0x752008c7}},	//   fsir, _udah_, _kvo_, namz,
   {{0x44260009,0x7c241b82,0x69cb28b4,0x1b1f0033}},	// [1f50] _jvo_, gsir, voge, _পাবে_,
   {{0x09b3134b,0x63ba01ae,0x69cb01a8,0x78a201ba}},	//   ंच्य, nntn, woge, dzov,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x44260537,0x7d040036,0x7c2428b5,0xceb2016b}},	//   _ovo_, ccis, bsir, _טיי_,
   {{0x1869174b,0x7d1d28b6,0x6c790070,0x442628b7}},	//   сали_, _iess, _האָפ, _nvo_,
   {{0x7d1d28b8,0x69cb28b9,0xbdf80df3,0x80c80033}},	//   _hess, soge, _دریا_, রেক্,
   {{0x44261eb8,0x29dc28ba,0x69cb28bb,0xa2ca28bc}},	//   _avo_, mían_, poge, _सुल्,
   {{0xc48502f3,0x29dc28bd,0xf1c00097,0x44260051}},	//   злик, lían_, čák_, _bvo_,
   {{0x7d1d28be,0x93790037,0x442428bf,0xe3b128c0}},	//   _mess, مصدر_, gsm_, فرد_,
   {{0xf8ae0a86,0x29dc28c1,0x798902e6,0xf7700037}},	//   _حکم_, nían_, _hoew, _لام_,
   {{0x442628c2,0x799b28c3,0x216a210e,0x798928c4}},	//   _evo_, _kluw, бини_, _koew,
   {{0x7d1d17e3,0x85040312,0x44260069,0xbcfb00f8}},	//   _ness, _قومن, _fvo_, _saén,
   {{0xb4fa0122,0x764b010b,0x92b5042c,0x798928c5}},	//   _הפני, žnyč, تحکا, _moew,
   {{0x7c2403d0,0x2245011e,0x6dac027d,0x7d1d00fe}},	//   vsir, ptlk_, rşam, _aess,
   {{0x7d1d02c9,0x29dc0caa,0x78a200ac,0x6d4f0211}},	//   _bess, dían_, zzov, _bbca,
   {{0x7d1d1d84,0x7c2428c6,0xb88300b8,0x6d4f0176}},	//   _cess, tsir, _klíč, _cbca,
   {{0x7d1d28c7,0x7d0428c8,0xe31900e2,0x212228c9}},	// [1f60] _dess, rcis, _điể, makh_,
   {{0x6d4f0176,0xa01b0086,0x29dc0453,0x799b28ca}},	//   _ebca, pyör, gían_, _aluw,
   {{0x4efb0052,0x61e41c26,0x7c2428cb,0xc3320122}},	//   _להיו, _khil, ssir, תוב_,
   {{0xe9d20312,0xd7fa28cc,0x7c2428cd,0x00000000}},	//   رغا_, бук_, psir, --,
   {{0x29dc0f56,0x61e409c3,0x799b01cb,0x79890118}},	//   bían_, _mhil, _dluw, _doew,
   {{0xc7a309ea,0x29dc0f56,0x78a228ce,0x07a328cf}},	//   ничк, cían_, rzov, начн,
   {{0x4426064b,0xdb1e01ae,0x7d1d25e8,0x4e7a0070}},	//   _svo_, ropä, _yess, מאַצ,
   {{0x2abb0122,0x44260df4,0x79890b88,0x00000000}},	//   _המלא, _pvo_, _goew, --,
   {{0x3a3a003c,0xa5070274,0x752002ff,0x3cfd00b4}},	//   lupp_, чења_, ramz, लखते_,
   {{0xe44f0082,0x6f1e0506,0x44260345,0x00000000}},	//   اضي_, _nepc, _vvo_, --,
   {{0x61e409c3,0x44241585,0x2bbf1856,0xaabe178c}},	//   _bhil, ssm_, ्वता, ्थिक,
   {{0x61e428d0,0x44260093,0xc10800af,0xb88300fe}},	//   _chil, _tvo_, зэре_, _flíč,
   {{0x7d1d28d1,0xa91d28d2,0x6ab90d00,0x61e428d3}},	//   _ress, _božj, _आश्र, _dhil,
   {{0x7d1d28d4,0x6f1e023a,0x29dc0042,0x4abe01d1}},	//   _sess, _cepc, xían_, ्थाव,
   {{0x7d1d28d5,0x29dc2675,0xd3e50e3a,0x61e4009d}},	//   _pess, vían_, _تقوی, _fhil,
   {{0x61e428d6,0xbcfb0042,0xdcef00ec,0x9f5300f6}},	//   _ghil, _gaél, _ancā, _mixé_,
   {{0xa3d0045c,0x29dc27c2,0x6c5428d7,0x6ecd0517}},	// [1f70] वकप_, tían_, нкту, _दुरु,
   {{0x69c0022f,0x798928d8,0x799b1ebb,0x00000000}},	//   _ajme, _soew, _sluw, --,
   {{0x29dc116c,0x7d1d28d9,0xbb84004f,0x799b011e}},	//   rían_, _tess, علمي, _pluw,
   {{0x20e1022e,0x00000000,0x00000000,0x00000000}},	//   _नराध, --, --, --,
   {{0xa3cc238a,0xa3c10099,0x7a05005f,0x00000000}},	//   लवा_, ्कम_, _dėta, --,
   {{0x2d8b28da,0x21220118,0x79890118,0x00000000}},	//   _hoce_, zakh_, _woew, --,
   {{0x6b83008a,0x798928db,0xb8f428dc,0x29dc002a}},	//   öngu, _toew, _सु_, cíao_,
   {{0x6d4d06df,0x24090421,0xa2ad0fbf,0xa91d023a}},	//   nfaa, онии_, ुपस्, _možk,
   {{0xd4691c36,0x68fb0409,0x00000000,0x00000000}},	//   ципе_, _igud, --, --,
   {{0x61e4000e,0x69d901ae,0x9f5300f7,0x2d8b01ef}},	//   _shil, llwe, _fixé_, _loce_,
   {{0x61e428dd,0x0cba021a,0x00000000,0x00000000}},	//   _phil, _इश्म, --, --,
   {{0x67230ac8,0x2d8b28de,0x6f1e0139,0x00000000}},	//   lanj, _noce_, _sepc, --,
   {{0xfbbf0ac4,0x27ff00be,0x291f0310,0x81c20033}},	//   ्वाम, _juun_, _meua_, ্গল_,
   {{0x656928df,0x82350a86,0x61e40052,0xe29928e0}},	//   ldeh, _قربا, _whil, _мал_,
   {{0x61e401a6,0x2d8b003a,0x6d4d0855,0x29dc01ef}},	//   _thil, _boce_, ffaa, xíao_,
   {{0x672328e1,0x656928e2,0x291f01e8,0x68fb00f8}},	//   hanj, ndeh, _neua_, _ngud,
   {{0x644928e3,0x6723108a,0x2d8b28e4,0xbfc612e8}},	// [1f80] ntei, kanj, _doce_, _обик,
   {{0x67230528,0xd9b804cc,0x6d4d073a,0x2b430183}},	//   janj, ेक्ट, afaa, _ccjc_,
   {{0x67230496,0x6da6021d,0x644928e5,0x236702c6}},	//   danj, _жина, htei, _manj_,
   {{0x3a3a28e6,0x2d8b28e7,0xdce401f2,0x20000118}},	//   rupp_, _goce_, ldič, _kuii_,
   {{0x260300c8,0xdcb903ad,0xc7c60dbf,0xdb0e008a}},	//   _año_, _ещё_, мски, þjón,
   {{0x672318b0,0x31bb0b40,0xdce428e8,0x656928e9}},	//   ganj, _उद्ध, ndič, edeh,
   {{0xc34e0019,0x6e3c0138,0x45d428ea,0x2a35002d}},	//   _bổng_, nurb, нокс, _пэтр,
   {{0xc34e01a5,0x644928eb,0xe8190026,0x68fb28ec}},	//   _cổng_, ftei, _नौका_, _ggud,
   {{0x67230c4f,0x29e80095,0x13f401af,0x39440279}},	//   banj, _uşaq_, нзия, _icms_,
   {{0x672328ed,0x6e3c28ee,0x27e5009e,0xdb050225}},	//   canj, kurb, _ghln_, rihç,
   {{0xa2941958,0x644928ef,0x777a01a3,0xdb0e0c6f}},	//   хані, atei, _intx, _ambë,
   {{0x644928f0,0x20000103,0x6e3c008d,0x14af0099}},	//   btei, _buii_, durb, _जेवण,
   {{0x14e20ac4,0x2d8b000c,0x644928f1,0x7afc00cb}},	//   _परिण, _roce_, ctei, _ogrt,
   {{0x61ee016f,0x2000009e,0x6e3c0f00,0x00000000}},	//   _ďale, _duii_, furb, --,
   {{0x2bbf2177,0xfbbf0266,0xdb0e01f7,0x6e3c008d}},	//   ्वसा, ्वसम, _imbè, gurb,
   {{0x67230496,0xa2ad000c,0x236728f2,0x7d1603bc}},	//   zanj, ुपर्, _zanj_, gbys,
   {{0x2d8b28f3,0xf1bf024e,0x67230186,0x2000009e}},	// [1f90] _voce_, mná_, yanj, _guii_,
   {{0xf1bf033a,0x291f0443,0x23a00260,0xa3e40b54}},	//   lná_, _seua_, _fòje_, _भीम_,
   {{0x672302dd,0x6e3c28f4,0x644928f5,0xdb1c0097}},	//   vanj, curb, ztei, _ukrý,
   {{0xf1bf28f6,0x672328f7,0x777a01d7,0xa91d07e7}},	//   nná_, wanj, _antx, _koži,
   {{0x67230537,0xa91d02a7,0x64491097,0xdb0e00e0}},	//   tanj, _joži, xtei, _ombè,
   {{0xa3dd004e,0xf771004f,0x06b00033,0x23dd0066}},	//   _थीं_, طات_, _ছড়ি, _नींद,
   {{0x6723022e,0x92c20083,0xa91d00ac,0xe91900d4}},	//   ranj, ্ধু_, _loži, _нові_,
   {{0x644928f8,0x67230bc6,0xf1bf053d,0xdb0e0118}},	//   ttei, sanj, jná_, _ambè,
   {{0xf1bf05d3,0xa91d28f9,0x756800b5,0x2367003d}},	//   dná_, _noži, بینہ_, _panj_,
   {{0x437428fa,0x656902b1,0x00000000,0x00000000}},	//   вуют, sdeh, --, --,
   {{0xc34e00e8,0xfbd20122,0xb3450279,0x23670116}},	//   _tổng_, רתי_, _acçã, _vanj_,
   {{0xa91d05e2,0x569428fb,0x644928fc,0x672128fd}},	//   _boži, _шахт, ptei, _helj,
   {{0x25bf0043,0x02cf0066,0x660128fe,0x7e6501f4}},	//   mnul_, _सुरभ, _hulk, _ashp,
   {{0xa91d1851,0x395d28ff,0x66012900,0x2d8f19ee}},	//   _doži, hews_, _kulk, ögen_,
   {{0x660103ad,0xf1bf024e,0xe2992901,0x25bf00af}},	//   _julk, bná_, _хай_, onul_,
   {{0xf1bf0187,0xdd9214ac,0xdb0e2902,0xd9c90edf}},	//   cná_, دور_, _imbé, िकोट,
   {{0xdca308bb,0x7d162903,0x45da0070,0x7f5c0c6f}},	// [1fa0] гати, rbys, פֿלא, perq,
   {{0xa3c10953,0x67210d4c,0xf4010083,0x7d160297}},	//   ्कि_, _nelj, _এবার_, sbys,
   {{0x1b1f0083,0xdb1c0035,0x25bf0d5c,0xab680069}},	//   _পাশে_, _skró, knul_, _reżħ,
   {{0x6da601e0,0xd826083e,0xaa570079,0x00000000}},	//   _чима, едди, علنا_, --,
   {{0x1b1f00c8,0xa3c100db,0x67212904,0x660101a3}},	//   _পারে_, ्का_, _belj, _aulk,
   {{0x672102c6,0xf1bf2905,0xd7ef004f,0xe6662123}},	//   _celj, zná_, مكن_, етио,
   {{0xd2cf0084,0x67212906,0x2bbf0ac4,0x66010260}},	//   _सुलझ, _delj, ्वरा, _culk,
   {{0xa2ca2907,0x66012908,0x25bf2909,0xa967290a}},	//   _सुग्, _dulk, gnul_, _писа_,
   {{0x6d460526,0xf1bf290b,0xe73a0370,0x672100b5}},	//   _mcka, vná_, _неа_, _felj,
   {{0xc4530082,0xa91d0a65,0x25bf00af,0x777a0065}},	//   اضيع, _roži, anul_, _untx,
   {{0xf1bf0076,0x36360e3a,0x28b60066,0xe7370390}},	//   tná_, _سراس, _आइडि, _чех_,
   {{0x672117ee,0xa91d290c,0xf48401cb,0x00000000}},	//   _zelj, _poži, _لاتی, --,
   {{0x55770779,0xf1bf0076,0x6601290d,0x0cc40033}},	//   _רעדן_, rná_, _zulk, ্ধুত,
   {{0xf1bf024e,0xe47b1899,0x5334290e,0x6d460051}},	//   sná_, _מרדכ, _рект, _acka,
   {{0xf1bf024e,0x00000000,0x00000000,0x00000000}},	//   pná_, --, --, --,
   {{0x13d500c8,0x2bd900b4,0xcdd803fa,0xa3e40380}},	//   _হওয়, _बीजा, ењу_, _भीत_,
   {{0x41c421a0,0x2bbf112b,0xe7e301c0,0x00000000}},	// [1fb0] _حقيق, ्वला, गतमा_, --,
   {{0x7522021d,0x6d46290f,0x09c905f8,0x00000000}},	//   _leoz, _ecka, िक्य, --,
   {{0x67212910,0x75e50453,0x00000000,0x00000000}},	//   _relj, nózc, --, --,
   {{0xc9841150,0xdd1600a0,0x98b906e4,0x00000000}},	//   лучи, _päťd, млет_, --,
   {{0x66012911,0x67212912,0xa3d001c0,0xf7451403}},	//   _sulk, _pelj, वका_, вело,
   {{0x6d5f06c4,0x66012913,0xec360277,0x00000000}},	//   leqa, _pulk, _באשר_, --,
   {{0x67212914,0xbbbf0967,0x0cc40033,0x19ab2915}},	//   _velj, ्वीक, ্ধৃত, _етап_,
   {{0x6d5f0510,0xc65400e0,0x00000000,0x00000000}},	//   neqa, افيک, --, --,
   {{0x67212916,0x9f530955,0x57f515ae,0x25bf0043}},	//   _telj, _així_, _апат, rnul_,
   {{0x66012917,0x61bc022e,0xc6a72447,0xe2990274}},	//   _tulk, ोक्ष, _преи, дао_,
   {{0x0cde06bc,0xb2f400c3,0x2ca903d0,0x25fa0067}},	//   _मर्म, ляющ, hzad_, _ऊंची_,
   {{0xe2962918,0x7afa2919,0x00000000,0x00000000}},	//   таю_, _útte, --, --,
   {{0x2ca91269,0x6d5f012f,0x656b009e,0x00000000}},	//   jzad_, deqa, _iagh, --,
   {{0x656b0082,0x443f081b,0x752201a3,0x00000000}},	//   _hagh, muu_, _zeoz, --,
   {{0x443f0086,0x6d46011e,0xff070043,0x00000000}},	//   luu_, _pcka, теск_, --,
   {{0x656b003c,0xa91d0cc1,0xfce607b0,0xdde900d1}},	//   _jagh, _kožu, вобо, فرقه_,
   {{0x656b291a,0x443f291b,0xfc0310e3,0x6f020139}},	// [1fc0] _magh, nuu_, ипто, _şocu,
   {{0x656b009c,0x4e062294,0xaaba02fd,0x9f4c0421}},	//   _lagh, _изоб, ودار_, ödä_,
   {{0x443f0421,0x6a8601d3,0x91fc00ea,0xbea6291c}},	//   huu_, ължа, lvār, _ранк,
   {{0x443f291d,0x656b12d7,0x645911ad,0x3f8a00cd}},	//   kuu_, _nagh, _opwi, ljbu_,
   {{0x92bd00c8,0x91fc0029,0x443f1b65,0x6843291e}},	//   _আরো_, nvār, juu_, инца,
   {{0x6d44291f,0x244b08c8,0xeb9f1217,0x00000000}},	//   lgia, døm_, _støv_, --,
   {{0x25a400d7,0x64590107,0xacbb00a2,0xdce60107}},	//   thml_, _apwi, _jeûn, _makč,
   {{0x6d442920,0x7bde2921,0x443f0054,0xd5b70aeb}},	//   ngia, llpu, fuu_, ксы_,
   {{0x656b2922,0x443f0054,0x80e12923,0x91fc00ea}},	//   _dagh, guu_, _नरें, jvār,
   {{0x69c20009,0x91fc013a,0xb4e20437,0xa91d0124}},	//   lnoe, dvār, _धरी_, _dožu,
   {{0x656b1c8b,0xa1950036,0xbb3b00a5,0x752200f4}},	//   _fagh, ганч, ועיי, _teoz,
   {{0x80d10083,0x69c200e9,0x656b0069,0xe8192924}},	//   _সৃষ্, nnoe, _gagh, नीका_,
   {{0x04430bef,0x443f0160,0xe3af0220,0x00000000}},	//   _вечн, cuu_, صری_, --,
   {{0x64402925,0x656b2926,0x4fc40328,0x00000000}},	//   mumi, _zagh, асса, --,
   {{0x64402927,0xa3c10653,0x75e5006c,0x93fb0317}},	//   lumi, ्कर_, lóza, _קלוי,
   {{0x6d440133,0x46b500ab,0x7bde0051,0x00000000}},	//   ggia, _अइसह, elpu, --,
   {{0x64402928,0x3b55002d,0x5c750f8f,0x6d5f0510}},	// [1fd0] numi, лкар, ылат, reqa,
   {{0xbbbf0d53,0x765a0035,0xd24d00fd,0x5b1401e0}},	//   ्वेक, _opty, _بچی_, имут,
   {{0x64400657,0x6d4400e2,0x443f2929,0xb4cf012f}},	//   humi, bgia, zuu_, _षड्_,
   {{0x6440292a,0x443f00d7,0x99d10083,0xac1900af}},	//   kumi, yuu_, িষ্ক, _пому_,
   {{0x64400080,0x7c84292b,0x656b0874,0x9f5a0107}},	//   jumi, _куре, _ragh, _bipè_,
   {{0xb605292c,0x7d0d00f1,0x6440292d,0xfba70287}},	//   hláš, lcas, dumi, _गतिम,
   {{0x656b12d7,0x9967292e,0x7d0d0036,0x443f0103}},	//   _pagh, _итал, ocas, wuu_,
   {{0x4efc0052,0x443f0086,0xa91d0254,0x6440018e}},	//   ולוג, tuu_, _požu, fumi,
   {{0x6440292f,0x656b027a,0xa3c10d91,0xceb50160}},	//   gumi, _vagh, ्कल_, _deși_,
   {{0x443f2930,0x7c2d2931,0x7d0d0211,0x244b0c71}},	//   ruu_, isar, hcas, røm_,
   {{0xe29905a1,0x656b2932,0x6d44001e,0x443f2933}},	//   хан_, _tagh, ygia, suu_,
   {{0xe57003c7,0x64402934,0x7c2d2935,0x443f127d}},	//   _وطن_, bumi, ksar, puu_,
   {{0xad9b0391,0x64400e85,0x91fd02d4,0x7d0d2936}},	//   _miúd, cumi, tvār, dcas,
   {{0x442d2937,0x7c2d2938,0x442f2939,0x00000000}},	//   mse_, dsar, _ivg_, --,
   {{0xed5a0994,0xd5ac0332,0x442d293a,0x7c2f0176}},	//   нов_, _رہی_, lse_, _avcr,
   {{0x442d293b,0x7d0d0176,0x69c3006c,0x5d6700af}},	//   ose_, gcas, énel, лисм_,
   {{0x442d293c,0x7077004f,0x7c2f0036,0x6abe012f}},	// [1fe0] nse_, _مميز_, _cvcr, ्थ्र,
   {{0x442d293d,0x442f293e,0x6d4400e9,0x7d0d01ef}},	//   ise_, _mvg_, sgia, acas,
   {{0x6440293f,0x442d2940,0x8ad501c8,0x442f0009}},	//   zumi, hse_, аюцц, _lvg_,
   {{0x442d2941,0x9f5a02e9,0x2d9e00ea,0x7c2d2942}},	//   kse_, _sipè_, ītes_, bsar,
   {{0x64e20953,0x442d2943,0x69c22944,0xb4e20324}},	//   _परेश, jse_, rnoe, _धरे_,
   {{0x38cb0357,0x442d2945,0xb7d20083,0x64402946}},	//   رانی_, dse_, াষ্ট, vumi,
   {{0xfaa62947,0x7bcb2948,0xaab80e6f,0x49940e3a}},	//   _саво, égue, _आधिक, _پیشر,
   {{0x64402949,0xad9b0079,0x2fda0282,0xb8fa0831}},	//   tumi, _giúd, _lkpg_, _ডঃ_,
   {{0xd326294a,0x442d294b,0xb993004f,0x48e30be8}},	//   льни, gse_, _القب, _готв,
   {{0x6440294c,0xf366294d,0x3946294e,0x3254294f}},	//   rumi, утин, lgos_, авор,
   {{0x442d0052,0x7c2d0080,0xafdb0c61,0x454605bc}},	//   ase_, zsar, ktør, _مناق,
   {{0x39462950,0x7c2d1fb2,0x442f027a,0x64402951}},	//   ngos_, ysar, _fvg_, pumi,
   {{0x2b4a012f,0x442d2952,0xc5f3011d,0xdb1e0ec3}},	//   _ocbc_, cse_, _הדף_, nopó,
   {{0xa91d2953,0x6ed6193c,0x7d0d2954,0x672a05ee}},	//   _inže, _मुहु, wcas, nafj,
   {{0x7c2d2955,0x539b011d,0x98ad0116,0x59d40b35}},	//   wsar, _איגו, _rdeč_, धकार,
   {{0x63ba05d3,0x82331a7c,0xc27b0317,0xf12701e0}},	//   litn, _اروا, _טרוי, _сько,
   {{0x7d0d2956,0x69c302e1,0xdfd1063d,0x61ed2957}},	// [1ff0] rcas, énem, _ويب_, _ihal,
   {{0x212b2958,0x63ba0252,0x39461a84,0x798002d0}},	//   lach_, nitn, egos_, _anmw,
   {{0x7c2d2959,0x61ed295a,0x629a295b,0x3f81035f}},	//   ssar, _khal, nyto, _inhu_,
   {{0x212b295c,0x442d295d,0xa91d0009,0x61ed009f}},	//   nach_, yse_, _onže, _jhal,
   {{0x39490080,0x61ed111c,0x186907be,0x63ba0600}},	//   ļas_, _mhal, тали_, kitn,
   {{0x212b0094,0x629a00d8,0x442f0479,0x3946010b}},	//   hach_, kyto, _rvg_, agos_,
   {{0x212b295e,0x442d295f,0x69ca00f7,0x752901a3}},	//   kach_, wse_, éfec, taez,
   {{0x442d2960,0x629a1648,0x2bbf0e61,0x212b0035}},	//   tse_, dyto, ्वका, jach_,
   {{0x212b2961,0x291d08e1,0x63ba03c9,0x442d2962}},	//   dach_, mbwa_, fitn, use_,
   {{0x61ed0291,0x13a700ff,0x63ba067f,0xe7a901c0}},	//   _ahal, اندی_, gitn, _कतिप,
   {{0x61ed2963,0x212b2964,0xa2e50009,0x60cd0168}},	//   _bhal, fach_, ронд, _axam,
   {{0x442d2965,0x212b2966,0x76432967,0x61ed2968}},	//   pse_, gach_, muny, _chal,
   {{0x61ed2969,0x7643162d,0x2fda00d7,0x15f400d2}},	//   _dhal, luny, _pkpg_, _اسلح,
   {{0x629a290b,0x7fd60210,0x394621aa,0x74120088}},	//   byto, рімі, zgos_, _بووا,
   {{0x60cd296a,0x212b296b,0x7643296c,0x629a296d}},	//   _exam, bach_, nuny, cyto,
   {{0x61ed296e,0xd1ba0332,0x4ad90d00,0x3d20004e}},	//   _ghal, _جاتا_, _बुधव, बरें_,

   {{0x8c46296f,0x2a6a012f,0xafdb082b,0x76432970}},	// [2000] резе, _ssbb_, rtør, huny,
   {{0x69db2971,0x109b011d,0xafdb082b,0x207b0070}},	//   _akue, _סביב, stør, _יאפא,
   {{0x32070955,0x34e20632,0x76432972,0x7f3b0122}},	//   _juny_, _पर्द, juny, _בעיו,
   {{0x394601c8,0xeae602cb,0x8c461f39,0x26de010b}},	//   ugos_, _करीत_, _кеме, _ryto_,
   {{0x39462140,0xa91d03ab,0x8eb300d1,0x69c90051}},	//   rgos_, _požr, _همیش, _djee,
   {{0x81bd0080,0x39460020,0x69db00d7,0x7643018e}},	//   lsēt, sgos_, _ekue, funy,
   {{0x76432973,0xdb1701ef,0x56941f39,0x79800103}},	//   guny, xixé, сайт, _tnmw,
   {{0x6d5602e9,0xe5c603fa,0x59de0026,0x281603ec}},	//   nfya, јско, _फीचर, _نورس,
   {{0x88bd006a,0x212b2974,0x2fd801ff,0x2904217c}},	//   _jeśl, vach_, korg_, _igma_,
   {{0x26de01c0,0x61ed2975,0x212b0035,0x386901f4}},	//   _tyto_, _shal, wach_, çare_,
   {{0x212b2976,0x63ba2977,0x61ed2978,0x76432979}},	//   tach_, ritn, _phal, cuny,
   {{0x29dc1111,0x61ed00d7,0x969502c4,0x629a297a}},	//   mías_, _qhal, _уруш, ryto,
   {{0x7bdc0bec,0x212b297b,0x63ba04c3,0x29dc1111}},	//   _okru, rach_, pitn, lías_,
   {{0x212b297c,0x2d820f2f,0x644f0955,0xd83f053d}},	//   sach_, _anke_, àcie, _účet_,
   {{0x6728297d,0x61ed297e,0x29dc0b4c,0x212b297f}},	//   _medj, _thal, nías_, pach_,
   {{0xaada0084,0x61ed0054,0xdda80043,0xdce600ea}},	//   _भड़क, _uhal, атул_, _sakā,
   {{0x2fd82980,0xdce600ea,0x3f9301ed,0x6be50037}},	// [2010] borg_, _pakā, _toxu_, مكرم,
   {{0x6728029d,0xa3e619b7,0x69db0c71,0xfbd01c64}},	//   _nedj, पति_, _skue, وتل_,
   {{0x7bc52981,0x5a470677,0x68e900b5,0x2001010d}},	//   rnhu, рэза, _szed, _iihi_,
   {{0x76432982,0x29dc0b4c,0xbcfb01cb,0xa91d00fe}},	//   vuny, días_, _daér, _cožp,
   {{0xe7390192,0xa3e60fd0,0x68e00297,0x7c871bc0}},	//   гел_, पता_, _cymd, _туне,
   {{0x76430f1a,0x785a0080,0x21292983,0x29dc0f56}},	//   tuny, dāvā, _leah_, fías_,
   {{0xf7701b15,0x29dc0033,0x69c90223,0x77632984}},	//   بان_, gías_, _tjee, renx,
   {{0x76432985,0x2fd80120,0x20010c6f,0x1dc700e7}},	//   runy, zorg_, _lihi_, रचित,
   {{0xbee409a3,0x68e0001e,0x69d92986,0x764300d1}},	//   _गर्न_, _gymd, mowe, suny,
   {{0xe7842987,0x76432988,0x29dc05c9,0x320701f7}},	//   _мухо, puny, bías_, _puny_,
   {{0x6b952989,0xd57501c8,0xe1fa1d36,0x29dc0b4c}},	//   _mozg, _гуль, лго_, cías_,
   {{0x200900d7,0x69d90035,0xdcfd021e,0x13a7042c}},	//   _buai_, nowe, _ansč, انگی_,
   {{0xd24e03c5,0x2009028b,0x2fd80093,0x21290211}},	//   ونی_, _cuai_, torg_, _deah_,
   {{0x443f298a,0x200900d7,0xaad00035,0x69d9298b}},	//   mru_, _duai_, _तुझक, howe,
   {{0x69d90035,0xdee608bb,0x23651b88,0x394d0124}},	//   kowe, сови, melj_, _oces_,
   {{0x394d006d,0x290000d8,0xdce4003a,0x2fd8298c}},	//   _nces_, žiai_, ndić, sorg_,
   {{0x69d9004e,0x2009298d,0x6b95298e,0xad9b0079}},	// [2020] dowe, _guai_, _bozg, _siúc,
   {{0x68e001ff,0x443f298f,0x00000000,0x00000000}},	//   _rymd, iru_, --, --,
   {{0x4906004f,0x443f2990,0x29dc0391,0x386d2991}},	//   مواق, hru_, xías_, _aser_,
   {{0x5d860082,0x70530164,0x29dc0b06,0x69d90067}},	//   _الحل, _بنیا, vías_, gowe,
   {{0x67282889,0xdb0e01ef,0x236502a7,0x4c35002d}},	//   _pedj, _embá, kelj_, _мэрт,
   {{0x7bdc2992,0x29dc2993,0x0f7a0070,0xad9b0098}},	//   _ukru, tías_, ראַב, _tiúc,
   {{0x443f2994,0x2365080a,0x386d0225,0x9f5202d7}},	//   eru_, delj_, _eser_, _huyó_,
   {{0x29dc09ab,0x98a60012,0x29041b82,0x88840580}},	//   rías_, _либе, _ugma_, _ویان,
   {{0x443f2995,0x29dc0b4c,0x6b950225,0x9f5a027a}},	//   gru_, sías_, _yozg, _pipì_,
   {{0x29dc1111,0x236513bd,0x00000000,0x00000000}},	//   pías_, gelj_, --, --,
   {{0x4df807ba,0x2009104e,0x443f2996,0x225800c3}},	//   ंगाई_, _suai_, aru_, шины_,
   {{0x443f2997,0x25a608dd,0xeae600ab,0x00000000}},	//   bru_, _ulol_, _करैत_, --,
   {{0x443f0043,0x20092998,0x2365023a,0x6ac420af}},	//   cru_, _quai_, belj_, वपुर,
   {{0x33f61a31,0x69d92999,0x23651bd8,0x4fc700c3}},	//   _учес, zowe, celj_, ссма,
   {{0x6b95299a,0x69d90054,0xd35700a5,0x82330697}},	//   _rozg, yowe, _השוק_, _فريا,
   {{0x2009028b,0x6440299b,0xd13100d1,0x442601a8}},	//   _tuai_, ormi, _کمک_, _kwo_,
   {{0x20010478,0xb606012e,0x6602299c,0x6b9501b7}},	// [2030] _tihi_, lišć, _miok, _pozg,
   {{0x6ac41bc6,0x64400037,0x66021b6f,0x69d9299d}},	//   वपूर, irmi, _liok, wowe,
   {{0x69d9299e,0x3cde00a1,0x29dc299f,0xdd9500c7}},	//   towe, _कुठे_, víar_, _даны,
   {{0x19591482,0x127b02b5,0x442629a0,0x443f29a1}},	//   рады_, טאבע, _owo_, yru_,
   {{0x69d92737,0xf09f12c3,0x6d4f29a2,0xdb17002a}},	//   rowe, nyà_, _icca, lixí,
   {{0x01cf0083,0x645c0043,0x69d929a3,0xbcfb0118}},	//   রতিদ, ăril, sowe, _abég,
   {{0x442609d6,0x644029a4,0x80c000b4,0x86980382}},	//   _awo_, ermi, _लेने, йтът_,
   {{0x443f29a5,0x44260b55,0x84592325,0xb606012e}},	//   tru_, _bwo_, арот_, dišć,
   {{0x23651851,0x386d29a6,0x443f29a7,0xf1bf01ba}},	//   telj_, _user_, uru_, diá_,
   {{0x443f29a8,0xdb0e0093,0x44260107,0xe3b90dfc}},	//   rru_, _embæ, _dwo_, рбо_,
   {{0x6d5d114d,0x66020009,0x6d4f1e11,0x442629a9}},	//   _obsa, _fiok, _occa, _ewo_,
   {{0xe56e005f,0x443f29aa,0x659429ab,0x6602027a}},	//   _ўз_, pru_, _наху, _giok,
   {{0x442629ac,0x25bf00af,0x23650a66,0xeae629ad}},	//   _gwo_, miul_, pelj_, _कर्त_,
   {{0x6d5d29ae,0x6d4f01d3,0x3cdd0084,0x25bf002d}},	//   _absa, _acca, _खड़े_, liul_,
   {{0xf1bf0952,0x2d961402,0x00000000,0x00000000}},	//   biá_, орас, --, --,
   {{0x25bf0043,0x3dc9043d,0xf1bf1945,0x51f603fc}},	//   niul_, gnaw_, ciá_, _بستر,
   {{0xfce329af,0x752b29b0,0x249f29b1,0x248d0176}},	// [2040] дото, _megz, nyum_, nxem_,
   {{0x61e629b2,0x25bf00af,0x6d4f0027,0x248d0176}},	//   llkl, hiul_, _ecca, ixem_,
   {{0xed5a00c9,0x3dc9010d,0x00000000,0x00000000}},	//   _кон_, bnaw_, --, --,
   {{0xe9da2217,0xd37800cb,0xad5a010b,0x00000000}},	//   шке_, moće_, _трох_, --,
   {{0x25bf0043,0x999c00fd,0x25ad29b3,0x00000000}},	//   diul_, évő_, dhel_, --,
   {{0x44260232,0x207b0070,0xc7a3117a,0x38690132}},	//   _rwo_, יאנא, мичк, çara_,
   {{0x81c30033,0x7bce0223,0xd37800f4,0x3cde021a}},	//   ্তত_, _ijbu, noće_, _कुते_,
   {{0x2d920232,0x25ad29b4,0x7e9b02b5,0xad9b0037}},	//   njye_, ghel_, יסצו, _liún,
   {{0xa73a042c,0x938a29b5,0xd3780207,0x00000000}},	//   _نثار_, асна_, hoće_, --,
   {{0xa3e40722,0xb6060124,0x442602a2,0xd37800f4}},	//   _भीख_, tišć, _vwo_, koće_,
   {{0x86c6004f,0xcb130122,0xf1bf0a54,0xb7d700b5}},	//   _بيان, ולת_, tiá_, _بولا_,
   {{0x44260052,0xb60603fa,0x290000d8,0x25bf0043}},	//   _two_, rišć, žiau_, ciul_,
   {{0x4426070b,0xcf0000a8,0xf1bf00a0,0x25d900f8}},	//   _uwo_, əşən_, riá_, _اهنگ_,
   {{0x437400d1,0x61e60051,0xad9b0098,0x00000000}},	//   _رهبر, alkl, _ciún, --,
   {{0x3ea5006c,0x6d5d009e,0xf1bf014c,0x00000000}},	//   ált_, _pbsa, piá_, --,
   {{0x321e28c3,0xdb1701dd,0x51871783,0x463b016b}},	//   mpty_, rixí, _фука, יעלע,
   {{0x030e0299,0xe7bc29b6,0xa1f900b5,0xc19c00a5}},	// [2050] _सलाह_, ्चाप, _پڑھا_, _כשהי,
   {{0x09d31e18,0x1fa709ce,0x6ed6111a,0xda7b0382}},	//   तव्य, _фриг, _मुकु, ияе_,
   {{0xfd4700b5,0xaf010033,0x00000000,0x00000000}},	//   _ویسٹ_, ্রহণ_, --, --,
   {{0x2ca029b7,0x67ed1f51,0x09c5021a,0x00000000}},	//   byid_, dúja, लचेय, --,
   {{0xb17c0070,0x661a03d0,0xdb1e01f7,0x98f4010b}},	//   יטאר, _attk, kipè, мяшч,
   {{0x81c300c8,0x2d9929b8,0x6cfa0122,0x6d4d29b9}},	//   ্তি_, _hose_, _לפרס, lgaa,
   {{0xb90200ab,0x2d9929ba,0x67ed00b5,0x25bf00af}},	//   _नु_, _kose_, gúja, tiul_,
   {{0x6d4d29bb,0x2d9929bc,0x39150746,0x00000000}},	//   ngaa, _jose_, _хмар, --,
   {{0x81c30083,0x25bf0043,0x395f0107,0x661a0282}},	//   ্তা_, riul_, _ibus_, _ettk,
   {{0x2d9929bd,0x249f29be,0x752b1bb3,0x00000000}},	//   _lose_, ryum_, _wegz, --,
   {{0x69cb29bf,0x95cb0086,0x25bf002d,0x04fd0033}},	//   onge, _куда_, piul_, ীরের_,
   {{0x2ca029c0,0x6d4d29c1,0x69cb29c2,0xd3780009}},	//   yyid_, jgaa, nnge, voće_,
   {{0x69cb29c3,0x6d4d29c4,0x920b0461,0x261100e2}},	//   inge, dgaa, _सूरज_, _háo_,
   {{0xd9b8175f,0x6d4d29c5,0xa4fa00a5,0x2d990118}},	//   _अष्ट, egaa, _פלסט, _aose_,
   {{0x2d990232,0x59db0d53,0x8e8319b6,0x6d4d2193}},	//   _bose_, यकार, нгре, fgaa,
   {{0x6d4d0173,0x2d9901d3,0x76431ea7,0xa3b70437}},	//   ggaa, _cose_, irny, घोर_,
   {{0xdb1e29c6,0x6ac41856,0x7a0c0be2,0xad9b0098}},	// [2060] qipë, वप्र, _iğti, _tiún,
   {{0x395f29c7,0x6d4d29c8,0x656929c9,0x69cb29ca}},	//   _abus_, agaa, heeh, enge,
   {{0x2d9929cb,0x2ca00a7e,0x9f9b0122,0x98b00254}},	//   _fose_, syid_, _הסיפ, đači_,
   {{0x5f46006c,0x2d9901a3,0x3f9a29cc,0x00000000}},	//   _بنگل, _gose_, _hopu_, --,
   {{0xa3bd02cb,0x3f9a29cd,0x7d7b00a5,0xa3cb29ce}},	//   ीचा_, _kopu_, _הנכו, रचा_,
   {{0x261100e8,0xdb1e0118,0x644912c3,0x2d990010}},	//   _báo_, kipé, duei, _zose_,
   {{0x261100e8,0x2d990232,0x7bde022e,0xd5ba2626}},	//   _cáo_, _yose_, mopu, йси_,
   {{0x69c3006c,0x7d160118,0x9418195c,0x00000000}},	//   énet, ncys, ожит_, --,
   {{0x644929cf,0x764329d0,0xdce400c7,0xdcfd0160}},	//   guei, arny, keič, _insă,
   {{0x69c229d1,0xdc9b0070,0x7dfc0107,0x00000000}},	//   lioe, צייל, _včsy, --,
   {{0xe4d60357,0x6d4d1d8d,0xf77300a5,0x5ec10033}},	//   _کتاب, ygaa, _רקע_, _শুনে,
   {{0xfbc40083,0x69c229d2,0x925700c3,0x7bde02ee}},	//   ্তিত, nioe, чают_, hopu,
   {{0x64491010,0x7bde00c3,0xad9b0037,0x78a229d3}},	//   cuei, kopu, _diúl, nyov,
   {{0x2259004e,0xdce40009,0xa91d023a,0x69c201ed}},	//   ńska_, geič, _anžl, hioe,
   {{0x6d4d29d4,0xdb1e004f,0x7bde040b,0x69cb29d5}},	//   tgaa, cipé, dopu, ynge,
   {{0xdd9429d6,0x91e403fa,0x69c20065,0x00000000}},	//   насы, _поје, jioe, --,
   {{0x6d4d29d7,0x2d991628,0x113c00a5,0x69b000b4}},	// [2070] rgaa, _vose_, _התחל, ंसनी,
   {{0x6d4d29d8,0x2d9901d5,0x09c50099,0xbcfb00a2}},	//   sgaa, _wose_, लच्य, _abéc,
   {{0x2d9929d9,0xb4c90026,0x69c201ed,0x00000000}},	//   _tose_, _ईश्_, fioe, --,
   {{0x6ed6045c,0x69cb02fb,0x69c229da,0x26110023}},	//   _मुटु, unge, gioe, _ráo_,
   {{0xeab0006c,0x26110023,0x69cb29db,0x3f9a0118}},	//   نٹے_, _sáo_, rnge, _yopu_,
   {{0x66e529dc,0xdb2303fc,0x69da0132,0xfd1300b5}},	//   мола, _سوری, _íten, _تجھ_,
   {{0xe73001b2,0x69c3002a,0x69c20065,0x00000000}},	//   اصه_, énes, bioe, --,
   {{0x64490443,0x395f02b3,0xe7ed0387,0x387f0044}},	//   tuei, _ubus_, _चीरा_, _trur_,
   {{0x79890168,0x00000000,0x00000000,0x00000000}},	//   _inew, --, --, --,
   {{0x26110019,0x799b0223,0xad9b0079,0xf77029dd}},	//   _táo_, _houw, _siúl, _مام_,
   {{0x614629de,0x3f9a0a69,0x799b02d0,0x6449005f}},	//   мена, _ropu_, _kouw, suei,
   {{0x5ec10083,0x799b29df,0xdb1e29e0,0x7bde034d}},	//   _শুভে, _jouw, ripé, zopu,
   {{0x644929e1,0xafdb0185,0xad9b0132,0x799b02a2}},	//   quei, rrøn, _ciúm, _mouw,
   {{0x69c206a2,0x799b29e2,0xa2d80067,0x00000000}},	//   zioe, _louw, _नुक्, --,
   {{0xdee32515,0x5de600d8,0x0ef9010b,0xdb0e00f6}},	//   вори, джва, зэты_, _embû,
   {{0x69bf0fd1,0xd378012e,0x799b01f7,0xdb1c29e3}},	//   लोमी, moća_, _nouw, _imré,
   {{0x5f76028c,0x61e429e4,0xa5c6008d,0x7e65009e}},	// [2080] _قادر, _ikil, ljóð, _ephp,
   {{0xfaa629e5,0x78a208c7,0x00000000,0x00000000}},	//   мазо, vyov, --, --,
   {{0x7c36017b,0x81c300c8,0x799b29e6,0x1d0a0431}},	//   ssyr, ্তর_, _bouw, _мени_,
   {{0x7bde29e7,0x79890090,0x00000000,0x00000000}},	//   sopu, _cnew, --, --,
   {{0x79890069,0x69c201d7,0xd3780207,0x61e40a6b}},	//   _dnew, rioe, hoća_, _mkil,
   {{0xe6c9021a,0x7a0c002d,0x69c329e8,0x69c229e9}},	//   िपूज, _aşte, éner, sioe,
   {{0x6b9c29ea,0x799b0107,0x69c201b7,0x00000000}},	//   _iorg, _fouw, pioe, --,
   {{0x6b9c00b5,0x61e429eb,0x320e027a,0x799b2069}},	//   _horg, _nkil, _rufy_, _gouw,
   {{0x69c029ec,0x6b9c29ed,0xdb1c0118,0x236a2123}},	//   _imme, _korg, _amré, ојно_,
   {{0x6b9c1c98,0x61e4000e,0xf36622a9,0x889b00a5}},	//   _jorg, _akil, фтин, _ובמי,
   {{0xbcfb0037,0x6b9c14f9,0x00000000,0x00000000}},	//   _mbéa, _morg, --, --,
   {{0x6b9c09c3,0x61f629ee,0xad9b021d,0xc6930277}},	//   _lorg, _chyl, _piúm, _שאף_,
   {{0x6b9c0173,0x0cc90033,0x65620371,0x3cde012f}},	//   _oorg, _শর্ত, _iboh, _कुले_,
   {{0x6b9c27fe,0x61e429ef,0xa5c6003e,0xdb0e0176}},	//   _norg, _ekil, bjóð, _embú,
   {{0x69c029f0,0xa3bd0035,0xdd9b1474,0x3ced00d5}},	//   _omme, ीचर_, оша_, _šev_,
   {{0xc5f800ea,0x00000000,0x00000000,0x00000000}},	//   _spēj_, --, --, --,
   {{0x6b9c29f1,0x65620027,0x799b02a2,0x3c5800af}},	// [2090] _borg, _mboh, _rouw, митэ_,
   {{0x799b0260,0x69c029f2,0x6b9c29f3,0x61fd093a}},	//   _souw, _amme, _corg, lmsl,
   {{0xfd10006c,0x65620187,0x6b9c29f4,0x799b021e}},	//   اجہ_, _oboh, _dorg, _pouw,
   {{0x4c950bfe,0x9f5a00c3,0x6d4b0098,0x49b800f8}},	//   _зимс, _eipä_, ógad, واند_,
   {{0x6b9c29f5,0x2d8b027d,0x799b02a2,0x7e6200cd}},	//   _forg, _ince_, _vouw, _ćopi,
   {{0x69c029f6,0xdce401d6,0x656229f7,0x6b9c05f0}},	//   _emme, ldiğ, _aboh, _gorg,
   {{0x4ae401c8,0xdcfd010b,0x16a917f9,0x799b29df}},	//   _аўта, _posė, явки_, _touw,
   {{0x7bc529f8,0x6b9c29f9,0xc8c000a1,0xdce401d6}},	//   lihu, _zorg, _शेवट, ndiğ,
   {{0x443929fa,0x290d027a,0x6b9c29fb,0x4a08002d}},	//   és_, _igea_, _yorg, _цэрм_,
   {{0x61e429fc,0x422529fd,0xf77329fe,0x61f600fe}},	//   _skil, ндов, _جار_, _shyl,
   {{0x2d8b29ff,0x98a400af,0x00000000,0x00000000}},	//   _once_, _temă_, --, --,
   {{0x22590035,0xe29a0023,0xa91d00c7,0x68e9030d}},	//   ńsko_, _ngưu_, _požy, _kyed,
   {{0x6abd0ea3,0x3209067f,0xa5c60093,0x7bc51b68}},	//   ्पुर, _diay_, sjóð, kihu,
   {{0x2d8b0228,0x7bc5002f,0x656200ac,0x61fd12ba}},	//   _ance_, jihu, _zboh, amsl,
   {{0x24592a00,0x645b2a01,0x61f62a02,0x68e9030d}},	//   lèm_, ltui, _thyl, _lyed,
   {{0x657b2a03,0x32090019,0x61e4002f,0x62832a04}},	//   nduh, _giay_, _ukil, _irno,
   {{0xf3900019,0x8c43020a,0x68e900d1,0x6b9c2a05}},	// [20a0] _mảnh_, лете, _nyed, _porg,
   {{0x6abd2a06,0x7bc50010,0x657b2a07,0x62832a08}},	//   ्पूर, gihu, hduh, _krno,
   {{0x6b9c02c9,0x645b2a09,0xfaa3005f,0x7c292a0a}},	//   _vorg, htui, лафо, _çern,
   {{0x645b053e,0x6b9c03bc,0xe8fa2a0b,0x68e90103}},	//   ktui, _worg, пле_, _byed,
   {{0x6b9c2a0c,0x69da2a0d,0xd7e600d8,0x7bc504fb}},	//   _torg, _ítem, ніко, bihu,
   {{0x290d0176,0x62830566,0x6b9c23f4,0x00000000}},	//   _egea_, _orno, _uorg, --,
   {{0x56942a0e,0xfa670272,0x7c242a0f,0x61fd0093}},	//   тайт, _парк_, lpir, ymsl,
   {{0xd5b70862,0xf3900028,0x4ad9000c,0x657b043d}},	//   есь_, _cảnh_, _बुटव, gduh,
   {{0x62832a10,0xb8860314,0x645b2a11,0x65790211}},	//   _arno, _blíž, gtui, _dawh,
   {{0xdb17013b,0x00000000,0x00000000,0x00000000}},	//   rixç, --, --, --,
   {{0xf8bf00fb,0x62830a78,0x0bb700a5,0x645b2a12}},	//   _þér_, _crno, גלים_, atui,
   {{0x645b053e,0x7bc52a13,0x62832a14,0x656200ac}},	//   btui, zihu, _drno, _uboh,
   {{0xdce4027d,0x777a01a3,0x7bc5251e,0xf1c005fc}},	//   vdiğ, _katx, yihu, शोधन,
   {{0x2294004f,0x7c24008b,0x777a01ed,0xdcef0139}},	//   _للتس, dpir, _jatx, _lacă,
   {{0xfe70006c,0x777a2a15,0x0edb26c6,0x00000000}},	//   یدہ_, _matx, _मुखड, --,
   {{0x777a0065,0x00000000,0x00000000,0x00000000}},	//   _latx, --, --, --,
   {{0x3cfc02cb,0xdce401d6,0x7c242a16,0xd16401d3}},	// [20b0] लेले_, rdiğ, gpir, _същи,
   {{0x657b03fa,0xa91d2a17,0xe1ff2a18,0x3b54002d}},	//   zduh, _inži, lmó_, лкур,
   {{0xc3330122,0xdcef00af,0xdb1e0952,0x68e9008c}},	//   רוע_, _bacă, cipí, _syed,
   {{0x245902d0,0x7c240051,0xf1e106fe,0x7bc5135c}},	//   yèm_, bpir, नविन, sihu,
   {{0x777a2a19,0xf3900023,0x65792a1a,0xed600355}},	//   _batx, _rảnh_, _rawh, ížet_,
   {{0xf7711c51,0x777a0392,0x98a20226,0xf3900023}},	//   شات_, _catx, рише, _sảnh_,
   {{0xd91501c8,0x777a2a1b,0xf1e105f8,0x00000000}},	//   _адбы, _datx, नवान, --,
   {{0xd6ce004f,0x645b00c3,0xdb0e2a1c,0xb88600d5}},	//   تقى_, ttui, _albè, _slíž,
   {{0xad9b0079,0x777a2a1d,0x44240159,0x7a0c0448}},	//   _ciúi, _fatx, gpm_, _işta,
   {{0x645b11f6,0x5ed70083,0x777a01b7,0x20120103}},	//   rtui, _ধরনে, _gatx, _ruyi_,
   {{0x65792a1e,0x645b2a1f,0xdb1e0132,0xa91d023a}},	//   _tawh, stui, lipã, _anži,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x75292a20,0x98a401c8,0x7c240118,0xad9b0098}},	//   mbez, _temą_, xpir, _giúi,
   {{0x6449001e,0x644600c5,0x43452a21,0x443d0bf7}},	//   mrei, škic, _рекв, _ivw_,
   {{0xed5a275d,0xd0072a22,0x64492a23,0xdee62a24}},	//   мов_, тере_, lrei, тови,
   {{0xd00f0332,0xb602008a,0x661c006c,0x752901ae}},	//   صلہ_, _þátt, _érke, nbez,
   {{0xff262a25,0x973c0254,0x64492a26,0xa3c507df}},	// [20c0] _импо, _hoće, nrei, _एषा_,
   {{0x64492a27,0x7c242a28,0x442f016e,0x660b0345}},	//   irei, rpir, _mwg_, _ligk,
   {{0x64492a29,0xf1c608d1,0x442f01e8,0x2d9e0248}},	//   hrei, _लगान, _lwg_, êtes_,
   {{0x6cc6081b,0x64492a2a,0xd00f0416,0xdb1c0079}},	//   _айма, krei, _دلی_, _imrí,
   {{0x442f0221,0x777a01d7,0xb8220033,0x00000000}},	//   _nwg_, _patx, _নিহত_, --,
   {{0xb17b013c,0xbcfb00e0,0x628112ba,0x00000000}},	//   llåt, _mbél, kvlo, --,
   {{0x1637004f,0x2b582a2b,0x660b08dd,0x442f0168}},	//   نسية_, _icrc_, _bigk, _awg_,
   {{0x64492a2c,0xd01a00c8,0x557401b8,0xe9a32a2d}},	//   frei, তীয়_, угит, _касп,
   {{0x64492a2e,0xa80600af,0xb8652a2f,0x660b053e}},	//   grei, _азал, _مالو, _digk,
   {{0x75c80355,0x00000000,0x00000000,0x00000000}},	//   tězs, --, --, --,
   {{0xd37700c7,0xf2040067,0x2611023a,0xf1f60067}},	//   тчы_, रगढ़_, _cšod_, ीगढ़_,
   {{0x64492a30,0x442f016e,0x973c0207,0x00000000}},	//   brei, _fwg_, _doće, --,
   {{0xe1ff0033,0xc05815d6,0x64492a31,0x6e22011c}},	//   rmó_, кір_, crei, _čoba,
   {{0x9f530955,0x261801a5,0x386916f6,0xe1ff02d7}},	//   _això_, _kéo_, çari_, smó_,
   {{0x4ea42a32,0x9f3401e0,0x2fcd0254,0x6e3c011e}},	//   арта, ресі, đeg_, gsrb,
   {{0x442f0189,0x261800e2,0x00000000,0x00000000}},	//   _ywg_, _méo_, --, --,
   {{0x69c30248,0x26182a33,0x9f4301f4,0x213901e9}},	// [20d0] ènem, _léo_, nojë_, mash_,
   {{0x8aa72a34,0x39db0066,0x2d9e000d,0x21392a35}},	//   кред, यक्ि, êter_, lash_,
   {{0x2618000d,0x00000000,0x00000000,0x00000000}},	//   _néo_, --, --, --,
   {{0xdd95247f,0x21390055,0x9f4301f4,0x00000000}},	//   _самы, nash_, kojë_, --,
   {{0x2486006d,0xf745167d,0xafdb01b4,0x9f430031}},	//   _nrom_, гело, gsøg, jojë_,
   {{0x442f01e8,0x26180019,0xdb07006c,0x64492a36}},	//   _rwg_, _béo_, _eljá, vrei,
   {{0xfc3f003e,0xcf940100,0xaa9412a2,0x2486011e}},	//   _hví_, יטס_, _кирч, _arom_,
   {{0x442f01e8,0x973c0009,0x248601bf,0x21390055}},	//   _pwg_, _roće, _brom_, jash_,
   {{0x75292a37,0x24862a38,0x213901e9,0x9f430031}},	//   rbez, _crom_, dash_, gojë_,
   {{0x64492a39,0x973c022f,0x75292a3a,0xe7b705f8}},	//   rrei, _poće, sbez, _अतिप,
   {{0x64492a3b,0x660b0430,0x248602a2,0x261800a2}},	//   srei, _tigk, _erom_, _géo_,
   {{0x248601f3,0x442f01a9,0x644600d8,0x628103c4}},	//   _from_, _twg_, škia, rvlo,
   {{0x3fc800bf,0x24862a3c,0xf53900a0,0x291f0283}},	//   ندسی_, _grom_, mať_, _mfua_,
   {{0xf53901ba,0x00000000,0x00000000,0x00000000}},	//   lať_, --, --, --,
   {{0xfc3f0176,0x1eaa00f3,0x261800cc,0x61ef0118}},	//   _aví_, راسي_, _xéo_, blcl,
   {{0x25ad2a3d,0xf53901ba,0x67380124,0x00000000}},	//   nkel_, nať_, zavj, --,
   {{0xb17b013c,0x5ed70033,0xed350144,0x80a500b5}},	// [20e0] rlåt, _ধরণে, рэсэ, _نمٹن,
   {{0xb34603e6,0x9f5e0086,0x25ad00ab,0xf53900a0}},	//   moçõ, ötä_, hkel_, hať_,
   {{0x25ad2a3e,0x3ea610ac,0x533602b5,0xa4f002e4}},	//   kkel_, _синг, רנען_, _चर्च_,
   {{0xf53900a0,0x3ea52a3f,0x1ad5012f,0x2ca90051}},	//   jať_, älte_, _दशरथ, byad_,
   {{0xe89417e0,0xf539124b,0x07a60ed2,0xc7c6150d}},	//   раль, dať_, ладн, лски,
   {{0xafdb0022,0x9f4301f4,0x61e62a40,0x21390055}},	//   rsøg, vojë_, hokl, zash_,
   {{0x6738108a,0xad9b1be9,0xa91d01f2,0x2486009e}},	//   ravj, _viúv, _anžu, _srom_,
   {{0x6d562a41,0xd49a1238,0x2d802a42,0x9f4301f4}},	//   ngya, еро_, ndie_, tojë_,
   {{0xa84a18dd,0x61e60029,0x2d8026d8,0x21392a43}},	//   _سلام_, dokl, idie_, vash_,
   {{0x9f4301f4,0x28d1007e,0x24860223,0x2618021d}},	//   rojë_, तपरि, _vrom_, _téo_,
   {{0x9f4301f4,0x213904a7,0xe81a0026,0xf53900a0}},	//   sojë_, tash_, _फंडा_, bať_,
   {{0x24862a44,0x25ad2a45,0x9f430055,0xd9f6021a}},	//   _trom_, ckel_, pojë_, ेषित_,
   {{0x21392a46,0x73c40d4f,0x5ff5002d,0x00000000}},	//   rash_, _پيغم, изму, --,
   {{0x2d8000d7,0x14d700a5,0x2a660035,0x21390031}},	//   edie_, _גודל_, łoby_, sash_,
   {{0x21392a47,0x00000000,0x00000000,0x00000000}},	//   pash_, --, --, --,
   {{0x6d56221a,0x61e61c26,0x21391505,0x7c292a48}},	//   ggya, cokl, qash_, _çerk,
   {{0xdfd5010b,0xeb4b039e,0x00000000,0x00000000}},	// [20f0] _вопы, ечек_, --, --,
   {{0x91fd0080,0xf539016f,0x2d80009e,0x00000000}},	//   stād, zať_, adie_, --,
   {{0x20d4064e,0x2ca920fb,0x9b68005f,0x25ad2a49}},	//   _نتیج, syad_, ышта_, ykel_,
   {{0xdb0e01ef,0x7aee0a8a,0x6e25009e,0x00000000}},	//   _ambó, _dybt, _ithb, --,
   {{0xf539124b,0xd5b100e2,0x3d3a00a5,0xa3c60825}},	//   vať_, _lúc_, _בגרס, ैचा_,
   {{0x2259004e,0x69ca1485,0x10380317,0xf62503b2}},	//   ński_, éfer, נטום_, адко,
   {{0x25ad007c,0xf539016f,0x39440a8a,0x00000000}},	//   tkel_, tať_, _fdms_, --,
   {{0xdb0e00ee,0x00000000,0x00000000,0x00000000}},	//   _embó, --, --, --,
   {{0x69cb2a4a,0x644600d8,0xf539016f,0x61e62a4b}},	//   mige, škin, rať_, vokl,
   {{0x69cb2a4c,0xf53901ba,0x25ad2a4d,0x386d1f26}},	//   lige, sať_, skel_, _iper_,
   {{0x27e72a4e,0xd6d10754,0x25b000b5,0xfbdd08b0}},	//   monn_, _بقا_, álló_, _मदनम,
   {{0x69cb2a4f,0x91e62a50,0x61e600c7,0x568a016b}},	//   nige, роме, uokl, _שטײַ,
   {{0x6e25004f,0x80c000b8,0x00000000,0x00000000}},	//   _athb, _लेखे, --, --,
   {{0x69cb2a51,0x753b2a52,0xdfd20037,0x61e6011e}},	//   hige, lauz, زيز_, sokl,
   {{0xa91d114d,0x443f2a53,0x63a3004a,0x09b500a1}},	//   _každ, lsu_, _ionn, ंसाठ,
   {{0x63a32a54,0x32da0122,0x27e7053f,0x1d261353}},	//   _honn, _שחקנ, honn_, рмам,
   {{0x63a32a55,0x2d801e4f,0x69cb0e45,0x27e72a56}},	// [2100] _konn, rdie_, dige, konn_,
   {{0x443f2a57,0x63a32a58,0x753b0200,0xeab20037}},	//   isu_, _jonn, hauz, يعا_,
   {{0x69cb2a59,0x973c0c0a,0x63a32a5a,0x386d03d0}},	//   fige, _noća, _monn, _aper_,
   {{0x443f2a5b,0x63a30037,0x88862a5c,0x69cb2a5d}},	//   ksu_, _lonn, илеж, gige,
   {{0x6eca0fcf,0x91fd00ea,0x443f1c90,0x76412a5e}},	//   _हेतु, ltāc, jsu_, _avly,
   {{0x63a32a5f,0x98a401c0,0x973c012e,0x443f02a7}},	//   _nonn, _země_, _boća, dsu_,
   {{0x69cb2a60,0xfaa60009,0x443f2a61,0x295601d3}},	//   bige, _таво, esu_, _възр,
   {{0xd3780a78,0x443f2a62,0x98a62a63,0x18a628fa}},	//   moći_, fsu_, _кибе, _кабм,
   {{0x2616006a,0x63a32a64,0xb0c50035,0xa91d11d7}},	//   _पूरी_, _bonn, _लेंग, _dažd,
   {{0x63a31762,0x79800232,0x27e70176,0x79822a65}},	//   _conn, _hamw, conn_, ldow,
   {{0x6d46114d,0x798018a6,0x63a30dd5,0xd5af17df}},	//   _odka, _kamw, _donn, _дс_,
   {{0x7c2601cc,0x31c72a66,0x753b137d,0x79800069}},	//   _otkr, рсов, cauz, _jamw,
   {{0x63a3026e,0xcfa72a67,0x79800090,0x846302fb}},	//   _fonn, ашви, _mamw, _дъще,
   {{0x63a32a68,0x44262a69,0x69cb2a6a,0x64422a6b}},	//   _gonn, _ito_, zige, _ivoi,
   {{0xc3fb0122,0x644017ad,0x7c262791,0x69cb01d5}},	//   _שלוש, lsmi, _atkr, yige,
   {{0x44262a6c,0xa91d28d2,0x42550332,0x63a32a6d}},	//   _kto_, _kaže, _انٹر, _zonn,
   {{0x61ed2a6e,0x63a30273,0x69cb2a6f,0xdb1e0421}},	// [2110] _ikal, _yonn, vige, kipä,
   {{0xa91d00d8,0x69d80248,0x69cb2a70,0x44262a71}},	//   _maže, éven, wige, _mto_,
   {{0x69cb2a72,0x79800a74,0x386d002d,0xa91d2676}},	//   tige, _bamw, _sper_, _laže,
   {{0x44262a73,0x443f2a74,0x64402a75,0x27e70359}},	//   _oto_, ysu_, ksmi, wonn_,
   {{0x44262a76,0xfd960122,0x61ed0054,0xe6cb008a}},	//   _nto_, _הדרך_, _mkal, _íbúð,
   {{0x64402a77,0x628a00e9,0xdb1e00be,0x753b08c7}},	//   dsmi, _orfo, gipä, wauz,
   {{0x44262a78,0x3f8102c2,0x64422a79,0x69cb2a7a}},	//   _ato_, _mahu_, _avoi, pige,
   {{0x81bd0ae0,0x63a32a7b,0x27e702e9,0xe5792a7c}},	//   spēj, _sonn, sonn_, узи_,
   {{0x27e70c1f,0x64402a7d,0x63a32a7e,0x69c9002f}},	//   ponn_, gsmi, _ponn, _imee,
   {{0x443f2a7f,0x61ed2a80,0x44262a81,0xd7fb2a82}},	//   rsu_, _akal, _dto_, _руб_,
   {{0x443f2a83,0x4426197d,0x63a32a84,0x69db0009}},	//   ssu_, _eto_, _vonn, _kjue,
   {{0x63a3018e,0x443f2a85,0x64402a86,0x00000000}},	//   _wonn, psu_, bsmi, --,
   {{0x628a02bf,0x644f2a87,0x3f810ce8,0x973c0254}},	//   _erfo, ácid, _bahu_, _moćn,
   {{0x61ed2a88,0x63ba2a89,0x7fd60409,0x23262a8a}},	//   _ekal, chtn, сімі, _лоши_,
   {{0xa91d13a6,0xdfcf00ad,0x65b50187,0x3f810506}},	//   _zaže, ريف_, _záha, _dahu_,
   {{0x973c0254,0x3d2800f8,0x68fb2a8b,0x00000000}},	//   _noćn, شتری_, _ozud, --,
   {{0x6da32832,0x79800051,0x68fb0103,0x00000000}},	// [2120] чита, _ramw, _nzud, --,
   {{0x69c92a8c,0xa3ca0f3d,0x79800a28,0x22590067}},	//   _amee, रोप_, _samw, ńsku_,
   {{0x3cfc0302,0x8e86004f,0x79800260,0x0a4a00c3}},	//   लेजे_, _الجه, _pamw, узей_,
   {{0xe93a07f8,0x8d562263,0x64402a8d,0xe9da0f78}},	//   اسات_, _уточ, ysmi, ыке_,
   {{0xa3e70302,0x79820035,0x69db0453,0x3f812a8e}},	//   पवा_, rdow, _djue, _yahu_,
   {{0x2d821e41,0x79822a8f,0x79800848,0xa91d00fe}},	//   _hake_, sdow, _wamw, _raže,
   {{0x798228c3,0x2d822a90,0xa91d2a91,0x79802a92}},	//   pdow, _kake_, _dažb, _tamw,
   {{0x6440038d,0xb8ce0083,0xa91d00d8,0xfad70122}},	//   tsmi, _ওই_, _paže, _הולך_,
   {{0x2d820052,0x44260132,0x64402a93,0x00000000}},	//   _make_, _qto_, usmi, --,
   {{0x61ed2a94,0xd37a0dc8,0x2d8200a5,0xa91d01a0}},	//   _skal, учи_, _lake_, _važe,
   {{0x44262a95,0xc7b300a5,0x9f8d00b8,0xd2f817d0}},	//   _wto_, _צבע_, uží_, ренц_,
   {{0xdb1c00fb,0x64402a96,0x44262a97,0x673a008d}},	//   _umræ, psmi, _tto_, _hetj,
   {{0x44262a98,0x3f81012f,0xafdb0c71,0x673a0086}},	//   _uto_, _pahu_, drør, _ketj,
   {{0x8233006c,0x661a2a99,0x62340fa7,0x43942a9a}},	//   _کروا, _kutk, _деку, _факс,
   {{0x25a62a9b,0x673a0861,0x61ed0124,0x09cf0033}},	//   _kool_, _metj, _tkal, িকতা,
   {{0x673a2a9c,0x61ed2a9d,0x7bdc035f,0x2d820b48}},	//   _letj, _ukal, _ajru, _cake_,
   {{0x21f90076,0x3f810614,0x2d822a9e,0x661a2a9f}},	// [2130] lého_, _tahu_, _dake_, _lutk,
   {{0x673a0c7c,0x69c911cc,0x7e7e0176,0xc7b800e2}},	//   _netj, _smee, _fspp, _nlđ_,
   {{0x21f9086d,0xa91d00d5,0x2d822aa0,0xdddc00f4}},	//   ného_, _ražb, _fake_, svrš,
   {{0xd378039a,0x25a6018d,0x725b0070,0xad9b0079}},	//   moću_, _nool_, רכאפ, _dhúc,
   {{0x21f90187,0x973c044d,0x673a2aa1,0xdcfd021e}},	//   hého_, _voćn, _betj, _kasč,
   {{0x21f9114d,0x2d820657,0x661a2aa2,0x9f4300ac}},	//   kého_, _zake_, _butk, kojí_,
   {{0x2d8219c6,0x2013007a,0xd37800f4,0x56920dec}},	//   _yake_, _mixi_, noću_, дајт,
   {{0x69c92aa3,0x25a62aa4,0x94252aa5,0x14250f68}},	//   _umee, _cool_, омие, одим,
   {{0x7c2d2aa6,0xe3b91456,0x57d50370,0xd3780207}},	//   npar, иби_, _доаѓ, hoću_,
   {{0x673a0296,0xd37800cd,0x387f01ed,0x37f9002d}},	//   _getj, koću_, _isur_, _тезэ_,
   {{0x56942aa7,0x27e00037,0x25a60f00,0xd6db1c4d}},	//   _нафт, éine_, _fool_, _ста_,
   {{0x25a62aa8,0x20130310,0x69d9033b,0x673a0051}},	//   _gool_, _aixi_, nnwe, _zetj,
   {{0x09a70302,0x64a52aa9,0x201301ed,0xdbc600be}},	//   _खवैय, _фала, _bixi_, mööb,
   {{0x2d822aaa,0x7c2d2aab,0x44072aac,0x25a60051}},	//   _sake_, dpar, _учеб, _zool_,
   {{0x442d2aad,0x764302c2,0x7c2d02a2,0x51f700b5}},	//   lpe_, nsny, epar, _ڈسٹر,
   {{0x201b2aae,0x6000013c,0x764300d7,0x8d66010b}},	//   _fuqi_, döme, isny, ўвае,
   {{0x90c30086,0x442d0c1f,0xfaf80080,0x7c2d2aaf}},	// [2140] _объе, npe_, _šī_, gpar,
   {{0x442d2ab0,0xdb1c02df,0x7a0c01c2,0xe81d0084}},	//   ipe_, _områ, _işti, _पढ़ा_,
   {{0x6da6280a,0x2d820052,0x65b50237,0xada6021d}},	//   _дина, _take_, _náho, _данл,
   {{0xa96a0369,0x673a2129,0x2d82006f,0x3ce5073f}},	//   рида_, _setj, _uake_, _झुके_,
   {{0xa3ca009a,0x673a2ab1,0x661a2ab2,0x7c2d2ab3}},	//   रोड_, _petj, _sutk, cpar,
   {{0x25a600b9,0xe79303fa,0x661a00c3,0x69d90345}},	//   _sool_, дишњ, _putk, anwe,
   {{0xd5ba2ab4,0x442d0173,0x25a606ae,0x673a01f4}},	//   иси_, epe_, _pool_, _vetj,
   {{0x21f92ab5,0x746a1b0a,0x7a0c0160,0x00000000}},	//   vého_, аров_, _oşti, --,
   {{0x7643012f,0x7c290bf4,0x00000000,0x00000000}},	//   asny, _çert, --, --,
   {{0x661a2ab6,0x21f9053d,0xe737002d,0x25a60f00}},	//   _tutk, tého_, _меу_, _wool_,
   {{0x25a62ab7,0x442d2ab8,0x74140e3a,0x4bfb0070}},	//   _tool_, ape_, _کوتا, שליס,
   {{0x21f9024e,0x7c2d2ab9,0xd46a2aba,0x65b500fe}},	//   rého_, ypar, _виде_, _jáhl,
   {{0x38662abb,0x65b52abc,0x9f4e0187,0x55d90070}},	//   ntor_, _záho, šným_, _פֿענ,
   {{0xb4c81e79,0x38662abd,0x9f5a02d0,0xa91d00d8}},	//   ोपी_, itor_, _sipò_, _maža,
   {{0x0ef30033,0xa187010b,0xa91d00f4,0x2013021d}},	//   ছেনঃ_, _дыпл, _laža, _vixi_,
   {{0xd378004e,0x65b50314,0xdd981d29,0xf8bc07df}},	//   leć_, _náhl, ошу_, ्छाय,
   {{0xa91d03fd,0xf1bf004f,0x3a2a0dc3,0x386601f4}},	// [2150] _naža, mhá_, _atbp_, jtor_,
   {{0x7c2d0ffe,0x66021c26,0xfc300037,0x2b4a099e}},	//   rpar, _lhok, ضحك_, _cdbc_,
   {{0x7a400082,0x38662abe,0x395f01ef,0x442d01ed}},	//   _rátá, etor_, _pcus_, zpe_,
   {{0x1959010b,0xa3ca06bc,0x7e7a02b5,0x4e7a02b5}},	//   сады_, रोत_, _פארז, _פארצ,
   {{0xf1b40122,0x69d90110,0xd8b801b2,0x00000000}},	//   וסף_, rnwe, يدها_, --,
   {{0xec3600a5,0xa91d123c,0x6fbb0026,0x31a200d5}},	//   _מאשר_, _daža, उसिं, _dózy_,
   {{0xc9772abf,0x6602034d,0xd3780207,0x00000000}},	//   _وارث, _bhok, deć_, --,
   {{0x66022ac0,0x3179004e,0x65b50334,0xdb0701f4}},	//   _chok, jesz_, _váho, _lojë,
   {{0x442d2ac1,0x38662ac2,0x660201cb,0x317900b5}},	//   upe_, ctor_, _dhok, desz_,
   {{0x65692ac3,0x75d3002d,0x7643010b,0x00000000}},	//   sfeh, văzu, psny, --,
   {{0x656902c9,0x65152ac4,0xdb0e008c,0x00000000}},	//   pfeh, _فوائ, _elbæ, --,
   {{0x442d2ac5,0x91fd0228,0x216a0eb1,0x00000000}},	//   ppe_, stān, щими_, --,
   {{0x66092ac6,0xbcfb00e0,0x43952ac7,0x00000000}},	//   mmek, _mbés, _надс, --,
   {{0x66092ac8,0x25bf0159,0x35d10066,0x1c1f00ab}},	//   lmek, lhul_, _तगड़, _बढ़ल_,
   {{0xa3b80833,0xbcfb000d,0x00000000,0x00000000}},	//   _ظاهر_, _obés, --, --,
   {{0xf1bf024e,0x3179004e,0x9c26075c,0x66092ac9}},	//   chá_, cesz_, здад, nmek,
   {{0x3a2a028b,0x90460037,0x1d072aca,0x6609064a}},	// [2160] _stbp_, _عنده, зети_, imek,
   {{0x0e662acb,0xa91d2acc,0xdb070031,0x66090f5e}},	//   _екон, _raža, _gojë, hmek,
   {{0x66092acd,0xa91d011c,0x00000000,0x00000000}},	//   kmek, _saža, --, --,
   {{0x38662ace,0x58861397,0x9f4a0187,0x7e9b00a5}},	//   ttor_, зыка, dobé_, _הסטו,
   {{0xd90d0609,0xc18d0070,0x660900be,0xbf5900e2}},	//   لیف_, יטאָ, dmek, _điếc_,
   {{0x38662acf,0x66022ad0,0xa91d0254,0xaa462ad1}},	//   rtor_, _shok, _važa, _негл,
   {{0x7bce2ad2,0xd378012e,0xad9b0079,0x660203d0}},	//   _imbu, već_, _mhún, _phok,
   {{0x9adb0122,0xbcfb0d2e,0x2ca02ad3,0x38662ad4}},	//   _החלט, _ibér, oxid_, ptor_,
   {{0x6d4b0037,0xa91d0254,0x00000000,0x00000000}},	//   ógai, _kažn, --, --,
   {{0xad9b0019,0x644f2ad5,0x00000000,0x00000000}},	//   _nhún, ácia, --, --,
   {{0x66020088,0xd3780124,0xdcfd0228,0x25bf009e}},	//   _thok, reć_, _masā, bhul_,
   {{0x80ab00c8,0xa91d15d7,0x7bce0042,0xf1bf0355}},	//   _চেষ্, _lažn, _lmbu, uhá_,
   {{0xbcfb2ad6,0x26090e04,0x44200043,0xf1bf00d5}},	//   _océa, ागरी_, _îi_, rhá_,
   {{0xad9b00e8,0x03a3145f,0xefc82ad7,0x00000000}},	//   _chún, _пичо, пуск_, --,
   {{0xad9b0079,0x33fb0277,0x00000000,0x00000000}},	//   _dhún, _ההגנ, --, --,
   {{0x22f70122,0x7bce2ad8,0xdda8002d,0x00000000}},	//   _מזון_, _ambu, птул_, --,
   {{0xa91d010b,0x6285008d,0xdcfd013a,0x00000000}},	// [2170] _bažn, _áhor, _basā, --,
   {{0x09b5112b,0xbcfb0312,0x00000000,0x00000000}},	//   ंस्य, _ccéa, --, --,
   {{0xa91d01c8,0xfe242ad9,0x00000000,0x00000000}},	//   _dažn, _пьян, --, --,
   {{0x7bce2ada,0x6aaa022a,0x00000000,0x00000000}},	//   _embu, äffa, --, --,
   {{0x2d992adb,0x76480055,0x00000000,0x00000000}},	//   _inse_, _avdy, --, --,
   {{0xbcfb004f,0xab8401af,0x65620176,0xbcb600a5}},	//   _gcéa, _пуск, _acoh, _חפשו_,
   {{0x66092adc,0x00000000,0x00000000,0x00000000}},	//   tmek, --, --, --,
   {{0x2d892add,0x6d5f046a,0x75fe01f4,0x9f4a2ade}},	//   ndae_, ngqa, tëza, robé_,
   {{0x66092adf,0x91fd0080,0x61ef2ae0,0x44390815}},	//   rmek, rtāl, docl, ès_,
   {{0x63aa001e,0xe3b10037,0xe79501df,0x00000000}},	//   _cofn, ئرة_, _تارک, --,
   {{0x91e62ae1,0x2d99053e,0xafdb008c,0x2d890345}},	//   доне, _onse_, rsøl, kdae_,
   {{0xa91d2ae2,0x44b51cae,0x61ef2ae3,0x00000000}},	//   _mažo, _обес, gocl, --,
   {{0xa3ca0d00,0xa91d012e,0x2d890b88,0x00000000}},	//   रोह_, _lažo, ddae_, --,
   {{0x6b872524,0x2d890298,0x63aa00e9,0x3fcc0033}},	//   _najg, edae_, _gofn, লক্ষ,
   {{0xa91d022f,0x248d2ae4,0x394d0124,0x61ef2ae5}},	//   _ražn, lvem_, _odes_, bocl,
   {{0x5bb6052f,0xbcfb004f,0x26160035,0x394d00e0}},	//   ःस्व, _scéa, _पंछी_, _ndes_,
   {{0xdcfd0080,0xa91d0a78,0x6446011c,0x3fe6174b}},	// [2180] _pasā, _pažn, škiv, _ожив,
   {{0x394d2ae6,0x2d992ae7,0x973c0506,0x657b021d}},	//   _ades_, _ense_, _voćk, heuh,
   {{0xa91d01cc,0x00000000,0x00000000,0x00000000}},	//   _važn, --, --, --,
   {{0xe8fa2ae8,0xa91d1eef,0x00000000,0x00000000}},	//   оле_, _dažo, --, --,
   {{0x6d442ae9,0xdb1c0a8a,0x394d2aea,0x00000000}},	//   maia, _omrø, _ddes_, --,
   {{0x62832648,0x6d442ae9,0xc5f8083f,0x394d0086}},	//   _osno, laia, ुष्य_, _edes_,
   {{0xd90d0332,0x5a5501d3,0xba232aeb,0x00000000}},	//   لیہ_, _пъту, _адск, --,
   {{0x1dde0035,0x77b412c3,0x6d442aec,0x394d021e}},	//   नचित, _màxi, naia, _gdes_,
   {{0x186a0819,0x69c20051,0x00000000,0x00000000}},	//   _фази_, mhoe, --, --,
   {{0x6d4401d7,0xa91d012e,0x69c21060,0x926a0f88}},	//   haia, _lažl, lhoe, орма_,
   {{0x6d440f1a,0x973c00cb,0x452a00af,0xc7d7011d}},	//   kaia, _noći, _джен_, _קובי_,
   {{0x85061b15,0x2251033a,0x69c22aed,0xad9b0037}},	//   _قوان, ázka_, nhoe, _chúl,
   {{0x6d442aee,0xbcfb01ef,0x22590067,0x3c24013b}},	//   daia, _acén, ąska_, _növ_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x05b20026,0xafdb01e0,0x6d440952,0x6b872aef}},	//   _जवाब, lsøk, faia, _rajg,
   {{0xa91d0080,0x6d442af0,0xe3b80225,0x00000000}},	//   _ražo, gaia, lkı_, --,
   {{0xafdb0a8a,0x2d8903bc,0x261600ab,0x75fe0055}},	// [2190] nsøk, rdae_, _पूछी_, hëzo,
   {{0x2d89053e,0xe3b805f9,0x09d70099,0x3c242af1}},	//   sdae_, nkı_, ढच्य, _döv_,
   {{0x6d442af2,0x657b022e,0x248d00b8,0x160e22c7}},	//   baia, yeuh, zvem_, ागार_,
   {{0xd5a627f6,0x27e00098,0x2d990160,0x69c22af3}},	//   _صف_, éinn_, _unse_, ghoe,
   {{0xe7eb009a,0x6b872af4,0x6d4f0176,0xe3b801d6}},	//   टवला_, _tajg, _idca, kkı_,
   {{0xd7c80413,0x65bc000d,0xa91d00d5,0x9665081b}},	//   وونه_, _réha, _zažl, екке,
   {{0x65bc00e0,0x00000000,0x00000000,0x00000000}},	//   _séha, --, --, --,
   {{0x69c22af5,0x91fd0029,0xff1800a5,0x65b500ac}},	//   choe, stāj, וקות_, _káhi,
   {{0xa9240187,0x799b2af6,0x6000013c,0xd7fb0200}},	//   _úžas, _inuw, dömn, _дуж_,
   {{0xf7701144,0xa3ca2af7,0x6560004f,0xb6050187}},	//   _نام_, रोल_, agmh, dnáš,
   {{0xeb9200c2,0xe2992af8,0x79890118,0x00000000}},	//   אָר_, чан_, _kaew, --,
   {{0xdb07008a,0x7d1d2af9,0x56b60070,0xcb12011d}},	//   _hljó, _ngss, _אפען_, טלי_,
   {{0xbcfb2afa,0x6d440183,0x79890118,0xb143010b}},	//   _scén, vaia, _maew, ынял,
   {{0x6d441051,0x443d012f,0x75292afb,0x7d1d0176}},	//   waia, _iww_, lcez, _agss,
   {{0xdee32afc,0x64492afd,0x670f2afe,0xa91d0254}},	//   гори, lsei, ाधिक_, _pažl,
   {{0x973c0207,0xdca62aff,0x00000000,0x00000000}},	//   _voći, наби, --, --,
   {{0x64492b00,0x6d440cd3,0x443d00d7,0x6b56004f}},	// [21a0] nsei, raia, _jww_, فضائ,
   {{0x7c2b2b01,0x6d442b02,0x64492b03,0x799b08c7}},	//   ígra, saia, isei, _anuw,
   {{0x6d4402c2,0x443d2b04,0xc0a900bf,0x69c2001e}},	//   paia, _lww_, _فایل_, thoe,
   {{0xdca60610,0x68462b05,0x3940004f,0x201a2b06}},	//   _зами, енда, úis_, _hipi_,
   {{0x69c22b07,0x79892b08,0xad1b00a5,0x201a023c}},	//   rhoe, _daew, _מוכר, _kipi_,
   {{0x64492b03,0x69c22b09,0xc7a31a1c,0x61e40254}},	//   dsei, shoe, личк, _ljil,
   {{0x201a012f,0x644b014e,0x69c203bc,0xa91d00cd}},	//   _mipi_, _avgi, phoe, _zažm,
   {{0x38cb064e,0x9f4a033a,0x75fe00da,0xa91d008b}},	//   _کافی_, dobí_, rëzo, _lažj,
   {{0x69c02b0a,0xdb07008a,0x394600f8,0x91fd0029}},	//   _ilme, _fljó, maos_, stāk,
   {{0xa3ca0755,0x61e40657,0xe1fb0ebd,0x61f60409}},	//   रों_, _ajil, ृष्ण_, _akyl,
   {{0xe3b8008f,0x443d010d,0x9696004b,0x26c70035}},	//   rkı_, _eww_, _яраш, czno_,
   {{0x39460159,0x644902c9,0x442f2b0b,0x26891328}},	//   naos_, bsei, _ftg_, _زخمي_,
   {{0x442f0159,0x443d0051,0xe3b80225,0x00000000}},	//   _gtg_, _gww_, pkı_, --,
   {{0x6d4f0024,0xdecb0043,0x69c003d0,0x41d20253}},	//   _sdca, публ_, _llme, दोबस,
   {{0xdb1e0042,0x3946198d,0x65bc00f6,0x3a2d0207}},	//   hipó, kaos_, _jého, _čepo_,
   {{0x61e40031,0x7a4706fe,0x00000000,0x00000000}},	//   _gjil, _létá, --, --,
   {{0x6ad90066,0x39462b0c,0xa01b0ef0,0x00000000}},	// [21b0] भप्र, daos_, rvös, --,
   {{0x69c02b0d,0xe8000e04,0x61fd2b0e,0xdb15002a}},	//   _alme, _लीला_, llsl, _alzá,
   {{0x32090023,0x2904002f,0xb7b500e2,0x2a780027}},	//   _khay_, _azma_, _lịc, _cprb_,
   {{0x28d200be,0x24860009,0x201a08c7,0x394601ef}},	//   _देहि, _osom_, _zipi_, gaos_,
   {{0x69c0009e,0x201a0176,0x50b30e61,0x00000000}},	//   _dlme, _yipi_, ुनिष, --,
   {{0x2d8b00c8,0x9a872b0f,0x69c02b10,0x79890118}},	//   _hace_, _публ, _elme, _waew,
   {{0x644b00d7,0x3946002a,0x973c0207,0xdb070184}},	//   _svgi, baos_, _noću, _kojí,
   {{0x64492b11,0x2d8b2b12,0x28d2252b,0x644f00cd}},	//   tsei, _jace_, _देवि, šcim,
   {{0x752907e5,0x2d8b0ca0,0x291f0176,0xa8150036}},	//   rcez, _mace_, _igua_, _адаш,
   {{0x61f62b13,0x64492b14,0x7bc500e2,0xb7b500e2}},	//   _skyl, rsei, nhhu, _dịc,
   {{0x13090086,0xa2e508d9,0x32090159,0x9f8f02b1}},	//   ьной_, тонд, _bhay_, _süß_,
   {{0x2d8b2b15,0x201a067f,0x32092b16,0x442f2b17}},	//   _nace_, _sipi_, _chay_, _ttg_,
   {{0x9f4a024e,0x64460009,0x442f2b18,0x7bd701ed}},	//   sobí_, škir, _utg_, kixu,
   {{0x61fd0051,0x2b4308b7,0x00000000,0x00000000}},	//   alsl, _nejc_, --, --,
   {{0x201a2b19,0x2d8b0027,0xdb0715d8,0x61e42b1a}},	//   _vipi_, _bace_, _bojí, _tjil,
   {{0xc6920319,0xd9bd1e82,0xdb0702d7,0x291f00e2}},	//   סאן_, ्फोट, _cojí, _ngua_,
   {{0x201a2b1b,0x2d8b0228,0xab6628cc,0x7bd72b1c}},	// [21c0] _tipi_, _dace_, квал, fixu,
   {{0x291f0083,0xa2c51cce,0x6d4b008d,0xdb1500ac}},	//   _agua_, ानप्, ógar, _slzá,
   {{0x68fb00c8,0xcf570052,0x0f5700c2,0x2d8b2b1d}},	//   _ayud, _בבית_, _ביים_, _face_,
   {{0x68fb0b3e,0x2d8b01d5,0x7a4700fd,0x29d500ac}},	//   _byud, _gace_, _sétá, sťan_,
   {{0x28d200b4,0x39462b1e,0x2d80002d,0x00000000}},	//   _देशि, raos_, meie_, --,
   {{0x291f01ef,0x2d8b2b1f,0x00000000,0x00000000}},	//   _egua_, _zace_, --, --,
   {{0xfaa32b20,0x69262b21,0x2d8b02d7,0x68e90138}},	//   _каро, _амба, _yace_, _exed,
   {{0xa2c52b22,0x5e5702b5,0x24862b23,0x69c00f5e}},	//   ानन्, דיקע_, _psom_, _ulme,
   {{0x68fb011e,0xe8f70009,0x7afc0282,0x39440409}},	//   _gyud, _алт_, _hyrt, _iems_,
   {{0x32090159,0x3944093a,0x2d802b24,0x00000000}},	//   _shay_, _hems_, heie_, --,
   {{0x59b604bc,0xe3af0bdf,0x2d800173,0xd7ef004f}},	//   _अकार, تري_, keie_, _بكل_,
   {{0xb6d902b5,0x2486006f,0xa5da0ae7,0x00000000}},	//   _אַנט, _tsom_, _غبار_, --,
   {{0x2d8b2b25,0x00000000,0x00000000,0x00000000}},	//   _race_, --, --, --,
   {{0x040d00e2,0x39442b26,0x00000000,0x00000000}},	//   _mườn, _lems_, --, --,
   {{0x2d8b2b27,0x32090028,0x39442b28,0xdb0e01f4}},	//   _pace_, _thay_, _oems_, _dobë,
   {{0x60b500b5,0x32090159,0x21200118,0x00000000}},	//   _ممبئ, _uhay_, _ggih_, --,
   {{0x1df80328,0x7afc0183,0x7bd701ef,0x28d2018d}},	// [21d0] теты_, _ayrt, tixu, _देलि,
   {{0xe1ff2b29,0x1ae700c8,0x09bd11b5,0xad9b0037}},	//   lló_, _করবে_, ्फ्य, _mhúi,
   {{0x68fb2b2a,0x2d8b2b2b,0xc9590037,0x65b500ac}},	//   _syud, _tace_, فلاش_, _záhu,
   {{0xe1ff006c,0xa91d2b2c,0x68fb08dd,0x7afc0d51}},	//   nló_, _kaži, _pyud, _dyrt,
   {{0x3da401c8,0x040d01a5,0x7c220037,0xdb0e0107}},	//   _трэб, _cườn, íort, _lobè,
   {{0xa91d00d8,0x040d0019,0x66e50409,0x69d800f6}},	//   _maži, _dườn, лола, éver,
   {{0xf7702b2d,0x39442b2e,0x25af0009,0xa91d18cc}},	//   تان_, _fems_, _pogl_, _laži,
   {{0x7f450024,0xad9b026e,0x39442b2f,0x291f034d}},	//   _lehq, _bhúi, _gems_, _ugua_,
   {{0x7afc00da,0xad9b004f,0x9868006c,0x588400d8}},	//   _zyrt, _chúi, _لینے_, _выха,
   {{0xa91d2b30,0x69d92b31,0xd774042c,0xad9b0079}},	//   _naži, liwe, _نامع, _dhúi,
   {{0x216a2b32,0x61462b33,0xd5752b34,0xdb0e0031}},	//   нини_, лена, _буль, _robë,
   {{0x69d92b35,0x6000013c,0xcf8900a5,0x9f4a0097}},	//   niwe, römm, _מט_, dobá_,
   {{0x753b2b36,0xa91d00ac,0xd24e0220,0x00000000}},	//   mbuz, _baži, ينی_, --,
   {{0x645b2b37,0x69d90088,0xe1ff02d7,0x00000000}},	//   mrui, hiwe, aló_, --,
   {{0xd36e1c64,0x3ebe008a,0x69d92b38,0xe1ff2b39}},	//   _رهي_, átt_, kiwe, bló_,
   {{0x3f8c00ac,0x1c1c04bc,0x69d90054,0x753b0051}},	//   ždu_, _भूजल_, jiwe, nbuz,
   {{0x39442b3a,0x2d802b3b,0x645b2b3c,0xd00f00b5}},	// [21e0] _rems_, reie_, nrui, زلہ_,
   {{0x3ea61964,0x7c3600d7,0x39442b3d,0x00000000}},	//   _биог, rpyr, _sems_, --,
   {{0x645b0037,0x29022b3e,0x7c362b3f,0x7bcb0055}},	//   hrui, _ška_, spyr, ëgua,
   {{0xa91d14a6,0x91fd0029,0x645b11ad,0x08c6002d}},	//   _zaži, stāv, krui, лбен,
   {{0x6d4600ea,0xd7fa02c4,0x00000000,0x00000000}},	//   _ieka, нук_, --, --,
   {{0x91fd0080,0x6d462b40,0x645b2b41,0xa63400d4}},	//   ltāt, _heka, drui, анкі,
   {{0x6d461cad,0xf1c1024e,0xad9b0079,0x645b0223}},	//   _keka, ášky_, _shúi, erui,
   {{0x54542b42,0x645b2b43,0x040d01a5,0x6d462b44}},	//   авит, frui, _tườn, _jeka,
   {{0xa2d909a8,0x6b8e10a2,0x645b0d35,0x79822b45}},	//   _फेब्, _kabg, grui, meow,
   {{0x1ae70b52,0x6d460fe2,0x42740beb,0x7c262b46}},	//   _করতে_, _leka, агос, _mukr,
   {{0xd37700c7,0xb34503e6,0x75fe0031,0x28130118}},	//   учы_, _seçã, hëzi, _اولس,
   {{0x6d462b47,0x645b137b,0xd2572b48,0xf1a702c4}},	//   _neka, brui, ыць_, урон,
   {{0x645b2b49,0x6e25012f,0xa91d00d8,0xf8c404bc}},	//   crui, _suhb, _paži, वनिय,
   {{0xa3e80939,0x53342b4a,0x92942b4b,0x69d92b4c}},	//   _यदि_, _тект, _вакц, ziwe,
   {{0xdd9b0f2a,0x44260657,0xa91d2b4d,0x7c262b4e}},	//   нша_, _huo_, _važi, _aukr,
   {{0x6d462b4f,0x442600d8,0x628a2b50,0x7c262b51}},	//   _ceka, _kuo_, _isfo, _bukr,
   {{0xa3e800b4,0x6298025c,0x79820118,0x41c40c26}},	// [21f0] _यदा_, _hrvo, deow, _دقيق,
   {{0xf1bf00b8,0x7c26010b,0x69d800a2,0x00000000}},	//   lká_, _dukr, èven, --,
   {{0x3f8302c4,0x44262b52,0x69d92b53,0x00000000}},	//   meju_, _luo_, tiwe, --,
   {{0x195900c7,0x8937004f,0x6d462b54,0x75220054}},	//   тады_, اعضا, _geka, _ngoz,
   {{0x44260a93,0x69d92b55,0x98a52b56,0x3158016b}},	//   _nuo_, riwe, риле, רידן_,
   {{0x65b50076,0xd2461168,0x6298006c,0x7bd501ae}},	//   _náhr, _ون_, _orvo, _umzu,
   {{0x6d462b57,0xf40a0033,0x00000000,0x00000000}},	//   _yeka, রদার_, --, --,
   {{0x44260dc3,0x64420103,0xf77301df,0x7c260103}},	//   _buo_, _bwoi, _گار_, _yukr,
   {{0x629803ad,0x05a60086,0x44262b58,0x58d50012}},	//   _arvo, рвый_, _cuo_, _тоат,
   {{0xf7731d05,0xe2990202,0x645b2b59,0x67210254}},	//   _دار_, вао_, rrui, _uglj,
   {{0x645b2407,0x59b90d2a,0x3f832b5a,0x629800f4}},	//   srui, _आवार, deju_, _crvo,
   {{0x645b1e7e,0x6298011c,0x947900af,0x628a008c}},	//   prui, _drvo, _аску_, _dsfo,
   {{0x03a52b5b,0x628a2b5c,0x62980120,0x04450382}},	//   _вило, _esfo, _ervo, _телн,
   {{0x6d461221,0x91fd0029,0xbcfb0079,0x88ba0070}},	//   _seka, tuāc, _gcéi, דזשי,
   {{0x6d462b5d,0x4426012f,0x7c262b5e,0x00000000}},	//   _peka, _zuo_, _sukr, --,
   {{0xf1bf114d,0x65b5016f,0x67170518,0x25ad2b5f}},	//   cká_, _záhr, धेयक_, njel_,
   {{0x0b462b60,0xd7c500a1,0x6d462b61,0xa91d0207}},	// [2200] инан, वसाच, _veka, _kažu,
   {{0x75fe00da,0x91fd0029,0x6d462b62,0xdb0e0139}},	//   rëzi, grāf, _weka, _dobî,
   {{0x6d462b63,0xa91d2b64,0xa9262b65,0x25bf2b66}},	//   _teka, _mažu, адел, kkul_,
   {{0x25ad2b67,0xd37800cd,0x6d46095f,0x25bf0207}},	//   jjel_, miće_, _ueka, jkul_,
   {{0xd378124d,0xe8940de9,0x83fd00b5,0xa96702fb}},	//   liće_, саль, ntős, рича_,
   {{0x91fd0ae0,0xd90d0a86,0x75220036,0xf1bf0355}},	//   ntār, ریل_, _sgoz, zká_,
   {{0x44260133,0x4b7b02da,0x6442006a,0xd3780129}},	//   _suo_, _שאלו, _swoi, niće_,
   {{0x2d92142f,0xbcfb004f,0x442602fb,0xa3d30722}},	//   ndye_, _scéi, _puo_, सोस_,
   {{0xa4d400d8,0x98bd0067,0xa91d00f4,0x91fd0228}},	//   сопі, tawą_, _sažv, ktār,
   {{0x62980912,0xa5070274,0xd3780207,0x61e60345}},	//   _prvo, шења_, kiće_, enkl,
   {{0xe7e3009a,0x3f8300d8,0xf1bf0bca,0x25ad02c4}},	//   कचरा_, veju_, tká_, bjel_,
   {{0x44262b68,0x28db0fbf,0x64420035,0xd378011c}},	//   _tuo_, _मेडि, _twoi, diće_,
   {{0xe3af2292,0xdb0e01d6,0x75d3004f,0xf1bf00ac}},	//   سری_, _albü, _بينا, rká_,
   {{0xf1bf0076,0xd3780124,0x245700af,0x33f315dc}},	//   ská_, fiće_, _ташь_, _وسوس,
   {{0x3f832b69,0x3dc92b6a,0x245200b5,0x00000000}},	//   reju_, thaw_, _انڈس, --,
   {{0x3dc9010d,0x3f832b6b,0xa91d07e7,0x82330911}},	//   uhaw_, seju_, _zažu, _بروا,
   {{0x91fd0029,0x3f832b6c,0x26e22b6d,0x3b552b6e}},	// [2210] stās, peju_, गपुर_, йкар,
   {{0x3dc9006f,0x60c02b6f,0xd37800cd,0x00000000}},	//   shaw_, ømme, biće_, --,
   {{0x6e950082,0x200310ec,0xad9b2b70,0x00000000}},	//   _الجا, mlji_, _bhút, --,
   {{0x6286004e,0xdb0e0138,0x999800af,0xad9b0312}},	//   łkow, _albó, икхт_, _chút,
   {{0x9f5101c0,0x18210cea,0xb4e50067,0x22590067}},	//   hozí_, मदेव_, _नशे_, ąski_,
   {{0x26e200a1,0xdb1c009e,0x68190260,0x9f4a0176}},	//   गपूर_, _flrà, _kňdi, llbò_,
   {{0x7c2d013b,0x7bc72b71,0x25bf0523,0x75fe0031}},	//   lqar, _ilju, tkul_, hëzu,
   {{0x59f903ad,0x3940008a,0xa2c5112b,0x6b8500d7}},	//   _себя_, ðist_, ानस्, lehg,
   {{0x7bc702dd,0x38600014,0x26c1016f,0x7c2d2b72}},	//   _klju, àirt_, šho_, nqar,
   {{0xd6db1917,0x68e40037,0x25bf022e,0x00000000}},	//   _ите_, úide, skul_, --,
   {{0x57fa016b,0x200300f4,0x00000000,0x00000000}},	//   _עלעו, dlji_, --, --,
   {{0xd3780b16,0xad9b0079,0x930d0225,0x00000000}},	//   viće_, _mhús, _ışık, --,
   {{0x7bc70282,0x34ab004f,0x61e62b73,0xe3ae0384}},	//   _olju, _جداً_, rnkl, _еб_,
   {{0x65691b4a,0xd378011c,0x6d4b0093,0x9f580031}},	//   lgeh, tiće_, ðgan, morë_,
   {{0xed5a0f94,0xada620b6,0x6da60665,0x75fe01f4}},	//   лов_, бавл, бива, rëzv,
   {{0xd3780280,0x65692b74,0xb146002d,0xdb1200a2}},	//   riće_, ngeh, _унил, _égér,
   {{0x7bc700cb,0x200305e2,0x9f5801f4,0x69d800f7}},	// [2220] _blju, blji_, norë_, èvem,
   {{0x65bc02e1,0x7f86004f,0xbb4a00f8,0xd378012e}},	//   _véhi, _الدن, الان_, piće_,
   {{0x16170084,0x387f01d7,0xdb0e021e,0x262700f4}},	//   दगार_, _apur_, _albò, _uđoh_,
   {{0x27e90037,0xdb1c01ff,0xdce400f4,0x7bc700b5}},	//   éann_, _omrö, lgič, _elju,
   {{0x28d221b2,0xfbd100b5,0xb4d6046c,0x28db1140}},	//   _देखि, ستے_, _सधे_, _मेदि,
   {{0xab270011,0x207b025a,0x00000000,0x00000000}},	//   _гора_, ראסא, --, --,
   {{0x7bde2b75,0x65692b76,0x8f9b00a5,0x2a35010b}},	//   mipu, fgeh, טיסי, _мэтр,
   {{0x7bde10cd,0x69cb2b77,0x65692b78,0x7434002d}},	//   lipu, chge, ggeh, ониф,
   {{0xc34a2b79,0x41cc06fe,0x387f009e,0xdb0e0183}},	//   ляне_, ासनस, _gpur_, _mobí,
   {{0x7bde01ca,0x32540c9f,0x2bfa021a,0xdcef00ea}},	//   nipu, овор, ्तिं_, _sacī,
   {{0x200304c3,0xd5af2b7a,0xc2050067,0xa2a80099}},	//   vlji_, _ес_, रतलब_, टमध्,
   {{0x645d0f56,0x7bde00d1,0x6fcb027d,0x69c22b7b}},	//   ásic, hipu, _müce, nkoe,
   {{0x7bde00bf,0x2bfa0096,0x20030478,0x644f0138}},	//   kipu, ्तां_, tlji_, ácit,
   {{0x75fe0031,0x02a61b96,0x7bde023c,0xe29a00e2}},	//   rëzu, _грим, jipu, _trư_,
   {{0x7bde2b7c,0x63770122,0x91fd0029,0xe3af2b7d}},	//   dipu, _הגוף_, trād, _سرو_,
   {{0x1ae70083,0x7c2d2b7e,0x7bc707e7,0x7bde0345}},	//   _করলে_, tqar, _slju, eipu,
   {{0x7bc72209,0x61ed02c4,0x20030121,0x22ae0095}},	// [2230] _plju, _ijal, plji_, dəki_,
   {{0xad9b004f,0x7c2d1952,0x61ed2b7f,0x7bde09e7}},	//   _chúr, rqar, _hjal, gipu,
   {{0x387f2b80,0x61ed008d,0x7c2d0c6f,0xbcfb2b81}},	//   _spur_, _kjal, sqar, _acét,
   {{0x39492b82,0xdb0e0160,0x7bde0298,0x69c21472}},	//   úas_, _bobâ, aipu, gkoe,
   {{0x7c2d01ef,0x27e92b83,0x61ed2b84,0xdd9800af}},	//   qqar, éano_, _mjal, _ушэ_,
   {{0x61ed023a,0xad9b0312,0x7bc72b85,0x98481ac5}},	//   _ljal, _thús, _ulju, сяца_,
   {{0x61ed2b86,0x3ffc0070,0x65692b87,0xa01b033b}},	//   _ojal, אפגע, tgeh, rwöh,
   {{0xe4592070,0x61ed2b88,0x9f5801f4,0x8beb0083}},	//   ажи_, _njal, torë_, _কঠিন_,
   {{0x65692b89,0x69c901ed,0xb3c9002d,0x00000000}},	//   rgeh, _ilee, илиз_, --,
   {{0x61ed2b8a,0xa3d30953,0x394f008a,0xd7fb2b8b}},	//   _ajal, सों_, lags_, _суб_,
   {{0xf7701144,0x69c92601,0x61ed2b8c,0x9f580031}},	//   _سال_, _klee, _bjal, sorë_,
   {{0x059613cf,0x216a08a6,0x9f58014c,0x386000cd}},	//   _وانگ, шими_, moré_, šire_,
   {{0x61ed2b8d,0xdb0e00a0,0x9f58000d,0x3f930065}},	//   _djal, _robí, loré_, _baxu_,
   {{0xee3a2b8e,0xd9b609f9,0x61ed0861,0x69c22b8f}},	//   инг_, _अक्ट, _ejal, zkoe,
   {{0x61ed2b90,0x80db00c8,0xdce404c3,0x9f5800a2}},	//   _fjal, _যুদ্, rgič, noré_,
   {{0x61ed2b91,0x2251024e,0x80662b92,0x6da32b93}},	//   _gjal, ázku_, _движ, миса,
   {{0x7bde2b94,0xd3780254,0x394f2b95,0x3f9300d5}},	// [2240] tipu, lića_, dags_, _faxu_,
   {{0x69db2b96,0x69c92b97,0x81ac0033,0x00000000}},	//   _amue, _alee, _গতি_, --,
   {{0x7bde2b98,0xd3780254,0x8eb3006c,0xdb1502d0}},	//   ripu, nića_, _ہمیش, _jozè,
   {{0x7bde2b99,0x7ae30037,0x09060043,0xdca61052}},	//   sipu, únta, опен, _дами,
   {{0x69c22b9a,0x91fd00ea,0xdb15000d,0xd3780207}},	//   rkoe, duāl, _lozè, hića_,
   {{0x69c22b9b,0xa09b0317,0xd378011c,0x56940009}},	//   skoe, יינט, kića_, закт,
   {{0x394f2b9c,0xeb9100c2,0x3a2a011e,0xd378011c}},	//   bags_, _אָן_, _uubp_, jića_,
   {{0x69c904f4,0xd3780254,0x00000000,0x00000000}},	//   _glee, dića_, --, --,
   {{0x6b990098,0xb7e6290a,0x249d099e,0x38660f00}},	//   _éagó, _джак, _crwm_, quor_,
   {{0x61ed2b9d,0xd37800cb,0x9f58000d,0x7de500c7}},	//   _sjal, fića_, boré_, rėsi,
   {{0x69c90086,0xd378011c,0x67280124,0xc7b300a5}},	//   _ylee, gića_, _igdj, _קבע_,
   {{0x20180055,0x1aec0831,0x00000000,0x00000000}},	//   emri_, _করাই_, --, --,
   {{0xc95302b8,0xa5070d28,0x80db0461,0x3a2402d7}},	//   ומר_, _деца_, _पेशे, _mimp_,
   {{0x4255006c,0xcf27004f,0xd378011c,0x00000000}},	//   _کنٹر, ترحي, bića_, --,
   {{0xcddb2b9e,0x61ed0093,0x25a60051,0x91fd00ea}},	//   ања_, _tjal, _knol_, grāc,
   {{0xc7b80009,0x61ed00ac,0x7bdc034d,0xad9b0098}},	//   _lođ_, _ujal, _amru, _chúp,
   {{0x61fd0138,0x7e67006d,0xbcfb2b9f,0x00000000}},	// [2250] mosl, sujp, _acér, --,
   {{0x61fd1550,0xaac700f3,0x69c90191,0x7a330024}},	//   losl, يتان, _slee, _aħta,
   {{0x69c92ba0,0x8ae702ce,0xaa95004f,0x394f09af}},	//   _plee, ціал, ثلاث, tags_,
   {{0xbcfb01ba,0x3a240160,0x00000000,0x00000000}},	//   _dcér, _cimp_, --, --,
   {{0x394f2ba1,0x9aa500b5,0x69c9152b,0xe739029f}},	//   rags_, _کمزو, _vlee, бел_,
   {{0x61fd2ba2,0x2904001e,0x00000000,0x00000000}},	//   hosl, _dyma_, --, --,
   {{0x61fd2187,0x2bfa01d1,0x6fc201ba,0x91fd0029}},	//   kosl, ्तरं_, _dôch, tuāl,
   {{0xd37801cc,0x69c9022e,0x2129104e,0xd90e006c}},	//   vića_, _ulee, _ngah_, ئیے_,
   {{0x478b0086,0x61fd2ba3,0xdb1c0523,0x00000000}},	//   _всем_, dosl, _elrä, --,
   {{0x63b8006d,0x394d2ba4,0xd3780254,0x25a601ef}},	//   _covn, _hees_, tića_, _enol_,
   {{0x88bd0083,0x394d2ba5,0x6b95123c,0x9f4e00b8}},	//   _অধিক, _kees_, _mazg, áním_,
   {{0x61fd2ba6,0xd3782ba7,0x394d0421,0x6b950065}},	//   gosl, rića_, _jees_, _lazg,
   {{0x394d2ba8,0xd9bd0083,0x64a52ba9,0x2d89143f}},	//   _mees_, _আগাম, _хала, deae_,
   {{0x43750779,0x394d2baa,0x443f2bab,0x78a600fb}},	//   _זײַן_, _lees_, mpu_, _ákve,
   {{0x443f2bac,0x6012008a,0x61fd00ee,0xc332100a}},	//   lpu_, væmd, bosl, _אוו_,
   {{0x394d0221,0xc8bd2bad,0x62832bae,0x63b80506}},	//   _nees_, ्नाट, _ipno, _zovn,
   {{0xdd8f1b15,0x28db00b4,0xafe600af,0x6b951bfa}},	// [2260] دوق_, _मेलि, _ноил, _bazg,
   {{0x3a240260,0x443f2baf,0x600001ff,0x2bc10099}},	//   _simp_, ipu_, röms, _शकणा,
   {{0x394d17b0,0xc7b8011c,0xdb0e00d5,0x00000000}},	//   _bees_, _rođ_, _bobá, --,
   {{0xa96a0c06,0x394d2bb0,0xf1cc2bb1,0x3f8a2bb2}},	//   сида_, _cees_, ासिन, lebu_,
   {{0x394d2139,0x7bc5006d,0x443f2568,0x186703f5}},	//   _dees_, bkhu, jpu_, зачи_,
   {{0x3f982bb3,0x6d44010b,0x628301bf,0x6e26010d}},	//   ndru_, lbia, _opno, _hikb,
   {{0x63b80076,0x3a240012,0xd9462bb4,0x2bc100a1}},	//   _rovn, _timp_, _неви, _शकता,
   {{0x394d0626,0x6fcb033e,0x3f8a2bb5,0x6d4401a3}},	//   _gees_, _müca, hebu_, nbia,
   {{0x61fd2bb6,0x443f010d,0x6b951008,0xd49700af}},	//   vosl, gpu_, _yazg, прэ_,
   {{0x3f8a0124,0x6027000d,0xdb0e00ac,0x883b00a5}},	//   jebu_, hémè, _zobá, _לתמו,
   {{0x394d0189,0x63b800e2,0x7d062bb7,0x00000000}},	//   _yees_, _vovn, _lyks, --,
   {{0x394d01e8,0x25a6001e,0x3f980228,0x00000000}},	//   _xees_, _unol_, edru_, --,
   {{0x61fd15d8,0x64a32bb8,0x859b00a5,0x77bd0310}},	//   rosl, _паца, _לשאו, _tèxt,
   {{0xb7bd0043,0x61fd2bb9,0x00000000,0x00000000}},	//   _puţi, sosl, --, --,
   {{0x6b951851,0x61fd2bba,0xddd02bbb,0x64400c7c}},	//   _razg, posl, _šeši, lpmi,
   {{0x6d442bbc,0x00000000,0x00000000,0x00000000}},	//   gbia, --, --, --,
   {{0x394d2bbd,0x6e260345,0x7de500c7,0x660208c7}},	// [2270] _rees_, _dikb, dėst, _mkok,
   {{0xfe6e07e4,0xbca40037,0x60cf04d4,0x7d060282}},	//   دگی_, عملي, ınmı, _dyks,
   {{0xa3cd0084,0x6d442bbe,0x7bc5069d,0x394d2bbf}},	//   रसत_, bbia, rkhu, _pees_,
   {{0x394d0221,0x3ebe2bc0,0x6602251e,0x00000000}},	//   _qees_, ätte_, _nkok, --,
   {{0x394d2bc1,0x315802b5,0xa91d00d5,0x6b950116}},	//   _vees_, ליאן_, _obže, _tazg,
   {{0x394d250a,0x66022bc2,0x6d4f2bc3,0x7de50031}},	//   _wees_, _akok, _heca, rėsu,
   {{0x6d4f1690,0x99672bc4,0x00000000,0x00000000}},	//   _keca, _нтал, --, --,
   {{0x7c2706b3,0x84592bc5,0x6d4f2bc6,0x6e3800b5}},	//   _hijr, орот_, _jeca, _évbe,
   {{0x855400bf,0x6add29ce,0x6f0900b8,0xb4c70d41}},	//   ریور_, _मधुर, řech, ईने_,
   {{0x6d4f2bc7,0x443f2bc8,0x00000000,0x00000000}},	//   _leca, rpu_, --, --,
   {{0x7c2f0012,0x6d5d1554,0x2bae00a1,0xa18a2031}},	//   _lucr, _odsa, घाता, обна_,
   {{0x443f2bc9,0x6d4f2bca,0x798b00e9,0x3f8a2bcb}},	//   ppu_, _neca, negw, webu_,
   {{0x66092bcc,0xeb0a00b4,0xc4fb00d1,0x661b2bcd}},	//   mlek, _वर्त_, _اعضا_, mmuk,
   {{0x6d4f0051,0x661b2bce,0x7d062bcf,0x443d2bd0}},	//   _aeca, lmuk, _ryks, _itw_,
   {{0x6d4f2bd1,0x442f2bd2,0x3f8a2bd3,0xd0070c8d}},	//   _beca, _hug_, rebu_, фере_,
   {{0x44272bd4,0x6d4f2bd5,0x7e610093,0x443d2bd6}},	//   _hin_, _ceca, álpa, _ktw_,
   {{0x6d442bd7,0x442f2bd8,0xfce3015a,0x6d4f0aed}},	// [2280] rbia, _jug_, вото, _deca,
   {{0x8bf10083,0x7d0600d8,0x7c2f00a2,0x6d5d03d0}},	//   _জীবন_, _vyks, _ducr, _edsa,
   {{0x442f2bd9,0x6eb50d53,0x66091b2a,0x7d062bda}},	//   _lug_, _उपयु, klek, _wyks,
   {{0x6d4f2bdb,0x661b00d7,0x442f00af,0xc8ca0286}},	//   _geca, jmuk, _oug_, يوان_,
   {{0x442f0189,0xa3cd2207,0x443d006d,0x645d0187}},	//   _nug_, रसा_, _ntw_, ásil,
   {{0x44272bdc,0xb8d60f09,0x66092bdd,0x00000000}},	//   _nin_, _छप_, elek, --,
   {{0x8b230cf9,0x34b800c0,0xd6d0004f,0x442f06b5}},	//   _адре, ेन्द, طقة_, _aug_,
   {{0xd5b00514,0x6609082b,0x661b11e9,0x442f2bde}},	//   افة_, glek, gmuk, _bug_,
   {{0x442f2bdf,0x92ea0033,0x443d0312,0x00000000}},	//   _cug_, _মরে_, _ctw_, --,
   {{0xa3d8006a,0x394600d8,0xe8d7011d,0x443d2be0}},	//   ठों_, lbos_, _חומר_, _dtw_,
   {{0x44272be1,0xbcfb0248,0x66092be2,0xb7d70987}},	//   _din_, _idée, blek, _تولا_,
   {{0x44272be3,0x7dc3007c,0x442f0395,0xf6690037}},	//   _ein_, _tõsi, _fug_, _رحمه_,
   {{0x29f80c21,0x39462be4,0xf77100b5,0x442f2be5}},	//   mčad_, ibos_, _جاۓ_, _gug_,
   {{0x44272be6,0x6d4f203f,0x9f4301f4,0x6600150c}},	//   _gin_, _seca, mijë_, lomk,
   {{0x7c2f0fcb,0x442f033b,0x7c270051,0x9f580176}},	//   _sucr, _zug_, _rijr, corí_,
   {{0x44272be7,0x442f0189,0xa01b033b,0x29f800cd}},	//   _zin_, _yug_, gwör, nčad_,
   {{0x44272be8,0x6d4f2be9,0x00000000,0x00000000}},	// [2290] _yin_, _veca, --, --,
   {{0x2fc700e8,0x44272bea,0x60c0022a,0x660900b5}},	//   _ông_, _xin_, ämme, zlek,
   {{0x6d4f2beb,0x798b2bec,0xf09f0176,0x00000000}},	//   _teca, tegw, lvà_, --,
   {{0x3866001e,0x6d5d01b4,0x6eae000c,0x7f5502d7}},	//   fror_, _udsa, ीहरु, lazq,
   {{0xdd3a0052,0x52ca0253,0x660903e0,0x798b0010}},	//   _מערכ, ानुस, vlek, regw,
   {{0xe7392bed,0x2d992bee,0xa69500ed,0x7dd108c8}},	//   чек_, _hase_, ериј, _dåse,
   {{0x4427134c,0x2d992bef,0x442f2bf0,0x27e9011c}},	//   _rin_, _kase_, _sug_, đan_,
   {{0x44272bf1,0xfc3f004f,0x9f5801ba,0x38662bf2}},	//   _sin_, _tríd_, vorí_, bror_,
   {{0x66092bf3,0x661b0388,0x44270cdb,0x91fd013a}},	//   rlek, rmuk, _pin_, trān,
   {{0xe3b10514,0xe8bd02e4,0x44272bf4,0x66092bf5}},	//   ارة_, ्नीच, _qin_, slek,
   {{0x44272bf6,0x2d992bf7,0x0394010b,0x00000000}},	//   _vin_, _oase_, трыя, --,
   {{0x442f01a9,0x2d992bf8,0x44272bf9,0x7dca00d5}},	//   _tug_, _nase_, _win_, _rýso,
   {{0x44272bf9,0x2ec801c0,0x30752bfa,0x443d0a5a}},	//   _tin_, रन्त, курс, _utw_,
   {{0x44272bfb,0xd01221a0,0x2d990a8c,0xe456016b}},	//   _uin_, الس_, _aase_, _טינט_,
   {{0x2d990dc5,0xf8bd000c,0x394600d8,0x91e62bfc}},	//   _base_, ्नुप, ybos_, _поке,
   {{0x2d992bfd,0xdb1c0248,0x7dca00ac,0x00000000}},	//   _case_, _forê, _výso, --,
   {{0xa3c302cb,0x3dd202c7,0x2d992bfe,0x8fa62626}},	// [22a0] _एका_, rhyw_, _dase_, _запе,
   {{0x61e60d6f,0xfc3f0082,0x395f2bff,0x320200ac}},	//   likl, _dtí_, _adus_, loky_,
   {{0x160f00b1,0x6600002f,0x41b30118,0xc3210033}},	//   ातार_, yomk, _شمیر, পুরি_,
   {{0x61e62c00,0x39462c01,0x2d992c02,0x38661124}},	//   nikl, ubos_, _gase_, tror_,
   {{0xe8942246,0x3f9a2c03,0x98a32bfc,0xa92700d4}},	//   таль, _kapu_, лице, ніше_,
   {{0x6d562c04,0x2d990e6a,0x38662c05,0x2d800b88}},	//   laya, _zase_, rror_, lfie_,
   {{0x3f9a2c06,0x66000791,0xdb1c01f4,0xd90d00b5}},	//   _mapu_, tomk, _morë, میہ_,
   {{0x6d562c07,0xceb30052,0x3949008a,0x3f9a0029}},	//   naya, ריה_, ðast_, _lapu_,
   {{0x61e62c08,0x18670370,0x29f800f4,0x00000000}},	//   dikl, _пати_, rčad_, --,
   {{0x6d5611e9,0xb3460279,0x7dca0093,0xb3560df3}},	//   haya, diçõ, _sýsl, ریبا_,
   {{0x6d561292,0x6b811e70,0x61e62c09,0xd25701e0}},	//   kaya, _ölge, fikl, нця_,
   {{0x6d562bab,0x25bd035f,0xab64027d,0x7c360055}},	//   jaya, _gowl_, ldüğ, kqyr,
   {{0x7dca0076,0x6d562c0a,0x1ae700c8,0x2ca02c0b}},	//   _výsl, daya, _করছে_, jvid_,
   {{0x6fcb0095,0x2d9900af,0x200501ba,0x31602c0c}},	//   _gücl, _sase_, ôli_, _ediz_,
   {{0x2d99142f,0x2d802c0d,0xdb1c00da,0xdb152c0e}},	//   _pase_, ffie_, _dorë, _pozí,
   {{0x6d5621ea,0x32530133,0xb3460279,0x3ebe013c}},	//   gaya, _свър, biçõ, ätta_,
   {{0xdb150187,0xacf82c0f,0xa91d232f,0x9f5801f7}},	// [22b0] _vozí, енту_, _obža, borà_,
   {{0xdb1c2c10,0x9f5801f7,0xe7e201c0,0x00000000}},	//   _korè, corà_, कोमा_, --,
   {{0x6d561d02,0x2003010b,0x3a752c11,0x2d9900be}},	//   baya, moji_, тлер, _tase_,
   {{0x20032c12,0x6d5601cb,0x9f580132,0x91fd00ec}},	//   loji_, caya, porã_, krām,
   {{0xcf2701cb,0x7dda0355,0xdb1c00e0,0x83fd00b5}},	//   _ترکي, růst, _lorè, rtőz,
   {{0x66e51129,0x61e62c13,0x200300c7,0x00000000}},	//   кола, zikl, noji_, --,
   {{0x34c9210a,0x9f58021d,0x00000000,0x00000000}},	//   िन्द, norá_, --, --,
   {{0x20030054,0x00000000,0x00000000,0x00000000}},	//   hoji_, --, --, --,
   {{0x61e60568,0x22402c14,0x20032c15,0x91fd02d4}},	//   vikl, _čika_, koji_, grām,
   {{0xad9b21ae,0x20032c16,0x799b002f,0xd75918dd}},	//   _skúl, joji_, _hauw, _آلات_,
   {{0x6d560247,0x3f9a2c17,0x27e700fb,0x799b2c18}},	//   yaya, _rapu_, minn_, _kauw,
   {{0xe3b1064e,0x6d560118,0x27e72c19,0xb3460279}},	//   ارک_, xaya, linn_, tiçõ,
   {{0x61e62c1a,0x32020187,0x3f9a2c1b,0xc95200a5}},	//   rikl, roky_, _papu_, סמך_,
   {{0xb3460370,0x6d5609df,0x2003108a,0x799b2c1c}},	//   riçõ, waya, goji_, _lauw,
   {{0x6d562c1d,0x0cbc00b4,0xb34603e6,0xa3d62207}},	//   taya, ोन्म, siçõ, _सतत_,
   {{0x27e7004a,0xdce40c99,0x799b2c1e,0x69cb02a2}},	//   hinn_, ngić, _nauw, jkge,
   {{0x7e7c1cc4,0x61e42c1f,0x3f9a0225,0x200319f6}},	// [22c0] strp, _imil, _tapu_, boji_,
   {{0x6d562c20,0x80db00c8,0xfaa62c21,0x9f4a05c9}},	//   saya, _যুক্, казо, robó_,
   {{0x799b2c22,0x6d562c23,0x27e72c24,0x81f70416}},	//   _bauw, paya, dinn_, _سفیر_,
   {{0x5e5700c2,0x2b4d02c4,0xe8ea0183,0x186a0279}},	//   _ביטע_, _đece_, ммед_, дади_,
   {{0xf7720642,0x27e7008a,0x7641010b,0x61e40054}},	//   لاغ_, finn_, _atly, _mmil,
   {{0x27e72c25,0xda661c2d,0x6a86021d,0xf0930317}},	//   ginn_, _لاري, _илга, ינד_,
   {{0x61e42c26,0xbcfb2c27,0xd6cf0ad9,0x7dc3007c}},	//   _omil, _idéa, يقه_, _tõst,
   {{0x6b9c2c28,0xd87600b5,0x69cb01ae,0xd378011c}},	//   _harg, _لائب, ckge, mići_,
   {{0xb4be0712,0xb4cc2c29,0x6b9c2c2a,0x02ca2c2b}},	//   ीने_, रने_, _karg, ान्न,
   {{0x69c02c2c,0x61e42055,0x27e701a6,0x799b0035}},	//   _home, _amil, cinn_, _zauw,
   {{0xa3e304cc,0x6b9c2c2d,0xd6c4064e,0xa3c30006}},	//   _नगर_, _marg, _حمای, _एकर_,
   {{0x6b9c2c2e,0xdb1c1498,0x386901a0,0x00000000}},	//   _larg, _coré, šare_, --,
   {{0x20030bc5,0xdb15002a,0xdb1c14e1,0xd3780009}},	//   toji_, _mozá, _doré, hići_,
   {{0xbcfb004f,0xd378042a,0xa3e10c67,0x60c0013c}},	//   _ndéa, kići_, नोद_, ämma,
   {{0xd3780129,0x20032c2f,0xdd9b005f,0x9e0700d4}},	//   jići_, roji_, мша_, вчал,
   {{0x69c02c30,0xd3780254,0xdb1c0118,0x20032c31}},	//   _nome, dići_, _goré, soji_,
   {{0x32090c86,0xa3d607b5,0x799b0223,0x78a20009}},	// [22d0] _ikay_, _सता_, _rauw, jvov,
   {{0x6b9c2140,0xfc3f2675,0xd3780506,0xe8120066}},	//   _carg, _cría_, fići_, _ढीला_,
   {{0x6b9c2c32,0x69c001e4,0x799b067f,0x656200a0}},	//   _darg, _bome, _pauw, _odoh,
   {{0xfc3f01ef,0x644201a3,0x27e7033b,0x645b0298}},	//   _ería_, _otoi, winn_, ysui,
   {{0x27e72c33,0x26c70297,0x69cb0c7c,0x6b9c0044}},	//   tinn_, wyno_, rkge, _farg,
   {{0x629805e2,0x628a01b4,0xd378011c,0x656200e0}},	//   _osvo, _opfo, bići_, _adoh,
   {{0x27e72c34,0x69c02c35,0x64422c36,0xd3780009}},	//   rinn_, _fome, _atoi, cići_,
   {{0x27e72c37,0x69c02c38,0x09ca0083,0xd8b7006c}},	//   sinn_, _gome, লোবা, _لگتا_,
   {{0x6b9c027d,0x3f9101d7,0x753b2c39,0xad9b00a0}},	//   _yarg, kezu_, rcuz, _akúk,
   {{0x6b9c0176,0x69c00a75,0x645b2c3a,0x3a2d2c3b}},	//   _xarg, _zome, rsui, _hiep_,
   {{0x645b2c3c,0x42261a24,0xdb1c0bb0,0x64422c3d}},	//   ssui, лдов, _poré, _etoi,
   {{0x9f4e0076,0xa06a2c3e,0x7dca0334,0xcb1200a5}},	//   čník_, нама_, _výsk, מלי_,
   {{0x6fcb01ae,0xa91d00d8,0x629801f7,0x3a2d0051}},	//   _küch, _pažy, _esvo, _miep_,
   {{0xdee61d30,0x3a2d01e4,0x83350070,0x00000000}},	//   гоги, _liep_, _גאַס_, --,
   {{0xe7f6018d,0xdb1c01cb,0x00000000,0x00000000}},	//   ेवता_, _toré, --, --,
   {{0xd3782c3f,0x6b9c2c40,0xa01b006c,0x68fb00a8}},	//   vići_, _sarg, gtöb, _oxud,
   {{0x69c003d0,0x3b8602ee,0x6b9c2c41,0xb88600b8}},	// [22e0] _rome, ллаг, _parg, _kníž,
   {{0x69c01c33,0xd378011c,0x6b9c2c42,0x00000000}},	//   _some, tići_, _qarg, --,
   {{0x69c02c43,0x68fb043f,0x7dca0093,0xc3320122}},	//   _pome, _axud, _lýsi, צוא_,
   {{0x6b9c272d,0xd3780c0a,0xbcfb2c44,0x9f580443}},	//   _warg, rići_, _idén, forç_,
   {{0x2d922c45,0x1754111d,0x6fcb02c9,0xd3780c99}},	//   meye_, авля, _büch, sići_,
   {{0x6fcb02c9,0x78a20187,0x69c00122,0xd37800cd}},	//   _rück, rvov, _wome, pići_,
   {{0x64422c46,0xb4cc1371,0xa2630023,0x36d40036}},	//   _stoi, रन्_, _quố, ройр,
   {{0x2d922c47,0xa2a200dc,0xa5342c48,0x62980051}},	//   neye_, गिस्, шнич, _rsvo,
   {{0x98a32c49,0x7c2e2c4a,0xf746263b,0x3f9110a2}},	//   _лите, _kibr, _безо, yezu_,
   {{0x7c2e2c4b,0x2d9204fb,0xdcef00cd,0x00000000}},	//   _jibr, heye_, šeće, --,
   {{0x0586027a,0x2d920010,0x3f910254,0x8646004b}},	//   _булм, keye_, vezu_, _снеж,
   {{0xf65100f5,0x6fcb033b,0xbbc10380,0x00000000}},	//   _گئے_, _züch, _शक्क, --,
   {{0x7c2e0a24,0x3f91011c,0x50642c4c,0x2d922c4d}},	//   _oibr, tezu_, йтра, deye_,
   {{0x40340c65,0x00000000,0x00000000,0x00000000}},	//   серс, --, --, --,
   {{0x62980f44,0xddab2c4e,0x00000000,0x00000000}},	//   _usvo, нтал_, --, --,
   {{0x7c2e004f,0x442e2c4f,0xb88601ba,0x32092c50}},	//   _aibr, _hif_, _zníž, _ukay_,
   {{0x442e048c,0x3b552c51,0x7c2e0065,0x3a2d02a2}},	// [22f0] _kif_, икар, _bibr, _riep_,
   {{0x7c2e002a,0x00000000,0x00000000,0x00000000}},	//   _cibr, --, --, --,
   {{0x7c2e2c52,0x2d922c53,0x15f600b4,0x3a2d0e54}},	//   _dibr, beye_, ुकार_, _piep_,
   {{0xd37800cd,0x6fcb02b1,0x2d920225,0x00000000}},	//   miću_, _süch, ceye_, --,
   {{0xd378011c,0xbcfb000d,0x99840395,0x00000000}},	//   liću_, _idéo, _simţ_, --,
   {{0xdcfd0ae0,0x7c2e2c54,0xf7712087,0x442e0536}},	//   _lasī, _gibr, زات_, _nif_,
   {{0x45d50cac,0xd378011c,0x3a2d0023,0x00000000}},	//   ицит, niću_, _tiep_, --,
   {{0x6d4d0244,0xb88600b8,0x446529fd,0x6e371505}},	//   nbaa, _sníž, авив, _muxb,
   {{0x851f1fe0,0x6d4d2c55,0xe45600d8,0x442e029e}},	//   मेंट_, ibaa, ажы_, _bif_,
   {{0x29f803c9,0x6d4d0107,0x2d922c56,0x98170037}},	//   nčan_, hbaa, zeye_, _إبرا,
   {{0x629e18f2,0x6d4d06ba,0x25af012f,0x2d922c57}},	//   _špor, kbaa, _tngl_, yeye_,
   {{0x78a92c58,0xe7eb11b5,0xd3780254,0x10a60340}},	//   _krev, _झगडा_, diću_, аимн,
   {{0x6d4d2c59,0x442e2c5a,0x78a90065,0x21a30421}},	//   dbaa, _fif_, _jrev, циям,
   {{0xfe46036e,0xd378012e,0x00000000,0x00000000}},	//   инго, fiću_, --, --,
   {{0xed5a1cf7,0x2d92269e,0xdbcf01ba,0x69d90345}},	//   ков_, teye_, bľúb, khwe,
   {{0x3860044d,0x20562bfa,0x6d4d053e,0x78a92c5b}},	//   širi_, _ктор, gbaa, _orev,
   {{0x2d922c47,0xd00f0332,0x64490065,0x00000000}},	// [2300] reye_, سلہ_, npei, --,
   {{0x2d922c5c,0x6d4d073a,0x79892c5d,0xd37800cd}},	//   seye_, abaa, _abew, biću_,
   {{0x7f5c2c5e,0xeb972c5f,0x6d4d001c,0x78a92c60}},	//   marq, рих_, bbaa, _arev,
   {{0xa96a2c61,0x22511840,0x6d4d0345,0x973c00cd}},	//   тида_, ázky_, cbaa, _maće,
   {{0x3860004f,0x913b02b5,0x78a92c62,0x7c2e0282}},	//   éir_, דענק, _crev, _tibr,
   {{0x78a90bcc,0x7f5c039f,0xe6662123,0x6f09027d}},	//   _drev, narq, атио, şece,
   {{0x442e2c63,0x78a92c64,0xd9100919,0x64490051}},	//   _rif_, _erev, _کیش_, epei,
   {{0x69d92699,0x7dd8004f,0x442e2c65,0x78a91097}},	//   chwe, _físe, _sif_, _frev,
   {{0x030b07ba,0x2e3c008a,0xdb1c0a17,0xd37800f4}},	//   _सुबह_, _líf_, _morí, ziću_,
   {{0x66e62c66,0x2b580310,0x442e2c67,0x00000000}},	//   _коза, _jerc_, _qif_, --,
   {{0xe7370086,0x6d4d0298,0x442e2a5a,0x29f8011c}},	//   _тех_, ybaa, _vif_, nčao_,
   {{0xd3780a78,0x92570421,0x00000000,0x00000000}},	//   viću_, шают_, --, --,
   {{0x909807b4,0x92b60083,0x7dd12c68,0x10740352}},	//   авят_, ছনে_, _såso, оляю,
   {{0x92170722,0x7f5c0473,0xd378011c,0x2b58009e}},	//   _धीरज_, garq, tiću_, _nerc_,
   {{0x6d4d2c69,0x29f81b76,0x4ea42c6a,0x6e2f0176}},	//   tbaa, včan_, орта, _picb,
   {{0xcdd80202,0xd378011c,0xdb1c0183,0x00000000}},	//   ању_, riću_, _corí, --,
   {{0xdce606a8,0x6d4d0136,0x7f5c2c6b,0xd90400d1}},	// [2310] _bakı, rbaa, barq, _آی_,
   {{0x6d4d03c4,0x6c6a00b5,0x2b580395,0xd37800cd}},	//   sbaa, اللہ_, _cerc_, piću_,
   {{0x1eab0773,0xfc3f1111,0x6d4d03c4,0xe0df0036}},	//   _شادي_, _trío_, pbaa, lzò_,
   {{0x7dd801c0,0xf99316e6,0x6ec401c0,0x64490328}},	//   _píse, تبط_, रहरु, ypei,
   {{0x2d8b006d,0x98a52c6c,0x3a380069,0xf74500b6}},	//   _ibce_, силе, _eurp_, бело,
   {{0xc88428ae,0x69d90b13,0xc60f021a,0x78a90124}},	//   dağı_, shwe, ात्य_, _vrev,
   {{0x5a4400d8,0x00000000,0x00000000,0x00000000}},	//   _мэта, --, --, --,
   {{0x78a92c6d,0xdce80035,0x00000000,0x00000000}},	//   _trev, śląs, --, --,
   {{0xdce60723,0xcdb80122,0x6fcb0095,0x9f8f027d}},	//   _yakı, שפחה_, _hücu, _güç_,
   {{0xa3e10755,0x395d2c6e,0x3cff004e,0xe29903fa}},	//   नों_, laws_, _रखने_, гао_,
   {{0x64492c6f,0x2d8b2c70,0x11d6004f,0x7c250079}},	//   spei, _obce_, متحد, imhr,
   {{0x64492c71,0x9f5100b5,0xc88400a8,0xd9f70ec5}},	//   ppei, kozó_, bağı_, ंचित_,
   {{0xc88406d3,0x7f5c0a39,0x53a50043,0xd4692c72}},	//   cağı_, tarq, _галб, _силе_,
   {{0x395d0189,0x248f00d7,0xd91a100a,0x7dca008d}},	//   haws_, _ipgm_, טורל, _lýst,
   {{0x7f5c0473,0x6fd00301,0xdb1c1e15,0x6012003e}},	//   rarq, _häck, _porí, næmi,
   {{0x25bf01cb,0xdce6027d,0xbcfb00d5,0xad9b008d}},	//   njul_, _sakı, _edém, _ljúf,
   {{0x2b5800b5,0x395d0221,0xdb0e0097,0x7f5c014c}},	// [2320] _perc_, daws_, _dobý, parq,
   {{0x66092c73,0x25bf139f,0x2f561368,0x00000000}},	//   hoek, hjul_, _утис, --,
   {{0x4e1a0416,0xdce60225,0x6fd0013c,0x66092c74}},	//   _متحد_, _vakı, _läck, koek,
   {{0xb86600f3,0x29f800cd,0x9f4a0051,0xc8840448}},	//   ماتو, rčao_, dibé_, yağı_,
   {{0x1cba036b,0xc7c6071d,0xdce60723,0x06e50083}},	//   _صاحب_, йски, _takı, _পুলি,
   {{0x3a382c75,0x9ad6010b,0x7dca00ac,0x29f80207}},	//   _turp_, _любі, _výsu, pčao_,
   {{0xe0df07e5,0x91fd0228,0x00000000,0x00000000}},	//   zzò_, nsāc, --, --,
   {{0x6fd02c76,0x200a012f,0xd6d901e0,0xa2c6022e}},	//   _bäck, hobi_, шті_, ाहस्,
   {{0x200a2c77,0xdb1c0392,0x29f80a66,0x656f2c78}},	//   kobi_, _horà, nčam_, ócha,
   {{0x249d0107,0x6fd001ff,0xc88400c1,0x200a0183}},	//   _dswm_, _däck, rağı_, jobi_,
   {{0x660902e6,0x91fd00ea,0x51f900d4,0x200a08b7}},	//   boek, krāt, иною_, dobi_,
   {{0x38600c99,0x09ca0033,0x7dd1008c,0x00000000}},	//   širu_, লোরা, _påsm, --,
   {{0x2ed1060a,0x200a2c79,0x63bc2c7a,0x6fd00282}},	//   सन्त, fobi_, örns, _gäck,
   {{0x3fe70033,0x03a300af,0x2cad00d5,0x00000000}},	//   পক্ষ, _ничо, _šedo_, --,
   {{0xd35b0bed,0xe246211b,0x6fd0033b,0x00000000}},	//   _גדול, _اختي, _mäch, --,
   {{0x395d0221,0x720700b5,0x6fd0033b,0x3ebf0124}},	//   xaws_, _دفعہ_, _läch, ćut_,
   {{0xf1f8064e,0x71f80ad9,0x320b004e,0x91a90023}},	// [2330] _دعوت_, _دروس_, mocy_, _giá_,
   {{0x6fd002c9,0x66090a75,0x61ef2c7b,0xad9b07c0}},	//   _näch, zoek, licl, _akút,
   {{0x6fb500d1,0xad270416,0xfbd00037,0xfc3f00ee}},	//   _همکا, _گردو, رتك_, _krík_,
   {{0x7dd10022,0x6fcb2c7c,0x39152447,0x7dd80138}},	//   _måsk, _vücu, омер, _vísc,
   {{0x6d5f1505,0x7dca05d3,0x9ccb021f,0x89340037}},	//   maqa, _výst, _сына_, أعما,
   {{0x6d5f0024,0x395d006d,0x6fd0013c,0x61ef2c7d}},	//   laqa, saws_, _räck, hicl,
   {{0x7ac41346,0x6fd01193,0x66091908,0x2ca900be}},	//   _есте, _säck, toek, lvad_,
   {{0xa2d71604,0x59f90086,0xe6190370,0xa3e10066}},	//   मनस्, _тебя_, јди_, नोई_,
   {{0x22470703,0x7bc72c7e,0x38600037,0x44390132}},	//   _stnk_, _koju, áirt_, ês_,
   {{0xdb1c2c7f,0x6d5f0103,0xd26507b0,0x66092c80}},	//   _horá, haqa, окой, soek,
   {{0xdb1c006c,0x2ca92c81,0x59dd007c,0x2bde0099}},	//   _korá, hvad_, _मतार, फोटा,
   {{0x249d0221,0x6fd0013c,0x61ef2c82,0x00000000}},	//   _tswm_, _täck, gicl, --,
   {{0x200a046a,0x34942c83,0xa01b00fd,0x2bfb012f}},	//   tobi_, _нацр, rtön, ्वां_,
   {{0x34b201ca,0x23292c84,0x973c0009,0x25e50af6}},	//   _آموز, _коли_, _kaća, जोरी_,
   {{0x443f2c85,0x61ef0602,0x200a087c,0xbea32c86}},	//   lqu_, bicl, robi_, марк,
   {{0x63a32c87,0xdd921d05,0x657b2c88,0xa01b2c89}},	//   _hann, بور_, nguh, ltöl,
   {{0x63a32c8a,0xe2060907,0x7bc70187,0x443f0024}},	// [2340] _kann, रवीण_, _boju, nqu_,
   {{0xad9b2c8b,0x3ce00009,0xf1bf0042,0x443f00a2}},	//   _skút, rziv_, nmán_, iqu_,
   {{0x63a32c8c,0x3f982c8d,0x6d5f2c8e,0x5fb70122}},	//   _mann, meru_, baqa, _והיא_,
   {{0x63a32c8f,0xdb1c2c90,0x8d7608cf,0x6fd0033b}},	//   _lann, _corá, _بادا, _säch,
   {{0x91a00023,0x63a30282,0xdb1c00ac,0x29f80009}},	//   _chỉ_, _oann, _dorá, lčak_,
   {{0x3f982c91,0x6d442c92,0x3cff0035,0x466a0ade}},	//   neru_, lcia, _रखते_, арим_,
   {{0xd90d006c,0xdb1c0037,0xfa672c93,0x6d442c94}},	//   نیہ_, _forá, _марк_, ocia,
   {{0x6d44028b,0x39420006,0x63a302e6,0x26c00254}},	//   ncia, _üks_, _aann, ćio_,
   {{0x63a32c95,0x6d442c96,0x3f982c97,0x22492c98}},	//   _bann, icia, keru_, _čaka_,
   {{0x3f980b56,0x69c20136,0x63a32c99,0x7dd12c9a}},	//   jeru_, ljoe, _cann, _påsk,
   {{0x63a32c9b,0x61ef08fe,0x3f982c9c,0x29f80009}},	//   _dann, ticl, deru_, jčak_,
   {{0x63a31861,0x7dd10282,0x69c22c9d,0x00000000}},	//   _eann, _gåsh, njoe, --,
   {{0x63a32c9e,0x3f982c9f,0xa3c300a1,0x3d190067}},	//   _fann, feru_, _एकच_, _दरें_,
   {{0xa3ce0066,0x6d462ca0,0x3f982ca1,0x80270037}},	//   _रवि_, _afka, geru_, ترجم,
   {{0x9f340185,0xbcfb03e6,0x6d5f1505,0x24400023}},	//   дері, _idéi, taqa, _hòm_,
   {{0x24400c1f,0x6560004f,0x63a31d33,0x7dd801ba}},	//   _kòm_, namh, _zann, _písa,
   {{0x61ed0537,0x3f982ca2,0x63a32ca3,0xad9b016f}},	// [2350] _imal, beru_, _yann, _skús,
   {{0x6d5f1505,0xdb1c2ca4,0x3f982ca5,0x7dd80093}},	//   saqa, _sorá, ceru_, _vísa,
   {{0xdd910082,0x61ed008b,0x5a352ab4,0x657b011e}},	//   _كود_, _kmal, чнет, yguh,
   {{0x6d4401d3,0xfe9a02b5,0x6d5f0069,0xf1bf2ca6}},	//   ccia, _פירמ, qaqa, zmán_,
   {{0x6d5d0029,0x65602ca7,0x61ed2ca8,0x2440021e}},	//   _iesa, damh, _mmal, _nòm_,
   {{0x6d5d2ca9,0xd7c80098,0x61ed0088,0x60c002e2}},	//   _hesa, يونه_, _lmal, ämmi,
   {{0x63a32caa,0x6d5d2cab,0x61ed2cac,0xdb1c2cad}},	//   _rann, _kesa, _omal, _torá,
   {{0x63a329fc,0x6d5d2cae,0xfb3401c8,0x61ed010d}},	//   _sann, _jesa, _інтэ, _nmal,
   {{0x6d5d2caf,0xb4d52cb0,0x3d190067,0xf1ba00e2}},	//   _mesa, सने_, _दरों_, _đơ_,
   {{0x61ed2cb1,0x6d5d2cb2,0x443f2cb3,0x3ea10031}},	//   _amal, _lesa, rqu_, _osht_,
   {{0x63a32cb4,0x443f02e1,0x3f982073,0x69db022e}},	//   _vann, squ_, veru_, _klue,
   {{0x63a32cb5,0x6d5d2cb6,0xdb1c054e,0x244002e9}},	//   _wann, _nesa, _foræ, _fòm_,
   {{0x63a32cb7,0xe20b008a,0x3ea101f4,0xe449004f}},	//   _tann, _slóð_, _asht_, _التى_,
   {{0xf8a501ca,0x69db2cb8,0x0454006c,0x61ed2cb9}},	//   _یک_, _llue, _آئند, _emal,
   {{0x6d5d2cba,0x7c3d2cbb,0x443d2cbc,0x68e20036}},	//   _besa, _ausr, _huw_, zzod,
   {{0xf0660525,0xf1bf0093,0x7c3500ea,0x29f800cd}},	//   _екип, nmál_, _aizr, rčak_,
   {{0x6d5d2cbd,0x3f982cbe,0x3ea101f4,0xdb1c01f4}},	// [2360] _desa, peru_, _esht_, _korç,
   {{0x6d442cbf,0x69db03ad,0xe81b0084,0x443d2cc0}},	//   scia, _alue, _पीला_, _muw_,
   {{0x69c20345,0x6d441f51,0xcf5700a5,0x69c901ed}},	//   tjoe, pcia, _מבית_, _boee,
   {{0x6d5d2cc1,0x443d012f,0x61ed0176,0x7bde0c6f}},	//   _gesa, _ouw_, _xmal, shpu,
   {{0x2d82013c,0xb4d500be,0x00000000,0x00000000}},	//   _icke_, सनो_, --, --,
   {{0x569400a4,0x69c20234,0x2ca200d7,0x6d5d2cc2}},	//   дакт, sjoe, _iskd_, _zesa,
   {{0x69db2cc3,0x6d5d2cc4,0x030b0066,0x6459007a}},	//   _flue, _yesa, _सुलह_, _awwi,
   {{0xe9a32b34,0x7c3d1051,0x660400a0,0x75e6010b}},	//   _пасп, _yusr, čiko, яўле,
   {{0x2816006c,0xdb1c00d0,0x65602cc5,0x2ca2023a}},	//   _فورس, _borç, ramh, _jskd_,
   {{0x65602cc6,0x46a62cc7,0x61ed0122,0x9f94073c}},	//   samh, _назв, _smal, _jää_,
   {{0xad9b0168,0x00000000,0x00000000,0x00000000}},	//   _okúp, --, --, --,
   {{0x39461423,0x2440009e,0x7ae100fd,0x443d099e}},	//   ncos_, _tòm_, _ülte, _fuw_,
   {{0x38662cc8,0xdb1c2cc9,0x39462cad,0x7dd800b8}},	//   nsor_, _forç, icos_, _písn,
   {{0x6d5d2b63,0x925700bf,0xa01b0093,0x2d820282}},	//   _sesa, _کشور_, mtök, _acke_,
   {{0x6d5d108b,0x7c3d01cc,0x9f4a00de,0xdb0501f4}},	//   _pesa, _susr, cibí_, rdhë,
   {{0x61ed18e4,0x42fb0122,0x7bdc029e,0x7c3d00c7}},	//   _umal, _להוס, _alru, _pusr,
   {{0x628809b3,0x25a61a07,0x6d5d2cca,0x7bdc0103}},	// [2370] ltdo, _maol_, _vesa, _blru,
   {{0x39462ccb,0x2d82033b,0x6e992ccc,0x6d5d0103}},	//   ecos_, _ecke_, _двор_, _wesa,
   {{0x61fd2ccd,0xdb5800c3,0xdd0c0035,0x20041d70}},	//   onsl, яют_, góło, émie_,
   {{0x61fd2cce,0x973c02c4,0x23c8000c,0xc33300a5}},	//   nnsl, _baćo, ाउँद, גוע_,
   {{0x07a52ccf,0xe7390279,0x00000000,0x00000000}},	//   далн, оел_, --, --,
   {{0xd7c9183b,0x443d0223,0x394602d7,0xdb1c017b}},	//   توته_, _ruw_, acos_, _borä,
   {{0x443d2cd0,0x64460093,0x56922123,0x25a60079}},	//   _suw_, íkin, вајт, _baol_,
   {{0x25a60874,0x63b80107,0x39462cd1,0x291f0065}},	//   _caol_, _anvn, ccos_, _tzua_,
   {{0xf1bf2cd2,0xdb1c0132,0xfc3f0176,0x443d0118}},	//   rmál_, _porç, _juí_, _quw_,
   {{0xa2a900b4,0x395f2cd3,0xf1bf0093,0x7dd802d7}},	//   टिल्, _heus_, smál_, _aísl,
   {{0xfc3f0037,0x395f01e4,0xa2e51b50,0x91fd00ec}},	//   _luí_, _keus_, фонд, trāp,
   {{0x25a609c3,0x6721025c,0x7763002a,0x7dd800d5}},	//   _gaol_, _izlj, lanx, _císl,
   {{0x395f2cd4,0x644b2cd5,0xdb1c2cd6,0x7f5e0176}},	//   _meus_, _utgi, _torç, _pepq,
   {{0x7dd801ba,0xe820164f,0x395f2cd7,0x61fd0223}},	//   _píso, यतया_, _leus_, ansl,
   {{0xe7e5007c,0x62880223,0x00000000,0x00000000}},	//   _कतना_, ctdo, --, --,
   {{0x26130279,0x395f2cd8,0xa6af0033,0xd6af0033}},	//   mãos_, _neus_, _কথাট, _কথায,
   {{0x39a601c8,0xfc3f0037,0x9f940421,0x00000000}},	// [2380] _jūsų_, _cuí_, _pää_, --,
   {{0x39a601c8,0x67210c21,0xafdb02ce,0x00000000}},	//   _mūsų_, _ozlj, spør, --,
   {{0x395f009e,0x776301f7,0x7dd103d0,0x00000000}},	//   _beus_, danx, _råsv, --,
   {{0xbcfb0176,0xfc3f0453,0x395f2cd9,0x9f4a0176}},	//   _adéu, _fuí_, _ceus_, libà_,
   {{0x5fd20755,0x395f0bb0,0x39460aca,0x1867151d}},	//   _हवाल, _deus_, rcos_, дачи_,
   {{0x25a62cda,0x2d802cdb,0x7a2300ab,0x9f580453}},	//   _saol_, lgie_, võte, moró_,
   {{0xc7b80028,0x69d800da,0xdb1c013c,0x61fd2cce}},	//   _vnđ_, ëves, _borå, ynsl,
   {{0x395f2cdc,0x746a2cdd,0x26130279,0x69d80029}},	//   _geus_, оров_, dãos_, īves,
   {{0x211d0f17,0xd49a01e0,0x00000000,0x00000000}},	//   _नरेश_, іри_, --, --,
   {{0x1b2100c8,0x395f2cde,0xf1bf0097,0x325400af}},	//   _বলতে_, _zeus_, rmám_, нвор,
   {{0xc7b302b8,0x261303e6,0xdb1c0c61,0xa01b2cdf}},	//   _שבע_, gãos_, _forå, stök,
   {{0x22ac00b8,0x3cff00ab,0xa01b008d,0x00000000}},	//   _věk_, _रखले_, ptök, --,
   {{0x7dd106d7,0x2ca0046a,0x61fd2ce0,0xd83802f6}},	//   _måst, jwid_, rnsl, _kič_,
   {{0x752201a3,0x7dd12ce1,0x2d800345,0x00000000}},	//   _izoz, _låst, egie_, --,
   {{0x40342ce2,0xfc3f0079,0xd838023a,0x660203d0}},	//   терс, _suí_, _mič_, _kjok,
   {{0x2d802ce3,0x66020176,0x386901a0,0xd83800f4}},	//   ggie_, _jjok, šari_, _lič_,
   {{0x395f0443,0xfc3f0023,0x2b4a05f5,0x6e26005f}},	// [2390] _reus_, _quí_, _bfbc_, _dhkb,
   {{0x395f2ce4,0xd8382ce5,0x7e7c01d7,0x7522002f}},	//   _seus_, _nič_, burp, _mzoz,
   {{0x20112ce6,0x395f0310,0xe1ff0831,0x7dd101ff}},	//   mozi_, _peus_, onó_, _båst,
   {{0x20112ce7,0x9f580453,0x66022ce8,0x1dd3074f}},	//   lozi_, boró_, _njok, _सवित,
   {{0x7b670d36,0x6e2d2ce9,0x3869004f,0xd83802c4}},	//   _отве, mmab, éar_, _bič_,
   {{0x48e00083,0x660200c3,0x907c016b,0x6e2d2cea}},	//   বপূর, _ajok, קטוי, lmab,
   {{0x395f1544,0x77630391,0xd8380187,0xe7362701}},	//   _teus_, ranx, _dič_, неш_,
   {{0x442c09a6,0xdcef2ceb,0x20112cec,0xd5b10206}},	//   emd_, _hacı, hozi_, افظ_,
   {{0x25e50302,0x201119c7,0x31602ced,0x601201b4}},	//   जोगी_, kozi_, _reiz_, kæmp,
   {{0x69d901bf,0x28be00be,0xe19000cc,0x28ac018d}},	//   lkwe, ्हरि, _cẳng_, चिरि,
   {{0xd24e07e4,0xb81b0035,0x69d92cee,0x201108a0}},	//   ینی_, _पीएम_, okwe, dozi_,
   {{0x69d92cef,0x7dd8024e,0xbbdc012f,0x66020031}},	//   nkwe, _písm, _यत्क, _gjok,
   {{0x7641121e,0xa3d51583,0x26130183,0xf9da0070}},	//   _huly, _подч, sãos_, פֿטל,
   {{0x7e7c2cf0,0x20112cf1,0x661b2cf2,0x7641018e}},	//   turp, gozi_, lluk, _kuly,
   {{0x442702c9,0xdee60b3b,0xfc3f0392,0x236500f4}},	//   _ihn_, хови, _orís_, malj_,
   {{0xd24e004f,0x76412cf3,0x6da30274,0x6e2d043d}},	//   _اني_, _muly, лиса, gmab,
   {{0x2011070b,0xfce3219f,0x921702b5,0x91fd0029}},	// [23a0] bozi_, гото, _אַזױ_, ksāj,
   {{0xfc3f004f,0x26e50083,0xdb0700e0,0x44270298}},	//   _arís_, _কখনো_, _kajè, _jhn_,
   {{0x661b2cf4,0x7dd10b87,0xdb1c01ba,0xd8380506}},	//   kluk, _påst, _horú, _rič_,
   {{0xceb30bed,0xdb1c01ba,0x69d911e9,0xf8661d67}},	//   _עיר_, _korú, gkwe, евдо,
   {{0x661b2cf5,0x23652cf6,0x6d3b00a5,0x442c2cf7}},	//   dluk, kalj_, _מתכנ, ymd_,
   {{0x76412cf8,0x442703bc,0x66022cf9,0x69d92cfa}},	//   _buly, _nhn_, _sjok, akwe,
   {{0xfc0302ef,0x3b0706e4,0x09e600d4,0x23652cfb}},	//   _спро, _зеро_, _зовн, dalj_,
   {{0x69d92cfc,0xe7f20461,0x7bce00ab,0x661b2cfd}},	//   ckwe, _अगवा_, _hobu, gluk,
   {{0x7bce2cfe,0xb4da0084,0x09e318d9,0xa01b02e2}},	//   _kobu, ठने_, _сотн, stöi,
   {{0x442709ba,0x7bce2cff,0x23652d00,0x224e01ed}},	//   _chn_, _jobu, galj_, _ptfk_,
   {{0xa3b102e4,0x7bce2d01,0x442c0120,0x201103ab}},	//   _ऑफर_, _mobu, rmd_, vozi_,
   {{0x79822d02,0xd2571ca4,0x44270065,0xdb0e017b}},	//   ngow, эць_, _ehn_, _inbä,
   {{0x20110418,0x9f580036,0xe1ff2d03,0xe3b200d1}},	//   tozi_, vorò_, rnó_, _مرغ_,
   {{0x7bce2d04,0x644f248d,0x09dd021a,0x44270341}},	//   _nobu, ície, _मत्य, _ghn_,
   {{0x20110010,0x6e2d0159,0xe28f0037,0x200400a0}},	//   rozi_, tmab, _هذي_, émia_,
   {{0x63aa2d05,0x20112d06,0xdda80012,0xdb1c021d}},	//   _hafn, sozi_, нтул_, _forú,
   {{0x7dd82d07,0x6e2d20d9,0x20112d08,0xa3e4021a}},	// [23b0] _získ, rmab, pozi_, _नता_,
   {{0x63aa00fb,0x7bce058d,0x64421e19,0x660000d7}},	//   _jafn, _cobu, _muoi, hnmk,
   {{0xa0360122,0x9f8f00ab,0xfc3f2d09,0x29d7027d}},	//   _שאתה_, _müü_, _prís_, _uçak_,
   {{0x65622d0a,0x9f58008a,0x77612984,0xdb0e0183}},	//   _neoh, lorð_, _selx, _robô,
   {{0x69d901bf,0x76412d0b,0x98a52d0c,0x991401e0}},	//   rkwe, _suly, тиле, льші,
   {{0x69d91296,0x62980136,0x63aa008a,0x3f83008a}},	//   skwe, _opvo, _nafn, ngju_,
   {{0x236500cd,0xf1c406fe,0xa3e426d4,0x69d92d0d}},	//   valj_, षामन, नसन_, pkwe,
   {{0xceb4168d,0xa2c40de8,0x7bce2d0e,0x44272d0f}},	//   ריק_, िमन्, _zobu, _shn_,
   {{0x661b0f1a,0x23652d10,0x64421e19,0xf8bf0187}},	//   rluk, talj_, _cuoi, _šéf_,
   {{0x9aa40332,0x7641018e,0x7dd80e06,0x91aa0067}},	//   _جمہو, _tuly, _písk, _जोड़े,
   {{0x386d2d11,0xd6db0086,0xb17b177c,0x661b2d12}},	//   _hver_, _эта_, rhån, pluk,
   {{0x99980029,0xa06a2d13,0x38691ada,0x23650207}},	//   _kurš_, мама_, šaru_, salj_,
   {{0x44272d14,0xd1320037,0x91a000e2,0x23650207}},	//   _thn_, شمس_, _chí_, palj_,
   {{0xb4bf02cb,0x3f83008d,0x29f818b0,0xb4cd04ef}},	//   ीही_, ggju_, nčar_, रही_,
   {{0x248d2d15,0x91a00023,0x6fd90211,0x00000000}},	//   ltem_, _thì_, _mìch, --,
   {{0x386d0052,0xbcfb000d,0x7bce0027,0x248d0067}},	//   _over_, _adéq, _sobu, otem_,
   {{0x248d2d16,0x7bce2d17,0x9f580093,0xe7f208a9}},	// [23c0] ntem_, _pobu, borð_, _अगला_,
   {{0x248d2d18,0x7dd80042,0xeafa0180,0x7bce2d19}},	//   item_, _mísi, ورات_, _qobu,
   {{0x386d01d3,0xdb1c009e,0x6f790070,0xb4cd0006}},	//   _aver_, _yorù, _אָרג, रहु_,
   {{0x7bce2d1a,0xe8fa00c3,0x248d06bb,0xfc3f01ef}},	//   _wobu, мле_, ktem_, _isín_,
   {{0xe8942246,0x7bce2d1b,0x6b87009e,0x79820067}},	//   уаль, _tobu, _fcjg, rgow,
   {{0x248d2d1c,0x25ad0e0e,0x386d00ee,0x79822d1d}},	//   dtem_, edel_, _dver_, sgow,
   {{0x386d0122,0x00000000,0x00000000,0x00000000}},	//   _ever_, --, --, --,
   {{0xd90d00e0,0x63aa008a,0xa01b00b5,0x7c3c064a}},	//   _کیه_, _safn, ltöt, _hirr,
   {{0x98a32d1e,0x64422d1f,0x248d2d20,0x18a3021d}},	//   _ките, _quoi, gtem_, _катм,
   {{0x7c3c0484,0x32020038,0x660d2d21,0x25ad0553}},	//   _jirr, enky_, čaka, adel_,
   {{0x386d2d22,0x51f92659,0x7c3c2d23,0xe81b0354}},	//   _zver_, енню_, _mirr, _पीटा_,
   {{0xcb1302b8,0x973c0124,0x64420023,0x91a000e2}},	//   ילת_, _naći, _tuoi, _phí_,
   {{0x248d01f7,0x6abf00a1,0xfc3f0176,0x7c3c01a6}},	//   ctem_, _एप्र, _asín_, _oirr,
   {{0x200500be,0xdb1c01cf,0x7c3c2d24,0x00000000}},	//   õli_, _forø, _nirr, --,
   {{0x929400d8,0x9f580093,0xb5fc0024,0x973c0506}},	//   _сайц, rorð_, _ewġe, _baći,
   {{0x7c3c2d25,0x325301d3,0x443c2d26,0x1b210033}},	//   _airr, _твър, _hiv_, _বললে_,
   {{0x443c2d27,0x7c3c2d28,0xdb050037,0xbddb00f7}},	// [23d0] _kiv_, _birr, rdhí, _lièg,
   {{0x7c3c2d29,0xe7bd0083,0x7c84015a,0x3b540d07}},	//   _cirr, _অত্য, јуте, икур,
   {{0x443c2d2a,0x3a750036,0x248d006c,0x7c3c1901}},	//   _miv_, улер, ztem_, _dirr,
   {{0xe7e51e79,0x443c18ee,0x973c003a,0x00000000}},	//   कसभा_, _liv_, _gaći, --,
   {{0x2003046a,0x851e046c,0x67d52d2b,0x7c3c2d2c}},	//   onji_, _परगट_, лоду, _firr,
   {{0x443c2d2d,0x00000000,0x00000000,0x00000000}},	//   _niv_, --, --, --,
   {{0x6e3d2b67,0x00000000,0x00000000,0x00000000}},	//   _kisb, --, --, --,
   {{0x248d0332,0x443c006d,0x0696004f,0x26c90a78}},	//   ttem_, _aiv_, انية_, ćao_,
   {{0x6e3d2d2e,0x25ad02df,0xb17b022a,0x84580677}},	//   _misb, rdel_, rhål, крэт_,
   {{0x248d2d2f,0x7dd800fb,0x6e3d2d30,0xb17b013c}},	//   rtem_, _vísi, _lisb, shål,
   {{0x200302dd,0x7d1d2d31,0x17f8004f,0x00000000}},	//   dnji_, _lyss, _شركة_, --,
   {{0x64b52087,0x6e3d2d32,0x248d2d33,0x5ed70033}},	//   _محتر, _nisb, ptem_, _ডেভে,
   {{0x443c2d34,0x7d1d0b88,0x20040132,0x00000000}},	//   _fiv_, _nyss, émio_, --,
   {{0x443c01b4,0xa2ab045c,0x75fe0029,0xedd61a95}},	//   _giv_, _जनप्, vīzi, گيرد,
   {{0xdee32d35,0x6e3d2d36,0xf3f0004f,0xe81b0084}},	//   бори, _bisb, _بأن_, _पीछा_,
   {{0x63a12d37,0xdca62d38,0x7c3c2d39,0x443c0124}},	//   leln, лаби, _sirr, _ziv_,
   {{0xa3d70f39,0x7c3c2d3a,0x443c006d,0x69ba0026}},	// [23e0] _सवा_, _pirr, _yiv_, _एफबी,
   {{0x35c50084,0xfc3f004f,0x3d0407b5,0x6e3d02b1}},	//   वाड़, _tsín_, _रखीं_, _eisb,
   {{0x7c3c16c9,0x78a92d3b,0x7d1d0345,0x61e42d3c}},	//   _virr, _asev, _eyss, _klil,
   {{0x63a12d3d,0x7cda00ea,0x8e7b0070,0xa01b2d3e}},	//   heln, _pārā, _אנטה, stöt,
   {{0xb4cd009a,0xd9171728,0x7c3c0484,0x63a12d3f}},	//   रहो_, льш_, _tirr, keln,
   {{0x62812d40,0x63a12d41,0xbddb000d,0xda661301}},	//   kulo, jeln, _pièg, _ماري,
   {{0x63a12d42,0x628100d7,0xab270aec,0x1ae600c3}},	//   deln, julo, _бора_, _совм,
   {{0x443c0d4b,0x45d40836,0xa01b2d43,0x2003003d}},	//   _siv_, роис, ntör, znji_,
   {{0x443c0189,0x69c02d44,0x02dc018d,0x09062d45}},	//   _piv_, _inme, मन्न, _спан,
   {{0x61e42d46,0x443c006f,0x644f0a54,0x63a12d47}},	//   _alil, _qiv_, ícia, geln,
   {{0x443c2d48,0xa01b2d49,0x7bde028b,0xd5af218b}},	//   _viv_, ktör, ikpu, _лс_,
   {{0x15462d4a,0xa01b0086,0x61e4009e,0x31c72d4b}},	//   _седм, ytös, _clil, усов,
   {{0x443c0189,0x20030254,0x6e3d2d4c,0xc10800af}},	//   _tiv_, tnji_, _risb, гэре_,
   {{0x53342d4d,0x62812d4e,0x7d1d2d4f,0x63a10124}},	//   _келт, bulo, _ryss, celn,
   {{0x62812d50,0x20030496,0x539b0122,0x9f3500d4}},	//   culo, rnji_, _ניהו, реві,
   {{0x5d550265,0x20030bde,0x7d1d1ab7,0x61e40211}},	//   ркат, snji_, _pyss, _glil,
   {{0x8f5500d1,0x20031d7d,0x6e3d2d51,0xad9b0093}},	// [23f0] _پنجش, pnji_, _visb, _hjúk,
   {{0x69c02d52,0x6d4d02a2,0x201a012f,0x6e3d00e0}},	//   _anme, scaa, _gkpi_, _wisb,
   {{0x973c00cd,0xa01b00c3,0xdd95005f,0x78a9030d}},	//   _kaću, stös, _каны, _ssev,
   {{0x63a12d53,0xdb070093,0x6e3d0345,0x78a92d54}},	//   zeln, _snjó, _uisb, _psev,
   {{0x79c904e8,0x62812d55,0x383507fa,0xf1bf1e15}},	//   _یوسف_, zulo, андр, lmás_,
   {{0x69c02d56,0x2449008d,0x2d84027d,0x7bde0110}},	//   _enme, _rúm_, _ömer_, ckpu,
   {{0x0f5800a5,0xbddb00a2,0xdb071dab,0xdb1c007e}},	//   ניהם_, _tièd, _kají, _korý,
   {{0x9f5801f4,0x660d008b,0x78a901e8,0x049500d8}},	//   tirë_, čako, _tsev, ароў,
   {{0x63a115bc,0xa78703c5,0x78a90b5e,0xdb0706fe}},	//   teln, _مشاو, _usev, _mají,
   {{0x62812d57,0x61e42d58,0xad9b00fe,0x661901cb}},	//   tulo, _slil, _bjúk, _wkwk,
   {{0x02062d59,0xc7c42d5a,0x973c01f2,0x212900d7}},	//   изон, _усти, _baću, _azah_,
   {{0x63a12d5b,0xdb0701c0,0xa3b50a40,0x3209008c}},	//   seln, _nají, _चोर_, _cjay_,
   {{0x7dd8000c,0x63a12d5c,0x3d04004e,0x62812d5d}},	//   _míst, peln, _रखें_, sulo,
   {{0x62812d5e,0x7dd8024e,0x2d990260,0x24520088}},	//   pulo, _líst, _abse_, _بنوس,
   {{0x316b006a,0xdb0702d7,0x2bc909b4,0x420a00af}},	//   bacz_, _bají, राना, _инко_,
   {{0x260b07a3,0x61e42d5f,0x3a2d00e2,0x00000000}},	//   ावटी_, _ulil, _nhep_, --,

   {{0xab660545,0xf1bf1d8a,0xa01b2d60,0x9f5800e0}},	// [2400] ивал, rmát_, rtör, hiré_,
   {{0xfbdf03bc,0x2cab01f7,0x8b2600d8,0x00000000}},	//   _stêr_, _dscd_, адзе, --,
   {{0x22470602,0xa01b2d61,0x0f7b016b,0x00000000}},	//   _junk_, ptör, _בריל, --,
   {{0x20182d62,0xf2960070,0x22470a8a,0x82960070}},	//   lori_, יכער_, _munk_, ידעס_,
   {{0x9f510279,0xc7c60370,0x69c00019,0x3a2d0118}},	//   lizá_, иски, _vnme, _dhep_,
   {{0x20182d63,0xdb07000c,0x7dd8008d,0x224000be}},	//   nori_, _zají, _vísu, _liik_,
   {{0xb76500d4,0x46670104,0xa5f82d64,0x2247014c}},	//   стій, арым_, леку_, _nunk_,
   {{0xd5b71cba,0x2018001e,0x3a3f0023,0x69c02d65}},	//   ась_, hori_, _giup_, _unme,
   {{0xad9b008a,0x20182d66,0x23670176,0x22470453}},	//   _sjúk, kori_, _benj_, _aunk_,
   {{0x2bc900e7,0x9f580453,0xf743182f,0xf1bf00b5}},	//   राया, biré_, _дефо, ymás_,
   {{0x20182d67,0x0bb70122,0xa6ca004f,0x91fd0029}},	//   dori_, בלים_, _جوال_, ksāt,
   {{0xdb1c25ec,0x05830a7c,0x7dd81eae,0x3a2d0055}},	//   _horó, _душм, _míss, _xhep_,
   {{0x2edf012f,0x2bc90325,0x291f006d,0x20182d68}},	//   नन्त, रामा, _xyua_, fori_,
   {{0xb7f8114e,0x7a2300ab,0xfc3f00d5,0x764800fe}},	//   ्चिम_, võtm, _psím_, _kudy,
   {{0x22470024,0xdb1c04ac,0x5f1a26c6,0x6235029f}},	//   _gunk_, _moró, _मुद्_, _леку,
   {{0xaac701cb,0x5d7800c3,0x23672d69,0x7a3a00fe}},	//   یتان, ийся_, _zenj_, _důtk,
   {{0x61fd1942,0x4095004f,0xdb070187,0x00000000}},	// [2410] misl, _الخر, _vají, --,
   {{0x61fd2d6a,0x3a3f1371,0xdb0e00bf,0xcc250033}},	//   lisl, _siup_, _kabè, বদ্ধ_,
   {{0x24840255,0x2bc9175f,0xdb0e0260,0x291f0118}},	//   humm_, राबा, _jabè, _syua_,
   {{0x32190e7d,0x29d7045e,0x9f5802d7,0x3944013a}},	//   nosy_, _açar_, viré_, _cgms_,
   {{0x7dd80138,0xa8a700c3,0x76480067,0xdb0e0107}},	//   _víst, ррек, _audy, _labè,
   {{0xf77121a0,0x7648004e,0xab841e38,0x9f582d6b}},	//   سات_, _budy, _муск, tiré_,
   {{0x3a3f0034,0x61fd2d6c,0x2ca9016e,0x3a2d055c}},	//   _tiup_, kisl, lwad_, _thep_,
   {{0x61fd2d6d,0x644f2d6e,0x23670124,0x2d8908c7}},	//   jisl, ício, _senj_, ngae_,
   {{0x20182d6f,0x2240007c,0x799b011e,0x7bd52d70}},	//   yori_, _riik_, _ibuw, _kozu,
   {{0x53c90a9f,0x60dd0298,0xdb0e0107,0x22472d71}},	//   угом_, dysm, _babè, _punk_,
   {{0x20182d72,0x216a005c,0x7a23007c,0x442e2d73}},	//   vori_, лини_, võtj, _dhf_,
   {{0x442e0093,0x61fd2d74,0x78bb2d75,0x2bc9021a}},	//   _ehf_, gisl, _kruv, राडा,
   {{0x20182d76,0x63c200b8,0x442e2d77,0x799b089b}},	//   tori_, ávní, _fhf_, _mbuw,
   {{0xd91a0122,0xe8df0019,0xb4e30a44,0x90d5010b}},	//   רושל, _ngọn_, ननी_, іцяч,
   {{0xe29900af,0x20182d78,0x799b2d79,0xdee32d7a}},	//   _сай_, rori_, _obuw, пори,
   {{0x20182d7b,0xfbdf01a5,0xa2c408b0,0x2291006c}},	//   sori_, _quên_, िमर्, mák_,
   {{0xbddb0248,0x7bd501d6,0x2ca9011e,0x6e2f009e}},	// [2420] _sièc, _bozu, gwad_, _dhcb,
   {{0xbddb02e1,0x9f861018,0x20180510,0x6faa03fa}},	//   _pièc, _угод, qori_, _свог_,
   {{0xfe722d7c,0x6c33004f,0xdb0e0118,0x7bd52d7d}},	//   _عدد_, أفلا, _kabé, _dozu,
   {{0xed3600af,0xa2d8021a,0x78bb2d7e,0xed5a02fb}},	//   _гэгэ, महत्, _bruv, _щом_,
   {{0xd7fa059d,0xdb1c2d7f,0x6d46011e,0x25f60026}},	//   лук_, _poró, _igka, एफसी_,
   {{0x2bc9074f,0xa09b0319,0x229100b5,0x78bb2d80}},	//   राणा, ריסט, kák_, _druv,
   {{0x22912d81,0xf76f2d82,0x61fd273b,0x00000000}},	//   ják_, راو_, yisl, --,
   {{0x545402ef,0xfbc90567,0x61fd0391,0x6e242d83}},	//   овит, राथम, xisl, nlib,
   {{0x61fd0076,0x7bd50be2,0x6d46010d,0x92a80035}},	//   visl, _yozu, _mgka, _małż,
   {{0xb2742d84,0x4adc0808,0x03f80274,0x42742349}},	//   олош, _यथाव, рној_, огос,
   {{0x61fd124b,0x7648010d,0x17570d85,0xdb9b1804}},	//   tisl, _uudy, _הסבר_, נסטר,
   {{0xd46a00c9,0x64460093,0x6d462d85,0x6e240009}},	//   _биде_, íkis, _ngka, jlib,
   {{0xdb0705f6,0x682d00a0,0x05c500b4,0xdb0e00fe}},	//   _majá, súde, वारब, _dabé,
   {{0x61fd2d86,0x22912d87,0x6d460103,0x6abc0211}},	//   sisl, bák_, _agka, _orrf,
   {{0x7bd52d88,0x61fd2d89,0x8c000033,0xdd9b2d8a}},	//   _rozu, pisl, ্তান_, лша_,
   {{0x6e242d8b,0xbcfb006c,0x4cd10033,0x7bd52d8c}},	//   glib, _idéz, _সেগু, _sozu,
   {{0xe1ff2d8d,0x7bd50095,0x76421476,0x7bf904d9}},	// [2430] mió_, _pozu, _mioy, анар_,
   {{0xe1ff2d8e,0x2bc90c03,0x6e24018e,0xdb1c0d2e}},	//   lió_, राधा, alib, _enrí,
   {{0x7bd50009,0xa1150088,0x6e2400fe,0xfc3f00ee}},	//   _vozu, _دوکت, blib, _kríz_,
   {{0xe1ff0955,0x78bb2d8f,0xa2ab09b4,0x3ebe035b}},	//   nió_, _pruv, _जनस्, ætte_,
   {{0x7c840ebc,0xeab0006c,0xe0df0107,0x2bc902b4}},	//   _нуре, وٹے_, nyò_, रादा,
   {{0x2bcb0036,0x8bcb00af,0x229100b5,0xd2461301}},	//   _сумо_, _сымб_, yák_, _ين_,
   {{0x99852149,0xdddc082d,0x7522030d,0x00000000}},	//   _ولسو, lurš, _ayoz, --,
   {{0x649928a1,0x22912d90,0x78bb2d91,0x91a90023}},	//   атор_, vák_, _truv, _nhà_,
   {{0xe1ff2d92,0x13e92d93,0xb4e32188,0x764200e0}},	//   dió_, имий_, नने_, _dioy,
   {{0x22912d87,0xdb0e17b8,0x22510187,0xe2910037}},	//   ták_, _sabé, ízko_, وذج_,
   {{0x2329263c,0xe29900ed,0xd5ae00bf,0xd1ca03fa}},	//   рони_, шан_, رفی_, алне_,
   {{0xe1ff2d94,0xbba602e4,0x22911055,0x36340037}},	//   gió_, _ऑस्क, rák_, _فرنس,
   {{0x22912d95,0x661b02ee,0x66092d96,0x00000000}},	//   sák_, mouk, mnek, --,
   {{0xa2e51a24,0x3eb8011c,0x645904fb,0x661b2d97}},	//   _молд, tvrt_, _itwi, louk,
   {{0xdb1c008a,0xe1ff0083,0x7f430b7d,0x6609000e}},	//   _norð, bió_, держ, onek,
   {{0xe1ff2d98,0x644b070b,0x64432d99,0x660917eb}},	//   ció_, _kugi, _hini, nnek,
   {{0x644322fb,0x656b0332,0x6e240f1a,0x4425239a}},	// [2440] _kini, _megh, rlib, oll_,
   {{0x9f580082,0x644b2d9a,0xdb070332,0xdb1c008a}},	//   oirí_, _mugi, _sajá, _borð,
   {{0x44252d9b,0x9d462d9c,0x644b2d9d,0x661b2d9e}},	//   ill_, _менд, _lugi, kouk,
   {{0xa92607c1,0xdddc0c99,0x656b2d9f,0x661b00c3}},	//   одел, burš, _negh, jouk,
   {{0x644b2da0,0x76420118,0xdce6023a,0x9f43008d}},	//   _nugi, _rioy, _kekč, mhjá_,
   {{0x64432da1,0xdb1c0093,0x660901d7,0xe1ff00b5}},	//   _nini, _forð, enek, zió_,
   {{0x644b00d8,0x656b0f1c,0x645904fb,0x98a300c7}},	//   _augi, _begh, _atwi, _ąją_,
   {{0x44252da2,0xd49a1e9f,0x644b19d3,0xe1ff0443}},	//   ell_, аро_, _bugi, xió_,
   {{0x644300a7,0xe1ff0831,0x644b2da3,0x656b2da4}},	//   _bini, vió_, _cugi, _degh,
   {{0x64432da5,0x644b2da6,0x986800b5,0xa2f401e0}},	//   _cini, _dugi, _نیچے_, зпоч,
   {{0xe1ff0831,0xe3b801d6,0x661b2da7,0x644b01ed}},	//   tió_, llık_, bouk, _eugi,
   {{0x64430938,0x644b2da8,0x656b0345,0x44252da9}},	//   _eini, _fugi, _gegh, all_,
   {{0xe1ff0033,0xe3b801d6,0x64430dc5,0x62812daa}},	//   rió_, nlık_, _fini, arlo,
   {{0x64432dab,0xd2500082,0xe1ff0955,0xbddb12c3}},	//   _gini, _كنت_, sió_, _cièn,
   {{0x2bc90930,0x3a262dac,0x2ee50093,0xbddb00e0}},	//   रासा, klop_, álf_, _dièn,
   {{0x63a82dad,0x66002dae,0x644b0526,0x64432daf}},	//   ledn, nimk, _yugi, _zini,
   {{0x62880083,0x64432db0,0x7dd80453,0x25d71804}},	// [2450] ludo, _yini, _vísp, קומן_,
   {{0xa2be111a,0xdddc0121,0x661b03d0,0x00000000}},	//   षिप्, rurš, zouk, --,
   {{0x66002db1,0x67ef0b3e,0x00000000,0x00000000}},	//   kimk, _højg, --, --,
   {{0xdb1c008e,0x2bc900b8,0x66000355,0xda78093e}},	//   _vorð, राहा, jimk, іях_,
   {{0x44252db2,0x998d016f,0x656b2db3,0x66002db4}},	//   yll_, _tiež_, _regh, dimk,
   {{0x63a80254,0x644b2db5,0x656b0036,0x27c700c3}},	//   jedn, _rugi, _segh, ющег,
   {{0xfbd20052,0x644b2db6,0x64432db7,0x64590035}},	//   _אתם_, _sugi, _rini, _stwi,
   {{0x2bc90e1d,0xd5c500dc,0x3a260176,0x7dd103d0}},	//   रावा, वाइज, clop_, _påsy,
   {{0x6443081a,0x656b2db8,0xdb07021d,0x5a44002d}},	//   _pini, _vegh, _enjô, _цэра,
   {{0x656b2db9,0x682d00a0,0x66092dba,0xe2852dbb}},	//   _wegh, búda, snek, плои,
   {{0x44250090,0xdce60107,0x00000000,0x00000000}},	//   rll_, _rekč, --, --,
   {{0x644b2dbc,0x64432dbd,0xe2962dbe,0x00000000}},	//   _tugi, _wini, чаю_, --,
   {{0x64432dbf,0x63a80274,0x7bc701e4,0x645905a8}},	//   _tini, bedn, _onju, _utwi,
   {{0x63a80a69,0x62881298,0xdfd20372,0x00000000}},	//   cedn, budo, ريز_, --,
   {{0xf1bf0082,0x62882cad,0xe7f30006,0x3ebe0093}},	//   mlán_, cudo, _अतना_, ítt_,
   {{0x7bc71221,0xed640187,0x67ef01b4,0x6d4b2dc0}},	//   _anju, drží_, _højd, žgan,
   {{0xdca32dc1,0x32020187,0x00000000,0x00000000}},	// [2460] нати, miky_, --, --,
   {{0x46bd073f,0xa0970319,0x6600048f,0x32020097}},	//   ्माह, _צדיק_, zimk, liky_,
   {{0x3ce6290b,0x34a81cce,0xca7500d8,0x3fdb00a5}},	//   šov_, _कन्द, дучы, _הקיב,
   {{0x8c462b60,0x3202024e,0x63a8004e,0x7bc701a8}},	//   _неме, niky_, zedn, _enju,
   {{0xd7c700a1,0x39402dc2,0x2bc923db,0xe8942dc3}},	//   लांच, äis_, राशा, фаль,
   {{0xdb0e09ab,0xe3b801d6,0x9f582dc4,0x7bc70124}},	//   _habí, rlık_, nirà_, _gnju,
   {{0xfaa32dc5,0x63a82dc6,0xa01b1193,0xfbc90edf}},	//   _паро, vedn, krön, रारम,
   {{0xceb300a5,0x682d0079,0xbb430c46,0xf64f00f8}},	//   תיה_, rúda, _ческ, دئو_,
   {{0x66002883,0x32020097,0x67ef008c,0x18671de4}},	//   rimk, diky_, _bøjd, _нати_,
   {{0x62882dc7,0x6600002f,0x61e60298,0x00000000}},	//   tudo, simk, ekkl, --,
   {{0x63a82dc8,0xa75b0122,0x3202031d,0x9f582dc9}},	//   redn, _הדבר, fiky_, dirà_,
   {{0xdb0e0311,0x628801b4,0x63a82dca,0xb05b01ff}},	//   _nabí, rudo, sedn, nväg,
   {{0x68e22dcb,0x62882dcc,0x2fda01f7,0x7a2300ab}},	//   nyod, sudo, _bopg_, mõtt,
   {{0xf1bf2dcd,0x2d9c00b5,0xa01b00b5,0xe47b016b}},	//   clán_, ővel_, ltöz, _פרוכ,
   {{0x24520019,0xaaab00dc,0xa3b50c57,0xdb0e0168}},	//   _hâm_, _टैंक, _चोट_, _babí,
   {{0xe3b806d0,0x3ebe003e,0xdb0e08cb,0x67ef008c}},	//   ldı_, ætta_, _cabí, _iøje,
   {{0x61ed2dce,0x67ef054e,0x9f582dcf,0xfbc9007e}},	// [2470] _ilal, _høje, birà_, रालम,
   {{0xe3b806d0,0xd6ec0026,0x9f5807e5,0x68e22dd0}},	//   ndı_, जनाथ_, cirà_, dyod,
   {{0x20031977,0x24520028,0x61ed2dd1,0xbd0202a2}},	//   miji_, _lâm_, _klal, _éénm,
   {{0x20032dd2,0x9f582dd3,0xa95401e0,0x00000000}},	//   liji_, mirá_, екці, --,
   {{0x9f580453,0x61ed2dd4,0x67ef0a8a,0x00000000}},	//   lirá_, _mlal, _løje, --,
   {{0x20032dd5,0x7bc705ca,0xb8d513ab,0x32020097}},	//   niji_, _unju, _जन_, ziky_,
   {{0xdce60029,0x9f581c98,0xb8d4007c,0xe7360a22}},	//   _iekā, nirá_, _छै_, меш_,
   {{0x200325d0,0xb9c507f6,0xe4592701,0x3e5800d5}},	//   hiji_, _تقري, ожи_, _učte_,
   {{0x69c92dd6,0xdcfd008f,0xf1bf2dd7,0x200305e2}},	//   _inee, _kası, tlán_, kiji_,
   {{0x61ed22a8,0x20032dd8,0x69c901e8,0x24520019}},	//   _alal, jiji_, _hnee, _dâm_,
   {{0x20032dd9,0x32020076,0x61ed2dda,0x69db2ddb}},	//   diji_, tiky_, _blal, _koue,
   {{0x471a00c2,0x69db1010,0x7e690129,0xd6d80086}},	//   _וועג, _joue, ćepl, _эту_,
   {{0x25091c04,0x69db2ddc,0x057400bc,0x2bb2021a}},	//   _برای_, _moue, _ساند, ीयमा,
   {{0xdcfd0723,0xdb0e0aaf,0xdce60029,0x69db0248}},	//   _nası, _sabí, _nekā, _loue,
   {{0x9f582ddd,0x50432dde,0x69c92ddf,0x67ef008c}},	//   rirà_, терб, _onee, _gøje,
   {{0x69db2386,0x61ed2de0,0x69c901a8,0x00000000}},	//   _noue, _glal, _nnee, --,
   {{0x20030759,0xdcfd008f,0x24520019,0x9f58027a}},	// [2480] biji_, _bası, _xâm_, pirà_,
   {{0x20031851,0x9f582de1,0x69c92de2,0xe50e051d}},	//   ciji_, birá_, _anee, ापति_,
   {{0x69db2de3,0x9f581111,0xfc3f0138,0xdce602d4}},	//   _boue, cirá_, _asís_, _dekā,
   {{0x79a311b9,0xef1701c8,0x0906107b,0xa9670a87}},	//   врше, _імя_, мпен, дица_,
   {{0x7a23007c,0xe3b806d3,0xe9ff0019,0xd6cf00d1}},	//   võtt, ydı_, _giận_, یقه_,
   {{0x68e22de4,0xb05b013c,0x69c9018e,0xe3b800a8}},	//   ryod, sväg, _enee, xdı_,
   {{0x7a2300ab,0x69db000d,0x24522de5,0x7bdc0079}},	//   tõtt, _foue, _sâm_, _ioru,
   {{0x69db2de6,0xc88301d6,0x200315d7,0x67ef03d0}},	//   _goue, üğü_, ziji_, _røje,
   {{0x7bdc2de7,0xe3b800a8,0xdb0e021d,0xdcfd00a3}},	//   _koru, tdı_, _fabã, _yası,
   {{0x88bd004e,0x7bdc03d0,0x00000000,0x00000000}},	//   _myśl, _joru, --, --,
   {{0xe3b80092,0x200305e2,0x7bdc2de8,0x61ed2de9}},	//   rdı_, viji_, _moru, _plal,
   {{0x245200e8,0xd25701c8,0x9f580473,0xdb1c01ff}},	//   _tâm_, ьць_, virá_, _inrä,
   {{0x20030496,0x60f81482,0xdb0e0107,0x00000000}},	//   tiji_, дняя_, _labà, --,
   {{0x9f582dea,0xa2be0808,0x67ef08c8,0x00000000}},	//   tirá_, षिद्, _tøje, --,
   {{0x61ed0453,0xc7b801f2,0xe7e6007c,0xdb15021e}},	//   _tlal, _mađ_, _कवना_, _gazè,
   {{0x63b81217,0x20031851,0x9f582deb,0x61ed034d}},	//   _havn, siji_, rirá_, _ulal,
   {{0x69db0248,0x22980416,0x629a2dec,0xad9b0093}},	// [2490] _roue, lék_, ltto, _djúp,
   {{0x63b802dd,0x7bdc2ded,0xfe710164,0x69c92dee}},	//   _javn, _coru, _مگر_, _snee,
   {{0x69db2def,0xdb0e2df0,0xdcfd027d,0x229800b5}},	//   _poue, _cabà, _vası, nék_,
   {{0x7bdc0107,0xc3330d85,0xdb0e0132,0x629a0421}},	//   _eoru, דוע_, _sabã, itto,
   {{0x18692374,0x07a5097c,0x69db00f6,0xdb1c0282}},	//   чали_, еалн, _voue, _anrä,
   {{0x7bdc2df1,0x63b81123,0x212900d7,0xdb072df2}},	//   _goru, _navn, _myah_, _majú,
   {{0xd6d10c9e,0x26c10311,0x48ff0864,0x00000000}},	//   اقع_, ího_, _शेरो_, --,
   {{0x7bdc01d6,0x2298006c,0x9998010b,0x917a00e2}},	//   _zoru, dék_, _durų_, _mẫu_,
   {{0x7bdc08a1,0x21292df3,0x5436006c,0x63b80a8a}},	//   _yoru, _nyah_, کرٹر, _bavn,
   {{0xf6e72b92,0x2bd20099,0x629a0282,0x63b80139}},	//   _оцен, साया, ftto, _cavn,
   {{0x63b82df4,0xdb15024e,0x21292883,0xe9ff01a5}},	//   _davn, _bazé, _ayah_, _giản_,
   {{0xbbdc0084,0x22492df5,0x70cb2df6,0xe8200380}},	//   _मक्क, _ciak_, ामूल, मकथा_,
   {{0x64a501c8,0x629a0086,0x2bd20099,0x25ad07bd}},	//   _чала, atto, सामा, meel_,
   {{0x212916ab,0x25ad2df7,0x63b808c8,0xdb0e017b}},	//   _dyah_, leel_, _gavn, _inbö,
   {{0x5f1a02e4,0x6da62217,0xada600c3,0x76b300a8}},	//   _मुख्_, нива, навл, _bəyə,
   {{0x7bdc2df8,0x25ad0a45,0x2249011e,0xc1ba07f6}},	//   _soru, neel_, _giak_, _رابط_,
   {{0x7bdc1342,0x76b30095,0x248d2df9,0x1de100b4}},	// [24a0] _poru, _dəyə, nuem_, _नवरत,
   {{0xa09b00c2,0x7bdc01c2,0x25ad0c7c,0x1f662659}},	//   _צייט, _qoru, heel_, _яком,
   {{0x386d0118,0x79a62dfa,0x88bd004e,0x7bdc008a}},	//   _awer_, ерле, _wyśl, _voru,
   {{0x60c42dfb,0xd910042c,0x386d15b1,0xdb0e026e}},	//   _krim, لیز_, _bwer_, _cabá,
   {{0x25ad152b,0x7bdc2dfc,0x317b00a5,0x229800b5}},	//   deel_, _toru, פרסמ, zék_,
   {{0x229803fc,0xdb0e0176,0xe7c70066,0x60c425e8}},	//   yék_, _tabà, लागप, _mrim,
   {{0x63b802dd,0x629a0211,0x386d2dfd,0x2cb2001e}},	//   _ravn, xtto, _ewer_, lwyd_,
   {{0x63b82dfe,0x7af2027d,0x60c42dff,0xaa43021d}},	//   _savn, ıktı, _orim, _бесл,
   {{0x248d2e00,0x2cb20297,0x224910b9,0x60c401cb}},	//   guem_, nwyd_, _riak_, _nrim,
   {{0xa87b0052,0x22980332,0x224927a6,0xa01b06ed}},	//   _מאמר, ték_, _siak_, tröm,
   {{0x60c42e01,0x05662e02,0x21290ac8,0x7c3e0036}},	//   _arim, _звен, _syah_, impr,
   {{0x60c42e03,0x6e260159,0x229800b5,0x629a0234}},	//   _brim, _nkkb, rék_, rtto,
   {{0x60c41886,0x629a2e04,0xd5af27f6,0x229800fd}},	//   _crim, stto, _دفن_, sék_,
   {{0x2cb2001e,0x60c42e05,0x00000000,0x00000000}},	//   dwyd_, _drim, --, --,
   {{0x443e2e06,0x2249046a,0x6e26012f,0x60c42e07}},	//   mmt_, _tiak_, _bkkb, _erim,
   {{0x60c42e08,0x644a2e09,0x7c3e1c98,0x442c2e0a}},	//   _frim, _hifi, empr, lld_,
   {{0x644a2e0b,0x2cb2001e,0x212901cb,0x442c2e0c}},	// [24b0] _kifi, gwyd_, _uyah_, old_,
   {{0xdb0e171c,0x62880036,0xdb1507c0,0x644a007a}},	//   _sabá, ordo, _enzý, _jifi,
   {{0x442c2e0d,0x67ef08c8,0x59bf021a,0x19b90bfc}},	//   ild_, _nøja, _एफआर, дуль_,
   {{0x443e033b,0x644a008d,0xf1bf1534,0x00000000}},	//   hmt_, _lifi, dlák_, --,
   {{0x644a04d6,0x25ad0d26,0x7ae500c3,0x67d501e0}},	//   _oifi, veel_, syht, коду,
   {{0x644a2e0e,0x660201d5,0x07a504bf,0x6e2d2e0f}},	//   _nifi, _amok, такн, llab,
   {{0x79a700d8,0x25ad2e10,0xdb0e2e11,0x00000000}},	//   _прае, teel_, _tabá, --,
   {{0x6e2d0dc3,0x2bc900b8,0x66021980,0x442c2e12}},	//   nlab, राका, _cmok, eld_,
   {{0x8cc4004e,0x6e2d0052,0x25ad11cc,0x62882e13}},	//   रियो, ilab, reel_, erdo,
   {{0xd6db002d,0xf1bf00d5,0xd7f82e14,0x00000000}},	//   _нте_, lláh_, _пух_, --,
   {{0x60c40feb,0x6e2d2e15,0x25ad0b88,0x6d5d2e16}},	//   _srim, klab, peel_, _ofsa,
   {{0x442c01e4,0x443e0110,0xd70d00b4,0x20112206}},	//   ald_, amt_, िपीठ_, enzi_,
   {{0x248d2e17,0xe3ae1b0a,0xdd92103b,0xa879016b}},	//   quem_, _кб_, یوس_, ואָר,
   {{0x60c42e18,0x65692e19,0x6e2d1167,0x644a01d5}},	//   _vrim, lbeh, elab, _gifi,
   {{0x91fd0029,0x6e2d2e1a,0x7a380172,0x2d962e1b}},	//   mpān, flab, líte, крас,
   {{0x6e2d2e1c,0xa6e901a5,0x65692e1d,0x644a01d5}},	//   glab, _trươ, nbeh, _zifi,
   {{0x7a382ac4,0x60c42e1e,0x1d071761,0xa3e50099}},	// [24c0] níte, _urim, вети_, _नवा_,
   {{0xdca3195a,0x2bd2052b,0x2cb2001e,0x6e2d2e1f}},	//   рафи, साधा, rwyd_, alab,
   {{0xee3a2e20,0xeb972e21,0x7c3e037d,0xdce40009}},	//   _оно_, тих_, rmpr, mbič,
   {{0x7c662e22,0x6e2d2e23,0xa96a0036,0x442708c7}},	//   _لاسل, clab, фида_, _lkn_,
   {{0x443e2e24,0x442c2e25,0x26c501d7,0xdce4011c}},	//   ymt_, yld_, _arlo_, obič,
   {{0x66022e26,0x656901ba,0x62880523,0xc8650037}},	//   _smok, ebeh, yrdo, اطني,
   {{0x644a2e27,0xa3d500c0,0x7bce2e28,0x764b2e29}},	//   _rifi, हान_, _inbu, _bigy,
   {{0x644a2e2a,0x44270159,0x6adb0033,0x23690009}},	//   _sifi, _akn_, _যেকো, _đaja_,
   {{0x41d60567,0xd94319b3,0x7a38006c,0x644a1c5b}},	//   धानस, _вети, gíte, _pifi,
   {{0x442c0052,0x38662e2b,0x6e2d0fdf,0x67ef0a8a}},	//   uld_, mpor_, zlab, _højn,
   {{0x442c04e2,0x443e039b,0x764b0332,0xd5af1208}},	//   rld_, rmt_, _figy, _кс_,
   {{0x66022e2c,0xfc3f099e,0xe4a62e2d,0x764b0090}},	//   _umok, _apíl_, _арко, _gigy,
   {{0x644a0cd4,0x7bce0296,0x443e0176,0x00000000}},	//   _tifi, _onbu, pmt_, --,
   {{0x6e2d026e,0x00000000,0x00000000,0x00000000}},	//   wlab, --, --, --,
   {{0x6e2d14d4,0x20110009,0xd3780035,0xdbdc0093}},	//   tlab, rnzi_, mać_, _ráðl,
   {{0xb283004b,0x51870f8f,0x6e2401d7,0x7bce2e2e}},	//   _тышк, _рука, goib, _anbu,
   {{0x31792e2f,0x5d5421be,0xe3b8013b,0x00000000}},	// [24d0] masz_, ркут, llıq_, --,
   {{0x317900f5,0xa3d51fb4,0x6e2d2e30,0xd3780035}},	//   lasz_, हाय_, slab, nać_,
   {{0xf09f2e31,0x16220653,0x78a901ba,0xe3b80095}},	//   ltà_, मवार_, _spev, nlıq_,
   {{0xa01b0093,0xf1bf021d,0x75f500d5,0xd378263f}},	//   fsög, ndá_, _káze, hać_,
   {{0xd378004e,0xf09f2e32,0xa3c82e33,0xbddb00f6}},	//   kać_, ntà_, _लोभ_, _bièv,
   {{0xf09f027a,0xe7392e34,0xdb1c0345,0xd3780067}},	//   ità_, нел_, _marê, jać_,
   {{0x17f30302,0xd378006a,0x9f510033,0x31792130}},	//   _अतीव_, dać_, lizó_, kasz_,
   {{0x26c501cc,0xe3b80095,0xa2d6164f,0x442700fe}},	//   _vrlo_, dlıq_, यमन्, _skn_,
   {{0x65692e35,0x75f501c0,0x78a90187,0x9f5100de}},	//   rbeh, _náze, _upev, nizó_,
   {{0x7a382e36,0x7c2528b0,0x2cb900d7,0xd3780035}},	//   ríte, nohr, _mssd_, gać_,
   {{0x420a15de,0xf09f02fb,0x7a380c5d,0xa91d0254}},	//   енно_, età_, síte, _udžb,
   {{0x28c709b4,0x7a3800b5,0x09b10033,0xf1bf021d}},	//   लिपि, píte, ছাকা, gdá_,
   {{0x7c252e37,0xdb1c2e38,0x03a51126,0x44270088}},	//   kohr, _carê, _било, _tkn_,
   {{0x25bd001e,0x66092e39,0xd3780035,0x00000000}},	//   _hawl_, liek, cać_, --,
   {{0x44252e3a,0x249f008d,0x539a00a5,0x932400f8}},	//   mol_, ltum_, _ניקו, _پرون,
   {{0x44252e3b,0x66090080,0xe1f200bf,0x25bf2e3c}},	//   lol_, niek, _دست_, ndul_,
   {{0xa3c80cea,0xf09f0176,0x2cb900fe,0x00000000}},	// [24e0] _लोड_, ctà_, _cssd_, --,
   {{0x442502c7,0x249f2e3d,0xeb972e3e,0x2d99009e}},	//   nol_, itum_, лиу_, _ecse_,
   {{0xdee62101,0xfbc90e3b,0x7f9b0122,0xc9862d0c}},	//   _сони, राजम, _אביז, гули,
   {{0x44252e3f,0xd3780035,0x249f2e40,0x200a00a8}},	//   hol_, zać_, ktum_, libi_,
   {{0x44252e41,0x7a1c00b8,0xdbd200be,0x7c252e42}},	//   kol_, jčte, _küüs, bohr,
   {{0x44252e43,0x2ca004ca,0xbddb021e,0xa01b0093}},	//   jol_, mtid_, _chèf, rsög,
   {{0x44252e3f,0x09a900c8,0x2ca02e44,0x38662e45}},	//   dol_, ওয়া, ltid_, spor_,
   {{0xd3780755,0x200a06d3,0x249f008d,0x9634052c}},	//   wać_, hibi_, ftum_, јниц,
   {{0x44250297,0x249f2e46,0xd378004e,0x77940220}},	//   fol_, gtum_, tać_, _نیشا,
   {{0x3a261516,0x44252413,0x200a00d7,0xe3b800a8}},	//   loop_, gol_, jibi_, tlıq_,
   {{0xd3780035,0x25bf007a,0x53342e47,0x66092e48}},	//   rać_, bdul_, рент, biek,
   {{0xf09f0133,0xe3b80095,0xd378004e,0x2ca0007c}},	//   ttà_, rlıq_, sać_, ktid_,
   {{0x44252e49,0x3dc0001e,0xf1bf00ac,0xfc3f00d5}},	//   bol_, ddiw_, rdá_, _spím_,
   {{0x44252e4a,0xf09f2e4b,0xc3560133,0x682d0752}},	//   col_, rtà_, _съдъ, túdi,
   {{0xf09f2e4c,0x3a2603c4,0xa36f01ba,0x7c250501}},	//   stà_, koop_, äčši, vohr,
   {{0x270e01c2,0xf09f0176,0x9f510453,0x443c1f8b}},	//   _mən_, ptà_, tizó_, _hhv_,
   {{0x9f4100da,0x1ae20083,0x200a2e4d,0x7c250393}},	// [24f0] _kohë_, _গেলে_, bibi_, tohr,
   {{0x320b0052,0x66092e4e,0x41c300dc,0x9f510453}},	//   licy_, ziek, षयवस, rizó_,
   {{0xa3d52e4f,0xddd001d6,0x9e352e50,0x28c700b8}},	//   हात_, _çeşi, _венч, लिभि,
   {{0x44252e51,0x320b0035,0xdb1c2e52,0x4c950210}},	//   zol_, nicy_, _marè, _кимс,
   {{0x44252e53,0x2ca000e9,0x25bd0051,0xdb1c021e}},	//   yol_, ctid_, _rawl_, _larè,
   {{0xc5ed00b4,0x6609004e,0x25bd001e,0xba77097f}},	//   जस्य_, wiek, _sawl_, _مارت,
   {{0xec360052,0x66092e54,0x44252e55,0x2bd20907}},	//   _כאשר_, tiek, vol_, सारा,
   {{0x249f2e56,0x44252e57,0x270e0095,0xc4850424}},	//   ttum_, wol_, _dən_, алик,
   {{0x44252e58,0x25bf2e59,0x47d50987,0x443c0d24}},	//   tol_, rdul_, _پيار, _bhv_,
   {{0x66092e5a,0x442500e9,0x78bb2e5b,0x7a382e5c}},	//   siek, uol_, _isuv, míta,
   {{0x249f2e5d,0xc5d50131,0x216a0adb,0x64412e5e}},	//   stum_, _віль, кини_, rmli,
   {{0x44250297,0x249f0093,0xb05b013c,0xdb1c00e0}},	//   sol_, ptum_, rvän, _darè,
   {{0x200a00a8,0x04670043,0xdb1c01f4,0xb05b01ff}},	//   tibi_, _стем, _parë, svän,
   {{0x88bd006a,0x248d2e5f,0x44252e60,0xb4fa00a5}},	//   _wyśw, mrem_, qol_, _בפני,
   {{0x645b00c8,0x200a2e61,0x52752192,0xdb1c2e62}},	//   lqui, ribi_, _тулу, _varë,
   {{0xdd922e63,0x06af00c8,0x8e5502ce,0x4d6600d8}},	//   تور_, কিপি, стрі, ркав,
   {{0x248d2e64,0x645b2e65,0xed570c95,0x245b0345}},	// [2500] nrem_, nqui, роу_, _jêm_,
   {{0x907b00c2,0x307b0122,0x2ca00e45,0x272201ba}},	//   _שטיי, _שאינ, rtid_, nčné_,
   {{0x2ca02e66,0x703b0332,0xdb1503e6,0x78bb03a6}},	//   stid_, _جسٹس_, _razã, _asuv,
   {{0x705303c5,0x7ae31535,0xc33200a5,0xb05b013c}},	//   _دنیا, änta, חוב_, kväl,
   {{0x270e0095,0xdb1c2e67,0x3a260a81,0x61e42e68}},	//   _sən_, _maré, roop_, _moil,
   {{0xb2270093,0xdb072e69,0x248d2e6a,0x18670274}},	//   _klæð, _cajó, drem_, шаљи_,
   {{0x645b0d9a,0x5b3500d8,0xdb05033b,0xdb150183}},	//   equi, _гэту, gehä, _vazã,
   {{0xe5c62462,0x248d2e6b,0x61e42e6c,0x443c011e}},	//   рско, frem_, _noil, _shv_,
   {{0x7a380168,0x918300e2,0x69c02e6d,0xdb1c00e0}},	//   cíta, _nếu_, _iame, _sarè,
   {{0x69c22e6e,0xdb1c02e9,0x53e600af,0x245b0345}},	//   ldoe, _parè, рциа, _dêm_,
   {{0x78a22e6f,0x4b7b02b5,0x248d2e70,0x443c055c}},	//   ltov, כטיג, arem_, _vhv_,
   {{0x61e40094,0x248d2e71,0x69c22e72,0x69c00e6d}},	//   _coil, brem_, ndoe, _jame,
   {{0x78a20097,0x69c02e73,0x645b2e74,0x61e42e75}},	//   ntov, _mame, cqui, _doil,
   {{0xf7780069,0xdb070107,0x00000000,0x00000000}},	//   _jeħ_, _majò, --, --,
   {{0x61e4148b,0x69c00012,0x34b60c67,0x9e0712fa}},	//   _foil, _oame, _अनुद, ачал,
   {{0x5d552e76,0x78a22e6f,0xdb0506d7,0x69c02e77}},	//   скат, ktov, nehå, _name,
   {{0x78a22e78,0xbddb00f7,0x69c200e9,0xd7c60099}},	// [2510] jtov, _bièr, ddoe, लयाच,
   {{0x6fb504e8,0xeb930206,0x7a382e79,0x61e402d7}},	//   _امدا, تظر_, víta, _zoil,
   {{0xdb152e7a,0xcf920122,0x69c001d0,0x645b1e6e}},	//   _bazá, _צטט_, _bame, zqui,
   {{0x69c02e7b,0xc9872e7c,0xd7c80088,0x61e401ed}},	//   _came, ружи, یونه_, _xoil,
   {{0xa3c60302,0xf09402b5,0xf1bf00b5,0x645b02d7}},	//   उया_, ַנק_, llás_, xqui,
   {{0x645d2e7d,0xe8f800d8,0x248d0811,0x67f40176}},	//   ísim, шлі_, vrem_, _pàja,
   {{0xc66802cc,0x69c02e7e,0x657b0dc3,0x7a382e7f}},	//   ашње_, _fame, tauh, síta,
   {{0x248d2e80,0x69c02e81,0xff1802b8,0x32090159}},	//   trem_, _game, יקות_, _nmay_,
   {{0x32f70095,0x61e40341,0xf1bf01ba,0x78a22e82}},	//   məyə_, _roil, hlás_, ctov,
   {{0x61e42e83,0x69c01be6,0x248d2e84,0x32090159}},	//   _soil, _zame, rrem_, _amay_,
   {{0x645b00c9,0x61e42e85,0x69c00565,0xdb1c2e86}},	//   squi, _poil, _yame, _paré,
   {{0x245b0370,0xa06a2e87,0x248d2e88,0x682d0079}},	//   _têm_, лама_, prem_, rúdu,
   {{0x61e402e1,0x7056004f,0x68fc00a8,0x201a021d}},	//   _voil, إنسا, _ərdo, _pjpi_,
   {{0x7afe2e89,0x76aa01c2,0x51f600d1,0x64590118}},	//   yzpt, _həya, _گستر, _iuwi,
   {{0x2295004f,0x6459007a,0x52850037,0x61e42e8a}},	//   _العس, _huwi, _البك, _toil,
   {{0x78a2114d,0x64592e8b,0x51f60e3a,0x8cc42e8c}},	//   ytov, _kuwi, _دستر, रिलो,
   {{0x22830723,0x78a2024e,0x64592e8d,0x32f700a8}},	// [2520] lık_, xtov, _juwi, dəyə_,
   {{0x69c0245b,0x628101f2,0x78a20478,0x7e690124}},	//   _same, oslo, vtov, ćepr,
   {{0x6281165e,0xcf570122,0xdcef0029,0x7d0925d2}},	//   nslo, _לבית_, _vecā, _žest,
   {{0xe8fa0104,0x78a21622,0x5ca60012,0x65792e8e}},	//   лле_, ttov, _лимб, _newh,
   {{0x69c22e8f,0xb3b70253,0x17540d13,0x9f4100e0}},	//   rdoe, _असंख, овля, _rohé_,
   {{0x69c019c6,0x78a20bca,0xab2a2e90,0x6283040b}},	//   _wame, rtov, _бога_, _ovno,
   {{0x69c02e91,0x78a22e92,0x76aa0095,0x75f50355}},	//   _tame, stov, _bəya, _sáza,
   {{0x78a22e93,0x2283027d,0x6459067f,0x8a0602d5}},	//   ptov, dık_, _buwi, _узбе,
   {{0x62832e94,0x98b50461,0x7a3800b5,0x62812e95}},	//   _avno, _आईएए, líto, eslo,
   {{0x64592e96,0x9f410118,0x00000000,0x00000000}},	//   _duwi, _wohé_, --, --,
   {{0x02a30ebb,0x00000000,0x00000000,0x00000000}},	//   прям, --, --, --,
   {{0x22402e97,0xa3c800ab,0x00000000,0x00000000}},	//   _chik_, _लोर_, --, --,
   {{0x25b700d1,0x75f500ac,0x224000f8,0x9f4100a0}},	//   _دهند_, _kázn, _dhik_, _dlhý_,
   {{0x765a2e98,0xb4e404ef,0xb4d40099,0x26cc00cd}},	//   _kuty, नही_, हमी_, _krdo_,
   {{0xa3d50726,0x0cd12e99,0x2283027d,0x32f700a8}},	//   हार_, सम्म, cık_, yəyə_,
   {{0x5ebb0083,0x75f500b8,0xf1bf00b5,0x76aa00a8}},	//   _উপদে, _lázn, rlás_, _xəya,
   {{0xc4b622c7,0x13ac0033,0xae0213ab,0x00000000}},	// [2530] _अनोख, _কোয়, रोइन_, --,
   {{0x26cc2e9a,0x3a2d0173,0x442e012f,0x60cd19df}},	//   _ordo_, _skep_, _jkf_, _iram,
   {{0x1dc40240,0xbddb02e9,0x60cd0ce9,0x442e00ee}},	//   _लोकत, _chèc, _hram, _mkf_,
   {{0x60cd2e9b,0x777a01ed,0xdb1c0312,0x67ef008c}},	//   _kram, _aetx, _anró, _tøjk,
   {{0x26cc2e9c,0x75f500d5,0x2283027d,0x777a0a8a}},	//   _ardo_, _bázn, zık_, _betx,
   {{0x765a2d1a,0x26cc0bc6,0x62812e9d,0x60cd2e9e}},	//   _buty, _brdo_, yslo, _mram,
   {{0x7bd52e9f,0x4e0d0066,0xe73900c3,0xcf940070}},	//   _inzu, _सगाई_, шек_, לטס_,
   {{0x7d092ea0,0x60cd2ea1,0x291f0221,0x26c70169}},	//   _þess, _oram, _txua_, rvno_,
   {{0xa3d50af6,0x6aa52ea2,0x41dd0ea3,0xf1dd012f}},	//   हाल_, lthf, यानस, यानन,
   {{0x98170dd2,0x228301d6,0x7bc500bf,0x777a01d7}},	//   _ابرا, tık_, ndhu, _getx,
   {{0x60cd2ea3,0xe9ff0019,0x28c70722,0x765a018c}},	//   _aram, _nhẫn_, लिवि, _guty,
   {{0x60cd2ea4,0x75f50237,0x64592ea5,0x6aa52ea6}},	//   _bram, _zázn, _tuwi, ithf,
   {{0x04c90d4f,0x62812ea7,0x316d20d9,0x24191667}},	//   _خوشي_, sslo, ñeza_, _коды_,
   {{0x628307c0,0x3dc203d0,0x3f9e018d,0xae02021a}},	//   _tvno, _sakw_, ütu_, रोईन_,
   {{0x60cd2ea8,0xe2992725,0x22402ea9,0xd34700d1}},	//   _eram, _тай_, _thik_, _دیده_,
   {{0x60cd2eaa,0x7bd502c9,0xdd1c0187,0x61fd033b}},	//   _fram, _anzu, rážc, chsl,
   {{0x60cd0065,0xdca30e75,0xac0a0279,0x640200e0}},	// [2540] _gram, мати, анаа_, _رژیم,
   {{0x91a6006c,0x7bc52eab,0x602600d4,0x79890090}},	//   _اچھے_, gdhu, _єдна, _adew,
   {{0x2bce02cb,0x75f52eac,0x34b613a0,0x1c391303}},	//   _होणा, _názo, _अन्द, сять_,
   {{0xa3d5056a,0xf1dd022e,0x41dd0ea3,0x7bd5054b}},	//   हाँ_, यायन, यायस, _enzu,
   {{0x2db70122,0x7989001e,0x636600b8,0x7a38006c}},	//   _ולכן_, _ddew, nční, síto,
   {{0x7a380d42,0xdb1c054d,0x75f500ee,0x00000000}},	//   píto, _harí, _bázo, --,
   {{0xf1ca0d53,0x26c30124,0x41dd0355,0x41ca0e61}},	//   ियान, _šjor_, यामस, ियास,
   {{0x2bce04cc,0x95ca2ead,0x63660355,0x00000000}},	//   _होता, рука_, kční, --,
   {{0xdb1c2eae,0xa3d5020d,0xe9ff0019,0x75fc006c}},	//   _marí, हां_, _hiến_, _néze,
   {{0xe9ff0028,0xdb1c01ef,0x765a01a8,0xc34a0328}},	//   _kiến_, _larí, _tuty, ияне_,
   {{0x60cd2eaf,0x6fde2eb0,0x75f500fd,0x00000000}},	//   _sram, मानं, _gázo, --,
   {{0x60cd2eb1,0x442e012f,0xe9ff00e2,0x00000000}},	//   _pram, _wkf_, _miến_, --,
   {{0x845a0279,0x00000000,0x00000000,0x00000000}},	//   _трет_, --, --, --,
   {{0x24860124,0x05a601c0,0xe9ff00e2,0xe3a413cf}},	//   _ivom_, क्रब, _phẫn_, _رشتی,
   {{0x226301ba,0xdb1c002a,0x15ee00ab,0xe29710b4}},	//   ľské_, _barí, _जवार_, _дај_,
   {{0x442c2eb2,0x2d582eb3,0xc333134d,0x02fb0397}},	//   lod_, жить_, _קוק_, _כלומ,
   {{0xa80201d6,0xdb1c0b4c,0x60cd2eb4,0x00000000}},	// [2550] şıyo, _darí, _uram, --,
   {{0x442c2eb5,0xe9ff0028,0x6d5a00a8,0xbddb01da}},	//   nod_, _biến_, _ştat, _dhèa,
   {{0x20112eb6,0xdb1c039f,0x7bc501f4,0x75f500d5}},	//   mizi_, _farí, rdhu, _bázl,
   {{0x248601cc,0x442c2eb7,0x20112eb8,0x6aa5001e}},	//   _ovom_, hod_, lizi_, rthf,
   {{0x442c2eb9,0x7e62219c,0x6e2d0553,0x8dda00a5}},	//   kod_, _čopi, moab, _הקרק,
   {{0x20112eba,0x7bd5033b,0x6e2d01ed,0x00000000}},	//   nizi_, _unzu, loab, --,
   {{0x442c2ebb,0xea63006c,0x69a600b4,0x00000000}},	//   dod_, _آپری, _टॉकी, --,
   {{0x20112ebc,0x9f580036,0x764227d2,0x644812ba}},	//   hizi_, nirò_, _choy, emdi,
   {{0x442c0297,0x201104f7,0x588400d8,0x764200e0}},	//   fod_, kizi_, _жыха, _dhoy,
   {{0x442c149b,0x20110a78,0x24861b89,0x6e2d00cc}},	//   god_, jizi_, _dvom_, hoab,
   {{0x20112ebd,0x232908d9,0xdb070097,0x248600f4}},	//   dizi_, сони_, _objí, _evom_,
   {{0x27340037,0x75fc00f6,0x00000000,0x00000000}},	//   súnú_, _péze, --, --,
   {{0xb81f009a,0x442c2ebe,0xa01b02c9,0x455a0bed}},	//   _बदाम_, bod_, rsön, _הכנס,
   {{0x7fd50131,0x76492c7c,0x442c0987,0x20110b69}},	//   місі, lmey, cod_, gizi_,
   {{0xdb1c2ebf,0x2d8000af,0xdee601e0,0x00000000}},	//   _parí, taie_, чови, --,
   {{0x661b0f67,0xee3a00d8,0x764901d6,0xe1ff2ec0}},	//   nnuk, ёна_, nmey, chó_,
   {{0xdb1c2ec1,0x2011194a,0x2d802ec2,0xd34700d1}},	// [2560] _varí, bizi_, raie_, _دیگه_,
   {{0x2d802ec3,0x76492ec4,0x5ebb0033,0x7a3801ef}},	//   saie_, hmey, _উপরে, rítm,
   {{0xdb1c00ee,0x05bd00a1,0x7a3800b5,0xd5bd01d1}},	//   _tarí, ्याब, sítm, ्याज,
   {{0xc8c702e4,0x442c2ec5,0xdb1c2ec6,0x98a62ec7}},	//   लिंट, zod_, _parâ, зиде,
   {{0x442c121e,0x64430187,0xdb1c0279,0xed5200d1}},	//   yod_, _ohni, _barã, _سپس_,
   {{0xe9ff0028,0x26090084,0xdb0e00b8,0x6d3b00a5}},	//   _tiến_, ़ोसी_, _zabý, _לתכנ,
   {{0x248601cc,0x8c432ec8,0x8cc40026,0xb4d40096}},	//   _svom_, _чере, रिको, हम्_,
   {{0xd49a0dde,0xceb30122,0x442c00e9,0xcb370070}},	//   бро_, גיה_, wod_, _זאלי_,
   {{0x442c2ec9,0x38c80bb4,0x7d042eca,0x2902013c}},	//   tod_, _بازی_, nzis, _åka_,
   {{0x6e2d1945,0x64430341,0xa2f400d4,0x442c0159}},	//   zoab, _chni, дпоч, uod_,
   {{0x64480029,0x20112ecb,0xa1950f16,0xe4da0df3}},	//   rmdi, vizi_, манч, _گوشت_,
   {{0x442c2ecc,0xd25701c8,0x2486044d,0xbbc80167}},	//   sod_, яць_, _tvom_, रयुक,
   {{0x442c2ecd,0x20112ece,0x6443009e,0x00000000}},	//   pod_, tizi_, _fhni, --,
   {{0x1ae200c8,0x7d040035,0x442c009f,0xdb0e00de}},	//   _গেছে_, dzis, qod_, _jabó,
   {{0x63ba2676,0x53332ecf,0x2be0175f,0x20112ed0}},	//   metn, _пешт, नाना, rizi_,
   {{0x63ba067b,0x629a2ed1,0x67ef01b4,0x753d0035}},	//   letn, muto, _højt, ższe,
   {{0x629a2ed2,0x9f58027a,0x7d040409,0x76aa013b}},	// [2570] luto, rirò_, gzis, _səyl,
   {{0x7a38126b,0xf0450609,0xa2d0012f,0x629a08c7}},	//   líth, _تعبی, धिप्, outo,
   {{0x3f8301cc,0xdb1c12c3,0x9f580036,0x53ae0517}},	//   maju_, _carà, pirò_, ज्यश,
   {{0x3f832ed3,0x391500c3,0x63ba006c,0x7aea01ff}},	//   laju_, ммер, hetn, äfta,
   {{0x63ba2ed4,0x48ab107a,0x2bce012f,0x25e00d91}},	//   ketn, стем_, _होवा, कानी_,
   {{0xfe7000f8,0x63ba17ee,0x629a2ed5,0xdb1c0392}},	//   _جدی_, jetn, kuto, _farà,
   {{0x2ca92ed6,0x629a2ed7,0x7649027d,0x661b0553}},	//   ltad_, juto, tmey, tnuk,
   {{0x629a130f,0x7bc72ed8,0x644300fe,0x3f830e31}},	//   duto, _haju, _shni, haju_,
   {{0x2ca92ed9,0x764901d6,0x7bc72eda,0x3f83287d}},	//   ntad_, rmey, _kaju, kaju_,
   {{0x3f8301cc,0x386d2edb,0xdb1c2edc,0x7bc70107}},	//   jaju_, _iter_, _hará, _jaju,
   {{0x7bc72edd,0x3f8301cc,0x629a2ede,0x0cba00df}},	//   _maju, daju_, guto, _उन्म,
   {{0x7bc70e9c,0x2ca92edf,0xdb0e2ee0,0xa91d00cd}},	//   _laju, ktad_, _kabò, _adži,
   {{0xa3c80f9f,0x629a2ee1,0x2be0166b,0x53a52ee2}},	//   _लोक_, auto, नामा, _жалб,
   {{0x63ba18b0,0x3f83235b,0xad9b0176,0xdb0e0042}},	//   cetn, gaju_, _llúd, _xabó,
   {{0xe9ff00e8,0x67ef01b4,0xa5c60067,0xbea32ee3}},	//   _nhắn_, _højs, _wróż, карк,
   {{0x51561578,0xee3a1112,0x3ce001e8,0x386d00f6}},	//   _отпу, іна_, txiv_, _oter_,
   {{0xbc6a0d93,0x3f832ee4,0x7bc72ee5,0x2ca92ee6}},	// [2580] زمان_, baju_, _baju, gtad_,
   {{0x3f832ee7,0x60c42ee8,0x7d042ee9,0xdb1c0443}},	//   caju_, _isim, rzis, _parà,
   {{0xdb1c2eea,0xfbd10332,0xe9ff0019,0x09e60c0d}},	//   _bará, ھتے_, _chắn_, можн,
   {{0x63ba2eeb,0xdb1c1423,0xad9b0037,0x25ad2eec}},	//   zetn, _cará, _clúd, jfel_,
   {{0x307a02b5,0xdb1c2eed,0xdb0e01f7,0x61fd0031}},	//   קאַנ, _dará, _cabò, ërli,
   {{0x60c4000e,0x38cb03fc,0xdb0e021e,0xdb1c0176}},	//   _msim, غانی_, _dabò, _tarà,
   {{0xa3c81033,0x25ad2eee,0x63ba0169,0xe81f0324}},	//   _लोग_, ffel_, vetn, _बदरा_,
   {{0xdb1c2eef,0x60c42ef0,0x629a2ef1,0xfc3f00ac}},	//   _gará, _osim, vuto, _upír_,
   {{0x63ba2ef2,0x7bc72ef3,0x60c41815,0x75fc2ef4}},	//   tetn, _yaju, _nsim, _céza,
   {{0x42742ef5,0xdb1c2ef6,0xb05b033b,0xa3d50084}},	//   нгос, _zará, hwäc, हाग_,
   {{0x63ba2ef7,0x3f830537,0x629a010d,0x65c602f2}},	//   retn, vaju_, uuto, _обжа,
   {{0x629a2ef8,0x63ba0bd1,0x74130609,0x27ec00d5}},	//   ruto, setn, _یونا, _hodn_,
   {{0x3f830a78,0xc5f30122,0x2fda01ef,0x798002d0}},	//   taju_, _בדף_, _bnpg_, _memw,
   {{0x629a2ef9,0x67ef01b4,0xbbc80067,0x7a3800b5}},	//   puto, _højr, रयोक, síth,
   {{0x3f830537,0x60c42efa,0xa01b01ff,0x7bc70dfa}},	//   raju_, _esim, lsök, _raju,
   {{0x2ca92efb,0x7bc72efc,0x3f831e1a,0x79802efd}},	//   ttad_, _saju, saju_, _nemw,
   {{0xe81f017a,0x64582efe,0x3f830254,0x7bc72eff}},	// [2590] _बदला_, _kivi, paju_, _paju,
   {{0x2ca92f00,0x41dd112b,0x2c64013c,0x9f4500b5}},	//   rtad_, यावस, _död_, óló_,
   {{0x2ca92f01,0x62882f02,0x386d11cc,0x23a61fb4}},	//   stad_, nsdo, _ster_, _खानद,
   {{0x64582f03,0xa91d2f04,0xceb202b5,0x7bc7000e}},	//   _livi, _leže, _גיט_, _waju,
   {{0x7bc72f05,0x9f58004f,0x6d5d0008,0x645802c4}},	//   _taju, mhrá_, _igsa, _oivi,
   {{0xf7450043,0x07a206c2,0x75fc01ef,0xb05b2f06}},	//   нело, гашн, _réza, lväs,
   {{0x25ad0012,0x49bb00bf,0x75f500b5,0x199500d8}},	//   tfel_, _وارد_, _házi, _павя,
   {{0xcf5801f3,0x6b850ce8,0x649917d0,0xad9b2f07}},	//   ובות_, lahg, птор_, _flúe,
   {{0x64582f08,0x7a3801dd,0x25ad0d04,0x386d0139}},	//   _bivi, xíti, rfel_, _uter_,
   {{0x87d40088,0xc747017e,0x38a92f09,0x75f500d5}},	//   _لغما, _قضاي, múr_, _mázi,
   {{0x61ed002d,0xa91d008b,0x798004fb,0x25ad033b}},	//   _boal, _deže, _yemw, pfel_,
   {{0x25e000a1,0x64582f0a,0x69cb08f3,0x60c4003a}},	//   काणी_, _eivi, ndge, _psim,
   {{0xe9ff00e8,0x3f812f0b,0x69c90159,0x61ed01b7}},	//   _nhận_, _behu_, _maee, _doal,
   {{0x7a382f0c,0x6d5d13d6,0x6b85012f,0x64582f0d}},	//   ríti, _agsa, jahg, _givi,
   {{0x6e290187,0x6288009e,0xa3c81604,0xa3dc0354}},	//   čebn, csdo, _लोट_, डार_,
   {{0x64582f0e,0x60c42f0f,0x69c90159,0x91fd0029}},	//   _zivi, _tsim, _naee, spār,
   {{0xdd8f18dd,0x60c42f10,0xf65202b5,0x1c461c80}},	// [25a0] صول_, _usim, רצן_, енам,
   {{0x61ed04ce,0x26c500d4,0x69c90176,0x69cb1192}},	//   _zoal, _oslo_, _aaee, edge,
   {{0xdb1c0370,0x8f9b0070,0x2c520107,0x69cb02a2}},	//   _març, _ציטי, _jņdi_, fdge,
   {{0xa9261309,0x4911018d,0x69cb0479,0x5fde0e61}},	//   ндел, _देहो_, gdge, मावल,
   {{0x27fe022e,0x02db06fe,0xb05b01ff,0x27ec02a7}},	//   _pltn_, यमुन, lvär, _podn_,
   {{0x2d8200d7,0xfaa62f11,0x69db01ed,0x69cb0345}},	//   _heke_, _паго, _enue, adge,
   {{0x79802104,0x8f9b02b5,0x7bdc2f12,0x2d822f13}},	//   _temw, ליסי, _inru, _keke_,
   {{0x64582f14,0xc1ca08d1,0xd49a0210,0x49110b35}},	//   _sivi, ियोग, про_, _देवो_,
   {{0x76590297,0xdb1c2f15,0x64582f16,0x2d822f17}},	//   _diwy, _barç, _pivi, _meke_,
   {{0xa01b06d7,0x61ed2f18,0x66e62f19,0x2d822f1a}},	//   rsök, _soal, _поза, _leke_,
   {{0x64582993,0xa3d50084,0x61ed0139,0xa91d0612}},	//   _vivi, हाज_, _poal, _veže,
   {{0x2d822f1b,0x62882f1c,0xb05b01ff,0xdb050079}},	//   _neke_, rsdo, dvär, nfhá,
   {{0x61ed2f1d,0xa91d02f6,0x64582f1e,0x62880408}},	//   _voal, _teže, _tivi, ssdo,
   {{0xdb1c2f1f,0x00000000,0x00000000,0x00000000}},	//   _garç, --, --, --,
   {{0x2d820107,0x00000000,0x00000000,0x00000000}},	//   _beke_, --, --, --,
   {{0xbddb02e1,0xe9ff01a5,0x7bdc01ae,0x8ccd00dc}},	//   _thèm, _phận_, _anru, सिलो,
   {{0x76aa01c2,0x2d822181,0x5d550265,0x3f8100d5}},	// [25b0] _dəyi, _deke_, ткат, _tehu_,
   {{0xb603016f,0xb606011c,0xfe710647,0xf1bf178f}},	//   čšin, lešć, _نگر_, leá_,
   {{0x2013009f,0x22490118,0x62a400d5,0x25a60160}},	//   _imxi_, _khak_, _úroč, _ocol_,
   {{0xe9ff0019,0x38a92f20,0x2d820051,0xbcfb00a2}},	//   _thận_, túr_, _geke_, _agée,
   {{0x69cb0e54,0x4911046c,0x28f801e0,0xf09f01f7}},	//   rdge, _देशो_, нець_, nuà_,
   {{0x38a92f21,0x673a0298,0x00000000,0x00000000}},	//   rúr_, _bytj, --, --,
   {{0x38a90037,0x3d1500a1,0xa91d0168,0x2001009e}},	//   súr_, _नेते_, _bežc, _mlhi_,
   {{0xa91d0b16,0x9b582701,0xb60600cb,0x660d01ba}},	//   _vežb, _чист_, ješć, ďako,
   {{0xc482005f,0xdb1c06d3,0xf1bf016f,0x65692f22}},	//   алык, _parç, deá_, rceh,
   {{0x75f5024e,0x00000000,0x00000000,0x00000000}},	//   _názv, --, --, --,
   {{0xf1dd0429,0xfbd20122,0x41dd0099,0x5694081b}},	//   यांन, בתי_, यांस, _бахт,
   {{0x2249142f,0x15151d13,0xbddb00e0,0x7a3800b5}},	//   _chak_, _идея, _dhèk, sítv,
   {{0x2d822f23,0xd9e30083,0x28c72450,0x22490118}},	//   _reke_, _মতাম, लिटि, _dhak_,
   {{0x35a70299,0x2d822f24,0x395f0159,0xe2990a7c}},	//   _गाड़, _seke_, _lgus_, _жак_,
   {{0x2d822f25,0x8e8300af,0xf77200a5,0x2be01e82}},	//   _peke_, игре, שקל_, नासा,
   {{0xc6920bed,0xf1bf004f,0x395f009e,0x00000000}},	//   יאל_, ceá_, _ngus_, --,
   {{0xb05b022a,0x25b201d6,0xd24f0c74,0x6c360a42}},	// [25c0] rvär, _öyle_, _بني_, نفرا,
   {{0x395f17e7,0xd00f0bdf,0x0e662f26,0xb05b2f27}},	//   _agus_, _ولي_, _икон, svär,
   {{0x76aa0095,0xbad500d8,0x2d820044,0x387f00e0}},	//   _təyi, ліцы, _teke_, _awur_,
   {{0x20182f28,0xb33c0484,0x60d62f29,0x75f500ac}},	//   liri_, ngħa, _krym, _zázv,
   {{0xf1aa1b8f,0x8b6603c7,0x18670610,0x25e00963}},	//   _कानन, _لازم, вачи_, कासी_,
   {{0xe9ff0028,0x20182f2a,0xf1e40084,0x6d462f2b}},	//   _phản_, niri_, गाड़_, _izka,
   {{0x1ae3036c,0xcac72f2c,0x2ca00c7c,0x86c311cf}},	//   _корм, _игре_, luid_, ليون,
   {{0x7c3e2f2d,0x20182f2e,0xbddb0107,0xdb1500ac}},	//   llpr, hiri_, _chèh, _jazý,
   {{0x20182f2f,0xb606042a,0x69d3024e,0x2ca02f30}},	//   kiri_, vešć, ádež, nuid_,
   {{0x25e0065a,0x20182eb8,0x9f5a01f7,0xe9ff0023}},	//   काही_, jiri_, _alpí_, _thản_,
   {{0x201819d3,0xd5a403fc,0x25bf2f31,0xdd2f0355}},	//   diri_, _ملای, beul_, měťo,
   {{0x7a382140,0xdb150187,0x2ca0007c,0x25bf00af}},	//   pítu, _nazý, kuid_, ceul_,
   {{0x20182f32,0x66022f33,0xb6060009,0x3eba2f34}},	//   firi_, _ilok, rešć, _appt_,
   {{0x20182f35,0xdb1703e6,0x3eba012f,0xc95300a5}},	//   giri_, nexã, _bppt_, ימר_,
   {{0x66022f36,0xbe88171d,0x6d4601d7,0xb6060124}},	//   _klok, ксте_, _azka, pešć,
   {{0x443e2f37,0x60d600da,0xe3b000b5,0xd35700a5}},	//   llt_, _frym, _خرچ_, _בשוק_,
   {{0x20182f38,0x60d62f39,0x2ca02f3a,0xf09f0036}},	// [25d0] biri_, _grym, guid_, quà_,
   {{0x629a0176,0x20182f3b,0x61fd000b,0x25bf00af}},	//   orto, ciri_, lksl, zeul_,
   {{0x443e2f3c,0x9999081b,0x497503fa,0x41aa00b4}},	//   ilt_, екет_, глес, _कामस,
   {{0x443e02c9,0x61fd2f3d,0x7c3e2f3e,0x32192f3f}},	//   hlt_, nksl, alpr, nisy_,
   {{0x69342f40,0xa91d2237,0x2be02f41,0x3f870132}},	//   анцу, _beža, नाशा, _ônus_,
   {{0x66022f42,0x7e65012f,0x16a90665,0x00000000}},	//   _alok, _kuhp, евки_, --,
   {{0x7a380332,0xe7360336,0x2be00683,0x25bf00af}},	//   gíts, леш_, नारा, teul_,
   {{0x20182f43,0xe51400be,0x15452f44,0x61fd0051}},	//   ziri_, _तेहि_, лейм, jksl,
   {{0x644a004f,0x629a2f45,0x20180b69,0xe45900af}},	//   _bhfi, erto, yiri_, нжи_,
   {{0x66020086,0x3fce0083,0xede0018d,0x249f00be}},	//   _elok, _রক্ষ, _पच्छ, ruum_,
   {{0x66022f46,0xa2d0035d,0x20182f47,0x7a38002a}},	//   _flok, धिष्, viri_, mítr,
   {{0x20181b68,0x443e2f48,0x00000000,0x00000000}},	//   wiri_, alt_, --, --,
   {{0x20182f49,0x25e004aa,0x657b2f4a,0x629a2f4b}},	//   tiri_, कारी_, mbuh, arto,
   {{0x5ebb0083,0x0492004f,0x443e011e,0x23292f4c}},	//   _উপজে, _الوح, clt_, _поли_,
   {{0x20182f4d,0x4427028b,0x657b011c,0x539a00a5}},	//   riri_, _ijn_, obuh, _טיסו,
   {{0x20182f4e,0x61fd2f4f,0x657b011e,0x2ca000ab}},	//   siri_, cksl, nbuh, tuid_,
   {{0x248d2f50,0xfce30cf9,0x271f2088,0x2be000b8}},	// [25e0] nsem_, бото, यपुर_, नाला,
   {{0x6d4600b8,0x207b0070,0xb05b033b,0x20180031}},	//   _vzka, _ראיא, nwäl, qiri_,
   {{0xdb1c01ef,0x23a600a1,0x657b067f,0x9eaa1b50}},	//   _harú, _खासद, kbuh, _явна_,
   {{0x533602b5,0x3f8a2f51,0x248d2f52,0x6e9b00a5}},	//   אנען_, labu_, ksem_, _אבטח,
   {{0x81ce0083,0xddc40035,0x248d00b8,0x443e2f53}},	//   রাপ_, rmiń, jsem_, ylt_,
   {{0x67d42f54,0xdb152f55,0x66022f56,0x57b3005f}},	//   року, _cazó, _slok, йбіт,
   {{0x66022f57,0x25e00af6,0x6e240553,0x443e08c8}},	//   _plok, काली_, onib, vlt_,
   {{0x7bce2f58,0x3f8a2f59,0x629a01ba,0x657b2487}},	//   _habu, habu_, vrto, gbuh,
   {{0xa91d068b,0x248d00b5,0x660212ba,0x7a382f5a}},	//   _teža, gsem_, _vlok, síts,
   {{0x443e2f5b,0x7bce0e46,0x78a21d13,0x4394052c}},	//   ult_, _jabu, muov, јанс,
   {{0x7bce2f5c,0x81ce0083,0x629a0d35,0x3f850093}},	//   _mabu, রান_, urto, ðlum_,
   {{0x7bce2f5d,0x25e000a1,0xdb1c0079,0x443e2f5e}},	//   _labu, काळी_, _barú, slt_,
   {{0x78a207e5,0x644a0160,0x491a021a,0xdb1c2f5f}},	//   nuov, _thfi, _मेमो_, _carú,
   {{0x7bce2f60,0xcbbf0033,0xbcfb0098,0x00000000}},	//   _nabu, _উচ্ছ, _ngéa, --,
   {{0x32190f86,0xa91d2f61,0xb7db0070,0x68f90067}},	//   pisy_, _nežn, עקלי, zywd,
   {{0x821500b5,0x7bce067f,0x05da0066,0x78a22f62}},	//   _خوبص, _aabu, _मोमब, kuov,
   {{0x3f8a0657,0x7bce2d06,0x69c22f63,0xbcfb2f64}},	// [25f0] babu_, _babu, deoe, _afér,
   {{0x5d542f65,0x26e40035,0xa91d01ba,0x6e24030d}},	//   скут, _कपूर_, _bežn, anib,
   {{0xdb150f56,0x7bce0228,0x5e470037,0xe7fa0a90}},	//   _razó, _dabu, _مضحك, ्सना_,
   {{0x65622f66,0x248d2f67,0xdb150138,0xd36600e0}},	//   _ngoh, ysem_, _sazó, _ژه_,
   {{0xa3d40066,0x22590355,0x00000000,0x00000000}},	//   हया_, írky_, --, --,
   {{0xb8cd00b1,0x96950d54,0xa695192f,0x248d008b}},	//   _कम_, ариш, ариј, vsem_,
   {{0x44270009,0x69c212ba,0x00000000,0x00000000}},	//   _rjn_, beoe, --, --,
   {{0x7bce2f68,0x6b870009,0x442700d7,0xf98800ff}},	//   _zabu, _hejg, _sjn_, _منفي_,
   {{0x81ce00c8,0xccf200c2,0xdb0501ae,0x7d0d002a}},	//   রাম_, ַכט_, gehö, nzas,
   {{0x3ea300da,0x798b2f60,0x248d2f69,0x6b87005f}},	//   kujt_, lagw, rsem_, _jejg,
   {{0x248d2f6a,0x23292632,0xfbcf0083,0xd6db2f6b}},	//   ssem_, тони_, রাপত, _ята_,
   {{0xdb0508f9,0xa06a2f6c,0xc1060037,0x7aea033b}},	//   behö, кама_, لوجي, äfti,
   {{0x3f8a2f6d,0x7d0d2f6e,0x00000000,0x00000000}},	//   tabu_, jzas, --, --,
   {{0x2bd5009a,0x661b00d8,0x8fa600c9,0x6609003c}},	//   _डोला, liuk, јаве, lhek,
   {{0x7bce028b,0x3f8a2f6f,0x539a00a5,0xa22500d1}},	//   _rabu, rabu_, _סיקו, _گروه,
   {{0x3f8a0054,0x75f50187,0x661b010b,0xa91d2f70}},	//   sabu_, _zázr, niuk, _režn,
   {{0xdca6135d,0xed5a00c9,0x7bce2f71,0x3b861a1c}},	// [2600] рази, тоа_, _pabu, илаг,
   {{0x7bce00d7,0x4f962f72,0x9b850c9e,0x64412f73}},	//   _qabu, _триу, مؤمن, nlli,
   {{0x64412f74,0xbf9b0100,0x661b2f75,0xa91d00ee}},	//   illi, _בייש, kiuk, _bežo,
   {{0x7bce2f76,0xe8fa2f77,0xdca6135b,0xbcfb006c}},	//   _wabu, кле_, _ками, _igén,
   {{0x7fe90164,0xe7e22f78,0x7d0d0035,0x660901cb}},	//   _شریف_, पालप, czas, dhek,
   {{0xa91d05e2,0x78a20009,0xdb17002a,0x481301e0}},	//   _težn, ruov, sexá, оміс,
   {{0x2cb2053e,0x29001b29,0xddc40029,0xe5c61353}},	//   ltyd_, šia_, rmiņ, аспо,
   {{0x88810332,0x64410086,0xa01b2f79,0xf64f2f7a}},	//   _کیون, elli, nsör, وئي_,
   {{0x07a61a90,0x75fc0107,0x64410345,0x186a01e0}},	//   _вазн, _jézi, flli, _рази_,
   {{0xf3662f7b,0xe9ff00e8,0x6908037a,0x6441011e}},	//   штин, _phần_, ırdı, glli,
   {{0x7bd902b5,0xa3c50067,0xdb1c008c,0x53342f7c}},	//   אַרק, उज़_, _carø, сент,
   {{0x9f58004f,0x64412f7d,0x66090054,0xd5b003c5}},	//   bhrú_, alli, chek, _رفت_,
   {{0x60020183,0x6a730069,0x00000000,0x00000000}},	//   _cômo, _iħfe, --, --,
   {{0xe9ff0028,0x54330118,0xfe731dbf,0x2005008a}},	//   _thần_, _ورور, قدر_, óli_,
   {{0x543902b5,0x798b2f7e,0x22940037,0x2cb20298}},	//   _געװא, yagw, _البس, etyd_,
   {{0x2cb203bc,0xb7fe0033,0x75fc000d,0xdcfd0160}},	//   ftyd_, ্চিত_, _bézi, _nesă,
   {{0x6b8701f4,0x7c8700c3,0x2cb20b88,0x00000000}},	// [2610] _pejg, рубе, gtyd_, --,
   {{0x60cd2f7f,0x81ce0083,0x3ea30031,0x798b0b13}},	//   _isam, রাণ_, pujt_, wagw,
   {{0xa91d0009,0xdce72f80,0xf09f0392,0x443c188e}},	//   _pežo, ılıd, lrà_, _mkv_,
   {{0xa2d70afa,0x00000000,0x00000000,0x00000000}},	//   यित्, --, --, --,
   {{0x4911004e,0x64412f81,0xe9ff01a5,0x98c72f82}},	//   _देखो_, ylli, _nhấn_, рсел,
   {{0x60cd0054,0x8d5a00a5,0x798b2f83,0x443c0345}},	//   _msam, _תכשי, sagw, _nkv_,
   {{0x66092f84,0xfeca0070,0x7bc52f85,0x661b24a5}},	//   thek, ָמפּ, mehu, tiuk,
   {{0xc4852f86,0x60cd0d5c,0x7bc52f87,0x5bc70e04}},	//   блик, _osam, lehu, _रघुव,
   {{0x999f0187,0xe9ff0019,0xf79500d8,0x661b010b}},	//   _chuť_, _chấn_, _газэ, riuk,
   {{0xf09f2f88,0x66092f89,0xf7700037,0x75f50b4c}},	//   drà_, shek, _قام_, _vázq,
   {{0xd7f818d9,0x60cd2f8a,0x7c220248,0xf09f0382}},	//   _тут_, _asam, éori, erà_,
   {{0x7bc501f4,0xf09f0176,0x64412f8b,0x00000000}},	//   hehu, frà_, slli, --,
   {{0x7e770069,0x798919c1,0x7bc52f8c,0xf09f0176}},	//   _atxp, _meew, kehu, grà_,
   {{0x4385004f,0x183502b5,0x7989030d,0x249f2f8d}},	//   _الثق, מאָל_, _leew, mrum_,
   {{0x60cd2f8e,0x7bc52f8f,0xf09f0310,0xd1380067}},	//   _esam, dehu, arà_, łą_,
   {{0x249f2f90,0x4d66137c,0x79890345,0x629c00ea}},	//   orum_, скав, _neew, šroc,
   {{0x61e42f91,0x1b150083,0x249f2f92,0xa01b01ff}},	// [2620] _inil, _তুলে_, nrum_, rsör,
   {{0x7bc52f93,0xf1bf004f,0x2cb2053e,0x61e400ac}},	//   gehu, nnán_, rtyd_, _hnil,
   {{0x34c40324,0x61e408dd,0x249f05f9,0x201a0159}},	//   _वन्द, _knil, hrum_, _impi_,
   {{0x61f61505,0x994a0037,0xc33200a5,0xf1bf2f94}},	//   _joyl, هلال_, הוב_, hnán_,
   {{0x2d802f95,0x98a31583,0x61f603d0,0x5e57016b}},	//   mbie_, зиче, _moyl, _ליטע_,
   {{0x249f2f96,0x2d802f97,0xdb1e2f98,0x2bb700b8}},	//   drum_, lbie_, lepí, _věcí_,
   {{0xfaa32449,0x05240083,0x66740df3,0x661900d5}},	//   _наро, _পরের_, زگار, _bmwk,
   {{0xe5c60086,0xe9ff0019,0x443c0093,0xe4a6021d}},	//   сско, _phấn_, _skv_, броо,
   {{0x8cdb19b7,0x32ee00a8,0x249f2f99,0xbcfb01cb}},	//   नियो, məyi_, grum_, _ngél,
   {{0x61e42f9a,0xf09f02fb,0x2ca02f9b,0x79892f9c}},	//   _anil, vrà_, irid_, _zeew,
   {{0x249f0176,0x61f62f9d,0x60cd2f9e,0x2d800345}},	//   arum_, _boyl, _ssam, kbie_,
   {{0x64a605d8,0xf09f2f9f,0x201a07e5,0x7bc50051}},	//   _гада, trà_, _ampi_, zehu,
   {{0x7bc5002f,0x3394010b,0x443c2fa0,0xf1aa1365}},	//   yehu, _далё, _tkv_, _कारन,
   {{0x3e6e000c,0xf09f01d3,0x2ca0012c,0x61e4001e}},	//   _být_, rrà_, drid_, _enil,
   {{0xa3d5000c,0x61f62fa1,0x7afe0055,0x32b70079}},	//   ाएर_, _foyl, jypt, _هدية_,
   {{0x60cd2fa2,0x5fad06fe,0xf09f298d,0x2ceb00c3}},	//   _tsam, ञ्जल, prà_, льзо_,
   {{0x60cd2fa3,0x00000000,0x00000000,0x00000000}},	// [2630] _usam, --, --, --,
   {{0xbddb1f10,0x79892fa4,0x7b672fa5,0x00000000}},	//   _chèr, _seew, стае, --,
   {{0x2ca00006,0x7bc52fa6,0x7afe0044,0xb9950105}},	//   arid_, rehu, gypt, قلاب,
   {{0x80cc0083,0x7bc50a8a,0xf1c91604,0xdb1c008d}},	//   ামর্, sehu, िजिन, _farþ,
   {{0x7bc52fa7,0x5fde00b4,0x75fc00b5,0xdcfd0409}},	//   pehu, माचल, _jézu, _besą,
   {{0x4cba0070,0xbddb00f7,0x798901a8,0x249f2fa8}},	//   _דזשו, _thès, _weew, vrum_,
   {{0x41aa2fa9,0x79890159,0x320900d0,0x05da0067}},	//   _कालस, _teew, _olay_, _मोहब,
   {{0xf1d90299,0xb05b01ae,0x32ee00a8,0xa91d0a4c}},	//   _बोलन, swäh, cəyi_, _ježk,
   {{0xdb1e002d,0x61f60282,0x2409081b,0xa3d529ad}},	//   cepâ, _royl, инии_, ाएल_,
   {{0x32092faa,0x249f2fab,0x61e42fac,0x61f60448}},	//   _alay_, rrum_, _snil, _soyl,
   {{0x81ce0083,0x320901f7,0xf1bf2fad,0x2d8017cc}},	//   রাস_, _blay_, rnán_, ybie_,
   {{0x2d8b2fae,0x249f028b,0xcad60122,0x201a0176}},	//   _nece_, prum_, קורת_, _smpi_,
   {{0xa06a2faf,0x05741026,0x628e00b5,0x00000000}},	//   рага_, _راند, ábor, --,
   {{0xee3f01ba,0x61f6012f,0x320905dd,0x3a2d0124}},	//   _aký_, _woyl, _elay_, _ljep_,
   {{0x32090107,0xa91d0168,0x82360312,0x61f62fb0}},	//   _flay_, _bežk, _وربا, _toyl,
   {{0x3d150ccf,0x2d8b2fb1,0x00000000,0x00000000}},	//   _नइखे_, _cece_, --, --,
   {{0x2d8b0274,0xbddb00f7,0xee371112,0x2d801116}},	// [2640] _dece_, _chèq, іну_, rbie_,
   {{0xeb9a0b3a,0x2ca02fb2,0x8b2600d8,0x41aa04aa}},	//   риж_, rrid_, одзе, _काँस,
   {{0x2d8b0382,0xf1bf00b5,0x7d1b003d,0x6ac6097f}},	//   _fece_, knál_, _žust, تقام,
   {{0xa3d5006a,0xfce62fb3,0x752f004e,0x2d8b2c7c}},	//   ाएँ_, _домо, żczy, _gece_,
   {{0x7afe00d5,0x00000000,0x00000000,0x00000000}},	//   sypt, --, --, --,
   {{0xec340609,0x2d8b002d,0xdb1e021d,0x00000000}},	//   _روزگ, _zece_, repâ, --,
   {{0x491a0632,0xdb1c01f4,0x02a81746,0x41aa0835}},	//   _मेरो_, _mbrë, _कमेन, _कांस,
   {{0x16370082,0x7ae10332,0xd5b72830,0xf1bf2fb4}},	//   يسية_, _álta, ось_, gnál_,
   {{0xa3d5006a,0x79822fb5,0x6fca00a1,0x69dd07a6}},	//   ाएं_, mbow, ाजां, _ósea,
   {{0x2240006c,0x78a20124,0x7c2e0124,0x25da00be}},	//   _akik_, mrov, _jjbr, _खोरी_,
   {{0x32092fb6,0xe73a01e0,0x2a64023c,0x00000000}},	//   _play_, _теж_, _kimb_, --,
   {{0x80ac0299,0x6010022a,0x78a215d8,0x00000000}},	//   _जमशे, _jämf, orov, --,
   {{0xd2580a93,0x2d8b2fb7,0xf9930d85,0x78a21321}},	//   юць_, _rece_, ורר_, nrov,
   {{0x32090159,0x600b00ab,0xb4d60a90,0x78a200c7}},	//   _wlay_, _sümb, ाटी_, irov,
   {{0x28d109b4,0x2d8b0393,0xed8b03fa,0x657900f7}},	//   _दैनि, _pece_, исак_, _éché,
   {{0xdb1c01ae,0x31352fb8,0x2a64008c,0x00000000}},	//   _darü, _нейр, _nimb_, --,
   {{0x2d8b2fb9,0x69c60093,0x3169006c,0x7c2b2fba}},	// [2650] _vece_, _ókey, _igaz_, égro,
   {{0x78a20e42,0x9f58008a,0x26de2fbb,0x3a3f01a0}},	//   drov, skrá_, _orto_, _skup_,
   {{0x81ce0083,0xa91d02c6,0x78a22fbc,0x2d8b0124}},	//   রার_, _težk, erov, _tece_,
   {{0x2a64028b,0x3f910254,0x78a22fbd,0xdb1c0138}},	//   _cimb_, lazu_, frov, _aaró,
   {{0x78a20097,0xdb1c2fbe,0xdb150279,0x26de2fbf}},	//   grov, _baró, _razõ, _arto_,
   {{0xf7711b31,0xa91d2fc0,0xa3da05dc,0xdb1c01dd}},	//   رات_, _ježi, _ढोल_, _caró,
   {{0x78a200ac,0xf4200033,0x26de02a7,0x1ab40b00}},	//   arov, নকার_, _crto_, _обря,
   {{0xa91d10a5,0xc4852fc1,0xdce40035,0x7bd52fc2}},	//   _leži, плик, ecię, _hazu,
   {{0x629c043f,0xdb1c18b5,0xf1bf2fc3,0x799b030d}},	//   áron, _abrè, rnál_, _iduw,
   {{0xa91d2fc4,0xe7b500b4,0xb68600b5,0x442e021d}},	//   _neži, _आउटप, _کھول_, _cjf_,
   {{0x7bd52fc5,0x3f9101a3,0xf7700372,0x386d0a8a}},	//   _mazu, dazu_, _شال_, _huer_,
   {{0xdb1c0035,0x06c30083,0xad9b1529,0x00000000}},	//   _zaró, ্মদি, _flúi, --,
   {{0xa91d03c9,0xad9b0037,0x386d02d7,0x442e023a}},	//   _beži, _glúi, _juer_, _fjf_,
   {{0x2ca9022e,0x386d01e9,0x316901ed,0xdb1c0260}},	//   duad_, _muer_, _egaz_, _marò,
   {{0x25ad00e9,0x6d4f0453,0xdee32695,0x78a200ee}},	//   ogel_, _azca, нори, zrov,
   {{0x386d0173,0x799b00bf,0x75fc0118,0xe9ff00e2}},	//   _ouer_, _nduw, _hézr, _thẹn_,
   {{0x7bd52fc6,0xed5703e6,0x602600af,0x00000000}},	// [2660] _bazu, зот_, _ндиа, --,
   {{0x7bd50012,0x91a800b5,0x3f910223,0x60c40371}},	//   _cazu, _انکے_, cazu_, _ipim,
   {{0xf1bf0187,0x7bd52fc7,0x00000000,0x00000000}},	//   znám_, _dazu, --, --,
   {{0xdb1c0392,0x25ad0009,0x386d2be5,0x38c802fd}},	//   _barò, jgel_, _buer_, قاتی_,
   {{0x2d922fc8,0x79820035,0xdb1c2fc9,0xdce40035}},	//   maye_, rbow, _paró, ycię,
   {{0x386d2fca,0x2d922fcb,0x25ad2fcc,0x799b0176}},	//   _duer_, laye_, egel_, _eduw,
   {{0xdb1c0300,0x386d033b,0x60020183,0x00000000}},	//   _varó, _euer_, _cômi, --,
   {{0x78a22fcd,0x25ad2fce,0x2d922fcf,0x386d033b}},	//   prov, ggel_, naye_, _fuer_,
   {{0x386d0176,0x7bd52fd0,0xb4d621fe,0x98a32fd1}},	//   _guer_, _yazu, ाटे_, _пите,
   {{0x2d920010,0x6d46028b,0xd776004f,0xdb1c259e}},	//   haye_, _myka, _رائع, _abré,
   {{0xa91d2fd2,0x600b01c2,0x2d922fd3,0x60c42fd4}},	//   _reži, _nüma, kaye_, _apim,
   {{0xb05b0110,0xe7e0073f,0xa91d02a7,0x00000000}},	//   hwät, _गोता_, _seži, --,
   {{0x2d922f59,0x463b0070,0x3f912fd5,0x92cc0033}},	//   daye_, _פעדע, tazu_, রমে_,
   {{0x545300d4,0xf48700e0,0x644f13dd,0x60100523}},	//   _звіт, _راهی, ïcit, _nämd,
   {{0x7bd51851,0x645a00fb,0x7c3e1384,0x69c001ba}},	//   _razu, mmti, dopr, _obme,
   {{0x443e2fd6,0x2d920232,0xfbd301cb,0x6d4603bc}},	//   lot_, gaye_, کتر_, _byka,
   {{0x423802da,0xa91d10ec,0x7bd52fd7,0x443e2583}},	// [2670] _מנהל_, _teži, _pazu, oot_,
   {{0x443e2fd8,0xf09202da,0x442c2fd9,0x69c0033b}},	//   not_, _שני_, nnd_, _abme,
   {{0x2d922fda,0x7bd50043,0x64480349,0x442c2fdb}},	//   baye_, _vazu, ildi, ind_,
   {{0xa2a400c0,0x7bd52f10,0x2d9201d5,0xdb1c2fdc}},	//   _किन्, _wazu, caye_, _parò,
   {{0x443e2fdd,0xddc40dac,0x89370082,0x386d0370}},	//   kot_, lmiş, أعضا, _quer_,
   {{0xd3660082,0x443e0080,0x7c3e2fde,0xf7450171}},	//   _له_, jot_, copr, мело,
   {{0x443e2fdf,0x6e2d2fe0,0xddc4008f,0x69dd07a6}},	//   dot_, onab, nmiş, _óseo,
   {{0x6e2d2fe1,0x442c2e12,0x644811cc,0x386d0a1a}},	//   nnab, end_, eldi, _tuer_,
   {{0x629802fb,0xdb1c0093,0x442c008a,0x69cb2fe2}},	//   _avvo, _harð, fnd_, mege,
   {{0x443e2fe3,0x69d92fe4,0x69cb16be,0x2d922206}},	//   got_, ldwe, lege, zaye_,
   {{0x81d70083,0xdb1c008a,0x2d92251e,0xd1ca1c36}},	//   সান_, _jarð, yaye_, олне_,
   {{0x69d90b19,0x644806a2,0x442c2fe5,0x645a0479}},	//   ndwe, aldi, and_, amti,
   {{0x20040370,0x6e2d001e,0x2fca009e,0x51550dd0}},	//   êmio_, dnab, tebg_, етру,
   {{0x443e2fe6,0x2d922fe7,0x81ce0083,0x6e2d0024}},	//   cot_, waye_, রাই_, enab,
   {{0x7f430086,0x2d922fe8,0x7c3e19be,0x69cb2fe9}},	//   верж, taye_, vopr, kege,
   {{0x6e2d2fea,0x76492feb,0xfce60009,0xd6cf03d0}},	//   gnab, nley, мобо, ттi_,
   {{0x7c3e2fec,0x2d922fe8,0x60c41982,0x69d900e5}},	// [2680] topr, raye_, _upim, ddwe,
   {{0x6d460187,0x2d922fed,0x7e6600d7,0x69d90345}},	//   _vyka, saye_, _wikp, edwe,
   {{0x600b007c,0x76492fee,0x62811b71,0x6d460035}},	//   _kümn, kley, nplo, _wyka,
   {{0x69cb2fef,0x6b8e06a2,0x443e2ff0,0x6d462ff1}},	//   gege, _webg, zot_, _tyka,
   {{0x443e2ff2,0x442c2cce,0x8d770088,0x2fc1028b}},	//   yot_, ynd_, _تاپا, _ybhg_,
   {{0x8cdb00b4,0x6e242ff3,0x656b027a,0x69d90298}},	//   निरो, liib, _aggh, adwe,
   {{0x443e2ff4,0xdb1c008a,0x69cb2ff5,0x6b6300d8}},	//   vot_, _garð, bege, _акра,
   {{0xd49a0de3,0xceb30122,0x442c2ff6,0x765b0159}},	//   оро_, דיה_, wnd_, gmuy,
   {{0x443e2ff7,0x7d040273,0x64a303e6,0x26c5018d}},	//   tot_, nyis, вања, _eplo_,
   {{0x442c2ff8,0x6e2d2ff9,0x656b2b28,0x9f5a0031}},	//   und_, znab, _eggh, _copë_,
   {{0x443e2ffa,0x442c2ffb,0xe57a01c8,0xa91d0293}},	//   rot_, rnd_, _дзе_, _dežu,
   {{0x443e2ffc,0x20ca02e4,0x7d040086,0x84ea186e}},	//   sot_, िबंध, kyis, _وفاق_,
   {{0x6e242ffd,0x92be0033,0xdb1e194e,0x62810298}},	//   diib, ঁটে_, lepä, aplo,
   {{0x764001ef,0x69cb2ffe,0xdb1e0279,0x443e0c6f}},	//   lomy, zege, cepç, qot_,
   {{0x15f20026,0x69cb2fff,0x81d70033,0x69d9016e}},	//   _आचार_, yege, সাব_, ydwe,
   {{0x76403000,0xddc40463,0xc3330122,0x6e24010d}},	//   nomy, rmiş, _שוק_, giib,
   {{0xd904042c,0x69cb3001,0xdc550166,0xe9ff055c}},	// [2690] _ئی_, vege, евањ, _chẽn_,
   {{0x69cb3002,0x6e2d3003,0x9f890093,0x764901fb}},	//   wege, snab, _góðu_, zley,
   {{0x69cb3004,0x76403005,0x7649027d,0x6e24030d}},	//   tege, komy, yley, biib,
   {{0xdb1c008a,0x7640004e,0xdddd0035,0x7d0404fb}},	//   _varð, jomy, _wisł, byis,
   {{0xf1c1018d,0x69d93006,0x9996006c,0x7d16004e}},	//   ष्यन, rdwe, رپور_, czys,
   {{0x78ab03c4,0x9f5a0260,0xd76300b5,0x3e75017b}},	//   rugv, _bopè_, نچای, _kåt_,
   {{0x76493007,0x69cb3008,0xcb440279,0x00000000}},	//   tley, pege, _ахти, --,
   {{0xb8d500c8,0x6ec20066,0x76402ed0,0xf1c1022e}},	//   _জন_, _लहसु, gomy, ष्मन,
   {{0x3e75022a,0x76493009,0xe7e0074f,0xf1bf0079}},	//   _låt_, rley, _गोवा_, dfá_,
   {{0x7649300a,0x62810b0d,0x37071c20,0x7c25300b}},	//   sley, tplo, _очев, nihr,
   {{0x7649300c,0x3e75013c,0xc7d600a5,0x0ece0067}},	//   pley, _nåt_, _רועי_, _हैंड,
   {{0x6281300d,0x7d160067,0xf676016b,0xdcef0228}},	//   rplo, yzys, _װײסט_, _cecī,
   {{0x05960580,0x644301ed,0xa3b718da,0x70ca01c0}},	//   _سانگ, _tkni, _छाप_, िबेल,
   {{0x25bf300e,0x3e75014e,0x6609177e,0x62810523}},	//   lful_, _båt_, lkek, pplo,
   {{0x6e240273,0x846402fb,0x00000000,0x00000000}},	//   tiib, _ръце, --, --,
   {{0x7d0403ad,0xee3a02ce,0x6441300f,0xa2a43010}},	//   tyis, їна_, loli, _कित्,
   {{0x4425148b,0xdca31c1b,0xbc6a0427,0x25bf07ee}},	// [26a0] oil_, лати, سمان_, iful_,
   {{0x7d16006a,0x44253011,0x6e243012,0xf1c1012f}},	//   rzys, nil_, siib, ष्ठन,
   {{0x34bd021a,0x387f3013,0xa3b704ef,0xad9b08bf}},	//   ्बुद, _atur_, _छान_, _clús,
   {{0x64413014,0x4425134c,0x7d0401d5,0xf99212de}},	//   holi, hil_, pyis, ابا_,
   {{0x64413015,0x25bf016e,0x4973010b,0x00000000}},	//   koli, dful_, уліс, --,
   {{0x44253016,0x64413017,0xf09300a5,0x00000000}},	//   jil_, joli, ננו_, --,
   {{0x64413018,0x0cd00437,0x76403019,0xa3b30722}},	//   doli, _हनुम, tomy, टलन_,
   {{0xdb1e00ab,0x4425301a,0xd90d00b5,0xcb67010b}},	//   repä, eil_, _ڈیم_, _часе_,
   {{0xddde0080,0xf8d407b5,0x20d60207,0xdb1e2119}},	//   _atpū, _धनिय, nžić_, sepä,
   {{0x4425301b,0x64410297,0x600b0463,0x7640018c}},	//   gil_, goli, _cüml, somy,
   {{0x53342f19,0xa3b601c0,0xdb1c301c,0x60d6301d}},	//   тент, ङ्ग_, _obrí, _asym,
   {{0x4425066a,0xad9b0176,0x6609301e,0x3e750a8a}},	//   ail_, _llúr, ckek, _råt_,
   {{0xc05b00d4,0xf1bf0079,0x2906301f,0x27fe3020}},	//   зів_, rfá_, nyoa_, _kotn_,
   {{0x44253021,0x64413022,0xdb1c0b06,0x20d60254}},	//   cil_, coli, _abrí, džić_,
   {{0x9f3403d0,0x80c40033,0xdd9500d8,0x00000000}},	//   гері, শিষ্, кавы, --,
   {{0xb05b0523,0xe7e70775,0x629a190f,0x931200fd}},	//   ktäg, _टोना_, msto, _لوڈش,
   {{0x629a3023,0x61ed3024,0xd2f8006c,0x301500d8}},	// [26b0] lsto, _inal, _رکھا_, _адпр,
   {{0x600b3025,0x629a02ee,0x00000000,0x00000000}},	//   _kümm, osto, --, --,
   {{0xd01100f5,0x61ed3026,0xe9d90035,0x7c253027}},	//   _ملک_, _knal, _paź_, rihr,
   {{0x64413028,0x629a3029,0xdbd7073c,0xe8090fbf}},	//   zoli, isto, _sääs, वस्थ_,
   {{0xdbd7087a,0x4425302a,0xfd960bed,0x6441302b}},	//   _pääs, yil_, _בדרך_, yoli,
   {{0x629a25e5,0x442501c2,0x2ca90523,0x25bf0f00}},	//   ksto, xil_, mrad_, wful_,
   {{0x629a0a78,0x4425302c,0xdb1c021d,0x66092933}},	//   jsto, vil_, _barõ, tkek,
   {{0x4425302d,0x2ca909c3,0x78a40254,0x6441302e}},	//   wil_, orad_, šiva, woli,
   {{0x629a016f,0x25bf1fc9,0xa3ac0099,0x00000000}},	//   esto, rful_, गलं_, --,
   {{0x69db0291,0x2b9c01c0,0x629a008a,0x64581d53}},	//   _haue, mácí_, fsto, _chvi,
   {{0x15b90409,0x2ca90187,0x6441302f,0x25bf0069}},	//   _жылы_, hrad_, roli, pful_,
   {{0x44253030,0x2ca93031,0x412a0d13,0x60d6008c}},	//   sil_, krad_, домо_, _psym,
   {{0x44253032,0x6606006c,0x69db033b,0x2fda0027}},	//   pil_, ökke, _maue, _papg_,
   {{0x7fd50804,0x69db3033,0x64a2031a,0x2ca93034}},	//   лісі, _laue, _таша, drad_,
   {{0xa0673035,0x629a3036,0x539a00a5,0x61ed0069}},	//   тара_, csto, _חיצו, _fnal,
   {{0x645801d2,0xf1bf3037,0x657b00d7,0x3ea506c9}},	//   _zhvi, lián_, ncuh, álta_,
   {{0x2ca90759,0x4cca0083,0xdd8f1062,0x3b960836}},	// [26c0] grad_, রিভু, زول_, вјет,
   {{0x61ed3038,0x62860c99,0x81ce0033,0xaf060369}},	//   _znal, ćkov, রাও_, _апол,
   {{0x69db01ae,0x00000000,0x00000000,0x00000000}},	//   _baue, --, --, --,
   {{0xa2a4020c,0x69db2ddc,0x2ca9007c,0xfaa300d8}},	//   _किस्, _caue, brad_, рацо,
   {{0x69db22dd,0xa96705f2,0xd7fa0395,0xe9ff055c}},	//   _daue, вица_, дуй_, _chằn_,
   {{0xbcfb0332,0x3f983039,0x629a303a,0xdb2100a0}},	//   _egés, naru_, ysto, štát,
   {{0x48ee006a,0x59dd303b,0x629a303c,0x5b3500af}},	//   _आपको_, _नोकर, xsto, _бэту,
   {{0x7bdc303d,0xe5c6303e,0x3f98303f,0x76593040}},	//   _haru, тско, haru_, _chwy,
   {{0x260300c8,0x3f9802d4,0x7bdc0a12,0x629a3041}},	//   _años_, karu_, _karu, wsto,
   {{0x7bde2069,0x629a3042,0x7bdc3043,0x61ed011c}},	//   ndpu, tsto, _jaru, _snal,
   {{0x7bdc3044,0x81dc00c8,0x629a3045,0xddcd00d5}},	//   _maru, ঠান_, usto, blaň,
   {{0x7bdc3046,0xa5263047,0x3f933048,0xe8df00e2}},	//   _laru, _имед, _sexu_, _uyển_,
   {{0x629a3049,0x3f98304a,0xf1bf304b,0x9f4600e2}},	//   ssto, faru_, bián_, _đoá_,
   {{0x629a0313,0xf1bf002a,0xb4be07b5,0xc953024b}},	//   psto, cián_, ँझी_, שמש_,
   {{0x5f94304c,0x81ce0083,0xc43400b5,0xbcfb0118}},	//   рист, রাজ_, _لکھت, _ngér,
   {{0x2ca9304d,0x7bdc304e,0x61ed304f,0xdda80043}},	//   trad_, _aaru, _unal, ктул_,
   {{0x68e23050,0x7bdc08a0,0xdb1c0176,0x5d5514a1}},	// [26d0] jvod, _baru, _abrà, укат,
   {{0x7bdc3051,0x600b0092,0x9b950b8d,0x69db3052}},	//   _caru, _mümk, الات, _saue,
   {{0xba740037,0xca7400ce,0x69db3053,0xb4ce073f}},	//   لانت, لانغ, _paue, शबु_,
   {{0xc3330052,0xb05b06d2,0x2ca901ba,0x601001ff}},	//   בוע_, städ, prad_, _jämn,
   {{0x80d93054,0x7bdc3055,0x7659001e,0x621c0070}},	//   मिटे, _faru, _rhwy, וואק,
   {{0x7bdc3056,0x6010022a,0x38bb0298,0xed58010b}},	//   _garu, _lämn, rêr_, _шоў_,
   {{0x8cdb00dc,0xaa673057,0xa2a4022e,0x7659016e}},	//   निको, _атак, _किष्, _phwy,
   {{0x7bdc1075,0x3f982577,0x6010013c,0xb4ce0084}},	//   _zaru, zaru_, _nämn, शबू_,
   {{0x7bdc3058,0x291901ff,0x245900a2,0xddde0160}},	//   _yaru, _åsa_, hème_, _lupş,
   {{0x6b950254,0xa2a40026,0x87d718dd,0x22490118}},	//   _jezg, _किश्, _جغرا, _akak_,
   {{0x3f983059,0xe7f01fb4,0xf1bf219d,0x6b95305a}},	//   varu_, चारा_, rián_, _mezg,
   {{0xa3e3065a,0x7999046a,0x3f98305b,0x6b950088}},	//   _पोर_, naww, waru_, _lezg,
   {{0x425500af,0x00000000,0x00000000,0x00000000}},	//   ртэт, --, --, --,
   {{0x6b952a9f,0x705607f6,0x2a6d033b,0x6002021d}},	//   _nezg, انسا, _lieb_, _cômp,
   {{0xdb1c114d,0x6da60439,0x3f98305c,0x04560037}},	//   _obrá, лива, raru_, _حلوة_,
   {{0x7bdc305d,0x3f98305e,0x2bc60035,0x22490118}},	//   _saru, saru_, र्ना, _gkak_,
   {{0x6b95305f,0x1bea021d,0x3f983060,0x629c0bca}},	// [26e0] _bezg, ндаи_, paru_, árov,
   {{0xb05b00c3,0xd0f700a5,0xdb1c3061,0x00000000}},	//   ttäe, _עמית_, _abrá, --,
   {{0x81d70083,0x2a6d035f,0x6b950395,0x09e61f62}},	//   সার_, _bieb_, _dezg, ложн,
   {{0x7bdc3062,0x02b60070,0xe94700b5,0xad9b00ee}},	//   _waru, טלעך_, گرمی, _ulúp,
   {{0x7bdc3063,0xa3b300a1,0x69c23064,0x00000000}},	//   _taru, टला_, rfoe, --,
   {{0xd6da0b46,0xa2a41451,0x68e20282,0x600b00a8}},	//   ети_, _किल्, rvod, _cümh,
   {{0x96f8027a,0x394d00a5,0xfd500023,0x2a6d021d}},	//   тейт_, _eyes_, _nghẹ, _fieb_,
   {{0xa5bd010b,0x00000000,0x00000000,0x00000000}},	//   liųj, --, --, --,
   {{0x27ef000c,0x62830009,0x75fc00fd,0x00000000}},	//   ální_, _atno, _kézz, --,
   {{0xd90d0088,0x1cbb0070,0x22490a8a,0x00000000}},	//   _تیه_, עמיע, _skak_, --,
   {{0x2bc60d91,0xa6862afc,0xfbc600b8,0xe9ff0019}},	//   र्या, _след, र्यम, _chặn_,
   {{0x54e61d05,0xa2d50066,0xf1bf0097,0xdb05033b}},	//   _مستق, _बनर्, ciál_, pfhö,
   {{0x75d31902,0xbf0d0de8,0x00000000,0x00000000}},	//   _دينا, सन्न_, --, --,
   {{0x2bc60266,0xddd015d7,0xfbc60ea3,0xc5bc0033}},	//   र्मा, _češk, र्मम, _অফটপ,
   {{0x6e950cd0,0x66023065,0xe1ff00b5,0x00000000}},	//   рибу, _kook, tmód_, --,
   {{0x66020006,0xfc240083,0x62881674,0x2459000d}},	//   _jook, বকোষ_, mpdo, rème_,
   {{0x82340609,0x2bc6175f,0x200100ab,0xfbab3066}},	// [26f0] _دروا, र्भा, _tohi_, етей_,
   {{0x66020052,0x6fb2004e,0x60cd11e9,0xbd68037c}},	//   _look, _जाएं, _ipam, урсе_,
   {{0xdddc00cb,0xf09f0176,0x00000000,0x00000000}},	//   sprš, lsà_, --, --,
   {{0x6602030d,0x2bc60d1f,0xfde905e7,0x394d3067}},	//   _nook, र्बा, _ऑफिस_, _pyes_,
   {{0x02d10355,0x0ff8006c,0x26cc02d7,0x6b953068}},	//   _तन्न, _شعیب_, _apdo_, _tezg,
   {{0x60cd3069,0x6010306a,0x80ad021a,0xd70503d0}},	//   _mpam, _näml, _जिने, изли,
   {{0x6602306b,0xe571004f,0xc9870812,0x00000000}},	//   _book, يطة_, _бузи, --,
   {{0x7aea01b4,0x6602306c,0x1b1e0033,0x7bc50223}},	//   æfte, _cook, _বুকে_, lfhu,
   {{0xf1bf0076,0x84590132,0x6602306d,0xc7d902fb}},	//   riál_, крот_, _dook, _имах_,
   {{0x291d08c7,0xe4c80079,0x00000000,0x00000000}},	//   mzwa_, ابين_, --, --,
   {{0xfbd20122,0x60cd01cb,0x85b90043,0x2d9b0031}},	//   חתי_, _apam, _алес_, kaqe_,
   {{0x016607b4,0xb34501f7,0x86220088,0x998f00c7}},	//   икно, _alçà, _وکيل, mogų_,
   {{0x291d306e,0xe0d701d3,0x2018099e,0x69c901a8}},	//   nzwa_, авя_, thri_, _mbee,
   {{0x249f306f,0x6e2600d7,0x66023070,0x68e90118}},	//   msum_, _smkb, _zook, _mred,
   {{0x44d60755,0x2d96019e,0x249f3071,0x66020103}},	//   _zł_, ирас, lsum_, _yook,
   {{0x0d863072,0x68e93073,0x249f00be,0x7e6f02d7}},	//   рлан, _ored, osum_, _cicp,
   {{0x249f3074,0x0c261a09,0xfce308d9,0x8fa60beb}},	// [2700] nsum_, аман, оото, _капе,
   {{0x69c90273,0x81d70033,0x60101b7a,0x515b00a5}},	//   _abee, সাঃ_, _kämm, _בכפו,
   {{0xdef901c8,0xf1eb0299,0xf778003c,0x69c9073a}},	//   _быў_, _जोड़_, _naħa_, _bbee,
   {{0x68e924ec,0x69c92cd7,0xb05b013c,0xda65004f}},	//   _bred, _cbee, ptäc, ماني,
   {{0x68e92e7b,0x60103075,0x3e7c0023,0x7e641c37}},	//   _cred, _lämm, _hít_, mmip,
   {{0xb8ce3076,0xb8fe0299,0x44270dc3,0x66023077}},	//   _कि_, _तन_, _nmn_, _sook,
   {{0x68e93078,0x7aa3034b,0xfaa33079,0x2bc604e9}},	//   _ered, _мирз, _маро, र्णा,
   {{0x68e92bf2,0x2d80307a,0x35f4307b,0x3e7c01c0}},	//   _fred, ncie_, спир, _mít_,
   {{0xfbc60355,0x68e9307c,0x2bc603de,0x3e7c307d}},	//   र्थम, _gred, र्था, _lít_,
   {{0x5fb2009a,0xe3b80ec4,0x4427307e,0x2a7800be}},	//   _जागल, lnız_, _cmn_, _kurb_,
   {{0x2d80307f,0x68e9076e,0x660200be,0x3e7c00e2}},	//   kcie_, _zred, _took, _nít_,
   {{0x2bc60567,0x2ca00006,0x2d80004e,0xfbc6112b}},	//   र्ता, ksid_, jcie_, र्तम,
   {{0x6010017b,0x442705be,0x25a63080,0x00000000}},	//   _täml, _fmn_, _idol_, --,
   {{0x2d80004e,0x24863081,0x3e7c0019,0x2ca000ab}},	//   ecie_, _itom_, _bít_, dsid_,
   {{0xf09f3082,0x442c3083,0x6d4f3084,0x00000000}},	//   ssà_, mid_, _syca, --,
   {{0x442c3085,0x518703c6,0xef190035,0x131700a5}},	//   lid_, _тука, ąż_, _כחול_,
   {{0x60cd3086,0x442c3087,0x7e6f0160,0x00000000}},	// [2710] _upam, oid_, _vicp, --,
   {{0x442c3088,0x7e7702d7,0x46a707b5,0x1fa708ce}},	//   nid_, _tuxp, _गिलह, _триг,
   {{0x68e90fd5,0x2bc60567,0x25a63089,0x7e6400e0}},	//   _sred, र्धा, _odol_, bmip,
   {{0x68e9308a,0x6448308b,0x442c308c,0x2d80027a}},	//   _pred, hodi, hid_, ccie_,
   {{0x442c308d,0x2ca0308e,0x2486006d,0xb9c4004f}},	//   kid_, csid_, _ntom_, تقني,
   {{0x6e2d308f,0x68e93090,0xe7393091,0x2bc60e61}},	//   liab, _vred, лел_, र्दा,
   {{0x442c3092,0x7d0d3093,0x2a783094,0x68e93095}},	//   did_, lyas, _gurb_, _wred,
   {{0x249f006d,0x68e91b2f,0xdb160037,0x6e2d3096}},	//   tsum_, _tred, _ócái, niab,
   {{0x68e902dd,0x7d0d3097,0x2d993098,0x442c3099}},	//   _ured, nyas, _mese_, fid_,
   {{0x64481bfc,0x249f309a,0x6e2d309b,0x2d99309c}},	//   godi, rsum_, hiab, _lese_,
   {{0x249f309d,0x8c1a0122,0x2d800035,0x7d0d309e}},	//   ssum_, רותי, ycie_, hyas,
   {{0x2d99309f,0x442c30a0,0x22162f19,0x249f0207}},	//   _nese_, aid_, сфор, psum_,
   {{0x442c30a1,0x442730a2,0xddc6011c,0x644830a3}},	//   bid_, _tmn_, _nikš, bodi,
   {{0x7d0d1d33,0x661b012f,0x644830a4,0xc8790225}},	//   dyas, lhuk, codi, _muş_,
   {{0x81bf00c8,0x2d9930a5,0xddc6010b,0x600b00a8}},	//   ীয়_, _bese_, _aikš, _nümu,
   {{0xf2d202b5,0x2ca0007c,0xdb170279,0x2d990300}},	//   _זעה_, tsid_, nexõ, _cese_,
   {{0x2d99043f,0x2d8030a6,0x7d0d006c,0x6e3600d8}},	// [2720] _dese_, rcie_, gyas, rnyb,
   {{0xe7e7007c,0x80ad0edf,0x2d800035,0x2ca00a47}},	//   _टोला_, _जिते, scie_, rsid_,
   {{0x2ca000ab,0x2d80042f,0x6e2d30a7,0x2d990031}},	//   ssid_, pcie_, biab, _fese_,
   {{0x6e2d30a8,0x442c30a9,0x753d0035,0x2d99053e}},	//   ciab, zid_, ższy, _gese_,
   {{0x28f830aa,0xdb1e006c,0x661b01cb,0x91bb00a5}},	//   рель_, lepü, dhuk, רמני,
   {{0xf09300a5,0xc87930ab,0x00000000,0x00000000}},	//   לנד_, _duş_, --, --,
   {{0x64480888,0x24860fdb,0x07a300ed,0x09e62f26}},	//   vodi, _stom_, чајн, _ловн,
   {{0x442c30ac,0xd5ba30ad,0x661b02b3,0xf1bf00b5}},	//   wid_, уск_, ghuk, riák_,
   {{0x442c30ae,0x38cb03c5,0xa3b30099,0x07a60009}},	//   tid_, _مالی_, टलं_, _газн,
   {{0x6e2d30af,0x3e41010b,0x248600ac,0x79820067}},	//   ziab, mėte_, _vtom_, lcow,
   {{0x644830b0,0x95ca00d4,0x78a20523,0x51f9093e}},	//   rodi, _була_, lsov, анню_,
   {{0x442c0ccf,0x26de30b1,0x661b0657,0xdb1e0035}},	//   sid_, _isto_, chuk, lepó,
   {{0x644830b2,0x2d990dc6,0x442c30b3,0x248601ff}},	//   podi, _rese_, pid_, _utom_,
   {{0x2d9930b4,0x442c2ea2,0x3f9a00e7,0x7d0d0883}},	//   _sese_, qid_, _cepu_, vyas,
   {{0x533330b5,0x2d9930b6,0xdef80bbc,0x59c8083f}},	//   _нешт, _pese_, быт_, रभार,
   {{0x7d0d30b7,0x31350812,0x443c0a8a,0x00000000}},	//   tyas, _мейр, _hjv_, --,
   {{0x2d9930b8,0x6e2d30b9,0x443c1505,0xdb9930ba}},	// [2730] _vese_, riab, _kjv_, ивач_,
   {{0x224b30bb,0x6e2d30bc,0x2d9930bd,0x7d0d30be}},	//   lock_, siab, _wese_, ryas,
   {{0x7d0d30bf,0x2d9930c0,0x6a730069,0x3ad50a42}},	//   syas, _tese_, _aħfr, تياز,
   {{0x224b0107,0x13e10033,0xddc600ea,0x78a20051}},	//   nock_, বায়, _tikš, fsov,
   {{0x26de01b7,0x6e3d30c1,0x7d0d00a8,0x2bc60efa}},	//   _asto_, _ijsb, qyas, र्हा,
   {{0x6d5d00ea,0x186930c2,0x00000000,0x00000000}},	//   _izsa, шали_, --, --,
   {{0x661b00d1,0xb05b0086,0x2a660221,0x6fac0026}},	//   thuk, ytän, bmob_, _जयसू,
   {{0xc48530c3,0x34a903fa,0x060930c4,0x7bd730c5}},	//   олик, авио_, рник_, lexu,
   {{0x2bc6164f,0x26de00c8,0xfbc60931,0xe3b10125}},	//   र्वा, _esto_, र्वम, ورد_,
   {{0x661b30c6,0x42c90a80,0x799b03bc,0x00000000}},	//   shuk, агон_, _heuw, --,
   {{0xd7f801a5,0x3f9a0478,0xb05b0086,0x290f30c7}},	//   _khăn_, _repu_, ttän, lyga_,
   {{0xb68600b5,0xd5dd0067,0x00000000,0x00000000}},	//   _بھول_, _मसिज, --, --,
   {{0x03a5027a,0xb05b30c8,0x00000000,0x00000000}},	//   _дило, rtän, --, --,
   {{0xb05b30c9,0x799b022e,0x248d0af9,0x6e3d0c6f}},	//   stän, _leuw, mpem_, _ajsb,
   {{0xdee330ca,0x7bd70139,0x248d0132,0x3f6a0ef3}},	//   мори, dexu, lpem_, риво_,
   {{0xe1ff1111,0x799b033b,0xd7f80023,0x78a400f4}},	//   lmón_, _neuw, _nhăn_, šivi,
   {{0xad6600bf,0x3f9a30cb,0xafe630cc,0x00000000}},	// [2740] زاره, _tepu_, _допл, --,
   {{0x6b561956,0x61e630cd,0xc1050594,0x78a20009}},	//   отех, ldkl, _روپي, vsov,
   {{0x61e4134c,0x2bc6143a,0xe6b800b4,0xfbc60355}},	//   _kail, र्षा, _इमेज, र्षम,
   {{0xd7f80019,0x3eb830ce,0x78a230cf,0xdcfd00c7}},	//   _chăn_, murt_, tsov, _nesė,
   {{0xe89417e0,0x2d92203d,0xc7ba00d8,0x6b9e0159}},	//   чаль, mbye_, аёй_, papg,
   {{0x76aa2b05,0xacd900c2,0x2cb20297,0xb0b20006}},	//   атив_, _פֿרי, mryd_, _जिनग,
   {{0x26de0036,0x7bce009f,0xa01b00c3,0x28da0067}},	//   _qsto_, _ibbu, mpöt, _मैरि,
   {{0x78ad01cc,0x6b9c30d0,0x2bc601c0,0x2bd80066}},	//   šava, _herg, र्रा, ड़वा,
   {{0x07a60390,0x6b9c007c,0xdb070107,0x7aee08b7}},	//   _маан, _kerg, _adjè, _hrbt,
   {{0x6b9c30d1,0x3eb800da,0x136a224a,0xdb1c0279}},	//   _jerg, kurt_, ишни_, _acré,
   {{0x61e430d2,0x26de0009,0x4b7b0070,0x04fa0033}},	//   _bail, _usto_, יטיג, ইনের_,
   {{0x61e430d3,0x201a1f26,0x6b9c0282,0x00000000}},	//   _cail, _alpi_, _lerg, --,
   {{0x61e430d4,0x660f00a6,0x6b9c00e5,0x7bce0103}},	//   _dail, öcke, _oerg, _obbu,
   {{0xcbd500c8,0x3eb830d5,0x6b9c30d6,0x224b055c}},	//   _হচ্ছ, furt_, _nerg, sock_,
   {{0xdd9b2264,0x61e430d7,0x93cb00b5,0x3ea500b5}},	//   иша_, _fail, _خانہ_, élt_,
   {{0x61e430d8,0x3ead086d,0x7bce0484,0x2cb200e9}},	//   _gail, čet_, _abbu, fryd_,
   {{0x2fd830d9,0x6b9c30da,0xc05b02ce,0x40352695}},	// [2750] berg_, _berg, _він_, _неис,
   {{0xa2a4018d,0x6b9c30db,0x61e406a2,0x69c00197}},	//   _किञ्, _cerg, _zail, _acme,
   {{0x6b9c30dc,0x0a6b30dd,0x23c20534,0xb05b00c3}},	//   _derg, арди_, _शानद, ntäm,
   {{0x69c00ea5,0x9f410097,0x2cb200e9,0x6b9c2069}},	//   _ccme, _nahé_, bryd_, _eerg,
   {{0x6b9c30de,0x6d5d2143,0xa2a100e7,0xd9450279}},	//   _ferg, _uzsa, _कौन्, џели,
   {{0x6b9c30df,0x3abb00bf,0xa69504bf,0x66e50009}},	//   _gerg, _پاسخ_, приј, зока,
   {{0x09c20083,0x4e0f0026,0x29020176,0x199530e0}},	//   োয়া, _सवाई_, _àkan_, _навя,
   {{0xd6ce004f,0x6b9c06a2,0x6b8500e9,0xbcfb00e0}},	//   اقي_, _zerg, lchg, _izéb,
   {{0x6d4301ae,0x69d930e1,0x61e430e2,0x6b9c0a21}},	//   ßnah, mewe, _rail, _yerg,
   {{0x69d930e3,0x942200c3,0x6b850523,0x61e403e9}},	//   lewe, емье, nchg, _sail,
   {{0x81e500c8,0xef20004e,0xc7c40d13,0xb05b013c}},	//   নান_, ążki_, _юсти, rtäl,
   {{0xb05b06d7,0x614603e6,0x628a02d7,0xcb12016b}},	//   stäl, зема, _dtfo, גלט_,
   {{0x61e430e4,0xf99200a5,0x61e630e5,0x26c7003d}},	//   _vail, ערך_, rdkl, ltno_,
   {{0xb4d70f39,0xdff5010b,0xa06a005f,0x00000000}},	//   ाबी_, мясь, сага_, --,
   {{0x63a130e6,0x61e430e7,0x26c702dd,0x69d930e8}},	//   maln, _tail, ntno_, kewe,
   {{0x261830e9,0x2cb2053e,0xbc760037,0x61e40719}},	//   _léon_, tryd_, كهرب, _uail,
   {{0x69d90a75,0x224000e0,0xee3701e0,0x721b00a5}},	// [2760] dewe, _ijik_, їну_, _לוקח,
   {{0x63a130ea,0x26c70496,0xdce60029,0x3eb80527}},	//   naln, ktno_, _iekļ, purt_,
   {{0x6b9c0a2e,0x9f9700a5,0xc9862aff,0x78b90051}},	//   _verg, _מדיה_, пули, euwv,
   {{0x69d90b3c,0xe8fa30eb,0x32090019,0x63a130ec}},	//   gewe, йле_, _xoay_, haln,
   {{0x63a10169,0x6b9c0f1a,0xc5c30083,0x41c106fe}},	//   kaln, _terg, ্যাপ, ष्टस,
   {{0x63a10bc6,0xfaa630ed,0x25a00a69,0x7e7e30ee}},	//   jaln, _наго, _žil_, _kupp,
   {{0x7c2e30ef,0x69d91a4f,0x8c1b0122,0xbb4300c3}},	//   _imbr, bewe, _פולי, _зерк,
   {{0x44f40f28,0xbb3b02b8,0xda100066,0xb4d71365}},	//   дпис, _העלי, _ावित_, ाबू_,
   {{0x63a130f0,0x1dce022e,0x81e50033,0xaa430036}},	//   faln, ह्यत, নাম_, _четл,
   {{0xb05b03ad,0x22810093,0x32090211,0x7e7e0523}},	//   ttäm, _bók_, _soay_, _oupp,
   {{0x316030f1,0xe1d902ce,0xae1c0066,0xd5af1309}},	//   _aziz_, одні_, नसान_, _пс_,
   {{0x63a100ab,0xb05b00c3,0x250b0416,0xa19412ea}},	//   aaln, rtäm, _گرمی_, наюч,
   {{0xd6250082,0xf1a4010b,0xb05b30f2,0x7c2e30f3}},	//   _تعلي, эрэн, stäm, _ombr,
   {{0x63a130f4,0x00000000,0x00000000,0x00000000}},	//   caln, --, --, --,
   {{0x442e30f5,0x628a30f6,0x69d930f7,0x998600d5}},	//   _imf_, _utfo, yewe, dnož_,
   {{0xc33300a5,0x2bcf022e,0x433b00a5,0x7e7e0b41}},	//   _רוק_, स्ना, _לעוב, _dupp,
   {{0x69d900ee,0x5d55027a,0xb4ca00ab,0xb05b30c8}},	// [2770] vewe, фкат, _ऊहो_, ntäk,
   {{0x69d930f8,0xf778007a,0x7e7e0b3e,0x6f030176}},	//   wewe, _daħk_, _fupp, _ànco,
   {{0x34d90311,0xd7f801a5,0x6b8501ae,0x442e30f9}},	//   _भन्द, _chăm_, rchg, _mmf_,
   {{0xf1bf30fa,0x63a130fb,0x7c2e30fc,0x6b85033b}},	//   ngá_, zaln, _embr, schg,
   {{0x7e7e07e5,0x37e5073e,0xed51026b,0x69d916a3}},	//   _zupp, долг, _شھر_, rewe,
   {{0x69d930fd,0xf7710118,0x78ad0506,0x00000000}},	//   sewe, پات_, šavo, --,
   {{0x63a1108a,0xb05b0086,0x69d90103,0x00000000}},	//   valn, ttäj, pewe, --,
   {{0x6010022a,0x26c7068b,0x63a10035,0x00000000}},	//   _hämt, rtno_, waln, --,
   {{0x26c702c6,0xf2b60033,0xb4d7046c,0x00000000}},	//   stno_, _জনগণ, ाबे_, --,
   {{0x52a930fe,0x6010013c,0xb05b00c3,0x7d020421}},	//   овом_, _jämt, stäj, äosi,
   {{0x63a130ff,0x2bcf0c67,0x387f02e6,0xfbcf3100}},	//   raln, स्या, _huur_, स्यम,
   {{0x63a13101,0x387f3102,0x7e7e3103,0x600b00be}},	//   saln, _kuur_, _rupp, _sümp,
   {{0x7e7e3104,0xe44e3105,0x63a13106,0xa5bd00d8}},	//   _supp, _аж_, paln, siųs,
   {{0x2281008a,0x2bcf0e68,0xa2d80f09,0x387f03c4}},	//   _tók_, स्मा, _फैक्, _muur_,
   {{0x41c60035,0x2240022e,0x00000000,0x00000000}},	//   _वापस, _tjik_, --, --,
   {{0x25bf3107,0x316001ed,0x00000000,0x00000000}},	//   ngul_, _tziz_, --, --,
   {{0xdca33108,0xed5700c9,0x387f002f,0x7e7e3109}},	// [2780] кати, дот_, _nuur_, _wupp,
   {{0x8d630086,0x7e7e310a,0xf1bf2fba,0xbcfb00b5}},	//   твуе, _tupp, biás_, _széc,
   {{0x78a90133,0x78ad264f,0x0e66310b,0x53cf0b35}},	//   _avev, šavl, _окон, त्यश,
   {{0x387f310c,0xd378011c,0x8b650427,0x81e50033}},	//   _buur_, meće_, رالم, নাথ_,
   {{0xd3780b16,0x02da08b6,0xb4d70387,0x00000000}},	//   leće_, _बन्न, ाबो_, --,
   {{0xd7f801a5,0x387f152b,0x368a01e0,0x6d46009f}},	//   _thăm_, _duur_, осин_, _ixka,
   {{0x6a8303e6,0x660b0b3e,0xd37800f4,0x7e66005f}},	//   _алса, _bogk, neće_, _khkp,
   {{0x973c03fd,0x25bf04f6,0xd5b000b5,0x3ced0124}},	//   _neće, ggul_, اہش_, _ševi_,
   {{0xe3ce0028,0x47c603fa,0x442e1606,0x7c3e310d}},	//   _dựng_, _обав, _pmf_, onpr,
   {{0x7863002d,0x7c3e1b04,0x25bf0395,0x00000000}},	//   _акуз, nnpr, agul_, --,
   {{0x0bb70052,0xd37803fd,0xe2f801e0,0x625d021d}},	//   ולים_, jeće_, чені_, béol,
   {{0xd3780a78,0x442e2955,0x00000000,0x00000000}},	//   deće_, _wmf_, --, --,
   {{0x442e310e,0x00000000,0x00000000,0x00000000}},	//   _tmf_, --, --, --,
   {{0x6562273b,0xdb1c310f,0x8ca20035,0x7c3e0223}},	//   _izoh, _acrí, गठनो, jnpr,
   {{0xe6dc007c,0x660b006d,0x7687027d,0x443e3110}},	//   _मनोज, _yogk, _kıya, mnt_,
   {{0x645a0297,0xf1d001a5,0x6010033b,0x80da0461}},	//   llti, _hạng_, _sämt, _पैके,
   {{0x443e01a6,0x2d58093c,0xf4bc0083,0x645a0051}},	// [2790] ont_, дить_, _অনুব, olti,
   {{0x443e3111,0x00000000,0x00000000,0x00000000}},	//   nnt_, --, --, --,
   {{0x443e3112,0xf1c60302,0xf1d00028,0x387f007c}},	//   int_, _वामन, _mạng_, _suur_,
   {{0x443e02c9,0xdb1c0037,0xf1d00019,0x321903bc}},	//   hnt_, _gcrí, _lạng_, nksy_,
   {{0x625d3113,0x7e6d3114,0xa3be1f57,0x00000000}},	//   véol, mmap, इला_, --,
   {{0xd3660833,0xb90727bd,0x81d30083,0x7e6d3115}},	//   _مه_, _बन_, _হোম_, lmap,
   {{0x7ac42695,0x2aa82705,0x65620371,0x443e3116}},	//   _исте, _отто_, _azoh, dnt_,
   {{0x443e3117,0xceb40100,0x645a0a8d,0x387f3118}},	//   ent_, דיק_, elti, _tuur_,
   {{0x2bcf052b,0xa95401e0,0x2ca90f3a,0x25bf3119}},	//   स्था, _акті, nsad_, rgul_,
   {{0x6932006c,0x443e1aee,0xd3780254,0x73050431}},	//   _حکمر, gnt_, zeće_, епоз,
   {{0xf1d001a5,0x656201b7,0x2d8b0207,0x973c0207}},	//   _dạng_, _ezoh, _ofce_, _peće,
   {{0x443e311a,0x2bcf111a,0xfbcf0bad,0x2ca9018d}},	//   ant_, स्ता, स्तम, ksad_,
   {{0xa1550133,0x973c0254,0xd378011c,0xa116183b}},	//   върш, _veće, veće_, روست,
   {{0xdb1c0082,0x201e2919,0xdee6081b,0x628407e7}},	//   _scrí, óti_, ноги, _čiov,
   {{0xd378011c,0x601001ff,0x00000000,0x00000000}},	//   teće_, _säms, --, --,
   {{0x2018311b,0x7e6d0430,0x00000000,0x00000000}},	//   skri_, gmap, --, --,
   {{0x15f20084,0xd3780254,0xfe43311c,0xc7a500b5}},	// [27a0] _अफसर_, reće_, унто, _پڑ_,
   {{0xaf9a0086,0x248200a0,0xd37800cd,0x25af037b}},	//   _этих_, íkmi_, seće_, _ldgl_,
   {{0x3f98311d,0x2bc625de,0xfbc60577,0xe8030f8a}},	//   mbru_, र्गा, र्गम, लाना_,
   {{0x644302c4,0x2d96311e,0xda650037,0x0f370070}},	//   _ljni, _ярос, ناني, _טריט_,
   {{0x443e311f,0x00000000,0x00000000,0x00000000}},	//   ynt_, --, --, --,
   {{0xb05b03ad,0x6e243120,0xf6e6002d,0x2bc60577}},	//   ttäi, lhib, ецин, र्खा,
   {{0x8c433121,0xd6d73122,0x765b0831,0x443e10db}},	//   _сере, еты_, fluy, vnt_,
   {{0xcfe90033,0xa3d23123,0xfaf700a5,0x443e3124}},	//   খায়_, ह्न_, _אצלי_, wnt_,
   {{0x290200da,0x7d040042,0x3219012f,0xd9431c89}},	//   _çka_, nxis, vksy_, _бети,
   {{0xe8d70122,0x443e3125,0x3d080461,0x69c20b0d}},	//   _אומר_, unt_, _सपने_, lgoe,
   {{0xa195021f,0x443e06c6,0xf1d000e2,0x00000000}},	//   канч, rnt_, _vạng_, --,
   {{0x765b0083,0x69c23126,0x2bc704e9,0x7bde3127}},	//   cluy, ngoe, _लाभा, hepu,
   {{0x6e24000e,0x7bde09dc,0xf1d00023,0x66060093}},	//   dhib, kepu, _tạng_, ökku,
   {{0xb05b0086,0x6010013c,0xe8031282,0xb8030534}},	//   htäv, _sämr, लाया_, लायम_,
   {{0x2cab3128,0x69c20298,0x00000000,0x00000000}},	//   _svcd_, kgoe, --, --,
   {{0x6e243129,0x09d50083,0x2ca9312a,0xddc4013b}},	//   ghib, _সোনা, tsad_, rliş,
   {{0xd9041144,0xe803000c,0x2ca90159,0xdb1c0067}},	// [27b0] _ای_, लामा_, usad_, _obró,
   {{0x7bde312b,0x7e6d312c,0x2d89002a,0x2bd80035}},	//   gepu, smap, scae_, ड़गा,
   {{0x2ca9312d,0xa3d21bb5,0x1eab0c74,0x6e240103}},	//   ssad_, ह्य_, _عادي_, bhib,
   {{0x6e24312e,0xdb1c01ef,0x6fcd0b35,0x3ced0207}},	//   chib, _abró, द्रू, _ševu_,
   {{0x6010312f,0x260400c0,0x9f5a0260,0x2bd8046c}},	//   _kämp, वानी_, _anpè_, ड़खा,
   {{0xec3500c2,0xa3d229ad,0x7bde0012,0x69c201a3}},	//   _יאָר_, ह्म_, cepu, agoe,
   {{0xf4c200c8,0x765b0225,0x00000000,0x00000000}},	//   ্টোব, tluy, --, --,
   {{0x60103130,0x64470bc6,0x00000000,0x00000000}},	//   _lämp, čjim, --, --,
   {{0xe1ff0035,0x5a4400af,0x68e20118,0x00000000}},	//   lmów_, _сэра, cwod, --,
   {{0xa93403e6,0x00000000,0x00000000,0x00000000}},	//   _сеуш, --, --, --,
   {{0x23292258,0x23c20b54,0xfbc60d34,0x2bc603de}},	//   фони_, _शारद, र्टम, र्टा,
   {{0x7aea01b4,0x65951fde,0x7bde0067,0x00000000}},	//   æfti, _раду, zepu, --,
   {{0xddc4030a,0xc2432dbe,0xbcfb00fd,0x00000000}},	//   jmiš, рняк, _szén, --,
   {{0x66091f39,0xd2b900fd,0x00000000,0x00000000}},	//   ljek, _قابض_, --, --,
   {{0x6e243131,0x601000a6,0x64410523,0x69d20e6f}},	//   thib, _dämp, mnli, ण्डी,
   {{0x63a33132,0x68e20297,0x7bd501ae,0x661b3133}},	//   _henn, ywod, _abzu, nkuk,
   {{0x644106ba,0x602601c8,0x62833134,0x63a33135}},	// [27c0] onli, _адпа, _huno, _kenn,
   {{0xd3780b16,0x62833136,0x64413137,0x00000000}},	//   leća_, _kuno, nnli, --,
   {{0x81e50b52,0x63a303d0,0xb05b03ad,0x26043138}},	//   নার_, _menn, ttäv, वामी_,
   {{0x63a33139,0x6283313a,0x644101ae,0x7bde09e7}},	//   _lenn, _muno, hnli, sepu,
   {{0xe3a7040d,0x69c2313b,0x6283010d,0x6609313c}},	//   _پر_, rgoe, _luno, djek,
   {{0x63a3313d,0x8d7700b5,0x64410a75,0xb05b0086}},	//   _nenn, _جاپا, jnli, stäv,
   {{0x29000012,0xc5eb0083,0x973c00cb,0x6283313e}},	//   ţia_, কানা_, _beća, _nuno,
   {{0xd3780470,0x6441313f,0x661b00a7,0xbb430009}},	//   jeća_, enli, gkuk, _теск,
   {{0x63a33140,0x62830159,0xd3780254,0x70dc00a1}},	//   _benn, _auno, deća_, यबोल,
   {{0x63a33141,0x62833142,0xe7c905e7,0x2bc600a9}},	//   _cenn, _buno, _रायप, र्चा,
   {{0x63a304ca,0x62830012,0xddc402f0,0x42751065}},	//   _denn, _cuno, zmiš, лгос,
   {{0x9f410097,0x27ec0f00,0x644104d5,0x00000000}},	//   _nahá_, _hadn_, anli, --,
   {{0x63a33143,0xc05b02ce,0xa3d40036,0xd7c900db}},	//   _fenn, дів_, _болч, _रामच,
   {{0x63a33144,0x44253145,0xe44f0647,0x00000000}},	//   _genn, chl_, _وضو_, --,
   {{0x63a83146,0x628300af,0x64580029,0x80d60033}},	//   madn, _guno, _ikvi, দিষ্,
   {{0x63a80252,0x33770122,0x78ad0254,0x2bc61856}},	//   ladn, _בתוך_, šavi, र्घा,
   {{0x63a30273,0x61ed08dd,0xa1340d4f,0x23cf06fe}},	// [27d0] _yenn, _iaal, _پريش, त्वद,
   {{0x61ed3147,0x63a80d5c,0xddc43148,0x06d90033}},	//   _haal, nadn, rmiš, থিতি,
   {{0x61ed3149,0xfe6e0e3a,0x00000000,0x00000000}},	//   _kaal, تگی_, --, --,
   {{0x61ed314a,0x63a8314b,0xc3330122,0xa3d922c7}},	//   _jaal, hadn, סוף_, _डॉन_,
   {{0x61ed2ed8,0x64582dd2,0x394900c9,0x6609029d}},	//   _maal, _okvi, ças_, vjek,
   {{0x973c03fa,0xa3d20907,0xab9400d4,0xd3780254}},	//   _seća, _हॉल_, _вирі, zeća_,
   {{0x63a3314c,0x973c042a,0x64411217,0x27fe00e2}},	//   _renn, _peća, vnli, _dntn_,
   {{0x2bcf0380,0x61ed314d,0x6283314e,0x3a2602a2}},	//   स्रा, _naal, _runo, chop_,
   {{0x7e7d314f,0x6283300c,0x69cc024e,0x661b3150}},	//   _misp, _suno, ílež, rkuk,
   {{0x62833151,0x7bc53152,0x66090a55,0x63a83153}},	//   _puno, nghu, sjek, gadn,
   {{0xc5d502ce,0x61ed0273,0x63a33154,0xbcfb006c}},	//   _біль, _baal, _venn, _szél,
   {{0x63a33155,0x7e7d3156,0x260400fa,0x62833157}},	//   _wenn, _nisp, वाणी_, _vuno,
   {{0x61ed0223,0x04c80037,0x63a33158,0xa24800b5}},	//   _daal, _لوني_, _tenn, ٹیکل_,
   {{0x62833159,0xf7780484,0x34b200d1,0xd37800cd}},	//   _tuno, _taħt_, _اموز, seća_,
   {{0x7e7d315a,0xb05b315b,0x6d5d0381,0x61ed027d}},	//   _bisp, kräf, _aysa, _faal,
   {{0xc6920c37,0x61ed315c,0xfce60798,0x69c9006f}},	//   מאל_, _gaal, лобо, _ncee,
   {{0xdd8f0c36,0x4d6600d8,0xad9b00d5,0xbcfb00e0}},	// [27e0] سول_, укав, _poúr, _nyéd,
   {{0x309b0bed,0x69c90043,0x6d5d0107,0xab2a315d}},	//   _רשימ, _acee, _dysa, ноза_,
   {{0x61ed001c,0x68e9315e,0xb05b1193,0x9f4100d5}},	//   _yaal, _ased, rtät, _tahá_,
   {{0xb05b02c9,0x63a8008b,0x290601d7,0x7e7d315f}},	//   stät, zadn, txoa_, _gisp,
   {{0x522d02b5,0x00000000,0x00000000,0x00000000}},	//   וואַ, --, --, --,
   {{0x68e90009,0xcaa60037,0xdd3b0070,0x2c05012f}},	//   _dsed, _مصري, _װעלכ, राणं_,
   {{0x63a83160,0xd5e200e2,0x3a263161,0x00000000}},	//   vadn, _phò, phop_, --,
   {{0xa281004e,0xe4e602ce,0xb05b3162,0x44b40036}},	//   łość_, гіон, ntär, абис,
   {{0x61ed0223,0x394603fa,0xd5e200cc,0x00000000}},	//   _raal, _снаг, _chó, --,
   {{0x61ed3163,0x250700b5,0x00000000,0x00000000}},	//   _saal, ارٹی_, --, --,
   {{0x63a83164,0x2604114e,0x61ed3165,0xb05b01ff}},	//   radn, वादी_, _paal, ktär,
   {{0x63a83166,0x64a63167,0xf8c808b0,0x387e02a7}},	//   sadn, _бада, _रमाय, _hitr_,
   {{0x63a80129,0x7e7d3168,0x61ed3169,0xb5fd02c4}},	//   padn, _risp, _vaal, rmšt,
   {{0x4394316a,0x61ed316b,0xf1bf0082,0x7e7d02e9}},	//   _такс, _waal, chán_, _sisp,
   {{0x61ed316c,0x5f94316d,0x3e41010b,0x248600c3}},	//   _taal, сист, lėti_, _huom_,
   {{0x92b3083a,0x6fd6316e,0x387e316f,0x6d5d00ee}},	//   _احوا, म्बू, _litr_, _pysa,
   {{0x7e7d0080,0x3e4100d8,0xc047042c,0x527c016b}},	// [27f0] _visp, nėti_, _مخدو, _אנהא,
   {{0x7e7d3170,0x25a6001e,0x6d5d053d,0x00000000}},	//   _wisp, _leol_, _vysa, --,
   {{0xb05b1535,0xe8030d00,0x78bc0029,0x7e7d035f}},	//   träf, लासा_, _ārva, _tisp,
   {{0x973c025c,0x3e4100d8,0x636f00b5,0x6d5d0051}},	//   _pećn, kėti_, lóné, _tysa,
   {{0x05260033,0x387e0523,0x00000000,0x00000000}},	//   মপুর_, _bitr_, --, --,
   {{0x3e4100d8,0x25a9008b,0x973c02c4,0xe73905a1}},	//   dėti_, _žal_, _većn, кел_,
   {{0x7ceb0523,0x00000000,0x00000000,0x00000000}},	//   _förå, --, --, --,
   {{0x25a6066a,0x9b581edd,0x22492181,0x24863171}},	//   _ceol_, _сист_, _njak_, _buom_,
   {{0x68e93172,0xf1bf0037,0xf7780024,0x00000000}},	//   _used, thán_, _daħq_, --,
   {{0x391400af,0x224908eb,0x8938002d,0x00000000}},	//   _умур, _ajak_, _спус_, --,
   {{0x2a6d3173,0x69cc000c,0x2a7f0a4e,0x63bc008a}},	//   _kheb_, _हामी, _kiub_, órna,
   {{0xd57517e0,0x323607e5,0x2001011e,0x3e41010b}},	//   _куль, рхос, _anhi_, bėti_,
   {{0x224901ed,0xddde0160,0x20130dfa,0x00000000}},	//   _djak_, _lupţ, _boxi_, --,
   {{0xa06a01c8,0xfaf800ea,0xe3b93174,0x00000000}},	//   тага_, _šīm_, _рбк_, --,
   {{0xdee63175,0x43750070,0x31693176,0x9ac70024}},	//   шови, _דײַן_, _ezaz_, _jiċħ,
   {{0x644f0248,0x224901f4,0x9ac7009f,0x3dd9016e}},	//   écif, _gjak_, _miċħ, _cbsw_,

   {{0xa2a10026,0xc0e60265,0x2bca005f,0xcd060210}},	// [2800] कीर्, _топк, клап_, шпай,
   {{0xb05b3177,0xd00f0037,0x00000000,0x00000000}},	//   stär, _يلي_, --, --,
   {{0x394d3178,0x395f067f,0xe6d407b5,0xf1d31371}},	//   _axes_, _ayus_, _दहेज, ध्वन,
   {{0xb05b0446,0x2efa0747,0x2a6d3179,0x5fd20761}},	//   träg, _irpf_, _cheb_, द्रल,
   {{0x260400dc,0x386c0097,0xd946002d,0x25a6317a}},	//   वासी_, _phdr_, шеди, _reol_,
   {{0x25a6004f,0xdca3049f,0x6843257f,0x98560043}},	//   _seol_, _фари, онча, штеш,
   {{0x973c0254,0x6f1c016e,0x03ee0033,0x00000000}},	//   _većo, nyrc, জামী_, --,
   {{0xb05b0f8e,0x6b6301e0,0x00000000,0x00000000}},	//   präg, _єкта, --, --,
   {{0x87da0148,0x6f1c00e9,0x386c063c,0x00000000}},	//   _لباس_, hyrc, _thdr_, --,
   {{0xbcfb006c,0x3e41010b,0x00000000,0x00000000}},	//   _szék, rėti_, --, --,
   {{0x2338021f,0xb6cb00b5,0x05ea00af,0x20130160}},	//   упны_, _لانے_, _афли_, _roxi_,
   {{0xd37700d8,0x25dd0907,0xd25800d4,0x00000000}},	//   шчы_, _कॉपी_, иця_, --,
   {{0x0494317b,0x66021852,0x625d00a2,0xfbc70387}},	//   _التح, _inok, déot, _लालम,
   {{0x04db025a,0x00000000,0x00000000,0x00000000}},	//   _סקול, --, --, --,
   {{0x6f1c0297,0xfda703fa,0x59d7317c,0x6602317d}},	//   gyrc, ијам, ण्डर, _knok,
   {{0x30a72365,0xdd98178e,0x9e040009,0xe37b011d}},	//   _кров, ишу_, очул, _ברור,
   {{0x25dd02e4,0xb05b013c,0xbcfb0118,0x6602023c}},	// [2810] _कॉफी_, träd, _syéb, _mnok,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x19b900af,0x6602317e,0xb05b0f8e,0x00000000}},	//   гуль_, _onok, rräd, --,
   {{0x2a6d0221,0x4975039e,0x9f430055,0x66020103}},	//   _qheb_, блес, hejë_, _nnok,
   {{0x26de21a4,0x8cf400d8,0xe80329ce,0x00000000}},	//   _apto_, _дзяц, लाला_, --,
   {{0x1d1600a5,0x6602317f,0x3dc9010d,0xb8ff051d}},	//   _הקשר_, _anok, lgaw_, _तह_,
   {{0x2a7f104e,0x7e6f008c,0x6dbb0067,0x00000000}},	//   _tiub_, _khcp, ałał, --,
   {{0xb8cd00c8,0x3dc90f3a,0x26de0453,0xf1c600b4}},	//   _কম_, ngaw_, _dpto_, _वाइन,
   {{0x81d60033,0xe4592503,0x629a01bf,0x00000000}},	//   _সফল_, лжи_, epto, --,
   {{0x9b4400f5,0x68fb0291,0x981401ca,0x66023180}},	//   _انہو, _irud, _وبلا, _enok,
   {{0x68fb0187,0xe7193181,0x00000000,0x00000000}},	//   _hrud, _حيات_, --, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x26040587,0x850500d1,0x291d3182,0x6f1c00e9}},	//   वारी_, _دوشن, nywa_, wyrc,
   {{0x3cfe0355,0xe3b80225,0x656b0069,0x33950037}},	//   _čtv_, lkın_, _izgh, _الغز,
   {{0xfbcd0033,0x22590051,0xd7f100e2,0x44270185}},	//   রজাত, bosk_, _mã_, _iln_,
   {{0x0d863183,0x44273184,0xe3b800a8,0xdcfd0457}},	//   слан, _hln_, nkın_, _adsı,
   {{0x61e63185,0x00000000,0x00000000,0x00000000}},	// [2820] mekl, --, --, --,
   {{0x69db0831,0x61e63186,0x44273187,0x3dc9010d}},	//   _abue, lekl, _jln_, agaw_,
   {{0x44273188,0xfc3f0955,0x25ad3189,0x68fb318a}},	//   _mln_, _avís_, kael_, _arud,
   {{0x68fb318b,0x61e60723,0x80cb00c8,0xb3460279}},	//   _brud, nekl, িবর্, leçõ,
   {{0x25ad001e,0xddcd2ceb,0x8d7608cf,0x656f00a0}},	//   dael_, llaş, _دادا, ýchl,
   {{0x5fdb0127,0x7e64318c,0x66022a5e,0x00000000}},	//   म्पल, llip, _snok, --,
   {{0xddcd0463,0x61e601d6,0x7e64318d,0x260413ab}},	//   nlaş, kekl, olip, वाली_,
   {{0x61e6318e,0x7e640dc3,0x291d0035,0x7afc02b1}},	//   jekl, nlip, bywa_, _irrt,
   {{0x2bcf009a,0x68fb318f,0x61e63190,0xa9263191}},	//   स्का, _grud, dekl, _удал,
   {{0xddcd01d6,0x7c3e1b39,0x60c600d7,0xe82400b5}},	//   klaş, nipr, dukm, _بذری,
   {{0x5c5b02b5,0x2bf700a5,0x7bdc3192,0x00000000}},	//   רדיק, זמין_, _mbru, --,
   {{0xad9b00c9,0xcb1300a5,0x7e64022f,0xc0cb0cc7}},	//   _anún, ללת_, jlip, луге_,
   {{0x661d00c3,0xdb070055,0x44270381,0x00000000}},	//   öske, _pejë, _fln_, --,
   {{0xa2c00af9,0x3dc90159,0x629a3193,0x973c0207}},	//   _विप्, wgaw_, ppto, _nećk,
   {{0x443e0f00,0x543b02b5,0x644f0248,0x643b02b5}},	//   mit_, _געגא, écie, _געגנ,
   {{0x645a0228,0x7bdc3194,0x61e63195,0x7e640dc3}},	//   loti, _abru, cekl, glip,
   {{0x973c02c4,0x7bdc009e,0x644800b9,0x68e400a8}},	// [2830] _bećk, _bbru, ondi, çidl,
   {{0x443e3196,0x645a3197,0x64483198,0x3dc90430}},	//   nit_, noti, nndi, sgaw_,
   {{0x64483199,0x207c0070,0xdb0501ef,0x973c0207}},	//   indi, _גאזא, pahí, _dećk,
   {{0x443e319a,0x7e64319b,0x1df90086,0xc1b7319c}},	//   hit_, clip, _темы_, _अयोग,
   {{0x443e319d,0x65620027,0x00000000,0x00000000}},	//   kit_, _nyoh, --, --,
   {{0x62980912,0x443e319e,0x63aa00fb,0x645a1669}},	//   _otvo, jit_, _nefn, joti,
   {{0xa3be0f39,0x645a319f,0x6562043d,0x628a00c7}},	//   ेलन_, doti, _ayoh, _nufo,
   {{0xe61903f5,0x68fb0fe2,0x6e2d31a0,0x644831a1}},	//   рди_, _trud, nhab, endi,
   {{0x4427035d,0x644831a2,0x645a0097,0x68fb31a3}},	//   _pln_, fndi, foti, _urud,
   {{0x443e31a4,0xddcd0723,0x63aa0297,0x2bcc00a1}},	//   git_, ylaş, _cefn, ालया,
   {{0x63aa02c7,0x27e731a5,0xdb1c004f,0x69cb31a6}},	//   _defn, menn_, _scrú, ogge,
   {{0x69cb1034,0x443e31a7,0x6448000e,0x60c622be}},	//   ngge, ait_, andi, tukm,
   {{0xe3ae31a8,0x61e631a9,0x6e2d31aa,0x21240079}},	//   _об_, rekl, dhab, ámh_,
   {{0x442c31ab,0x645a31ac,0x27e731ad,0x63aa31ae}},	//   chd_, coti, nenn_, _gefn,
   {{0x26c731af,0xa3d20141,0x61e631b0,0x764931b1}},	//   nuno_, _हॉट_, pekl, oney,
   {{0xddcd0644,0x22b50029,0x27e731b2,0x6e2d31b3}},	//   rlaş, māk_, henn_, ghab,
   {{0x7e6431b4,0x81d30083,0x22b50029,0x27e702e9}},	// [2840] rlip, _হোক_, lāk_, kenn_,
   {{0x27e731b5,0xddcd05f9,0x09b425de,0xebe300ca}},	//   jenn_, plaş, ुल्य, моуп,
   {{0x27e7021e,0x0aea0036,0x22b50029,0xd24f0416}},	//   denn_, рдей_, nāk_, _سنی_,
   {{0xe8fa28a4,0x443e31b6,0x6e2d31b7,0xddcd0043}},	//   иле_, zit_, chab, rmaţ,
   {{0x644831b8,0x645a31b9,0x443e31ba,0x3ead0a78}},	//   yndi, yoti, yit_, ćete_,
   {{0x7bdc31bb,0x27e731bc,0x645a31bd,0x76490298}},	//   _ubru, genn_, xoti, eney,
   {{0x443e31be,0x645a011c,0xdcf60463,0x26c731bf}},	//   vit_, voti, mayı, guno_,
   {{0xdcf60dac,0x443e31c0,0x62980223,0x22b50228}},	//   layı, wit_, _rtvo, dāk_,
   {{0x443e31c1,0x645a31c2,0x6298011c,0x27e70359}},	//   tit_, toti, _stvo, benn_,
   {{0x644831c3,0x186a0133,0x443e15f7,0x68ed31c4}},	//   undi, _тази_, uit_, çade,
   {{0x443e0b73,0x1bfb02b5,0x2bcf0d00,0x26c731c5}},	//   rit_, בליב, स्टा, cuno_,
   {{0x443e31c6,0x442c028b,0xd378011c,0xa2c00099}},	//   sit_, shd_, neći_, _विठ्,
   {{0x443e31c7,0xda7b0052,0x645a31c8,0x51840171}},	//   pit_, ינטר, poti, дура,
   {{0xddcd31c9,0xc05b01e0,0x764000d8,0x22b50029}},	//   dmaš, рім_, limy, bāk_,
   {{0x6e2d31ca,0x69cb31cb,0x973c0c99,0x539b0d85}},	//   thab, ygge, _beći, _דיוו,
   {{0x2bdd0ed1,0x27e70260,0xfbdd0ea3,0xd3780254}},	//   न्ना, zenn_, न्नम, jeći_,
   {{0xd37801cc,0x6e2d31cc,0xacf831cd,0x00000000}},	// [2850] deći_, rhab, онту_, --,
   {{0x1c050243,0x6e2d04f7,0x26c731ce,0xad9b0279}},	//   राइल_, shab, yuno_, _inúm,
   {{0x764931cf,0x764031d0,0xce59027f,0x27e7021e}},	//   yney, kimy, _ганц_, venn_,
   {{0x7c3c028b,0x26c7002f,0x682f008c,0x00000000}},	//   _emrr, vuno_, _kødg, --,
   {{0x27e731d1,0x8cc200dc,0x22b50029,0x22a7006c}},	//   tenn_, _लियो, zāk_, zők_,
   {{0xf8070a71,0x26c700e9,0x443c023a,0x00000000}},	//   ючен, tuno_, _nmv_, --,
   {{0x27e731d2,0x2a660cca,0xd378011c,0x26c70124}},	//   renn_, blob_, beći_, uuno_,
   {{0x060931d3,0x22b50228,0x7c250207,0x22a700b5}},	//   сник_, vāk_, lkhr, vők_,
   {{0x27e731d4,0xe4d6004f,0x26c70159,0x764931d5}},	//   penn_, كويت_, suno_, rney,
   {{0x26c70f3a,0x8707004f,0x22a7006c,0x22b500ea}},	//   puno_, _وبال, tők_, tāk_,
   {{0x2bdd0ceb,0xfbdd0517,0x1dcb00dc,0x625d000d}},	//   न्या, न्यम, िलात, téop,
   {{0x22b50ae0,0x2c6d1840,0x26f9004e,0x443c31d6}},	//   rāk_, _vždy_, ्मीर_, _emv_,
   {{0x443c0210,0x48fe0d4e,0x22b50228,0x22a700fd}},	//   _fmv_, लियो_, sāk_, sők_,
   {{0xd3780254,0x2bdd31d7,0xb4fa00a5,0x66190069}},	//   zeći_, न्मा, _לפני, _howk,
   {{0x644131d8,0x973c0254,0x0e6a0037,0x78a90103}},	//   mili, _peći, مصري_, _lwev,
   {{0xa2c00433,0xe1ff0f56,0xb2ba00a5,0x79891da1}},	//   _वित्, llón_, _המקר, _ngew,
   {{0x973c01cc,0x6c860180,0x6e2431d9,0xd3780254}},	// [2860] _veći, سلام, rkib, veći_,
   {{0x61f631da,0x6e2431db,0x79890103,0x764001b5}},	//   _hayl, skib, _agew, zimy,
   {{0xd3780470,0x61f631dc,0xdcf604d4,0x62970300}},	//   teći_, _kayl, rayı, _éxod,
   {{0x644131dd,0x98a030ec,0x00000000,0x00000000}},	//   hili, šič_, --, --,
   {{0x644131de,0x201a31df,0x61f631e0,0xd3780a78}},	//   kili, _kopi_, _mayl, reći_,
   {{0x442531e1,0x64410054,0xb05b01ae,0xd3780254}},	//   jkl_, jili, hrän, seći_,
   {{0x644131e2,0x4425028b,0xd3780506,0xa2c02218}},	//   dili, dkl_, peći_, _विध्,
   {{0xa3d90f3d,0x443c0a8a,0xf77200b5,0x61f61af2}},	//   ड्स_, _smv_, واں_, _nayl,
   {{0x76400d29,0x682f0a8c,0xbcfb13cf,0xb05b10c0}},	//   rimy, _bødd, _nyél, drän,
   {{0xa2c00d34,0x644131e3,0x3949002a,0x682f11cb}},	//   _विद्, gili, úase_, _rødg,
   {{0x61f6043d,0x644f02e1,0x46a3280a,0xe7b300b5}},	//   _bayl, écia, _захв, _سمند,
   {{0xb05b022a,0x7ae101ae,0xbba800b4,0x443c31e4}},	//   grän, _älte, गरुक, _wmv_,
   {{0xe1ff31e5,0x682f1b99,0x216731e6,0xa3d40183}},	//   blón_, _fødd, ятог, _жолч,
   {{0x6e3d0069,0x201a00e9,0xe1ff0138,0xbddb0118}},	//   _smsb, _copi_, clón_, _njèr,
   {{0x629c05d3,0x33db00a5,0xb05b1890,0x61f600a8}},	//   írod, _החוד, brän, _fayl,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x32090c86,0xbcfb0332,0xc1bc0122,0x91bc0122}},	// [2870] _inay_, _azér, _המחש, _המחי,
   {{0x201a016e,0xa3c500b4,0x682f08c8,0x320900e2}},	//   _gopi_, एलए_, _køde, _hnay_,
   {{0x998900b8,0x61f60448,0x3a2612ba,0x682f00d4}},	//   íkům_, _yayl, fkop_, _jøde,
   {{0x682f054e,0x3a260dc3,0x41bf0380,0xf1bf178c}},	//   _møde, gkop_, ्लिस, ्लिन,
   {{0xa3be31e7,0xbcfb006c,0xf8ae006c,0x64410644}},	//   ेला_, _ezér, لکل_, yili,
   {{0xd3780c99,0x66e52519,0x00000000,0x00000000}},	//   leću_, дока, --, --,
   {{0x3209027d,0xe81e020d,0x682f1f8b,0xf1bf1cce}},	//   _onay_, _बकरा_, _rødd, ्लान,
   {{0x644102c7,0xc7440082,0xdb0701c0,0x27e000f4}},	//   wili, عضوي, _její, đina_,
   {{0x3d00111e,0x280800b8,0xdb0721db,0x7bca31e8}},	//   रिये_, átní_, _mejí, ófug,
   {{0x61f600a8,0x32090c47,0xe7b50e3a,0xdb071c5b}},	//   _sayl, _anay_, _آماد, _lejí,
   {{0x644131e9,0x61f61a68,0xb05b15e5,0x1b1f00c8}},	//   rili, _payl, trän, _যেতে_,
   {{0x2bdd0e96,0xfbdd0355,0xd3780c0a,0xdb0e03e6}},	//   न्ता, न्तम, jeću_, _bebê,
   {{0x64411fd9,0xd3780254,0x2c740282,0xb05b31ea}},	//   pili, deću_, läde_, rrän,
   {{0x682f2b6f,0x23290dde,0xdee600c3,0x2d99008c}},	//   _føde, _моли_, моги, _afse_,
   {{0xa06731eb,0x61f631ec,0xfbcc06fe,0x682f0a8a}},	//   фара_, _tayl, ालसम, _gøde,
   {{0x7bc30093,0x00000000,0x00000000,0x00000000}},	//   ónun, --, --, --,
   {{0x201a31ed,0xac8631ee,0x2ca0008c,0x22400178}},	// [2880] _topi_, дгал, upid_, _imik_,
   {{0x25dd0930,0x3a2d00f6,0x00000000,0x00000000}},	//   क्ती_, _alep_, --, --,
   {{0x2bdd01c0,0x248702d0,0x63bc0cb2,0xfbdd00b8}},	//   न्धा, _minm_, órni, न्धम,
   {{0xa2c00e6f,0xfaf80029,0x1d0a0183,0x25af008c}},	//   _विस्, _šīs_, _деми_, _negl_,
   {{0x249d006d,0x3a2631ef,0x08970037,0x2bc7073f}},	//   _ntwm_, rkop_, وضوع_, _लाचा,
   {{0x2bdd0ca4,0x0ee2210a,0xfbdd0af6,0x68ed0279}},	//   न्दा, _पहाड, न्दम, çada,
   {{0xdb83049f,0x3a2631f0,0x00000000,0x00000000}},	//   _агри, pkop_, --, --,
   {{0x26c031f1,0x2487003b,0x44f4316d,0xe5c60145}},	//   čio_, _ainm_, епис, фско,
   {{0x25af0036,0x83fc00cd,0x05bf0380,0x682f0a8c}},	//   _degl_, hođe, _एयरब, _dødb,
   {{0x83fc029d,0xd378011c,0xa2b20761,0x224000fd}},	//   kođe, zeću_, _आबद्, _amik_,
   {{0xd6cf0071,0x78a20124,0x972600d1,0x00000000}},	//   _نقل_, lpov, _تفاو, --,
   {{0xc7b80a78,0x64a600d8,0x78a20051,0x7afa0093}},	//   _dođe_, _жада, opov, _áttu,
   {{0xd37800cd,0x7c2e31f2,0x2a640168,0x00000000}},	//   veću_, _olbr, _mkmb_, --,
   {{0x656f01ae,0x00000000,0x00000000,0x00000000}},	//   üche, --, --, --,
   {{0x5f9408ae,0x83fc0254,0x442e09c5,0x2d8b0284}},	//   тист, gođe, _ilf_, _pgce_,
   {{0x41e71112,0x3209011e,0xddc40067,0x00000000}},	//   _ціка, _unay_, enił, --,
   {{0x5c750086,0x6fd70026,0x7bde033b,0x78a21321}},	// [2890] елат, _बापू, ffpu, jpov,
   {{0x83fc0f44,0x78a20076,0x9f4c024e,0x3a2d03c9}},	//   bođe, dpov, ždá_, _slep_,
   {{0xb5fd31f3,0x00000000,0x00000000,0x00000000}},	//   loše, --, --, --,
   {{0xdb1c31f4,0xd37b0070,0x2cc40448,0x8c490225}},	//   _acró, קראט, ürdü_, _başö,
   {{0x5d851062,0xb5fd1851,0x442e013a,0x9f430176}},	//   _سلسل, noše, _olf_, lejà_,
   {{0x442e00d7,0x25af0f0a,0x2c050035,0x59d100b4}},	//   _nlf_, _segl_, राओं_, _हावर,
   {{0xa2c0112b,0x7b640328,0xa3d900b4,0x00000000}},	//   _विष्, _атте, _डॉग_, --,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xdb1c02e9,0x2240028b,0x26040ca1,0xb5fd0009}},	//   _adrè, _rmik_, वाजी_, joše,
   {{0xa2c0017f,0xb5fd0169,0x7af50035,0xdb0e31f5}},	//   _विश्, doše, _kszt, _bebè,
   {{0x442e0a8a,0x31690457,0x25af0a8a,0x00000000}},	//   _dlf_, _ayaz_, _tegl_, --,
   {{0x34951b5d,0x83fc0a78,0xc7b80254,0xe60e005f}},	//   _задр, vođe, _vođe_, _ёд_,
   {{0x660b1c04,0x659403fa,0xb5fd055f,0x2bff046c}},	//   _ingk, _рачу, goše, ईयां_,
   {{0x26c702fb,0x7af5006c,0x95cc0095,0x05740416}},	//   orno_, _oszt, _çərç, _شاند,
   {{0xdee30af5,0xbcfb006c,0x260400a1,0xe29a0019}},	//   лори, _szép, वाची_, _trưa_,
   {{0x2612112b,0xe7df0026,0x9f5831f6,0x83fc0254}},	//   थायी_, प्तप, ndré_, rođe,
   {{0x61e40291,0x7af500b5,0xed5731f7,0xe80201c0}},	// [28a0] _ibil, _aszt, еот_, लयमा_,
   {{0x799b030d,0x3ec50448,0xa7fc0225,0x4d6331f8}},	//   _afuw, üstü_, _akın, укув,
   {{0x4fd70779,0x7fd700c2,0xe7c900c4,0x660b31f9}},	//   _אויב_, _אויס_, _राजप, _ongk,
   {{0x78a20124,0x660b0118,0x00000000,0x00000000}},	//   tpov, _nngk, --, --,
   {{0x61e40657,0x2bdd31fa,0x7af5006c,0x67d431fb}},	//   _mbil, न्हा, _eszt, волу,
   {{0x660b253e,0xb05b081b,0x25dd0d00,0x7c2e31fc}},	//   _angk, yräm, क्सी_, _ulbr,
   {{0x78a20bec,0x61e40ce9,0x799b0103,0xad9b008d}},	//   spov, _obil, _ffuw, _snúi,
   {{0xdb0e31fd,0x00000000,0x00000000,0x00000000}},	//   _odbú, --, --, --,
   {{0x2bdd021a,0x973c0009,0x54540dee,0x69c00176}},	//   न्वा, _pećs, квит, _idme,
   {{0xccf30122,0x660b072e,0x26c7210c,0x88bb00a5}},	//   רכז_, _engk, brno_, _מזמי,
   {{0x6fd71782,0xdb0e0152,0x07a303d0,0x61e40069}},	//   _बाबू, _bebé, _сахн, _bbil,
   {{0x5ab70779,0x7e660159,0xb5fd00f4,0x2904023a}},	//   עלכע_, _nkkp, toše, _krma_,
   {{0x442e0022,0x64a331fe,0xdb0e0300,0x00000000}},	//   _tlf_, _бача, _debé, --,
   {{0xb5fd04c3,0xdb07006c,0x442e0533,0x61e431ff}},	//   roše, _lejá, _ulf_, _ebil,
   {{0xc0ab0df3,0xa3d90e04,0x69c01b89,0x2baf0433}},	//   _کابل_, _डॉट_, _odme, टरसा,
   {{0xdb0e00e0,0x00000000,0x00000000,0x00000000}},	//   _gebé, --, --, --,
   {{0x8bc711d0,0xf1bf3200,0x61ef0a21,0x6d4000f4}},	// [28b0] есед, nkám_, mecl, _žmar,
   {{0x69c03201,0x61e43202,0x61fd02ce,0x00000000}},	//   _adme, _zbil, ldsl, --,
   {{0x8f35231f,0xb5fd00f4,0xdb0700fd,0x00000000}},	//   _ренц, nošc, _bejá, --,
   {{0x61fd1ba9,0xf99000e0,0x68ed3203,0x61ef3204}},	//   ndsl, مبه_, çado, necl,
   {{0xd36601ca,0x7e6d3205,0xdb0700de,0xdb050079}},	//   _چه_, mlap, _dejá, ibhé,
   {{0xd36600bf,0x7e6d3206,0xfc3f008e,0x76420159}},	//   _نه_, llap, _stíf_, _amoy,
   {{0x8f9c02b5,0x644f00a2,0x316c0067,0x00000000}},	//   ליגי, écim, ędzi_, --,
   {{0x24993207,0x7e6d006c,0x59d80fd1,0xda0900e0}},	//   ísmo_, nlap, _डायर, _تيره_,
   {{0x25dd0567,0xe89500d8,0x9f4a0443,0x78bb002f}},	//   क्षी_, _разь, rebé_, _uvuv,
   {{0x7e6d3208,0x61e4027a,0x00000000,0x00000000}},	//   hlap, _sbil, --, --,
   {{0x13a70987,0x6fdf0026,0xe6c70c74,0x26dc0237}},	//   ونکی_, _पॉइं, _ستاي, ctvo_,
   {{0x660b20fb,0x61ef0088,0x60dd3209,0xa6960319}},	//   _ungk, gecl, ftsm, _סכנה_,
   {{0x463a00c2,0x7e6d00ea,0x54e50066,0x85b80647}},	//   _קענע, dlap, _कहिए_, _سانس_,
   {{0x25dd0567,0x6a781c02,0x160900c4,0xb5fd02c4}},	//   क्री_, mífe, वाकर_, bošc,
   {{0x60dd320a,0x998f00d8,0x61e4320b,0x1f591a24}},	//   atsm, nigų_, _tbil, ешть_,
   {{0x61e40bc6,0xe8d10084,0x7e6d0cca,0xc6920070}},	//   _ubil, _समूच, glap, שאן_,
   {{0x0d862857,0x6a78002a,0x3e5a0355,0x00000000}},	// [28c0] тлан, nífe, jďte_, --,
   {{0xe0b7168d,0x9f5a01f4,0xbbcc01c0,0xfce3136c}},	//   _שליט_, _japë_, ालेक, рофо,
   {{0xe9da00c3,0x3daa00c3,0x3ea60009,0xcb0a0698}},	//   дке_, _окно_, _шинг, بيان_,
   {{0x98a6320c,0x831a02b5,0x60c90c99,0x01b00033}},	//   виде, וועז, šeme, _কাঁদ,
   {{0x83fc0009,0x00000000,0x00000000,0x00000000}},	//   hođa, --, --, --,
   {{0x6b9c0132,0x00000000,0x00000000,0x00000000}},	//   _ufrg, --, --, --,
   {{0x8c4305c2,0xddcd002d,0xcf9300a5,0x27ee00e9}},	//   _тере, noaş, סטה_, refn_,
   {{0xd49a0009,0xceb3011d,0x656b0b3e,0x35f41199}},	//   мро_, ביה_, _bygh, упир,
   {{0x26dc0888,0x29040043,0x61ef0526,0xd9100416}},	//   stvo_, _urma_, vecl, _دیش_,
   {{0xa84a0493,0x1e1f2218,0xf1bf1534,0x00000000}},	//   _غلام_, _यक्ष_, rkám_, --,
   {{0x0bb70d85,0x83fc011c,0x1db20325,0x7d060345}},	//   כלים_, gođa, जरात, _lrks,
   {{0x61bf021a,0x27e90254,0x6443320d,0xe5a6002d}},	//   ्लेष, đane_, _emni, _риди,
   {{0x61fd320e,0x6a7801ef,0x041e0033,0xdb050079}},	//   rdsl, cífe, যোগী_, rbhé,
   {{0xdb050093,0x61ef00f6,0x60dd0147,0xa4b700a5}},	//   rahú, secl, rtsm, _ילדה_,
   {{0x7e6d320f,0xb5fd3210,0xf1bf00b5,0x69d33211}},	//   tlap, loša, nkák_, _डाली,
   {{0x64483212,0x2d8f01b4,0x64430035,0xfda40274}},	//   lidi, øge_, _zmni, ијум,
   {{0x23b60299,0x3d0d004e,0xb5fd0029,0xd7d20722}},	// [28d0] _आजाद, समें_, noša, _सांच,
   {{0x7e6d01c8,0x64483213,0x00000000,0x00000000}},	//   slap, nidi, --, --,
   {{0x68e93214,0xe0df027a,0xeab00118,0x7e6d3215}},	//   _sped, ltò_, قعن_, plap,
   {{0x64483216,0xe1ff3217,0x6e36024e,0x628d0069}},	//   hidi, ndó_, chyb, _jiao,
   {{0x6e2d3218,0xe0df1fc7,0x89a800d4,0xd7e902ee}},	//   mkab, ntò_, тків_, емле_,
   {{0x628d3219,0xb5fd0029,0x64480107,0x656b23f4}},	//   _liao, doša, jidi, _rygh,
   {{0x6448321a,0x80d3021a,0x366902e0,0x81cb0083}},	//   didi, भूते, нако_, র্য_,
   {{0xc7b80f44,0x83fc0a78,0x6e2d321b,0x6a781e97}},	//   _vođa_, vođa, nkab, tífe,
   {{0x6448321c,0x629c0391,0x9f4300c3,0x6e2d1855}},	//   fidi, íron, lejä_, ikab,
   {{0x6448321d,0xe576004b,0x628d009e,0x81cb0033}},	//   gidi, ызы_, _aiao, র্ম_,
   {{0x23290036,0x6e2d321e,0x05130033,0x7e6408c7}},	//   хони_, kkab, িনের_, yoip,
   {{0xd7df04bc,0x628d321f,0x82360df3,0xe7df09b4}},	//   प्रच, _ciao, اردا, प्रप,
   {{0x64483220,0x656b2b66,0x7d090254,0x6e2d0523}},	//   bidi, _uygh, _šesn, dkab,
   {{0xddc401c0,0x9f430086,0xad9b01ef,0x661b3221}},	//   dliš, kejä_, _laúd, ljuk,
   {{0xd5b7045c,0x7529006c,0x3ebe008a,0xd00700af}},	//   _इजाज, lyez, étt_, ыере_,
   {{0x661b0f1a,0x81cb0083,0x6e2d1c3f,0x628d3222}},	//   njuk, র্ব_, gkab, _giao,
   {{0x75293223,0x753b3224,0xddc41001,0x2fba0012}},	// [28e0] nyez, nzuz, gliš, _пынэ_,
   {{0x6e2d08c3,0xbc6a0c36,0x661b00ab,0x1c0e0354}},	//   akab, رمان_, hjuk, साइल_,
   {{0x6e460192,0x49ca144b,0x6e2d3225,0x7e64034d}},	//   _бенз, елен_, bkab, poip,
   {{0x64483226,0xb05b01ff,0xddc403c9,0x661b01a8}},	//   zidi, tsäg, bliš, jjuk,
   {{0x28f80b7d,0xad9b016f,0x627c0035,0x3c2400a8}},	//   тель_, _vnút, _głoś, _dövr_,
   {{0x7d043227,0xb8dc007c,0xb5fd0029,0xdb0e00fe}},	//   mvis, _आब_, voša, _hebí,
   {{0x64483228,0xa3d707a3,0xfaa30bfe,0xdb0e00ee}},	//   vidi, िलन_, _гасо, _kebí,
   {{0xb5fd0080,0xceb30122,0x6448001e,0x7d0400be}},	//   toša, זיה_, widi, ovis,
   {{0x81cb00c8,0x7d0402df,0x3ce03229,0x2a6601e8}},	//   র্ড_, nvis, ntiv_, moob_,
   {{0xb5fd0029,0x2a6600a7,0x5c370070,0x7d04322a}},	//   roša, loob_, ָרטן_, ivis,
   {{0xd7930082,0x7ae90c99,0xddc4053d,0xe2150f99}},	//   _المخ, _ćetk, zliš, амны,
   {{0x6448322b,0x3ce010dd,0x2a66322c,0x6676006c}},	//   sidi, ktiv_, noob_, _صدار,
   {{0x7d04322d,0xa2c0142a,0xe1ff322e,0xc5f30122}},	//   jvis, _विक्, rdó_, _לדף_,
   {{0xe0df07e5,0x2a66006f,0x682f0b3e,0x9f530024}},	//   rtò_, hoob_, _nødl, _paxà_,
   {{0xd904040d,0xf8d1051d,0x27fe00d7,0x9f340185}},	//   _کی_, _सम्प, _matn_, бері,
   {{0xddc4003d,0x00000000,0x00000000,0x00000000}},	//   tliš, --, --, --,
   {{0xdb0e0caa,0x5bcb0274,0x682f008c,0x7d04322f}},	// [28f0] _debí, ећег_, _bødl, gvis,
   {{0xad9b130f,0x224b3230,0x6e2d3231,0x63ba3232}},	//   _saúd, lick_, skab, natn,
   {{0x09bc0083,0x7d043233,0x81cb0083,0x1a65006c}},	//   _ইউজা, avis, র্ণ_, لیسی_,
   {{0x63ba3234,0xdb07013c,0x98a919be,0xdb68002d}},	//   hatn, _rejä, šač_, урул_,
   {{0x212b3235,0x63ba27a6,0x61ff007a,0x3ce00043}},	//   nych_, katn, _maql, ctiv_,
   {{0x63ba0470,0xc7b80009,0x2ca9017b,0x224b3236}},	//   jatn, _dođo_, mpad_, hick_,
   {{0x63ba1cb0,0x224b3237,0xa2c004aa,0x2ca93238}},	//   datn, kick_, _विग्, lpad_,
   {{0x06090e60,0x212b016f,0x81cb0033,0xf6252dfa}},	//   тник_, kych_, র্ত_, рдио,
   {{0xe6160f99,0x63ba3239,0x680b0080,0x7d0020d9}},	//   рды_, fatn, _pēdē, _ámst,
   {{0x212b323a,0x63ba323b,0x13090086,0x661b014e}},	//   dych_, gatn, вной_, sjuk,
   {{0x35f51470,0x75290107,0x9f4c00a0,0x5fdc00b4}},	//   _впер, syez, ždú_, _बाबल,
   {{0x61ff0069,0x224b323c,0x7d04059c,0x64580a8a}},	//   _caql, gick_, yvis, _ejvi,
   {{0xd176323d,0x63ba005d,0xae000ccf,0x25ad323e}},	//   рыны, batn, _लोगन_, mbel_,
   {{0x7d04323f,0x98a00a78,0x645d02e1,0x03a5002d}},	//   vvis, šić_, ésid, _тико,
   {{0xc44700f5,0x6d5d0510,0x71a63240,0x9f53002a}},	//   _لیکن_, _axsa, _кайз, _paxá_,
   {{0x7d043241,0x3ce00484,0xfbb20033,0x27e000cd}},	//   tvis, ttiv_, _চাইত, đini_,
   {{0x212b006a,0x1c463242,0xeb9a05ac,0x6834009e}},	// [2900] cych_, анам, виз_, _làda,
   {{0x629e1ec0,0x69db0083,0x3ce03243,0xda0b0099}},	//   _époc, _acue, rtiv_, _सोबत_,
   {{0x3ce0273a,0x68fb3244,0x683401a6,0x00000000}},	//   stiv_, _asud, _nàda, --,
   {{0x09e63245,0x7d043246,0x09060b78,0x25ad01e4}},	//   родн, pvis, ипен, jbel_,
   {{0x63ba0388,0xb5fd3247,0x7d043248,0x2a6600be}},	//   yatn, tošn, qvis, roob_,
   {{0x25ad3249,0x69db0300,0xd90d0416,0x5694324a}},	//   ebel_, _ecue, عیل_, бакт,
   {{0x63ba07c4,0x212b004e,0x9f5812c3,0x27fe0044}},	//   vatn, zych_, ndrà_, _vatn_,
   {{0x2c0a02cb,0x27e90a78,0x63ba324b,0xddcd012e}},	//   _होतं_, đana_, watn, zmaž,
   {{0x63ba1298,0xb5fd0124,0x98a318cd,0x15e20ca1}},	//   tatn, pošn, _мите, क्षर_,
   {{0x3cf908a9,0x212b324c,0x6834009e,0xb05b191b}},	//   _उनसे_, vych_, _fàda, nrät,
   {{0x212b0755,0x25ad324d,0xdb1701ef,0x00000000}},	//   wych_, bbel_, taxé, --,
   {{0x2ca9324e,0x058609d0,0x212b324f,0x63ba3250}},	//   ypad_, _кулм, tych_, satn,
   {{0x224b3251,0x63ba005d,0x92580382,0x00000000}},	//   rick_, patn, раят_, --,
   {{0x212b3252,0xf1a70387,0x63ba0024,0x104b1303}},	//   rych_, _क्रन, qatn, тями_,
   {{0xe29700c9,0x25dd0299,0xc05802ce,0x645d3253}},	//   _кај_, क्की_, рія_, ésie,
   {{0x2ca90345,0xdda8002d,0xdd9402ee,0x682f0a8a}},	//   tpad_, итул_, жаты, _rødm,
   {{0xdb050082,0x63b8006d,0xb5fd3254,0x682f0a8a}},	// [2910] rbhí, _kevn, došl, _sødm,
   {{0x0ba700c7,0x2ca901bf,0xdd11009f,0xb05b02b1}},	//   ршам, rpad_, _iżże, träu,
   {{0x2ca90371,0xdb1500b5,0x68e2018d,0xddc40067}},	//   spad_, _kezé, etod, nniś,
   {{0x6298007b,0x63b801c0,0x2ca901ff,0x3a242e0f}},	//   _muvo, _levn, ppad_, _comp_,
   {{0x20012379,0xa3b60ca1,0xb05b02b1,0x290901ef}},	//   _kahi_, जरा_, sräu, íaa_,
   {{0x81dd00c8,0x63b801e0,0x9f5800de,0x7bdc0079}},	//   ড়ি_, _nevn, ldrá_, _gcru,
   {{0x26c13255,0xad9b03e6,0x62983256,0xab0400be}},	//   ého_, _gaúc, _nuvo, _ööpä,
   {{0xa2c00d00,0x200118ad,0xcf580bed,0x9f580033}},	//   _विज्, _lahi_, יבות_, ndrá_,
   {{0x81dd00c8,0x68fb3257,0x25ad3258,0x7bdc0103}},	//   ড়া_, _usud, rbel_, _ycru,
   {{0xc6e70a55,0x200103cb,0x224901a3,0x6298010b}},	//   _відп, _nahi_, _amak_, _buvo,
   {{0xd6db0202,0x2a7f0221,0x63b80359,0x9f5a027a}},	//   _шта_, _khub_, _devn, _capì_,
   {{0xf595004f,0x81cb0083,0x62983259,0x00000000}},	//   _الإج, র্স_, _duvo, --,
   {{0x2001325a,0x66ea00a8,0x7bc72a40,0xdb1500ac}},	//   _bahi_, _təkc, _odju, _dezé,
   {{0x2249325b,0xb21b008d,0x8fa317a3,0xa8790070}},	//   _emak_, lmæl, заре, טאָר,
   {{0x9e5a027a,0xdb1c0187,0x200100d0,0x00000000}},	//   граф_, _odrá, _dahi_, --,
   {{0x2a7f006d,0xb05b01ae,0x7bc7325c,0xdb0e00ac}},	//   _nhub_, tsäc, _adju, _nebá,
   {{0x3a240d35,0x6298033b,0x66ea00a8,0x68e20523}},	// [2920] _romp_, _zuvo, _məka, xtod,
   {{0xd37e011c,0xddcd0067,0x69d90051,0x999f0160}},	//   šćem_, gnał, egwe, _pluş_,
   {{0xb05b325d,0x5f06325e,0x3a24217f,0x9f5a0260}},	//   rrät, _узна, _pomp_, _enpò_,
   {{0xa2c00026,0xb05b013c,0x68e2325f,0x9acb00b5}},	//   _विघ्, srät, ttod, ادلہ_,
   {{0xa3d70f9f,0xdb0e01ef,0xb05b01ff,0xb5fd0506}},	//   िला_, _debá, prät, rošl,
   {{0xdca30aec,0x5a963260,0x6c360df3,0xc5e50083}},	//   _хари, _граф, _افسا, _খোলা_,
   {{0xfe1c11b5,0x63b83261,0xb5fd0254,0x3d0000be}},	//   _पचास_, _revn, pošl, रिके_,
   {{0xb8ce0b52,0x60c40254,0x63b808b7,0xf1bf00b5}},	//   _কি_, _ovim, _sevn, nkát_,
   {{0x62983262,0x63b80237,0xdb05027b,0x00000000}},	//   _suvo, _pevn, zahü, --,
   {{0x96ba3263,0x22493264,0x932600b5,0x62860051}},	//   _буду_, _smak_, مرجن, emko,
   {{0xe696004f,0x60c4005f,0xd5af3265,0x00000000}},	//   _الصد, _avim, _нс_, --,
   {{0xe7170052,0x80dd00c8,0x3cf90311,0xfbde0033}},	//   _לחבר_, যবস্, _उनले_, ড়িত,
   {{0x645d0473,0x067b0070,0xdb1500b5,0x857600b5}},	//   ésic, _ענדל, _vezé, _ادائ,
   {{0xdb1c01b4,0x25de221c,0x629800ea,0x234800d1}},	//   _idræ, _गाडी_, _tuvo, _پستی_,
   {{0xfbde0083,0x644a3266,0x9f3401e0,0xadbd010b}},	//   ড়াত, _imfi, пері, кавi,
   {{0x6602007c,0x2001023c,0x22493267,0x6a780453}},	//   _jaok, _wahi_, _umak_, dífo,
   {{0x20013268,0x61ed190b,0x6e260118,0xd7c80099}},	// [2930] _tahi_, _ibal, _dokb, रणाच,
   {{0x44e2008a,0xb6060274,0x81cb0083,0x09b3012f}},	//   ið_, lašć, র্শ_, ुण्य,
   {{0x99990812,0x60c4005f,0x2a7f0211,0x00000000}},	//   акет_, _zvim, _phub_, --,
   {{0x66023269,0x2a7f01e8,0x4975002d,0x27ec326a}},	//   _naok, _qhub_, олес, _abdn_,
   {{0x61ed326b,0x7bc300fb,0xa9690274,0x69d9326c}},	//   _mbal, ónus, јила_, rgwe,
   {{0xbcfb0248,0x16a9326d,0x27e90009,0xdb050079}},	//   _exéc, авки_, đano_, abhá,
   {{0xe73918eb,0x4639326e,0xb21b0093,0xdb1c008c}},	//   рей_, ичия_, tmæl, _adræ,
   {{0xe7f5004e,0x79e7006c,0xb5fd0a69,0x998600cd}},	//   _इसका_, _دورہ_, mošk, skoš_,
   {{0xb5fd1851,0x845903e6,0xd838021e,0x998d00f4}},	//   lošk, ирот_, _flč_, _fleš_,
   {{0x61ed09d6,0x72c5002d,0x00000000,0x00000000}},	//   _abal, обоз, --, --,
   {{0x60c4326f,0xfbd202b8,0x7c270009,0x61ed018e}},	//   _svim, ותי_, _mojr, _bbal,
   {{0x7c2701f4,0x290d3270,0xe5ef00c3,0x77610160}},	//   _lojr, _krea_, äkää, _ixlx,
   {{0x644f02e1,0x61ed01f7,0xd7e0046c,0x629e000d}},	//   écis, _dbal, _नामच, _épon,
   {{0x22590523,0x61ed3271,0x660201a0,0xdfd20037}},	//   ansk_, _ebal, _zaok, بيس_,
   {{0xa3a93272,0x81b90083,0xb5fd011c,0x44273273}},	//   गुण_, _চার_, jošk, _ion_,
   {{0x44273274,0xee373275,0x78a901c0,0xb5fd0097}},	//   _hon_, онс_, _otev, došk,
   {{0x4427069d,0x0c262626,0xec4a0086,0x9c260265}},	// [2940] _kon_, оман, азал_, одад,
   {{0x44273276,0x61ed3277,0x6e260051,0x00000000}},	//   _jon_, _zbal, _wokb, --,
   {{0x4427105d,0xb5fd2648,0x290d3278,0x7c270067}},	//   _mon_, gošk, _area_, _dojr,
   {{0x44273279,0x38c802fd,0x7bc3003e,0x00000000}},	//   _lon_, ماتی_, ónur, --,
   {{0x290d1ab8,0xa88a0714,0x442700c3,0xb05b327a}},	//   _crea_, айда_, _oon_, isän,
   {{0x4427327b,0x764b0297,0xb8f204e9,0x7c270345}},	//   _non_, _amgy, _वि_, _gojr,
   {{0xab2a0021,0xd838022f,0xd6d00037,0x290d09c5}},	//   _това_, _vlč_, رقة_, _erea_,
   {{0x44270f46,0x290d01ef,0x25bf327c,0xcf9300a5}},	//   _aon_, _frea_, gaul_, וטו_,
   {{0x4427327d,0x25eb0ccf,0xe4e602ce,0x290d00af}},	//   _bon_, _अउरी_, ційн, _grea_,
   {{0x4427327e,0x44e200fb,0x61ed2329,0x660208c7}},	//   _con_, rð_, _sbal, _waok,
   {{0xe7f7009a,0xd25100bf,0x4427327f,0x2be20099}},	//   ंजरा_, فند_, _don_, _पाना,
   {{0xe80201c0,0x92580421,0x00000000,0x00000000}},	//   लयका_, жают_, --, --,
   {{0x44273280,0xc21800d4,0x2689026e,0xb60600cd}},	//   _fon_, ією_, _اخلي_, rašć,
   {{0x44273281,0x9f4c05d3,0xdb1e0279,0xddcd0067}},	//   _gon_, ždý_, rapê, znań,
   {{0x764b0297,0xb6060129,0x62353282,0x61ed009e}},	//   _ymgy, pašć, _неку, _tbal,
   {{0x44273283,0xc7b8003a,0x61ed3284,0x443e011e}},	//   _zon_, _dođi_, _ubal, lht_,
   {{0x44273285,0x2d8f0446,0x645a3286,0xe04b00d1}},	// [2950] _yon_, äge_, onti, _نشده_,
   {{0x645a3287,0xb5fd00ac,0xfbab004b,0x44273288}},	//   nnti, tošk, ртай_, _xon_,
   {{0x682f008c,0x443e02b1,0xdefb00c7,0x00000000}},	//   _kødv, iht_, _тып_, --,
   {{0x290d0043,0xb5fd108a,0xf9c700d4,0x7b6401d3}},	//   _prea_, rošk, іщен, фтуе,
   {{0xf99016e6,0x8d873289,0x00000000,0x00000000}},	//   نبه_, _фунд, --, --,
   {{0x290d0043,0x7c3e033b,0x09340037,0x2be20099}},	//   _vrea_, chpr, برمج, _पाया,
   {{0x4427328a,0x2d9e0160,0x00000000,0x00000000}},	//   _ron_, _ştei_, --, --,
   {{0x44270147,0x682f177c,0x645a19a6,0x443e033b}},	//   _son_, _nødv, enti, eht_,
   {{0x60c90124,0xb5fd00ec,0x00000000,0x00000000}},	//   šemj, noši, --, --,
   {{0x443e01f3,0x442701e9,0x00000000,0x00000000}},	//   ght_, _qon_, --, --,
   {{0x4427328b,0xdb0e01ae,0xa82200d1,0x65620168}},	//   _von_, _gebä, _سکون, _exoh,
   {{0x645a328c,0xfc3f2556,0xb5fd23d9,0x442700a5}},	//   anti, _stíl_, koši, _won_,
   {{0x4427328d,0xfbcb022e,0x443e04e6,0x645a01e8}},	//   _ton_, ाणाम, bht_, bnti,
   {{0x443e328e,0x9f5a0382,0xb05b328f,0xc7b800cd}},	//   cht_, _papà_, ssän, _pođi_,
   {{0xe7ed134b,0x25bd0159,0xfbd2006c,0xdb1e0055}},	//   च्या_, _kewl_, ہتا_, rapë,
   {{0x9f4b00b5,0xc7b800cd,0x00000000,0x00000000}},	//   áját_, _vođi_, --, --,
   {{0xdb1c0279,0x62960159,0x229a00ea,0xb5fd3290}},	// [2960] _gerê, _iiyo, _rīki_, goši,
   {{0x62960848,0x7e760298,0x62840211,0x9f580031}},	//   _hiyo, slyp, _hhio, nerë_,
   {{0xeb97046e,0x62963136,0xfbe21604,0x4f9b00a5}},	//   чих_, _kiyo, _पाठम, _לביצ,
   {{0xdb1c01f4,0x9f580031,0x628700b8,0x83fc0009}},	//   _herë, herë_, ňkov, rođi,
   {{0x645a3291,0x62840094,0x62963292,0x6e241476}},	//   ynti, _mhio, _miyo, mjib,
   {{0x18673293,0x62962014,0x9f580031,0x00000000}},	//   пачи_, _liyo, jerë_, --,
   {{0x81d400c8,0xe3c30083,0xf1be0b35,0x8f9b0317}},	//   স্য_, ্ভাব, ्णान, זיצי,
   {{0x645a3294,0x62963295,0x6e3600c7,0xaad10355}},	//   wnti, _niyo, nkyb, _हितक,
   {{0x6d440133,0xa3d700a1,0x69c2022e,0xa4f80105}},	//   nzia, िलं_, maoe, تکار_,
   {{0x81b900c8,0x7bde03be,0x644f000d,0x53343296}},	//   _চাই_, ngpu, écip, деот,
   {{0x6284004a,0x62963297,0xe41a01ba,0x645a038e}},	//   _bhio, _biyo, _kľúč, rnti,
   {{0x443e071f,0x62843298,0xa77b0070,0xf3630144}},	//   sht_, _chio, _פראפ, этын,
   {{0x62963299,0x62840874,0x6d440221,0xdb150168}},	//   _diyo, _dhio, jzia, _rezí,
   {{0x6d44329a,0xc9530052,0xc05b2327,0x9f580055}},	//   dzia, תמש_, сім_, cerë_,
   {{0x6284003b,0x9f5a0831,0xb17b01b4,0x08770070}},	//   _fhio, _papá_, dgåe, פעלט_,
   {{0x33770052,0x6296329b,0x443c0019,0xdb1e00f7}},	//   _מתוך_, _giyo, _hlv_, capé,
   {{0xddcd0a78,0x7e6d0043,0x8d770037,0xdb1c0392}},	// [2970] glaš, roap, سارا, _herè,
   {{0xb5fd329c,0x629604fb,0xdb1c0260,0x7a330448}},	//   roši, _ziyo, _kerè, _içti,
   {{0x3cf91db6,0x6296329d,0x682f08c8,0x69c200e9}},	//   _उनके_, _yiyo, _mødt, faoe,
   {{0xddcd329e,0xdb1c01f7,0x69c20345,0x00000000}},	//   blaš, _merè, gaoe, --,
   {{0x8c3b02c9,0x443c329f,0x998401c0,0x23dd0bdd}},	//   _auße, _olv_, _domů_, _मालद,
   {{0x66ea0095,0xe8f800d8,0x443c0298,0xddc400f4}},	//   _təkl, ялі_, _nlv_, moiš,
   {{0x7d0d32a0,0x2be20380,0x26190066,0x00000000}},	//   lvas, _पाता, भाली_, --,
   {{0x443c32a1,0x00000000,0x00000000,0x00000000}},	//   _alv_, --, --, --,
   {{0x7d0d32a2,0x799b011e,0x629632a3,0x3a8400d8}},	//   nvas, _iguw, _riyo, _чырв,
   {{0x629632a4,0x628432a5,0x42c932a6,0xdb1c0107}},	//   _siyo, _shio, огон_, _berè,
   {{0xb05b022a,0xcfe30083,0x629630be,0x6d4432a7}},	//   rsäl, য়ান, _piyo, zzia,
   {{0x5eac0083,0x1c0a02cb,0xc7b80254,0x443c32a8}},	//   _ছিলে, _होईल_, _dođu_, _elv_,
   {{0xd0120332,0xdb1c00da,0xdb1e1bea,0x660932a9}},	//   پلز_, _perë, rapé, mdek,
   {{0x40950b12,0x660932aa,0xddcd011c,0xdb1c0176}},	//   ерст, ldek, vlaš, _ferè,
   {{0xdee332ab,0x6284009c,0xdb1c32ac,0x644132ad}},	//   кори, _thio, _verë, mhli,
   {{0x6d4406a2,0x799b32ae,0x7c3c0159,0xa3a92df6}},	//   tzia, _nguw, _slrr, गुर_,
   {{0x2be2022e,0x7d0d32af,0x00000000,0x00000000}},	// [2980] _पादा, gvas, --, --,
   {{0x6d4432b0,0x26c703ab,0x660900c3,0x7e6900cd}},	//   rzia, ksno_, hdek, čepa,
   {{0x7d0915b5,0x25de11b5,0x7d0d0421,0xf0930d85}},	//   _šest, _गाली_, avas, _שנת_,
   {{0xddcd00ea,0xceb302b8,0x8c480095,0xa2d532b1}},	//   plaš, _שיר_, _başç, _भिन्,
   {{0x81cb0083,0x61e432b2,0x201a012f,0x81d40033}},	//   র্ক_, _mcil, _knpi_, স্থ_,
   {{0x76aa32b3,0x9f5802e9,0x645d00f7,0x7a1e0160}},	//   отив_, terè_, ésil, _bătâ,
   {{0x6441060e,0x8c3b02c9,0x61e40009,0x66ea00a8}},	//   dhli, _fußb, _ocil, _təkm,
   {{0x81d40083,0x660932b4,0x60c900f4,0xa3b025d8}},	//   স্ত_, gdek, šemi, टुन_,
   {{0x6ad30083,0x69c00029,0x998d0187,0xb7bc00ea}},	//   _সহযো, _ieme, _pleť_, _loģi,
   {{0x69c032b5,0x29040024,0x644132b6,0x61e432b7}},	//   _heme, _isma_, ghli, _acil,
   {{0x69c00f1a,0x39460138,0x78a00371,0x27fc00e2}},	//   _keme, lzos_, _humv, mevn_,
   {{0x78a00232,0x51870210,0x2904010d,0x682f10db}},	//   _kumv, дуга, _ksma_, _føds,
   {{0x69c01201,0x394632b8,0x656f01ae,0xe5a30e9f}},	//   _meme, nzos_, ücht, _ричи,
   {{0x644102c9,0x69c032b9,0xbe05006c,0xdb0e002a}},	//   chli, _leme, کورٹ, _debú,
   {{0xfe730a72,0x9f4107e5,0xdb1c01f7,0x326702fb}},	//   ندر_, _xchè_, _feré, _отив,
   {{0x69c032ba,0xdb15024e,0xe50801a5,0x27e90a78}},	//   _neme, _nezá, _kỷ_, đani_,
   {{0xa2da20ab,0xddc40a4c,0x61fd02d4,0x78a00010}},	// [2990] पूर्, bliž, mesl, _numv,
   {{0x61fd32bb,0x3209067f,0x244002d0,0x4ea70819}},	//   lesl, _haay_, _fòme_, _орма,
   {{0x3ce915b5,0x69c032bc,0x290400d1,0x7d0d1e1f}},	//   stav_, _beme, _asma_, svas,
   {{0xfe3500c2,0x61fd32bd,0xdb05178d,0x78a00010}},	//   _נאָך_, nesl, nché, _bumv,
   {{0x69c008d7,0xadd602b8,0x290401a2,0x3209011e}},	//   _deme, _אורח_, _csma_, _maay_,
   {{0xa3b000be,0x69c032be,0x61fd00d5,0x682f1f8b}},	//   टुम_, _eeme, hesl, _røds,
   {{0x69c032bf,0x7bc532c0,0x645d3113,0x660928e9}},	//   _feme, mahu, ésim, tdek,
   {{0x69c010fb,0x7bc532c1,0xd90e006c,0xf1db0066}},	//   _geme, lahu, جیے_, _भागन,
   {{0x66090a99,0x644132c2,0x00000000,0x00000000}},	//   rdek, thli, --, --,
   {{0xc984292e,0x69c032c3,0x7bc50b04,0x61e40037}},	//   _руси, _zeme, nahu, _scil,
   {{0x69c032c4,0x3a3f0051,0x32090260,0x35b500d4}},	//   _yeme, _klup_, _baay_, _збер,
   {{0xcb1200c2,0x61fd0136,0x683412c3,0x6a780473}},	//   אלט_, gesl, _ràdi, tífi,
   {{0x7bc518ad,0x78a0006d,0x25b90093,0x68340176}},	//   kahu, _xumv, ðslu_, _sàdi,
   {{0x6a781d2b,0xf8b20122,0x3a2d32c5,0x7bc532c6}},	//   rífi, רשם_, _loep_, jahu,
   {{0xdb1c2e79,0x3a3f32c7,0x5e96004f,0x61fd32c8}},	//   _teré, _olup_, فلسط, besl,
   {{0xa3d70066,0x61e40e31,0x2be20099,0x66ea00a8}},	//   िलक_, _ucil, _पाहा, _səkk,
   {{0x409632c9,0xc692168d,0x7afb0129,0x69c032ca}},	// [29a0] _прот, ראן_, _ćuta, _reme,
   {{0x69c00ec0,0x7bc532cb,0x6cd30037,0x290400d5}},	//   _seme, gahu, اقلا, _rsma_,
   {{0x69c01201,0x224032cc,0x3a2d0345,0x00000000}},	//   _peme, _klik_, _boep_, --,
   {{0xc986190a,0x4ad10099,0x0f571804,0x9fb80033}},	//   нули, _हिरव, _טיים_, _জায়গ,
   {{0xa3cf0bdd,0x7bc532cd,0x69c00031,0x3a2d0345}},	//   षणा_, bahu, _veme, _doep_,
   {{0x26dc32ce,0x394632cf,0x7bc532d0,0x66ea00a8}},	//   tuvo_, rzos_, cahu, _həki,
   {{0x8c1b00c2,0x316c004e,0x81cb0083,0x78a001d5}},	//   _צולי, ędzy_, র্ট_, _wumv,
   {{0x3a3f0bde,0x9b1700a5,0x7c2e32d1,0xddd100c7}},	//   _glup_, _אחלה_, _hobr, _įgūd,
   {{0x7c2e32d2,0x61fd32d3,0xb21b08c8,0xc7b80207}},	//   _kobr, vesl, llæg, _anđe_,
   {{0xb8060332,0xb05b022a,0x224032d4,0x733808ce}},	//   _سکتے_, rsäk, _alik_, дзор_,
   {{0xb21b221b,0x7c2e09c8,0x224032d5,0x1de10864}},	//   nlæg, _mobr, _blik_, _फालत,
   {{0x64a62dc5,0xe5080028,0xb0a50084,0x60dd127d}},	//   _зада, _tỷ_, _गंदग, tusm,
   {{0xdb0532d6,0x61fd0c7d,0x7bc52eb4,0xe5080019}},	//   rché, resl, yahu, _uỷ_,
   {{0x7c2e32d7,0x3209010d,0xdb05026e,0x61fd00a8}},	//   _nobr, _waay_, sché, sesl,
   {{0xb5fd0bc6,0x60dd00ab,0xddc40035,0x61fd00b5}},	//   pošt, susm, bliż, pesl,
   {{0x442e02c0,0xa2d5000c,0x7bc50054,0xb21b01b4}},	//   _hof_, _भित्, wahu, dlæg,
   {{0x5c75081b,0x3a2d053e,0x3d1b0035,0x25f3021a}},	// [29b0] влат, _roep_, नमें_, ्जती_,
   {{0xddeb01ca,0xe1ff32d8,0x7c2e1adb,0x60cd0371}},	//   _کرده_, leó_, _cobr, _ivam,
   {{0x7c2e0b9a,0x7bc532d9,0x2be202d1,0xfbe232da}},	//   _dobr, rahu, _पारा, _पारम,
   {{0x7bc50991,0x442e32db,0xe1ff02d7,0x60cd32dc}},	//   sahu, _lof_, neó_, _kvam,
   {{0x7bc50f3a,0xbddb0443,0x8d8432dd,0xe0df027a}},	//   pahu, _elèc, _бурд, nuò_,
   {{0x81cb0b52,0xbddb2870,0x442e03d0,0x60cd0027}},	//   র্চ_, _flèc, _nof_, _mvam,
   {{0x1c0a3123,0x6e2f023a,0x683400f1,0xddcd0067}},	//   _होटल_, _kocb, _nàdu, miał,
   {{0x7c2e2ab5,0x60cd011c,0xb9070831,0x00000000}},	//   _zobr, _ovam, _বন_, --,
   {{0xe1ff006c,0x98f40041,0x442e32de,0x3ceb0176}},	//   deó_, _مثلا, _bof_, _jqcv_,
   {{0x442e00e9,0x22400044,0xddcd0035,0x9f580036}},	//   _cof_, _slik_, niał, ferì_,
   {{0x60cd00ab,0xb21b32df,0x22400035,0x33f40409}},	//   _avam, klæd, _plik_, учыс,
   {{0x6b9a0093,0x81cb0033,0x6e2f009e,0x355201cb}},	//   _útge, র্ঘ_, _nocb, انیز,
   {{0xf1bf006c,0xa5092b21,0x7e6900cd,0xdd010355}},	//   pján_, _цела_, čepl, čtět,
   {{0x03a20c06,0xd4790070,0x7afb0009,0x628f0345}},	//   _кишо, _קאַל, _ćutn, amco,
   {{0xe45602b5,0x60cd32e0,0x660b011e,0x00000000}},	//   _ביסט_, _evam, _kagk, --,
   {{0xb17b013c,0x28d20b54,0x660b0069,0x224001e0}},	//   mgån, _सिलि, _jagk, _ulik_,
   {{0xed570610,0x660b32e1,0xada332e2,0xdca31d80}},	// [29c0] вот_, _magk, раул, иати,
   {{0x21370070,0x1c1c007c,0x660b24ec,0x14d40099}},	//   _סטיל_, नाइल_, _lagk, _दिसण,
   {{0x9f480086,0x8b96280a,0x403b32e3,0x2b39002d}},	//   ähän_, трач, _חגיג, няцэ_,
   {{0x660b03a2,0xb21b32e4,0xd8380124,0x281300fd}},	//   _nagk, rlæg, _miče_, یونس,
   {{0x61f600da,0xd94607b0,0x7c2e32e5,0x7e660051}},	//   _mbyl, ъеди, _tobr, _ijkp,
   {{0xddcd004e,0x98730eb9,0x7d0401d5,0x7c2e00cd}},	//   ciał, аліц, mwis, _uobr,
   {{0x442000e8,0x7d0432e6,0x660b32e7,0x442e32e8}},	//   _đi_, lwis, _bagk, _rof_,
   {{0x442e32e9,0x261932ea,0xb17b01ff,0xddcd00ac}},	//   _sof_, भागी_, dgån, plať,
   {{0x18a62dc5,0x2ca60082,0x57ea0279,0x660b32eb}},	//   _разм, íodh_, _одам_, _dagk,
   {{0xdb1c01ef,0x6a780d9b,0x68340176,0xd83820dc}},	//   _lerí, rífu, _pàdu, _biče_,
   {{0x60cd32ec,0x7d0432ed,0x442e0223,0x9f5802d7}},	//   _svam, hwis, _vof_, ferí_,
   {{0x7d0432ee,0xddcd0035,0x9f580453,0xd8380207}},	//   kwis, ział, gerí_, _diče_,
   {{0x442e32ef,0x628f01e4,0x6e2f32f0,0x660008c7}},	//   _tof_, rmco, _rocb, memk,
   {{0x660032f1,0x6e2f0023,0x2440021e,0xe1ff02d7}},	//   lemk, _socb, _fòma_, seó_,
   {{0x9259049f,0x6738006c,0x9f5301ef,0xbcfb0176}},	//   _пакт_, nyvj, _raxó_, _txék,
   {{0x6d0e083f,0xd2580043,0x30a732f2,0x6aa1002a}},	//   सिंग_, _аць_, _иров, _élfi,
   {{0xd90407e4,0x2d5803ad,0xebc703fa,0x50670409}},	// [29d0] _بی_, вить_, вљен, _атна,
   {{0x764232f3,0x5fb71db1,0x2259057f,0x61f60355}},	//   _lloy, _अभिल, lisk_, _zbyl,
   {{0x9f3503d0,0xddcd004e,0x98b800ea,0x0ba40dc8}},	//   _сені, riał, _ārā_, ршум,
   {{0x225902df,0x629e0248,0x7f3a0319,0xddcd0035}},	//   nisk_, _épou, _נערו, siał,
   {{0x4dda02da,0xdb1c2ec6,0xbd6b0274,0x00000000}},	//   _אחרו, _cerâ, _црне_, --,
   {{0xd3660a42,0x764232f4,0x660b32f5,0xb8cb060a}},	//   _هه_, _aloy, _sagk, _गढ_,
   {{0x660b132a,0xf0940070,0x00000000,0x00000000}},	//   _pagk, בנס_, --, --,
   {{0x2bcb2f41,0xf50932f6,0x3eb300e2,0xda0b007c}},	//   ाणका, енил_, _mtxt_, _सोचत_,
   {{0x22591e54,0xdb050079,0x03a527eb,0xb05b02b1}},	//   disk_, ichí, липо, lsäu,
   {{0x2c1c0035,0x58871ac5,0x76420107,0x660b0298}},	//   नाएं_, _рыба, _eloy, _wagk,
   {{0x7d0432f7,0x2259177c,0xc7350a86,0x660b32f8}},	//   zwis, fisk_, _حفاظ, _tagk,
   {{0x225902df,0x764205a4,0xd83800cb,0x7d040035}},	//   gisk_, _gloy, _viče_, ywis,
   {{0x5156005f,0x51550183,0x00000000,0x00000000}},	//   утну, атру, --, --,
   {{0xdb1c32f9,0xdee632fa,0xc5e30084,0xd83802f0}},	//   _serí, логи, _गाँठ_, _tiče_,
   {{0xdb1c32fb,0x00000000,0x00000000,0x00000000}},	//   _perí, --, --, --,
   {{0x25ad32fc,0x6d4101c2,0x7d0432fd,0x200c18a8}},	//   ncel_, _əlav, twis, ždi_,
   {{0xdb1c32fe,0x0d8632ff,0x00000000,0x00000000}},	// [29e0] _verí, улан, --, --,
   {{0x7d043300,0x66000076,0xc0063301,0x629e0443}},	//   rwis, zemk, _спок, _èpoc,
   {{0xdb1c3302,0x91a93303,0x41b80026,0x68fb011e}},	//   _terí, _hoá_, _आभास, _apud,
   {{0x66ea01c2,0x61e60703,0x9f583304,0x98a60036}},	//   _məkt, ngkl, merà_, гиде,
   {{0x9f5807e5,0xc7b800cd,0xbddb00e0,0xed36002d}},	//   lerà_, _anđa_, _klèn, _сэнэ,
   {{0xdcfd0029,0x6d4800a8,0xbddb0118,0xd37e0124}},	//   _uzsā, _ədal, _jlèn, šćim_,
   {{0xf1ba0028,0x9f5807e5,0x66003305,0xb5fd3306}},	//   _đơn_, nerà_, temk, tošp,
   {{0x7e643307,0x9634316d,0xfb1b011d,0xb05b01ff}},	//   nnip, рниц, _אולמ, lsät,
   {{0x3d170243,0x896613ad,0x9f580382,0xa3cf00e7}},	//   निये_, _скаж, herà_, षणं_,
   {{0x261900a1,0xb05b3308,0x64430211,0x545402fb}},	//   _मोठी_, nsät, _clni, рвот,
   {{0x225902df,0x7e643309,0xa3e50cc5,0xb893004f}},	//   tisk_, knip, _फार_, _اللع,
   {{0x9f580382,0xbb3b0070,0x6443151c,0xdb050132}},	//   derà_, געטי, _elni, lchã,
   {{0x225902df,0xf1bf006c,0x25f30963,0xc6930319}},	//   risk_, lják_, ्जरी_, _האף_,
   {{0x225902df,0x43940009,0xdb1e02d7,0x7afc07e7}},	//   sisk_, _калс, zapá, _oprt,
   {{0x645a330a,0x213901f4,0x22592895,0xb05b330b}},	//   miti, sysh_, pisk_, dsät,
   {{0x442c330c,0x443e330d,0x7e64011e,0x31660009}},	//   ljd_, lkt_, gnip, _žoze_,
   {{0xdc5511b9,0x28c61fe0,0x26c1006c,0x5d9900d8}},	// [29f0] авањ, रीमि, ához_, ткаў_,
   {{0x645a330e,0x443e330f,0x2ca90024,0xe7e016d3}},	//   niti, nkt_, rqad_, _नागप,
   {{0x443e3310,0xcb550202,0xdb0e01ae,0xdb1c0310}},	//   ikt_, јвећ, _gebü, _cerà,
   {{0xdb1c0370,0x645a3311,0x39153312,0x20033313}},	//   _serã, hiti, имер, leji_,
   {{0x628d111c,0x645a3314,0xfc3f0037,0x443e3315}},	//   _mhao, kiti, _dtír_, kkt_,
   {{0x443e04ce,0x7c3e3316,0x645a3317,0xccf200a5}},	//   jkt_, ckpr, jiti, _וכך_,
   {{0xfc3f3318,0x645a3319,0xdb1c03e6,0xaa9500d4}},	//   _guía_, diti, _verã, _вивч,
   {{0x6e2d331a,0x443e331b,0xceb41899,0xea63006c}},	//   njab, ekt_, זיק_, _اپری,
   {{0x645a331c,0x7bc70464,0xdb1c03e6,0x6d4d331d}},	//   fiti, _keju, _terã, nzaa,
   {{0x69cb1173,0x6448331e,0xdb1c2cad,0x7bc7331f}},	//   lage, ghdi, _herá, _jeju,
   {{0x20033320,0x60dd0d35,0x38ab0249,0x32020501}},	//   deji_, ersm, _hør_, teky_,
   {{0x628d3321,0x69cb3322,0x7bc73323,0x9f580382}},	//   _chao, nage, _leju, verà_,
   {{0x645a3324,0x628d1093,0x9f583325,0x2003042a}},	//   biti, _dhao, derá_, feji_,
   {{0x443e08f9,0x69cb3326,0x9f583327,0x6d4d3328}},	//   ckt_, hage, terà_, dzaa,
   {{0x628d0014,0x7e561018,0x69cb3329,0x38ab0249}},	//   _fhao, атац, kage, _lør_,
   {{0x628d02a8,0x9f58332a,0xa0a60336,0x6da300af}},	//   _ghao, rerà_, _каид, жита,
   {{0x69cb332b,0x64860093,0xb05b1535,0x753b0010}},	// [2a00] dage, iðin, tsät, nyuz,
   {{0x9f5807e5,0xdb1c0037,0x765b043d,0x0c23290e}},	//   perà_, _aerá, hiuy, омун,
   {{0xb05b06d2,0x9f58332c,0x7c3e0051,0x2e3c0093}},	//   rsät, berá_, rkpr, _lífi_,
   {{0x645a332d,0x9f5808c0,0x38ab177c,0x644800da}},	//   ziti, cerá_, _bør_, zhdi,
   {{0x764900e0,0x3940332e,0x443e01e0,0x645a0273}},	//   dhey, áis_, ykt_, yiti,
   {{0x26dc0274,0x645a332f,0x2c1c004e,0xf1bf006c}},	//   trvo_, xiti, नाओं_, tják_,
   {{0x69cb3330,0x645a3331,0x12e00083,0x3940010b}},	//   bage, viti, _বন্দ, šis_,
   {{0x26190fd1,0x38ab1953,0x69cb3332,0x20033333}},	//   _मोदी_, _før_, cage, zeji_,
   {{0x38ab0022,0x645a3334,0xd9431964,0x644819f4}},	//   _gør_, titi, _дети, thdi,
   {{0x628d009c,0x9f5801ba,0x443e1715,0x7e690124}},	//   _shao, zerá_, ukt_, čepi,
   {{0x645a3335,0x443e3336,0xd5af0112,0x7afb0009}},	//   riti, rkt_, _мс_, _ćutk,
   {{0x443e0161,0x645a3337,0x64483338,0xdb1c0042}},	//   skt_, siti, shdi, _xerá,
   {{0x645a2ce7,0x9f580370,0x68e4004a,0xc05b00d4}},	//   piti, verá_, àidh, вів_,
   {{0x02a61dc2,0x60c4046a,0x69cb3339,0xc05b00d4}},	//   _крим, _dwim, zage, тім_,
   {{0x628d1093,0x69cb333a,0x44f0333b,0x28c623f0}},	//   _thao, yage, là_, रीति,
   {{0x7bc70f1a,0x69cb0183,0xb05b00c3,0x2003023c}},	//   _seju, xage, tsäs, seji_,
   {{0x7bc7005d,0xdb05290b,0x44f0333c,0x629f0248}},	// [2a10] _peju, dchá, nà_, _époq,
   {{0xdb1c0f56,0x69cb333d,0x6d4d0120,0x6aa0009e}},	//   _será, wage, rzaa, _aimf,
   {{0x69cb333e,0xc7b80124,0x6486008d,0x15f80d1f}},	//   tage, _anđo_, yðin, ्जार_,
   {{0xceb2012b,0xe0df0036,0xbddb0359,0x6d4d0051}},	//   _מיט_, orò_, _klèm, pzaa,
   {{0xdb1c333f,0xe9d800d8,0x798000e9,0xa3d62218}},	//   _verá, ркі_, _cymw, िणा_,
   {{0x44f00392,0xdb050037,0xb8cf018d,0xfd96024b}},	//   dà_, achá, _ऐं_, _לדרך_,
   {{0x76493340,0xdb1c0f2d,0x61ed0096,0xb9e701e0}},	//   they, _terá, _ocal, _візи,
   {{0x81cc0083,0x7c3502c4,0x683d0443,0x38ab01b4}},	//   _লাভ_, _hozr, _mèdi, _tør_,
   {{0x648600fb,0x7980001e,0xf80700d4,0xf1bf00d5}},	//   rðin, _gymw, _вчен, dbá_,
   {{0xe0df07e5,0x61ed2127,0x7649034d,0x60c404fb}},	//   drò_, _acal, shey, _rwim,
   {{0x78a90033,0x9f5812c3,0xe0df027a,0x60c43341}},	//   _huev, merç_, erò_, _swim,
   {{0x78a13342,0x66ea00a8,0x44f00392,0xa91d00ee}},	//   _hilv, _təkr, bà_, _tyžd,
   {{0x78a93343,0x25bf3344,0xf6743345,0xfc3f3346}},	//   _juev, mbul_, _بالخ, _ruín_,
   {{0x78a90831,0xf1bf0279,0x25bf3347,0x7e7d0260}},	//   _muev, abá_, lbul_, _aksp,
   {{0x7ae5007c,0xddcb011c,0xe0df027a,0xf1bf00b5}},	//   juht, _šiša, arò_, bbá_,
   {{0x25bf0723,0x64413348,0xf8a500bf,0x290d3349}},	//   nbul_, lkli, _يک_, _osea_,
   {{0x78a90b52,0x6441334a,0xa3ae073f,0x1c46005f}},	// [2a20] _nuev, okli, _कलम_, бнам,
   {{0xeb9a0036,0xdd8f197c,0x09d000a1,0x3212010d}},	//   гиз_, رول_, हण्य, _hayy_,
   {{0xdb1c334b,0x7c3528f9,0xb09b0122,0x6441334c}},	//   _merç, _dozr, _תייר, ikli,
   {{0xd9100164,0x64411ca0,0xdb1e194e,0x281900b5}},	//   ویز_, hkli, vapä, یفنگ_,
   {{0x78a905c9,0x6441334d,0x78a11cdb,0xda1d046c}},	//   _cuev, kkli, _bilv, फाजत_,
   {{0x78a10ae0,0x44f0334e,0xaad10437,0xfc44006c}},	//   _cilv, và_, _हिचक, _بھرپ,
   {{0x61b80084,0x56941195,0x6aa00312,0x644109e1}},	//   _आभूष, оакт, _timf, dkli,
   {{0x44f0334f,0xc8e00299,0xbb3b02b5,0x44b400d4}},	//   tà_, _निपट, _געלי, обис,
   {{0xdb1c0279,0x7afb011c,0x3ebf0124,0x28d20067}},	//   _berç, _ćuti, ćuti_, _सिटि,
   {{0x44f03350,0x61ed3351,0xe0df07e5,0x15ea00dc}},	//   rà_, _scal, vrò_, _टावर_,
   {{0x6d4101c2,0xd764006c,0x533402c1,0x44f00392}},	//   _əlaq, _بنای, цент, sà_,
   {{0x64410173,0x3ea2004e,0xe0df07e5,0x78a13352}},	//   akli, _nikt_, trò_, _zilv,
   {{0xdb1c0086,0xf5960037,0xa3d4058f,0x683d0260}},	//   _herä, _الشج, _долч, _sèdi,
   {{0x64413353,0xdb1c3354,0xe0df07e5,0x61ed0035}},	//   ckli, _gerç, rrò_, _wcal,
   {{0x62350369,0x7c3512ad,0xc0580131,0xce6b3355}},	//   _меку, _rozr, сія_, град_,
   {{0x4caa0083,0xe0df027a,0x61ed013b,0xddcd0124}},	//   _চৌধু, prò_, _ucal, slaž,
   {{0x7c35016f,0x3ea23356,0xdd94004b,0x00000000}},	// [2a30] _pozr, _dikt_, заты, --,
   {{0x4d9815eb,0x9f5a2b01,0x2d823357,0x99ba0033}},	//   скую_, _capó_, _dyke_, ুলোক,
   {{0x78a93358,0x25a60183,0xa91d0a66,0x00000000}},	//   _suev, _ogol_, _izži, --,
   {{0x78a13359,0x3a240183,0x7e990ef2,0x7ae5335a}},	//   _silv, _cnmp_, _خنجر_, ruht,
   {{0xbcfb335b,0x7c870705,0x78a1335c,0x7ae518af}},	//   _exér, _гуве, _pilv, suht,
   {{0x8aa702f3,0xdb1c022a,0xe739224c,0xdd31004e}},	//   _град, _berä, иел_, zęśc,
   {{0x81d40b52,0x6486003e,0xa6b40033,0x2249335d}},	//   স্ট_, rðil, _টিউট, _olak_,
   {{0x25a60069,0xb05b02b1,0x62560097,0x00000000}},	//   _cgol_, lpäd, lšov, --,
   {{0x78a1335e,0x893704e8,0x6441335f,0x3212028b}},	//   _tilv, _اعزا, tkli, _rayy_,
   {{0x22493360,0xf9903345,0x99480037,0x26191ca8}},	//   _alak_, _سبق_, _الكل_, _मोरी_,
   {{0x64413361,0xdb1c02c9,0x22493362,0xb21b04f2}},	//   rkli, _gerä, _blak_, rlæn,
   {{0x81e200c8,0x28e004eb,0x64413363,0x28c60e61}},	//   ন্ন_, _निमि, skli, रीवि,
   {{0xa2d523db,0xdb1c0370,0xbddb0359,0x22490116}},	//   _भिक्, _terç, _elèk, _dlak_,
   {{0x22493364,0xe7ed0387,0x3ea215ed,0x2d820b88}},	//   _elak_, च्चा_, _sikt_, _ryke_,
   {{0x2013012f,0x032500d4,0x7d1d0051,0x8fa318cd}},	//   _daxi_, _єдин, _arss, даре,
   {{0x00e616e2,0x3f8400ea,0xdcf72135,0x00000000}},	//   _джин, āmu_, ुबंध_, --,
   {{0x3ea2013c,0x2cb90345,0xb5fd00ac,0x00000000}},	// [2a40] _vikt_, _ctsd_, jnšm, --,
   {{0x62863365,0x2a7f0a4e,0xc8e00066,0x24400211}},	//   llko, _akub_, _निबट, _còmh_,
   {{0x6da607c1,0x3ea200ea,0xe7ed05f7,0x2440009e}},	//   _мина, _tikt_, च्छा_, _dòmh_,
   {{0xdb1c017b,0x00000000,0x00000000,0x00000000}},	//   _nerå, --, --, --,
   {{0xa3e902cb,0x15e300c4,0xa96a0009,0x00000000}},	//   यला_, _गाजर_, шида_, --,
   {{0xd6da3366,0xdb1c0086,0x6f1e00ee,0x20130065}},	//   ати_, _perä, _krpc, _xaxi_,
   {{0x27e00723,0x81e20083,0xdca30923,0x2a7f0118}},	//   ğin_, ন্য_, _цари, _fkub_,
   {{0x91e60bc1,0xdb1c02c9,0x27e004d4,0xa5341d9f}},	//   _कागज_, _verä, şin_, знич,
   {{0xd4062294,0x28c6018d,0x746a3367,0x00000000}},	//   ояни, रीशि, иров_, --,
   {{0x81e20083,0x69c23368,0xdb1c00c3,0xb35400d4}},	//   ন্ম_, lboe, _terä, зкош,
   {{0x22493369,0x28c60567,0x683d01f7,0x68e40079}},	//   _plak_, रीरि, _cèdu, áidf,
   {{0x64a6336a,0x69c20120,0x68e2023c,0x00000000}},	//   _дада, nboe, orod, --,
   {{0x2249336b,0x1a9b00c2,0x2beb25de,0x62560187}},	//   _vlak_, ייטע, _चालू_, yšov,
   {{0x9f5a02e9,0x62863118,0x6e260282,0x741400f8}},	//   _rapò_, alko, _ankb, _روبا,
   {{0xd838008b,0x69c20b0d,0x2ca301e4,0x38b00284}},	//   _moč_, kboe, _rijd_, _làr_,
   {{0x2cb90526,0x68e2336c,0x2249336d,0xa91d0355}},	//   _ptsd_, krod, _ulak_, _lyža,
   {{0xa3ae2450,0x5d5506c2,0x6b9a008d,0xfbab2374}},	// [2a50] _कला_, чкат, _útgj, атей_,
   {{0x68e2336e,0x64dd00a1,0xd838008b,0xb5fd082d}},	//   drod, _मिसळ, _noč_, miše,
   {{0x625600ac,0xb5fd336f,0x656400d5,0x00000000}},	//   ršov, liše, _žihl, --,
   {{0xc33302b5,0x69c2152b,0x244002d0,0x68e2016e}},	//   ווע_, gboe, _dòmi_, frod,
   {{0x2ca304ce,0x68e2004e,0x62560187,0x38b00284}},	//   _tijd_, grod, pšov, _càr_,
   {{0xd7fb00af,0x7d0d3370,0x9f58027a,0x38b0009e}},	//   руд_, mwas, ffrè_, _dàr_,
   {{0x3ffc00c2,0x44290028,0xe7393371,0x7d0d3372}},	//   יפגע, _đa_, сей_, lwas,
   {{0x68e22d5b,0xecdf004e,0x38b0009e,0xdb170042}},	//   brod, _फटाफ, _fàr_, saxó,
   {{0xdb0502bf,0x81e200c8,0x83fc042a,0x7d0d3373}},	//   schä, ন্ড_, ziđe, nwas,
   {{0xd8380009,0x7d0d067f,0x78bb021d,0x28e022c7}},	//   _goč_, iwas, _ituv, _निति,
   {{0x59cf0517,0x3ce90189,0x7d0d3374,0x5884010b}},	//   _हजार, huav_, hwas, _цыта,
   {{0x64c510ab,0x7d0d01a8,0x80b30083,0x83fc0254}},	//   _فيصل, kwas, _জিজ্, viđe,
   {{0x271c0023,0x66093375,0xbddb3376,0xe56e027a}},	//   _ảnh_, meek, _glèi, _чз_,
   {{0x66093377,0xdb15033b,0xbddb0107,0xa879016b}},	//   leek, _bezü, _klèw, מאָר,
   {{0x44273378,0xe29a3379,0x00000000,0x00000000}},	//   _inn_, _лак_, --, --,
   {{0x6f1e00cb,0xb5fd0009,0x7c270118,0x6609337a}},	//   _vrpc, biše, _anjr, neek,
   {{0x7d0d01a2,0x28e000b4,0x78bb0027,0x229b02d4}},	// [2a60] gwas, _निधि, _ntuv, _cūku_,
   {{0x69db0453,0x8b960eee,0x6609337b,0xac831858}},	//   _adue, преч, heek, егул,
   {{0x103b00a5,0x69c219c1,0xd83800d5,0x291f2cee}},	//   _הגיע, tboe, _roč_, _arua_,
   {{0xdca60ea6,0x200a337c,0x2018337d,0x44270211}},	//   _нами, lebi_, ldri_, _lnn_,
   {{0x4427337e,0x291f004f,0x69c22c59,0xb05b007c}},	//   _onn_, _crua_, rboe, späe,
   {{0xe8160084,0x68e2337f,0x69c209a6,0x200a26b4}},	//   _धोखा_, rrod, sboe, nebi_,
   {{0xa91d024e,0x7bdc0034,0x1c0202e4,0xa09b0070}},	//   _vyža, _idru, _रॉयल_, זיסט,
   {{0x44273380,0x81e20b52,0x54b81583,0xbddb0118}},	//   _ann_, ন্ত_, огия_, _dlèw,
   {{0x7bce0464,0x48e3117a,0x291f01f4,0x44273381}},	//   _kebu, _потв, _grua_, _bnn_,
   {{0xb5fd0254,0x200a022f,0x7bce00d1,0x2b0000ab}},	//   više, jebi_, _jebu, _ईहाँ_,
   {{0x67bb00a5,0xf3660dba,0x212000e0,0x442700cc}},	//   _המבק, ятин, _arih_, _dnn_,
   {{0x44270bd1,0x7bce3382,0x3ce9006d,0xb5fd0478}},	//   _enn_, _lebu, yuav_, tiše,
   {{0x3ce9006f,0xbddb0107,0xba57016b,0x7bdc1aa5}},	//   xuav_, _klèv, לסטו_, _odru,
   {{0x7bce3383,0xb5fd18b0,0xc05800d8,0x4427053e}},	//   _nebu, riše, піс_, _gnn_,
   {{0x212002c4,0xff042698,0x54330416,0x81e20033}},	//   _erih_, нятн, _سرور, ন্ধ_,
   {{0xb5fd3384,0x7d0d3385,0x7bdc00d7,0x00000000}},	//   piše, twas, _adru, --,
   {{0xf1c3009a,0x7bce3386,0x6256010b,0xdcef00ea}},	// [2a70] _व्यन, _bebu, ršot, _izcī,
   {{0x81e200c8,0xfbab00c7,0x6609276d,0xe0df02d0}},	//   ন্দ_, стай_, zeek, ryòd_,
   {{0x29040176,0x78bb0c7d,0x3ce90221,0x7ac4002d}},	//   _apma_, _stuv, suav_, есче,
   {{0xdb15024e,0xfd1f01a5,0x61ef00cc,0x320b3387}},	//   _sezó, _trì_, ngcl, necy_,
   {{0x9f510831,0xdb050079,0xdb1502d7,0x00000000}},	//   pezó_, nchú, _pezó, --,
   {{0x7bce3388,0x66093389,0xdb1502d0,0x6fbf0096}},	//   _gebu, week, _dezò, ्रिं,
   {{0x660909d6,0xb5fd0009,0xdb050079,0xac940dde}},	//   teek, lnši, hchú, _чарш,
   {{0x7e6d338a,0x7bdc338b,0x7bce1f55,0x291f338c}},	//   nnap, _zdru, _zebu, _trua_,
   {{0x660902e6,0x5fbf052b,0x81cc0083,0x14dd00a1}},	//   reek, ्राल, _লাল_, _मिळण,
   {{0x68e40514,0x66091c85,0x7e6d338d,0x6f05023a}},	//   áide, seek, hnap, _ophc,
   {{0xe29a338e,0xc7b200a5,0x44270023,0x7e6d338f}},	//   жан_, _סבא_, _vnn_, knap,
   {{0xd9ff0d00,0x2001012f,0x1fc60026,0x21200009}},	//   ोजित_, _abhi_, वर्ड, _prih_,
   {{0x7e6d3390,0x68eb02b3,0xd4350037,0x4427055c}},	//   dnap, nugd, _يعتب, _tnn_,
   {{0x67210c99,0xa91d0187,0xe80009b1,0x28e0018d}},	//   _krlj, _lyžo, ल्पा_, _निसि,
   {{0x7bce3391,0xa0a30fc5,0x7bc5009e,0x10a33392}},	//   _rebu, тард, dbhu, тирн,
   {{0x7bce203f,0x7ae5003a,0x7bdc00b8,0x6721011c}},	//   _sebu, drht, _sdru, _mrlj,
   {{0x6aae3393,0x7bce012f,0x62843394,0x2bb207b5}},	// [2a80] _subf, _pebu, _ikio, _जलदा,
   {{0x1daa1ea9,0x672100f4,0xfce30b25,0xdb150260}},	//   _कलकत, _orlj, тофо, _rezò,
   {{0x3cea0084,0x28e0017f,0xaaba132d,0x00000000}},	//   _चमके_, _निहि, زدار_, --,
   {{0x1bf00084,0x7bce3395,0x53360070,0x00000000}},	//   _चावल_, _webu, ונען_, --,
   {{0x7bce3396,0x83fc0009,0x644f00ea,0x6284023c}},	//   _tebu, hiđa, īcij, _mkio,
   {{0x7bdc01cc,0x67210506,0x59cc01c0,0x888400ff}},	//   _udru, _brlj, ारहर, ریان,
   {{0x2bc421b2,0x68e40079,0xb17b0542,0x28e0074f}},	//   _ल्या, áidb, ngår, _निवि,
   {{0x44201a24,0x1514145f,0x7c3c03e9,0x672100cd}},	//   _şi_, едия, _horr, _drlj,
   {{0x7c3c3397,0x6d441096,0xd838011c,0x04170033}},	//   _korr, nyia, _liči_, তানী_,
   {{0x03f803fa,0x62840054,0x7c3c01d7,0xdb1c0c61}},	//   чној_, _akio, _jorr, _berø,
   {{0x7c3c3398,0x6fbf25de,0xbddb0260,0x672100f4}},	//   _morr, ्रसं, _klèt, _grlj,
   {{0x7c3c3399,0x81e20083,0x63ad339a,0x68ed010b}},	//   _lorr, ন্স_, _şant, žodž,
   {{0x61fd0093,0xbddb0118,0x7c3c03bc,0x00000000}},	//   rfsl, _mlèt, _oorr, --,
   {{0x7c3c330b,0xb5fd0124,0x628401ed,0x75220027}},	//   _norr, miša, _ekio, _iroz,
   {{0xe800134b,0x9f5f0723,0x7522024e,0x7e6d339b}},	//   ल्या_, _ürün_, _hroz, tnap,
   {{0x443c339c,0x7e64010d,0x752200f4,0xd8380207}},	//   _hov_, giip, _kroz, _diči_,
   {{0x443c339d,0x7e6d339e,0x660200d1,0x7c3c0147}},	// [2a90] _kov_, rnap, _mbok, _borr,
   {{0x7c3c339f,0xe3b8008f,0x6f0501a5,0x6fc000a1}},	//   _corr, ncı_, _tphc, वडणू,
   {{0x443c33a0,0xda7b0036,0x7c3c33a1,0x30780037}},	//   _mov_, ояд_, _dorr, _تحية_,
   {{0x60cd15ab,0x443c33a2,0x752233a3,0xddeb0833}},	//   _kwam, _lov_, _oroz, _برده_,
   {{0x7c3c33a4,0xa80301d6,0x6e3d011e,0x20cd33a5}},	//   _forr, _çıkt, _iosb, nži_,
   {{0x7c3c33a6,0x672103fd,0x60cd33a7,0x660233a8}},	//   _gorr, _prlj, _mwam, _abok,
   {{0x394933a9,0xddc4108a,0x60cd018e,0x98bf00d0}},	//   šas_, lniš, _lwam, ırım_,
   {{0x83fc1269,0x7c3c33aa,0x752201a0,0x629d02c4}},	//   viđa, _zorr, _broz, jmso,
   {{0x443c0c9a,0x6e3d33ab,0xd7fb33ac,0x752200f6}},	//   _bov_, _mosb, _муж_, _croz,
   {{0x443c1020,0x20cd33ad,0x7c3c33ae,0x672100cb}},	//   _cov_, dži_, _xorr, _trlj,
   {{0x60cd33af,0x13a704e8,0x443c33b0,0x63ad33b1}},	//   _awam, بندی_, _dov_, _şans,
   {{0x23bf0d1f,0xd83800cb,0x60cd2107,0xf08900a5}},	//   _श्रद, _riči_, _bwam, _הנ_,
   {{0x752233b2,0x1bf00302,0xc56b006c,0xddc4008b}},	//   _groz, _चालल_, _بحال_, jniš,
   {{0x6aa933b3,0xddc4068b,0x653a02b5,0x661b1605}},	//   _lief, dniš, _מענד, lduk,
   {{0x44f90c1f,0x661933b4,0x1e9633b5,0x752212ad}},	//   lè_, _kawk, ерар, _zroz,
   {{0x661b33b6,0x6284002f,0x443c006f,0xb17b33b7}},	//   nduk, _ukio, _zov_, rgår,
   {{0x60cd018e,0xfce33066,0x44f902e9,0x6e3d001e}},	// [2aa0] _gwam, лото, nè_, _dosb,
   {{0x443c01a9,0x315702b5,0x7e7b00cb,0x7c3c33b8}},	//   _xov_, _ניין_, čupa, _qorr,
   {{0x7c3c33b9,0xb5fd0c99,0x6e3d33ba,0x201a012f}},	//   _vorr, ziša, _fosb, _iapi_,
   {{0x661b33bb,0x7ae33345,0xddc402c6,0x2bb21119}},	//   jduk, ánta, bniš, _जलवा,
   {{0x44f902e9,0x6aa90b0d,0x661b0273,0xdb1e00be}},	//   jè_, _dief, dduk, lapü,
   {{0x98a303fe,0x76491857,0xb5fd02a7,0x661b029c}},	//   гиче, ekey, viša, eduk,
   {{0x443c01a9,0x09e602ce,0x78a833bc,0x75221342}},	//   _rov_, _повн, _vidv, _sroz,
   {{0x752233bd,0x443c33be,0x661b043d,0x6aa9027a}},	//   _proz, _sov_, gduk, _gief,
   {{0x443c0189,0xc8ca0833,0x661933bf,0x7d1b0132}},	//   _pov_, _روان_, _dawk, _áust,
   {{0x60cd3069,0x61f60602,0x443c01e8,0x07a61958}},	//   _rwam, _acyl, _qov_, _зазн,
   {{0x443c33c0,0x2c02012f,0xcf120083,0xddc4008b}},	//   _vov_, र्यं_, হমুদ_, zniš,
   {{0xb5fd33c1,0x764933c2,0x75220453,0x201a08dd}},	//   lišn, ckey, _troz, _aapi_,
   {{0x81a900c8,0x443c33c3,0x3946006c,0x26190084}},	//   খুন_, _tov_, nyos_, _मोटी_,
   {{0xddc40500,0x201a33c4,0x20cd0bc6,0xc5690206}},	//   vniš, _capi_, rži_, _تحمل_,
   {{0x201a33c5,0xddd433c6,0x6e3d03bc,0x141b00a5}},	//   _dapi_, _šaša, _posb, _מוגב,
   {{0xddc433c7,0x6d1c0cf1,0x60cd33c8,0x9f5a0260}},	//   tniš, निंग_, _twam, _rapô_,
   {{0x30a7311e,0x313533c9,0x22ac00b8,0x60cd01d5}},	// [2ab0] _пров, _репр, _věku_, _uwam,
   {{0xddc433ca,0xbbcb0099,0x201a33cb,0xb5fd011c}},	//   rniš, िरेक, _gapi_, jišn,
   {{0xb5fd01cc,0xcfb60122,0xddc410ec,0x99f500d8}},	//   dišn, _בלתי_, sniš, вялі,
   {{0x44f902e9,0xddc403ab,0xd8380207,0x201a01b7}},	//   yè_, pniš, _miču_, _zapi_,
   {{0xca7433cc,0x3eab021d,0x201a33cd,0x8c3b02b1}},	//   دالغ, _iict_, _yapi_, _fußp,
   {{0x66e533ce,0x6bd418dd,0x44f90359,0xd9421309}},	//   вока, _متفر, vè_, реши,
   {{0x6aa901ae,0x79c9004f,0xf7730919,0x3946067f}},	//   _tief, _يوسف_, داش_, ayos_,
   {{0x44f902e9,0xb5fd01f2,0x7bd700ac,0x39460118}},	//   tè_, jnšt, laxu, byos_,
   {{0x764933cf,0x661b33d0,0x3a2d0183,0xb5fd00cd}},	//   rkey, rduk, _inep_, bišn,
   {{0x7bd700e2,0x2d8b0223,0x3a3f0009,0x44f90359}},	//   naxu, _myce_, _houp_, rè_,
   {{0x201a1581,0x3a3f02e9,0x44f902d0,0x35f533d1}},	//   _rapi_, _koup_, sè_, _апер,
   {{0x201a16ab,0x216a33d2,0x44f933d3,0x3ce933d4}},	//   _sapi_, дими_, pè_, krav_,
   {{0x2124004f,0x9f58008d,0x6486008a,0xb5fd00ac}},	//   ímh_, rfrí_, gðis, lišo,
   {{0x3a3f1f3c,0x3ce90124,0xb05b0ef0,0x00000000}},	//   _loup_, drav_, spän, --,
   {{0xfc3f0bc8,0xe1ff33d5,0x201a33d6,0x7bd701ed}},	//   _luís_, mión_, _vapi_, daxu,
   {{0xe1ff33d7,0x201a000e,0x3376011d,0x3dc9043d}},	//   lión_, _wapi_, _בעצם_, gbaw_,
   {{0x201a272d,0xbea333d8,0xada600d8,0x3eab0110}},	// [2ac0] _tapi_, ратк, таал, _dict_,
   {{0xe1ff33d9,0xf1a7051d,0x224001ed,0x3eab0027}},	//   nión_, _गणतन, _hoik_, _eict_,
   {{0xb5fd0254,0x3a3f0260,0x8fa610b4,0x3eab00fe}},	//   višn, _boup_, _јане, _fict_,
   {{0x3a3f02e1,0x752402c4,0xc332011d,0x9f580176}},	//   _coup_, _šizm, יוב_, mfrà_,
   {{0x99dd0107,0xc7b800cd,0x3ea033da,0xee3700af}},	//   _alňs, _lađe_, mmit_, _рня_,
   {{0xdb1c0332,0x3ea033db,0x515b00a5,0xb7d80037}},	//   _kerü, lmit_, וכנו, روبا_,
   {{0xb5fd33dc,0x7c2e33dd,0xc7b80254,0x2c02012f}},	//   rišn, _inbr, _nađe_, र्णं_,
   {{0xeb9715dd,0x692600af,0x9f581c5b,0x6486008d}},	//   _рис_, _имба, leró_, yðis,
   {{0xb5fd0496,0x00000000,0x00000000,0x00000000}},	//   mišl, --, --, --,
   {{0xe1ff33de,0x9f580453,0xb5fd01ba,0x3ea00031}},	//   gión_, neró_, bišo, hmit_,
   {{0x2252053e,0x3a3f0051,0xd70a0210,0x25bd0090}},	//   _blyk_, _youp_, _інде_, _ffwl_,
   {{0xdb1c33df,0x550633e0,0xacbb00f7,0x752d0009}},	//   _heró, _ачка, _brûl, _šaze,
   {{0x81cc0083,0xe1ff07a6,0x7c2e33e1,0x00000000}},	//   _লাখ_, bión_, _onbr, --,
   {{0xe1ff33e2,0x14d700c2,0x6486008a,0xdb1c33e3}},	//   ción_, _יודל_, rðis, _berü,
   {{0x9f5800de,0x00000000,0x00000000,0x00000000}},	//   deró_, --, --, --,
   {{0x5bcb175f,0x320f0332,0x7c2e33e4,0x442e2b2e}},	//   िर्व, _úgy_, _anbr, _hnf_,
   {{0x5c751d99,0xc7b80124,0xcc991d77,0x2bc40bdd}},	// [2ad0] глат, _zađe_, евац_, _ल्हा,
   {{0x7ae32b39,0x3a2d33e5,0x3a3f33e6,0x00000000}},	//   ánto, _snep_, _soup_, --,
   {{0x3ea00122,0x7bd70069,0xdb1c033b,0x201133e7}},	//   bmit_, raxu, _gerü, mezi_,
   {{0x201133e8,0x3ce902c6,0x3ce6219e,0x442e33e9}},	//   lezi_, prav_, šova_, _lnf_,
   {{0x26de33ea,0x9f581c5b,0x7c2e00fe,0x442e00f6}},	//   _avto_, beró_, _fnbr, _onf_,
   {{0xe1ff33eb,0x201133ec,0x81d90033,0x628f00d5}},	//   xión_, nezi_, ালি_, hlco,
   {{0x27e906d0,0x8aa733ed,0x9f580036,0xb5fd33ee}},	//   ğan_, _арад, lerò_, bišl,
   {{0x27e933ef,0x442e01a2,0x1dd31b8f,0xa91d01ba}},	//   şan_, _anf_, तरित, _lyži,
   {{0xe1ff20d9,0xe80033f0,0x2ba7022e,0x27170095}},	//   tión_, ल्हा_, _कृता, _mənə_,
   {{0x7bd533f1,0x69d933f2,0x3ea000da,0x628f0051}},	//   _jezu, lawe, zmit_, elco,
   {{0x7bd533f3,0x3246005f,0x9f5807e5,0x38b90176}},	//   _mezu, генг, herò_, _hèr_,
   {{0xe1ff1175,0x69d90657,0xddd6024e,0x442e0260}},	//   sión_, nawe, chyň, _enf_,
   {{0x1ae0021a,0x6486008d,0xe1ff1f51,0x00000000}},	//   _पट्ठ, rðir, pión_, --,
   {{0x201133f4,0x69d933f5,0x9f5807e5,0x628f33f6}},	//   gezi_, hawe, derò_, alco,
   {{0x37d80083,0x2d8f01ae,0x69d933f7,0x9f580453}},	//   _সামর, ügen_, kawe, veró_,
   {{0x69d933f8,0xdb050037,0xfbcd0033,0x22990c8e}},	//   jawe, hchó, _লাগত, téke_,
   {{0x3ea00897,0x61e433f9,0x7bd533fa,0x628633fb}},	// [2ae0] rmit_, _idil, _bezu, moko,
   {{0x09cc0d53,0x62860273,0xdb1c006c,0xa3e90026}},	//   ार्य, loko, _terü, यलट_,
   {{0x27230d6f,0xdb1c0392,0x7bd533fc,0x8cb00035}},	//   _nın_, _aerò, _dezu, _अंको,
   {{0x248533fd,0x69d933fe,0x9f410453,0x9f580036}},	//   holm_, gawe, _echó_, berò_,
   {{0xdb1c1111,0x9f5800de,0xb5fd0506,0x09e32d9c}},	//   _peró, peró_, rišl, сочн,
   {{0x628633ff,0x7bd53400,0xddcd0035,0x7d1600e9}},	//   hoko, _gezu, chał, mwys,
   {{0xeb970c06,0x62863401,0x69d93402,0xdb1c0300}},	//   _бир_, koko, bawe, _veró,
   {{0x61e43403,0x60c43404,0x62863405,0x20113406}},	//   _ndil, _otim, joko, zezi_,
   {{0x60c40010,0x6d5b0009,0x38b90176,0x54543407}},	//   _ntim, _žuaz, _gèr_, ивит,
   {{0xe6440644,0x59cc0577,0x6aa23408,0x98a60009}},	//   ılış, ारकर, lmof, _сизе,
   {{0x60c43409,0x4394340a,0x2011340b,0x6286340c}},	//   _atim, ранс, vezi_, foko,
   {{0x2011340d,0xe45209b9,0x6286340e,0x61e4009e}},	//   wezi_, _گفتگ, goko, _cdil,
   {{0x2011340f,0x61e4001e,0xb7b500e2,0x855700b5}},	//   tezi_, _ddil, _mạn, _میٹر_,
   {{0x61e43410,0x9f5807e5,0x27170095,0xf5930037}},	//   _edil, verò_, _sənə_, _الهج,
   {{0x20113411,0xda0402e4,0x62861321,0xa91d0334}},	//   rezi_, रभात_, boko, _vyži,
   {{0x2449003e,0x9f58027a,0x20113412,0x7bd53413}},	//   _rúmi_, terò_, sezi_, _sezu,
   {{0xdb0501ae,0x3209010d,0x16d10af9,0xe6d10461}},	// [2af0] schü, _ibay_, _सब्ब, _सब्ज,
   {{0x69c03414,0x69d93415,0x9f5807e5,0x7642073a}},	//   _afme, wawe, rerò_, _looy,
   {{0x7bd53416,0x69d91ce2,0x8af91578,0x5b153417}},	//   _vezu, tawe, тнес_, рмет,
   {{0x7f3a02b5,0xd011006c,0x38b90107,0x7d1600e9}},	//   _סערו, _الگ_, _pèr_, bwys,
   {{0x80a402fd,0x65ab013b,0xe0df3418,0x67283419}},	//   _خمین, _möhü, nsò_, _ardj,
   {{0xe8001cce,0xb346027d,0x6286341a,0x98a503d0}},	//   ल्ला_, _kaçı, zoko, шиле,
   {{0xe739341b,0x76420b88,0x6286341c,0xdb050079}},	//   тей_, _booy, yoko, rchó,
   {{0x8aa40f23,0x2129341d,0xb5fd010b,0xb346027d}},	//   _груд, _orah_, mišk, _maçı,
   {{0xb5fd341e,0xf1c800b8,0x76420bf7,0xdb1c008d}},	//   lišk, ndář_, _dooy, _herð,
   {{0x320908dd,0x999f2e37,0x6286341f,0x290d0183}},	//   _abay_, _kluž_, woko, _ipea_,
   {{0x62863420,0x21291034,0xb5fd341e,0xe29a03fa}},	//   toko, _arah_, nišk, као_,
   {{0x21290088,0x543501df,0x00000000,0x00000000}},	//   _brah_, ارکر, --, --,
   {{0x161e3421,0x212900e0,0x2d8f033b,0xe44e0217}},	//   _मोटर_, _crah_, ügel_, _дж_,
   {{0x03a53422,0x9f58008a,0x25bf3423,0x53a50036}},	//   _кило, ferð_, lcul_, _калб,
   {{0x9f58008a,0x62863424,0x8fa63425,0xb5fd02a7}},	//   gerð_, poko, раве, jišk,
   {{0x25bf0388,0xb5fd3426,0x13da0083,0x64433427}},	//   ncul_, dišk, _দায়, _honi,
   {{0x64433428,0x21290a18,0x60c41b68,0xc7b8011c}},	// [2b00] _koni, _grah_, _utim, _lađa_,
   {{0x64433429,0x7d160173,0x25a0009e,0x00000000}},	//   _joni, rwys, _ùile_, --,
   {{0x6443342a,0x290d099e,0xb5fd00d8,0xe9da1c36}},	//   _moni, _apea_, gišk, вке_,
   {{0x644301ef,0x628700cb,0xa91d00d5,0x539a011d}},	//   _loni, čkog, _lyžu, דיעו,
   {{0x2ba702e4,0xd3780254,0x764203bc,0x82770070}},	//   केबा, maće_, _rooy, סענע_,
   {{0xdb1c00fb,0x6aa2342b,0x9866006c,0xb5fd342c}},	//   _ferð, smof, جیئے_, bišk,
   {{0xd6d7342d,0xdb1c00fb,0x290d06a2,0x00000000}},	//   аты_, _gerð, _epea_, --,
   {{0x7e7601a2,0x9634342e,0xd01f0083,0x960a010b}},	//   nnyp, сниц, দায়_, тэка_,
   {{0xd49a25ef,0xd90e0df3,0x993400b5,0xdb0e0a8a}},	//   кро_, _آیت_, _دہشت, _afbø,
   {{0x656f342f,0x3209010d,0x64433430,0x66e602ee}},	//   úcha, _sbay_, _coni, _вожа,
   {{0x0bb70052,0x64433431,0x6f09004e,0xc5e80083}},	//   ילים_, _doni, łecz, ক্ষা_,
   {{0x212903c9,0xd378042a,0x326702d6,0x99dd00d5}},	//   _prah_, jaće_, ртов, _koňa,
   {{0xdfdb0133,0xc6930122,0xd37800cb,0x64433432}},	//   къв_, _ואף_, daće_, _foni,
   {{0xe0df0036,0xd48f01e0,0x21290097,0x916900cc}},	//   rsò_, _єр_, _vrah_, _vừa_,
   {{0x09d70083,0xe0df3433,0x8cb0007c,0xb34600a8}},	//   _হাসা, ssò_, _अंजो, _qaçı,
   {{0xb5fd00d8,0x877b0070,0x3209010d,0x443e01ff}},	//   višk, דאלי, _ubay_, ljt_,
   {{0x644301d1,0x656d01ba,0x2d8f01b4,0xdbd10093}},	// [2b10] _yoni, _ľahk, æge_, _býðu,
   {{0xa80200a8,0x64433434,0xb5fd00d8,0x270e0095}},	//   çıla, _xoni, tišk, _kənd_,
   {{0xf2d30070,0xd3780009,0x95ff0033,0xe3b80448}},	//   ַעס_, baće_, ্যতম_, ydın_,
   {{0xdb1c064b,0xb5fd3435,0xc7b80254,0x270e00a8}},	//   _verð, rišk, _rađa_, _zəng_,
   {{0x645a046a,0x634a01c2,0xb5fd00d8,0x628d3436}},	//   khti, lənd, sišk, _mkao,
   {{0x89341062,0xb5fd0f27,0x1ed80416,0x60c201ef}},	//   تعما, miši, _حبیب_, _éome,
   {{0x81e200c8,0x6d4d3437,0x644327ba,0xb5fd0944}},	//   ন্ট_, lyaa, _roni, liši,
   {{0x64433438,0x80b800c8,0xe6192611,0xceb400a5}},	//   _soni, _অবস্, уди_, חיק_,
   {{0x6443263f,0x6d4d3439,0x25bf002d,0xb5fd343a}},	//   _poni, nyaa, rcul_, niši,
   {{0x6d4d0103,0x25bf343b,0x628d343c,0x645a343d}},	//   iyaa, scul_, _akao, ghti,
   {{0xd7950082,0x6443343e,0x7e6d0468,0xe1ff006c}},	//   _الاخ, _voni, kiap, ciók_,
   {{0xc049343f,0x425628a1,0x64433440,0x22993441}},	//   _אז_, стот, _woni, téka_,
   {{0xd378011c,0x64433442,0x2ba70099,0xc299002d}},	//   vaće_, _toni, केता, ртэц_,
   {{0x645a3443,0x10a60043,0xb5fd0cc2,0x6d4d0118}},	//   chti, сигн, diši, dyaa,
   {{0xd3780129,0x9345002d,0x00000000,0x00000000}},	//   taće_, _ынке, --, --,
   {{0x765b3444,0x7e6d3445,0x6d4d034d,0x00000000}},	//   nhuy, giap, fyaa, --,
   {{0x6da32526,0x6d4d3446,0xd378011c,0x799b1766}},	// [2b20] зита, gyaa, raće_, _nzuw,
   {{0x3ce02837,0xd3780c99,0xb0b50067,0xae0a00ab}},	//   rsiv_, saće_, ंदरग, _हउवन_,
   {{0x3ce03447,0x6d4d0034,0xff26174b,0xd3780124}},	//   ssiv_, ayaa, _умно, paće_,
   {{0x6d4d073a,0xeb971470,0xddcd0043,0xb5fd0c6e}},	//   byaa, щих_, rnaţ, biši,
   {{0xdd922499,0x2d8400f7,0x645a00c3,0x00000000}},	//   _روس_, _âme_, yhti, --,
   {{0x6e243448,0xb9000066,0x99dd0097,0x13af0033}},	//   ldib, _दब_, _voňa, চুয়,
   {{0x09d70083,0x2ba70fbf,0x6b633449,0x3952010b}},	//   _হারা, केदा, _екра, šys_,
   {{0x6e24344a,0xceb30122,0x645d00da,0xdb1c013c}},	//   ndib, היה_, ësin, _berö,
   {{0x7d04344b,0xb05b00c3,0x3eba125e,0x645a01e9}},	//   ntis, späi, _lupt_, thti,
   {{0x7bde2883,0x634a01c2,0x7d04344c,0x14b7004f}},	//   napu, yənd, itis, حديث_,
   {{0x80b20026,0x7d04344d,0x9f4500d0,0x539800d4}},	//   _इंजे, htis, ülü_, рвня_,
   {{0x645a01d2,0x7bde344e,0x7d042172,0x7ae327c2}},	//   shti, hapu, ktis, ánti,
   {{0x7bde05c8,0x68e2344f,0x6e243450,0xe3b8033e}},	//   kapu, nsod, ddib, ldım_,
   {{0x80b80083,0x634a0095,0x7bde2930,0xb5fd343a}},	//   _অবশ্, tənd, japu, viši,
   {{0x7bde3451,0x6fda00ab,0x7e6d3452,0xe3b8033e}},	//   dapu, _बजरं, tiap, ndım_,
   {{0xdceb3453,0x7d043454,0x3d140006,0x6e240008}},	//   žičk, ftis, _नईखे_, gdib,
   {{0x7d043455,0x69c23456,0x09d70831,0x00000000}},	// [2b30] gtis, dcoe, _হালা, --,
   {{0x7e6d3457,0xb5fd1ada,0x7bde3458,0x00000000}},	//   siap, riši, gapu, --,
   {{0xb5fd0129,0x7d043459,0x6e240cca,0x6d4d327c}},	//   mišv, atis, bdib, syaa,
   {{0xb5fd03ab,0x02fb016b,0x00000000,0x00000000}},	//   piši, רלאמ, --, --,
   {{0x64580083,0xab620092,0x7d04345a,0xe9d801c8}},	//   _olvi, _çünk, ctis, скі_,
   {{0xe9d90067,0x00000000,0x00000000,0x00000000}},	//   _weź_, --, --, --,
   {{0x07a211ca,0x70b50035,0x765b00e2,0x00000000}},	//   машн, ंदुल, thuy, --,
   {{0x245b1010,0x656f345b,0x79960067,0xb658010b}},	//   _même_, úcho, żywa, йшых_,
   {{0x1fa60761,0xe45916fb,0x69db00e9,0x81bf0033}},	//   _खण्ड, ижи_, _ieue, ইরা_,
   {{0xdb1c345c,0x69db345d,0x291f008c,0x99dd07c0}},	//   _verö, _heue, _isua_, _koňo,
   {{0x2c0b018d,0x7c251a07,0xf8ae0088,0xddcd023a}},	//   स्यं_, idhr, _شکه_, znaš,
   {{0x7d040093,0x7de6006c,0xdb1c027d,0x3eba00af}},	//   ytis, _késő, _terö, _rupt_,
   {{0x7bde0e89,0x3eba345e,0x69db01f7,0xe82001c0}},	//   yapu, _supt_, _meue, _यसमा_,
   {{0x9f580248,0x69db053e,0xdb050132,0x68e40079}},	//   lgré_, _leue, lchõ, áidi,
   {{0xe29a345f,0x75293460,0x1faa172a,0x7bde136b}},	//   _как_, lvez, ркви_, vapu,
   {{0x69db02bf,0xe1ff0035,0x7d0404d5,0x7bde3461}},	//   _neue, diów_, ttis, wapu,
   {{0x7bde3462,0x7d043463,0x1c463464,0x6e243465}},	// [2b40] tapu, utis, онам, rdib,
   {{0x76590297,0x212000bf,0xddcd0124,0x8b963466}},	//   _llwy, _isih_, rnaš, ореч,
   {{0x69db3467,0x9f0601b2,0x3bd500c3,0xa3da0066}},	//   _beue, _بوجو, яютс, ़रत_,
   {{0x201808a1,0x634a00a8,0x7c353468,0x7ff602fd}},	//   leri_, lənc, _enzr, _اسکا,
   {{0xdca616e2,0x69db3469,0xcaa5004f,0x7bde346a}},	//   _мами, _deue, أصلي, papu,
   {{0x2018346b,0xab2a24c8,0x7529006c,0x7659346c}},	//   neri_, _кога_, dvez, _alwy,
   {{0xf8bf04ce,0x69db01ae,0x7bdc346d,0x7659001e}},	//   _één_, _feue, _ieru, _blwy,
   {{0x7bdc346e,0xe3b80d6f,0x20181c69,0x765900e9}},	//   _heru, rdım_, heri_, _clwy,
   {{0x7bdc346f,0x20180a9c,0xd378012e,0xdb210421}},	//   _keru, keri_, daća_, ätös,
   {{0xddc42d5b,0x20183470,0x344a3471,0x3a24008c}},	//   jniž, jeri_, рчин_, _hamp_,
   {{0x7bdc203f,0x20183472,0x752905f5,0x76590297}},	//   _meru, deri_, avez, _flwy,
   {{0xbddb1f3c,0x6abc300e,0x7bdc3473,0x752908b7}},	//   _poèm, _murf, _leru, bvez,
   {{0xe3af006c,0x29063474,0xddcd00b8,0xdb150359}},	//   ٹری_, ntoa_, chař, _egzè,
   {{0x20183475,0xe3af006c,0x270e0095,0xfdd33010}},	//   geri_, عری_, _gənc_, तर्फ,
   {{0xcddb04bf,0x6abc00d7,0x212000e0,0x04200033}},	//   иња_, _nurf, _esih_, বাদী_,
   {{0x7bdc3476,0xb3bc0033,0x29060065,0x00000000}},	//   _aeru, _আজিজ, ktoa_, --,
   {{0x7bdc3477,0x20183478,0xb5fd00cb,0x386c0a8a}},	// [2b50] _beru, beri_, mišt, _omdr_,
   {{0xb5fd3479,0x2018347a,0x69db0310,0x7bdc347b}},	//   lišt, ceri_, _seue, _ceru,
   {{0x7bdc347c,0x7529347d,0x200100e9,0x6abc0079}},	//   _deru, zvez, _ichi_, _curf,
   {{0xb5fd1367,0x61fd10dd,0x81d90033,0x6abc347e}},	//   ništ, ngsl, ালক_, _durf,
   {{0x3ea903ad,0x7bdc347f,0x61fd0312,0xcfab02fd}},	//   mmat_, _feru, igsl, _حاکم_,
   {{0x7bdc2069,0x3ea93480,0xeafb042c,0xb5fd008b}},	//   _geru, lmat_, _پرست_, hišt,
   {{0x7bc515b4,0x69db3481,0x645d0031,0x7d19027b}},	//   mchu, _teue, ësim, şası,
   {{0xe9df064b,0xb5fd0956,0x20183482,0x7bdc3483}},	//   _þú_, jišt, zeri_, _zeru,
   {{0xb5fd3479,0x7bdc3484,0xd3783485,0x20183486}},	//   dišt, _yeru, vaća_, yeri_,
   {{0x200119c6,0x75290332,0x7bc53487,0xfdb80026}},	//   _nchi_, rvez, nchu, _अल्फ,
   {{0x7ae501f4,0x3ea92b63,0x7bc53488,0xd37802c4}},	//   nsht, kmat_, ichu, taća_,
   {{0x7bc50874,0x20182ed0,0x2c0b022e,0x3ce60097}},	//   hchu, weri_, स्तं_, šovi_,
   {{0x20183489,0x3ea91d11,0x55ba00a5,0xd378011c}},	//   teri_, dmat_, _המנו, raća_,
   {{0x7bc500ac,0xb5fd02c4,0x2ef800f6,0x394000c3}},	//   jchu, rišu, turf_, äisi_,
   {{0x437500c2,0x7bdc0feb,0x2018348a,0x634a00a8}},	//   _מײַן_, _reru, reri_, rənc,
   {{0x7bdc06b3,0x32190865,0x20010036,0xf1bf0138}},	//   _seru, cesy_, _echi_, ldán_,
   {{0x7bdc348b,0x2018348c,0x6abc348d,0xdd920957}},	// [2b60] _peru, peri_, _surf, روط_,
   {{0x8fa60c0d,0x201801f4,0xee3f07c0,0x68f90051}},	//   _напе, qeri_, _chýb_, duwd,
   {{0x7bdc348e,0x3a240159,0x68f901e4,0x501b00a5}},	//   _veru, _pamp_, euwd, _פוטו,
   {{0x7bdc348f,0xfc3f01dd,0xda65017e,0x290600c3}},	//   _weru, _xuíz_, واني, ttoa_,
   {{0x7bdc3490,0x29063491,0x6abc02b1,0x00000000}},	//   _teru, utoa_, _wurf, --,
   {{0x3a240088,0x6e260dc3,0xb5fd1321,0x7c5a0037}},	//   _wamp_, _hakb, zišt, _السر_,
   {{0x6e263492,0x29063493,0x98a40139,0xdc37016b}},	//   _kakb, stoa_, _armă_, _צאלט_,
   {{0xb8660a86,0xa5343494,0x6e260035,0x4b7b00a5}},	//   _کارو, днич, _jakb, _האלו,
   {{0xb5fd0672,0x5fbe0355,0xfc3f0138,0x04200033}},	//   višt, ्डाल, _ruíz_, বাসী_,
   {{0x3ea93495,0xe9ff00e2,0x6e263496,0x00000000}},	//   zmat_, _toản_, _lakb, --,
   {{0xb5fd0956,0x04fe0083,0xe9ff00e2,0x3ea93497}},	//   tišt, ্টের_, _hoạn_, ymat_,
   {{0x20011c2c,0x76bb00a5,0x3ea91505,0xf1bf0098}},	//   _schi_, _המאפ, xmat_, adán_,
   {{0xb5fd01cc,0x32191298,0x61fd3498,0x7bc5055c}},	//   rišt, resy_, rgsl, ychu,
   {{0x75223499,0xb5fd0207,0x04200033,0x00000000}},	//   _isoz, sišt, বাহী_, --,
   {{0xb5fd01c0,0xe9ff0019,0x9f3401e0,0x6e26349a}},	//   pišt, _loạn_, нері, _bakb,
   {{0x5f9400d4,0x5eb40a71,0x644a349b,0x7bc500e5}},	//   хист, ейст, _hofi, wchu,
   {{0x628f016f,0x644a002f,0x6e26349c,0xd8380107}},	// [2b70] moco, _kofi, _dakb, _onč_,
   {{0x5ba706a6,0x628f349d,0x200104be,0x09d50e61}},	//   през, loco, _uchi_, दर्य,
   {{0x7bc5349e,0xa134042c,0xe7a500ea,0x00000000}},	//   rchu, _قریش, ādīš, --,
   {{0x7bc5349f,0x7ae500da,0xe1ff34a0,0x6e260024}},	//   schu, rsht, ngó_, _gakb,
   {{0xa95402ce,0x08c40044,0xa3df0127,0x61ed237c}},	//   нкці, ебін, तरम_, _mdal,
   {{0xf77001ca,0x644a34a1,0x60cd0054,0x7ae50031}},	//   گاه_, _nofi, _mtam, psht,
   {{0x16a934a2,0x61ed34a3,0x628f0a04,0xab9500d4}},	//   овки_, _odal, koco, _циві,
   {{0x61ed34a4,0x60cd34a5,0x7c273455,0xe81f018d}},	//   _ndal, _otam, _hajr, _मघवा_,
   {{0x68e4004f,0x644a01f7,0x60cd01d0,0x628f0d9b}},	//   áidt, _bofi, _ntam, doco,
   {{0x61ed1760,0x644a001e,0x7c270069,0x55ff0033}},	//   _adal, _cofi, _jajr, ্যেক_,
   {{0x60cd288d,0x644a34a6,0x588401c8,0x672100cd}},	//   _atam, _dofi, _чыта, _uslj,
   {{0xd7f80139,0x00000000,0x00000000,0x00000000}},	//   _umăr_, --, --, --,
   {{0x2bfe0299,0x61ed34a7,0x160602e4,0x644a34a8}},	//   _लालू_, _ddal, _वॉटर_, _fofi,
   {{0x764b34a9,0x60cd34aa,0x644a00e9,0x61ed34ab}},	//   _hogy, _dtam, _gofi, _edal,
   {{0x442734ac,0x60cd34ad,0x764b012f,0x92e8004f}},	//   _ian_, _etam, _kogy, _فريق_,
   {{0x442734ae,0x68e90009,0x661b34af,0x764b08eb}},	//   _han_, _oved, neuk, _jogy,
   {{0x44270d51,0xfce30086,0x3cf5004e,0x7c2734b0}},	// [2b80] _kan_, кото, एंगे_, _bajr,
   {{0x44270122,0x61ed2f3f,0xb05b34b1,0xe1ff0098}},	//   _jan_, _zdal, spär, thóg_,
   {{0x442734b2,0x6fd406bb,0xe9ff01a5,0xe1ff34b3}},	//   _man_, _ब्यू, _soạn_, ciós_,
   {{0x442734b4,0xe1ff004e,0x7c2701a3,0x62980183}},	//   _lan_, chód_, _eajr, _êxod,
   {{0x44270023,0x09e334b5,0xe3e30083,0x7c270207}},	//   _oan_, точн, _মানব, _fajr,
   {{0x442734b6,0xb8e6018d,0x00000000,0x00000000}},	//   _nan_, _ईं_, --, --,
   {{0x69c9018e,0x644a34b7,0x628f34b8,0x7522030d}},	//   _ffee, _rofi, yoco, _ssoz,
   {{0x442734b9,0x661b0054,0x7c270067,0x764b00e5}},	//   _aan_, geuk, _zajr, _cogy,
   {{0x442734ba,0xe7cf09b8,0xd7cf2afe,0x628f34bb}},	//   _ban_, _स्वप, _स्वच, voco,
   {{0x442701f3,0x00000000,0x00000000,0x00000000}},	//   _can_, --, --, --,
   {{0x442734bc,0x60cd34bd,0x764b006c,0x68e9156f}},	//   _dan_, _stam, _fogy, _zved,
   {{0x44272543,0xc7b8011c,0x925800c3,0x667600fd}},	//   _ean_, _nađi_, дают_, _غدار,
   {{0x442734be,0xe1ff34bf,0xe80534c0,0x644a013b}},	//   _fan_, rgó_, _रामा_, _tofi,
   {{0x442734c1,0xa3df0567,0xd4c50037,0x00000000}},	//   _gan_, तरण_, _أغني, --,
   {{0x764b34c2,0x3f8534c3,0x00000000,0x00000000}},	//   _yogy, çlu_, --, --,
   {{0x61ed34c4,0x442734c5,0x13e30083,0x2cb8184f}},	//   _udal, _zan_, _মায়, _aird_,
   {{0x6e942252,0x442734c6,0x60cd34c7,0xe1ff0035}},	// [2b90] титу, _yan_, _utam, biór_,
   {{0x69c928e9,0x442734c8,0x4cc80033,0x229900b5}},	//   _sfee, _xan_, _লিখু, déki_,
   {{0x68e934c9,0x634a00a8,0x2ef400af,0xe945132d}},	//   _sved, zənn, _изэр, کرای,
   {{0x5ba4002d,0xdd910d93,0xdb0e00fd,0x37d80831}},	//   труз, _موج_, áján, _সাগর,
   {{0x7c2734ca,0xe6ed016f,0xcce7004f,0x00000000}},	//   _tajr, _väčš, _تسجي, --,
   {{0x07a51c2e,0xa15800a5,0x661b012f,0x00000000}},	//   налн, ובדה_, weuk, --,
   {{0x442734cb,0x661b012f,0x3eb934cc,0x2bae0803}},	//   _ran_, teuk, _kist_, झेदा,
   {{0x442734cd,0x5a341906,0xd0280033,0x2d9900c3}},	//   _san_, _инст, মায়_, _kyse_,
   {{0x68e934ce,0x3eb934cf,0xe5790086,0xeab001b2}},	//   _uved, _mist_, язи_, _ضعف_,
   {{0x3eb934d0,0x98ad02c4,0x442734d1,0x2d9934d2}},	//   _list_, _kreč_, _qan_, _myse_,
   {{0x442734d3,0xe29a34d4,0x3eb908dd,0x2d990249}},	//   _van_, зан_, _oist_, _lyse_,
   {{0x442734d5,0x80d40033,0x00000000,0x00000000}},	//   _wan_, _তিব্, --, --,
   {{0xdb1c022a,0x442714bc,0x634a00a8,0x00000000}},	//   _ifrå, _tan_, lənl, --,
   {{0x44270608,0x3eb9009e,0x98ad0207,0x6d40009e}},	//   _uan_, _aist_, _oreč_, _àmai,
   {{0x3eb902c9,0x66c7027d,0xa0a306d8,0x32290421}},	//   _bist_, _yıka, уард, ötyä_,
   {{0x3eb934d6,0x2d9934d7,0x00000000,0x00000000}},	//   _cist_, _byse_, --, --,
   {{0x61e634d8,0x0d8600af,0x626b00b8,0x6e9334d9}},	// [2ba0] makl, хлан, třov, القا,
   {{0x61e634da,0xa3df193c,0x3eb90223,0x4f2634db}},	//   lakl, तरि_, _eist_, _здоб,
   {{0x09d700c8,0xb3460279,0x20c60019,0x2d8f02b1}},	//   _হাজা, maçõ, _hôi_, üger_,
   {{0x2cb80446,0xb3460370,0x61e634dc,0x88e60c46}},	//   _wird_, laçõ, nakl, ежде,
   {{0xa3df0084,0xb4de007c,0x2d99008c,0x00000000}},	//   तरा_, _तबे_, _gyse_, --,
   {{0x20c601a5,0xd6da058f,0xeee700bf,0x69d00026}},	//   _môi_, пти_, _تغیی, _ड्री,
   {{0xf0930100,0x8ba30421,0x20c60019,0x61e634dd}},	//   אנג_, _бирж, _lôi_, kakl,
   {{0x9634010c,0x7e6434de,0x62840207,0x35461fff}},	//   тниц, nhip, _njio, ехов,
   {{0x61e62cf4,0x6d4428ab,0x06e000b4,0x20c60023}},	//   dakl, nxia, _गौरव_, _nôi_,
   {{0x54540cac,0x6d56028b,0x629634df,0x62870612}},	//   твот, iyya, _akyo, čkom,
   {{0xb3460279,0xd25111c0,0x61e634e0,0x66c70225}},	//   daçõ, لند_, fakl, _tıka,
   {{0xa75b00a5,0x20c60023,0x634a00a8,0xbddb0107}},	//   _מדבר, _bôi_, səno, _inèg,
   {{0x518434e1,0x7e641872,0x225903d0,0xc68f00b5}},	//   гура, dhip, rksk_, _اِن_,
   {{0xb34634e2,0x634a0095,0x7afe34e3,0x3eb91281}},	//   gaçõ, lənm, kupt, _sist_,
   {{0x5f95021d,0x61f401ff,0x2d990345,0x78ba02b1}},	//   тивт, ådlö, _syse_, _mitv,
   {{0x61e601d6,0x78ba34e4,0x7e64010d,0x439b00a5}},	//   cakl, _litv, ghip, _מבוג,
   {{0x3eb934e5,0x442c001e,0x3f9e0093,0x4f5800b5}},	// [2bb0] _vist_, odd_, ýtur_, وجہد_,
   {{0x645a34e6,0xb3460370,0xe8051b8f,0x3eb90120}},	//   nkti, caçõ, _राधा_, _wist_,
   {{0x442c311f,0x7c941c2d,0x7afe34e7,0x2d99053e}},	//   idd_, اشقا, gupt, _wyse_,
   {{0x7c3c0176,0x443c0223,0x78ba004b,0x200334e8}},	//   _enrr, _lnv_, _aitv, lgji_,
   {{0x6e3d01ae,0x26de34e9,0x20c60023,0x78ba0355}},	//   _insb, _awto_, _xôi_, _bitv,
   {{0xa3bc27c6,0x6e2d003e,0x7d0d34ea,0x200334eb}},	//   _अलग_, ldab, mtas, ngji_,
   {{0x7d0d34ec,0xddcd002d,0x81e70033,0xba770079}},	//   ltas, ciaţ, _পান_, _كارت,
   {{0x442c0297,0xb3460370,0x443c34ed,0x99d70098}},	//   edd_, zaçõ, _anv_, _سترا,
   {{0x7d0d190f,0x12bd0083,0xc4850ebb,0x28dd0066}},	//   ntas, _আবেদ, клик, नीशि,
   {{0x443c34ee,0x69d902b1,0x00000000,0x00000000}},	//   _cnv_, lbwe, --, --,
   {{0x61e634ef,0x7d0d34f0,0x20c60019,0xb3460279}},	//   takl, htas, _sôi_, vaçõ,
   {{0x27e734f1,0x7d0d34f2,0x443c34f3,0x442c001e}},	//   lann_, ktas, _env_, add_,
   {{0x6e2d2d1a,0xb3460370,0x61e634f4,0x443c34f5}},	//   ddab, taçõ, rakl, _fnv_,
   {{0x27e70082,0x6e3d34f6,0x2335021d,0x7d0d01b4}},	//   nann_, _ansb, _ахир, dtas,
   {{0xb3460370,0xafe32ad7,0xdee30e05,0x7d0d0036}},	//   raçõ, росл, иори, etas,
   {{0x20c600e8,0x27e734f7,0xdcf434f8,0x6d4406a2}},	//   _tôi_, hann_, žačk, txia,
   {{0xdbdf0093,0x6e3d34f9,0x7e64012f,0x7d0d34fa}},	// [2bc0] tíði, _dnsb, rhip, gtas,
   {{0x61e42395,0xe3b80716,0x3f9a1298,0x27e734fb}},	//   _heil, mdır_, _typu_, jann_,
   {{0xbddb34fc,0x61e434fd,0xe3b8037a,0x09e634fe}},	//   _poèt, _keil, ldır_, воен,
   {{0x6aa934ff,0x7afe3500,0x60c4000e,0x6abb13fb}},	//   _chef, rupt, _kuim, _ciuf,
   {{0x442c1973,0x61e43501,0x7d0d3502,0xe3b80463}},	//   ydd_, _meil, ctas, ndır_,
   {{0x27e73503,0xcee91c0c,0x61e43504,0x60c43505}},	//   gann_, _ترین_, _leil, _muim,
   {{0x8a06087b,0xb8c900ab,0xa7fc00d0,0x60c40079}},	//   _изве, _गी_, _alıc, _luim,
   {{0xfaa6216f,0x61e43506,0x442c0297,0x6abb027a}},	//   _рабо, _neil, wdd_, _giuf,
   {{0x27e73507,0x47e10083,0x09060798,0xd3780254}},	//   bann_, _নারী, _шпан, maći_,
   {{0x78ba0a45,0x6b9c3508,0xdb1c0248,0x27e70315}},	//   _uitv, _kyrg, _agré, cann_,
   {{0x442c02c7,0x7d0d3509,0x2c140026,0xa2790200}},	//   rdd_, ztas, न्यू_, ебну_,
   {{0xd37803fd,0x7d0d350a,0x443c0107,0x7ae3350b}},	//   naći_, ytas, _wnv_, ânti,
   {{0x60c41093,0x61e4350c,0x443c350d,0xd251006c}},	//   _cuim, _deil, _tnv_, لنگ_,
   {{0xa2ca02e4,0x2bfe114e,0x645d01f4,0xe5a3350e}},	//   _संप्, _लागू_, ësit, _тичи,
   {{0x61e4350f,0x200301f4,0x260f0f3d,0x3ce8046c}},	//   _feil, rgji_, थ्वी_, _चौबे_,
   {{0x68ed0274,0x7d0d09bd,0x61e43510,0x60c43511}},	//   šadi, ttas, _geil, _fuim,
   {{0x60c43512,0x27e71a22,0x16df14ab,0x7d0d3513}},	// [2bd0] _guim, yann_, _नब्ब, utas,
   {{0x7d0d3514,0x6aa93515,0xbbdd02e4,0x61e43516}},	//   rtas, _shef, यरेक, _zeil,
   {{0x7d0d3517,0xddc6004e,0x27e73518,0xda3500d8}},	//   stas, _dokł, vann_, лежы,
   {{0x27e73519,0xa2ca0127,0x6b9c0523,0x99d40c74}},	//   wann_, _संन्, _dyrg, لتها,
   {{0x69cb02c4,0xe9d800d8,0x27e7351a,0xee3f01ba}},	//   rcge, ткі_, tann_, _iný_,
   {{0xfa230083,0x6b9c351b,0x00000000,0x00000000}},	//   ফাইল_, _fyrg, --, --,
   {{0x27e7351c,0x12bd0083,0xe3b8008f,0x6aa904d5}},	//   rann_, _আব্দ, zdır_, _thef,
   {{0x27e7351d,0xddcd0080,0x060901af,0x9980351e}},	//   sann_, skaņ, хник_, žiš_,
   {{0x61e423ea,0xe6160c28,0x27e7351f,0x3a3f011e}},	//   _reil, уды_, pann_, _inup_,
   {{0x60c40244,0xe3e30083,0x61e43520,0x765b011e}},	//   _ruim, _মাহব, _seil, skuy,
   {{0x60c43521,0x91e61edd,0x656900b5,0x21291872}},	//   _suim, лоне, szeh, _asah_,
   {{0xe3b8013b,0x00000000,0x00000000,0x00000000}},	//   tdır_, --, --, --,
   {{0x61e43522,0x645d01d2,0x27e50009,0x00000000}},	//   _veil, ësis, _keln_, --,
   {{0xe3b80d6f,0x26c5113f,0x61e43523,0x99dd0184}},	//   rdır_, _kulo_, _weil, _koňs,
   {{0x61e43524,0x212900d7,0x26c500ee,0x99750067}},	//   _teil, _esah_, _julo_, nęło_,
   {{0xa2063525,0x6fd402b4,0x26c53526,0x60c43527}},	//   _спид, _ब्रू, _mulo_, _tuim,
   {{0x0eb9086c,0x4c862590,0x22400359,0xe3b80095}},	// [2be0] туры_, глав, _inik_, qdır_,
   {{0x6b9c03d0,0x00000000,0x00000000,0x00000000}},	//   _pyrg, --, --, --,
   {{0xd378011c,0x22400a81,0xfaa630ba,0xaae60079}},	//   taći_, _knik_, гажо, اسطو,
   {{0x3a2d0176,0x1efb0070,0x3ce8035d,0x2cb000c7}},	//   _caep_, _אלטע, _चौथे_, _žodį_,
   {{0xf99202e7,0xed570340,0xd37800cd,0xa2ca143a}},	//   حبا_, _боя_, raći_, _संभ्,
   {{0x3ea03528,0x66c70723,0xf7720332,0x26c5012f}},	//   llit_, _tıkl, یاں_, _bulo_,
   {{0x26c53529,0xb8eb051d,0xd378025c,0x224001b7}},	//   _culo_, _रू_, paći_, _onik_,
   {{0x7c2e0033,0x3ea00093,0x26c50dc3,0x09de0033}},	//   _habr, nlit_, _dulo_, _ডাকা,
   {{0xca75010b,0x634a01c2,0x7c2e352a,0x270e0095}},	//   _туры, məni, _kabr, _məni_,
   {{0x634a0095,0x2240352b,0x24520395,0x6fd40127}},	//   ləni, _anik_, _câmp_, _ब्लू,
   {{0x36061dbf,0x3ea0352c,0x26c5352d,0x0eb40099}},	//   _مواف, klit_, _gulo_, ंगाड,
   {{0x21b500d4,0xdbdf0093,0xa29512ea,0x645d0055}},	//   ийня, _líðu, рамі, ësir,
   {{0x667b02b5,0x463b0070,0x26c501a3,0x3ea0352e}},	//   _אטאק, _רעדע, _zulo_, dlit_,
   {{0x7c2e1942,0xa3df022e,0xe1ff0d2e,0x3e6700ab}},	//   _nabr, तरः_, chón_, _mõte_,
   {{0xe7f70387,0x634a0095,0x442e013c,0x316b2200}},	//   ीलता_, kəni, _iaf_, szcz_,
   {{0x2bdd012f,0x3ea0352f,0x442e00e9,0x7c2e0159}},	//   यर्थ, glit_, _haf_, _aabr,
   {{0x3cee006a,0x634a01c2,0x5c751ca9,0xbddb0310}},	// [2bf0] ेंगे_, dəni, алат, _anèc,
   {{0x442e3530,0x3ea03531,0x9f430355,0x3a3f3532}},	//   _jaf_, alit_, lají_, _snup_,
   {{0x2baa02cb,0xfbd01c64,0x3ea03533,0xb09c0070}},	//   _करणा, ستل_, blit_, _איזר,
   {{0x442e337c,0x7c2e009e,0x9f430355,0x00000000}},	//   _laf_, _eabr, nají_, --,
   {{0xd378011c,0xd9453534,0x00000000,0x00000000}},	//   maću_, рели, --, --,
   {{0x2c14073f,0x442e035f,0x46f52201,0x26c53535}},	//   न्दू_, _naf_, ачит, _pulo_,
   {{0xf77100bf,0x36691c56,0x290f023a,0x270e0095}},	//   غات_, како_, stga_, _yəni_,
   {{0x7c2e15b5,0xbb840082,0x2baa255b,0x7ae3002d}},	//   _zabr, _الفي, _करता, ântu,
   {{0x81eb0083,0x98b90f08,0x9f4300b8,0xad9b3536}},	//   মলা_, _алат_, dají_, _abúz,
   {{0x26c50188,0x7c2e01ef,0xf8b900bc,0x176b3537}},	//   _tulo_, _xabr, _شهاب_, _преп_,
   {{0x03a5059b,0xf868026e,0x53a50279,0xd37800f4}},	//   рино, _حملي_, ранб, kaću_,
   {{0x67b814ac,0xcb120122,0xd37800f4,0x2c640523}},	//   _صالح_, חלט_, jaću_, _möda_,
   {{0xd378011c,0x2c640282,0x00000000,0x00000000}},	//   daću_, _löda_, --, --,
   {{0x442e3538,0xad9b0037,0x270e0095,0x05a800d4}},	//   _gaf_, _gcúi, _səni_, _свій_,
   {{0x634a0095,0x7c2e0009,0xdee63539,0xa2a700a1}},	//   yəni, _rabr, роби, _टीव्,
   {{0xdbdf00fb,0x3f8c003c,0x3ea0353a,0xa2ca035d}},	//   _síðu, ħdu_, ulit_, _संत्,

   {{0x3ea0008a,0x7c2e353b,0x645c353c,0x442e353d}},	// [2c00] rlit_, _pabr, örig, _yaf_,
   {{0xa7fc036a,0x7c2e0be2,0x6e2f009e,0x2c640523}},	//   _alın, _qabr, _eacb, _böda_,
   {{0x62870097,0xf1a900f8,0x634a0095,0xbea62ccc}},	//   čkov, _لایه_, təni, _ванк,
   {{0xeb97353e,0x6286353f,0x2c64013c,0x3e7f0421}},	//   ших_, nnko, _döda_, rätä_,
   {{0x7c2e3540,0xa3e822d4,0x634a00a8,0x6e243541}},	//   _tabr, बरम_, rəni, meib,
   {{0x7d043542,0xceb40095,0x1957005f,0x634a00a8}},	//   muis, lmə_, рашы_, səni,
   {{0x7d043543,0xa2ca0785,0x00000000,0x00000000}},	//   luis, _संध्, --, --,
   {{0x2bd2009a,0x442e28ae,0x386503d0,0x634a013b}},	//   दुरा, _saf_, _ellr_, qəni,
   {{0x9f4301c0,0x7d043544,0x69340118,0x78b1008d}},	//   vají_, nuis, _دکار, ákvæ,
   {{0x62863545,0x6e2401ae,0xb7960274,0x3cfe01c0}},	//   enko, heib, _крећ, _लिने_,
   {{0x7d043546,0x1c0b08a9,0x4394338e,0x9f431dab}},	//   huis, स्टल_, санс, tají_,
   {{0x7d043547,0x442e0e91,0x00000000,0x00000000}},	//   kuis, _waf_, --, --,
   {{0x442e3548,0xe4d404e8,0x61f6001e,0x7d043549}},	//   _taf_, _اقتد, _ddyl, juis,
   {{0x7d04354a,0x6286299b,0x03770416,0x6aa2354b}},	//   duis, anko, احیت_, hlof,
   {{0x60d609b3,0x229201ba,0xe80e06d9,0xf0b400d4}},	//   _etym, háky_, _साना_, ійсь,
   {{0x2c64013c,0xdce6027d,0x5f94354c,0x00000000}},	//   _röda_, _aykı, цист, --,
   {{0xd90402fd,0x7d04354d,0xa2ca02b4,0xd378003a}},	// [2c10] _تی_, guis, _सूत्, raću_,
   {{0x80dd0083,0x38a91da9,0xd3780c99,0x00000000}},	//   _বিপ্, kúra_, saću_, --,
   {{0x5b151d91,0x7642030d,0x00000000,0x00000000}},	//   смет, _onoy, --, --,
   {{0x7d040382,0xe8f5004f,0x3d070026,0x00000000}},	//   buis, مستخ, िंदे_, --,
   {{0x3cfe006a,0x7d040cb3,0xb92707bc,0x8d842f44}},	//   _लिये_, cuis, рфей, _дурд,
   {{0xd3660286,0xf1bf00b5,0x26d90097,0x00000000}},	//   _فه_, ldás_, _čsob_, --,
   {{0x81bf0083,0x99861a8a,0x62860067,0xda35037c}},	//   েরি_, rdoš_, ynko, _левы,
   {{0x7c25354e,0x80dd0033,0x229200ac,0xf1bf00fd}},	//   lehr, _বিন্, báky_, ndás_,
   {{0x673a0b88,0xf09f01f7,0x00000000,0x00000000}},	//   _ertj, ntàs_, --, --,
   {{0xb46503ad,0x9865006c,0x81bf0083,0xba3d06fe}},	//   скол, _دیتے_, েরা_, _chův,
   {{0x2c19021a,0x673a0051,0x6e24354f,0x60d61140}},	//   न्यं_, _grtj, yeib, _stym,
   {{0x9980016f,0x201a00d7,0x628601d7,0x17680ddc}},	//   žiť_, _sbpi_, unko, _труп_,
   {{0xf6520122,0x7c25033b,0xd5480c26,0x62860533}},	//   _מצא_, kehr, _نجوم_, rnko,
   {{0x1c030ccf,0x753602b5,0x75293550,0x200c00ab}},	//   _लागल_, _לאנד_, mwez, üdi_,
   {{0x44253551,0x64433552,0xceb40095,0x81e70033}},	//   mel_, _inni, tmə_, _পার_,
   {{0x66093553,0x7d0403fe,0x752908c7,0x00000000}},	//   ngek, tuis, owez, --,
   {{0x6e243554,0x75290a75,0x291f006f,0xceb40095}},	// [2c20] reib, nwez, _npua_, rmə_,
   {{0x44253555,0x22920097,0x7c25033b,0xa3ab3556}},	//   nel_, váky_, gehr, _खरा_,
   {{0x7d040dfa,0x291f00c3,0x2018079a,0xe1ff00d5}},	//   suis, _apua_, mfri_, bkód_,
   {{0xa2ca1d78,0x44253557,0x22920187,0x7d043558}},	//   _संस्, hel_, táky_, puis,
   {{0x44253559,0x2baa0299,0x1fa8021a,0x64430086}},	//   kel_, _करवा, _गरुड, _onni,
   {{0xd90d0a86,0xbb461cba,0x38a9355a,0x22920187}},	//   ئیل_, _легк, túra_, ráky_,
   {{0xe80e065a,0xf1bf016f,0xf1c805f7,0xfaa600d8}},	//   _साठा_, ndár_, रखान, _гаво,
   {{0x44250244,0x6443355b,0x6609355c,0x673a022f}},	//   eel_, _anni, ggek, _vrtj,
   {{0x4425355d,0x8966355e,0xc96600d8,0x96170037}},	//   fel_, _укаж, _увай, صغير_,
   {{0xe8d700a5,0x290608c7,0x20cf00ec,0x00000000}},	//   _לומר_, muoa_, _bļin_, --,
   {{0xf743261f,0x2f380359,0x9f4a01cb,0xdc9b1804}},	//   _нефо, _nčg_, babé_, רייל,
   {{0x326710fe,0x644311e6,0x466900d4,0xbddb00e0}},	//   стов, _enni, _крім_, _anèn,
   {{0x4425355f,0x2018003c,0x75290371,0x00000000}},	//   bel_, ffri_, cwez, --,
   {{0x44252572,0x27ee0093,0x00000000,0x00000000}},	//   cel_, nafn_, --, --,
   {{0x447b0122,0x7c250355,0x00000000,0x00000000}},	//   _תנוע, vehr, --, --,
   {{0x7c25033b,0x2906023c,0x00000000,0x00000000}},	//   wehr, kuoa_, --, --,
   {{0x463b02b5,0xdc5503fa,0xdb1c0310,0xa7fc027d}},	// [2c30] נעמע, овањ, _agrà, _alım,
   {{0x61ef3560,0xba3d00b8,0x00000000,0x00000000}},	//   lacl, _lhůt, --, --,
   {{0x50d40332,0x212b0297,0x99d7004f,0x9f430453}},	//   _وزیر, lwch_, متشا, bajá_,
   {{0x44253561,0x61ef3562,0x9f43021d,0x2be90831}},	//   zel_, nacl, cajá_, খলেই_,
   {{0x44253563,0x212b001e,0x5fd00026,0xa3e804bc}},	//   yel_, nwch_, तुकल, बरा_,
   {{0x7e6d3564,0xb901007c,0x27ee00e9,0xf99002ed}},	//   lhap, _दऽ_, gafn_, ربن_,
   {{0x2bdf2088,0x44253565,0xb8d00fd1,0x66090c7c}},	//   _प्या, vel_, _टी_, tgek,
   {{0x44253566,0x0f7c00a5,0x7e6d0553,0x00000000}},	//   wel_, טרול, nhap, --,
   {{0x66093567,0xd7fb0009,0xdb1c00ee,0x75293568}},	//   rgek, _буе_, _igrá, uwez,
   {{0x212b001e,0x66093569,0x752901e4,0x4425000b}},	//   dwch_, sgek, rwez, uel_,
   {{0x4425356a,0x7e6d0553,0xe80e01c0,0x60dd0345}},	//   rel_, khap, _साता_, epsm,
   {{0x4425356b,0xe29a356c,0xd6ab028c,0x2f38021e}},	//   sel_, рам_, _صدام_, _rčg_,
   {{0xa4f70609,0x7e6d01cb,0x212b00e9,0x2f38023a}},	//   _اکبر_, dhap, gwch_, _sčg_,
   {{0x6443008a,0x316c0067,0x00000000,0x00000000}},	//   _unni, ądz_, --, --,
   {{0x7e6d0051,0x1fb5248f,0xe81b01d1,0x00000000}},	//   fhap, зстр, प्या_, --,
   {{0x7e6d2326,0x7bd502a2,0xf1bf01ef,0xaaa800ab}},	//   ghap, _afzu, meán_, _छींक,
   {{0x63a30297,0xf1bf004f,0xec7a17a3,0x6da32c61}},	// [2c40] _hynn, leán_, апа_, дита,
   {{0x0c2300c3,0x63a3356d,0xdb1c356e,0x6721011c}},	//   ммун, _kynn, _agrá, _oplj,
   {{0x49ca07c1,0xad9b0098,0x7e6d01cb,0x00000000}},	//   ален_, _scút, bhap, --,
   {{0x7e6d356f,0x09e30370,0x63a33570,0x00000000}},	//   chap, доцн, _mynn, --,
   {{0x63a33571,0xe80e22a7,0x522d016b,0x00000000}},	//   _lynn, _सादा_, טואַ, --,
   {{0x6e3601c8,0x7e643572,0x786f0a8a,0x00000000}},	//   ldyb, lkip, _løvf, --,
   {{0x7d1615d6,0x63a33573,0x61ef013b,0x00000000}},	//   ltys, _nynn, yacl, --,
   {{0x6e363574,0xf1bf004f,0x27ee008a,0x7bc701f4}},	//   ndyb, deán_, safn_, _zgju,
   {{0xceb302b8,0x7d163575,0x7afa003e,0x00000000}},	//   ויה_, ntys, _ættb, --,
   {{0x31e302cb,0x63a3001e,0xb8660e0c,0x81e70083}},	//   पर्ध, _bynn, _بارو, _পাই_,
   {{0x63a302c7,0x61ef3576,0xe3b8027d,0x7e640421}},	//   _cynn, tacl, ldız_, kkip,
   {{0x212b001e,0x63b50187,0x63a300e9,0x7d160409}},	//   twch_, ýzna, _dynn, ktys,
   {{0x26cc3577,0x61ef3578,0x00000000,0x00000000}},	//   _hudo_, racl, --, --,
   {{0x80dd0083,0x26cc01f4,0x212b001e,0x741311c0}},	//   _বিদ্, _kudo_, rwch_, _يونا,
   {{0x63a302c7,0x7e6d3579,0x8f34357a,0x64580036}},	//   _gynn, thap, мерц, _iovi,
   {{0x6458357b,0xa1950208,0x975700a5,0x00000000}},	//   _hovi, _найч, חילו_, --,
   {{0x629d2de1,0x26cc357c,0x6458357d,0x7e6d357e}},	// [2c50] moso, _ludo_, _kovi, rhap,
   {{0x6458357f,0x61ed3580,0x7e6d3581,0x2ba703fa}},	//   _jovi, _heal, shap, ојев,
   {{0x64582280,0x61ed0fef,0x26cc3582,0x60cd3583}},	//   _movi, _keal, _nudo_, _huam,
   {{0x75223584,0x60cd000e,0x7e6402ec,0x61ed3585}},	//   _opoz, _kuam, ckip, _jeal,
   {{0xcfbd0083,0x6d4b01ff,0x60cd3586,0x672100f4}},	//   _অভিন, ågad, _juam, _splj,
   {{0x61ed3434,0x64583587,0x26cc3588,0x60c50069}},	//   _leal, _novi, _budo_, _jihm,
   {{0x25a92518,0xad9b0037,0x26cc3589,0x60cd358a}},	//   _šal_, _gcúr, _cudo_, _luam,
   {{0x26cc358b,0x7c35358c,0xdb1c00b5,0x60cd009e}},	//   _dudo_, _hazr, _ugrá, _ouam,
   {{0x629d358d,0x63a3358e,0x656000e9,0x49040037}},	//   doso, _synn, gymh, _يوفق,
   {{0xf1bf0037,0x13090421,0x26cc0090,0x00000000}},	//   teán_, бной_, _fudo_, --,
   {{0x61ed358f,0x64583590,0xbddb0176,0x7c353591}},	//   _beal, _dovi, _anèm, _mazr,
   {{0xf1bf004f,0x629d3592,0x61ed3593,0x60cd0698}},	//   reán_, goso, _ceal, _buam,
   {{0xf1bf004f,0x61ed3594,0x15453471,0xf8cb0035}},	//   seán_, _deal, _хелм, ादिय,
   {{0x653a02b5,0x7c353595,0x645800ec,0x63a33596}},	//   _לענד, _nazr, _govi, _tynn,
   {{0x629d3597,0x61ed3598,0x1eaa01b2,0x69c90103}},	//   boso, _feal, ماري_, _ogee,
   {{0x786f0a8c,0x61ed0094,0xe81b0440,0x69c93599}},	//   _høvd, _geal, प्ता_, _ngee,
   {{0xf1bf004f,0x60cd359a,0x00000000,0x00000000}},	// [2c60] neál_, _guam, --, --,
   {{0x7e64359b,0xeb9a021d,0x61ed359c,0x7659359d}},	//   skip, биз_, _zeal, _lowy,
   {{0xe805227d,0x7d163291,0x6d4b013c,0xfe46359e}},	//   _राजा_, stys, ägar, _енно,
   {{0x7659004e,0x60cd006d,0x7d160282,0x9f4a02d7}},	//   _nowy, _yuam, ptys, nabí_,
   {{0x7c3500d7,0x63a60035,0x00000000,0x00000000}},	//   _fazr, ękni, --, --,
   {{0xb8f40f39,0x26cc0831,0x2bdb2a06,0x7d04359f}},	//   _सं_, _pudo_, मुदा, mris,
   {{0x7522096f,0xd6d71667,0x25c10095,0x661b35a0}},	//   _spoz, пты_, ərlə_, ffuk,
   {{0x80dd00c8,0xfaa300d4,0x7d0435a1,0x99890b67}},	//   _বিস্, _засо, oris, žaš_,
   {{0x645835a2,0x68e9001e,0x629d35a3,0xd49a3464}},	//   _povi, _gwed, voso, йро_,
   {{0x26cc00c9,0x7d040a32,0x61ed35a4,0xb5fd00ea}},	//   _tudo_, iris, _seal, rkša,
   {{0x61ed0006,0xe61a35a5,0x7d0435a6,0x60cd005d}},	//   _peal, _где_, hris, _suam,
   {{0x7d0435a7,0xbddb02d0,0xad9b0042,0xd377010b}},	//   kris, _enèj, _ocúp, ячы_,
   {{0xf4871328,0xe53400c3,0x64582442,0x386c06fe}},	//   _کانی, _цель, _tovi, _kldr_,
   {{0x7d0435a8,0x629d35a9,0x7e7d00d7,0x61e000d0}},	//   dris, soso, _smsp, ımla,
   {{0xda0d0953,0x7c351851,0x25af35aa,0x7d0435ab}},	//   _हालत_, _razr, _zzgl_, eris,
   {{0x7d0435ac,0x7c35011c,0x2a660009,0x60cd35ad}},	//   fris, _sazr, jkob_, _tuam,
   {{0x2249016f,0xe7cc018d,0x82340833,0x786f23f4}},	// [2c70] _inak_, ाशाप, _سريا, _høve,
   {{0xdfd10037,0xdb1c017b,0x00000000,0x00000000}},	//   _جيد_, _ogrä, --, --,
   {{0xaac710ad,0x7d0435ae,0x68e935af,0xde5901e0}},	//   ستان, aris, _swed, _дані_,
   {{0x7d180082,0x7d042190,0x68e90269,0x37e60033}},	//   éasá, bris, _pwed, _নাগর,
   {{0x26160006,0x3ea935b0,0x25a60118,0x20d3198f}},	//   _भउजी_, mlat_, _nyol_, _धूमध,
   {{0x3ea935b1,0x07a535b2,0x013800a5,0xc7a501e0}},	//   llat_, малн, פרות_, милк,
   {{0x224935b3,0x12c70083,0xb8f4111e,0x765920bc}},	//   _onak_, _শব্দ, _सू_, _powy,
   {{0xd87701ca,0x645c35b4,0x7afa008d,0x68e90345}},	//   _کارب, örin, _ætta, _twed,
   {{0xbddb0260,0x1dbf07df,0xdce400f4,0x00000000}},	//   _anèk, ्शित, rzić, --,
   {{0x224935b5,0x2a6d35b6,0x25a60359,0x3ea90421}},	//   _anak_, _hleb_, _dyol_, hlat_,
   {{0x3ea900d6,0x04ff0033,0xa22a110d,0x80dd0033}},	//   klat_, ্বের_, ожна_, _বিষ্,
   {{0x7d04008a,0x1fc50083,0xcfc50033,0x38b200af}},	//   yris, ্রাস, ্রান, râre_,
   {{0x66c7027d,0x3ea935b7,0xbbaa1e18,0x00000000}},	//   _fıkr, dlat_, _कर्क, --,
   {{0x80dd0b52,0x63850923,0x22493086,0x00000000}},	//   _বিশ্, _огла, _enak_, --,
   {{0xe29f008a,0x4f95002d,0x8fa30227,0x3ea935b8}},	//   boð_, ерту, варе, flat_,
   {{0xe1ff0501,0xecea1172,0x00000000,0x00000000}},	//   lkón_, ждал_, --, --,
   {{0x32d30028,0xe80e1782,0xbea3032f,0xd12f00d1}},	// [2c80] _hãy_, _साला_, татк, _نمي_,
   {{0x224935b9,0x3ac800a8,0x3ea9231e,0x25a2018d}},	//   _znak_, _aşpa_, alat_, ükli_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0x7d041691,0x20d400be,0x3ea90310,0x2efa0027}},	//   pris, _käi_, clat_, _ivpf_,
   {{0x20d41c55,0xaac500f8,0x2bdf0af6,0xbdfb103b}},	//   _jäi_, رتمن, _प्वा, _برپا_,
   {{0xd6da35ba,0x3ea001ef,0xbddb0118,0x4c350043}},	//   оти_, loit_, _anèh, _пэст,
   {{0xf79301c8,0xdca319fa,0x32d300e2,0xdc37016b}},	//   кашэ, _рари, _nãy_, _קאלט_,
   {{0xa5340011,0x3ea035bb,0x786f08c8,0x00000000}},	//   енич, noit_, _røve, --,
   {{0x64c805f7,0x6d40063c,0x786f0a8a,0x224901ed}},	//   रदेश, _šmaj, _døvb, _rnak_,
   {{0x224935bc,0x83860409,0x80dd0033,0x3ea001ed}},	//   _snak_, дыме, _বিল্, hoit_,
   {{0xd37a2743,0x22490118,0x00000000,0x00000000}},	//   ючи_, _pnak_, --, --,
   {{0x05660012,0x32d30023,0x475900af,0x00000000}},	//   _овен, _dãy_, _эруя_, --,
   {{0x3ea92cfb,0xa2ca1729,0xd83802a7,0xf1ab00f8}},	//   vlat_, _संक्, _kač_, تاده_,
   {{0xdbf30463,0x9f4301ba,0x961d00ea,0x2906002a}},	//   _işçi, majú_, miņa, iroa_,
   {{0x442c35bd,0xd838011c,0xc0580823,0x32d30023}},	//   med_, _mač_, фія_, _gãy_,
   {{0x442c35be,0xd8380107,0x3ea90460,0xc1150fb4}},	//   led_, _chčz_, ulat_, _змиј,
   {{0x3ea935bf,0x442c001e,0x68e200ac,0x865b00a5}},	// [2c90] rlat_, oed_, jpod, קדמי,
   {{0x3ea935c0,0x6ab9021a,0x29061c7a,0xb5fd00ea}},	//   slat_, ेद्र, droa_, ekšl,
   {{0x2a6d006d,0x3ea935c1,0x9f4300a0,0x26de0051}},	//   _pleb_, plat_, hajú_, _ntto_,
   {{0x2bdf1119,0x442c35c2,0xfbdf0d53,0xdd140038}},	//   _प्रा, hed_, _प्रम, _súťa,
   {{0x442c35c3,0x26de02fb,0xd8380df4,0x6e2d002a}},	//   ked_, _atto_, _bač_, meab,
   {{0x442c35c4,0x7d0d35c5,0x6e2d0037,0x9f4301ba}},	//   jed_, muas, leab, dajú_,
   {{0x442c01f3,0xa2ca020c,0x7d0d35c6,0xc7a2208b}},	//   ded_, _संग्, luas, лишк,
   {{0xbb4801ca,0x6e2d35c7,0x442c013a,0x290601ef}},	//   _تلفن_, neab, eed_, broa_,
   {{0x442c35c8,0x79a70798,0x2bc3252c,0x7d0d35c9}},	//   fed_, _црве, _वृता, nuas,
   {{0xa2ca0f17,0xe451004f,0x442c35ca,0x3ea0028b}},	//   _संख्, اضة_, ged_, zoit_,
   {{0xe2860b46,0x4e0f2924,0x00000000,0x00000000}},	//   елни, िलाई_, --, --,
   {{0x7d0d0f1a,0x644a35cb,0xd83800ac,0x442c00be}},	//   kuas, _enfi, _zač_, aed_,
   {{0x442c35cc,0x764b006c,0x6e2d07a6,0x3e6e0093}},	//   bed_, _ingy, deab, _nýta_,
   {{0x442c24f4,0xa2ca25d8,0x2bdf1bc6,0xa06a00d8}},	//   ced_, _सूक्, _प्ला, чага_,
   {{0x62580183,0x00000000,0x00000000,0x00000000}},	//   _mãoz, --, --, --,
   {{0x6e2d35cd,0x7d0d0054,0x68fb35ce,0x00000000}},	//   geab, fuas, _ovud, --,
   {{0x628635cf,0x7d0d35d0,0x764b0159,0x68fb073a}},	// [2ca0] miko, guas, _mngy, _nvud,
   {{0x62860a0b,0x69db0831,0x68e20009,0xbca600f3}},	//   liko, _afue, vpod, رماي,
   {{0x961d0029,0x764b012f,0x09ba35d1,0x9f4301ba}},	//   ziņa, _ongy, ेश्य, zajú_,
   {{0xfce60109,0x628635d2,0x442c35d3,0x290635d4}},	//   _помо, niko, zed_, troa_,
   {{0xa967010e,0x442c0122,0xd83802c6,0xf09f0176}},	//   ница_, yed_, _pač_, iràn_,
   {{0x628635d5,0x290606a2,0x9f43016f,0x442c0122}},	//   hiko, rroa_, vajú_, xed_,
   {{0x442c0052,0x628635d6,0x7bce043d,0xe6660431}},	//   ved_, kiko, _igbu, етпо,
   {{0x442c35d7,0x628635d8,0x2906012f,0x9f4300a0}},	//   wed_, jiko, proa_, tajú_,
   {{0x442c35d9,0x628635da,0xdb1c0079,0xad9b0168}},	//   ted_, diko, _ngrú, _idúc,
   {{0x6aa20136,0x998000d8,0x9f4301ba,0x764b35db}},	//   loof, žių_, rajú_, _engy,
   {{0x442c35dc,0xdb1c0042,0x43940f68,0x00000000}},	//   red_, _agrú, танс, --,
   {{0x442c35dd,0x628635de,0x998900a0,0x3f85008e}},	//   sed_, giko, žať_, úlum_,
   {{0x442c0122,0x6e2d02ce,0x628f0051,0x7bdc0031}},	//   ped_, veab, rnco, _ofru,
   {{0x6aa21472,0xc0580208,0x41a501c0,0x7bce35df}},	//   hoof, ніс_, _गुणस, _ngbu,
   {{0x02a735e0,0x5334111d,0x62860a74,0xc90d01c0}},	//   _прим, _рейт, biko, _सम्म_,
   {{0x7d0d35e1,0x7bce011e,0x628635e2,0x7bdc35e3}},	//   tuas, _agbu, ciko, _afru,
   {{0x6e2d35e4,0x9f4a1438,0xbbeb0037,0x2bc3012f}},	// [2cb0] reab, rabá_, كرام_, वेना,
   {{0x6e2d35e5,0xf8b80023,0x22590009,0x00000000}},	//   seab, _nhĩ_, ljsk_, --,
   {{0x68fb0254,0x7afa008d,0x3944024b,0x7afc0a66}},	//   _svud, _ættl, _arms_, _cvrt,
   {{0x636b006c,0xd7f10023,0x2bd31746,0x63aa00a2}},	//   lönö, _sẽ_, _तलवा, _myfn,
   {{0x7d0d0036,0xb5fd00c7,0x6258021d,0x00000000}},	//   quas, ukšm, _pãoz, --,
   {{0x628635e6,0xf8b800cc,0x00000000,0x00000000}},	//   ziko, _chĩ_, --, --,
   {{0x764b0159,0x628601d5,0xdb15021e,0xa6950bfe}},	//   _pngy, yiko, _egzò, криј,
   {{0x628635e7,0xbddb0260,0x21290118,0x6edc08b7}},	//   xiko, _enèv, _opah_, _učbe,
   {{0xf9930e0c,0x383500af,0x628635e8,0x69c435e9}},	//   _صبر_, _инар, viko, žier,
   {{0x446535ea,0x2bb80992,0x58d40de3,0x290f35eb}},	//   твов, _अरमा, _софт, muga_,
   {{0xe29a35ec,0xfbd20052,0x63aa0297,0x78a30009}},	//   дан_, יתי_, _cyfn, monv,
   {{0x20012745,0x63aa016e,0x00000000,0x00000000}},	//   _adhi_, _dyfn, --, --,
   {{0x628635ed,0x290f0a47,0xa564004f,0x291d33e5}},	//   riko, nuga_, _مدون, ntwa_,
   {{0x291d0054,0x290f0553,0x78a302ee,0x00000000}},	//   itwa_, iuga_, nonv, --,
   {{0x63aa001e,0x8fa60265,0x290f35ee,0x00000000}},	//   _gyfn, таве, huga_, --,
   {{0x7bdc35ef,0x291d02e9,0x290f00ab,0xb146002d}},	//   _sfru, ktwa_, kuga_, _анил,
   {{0xc5f21899,0x6f0e0211,0x290f35f0,0x62840067}},	// [2cc0] ידן_, subc, juga_, _imio,
   {{0x290f35f1,0x1f66002d,0x2004010b,0x00000000}},	//   duga_, _аком, ėmis_, --,
   {{0x78a335f2,0x00000000,0x00000000,0x00000000}},	//   donv, --, --, --,
   {{0x290f01a8,0xc98615ae,0x00000000,0x00000000}},	//   fuga_, кули, --, --,
   {{0x6aa22541,0x78a303d0,0x290f00be,0x6fd9021a}},	//   roof, fonv, guga_, _मलमू,
   {{0x7afc0c21,0xa7fc037a,0xa3c30035,0x3a2435f3}},	//   _tvrt, _alır, ्शा_, _wbmp_,
   {{0x7c3c0f46,0x6d460124,0x3944021d,0x62840103}},	//   _iarr, _hrka, _wrms_, _omio,
   {{0x290f0198,0x7c3c35f4,0x7c3e35f5,0x3e6e0097}},	//   buga_, _harr, ldpr, _mýto_,
   {{0x7c3c35f6,0x291d004e,0x81d80033,0x08c635f7}},	//   _karr, ctwa_, িরা_, _абан,
   {{0x7c3c03cb,0xdb1c01a6,0x6d46023a,0xdb0e0160}},	//   _jarr, _sgrù, _mrka, _izbâ,
   {{0xd2510e3a,0x7c3c357e,0xd7a90722,0x64a30370}},	//   مند_, _marr, _चुपच, раќа,
   {{0x7c3c0291,0x6d4635f8,0xa77b0070,0x2ebe021a}},	//   _larr, _orka, _קראפ, ्दोत,
   {{0xd8380009,0x518416b8,0x316d0300,0x955300d1}},	//   _akči_, аура, áez_, _نخوا,
   {{0x8c080083,0x8cd60084,0x7c3c35f9,0x258400ea}},	//   র্তন_, _बढ़ो, _narr, rīlī_,
   {{0x54330a72,0xdef80043,0x443c0221,0x6d4635fa}},	//   _ضرور, кыт_, _iav_, _arka,
   {{0x443e35fb,0x443c35fc,0x3cfe1163,0xa2cb08b0}},	//   ldt_, _hav_, _लिखे_, _सूच्,
   {{0x443c0189,0x7c3c35fd,0x21290ac8,0x80dd0083}},	// [2cd0] _kav_, _barr, _upah_, _বিক্,
   {{0x443e35fe,0x290f070b,0x7c3c35ff,0x443c1665}},	//   ndt_, vuga_, _carr, _jav_,
   {{0x7c3c0955,0x443c01e8,0x6d463600,0x443e3601}},	//   _darr, _mav_, _erka, idt_,
   {{0x7c3c1093,0x443c3602,0x998400d8,0x66023603}},	//   _earr, _lav_, _namų_, _ndok,
   {{0x7c3c3604,0xe8df0019,0x443c3605,0x6d4600ee}},	//   _farr, _trọn_, _oav_, _grka,
   {{0x443c0ae0,0x7c3c3606,0x290f3607,0x7e6d3608}},	//   _nav_, _garr, ruga_, lkap,
   {{0x291d3609,0x290f360a,0x6d4601ba,0x46f400d8}},	//   stwa_, suga_, _zrka, ачыт,
   {{0x443e0120,0xc1e3360b,0x7c3c01a3,0x6d46017b}},	//   edt_, _क्लब_, _zarr, _yrka,
   {{0x9a840183,0x26140066,0x6e3d360c,0x66020069}},	//   _турл, _धारी_, _masb, _ddok,
   {{0x443c006f,0x7c3c1d75,0x649d12c3,0x6284360d}},	//   _cav_, _xarr, nèix, _smio,
   {{0x443c0189,0xf7700833,0x461500d1,0x7e6d00c3}},	//   _dav_, _وام_, _موار, kkap,
   {{0xe0c902b5,0x443e23b5,0x6d030096,0x6e3d360e}},	//   _זײ_, adt_, _लिंग_, _nasb,
   {{0x81ac0083,0x321e0035,0x2bc31371,0x3e6e00ee}},	//   কেন_, ęty_, वेता, _sýto_,
   {{0x40952846,0x443c360f,0x66020187,0x80dd0033}},	//   арст, _gav_, _zdok, _বিখ্,
   {{0x6e3d3610,0x6d46063b,0x9f580055,0x6aa90069}},	//   _basb, _srka, marë_, _okef,
   {{0x7c3c0291,0x7e6d3611,0xa3df00ab,0x6d460207}},	//   _sarr, gkap, धुर_, _prka,
   {{0x7c3c3612,0x261b0299,0x0c26150d,0x443c0189}},	// [2ce0] _parr, _यानी_, лман, _yav_,
   {{0x443c0d4b,0x7c3c035f,0x786f082b,0x6e3d00f1}},	//   _xav_, _qarr, _søvn, _easb,
   {{0x7c3c3613,0x645c1b43,0x16030099,0x629d00a2}},	//   _varr, örii, ळणार_, érog,
   {{0xe3c50083,0x998d0035,0x7c3c3614,0x6d460a23}},	//   _এভাব, _oceń_, _warr, _trka,
   {{0x7c3c3615,0x6abb0211,0x5886004b,0xbddb01f7}},	//   _tarr, _dhuf, лыка, _enès,
   {{0x61f6045e,0x60d6010d,0x6e2402fc,0x95f00033}},	//   _leyl, _muym, lfib, _টাইম_,
   {{0x6d443616,0xbddb01f7,0x2bc305a6,0x9f580031}},	//   lvia, _inèr, वेदा, darë_,
   {{0x443c3617,0x9b93004f,0xfaa63618,0x7ae33619}},	//   _sav_, _الفت, _сабо, ínte,
   {{0x6d4412c3,0xd9432dbb,0x443c361a,0x4427361b}},	//   nvia, _лети, _pav_, _bbn_,
   {{0xd5c006bb,0x443c0221,0x443e213d,0x7e6d361c}},	//   शेषज, _qav_, udt_, zkap,
   {{0x443e25cb,0x443c30bc,0x61f6033e,0x7e6d067f}},	//   rdt_, _vav_, _beyl, ykap,
   {{0x201a0024,0x673a003a,0x61f61008,0x442701ed}},	//   _acpi_, _istj, _ceyl, _ebn_,
   {{0x443c361d,0x6d44016f,0x9f510097,0x4427009e}},	//   _tav_, jvia, razí_, _fbn_,
   {{0x443c361e,0x60d6033e,0x00000000,0x00000000}},	//   _uav_, _duym, --, --,
   {{0xb4c2361f,0xe81c2e4f,0xb4c010a6,0x7e6d3620}},	//   ्दी_, _नाना_, ंगी_, tkap,
   {{0xe80e06bb,0x6e3d009f,0x4ea70804,0x7640183a}},	//   _साझा_, _qasb, урга, ndmy,
   {{0xb8042e4f,0x7d550036,0x5d550265,0x38bb03bc}},	// [2cf0] रणाम_, швах, шкат, lêre_,
   {{0x7e6d3621,0x673a00ab,0x9ed9029f,0xb5fd0009}},	//   skap, _ostj, _имот_, rkši,
   {{0x649d0443,0xd1b800b5,0x00000000,0x00000000}},	//   rèix, _لایا_, --, --,
   {{0x81f30083,0x61f600a8,0xbddb01f7,0xb4c20af9}},	//   _ঝাঁপ_, _xeyl, _enèr, ्दु_,
   {{0xc27c0070,0xa3ab0803,0x527c016b,0x2c760b3e}},	//   ערדי, _कुन_, ענדא, _sæde_,
   {{0x1bd43622,0x2bdb21b2,0x7d0d3623,0x41c7143a}},	//   _горя, मुखा, mras, रेयस,
   {{0x9f580031,0x9f430176,0x00000000,0x00000000}},	//   varë_, majó_, --, --,
   {{0x673a023a,0x0f5800a5,0x00000000,0x00000000}},	//   _dstj, ריהם_, --, --,
   {{0x9f5800da,0x7d0d01d6,0xb4c20534,0x4427055c}},	//   tarë_, nras, ्दू_, _pbn_,
   {{0x0325015a,0x291f01f7,0xddc400c7,0x61f600a3}},	//   адон, _iqua_, nkiš, _seyl,
   {{0x7d0d3624,0xe1ff004e,0x3a3f3625,0xe70b1c73}},	//   hras, nków_, _kaup_, _ستان_,
   {{0x80dd00c8,0x216a00d4,0x6d44010b,0x6146021f}},	//   _বিজ্, вими_, yvia, аема,
   {{0x34953626,0xe2973627,0x9f583628,0x44270023}},	//   _кадр, рая_, maré_, _tbn_,
   {{0xd4660202,0x6d4407e5,0x26cf0453,0xe5c4010b}},	//   _више_, vvia, _higo_, _усхо,
   {{0x26cf01d0,0x6e24027a,0x7d0d3629,0x00000000}},	//   _kigo_, tfib, eras, --,
   {{0x9f580176,0xe1ff0035,0x539a00a5,0xddc90693}},	//   naré_, dków_, _ביצו, _šošt,
   {{0x7d0d362a,0xac860c0d,0x291f006d,0x26cf02d7}},	// [2d00] gras, агал, _nqua_, _migo_,
   {{0x6441362b,0xd12f064e,0x26cf362c,0x0eb800a1}},	//   ndli, _کمی_, _ligo_, _आठवड,
   {{0x7d0d362d,0x64411d22,0xdddd006c,0x2abc00de}},	//   aras, idli, _első, híbe_,
   {{0x9f580a17,0x6da600d4,0x7d0d14bc,0x2240362e}},	//   jaré_, _вима, bras, _jaik_,
   {{0x44e9362f,0x7d0d3630,0x290003e6,0x9f58181f}},	//   _nº_, cras, éia_, daré_,
   {{0x20183631,0x37063632,0x3eb22f06,0x64410223}},	//   ngri_, ачив, llyt_, jdli,
   {{0x64410699,0x291f0036,0x26cf3633,0x9f580176}},	//   ddli, _equa_, _bigo_, faré_,
   {{0x644102c9,0x22400224,0x9f58181f,0xeb9700d4}},	//   edli, _naik_, garé_, _тис_,
   {{0xd5b73634,0x26cf1721,0x44e902d7,0x442509a2}},	//   ись_, _digo_, _cº_, ffl_,
   {{0xb4c0006a,0xb4c20d4e,0x2bc300ab,0x38bb03bc}},	//   ंगे_, ्दे_, वेवा, têre_,
   {{0x22403635,0x394600d8,0x3e75013c,0x9f583636}},	//   _baik_, lvos_, _låta_, baré_,
   {{0xc5f000c8,0x9f583637,0x64413638,0x38bb0b88}},	//   _টাকা_, caré_, adli, rêre_,
   {{0x22400fef,0x64d1012f,0x4425009e,0x00000000}},	//   _daik_, सदृश, bfl_, --,
   {{0x83f82b92,0x53340810,0x7d0d3639,0x27fc03db}},	//   _секс_, _гект, vras, navn_,
   {{0x06fd00b8,0x2240363a,0x00000000,0x00000000}},	//   žívá_, _faik_, --, --,
   {{0x27fc01b4,0x2c190099,0x2a640260,0x20181b37}},	//   havn_, _पाहू_, _nomb_, agri_,
   {{0xddc400cb,0xdb1c0035,0x6d40008b,0x66d5010b}},	// [2d10] tkiš, _ogró, _šmar, _iške,
   {{0xe1ff0035,0x9f58363b,0x61fd363c,0xa3aa363d}},	//   tków_, zaré_, lasl, _खडा_,
   {{0x291f0069,0x1da700ab,0x7d0d363e,0x7e9900fd}},	//   _squa_, _कुरत, sras, _مندر_,
   {{0x7d0d363f,0xa3e60567,0xde590402,0xdb1c0138}},	//   pras, युत_, _самі_, _agró,
   {{0x39490f56,0xf99011c0,0xd9453640,0x0dcb0370}},	//   ías_, وبه_, сели, _јуни_,
   {{0x26cf3641,0xb4c201c0,0xb4c03100,0xf8a8010b}},	//   _sigo_, ्दो_, ंगो_, авік_,
   {{0xb4c20311,0x61fd0291,0x9f583642,0x26cf3643}},	//   ्दै_, kasl, taré_, _pigo_,
   {{0x3ea902ee,0x2f980122,0x61fd00ea,0x20180124}},	//   noat_, יכון_, jasl, zgri_,
   {{0x26cf0caa,0x880718dd,0xc485081b,0x9f580747}},	//   _vigo_, _نظام, йлик, raré_,
   {{0x9f583644,0x26c40036,0x26cf08c7,0x66d502a7}},	//   saré_, ammo_, _wigo_, _aške,
   {{0x644119ea,0xe81c056a,0xa25b0132,0x9f583645}},	//   rdli, _नाता_, rmôn, paré_,
   {{0x27213646,0x6f153647,0x625a3648,0x7d0200c7}},	//   món_, duzc, урор_, šosi,
   {{0x272133d5,0xa5093649,0x5a9a025a,0x00000000}},	//   lón_, _села_, רשרא, --,
   {{0x645c1130,0x00000000,0x00000000,0x00000000}},	//   örit, --, --, --,
   {{0x2721043f,0xdee600cf,0xb21b08c8,0x3ea90298}},	//   nón_, соби, dhæf, foat_,
   {{0x2252014c,0x394600c7,0xbda60037,0x00000000}},	//   _unyk_, yvos_, محذو, --,
   {{0xed57364a,0x2721364b,0x2a64009e,0x00000000}},	// [2d20] бот_, hón_, _romb_, --,
   {{0xa3ab364c,0x00000000,0x00000000,0x00000000}},	//   कअप_, --, --, --,
   {{0xfbc3009a,0x2721364d,0xdb1c01f7,0xf1a901cb}},	//   वेलम, jón_, _agrò, _مایه_,
   {{0x2721364e,0x82d60070,0x7bd5005f,0xef220067}},	//   dón_, צונג_, _egzu, ążę_,
   {{0x19581385,0x186a364f,0xceb40095,0xa3e72874}},	//   ралы_, лади_, mlə_, बडा_,
   {{0xfce33650,0x27213651,0x6e360644,0xceb400a8}},	//   _хоро, fón_, leyb, llə_,
   {{0x27210f56,0xa3c93652,0x61e40139,0x61fd01fb}},	//   gón_, लेम_, _ofil, yasl,
   {{0x27fc008c,0xceb40095,0x20cf0024,0x3e6e06fe}},	//   savn_, nlə_, _ażil_, _býti_,
   {{0x2d803653,0xb5fd0029,0x61fd3654,0x99920035}},	//   nzie_, ekšs, vasl, żył_,
   {{0xd6d21e23,0xb8653655,0x27211111,0xf48400e0}},	//   _فقط_, _والو, bón_, تابی,
   {{0x272125ac,0xceb40095,0x61fd3656,0x61e9002a}},	//   cón_, klə_, tasl, ñelo,
   {{0x9c8700b8,0x41e400d8,0x290000c7,0x7afa008d}},	//   _kočá, зіра, šiau_, _ættu,
   {{0x61fd02dd,0x1da70380,0x00000000,0x00000000}},	//   rasl, _कुंत, --, --,
   {{0x2d800755,0x61e407c0,0x61fd3657,0x9f5a021d}},	//   dzie_, _efil, sasl, _iepê_,
   {{0x61e4001e,0x4fc433d2,0xddcf0139,0x7e662433}},	//   _ffil, зста, _bocş, _bokp,
   {{0x5f9428a1,0xa1951089,0x00000000,0x00000000}},	//   чист, _майч, --, --,
   {{0x272109ab,0x2d5800aa,0x628f2e65,0x7e6600d4}},	// [2d30] zón_, бить_, mico, _dokp,
   {{0xebc703fa,0x6f153658,0xf21f0324,0x27213659}},	//   бљен, puzc, _भाड़_, yón_,
   {{0x272101dd,0xb5fd24d4,0x7e660051,0xb21b0093}},	//   xón_, ljše, _fokp, rhæf,
   {{0xdb1f003e,0x7d16011e,0x2721365a,0x290f023a}},	//   _ávís, buys, vón_, trga_,
   {{0xae1a00c2,0xd5a6006c,0x786f008c,0xb5fd08b7}},	//   _דורכ, _آف_, _høvi, njše,
   {{0x2721069c,0xd7fb027a,0xd3660d47,0x628f0139}},	//   tón_, ууд_, _قه_, hico,
   {{0x628f1bfa,0x00000000,0x00000000,0x00000000}},	//   kico, --, --, --,
   {{0x2721184d,0xb4d10b35,0x628f19be,0xb5fd00ea}},	//   rón_, वद्_, jico, ekšr,
   {{0x628f0aca,0x6499365b,0x2721365c,0x786f008c}},	//   dico, итор_, són_, _løvi,
   {{0x2721116c,0x448909ce,0x61e4365d,0x6aab1ae5}},	//   pón_, рбон_, _sfil, logf,
   {{0x628f1423,0x320931dc,0x68e902c4,0xe7ef00a1}},	//   fico, _bday_, _hted, _घ्या_,
   {{0x628f365e,0xd5750f92,0xf1bf02d7,0xe297365f}},	//   gico, _муль, rfán_, жаю_,
   {{0x7e660159,0x2a3a0070,0xceb400a8,0xf1bf01ef}},	//   _rokp, בערמ, vlə_, sfán_,
   {{0x7e660009,0x201e3660,0x00000000,0x00000000}},	//   _sokp, üti_, --, --,
   {{0xceb40095,0x7e6608dd,0x64430139,0x2abc02d7}},	//   tlə_, _pokp, _iani, híba_,
   {{0x661b3661,0xee3a04bf,0x394d3662,0x2d803663}},	//   nguk, јна_, _ores_, tzie_,
   {{0x64433664,0x7fd63665,0xa3c30302,0xbc6624df}},	// [2d40] _kani, _міні, ्शक_, овак,
   {{0xa3bd0243,0x2d803666,0x6fde0026,0xceb4013b}},	//   _आरा_, rzie_, _मलिं, slə_,
   {{0x394d3667,0xe9da3668,0x6a863669,0x68e92e1e}},	//   _ares_, аке_, олжа, _ated,
   {{0x6443040c,0x2bdc00b4,0x9c8700b8,0x394d099e}},	//   _lani, _बलवा, _počá, _bres_,
   {{0x81ac00c8,0x394d366a,0xdb0700b8,0x59a50099}},	//   কের_, _cres_, _vyjá, गॅलर,
   {{0x6443366b,0xc1730122,0xb902366c,0xd90d00d1}},	//   _nani, וחד_, _नं_, ایل_,
   {{0x394d366d,0x8b231a31,0xe3a700d2,0xea5a04bf}},	//   _eres_, _одре, _آر_, _крај_,
   {{0x628f0042,0x6443366e,0x395d006d,0xba1a0037}},	//   xico, _aani, bxws_, _خيرا_,
   {{0x6443366f,0xd49a05a1,0xd90d042c,0x261b0324}},	//   _bani, иро_, _مین_, _यारी_,
   {{0x64433670,0x7d043671,0xe46a1099,0xa25b0183}},	//   _cani, isis, ршил_, rmôm,
   {{0x628f3672,0x7d043673,0x00000000,0x00000000}},	//   tico, hsis, --, --,
   {{0x7d043674,0xd37701c8,0x64430159,0xdb213675}},	//   ksis, ючы_, _eani, étét,
   {{0x628f3676,0x64433677,0x7c2e0036,0x6600028b}},	//   rico, _fani, _obbr, mamk,
   {{0x628f0aca,0x64433678,0x66003679,0x7d040009}},	//   sico, _gani, lamk, dsis,
   {{0x628f1417,0x44e0367a,0x7d04367b,0x81ac0033}},	//   pico, _hò_, esis, কেল_,
   {{0x644304c3,0x44e00c1f,0x7c2e367c,0x6600000e}},	//   _zani, _kò_, _abbr, namk,
   {{0xd9040ef5,0x5c75010c,0x7d0400a7,0x628d02c4}},	// [2d50] _جی_, плат, gsis, _imao,
   {{0x44e0367d,0x6600028b,0xfc33004f,0x64430be2}},	//   _mò_, hamk, بحر_, _xani,
   {{0x44e0367e,0x6600367f,0x68e93680,0x394d02d7}},	//   _lò_, kamk, _sted, _sres_,
   {{0x66001f1d,0x442e028b,0x7c2e3681,0x787d0260}},	//   jamk, _lbf_, _ebbr, _mève,
   {{0x66000ac8,0x44e002e9,0x81cd0033,0x22920693}},	//   damk, _nò_, শুর_, nška_,
   {{0x68e901ba,0x6d4f0088,0x3e7c00b8,0x48ab0200}},	//   _vted, _irca, _víte_, штем_,
   {{0xf7710fab,0x64433682,0x68e9004e,0xb902007c}},	//   عات_, _rani, _wted, _नू_,
   {{0x394d0aaf,0x44e03683,0x6600046a,0x442e0523}},	//   _tres_, _bò_, gamk, _abf_,
   {{0x64433684,0x44e03685,0x7982004e,0x6d4f011e}},	//   _pani, _cò_, czow, _jrca,
   {{0x629d3686,0x64433687,0x442e3688,0x44e03689}},	//   éron, _qani, _cbf_, _dò_,
   {{0xf1a9012b,0x229201c8,0xa3ab0084,0x00000000}},	//   _עס_, eška_, _कुश_, --,
   {{0x64430464,0xe29a368a,0x44e002e9,0x7d04368b}},	//   _wani, сам_, _fò_, ysis,
   {{0x2bb80c67,0x6443368c,0xbbb8000c,0x44e00019}},	//   _अर्थ, _tani, _अर्क, _gò_,
   {{0x7ae9368d,0x6443034d,0xf09f0310,0x787d00a2}},	//   _četn, _uani, dràs_, _fève,
   {{0xe7cb012f,0x1fb50377,0x00000000,0x00000000}},	//   ाधिप, дстр, --, --,
   {{0x7d04368e,0x3e6e008a,0x71a6368f,0x6d4f02a7}},	//   tsis, _nýtt_, _найз, _brca,
   {{0xe81c04bc,0xed573690,0x44e0298d,0x6d4f009e}},	// [2d60] _नाला_, пот_, _xò_, _crca,
   {{0x7d043691,0x320200ac,0xe05800d1,0x99dd00a0}},	//   rsis, laky_, _بیست_, _raňa,
   {{0x66001ea7,0x8ad600f3,0x2baf0066,0x7d040147}},	//   yamk, ستائ, _जुदा, ssis,
   {{0x32020187,0x7d043692,0xfaa312ea,0x1c1e00ab}},	//   naky_, psis, нахо, _पावल_,
   {{0x6d4f0156,0xbddb0118,0x7d040055,0x9f580392}},	//   _grca, _maèl, qsis, larà_,
   {{0x44e000e2,0xf7720079,0x79820035,0x91bb00a5}},	//   _rò_, فاع_, rzow, זמני,
   {{0xa3ab0f9c,0x44e03693,0x6d4f3694,0x9f580443}},	//   _कुल_, _sò_, _zrca, narà_,
   {{0x44e01bbf,0x32020187,0x7e64022e,0x09d10033}},	//   _pò_, jaky_, njip, াড়া,
   {{0x320200ee,0x6600028b,0x1dbe0edf,0xa3c90cea}},	//   daky_, ramk, ्धित, लेस_,
   {{0x69c00bc6,0x628d1093,0x66003695,0xa3e61140}},	//   _izme, _smao, samk, युं_,
   {{0xd25100bf,0x44e00260,0x9f580392,0x00000000}},	//   نند_, _wò_, jarà_, --,
   {{0xa75b00a5,0x44e03696,0x1dbe00e7,0x9f580443}},	//   _לדבר, _tò_, ्धात, darà_,
   {{0xc05b00d4,0x442e3697,0x290602c4,0x6ed629ce}},	//   бів_, _tbf_, nsoa_, _मंजु,
   {{0x26de3698,0x22921bd8,0x98bf00cd,0x9f580176}},	//   _kuto_, rška_, _vruć_, farà_,
   {{0xb5fd02dd,0x64583699,0xcfa40043,0x7ae9042a}},	//   ljša, _invi, ешти, _četo,
   {{0x81ac00c8,0x02a401c8,0x26de018c,0xbddb0176}},	//   কেই_, _прым, _muto_, _gaèl,
   {{0x2d580086,0xb5fd008b,0x442c369a,0x00000000}},	// [2d70] пить_, njša, ofd_, --,
   {{0xebc70274,0x9f580443,0x6d4f00f4,0x26de0328}},	//   пљен, barà_, _vrca, _outo_,
   {{0x2003369b,0x6448001e,0x629d369c,0xddc6021e}},	//   maji_, iddi, onso, _lakň,
   {{0x2003369d,0x6d4f0124,0x629d24ac,0x2ea80099}},	//   laji_, _trca, nnso, ककृत,
   {{0x1869059b,0x9f581ea3,0x64580a8d,0x6d4f00af}},	//   жали_, mará_, _onvi, _urca,
   {{0x26de369e,0x2003369f,0x9f580181,0x629d36a0}},	//   _buto_, naji_, lará_, hnso,
   {{0x47d00083,0x6d4d36a1,0x60df03da,0xa6c9167d}},	//   _স্বী, lvaa, _luqm, олка_,
   {{0x9f580152,0x6e2d36a2,0xa3c20440,0x442c01e4}},	//   nará_, nfab, ्धन_, efd_,
   {{0x6d4d1816,0x200336a3,0x320200ac,0x442c02d7}},	//   nvaa, kaji_, vaky_, ffd_,
   {{0xd7c801cb,0x200336a4,0xd90d006c,0x99dd00ac}},	//   _کومه_, jaji_, _میچ_, _kaňo,
   {{0x200336a5,0x06d70083,0x3e7c0093,0x26de36a6}},	//   daji_, _সবকি, _líta_, _guto_,
   {{0x64480a21,0x9f5836a7,0x60c50159,0x66d500c7}},	//   addi, jará_, _ahhm, _iško,
   {{0x9f580152,0x51550043,0x320236a8,0x76590298}},	//   dará_, нтру, raky_, _inwy,
   {{0x9f580443,0x20030054,0x320200d5,0x7649246a}},	//   tarà_, gaji_, saky_, ldey,
   {{0x4aad009a,0xa3c900c4,0x69db0069,0x752936a9}},	//   टकाव, लेश_, _ogue, ltez,
   {{0x9f5836aa,0x764936ab,0x00000000,0x00000000}},	//   gará_, ndey, --, --,
   {{0x752936ac,0xfbd200fd,0xe8df0019,0xdb0e00b8}},	// [2d80] ntez, چتا_, _trộn_, _vybí,
   {{0x7e7d36ad,0x69db1e60,0xfbd2250f,0x20030121}},	//   _elsp, _ague, نتا_, caji_,
   {{0x9f5821a4,0xaec636ae,0x6d4d36af,0x68fb0118}},	//   bará_, _обол, avaa, _awud,
   {{0x99dd024e,0x9f5836b0,0x290600c3,0x26de36b1}},	//   _daňo, cará_, tsoa_, _ruto_,
   {{0x644802c7,0x76491481,0x752936b2,0xa967052c}},	//   yddi, ddey, jtez, мица_,
   {{0xd6ea150d,0x2906043f,0x3ead008b,0x69db01d7}},	//   офил_, rsoa_, čete_, _egue,
   {{0x29060370,0x7bdc011e,0x786f0a8a,0x00000000}},	//   ssoa_, _igru, _røvt, --,
   {{0x20030657,0xc9560086,0x786f0a8a,0x00000000}},	//   zaji_, _отзы, _bøvs, --,
   {{0x69c036b3,0x6f1c36b4,0x200336b5,0x26de0118}},	//   _uzme, hurc, yaji_, _wuto_,
   {{0x26de01c0,0x9f582132,0x162000a1,0x64481e77}},	//   _tuto_, zará_, _यावर_, uddi,
   {{0xd62a0e8b,0x644836b6,0x200336b7,0x7d160c0b}},	//   _може_, rddi, vaji_, hrys,
   {{0x68e036b8,0x6f1c01ae,0x20030054,0x9f582314}},	//   _kumd, durc, waji_, xará_,
   {{0x20030657,0x9f580152,0x752936b9,0x629d1e2e}},	//   taji_, vará_, ctez, rnso,
   {{0x656f01ae,0xc058291f,0x7d1636ba,0x7bdc00d1}},	//   äche, міс_, drys, _ngru,
   {{0x9f582140,0x26c636bb,0xf41302b8,0xa29500d8}},	//   tará_, _khoo_, _ספק_, _пакі,
   {{0x7bdc0876,0x4ea407c1,0x7d1613dc,0x6d4d2b37}},	//   _agru, вруа, frys, tvaa,
   {{0x9f582132,0x20032f10,0xdd94021f,0xf1a4010b}},	// [2d90] rará_, paji_, ваты, _арэн,
   {{0x31560052,0x6d4d36bc,0x9f582132,0x60c50159}},	//   _ניתן_, rvaa, sará_, _uhhm,
   {{0x9f581fca,0x6f1c00af,0x224936bd,0x6d4d36be}},	//   pará_, curc, _kaak_, svaa,
   {{0x75290031,0x224900be,0x3a240160,0x6d4d02a2}},	//   ytez, _jaak_, _ccmp_, pvaa,
   {{0x224936bf,0x801809b9,0xf5480019,0xd90f0416}},	//   _maak_, _عزیز_, _nụ_, شیا_,
   {{0x22490051,0x7bdc0069,0x2b4301f7,0x00000000}},	//   _laak_, _ggru, _tsjc_, --,
   {{0x7afc001e,0x38c9006c,0x200100ab,0xcb690698}},	//   _gwrt, _ہائی_, _mehi_, _عمره_,
   {{0x26c636c0,0x06090f94,0x22492c55,0x752936c1}},	//   _choo_, чник_, _naak_, ttez,
   {{0xf5480028,0x2a7f0008,0x75290036,0x764936c2}},	//   _cụ_, _ilub_, utez, rdey,
   {{0x2a7f01a9,0xf54801a5,0x291d018e,0x336536c3}},	//   _hlub_, _dụ_, muwa_, евог,
   {{0xa3c90b4a,0x224936c4,0xe8d600a5,0x291d36c5}},	//   लें_, _baak_, _נוער_, luwa_,
   {{0xbbdc0953,0xe61001cb,0x25a00612,0x229203c9}},	//   _बल्क, _نشه_, _žile_, rško_,
   {{0x200101a3,0x787401f7,0x45220033,0x291d2206}},	//   _behi_, _sàvi, _বৈঠক_, nuwa_,
   {{0x6f1c36c6,0x03a505f2,0x2a6d36c7,0xd11c0581}},	//   turc, _пило, _loeb_, भूषण_,
   {{0xc7b20779,0x2baf2088,0x2a7f01c2,0x291d1047}},	//   ָבן_, _जुला, _olub_, huwa_,
   {{0x291d225e,0x9f5c2ea0,0x68330092,0x7d1636c8}},	//   kuwa_, _því_, lıdı, trys,
   {{0xafe62e50,0x291d002f,0xe3b80225,0xec7a02ee}},	// [2da0] _попл, juwa_, ngın_, ппа_,
   {{0x2a661bc5,0x64572cad,0x22490120,0xb21b01b4}},	//   wjob_, _óxid, _zaak_, nhæn,
   {{0x2a660024,0xddcd05e2,0x3ce50354,0x68e00069}},	//   tjob_, rkaš, _झूठे_, _sumd,
   {{0x09e636c9,0x2a7f36ca,0x394400e7,0xb90610b0}},	//   ходн, _club_, _psms_, ездк,
   {{0x291d36cb,0x2a662a86,0x3ea036cc,0xe2970070}},	//   guwa_, rjob_, mnit_, עכנט_,
   {{0x6d4636cd,0x3b0a1906,0x3ea036ce,0x7bdc36cf}},	//   _iska, _него_, lnit_, _ugru,
   {{0x61bd0026,0x3ea001f4,0x26c6006d,0xdca3034b}},	//   _ईर्ष, onit_, _phoo_, _сари,
   {{0x3ea036d0,0x291d2ed0,0x940500a8,0x26cd01ef}},	//   nnit_, buwa_, milə_, gmeo_,
   {{0x22490626,0x3ea036d1,0xb21b01cf,0x672a3315}},	//   _raak_, init_, fhæn, stfj,
   {{0xf54800e8,0x22490173,0x63860e8c,0x3ea036d2}},	//   _vụ_, _saak_, _néné, hnit_,
   {{0x7ae91b8d,0x26c636d3,0x224936d4,0xd76400f8}},	//   _četk, _thoo_, _paak_, _جنای,
   {{0x6d4636d5,0x09d40083,0xf5480019,0x7c3e36d6}},	//   _oska, _হ্যা, _tụ_, hepr,
   {{0x638602e1,0x22490a75,0x3ea00355,0x37d50033}},	//   _béné, _vaak_, dnit_, _স্পর,
   {{0x7c3e0532,0x660236d7,0x3ea00328,0x224903bc}},	//   jepr, _heok, enit_, _waak_,
   {{0x6d4636d8,0x9f3401e0,0xbfa8167d,0x224903c4}},	//   _aska, лері, етте_, _taak_,
   {{0x644a274d,0x20010118,0x6267234a,0x3ea036d9}},	//   _hafi, _wehi_, _سابق, gnit_,
   {{0xdb0e024e,0x61ed36da,0x64840284,0x6d4601ed}},	// [2db0] _rybá, _ifal, _còig, _cska,
   {{0x63861010,0x64840014,0xe81c0380,0x3ea036db}},	//   _géné, _dòig, _नागा_, anit_,
   {{0x6d4603cb,0xa3c20240,0x7f4500da,0x443e36dc}},	//   _eska, ्धि_, _ushq, iet_,
   {{0x443e36dd,0x644a36de,0x81ac00c8,0x291d36df}},	//   het_, _lafi, কেও_, tuwa_,
   {{0xd9451a56,0x61ed36e0,0x7c3e36e1,0x683305f9}},	//   тели, _mfal, bepr, yıdı,
   {{0x443e36e2,0xa3c236e3,0xe73927e9,0x291d36e4}},	//   jet_, ्धा_, дек_, ruwa_,
   {{0x443e0304,0x291d36e5,0x94240095,0x61ed00e9}},	//   det_, suwa_, _ötən_, _ofal,
   {{0x81ac0083,0x443e00c3,0x2f5c0070,0x291d067f}},	//   কেট_, eet_, לדונ, puwa_,
   {{0x443e36e6,0x644a0232,0x26cd36e7,0x999f023a}},	//   fet_, _bafi, rmeo_, _fauš_,
   {{0x443e0c66,0x3ea036e8,0x9b44006c,0x61ed36e9}},	//   get_, znit_, _جنہو, _afal,
   {{0x03a521be,0x644a36ea,0x53a536eb,0x70270033}},	//   тино, _dafi, танб, য়াজ_,
   {{0x7c3e004e,0x6833037a,0x638600f7,0xe1ff008d}},	//   zepr, sıdı, _séné, sjón_,
   {{0x443e36ec,0x638600f7,0x64840284,0x3ea00355}},	//   bet_, _péné, _bòid, vnit_,
   {{0x61ed0297,0x764b006c,0x66020009,0x644a04fb}},	//   _efal, _hagy, _zeok, _gafi,
   {{0xdee636ed,0x7c3e36ee,0x6386000d,0x3ea036ef}},	//   тоби, vepr, _véné, tnit_,
   {{0x940500a8,0x3ea00c6f,0x99dd007e,0x00000000}},	//   vilə_, unit_, _daňk, --,
   {{0x764b00f5,0x7c3e36f0,0x3ea036f1,0x644a276d}},	// [2dc0] _magy, tepr, rnit_, _yafi,
   {{0x3ea036f2,0x711b02b5,0x94050095,0x764b067f}},	//   snit_, _קויפ, tilə_, _lagy,
   {{0x290d0012,0x7c3e36f3,0x6d46004e,0x09ca0afa}},	//   _avea_, repr, _wska, िध्य,
   {{0x443e36f4,0x764b00f5,0x7c3e36f5,0x442700a2}},	//   zet_, _nagy, sepr, _lcn_,
   {{0x443e36f6,0x94050095,0x6d4636f7,0x442700e5}},	//   yet_, silə_, _uska, _ocn_,
   {{0x443e36f8,0x68ed0a39,0x660236f9,0x3cfb0354}},	//   xet_, íada, _seok, _लौटे_,
   {{0x443e02df,0x644a36fa,0x764b36fb,0x37d50083}},	//   vet_, _rafi, _bagy, _স্বর,
   {{0x443e36fc,0x6e2436fd,0x44270443,0xddc60107}},	//   wet_, ngib, _acn_, _lakō,
   {{0x7ae901cc,0x48e602ce,0x442736fe,0x443e0b73}},	//   _četi, _розв, _bcn_, tet_,
   {{0x443e27b5,0xe8c700af,0x644a36ff,0x545300c3}},	//   uet_, _агул_, _qafi, авьт,
   {{0x443e3700,0x8c1b00c2,0x261b02cb,0x61ed033b}},	//   ret_, וויי, _याची_, _pfal,
   {{0x443e3701,0x92580086,0x644a002f,0x44273702}},	//   set_, вают_, _wafi, _ecn_,
   {{0x443e3703,0x644a3704,0x44273705,0x3e7501ff}},	//   pet_, _tafi, _fcn_, _mått_,
   {{0x8438004f,0x443e00da,0x7414006c,0x1c1e13a0}},	//   _أكثر_, qet_, _صوبا, _पागल_,
   {{0x61fb008e,0x6aa23706,0x764b030d,0x00000000}},	//   ðuls, knof, _yagy, --,
   {{0x2ebf2177,0x6e243707,0x61ed36e0,0x62863708}},	//   ्षेत, ggib, _ufal, chko,
   {{0x51871112,0x6aa2189a,0xfd74002d,0xa3c20ca1}},	// [2dd0] _шука, dnof, алтэ, ्धव_,
   {{0x04140083,0x673a3709,0xfdc300b4,0x00000000}},	//   ত্রী_, _optj, _शरीफ, --,
   {{0xc61a0033,0x76400421,0x2cb302d7,0xdfd10413}},	//   থ্যা_, kemy, roxd_, _ديد_,
   {{0xb21b01b4,0xdea100fd,0x6aa20298,0x00000000}},	//   skæf, _ایری, gnof, --,
   {{0x7640370a,0x66ea0035,0x0d6402fb,0x8d870fb4}},	//   demy, _ręka, _кърм, _рунд,
   {{0xb4ac000c,0xfaf31015,0x66d5010b,0x17c90369}},	//   कको_, _نثر_, _iški, нгли_,
   {{0x3e750533,0x442700de,0x764b370b,0x7d0d370c}},	//   _fått_, _rcn_, _pagy, lsas,
   {{0x7bc72c14,0x3e75370d,0x25a01e85,0x6aa20036}},	//   _izju, _gått_, _žila_, cnof,
   {{0x764b0332,0xdd1206d3,0x9555004f,0x39b80043}},	//   _vagy, _müşt, اخبا, _алтэ_,
   {{0x7c25370e,0x6e2413a6,0x764b030d,0x9f5102d7}},	//   nghr, zgib, _wagy, nazó_,
   {{0xe29a12da,0x7c250079,0x6d440067,0x229200f4}},	//   еан_, ighr, zwia, lški_,
   {{0x7d0d370f,0xad9b08c0,0x9555028c,0x23780185}},	//   ksas, _reún, _مختا, ørja_,
   {{0xd5bb01c8,0x9f583710,0x229202f6,0x6484009e}},	//   _ўсе_, mbré_, nški_, _dòib,
   {{0x628600da,0x20cf0024,0xd3780067,0xe7f8018d}},	//   shko, _bżiq_, być_, ुरया_,
   {{0xe81b009a,0xe29a17e3,0xa3c90f3d,0x44e93711}},	//   _नयना_, _пак_, लेख_, _hú_,
   {{0x64413712,0x539a011d,0x26dd0118,0x44e9008e}},	//   leli, _ריקו, _jiwo_, _kú_,
   {{0xa3e70992,0x44e9008a,0x7d0d0269,0x62843713}},	// [2de0] _भला_, _jú_, gsas, _ilio,
   {{0x64412de7,0x44253714,0x7640004e,0x629d0187}},	//   neli, ngl_, zemy, érov,
   {{0x44e9004f,0x66093715,0x61e93716,0x6441002d}},	//   _lú_, kaek, žele, ieli,
   {{0xa3ab3717,0x64413718,0x200a3719,0xaaba03c5}},	//   _कुछ_, heli, labi_, ردار_,
   {{0x44e9064b,0xd378004e,0x6284002f,0x9f4100cc}},	//   _nú_, zyć_, _mlio, _nghê_,
   {{0x6441371a,0x7ae901cc,0x200a0269,0x2242003c}},	//   jeli, _četv, nabi_, hekk_,
   {{0x64410b0f,0xd6da0e8b,0x26dd02e9,0x764018f9}},	//   deli, нти_, _biwo_, temy,
   {{0x44e9371b,0x6441371c,0x60de00ec,0x151401af}},	//   _bú_, eeli, _lipm, адия,
   {{0x6441371d,0x49ca03fa,0x76400010,0x44e9371e}},	//   feli, _члан_, remy, _cú_,
   {{0x6441371f,0x6284000e,0x27f7000c,0x75203720}},	//   geli, _alio, čení_, rumz,
   {{0xd7ef004f,0x44e901ba,0x23ce00b4,0x00000000}},	//   _ركن_, _eú_, हेंद, --,
   {{0x8ccb0084,0x628400f1,0x75200054,0x7d0d3721}},	//   _तीनो, _clio, pumz, ysas,
   {{0x628401da,0xd3780067,0x00000000,0x00000000}},	//   _dlio, syć_, --, --,
   {{0x64413722,0x224d3723,0x62843724,0x200a3725}},	//   celi, žek_, _elio, gabi_,
   {{0x447b00c2,0xdfd51397,0x7d0d00d7,0x1ee700d1}},	//   _אנגע, ровы, wsas, اوری_,
   {{0x62843726,0x3ead3727,0x7d0d3728,0xe3131015}},	//   _glio, četo_, tsas, _ابوب,
   {{0xe2140ad9,0x200a3729,0xddc600c7,0xf1bf2e22}},	// [2df0] _طبيع, babi_, _pokš, rfás_,
   {{0x7d0d372a,0x320b0035,0xac770088,0x00000000}},	//   rsas, lacy_, دارش, --,
   {{0x62840086,0x9f510138,0x9f530a8a,0x7c250098}},	//   _ylio, razó_, _nexø_, rghr,
   {{0xa3c90fbf,0x7c250037,0xdb1c0031,0x639b0070}},	//   लेट_, sghr, _zyrë, עסאנ,
   {{0x4425001e,0x6441372b,0x66d5023a,0x7ae908b7}},	//   ygl_, yeli, _uški, _četu,
   {{0x07090413,0x7e6d007c,0x229218b0,0x26dd02d0}},	//   نيتي_, ljap, rški_, _siwo_,
   {{0x44e9372c,0xb5fd008b,0x26dd372d,0x00000000}},	//   _sú_, ljši, _piwo_, --,
   {{0x7f3c02b5,0x6441372e,0xb8eb0033,0xd8380107}},	//   געהו, weli, _রং_, _ebč_,
   {{0xc485192f,0xe8df0019,0x26c30029,0xa2c4112b}},	//   илик, _trốn_, ējo_, रतस्,
   {{0x99840082,0x7ae700da,0xa3c2022e,0x6284184f}},	//   _الكو, _kujt, ्धं_, _slio,
   {{0x6266372f,0x628403d0,0x200a3730,0x386a0176}},	//   авна, _plio, vabi_, _òbra_,
   {{0x44e90514,0xe29a35f7,0xc5d502ce,0x67233731}},	//   _tú_, там_, _кіль, munj,
   {{0x64413732,0x273100e8,0xa3c920d8,0x200a3733}},	//   peli, _hơn_, लेज_, tabi_,
   {{0xe3b000d1,0x69c9034d,0x00000000,0x00000000}},	//   _کره_, _mzee, --, --,
   {{0x67230f1a,0xb4c310aa,0x200a3734,0x6abb09d6}},	//   nunj, ्षी_, rabi_, _okuf,
   {{0x62840657,0x200a0269,0x320b024b,0x6aa90055}},	//   _ulio, sabi_, cacy_, _njef,
   {{0xb2bb0122,0x61e43735,0x614603e6,0xfde7141d}},	// [2e00] _במקר, _igil, _тепа, рдук_,
   {{0x6abb3736,0xf8a50647,0xc5d70033,0xf1bf3737}},	//   _akuf, _رک_, _সভাপ, ogán_,
   {{0x0b461747,0xa3c90099,0x6aa90044,0x7ae70207}},	//   рнен, लेच_, _bjef, _cujt,
   {{0x533600c2,0xb4c122d4,0x67230506,0xb4c30096}},	//   ינען_, ंतु_, dunj, ्षु_,
   {{0x656f01ae,0x68460009,0xe6da0093,0x3a260051}},	//   ächl, инда, ðsíð, rgop_,
   {{0x57f31c56,0x6abb030d,0x657b0159,0xfb2600d1}},	//   општ, _ekuf, dyuh, _پرسپ,
   {{0x273101a5,0x61e401ff,0x76aa0ce3,0xa7b83122}},	//   _cơn_, _ogil, ктив_, ылку_,
   {{0x66c5008a,0x61e400d1,0xfaa62c6a,0x2baf00c0}},	//   sókn, _ngil, _табо, _जुटा,
   {{0x320b3738,0x3e7c07c0,0x54b80382,0x661d05ee}},	//   vacy_, _cíti_, лгия_, óska,
   {{0x67230254,0x78ba005f,0x3d191604,0x7e6d0207}},	//   bunj, _uktv, _पिसे_, zjap,
   {{0x94730514,0x7ae03739,0x00000000,0x00000000}},	//   تديا, _kimt, --, --,
   {{0x48fd000c,0x9f61000d,0x7ae0009f,0x00000000}},	//   रीको_, _épée_, _jimt, --,
   {{0xe29801c8,0x64a63296,0x320b373a,0xe69302fd}},	//   раў_, _када, racy_, _بلند,
   {{0x61e40b92,0x69c00298,0x653b0317,0x7ae0093a}},	//   _egil, _myme, _סעוד, _limt,
   {{0xcebb03fa,0xa3b70416,0x69c00051,0xddc60035}},	//   вља_, _پاور_, _lyme, _nakł,
   {{0xdc0f0761,0x33db00a5,0x70270033,0x7ae0373b}},	//   ाण्ड_, _בחוד, য়েও_, _nimt,
   {{0x629d373c,0xe1ff2f21,0x7e6d02e2,0x0e08002d}},	// [2e10] miso, mbó_, rjap, рэси_,
   {{0x629d0119,0xfd4d0028,0x6abb0c71,0x91bc0122}},	//   liso, _khoả, _skuf, _במחי,
   {{0x69c00815,0x7ae0021d,0xbfab0043,0x00000000}},	//   _ayme, _bimt, _штие_, --,
   {{0x67232f59,0x69c0053e,0x9f4100e2,0x6d4b008d}},	//   vunj, _byme, _nghé_, ægas,
   {{0x27310028,0x69c0001e,0xc8790139,0x00000000}},	//   _sơn_, _cyme, _huşi_, --,
   {{0x672326fb,0x6c85004f,0x6d9e0069,0x00000000}},	//   tunj, _السم, _dħaħ, --,
   {{0x629d14d5,0x3e7c0355,0x7ae0373d,0x00000000}},	//   kiso, _síti_, _fimt, --,
   {{0xe518018d,0x9aa500bf,0x7ae000d8,0x6abb034d}},	//   _दिशि_, _امرو, _gimt, _ukuf,
   {{0x1fd4051d,0xddc6004e,0x69c0001e,0x787d0176}},	//   _दण्ड, _zakł, _gyme, _lèvi,
   {{0xd8740082,0x67230a78,0xb4c304eb,0x61e4373e}},	//   _والب, punj, ्षे_, _sgil,
   {{0xdb1c0248,0x7ae0006d,0x657b373f,0xf1d009b1}},	//   _pyré, _yimt, syuh, _सृजन,
   {{0x629d3740,0xeb3a0070,0x00000000,0x00000000}},	//   giso, נערש, --, --,
   {{0x68e10909,0x940c00a8,0x00000000,0x00000000}},	//   _kild, hidə_, --, --,
   {{0x03790a86,0x23293741,0x68e90118,0x629d2386}},	//   _محبت_, _боки_, _mued, aiso,
   {{0x629d3742,0x1eaa0312,0x00000000,0x00000000}},	//   biso, هاري_, --, --,
   {{0x629d2dd3,0x681b00ea,0x1ea911c0,0x6e3b02d7}},	//   ciso, lādē, لاقي_, _ñubl,
   {{0x68e9012f,0x6ab9009e,0x7ae0010b,0x64840284}},	// [2e20] _nued, dowf, _rimt, _mòin,
   {{0x7ae93743,0x7ae03744,0x22920009,0xcb6a03fa}},	//   _četr, _simt, ršku_, лазе_,
   {{0x6f63002d,0x6d4b003e,0x00000000,0x00000000}},	//   _евэз, ægar, --, --,
   {{0x68e9008c,0x7f3b02b5,0x69c000de,0x68e100e9}},	//   _bued, _געטו, _pyme, _aild,
   {{0x68e10185,0x7ae0006d,0x391300d4,0x9f5a0282}},	//   _bild, _vimt, змір, _depå_,
   {{0xb4c30433,0x69c00237,0x629d18f9,0xbcfb0093}},	//   ्षो_, _vyme, ziso, _bréf,
   {{0xd6d0211f,0x394d0391,0xbb86004f,0x78b807e5}},	//   وقت_, _eses_, _الأي, rovv,
   {{0xdd080038,0x5678186f,0x44f407be,0x629d3745}},	//   _môže, рбия_, опис, xiso,
   {{0x68e93746,0x68e109e1,0xc9aa00d8,0x6484009e}},	//   _gued, _fild, _свае_, _dòin,
   {{0x68e1008a,0x04662c51,0x629d016e,0x44fb02d7}},	//   _gild, стим, wiso, _dª_,
   {{0x629d3747,0x291901bc,0x00000000,0x00000000}},	//   tiso, _åsar_, --, --,
   {{0x68e10183,0x25a900cd,0xc8790395,0x00000000}},	//   _zild, _žale_, _ruşi_, --,
   {{0x629d3748,0x787d0c1f,0x68e10225,0xe1ff3749}},	//   riso, _sèvi, _yild, rbó_,
   {{0x68e101ef,0x629d374a,0xfd4d0019,0xc8790395}},	//   _xild, siso, _thoả, _puşi_,
   {{0x629d1834,0x66d500c7,0xe7f00067,0xe43700a5}},	//   piso, _iškr, _चलना_, _הרוח_,
   {{0x2a6400d7,0x443c09b3,0x9df91b50,0x7c2e0183}},	//   _nnmb_, _hbv_, рнат_, _acbr,
   {{0xe29f00fb,0x5c7505c7,0x66f100ec,0xa3c202d1}},	// [2e30] mið_, олат, _māka, ्धक_,
   {{0xe29f00fb,0x68e9374b,0x6ad10026,0xa3cf0864}},	//   lið_, _rued, तग्र, _शरम_,
   {{0xe80c0084,0x68e9374c,0xda7b1112,0x7bda0187}},	//   _सज़ा_, _sued, ляд_, _útul,
   {{0x68e90b52,0xe29f008a,0x66f10080,0x68e1374d}},	//   _pued, nið_, _nāka, _sild,
   {{0x68e9374e,0x68e1374f,0x3ea93750,0xa96913f9}},	//   _qued, _pild, mnat_, рила_,
   {{0xbcfb02e1,0x46f50150,0x68e11505,0xaf3401cb}},	//   _préf, очит, _qild, _بریت,
   {{0xe29f064b,0x68e13751,0x3ea93752,0xf77121a0}},	//   kið_, _vild, onat_, ظات_,
   {{0x3ea93753,0xb4c30066,0x68e13754,0xa3bc0066}},	//   nnat_, ्ष्_, _wild, _आड़_,
   {{0x68e10c61,0xe29f008a,0x94250395,0x394d00a5}},	//   _tild, dið_, омпе, _uses_,
   {{0x3ea93755,0x6d5d2d00,0xada300d5,0xa4d60200}},	//   hnat_, _mrsa, moúč, одњу_,
   {{0xe29f00fb,0x37ab3756,0x3ea93757,0x443c0345}},	//   fið_, _стан_, knat_, _dbv_,
   {{0x6d4f3758,0xe29f00fb,0x6d5d3759,0x442e0526}},	//   _osca, gið_, _orsa, _ecf_,
   {{0xa50907be,0x3ea901c0,0xbbc60e62,0x2056218b}},	//   _тела_, dnat_, _वर्क, отвр,
   {{0x39400095,0x00000000,0x00000000,0x00000000}},	//   çisi_, --, --, --,
   {{0x6d5d375a,0xafe30210,0x935800af,0xe3d70033}},	//   _arsa, дорл, _грыу_, _দ্রব,
   {{0x3ea9375b,0xd5f90070,0xbddb0107,0x00000000}},	//   gnat_, שפּר, _obèd, --,
   {{0x660b0332,0x3ce30120,0x648d0037,0x6d5d009e}},	// [2e40] _megk, _bijv_, _cúig, _crsa,
   {{0x85210b4a,0x3ea922be,0x660b375c,0xa7fc033e}},	//   _मिनट_, anat_, _legk, _anın,
   {{0x6d5d375d,0x6d4f375e,0xbddb23e2,0x3ea90159}},	//   _ersa, _esca, _abèd, bnat_,
   {{0x00000000,0x00000000,0x00000000,0x00000000}},	//   --, --, --, --,
   {{0xbcfb375f,0x1958081b,0x3ea03760,0x82d70070}},	//   _créd, салы_, miit_, קונג_,
   {{0x3ea03761,0xd838025c,0xb4b30461,0x66f100ea}},	//   liit_, _omče_, झको_, _sāka,
   {{0xbcfb3762,0x443c0051,0x8cb904cc,0x00000000}},	//   _prég, _rbv_, ्तरो, --,
   {{0x3ea03763,0x7bce273a,0xbcfb00f7,0x9f58283e}},	//   niit_, _izbu, _fréd, laró_,
   {{0xe29f008d,0x442e00a2,0x2d800cdf,0x6484009e}},	//   við_, _pcf_, nyie_, _fòil,
   {{0x3ea91592,0x3ead15d7,0x7a400093,0xf7463379}},	//   znat_, četi_, _fátæ, _мезо,
   {{0xe29f064b,0xa3cf2516,0xbcfb216e,0x442e2348}},	//   tið_, _शरण_, _trég, _vcf_,
   {{0x442e0024,0x81af0083,0x00000000,0x00000000}},	//   _wcf_, _করব_, --, --,
   {{0xe29f064b,0x3ea900b8,0x3ea03764,0x443c0051}},	//   rið_, vnat_, diit_, _tbv_,
   {{0xe29f008a,0xf8ca0461,0x66d500d5,0xddcf0160}},	//   sið_, ितिय, _uškr, _locţ,
   {{0x3f850076,0xc05802ce,0x4fc40ed2,0xe29f0093}},	//   álu_, ція_, дста, pið_,
   {{0x64483765,0x3ea008dd,0xe298015a,0x442c3766}},	//   ledi, giit_, _мај_, lgd_,
   {{0x3ea93767,0x7bce3768,0x3f851587,0xf8ca0067}},	// [2e50] rnat_, _azbu, šlu_, िताय,
   {{0x64483769,0x442c237a,0x3e7c05ee,0x6d5d0124}},	//   nedi, ngd_, _sítt_, _vrsa,
   {{0x442c01e4,0x3ea9376a,0xa8010138,0x00000000}},	//   igd_, pnat_, _íñig, --,
   {{0x2011376b,0xbcfb376c,0x6448376d,0x6d5d022f}},	//   lazi_, _préd, hedi, _trsa,
   {{0x6d4f376e,0x6448376f,0x6d5d3770,0x6f153771}},	//   _usca, kedi, _ursa, lszc,
   {{0x64480537,0xbcfb02e1,0x20113772,0x1fdf0033}},	//   jedi, _crée, nazi_, _ব্যস,
   {{0x64483773,0x6d4d3774,0x3e7c05ee,0xf7730ae7}},	//   dedi, lwaa, _títt_, باش_,
   {{0x6e2d3775,0x20113776,0xbcfb0079,0x442c02a2}},	//   ngab, hazi_, _tréd, egd_,
   {{0x201118a6,0x6d4d3777,0x64483778,0x64a5338e}},	//   kazi_, nwaa, fedi, запа,
   {{0xa3cf3779,0x68fb011e,0x660b237e,0x2011377a}},	//   _शरद_, _itud, _wegk, jazi_,
   {{0x6d4d0069,0xe7f00461,0x395f0118,0x660b0118}},	//   hwaa, _चलता_, _hrus_, _tegk,
   {{0x6d4d377b,0x442c0a75,0x395f377c,0xbddb0118}},	//   kwaa, agd_, _krus_, _mbèb,
   {{0x7649030d,0x6448377d,0x3ea000b9,0x6f150035}},	//   meey, bedi, viit_, eszc,
   {{0x6448377e,0x7649073a,0x201101a8,0x6d4d377f}},	//   cedi, leey, gazi_, dwaa,
   {{0x6e2d02c9,0x3ea03780,0x66f100ea,0x3a3f02a7}},	//   fgab, tiit_, _māko, _obup_,
   {{0x7649001c,0x628f3781,0x6d4d1e7e,0x88d10033}},	//   neey, chco, fwaa, াদিক,
   {{0x20113782,0x9f580443,0x3ea03783,0x395f006d}},	// [2e60] bazi_, taró_, riit_, _nrus_,
   {{0x31370052,0x66f10029,0x3ea03784,0x62863785}},	//   _צריך_, _nāko, siit_, lkko,
   {{0x7649030d,0x307b0122,0x395f124f,0x68fb018e}},	//   keey, _האינ, _arus_, _atud,
   {{0x31603786,0x395f3787,0x66c5008d,0x7bce3788}},	//   _kriz_, _brus_, bóki, _vzbu,
   {{0x7649073a,0x442c3789,0x9f580453,0x67230009}},	//   deey, ygd_, paró_, ernj,
   {{0x644801dd,0x648d0098,0x75290065,0x00000000}},	//   xedi, _lúib, duez, --,
   {{0x7bce378a,0x68fb378b,0xa737004f,0xbb431b2e}},	//   _uzbu, _etud, كثير_, _перк,
   {{0xd90d0a86,0x2011000e,0x7649030d,0x6448001e}},	//   _چین_, zazi_, geey, wedi,
   {{0x64480723,0xd90d0594,0x7d16378c,0x75290065}},	//   tedi, _نین_, nsys, guez,
   {{0x6aa20054,0x6f150035,0x67230ce9,0x648401da}},	//   liof, yszc, brnj, _tòim,
   {{0x7649001c,0x6448378d,0x442c0120,0x20110054}},	//   beey, redi, rgd_, vazi_,
   {{0x2011378e,0xa25b0248,0x31600107,0x7d162f44}},	//   wazi_, plôm, _briz_, ksys,
   {{0x6448378f,0x7aee01e8,0x20113790,0xd62701e0}},	//   pedi, _lubt, tazi_, _хоче_,
   {{0x7d160cd9,0x62860051,0xe4d700f8,0xe5210355}},	//   dsys, akko, _فونت_, _मिति_,
   {{0x20113791,0x643b0122,0x543b0070,0x31600065}},	//   razi_, _העונ, _לעגא, _eriz_,
   {{0x8c090033,0x6d4d3792,0x59dc00b4,0x2011010a}},	//   _লাইন_, twaa, यधार, sazi_,
   {{0x6e2d3793,0x7d162357,0x20113794,0x6d4d0159}},	// [2e70] rgab, gsys, pazi_, uwaa,
   {{0x6d4d06ba,0x6e2d3795,0x787d00f7,0x224b0bf7}},	//   rwaa, sgab, _lèvr, leck_,
   {{0x81af00c8,0x6d4d3796,0x7649001c,0x628d0124}},	//   _করি_, swaa, yeey, _klao,
   {{0x225902df,0x7aee12c3,0x66f10029,0xfbd0004f}},	//   ndsk_, _dubt, _sāko, اتك_,
   {{0x6d4d046a,0x81df0083,0x2d4d00cd,0x224b02b1}},	//   qwaa, দুর_, _uže_, ieck_,
   {{0x81af0b52,0x7649001c,0x224b3797,0xccf200a5}},	//   _করা_, weey, heck_, _בכך_,
   {{0xe73917c7,0x7649073a,0x6aa200d5,0x44f2099e}},	//   цей_, teey, biof, _aâ_,
   {{0x61e90496,0xbcfb01ba,0x395f00d1,0x65640009}},	//   želj, _gréc, _trus_, _šiha,
   {{0xb3450370,0x395f3798,0x3944028b,0x09db0033}},	//   _opçã, _urus_, _gpms_, _ড্রা,
   {{0x7649073a,0x212b0187,0xdeff003c,0x628d3799}},	//   seey, duch_, ċċju_, _alao,
   {{0xdc380070,0x78a3379a,0x628d026e,0xa267004b}},	//   לאזט_, minv, _blao, _dėžę_,
   {{0x3160379b,0x628d184f,0x78a3379c,0xd29a01e0}},	//   _priz_, _clao, linv, ітні_,
   {{0x752904a5,0x628603ad,0x00000000,0x00000000}},	//   quez, rkko, --, --,
   {{0x62860006,0x92ae0083,0x78a316c9,0x648d0079}},	//   skko, কতে_, ninv, _dúic,
   {{0x1fb5379d,0x81df0083,0x224b379e,0x9f58003e}},	//   естр, দুল_, beck_, garð_,
   {{0x212b02c9,0xee3a01c8,0x628d184f,0xad9b0097}},	//   buch_, ўна_, _glao, _neús,
   {{0x6da30043,0x7afc023a,0x7aee11f0,0x78a3008c}},	// [2e80] вита, _strt, _subt, kinv,
   {{0x7aee006d,0x79820054,0x00000000,0x00000000}},	//   _pubt, vyow, --, --,
   {{0xbcfb1010,0x00000000,0x00000000,0x00000000}},	//   _préc, --, --, --,
   {{0x8b65004f,0x1e83379f,0x49ca15e1,0x00000000}},	//   عالم, _алюм, олен_, --,
   {{0x6aa237a0,0xd91000d1,0xb86500fd,0x7bc7008d}},	//   riof, ایط_, کانو, _eyju,
   {{0x7aee37a1,0x787d000d,0x6aa2254a,0xec1600fd}},	//   _tubt, _sèvr, siof, _زورد,
   {{0xfaa602ee,0x44f237a2,0x6f1a0098,0x00000000}},	//   _жаво, _sâ_, átch, --,
   {{0x7c3e0345,0xdb0e0035,0xdced0225,0x00000000}},	//   lfpr, _wybó, nyağ, --,
   {{0xfaa337a3,0xfbb00033,0xd44a0210,0x00000000}},	//   _рато, _করিত, оянд_, --,
   {{0x337403d6,0xb86637a4,0x224b0110,0x628d0284}},	//   егор, _تارو, weck_, _slao,
   {{0xe8ca00a1,0xd25101b2,0x628d37a5,0x224b0110}},	//   ितीच, هند_, _plao, teck_,
   {{0x68e800a5,0x6d4608c8,0x212b02b1,0x6d1e00b4}},	//   _hidd, _opka, tuch_, _पिंग_,
   {{0x68e837a6,0x224b191b,0x656f01ae,0xbcfb00a2}},	//   _kidd, reck_, ächt, _oréa,
   {{0x557700c2,0x68e804f0,0x212b37a7,0x3dcd003c}},	//   _קעגן_, _jidd, ruch_, _ġew_,
   {{0x68e82dee,0x212b01ae,0x6d462686,0x9f3403d0}},	//   _midd, such_, _apka, кері,
   {{0x68e8030d,0x645837a8,0x443e37a9,0x7ce90009}},	//   _lidd, _havi, lft_, _ažra,
   {{0x645837aa,0x7bca01ae,0xbcfb0037,0x61ed37ab}},	// [2e90] _kavi, üfun, _bréa, _igal,
   {{0xbcfb02e1,0x645837ac,0x443e02c9,0x68e82c9f}},	//   _créa, _javi, nft_, _nidd,
   {{0x645837ad,0x443e3695,0xbcfb0037,0x78a300c3}},	//   _mavi, ift_, _dréa, vinv,
   {{0x6458142f,0x69dd0187,0x656201b7,0x68e8013b}},	//   _lavi, _úsek, _oroh, _aidd,
   {{0xdb1c053d,0x78a337ae,0x61ed37af,0xbcfb0098}},	//   _vyrá, tinv, _mgal, _fréa,
   {{0xbcfb0082,0x68e80463,0x443e0a75,0x225e0029}},	//   _gréa, _cidd, jft_, ētki_,
   {{0x68e831ae,0x656232a3,0xf09402b8,0x61ed030d}},	//   _didd, _aroh, כנס_, _ogal,
   {{0x61ed37b0,0x443e0a75,0x68e8001e,0x64582933}},	//   _ngal, eft_, _eidd, _aavi,
   {{0x443e37b1,0x6458011c,0x7e7d0031,0xd8380260}},	//   fft_, _bavi, _mosp, _imčn_,
   {{0xe1fa04aa,0x645837b2,0x61ed37b3,0x68e837b4}},	//   ूर्ण_, _cavi, _agal, _gidd,
   {{0x645837b5,0x7ae9010b,0x53c900d4,0x69c90118}},	//   _davi, _kiet, ягом_, _hyee,
   {{0x60c524a1,0x7e7d37b6,0x443e0051,0x68e