/*
 * Copyright (c) 2012 The Native Client Authors. All rights reserved.
 * Use of this source code is governed by a BSD-style license that can be
 * found in the LICENSE file.
 */

/*
 * When the main autogenerated testing script is changed and new
 * types are introduced, This file needs to be updated.
 */

#include "ppapi/c/dev/ppb_audio_input_dev.h"
#include "ppapi/c/dev/ppb_console_dev.h"
#include "ppapi/c/dev/ppb_file_chooser_dev.h"
#include "ppapi/c/pp_array_output.h"
#include "ppapi/c/pp_completion_callback.h"
#include "ppapi/c/pp_instance.h"
#include "ppapi/c/pp_module.h"
#include "ppapi/c/pp_point.h"
#include "ppapi/c/pp_resource.h"
#include "ppapi/c/pp_var.h"
#include "ppapi/c/pp_video_dev.h"
#include "ppapi/c/ppb_input_event.h"
#include "ppapi/c/ppb_url_request_info.h"
#include "ppapi/c/ppb_url_response_info.h"

// This union contains all types used by the calling convention tests
union AllValues {
  // pointers
  char* val_char_ptr;
  uint32_t* val_uint32_t_ptr;
  void* val_void_ptr;

  PP_Resource* val_PP_Resource_ptr;

  struct PP_FileInfo* val_struct_PP_FileInfo_ptr;
  struct PP_PrintSettings_Dev* val_struct_PP_PrintSettings_Dev_ptr;
  struct PP_URLComponents_Dev* val_struct_PP_URLComponents_Dev_ptr;
  struct PP_Var* val_struct_PP_Var_ptr;
  struct PP_VideoBitstreamBuffer_Dev*
      val_struct_PP_VideoBitstreamBuffer_Dev_ptr;
  struct PP_VideoCaptureDeviceInfo_Dev*
      val_struct_PP_VideoCaptureDeviceInfo_Dev_ptr;

  // function pointer
  PPB_AudioInput_Callback val_PPB_AudioInput_Callback;

  int16_t val_int16_t;
  int32_t val_int32_t;
  int64_t val_int64_t;
  uint16_t val_uint16_t;
  uint32_t val_uint32_t;
  uint64_t val_uint64_t;

  // integers and enums
  PP_Bool val_PP_Bool;
  PP_FileChooserMode_Dev val_PP_FileChooserMode_Dev;
  PP_InputEvent_Type val_PP_InputEvent_Type;
  PP_Instance val_PP_Instance;
  PP_LogLevel_Dev val_PP_LogLevel_Dev;
  PP_Module val_PP_Module;
  PP_Resource val_PP_Resource;
  PP_TouchListType val_PP_TouchListType;
  PP_URLRequestProperty val_PP_URLRequestProperty;
  PP_URLResponseProperty val_PP_URLResponseProperty;

  // doubles
  PP_Time val_PP_Time;
  PP_TimeTicks val_PP_TimeTicks;

  // structs - this is what we really care about for the calling c
  // convention testing as these maybe passed/returned bv value
  struct PP_ArrayOutput val_struct_PP_ArrayOutput;
  struct PP_CompletionCallback val_struct_PP_CompletionCallback;
  struct PP_FloatPoint val_struct_PP_FloatPoint;
  struct PP_Point val_struct_PP_Point;
  struct PP_TouchPoint val_struct_PP_TouchPoint;
  struct PP_Var val_struct_PP_Var;
};

extern void emit_pointer(const char* m, const void* val);
extern void emit_integer(const char* m, int64_t val);
extern void emit_string(const char* s);
extern void randomize(void);
extern void initialize(int argc, char* argv[]);
extern union AllValues g_input_values;

