(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8036,        330]*)
(*NotebookOutlinePosition[      8947,        361]*)
(*  CellTagsIndexPosition[      8903,        357]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData["Three-dimensional Geometry"], "Title",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
This notebook demonstrates some computations in three-dimensional geometry. 
The topic is described in more detail in the book:

\tMathematica Graphics: Techniques and Applications.
\tTom Wickham-Jones, TELOS/Springer-Verlag 1994.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This package is now updated to ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " Version 3.0."
}], "Text"],

Cell[CellGroupData[{

Cell["Installation and Initialization", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "The ",
  StyleBox["ExtendGraphics", "Input"],
  " directory should be put in one of the canonical places for AddOns.   Two \
recommended places are first inside the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " distribution in:"
}], "Text"],

Cell[BoxData[
    \(ToFileName[\ {$TopDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell["a second in the preferences directory:", "Text"],

Cell[BoxData[
    \(ToFileName[
      \ {$PreferencesDirectory, \ "\<AddOns\>", \ "\<Applications\>"}]\)], 
  "Input"],

Cell[TextData[{
  "When one of these locations is used there is no need to set $Path and the \
loading instructions are identical for all versions of ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[TextData[{
  "The  ",
  StyleBox["ExtendGraphics`Geometry3D` ", "Input"],
  "package can  be loaded"
}], "Text"],

Cell["Needs[ \"ExtendGraphics`Geometry3D`\"]", "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["Turn off spelling checker", "Subsection"],

Cell["\<\
Off[ General::spell];
Off[ General::spell1];
\
\>", "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Slicing up a Surface"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["A surface is made."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
surf = 
  Graphics3D[Plot3D[Sin[x y],{x,-Pi,Pi},{y,-Pi,Pi},
                    PlotPoints -> 20]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The surface is clipped by two horizontal planes."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Fold[Clip3D[#1, #2]&, surf, 
    {Plane[{0,0,0.5}, {0,0,-1}], 
     Plane[{0,0,-0.5},{0,0,1}]}];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The result is plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["Show[%];", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Non-Convex Triangulation"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["These points for a non-convex set."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
pts2d = 
  {{0,0},{1,-2},{1.5,-2},{4,4},{2.5,4},
  {1,0},{.5,1},{-.5,1},{-1,0},{-2.5,4},
  {-4,4},{-1.5,-2},{-1,-2}};\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The two-dimensional plot."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics[Polygon[pts2d]], 
  AspectRatio -> Automatic]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The points are embedded in three-dimensional space."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
pts =
  EmbedIn3D[pts2d, Plane[{0,0,0}, {1,-2,.2}], {0,1}];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The points can be plotted on a line."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics3D[Line[pts /. {a_, b__} -> {a,b,a}]]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["When a ploygon is made the result is strange."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics3D[Polygon[pts]]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The non-convex outline can be generated."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["NonConvexTriangulate[pts2d]", "Input",
  AspectRatioFixed->True],

Cell[TextData["This can be plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics[
    Map[Line[Part[pts2d, #] /. 
            {a_,b__} -> {a,b,a}]&, %]]]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData[
"The function, NonConvexPolygon, does everything, at once."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics3D[NonConvexPolygon[Polygon[pts]]]]\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Extrusion"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData["A function to generate two-dimensional cog wheels."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Cog[r_, num_] :=
  Module[{ang, angi, ang1, ang2, 
          rf = 1.15, id = 0.4, od = 0.4},
    ang = N[2Pi/num] ;
    angi = ang*id ;
    ang1 = ang*(1+id-od)/2. ;
    ang2 = ang*(1+id+od)/2. ;
    pts =
      Table[{r { Cos[t], Sin[t]}, 
             r {Cos[t+angi],Sin[t+angi]},
             r rf { Cos[t+ang1], Sin[t+ang1]}, 
             r rf {Cos[t+ang2],Sin[t+ang2]}
             }, {t,0,2Pi-ang,ang}] ;
    Polygon[Flatten[pts, 1]]
    ]\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["An example cog."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
cog = Cog[3, 15];

Show[
  Graphics[{GrayLevel[0.5], cog}],
  AspectRatio -> Automatic];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The cog is put in three-dimensions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
cog3d = 
  cog /. 
    Polygon[pts_] :> 
        Polygon[Map[Append[#,0]&, pts]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The three-dimensional outline is plotted."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics3D[NonConvexPolygon[cog3d]]];\
\>", "Input",
  AspectRatioFixed->True],

Cell[TextData["The cog is extruded to form a solid object."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Show[
  Graphics3D[{EdgeForm[], Extrude[cog3d, 0.2]}]];\
\>", "Input",
  AspectRatioFixed->True]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"Microsoft Windows 3.0",
ScreenRectangle->{{0, 800}, {0, 544}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{496, 436},
WindowMargins->{{64, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"NeXTAutomaticEncoding"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 101, 2, 150, "Title"],
Cell[1835, 55, 302, 8, 109, "Text"],
Cell[2140, 65, 134, 5, 33, "Text"],

Cell[CellGroupData[{
Cell[2299, 74, 98, 2, 53, "Section"],
Cell[2400, 78, 272, 8, 53, "Text"],
Cell[2675, 88, 103, 2, 30, "Input"],
Cell[2781, 92, 54, 0, 33, "Text"],
Cell[2838, 94, 118, 3, 50, "Input"],
Cell[2959, 99, 222, 6, 52, "Text"],
Cell[3184, 107, 117, 4, 34, "Text"],
Cell[3304, 113, 81, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[3410, 118, 47, 0, 47, "Subsection"],
Cell[3460, 120, 70, 4, 66, "Input"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[3579, 130, 97, 2, 33, "Section"],
Cell[3679, 134, 92, 2, 33, "Text"],
Cell[3774, 138, 150, 5, 66, "Input"],
Cell[3927, 145, 122, 2, 33, "Text"],
Cell[4052, 149, 147, 5, 66, "Input"],
Cell[4202, 156, 96, 2, 33, "Text"],
Cell[4301, 160, 51, 1, 30, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4389, 166, 101, 2, 33, "Section"],
Cell[4493, 170, 108, 2, 33, "Text"],
Cell[4604, 174, 168, 6, 84, "Input"],
Cell[4775, 182, 99, 2, 33, "Text"],
Cell[4877, 186, 113, 5, 66, "Input"],
Cell[4993, 193, 125, 2, 33, "Text"],
Cell[5121, 197, 110, 4, 48, "Input"],
Cell[5234, 203, 110, 2, 33, "Text"],
Cell[5347, 207, 105, 4, 48, "Input"],
Cell[5455, 213, 119, 2, 33, "Text"],
Cell[5577, 217, 84, 4, 48, "Input"],
Cell[5664, 223, 114, 2, 33, "Text"],
Cell[5781, 227, 70, 1, 30, "Input"],
Cell[5854, 230, 94, 2, 33, "Text"],
Cell[5951, 234, 140, 6, 84, "Input"],
Cell[6094, 242, 132, 3, 33, "Text"],
Cell[6229, 247, 102, 4, 48, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6368, 256, 86, 2, 33, "Section"],
Cell[6457, 260, 124, 2, 33, "Text"],
Cell[6584, 264, 497, 17, 282, "Input"],
Cell[7084, 283, 89, 2, 33, "Text"],
Cell[7176, 287, 139, 7, 102, "Input"],
Cell[7318, 296, 109, 2, 33, "Text"],
Cell[7430, 300, 132, 6, 84, "Input"],
Cell[7565, 308, 115, 2, 33, "Text"],
Cell[7683, 312, 96, 4, 48, "Input"],
Cell[7782, 318, 117, 2, 33, "Text"],
Cell[7902, 322, 106, 4, 48, "Input"]
}, Closed]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

