"""
Below are flex arrays with x,y,z points and weights for numerical integration on a sphere.

The design has been taken from

http://www.personal.soton.ac.uk/jf1w07/nodes/nodes.html

"""
from __future__ import absolute_import, division, print_function

from scitbx.array_family import flex

t_x = flex.double([ 0.0 , 0.996972891319 , -0.982581060536 , 0.783068336711 , 0.495365041556 , -0.268566696162 , -0.518797826849 , -0.960017419086 , -0.676207321898 , -0.224573966429 , -0.850989429348 , -0.117034299758 , -0.242832540611 , 0.118185369053 , 0.387868988733 , 0.762262920998 , -0.205458031773 , -0.400891098554 , -0.161632828627 , -0.296311835751 , -0.983477624389 , 0.939292243275 , 0.40862157417 , -0.846440610041 , 0.922328935836 , -0.562816608531 , 0.688770932121 , -0.069372194943 , -0.066536764735 , 0.170865010346 , -0.17106546094 , 0.078247253047 , -0.037397470188 , 0.722143991034 , -0.341170368472 , 0.913627041301 , 0.981587060638 , -0.175564913877 , 0.035957359227 , 0.893221107164 , -0.854118167296 , -0.903411487018 , 0.752764931978 , 0.8261626241 , -0.907365714256 , 0.838674106059 , -0.88918904397 , -0.954535134767 , -0.812431876189 , -0.61466830574 , 0.00306948964 , -0.789952684686 , -0.521727387399 , 0.090110621171 , 0.547947478344 , -0.008422701718 , -0.362614348616 , -0.70966056751 , -0.569469411805 , 0.463325320655 , 0.988049242055 , -0.912546938245 , 0.281792257495 , 0.414783752898 , -0.39603414469 , 0.753119395631 , -0.854330924993 , 0.70233042827 , -0.329401105392 , 0.925584459762 , 0.861866730317 , -0.74388226061 , -0.986019999867 , 0.343422352076 , -0.034089820342 , 0.662106849154 , -0.617143323083 , -0.877317131436 , -0.137713797829 , -0.416107550629 , 0.373555412181 , -0.811675510087 , 0.583915213496 , -0.910554514778 , -0.801054223687 , -0.825552356933 , -0.043927842453 , 0.598473834488 , 0.463207873171 , -0.647062404608 , -0.717952628619 , -0.205102905755 , -0.183918566825 , -0.050246935492 , -0.412350520967 , 0.281340239598 , -0.108363708543 , 0.508818204177 , 0.339415368226 , 0.60901500124 , 0.818669629233 , -0.6316720379 , 0.234788475691 , -0.997275258459 , -0.829948233288 , -0.656258690231 , -0.189858522998 , 0.153697006244 , 0.354745613399 , -0.136200871745 , 0.298501595237 , 0.494556093772 , -0.595198664492 , 0.057820406398 , 0.285863667114 , -0.488373282363 , -0.90440949944 , -0.842792321703 , 0.336575112118 , 0.652174274313 , -0.773634673921 , 0.027676526049 , -0.131807177607 , -0.662892576584 , -0.637629867632 , -0.842684049655 , 0.922308651983 , 0.206876378707 , -0.542441106377 , -0.644694739065 , -0.686396578815 , -0.918091159826 , -0.035887452764 , 0.375598722903 , 0.012204326248 , 0.870154020408 , 0.557583529344 , -0.827325980918 , 0.880008792349 , 0.239032198645 , -0.182374068654 , 0.2548258262 , -0.732094368476 , -0.409193091492 , 0.973839385347 , 0.852599094232 , -0.865421257613 , -0.851140660166 , -0.43524693267 , -0.86250042302 , 0.068853757985 , -0.316102984838 , 0.072298030843 , -0.121703393687 , -0.824256633201 , -0.448843624631 , 0.960430729697 , -0.475094535603 , -0.621798769273 , 0.156115395048 , -0.216232023311 , 0.087632697742 , 0.306449505735 , -0.404019035886 , 0.341699821161 , 0.33063272965 , 0.493651916993 , 0.687030623885 , 0.455397383139 , 0.446315909963 , -0.79317389878 , -0.499513807056 , -0.413060433117 , 0.660247585205 , 0.197340052877 , -0.529578656922 , -0.224783229029 , -0.735626467712 , -0.735387762665 , -0.056891801966 , -0.733128196926 , -0.633420401185 , -0.401203479189 , 0.621154458626 , 0.994711334885 , 0.376259016599 , 0.585596435284 , -0.485208746882 , -0.400390480655 , 0.095818983332 , -0.293987369754 , 0.641860843414 , -0.330669437397 , -0.94781258805 , 0.606300617096 , -0.301485622053 , -0.275069345574 , 0.36851710788 , -0.174350142174 , 0.964976288084 , -0.104075707155 , 0.48554694712 , -0.766574070824 , -0.223614782247 , -0.450147311662 , 0.170076169121 , -0.079117500286 , -0.589558746618 , -0.692055074067 , -0.729077827169 , -0.607383389394 , 0.048611858761 , -0.359580564185 , -0.876341721025 , 0.767844529979 , 0.499649778329 , -0.885831813575 , 0.115291676533 , 0.160257666348 , 0.660969748707 , 0.928672889172 , -0.547704232286 , 0.577418163658 , 0.83035414139 , 0.396094341677 , 0.042985647742 , 0.921380372599 , 0.446394847427 , 0.086182451565 , 0.52303946722 , 0.9030579013 , 0.156597721998 , -0.719403124265 , -0.746491005479 , -0.993593457936 , -0.101077920215 , -0.088675149529 , 0.436038735213 , -0.378884634216 , -0.626498637029 , 0.406186134016 , -0.688463910568 , 0.280627074434 , 0.153737366665 , 0.199365964393 , -0.018204924648 , -0.681550334668 , -0.537587823785 , 0.090989830324 , 0.379989622671 , 0.566597174596 , 0.018441409743 , 0.345814825271 , 0.874283374514 , 0.399802428761 , 0.963220672283 , -0.994897296922 , -0.156714993068 , -0.927069069789 , -0.23890339494 , -0.237933816645 , -0.486829202841 , 0.126732104243 , 0.380892736307 , -0.853815222246 , 0.707500645964 , 0.593607703844 , -0.210801429753 , -0.359983711124 , 0.701453114467 , -0.92886583061 , 0.777324035743 , 0.085049559023 , 0.945074862356 , 0.450220156024 , -0.764580586297 , -0.625790395419 , 0.828464844247 , 0.72952130247 , -0.476309054931 , -0.342647093809 , 0.320489163896 , 0.960498146666 , 0.386201127374 , 0.274915339823 , 0.452380920752 , 0.626371644491 , -0.500922220172 , -0.20939077914 , -0.866060286694 , -0.757202650894 , 0.474524749904 , -0.78719556377 , 0.282601552833 , 0.054180730447 , -0.958719484843 , -0.392652775321 , -0.561771637121 , 0.823185361072 , 0.983645755443 , 0.019176892561 , 0.023721096519 , -0.71880745752 , -0.306776472984 , -0.439738720648 , 0.678197541212 , 0.556368501142 , 0.470281288793 , -0.865502721861 , -0.099484958616 , -0.150483582109 , -0.419243439803 , -0.917605895125 , -0.286399753629 , -0.222972817862 , -0.032420948931 , -0.084547388133 , 0.262727067599 , 0.286181442959 , 0.721507640447 , 0.096474309947 , -0.055791274907 , -0.373340138711 , -0.199415911886 , -0.469683737844 , 0.729979445183 , 0.894903606708 , -0.164329643459 , -0.557256121998 , -0.664354856752 , -0.055323287556 , 0.48309920615 , 0.251670190586 , -0.309066738538 , 0.205372356915 , -0.078421507828 , -0.407726365795 , 0.011988387061 , 0.761126573389 , -0.594897448793 , 0.044874600451 , 0.175707971267 , 0.264562208839 , 0.827306017903 , -0.567950337988 , -0.292533959217 , -0.323774816087 , -0.064560509651 , -0.342583684965 , -0.442663945332 , 0.954394456222 , -0.280890478067 , -0.511391507367 , -0.66139991747 , -0.568477570104 , -0.941284247886 , -0.446553915747 , 0.277990958449 , 0.564712706179 , -0.171289742615 , 0.540210065331 , -0.25348946477 , 0.04215082598 , -0.955293563768 , -0.922808417137 , 0.653987538808 , -0.454359973411 , -0.055842912585 , -0.423785012974 , -0.170749146349 , -0.538718513686 , -0.464777325019 , 0.924467469357 , 0.47072801829 , -0.88618844215 , 0.378988579576 , -0.268887025568 , -0.361439546712 , -0.04809566662 , 0.767003463662 , 0.96286981511 , -0.034826731083 , -0.722503892086 , -0.81575979451 , -0.629928640865 , -0.171064354468 , -0.177845244026 , 0.150803260104 , 0.035483995467 , 0.60313388223 , 0.02951203357 , 0.153859807794 , -0.566215228655 , -0.962748313255 , -0.289165130587 , -0.81121189824 , 0.041724390393 , -0.297413325681 , -0.46855928094 , 0.424018334848 , -0.293058962446 , 0.826399736974 , 0.412402300049 , -0.707233894716 , 0.046183722546 , -0.521389932596 , 0.237617352418 , 0.410311155995 , 0.65229732674 , -0.938019584864 , 0.723747731868 , 0.304450551212 , 0.220060917213 , -0.041806294748 , 0.281356566316 , -0.717648374348 , -0.593819103757 , 0.942841811064 , -0.760639963213 , 0.986544255992 , 0.705035080485 , -0.645232594173 , 0.676939169565 , -0.285236792801 , -0.041866775895 , -0.891483475473 , 0.497757706335 , -0.736877246837 , -0.354223207233 , 0.13703479587 , -0.667094382137 , 0.947149222296 , -0.777278616126 , 0.343990887963 , 0.56942286955 , -0.050082011116 , -0.922279720344 , -0.177323173113 , 0.911623650634 , -0.358483825048 , 0.787397279798 , 0.744103639551 , 0.675906339057 , 0.683038757408 , -0.145205587024 , -0.079020092235 , 0.076344261977 , 0.507283555217 , 0.858589180456 , 0.525995298681 , 0.498156197821 , 0.917968532136 , -0.850213135413 , 0.34853274105 , 0.588538472127 , -0.113957484201 , -0.580503237755 , 0.433510197464 , 0.336342526913 , 0.658319516289 , 0.684949398828 , -0.565059061186 , 0.504717094627 , 0.481797240712 , 0.01208931546 , 0.761299080413 , -0.853067203598 , -0.978328964994 , -0.375220888929 , 0.174080765705 , 0.485477314638 , 0.670219332813 , -0.826905109122 , 0.412571963233 , -0.938937347967 , 0.533395090742 , 0.402456655753 , 0.738098724808 , 0.975453862962 , 0.534431513903 , 0.618437671496 , -0.820341438124 , -0.463789473502 , -0.66224792331 , -0.159867740779 , -0.792540706358 , -0.639184631427 , 0.875572524933 , 0.570824116623 , -0.763953789554 , 0.860949015711 , 0.206949875732 , 0.654555651038 , -0.687935526117 , 0.452762600429 , -0.503853368428 , 0.513877272183 , 0.387967855712 , 0.214071377862 , 0.316848690572 , 0.448409354304 , -0.252682711754 , -0.461387358941 , 0.181552458696 , 0.090675067636 , 0.922676485702 , 0.10350219593 , 0.215879546981 , -0.114927521772 , 0.072784711423 , -0.556508809876 , 0.901748536141 , 0.799992479943 , 0.86352251636 , 0.150601019166 , -0.539440285753 , -0.381696006486 , -0.526390002749 , -0.659378863391 , -0.429850544661 , -0.252777036347 , -0.274819696579 , -0.563563267305 , 0.671793350511 , 0.256920943011 , -0.177607832609 , -0.583183170125 , -0.772149033221 , -0.885642252839 , 0.242202312707 , 0.033585936932 , 0.581356265779 , 0.087745169621 , -0.986348189622 , -0.383906459217 , -0.479546540076 , 0.783848511077 , -0.293191913927 , -0.512892958994 , 0.97560524763 , -0.264377236823 , -0.473548515367 , -0.457543372176 , 0.281138476354 , 0.041650613698 , -0.925355986337 , 0.145043904172 , 0.024077930208 , -0.947826385203 , 0.279454008096 , 0.802768960808 , -0.639826647957 , 0.054611437376 , -0.100560146439 , -0.749237731473 , 0.010108825896 , -0.457581304003 , 0.250983217486 , 0.455336833001 , -0.692755268756 , -0.492020127649 , -0.974425244157 , -0.987087885717 , -0.215725669628 , 0.45036797735 , -0.790331303989 , 0.567434726119 , 0.322113126823 , -0.122552846604 , -0.873523698346 , -0.577067362774 , -0.777404913427 , -0.389032897947 , -0.888207668821 , -0.786383560759 , 0.948931924863 , -0.544429015339 , 0.502789890401 , 0.800392771766 , 0.273816111252 , -0.044839700211 , 0.166196724225 , -0.692116979241 , 0.884106186808 , -0.231040327389 , -0.509605636768 , -0.287144783764 , -0.817909507973 , -0.280529131067 , -0.10028634042 , -0.975814570925 , 0.26548628778 , -0.940818081842 , -0.285032661528 , 0.151864135587 , -0.409142877884 , -0.902162263073 , 0.168718695943 , 0.978726780656 , 0.270488937697 , 0.623245020184 , -0.111273044338 , 0.568746052154 , -0.64414145104 , 0.893816473016 , 0.772393045649 , 0.621826578196 , 0.39031496523 , 0.669271115176 , -0.232363212822 , 0.75314112515 , 0.516046388823 , -0.694653707996 , -0.75336893475 , 0.517573096622 , 0.395042941549 , 0.2604879943 , 0.051181636294 , 0.81407987194 , -0.794886131772 , 0.424593436939 , -0.951055315049 , -0.304446959247 , 0.634862694743 , 0.21826347383 , -0.616600870055 , -0.644061969799 , -0.241654285755 , -0.096403307382 , -0.009475982445 , -0.284637177087 , 0.810902138983 , 0.608837286286 , -0.634994726639 , 0.333923030659 , -0.347848669059 , 0.757747566426 , 0.527390826472 , 0.083412977292 , -0.668816600217 , 0.668604264271 , 0.699385785264 , -0.659279958313 , -0.221816417219 , 0.235503482778 , 0.391027818556 , 0.843673811668 , 0.201181337779 , 0.803815902223 , 0.335077681332 , 0.21852954216 , -0.799469375185 , -0.526924925298 , 0.88186504041 , -0.745541307905 , 0.142974151735 , 0.761584695151 , 0.387387393547 , -0.113082274067 , -0.071660778852 , -0.120305519458 , -0.13088816086 , 0.556126248066 , 0.636639600828 , 0.363305849747 , -0.071089625891 , 0.853848029513 , -0.184102096793 , 0.276173370634 , -0.446516377387 , 0.488235068427 , -0.998315750096 , -0.036732793764 , -0.053183440962 , 0.802013951069 , -0.284150645739 , -0.531757094495 , 0.009092233292 , -0.77916148032 , 0.911331022567 , -0.910001031799 , 0.536129275771 , 0.630448300905 , 0.884119299498 , -0.799757721452 , 0.192600844054 , 0.790955413934 , 0.212820811991 , -0.482209156516 , 0.462599370761 , 0.519342866523 , -0.162469949306 , -0.161826066145 , -0.008210157057 , 0.703707615855 , 0.942395072646 , 0.035893741387 , 0.129311893344 , 0.324535098883 , 0.216164224377 , 0.961543173752 , -0.348042984572 , 0.931318550307 , 0.900807438538 , 0.745379857498 , 0.818655111781 , -0.581058683394 , -0.330781430461 , 0.400500821853 , 0.379047006524 , 0.572923066049 , -0.794008521639 , -0.914735551526 , -0.162692266738 , -0.959897348923 , -0.963200007491 , -0.825597989853 , -0.397840450176 , -0.73550108901 , 0.599151717885 , -0.479056142832 , -0.223189296471 , -0.030080026104 , 0.105739786786 , 0.560496338003 , -0.162807781767 , 0.833699345219 , -0.359288638975 , 0.072482546818 , 0.741699791872 , -0.243237087366 , -0.598805931496 , -0.73399243854 , -0.566900540735 , 0.629041406263 , 0.553397504856 , -0.434725644763 , -0.807224618297 , -0.082447822724 , -0.492839913192 , 0.372387672413 , -0.346749058607 , 0.594848147373 , 0.215360834209 , 0.015263306423 , 0.358519277703 , -0.370959595816 , -0.376841735952 , 0.310178040948 , 0.413708376164 , 0.841620194204 , 0.577762949967 , -0.694194295579 , 0.121230605399 , 0.877802417656 , 0.210067487085 , -0.591914600591 , -0.457567373685 , -0.276330232717 , -0.026371079884 , -0.056133511057 , -0.494339179818 , 0.136578065816 , 0.162030767995 , 0.288727494138 , 0.749916145495 , 0.275596386087 , 0.098106507213 , -0.24156668986 , 0.666744608555 , 0.270637229513 , 0.46708919244 , 0.882550325447 , -0.04062226855 , -0.17574570832 , 0.799094297787 , -0.625114055391 , -0.457811593695 , 0.169587324868 , -0.975797890626 , 0.207294577416 , 0.1652109688 , 0.331100600736 , 0.180776069703 , -0.342824106413 , 0.680013522113 , 0.615166986557 , 0.755411692104 , 0.406165632156 , 0.867665034582 , -0.515405243206 , 0.711337144769 , 0.538963420012 , -0.36594944489 , 0.511577933574 , -0.668267235015 , 0.637606340223 , -0.958220283051 , 0.444082374658 , -0.289289189908 , 0.195210206059 , -0.338521526896 , 0.83510975175 , 0.682624073801 , -0.707665196464 , -0.059362828026 , 0.824211150089 , 0.778672732354 , -0.181668291577 , -0.728148523583 , -0.842387605154 , -0.276792910402 , 0.897791810052 , 0.24485635413 , -0.258338381456 , 0.61894458669 , -0.877362005513 , 0.848639889373 , -0.236839082258 , -0.873418557361 , 0.939543005708 , -0.522624028549 , 0.53868174019 , 0.325700397427 , -0.545306264044 , 0.720377602584 , 0.143727367025 , 0.226981947448 , 0.487893122163 , 0.397953272301 , 0.806189946977 , 0.720546631844 , 0.88474506836 , -0.1552527509 , 0.687973581022 , -0.866232696714 , 0.398091554935 , 0.951124859307 , 0.831457601713 , 0.077002070141 , -0.157653618634 , 0.8459424722 , 0.158731400123 , 0.494773346928 , 0.139862875987 , -0.973622617089 , 0.008354735271 , 0.025228109165 , -0.746022261915 , 0.55994377822 , -0.555558572846 , -0.168873622591 , -0.575973089396 , -0.389948712647 , -0.712671252105 , 0.927801715997 , 0.998719286333 , -0.325915221932 , 0.332029757216 , -0.724952201383 , 0.738261726508 , -0.433245814889 , 0.057867910684 , 0.590989573119 , -0.095714008155 , 0.782803198093 , 0.591748592215 , -0.637536569751 , 0.992784879648 , -0.904389723249 , -0.354692691726 , -0.371424669451 , 0.114597638138 , 0.745442861896 , -0.940414017393 , -0.807052253738 , -0.587063299408 , -0.615249929854 , 0.306572844202 , 0.72012668134 , 0.593013055166 , 0.460486926048 , 0.140813220567 , -0.917393381624 , 0.690760554403 , 0.73402274463 , 0.633687213272 , 0.870821834791 , -0.483525689647 , -0.71369203987 , 0.790278347327 , -0.5784939709 , -0.657996583785 , 0.290239862492 , -0.411147369576 , 0.969441584378 , -0.088269347497 , 0.07677542403 , 0.139495770207 , 0.987329964301 , ])
t_y = flex.double([ 0.0 , 0.0 , -0.178228496639 , 0.621935399592 , 0.804616360278 , -0.734252990559 , 0.854890674061 , -0.108846768613 , -0.38460134532 , 0.968876550694 , -0.128055589111 , -0.382618734103 , -0.371800943221 , 0.536531573563 , -0.178294868797 , -0.607812974675 , -0.88616321192 , 0.129678481055 , 0.963162162784 , -0.045364855196 , 0.105232740135 , 0.340048361396 , -0.911467140107 , 0.074605441584 , 0.351691018398 , -0.184414466096 , -0.033145296257 , -0.958534292457 , -0.736186242601 , 0.129086130112 , -0.267826821378 , 0.900604217443 , 0.999300353112 , -0.519175144604 , 0.932454689983 , 0.17649893689 , 0.097751278382 , -0.385061463639 , 0.620723016752 , -0.378010326417 , 0.519991968523 , 0.211422207602 , -0.304805260431 , -0.08868419725 , -0.045843090362 , 0.383585781448 , 0.081589968875 , 0.141999887239 , -0.44377699139 , 0.456734263512 , -0.98696663069 , -0.046395411486 , 0.763220583448 , 0.995931340665 , 0.73311513448 , 0.525448072931 , -0.153787438641 , 0.688359325827 , -0.126207289567 , 0.885999474358 , 0.125824672126 , 0.408914451552 , -0.2411249332 , -0.730154896339 , -0.469085834794 , -0.657506022929 , -0.399497714473 , -0.657902370036 , 0.777060217581 , -0.25450617313 , -0.173126139133 , 0.650343317486 , 0.158049444489 , 0.456188930735 , 0.216432245369 , 0.392294899955 , -0.704457794918 , -0.337724751232 , -0.013812094902 , -0.435727602409 , 0.341210619117 , -0.250484422061 , -0.714393467036 , 0.174808261373 , 0.591790331457 , 0.422523218691 , 0.256600779302 , -0.755477780549 , 0.027628676169 , 0.41357127384 , 0.314075721633 , 0.38515809271 , -0.597258508257 , 0.639130698348 , 0.595729761732 , 0.836800646804 , 0.30754615763 , -0.855386046876 , 0.842035563054 , -0.279073287137 , -0.094722271026 , 0.683469016167 , -0.768148800892 , 0.067798737155 , -0.556314104916 , 0.596852018951 , -0.947549770628 , 0.982078862831 , 0.767675713887 , 0.164041989295 , 0.255289167523 , -0.212486497328 , 0.80071344728 , -0.256824253775 , 0.147839841018 , 0.633891485383 , 0.093621872411 , -0.25003967145 , 0.720115040603 , 0.164949608191 , 0.031650297007 , 0.993618792426 , 0.505601709955 , -0.098058818095 , -0.495459192457 , -0.508643052766 , -0.334756475017 , -0.263513985155 , -0.828281095131 , 0.113591543115 , 0.486362629857 , -0.12684523012 , -0.997687693124 , -0.061805930509 , -0.381826056943 , 0.212347524795 , 0.810481180221 , -0.536023937381 , -0.123313705859 , 0.778060786399 , -0.494332465663 , -0.960754025308 , -0.434371652132 , 0.303127182037 , 0.227219646942 , 0.029899675732 , 0.381631687469 , 0.46957912085 , -0.778902881481 , -0.140589572124 , 0.437786924524 , -0.94208809088 , 0.622640817268 , -0.975135118666 , 0.532937006173 , 0.751495341498 , -0.172725273718 , 0.595325701834 , 0.760478804021 , 0.933387611593 , 0.832048352443 , 0.216456219158 , -0.022523706549 , 0.91472564922 , 0.939772074374 , -0.801203007164 , -0.869097850673 , -0.702465205657 , 0.793128154871 , 0.109013117445 , 0.166191220671 , 0.07832310874 , -0.749953387895 , -0.620840796785 , 0.445918888612 , -0.066063541978 , 0.913640016023 , -0.142184730745 , -0.5350566284 , 0.419567637801 , 0.678922123877 , -0.64389397156 , -0.849093150808 , 0.057201234619 , -0.102397948277 , -0.124316920872 , -0.125079879828 , 0.67175762667 , 0.887389155812 , 0.233003545017 , -0.784938606416 , -0.743168756692 , 0.036606592567 , -0.080525101697 , 0.515264043817 , -0.639911772567 , -0.191319838245 , 0.532742930669 , 0.665212194363 , 0.148077520025 , 0.936424840892 , 0.51897274209 , -0.320803985871 , 0.92166048635 , 0.087089791086 , -0.315885406758 , -0.915759738403 , -0.60409828514 , 0.672693192918 , -0.098867915457 , -0.329813394885 , -0.485115882528 , 0.259904007634 , -0.242346159045 , 0.44808540319 , -0.796245580933 , -0.286557891706 , 0.780411825873 , 0.836118370949 , -0.032993718898 , 0.31233219051 , 0.412497518835 , -0.469416470036 , -0.540838602959 , -0.822224763212 , -0.93087392376 , -0.145899900516 , 0.434357693728 , -0.993096647459 , -0.672359428819 , 0.088957205203 , 0.842621424531 , -0.686571794229 , 0.507384310592 , -0.023844889575 , 0.988313390915 , 0.606928019329 , 0.688720986589 , -0.674150245858 , -0.767947205705 , -0.867091100491 , -0.723932272465 , 0.805783603711 , 0.693561432561 , 0.890610414744 , 0.544976834261 , -0.690775700315 , -0.555222292459 , 0.97151513783 , -0.922135766524 , -0.002113841254 , 0.94476457346 , 0.249588326276 , 0.404576594439 , 0.344402780137 , -0.057219511645 , 0.035772866794 , -0.987001810769 , -0.225672399208 , -0.728159342239 , -0.565566766505 , 0.204038379062 , -0.888242067541 , -0.840044165098 , 0.194312669544 , 0.551939817248 , 0.499787786459 , 0.58284453092 , -0.542500531109 , 0.630255410145 , -0.349571013193 , 0.528910387717 , -0.803093446859 , -0.032099836632 , -0.640071342009 , -0.611730355413 , -0.778954108935 , -0.469545585867 , 0.325879265903 , 0.831412475602 , 0.794999973058 , -0.621788849891 , -0.135366129635 , 0.624177240781 , 0.955266143783 , 0.674800989305 , 0.305486564804 , -0.864731207052 , 0.814175055821 , -0.426592948412 , -0.604111423775 , -0.541474754428 , 0.615212768795 , 0.901178731812 , -0.954665655355 , -0.235255871269 , -0.575362380497 , 0.820575748024 , -0.215179177069 , 0.03253251865 , 0.32868040285 , 0.993726985004 , 0.261581505426 , -0.922444171985 , 0.40744051642 , -0.275426864701 , -0.574065964726 , 0.239833697705 , 0.288515012311 , 0.989131449967 , -0.915491849186 , -0.883634189848 , 0.267307387498 , 0.93506544426 , 0.967657131626 , 0.903438800102 , 0.724069707971 , -0.874456907111 , 0.623537927212 , 0.570821841144 , 0.899683833176 , -0.282869193447 , 0.691719004963 , -0.975977491558 , -0.143550852863 , -0.666899296605 , 0.42266659023 , 0.959647501694 , 0.170930277542 , -0.329370888402 , -0.070335722723 , -0.746463594732 , -0.669716936739 , -0.261684561657 , -0.462381552021 , -0.994833420465 , 0.824963141963 , -0.574484484077 , -0.640647284883 , 0.210713862008 , -0.998132783902 , 0.302630226654 , -0.545489755147 , -0.561381158395 , -0.620255190695 , -0.538264843978 , -0.839429919013 , -0.442860238947 , -0.830132230231 , 0.346302385158 , 0.083018261137 , 0.851568611136 , 0.750667642179 , 0.50432808272 , 0.763240101254 , 0.323581835278 , 0.726349799552 , 0.905832414718 , 0.61691216849 , 0.677991811499 , -0.810594619205 , -0.054982895165 , 0.122487517458 , 0.234039896334 , 0.370332593939 , -0.366464314599 , 0.883246382364 , -0.218380193045 , -0.603942596977 , -0.805586775952 , -0.247795086824 , -0.696550753029 , 0.17843439846 , 0.858387096404 , 0.32758466692 , 0.832244833632 , -0.896471131202 , -0.699821592903 , 0.697431585086 , 0.153529615597 , 0.238004521831 , 0.975404901964 , 0.591774747095 , -0.365679157066 , 0.34832929201 , 0.276677402171 , -0.658051452771 , -0.729867122969 , 0.714138854996 , -0.784733957286 , 0.945021688284 , -0.847666770353 , 0.507038862812 , -0.204247165642 , -0.430806050563 , -0.505509745139 , -0.587992835719 , -0.463537749772 , 0.877791845009 , -0.86410390183 , 0.645575406134 , -0.502508165477 , -0.000913151746 , 0.377794850602 , -0.768310972744 , 0.310865017023 , 0.070934289436 , 0.218804935606 , -0.500562523973 , -0.20272231929 , 0.685325252488 , -0.90391991502 , 0.877796730709 , 0.974028658959 , -0.35797860551 , -0.002825551344 , 0.564997837094 , -0.286045368833 , -0.649170021245 , -0.113632943439 , 0.440188591106 , -0.624412874939 , -0.669470951274 , 0.865253528325 , 0.898047694873 , -0.023686328798 , -0.506384734901 , 0.502391141927 , 0.504090522457 , -0.561986780629 , 0.691047299812 , -0.318268761312 , -0.474906210504 , -0.919902059173 , -0.707646170074 , -0.482099734217 , -0.318342286267 , -0.056455877223 , -0.393833554049 , -0.103176045751 , -0.207000146731 , -0.121155553498 , -0.156142408637 , 0.698749285857 , 0.570522399106 , 0.365689080549 , 0.705864790691 , 0.809667617711 , 0.267817923452 , 0.0216738083 , 0.577171672991 , -0.264946796409 , 0.192408083112 , 0.049017024131 , -0.359369446348 , -0.574840890661 , -0.524238577984 , -0.607992497014 , 0.91841150605 , 0.29032048671 , 0.728295894626 , -0.823457914798 , -0.307913649656 , 0.289241755945 , -0.983839679114 , 0.467704851604 , -0.01169466001 , 0.196473647737 , 0.19112635647 , -0.925963654373 , -0.093937132671 , -0.390222650173 , -0.040299334356 , -0.893716469851 , 0.048296787716 , 0.473216951324 , 0.908018547732 , -0.419108456815 , -0.217595036676 , 0.838715071366 , 0.577069450481 , 0.091249121238 , 0.224448559141 , -0.535259694146 , 0.188659487837 , -0.145127433602 , -0.215251162293 , -0.389779677182 , 0.789631685106 , -0.634166089276 , -0.356878889565 , -0.972633611177 , -0.15803182646 , -0.541876987078 , 0.761315145291 , -0.362116442273 , 0.710055970023 , -0.403683910353 , 0.951372025916 , -0.940052822647 , -0.420324714255 , 0.47740806979 , 0.506205916609 , -0.935902713288 , -0.911012331066 , -0.031211435237 , -0.825417183352 , -0.950436596207 , -0.740691213134 , -0.658497311671 , 0.663297189992 , 0.431984407315 , 0.02923411466 , 0.149229579698 , -0.633764319936 , 0.822833668305 , 0.698630670238 , -0.831810021948 , -0.203662497673 , -0.893000280847 , 0.734921818875 , -0.961418098747 , 0.68244148005 , 0.663799964573 , -0.138713716845 , -0.693394866613 , -0.418392771878 , 0.402872213931 , -0.456800698415 , 0.015073420178 , 0.845469868302 , 0.21552132839 , -0.96396063547 , -0.148208193215 , -0.863518609257 , -0.496840689813 , -0.576002115443 , 0.292183707352 , 0.830042392996 , -0.200244995081 , 0.586180709898 , -0.846072101589 , 0.82586049158 , -0.930723986208 , -0.683577422 , -0.379047714843 , 0.345528113927 , 0.031110763012 , 0.106771650174 , 0.954601923665 , 0.237852237119 , 0.233381658359 , -0.374736276443 , 0.047998705807 , 0.099731672757 , -0.740242141123 , -0.153605984392 , -0.709982706454 , 0.409929693273 , 0.211674523462 , -0.50117547111 , -0.114942832671 , -0.085269276172 , 0.075530593729 , 0.870780355651 , -0.198917732818 , -0.656184466474 , 0.700093446303 , -0.858688031553 , -0.484383123089 , -0.775318382547 , 0.207721328109 , -0.921136932561 , 0.444077927834 , 0.288151816601 , 0.198230580259 , -0.70668398363 , -0.795321945597 , -0.472045143849 , 0.350223653925 , -0.811182323879 , -0.427419217886 , 0.718778814277 , 0.302577345596 , -0.963343973383 , -0.783123935622 , -0.639626239525 , -0.350241682864 , -0.31660957862 , -0.869787357135 , 0.12767622591 , -0.572027079087 , -0.009690367822 , 0.958492167982 , 0.982075137775 , -0.03353761888 , -0.167364627904 , -0.985526336198 , -0.018238893281 , -0.356205898042 , 0.644686850768 , -0.981103160399 , 0.732845684076 , 0.763507987027 , -0.057229598883 , -0.409609455526 , -0.605618790127 , -0.332272757028 , 0.546806695808 , 0.278692328836 , -0.557200943953 , 0.852826565838 , 0.007564493663 , 0.615805609537 , 0.597205321757 , 0.864374739786 , 0.378655485099 , 0.332624691087 , -0.332039202543 , -0.53098184187 , 0.520875703862 , -0.294610802307 , 0.362971334794 , -0.556628699512 , 0.248525876719 , 0.681999558766 , 0.74522856141 , -0.817469775973 , 0.941838470741 , 0.144785244295 , -0.901396559894 , 0.569952296029 , -0.731507058344 , -0.091006273606 , -0.709162528654 , 0.932046010214 , 0.594084025374 , 0.122684791704 , 0.972906862862 , -0.673555882808 , -0.740824242157 , 0.68592830071 , 0.106031119981 , 0.062066206217 , -0.785152627096 , -0.29275825577 , -0.364342774168 , 0.707301077877 , 0.492692334451 , 0.124062459687 , 0.756321021076 , 0.304602426928 , -0.701900869864 , 0.455171621569 , -0.345088608099 , -0.372656438603 , 0.604442907511 , -0.526120524696 , 0.470795296734 , -0.645258185352 , -0.174465491436 , 0.762794709226 , -0.396444403576 , 0.763725610087 , -0.611022800262 , -0.54700122134 , -0.485816763959 , -0.275383224402 , -0.116957623438 , 0.487953077824 , -0.437073003 , -0.056820202738 , -0.819662632521 , -0.662680107441 , 0.24418096947 , 0.930665103308 , 0.410126017177 , -0.878835231696 , 0.57518841726 , 0.059508021152 , 0.357836238625 , 0.671007933528 , 0.646959995558 , -0.440373394242 , 0.491158023684 , 0.596630848042 , -0.445780438682 , -0.83524803252 , -0.274702958576 , -0.873269611938 , 0.330332774694 , 0.986703828963 , 0.881932481797 , 0.777259670757 , -0.24562893058 , 0.325294451751 , 0.852763114194 , -0.982328714693 , 0.444488758457 , 0.952445277515 , -0.226010369152 , 0.886149311187 , 0.265386989709 , 0.292364490309 , -0.064083203157 , -0.290326936891 , -0.300452414203 , 0.546415787383 , 0.91149294762 , -0.509887952142 , -0.812570509497 , 0.521487222309 , -0.320304081531 , -0.938395424504 , 0.245854089208 , -0.266647265244 , 0.547531829198 , 0.807233290893 , 0.408317124781 , -0.480594063608 , -0.657845135796 , -0.857242530042 , -0.920399906973 , 0.523071877357 , 0.417234587721 , 0.772044440535 , 0.509328875897 , -0.904001352841 , -0.072966755034 , -0.331027327166 , -0.161741822467 , -0.759226411615 , -0.236717301706 , -0.735935987759 , 0.0924608493 , -0.189146432136 , -0.261512686244 , 0.399545268477 , 0.09651645749 , -0.389518613995 , -0.766586110671 , -0.931243370294 , -0.068916085148 , 0.976534090917 , 0.442488046943 , -0.700657417794 , 0.436643260632 , -0.239576913369 , 0.563390412891 , 0.146171324768 , 0.121521342374 , 0.247630617417 , -0.693629344867 , 0.092760205236 , -0.241448143357 , 0.186463516233 , 0.02272759723 , -0.789199108533 , 0.758122999253 , 0.793977487212 , -0.102273107113 , -0.817384273134 , -0.732926261124 , 0.626435592459 , -0.832051181516 , 0.363227657613 , -0.468331485092 , 0.781623597756 , -0.947276798102 , -0.636807029798 , 0.663433162862 , -0.681790546137 , 0.391130801364 , -0.959905461889 , -0.477830812029 , 0.116886640466 , 0.314903163283 , -0.884968798303 , -0.199977486427 , 0.00960546433 , -0.888715235039 , -0.081455851574 , -0.44365398529 , -0.034865366393 , 0.876577760755 , 0.185233783319 , 0.745411867757 , -0.186529549835 , 0.6141164243 , -0.002282739467 , -0.019249979145 , -0.529818919135 , 0.150964615418 , -0.353983352354 , -0.830396908541 , -0.437251191155 , 0.406434381997 , 0.285452286279 , -0.217709173225 , 0.166878655945 , -0.640072236202 , 0.074165920968 , 0.497625515408 , -0.728265115607 , -0.268480770493 , -0.332646113271 , 0.333124888799 , -0.003720471191 , 0.395071936082 , -0.577754056322 , 0.311673845926 , 0.681518804206 , -0.438943753867 , 0.538503514191 , 0.179005147276 , 0.721490321647 , -0.431522324285 , 0.528033848927 , 0.488505998314 , 0.475728806131 , -0.334052107309 , 0.529775262144 , -0.585617756036 , -0.239505032129 , 0.296840432727 , 0.081326862605 , 0.937742620391 , 0.491912306485 , -0.096868418378 , 0.868090973656 , -0.581736546045 , 0.275440784391 , -0.25795223 , -0.783450250362 , 0.475898058562 , 0.435459814867 , 0.763656234214 , 0.059486344959 , 0.422350642638 , -0.278396761547 , 0.893762931322 , 0.526073720051 , -0.533529657643 , -0.327119963228 , -0.970074546222 , 0.012542386069 , -0.18010139261 , -0.867471030703 , -0.44417935248 , 0.363547894794 , 0.102716949204 , -0.144750536136 , -0.43902913459 , -0.357804011941 , 0.604651208939 , -0.14907510723 , 0.012226046911 , 0.400740401337 , 0.919053073999 , 0.137750642889 , 0.665624673282 , -0.013097911283 , -0.129914453871 , 0.806677112689 , 0.846689437061 , 0.605014584329 , -0.244396685384 , -0.755208684676 , 0.113871513046 , -0.404704856805 , -0.762612508775 , 0.605549546169 , 0.021046052813 , -0.573804706471 , 0.22187543318 , -0.583557164421 , 0.760292711848 , 0.001360254508 , -0.887143084637 , 0.060952298667 , -0.805004273899 , -0.768387672351 , -0.168698439417 , 0.335466333419 , -0.448501029972 , 0.203679049759 , 0.763767942902 , -0.487559848628 , -0.603789973772 , -0.617534438224 , 0.356337594353 , 0.592450662968 , 0.589237495048 , -0.956932598442 , 0.888745371649 , 0.212475062411 , 0.83662193925 , -0.475257647454 , 0.416048998448 , -0.083528586978 , ])
t_z = flex.double([ 1.0 , -0.077749945174 , 0.052621881972 , -0.000582043422 , 0.327423255707 , 0.62349376546 , 0.003278758983 , 0.257912651907 , -0.628351384967 , -0.104138192409 , -0.509331677039 , -0.916463789243 , -0.895989071273 , 0.835563336386 , 0.904305582942 , -0.222527811946 , 0.415333310752 , 0.906901217692 , -0.214926677945 , -0.954013273444 , -0.147301842246 , 0.045795126755 , -0.047498017089 , 0.527230805018 , 0.160071114503 , 0.805747336239 , -0.724220955511 , -0.276404610587 , 0.673500315622 , 0.976801883317 , 0.948158953881 , 0.427538782935 , 0.000483212208 , -0.457127143625 , 0.118874012317 , -0.366242753758 , -0.164108287304 , 0.906037874614 , 0.783204957078 , 0.243442491853 , -0.009513620073 , 0.373025917673 , 0.583471259274 , -0.556408511526 , -0.417834742043 , -0.386636382273 , -0.450206531564 , -0.262104384777 , 0.378175129358 , 0.643099281956 , 0.160895767932 , -0.611410027519 , -0.38117564749 , 0.000916860649 , 0.402859479934 , 0.850783980073 , -0.919162802714 , 0.15014432213 , -0.812266156551 , 0.018291491932 , 0.08903284315 , -0.006859796818 , 0.928682879247 , 0.542980907292 , 0.789376612166 , 0.022293625472 , -0.332445855337 , 0.271838998356 , 0.536350939236 , -0.28021423177 , -0.476668731008 , -0.153924500163 , 0.052772464029 , -0.820946251328 , 0.975702294408 , 0.638528959227 , 0.350532928486 , 0.340964284485 , 0.990375754914 , -0.798120268386 , -0.862572702694 , 0.527674540441 , -0.385596936844 , -0.374609860219 , 0.089979632739 , 0.374082124178 , -0.965518712775 , -0.266612813889 , 0.885818899373 , -0.640522478917 , -0.621208873198 , -0.89976999376 , 0.780676780167 , -0.767455012299 , 0.689255467041 , 0.469693886581 , 0.945342619159 , -0.097050223639 , -0.419253286647 , -0.742441128085 , 0.566398913791 , -0.365869567571 , 0.595669196258 , -0.029075592963 , -0.041237685833 , -0.461619105941 , -0.257105374171 , -0.109079500606 , 0.533694245877 , -0.977005398288 , -0.919632665028 , 0.842771474699 , -0.067797677925 , 0.964726957889 , 0.946797415096 , 0.599727539665 , 0.416267224663 , -0.476635358717 , -0.606754911146 , -0.73990563093 , 0.632840935786 , -0.109342147606 , 0.852639301711 , -0.742265383878 , -0.58987146101 , 0.176538486821 , -0.193092860851 , -0.942211517421 , 0.140385446402 , 0.755953473935 , 0.540658051701 , 0.375524845842 , -0.057717915101 , 0.924719214847 , -0.924153621786 , 0.444680232842 , -0.179501711165 , -0.167958506343 , 0.458670094224 , 0.580934609641 , 0.849926533575 , 0.109615241443 , -0.524746704106 , -0.860624729708 , 0.002843165708 , -0.521709491868 , -0.324658746981 , -0.234638074221 , 0.451520108988 , 0.486135364379 , 0.896438379771 , 0.112022015689 , -0.779160707048 , 0.185202009463 , 0.191256764782 , -0.483522649247 , 0.218492089727 , -0.647975687026 , 0.187185146755 , -0.323133950481 , -0.510822132734 , -0.972351384775 , -0.951620398625 , 0.006753169653 , 0.008347481393 , 0.498754187346 , 0.031252372799 , -0.185826684534 , -0.404426697167 , -0.888210700644 , 0.585880230479 , 0.86275804673 , -0.516673005468 , -0.422646224729 , 0.873048250849 , 0.845684370527 , 0.33872469805 , -0.662296914039 , 0.415835596032 , 0.905939468275 , 0.039847165289 , -0.429160982327 , 0.343622743045 , -0.781597823236 , 0.008001277372 , -0.918136403599 , 0.800894399184 , -0.559744730176 , 0.22853435004 , 0.967743804135 , -0.545383177759 , 0.188983747368 , 0.943036415284 , -0.308491500579 , -0.605724794653 , -0.706837564809 , 0.942196144452 , 0.761826824824 , -0.726012923022 , 0.216549789885 , 0.3350772516 , 0.703499435046 , -0.556281400542 , -0.317077872236 , -0.888697229709 , 0.933429433056 , 0.393858505899 , -0.536176972816 , -0.261808408306 , 0.677252284768 , -0.722709168921 , 0.873097627821 , 0.896187326778 , 0.416285391513 , 0.457858328776 , -0.341091005248 , -0.364947356147 , 0.614544718763 , -0.524617527479 , 0.749686871839 , -0.200038165581 , -0.727918862848 , 0.668009312762 , -0.134184967213 , -0.408724493091 , 0.362802938456 , -0.360238015787 , 0.782345853245 , -0.079571564321 , 0.523796252572 , 0.420205952531 , 0.515234207315 , 0.105253580305 , 0.430479198225 , -0.110469278933 , 0.114104756178 , 0.789794338552 , 0.579252642657 , 0.634009368988 , -0.133253694321 , -0.288384895553 , -0.044039853873 , -0.521499021174 , -0.703802075412 , 0.408737447992 , -0.838253440695 , 0.241491352159 , -0.634608176495 , -0.218813134307 , 0.072618969701 , 0.823992216842 , 0.327230522936 , 0.904498631292 , -0.268228186961 , 0.849437898255 , 0.262548783988 , 0.094338065376 , -0.0356066916 , 0.299357492099 , -0.642424423724 , -0.789633922474 , -0.849332483266 , 0.44154841547 , 0.386324376805 , 0.482951501411 , 0.441367504577 , 0.630747225474 , 0.784764302189 , -0.759015745207 , 0.332778674479 , -0.122508675043 , 0.340618768157 , -0.589752056479 , -0.32527389233 , 0.622583719871 , 0.202983987851 , 0.040210411272 , 0.305242435843 , -0.601332997013 , -0.286152021842 , -0.50056768967 , -0.714608509589 , -0.243144650773 , -0.679154961188 , 0.109032795396 , -0.583091011226 , 0.717172588505 , 0.036288688154 , 0.541548225083 , 0.260687621834 , -0.248381829333 , 0.693996651321 , -0.042853161993 , 0.328653701738 , -0.292707934524 , -0.159723587536 , 0.717483051466 , 0.105204892852 , 0.525417722457 , 0.177151525618 , 0.944246493017 , 0.109288557748 , 0.644120295467 , -0.234488688843 , -0.800388707531 , 0.681313538171 , 0.600751495279 , 0.849302835776 , -0.409468101472 , -0.108266881804 , -0.373134514068 , -0.208387995607 , -0.294187324372 , -0.208872679096 , 0.117994907123 , -0.427489434419 , -0.684525234859 , 0.407798486457 , 0.727530504539 , -0.391904517007 , -0.42574840909 , -0.957534517938 , 0.618176317081 , 0.087756652508 , -0.871085724281 , 0.149583882151 , -0.143179915506 , 0.228193866644 , 0.812556739382 , 0.670930281165 , -0.995988062159 , -0.457610378769 , 0.698671124217 , -0.914329777115 , -0.862569124978 , 0.06447117679 , -0.391401360547 , -0.818427673121 , -0.101278801598 , -0.775691107192 , 0.04143930421 , -0.936771933156 , -0.795265845289 , -0.020394796915 , 0.541032265207 , 0.790376391627 , 0.436494306416 , 0.894263243879 , -0.439905557055 , 0.827117458126 , -0.28677376144 , 0.442641434866 , 0.418302303578 , -0.55516063815 , 0.307079468748 , -0.096326323298 , 0.522499348346 , -0.319669616115 , -0.548196074274 , 0.714833496428 , 0.226073989282 , 0.965774286513 , 0.991574563982 , -0.180664146826 , 0.106199788738 , -0.661818861328 , 0.115900140649 , 0.974264676769 , -0.675025630873 , -0.567339999853 , -0.805220440599 , 0.546625179262 , 0.33692887016 , 0.203928236209 , 0.327655811788 , 0.404643291608 , -0.352192104401 , -0.616125954801 , 0.715035657137 , 0.623004288801 , 0.127418863355 , -0.217651960768 , -0.357478355459 , -0.448123545185 , 0.694158923983 , -0.945614404373 , -0.731668883227 , 0.666747598084 , -0.699104128046 , -0.14290604042 , -0.325673223565 , -0.507728476634 , -0.649855296537 , 0.177197010846 , 0.854862371409 , -0.293930525333 , 0.807789267315 , -0.834672431702 , -0.099667833734 , 0.27116950152 , 0.705229636023 , -0.254064988455 , -0.911001377095 , 0.597571141391 , 0.638408421728 , -0.794679482168 , -0.968765358801 , -0.885307379062 , 0.56916197793 , -0.281110155764 , -0.080737345258 , 0.300397485171 , -0.425495114276 , 0.222531807267 , 0.890331286987 , -0.696399904548 , 0.572849296144 , 0.170960130669 , 0.002264923893 , -0.117549926137 , -0.556021168254 , 0.440208429074 , -0.305879071055 , -0.412281825642 , 0.437901256917 , 0.452433609258 , -0.704139024656 , -0.452343966033 , -0.78766659484 , -0.815715834785 , 0.278278124802 , 0.040166482001 , -0.412676682329 , 0.188282953363 , 0.418323431824 , -0.874683736233 , 0.219222047745 , -0.982532048436 , 0.117632696599 , 0.927816819616 , -0.580651757098 , -0.65698638149 , 0.720257015965 , 0.2126205338 , -0.808343695228 , -0.927376580139 , 0.704220456197 , -0.295130044957 , -0.437147777166 , -0.850211263039 , -0.647080568762 , 0.295189717099 , -0.490017095542 , 0.936014027545 , 0.724207199534 , -0.810291084869 , 0.623048877946 , -0.66514211434 , -0.208312289953 , -0.694499409266 , 0.020722232435 , -0.051237875911 , -0.806504704727 , -0.827170251799 , -0.178643035835 , -0.449083379729 , -0.521669992498 , -0.065349384067 , -0.907017089351 , 0.335092819665 , 0.869187892275 , 0.63129417011 , 0.560895626796 , -0.176224988781 , -0.340681782444 , -0.701110115568 , 0.116322642744 , 0.528732800063 , -0.033795876168 , 0.104594388053 , 0.533409501036 , -0.564547183829 , 0.857042687716 , 0.524332669108 , 0.968942672766 , 0.592298283623 , -0.738315612783 , -0.285384927492 , 0.225036951983 , -0.1191972258 , 0.362497242099 , -0.105620108615 , -0.739312411312 , -0.482818850898 , 0.464117740669 , -0.784221566497 , -0.48140489047 , 0.82856517152 , 0.221505560843 , -0.126125326231 , -0.788832165646 , 0.84156579189 , -0.728613254751 , -0.301868872198 , -0.402286669871 , 0.384309704592 , 0.554953843905 , 0.223754994997 , -0.661942740368 , -0.749055189092 , 0.500334670275 , -0.015461222598 , 0.599297420797 , -0.481725436616 , 0.758724007662 , -0.178742642955 , -0.605163899482 , -0.1760842196 , 0.723699593447 , 0.13333794532 , 0.629280295288 , -0.012221856384 , -0.465478323933 , -0.328729830168 , -0.956425707413 , 0.698325867164 , 0.696308034222 , 0.491405992778 , -0.083492047009 , 0.970108670059 , 0.53296593384 , 0.784586164324 , 0.251158671904 , -0.071774510052 , -0.327034313242 , -0.723314900197 , 0.23195489796 , -0.910311585539 , 0.219021547899 , 0.089979679602 , -0.765830824656 , 0.244772961144 , 0.329558054105 , -0.233910278977 , 0.728688640306 , 0.006255271581 , 0.927131375992 , -0.999225887226 , 0.300374696392 , -0.1031534037 , -0.546798234142 , 0.732225963829 , 0.925521644277 , -0.993772499715 , -0.654749123853 , -0.672264370724 , 0.875799378731 , -0.657975669062 , -0.790332850821 , -0.689408466534 , 0.711856264386 , -0.193089587413 , 0.135597405621 , 0.973528409896 , -0.197256830528 , -0.579489573251 , -0.497433189035 , 0.637269409255 , 0.497630047583 , 0.048263220932 , 0.256660601778 , -0.593711588592 , 0.012655267178 , -0.117821606922 , 0.546415067469 , -0.245423794742 , 0.45187918135 , 0.338622694105 , -0.369519678872 , 0.895750037371 , -0.583071726901 , 0.888645858055 , -0.065811117551 , 0.356094370048 , -0.136340588479 , 0.356397245262 , 0.713040073816 , 0.456458979922 , 0.906124594826 , -0.483127936777 , 0.177439298092 , 0.776081214689 , 0.338773425244 , 0.007010405026 , 0.11164993545 , -0.911853789594 , -0.397608265021 , 0.0164876408 , -0.204355649782 , -0.894400968684 , -0.442656197588 , -0.158287391342 , -0.373450306587 , 0.04623142653 , -0.4447661021 , -0.485416395454 , 0.496545655196 , -0.858632076535 , -0.503069191872 , 0.93184651267 , 0.349722109203 , -0.079893511526 , 0.719304528279 , 0.230691784457 , 0.612751085938 , -0.311122778903 , -0.888125007209 , -0.941669397924 , 0.476470282469 , 0.293622753073 , -0.740546362111 , 0.093264478135 , 0.880661035316 , -0.535830056737 , 0.943713910352 , 0.393293743773 , -0.172680544119 , 0.522825373855 , -0.321942071431 , -0.989417727146 , 0.326291157144 , 0.132635218716 , 0.306943940191 , 0.76713724672 , 0.620954038194 , -0.101447219175 , -0.269968139548 , 0.840718358333 , 0.2156258598 , -0.314653504683 , 0.064403261026 , -0.200902687032 , -0.744383864792 , -0.97311112577 , -0.572776973842 , 0.872576557555 , -0.394295374583 , 0.677680791054 , -0.333368053219 , -0.93398685942 , -0.616622536307 , -0.517750982279 , -0.479254934231 , 0.123015630798 , 0.570159636215 , -0.916889072191 , 0.233746708365 , -0.757052310487 , -0.874965249518 , 0.760596218114 , -0.977286229457 , 0.633255494191 , -0.730448787448 , -0.106832631513 , 0.703320692927 , 0.834107864094 , 0.186883959595 , -0.943541465795 , 0.953964980318 , 0.750016612194 , 0.755376533926 , 0.011710152473 , 0.571667622583 , -0.747011778227 , 0.545114003159 , 0.230479665069 , 0.740966289711 , 0.477038747717 , -0.249129830079 , -0.407350663096 , -0.209407135625 , 0.512165747395 , 0.428926222133 , -0.156218878178 , -0.345183114809 , -0.779061323668 , 0.419129256504 , 0.507018763119 , 0.831872955397 , 0.152977145475 , 0.788139102541 , 0.004366861748 , 0.442727254488 , 0.629126376443 , -0.666679848091 , -0.077942586 , -0.521063057988 , 0.135309757701 , 0.834929166575 , -0.214758053256 , -0.156057803546 , -0.305950125303 , 0.249430358112 , -0.321043553868 , 0.663552719164 , -0.495493771575 , 0.756372364152 , 0.769424091487 , -0.093700043407 , 0.772229009495 , 0.107183615744 , 0.312412458992 , -0.24630096656 , 0.304869240188 , 0.134732499236 , -0.033837575372 , -0.136370286959 , 0.436001594352 , -0.540661884801 , -0.640348783852 , -0.581158316919 , -0.464027782173 , -0.389819449583 , -0.845703794841 , 0.715373436671 , -0.614362277516 , -0.213376423157 , 0.231717992321 , -0.994697005659 , -0.583354375492 , -0.956386586164 , -0.254964139267 , 0.636568943037 , -0.370164826578 , 0.771853548643 , -0.811156476168 , -0.861756768885 , -0.434455974816 , 0.991910746974 , 0.778064309242 , -0.523137798635 , -0.112030690614 , -0.800878426963 , 0.000938278313 , -0.896644500228 , -0.616881763716 , 0.819592362834 , 0.894758743252 , -0.765755068919 , 0.898598532888 , 0.526220497563 , -0.77773327752 , -0.192282635529 , -0.988280670983 , 0.413721778042 , -0.959741115085 , 0.805680185887 , -0.409630157128 , -0.590670060601 , -0.607374938523 , 0.993171304709 , -0.295823807917 , -0.666457446273 , 0.762446377605 , -0.47363199371 , 0.552893699974 , 0.839471412287 , -0.615986740663 , 0.210504636831 , 0.387205931983 , -0.697575751024 , -0.563018061436 , 0.261001186353 , 0.277364986136 , -0.860692256897 , -0.589733682711 , -0.714190741684 , -0.085080965602 , 0.96501250985 , 0.218463296012 , -0.408918316029 , 0.982888742449 , -0.832792611356 , -0.982906108868 , 0.337761841262 , 0.70941529111 , -0.256769791948 , 0.628140034126 , 0.67667606479 , 0.497144020244 , -0.856730338893 , 0.461834796652 , -0.828690603772 , -0.86068390832 , -0.220746443156 , 0.601855712309 , -0.654422835816 , 0.018190145883 , -0.869133798912 , 0.942583300718 , -0.743101949865 , -0.938031231887 , 0.234436662975 , -0.060450767222 , -0.653550338986 , 0.94118150108 , 0.457934262238 , -0.627419264912 , 0.900508077229 , -0.368781748473 , 0.439593603739 , -0.67743472325 , -0.036031191279 , 0.806262569543 , -0.949325254017 , 0.310417967226 , -0.2098199107 , 0.031473680299 , -0.839803035674 , 0.104029450994 , -0.075286984447 , 0.667983754595 , -0.605701103351 , -0.914634676087 , 0.783917620603 , -0.688797540003 , 0.316198073793 , -0.840536422923 , -0.867511850563 , 0.296734316388 , 0.107890501847 , 0.636352831086 , -0.388183991234 , 0.601749356913 , 0.547917320106 , 0.244980947789 , -0.508283650963 , 0.303022898098 , 0.360968407504 , -0.957374495354 , -0.419920419993 , -0.087337132995 , 0.830752939827 , 0.805103636079 , -0.198478590013 , -0.227819419812 , -0.983612569449 , -0.496847615873 , 0.496140592533 , -0.744510505919 , -0.825108417412 , 0.974950758696 , -0.689571185065 , 0.84847880972 , 0.355663607854 , 0.341995011948 , 0.049094917079 , -0.856263043024 , 0.212362161166 , 0.674884483518 , 0.109148602793 , 0.9011806193 , 0.989835107272 , 0.001833120034 , -0.523407896208 , -0.145521496021 , 0.768182181377 , 0.152338323547 , -0.037569419198 , 0.135252383933 , 0.540939234938 , -0.703813513693 , 0.993189027826 , -0.339209520033 , 0.257667941431 , 0.09015373309 , -0.278049770363 , -0.788330941624 , -0.344949617449 , 0.691160169649 , -0.017425137238 , 0.444445920127 , -0.975557519294 , 0.214130153167 , -0.56718311205 , -0.647862219191 , 0.122878171909 , 0.062886612697 , 0.633751193312 , 0.330597776511 , -0.498481346288 , -0.560666511912 , 0.468870632646 , -0.006389386524 , -0.20270546333 , -0.122626923355 , 0.540622098195 , -0.876490560589 , -0.898578967584 , 0.134916703009 , ])
t_w = flex.double([ 0.0104739940264 , 0.017853847044 , 0.0143651999597 , 0.0169079005938 , 0.0155904051593 , 0.0157065125731 , 0.0145123186712 , 0.0137152551377 , 0.0171455054674 , 0.0169520615919 , 0.0132975361754 , 0.0137321835357 , 0.0140323333103 , 0.0118809084097 , 0.0145032001057 , 0.0087165051103 , 0.020470156143 , 0.0252397916276 , 0.0128426303728 , 0.015038723698 , 0.0161605522391 , 0.010964156242 , 0.0117951173089 , 0.014965672702 , 0.0197146487701 , 0.0218341483981 , 0.0132733434932 , 0.0105698007859 , 0.015060979561 , 0.0146007192855 , 0.027145608247 , 0.0151302009694 , 0.0167347573437 , 0.0146688203288 , 0.0105761607606 , 0.0142420743716 , 0.0148525202232 , 0.001557098779 , 0.0217356807946 , 0.00919522484776 , 0.0123212209553 , 0.0143923885619 , 0.00990305238991 , 0.0122904031693 , 0.0110167976757 , 0.0145765375053 , 0.0131530962098 , 0.014190658714 , 0.0145566730022 , 0.00758458166077 , 0.00947219111389 , 0.0127284497503 , 0.0188795702132 , 0.0166898283161 , 0.0166377070835 , 0.00864100772139 , 0.0108841291308 , 0.0164377129325 , 0.0169171368556 , 0.0162301106714 , 0.0161595016463 , 0.0154508928099 , 0.0140372484744 , 0.00881228776778 , 0.0183888912628 , 0.00970613069465 , 0.0116749134976 , 0.0209620425921 , 0.00508818991981 , 0.0113416466002 , 0.0138047319305 , 0.010627915069 , 0.0148477263994 , 0.0150186358731 , 0.0126407663791 , 0.0133975968715 , 0.00779960188726 , 0.018690356805 , -0.00091046302376 , 0.0102634322678 , 0.0156799629728 , 0.0186699227108 , 0.016181399945 , 0.0121338252668 , 0.0161204022805 , 0.0148862022897 , 0.0177540689788 , 0.00941810723833 , 0.011874294647 , 0.0136102682459 , 0.0135904901746 , 0.0183938636625 , 0.0188912658169 , 0.0109120214313 , 0.0108279884705 , 0.0114849309575 , 0.0222444229895 , 0.0122047725379 , 0.0093339897383 , 0.0135840498306 , 0.0107853480418 , 0.0101583825346 , 0.0104267795271 , 0.0111243359915 , 0.0130749439435 , 0.0188603794219 , 0.0106875496117 , 0.0130521992444 , 0.0177919580376 , 0.0137389950101 , 0.0153001220333 , 0.00958085190788 , 0.0135133264678 , 0.0254979136338 , 0.0141884652051 , 0.00937890558873 , 0.0147567556022 , 0.0117540457269 , 0.00909479440213 , 0.0138642466687 , 0.00981712669113 , 0.0112243999487 , 0.0231076116254 , 0.00839790120002 , 0.0135514707684 , 0.0139802267645 , 0.0167852955596 , 0.010907170337 , 0.0164761461711 , 0.00414187813635 , 0.0178039742199 , 0.0173215371669 , 0.0102261630267 , 0.00995915771645 , 0.0131342240264 , 0.0153939741433 , 0.0135512771266 , 0.0121296899069 , 0.0160378042455 , 0.010247131685 , 0.0182369553717 , 0.0149374828109 , 0.0112272853886 , 0.0158334489665 , 0.0180870000506 , 0.0141283048056 , 0.0118587149005 , 0.0131244106525 , 0.00606510913806 , 0.0113044023947 , 0.0197979437539 , 0.00990495237073 , 0.0182113189229 , 0.0104595336196 , 0.0118886348721 , 0.00966360822807 , 0.0109417785761 , 0.0133646265664 , 0.0146454357932 , 0.0103493731339 , 0.0129215822617 , 0.0140080268317 , 0.0158316957096 , 0.0172288632464 , 0.0134385746581 , 0.015273911137 , 0.0188125486022 , 0.014309280406 , 0.0175438142495 , 0.0147976841225 , 0.0135739568576 , -0.000152233167733 , 0.0115955744771 , 0.00908625658796 , 0.0110661009035 , 0.0128931235454 , 0.0210388192172 , 0.0155922932306 , 0.0083537714746 , 0.0124717021513 , 0.010087921169 , 0.0134482591236 , 0.0189201562662 , 0.0151455375993 , 0.0110099097068 , 0.0130606750257 , 0.0146097105323 , 0.016665217543 , 0.0192080128747 , 0.0193986906989 , 0.0114750905371 , 0.0087295284005 , -0.00312153305796 , 0.0144846231317 , 0.0161438769622 , 0.0126073662696 , 0.00350470418029 , 0.011227931821 , 0.0117717152624 , 0.0168655297336 , 0.0159783226287 , 0.0142008564913 , 0.0144878228206 , 0.014927674863 , 0.0161088588929 , 0.00896916814522 , 0.00951948160595 , 0.0109244224189 , 0.0199016257855 , 0.018183716912 , 0.0134898231511 , 0.0127072455893 , 0.00303849993703 , 0.0133356087051 , 0.0129351638391 , 0.017200354043 , 0.0133943507987 , 0.0119527707031 , 0.00899453158265 , 0.0179541660744 , 0.0149986061956 , 0.0134732283491 , 0.0196899861254 , 0.0142100433946 , 0.0147690339529 , 0.0106544892186 , 0.0116953719404 , 0.0170712084658 , 0.0183996168327 , 0.00969240122728 , 0.0163993186395 , 0.0212075342505 , 0.01634045004 , 0.0142772373806 , 0.0149414055427 , 0.0151893573254 , 0.00977672185908 , 0.0138585676285 , 0.00373427839472 , 0.0152943312769 , 0.0112449144517 , 0.0132302584673 , 0.0186904031721 , 0.00950121841174 , 0.00825591852117 , 0.013139074601 , 0.0183916762704 , 0.0172901381443 , 0.0170250268505 , 0.0132927192697 , 0.00952805698572 , 0.00685281143153 , 0.0168840242552 , 0.0142162685874 , 0.00976756600466 , 0.0154268880173 , 0.0150613488767 , 0.0102639881184 , 0.0103516403947 , 0.012354229894 , 0.011500024731 , 0.0108221681755 , 0.0100816313926 , 0.0149486058902 , 0.0120936224889 , 0.0180677776525 , 0.0184677092049 , 0.00741019620952 , 0.0167610470893 , 0.0172054205334 , 0.0105561847294 , 0.0092363122332 , 0.010416023874 , 0.0138134713121 , 0.0203373769768 , 0.00939829368453 , 0.0174734114676 , 0.0168229656421 , 0.0143049630982 , 0.0100784852365 , 0.018154403162 , 0.0156478618819 , 0.017845573185 , 0.0141004618001 , 0.015919512892 , 0.0182187230767 , 0.0190884149824 , 0.0106078909137 , 0.021897891666 , 0.0091468578534 , 0.0130625089119 , 0.0112095457346 , 0.0145488334609 , 0.0178058308264 , 0.018244621244 , 0.0141928366868 , 0.0199887387405 , 0.0148659738117 , 0.0156700991306 , 0.0104039186427 , 0.00906032849627 , 0.00838838396196 , 0.00947791372696 , 0.0203088923143 , 0.0128874625735 , 0.0169430710167 , 0.0118717516181 , 0.0167198061537 , 0.0148789336774 , 0.0149817206671 , 0.0195134395258 , 0.0115018934044 , 0.0152972647575 , 0.011713291844 , 0.0190842976967 , 0.0115582743332 , 0.0162293444344 , 0.00964440018571 , 0.0123678958286 , 0.0153852895449 , 0.0171515424349 , 0.0157037623834 , 0.0218582417426 , 0.011346781683 , 0.0154796392851 , 0.0116977998433 , 0.0134905152259 , 0.00697587883016 , 0.0239480069238 , 0.0195380706928 , 0.0152537981952 , 0.00953428980041 , 0.0135728121201 , 0.014899947792 , 0.0103273595321 , 0.0206375190864 , 0.0137123175848 , 0.0134757367399 , 0.0187401756134 , 0.0147491232729 , 0.0127720864907 , 0.0165389357225 , 0.015394865885 , 0.0126994604864 , 0.00592183677301 , 0.0010871328454 , 0.0150762800122 , 0.0227743345045 , 0.0188108664651 , 0.0245601831126 , 0.0148748937266 , 0.0166451269171 , 0.00940507650093 , 0.0129638494967 , 0.0166324797106 , 0.014404465723 , 0.0145786521863 , 0.0175704450812 , 0.015348095408 , 0.0251331155074 , 0.0200975697137 , 0.0282240330836 , 0.00839696134496 , 0.0117999797924 , 0.0128003220045 , 0.0181275063917 , 0.0120767425696 , 0.00181925601272 , 0.011347044429 , 0.0181798327626 , 0.00875806293708 , 0.0184443614759 , 0.0103363020122 , 0.0167555913171 , 0.0127039495595 , 0.0181630885195 , 0.0105349992938 , 0.0180220721972 , 0.0107919626781 , 0.0153721339861 , 0.0091719245441 , 0.0135659711022 , 0.0117016074695 , 0.0165631460283 , 0.0195769427848 , 0.0116517395559 , 0.0172602337715 , 0.015957967113 , 0.0134478295478 , 0.0183917279803 , 0.0137726828829 , 0.0160224084133 , 0.0164073099352 , 0.0175378069594 , 0.0242118019262 , 0.0168429926727 , 0.0198824458221 , 0.0153382584148 , 0.0103146613892 , 0.0146673729458 , 0.00649015663838 , 0.0181114664252 , 0.0119597740867 , 0.014354458391 , 0.017392077674 , 0.0152298156196 , 0.0116096063641 , 0.0108026149374 , 0.00919086950626 , 0.0108761777533 , 0.0116322160471 , 0.0148236296959 , 0.0148417165787 , 0.0191203269221 , 0.0167775094997 , 0.0165948755002 , 0.0155113592515 , 0.015883594519 , 0.0113326630035 , 0.0120033631209 , 0.0153001805482 , 0.0199282064811 , 0.0171347127575 , 0.011900902657 , 0.0207562819579 , 0.0131095881794 , 0.0176867913224 , 0.011581217578 , 0.0172427059409 , 0.0168908045121 , 0.0100336932044 , 0.0111359427447 , 0.0134625669591 , 0.0156220148616 , 0.0171644429017 , 0.0148861084075 , 0.0140094203629 , 0.0124905151786 , 0.016947918691 , 0.0131276831012 , 0.0171858718576 , 0.0132335814622 , 0.00994979059309 , 0.0157664567999 , 0.0182770640261 , 0.0120192509171 , 0.00894208174473 , 0.0106795316289 , 0.0145071388894 , 0.0123419851685 , 0.00957417129902 , 0.015930876255 , 0.0153523870783 , 0.020020027637 , 0.00950870889933 , 0.0143334138597 , 0.02052336292 , 0.0156205320958 , 0.0107565429025 , 0.014988799316 , 0.0137999759763 , 0.0119823234072 , 0.0184137975043 , 0.0163518264064 , 0.0118271631801 , 0.0148402098826 , 0.0158487785348 , 0.0149766591731 , 0.0147222714696 , 0.0202543946433 , 0.0186711840293 , 0.0141513527879 , 0.0162401489111 , 0.0167374781954 , 0.016780510871 , 0.0148721034554 , 0.0116530771915 , 0.0178648938791 , 0.0182966806591 , 0.0124966173578 , 0.014052995503 , 0.0130349201624 , 0.0120019554907 , 0.0142791856974 , 0.00394506762505 , 0.0119815043995 , 0.0174762586705 , 0.0150175024461 , 0.0134027354105 , 0.0167775468506 , 0.016472198784 , 0.0156346141873 , 0.0167372807395 , 0.0172440849402 , 0.00837178299402 , 0.0192030358844 , 0.00955080595874 , 0.0116383359308 , 0.0087771462352 , 0.0121440156136 , 0.0144499089331 , 0.0132338409506 , 0.0129633575346 , 0.0148351668417 , 0.0106351486138 , 0.0113452860185 , 0.0122697194426 , 0.00886586819686 , 0.0114296831582 , 0.013928699189 , 0.0168864587555 , 0.0174142097499 , 0.0170120425933 , 0.0138169556475 , 0.0137099015687 , 0.0184556257598 , 0.0139778423811 , 0.0118686229009 , 0.0166174943419 , 0.0180841349899 , 0.0145094852753 , 0.0205261541854 , 0.0128492545425 , 0.0116359865802 , 0.0119355193049 , 0.00527496610009 , 0.0154753508344 , 0.0114380946661 , 0.0174532416469 , 0.00918192671893 , 0.00502388931196 , 0.00642338519341 , 0.0120604350156 , 0.0106355039408 , 0.0116473939643 , 0.0140349458379 , 0.00692661284692 , 0.012483128541 , 0.0110938189705 , 0.0134736996703 , 0.0121496913375 , 0.00827759390998 , 0.0144552813343 , 0.0152153220163 , 0.0080415945338 , 0.0138253737514 , 0.0131377693546 , 0.0146914993521 , 0.0144011800887 , 0.0173252725207 , 0.0144085628674 , 0.0150049684962 , 0.00748514103817 , 0.0139618970551 , 0.0141998054699 , 0.0162965397563 , 0.00444394111529 , 0.0154533010845 , 0.0101884572775 , 0.0152647328381 , 0.00343789376642 , 0.0164801659414 , 0.0110134526577 , 0.0203589781112 , 0.0166962573842 , 0.0152750636456 , 0.0154694790137 , 0.0115021003493 , 0.0136190400356 , 0.0109677500376 , 0.0163694885271 , 0.0137087933784 , 0.0121470712117 , 0.0123224595077 , 0.0164241794568 , 0.0132251923044 , 0.0168265224636 , 0.00819691480447 , 0.00976747451789 , 0.0165728547812 , 0.0138716650318 , 0.0209911575968 , 0.018179979595 , 0.0175198526792 , 0.0112349241438 , 0.0170911077486 , 0.0210682351563 , 0.00889074039944 , 0.0131709151646 , 0.0103103414986 , 0.0119716279075 , 0.0175911320903 , 0.0121699243556 , 0.0129155635954 , 0.0163373056543 , 0.0159853911175 , 0.0171410239703 , 0.00916363511543 , 0.0116154656123 , 0.0137731832012 , 0.0158271386942 , 0.020691422413 , 0.0153980036852 , 0.0130558120048 , 0.0154110894031 , 0.0183266902017 , 0.0193168594566 , 0.0108948246295 , 0.0108892172297 , 0.0160385825735 , 0.0171911724681 , 0.0120242022669 , 0.0162148225333 , 0.0141276277588 , 0.0100173841067 , 0.0144963387566 , 0.0104848827784 , 0.0110214440613 , 0.0155127858419 , 0.0187218578788 , 0.017817598995 , 0.0101929722577 , 0.0225359670839 , 0.0183267028693 , 0.0103941336701 , 0.0158988414629 , 0.0101711201803 , 0.00646935301386 , 0.0149822167878 , 0.0114011356317 , 0.00837571435045 , 0.0140829384461 , 0.0142451609707 , 0.00600406686013 , 0.0174541475307 , 0.013371891215 , 0.0144127197685 , 0.0202806301538 , 0.0156353799815 , 0.0165770371429 , 0.0213559716848 , 0.0146924333473 , 0.0109295265163 , 0.0147275865179 , 0.0147574126298 , 0.0137650811387 , 0.012919775373 , 0.0198206042012 , 0.0125486811001 , 0.0162238864355 , 0.0140330535851 , 0.0127437305269 , 0.0179392657836 , 0.0119905864427 , 0.0135370758404 , 0.0180627529112 , 0.0118365371474 , 0.00984470988312 , 0.0115000948301 , 0.0184365071384 , 0.0132063969638 , 0.00361563524838 , 0.00901775816589 , 0.0149818121578 , 0.00748475863223 , 0.004216501074 , 0.0161048663993 , 0.0129155710692 , 0.0162166714012 , 0.0118252551326 , 0.0117036802084 , 0.0162040163645 , 0.00750644965741 , 0.0127041630843 , 0.0168372191371 , 0.0139642461726 , 0.0156450084944 , 0.0213273540765 , 0.0123184671556 , 0.0132975865948 , 0.0155638417103 , 0.0174141291594 , 0.00930826003058 , 0.00884940766751 , 0.0171967902778 , 0.0140892657347 , 0.00874830164666 , 0.0180536605541 , 0.0146829648091 , 0.0103704225345 , 0.0156563881329 , 0.00978543171378 , 0.00355857675449 , 0.023559817363 , 0.0109741794823 , 0.0121233614675 , 0.0148400452388 , 0.0198629600465 , 0.0141172114862 , 0.0134287166577 , 0.0123302244519 , 0.0156497880667 , 0.0142067595025 , 0.0132613261485 , 0.014690613761 , 0.0103597304506 , 0.0050944405484 , 0.0242468489095 , 0.013069055676 , 0.019836472529 , 0.0111975171082 , 0.0127439260669 , 0.0174857879333 , 0.011743998323 , 0.0150765336701 , 0.0174657410806 , 0.0168519539371 , 0.0195734198324 , 0.0158041085189 , 0.0155378912574 , 0.0127812271253 , 0.0124098700498 , 0.0132684287645 , 0.0100754554411 , 0.00928059150629 , 0.0153779598874 , 0.0146613875122 , 0.013990436462 , 0.0106671435773 , 0.0140840743757 , 0.0154470287946 , 0.0132290631145 , 0.00951218599325 , 0.0114453441958 , 0.0142860505216 , 0.0116651332734 , 0.0160070840092 , 0.0140007162119 , 0.024377243989 , 0.0221965082054 , 0.0165888217952 , 0.0100983718735 , 0.0130670245387 , 0.0108477824789 , 0.0181357576215 , 0.00975326078754 , 0.00354106595078 , 0.0258504869856 , 0.00918888438167 , 0.0078127803408 , 0.0103079029952 , 0.0111664541327 , 0.0121527924313 , 0.0163489292756 , 0.0104449653325 , 0.012093946466 , 0.0223445430733 , 0.0120798081766 , 0.0107320804625 , 0.0098076395818 , 0.0285900908079 , 0.0179019707775 , 0.0148753782115 , 0.0111402755925 , 0.012333505614 , 0.0195028015762 , 0.00892631873306 , 0.018492946492 , 0.0200833526563 , 0.00663296701919 , 0.0189616873738 , 0.0171133465474 , 0.00663458054952 , 0.0209516955857 , 0.0138110311979 , 0.0137477829001 , 0.0133435157755 , 0.0190960576272 , 0.0125202123346 , 0.0158358024544 , 0.0127472934234 , 0.0160241647772 , 0.0169282370442 , 0.0146581633941 , 0.00664932120186 , 0.0184078014982 , 0.0147123142773 , 0.0160373800627 , 0.0173248099342 , 0.0144707651046 , 0.00964685240425 , 0.0152812111003 , 0.0154159444178 , 0.0127663336011 , 0.0133750963917 , 0.00775869320893 , 0.0115745725019 , 0.0126072258574 , 0.011873006326 , 0.0186702295536 , 0.0104412542561 , 0.0110407047513 , 0.0190971303291 , 0.0104517202751 , 0.0107989879036 , 0.0143678659091 , 0.00802690877102 , 0.0150824975246 , 0.00529756306829 , 0.0118241767045 , 0.0147470768348 , 0.0167497432649 , 0.0216293018934 , 0.017886406974 , 0.0157534835911 , 0.0116892603434 , 0.0131090041913 , 0.0120429330633 , 0.0116736512591 , 0.0149372253101 , 0.0110505993986 , 0.0185730385271 , 0.00844475097936 , 0.0179767133601 , 0.00494556012234 , 0.0136714855845 , 0.0185038717302 , 0.0177167656815 , 0.0174041116094 , 0.00824314186507 , 0.0209151937253 , 0.00735221357433 , 0.016922342401 , 0.0206836885559 , 0.0100603298829 , 0.0158887597709 , 0.0142540803058 , 0.0148819103632 , 0.0187393236162 , 0.0118374747541 , 0.0144065734537 , 0.0125193594005 , 0.0101992025311 , 0.0183805489428 , 0.010708707426 , 0.0107973855541 , 0.0137399445843 , 0.0173683219723 , 0.0197471636688 , 0.0153202035268 , 0.0156912283107 , 0.0100819519142 , 0.011228284419 , 0.00191103973535 , 0.016632856818 , 0.015142990281 , 0.0143177598525 , 0.0123857379206 , 0.0159941336752 , 0.0197070413736 , 0.0130320632292 , 0.0258571108078 , 0.00671073697209 , 0.0150127926812 , 0.0162176060678 , 0.0141885668385 , 0.0157995498228 , 0.00815827386356 , 0.00968271289993 , 0.017968308856 , 0.0205940382414 , 0.0131839851344 , 0.0182976985286 , 0.0166533592631 , 0.0140803026758 , 0.016895277133 , 0.0129467399414 , 0.0161614990806 , 0.0147839314732 , 0.00947657338519 , 0.0110770881939 , 0.0179013928383 , 0.0177755140851 , 0.0132652876017 , 0.00855754285981 , 0.0136009701345 , 0.0141960662354 , 0.00657470307656 , 0.0180224480585 , 0.0138198584017 , 0.0125520320705 , 0.0107306676947 , 0.00936720234391 , 0.0154114969596 , 0.0160912117965 , 0.0142482831673 , 0.0164799866076 , 0.0126982495897 , 0.0139536823524 , 0.0170321172872 , ])
