/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#      define  FORT_INITDATA  initdata
#      define  FORT_PROBINIT  probinit
#      define  FORT_SET_CELL_VELBC setcellvelbc
#      define  FORT_DERVORT   dervort
#      define  FORT_DERAVGP   deravgp
#      define  FORT_XINIT     xinit
#      define  FORT_DERIVE    derive
#      define  FORT_CMPDT     cmpdt
#      define  FORT_SLOPEX    fslopex
#      define  FORT_SLOPEY    fslopey
#      define  FORT_LAPLAC    laplac
#      define  FORT_MKFORCE   mkforce
#      define  FORT_MKSCALFORCE   mkscalforce
#      define  FORT_MKDIVUCC  mkdivucc
#      define  FORT_MKDIVUNOD mkdivunod
#      define  FORT_MKADVVEL  mkadvvel
#      define  FORT_MKVELFLUX mkvelflux
#      define  FORT_MKSCAFLUX mkscaflux
#      define  FORT_SCALUPD   scalupd
#      define  FORT_VELUPD    velupd
#      define  FORT_SETVELBC  setvelbc
#      define  FORT_SETSCALBC setscalbc 
#else
#if defined(BL_FORT_USE_UNDERSCORE)
#      define  FORT_INITDATA  initdata_
#      define  FORT_PROBINIT  probinit_
#      define  FORT_SET_CELL_VELBC setcellvelbc_
#      define  FORT_DERVORT   dervort_
#      define  FORT_DERAVGP   deravgp_
#      define  FORT_XINIT     xinit_
#      define  FORT_DERIVE    derive_
#      define  FORT_CMPDT     cmpdt_
#      define  FORT_SLOPEX    fslopex_
#      define  FORT_SLOPEY    fslopey_
#      define  FORT_LAPLAC    laplac_
#      define  FORT_MKFORCE   mkforce_
#      define  FORT_MKSCALFORCE   mkscalforce_
#      define  FORT_MKDIVUCC  mkdivucc_
#      define  FORT_MKDIVUNOD mkdivunod_
#      define  FORT_MKADVVEL  mkadvvel_
#      define  FORT_MKVELFLUX mkvelflux_
#      define  FORT_MKSCAFLUX mkscaflux_
#      define  FORT_SCALUPD   scalupd_
#      define  FORT_VELUPD    velupd_
#      define  FORT_SETVELBC  setvelbc_ 
#      define  FORT_SETSCALBC setscalbc_ 
#elif defined(BL_FORT_USE_UPPERCASE)
#      define  FORT_INITDATA  INITDATA
#      define  FORT_PROBINIT  PROBINIT
#      define  FORT_SET_CELL_VELBC SETCELLVELBC
#      define  FORT_DERVORT   DERVORT
#      define  FORT_DERAVGP   DERAVGP
#      define  FORT_XINIT     XINIT
#      define  FORT_DERIVE    DERIVE 
#      define  FORT_CMPDT     CMPDT 
#      define  FORT_SLOPEX    FSLOPEX
#      define  FORT_SLOPEY    FSLOPEY
#      define  FORT_LAPLAC    LAPLAC
#      define  FORT_MKFORCE   MKFORCE
#      define  FORT_MKSCALFORCE   MKSCALFORCE
#      define  FORT_MKDIVUCC  MKDIVUCC
#      define  FORT_MKDIVUNOD MKDIVUNOD
#      define  FORT_MKADVVEL  MKADVVEL
#      define  FORT_MKVELFLUX MKVELFLUX
#      define  FORT_MKSCAFLUX MKSCAFLUX
#      define  FORT_SCALUPD   SCALUPD
#      define  FORT_VELUPD    VELUPD
#      define  FORT_SETVELBC  SETVELBC 
#      define  FORT_SETSCALBC SETSCALBC  
#elif defined(BL_FORT_USE_LOWERCASE)
#      define  FORT_INITDATA  initdata
#      define  FORT_PROBINIT  probinit
#      define  FORT_SET_CELL_VELBC setcellvelbc
#      define  FORT_DERVORT   dervort
#      define  FORT_DERAVGP   deravgp
#      define  FORT_XINIT     xinit
#      define  FORT_DERIVE    derive 
#      define  FORT_CMPDT     cmpdt 
#      define  FORT_SLOPEX    fslopex
#      define  FORT_SLOPEY    fslopey
#      define  FORT_LAPLAC    laplac
#      define  FORT_MKFORCE   mkforce
#      define  FORT_MKSCALFORCE   mkscalforce
#      define  FORT_MKDIVUCC  mkdivucc
#      define  FORT_MKDIVUNOD mkdivunod
#      define  FORT_MKADVVEL  mkadvvel
#      define  FORT_MKVELFLUX mkvelflux
#      define  FORT_MKSCAFLUX mkscaflux
#      define  FORT_SCALUPD   scalupd
#      define  FORT_VELUPD    velupd
#      define  FORT_SETVELBC  setvelbc 
#      define  FORT_SETSCALBC setscalbc  
#endif

extern "C" {

  void  FORT_INITDATA(Real * u, Real * v, Real * scalars,
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2, const Real * dx,
		      Real * time, int * numscal);

  void FORT_PROBINIT (const int* name,
                      const int* namelen);

  void  FORT_DERVORT(Real* state, Real * derval, 
		     const int& derlo_1, const int& derlo_2,
                     const int& derhi_1, const int& derhi_2, 
		     const int& lo_1, const int& lo_2,
                     const int& hi_1, const int& hi_2, 
		     const Real* dx);

  void  FORT_SET_CELL_VELBC(Real* u, Real* v, 
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2, 
	              int * bcx_lo, int * bcx_hi, 
	              int * bcy_lo, int * bcy_hi, 
                      int * irz, Real * visc_coef, Real * dx, Real * time);

  void  FORT_DERAVGP(Real* pressure, Real * dat, 
		     const int& lo_1, const int& lo_2,
                     const int& hi_1, const int& hi_2); 

  void  FORT_CMPDT(Real * u, Real * v, Real * rho,  Real * px, Real * py,
		   Real * force, Real* dx, Real * dt, Real * cfl,
		   const int & lo_1, const int & lo_2,
		   const int & hi_1, const int & hi_2);

  void  FORT_SLOPEX(Real * s, Real * slx, Real * dfromx,
		    const int& lo_1, const int& lo_2,
                    const int& hi_1, const int& hi_2,
                    int * first_comp, int * nvar,
		    int * bcx_lo, int * bcx_hi, int * irz, 
                    int * slope_order);

  void  FORT_SLOPEY(Real * s, Real * sly, Real * dfromy,
		    const int& lo_1, const int& lo_2,
                    const int& hi_1, const int& hi_2, int * nvar,
		    int * bcy_lo, int * bcy_hi, 
                    int * slope_order);

  void  FORT_LAPLAC(Real * u, Real * lapu, 
		    Real * x, Real * xhalf,
		    const int& lo_1, const int& lo_2,
                    const int& hi_1, const int& hi_2, Real * dx,
                    Real * visc_coef, int * irz, 
                    int * bcx_lo, int * bcx_hi,
                    int * bcy_lo, int * bcy_hi,
                    int * idir);

  void  FORT_MKFORCE(Real * force, Real * u, Real * v, 
		     Real * rho, Real * gravity,
		     Real * visc_coef, Real * time, const Real * dx, 
		     const int& lo_1, const int& lo_2,
                     const int& hi_1, const int& hi_2);

  void  FORT_MKSCALFORCE(Real * force, Real * s, 
		         Real * time, const Real * dx, 
		         const int& lo_1, const int& lo_2,
                         const int& hi_1, const int& hi_2,
                         int * numscal);

  void  FORT_MKDIVUCC(Real * divu_src, Real * u, Real * v, 
		      Real * rho, Real * time, const Real * dx,
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2);

  void  FORT_MKDIVUNOD(Real * divu_src, Real * u, Real * v, 
		       Real * rho, Real * time, const Real * dx,
		       const int& lo_1, const int& lo_2,
                       const int& hi_1, const int& hi_2);

  void  FORT_MKADVVEL(Real * u, Real * ux, Real * uy, 
                      Real * v, Real * vx, Real * vy,
                      Real * rho,  Real * force, Real * px, Real * py, 
		      Real * lapu, Real * dx, Real & dt,
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2,
                      Real * stlft, Real * strgt, Real * sttop, Real * stbot,
                      Real * uadv, Real * vadv, 
                      Real * utrans, Real * vtrans, 
		      int * bcx_lo, int * bcx_hi,
                      int * bcy_lo, int * bcy_hi, 
                      Real * visc_coef, int * irz);

  void FORT_SCALUPD(Real * s, Real * sn, 
                    Real * sedgex, Real * sedgey,
                    Real * uhalfx, Real * uhalfy,
                    Real * diff_term, Real * scalforce,
                    Real * r, Real * rhalf,
		    const int& lo_1, const int& lo_2,
                    const int& hi_1, const int& hi_2,
                    Real * dx,Real * dt, 
                    int * is_conserv, int * numscal);

  void FORT_MKVELFLUX(Real * s, Real * sedgex, Real * sedgey,
		      Real * slopex, Real * slopey, 
                      Real * uadv, Real * vadv,
                      Real * utrans, Real * vtrans,
                      Real * rho,  Real * px, Real * py, 
                      Real * lapu, 
    	   	      Real * s_l,  Real * s_r, 
                      Real * s_b,  Real * s_t,
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2,
                      Real * dx, Real * dt, Real * force, Real * visc_coef,
                      int * irz,
                      int * bcx_lo, int * bcx_hi,
                      int * bcy_lo, int * bcy_hi);

  void FORT_MKSCAFLUX(Real * s, Real * sedgex, Real * sedgey,
		      Real * slopex, Real * slopey, 
                      Real * uadv, Real * vadv,
                      Real * utrans, Real * vtrans,
                      Real * u, Real * diff_term, Real * scalforce,
    	   	      Real * s_l,  Real * s_r, 
                      Real * s_b,  Real * s_t,
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2,
                      Real * dx,Real * dt, 
                      int * bcx_lo, int * bcx_hi,
                      int * bcy_lo, int * bcy_hi,
                      int * numqty);

  void FORT_VELUPD(Real * u, Real * v, Real * ustar, Real * vstar, 
                   Real * lapu, Real * gradp, Real * rhohalf, 
                   Real * uadv, Real * vadv, Real * uhalfx, Real * uhalfy,
                   Real * force, Real * dt, 
		   const int& lo_1, const int& lo_2,
                   const int& hi_1, const int& hi_2, Real * dx);

  void  FORT_SETVELBC(Real* u, Real* v, 
		      const int& lo_1, const int& lo_2,
                      const int& hi_1, const int& hi_2, 
	              int * bcx_lo, int * bcx_hi, 
	              int * bcy_lo, int * bcy_hi, 
                      int * irz, Real * visc_coef, Real * dx, Real * time);

  void  FORT_SETSCALBC(Real * scal, 
		       const int& lo_1, const int& lo_2,
                       const int& hi_1, const int& hi_2, 
                       int * bcx_lo, int * bcx_hi,
                       int * bcy_lo, int * bcy_hi, 
                       int * irz, int * which_scal,
                       Real * dx, Real * time);

  void FORT_XINIT(Real * x, Real * xhalf, Real * hx, 
                  const int & lo_1, const int & lo_2,
                  const int & hi_1, const int & hi_2, int * irz);
};
#endif




