import Data.List (isPrefixOf)
import Debian.Relation (BinPkgName(..))
import Distribution.Debian (Flags(..), Config(..), defaultFlags, Executable(..), Server(..), Site(..), tightDependencyFixup)
import Distribution.Debian.DebHelper (DebAtom(..))
import Distribution.Debian.Debianize
import Distribution.Debian.Server (databaseDirectory)
import Distribution.Simple
import qualified Paths_clckwrks as Clckwrks

main :: IO ()
main =
    do jstreePath <- Clckwrks.getDataFileName "jstree"
       json2Path  <- Clckwrks.getDataFileName "json2"
       Distribution.Debian.Debianize.debianize $
         Config { flags = defaultFlags
                      { missingDependencies = ["libghc-clckwrks-theme-clckwrks-doc"]
                      , executablePackages  = map (theSite jstreePath json2Path "clckwrks-dot-com-server") serverNames ++ [backups]
                      , haddock             = True
                      , revision            = "" }
                , modifyAtoms = \ atoms ->
                          map fixRulesHead atoms ++
                          concatMap
                            (\ package -> tightDependencyFixup package
                                             -- For each pair (A, B) make sure that this package requires the
                                             -- same exact version of package B as the version of A currently
                                             -- installed during the build.
                                             [("libghc-clckwrks-theme-clckwrks-dev", "haskell-clckwrks-theme-clckwrks-utils"),
                                              ("libghc-clckwrks-plugin-media-dev", "haskell-clckwrks-plugin-media-utils"),
                                              ("libghc-clckwrks-plugin-bugs-dev", "haskell-clckwrks-plugin-bugs-utils"),
                                              ("libghc-clckwrks-dev", "haskell-clckwrks-utils")])
                              serverNames }
    where
      serverNames = map BinPkgName ["clckwrks-dot-com-production"] -- , "clckwrks-dot-com-staging", "clckwrks-dot-com-development"]
      -- Insert a line just above the debhelper.mk include
      fixRulesHead (DebRulesHead s) = DebRulesHead $ unlines $ concat $
          map (\ line -> if line == "include /usr/share/cdbs/1/rules/debhelper.mk"
                         then ["DEB_SETUP_GHC_CONFIGURE_ARGS = -fbackups", "", line]
                         else [line]) (lines s)
      fixRulesHead x = x

theSite :: FilePath -> FilePath -> String -> BinPkgName -> Executable
theSite jstreePath json2Path name (BinPkgName deb) =
    let this = Executable
          { debName    = deb
          , execName   = name
          , destName   = deb
          , sourceDir  = Nothing
          , destDir    = Nothing
          , execServer =
              Just (Server
                    { hostname =
                          case deb of
                            "clckwrks-dot-com-production" -> hostname
                            _ -> hostname
                    , port = portNum
                    , site =
                        case deb of
                          "clckwrks-dot-com-production" -> Just (Site { domain = hostname, serverAdmin = "logic@seereason.com" })
                          _                             -> Nothing
                    , headerMessage = "Generated by clckwrks-dot-com/Setup.hs"
                    , retry = "60"
                    , serverFlags =
                              [ "--http-port", show portNum
                              , "--hide-port"
                              , "--hostname", hostname
                              , "--top", databaseDirectory this
                              , "--enable-analytics"
                              , "--jquery-path", "/usr/share/javascript/jquery/"
                              , "--jqueryui-path", "/usr/share/javascript/jquery-ui/"
                              , "--jstree-path", jstreePath
                              , "--json2-path",json2Path
                              ]
                    }) }
    in this
    where
      hostname = "clckwrks.com"
      portNum =
          case deb of
            "clckwrks-dot-com-production"  -> 9029
            "clckwrks-dot-com-staging"     -> 9038
            "clckwrks-dot-com-development" -> 9039
            _ -> error $ "Unexpected package name: " ++ name

backups =
    Executable
    { execName   = "clckwrks-dot-com-backups"
    , destName   = "clckwrks-dot-com-backups"
    , debName    = "clckwrks-dot-com-backups"
    , sourceDir  = Nothing
    , destDir    = Just "/etc/cron.hourly"
    , execServer = Nothing }
