#!/bin/sh

#
# See: http://boinc.berkeley.edu/trac/wiki/AndroidBuildApp#
#

# Script to compile various BOINC libraries for Android to be used
# by science applications

COMPILEBOINC="yes"
CONFIGURE="yes"
MAKECLEAN="yes"

export BOINC="../boinc" #BOINC source code
export OPENSSL_DIR=$BOINC/../boinc_depends_android_eclipse/openssl
export CURL_DIR=$BOINC/../boinc_depends_android_eclipse/curl
export PKG_CONFIG_DEBUG_SPEW=1

export ANDROIDTC="/usr/arm-linux-androideabi"
export TCBINARIES="$ANDROIDTC/bin"
export TCINCLUDES="$ANDROIDTC/arm-linux-androideabi"
export TCSYSROOT="$ANDROIDTC/sysroot"
export STDCPPTC="$TCINCLUDES/lib/libstdc++.a"

export CROSS_PREFIX=arm-linux-androideabi
export ac_cv_host=${CROSS_PREFIX}

export PATH="$PATH:$TCBINARIES:$TCINCLUDES/bin"
export CC=${CROSS_PREFIX}-gcc
export CCAS=${CROSS_PREFIX}-gcc
export CXX=${CROSS_PREFIX}-g++
export LD=${CROSS_PREFIX}-ld
export NM=${CROSS_PREFIX}-nm
export AR=${CROSS_PREFIX}-ar
export STRIP=${CROSS_PREFIX}-strip
export RANLIB=${CROSS_PREFIX}-ranlib

export CFLAGS="--sysroot=$TCSYSROOT -DANDROID -DDECLARE_TIMEZONE -Wall -O3 -fomit-frame-pointer -march=armv6 -mtune=cortex-a9"
export CXXFLAGS="--sysroot=$TCSYSROOT -DANDROID -Wall -funroll-loops -fexceptions -O3 -fomit-frame-pointer -march=armv6 -mtune=cortex-a9"
export CCASFLAGS="${CFLAGS}"
export LDFLAGS="-L$TCINCLUDES/lib/armv6 -L$TCSYSROOT/usr/lib -L$TCINCLUDES/lib -llog -lstdc++"
export LIBS="/usr/arm-linux-androideabi/arm-linux-androideabi/lib/libstdc++.a"
export PKG_CONFIG_SYSROOT_DIR=$TCSYSROOT
export PKG_CONFIG_PATH=$CURL_DIR/lib/pkgconfig:$OPENSSL_DIR/lib/pkgconfig

if [ -n "$COMPILEBOINC" ]; then
echo "==================building Libraries from $BOINC=========================="
if [ -n "$MAKECLEAN" ]; then
make clean
fi
if [ -n "$CONFIGURE" ]; then
./_autosetup 
./configure -C --host=${ac_cv_host} --prefix="${ANDROIDTC}/arm-linux-androideabi" --exec-prefix="${ANDROIDTC}/arm-linux-androideabi" --with-boinc-platform="arm-android-linux-gnu" --with-ssl=$TCINCLUDES --disable-graphics --disable-server 
fi
make

echo "=============================BOINC done============================="

fi
