/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#ifndef _NETSTORAGE_H
#define _NETSTORAGE_H

#include <iostream>
#include <vector>
#include <stdio.h>
#include <string.h>
#include <curl/curl.h>
#include <string.h>
#include "Book.h"

using namespace std;

#define NETSTORAGE_BUFFER_MAX 50000

enum NETSTORAGE_ERRORS {
  NETSTORAGE_ERROR_LIBCURL,
  NETSTORAGE_ERROR_MISSING_FIELDS,
  NETSTORAGE_ERROR_SERVER_ERROR
};

class NetStorage {
public:
  NetStorage(string proxy = "");
  ~NetStorage();
  
  /* Receives a list of all books from the server, that match the criterias
   * given in "search" and stores the result in "results".
   */
  int find_book(Book* search, vector<Book*>& results);
  
  /* Defines the base url. */
  void set_baseurl(string url);
  
  /* Defines, which proxy to use. */
  void set_proxy(string proxy);
  
protected:
  /* Fetches the given url and returns it as a string. */
  int get_url(string url, char* buffer);
  
  string baseurl;
  CURL*  curl;
};

#endif /* _NETSTORAGE_H */
