/*
 * Decompiled with CFR 0.152.
 */
package yuku.alkitabconverter.usfx_common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DefaultHandler2;
import org.xml.sax.helpers.DefaultHandler;
import yuku.alkitab.util.Ari;
import yuku.alkitab.yes2.model.PericopeData;
import yuku.alkitabconverter.util.FootnoteDb;
import yuku.alkitabconverter.util.TextDb;
import yuku.alkitabconverter.util.XrefDb;
import yuku.alkitabconverter.yes_common.Yes2Common;
import yuku.alkitabconverter.yet.YetFileOutput;

public class UsfxToYet {
    static final SAXParserFactory factory = SAXParserFactory.newInstance();
    TextDb textDb = new TextDb();
    StringBuilder mystery = new StringBuilder();
    XrefDb xrefDb = new XrefDb();
    FootnoteDb footnoteDb = new FootnoteDb();
    PericopeData pericopeData = new PericopeData();

    public UsfxToYet() {
        this.pericopeData.entries = new ArrayList<PericopeData.Entry>();
    }

    public void u(InputStream[] inputs, int[] books_0, String info_locale, String info_short_name, String info_long_name, String info_description, List<String> book_names, List<String> book_abbrs, OutputStream output_yet) throws IOException {
        for (int i = 0; i < inputs.length; ++i) {
            InputStream input = inputs[i];
            int book_0 = books_0[i];
            System.out.println("input start;");
            try {
                SAXParser parser = factory.newSAXParser();
                XMLReader r = parser.getXMLReader();
                System.out.println("input buffer size (old) = " + r.getProperty("http://apache.org/xml/properties/input-buffer-size"));
                r.setProperty("http://apache.org/xml/properties/input-buffer-size", 0x100000);
                System.out.println("input buffer size (new) = " + r.getProperty("http://apache.org/xml/properties/input-buffer-size"));
                r.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.parse(input, (DefaultHandler)new Handler(book_0));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            System.out.println("input done; now total rec: " + this.textDb.size());
        }
        System.out.println("OUTPUT MYSTERY:");
        System.out.println(this.mystery);
        System.out.println("OUTPUT XREF:");
        this.xrefDb.processEach(XrefDb.defaultShiftTbProcessor);
        this.xrefDb.dump();
        System.out.println("OUTPUT FOOTNOTE:");
        this.footnoteDb.dump();
        this.textDb.normalize();
        this.textDb.removeEmptyVerses();
        this.textDb.dump();
        YetFileOutput yet = new YetFileOutput(output_yet);
        Yes2Common.VersionInfo versionInfo = new Yes2Common.VersionInfo();
        versionInfo.locale = info_locale;
        versionInfo.shortName = info_short_name;
        versionInfo.longName = info_long_name;
        versionInfo.description = info_description;
        versionInfo.setBookNamesAndAbbreviations(book_names, book_abbrs);
        yet.setVersionInfo(versionInfo);
        yet.setTextDb(this.textDb);
        yet.setPericopeData(this.pericopeData);
        yet.setXrefDb(this.xrefDb);
        yet.setFootnoteDb(this.footnoteDb);
        yet.write();
    }

    static List<String> parseParallel(String judul) {
        String[] alamats;
        ArrayList<String> res = new ArrayList<String>();
        if ((judul = judul.trim()).startsWith("(")) {
            judul = judul.substring(1);
        }
        if (judul.endsWith(")")) {
            judul = judul.substring(0, judul.length() - 1);
        }
        String kitab = null;
        String pasal = null;
        for (String alamat : alamats = judul.split("[;,]")) {
            String ayat;
            String pa;
            String[] bagians = (alamat = alamat.trim()).split(" +", 2);
            if (bagians.length == 1) {
                if (kitab == null) {
                    throw new RuntimeException("no existing kitab");
                }
                pa = bagians[0];
            } else {
                kitab = bagians[0];
                pa = bagians[1];
            }
            String[] parts = pa.split(":", 2);
            if (parts.length == 1) {
                if (pasal == null) {
                    throw new RuntimeException("no existing pasal");
                }
                ayat = parts[0];
            } else {
                pasal = parts[0];
                ayat = parts[1];
            }
            res.add(kitab + " " + pasal + ":" + ayat);
        }
        return res;
    }

    public class Handler
    extends DefaultHandler2 {
        private static final int LEVEL_p_r = -2;
        private static final int LEVEL_p_ms = -3;
        private static final int LEVEL_p_mr = -4;
        int book_0 = -1;
        int chapter_1 = 0;
        int verse_1 = 0;
        String[] tree = new String[80];
        int depth = 0;
        Stack<Object> writeTarget = new Stack();
        Object writeTarget_mystery = new Object();
        Object writeTarget_text = new Object();
        Object writeTarget_pericopeTitle = new Object();
        Object writeTarget_xref = new Object();
        Object writeTarget_footnote = new Object();
        List<PericopeData.Entry> pericopeBuffer = new ArrayList<PericopeData.Entry>();
        boolean afterThisMustStartNewPerikop = true;
        int sLevel = 0;
        int textIndent = -1;
        int xref_state = -1;
        int footnote_state = -1;
        StringBuilder charactersBuffer = new StringBuilder();
        private StringBuilder a = new StringBuilder();

        public Handler(int book_0) {
            this.book_0 = book_0;
            this.writeTarget.push(this.writeTarget_mystery);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.flushCharactersBuffer();
            this.tree[this.depth++] = localName;
            System.out.print("(start:) ");
            this.print();
            String alamat = this.address();
            if (alamat.endsWith("/c")) {
                String id = attributes.getValue("id");
                System.out.println("#c:" + id);
                this.chapter_1 = Integer.parseInt(id.trim());
                this.verse_1 = 1;
                return;
            } else if (alamat.endsWith("/v")) {
                String id = attributes.getValue("id");
                System.out.println("#v:" + id);
                try {
                    this.verse_1 = Integer.parseInt(id);
                    return;
                }
                catch (NumberFormatException e) {
                    System.out.println("// number format exception for: " + id);
                    for (int pos = 0; pos < id.length(); ++pos) {
                        if (Character.isDigit(id.charAt(pos))) continue;
                        String s = id.substring(0, pos);
                        this.verse_1 = Integer.parseInt(s);
                        System.out.println("// number format exception simplified to: " + s);
                        return;
                    }
                    return;
                }
            } else if (alamat.endsWith("/f")) {
                this.writeTarget.push(this.writeTarget_footnote);
                this.footnote_state = 0;
                return;
            } else if (alamat.endsWith("/f/fr")) {
                this.footnote_state = 1;
                return;
            } else if (alamat.endsWith("/f/fk")) {
                this.footnote_state = 2;
                return;
            } else if (alamat.endsWith("/f/ft")) {
                this.footnote_state = 3;
                return;
            } else if (alamat.endsWith("/p")) {
                String sfm = attributes.getValue("sfm");
                if (sfm != null) {
                    switch (sfm) {
                        case "r": {
                            this.writeTarget.push(this.writeTarget_pericopeTitle);
                            this.sLevel = -2;
                            return;
                        }
                        case "mt": {
                            this.writeTarget.push(this.writeTarget_mystery);
                            return;
                        }
                        case "ms": {
                            this.writeTarget.push(this.writeTarget_pericopeTitle);
                            this.sLevel = -3;
                            return;
                        }
                        case "mr": {
                            this.writeTarget.push(this.writeTarget_pericopeTitle);
                            this.sLevel = -4;
                            return;
                        }
                        case "mi": {
                            this.writeTarget.push(this.writeTarget_text);
                            this.textIndent = 2;
                            return;
                        }
                        case "pi": {
                            this.writeTarget.push(this.writeTarget_text);
                            this.textIndent = 1;
                            return;
                        }
                        case "pc": {
                            this.writeTarget.push(this.writeTarget_text);
                            this.textIndent = 2;
                            return;
                        }
                        case "m": {
                            this.writeTarget.push(this.writeTarget_text);
                            this.textIndent = 0;
                            return;
                        }
                        default: {
                            throw new RuntimeException("p@sfm ga dikenal: " + sfm);
                        }
                    }
                } else {
                    this.writeTarget.push(this.writeTarget_text);
                    this.textIndent = -2;
                }
                return;
            } else if (alamat.endsWith("/q")) {
                this.writeTarget.push(this.writeTarget_text);
                int level = Integer.parseInt(attributes.getValue("level"));
                if (level < 1 || level > 4) throw new RuntimeException("q level = " + level);
                this.textIndent = level;
                return;
            } else if (alamat.endsWith("/s")) {
                this.writeTarget.push(this.writeTarget_pericopeTitle);
                this.sLevel = Integer.parseInt(attributes.getValue("level"));
                return;
            } else if (alamat.endsWith("/x")) {
                this.writeTarget.push(this.writeTarget_xref);
                this.xref_state = 0;
                return;
            } else if (alamat.endsWith("/x/milestone")) {
                this.xref_state = 1;
                return;
            } else if (alamat.endsWith("/x/xt")) {
                this.xref_state = 2;
                return;
            } else {
                if (!alamat.endsWith("/wj")) return;
                this.writeTarget.push(this.writeTarget_text);
                this.write("@6");
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.flushCharactersBuffer();
            System.out.print("(end:) ");
            this.print();
            String alamat = this.address();
            if (alamat.endsWith("/p")) {
                this.writeTarget.pop();
            } else if (alamat.endsWith("/f")) {
                this.writeTarget.pop();
            } else if (alamat.endsWith("/s")) {
                this.afterThisMustStartNewPerikop = true;
                this.writeTarget.pop();
            } else if (alamat.endsWith("/x")) {
                this.writeTarget.pop();
            } else if (alamat.endsWith("/wj")) {
                this.write("@5");
                this.writeTarget.pop();
            }
            this.tree[--this.depth] = null;
        }

        private void flushCharactersBuffer() {
            if (this.charactersBuffer.length() > 0) {
                this.charactersCompleted(this.charactersBuffer.toString());
                this.charactersBuffer.setLength(0);
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.charactersBuffer.append(ch, start, length);
        }

        void charactersCompleted(String text) {
            System.out.println("#text:" + text);
            if (text.trim().length() == 0 && this.writeTarget.peek() != this.writeTarget_footnote) {
                return;
            }
            this.write(text);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void write(String chars) {
            Object target = this.writeTarget.peek();
            if (target == this.writeTarget_mystery) {
                System.out.println("$tulis ke mystery " + this.book_0 + " " + this.chapter_1 + " " + this.verse_1 + ":" + chars);
                UsfxToYet.this.mystery.append(chars).append('\n');
                return;
            } else if (target == this.writeTarget_text) {
                System.out.println("$tulis ke teks[jenis=" + this.textIndent + "] " + this.book_0 + " " + this.chapter_1 + " " + this.verse_1 + ":" + chars);
                UsfxToYet.this.textDb.append(this.book_0, this.chapter_1, this.verse_1, chars.replace("\n", " ").replaceAll("\\s+", " "), this.textIndent);
                this.textIndent = -1;
                if (this.pericopeBuffer.size() <= 0) return;
                for (PericopeData.Entry pe : this.pericopeBuffer) {
                    pe.block.title = pe.block.title.replace("\n", " ").replace("  ", " ").trim();
                    System.out.println("(commit to perikopData " + this.book_0 + " " + this.chapter_1 + " " + this.verse_1 + ":) " + pe.block.title);
                    pe.ari = Ari.encode(this.book_0, this.chapter_1, this.verse_1);
                    UsfxToYet.this.pericopeData.entries.add(pe);
                }
                this.pericopeBuffer.clear();
                return;
            } else if (target == this.writeTarget_pericopeTitle) {
                String title = chars;
                if (this.sLevel == 0 || this.sLevel == 1 || this.sLevel == -4 || this.sLevel == -3) {
                    if (this.afterThisMustStartNewPerikop || this.pericopeBuffer.size() == 0) {
                        PericopeData.Entry entry = new PericopeData.Entry();
                        entry.ari = 0;
                        entry.block = new PericopeData.Block();
                        entry.block.title = title;
                        this.pericopeBuffer.add(entry);
                        this.afterThisMustStartNewPerikop = false;
                        System.out.println("$tulis ke pericopeBuffer (new entry) (size now: " + this.pericopeBuffer.size() + "): " + title);
                        return;
                    } else {
                        this.pericopeBuffer.get((int)(this.pericopeBuffer.size() - 1)).block.title = this.pericopeBuffer.get((int)(this.pericopeBuffer.size() - 1)).block.title + title;
                        System.out.println("$tulis ke pericopeBuffer (append to existing) (size now: " + this.pericopeBuffer.size() + "): " + title);
                    }
                    return;
                } else if (this.sLevel == -2) {
                    if (this.pericopeBuffer.size() == 0) {
                        throw new RuntimeException("paralel found but no perikop on buffer: " + title);
                    }
                    PericopeData.Entry entry = this.pericopeBuffer.get(this.pericopeBuffer.size() - 1);
                    entry.block.parallels = UsfxToYet.parseParallel(title);
                    return;
                } else {
                    if (this.sLevel != 2) throw new RuntimeException("sLevel = " + this.sLevel + " not understood: " + title);
                    System.out.println("$tulis ke tempat sampah (perikop level 2): " + title);
                }
                return;
            } else if (target == this.writeTarget_xref) {
                System.out.println("$tulis ke xref (state=" + this.xref_state + ") " + this.book_0 + " " + this.chapter_1 + " " + this.verse_1 + ":" + chars);
                int ari = Ari.encode(this.book_0, this.chapter_1, this.verse_1);
                if (this.xref_state == 0) {
                    String content = chars;
                    int xrefIndex = content.replaceFirst("[-+a-zA-Z]", "").replaceAll("\\s", "").length() > 0 ? UsfxToYet.this.xrefDb.addComplete(ari, chars) : UsfxToYet.this.xrefDb.addBegin(ari);
                    UsfxToYet.this.textDb.append(ari, "@<x" + (xrefIndex + 1) + "@>@/", -1);
                    return;
                } else if (this.xref_state == 1) {
                    UsfxToYet.this.xrefDb.appendText(ari, chars);
                    return;
                } else {
                    if (this.xref_state != 2) throw new RuntimeException("xref_state not supported");
                    UsfxToYet.this.xrefDb.appendText(ari, chars);
                }
                return;
            } else {
                if (target != this.writeTarget_footnote) return;
                System.out.println("$tulis ke footnote (state=" + this.footnote_state + ") " + this.book_0 + " " + this.chapter_1 + " " + this.verse_1 + ":" + chars);
                int ari = Ari.encode(this.book_0, this.chapter_1, this.verse_1);
                if (this.footnote_state == 0) {
                    String content = chars.matches("[a-zA-Z+-]\\s.*") ? chars.substring(2) : chars;
                    int footnoteIndex = UsfxToYet.this.footnoteDb.addBegin(ari);
                    if (content.trim().length() != 0) {
                        UsfxToYet.this.footnoteDb.appendText(ari, content.replace("\n", " "));
                    }
                    UsfxToYet.this.textDb.append(ari, "@<f" + (footnoteIndex + 1) + "@>@/", -1);
                    return;
                } else if (this.footnote_state == 2) {
                    UsfxToYet.this.footnoteDb.appendText(ari, "@9" + chars.replace("\n", " ") + "@7");
                    return;
                } else {
                    if (this.footnote_state != 1 && this.footnote_state != 3) throw new RuntimeException("footnote_state not supported");
                    UsfxToYet.this.footnoteDb.appendText(ari, chars.replace("\n", " "));
                }
            }
        }

        void print() {
            for (int i = 0; i < this.depth; ++i) {
                System.out.print('/');
                System.out.print(this.tree[i]);
            }
            System.out.println();
        }

        private String address() {
            this.a.setLength(0);
            for (int i = 0; i < this.depth; ++i) {
                this.a.append('/').append(this.tree[i]);
            }
            return this.a.toString();
        }
    }
}

