# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from azure.core.exceptions import HttpResponseError


class AccessPolicy(Model):
    """An Access policy.

    :param start: the date-time the policy is active
    :type start: str
    :param expiry: the date-time the policy expires
    :type expiry: str
    :param permission: the permissions for the acl policy
    :type permission: str
    """

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str', 'xml': {'name': 'Start'}},
        'expiry': {'key': 'Expiry', 'type': 'str', 'xml': {'name': 'Expiry'}},
        'permission': {'key': 'Permission', 'type': 'str', 'xml': {'name': 'Permission'}},
    }
    _xml_map = {
    }

    def __init__(self, *, start: str=None, expiry: str=None, permission: str=None, **kwargs) -> None:
        super(AccessPolicy, self).__init__(**kwargs)
        self.start = start
        self.expiry = expiry
        self.permission = permission


class AppendPositionAccessConditions(Model):
    """Additional parameters for a set of operations, such as:
    AppendBlob_append_block, AppendBlob_append_block_from_url.

    :param max_size: Optional conditional header. The max length in bytes
     permitted for the append blob. If the Append Block operation would cause
     the blob to exceed that limit or if the blob size is already greater than
     the value specified in this header, the request will fail with
     MaxBlobSizeConditionNotMet error (HTTP status code 412 - Precondition
     Failed).
    :type max_size: long
    :param append_position: Optional conditional header, used only for the
     Append Block operation. A number indicating the byte offset to compare.
     Append Block will succeed only if the append position is equal to this
     number. If it is not, the request will fail with the
     AppendPositionConditionNotMet error (HTTP status code 412 - Precondition
     Failed).
    :type append_position: long
    """

    _attribute_map = {
        'max_size': {'key': '', 'type': 'long', 'xml': {'name': 'max_size'}},
        'append_position': {'key': '', 'type': 'long', 'xml': {'name': 'append_position'}},
    }
    _xml_map = {
    }

    def __init__(self, *, max_size: int=None, append_position: int=None, **kwargs) -> None:
        super(AppendPositionAccessConditions, self).__init__(**kwargs)
        self.max_size = max_size
        self.append_position = append_position


class BlobFlatListSegment(Model):
    """BlobFlatListSegment.

    All required parameters must be populated in order to send to Azure.

    :param blob_items: Required.
    :type blob_items: list[~azure.storage.blob.models.BlobItem]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItem]', 'xml': {'name': 'BlobItems', 'itemsName': 'Blob'}},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(self, *, blob_items, **kwargs) -> None:
        super(BlobFlatListSegment, self).__init__(**kwargs)
        self.blob_items = blob_items


class BlobHierarchyListSegment(Model):
    """BlobHierarchyListSegment.

    All required parameters must be populated in order to send to Azure.

    :param blob_prefixes:
    :type blob_prefixes: list[~azure.storage.blob.models.BlobPrefix]
    :param blob_items: Required.
    :type blob_items: list[~azure.storage.blob.models.BlobItem]
    """

    _validation = {
        'blob_items': {'required': True},
    }

    _attribute_map = {
        'blob_prefixes': {'key': 'BlobPrefixes', 'type': '[BlobPrefix]', 'xml': {'name': 'BlobPrefix', 'itemsName': 'BlobPrefix'}},
        'blob_items': {'key': 'BlobItems', 'type': '[BlobItem]', 'xml': {'name': 'Blob', 'itemsName': 'Blob'}},
    }
    _xml_map = {
        'name': 'Blobs'
    }

    def __init__(self, *, blob_items, blob_prefixes=None, **kwargs) -> None:
        super(BlobHierarchyListSegment, self).__init__(**kwargs)
        self.blob_prefixes = blob_prefixes
        self.blob_items = blob_items


class BlobHTTPHeaders(Model):
    """Additional parameters for a set of operations.

    :param blob_cache_control: Optional. Sets the blob's cache control. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type blob_cache_control: str
    :param blob_content_type: Optional. Sets the blob's content type. If
     specified, this property is stored with the blob and returned with a read
     request.
    :type blob_content_type: str
    :param blob_content_md5: Optional. An MD5 hash of the blob content. Note
     that this hash is not validated, as the hashes for the individual blocks
     were validated when each was uploaded.
    :type blob_content_md5: bytearray
    :param blob_content_encoding: Optional. Sets the blob's content encoding.
     If specified, this property is stored with the blob and returned with a
     read request.
    :type blob_content_encoding: str
    :param blob_content_language: Optional. Set the blob's content language.
     If specified, this property is stored with the blob and returned with a
     read request.
    :type blob_content_language: str
    :param blob_content_disposition: Optional. Sets the blob's
     Content-Disposition header.
    :type blob_content_disposition: str
    """

    _attribute_map = {
        'blob_cache_control': {'key': '', 'type': 'str', 'xml': {'name': 'blob_cache_control'}},
        'blob_content_type': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_type'}},
        'blob_content_md5': {'key': '', 'type': 'bytearray', 'xml': {'name': 'blob_content_md5'}},
        'blob_content_encoding': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_encoding'}},
        'blob_content_language': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_language'}},
        'blob_content_disposition': {'key': '', 'type': 'str', 'xml': {'name': 'blob_content_disposition'}},
    }
    _xml_map = {
    }

    def __init__(self, *, blob_cache_control: str=None, blob_content_type: str=None, blob_content_md5: bytearray=None, blob_content_encoding: str=None, blob_content_language: str=None, blob_content_disposition: str=None, **kwargs) -> None:
        super(BlobHTTPHeaders, self).__init__(**kwargs)
        self.blob_cache_control = blob_cache_control
        self.blob_content_type = blob_content_type
        self.blob_content_md5 = blob_content_md5
        self.blob_content_encoding = blob_content_encoding
        self.blob_content_language = blob_content_language
        self.blob_content_disposition = blob_content_disposition


class BlobItem(Model):
    """An Azure Storage blob.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param deleted: Required.
    :type deleted: bool
    :param snapshot: Required.
    :type snapshot: str
    :param properties: Required.
    :type properties: ~azure.storage.blob.models.BlobProperties
    :param metadata:
    :type metadata: ~azure.storage.blob.models.BlobMetadata
    """

    _validation = {
        'name': {'required': True},
        'deleted': {'required': True},
        'snapshot': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'deleted': {'key': 'Deleted', 'type': 'bool', 'xml': {'name': 'Deleted'}},
        'snapshot': {'key': 'Snapshot', 'type': 'str', 'xml': {'name': 'Snapshot'}},
        'properties': {'key': 'Properties', 'type': 'BlobProperties', 'xml': {'name': 'Properties'}},
        'metadata': {'key': 'Metadata', 'type': 'BlobMetadata', 'xml': {'name': 'Metadata'}},
    }
    _xml_map = {
        'name': 'Blob'
    }

    def __init__(self, *, name: str, deleted: bool, snapshot: str, properties, metadata=None, **kwargs) -> None:
        super(BlobItem, self).__init__(**kwargs)
        self.name = name
        self.deleted = deleted
        self.snapshot = snapshot
        self.properties = properties
        self.metadata = metadata


class BlobMetadata(Model):
    """BlobMetadata.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, str]
    :param encrypted:
    :type encrypted: str
    """

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{str}', 'xml': {'name': 'additional_properties'}},
        'encrypted': {'key': 'Encrypted', 'type': 'str', 'xml': {'name': 'Encrypted', 'attr': True}},
    }
    _xml_map = {
        'name': 'Metadata'
    }

    def __init__(self, *, additional_properties=None, encrypted: str=None, **kwargs) -> None:
        super(BlobMetadata, self).__init__(**kwargs)
        self.additional_properties = additional_properties
        self.encrypted = encrypted


class BlobPrefix(Model):
    """BlobPrefix.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
    }
    _xml_map = {
    }

    def __init__(self, *, name: str, **kwargs) -> None:
        super(BlobPrefix, self).__init__(**kwargs)
        self.name = name


class BlobProperties(Model):
    """Properties of a blob.

    All required parameters must be populated in order to send to Azure.

    :param creation_time:
    :type creation_time: datetime
    :param last_modified: Required.
    :type last_modified: datetime
    :param etag: Required.
    :type etag: str
    :param content_length: Size in bytes
    :type content_length: long
    :param content_type:
    :type content_type: str
    :param content_encoding:
    :type content_encoding: str
    :param content_language:
    :type content_language: str
    :param content_md5:
    :type content_md5: bytearray
    :param content_disposition:
    :type content_disposition: str
    :param cache_control:
    :type cache_control: str
    :param blob_sequence_number:
    :type blob_sequence_number: long
    :param blob_type: Possible values include: 'BlockBlob', 'PageBlob',
     'AppendBlob'
    :type blob_type: str or ~azure.storage.blob.models.BlobType
    :param lease_status: Possible values include: 'locked', 'unlocked'
    :type lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :param lease_state: Possible values include: 'available', 'leased',
     'expired', 'breaking', 'broken'
    :type lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :param lease_duration: Possible values include: 'infinite', 'fixed'
    :type lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :param copy_id:
    :type copy_id: str
    :param copy_status: Possible values include: 'pending', 'success',
     'aborted', 'failed'
    :type copy_status: str or ~azure.storage.blob.models.CopyStatusType
    :param copy_source:
    :type copy_source: str
    :param copy_progress:
    :type copy_progress: str
    :param copy_completion_time:
    :type copy_completion_time: datetime
    :param copy_status_description:
    :type copy_status_description: str
    :param server_encrypted:
    :type server_encrypted: bool
    :param incremental_copy:
    :type incremental_copy: bool
    :param destination_snapshot:
    :type destination_snapshot: str
    :param deleted_time:
    :type deleted_time: datetime
    :param remaining_retention_days:
    :type remaining_retention_days: int
    :param access_tier: Possible values include: 'P4', 'P6', 'P10', 'P15',
     'P20', 'P30', 'P40', 'P50', 'P60', 'P70', 'P80', 'Hot', 'Cool', 'Archive'
    :type access_tier: str or ~azure.storage.blob.models.AccessTier
    :param access_tier_inferred:
    :type access_tier_inferred: bool
    :param archive_status: Possible values include:
     'rehydrate-pending-to-hot', 'rehydrate-pending-to-cool'
    :type archive_status: str or ~azure.storage.blob.models.ArchiveStatus
    :param customer_provided_key_sha256:
    :type customer_provided_key_sha256: str
    :param encryption_scope: The name of the encryption scope under which the
     blob is encrypted.
    :type encryption_scope: str
    :param access_tier_change_time:
    :type access_tier_change_time: datetime
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'Creation-Time', 'type': 'rfc-1123', 'xml': {'name': 'Creation-Time'}},
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123', 'xml': {'name': 'Last-Modified'}},
        'etag': {'key': 'Etag', 'type': 'str', 'xml': {'name': 'Etag'}},
        'content_length': {'key': 'Content-Length', 'type': 'long', 'xml': {'name': 'Content-Length'}},
        'content_type': {'key': 'Content-Type', 'type': 'str', 'xml': {'name': 'Content-Type'}},
        'content_encoding': {'key': 'Content-Encoding', 'type': 'str', 'xml': {'name': 'Content-Encoding'}},
        'content_language': {'key': 'Content-Language', 'type': 'str', 'xml': {'name': 'Content-Language'}},
        'content_md5': {'key': 'Content-MD5', 'type': 'bytearray', 'xml': {'name': 'Content-MD5'}},
        'content_disposition': {'key': 'Content-Disposition', 'type': 'str', 'xml': {'name': 'Content-Disposition'}},
        'cache_control': {'key': 'Cache-Control', 'type': 'str', 'xml': {'name': 'Cache-Control'}},
        'blob_sequence_number': {'key': 'x-ms-blob-sequence-number', 'type': 'long', 'xml': {'name': 'x-ms-blob-sequence-number'}},
        'blob_type': {'key': 'BlobType', 'type': 'BlobType', 'xml': {'name': 'BlobType'}},
        'lease_status': {'key': 'LeaseStatus', 'type': 'LeaseStatusType', 'xml': {'name': 'LeaseStatus'}},
        'lease_state': {'key': 'LeaseState', 'type': 'LeaseStateType', 'xml': {'name': 'LeaseState'}},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'LeaseDurationType', 'xml': {'name': 'LeaseDuration'}},
        'copy_id': {'key': 'CopyId', 'type': 'str', 'xml': {'name': 'CopyId'}},
        'copy_status': {'key': 'CopyStatus', 'type': 'CopyStatusType', 'xml': {'name': 'CopyStatus'}},
        'copy_source': {'key': 'CopySource', 'type': 'str', 'xml': {'name': 'CopySource'}},
        'copy_progress': {'key': 'CopyProgress', 'type': 'str', 'xml': {'name': 'CopyProgress'}},
        'copy_completion_time': {'key': 'CopyCompletionTime', 'type': 'rfc-1123', 'xml': {'name': 'CopyCompletionTime'}},
        'copy_status_description': {'key': 'CopyStatusDescription', 'type': 'str', 'xml': {'name': 'CopyStatusDescription'}},
        'server_encrypted': {'key': 'ServerEncrypted', 'type': 'bool', 'xml': {'name': 'ServerEncrypted'}},
        'incremental_copy': {'key': 'IncrementalCopy', 'type': 'bool', 'xml': {'name': 'IncrementalCopy'}},
        'destination_snapshot': {'key': 'DestinationSnapshot', 'type': 'str', 'xml': {'name': 'DestinationSnapshot'}},
        'deleted_time': {'key': 'DeletedTime', 'type': 'rfc-1123', 'xml': {'name': 'DeletedTime'}},
        'remaining_retention_days': {'key': 'RemainingRetentionDays', 'type': 'int', 'xml': {'name': 'RemainingRetentionDays'}},
        'access_tier': {'key': 'AccessTier', 'type': 'str', 'xml': {'name': 'AccessTier'}},
        'access_tier_inferred': {'key': 'AccessTierInferred', 'type': 'bool', 'xml': {'name': 'AccessTierInferred'}},
        'archive_status': {'key': 'ArchiveStatus', 'type': 'str', 'xml': {'name': 'ArchiveStatus'}},
        'customer_provided_key_sha256': {'key': 'CustomerProvidedKeySha256', 'type': 'str', 'xml': {'name': 'CustomerProvidedKeySha256'}},
        'encryption_scope': {'key': 'EncryptionScope', 'type': 'str', 'xml': {'name': 'EncryptionScope'}},
        'access_tier_change_time': {'key': 'AccessTierChangeTime', 'type': 'rfc-1123', 'xml': {'name': 'AccessTierChangeTime'}},
    }
    _xml_map = {
        'name': 'Properties'
    }

    def __init__(self, *, last_modified, etag: str, creation_time=None, content_length: int=None, content_type: str=None, content_encoding: str=None, content_language: str=None, content_md5: bytearray=None, content_disposition: str=None, cache_control: str=None, blob_sequence_number: int=None, blob_type=None, lease_status=None, lease_state=None, lease_duration=None, copy_id: str=None, copy_status=None, copy_source: str=None, copy_progress: str=None, copy_completion_time=None, copy_status_description: str=None, server_encrypted: bool=None, incremental_copy: bool=None, destination_snapshot: str=None, deleted_time=None, remaining_retention_days: int=None, access_tier=None, access_tier_inferred: bool=None, archive_status=None, customer_provided_key_sha256: str=None, encryption_scope: str=None, access_tier_change_time=None, **kwargs) -> None:
        super(BlobProperties, self).__init__(**kwargs)
        self.creation_time = creation_time
        self.last_modified = last_modified
        self.etag = etag
        self.content_length = content_length
        self.content_type = content_type
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_md5 = content_md5
        self.content_disposition = content_disposition
        self.cache_control = cache_control
        self.blob_sequence_number = blob_sequence_number
        self.blob_type = blob_type
        self.lease_status = lease_status
        self.lease_state = lease_state
        self.lease_duration = lease_duration
        self.copy_id = copy_id
        self.copy_status = copy_status
        self.copy_source = copy_source
        self.copy_progress = copy_progress
        self.copy_completion_time = copy_completion_time
        self.copy_status_description = copy_status_description
        self.server_encrypted = server_encrypted
        self.incremental_copy = incremental_copy
        self.destination_snapshot = destination_snapshot
        self.deleted_time = deleted_time
        self.remaining_retention_days = remaining_retention_days
        self.access_tier = access_tier
        self.access_tier_inferred = access_tier_inferred
        self.archive_status = archive_status
        self.customer_provided_key_sha256 = customer_provided_key_sha256
        self.encryption_scope = encryption_scope
        self.access_tier_change_time = access_tier_change_time


class Block(Model):
    """Represents a single block in a block blob.  It describes the block's ID and
    size.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The base64 encoded block ID.
    :type name: str
    :param size: Required. The block size in bytes.
    :type size: int
    """

    _validation = {
        'name': {'required': True},
        'size': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'size': {'key': 'Size', 'type': 'int', 'xml': {'name': 'Size'}},
    }
    _xml_map = {
    }

    def __init__(self, *, name: str, size: int, **kwargs) -> None:
        super(Block, self).__init__(**kwargs)
        self.name = name
        self.size = size


class BlockList(Model):
    """BlockList.

    :param committed_blocks:
    :type committed_blocks: list[~azure.storage.blob.models.Block]
    :param uncommitted_blocks:
    :type uncommitted_blocks: list[~azure.storage.blob.models.Block]
    """

    _attribute_map = {
        'committed_blocks': {'key': 'CommittedBlocks', 'type': '[Block]', 'xml': {'name': 'CommittedBlocks', 'itemsName': 'Block', 'wrapped': True}},
        'uncommitted_blocks': {'key': 'UncommittedBlocks', 'type': '[Block]', 'xml': {'name': 'UncommittedBlocks', 'itemsName': 'Block', 'wrapped': True}},
    }
    _xml_map = {
    }

    def __init__(self, *, committed_blocks=None, uncommitted_blocks=None, **kwargs) -> None:
        super(BlockList, self).__init__(**kwargs)
        self.committed_blocks = committed_blocks
        self.uncommitted_blocks = uncommitted_blocks


class BlockLookupList(Model):
    """BlockLookupList.

    :param committed:
    :type committed: list[str]
    :param uncommitted:
    :type uncommitted: list[str]
    :param latest:
    :type latest: list[str]
    """

    _attribute_map = {
        'committed': {'key': 'Committed', 'type': '[str]', 'xml': {'name': 'Committed', 'itemsName': 'Committed'}},
        'uncommitted': {'key': 'Uncommitted', 'type': '[str]', 'xml': {'name': 'Uncommitted', 'itemsName': 'Uncommitted'}},
        'latest': {'key': 'Latest', 'type': '[str]', 'xml': {'name': 'Latest', 'itemsName': 'Latest'}},
    }
    _xml_map = {
        'name': 'BlockList'
    }

    def __init__(self, *, committed=None, uncommitted=None, latest=None, **kwargs) -> None:
        super(BlockLookupList, self).__init__(**kwargs)
        self.committed = committed
        self.uncommitted = uncommitted
        self.latest = latest


class ClearRange(Model):
    """ClearRange.

    All required parameters must be populated in order to send to Azure.

    :param start: Required.
    :type start: long
    :param end: Required.
    :type end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'ClearRange'
    }

    def __init__(self, *, start: int, end: int, **kwargs) -> None:
        super(ClearRange, self).__init__(**kwargs)
        self.start = start
        self.end = end


class ContainerCpkScopeInfo(Model):
    """Additional parameters for create operation.

    :param default_encryption_scope: Optional.  Version 2019-07-07 and later.
     Specifies the default encryption scope to set on the container and use for
     all future writes.
    :type default_encryption_scope: str
    :param prevent_encryption_scope_override: Optional.  Version 2019-07-07
     and newer.  If true, prevents any request from specifying a different
     encryption scope than the scope set on the container.
    :type prevent_encryption_scope_override: bool
    """

    _attribute_map = {
        'default_encryption_scope': {'key': '', 'type': 'str', 'xml': {'name': 'default_encryption_scope'}},
        'prevent_encryption_scope_override': {'key': '', 'type': 'bool', 'xml': {'name': 'prevent_encryption_scope_override'}},
    }
    _xml_map = {
    }

    def __init__(self, *, default_encryption_scope: str=None, prevent_encryption_scope_override: bool=None, **kwargs) -> None:
        super(ContainerCpkScopeInfo, self).__init__(**kwargs)
        self.default_encryption_scope = default_encryption_scope
        self.prevent_encryption_scope_override = prevent_encryption_scope_override


class ContainerItem(Model):
    """An Azure Storage container.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param properties: Required.
    :type properties: ~azure.storage.blob.models.ContainerProperties
    :param metadata:
    :type metadata: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str', 'xml': {'name': 'Name'}},
        'properties': {'key': 'Properties', 'type': 'ContainerProperties', 'xml': {'name': 'Properties'}},
        'metadata': {'key': 'Metadata', 'type': '{str}', 'xml': {'name': 'Metadata'}},
    }
    _xml_map = {
        'name': 'Container'
    }

    def __init__(self, *, name: str, properties, metadata=None, **kwargs) -> None:
        super(ContainerItem, self).__init__(**kwargs)
        self.name = name
        self.properties = properties
        self.metadata = metadata


class ContainerProperties(Model):
    """Properties of a container.

    All required parameters must be populated in order to send to Azure.

    :param last_modified: Required.
    :type last_modified: datetime
    :param etag: Required.
    :type etag: str
    :param lease_status: Possible values include: 'locked', 'unlocked'
    :type lease_status: str or ~azure.storage.blob.models.LeaseStatusType
    :param lease_state: Possible values include: 'available', 'leased',
     'expired', 'breaking', 'broken'
    :type lease_state: str or ~azure.storage.blob.models.LeaseStateType
    :param lease_duration: Possible values include: 'infinite', 'fixed'
    :type lease_duration: str or ~azure.storage.blob.models.LeaseDurationType
    :param public_access: Possible values include: 'container', 'blob'
    :type public_access: str or ~azure.storage.blob.models.PublicAccessType
    :param has_immutability_policy:
    :type has_immutability_policy: bool
    :param has_legal_hold:
    :type has_legal_hold: bool
    :param default_encryption_scope:
    :type default_encryption_scope: str
    :param prevent_encryption_scope_override:
    :type prevent_encryption_scope_override: bool
    """

    _validation = {
        'last_modified': {'required': True},
        'etag': {'required': True},
    }

    _attribute_map = {
        'last_modified': {'key': 'Last-Modified', 'type': 'rfc-1123', 'xml': {'name': 'Last-Modified'}},
        'etag': {'key': 'Etag', 'type': 'str', 'xml': {'name': 'Etag'}},
        'lease_status': {'key': 'LeaseStatus', 'type': 'LeaseStatusType', 'xml': {'name': 'LeaseStatus'}},
        'lease_state': {'key': 'LeaseState', 'type': 'LeaseStateType', 'xml': {'name': 'LeaseState'}},
        'lease_duration': {'key': 'LeaseDuration', 'type': 'LeaseDurationType', 'xml': {'name': 'LeaseDuration'}},
        'public_access': {'key': 'PublicAccess', 'type': 'str', 'xml': {'name': 'PublicAccess'}},
        'has_immutability_policy': {'key': 'HasImmutabilityPolicy', 'type': 'bool', 'xml': {'name': 'HasImmutabilityPolicy'}},
        'has_legal_hold': {'key': 'HasLegalHold', 'type': 'bool', 'xml': {'name': 'HasLegalHold'}},
        'default_encryption_scope': {'key': 'DefaultEncryptionScope', 'type': 'str', 'xml': {'name': 'DefaultEncryptionScope'}},
        'prevent_encryption_scope_override': {'key': 'DenyEncryptionScopeOverride', 'type': 'bool', 'xml': {'name': 'DenyEncryptionScopeOverride'}},
    }
    _xml_map = {
    }

    def __init__(self, *, last_modified, etag: str, lease_status=None, lease_state=None, lease_duration=None, public_access=None, has_immutability_policy: bool=None, has_legal_hold: bool=None, default_encryption_scope: str=None, prevent_encryption_scope_override: bool=None, **kwargs) -> None:
        super(ContainerProperties, self).__init__(**kwargs)
        self.last_modified = last_modified
        self.etag = etag
        self.lease_status = lease_status
        self.lease_state = lease_state
        self.lease_duration = lease_duration
        self.public_access = public_access
        self.has_immutability_policy = has_immutability_policy
        self.has_legal_hold = has_legal_hold
        self.default_encryption_scope = default_encryption_scope
        self.prevent_encryption_scope_override = prevent_encryption_scope_override


class CorsRule(Model):
    """CORS is an HTTP feature that enables a web application running under one
    domain to access resources in another domain. Web browsers implement a
    security restriction known as same-origin policy that prevents a web page
    from calling APIs in a different domain; CORS provides a secure way to
    allow one domain (the origin domain) to call APIs in another domain.

    All required parameters must be populated in order to send to Azure.

    :param allowed_origins: Required. The origin domains that are permitted to
     make a request against the storage service via CORS. The origin domain is
     the domain from which the request originates. Note that the origin must be
     an exact case-sensitive match with the origin that the user age sends to
     the service. You can also use the wildcard character '*' to allow all
     origin domains to make requests via CORS.
    :type allowed_origins: str
    :param allowed_methods: Required. The methods (HTTP request verbs) that
     the origin domain may use for a CORS request. (comma separated)
    :type allowed_methods: str
    :param allowed_headers: Required. the request headers that the origin
     domain may specify on the CORS request.
    :type allowed_headers: str
    :param exposed_headers: Required. The response headers that may be sent in
     the response to the CORS request and exposed by the browser to the request
     issuer
    :type exposed_headers: str
    :param max_age_in_seconds: Required. The maximum amount time that a
     browser should cache the preflight OPTIONS request.
    :type max_age_in_seconds: int
    """

    _validation = {
        'allowed_origins': {'required': True},
        'allowed_methods': {'required': True},
        'allowed_headers': {'required': True},
        'exposed_headers': {'required': True},
        'max_age_in_seconds': {'required': True, 'minimum': 0},
    }

    _attribute_map = {
        'allowed_origins': {'key': 'AllowedOrigins', 'type': 'str', 'xml': {'name': 'AllowedOrigins'}},
        'allowed_methods': {'key': 'AllowedMethods', 'type': 'str', 'xml': {'name': 'AllowedMethods'}},
        'allowed_headers': {'key': 'AllowedHeaders', 'type': 'str', 'xml': {'name': 'AllowedHeaders'}},
        'exposed_headers': {'key': 'ExposedHeaders', 'type': 'str', 'xml': {'name': 'ExposedHeaders'}},
        'max_age_in_seconds': {'key': 'MaxAgeInSeconds', 'type': 'int', 'xml': {'name': 'MaxAgeInSeconds'}},
    }
    _xml_map = {
    }

    def __init__(self, *, allowed_origins: str, allowed_methods: str, allowed_headers: str, exposed_headers: str, max_age_in_seconds: int, **kwargs) -> None:
        super(CorsRule, self).__init__(**kwargs)
        self.allowed_origins = allowed_origins
        self.allowed_methods = allowed_methods
        self.allowed_headers = allowed_headers
        self.exposed_headers = exposed_headers
        self.max_age_in_seconds = max_age_in_seconds


class CpkInfo(Model):
    """Additional parameters for a set of operations.

    :param encryption_key: Optional. Specifies the encryption key to use to
     encrypt the data provided in the request. If not specified, encryption is
     performed with the root account encryption key.  For more information, see
     Encryption at Rest for Azure Storage Services.
    :type encryption_key: str
    :param encryption_key_sha256: The SHA-256 hash of the provided encryption
     key. Must be provided if the x-ms-encryption-key header is provided.
    :type encryption_key_sha256: str
    :param encryption_algorithm: The algorithm used to produce the encryption
     key hash. Currently, the only accepted value is "AES256". Must be provided
     if the x-ms-encryption-key header is provided. Possible values include:
     'AES256'
    :type encryption_algorithm: str or
     ~azure.storage.blob.models.EncryptionAlgorithmType
    """

    _attribute_map = {
        'encryption_key': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_key'}},
        'encryption_key_sha256': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_key_sha256'}},
        'encryption_algorithm': {'key': '', 'type': 'EncryptionAlgorithmType', 'xml': {'name': 'encryption_algorithm'}},
    }
    _xml_map = {
    }

    def __init__(self, *, encryption_key: str=None, encryption_key_sha256: str=None, encryption_algorithm=None, **kwargs) -> None:
        super(CpkInfo, self).__init__(**kwargs)
        self.encryption_key = encryption_key
        self.encryption_key_sha256 = encryption_key_sha256
        self.encryption_algorithm = encryption_algorithm


class CpkScopeInfo(Model):
    """Additional parameters for a set of operations.

    :param encryption_scope: Optional. Version 2019-07-07 and later.
     Specifies the name of the encryption scope to use to encrypt the data
     provided in the request. If not specified, encryption is performed with
     the default account encryption scope.  For more information, see
     Encryption at Rest for Azure Storage Services.
    :type encryption_scope: str
    """

    _attribute_map = {
        'encryption_scope': {'key': '', 'type': 'str', 'xml': {'name': 'encryption_scope'}},
    }
    _xml_map = {
    }

    def __init__(self, *, encryption_scope: str=None, **kwargs) -> None:
        super(CpkScopeInfo, self).__init__(**kwargs)
        self.encryption_scope = encryption_scope


class DataLakeStorageError(Model):
    """DataLakeStorageError.

    :param error: The service error response object.
    :type error: ~azure.storage.blob.models.DataLakeStorageErrorError
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'DataLakeStorageErrorError', 'xml': {'name': 'error'}},
    }
    _xml_map = {
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(DataLakeStorageError, self).__init__(**kwargs)
        self.error = error


class DataLakeStorageErrorException(HttpResponseError):
    """Server responsed with exception of type: 'DataLakeStorageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'DataLakeStorageError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(DataLakeStorageErrorException, self).__init__(response=response)


class DataLakeStorageErrorError(Model):
    """The service error response object.

    :param code: The service error code.
    :type code: str
    :param message: The service error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'Code', 'type': 'str', 'xml': {'name': 'Code'}},
        'message': {'key': 'Message', 'type': 'str', 'xml': {'name': 'Message'}},
    }
    _xml_map = {
    }

    def __init__(self, *, code: str=None, message: str=None, **kwargs) -> None:
        super(DataLakeStorageErrorError, self).__init__(**kwargs)
        self.code = code
        self.message = message


class DirectoryHttpHeaders(Model):
    """Additional parameters for a set of operations, such as: Directory_create,
    Directory_rename, Blob_rename.

    :param cache_control: Cache control for given resource
    :type cache_control: str
    :param content_type: Content type for given resource
    :type content_type: str
    :param content_encoding: Content encoding for given resource
    :type content_encoding: str
    :param content_language: Content language for given resource
    :type content_language: str
    :param content_disposition: Content disposition for given resource
    :type content_disposition: str
    """

    _attribute_map = {
        'cache_control': {'key': '', 'type': 'str', 'xml': {'name': 'cache_control'}},
        'content_type': {'key': '', 'type': 'str', 'xml': {'name': 'content_type'}},
        'content_encoding': {'key': '', 'type': 'str', 'xml': {'name': 'content_encoding'}},
        'content_language': {'key': '', 'type': 'str', 'xml': {'name': 'content_language'}},
        'content_disposition': {'key': '', 'type': 'str', 'xml': {'name': 'content_disposition'}},
    }
    _xml_map = {
    }

    def __init__(self, *, cache_control: str=None, content_type: str=None, content_encoding: str=None, content_language: str=None, content_disposition: str=None, **kwargs) -> None:
        super(DirectoryHttpHeaders, self).__init__(**kwargs)
        self.cache_control = cache_control
        self.content_type = content_type
        self.content_encoding = content_encoding
        self.content_language = content_language
        self.content_disposition = content_disposition


class GeoReplication(Model):
    """Geo-Replication information for the Secondary Storage Service.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of the secondary location. Possible
     values include: 'live', 'bootstrap', 'unavailable'
    :type status: str or ~azure.storage.blob.models.GeoReplicationStatusType
    :param last_sync_time: Required. A GMT date/time value, to the second. All
     primary writes preceding this value are guaranteed to be available for
     read operations at the secondary. Primary writes after this point in time
     may or may not be available for reads.
    :type last_sync_time: datetime
    """

    _validation = {
        'status': {'required': True},
        'last_sync_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'Status', 'type': 'str', 'xml': {'name': 'Status'}},
        'last_sync_time': {'key': 'LastSyncTime', 'type': 'rfc-1123', 'xml': {'name': 'LastSyncTime'}},
    }
    _xml_map = {
    }

    def __init__(self, *, status, last_sync_time, **kwargs) -> None:
        super(GeoReplication, self).__init__(**kwargs)
        self.status = status
        self.last_sync_time = last_sync_time


class KeyInfo(Model):
    """Key information.

    All required parameters must be populated in order to send to Azure.

    :param start: Required. The date-time the key is active in ISO 8601 UTC
     time
    :type start: str
    :param expiry: Required. The date-time the key expires in ISO 8601 UTC
     time
    :type expiry: str
    """

    _validation = {
        'start': {'required': True},
        'expiry': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'str', 'xml': {'name': 'Start'}},
        'expiry': {'key': 'Expiry', 'type': 'str', 'xml': {'name': 'Expiry'}},
    }
    _xml_map = {
    }

    def __init__(self, *, start: str, expiry: str, **kwargs) -> None:
        super(KeyInfo, self).__init__(**kwargs)
        self.start = start
        self.expiry = expiry


class LeaseAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param lease_id: If specified, the operation only succeeds if the
     resource's lease is active and matches this ID.
    :type lease_id: str
    """

    _attribute_map = {
        'lease_id': {'key': '', 'type': 'str', 'xml': {'name': 'lease_id'}},
    }
    _xml_map = {
    }

    def __init__(self, *, lease_id: str=None, **kwargs) -> None:
        super(LeaseAccessConditions, self).__init__(**kwargs)
        self.lease_id = lease_id


class ListBlobsFlatSegmentResponse(Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param container_name: Required.
    :type container_name: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param segment: Required.
    :type segment: ~azure.storage.blob.models.BlobFlatListSegment
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'name': 'ContainerName', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'segment': {'key': 'Segment', 'type': 'BlobFlatListSegment', 'xml': {'name': 'Segment'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, *, service_endpoint: str, container_name: str, segment, prefix: str=None, marker: str=None, max_results: int=None, next_marker: str=None, **kwargs) -> None:
        super(ListBlobsFlatSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = service_endpoint
        self.container_name = container_name
        self.prefix = prefix
        self.marker = marker
        self.max_results = max_results
        self.segment = segment
        self.next_marker = next_marker


class ListBlobsHierarchySegmentResponse(Model):
    """An enumeration of blobs.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param container_name: Required.
    :type container_name: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param delimiter:
    :type delimiter: str
    :param segment: Required.
    :type segment: ~azure.storage.blob.models.BlobHierarchyListSegment
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_name': {'required': True},
        'segment': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'container_name': {'key': 'ContainerName', 'type': 'str', 'xml': {'name': 'ContainerName', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'delimiter': {'key': 'Delimiter', 'type': 'str', 'xml': {'name': 'Delimiter'}},
        'segment': {'key': 'Segment', 'type': 'BlobHierarchyListSegment', 'xml': {'name': 'Segment'}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, *, service_endpoint: str, container_name: str, segment, prefix: str=None, marker: str=None, max_results: int=None, delimiter: str=None, next_marker: str=None, **kwargs) -> None:
        super(ListBlobsHierarchySegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = service_endpoint
        self.container_name = container_name
        self.prefix = prefix
        self.marker = marker
        self.max_results = max_results
        self.delimiter = delimiter
        self.segment = segment
        self.next_marker = next_marker


class ListContainersSegmentResponse(Model):
    """An enumeration of containers.

    All required parameters must be populated in order to send to Azure.

    :param service_endpoint: Required.
    :type service_endpoint: str
    :param prefix:
    :type prefix: str
    :param marker:
    :type marker: str
    :param max_results:
    :type max_results: int
    :param container_items: Required.
    :type container_items: list[~azure.storage.blob.models.ContainerItem]
    :param next_marker:
    :type next_marker: str
    """

    _validation = {
        'service_endpoint': {'required': True},
        'container_items': {'required': True},
    }

    _attribute_map = {
        'service_endpoint': {'key': 'ServiceEndpoint', 'type': 'str', 'xml': {'name': 'ServiceEndpoint', 'attr': True}},
        'prefix': {'key': 'Prefix', 'type': 'str', 'xml': {'name': 'Prefix'}},
        'marker': {'key': 'Marker', 'type': 'str', 'xml': {'name': 'Marker'}},
        'max_results': {'key': 'MaxResults', 'type': 'int', 'xml': {'name': 'MaxResults'}},
        'container_items': {'key': 'ContainerItems', 'type': '[ContainerItem]', 'xml': {'name': 'Containers', 'itemsName': 'Containers', 'wrapped': True}},
        'next_marker': {'key': 'NextMarker', 'type': 'str', 'xml': {'name': 'NextMarker'}},
    }
    _xml_map = {
        'name': 'EnumerationResults'
    }

    def __init__(self, *, service_endpoint: str, container_items, prefix: str=None, marker: str=None, max_results: int=None, next_marker: str=None, **kwargs) -> None:
        super(ListContainersSegmentResponse, self).__init__(**kwargs)
        self.service_endpoint = service_endpoint
        self.prefix = prefix
        self.marker = marker
        self.max_results = max_results
        self.container_items = container_items
        self.next_marker = next_marker


class Logging(Model):
    """Azure Analytics Logging settings.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of Storage Analytics to configure.
    :type version: str
    :param delete: Required. Indicates whether all delete requests should be
     logged.
    :type delete: bool
    :param read: Required. Indicates whether all read requests should be
     logged.
    :type read: bool
    :param write: Required. Indicates whether all write requests should be
     logged.
    :type write: bool
    :param retention_policy: Required.
    :type retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'version': {'required': True},
        'delete': {'required': True},
        'read': {'required': True},
        'write': {'required': True},
        'retention_policy': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str', 'xml': {'name': 'Version'}},
        'delete': {'key': 'Delete', 'type': 'bool', 'xml': {'name': 'Delete'}},
        'read': {'key': 'Read', 'type': 'bool', 'xml': {'name': 'Read'}},
        'write': {'key': 'Write', 'type': 'bool', 'xml': {'name': 'Write'}},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'RetentionPolicy'}},
    }
    _xml_map = {
    }

    def __init__(self, *, version: str, delete: bool, read: bool, write: bool, retention_policy, **kwargs) -> None:
        super(Logging, self).__init__(**kwargs)
        self.version = version
        self.delete = delete
        self.read = read
        self.write = write
        self.retention_policy = retention_policy


class Metrics(Model):
    """a summary of request statistics grouped by API in hour or minute aggregates
    for blobs.

    All required parameters must be populated in order to send to Azure.

    :param version: The version of Storage Analytics to configure.
    :type version: str
    :param enabled: Required. Indicates whether metrics are enabled for the
     Blob service.
    :type enabled: bool
    :param include_apis: Indicates whether metrics should generate summary
     statistics for called API operations.
    :type include_apis: bool
    :param retention_policy:
    :type retention_policy: ~azure.storage.blob.models.RetentionPolicy
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'Version', 'type': 'str', 'xml': {'name': 'Version'}},
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'include_apis': {'key': 'IncludeAPIs', 'type': 'bool', 'xml': {'name': 'IncludeAPIs'}},
        'retention_policy': {'key': 'RetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'RetentionPolicy'}},
    }
    _xml_map = {
    }

    def __init__(self, *, enabled: bool, version: str=None, include_apis: bool=None, retention_policy=None, **kwargs) -> None:
        super(Metrics, self).__init__(**kwargs)
        self.version = version
        self.enabled = enabled
        self.include_apis = include_apis
        self.retention_policy = retention_policy


class ModifiedAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param if_modified_since: Specify this header value to operate only on a
     blob if it has been modified since the specified date/time.
    :type if_modified_since: datetime
    :param if_unmodified_since: Specify this header value to operate only on a
     blob if it has not been modified since the specified date/time.
    :type if_unmodified_since: datetime
    :param if_match: Specify an ETag value to operate only on blobs with a
     matching value.
    :type if_match: str
    :param if_none_match: Specify an ETag value to operate only on blobs
     without a matching value.
    :type if_none_match: str
    """

    _attribute_map = {
        'if_modified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'if_modified_since'}},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'if_unmodified_since'}},
        'if_match': {'key': '', 'type': 'str', 'xml': {'name': 'if_match'}},
        'if_none_match': {'key': '', 'type': 'str', 'xml': {'name': 'if_none_match'}},
    }
    _xml_map = {
    }

    def __init__(self, *, if_modified_since=None, if_unmodified_since=None, if_match: str=None, if_none_match: str=None, **kwargs) -> None:
        super(ModifiedAccessConditions, self).__init__(**kwargs)
        self.if_modified_since = if_modified_since
        self.if_unmodified_since = if_unmodified_since
        self.if_match = if_match
        self.if_none_match = if_none_match


class PageList(Model):
    """the list of pages.

    :param page_range:
    :type page_range: list[~azure.storage.blob.models.PageRange]
    :param clear_range:
    :type clear_range: list[~azure.storage.blob.models.ClearRange]
    """

    _attribute_map = {
        'page_range': {'key': 'PageRange', 'type': '[PageRange]', 'xml': {'name': 'PageRange', 'itemsName': 'PageRange'}},
        'clear_range': {'key': 'ClearRange', 'type': '[ClearRange]', 'xml': {'name': 'ClearRange', 'itemsName': 'ClearRange'}},
    }
    _xml_map = {
    }

    def __init__(self, *, page_range=None, clear_range=None, **kwargs) -> None:
        super(PageList, self).__init__(**kwargs)
        self.page_range = page_range
        self.clear_range = clear_range


class PageRange(Model):
    """PageRange.

    All required parameters must be populated in order to send to Azure.

    :param start: Required.
    :type start: long
    :param end: Required.
    :type end: long
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'Start', 'type': 'long', 'xml': {'name': 'Start'}},
        'end': {'key': 'End', 'type': 'long', 'xml': {'name': 'End'}},
    }
    _xml_map = {
        'name': 'PageRange'
    }

    def __init__(self, *, start: int, end: int, **kwargs) -> None:
        super(PageRange, self).__init__(**kwargs)
        self.start = start
        self.end = end


class RetentionPolicy(Model):
    """the retention policy which determines how long the associated data should
    persist.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Indicates whether a retention policy is enabled
     for the storage service
    :type enabled: bool
    :param days: Indicates the number of days that metrics or logging or
     soft-deleted data should be retained. All data older than this value will
     be deleted
    :type days: int
    """

    _validation = {
        'enabled': {'required': True},
        'days': {'minimum': 1},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'days': {'key': 'Days', 'type': 'int', 'xml': {'name': 'Days'}},
    }
    _xml_map = {
    }

    def __init__(self, *, enabled: bool, days: int=None, **kwargs) -> None:
        super(RetentionPolicy, self).__init__(**kwargs)
        self.enabled = enabled
        self.days = days


class SequenceNumberAccessConditions(Model):
    """Additional parameters for a set of operations, such as:
    PageBlob_upload_pages, PageBlob_clear_pages,
    PageBlob_upload_pages_from_url.

    :param if_sequence_number_less_than_or_equal_to: Specify this header value
     to operate only on a blob if it has a sequence number less than or equal
     to the specified.
    :type if_sequence_number_less_than_or_equal_to: long
    :param if_sequence_number_less_than: Specify this header value to operate
     only on a blob if it has a sequence number less than the specified.
    :type if_sequence_number_less_than: long
    :param if_sequence_number_equal_to: Specify this header value to operate
     only on a blob if it has the specified sequence number.
    :type if_sequence_number_equal_to: long
    """

    _attribute_map = {
        'if_sequence_number_less_than_or_equal_to': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_less_than_or_equal_to'}},
        'if_sequence_number_less_than': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_less_than'}},
        'if_sequence_number_equal_to': {'key': '', 'type': 'long', 'xml': {'name': 'if_sequence_number_equal_to'}},
    }
    _xml_map = {
    }

    def __init__(self, *, if_sequence_number_less_than_or_equal_to: int=None, if_sequence_number_less_than: int=None, if_sequence_number_equal_to: int=None, **kwargs) -> None:
        super(SequenceNumberAccessConditions, self).__init__(**kwargs)
        self.if_sequence_number_less_than_or_equal_to = if_sequence_number_less_than_or_equal_to
        self.if_sequence_number_less_than = if_sequence_number_less_than
        self.if_sequence_number_equal_to = if_sequence_number_equal_to


class SignedIdentifier(Model):
    """signed identifier.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. a unique id
    :type id: str
    :param access_policy:
    :type access_policy: ~azure.storage.blob.models.AccessPolicy
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str', 'xml': {'name': 'Id'}},
        'access_policy': {'key': 'AccessPolicy', 'type': 'AccessPolicy', 'xml': {'name': 'AccessPolicy'}},
    }
    _xml_map = {
        'name': 'SignedIdentifier'
    }

    def __init__(self, *, id: str, access_policy=None, **kwargs) -> None:
        super(SignedIdentifier, self).__init__(**kwargs)
        self.id = id
        self.access_policy = access_policy


class SourceModifiedAccessConditions(Model):
    """Additional parameters for a set of operations.

    :param source_if_modified_since: Specify this header value to operate only
     on a blob if it has been modified since the specified date/time.
    :type source_if_modified_since: datetime
    :param source_if_unmodified_since: Specify this header value to operate
     only on a blob if it has not been modified since the specified date/time.
    :type source_if_unmodified_since: datetime
    :param source_if_match: Specify an ETag value to operate only on blobs
     with a matching value.
    :type source_if_match: str
    :param source_if_none_match: Specify an ETag value to operate only on
     blobs without a matching value.
    :type source_if_none_match: str
    """

    _attribute_map = {
        'source_if_modified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'source_if_modified_since'}},
        'source_if_unmodified_since': {'key': '', 'type': 'rfc-1123', 'xml': {'name': 'source_if_unmodified_since'}},
        'source_if_match': {'key': '', 'type': 'str', 'xml': {'name': 'source_if_match'}},
        'source_if_none_match': {'key': '', 'type': 'str', 'xml': {'name': 'source_if_none_match'}},
    }
    _xml_map = {
    }

    def __init__(self, *, source_if_modified_since=None, source_if_unmodified_since=None, source_if_match: str=None, source_if_none_match: str=None, **kwargs) -> None:
        super(SourceModifiedAccessConditions, self).__init__(**kwargs)
        self.source_if_modified_since = source_if_modified_since
        self.source_if_unmodified_since = source_if_unmodified_since
        self.source_if_match = source_if_match
        self.source_if_none_match = source_if_none_match


class StaticWebsite(Model):
    """The properties that enable an account to host a static website.

    All required parameters must be populated in order to send to Azure.

    :param enabled: Required. Indicates whether this account is hosting a
     static website
    :type enabled: bool
    :param index_document: The default name of the index page under each
     directory
    :type index_document: str
    :param error_document404_path: The absolute path of the custom 404 page
    :type error_document404_path: str
    """

    _validation = {
        'enabled': {'required': True},
    }

    _attribute_map = {
        'enabled': {'key': 'Enabled', 'type': 'bool', 'xml': {'name': 'Enabled'}},
        'index_document': {'key': 'IndexDocument', 'type': 'str', 'xml': {'name': 'IndexDocument'}},
        'error_document404_path': {'key': 'ErrorDocument404Path', 'type': 'str', 'xml': {'name': 'ErrorDocument404Path'}},
    }
    _xml_map = {
    }

    def __init__(self, *, enabled: bool, index_document: str=None, error_document404_path: str=None, **kwargs) -> None:
        super(StaticWebsite, self).__init__(**kwargs)
        self.enabled = enabled
        self.index_document = index_document
        self.error_document404_path = error_document404_path


class StorageError(Model):
    """StorageError.

    :param message:
    :type message: str
    """

    _attribute_map = {
        'message': {'key': 'Message', 'type': 'str', 'xml': {'name': 'Message'}},
    }
    _xml_map = {
    }

    def __init__(self, *, message: str=None, **kwargs) -> None:
        super(StorageError, self).__init__(**kwargs)
        self.message = message


class StorageErrorException(HttpResponseError):
    """Server responsed with exception of type: 'StorageError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, response, deserialize, *args):

      model_name = 'StorageError'
      self.error = deserialize(model_name, response)
      if self.error is None:
          self.error = deserialize.dependencies[model_name]()
      super(StorageErrorException, self).__init__(response=response)


class StorageServiceProperties(Model):
    """Storage Service Properties.

    :param logging:
    :type logging: ~azure.storage.blob.models.Logging
    :param hour_metrics:
    :type hour_metrics: ~azure.storage.blob.models.Metrics
    :param minute_metrics:
    :type minute_metrics: ~azure.storage.blob.models.Metrics
    :param cors: The set of CORS rules.
    :type cors: list[~azure.storage.blob.models.CorsRule]
    :param default_service_version: The default version to use for requests to
     the Blob service if an incoming request's version is not specified.
     Possible values include version 2008-10-27 and all more recent versions
    :type default_service_version: str
    :param delete_retention_policy:
    :type delete_retention_policy: ~azure.storage.blob.models.RetentionPolicy
    :param static_website:
    :type static_website: ~azure.storage.blob.models.StaticWebsite
    """

    _attribute_map = {
        'logging': {'key': 'Logging', 'type': 'Logging', 'xml': {'name': 'Logging'}},
        'hour_metrics': {'key': 'HourMetrics', 'type': 'Metrics', 'xml': {'name': 'HourMetrics'}},
        'minute_metrics': {'key': 'MinuteMetrics', 'type': 'Metrics', 'xml': {'name': 'MinuteMetrics'}},
        'cors': {'key': 'Cors', 'type': '[CorsRule]', 'xml': {'name': 'Cors', 'itemsName': 'CorsRule', 'wrapped': True}},
        'default_service_version': {'key': 'DefaultServiceVersion', 'type': 'str', 'xml': {'name': 'DefaultServiceVersion'}},
        'delete_retention_policy': {'key': 'DeleteRetentionPolicy', 'type': 'RetentionPolicy', 'xml': {'name': 'DeleteRetentionPolicy'}},
        'static_website': {'key': 'StaticWebsite', 'type': 'StaticWebsite', 'xml': {'name': 'StaticWebsite'}},
    }
    _xml_map = {
    }

    def __init__(self, *, logging=None, hour_metrics=None, minute_metrics=None, cors=None, default_service_version: str=None, delete_retention_policy=None, static_website=None, **kwargs) -> None:
        super(StorageServiceProperties, self).__init__(**kwargs)
        self.logging = logging
        self.hour_metrics = hour_metrics
        self.minute_metrics = minute_metrics
        self.cors = cors
        self.default_service_version = default_service_version
        self.delete_retention_policy = delete_retention_policy
        self.static_website = static_website


class StorageServiceStats(Model):
    """Stats for the storage service.

    :param geo_replication:
    :type geo_replication: ~azure.storage.blob.models.GeoReplication
    """

    _attribute_map = {
        'geo_replication': {'key': 'GeoReplication', 'type': 'GeoReplication', 'xml': {'name': 'GeoReplication'}},
    }
    _xml_map = {
    }

    def __init__(self, *, geo_replication=None, **kwargs) -> None:
        super(StorageServiceStats, self).__init__(**kwargs)
        self.geo_replication = geo_replication


class UserDelegationKey(Model):
    """A user delegation key.

    All required parameters must be populated in order to send to Azure.

    :param signed_oid: Required. The Azure Active Directory object ID in GUID
     format.
    :type signed_oid: str
    :param signed_tid: Required. The Azure Active Directory tenant ID in GUID
     format
    :type signed_tid: str
    :param signed_start: Required. The date-time the key is active
    :type signed_start: datetime
    :param signed_expiry: Required. The date-time the key expires
    :type signed_expiry: datetime
    :param signed_service: Required. Abbreviation of the Azure Storage service
     that accepts the key
    :type signed_service: str
    :param signed_version: Required. The service version that created the key
    :type signed_version: str
    :param value: Required. The key as a base64 string
    :type value: str
    """

    _validation = {
        'signed_oid': {'required': True},
        'signed_tid': {'required': True},
        'signed_start': {'required': True},
        'signed_expiry': {'required': True},
        'signed_service': {'required': True},
        'signed_version': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'signed_oid': {'key': 'SignedOid', 'type': 'str', 'xml': {'name': 'SignedOid'}},
        'signed_tid': {'key': 'SignedTid', 'type': 'str', 'xml': {'name': 'SignedTid'}},
        'signed_start': {'key': 'SignedStart', 'type': 'iso-8601', 'xml': {'name': 'SignedStart'}},
        'signed_expiry': {'key': 'SignedExpiry', 'type': 'iso-8601', 'xml': {'name': 'SignedExpiry'}},
        'signed_service': {'key': 'SignedService', 'type': 'str', 'xml': {'name': 'SignedService'}},
        'signed_version': {'key': 'SignedVersion', 'type': 'str', 'xml': {'name': 'SignedVersion'}},
        'value': {'key': 'Value', 'type': 'str', 'xml': {'name': 'Value'}},
    }
    _xml_map = {
    }

    def __init__(self, *, signed_oid: str, signed_tid: str, signed_start, signed_expiry, signed_service: str, signed_version: str, value: str, **kwargs) -> None:
        super(UserDelegationKey, self).__init__(**kwargs)
        self.signed_oid = signed_oid
        self.signed_tid = signed_tid
        self.signed_start = signed_start
        self.signed_expiry = signed_expiry
        self.signed_service = signed_service
        self.signed_version = signed_version
        self.value = value
