/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:18:11 GMT 2018
 */

package uk.ac.sanger.artemis.plot;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.Box;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.apache.batik.ext.awt.ColorSpaceHintKey;
import org.biojava.bio.seq.io.GAMEFormat;
import org.biojava.bio.symbol.SymbolList;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.evosuite.runtime.System;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.runtime.testdata.FileSystemHandling;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.io.BioJavaSequence;
import uk.ac.sanger.artemis.io.EmblStreamSequence;
import uk.ac.sanger.artemis.io.FastaStreamSequence;
import uk.ac.sanger.artemis.io.Range;
import uk.ac.sanger.artemis.io.RawStreamSequence;
import uk.ac.sanger.artemis.io.Sequence;
import uk.ac.sanger.artemis.plot.MRIAlgorithm;
import uk.ac.sanger.artemis.sequence.Bases;
import uk.ac.sanger.artemis.sequence.Strand;
import uk.ac.sanger.artemis.util.StringVector;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class MRIAlgorithm_ESTest extends MRIAlgorithm_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence("uLZ");
      FastaStreamSequence fastaStreamSequence0 = new FastaStreamSequence("uLZ", "uLZ");
      Bases bases0 = new Bases(fastaStreamSequence0);
      bases0.addBases(23, 23, "b<f9o49B|E@;6FiHl?Z");
      Strand strand0 = bases0.getForwardStrand();
      Bases bases1 = strand0.getBases();
      Strand strand1 = bases1.getReverseStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand1);
      Integer integer0 = mRIAlgorithm0.getDefaultMinWindowSize();
      assertNotNull(integer0);
      assertEquals(24, (int)integer0);
      
      mRIAlgorithm0.getDefaultMaxWindowSize();
      mRIAlgorithm0.getDefaultWindowSize();
      bases1.getComplementPosition(1);
      Integer integer1 = mRIAlgorithm0.getDefaultMaxWindowSize();
      assertEquals(5000, (int)integer1);
      assertNotNull(integer1);
      
      Integer integer2 = mRIAlgorithm0.getDefaultStepSize(5);
      assertNull(integer2);
      
      Integer integer3 = mRIAlgorithm0.getDefaultWindowSize();
      assertNotNull(integer3);
      assertEquals(500, (int)integer3);
      
      float[] floatArray0 = new float[6];
      floatArray0[0] = (float) 5;
      floatArray0[1] = 687.369F;
      floatArray0[2] = (float) 0;
      floatArray0[3] = (float) 0;
      floatArray0[4] = (float) 0;
      floatArray0[5] = (float) 2;
      mRIAlgorithm0.getValues(85, 1775, floatArray0);
      mRIAlgorithm0.getDefaultStepSize((-5));
      int int0 = mRIAlgorithm0.getValueCount();
      assertEquals(3, int0);
      
      mRIAlgorithm0.getDefaultStepSize((-5));
      assertEquals("Reverse Mutational Response Index", mRIAlgorithm0.getAlgorithmName());
      assertTrue(mRIAlgorithm0.scalingFlag());
      
      mRIAlgorithm0.getDefaultMaxWindowSize();
      mRIAlgorithm0.getDefaultStepSize(5209);
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getDefaultMinWindowSize();
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("uWMFz");
      Bases bases0 = new Bases(emblStreamSequence0);
      Strand strand0 = bases0.getForwardStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.getDefaultWindowSize();
      mRIAlgorithm0.getDefaultMaxWindowSize();
      mRIAlgorithm0.getDefaultStepSize(10);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      FileSystemHandling.createFolder((EvoSuiteFile) null);
      FileSystemHandling.appendStringToFile((EvoSuiteFile) null, "1");
      Strand strand0 = bases0.getReverseStrand();
      Bases bases1 = strand0.getBases();
      Strand strand1 = bases1.getForwardStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand1);
      mRIAlgorithm0.getDefaultMinWindowSize();
      mRIAlgorithm0.getMaximumInternal();
      mRIAlgorithm0.getDefaultWindowSize();
      float[] floatArray0 = new float[9];
      floatArray0[0] = (float) (-5);
      floatArray0[1] = (float) 2;
      floatArray0[2] = (float) (-5);
      floatArray0[3] = (float) 0;
      floatArray0[4] = (float) 2;
      floatArray0[5] = (float) 0;
      floatArray0[6] = (float) 1;
      floatArray0[7] = (float) (-5);
      floatArray0[8] = (float) 0;
      // Undeclared exception!
      try { 
        mRIAlgorithm0.getValues((-1588), (-5), floatArray0);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("J");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      emblStreamSequence0.forceReset();
      Strand strand0 = bases0.getReverseStrand();
      rawStreamSequence0.setFromChar(bases0.letter_index);
      emblStreamSequence0.forceReset();
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.setAlgorithmName("J");
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getDefaultWindowSize();
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 5;
      floatArray0[3] = (float) 5;
      floatArray0[4] = (float) 0;
      // Undeclared exception!
      try { 
        mRIAlgorithm0.getValues(1, 108, floatArray0);
        fail("Expecting exception: ArrayIndexOutOfBoundsException");
      
      } catch(ArrayIndexOutOfBoundsException e) {
         //
         // -1
         //
         verifyException("uk.ac.sanger.artemis.plot.MRIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.getDefaultMaxWindowSize();
      mRIAlgorithm0.getDefaultStepSize((-5));
      // Undeclared exception!
      try { 
        mRIAlgorithm0.getValues(0, (-1868), (float[]) null);
        fail("Expecting exception: Error");
      
      } catch(Error e) {
         //
         // internal error - unexpected exception: org.evosuite.runtime.mock.java.lang.MockThrowable: start: 0 > end: -1867
         //
         verifyException("uk.ac.sanger.artemis.plot.MRIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("J");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      emblStreamSequence0.forceReset();
      Strand strand0 = bases0.getReverseStrand();
      rawStreamSequence0.setFromChar(bases0.letter_index);
      emblStreamSequence0.forceReset();
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.setAlgorithmName("J");
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getAverage();
      Integer integer0 = mRIAlgorithm0.getDefaultWindowSize();
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 108;
      floatArray0[1] = (float) 0;
      floatArray0[2] = (float) 5;
      floatArray0[3] = (float) 5;
      floatArray0[4] = (float) 0;
      mRIAlgorithm0.getValues(5, 108, floatArray0);
      Float float0 = mRIAlgorithm0.getMaximumInternal();
      Color[] colorArray0 = new Color[7];
      Box box0 = Box.createVerticalBox();
      Color color0 = box0.getBackground();
      colorArray0[1] = null;
      Object[][] objectArray0 = new Object[5][3];
      objectArray0[0] = (Object[]) colorArray0;
      objectArray0[1] = (Object[]) colorArray0;
      Object[] objectArray1 = new Object[6];
      objectArray1[1] = (Object) integer0;
      objectArray1[2] = (Object) integer0;
      objectArray1[3] = (Object) color0;
      objectArray1[4] = (Object) null;
      objectArray1[5] = (Object) box0;
      objectArray0[2] = objectArray1;
      objectArray0[3] = (Object[]) colorArray0;
      objectArray0[4] = (Object[]) colorArray0;
      Object[] objectArray2 = new Object[9];
      objectArray2[0] = (Object) floatArray0;
      objectArray2[1] = (Object) emblStreamSequence0;
      objectArray2[2] = (Object) box0;
      objectArray2[3] = (Object) mRIAlgorithm0;
      Object object0 = ColorSpaceHintKey.VALUE_COLORSPACE_ALPHA_CONVERT;
      objectArray2[4] = object0;
      objectArray2[6] = (Object) float0;
      objectArray2[7] = (Object) "J";
      objectArray2[8] = (Object) rawStreamSequence0;
      DefaultTableColumnModel defaultTableColumnModel0 = new DefaultTableColumnModel();
      defaultTableColumnModel0.getSelectionModel();
      Color color1 = Color.RED;
      colorArray0[3] = color1;
      SystemColor systemColor0 = SystemColor.textText;
      colorArray0[4] = (Color) systemColor0;
      Color color2 = Color.pink;
      colorArray0[5] = color2;
      DefaultTreeCellRenderer defaultTreeCellRenderer0 = new DefaultTreeCellRenderer();
      mRIAlgorithm0.drawLegend((Graphics) null, 1, 0, colorArray0);
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      Bases bases0 = new Bases((Sequence) null);
      Strand strand0 = bases0.getForwardStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.getMinimumInternal();
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      BioJavaSequence bioJavaSequence0 = new BioJavaSequence((SymbolList) null);
      Bases bases0 = new Bases(bioJavaSequence0);
      Strand strand0 = bases0.getReverseStrand();
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getMaximumInternal();
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      MRIAlgorithm mRIAlgorithm0 = null;
      try {
        mRIAlgorithm0 = new MRIAlgorithm((Strand) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("uk.ac.sanger.artemis.plot.MRIAlgorithm", e);
      }
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      EmblStreamSequence emblStreamSequence0 = new EmblStreamSequence("J");
      RawStreamSequence rawStreamSequence0 = new RawStreamSequence(emblStreamSequence0);
      Bases bases0 = new Bases(rawStreamSequence0);
      emblStreamSequence0.forceReset();
      Strand strand0 = bases0.getForwardStrand();
      rawStreamSequence0.setFromChar(bases0.letter_index);
      emblStreamSequence0.forceReset();
      emblStreamSequence0.setHeader("J");
      emblStreamSequence0.setFromChar(bases0.letter_index);
      MRIAlgorithm mRIAlgorithm0 = new MRIAlgorithm(strand0);
      mRIAlgorithm0.setAlgorithmName("J");
      mRIAlgorithm0.getAverage();
      mRIAlgorithm0.getMaximum();
      mRIAlgorithm0.getDefaultWindowSize();
      Range range0 = new Range(2);
      strand0.getStopOrStartCodons(range0, (StringVector) null);
      float[] floatArray0 = new float[5];
      floatArray0[0] = (float) 2;
      floatArray0[1] = (float) 0;
      System.setCurrentTimeMillis(2297L);
      floatArray0[2] = (float) 5;
      floatArray0[3] = (float) 5;
      floatArray0[4] = (float) 0;
      mRIAlgorithm0.getValues(1, 108, floatArray0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      GAMEFormat gAMEFormat0 = new GAMEFormat();
      assertEquals("GAME1.2", gAMEFormat0.getDefaultFormat());
  }
}
