#

  * Replies to Some Errors and Distortions in Bryan Caplan's "Anarchist Theory FAQ" version 5.2

## 1 - Individualist Anarchists and the socialist movement

Caplan, in his FAQ, attempts to rewrite anarchist history by trying to claim
that the individualist anarchists were forerunners of the so-called "anarcho-
capitalist" school. However, as is so often the case with Caplan's FAQ,
nothing could be further from the truth.

In section 5 (What major subdivisions may be made among anarchists?) of his
FAQ, Caplan writes that:

> _"A large segment of left-anarchists is extremely sceptical about the
> anarchist credentials of anarcho-capitalists, arguing that the anarchist
> movement has historically been clearly leftist. In my own view, it is
> necessary to re-write a great deal of history to maintain this claim."_

He quotes Carl Landauer's **European Socialism: A History of Ideas and
Movements** as evidence:

> _"To be sure, there is a difference between individualistic anarchism and
> collectivistic or communistic anarchism; Bakunin called himself a communist
> anarchist. But the communist anarchists also do not acknowledge any right to
> society to force the individual. They differ from the anarchistic
> individualists in their belief that men, if freed from coercion, will enter
> into voluntary associations of a communistic type, while the other wing
> believes that the free person will prefer a high degree of isolation. The
> communist anarchists repudiate the right of private property which is
> maintained through the power of the state. The individualist anarchists are
> inclined to maintain private property as a necessary condition of individual
> independence, without fully answering the question of how property could be
> maintained without courts and police."_

Caplan goes on to state that _"the interesting point is that before the
emergence of modern anarcho-capitalism Landauer found it necessary to
distinguish two strands of anarchism, only one of which he considered to be
within the broad socialist tradition."_

However, what Caplan seems to ignore is that both individualist and social
anarchists agree that there **is** a difference between the two schools of
anarchist thought! Some insight. Of course, Caplan tries to suggest that
Landauer's non-discussion of the individualist anarchists is somehow
"evidence" that their ideas are not socialistic. Firstly, Landauer's book is
about **European** Socialism. Individualist anarchism was almost exclusively
based in America and so hardly falls within the book's subject area. Secondly,
from the index Kropotkin is mentioned on **two** pages (one of which a
footnote). Does that mean Kropotkin was not a socialist? Of course not. It
seems likely, therefore, that Landauer is using the common Marxist terminology
of defining Marxism as Socialism, while calling other parts of the wider
socialist movement by their self-proclaimed names of anarchism, syndicalism
and so on. Hardly surprising that Kropotkin is hardly mentioned in a history
of "Socialism" (i.e. Marxism).

As noted above, both schools of anarchism knew there was a difference between
their ideas. Kropotkin and Tucker, for example, both distinguished between two
types of anarchism as well as two types of socialism. Thus Caplan's
_"interesting point"_ is just a banality, a common fact which anyone with a
basic familiarity of anarchist history would know. Kropotkin in his justly
famous essay on Anarchism for **The Encyclopaedia Britannica** **also** found
it necessary to distinguish two strands of anarchism. As regards Caplan's
claims that only one of these strands of anarchism is _"within the broad
socialist tradition"_ all we can say is that both Kropotkin **and** Tucker
considered their ideas and movement to be part of the broader socialist
tradition. According to an expert on Individualist Anarchism, Tucker _"looked
upon anarchism as a branch of the general socialist movement"_ [James J.
Martin, **Men Against the State** , pp. 226-7]. Other writers on Individualist
Anarchism have noted the same fact (for example, Tucker _"definitely thought
of himself a socialist"_ [William O. Reichart, **Partisans of Freedom: A Study
in American Anarchism** , p. 156]). As evidence of the anti-socialist nature
of individualist anarchism, Caplan's interpretation of Landauer's words is
fundamentally nonsense. If you look at the writings of people like Tucker you
will see that they called themselves socialists and considered themselves part
of the wider socialist movement. No one familiar with Tucker's works could
overlook this fact.

Interestingly, Landauer includes Proudhon in his history and states that he
was _"the most profound thinker among pre-Marxian socialists."_ [p. 67] Given
that Caplan elsewhere in his FAQ tries to co-opt Proudhon into the
"anarcho"-capitalist school as well as Tucker, his citing of Landauer seems
particularly dishonest. Landauer presents Proudhon's ideas in some depth in
his work within a chapter headed _**"The three Anticapitalistic Movements."**_
Indeed, he starts his discussion of Proudhon's ideas with the words _"In
France, post-Utopian socialism begins with Peter Joseph Proudhon."_ [p. 59]
Given that both Kropotkin and Tucker indicated that Individualist Anarchism
followed Proudhon's economic and political ideas the fact that Landauer states
that Proudhon was a socialist implies that Individualist Anarchism is also
socialist (or "Leftist" to use Caplan's term).

Tucker and the other individualist anarchists considered themselves as
followers of Proudhon's ideas (as did Bakunin and Kropotkin). For example,
Tucker stated that his journal **Liberty** was _"brought into existence as a
direct consequence of the teachings of Proudhon"_ and _"lives principally to
spread them."_ [cited by Paul Avrich in his _"Introduction"_ to **Proudhon and
his _"Bank of the People"_** by Charles A. Dana]

Obviously Landauer considered Proudhon a socialist and if Individualist
Anarchism follows Proudhon's ideas then it, too, must be socialist.

Unsurprisingly, then, Tucker also considered himself a socialist. To state the
obvious, Tucker and Bakunin both shared Proudhon's opposition to **private**
property (in the capitalist sense of the word), although Tucker confused this
opposition (and possibly the casual reader) by talking about possession as
"property."

So, it appears that Caplan is the one trying to rewrite history.

## 2 - Why is Caplan's definition of socialism wrong?

Perhaps the problem lies with Caplan's "definition" of socialism. In section 7
(Is anarchism the same thing as socialism?) he states:

> _"If we accept one traditional definition of socialism -- 'advocacy of
> government ownership of the means of production' -- it seems that anarchists
> are not socialists by definition. But if by socialism we mean something more
> inclusive, such as 'advocacy of the strong restriction or abolition of
> private property,' then the question becomes more complex."_

Which are hardly traditional definitions of socialism unless you are ignorant
of socialist ideas! By definition one, Bakunin and Kropotkin are not
socialists. As far as definition two goes, all anarchists were opposed to
(capitalist) private property and argued for its abolition and its replacement
with possession. The actual forms of possession differed from between
anarchist schools of thought, but the common aim to end private property
(capitalism) was still there. To quote Dana, in a pamphlet called _"a really
intelligent, forceful, and sympathetic account of mutual banking"_ by Tucker,
individualist anarchists desire to _"destroy the tyranny of capital,- that is,
of property"_ by mutual credit. [Charles A. Dana, **Proudhon and his _"Bank of
the People"_** , p. 46]

Interestingly, this second definition of socialism brings to light a
contradiction in Caplan's account. Elsewhere in the FAQ he notes that Proudhon
had _"ideas on the desirability of a modified form of private property."_ In
fact, Proudhon did desire to restrict private property to that of possession,
as Caplan himself seems aware. In other words, even taking his own definitions
we find that Proudhon would be considered a socialist! Indeed, according to
Proudhon, _"all accumulated capital is collective property, no one may be its
exclusive owner."_ [ **Selected Writings of Pierre-Joseph Proudhon** , p. 44]
Thus Jeremy Jennings' summary of the anarchist position on private property:

> _"The point to stress is that all anarchists [including Spooner and Tucker],
> and not only those wedded to the predominant twentieth-century strain of
> anarchist communism have been critical of private property to the extent
> that it was a source of hierarchy and privilege."_

He goes on to state that anarchists like Tucker and Spooner _"agreed with the
proposition that property was legitimate only insofar as it embraced no more
than the total product of individual labour."_ [ _"Anarchism"_ ,
**Contemporary Political Ideologies** , Roger Eatwell and Anthony Wright
(eds.), p. 132]

The idea that socialism can be defined as state ownership or even opposition
to, or "abolition" of, all forms of property is not one which is historically
accurate for all forms of socialism. Obviously communist-anarchists and
syndicalists would dismiss out of hand the identification of socialism as
state ownership, as would Individualist Anarchists like Tucker and Joseph
Labadie. As for opposition or abolition of all forms of "private property" as
defining socialism, such a position would have surprised communist-anarchists
like Kropotkin (and, obviously, such self-proclaimed socialists as Tucker and
Labadie).

For example, in **Act for Yourselves** Kropotkin explicitly states that a
peasant _"who is in possession of just the amount of land he can cultivate"_
would not be expropriated in an anarchist revolution. Similarly for the family
_"inhabiting a house which affords them just enough space . . . considered
necessary for that number of people"_ and the artisan _"working with their own
tools or handloom"_ would be left alone [pp. 104-5]. He makes the same point
in **The Conquest of Bread** [p. 61] Thus, like Proudhon, Kropotkin replaces
**private property** with **possession** as the former is _"theft"_ (i.e. it
allows exploitation, which _"indicate[s] the scope of Expropriation"_ namely
_"to everything that enables any man [or woman]. . . to appropriate the
product of other's toil"_ [ **The Conquest of Bread** , p. 61])

Even Marx and Engels did not define socialism in terms of the abolition of all
forms of "private property." Like anarchists, they distinguished between that
property which allows exploitation to occur and that which did not. Looking at
the **Communist Manifesto** we find them arguing that the _"distinguishing
feature of Communism is not the abolition of property generally, but the
abolition of bourgeois property"_ and that _"Communism deprives no man of the
power to appropriate the products of society; all that it does is to deprive
him of the power to subjugate the labour of others by means of such
appropriation."_ Moreover, they correctly note that "property" has meant
different things at different times and that the _"abolition of existing
property relations is not at all a distinctive feature of Communism"_ as
_"[a]ll property relations in the past have continually been subject to
historical change consequent upon the change in historical conditions."_ As an
example, they argue that the French Revolution _"abolished feudal property in
favour of bourgeois property."_ [ **The Manifesto of the Communist Party** ,
p.47, p. 49 and p. 47]

Which means that the idea that socialism means abolishing "private property"
is **only** true for those kinds of property that are used to exploit the
labour of others. Nicholas Walter sums up the anarchist position when he wrote
that anarchists _"are in favour of the private property which cannot be used
by one person to exploit another."_ [ **Reinventing Anarchy** , p. 49] In
other words, property which is no longer truly **private** as it is used by
those who do not own it. In effect, the key point of Proudhon's **What is
Property?** , namely the difference between possession and property. Which
means that rather than desire the abolition of all forms of "private
property," socialists (of all kinds, libertarian and authoritarian) desire the
abolition of a specific kind of property, namely that kind which allows the
exploitation and domination of others. To ignore this distinction is to paint
a very misleading picture of what socialism stands for.

This leaves the _"the strong restriction . . . of private property"_
definition of socialism. Here Caplan is on stronger ground. Unfortunately, by
using that definition the Individualist Anarchists, like the Social
Anarchists, are included in socialist camp, a conclusion he is trying to
avoid. As **every** anarchist shares Proudhon's analysis that _"property is
theft"_ and that **possession** would be the basis of anarchism, it means that
every anarchist is a socialist (as Labadie always claimed). This includes
Tucker and the other Individualist Anarchists. For example, Joseph Labadie
stated that _"the two great sub-divisions of Socialists"_ (anarchists and
State Socialists) both _"agree that the resources of nature -- land, mines,
and so forth -- should not be held as private property and subject to being
held by the individual for speculative purposes, that use of these things
shall be the only valid title, and that each person has an equal right to the
use of all these things. They all agree that the present social system is one
composed of a class of slaves and a class of masters, and that justice is
impossible under such conditions."_ [ **What is Socialism?** ] Tucker himself
argued that the anarchists' _"occupancy and use"_ title to land and other
scare material would involve a change (and, in effect, _"restriction"_ ) of
current (i.e. capitalist) property rights:

> _"It will be seen from this definition that Anarchistic property concerns
> only products. But anything is a product upon which human labour has been
> expended. It should be stated, however, that in the case of land, or of any
> other material the supply of which is so limited that all cannot hold it in
> unlimited quantities, Anarchism undertakes to protect no titles except such
> as are based on actual occupancy and use."_ [ **Instead of a Book** , p. 61]

and so:

> _"no advocate of occupancy and use believes that it can be put in force
> until as a theory it has been accepted as generally . . . seen and accepted
> as is the prevailing theory of ordinary private property."_ [ **Occupancy
> and Use versus the Single Tax** ]

So, as can be seen, Individualist Anarchism rejected important aspects of
capitalist property rights. Given that the Individualist Anarchists were
writing at a time when agriculture was still the largest source of employment
this position on land is much more significant than it first appears. In
effect, Tucker and the other American Anarchists were advocating a **massive**
and **fundamental** change in property-rights, in the social relationships
they generated and in American society. This is, in other words, a very
_"strong restriction"_ in capitalist property rights (and it is **this** type
of property Caplan is referring to, rather than "property" in the abstract).

However, such a "definition" of socialism as "restricting" private property is
flawed as it does not really reflect anarchist ideas on the subject.
Anarchists, in effect, reject the simplistic analysis that because a society
(or thinker) accepts "property" that it (or he/she) is capitalistic. This is
for two reasons. Firstly, the term "property" has been used to describe a wide
range of situations and institutions. Thus Tucker used the term "property" to
describe a society in which capitalist property rights were **not** enforced.
Secondly, and far more importantly, concentrating on "property" rights in the
abstract ignores the social relationships it generates. Freedom is product of
social interaction, not one of isolation. This means that the social
relationships generated in a given society are the key to evaluating it -- not
whether it has "property" or not. To look at "property" in the abstract is to
ignore people and the relationships they create between each other. And it is
these relationships which determine whether they are free or not (and so
exploited or not). Caplan's use of the anti-property rights "definition" of
socialism avoids the central issue of freedom, of whether a given society
generates oppression and exploitation or not. By looking at "property" Caplan
ignores liberty, a strange but unsurprising position for a self-proclaimed
"libertarian" to take.

Thus both of Caplan's "definitions" of socialism are lacking. A
_"traditional"_ one of government ownership is hardly that and the one based
on "property" rights avoids the key issue while, in its own way, includes
**all** the anarchists in the socialist camp (something Caplan, we are sure,
did not intend).

So what would be a useful definition of socialism? From our discussion on
property we can instantly reject Caplan's biased and simplistic starting
points. In fact, a definition of socialism which most socialists would agree
with would be one that stated that _"the whole produce of labour ought to
belong to the labourer"_ (to use words Thomas Hodgskin, an early English
socialist, from his essay **Labour Defended against the Claims of Capital** ).
Tucker stated that _"the bottom claim of Socialism"_ was _"that labour should
be put in possession of its own,"_ that _"the natural wage of labour is its
product"_ (see his essay **State Socialism and Anarchism** ). This definition
also found favour with Kropotkin who stated that socialism _"in its wide,
generic, and true sense"_ was an _"effort to **abolish** the exploitation of
labour by capital."_ [ **Kropotkin's Revolutionary Pamphlets** , p. 169]

From this position, socialists soon realised that (to again quote Kropotkin)
_"the only guarantee not to by robbed of the fruits of your labour is to
possess the instruments of labour."_ [ **The Conquest of Bread** , p. 145]
Because of this socialism also could be defined as _"the workers shall own the
means of production,"_ as this automatically meant that the product would go
to the producer, and, in fact, this could also be a definition of socialism
most socialists would agree with. The form of this ownership, however,
differed from socialist tendency to socialist tendency (some, like Proudhon,
proposed co-operative associations, others like Kropotkin communal ownership,
others like the Social Democrats state ownership and so on). Moreover, as the
economy changed in the 19th century, so did socialist ideas. Murray Bookchin
gives a good summary of this process:

> _"Th[e] growing shift from artisanal to an industrial economy gave rise to a
> gradual but major shift in socialism itself. For the artisan, socialism
> meant producers' co-operatives composed of men who worked together in small
> shared collectivist associations . . . For the industrial proletarian, by
> contrast, socialism came to mean the formation of a mass organisation that
> gave factory workers the collective power to expropriate a plant that no
> single worker could properly own. . . They advocated **public** ownership of
> the means of production, whether by the state or by the working class
> organised in trade unions."_ [ **The Third Revolution** , vol. 2, p. 262]

So, in this evolution of socialism we can place the various brands of
anarchism. Individualist anarchism is clearly a form of artisanal socialism
(which reflects its American roots) while communist anarchism and anarcho-
syndicalism are forms of industrial (or proletarian) socialism (which reflects
its roots in Europe). Proudhon's mutualism bridges these extremes, advocating
as it does artisan socialism for small-scale industry and agriculture and co-
operative associations for large-scale industry (which reflects the state of
the French economy in the 1840s to 1860s). The common feature of all these
forms of anarchism is opposition to usury and the notion that _"workers shall
own the means of production."_ Or, in Proudhon's words, _"abolition of the
proletariat."_ [ **Op. Cit.** , p. 179] As one expert on Proudhon points out,
Proudhon's support for _"association"_ (or _"associative socialism"_ )
_"anticipated all those later movements"_ which demanded _"that the economy be
controlled neither by private enterprise nor by the state . . . but by the
producers"_ such as _"the revolutionary syndicalists"_ and _"the students of
1968."_ [K. Steven Vincent, **Pierre-Joseph Proudhon and the Rise of French
Republican Socialism** , p. 165] _"Industrial Democracy must. . . succeed
Industrial Feudalism,"_ to again quote Proudhon. [ **Op. Cit.** , p. 167]

Thus the common agreement between all socialists was that capitalism was based
upon exploitation and wage slavery, that workers did not have access to the
means of production and so had to sell themselves to the class that did. Thus
we find Individualist Anarchists arguing that the whole produce of labour
ought to belong to the labourer and opposing the exploitation of labour by
capital. To use Tucker's own words:

> _"the fact that one class of men are dependent for their living upon the
> sale of their labour, while another class of men are relieved of the
> necessity of labour by being legally privileged to sell something that is
> not labour. . . . And to such a state of things I am as much opposed as any
> one. But the minute you remove privilege . . . every man will be a labourer
> exchanging with fellow-labourers . . . What Anarchistic-Socialism aims to
> abolish is usury . . . it wants to deprive capital of its reward."_ [
> **Instead of a Book** , p. 404]

By ending wage labour, anarchist socialism would ensure _"The land to the
cultivator. The mine to the miner. The tool to the labourer. The product to
the producer"_ and so _"everyone [would] be a proprietor"_ and so there would
be _"no more proletaires"_ (in the words of Ernest Lesigne, quoted favourably
by Tucker as part of what he called a _"summary exposition of Socialism from
the standpoint of Anarchism"_ [ **Op. Cit.** , p. 17, p. 16]). Wage labour,
and so capitalism, would be no more and _"the product [would go] to the
producer."_ The Individualist Anarchists, as Wm. Gary Kline correctly points
out, _"expected a society of largely self-employed workmen with no significant
disparity of wealth between any of them."_ [ **The Individualist Anarchists**
, p. 104] In other words, the _"abolition of the proletariat"_ as desired by
Proudhon.

Therefore, like all socialists, Tucker wanted to end usury, ensure the
_"product to the producer"_ and this meant workers owning and controlling the
means of production they used ( _"no more proletaires"_ ). He aimed to do this
by reforming capitalism away by creating mutual banks and other co-operatives
(he notes that Individualist Anarchists followed Proudhon, who _"would
individualise and associate"_ the productive and distributive forces in
society [as quoted by James J. Martin, **Men Against the State** , p. 228]).
Here is Kropotkin on Proudhon's reformist mutualist-socialism:

> _"When he proclaimed in his first memoir on property that 'Property is
> theft', he meant only property in its present, Roman-law, sense of 'right of
> use and abuse'; in property-rights, on the other hand, understood in the
> limited sense of **possession** , he saw the best protection against the
> encroachments of the state. At the same time he did not want violently to
> dispossess the present owners of land, dwelling-houses, mines, factories and
> so on. He preferred to **attain the same end** by rendering capital
> incapable of earning interest."_ [ **Kropotkin's Revolutionary Pamphlet's**
> , pp. 290-1 -- emphasis added]

In other words, like all anarchists, Proudhon desired to see a society without
capitalists and wage slaves ( _"the same end"_ ) but achieved by different
means. When Proudhon wrote to Karl Marx in 1846 he made the same point:

> _"through Political Economy we must turn the theory of Property against
> Property in such a way as to create what you German socialists call
> **community** and which for the moment I will only go so far as calling
> **liberty** or **equality.** "_ [ **Selected Writings of Pierre-Joseph
> Proudhon** , p. 151]

In other words, Proudhon shared the common aim of all socialists (namely to
abolish capitalism, wage labour and exploitation) but disagreed with the
means. As can be seen, Tucker placed himself squarely in this tradition and so
could (and did) call himself a socialist. Little wonder Joseph Labadie often
said that _"All anarchists are socialists, but not all socialists are
anarchists."_ That Caplan tries to ignore this aspect of Individualist
Anarchism in an attempt to co-opt it into "anarcho"-capitalism indicates well
that his FAQ is not an objective or neutral work.

Caplan states that the _"United States has been an even more fertile ground
for individualist anarchism: during the 19th-century, such figures as Josiah
Warren, Lysander Spooner, and Benjamin Tucker gained prominence for their
vision of an anarchism based upon freedom of contract and private property."_

However, as indicated, Tucker and Spooner did **not** support private property
in the capitalist sense of the word and Kropotkin and Bakunin, no less than
Tucker and Spooner, supported free agreement between individuals and groups.
What does that prove? That Caplan seems more interested in the words Tucker
and Proudhon used rather than the meanings **they** attached to them. Hardly
convincing.

Perhaps Caplan should consider Proudhon's words on the subject of socialism:

> _"Modern Socialism was not founded as a sect or church; it has seen a number
> of different schools."_ [ **Selected Writings of Pierre-Joseph Proudhon** ,
> p. 177]

If he did perhaps he would who see that the Individualist Anarchists were a
school of socialism, given their opposition to exploitation and the desire to
see its end via their political, economic and social ideas.

## 3 - Was Proudhon a socialist or a capitalist?

In section 8 (Who are the major anarchist thinkers?), Caplan tries his best to
claim that Proudhon was not really a socialist at all. He states that
_"Pierre[-Joseph] Proudhon is also often included [as a "left anarchist"]
although his ideas on the desirability of a modified form of private property
would lead some to exclude him from the leftist camp altogether."_

"Some" of which group? Other anarchists, like Bakunin and Kropotkin? Obviously
not -- Bakunin claimed that _"Proudhon was the master of us all."_ According
to George Woodcock Kropotkin was one of Proudhon's _"confessed disciples."_
Perhaps that makes Bakunin and Kropotkin proto-capitalists? Obviously not.
What about Tucker? He called Proudhon _"the father of the Anarchistic school
of Socialism."_ [ **Instead of a Book** , p. 381] And, as we noted above, the
socialist historian Carl Launder considered Proudhon a socialist, as did the
noted British socialist G.D.H. Cole in his **History of Socialist Thought**
(and in fact called him one of the _"major prophets of Socialism."_ ). What
about Marx and Engels, surely they would be able to say if he was a socialist
or not? According to Engels, Proudhon was _"the Socialist of the small peasant
and master-craftsman."_ [Marx and Engels, **Selected Works** , p. 260]

In fact, the only "left" (i.e. social) anarchist of note who seems to place
Proudhon outside of the "leftist" (i.e. anarchist) camp is Murray Bookchin. In
the second volume of **The Third Revolution** Bookchin argues that _"Proudhon
was no socialist"_ simply because he favoured _"private property."_ [p. 39]
However, he does note the _"one moral provision [that] distinguished the
Proudhonist contract from the capitalist contract"_ namely _"it abjured profit
and exploitation."_ [ **Op. Cit.** , pp. 40-41] -- which, of course, places
him in the socialist tradition (see [last section](append11.md#app2)).
Unfortunately, Bookchin fails to acknowledge this or that Proudhon was totally
opposed to wage labour along with usury, which, again, instantly places him in
ranks of socialism (see, for example, the **General Idea of the Revolution** ,
p. 98, pp. 215-6 and pp. 221-2, and his opposition to state control of capital
as being _"more wage slavery"_ and, instead, urging whatever capital required
collective labour to be _"democratically organised workers' associations"_ [
**No Gods, No Masters** , vol. 1, p. 62]).

Bookchin (on page 78) quotes Proudhon as arguing that _"association"_ was _"a
protest against the wage system"_ which suggests that Bookchin's claims that
Proudhonian _"analysis minimised the social relations embodied in the
capitalist market and industry"_ [p. 180] is false. Given that wage labour is
**the** unique social relationship within capitalism, it is clear from
Proudhon's works that he did not "minimise" the social relations created by
capitalism, rather the opposite. Proudhon's opposition to wage labour clearly
shows that he focused on the **key** social relation which capitalism creates
-- namely the one of domination of the worker by the capitalist.

Bookchin **does** mention that Proudhon was _"obliged in 1851, in the wake of
the associationist ferment of 1848 and after, to acknowledge that association
of some sort was unavoidable for large-scale enterprises."_ [p. 78] However,
Proudhon's support of industrial democracy pre-dates 1851 by some 11 years. He
stated in **What is Property?** that he _"preach[ed] emancipation to the
proletaires; association to the labourers"_ and that _"leaders"_ within
industry _"must be chosen from the labourers by the labourers themselves."_
[p. 137 and p. 414] It is significant that the first work to call itself
anarchist opposed property along with the state, exploitation along with
oppression and supported self-management against hierarchical relationships
within production ("anarcho"-capitalists take note!). Proudhon also called for
_"democratically organised workers' associations"_ to run large-scale industry
in his 1848 Election Manifesto. [ **No Gods, No Masters** , vol. 1, p. 62]
Given that Bookchin considers as _"authentic artisanal socialists"_ those who
called for **collective** ownership of the means of production, but _"exempted
from collectivisation the peasantry"_ [p. 4] we have to conclude that Proudhon
was such an "authentic" artisanal socialist! Indeed, at one point Bookchin
mentions the _"individualistic artisanal socialism of Proudhon"_ [p. 258]
which suggests a somewhat confused approach to Proudhon's ideas!

In effect, Bookchin makes the same mistake as Caplan; but, unlike Caplan, he
should know better. Rather than not being a socialist, Proudhon is obviously
an example of what Bookchin himself calls _"artisanal socialism"_ (as Marx and
Engels recongised). Indeed, he notes that Proudhon was its _"most famous
advocate"_ and that _"nearly all so-called 'utopian' socialists, even [Robert]
Owen -- the most labour-orientated -- as well as Proudhon -- essentially
sought the equitable distribution of property."_ [p. 273] Given Proudhon's
opposition to wage labour and capitalist property and his support for
industrial democracy as an alternative, Bookchin's position is untenable -- he
confuses socialism with communism, rejecting as socialist all views which are
not communism (a position he shares with right-libertarians).

He did not always hold this position, though. He writes in **The Spanish
Anarchists** that:

> _"Proudhon envisions a free society as one in which small craftsmen,
> peasants, and collectively owned industrial enterprises negotiate and
> contract with each other to satisfy their material needs. Exploitation is
> brought to an end. . . Although these views involve a break with capitalism,
> by no means can they be regarded as communist ideas. . ."_ [p. 18]

In contrast to some of Bookchin's comments (and Caplan) K. Steven Vincent is
correct to argue that, for Proudhon, justice _"applied to the economy was
associative socialism"_ and so Proudhon is squarely in the socialist camp [
**Pierre-Joseph Proudhon and the Rise of French Republican Socialism** , p.
228].

However, perhaps all these "leftists" are wrong (bar Bookchin, who **is**
wrong, at least some of the time). Perhaps they just did not understand what
socialism actually is (and as Proudhon stated _"I am socialist"_ [ **Selected
Writing of Pierre-Joseph Proudhon** , p. 195] and described himself as a
socialist many times this also applies to Proudhon himself!). So the question
arises, did Proudhon support private property in the capitalist sense of the
word? The answer is no. To quote George Woodcock summary of Proudhon's ideas
on this subject we find:

> _"He [Proudhon] was denouncing the property of a man who uses it to exploit
> the labour of others, without an effort on his own part, property
> distinguished by interest and rent, by the impositions of the non-producer
> on the producer. Towards property regarded as 'possession,' the right of a
> man to control his dwelling and the land and tools he needs to live,
> Proudhon had no hostility; indeed he regarded it as the cornerstone of
> liberty."_ [ _"On Proudhon's 'What is Property?'"_ , **The Raven** No. 31,
> pp. 208-9]

George Crowder makes the same point:

> _"The ownership he opposes is basically that which is unearned . . .
> including such things as interest on loans and income from rent. This is
> contrasted with ownership rights in those goods either produced by the work
> of the owner or necessary for that work, for example his dwelling-house,
> land and tools. Proudhon initially refers to legitimate rights of ownership
> of these goods as 'possession,' and although in his latter work he calls
> **this** 'property,' the conceptual distinction remains the same."_ [
> **Classical Anarchism** , pp. 85-86]

Indeed, according to Proudhon himself, the _"accumulation of capital and
instrument is what the capitalist owes to the producer, but he never pays him
for it. It is this fraudulent deprivation which causes the poverty of the
worker, the opulence of the idle and the inequality of their conditions. And
it is this, above all, which has so aptly been called the exploitation of man
by man."_ [ **Selected Writings of Pierre-Joseph Proudhon** , p. 43]

He called his ideas on possession a _"third form of society, the synthesis of
communism and property"_ and calls it _"liberty."_ [ **The Anarchist Reader**
, p. 68]. He even goes so far as to say that property _"by its despotism and
encroachment, soon proves itself oppressive and anti-social."_ [ **Op. Cit.**
, p. 67] Opposing private property he thought that _"all accumulated capital
is collective property, no one may be its exclusive owner."_ Indeed, he
considered the aim of his economic reforms _"was to rescue the working masses
from capitalist exploitation."_ [ **Selected Writings of Pierre-Joseph
Proudhon** , p. 44, p. 80]

In other words, Proudhon considered capitalist property to be the source of
exploitation and oppression and he opposed it. He explicitly contrasts his
ideas to that of capitalist property and **rejects** it as a means of ensuring
liberty.

Caplan goes on to claim that _"[s]ome of Proudhon's other heterodoxies include
his defence of the right of inheritance and his emphasis on the genuine
antagonism between state power and property rights."_

However, this is a common anarchist position. Anarchists are well aware that
possession is a source of independence within capitalism and so should be
supported. As Albert Meltzer puts it:

> _"All present systems of ownership mean that some are deprived of the fruits
> of their labour. It is true that, in a competitive society, only the
> possession of independent means enables one to be free of the economy (that
> is what Proudhon meant when, addressing himself to the self-employed
> artisan, he said 'property is liberty', which seems at first sight a
> contradiction with his dictum that it was theft)"_ [ **Anarchism: Arguments
> For and Against** , pp. 12-13]

Malatesta makes the same point:

> _"Our opponents . . . are in the habit of justifying the right to private
> property by stating that property is the condition and guarantee of
> liberty._
>
> _"And we agree with them. Do we not say repeatedly that poverty is slavery?_
>
> _"But then why do we oppose them?_
>
> _"The reason is clear: in reality the property that they defend is
> capitalist property. . . which therefore depends on the existence of a class
> of the disinherited and dispossessed, forced to sell their labour to the
> property owners for a wage below its real value. . . This means that workers
> are subjected to a kind of slavery."_ [ **The Anarchist Revolution** , p.
> 113]

As does Kropotkin:

> _"the only guarantee not to be robbed of the fruits of your labour is to
> possess the instruments of labour. . . man really produces most when he
> works in freedom, when he has a certain choice in his occupations, when he
> has no overseer to impede him, and lastly, when he sees his work bringing
> profit to him and to others who work like him, but bringing in little to
> idlers."_ [ **The Conquest of Bread** , p. 145]

Perhaps this makes these three well known anarcho-communists "really"
proto-"anarcho"-capitalists as well? Obviously not. Instead of wondering if
his ideas on what socialism is are wrong, he tries to rewrite history to fit
the anarchist movement into his capitalist ideas of what anarchism, socialism
and whatever are actually like.

In addition, we must point out that Proudhon's _"emphasis on the genuine
antagonism between state power and property rights"_ came from his later
writings, in which he argued that property rights were required to control
state power. In other words, this _"heterodoxy"_ came from a period in which
Proudhon did not think that state could be abolished and so _"property is the
only power that can act as a counterweight to the State."_ [ **Selected
Writings of Pierre-Joseph Proudhon** , p. 140] Of course, this "later"
Proudhon also acknowledged that property was _"an absolutism within an
absolutism,"_ _"by nature autocratic"_ and that its _"politics could be summed
up in a single word,"_ namely _"exploitation."_ [p. 141, p. 140, p. 134]

Moreover, Proudhon argues that _"spread[ing] it more equally and
establish[ing] it more firmly in society"_ is the means by which "property"
_"becomes a guarantee of liberty and keeps the State on an even keel."_ [p.
133, p. 140] In other words, rather than "property" **as such** limiting the
state, it is "property" divided equally through society which is the key,
without concentrations of economic power and inequality which would result in
exploitation and oppression. Therefore, _"[s]imple justice. . . requires that
equal division of land shall not only operate at the outset. If there is to be
no abuse, it must be maintained from generation to generation."_ [ **Op.
Cit.** , p. 141, p. 133, p. 130].

Interestingly, one of Proudhon's _"other heterodoxies"_ Caplan does not
mention is his belief that "property" was required not only to defend people
against the state, but also capitalism. He saw society dividing into _"two
classes, one of employed workers, the other of property-owners, capitalists,
entrepreneurs."_ He thus recognised that capitalism was just as oppressive as
the state and that it assured _"the victory of the strong over the weak, of
those who property over those who own nothing."_ [as quoted by Alan Ritter,
**The Political Thought of Pierre-Joseph Proudhon** , p. 121] Thus Proudhon's
argument that _"property is liberty"_ is directed not only against the state,
but also against social inequality and concentrations of economic power and
wealth.

Indeed, he considered that _"companies of capitalists"_ were the _"exploiters
of the bodies and souls of their wage earners"_ and an outrage on _"human
dignity and personality."_ Instead of wage labour he thought that the
_"industry to be operated, the work to be done, are the common and indivisible
property of all the participant workers."_ In other words, self-management and
workers' control. In this way there would be _"no more government of man by
man, by means of accumulation of capital"_ and the _"social republic"_
established. Hence his support for co-operatives:

> _"The importance of their work lies not in their petty union interests, but
> in their denial of the rule of capitalists, usurers, and governments, which
> the first [French] revolution left undisturbed. Afterwards, when they have
> conquered the political lie. . . the groups of workers should take over the
> great departments of industry which are their natural inheritance."_ [cited
> in **Pierre-Joseph Proudhon** , E. Hymans, pp. 190-1, and **Anarchism** ,
> George Woodcock, p. 110, 112]

In other words, a **socialist** society as workers would no longer be
separated from the means of production and they would control their own work
(the _"abolition of the proletariat,"_ to use Proudhon's expression). This
would mean recognising that _"the right to products is exclusive - jus in re;
the right to means is common - jus ad rem"_ [cited by Woodcock, **Anarchism**
, p. 96] which would lead to self-management:

> _"In democratising us, revolution has launched us on the path of industrial
> democracy."_ [ **Selected Writings of Pierre-Joseph Proudhon** , p. 63]

As Woodcock points out, in Proudhon's _"picture of the ideal society of the
ideal society it is this predominance of the small proprietor, the peasant or
artisan, that immediately impresses one"_ with _"the creation of co-operative
associations for the running of factories and railways."_ [ _"On Proudhon's
'What is Property?'"_ , **Op. Cit.** , p. 209, p. 210]

All of which hardly supports Caplan's attempts to portray Proudhon as "really"
a capitalist all along. Indeed, the "later" Proudhon's support for
protectionism [ **Selected Writings of Pierre-Joseph Proudhon** , p. 187], the
_"fixing after amicable discussion of a **maximum** and **minimum** profit
margin,"_ _"the organising of regulating societies"_ and that mutualism would
_"regulate the market"_ [ **Op. Cit.** , p. 70] and his obvious awareness of
economic power and that capitalism exploited and oppressed the wage-worker
suggests that rather than leading some to exclude Proudhon from the "leftist
camp" altogether, it is a case of excluding him utterly from the "rightist
camp" (i.e. "anarcho"-capitalism). Therefore Caplan's attempt to claim (co-opt
would be better) Proudhon for "anarcho"-capitalism indicates how far Caplan
will twist (or ignore) the evidence. As would quickly become obvious when
reading his work, Proudhon would (to use Caplan's words) _"normally classify
government, property, hierarchical organisations . . . as 'rulership.'"_

To summarise, Proudhon was a socialist and Caplan's attempts to rewrite
anarchist and socialist history fails. Proudhon was the fountainhead for both
wings of the anarchist movement and **What is Property?** _"embraces the core
of nineteenth century anarchism. . . [bar support for revolution] all the rest
of later anarchism is there, spoken or implied: the conception of a free
society united by association, of workers controlling the means of production.
. . [this book] remains the foundation on which the whole edifice of
nineteenth century anarchist theory was to be constructed."_ [ **Op. Cit.** ,
p. 210]

Little wonder Bakunin stated that his ideas were Proudhonism _"widely
developed and pushed to these, its final consequences."_ [ **Michael Bakunin:
Selected Writings** , p. 198]

## 4 - Tucker on Property, Communism and Socialism.

That Tucker called himself a socialist is quickly seen from **Instead of A
Book** or any of the books written about Tucker and his ideas. That Caplan
seeks to deny this means that either Caplan has not looked at either **Instead
of a Book** or the secondary literature (with obvious implications for the
accuracy of his FAQ) or he decided to ignore these facts in favour of his own
ideologically tainted version of history (again with obvious implications for
the accuracy and objectivity of his FAQ).

Caplan, in an attempt to deny the obvious, quotes Tucker from 1887 as follows
in section 14 (What are the major debates between anarchists? What are the
recurring arguments?):

> _"It will probably surprise many who know nothing of Proudhon save his
> declaration that 'property is robbery' to learn that he was perhaps the most
> vigorous hater of Communism that ever lived on this planet. But the apparent
> inconsistency vanishes when you read his book and find that by property he
> means simply legally privileged wealth or the power of usury, and not at all
> the possession by the labourer of his products."_

You will instantly notice that Proudhon does not mean by property _"the
possession of the labourer of his products."_ However, Proudhon did include in
his definition of "property" the possession of the capital to steal profits
from the work of the labourers. As is clear from the quote, Tucker and
Proudhon was opposed to capitalist property ( _"the power of usury"_ ). From
Caplan's own evidence he proves that Tucker was not a capitalist!

But lets quote Tucker on what he meant by _"usury"_ :

> _"There are three forms of usury, interest on money, rent on land and
> houses, and profit in exchange. Whoever is in receipt of any of these is a
> usurer."_ [cited in **Men against the State** by James J. Martin, p. 208]

Which can hardly be claimed as being the words of a person who supports
capitalism!

And we should note that Tucker considered both government and capital
oppressive. He argued that anarchism meant _"the restriction of power to self
and the abolition of power over others. Government makes itself felt alike in
country and in city, capital has its usurious grip on the farm as surely as on
the workshop and the oppressions and exactions of neither government nor
capital can be avoided by migration."_ [ **Instead of a Book** , p. 114]

And, we may add, since when was socialism identical to communism? Perhaps
Caplan should actually read Proudhon and the anarchist critique of private
property before writing such nonsense? We have indicated Proudhon's ideas
above and will not repeat ourselves. However, it is interesting that this
passes as "evidence" of "anti-socialism" for Caplan, indicating that he does
not know what socialism or anarchism actually is. To state the obvious, you
can be a hater of "communism" and still be a socialist!

So this, his one attempt to prove that Tucker, Spooner and even Proudhon were
really capitalists by quoting the actual people involved is a failure.

He asserts that for any claim that "anarcho"-capitalism is not anarchist is
wrong because _"the factual supporting arguments are often incorrect. For
example, despite a popular claim that socialism and anarchism have been
inextricably linked since the inception of the anarchist movement, many 19th-
century anarchists, not only Americans such as Tucker and Spooner, but even
Europeans like Proudhon, were ardently in favour of private property (merely
believing that some existing sorts of property were illegitimate, without
opposing private property as such)."_

The facts supporting the claim of anarchists being socialists, however, are
not "incorrect." It is Caplan's assumption that socialism is against all forms
of "property" which is wrong. To state the obvious, socialism does not equal
communism (and anarcho-communists support the rights of workers to own their
own means of production if they do not wish to join communist communes -- see
above). Thus Proudhon was renown as the leading French Socialist theorist when
he was alive. His ideas were widely known in the socialist movement and in
many ways his economic theories were similar to the ideas of such well known
early socialists as Robert Owen and William Thompson. As Kropotkin notes:

> _"It is worth noticing that French mutualism had its precursor in England,
> in William Thompson, who began by mutualism before he became a communist,
> and in his followers John Gray (A Lecture on Human Happiness, 1825; The
> Social System, 1831) and J. F. Bray (Labour's Wrongs and Labour's Remedy,
> 1839)."_ [ **Kropotkin's Revolutionary Pamphlets** , p. 291]

Perhaps Caplan will now claim Robert Owen and William Thompson as capitalists?

Tucker called himself a socialist on many different occasions and stated that
there were _"two schools of Socialistic thought . . . State Socialism and
Anarchism."_ And stated in very clear terms that:

> _"liberty insists on Socialism. . . - true Socialism, Anarchistic Socialism:
> the prevalence on earth of Liberty, Equality, and Solidarity."_ [ **Instead
> of a Book** , p. 363]

And like all socialists, he opposed capitalism (i.e. usury and wage slavery)
and wished that _"there should be no more proletaires."_ [see the essay
_"State Socialism and Anarchism"_ in **Instead of a Book** , p. 17]

Caplan, of course, is well aware of Tucker's opinions on the subject of
capitalism and private property. In section 13 (What moral justifications have
been offered for anarchism?) he writes:

> _"Still other anarchists, such as Lysander Spooner and Benjamin Tucker as
> well as Proudhon, have argued that anarchism would abolish the exploitation
> inherent in interest and rent simply by means of free competition. In their
> view, only labour income is legitimate, and an important piece of the case
> for anarchism is that without government-imposed monopolies, non-labour
> income would be driven to zero by market forces. It is unclear, however, if
> they regard this as merely a desirable side effect, or if they would reject
> anarchism if they learned that the predicted economic effect thereof would
> not actually occur."_

Firstly, we must point that Proudhon, Tucker and Spooner considered
**profits** to be exploitative as well as interest and rent. Hence we find
Tucker arguing that a _"just distribution of the products of labour is to be
obtained by destroying all sources of income except labour. These sources may
be summed up in one word, -- usury; and the three principle forms of usury are
interest, rent and profit."_ [ **Instead of a Book** , p. 474] To ignore the
fact that Tucker also considered profit as exploitative seems strange, to say
the least, when presenting an account of his ideas.

Secondly, rather than it being _"unclear"_ whether the end of usury was
_"merely a desirable side effect"_ of anarchism, the opposite is the case.
Anyone reading Tucker (or Proudhon) would quickly see that their politics were
formulated with the express aim of ending usury. Just one example from
hundreds:

> _"Liberty will abolish interest; it will abolish profit; it will abolish
> monopolistic rent; it will abolish taxation; it will abolish the
> exploitation of labour; it will abolish all means whereby any labourer can
> be deprived of any of his product."_ [ **Instead of a Book** , p. 347]

While it is fair to wonder whether these economic effects would result from
the application of Tucker's ideas, it **is** distinctly incorrect to claim
that the end of usury was considered in any way as a _"desirable side effect"_
of them. Rather, in **their** eyes, the end of usury was one of **the** aims
of Individualist Anarchism, as can be clearly seen. As Wm. Gary Kline points
out in his excellent account of Individualist Anarchism:

> _"the American anarchists exposed the tension existing in liberal thought
> between private property and the ideal of equal access. The Individualist
> Anarchists were, at least, aware that existing conditions were far from
> ideal, that the system itself worked against the majority of individuals in
> their efforts to attain its promises. Lack of capital, the means to creation
> and accumulation of wealth, usually doomed a labourer to a life of
> exploitation. This the anarchists knew and they abhorred such a system."_ [
> **The Individualist Anarchists** , p. 102]

This is part of the reason why they considered themselves socialists and,
equally as important, they were considered socialists by **other** socialists
such as Kropotkin and Rocker. The Individualist Anarchists, as can be seen,
fit very easily into Kropotkin's comments that _"the anarchists, in common
with all socialists. . . maintain that the now prevailing system of private
ownership in land, and our capitalist production for the sake of profits,
represent a monopoly which runs against both the principles of justice and the
dictates of utility."_ [ **Kropotkin's Revolutionary Pamphlets** , p. 285]
Given that they considered profits as usury and proposed _"occupancy and use"_
in place of the prevailing land ownership rights they are obviously
socialists.

That the end of usury was considered a clear aim of his politics explains
Tucker's 1911 postscript to his famous essay _"State Socialism and Anarchism"_
in which he argues that _"concentrated capital"_ **itself** was a barrier
towards anarchy. He argued that the _"trust is now a monster which. . . even
the freest competition, could it be instituted, would be unable to destroy."_
While, in an earlier period, big business _"needed the money monopoly for its
sustenance and its growth"_ its size now ensured that it _"sees in the money
monopoly a convenience, to be sure, but no longer a necessity. It can do
without it."_ This meant that the way was now _"not so clear."_ Indeed, he
argued that the problem of the trusts _"must be grappled with for a time
solely by forces political or revolutionary"_ as the trust had moved beyond
the reach of _"economic forces"_ simply due to the concentration of resources
in its hands. [ _"Postscript"_ to **State Socialism and Anarchism** ]

If the end of _"usury"_ **was** considered a _"side-effect"_ rather than an
objective, then the problems of the trusts and economic inequality/power (
_"enormous concentration of wealth"_ ) would not have been an issue. That the
fact of economic power **was** obviously considered a hindrance to anarchy
suggests the end of usury was a key aim, an aim which "free competition" in
the abstract could not achieve. Rather than take the "anarcho"-capitalist
position that massive inequality did not affect "free competition" or
individual liberty, Tucker obviously thought it did and, therefore, "free
competition" (and so the abolition of the public state) in conditions of
massive inequality would not create an anarchist society.

By trying to relegate an aim to a _"side-effect,"_ Caplan distorts the ideas
of Tucker. Indeed, his comments on trusts, _"concentrated capital"_ and the
_"enormous concentration of wealth"_ indicates how far Individualist Anarchism
is from "anarcho"-capitalism (which dismisses the question of economic power
Tucker raises out of hand). It also indicates the unity of political and
economic ideas, with Tucker being aware that without a suitable economic basis
individual freedom was meaningless. That an economy (like capitalism) with
massive inequalities in wealth and so power was not such a basis is obvious
from Tucker's comments.

Thirdly, what did Tucker consider as a government-imposed monopoly? Private
property, particularly in land! As he states _"Anarchism undertakes to protect
no titles except such as are based upon actual occupancy and use"_ and that
anarchism _"means the abolition of landlordism and the annihilation of rent."_
[ **Instead of a Book** , p. 61, p. 300] This, to state the obvious, is a
restriction on "private property" (in the capitalist sense), which, if we use
Caplan's definition of socialism, means that Tucker was obviously part of the
"Leftist camp" (i.e. socialist camp). In other words, Tucker considered
capitalism as the product of statism while socialism (libertarian of course)
would be the product of anarchy.

So, Caplan's historical argument to support his notion that anarchism is
simply anti-government fails. Anarchism, in all its many forms, have distinct
economic as well as political ideas and these cannot be parted without loosing
what makes anarchism unique. In particular, Caplan's attempt to portray
Proudhon as an example of a "pure" anti-government anarchism also fails, and
so his attempt to co-opt Tucker and Spooner also fails (as noted, Tucker
cannot be classed as a "pure" anti-government anarchist either). If Proudhon
was a socialist, then it follows that his self-proclaimed followers will also
be socialists -- and, unsurprisingly, Tucker called himself a socialist and
considered anarchism as part of the wider socialist movement.

> _"Like Proudhon, Tucker was an 'un-marxian socialist'"_ [William O.
> Reichart, **Partisans of Freedom: A Study in American Anarchism** , p. 157]

## 5 - Anarchism and "anarcho"-capitalism

Caplan tries to build upon the non-existent foundation of Tucker's and
Proudhon's "capitalism" by stating that:

> _"Nor did an ardent anarcho-communist like Kropotkin deny Proudhon or even
> Tucker the title of 'anarchist.' In his Modern Science and Anarchism,
> Kropotkin discusses not only Proudhon but 'the American anarchist
> individualists who were represented in the fifties by S.P. Andrews and W.
> Greene, later on by Lysander Spooner, and now are represented by Benjamin
> Tucker, the well-known editor of the New York Liberty.' Similarly in his
> article on anarchism for the 1910 edition of the Encyclopedia Britannica,
> Kropotkin again freely mentions the American individualist anarchists,
> including 'Benjamin Tucker, whose journal Liberty was started in 1881 and
> whose conceptions are a combination of those of Proudhon with those of
> Herbert Spencer.'"_

There is a nice historical irony in Caplan's attempts to use Kropotkin to
prove the historical validity of "anarcho"-capitalism. This is because while
Kropotkin was happy to include Tucker into the anarchist movement, Tucker
often claimed that an anarchist could not be a communist! In **State Socialism
and Anarchism** he stated that anarchism was _"an ideal utterly inconsistent
with that of those Communists who falsely call themselves Anarchists while at
the same time advocating a regime of Archism fully as despotic as that of the
State Socialists themselves."_ [ _"State Socialism and Anarchism"_ , **Instead
of a Book** , pp. 15-16]

While modern social anarchists follow Kropotkin in not denying Proudhon or
Tucker as anarchists, we do deny the anarchist title to supporters of
capitalism. Why? Simply because anarchism as a **political** movement (as
opposed to a dictionary definition) has always been anti-capitalist and
against capitalist wage slavery, exploitation and oppression. In other words,
anarchism (in all its forms) has always been associated with specific
political **and** economic ideas. Both Tucker and Kropotkin defined their
anarchism as an opposition to both state and capitalism. To quote Tucker on
the subject:

> _"Liberty insists. . . [on] the abolition of the State and the abolition of
> usury; on no more government of man by man, and no more exploitation of man
> by man."_ [cited in **Native American Anarchism - A Study of Left-Wing
> American Individualism** by Eunice Schuster, p. 140]

Kropotkin defined anarchism as _"the no-government system of socialism."_ [
**Kropotkin's Revolutionary Pamphlets** , p. 46] Malatesta argued that _"when
[people] sought to overthrow both State and property -- then it was anarchy
was born"_ and, like Tucker, aimed for _"the complete destruction of the
domination and exploitation of man by man."_ [ **Life and Ideas** , p. 19, pp.
22-28] Indeed **every** leading anarchist theorist defined anarchism as
opposition to government **and** exploitation. Thus Brain Morris' excellent
summary:

> _"Another criticism of anarchism is that it has a narrow view of politics:
> that it sees the state as the fount of all evil, ignoring other aspects of
> social and economic life. This is a misrepresentation of anarchism. It
> partly derives from the way anarchism has been defined [in dictionaries, for
> example], and partly because Marxist historians have tried to exclude
> anarchism from the broader socialist movement. But when one examines the
> writings of classical anarchists. . . as well as the character of anarchist
> movements. . . it is clearly evident that it has never had this limited
> vision. It has always challenged all forms of authority and exploitation,
> and has been equally critical of capitalism and religion as it has been of
> the state."_ [ _"Anthropology and Anarchism,"_ **Anarchy: A Journal of
> Desire Armed** no. 45, p. 40]

Therefore anarchism was never purely a political concept, but always combined
an opposition to oppression with an opposition to exploitation. Little wonder,
then, that both strands of anarchism have declared themselves "socialist" and
so it is _"conceptually and historically misleading"_ to _"create a dichotomy
between socialism and anarchism."_ [Brian Morris, **Op. Cit.** , p. 39]
Needless to say, anarchists oppose **state** socialism just as much as they
oppose capitalism. All of which means that anarchism and capitalism are two
**different** political ideas with specific (and opposed) meanings -- to deny
these meanings by uniting the two terms creates an oxymoron, one that denies
the history and the development of ideas as well as the whole history of the
anarchist movement itself.

As Kropotkin knew Proudhon to be an anti-capitalist, a socialist (but not a
communist) it is hardly surprising that he mentions him. Again, Caplan's
attempt to provide historical evidence for a "right-wing" anarchism fails.
Funny that the followers of Kropotkin are now defending individualist
anarchism from the attempted "adoption" by supporters of capitalism! That in
itself should be enough to indicate Caplan's attempt to use Kropotkin to give
credence to "anarcho"-capitalist co-option of Proudhon, Tucker and Spooner
fails.

Interestingly, Caplan admits that "anarcho"-capitalism has recent origins. In
section 8 (Who are the major anarchist thinkers?) he states:

> _"Anarcho-capitalism has a much more recent origin in the latter half of the
> 20th century. The two most famous advocates of anarcho-capitalism are
> probably Murray Rothbard and David Friedman. There were however some
> interesting earlier precursors, notably the Belgian economist Gustave de
> Molinari. Two other 19th-century anarchists who have been adopted by modern
> anarcho-capitalists with a few caveats are Benjamin Tucker and Lysander
> Spooner. (Some left-anarchists contest the adoption, but overall Tucker and
> Spooner probably have much more in common with anarcho-capitalists than with
> left-anarchists.)"_

Firstly, as he states, Tucker and Spooner have been _"adopted"_ by the
"anarcho"-capitalist school. Being dead they have little chance to protest
such an adoption, but it is clear that they considered themselves as
socialists, against capitalism (it may be claimed that Spooner never called
himself a socialist, but then again he never called himself an anarchist
either; it is his strong opposition to wage labour that places him in the
socialist camp). Secondly, Caplan lets the cat out the bag by noting that this
"adoption" involved a few warnings - more specifically, the attempt to rubbish
or ignore the underlying socio-economic ideas of Tucker and Spooner and the
obvious anti-capitalist nature of their vision of a free society.

Individualist anarchists are, indeed, more similar to classical liberals than
social anarchists. Similarly, social anarchists are more similar to Marxists
than Individualist anarchists. But neither statement means that Individualist
anarchists are capitalists, or social anarchists are state socialists. It just
means some of their ideas overlap -- and we must point out that Individualist
anarchist ideas overlap with Marxist ones, and social anarchist ones with
liberal ones (indeed, one interesting overlap between Marxism and
Individualist Anarchism can be seen from Marx's comment that abolishing
interest and interest-bearing capital _"means the abolition of capital and of
capitalist production itself."_ [ **Theories of Surplus Value** , vol. 3, p.
472] Given that Individualist Anarchism aimed to abolish interest (along with
rent and profit) it would suggest, from a Marxist position, that it is a
socialist theory).

So, if we accept Kropotkin's summary that Individualist Anarchism ideas are
_"partly those of Proudhon, but party those of Herbert Spencer"_ [
**Kropotkins' Revolutionary Pamphlets** , p. 173], what the
"anarcho"-capitalist school is trying to is to ignore the Proudhonian (i.e.
socialist) aspect of their theories. However, that just leaves Spencer and
Spencer was not an anarchist, but a right-wing Libertarian, a supporter of
capitalism (a _"champion of the capitalistic class"_ as Tucker put it). In
other words, to ignore the socialist aspect of Individualist Anarchism (or
anarchism in general) is to reduce it to liberalism, an extreme version of
liberalism, but liberalism nevertheless -- and liberalism is not anarchism. To
reduce anarchism so is to destroy what makes anarchism a unique political
theory and movement:

> _"anarchism does derive from liberalism and socialism both historically and
> ideologically . . . In a sense, anarchists always remain liberals and
> socialists, and whenever they reject what is good in either they betray
> anarchism itself . . . We are liberals but more so, and socialists but more
> so."_ [Nicholas Walter, **Reinventing Anarchy** , p. 44]

In other words, "anarcho"-capitalism is a development of ideas which have
little in common with anarchism. Jeremy Jennings, in his overview of anarchist
theory and history, agrees:

> _"It is hard not to conclude that these ideas ["anarcho"-capitalism] -- with
> roots deep in classical liberalism -- are described as anarchist only on the
> basis of a misunderstanding of what anarchism is."_ [ **Contemporary
> Political Ideologies** , Roger Eatwell and Anthony Wright (eds.), p. 142]

Barbara Goodwin also agrees that the "anarcho"-capitalists' _"true place is in
the group of right-wing libertarians"_ not in anarchism [ **Using Political
Ideas** , p. 148]. Indeed, that "anarcho"-capitalism is an off-shoot of
classical liberalism is a position Murray Rothbard would agree with, as he
states that right-wing Libertarians constitute _"the vanguard of classical
liberalism."_ [quoted by Ulrike Heider, **Anarchism: Left, Right and Green** ,
p. 95] Unfortunately for this perspective anarchism is not liberalism and
liberalism is not anarchism. And equally as unfortunate (this time for the
anarchist movement!) "anarcho"-capitalism _"is judged to be anarchism largely
because some anarcho-capitalists **say** they are 'anarchists' and because
they criticise the State."_ [Peter Sabatini, **Social Anarchism** , no. 23, p.
100] However, being opposed to the state is a necessary but not sufficient
condition for being an anarchist (as can be seen from the history of the
anarchist movement). Brian Morris puts it well when he writes:

> _"The term anarchy comes from the Greek, and essentially means 'no ruler.'
> Anarchists are people who reject all forms of government or coercive
> authority, all forms of hierarchy and domination. They are therefore opposed
> to what the Mexican anarchist Flores Magon called the 'sombre trinity' --
> state, capital and the church. Anarchists are thus opposed to both
> capitalism and to the state, as well as to all forms of religious authority.
> But anarchists also seek to establish or bring about by varying means, a
> condition of anarchy, that is, a decentralised society without coercive
> institutions, a society organised through a federation of voluntary
> associations. Contemporary 'right-wing' libertarians . . . who are often
> described as 'anarchocapitalists' and who fervently defend capitalism, are
> not in any real sense anarchists."_ [ **Op. Cit.** , p. 38]

Rather than call themselves by a name which reflects their origins in
liberalism (and **not** anarchism), the "anarcho"-capitalists have instead
seen fit to try and appropriate the name of anarchism and, in order to do so,
ignore key aspects of anarchist theory in the process. Little wonder, then,
they try and prove their anarchist credentials via dictionary definitions
rather than from the anarchist movement itself (see [next
section](append11.md#app6)).

Caplan's attempt in his FAQ is an example to ignore individualist anarchist
theory and history. Ignored is any attempt to understand their ideas on
property and instead Caplan just concentrates on the fact they use the word.
Caplan also ignores:

>   * their many statements on being socialists and part of the wider
> socialist movement.
>
>   * their opposition to capitalist property-rights in land and other scarce
> resources.
>
>   * their recognition that capitalism was based on usury and that it was
> exploitation.
>
>   * their attacks on government **and** capital, rather than just
> government.
>
>   * their support for strikes and other forms of direct action by workers to
> secure the full product of their labour.
>

In fact, the only things considered useful seems to be the individualist
anarchist's support for free agreement (something Kropotkin also agreed with)
and their use of the word "property." But even a cursory investigation
indicates the non-capitalist nature of their ideas on property and the
socialistic nature of their theories.

Perhaps Caplan should ponder these words of Kropotkin supporters of the
_"individualist anarchism of the American Proudhonians . . . soon realise that
the individualisation they so highly praise is not attainable by individual
efforts, and . . . abandon the ranks of the anarchists, and are driven into
the liberal individualism of the classical economist."_ [ **Kropotkin's
Revolutionary Pamphlets** , p. 297]

Caplan seems to confuse the end of the ending place of ex-anarchists with
their starting point. As can be seen from his attempt to co-opt Proudhon,
Spooner and Tucker he has to ignore their ideas and rewrite history.

## 6 - Appendix: Defining Anarchism

In his Appendix _"Defining Anarchism"_ we find that Caplan attempts to defend
his dictionary definition of anarchism. He does this by attempting to refute
two arguments, The Philological Argument and the Historical Argument.

Taking each in turn we find:

Caplan's definition of _"The Philological Argument"_ is as follows:

> _"Several critics have noted the origin of the term 'anarchy,' which derives
> from the Greek 'arkhos,' meaning 'ruler,' and the prefix an-,' meaning
> 'without.' It is therefore suggested that in my definition the word
> 'government' should be replaced with the word 'domination' or 'rulership';
> thus re-written, it would then read: 'The theory or doctrine that all forms
> of rulership are unnecessary, oppressive, and undesirable and should be
> abolished.'"_

Caplan replies by stating that:

> _"This is all good and well, so long as we realise that various groups of
> anarchists will radically disagree about what is or is not an instance of
> 'rulership.'"_

However, in order to refute this argument by this method, he has to ignore his
own methodology. A dictionary definition of ruler is _"a person who rules by
authority."_ and _"rule"_ is defined as _"to have authoritative control over
people"_ or _"to keep (a person or feeling etc.) under control, to dominate"_
[ **The Oxford Study Dictionary** ]

Hierarchy by its very nature is a form of rulership (hier- ** _archy_** ) and
is so opposed by anarchists. Capitalism is based upon wage labour, in which a
worker follows the rules of their boss. This is obviously a form of hierarchy,
of domination. Almost all people (excluding die-hard supporters of capitalism)
would agree that being told what to do, when to do and how to do by a boss is
a form of rulership. Anarchists, therefore, argue that _"economic exploitation
and political domination . . . [are] two continually interacting aspects of
the same thing -- the subjection of man by man."_ [Errico Malatesta, **Life
and Ideas** , p. 147] Rocker made the same point, arguing that the
_"exploitation of man by man and the domination of man over man are
inseparable, and each is the condition of the other."_ [ **Anarcho-
Syndicalism** , p. 18]

Thus Caplan is ignoring the meaning of words to state that _"on its own terms
this argument fails to exclude anarcho-capitalists"_ because they define
rulership to exclude most forms of archy! Hardly convincing.

Strangely enough, "anarcho"-capitalist icon Murray Rothbard actually provides
evidence that the anarchist position **is** correct. He argues that the state
_"arrogates to itself a monopoly of force, of ultimate decision-making power,
over a given area territorial area."_ [ **The Ethics of Liberty** , p. 170]
This is obviously a form of rulership. However, he also argues that
_"[o]bviously, in a free society, Smith has the ultimate decision-making power
over his own just property, Jones over his, etc."_ [ **Op. Cit.** , p. 173]
Which, to state the obvious, means that **both** the state and property is
marked by an _"ultimate decision-making power"_ over a given territory. The
only "difference" is that Rothbard claims the former is "just" (i.e. "justly"
acquired) and the latter is "unjust" (i.e. acquired by force). In reality of
course, the modern distribution of property is just as much a product of past
force as is the modern state. In other words, the current property owners have
acquired their property in the same unjust fashion as the state has its. If
one is valid, so is the other. Rothbard (and "anarcho"-capitalists in general)
are trying to have it both ways.

Rothbard goes on to show why statism and private property are essentially the
same thing:

> _"If the State may be said too properly own its territory, then it is proper
> for it to make rules for everyone who presumes to live in that area. It can
> legitimately seize or control private property because there is no private
> property in its area, because it really owns the entire land surface. So
> long as the State permits its subjects to leave its territory, then, it can
> be said to act as does any other owner who sets down rules for people living
> on his property."_ [ **Op. Cit.** , p. 170]

Of course Rothbard does not draw the obvious conclusion. He wants to maintain
that the state is bad and property is good while drawing attention to their
obvious similarities! Ultimately Rothbard is exposing the bankruptcy of his
own politics and analysis. According to Rothbard, something can look like a
state (i.e. have the _"ultimate decision-making power"_ over an area) and act
like a state (i.e. _"make rules for everyone"_ who lives in an area, i.e.
govern them) but not be a state. This not a viable position for obvious
reasons.

Thus to claim, as Caplan does, that property does not generate "rulership" is
obviously nonsense. Not only does it ignore the dictionary definition of
rulership (which, let us not forget, is Caplan's **own** methodology) as well
as commonsense, it obviously ignores what the two institutions have in common.
**If** the state is to be condemned as "rulership" then so must property --
for reasons, ironically enough, Rothbard makes clear!

Caplan's critique of the _"Philological Argument"_ fails because he tries to
deny that the social relationship between worker and capitalist and tenant and
landlord is based upon **archy,** when it obviously is. To quote Proudhon,
considered by Tucker as _"the Anarchist **par excellence,** "_ the employee
_"is subordinated, exploited: his permanent condition is one of obedience."_
Without _"association"_ (i.e. co-operative workplaces, workers' self-
management) there would be _"two industrial castes of masters and wage-workers
which is repugnant to a free and democratic society,"_ castes _"related as
subordinates and superiors."_ [ **The General Idea of the Revolution** , p.
216]

Moving on, Caplan defines the Historical Argument as:

> _"A second popular argument states that historically, the term 'anarchism'
> has been clearly linked with anarcho-socialists, anarcho-communists,
> anarcho-syndicalists, and other enemies of the capitalist system. Hence, the
> term 'anarcho-capitalism' is a strange oxymoron which only demonstrates
> ignorance of the anarchist tradition."_

He argues that _"even if we were to accept the premise of this argument -- to
wit, that the meaning of a word is somehow determined by its historical usage
-- the conclusion would not follow because the minor premise is wrong. It is
simply not true that from its earliest history, all anarchists were opponents
of private property, free markets, and so on."_

Firstly, anarchism is not just a word, but a political idea and movement and
so the word used in a political context is associated with a given body of
ideas. You cannot use the word to describe something which has little or
nothing in common with that body of ideas. You cannot call Marxism "anarchism"
simply because they share the anarchist opposition to capitalist exploitation
and aim for a stateless society, for example.

Secondly, it is true that anarchists like Tucker were not against the free
market, but they did not consider capitalism to be defined by the free market
but by exploitation and wage labour (as do all socialists). In this they share
a common ground with Market Socialists who, like Tucker and Proudhon, do not
equate socialism with opposition to the market or capitalism with the "free
market." The idea that socialists oppose _"private property, free markets, and
so on"_ is just an assumption by Caplan. Proudhon, for example, was not
opposed to competition, "property" (in the sense of possession) and markets
but during his lifetime and up to the present date he is acknowledged as a
socialist, indeed one of the greatest in French (if not European) history.
Similarly we find Rudolf Rocker writing that the Individualist Anarchists
_"all agree on the point that man be given the full reward of his labour and
recognised in this right the economic basis of all personal liberty. They
regard free competition . . . as something inherent in human nature . . . They
answered the **socialists of other schools** [emphasis added] who saw in
**free competition** one of the destructive elements of capitalistic society
that the evil lies in the fact that today we have too little rather than too
much competition."_ [quoted by Herbert Read, **A One-Man Manifesto** , p. 147]
Rocker obviously considered support for free markets as compatible with
socialism. In other words, Caplan's assumption that all socialists oppose free
markets, competition and so on is simply false -- as can be seen from the
history of the socialist movement. What socialists **do** oppose is capitalist
exploitation -- socialism _"in its wide, generic, and true sense"_ was an
_"effort to **abolish** the exploitation of labour by capital."_ [Peter
Kropotkin, **Kropotkin's Revolutionary Pamphlets** , p. 169] In this sense the
Individualist Anarchists are obviously socialists, as Tucker and Labadie
constantly pointed out.

In addition, as we have proved elsewhere, Tucker was opposed to capitalist
private property just as much as Kropotkin was. Moreover, it is clear from
Tucker's works that he considered himself an enemy of the capitalist system
and called himself a socialist. Thus Caplan's attempt to judge the historical
argument on its own merits fails because he has to rewrite history to do so.

Caplan is right to state that the meaning of words change over time, but this
does not mean we should run to use dictionary definitions. Dictionaries rarely
express political ideas well - for example, most dictionaries define the word
"anarchy" as "chaos" and "disorder." Does that mean anarchists aim to create
chaos? Of course not. Therefore, Caplan's attempt to use dictionary
definitions is selective and ultimately useless - anarchism as a political
movement cannot be expressed by dictionary definitions and any attempt to do
so means to ignore history.

The problems in using dictionary definitions to describe political ideas can
best be seen from the definition of the word "Socialism." According to the
**Oxford Study Dictionary** Socialism is _"a political and economic theory
advocating that land, resources, and the chief industries should be owned and
managed by the State."_ The **Webster's Ninth New Collegiate Dictionary** ,
conversely, defines socialism as _"any of various economic and political
theories advocating collective or government ownership and administration of
the means of production and distribution of goods."_

Clearly the latter source has a more accurate definition of socialism than the
former, by allowing for "collective" versus solely "State" control of
productive means. Which definition would be better? It depends on the person
involved. A Marxist, for example, could prefer the first one simply to exclude
anarchism from the socialist movement, something they have continually tried
to do. A right-libertarian could, again, prefer the first, for obvious
reasons. Anarchists would prefer the second, again for obvious reasons.
However neither definition does justice to the wide range of ideas that have
described themselves as socialist.

Using dictionaries as the basis of defining political movements ensures that
one's views depend on **which** dictionary one uses, and **when** it was
written, and so on. This is why they are not the best means of resolving
disputes -- if resolution of disputes is, in fact, your goal.

Both Kropotkin and Tucker stated that they were socialists and that anarchism
was socialistic. If we take the common modern meaning of the word as state
ownership as the valid one then Tucker and Kropotkin are **not** socialists
and no form of anarchism is socialist. This is obviously nonsense and it shows
the limitations of using dictionary definitions on political theories.

Therefore Caplan's attempt to justify using the dictionary definition fails.
Firstly, because the definitions used would depend which dictionary you use.
Secondly, dictionary definitions cannot capture the ins and outs of a
**political** theory or its ideas on wider subjects.

Ironically enough, Caplan is repeating an attempt made by State Socialists to
deny Individualist Anarchism its socialist title (see _"Socialism and the
Lexicographers"_ in **Instead of a Book** ). In reply to this attempt, Tucker
noted that:

> _"The makers of dictionaries are dependent upon specialists for their
> definitions. A specialist's definition may be true or it may be erroneous.
> But its truth cannot be increased or its error diminished by its acceptance
> by the lexicographer. Each definition must stand on its own merits."_ [
> **Instead of a Book** , p. 369]

And Tucker provided many quotes from **other** dictionaries to refute the
attempt by the State Socialists to define Individualist Anarchism outside the
Socialist movement. He also notes that any person trying such a method will
_"find that the Anarchistic Socialists are not to be stripped of one half of
their title by the mere dictum of the last lexicographer."_ [ **Op. Cit.** ,
p. 365]

Caplan should take note. His technique been tried before and it failed then
and it will fail again for the same reasons.

As far as his case against the Historical Argument goes, this is equally as
flawed. Caplan states that:

> _"Before the Protestant Reformation, the word 'Christian,' had referred
> almost entirely to Catholics (as well as adherents of the Orthodox Church)
> for about one thousand years. Does this reveal any linguistic confusion on
> the part of Lutherans, Calvinists, and so on, when they called themselves
> 'Christians'? Of course not. It merely reveals that a word's historical
> usage does not determine its meaning."_

However, as analogies go this is pretty pathetic. Both the Protestants and
Catholics followed the teachings of Christ but had different interpretations
of it. As such they could both be considered Christians - followers of the
Bible. In the case of anarchism, there are two main groupings - individualist
and social. Both Tucker and Bakunin claimed to follow, apply and develop
Proudhon's ideas (and share his opposition to both state and capitalism) and
so are part of the anarchist tradition.

The anarchist movement was based upon applying the core ideas of Proudhon (his
anti-statism and socialism) and developing them in the same spirit, and these
ideas find their roots in **socialist** history and theory. For example,
William Godwin was claimed as an anarchist after his death by the movement
because of his opposition to both state and private property, something all
anarchists oppose. Similarly, Max Stirner's opposition to both state and
capitalist property places him within the anarchist tradition.

Given that we find fascists and Nazis calling themselves "republicans,"
"democrats," even "liberals" it is worthwhile remembering that the names of
political theories are defined not by who use them, but by the ideas
associated with the name. In other words, a fascist cannot call themselves a
"liberal" any more than a capitalist can call themselves an "anarchist." To
state, as Caplan does, that the historical usage of a word does not determine
its meaning results in utter confusion and the end of meaningful political
debate. If the historical usage of a name is meaningless will we soon see
fascists as well as capitalists calling themselves anarchists? In other words,
the label "anarcho-capitalism" is a misnomer, pure and simple, as **all**
anarchists have opposed capitalism as an authoritarian system based upon
exploitation and wage slavery.

To ignore the historical usage of a word means to ignore what the movement
that used that word stood for. Thus, if Caplan is correct, an organisation
calling itself the "Libertarian National Socialist Party," for example, can
rightly call itself libertarian for _"a word's historical usage does not
determine its meaning."_ Given that right-libertarians in the USA have tried
to steal the name "libertarian" from anarchists and anarchist influenced
socialists, such a perspective on Caplan's part makes perfect sense. How
ironic that a movement that defends private property so strongly continually
tries to steal names from other political tendencies.

Perhaps a better analogy for the conflict between anarchism and "anarcho"-
capitalism would be between Satanists and Christians. Would we consider as
Christian a Satanist grouping claiming to be Christian? A grouping that
rejects everything that Christians believe but who like the name? Of course
not. Neither would we consider as a right-libertarian someone who is against
the free market or someone as a Marxist who supports capitalism. However, that
is what Caplan and other "anarcho"-capitalists want us to do with anarchism.

Both social and individualist anarchists defined their ideas in terms of both
political (abolition of the state) **and** economic (abolition of
exploitation) ideas. Kropotkin defined anarchism as _"the no-government form
of socialism"_ while Tucker insisted that anarchism was _"the abolition of the
State and the abolition of usury."_ In this they followed Proudhon who stated
that _"[w]e do not admit the government of man by man any more than the
exploitation of man by man."_ [quoted by Peter Marshall, **Demanding the
Impossible** , p. 245]

In other words, a political movement's economic ideas are just as much a part
of its theories as their political ideas. Any attempt to consider one in
isolation from the other kills what defines the theory and makes it unique.
And, ultimately, any such attempt, is a lie:

> _"[classical liberalism] is in theory a kind of anarchy without socialism,
> and therefore simply a lie, for freedom is impossible without equality, and
> real anarchy cannot exist without solidarity, without socialism."_ [Errico
> Malatesta, **Anarchy** , p. 46]

Therefore Caplan's case against the Historical Argument also fails - "anarcho-
capitalism" is a misnomer because anarchism has always, in all its forms,
opposed capitalism. Denying and re-writing history is hardly a means of
refuting the historical argument.

Caplan ends by stating:

> _"Let us designate anarchism (1) anarchism as you define it. Let us
> designate anarchism (2) anarchism as I and the American Heritage College
> Dictionary define it. This is a FAQ about anarchism (2)."_

Note that here we see again how the dictionary is a very poor foundation upon
to base an argument. Again using **Webster's Ninth New Collegiate Dictionary**
, we find under "anarchist" - _"one who rebels against any authority,
established order, or ruling power."_ This definition is very close to that
which "traditional" anarchists have - which is the basis for our own
opposition to the notion that anarchism is merely rebellion against **State**
authority.

Clearly this definition is at odds with Caplan's own view; is Webster's then
wrong, and Caplan's view right? Which view is backed by the theory and history
of the movement? Surely that should be the basis of who is part of the
anarchist tradition and movement and who is not? Rather than do this, Caplan
and other "anarcho"-capitalists rush to the dictionary (well, those that do
not define anarchy as "disorder"). This is for a reason as anarchism as a
political movement as always been explicitly anti-capitalist and so the term
"anarcho"-capitalism is an oxymoron.

What Caplan fails to even comprehend is that his choices are false. Anarchism
can be designated in two ways:

> (1). Anarchism as you define it  
>  (2). Anarchism as the anarchist movement defines it and finds expression in
> the theories developed by that movement.

Caplan chooses anarchism (1) and so denies the whole history of the anarchist
movement. Anarchism is not a word, it is a political theory with a long
history which dictionaries cannot cover. Therefore any attempt to define
anarchism by such means is deeply flawed and ultimately fails.

That Caplan's position is ultimately false can be seen from the
"anarcho"-capitalists themselves. In many dictionaries anarchy is defined as
_"disorder,"_ _"a state of lawlessness"_ and so on. Strangely enough, no
"anarcho"-capitalist ever uses **these** dictionary definitions of "anarchy"!
Thus appeals to dictionaries are just as much a case of defining anarchism as
you desire as not using dictionaries. Far better to look at the history and
traditions of the anarchist movement itself, seek out its common features and
apply **those** as criteria to those seeking to include themselves in the
movement. As can be seen, "anarcho"-capitalism fails this test and, therefore,
are not part of the anarchist movement. Far better for us all if they pick a
new label to call themselves rather than steal our name.

Although most anarchists disagree on many things, the denial of our history is
not one of them.

[‹ Appendix : Anarchism and "anarcho"-capitalism](append1.md "Go to previous
page") [up](append1.md "Go to parent page") [Replies to Some Errors and
Distortions in Bryan Caplan's "Anarchist Theory FAQ" version 4.1.1
›](append12.md "Go to next page")

