# ---------------------------------------------------------------------------
# - TLS0509.als                                                             -
# - afnix:tls module test unit                                              -
# ---------------------------------------------------------------------------
# - This program is free software;  you can redistribute it  and/or  modify -
# - it provided that this copyright notice is kept intact.                  -
# -                                                                         -
# - This program  is  distributed in  the hope  that it will be useful, but -
# - without  any  warranty;  without  even   the   implied    warranty   of -
# - merchantability or fitness for a particular purpose.  In no event shall -
# - the copyright holder be liable for any  direct, indirect, incidental or -
# - special damages arising in any way out of the use of this software.     -
# ---------------------------------------------------------------------------
# - copyright (c) 1999-2015 amaury darsch                                   -
# ---------------------------------------------------------------------------

# @info   X509 test unit
# @author amaury darsch

# get the module
interp:library "afnix-sec"
interp:library "afnix-tls"

# create a certificate by path
const cert (afnix:tls:X509 "TLS0509.der")

# check representation
assert true   (afnix:tls:x509-p cert)
assert "X509" (cert:repr)

# check version
assert 2  (cert:get-version)
# check serial number
assert 1R (cert:get-serial-number)
# check signature algorithm (sha1WithRSAEncryption)
const slgo (cert:get-signature-algorithm)
assert "1.2.840.113549.1.1.5" (slgo:get-identifier)

# get the issuer plist
const ilst  (cert:get-issuer-plist)
assert   6  (ilst:length)
# check the oid
assert "CA" (ilst:get-value "2.5.4.6")
assert "QC" (ilst:get-value "2.5.4.8")
assert "Montreal" (ilst:get-value "2.5.4.7")

# get the subject plist
const slst  (cert:get-subject-plist)
assert   6  (slst:length)
# check the oid
assert "CA" (slst:get-value "2.5.4.6")
assert "QC" (slst:get-value "2.5.4.8")
assert "Montreal" (slst:get-value "2.5.4.7")

# check the validity sequence
assert 63506925959 (cert:get-validity-before)
assert 63593325959 (cert:get-validity-after)

# check subject public key algorithm (RSAEncryption)
const spka (cert:get-subject-key-algorithm)
assert "1.2.840.113549.1.1.1" (spka:get-identifier)
# check subject public key info
const spki  (cert:get-subject-key-info)
assert true (bitset-p spki)
assert 2160 (spki:length)
# check the key
const  skey (cert:get-subject-key)
const  rsae (skey:to-key)
const  KRSA afnix:sec:Key:KRSA
assert KRSA (rsae:get-type)
assert 2048 (rsae:get-bits)

# check the unique id
assert nil (cert:get-issuer-unique-id)
assert nil (cert:get-subject-unique-id)

# check extensions
const  exts (cert:get-extension-vector)
assert 3    (exts:length)
  
