// ---------------------------------------------------------------------------
// - TlsProto.hpp                                                            -
// - afnix:tls service - tls protocol class definition                       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2015 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  AFNIX_TLSPROTO_HPP
#define  AFNIX_TLSPROTO_HPP

#ifndef  AFNIX_TLSSTATE_HPP
#include "TlsState.hpp"
#endif

#ifndef  AFNIX_TLSHBLOCK_HPP
#include "TlsHblock.hpp"
#endif

#ifndef  AFNIX_TLSMESSAGE_HPP
#include "TlsMessage.hpp"
#endif

namespace afnix {

  /// The TlsProto class is the tls record/message protocol decoder/encoder.
  /// This class is designed to be derived for supporting extra protocols. By
  /// default, the protocol of the tls 3.1 is implemented for reference. Note
  /// that creating a protocol by state entails the instanciation of the right
  /// protocol.
  /// @author amaury darsch

  class TlsProto : public Object {
  public:
    /// create a tls protocol by version
    /// @param vmaj the tls major version
    /// @param vmin the tls minor version
    static TlsProto* create (const t_byte vmaj, const t_byte vmin);

    /// create a tls protocol by state
    /// @param sta the tls state
    static TlsProto* create (TlsState* sta);

  public:
    /// create a default protocol
    TlsProto (void);

    /// @return the class name
    String repr (void) const;

    /// get a record by input stream
    /// @param is the input strem to read
    virtual TlsRecord* getrcd (InputStream* is) const;

    /// get a message by input stream
    /// @param is the input strem to read
    virtual TlsMessage* getmsg (InputStream* is) const;

    /// get a message by record
    /// @param rcd the record to decode
    virtual TlsMessage* getmsg (TlsRecord* rcd) const;

    /// encode a tls message
    /// @param os  the output stream
    /// @param msg the message to encode
    virtual void encode (OutputStream* os, TlsMessage* msg) const;

    /// decode a handshake block
    /// @param hblk the block to decode
    virtual TlsInfos* decode (TlsHblock* hblk) const;

    /// get a client hello by input stream
    /// @param is the input strem to read
    virtual TlsInfos* getchlo (InputStream* is) const;

    /// get a server hello message by state
    /// @param sta the tls state
    virtual TlsMessage* getshlo (TlsState* sta) const;

    /// get a server hello chunk by state
    /// @param sta the tls state
    virtual TlsChunk toshlo (TlsState* sta) const;

  public:
    /// create a new object in a generic way
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// @return true if the given quark is defined
    bool isquark (const long quark, const bool hflg) const;
    
    /// apply this object with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
  };
}

#endif
