#ifndef	__ATR_H__
#define	__ATR_H__

#define ATR_TS_CONVENTION_DIRECT	(0x3B)
#define ATR_TS_CONVENTION_INVERSE	(0x3F)

#define ATR_TDI_INTERFACE(X)	((0xF0 & (X)) >> 4)
#define ATR_TDI_DATA(X)			(0x0F & (X))
#define ATR_TDI_TA_MASK			(0x10)
#define ATR_TDI_TB_MASK			(0x20)
#define ATR_TDI_TC_MASK			(0x40)
#define ATR_TDI_TD_MASK			(0x80)

#define ATR_TDI_PROTO_T0		(0)
#define ATR_TDI_PROTO_T1		(1)
#define ATR_TDI_PROTO_T2		(2)
#define ATR_TDI_PROTO_T3		(3)
#define ATR_TDI_PROTO_T14		(14)

#define ATR_TA1_FI(X)			((0xF0 & (X)) >> 4)
#define ATR_TA1_DI(X)			(0x0F & (X))
#define ATR_TB1_II(X)			((0x60 & (X)) >> 5)
#define ATR_TB1_PI1(X)			(0x1F & (X))
#define ATR_TC1_N(X)			(X)
#define ATR_TB2_PI2(X)			(X)

#endif	/* __ATR_H__ */
