!{\src2tex{textfont=tt}}
!!****f* ABINIT/wvl_outwf
!! NAME
!! wvl_outwf
!!
!! FUNCTION
!! Simple wrapper around the read/write disk methods of BigDFT for wavefunctions.
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DC)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  dtset <type(dataset_type)>=input variables.
!!  mpi_enreg=informations about MPI parallelization
!!  option= -2 for write with BigDFT format,
!!          -1 for reading wavelets coefficients with BigDFT format,
!!          2 for write,
!!          1 for read.
!!  rprimd(3,3)=dimensional primitive translations in real space (bohr)
!!  wff <type(wffile_type)>=struct info for wavefunction
!!  wfs <type(wvl_wf_type)>=wavefunctions informations for wavelets.
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!  xred(3,natom)=reduced dimensionless atomic coordinates (in fact IN but here
!!                because of INOUT xredxcart() behavior).
!!
!! PARENTS
!!
!! CHILDREN
!!
!! SOURCE
#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine wvl_rwwf(dtset, mpi_enreg, option, rprimd, wff, wfs, xred)

  use defs_basis
  use defs_datatypes
#if defined HAVE_BIGDFT
  use libbigdft
#endif

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_12geometry
#endif
!End of the abilint section

  implicit none

!Arguments -------------------------------
  !scalars
  integer, intent(in)                       :: option
  type(dataset_type), intent(in)            :: dtset
  type(MPI_type), intent(in)                :: mpi_enreg
  type(wffile_type),intent(in)              :: wff
  type(wvl_wf_type), intent(in)             :: wfs
  !arrays
  real(dp), intent(in)                      :: rprimd(3, 3)
  real(dp), intent(inout)                   :: xred(3, dtset%natom)

!Local variables-------------------------------
  character(len = 500)  :: message
  integer               :: iorb, iseg, jj, j0, j1, ii, i0, i1, i2, i3, buffer
  real(dp), allocatable :: xcart(:,:), psifscf(:,:,:)

  if (abs(option) > 2 .or. option == 0) then
    write(message,'(a,a,a,a,a,a,i5,a)') ch10,&
  &  ' wvl_rwwf : BUG -', ch10, &
  &  '  Option argument is wrong,', ch10, &
  &  '  awaited values are -2, -1, 1, 2 but option = ', option, '.'
    call wrtout(6,message,'PERS')
    call leave_new('PERS')
  end if

#if defined HAVE_BIGDFT
  ! Store xcart for each atom
  allocate(xcart(3, dtset%natom))
  call xredxcart(dtset%natom, 1, rprimd, xcart, xred)

  if (abs(option) == 2) then
    write(message, '(a,a,a,a)' ) ch10,&
      &  ' wvl_rwwf :  Write wavefunctions to file.'
    call wrtout(6,message,'COLL')

    if (option > 0) then
    ! MPI is not taken into account yet.
#if defined MPI
      write(message, '(a,a,a,a)' ) ch10,&
        &  ' wvl_rwwf :  no MPI implementation yet.'
      call wrtout(6,message,'COLL')
#else
      do iorb = 1, dtset%mband
        call writeonewave(wff%unwff, .false., iorb, dtset%wvl_internal%nSize(1), &
                        & dtset%wvl_internal%nSize(2), dtset%wvl_internal%nSize(3), &
                        & dtset%wvl_hgrid, xcart(:, 1), wfs%keys%nseg(0), wfs%keys%nvctr(0), &
                        & wfs%keys%keyg(1,1), wfs%keys%keyv(1), wfs%keys%nseg(1), &
                        & wfs%keys%nvctr(1), wfs%keys%keyg(1, wfs%keys%nseg(0) + 1), &
                        & wfs%keys%keyv(wfs%keys%nseg(0) + 1), wfs%psi(1, iorb), &
                        & wfs%psi(wfs%keys%nvctr(0) + 1, iorb), dtset%mband, wfs%eval)
      enddo
#endif
    else
      call  writemywaves(mpi_enreg%me, dtset%mband, wfs%mbandp, &
                       & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
                       & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid,dtset%natom, &
                       & xcart(:, 1), wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%nvctr(0), &
                       & wfs%keys%nvctr(1), wfs%keys%keyg, wfs%keys%keyv, wfs%psi, wfs%eval)
    end if
  else
    write(message, '(a,a,a,a)' ) ch10,&
      &  ' wvl_rwwf :  Read wavefunctions from file.'
    call wrtout(6,message,'COLL')

    if (option < 0) then
      call readmywaves(mpi_enreg%me, dtset%mband, wfs%mbandp, &
                     & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
                     & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid, dtset%natom, &
                     & xcart(:, 1), wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%nvctr(0), &
                     & wfs%keys%nvctr(1), wfs%keys%keyg, wfs%keys%keyv, wfs%psi, wfs%eval)
    else
#if defined MPI
      write(message, '(a,a,a,a)' ) ch10,&
        &  ' wvl_rwwf :  no MPI implementation yet.'
      call wrtout(6,message,'COLL')
#else
      buffer = dtset%wvl_internal%buffer
      allocate(psifscf(-buffer:2 * dtset%wvl_internal%nSize(1) + buffer + 1, &
                     & -buffer:2 * dtset%wvl_internal%nSize(2) + buffer + 1, &
                     & -buffer:2 * dtset%wvl_internal%nSize(3) + buffer + 1))
      do iorb = 1, dtset%mband
        call readonewave(wff%unwff, .false., iorb, mpi_enreg%me, &
                       & dtset%wvl_internal%nSize(1), dtset%wvl_internal%nSize(2), &
                       & dtset%wvl_internal%nSize(3), dtset%wvl_hgrid, &
                       & xcart(:, 1), wfs%keys%nseg(0), wfs%keys%nseg(1), wfs%keys%nvctr(0), &
                       & wfs%keys%nvctr(1), wfs%keys%keyg, wfs%keys%keyv, wfs%psi, &
                       & wfs%eval(iorb), psifscf)
      end do
      deallocate(psifscf)
#endif
    end if
  end if

  deallocate(xcart)

#else
  write(message, '(a,a,a,a)' ) ch10,&
    &  ' wvl_outwf : BigDFT library is not compiled.', ch10, &
    &  '   Action, used the flag --enable-bigdft when configuring.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
#endif
end subroutine wvl_rwwf
!!***
