/** BEGIN COPYRIGHT BLOCK
 * Copyright (c) 2016, William Brown <william at blackhats dot net dot au>
 * Copyright (c) 2017, Red Hat, Inc
 * All rights reserved.
 *
 * License: GPL (version 3 or any later version).
 * See LICENSE for details.
 * END COPYRIGHT BLOCK **/

#pragma once

#include <config.h>

/* As this is a test, we can access internal functions */
#include "../sds/sds_internal.h"
/* sds pulls in NSPR threads. */
#include <sds.h>

/* For cmocka */
#include <stdarg.h>
#include <stddef.h>
#include <setjmp.h>
#include <cmocka.h>

static const uint64_t fill_pattern[] = {
    228, 733, 609, 1378, 557, 199, 1336, 1923, 1813, 746, 52,
    1627, 586, 2048, 1749, 965, 625, 725, 1798, 393, 1551,
    212, 976, 1410, 1386, 491, 98, 1338, 1807, 967, 1984,
    1930, 604, 1873, 22, 1454, 90, 892, 455, 1389, 1727,
    33, 149, 937, 1236, 1080, 1883, 1291, 59, 1025, 1275,
    1495, 2027, 920, 1459, 537, 1768, 15, 1478, 352, 1834,
    415, 1784, 1036, 1272, 650, 642, 1366, 363, 1147, 813,
    1299, 1753, 1550, 784, 999, 1695, 46, 244, 1067, 2021,
    167, 949, 2039, 957, 1820, 1778, 648, 756, 242, 1644,
    256, 1351, 1027, 1899, 27, 408, 1402, 1189, 504, 2036,
    539, 800, 1713, 1659, 227, 342, 264, 1411, 689, 721,
    1171, 587, 1658, 524, 1207, 480, 250, 40, 1430, 1728,
    824, 887, 467, 731, 309, 344, 380, 1723, 80, 517,
    1408, 993, 81, 203, 1060, 1563, 618, 29, 1651, 1413,
    669, 1019, 340, 371, 1840, 1214, 23, 1481, 434, 1170,
    1349, 939, 2007, 894, 1155, 737, 1610, 160, 381, 1141,
    720, 1120, 1989, 1064, 1119, 569, 711, 1245, 961, 173,
    329, 575, 406, 312, 461, 483, 1731, 132, 61, 131,
    179, 940, 749, 1348, 1472, 1305, 521, 900, 1023, 64,
    253, 25, 245, 134, 912, 1122, 1540, 2, 841, 876,
    1079, 602, 728, 570, 213, 450, 508, 1864, 295, 1669,
    968, 1851, 845, 424, 1316, 759, 1814, 1487, 1881, 1645,
    1029, 278, 335, 1174, 207, 493, 787, 1920, 34, 1740,
    496, 1670, 1002, 632, 185, 916, 563, 1854, 2000, 1446,
    68, 812, 275, 1641, 2046, 477, 1846, 910, 703, 782,
    159, 502, 91, 1453, 1146, 655, 2020, 1936, 272, 1957,
    1145, 44, 1637, 1463, 536, 1912, 1694, 909, 966, 722,
    718, 1300, 511, 1745, 444, 1942, 796, 786, 1357, 1867,
    10, 1896, 931, 922, 633, 290, 1123, 1907, 1847, 427,
    1092, 1737, 305, 530, 260, 1314, 1802, 1556, 30, 992,
    1032, 631, 304, 154, 1368, 1973, 1842, 284, 1783, 8,
    825, 1096, 811, 1250, 901, 3, 1566, 779, 1751, 468,
    77, 667, 2014, 1871, 1022, 666, 761, 1771, 1330, 783,
    608, 1581, 899, 1279, 127, 798, 872, 1473, 616, 1634,
    1138, 1307, 259, 1904, 686, 691, 1894, 1206, 1738, 141,
    190, 930, 1360, 762, 1801, 1557, 334, 1108, 1661, 988,
    274, 1457, 1815, 1782, 556, 488, 1827, 1282, 1543, 1926,
    479, 1996, 54, 736, 208, 573, 1082, 1417, 1441, 1034,
    1167, 528, 1701, 1442, 600, 515, 1301, 1986, 1010, 1296,
    1828, 647, 1427, 1475, 1278, 1447, 1256, 2031, 147, 2004,
    1042, 1900, 804, 869, 1676, 417, 1180, 551, 463, 1704,
    1139, 1028, 1335, 1571, 1260, 1735, 280, 247, 1437, 1104,
    808, 588, 1165, 1517, 140, 1483, 1588, 217, 365, 287,
    1614, 929, 485, 165, 2015, 1761, 1906, 323, 898, 1401,
    744, 170, 1602, 1126, 979, 447, 617, 1003, 1561, 1154,
    820, 959, 1486, 109, 1725, 238, 357, 534, 1748, 326,
    896, 391, 1529, 1844, 1511, 1241, 1083, 1097, 702, 341,
    246, 1237, 1322, 1574, 1075, 1849, 889, 236, 1233, 1056,
    1204, 1806, 1202, 821, 1488, 1549, 378, 85, 1916, 1391,
    1963, 232, 1302, 644, 270, 148, 1346, 809, 1952, 801,
    1375, 603, 704, 392, 1730, 1334, 1266, 1880, 1223, 1193,
    13, 390, 1555, 478, 1177, 1332, 1796, 578, 1211, 71,
    111, 1600, 1931, 535, 1705, 1319, 161, 300, 394, 1823,
    982, 369, 1825, 1527, 1608, 571, 765, 310, 1777, 1858,
    1054, 2042, 197, 429, 1303, 301, 1393, 302, 994, 1743,
    1325, 1121, 1091, 1979, 1344, 73, 271, 420, 874, 1045,
    220, 51, 695, 269, 303, 748, 1927, 60, 1809, 316,
    1166, 1255, 1978, 268, 281, 1598, 676, 581, 443, 932,
    1756, 481, 826, 1940, 810, 1093, 706, 1653, 1431, 1682,
    938, 1812, 1741, 1595, 672, 550, 2008, 86, 286, 1294,
    1132, 2032, 997, 291, 198, 1271, 31, 193, 645, 1364,
    1535, 2043, 265, 990, 1498, 971, 1714, 12, 599, 1901,
    115, 375, 1425, 509, 1337, 318, 1893, 120, 1020, 423,
    919, 414, 950, 687, 531, 331, 1863, 1175, 646, 584,
    1966, 1955, 1070, 56, 168, 1585, 1734, 4, 317, 1151,
    172, 1674, 1520, 1818, 441, 1173, 1994, 1345, 221, 1482,
    547, 1125, 911, 1217, 856, 405, 261, 693, 1762, 996,
    1788, 1573, 1012, 1760, 738, 2030, 1496, 713, 107, 730,
    482, 2037, 297, 1981, 991, 776, 320, 324, 1681, 129,
    745, 1639, 636, 473, 1073, 903, 1014, 1958, 285, 1219,
    2019, 816, 158, 254, 1186, 1850, 249, 873, 723, 498,
    205, 1168, 1909, 2041, 1076, 1631, 946, 337, 1052, 546,
    955, 1911, 1274, 1515, 14, 163, 214, 572, 1747, 1522,
    258, 1934, 1974, 1688, 610, 146, 960, 1763, 1578, 562,
    1239, 1772, 1668, 418, 958, 1800, 1293, 138, 918, 65,
    592, 799, 567, 189, 327, 519, 888, 1633, 640, 865,
    492, 1292, 1397, 1306, 308, 162, 364, 1359, 1856, 1356,
    1594, 1793, 2040, 935, 1228, 1387, 554, 266, 1804, 1616,
    1604, 1882, 1666, 123, 1304, 682, 332, 1650, 630, 1757,
    186, 235, 1130, 755, 1980, 945, 74, 1510, 928, 1703,
    1606, 1680, 815, 624, 1059, 1774, 741, 72, 1265, 1350,
    360, 1371, 2012, 897, 438, 696, 215, 514, 1833, 1379,
    2035, 986, 456, 607, 1114, 840, 428, 1891, 560, 1131,
    1548, 1824, 1617, 501, 917, 1532, 906, 516, 1908, 1309,
    1838, 1505, 1438, 777, 1494, 382, 1892, 495, 1328, 1176,
    1895, 83, 585, 1528, 1231, 211, 1465, 1181, 1716, 1164,
    942, 895, 276, 1044, 1497, 1832, 401, 1226, 1506, 1967,
    506, 1063, 1158, 1200, 1358, 1944, 359, 1609, 397, 1201,
    1455, 407, 35, 1816, 757, 987, 1765, 319, 2009, 716,
    1374, 1440, 1311, 781, 1865, 753, 1196, 606, 933, 176,
    1501, 591, 1577, 1085, 1331, 980, 1640, 353, 1137, 1112,
    683, 101, 837, 178, 1057, 223, 41, 1711, 827, 1143,
    70, 1157, 1046, 17, 828, 50, 1699, 1767, 1537, 1766,
    859, 500, 187, 886, 844, 1719, 760, 1461, 1503, 1603,
    1988, 1959, 377, 1519, 1822, 834, 1229, 1776, 383, 838,
    2024, 622, 767, 1995, 1932, 660, 1103, 1182, 37, 24,
    2017, 1596, 1960, 409, 734, 1968, 82, 273, 63, 2010,
    294, 677, 1474, 1471, 263, 2038, 878, 1534, 806, 1915,
    1235, 538, 105, 1615, 1087, 1150, 1491, 315, 1586, 936,
    1283, 1857, 1590, 1785, 1848, 1227, 764, 1780, 1448, 1853,
    1597, 210, 32, 333, 1937, 1726, 425, 1710, 321, 439,
    1775, 589, 962, 177, 754, 457, 1671, 1791, 802, 975,
    1184, 1140, 1524, 842, 251, 1246, 830, 2044, 543, 541,
    21, 11, 156, 778, 1855, 67, 373, 1149, 1953, 2016,
    1006, 1038, 1078, 151, 772, 1589, 78, 1352, 1933, 1289,
    143, 1429, 1746, 121, 128, 823, 1285, 1982, 1127, 116,
    1514, 1403, 981, 1116, 1493, 867, 346, 657, 513, 857,
    794, 1221, 153, 1706, 870, 1476, 671, 1192, 1764, 18,
    311, 413, 793, 386, 1339, 1913, 1872, 367, 113, 1545,
    1071, 137, 1015, 583, 117, 1972, 7, 1910, 1340, 1,
    440, 714, 1592, 240, 1373, 370, 133, 750, 1251, 442,
    1468, 350, 194, 614, 1888, 605, 419, 489, 1423, 2022,
    1317, 1412, 1587, 1144, 673, 1742, 849, 1656, 1134, 1017,
    1224, 885, 277, 1618, 152, 345, 927, 601, 196, 1612,
    1404, 701, 1055, 1678, 595, 855, 1329, 1372, 995, 969,
    307, 1754, 752, 510, 431, 1267, 1242, 1993, 1752, 708,
    1030, 2028, 1464, 1570, 792, 1861, 1831, 1194, 97, 1712,
    94, 1392, 330, 879, 453, 1432, 226, 130, 1810, 1792,
    314, 789, 768, 566, 349, 921, 598, 1405, 1361, 108,
    1286, 1579, 835, 1985, 1380, 831, 829, 36, 1443, 1069,
    619, 1948, 656, 2005, 1225, 1435, 1469, 1919, 1409, 641,
    1420, 1105, 222, 445, 780, 758, 282, 279, 1560, 1835,
    1922, 28, 807, 850, 529, 412, 685, 1542, 1086, 890,
    1377, 627, 882, 233, 239, 459, 395, 1638, 1708, 1956,
    1925, 1877, 1885, 1884, 1859, 1580, 104, 1252, 195, 1287,
    55, 1866, 1684, 1280, 296, 712, 663, 466, 175, 1347,
    432, 125, 1647, 1257, 293, 1794, 1068, 361, 1315, 1721,
    593, 1009, 1945, 372, 1691, 1965, 805, 1779, 1526, 1210,
    1733, 426, 1621, 926, 525, 19, 1018, 1890, 523, 1613,
    1685, 1547, 388, 39, 1383, 1162, 1142, 1717, 1421, 9,
    449, 545, 1553, 1698, 1795, 42, 1565, 1696, 1268, 313,
    180, 662, 751, 1318, 652, 1830, 1789, 1269, 854, 1281,
    1253, 1004, 26, 1109, 1041, 1605, 1664, 1270, 1797, 1961,
    775, 1450, 891, 1718, 2001, 774, 858, 559, 1939, 549,
    649, 710, 628, 880, 1593, 1692, 181, 680, 124, 1124,
    717, 952, 871, 1102, 819, 668, 629, 1954, 1662, 1720,
    1049, 1084, 836, 171, 1136, 20, 1039, 568, 1456, 913,
    1660, 1999, 1254, 174, 1876, 1969, 970, 1462, 1636, 1218,
    675, 1635, 1394, 1400, 1178, 1509, 574, 1657, 1277, 1048,
    1887, 1769, 1817, 1037, 183, 2034, 289, 1451, 953, 150,
    403, 1406, 715, 38, 100, 288, 1354, 505, 1655, 499,
    2003, 476, 1924, 306, 1205, 1786, 1554, 729, 788, 881,
    1536, 338, 743, 348, 435, 1739, 1943, 1024, 623, 1539,
    1467, 542, 1466, 520, 1169, 472, 206, 1997, 1642, 219,
    1929, 1874, 135, 358, 1117, 925, 1860, 1047, 1051, 1365,
    956, 1363, 487, 1416, 1544, 1234, 1852, 112, 79, 561,
    1342, 963, 1507, 1513, 1398, 87, 1376, 355, 1693, 1290,
    742, 368, 118, 1652, 615, 106, 579, 690, 564, 907,
    1709, 1917, 325, 1106, 853, 490, 1343, 1284, 351, 1643,
    1886, 157, 416, 1026, 69, 1583, 470, 732, 1248, 1750,
    421, 1977, 654, 433, 773, 1263, 1230, 847, 791, 766,
    1115, 822, 1148, 1439, 1458, 1575, 565, 1369, 1690, 664,
    1665, 540, 136, 402, 544, 612, 503, 851, 1646, 1499,
    1869, 92, 404, 972, 1222, 1203, 863, 954, 1732, 1552,
    1770, 1001, 674, 884, 653, 234, 1031, 1259, 923, 552,
    1836, 1619, 1110, 191, 611, 446, 267, 1686, 621, 984,
    57, 532, 555, 613, 1500, 142, 1837, 1232, 110, 202,
    88, 839, 861, 1562, 396, 848, 1135, 670, 1898, 707,
    1722, 1428, 243, 356, 1090, 184, 2023, 1632, 1970, 1485,
    255, 1213, 1799, 576, 1264, 47, 1099, 705, 43, 1902,
    458, 229, 398, 1702, 1990, 1628, 989, 724, 924, 494,
    678, 230, 1161, 460, 1208, 1490, 1790, 2026, 1601, 484,
    299, 908, 727, 1889, 1053, 771, 684, 95, 139, 292,
    634, 1313, 1492, 941, 1673, 1384, 1611, 643, 651, 1436,
    1370, 580, 1333, 1683, 354, 1470, 1629, 1950, 1841, 1353,
    1622, 1811, 679, 1724, 1700, 699, 1191, 218, 1964, 1321,
    1000, 843, 6, 1288, 1007, 166, 1875, 1821, 475, 507,
    934, 436, 1396, 96, 665, 53, 1947, 1489, 1133, 735,
    1667, 1172, 1247, 1385, 533, 883, 1035, 1582, 1541, 597,
    797, 1829, 328, 1061, 1878, 1759, 527, 1198, 366, 1599,
    558, 1159, 688, 1195, 769, 1212, 582, 1298, 1697, 114,
    1382, 943, 548, 1649, 1043, 2033, 1016, 739, 590, 1521,
    437, 339, 1216, 1843, 122, 893, 1308, 983, 661, 486,
    248, 1533, 1094, 1341, 697, 868, 1390, 2047, 1576, 1518,
    465, 692, 1074, 902, 1179, 977, 1238, 1679, 1187, 1558,
    1962, 164, 905, 596, 322, 914, 1689, 1367, 1323, 1987,
    1433, 1938, 1951, 817, 1773, 638, 512, 948, 16, 66,
    430, 833, 1197, 192, 1715, 1868, 283, 985, 577, 1081,
    1591, 1415, 237, 410, 169, 1569, 336, 862, 2045, 1531,
    1504, 1559, 451, 1484, 639, 1062, 1946, 1477, 1584, 2018,
    526, 224, 1381, 462, 1903, 1209, 1240, 864, 1879, 1199,
    1327, 1419, 1118, 1156, 103, 464, 1626, 1185, 1624, 387,
    469, 376, 1065, 522, 1564, 1625, 1452, 1516, 637, 1460,
    973, 852, 144, 1422, 1983, 1426, 200, 1630, 343, 2029,
    145, 1755, 1258, 1005, 620, 681, 964, 1100, 58, 1101,
    1273, 866, 49, 102, 1424, 1648, 846, 832, 814, 944,
    1066, 225, 700, 1434, 201, 594, 298, 785, 726, 1736,
    182, 1687, 1941, 763, 658, 1538, 1826, 635, 818, 1107,
    1153, 1914, 1928, 1805, 1152, 1758, 1310, 1444, 422, 1215,
    1183, 709, 1355, 262, 1033, 1992, 1480, 1249, 385, 1244,
    1449, 974, 1512, 1523, 1572, 209, 1414, 803, 204, 1479,
    1220, 1445, 1188, 1971, 399, 1295, 1088, 626, 1297, 694,
    1975, 1008, 1677, 1276, 93, 347, 1654, 947, 1672, 1502,
    1839, 1089, 252, 1530, 860, 379, 1976, 400, 231, 241,
    553, 48, 719, 1508, 1707, 76, 877, 740, 1781, 471,
    1568, 45, 1819, 2002, 978, 1905, 2011, 1395, 951, 155,
    1918, 1620, 1803, 452, 126, 698, 1129, 1095, 1261, 84,
    2013, 1163, 1312, 5, 1160, 1072, 1949, 374, 1808, 747,
    1663, 1011, 1998, 1190, 62, 216, 1546, 1058, 875, 1991,
    2025, 119, 1388, 389, 1845, 1623, 89, 1729, 790, 474,
    1324, 1525, 257, 1128, 1607, 904, 188, 2006, 1113, 497,
    1935, 1567, 1326, 448, 362, 1111, 1399, 1262, 1320, 1362,
    1870, 75, 1243, 454, 1407, 770, 1418, 518, 1897, 1921,
    795, 99, 915, 1787, 1013, 659, 1040, 411, 1862, 1675,
    1050, 1021, 1098, 1744, 384, 998, 1077,
};

static const uint64_t load_array[] = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64};

/* Test runners */
int run_bpt_tests(void);
int run_set_tests(void);
int run_cow_tests(void);
int run_queue_tests(void);
int run_tqueue_tests(void);
int run_lqueue_tests(void);
int run_siphash_tests(void);
int run_ht_tests(void);

/* fixtures */
int bptree_test_setup(void **state);
int bptree_str_test_setup(void **state);
int bptree_test_teardown(void **state);

int bptree_test_set_setup(void **state);
int bptree_test_set_teardown(void **state);

int bptree_test_cow_setup(void **state);
int bptree_test_cow_teardown(void **state);

int queue_test_setup(void **state);
int queue_test_teardown(void **state);

int tqueue_test_setup(void **state);
int tqueue_test_teardown(void **state);

int lqueue_test_setup(void **state);
int lqueue_test_teardown(void **state);

int ht_test_setup(void **state);
int ht_test_teardown(void **state);
