/** BEGIN COPYRIGHT BLOCK
 * Copyright (C) 2001 Sun Microsystems, Inc. Used by permission.
 * Copyright (C) 2005 Red Hat, Inc.
 * All rights reserved.
 *
 * License: GPL (version 3 or any later version).
 * See LICENSE for details.
 * END COPYRIGHT BLOCK **/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* cleanup.c - cleans up ldbm backend */

#include "back-ldbm.h"

int
ldbm_back_cleanup(Slapi_PBlock *pb)
{
    struct ldbminfo *li;
    Slapi_Backend *be;

    slapi_log_err(SLAPI_LOG_TRACE, "ldbm_back_cleanup", "ldbm backend cleaning up\n");
    slapi_pblock_get(pb, SLAPI_PLUGIN_PRIVATE, &li);
    slapi_pblock_get(pb, SLAPI_BACKEND, &be);

    if (be->be_state != BE_STATE_STOPPED &&
        be->be_state != BE_STATE_DELETED) {
        slapi_log_err(SLAPI_LOG_TRACE,
                      "ldbm_back_cleanup", "Warning - backend is in a wrong state - %d\n",
                      be->be_state);
        return 0;
    }

    PR_Lock(be->be_state_lock);

    if (be->be_state != BE_STATE_STOPPED &&
        be->be_state != BE_STATE_DELETED) {
        slapi_log_err(SLAPI_LOG_TRACE,
                      "ldbm_back_cleanup", "Warning - backend is in a wrong state - %d\n",
                      be->be_state);
        PR_Unlock(be->be_state_lock);
        return 0;
    }

    /*
     * We check if li is NULL. Because of an issue in how we create backends
     * we share the li and plugin info between many unique backends. This causes
     * be_cleanall to try to trigger this multiple times. But we don't need to!
     * dblayer_terminate is sufficent to be called once for each instance of
     * ldbminfo. This protects us from heap use after frees while still cleaning
     * up. Ultimately, it's a flaw in how ldbm can have many backends, but for
     * "one" plugin.
     */
    if (li != NULL) {

        dblayer_terminate(li);

        /* JCM I tried adding this to tidy up memory on shutdown. */
        /* JCM But, the result was very messy. */
        objset_delete(&(li->li_instance_set));

        ldbm_config_destroy(li);

        slapi_pblock_set(pb, SLAPI_PLUGIN_PRIVATE, NULL);
    }

    be->be_state = BE_STATE_CLEANED;

    PR_Unlock(be->be_state_lock);

    return 0;
}
