#!/bin/sh
set -o errexit

###
# Copyright © 2015-2022, Antoine Le Gonidec <vv221@dotslashplay.it>
# Copyright © 2021-2022, Anna Lea
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Whispering Willows
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220125.4

# Set game-specific variables

GAME_ID='whispering-willows'
GAME_NAME='Whispering Willows'

ARCHIVE_BASE_FIREFLOWER_0='Whispering_Willows_1_27_Linux.zip'
ARCHIVE_BASE_FIREFLOWER_0_MD5='5ca10433c0da315028d8318e39fb3ad2'
ARCHIVE_BASE_FIREFLOWER_0_SIZE='2000000'
ARCHIVE_BASE_FIREFLOWER_0_VERSION='1.27-fireflower'
ARCHIVE_BASE_FIREFLOWER_0_URL='https://fireflowergames.com/products/whispering-willows'

ARCHIVE_BASE_HUMBLE_0='LINUX_NO_STEAM.rar'
ARCHIVE_BASE_HUMBLE_0_MD5='56c078a0208769ab2222f7e1cc0e0d57'
ARCHIVE_BASE_HUMBLE_0_SIZE='1900000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.26-humble151125'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/whispering-willows'

UNITY3D_NAME='WhisperingWillows'

CONTENT_PATH_DEFAULT_FIREFLOWER='.'
CONTENT_PATH_DEFAULT_HUMBLE='LINUX_NO_STEAM'
ARCHIVE_GAME_BIN32_FILES="
${UNITY3D_NAME}.x86
${UNITY3D_NAME}_Data/Mono/x86
${UNITY3D_NAME}_Data/Plugins/x86"
ARCHIVE_GAME_BIN64_FILES="
${UNITY3D_NAME}.x86_64
${UNITY3D_NAME}_Data/Mono/x86_64
${UNITY3D_NAME}_Data/Plugins/x86_64"
ARCHIVE_GAME_DATA_FILES="
${UNITY3D_NAME}_Data"

PACKAGES_LIST='PKG_BIN32 PKG_BIN64 PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN32_ARCH='32'
PKG_BIN32_DEPS="$PKG_DATA_ID libc.so.6 libstdc++.so.6 libGLU.so.1 libGL.so.1 libX11.so.6 libgtk-x11-2.0.so.0 libgdk_pixbuf-2.0.so.0 libgobject-2.0.so.0 libglib-2.0.so.0 xcursor libxrandr"

PKG_BIN64_ARCH='64'
PKG_BIN64_DEPS="$PKG_BIN32_DEPS"

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Get game icon

PKG='PKG_DATA'
icons_get_from_package 'APP_MAIN'

# Clean up temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Write launchers

for PKG in 'PKG_BIN32' 'PKG_BIN64'; do
	launchers_write 'APP_MAIN'
done

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "${PLAYIT_WORKDIR}"

# Print instructions

print_instructions

exit 0
