/*###############################################################################
# Linux Management Providers (LMP), Physical Asset provider package
# Copyright (C) 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_CARD_H_
#define OPENDRIM_CARD_H_

#include <Instance.h>

const static char* OpenDRIM_Card_classnames[] = {"OpenDRIM_Card"};
static string OpenDRIM_Card_NAMESPACE = _NAMESPACE;

class OpenDRIM_Card {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string InstallDate;
	bool InstallDate_isNULL;
	
	string Name;
	bool Name_isNULL;
	
	vector<unsigned short> OperationalStatus;
	bool OperationalStatus_isNULL;
	
	vector<string> StatusDescriptions;
	bool StatusDescriptions_isNULL;
	
	string Status;
	bool Status_isNULL;
	
	unsigned short HealthState;
	bool HealthState_isNULL;
	
	unsigned short PrimaryStatus;
	bool PrimaryStatus_isNULL;
	
	unsigned short DetailedStatus;
	bool DetailedStatus_isNULL;
	
	unsigned short OperatingStatus;
	bool OperatingStatus_isNULL;
	
	unsigned short CommunicationStatus;
	bool CommunicationStatus_isNULL;
	
	string Tag;
	bool Tag_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string CreationClassName;
	bool CreationClassName_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string Manufacturer;
	bool Manufacturer_isNULL;
	
	string Model;
	bool Model_isNULL;
	
	string SKU;
	bool SKU_isNULL;
	
	string SerialNumber;
	bool SerialNumber_isNULL;
	
	string Version;
	bool Version_isNULL;
	
	string PartNumber;
	bool PartNumber_isNULL;
	
	string OtherIdentifyingInfo;
	bool OtherIdentifyingInfo_isNULL;
	
	bool PoweredOn;
	bool PoweredOn_isNULL;
	
	string ManufactureDate;
	bool ManufactureDate_isNULL;
	
	string VendorEquipmentType;
	bool VendorEquipmentType_isNULL;
	
	string UserTracking;
	bool UserTracking_isNULL;
	
	bool CanBeFRUed;
	bool CanBeFRUed_isNULL;
	
	unsigned short RemovalConditions;
	bool RemovalConditions_isNULL;
	
	bool Removable;
	bool Removable_isNULL;
	
	bool Replaceable;
	bool Replaceable_isNULL;
	
	bool HotSwappable;
	bool HotSwappable_isNULL;
	
	float Height;
	bool Height_isNULL;
	
	float Depth;
	bool Depth_isNULL;
	
	float Width;
	bool Width_isNULL;
	
	float Weight;
	bool Weight_isNULL;
	
	unsigned short PackageType;
	bool PackageType_isNULL;
	
	string OtherPackageType;
	bool OtherPackageType_isNULL;
	
	vector<string> VendorCompatibilityStrings;
	bool VendorCompatibilityStrings_isNULL;
	
	bool HostingBoard;
	bool HostingBoard_isNULL;
	
	string SlotLayout;
	bool SlotLayout_isNULL;
	
	bool RequiresDaughterBoard;
	bool RequiresDaughterBoard_isNULL;
	
	bool SpecialRequirements;
	bool SpecialRequirements_isNULL;
	
	string RequirementsDescription;
	bool RequirementsDescription_isNULL;
	
	vector<short> OperatingVoltages;
	bool OperatingVoltages_isNULL;
	
	OpenDRIM_Card() {
		Caption_isNULL = true;
		InstallDate_isNULL = true;
		Name_isNULL = true;
		OperationalStatus_isNULL = true;
		StatusDescriptions_isNULL = true;
		Status_isNULL = true;
		HealthState_isNULL = true;
		PrimaryStatus_isNULL = true;
		DetailedStatus_isNULL = true;
		OperatingStatus_isNULL = true;
		CommunicationStatus_isNULL = true;
		Tag_isNULL = true;
		Description_isNULL = true;
		CreationClassName_isNULL = true;
		ElementName_isNULL = true;
		Manufacturer_isNULL = true;
		Model_isNULL = true;
		SKU_isNULL = true;
		SerialNumber_isNULL = true;
		Version_isNULL = true;
		PartNumber_isNULL = true;
		OtherIdentifyingInfo_isNULL = true;
		PoweredOn_isNULL = true;
		ManufactureDate_isNULL = true;
		VendorEquipmentType_isNULL = true;
		UserTracking_isNULL = true;
		CanBeFRUed_isNULL = true;
		RemovalConditions_isNULL = true;
		Removable_isNULL = true;
		Replaceable_isNULL = true;
		HotSwappable_isNULL = true;
		Height_isNULL = true;
		Depth_isNULL = true;
		Width_isNULL = true;
		Weight_isNULL = true;
		PackageType_isNULL = true;
		OtherPackageType_isNULL = true;
		VendorCompatibilityStrings_isNULL = true;
		HostingBoard_isNULL = true;
		SlotLayout_isNULL = true;
		RequiresDaughterBoard_isNULL = true;
		SpecialRequirements_isNULL = true;
		RequirementsDescription_isNULL = true;
		OperatingVoltages_isNULL = true;
	}
	
	~OpenDRIM_Card() {}
	
	string getKeys() const {
		return CF_toLowCase(".Tag=\"" + CF_quoteString(Tag) + "\""".CreationClassName=\"" + CF_quoteString(CreationClassName) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getInstallDate(string& value) const {
		if (InstallDate_isNULL==true)
			return NOT_FOUND;
		value = InstallDate;
		return OK;
	}
	
	int setInstallDate(const string& newValue) {
		InstallDate = newValue;
		InstallDate_isNULL = false;
		return OK;
	}

	int getName(string& value) const {
		if (Name_isNULL==true)
			return NOT_FOUND;
		value = Name;
		return OK;
	}
	
	int setName(const string& newValue) {
		Name = newValue;
		Name_isNULL = false;
		return OK;
	}

	int getOperationalStatus(vector<unsigned short>& value) const {
		if (OperationalStatus_isNULL==true)
			return NOT_FOUND;
		value = OperationalStatus;
		return OK;
	}
	
	int setOperationalStatus(const vector<unsigned short>& newValue) {
		OperationalStatus = newValue;
		OperationalStatus_isNULL = false;
		return OK;
	}

	int getStatusDescriptions(vector<string>& value) const {
		if (StatusDescriptions_isNULL==true)
			return NOT_FOUND;
		value = StatusDescriptions;
		return OK;
	}
	
	int setStatusDescriptions(const vector<string>& newValue) {
		StatusDescriptions = newValue;
		StatusDescriptions_isNULL = false;
		return OK;
	}

	int getStatus(string& value) const {
		if (Status_isNULL==true)
			return NOT_FOUND;
		value = Status;
		return OK;
	}
	
	int setStatus(const string& newValue) {
		Status = newValue;
		Status_isNULL = false;
		return OK;
	}

	int getHealthState(unsigned short& value) const {
		if (HealthState_isNULL==true)
			return NOT_FOUND;
		value = HealthState;
		return OK;
	}
	
	int setHealthState(const unsigned short& newValue) {
		HealthState = newValue;
		HealthState_isNULL = false;
		return OK;
	}

	int getPrimaryStatus(unsigned short& value) const {
		if (PrimaryStatus_isNULL==true)
			return NOT_FOUND;
		value = PrimaryStatus;
		return OK;
	}
	
	int setPrimaryStatus(const unsigned short& newValue) {
		PrimaryStatus = newValue;
		PrimaryStatus_isNULL = false;
		return OK;
	}

	int getDetailedStatus(unsigned short& value) const {
		if (DetailedStatus_isNULL==true)
			return NOT_FOUND;
		value = DetailedStatus;
		return OK;
	}
	
	int setDetailedStatus(const unsigned short& newValue) {
		DetailedStatus = newValue;
		DetailedStatus_isNULL = false;
		return OK;
	}

	int getOperatingStatus(unsigned short& value) const {
		if (OperatingStatus_isNULL==true)
			return NOT_FOUND;
		value = OperatingStatus;
		return OK;
	}
	
	int setOperatingStatus(const unsigned short& newValue) {
		OperatingStatus = newValue;
		OperatingStatus_isNULL = false;
		return OK;
	}

	int getCommunicationStatus(unsigned short& value) const {
		if (CommunicationStatus_isNULL==true)
			return NOT_FOUND;
		value = CommunicationStatus;
		return OK;
	}
	
	int setCommunicationStatus(const unsigned short& newValue) {
		CommunicationStatus = newValue;
		CommunicationStatus_isNULL = false;
		return OK;
	}

	int getTag(string& value) const {
		if (Tag_isNULL==true)
			return NOT_FOUND;
		value = Tag;
		return OK;
	}
	
	int setTag(const string& newValue) {
		Tag = newValue;
		Tag_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getCreationClassName(string& value) const {
		if (CreationClassName_isNULL==true)
			return NOT_FOUND;
		value = CreationClassName;
		return OK;
	}
	
	int setCreationClassName(const string& newValue) {
		CreationClassName = newValue;
		CreationClassName_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getManufacturer(string& value) const {
		if (Manufacturer_isNULL==true)
			return NOT_FOUND;
		value = Manufacturer;
		return OK;
	}
	
	int setManufacturer(const string& newValue) {
		Manufacturer = newValue;
		Manufacturer_isNULL = false;
		return OK;
	}

	int getModel(string& value) const {
		if (Model_isNULL==true)
			return NOT_FOUND;
		value = Model;
		return OK;
	}
	
	int setModel(const string& newValue) {
		Model = newValue;
		Model_isNULL = false;
		return OK;
	}

	int getSKU(string& value) const {
		if (SKU_isNULL==true)
			return NOT_FOUND;
		value = SKU;
		return OK;
	}
	
	int setSKU(const string& newValue) {
		SKU = newValue;
		SKU_isNULL = false;
		return OK;
	}

	int getSerialNumber(string& value) const {
		if (SerialNumber_isNULL==true)
			return NOT_FOUND;
		value = SerialNumber;
		return OK;
	}
	
	int setSerialNumber(const string& newValue) {
		SerialNumber = newValue;
		SerialNumber_isNULL = false;
		return OK;
	}

	int getVersion(string& value) const {
		if (Version_isNULL==true)
			return NOT_FOUND;
		value = Version;
		return OK;
	}
	
	int setVersion(const string& newValue) {
		Version = newValue;
		Version_isNULL = false;
		return OK;
	}

	int getPartNumber(string& value) const {
		if (PartNumber_isNULL==true)
			return NOT_FOUND;
		value = PartNumber;
		return OK;
	}
	
	int setPartNumber(const string& newValue) {
		PartNumber = newValue;
		PartNumber_isNULL = false;
		return OK;
	}

	int getOtherIdentifyingInfo(string& value) const {
		if (OtherIdentifyingInfo_isNULL==true)
			return NOT_FOUND;
		value = OtherIdentifyingInfo;
		return OK;
	}
	
	int setOtherIdentifyingInfo(const string& newValue) {
		OtherIdentifyingInfo = newValue;
		OtherIdentifyingInfo_isNULL = false;
		return OK;
	}

	int getPoweredOn(bool& value) const {
		if (PoweredOn_isNULL==true)
			return NOT_FOUND;
		value = PoweredOn;
		return OK;
	}
	
	int setPoweredOn(const bool& newValue) {
		PoweredOn = newValue;
		PoweredOn_isNULL = false;
		return OK;
	}

	int getManufactureDate(string& value) const {
		if (ManufactureDate_isNULL==true)
			return NOT_FOUND;
		value = ManufactureDate;
		return OK;
	}
	
	int setManufactureDate(const string& newValue) {
		ManufactureDate = newValue;
		ManufactureDate_isNULL = false;
		return OK;
	}

	int getVendorEquipmentType(string& value) const {
		if (VendorEquipmentType_isNULL==true)
			return NOT_FOUND;
		value = VendorEquipmentType;
		return OK;
	}
	
	int setVendorEquipmentType(const string& newValue) {
		VendorEquipmentType = newValue;
		VendorEquipmentType_isNULL = false;
		return OK;
	}

	int getUserTracking(string& value) const {
		if (UserTracking_isNULL==true)
			return NOT_FOUND;
		value = UserTracking;
		return OK;
	}
	
	int setUserTracking(const string& newValue) {
		UserTracking = newValue;
		UserTracking_isNULL = false;
		return OK;
	}

	int getCanBeFRUed(bool& value) const {
		if (CanBeFRUed_isNULL==true)
			return NOT_FOUND;
		value = CanBeFRUed;
		return OK;
	}
	
	int setCanBeFRUed(const bool& newValue) {
		CanBeFRUed = newValue;
		CanBeFRUed_isNULL = false;
		return OK;
	}

	int getRemovalConditions(unsigned short& value) const {
		if (RemovalConditions_isNULL==true)
			return NOT_FOUND;
		value = RemovalConditions;
		return OK;
	}
	
	int setRemovalConditions(const unsigned short& newValue) {
		RemovalConditions = newValue;
		RemovalConditions_isNULL = false;
		return OK;
	}

	int getRemovable(bool& value) const {
		if (Removable_isNULL==true)
			return NOT_FOUND;
		value = Removable;
		return OK;
	}
	
	int setRemovable(const bool& newValue) {
		Removable = newValue;
		Removable_isNULL = false;
		return OK;
	}

	int getReplaceable(bool& value) const {
		if (Replaceable_isNULL==true)
			return NOT_FOUND;
		value = Replaceable;
		return OK;
	}
	
	int setReplaceable(const bool& newValue) {
		Replaceable = newValue;
		Replaceable_isNULL = false;
		return OK;
	}

	int getHotSwappable(bool& value) const {
		if (HotSwappable_isNULL==true)
			return NOT_FOUND;
		value = HotSwappable;
		return OK;
	}
	
	int setHotSwappable(const bool& newValue) {
		HotSwappable = newValue;
		HotSwappable_isNULL = false;
		return OK;
	}

	int getHeight(float& value) const {
		if (Height_isNULL==true)
			return NOT_FOUND;
		value = Height;
		return OK;
	}
	
	int setHeight(const float& newValue) {
		Height = newValue;
		Height_isNULL = false;
		return OK;
	}

	int getDepth(float& value) const {
		if (Depth_isNULL==true)
			return NOT_FOUND;
		value = Depth;
		return OK;
	}
	
	int setDepth(const float& newValue) {
		Depth = newValue;
		Depth_isNULL = false;
		return OK;
	}

	int getWidth(float& value) const {
		if (Width_isNULL==true)
			return NOT_FOUND;
		value = Width;
		return OK;
	}
	
	int setWidth(const float& newValue) {
		Width = newValue;
		Width_isNULL = false;
		return OK;
	}

	int getWeight(float& value) const {
		if (Weight_isNULL==true)
			return NOT_FOUND;
		value = Weight;
		return OK;
	}
	
	int setWeight(const float& newValue) {
		Weight = newValue;
		Weight_isNULL = false;
		return OK;
	}

	int getPackageType(unsigned short& value) const {
		if (PackageType_isNULL==true)
			return NOT_FOUND;
		value = PackageType;
		return OK;
	}
	
	int setPackageType(const unsigned short& newValue) {
		PackageType = newValue;
		PackageType_isNULL = false;
		return OK;
	}

	int getOtherPackageType(string& value) const {
		if (OtherPackageType_isNULL==true)
			return NOT_FOUND;
		value = OtherPackageType;
		return OK;
	}
	
	int setOtherPackageType(const string& newValue) {
		OtherPackageType = newValue;
		OtherPackageType_isNULL = false;
		return OK;
	}

	int getVendorCompatibilityStrings(vector<string>& value) const {
		if (VendorCompatibilityStrings_isNULL==true)
			return NOT_FOUND;
		value = VendorCompatibilityStrings;
		return OK;
	}
	
	int setVendorCompatibilityStrings(const vector<string>& newValue) {
		VendorCompatibilityStrings = newValue;
		VendorCompatibilityStrings_isNULL = false;
		return OK;
	}

	int getHostingBoard(bool& value) const {
		if (HostingBoard_isNULL==true)
			return NOT_FOUND;
		value = HostingBoard;
		return OK;
	}
	
	int setHostingBoard(const bool& newValue) {
		HostingBoard = newValue;
		HostingBoard_isNULL = false;
		return OK;
	}

	int getSlotLayout(string& value) const {
		if (SlotLayout_isNULL==true)
			return NOT_FOUND;
		value = SlotLayout;
		return OK;
	}
	
	int setSlotLayout(const string& newValue) {
		SlotLayout = newValue;
		SlotLayout_isNULL = false;
		return OK;
	}

	int getRequiresDaughterBoard(bool& value) const {
		if (RequiresDaughterBoard_isNULL==true)
			return NOT_FOUND;
		value = RequiresDaughterBoard;
		return OK;
	}
	
	int setRequiresDaughterBoard(const bool& newValue) {
		RequiresDaughterBoard = newValue;
		RequiresDaughterBoard_isNULL = false;
		return OK;
	}

	int getSpecialRequirements(bool& value) const {
		if (SpecialRequirements_isNULL==true)
			return NOT_FOUND;
		value = SpecialRequirements;
		return OK;
	}
	
	int setSpecialRequirements(const bool& newValue) {
		SpecialRequirements = newValue;
		SpecialRequirements_isNULL = false;
		return OK;
	}

	int getRequirementsDescription(string& value) const {
		if (RequirementsDescription_isNULL==true)
			return NOT_FOUND;
		value = RequirementsDescription;
		return OK;
	}
	
	int setRequirementsDescription(const string& newValue) {
		RequirementsDescription = newValue;
		RequirementsDescription_isNULL = false;
		return OK;
	}

	int getOperatingVoltages(vector<short>& value) const {
		if (OperatingVoltages_isNULL==true)
			return NOT_FOUND;
		value = OperatingVoltages;
		return OK;
	}
	
	int setOperatingVoltages(const vector<short>& newValue) {
		OperatingVoltages = newValue;
		OperatingVoltages_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Card_IsCompatible_In {

public:

	Objectpath ElementToCheck;
	bool ElementToCheck_isNULL;

	OpenDRIM_Card_IsCompatible_In() {
		ElementToCheck_isNULL = true;
	}

	~OpenDRIM_Card_IsCompatible_In() {}

	int getElementToCheck(Objectpath& value) const {
		if (ElementToCheck_isNULL == true)
			return NOT_FOUND;
		value = ElementToCheck;
		return OK;
	}
	int setElementToCheck(const Objectpath&  newValue) {
		ElementToCheck = newValue;
		ElementToCheck_isNULL = false;
		return OK;
	}

};

class OpenDRIM_Card_ConnectorPower_In {

public:

	Objectpath Connector;
	bool Connector_isNULL;

	bool PoweredOn;
	bool PoweredOn_isNULL;

	OpenDRIM_Card_ConnectorPower_In() {
		Connector_isNULL = true;
		PoweredOn_isNULL = true;
	}

	~OpenDRIM_Card_ConnectorPower_In() {}

	int getConnector(Objectpath& value) const {
		if (Connector_isNULL == true)
			return NOT_FOUND;
		value = Connector;
		return OK;
	}
	int setConnector(const Objectpath&  newValue) {
		Connector = newValue;
		Connector_isNULL = false;
		return OK;
	}

	int getPoweredOn(bool& value) const {
		if (PoweredOn_isNULL == true)
			return NOT_FOUND;
		value = PoweredOn;
		return OK;
	}
	int setPoweredOn(const bool&  newValue) {
		PoweredOn = newValue;
		PoweredOn_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_CARD_H_*/
