/* OGMRip - A library for DVD ripping and encoding
 * Copyright (C) 2004-2009 Olivier Rolland <billl@users.sourceforge.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <ogmrip-lavc.h>
#include <ogmrip-plugin.h>

#include <glib/gi18n-lib.h>

#define OGMRIP_TYPE_LAVC_MPEG1           (ogmrip_lavc_mpeg1_get_type ())
#define OGMRIP_LAVC_MPEG1(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMRIP_TYPE_LAVC_MPEG1, OGMRipLavcMpeg1))
#define OGMRIP_LAVC_MPEG1_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), OGMRIP_TYPE_LAVC_MPEG1, OGMRipLavcMpeg1Class))
#define OGMRIP_IS_LAVC_MPEG1(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMRIP_TYPE_LAVC_MPEG1))
#define OGMRIP_IS_LAVC_MPEG1_CLASS(obj)  (G_TYPE_CHECK_CLASS_TYPE ((klass), OGMRIP_TYPE_LAVC_MPEG1))
#define OGMRIP_LAVC_MPEG1_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), OGMRIP_TYPE_LAVC_MPEG1, OGMRipLavcMpeg1Class))

typedef struct _OGMRipLavcMpeg1      OGMRipLavcMpeg1;
typedef struct _OGMRipLavcMpeg1Class OGMRipLavcMpeg1Class;

struct _OGMRipLavcMpeg1
{
  OGMRipLavc parent_instance;
};

struct _OGMRipLavcMpeg1Class
{
  OGMRipLavcClass parent_class;
};

G_DEFINE_TYPE (OGMRipLavcMpeg1, ogmrip_lavc_mpeg1, OGMRIP_TYPE_LAVC)

G_CONST_RETURN gchar *
ogmrip_lavc_mpeg1_get_codec (void)
{
  const gchar *codec = "mpeg1video";

  return codec;
}

static void
ogmrip_lavc_mpeg1_class_init (OGMRipLavcMpeg1Class *klass)
{
  OGMRipLavcClass *lavc_class;

  lavc_class = (OGMRipLavcClass *) klass;
  lavc_class->get_codec = ogmrip_lavc_mpeg1_get_codec;
}

static void
ogmrip_lavc_mpeg1_init (OGMRipLavcMpeg1 *lavc_mpeg1)
{
}

static OGMRipVideoPlugin lavc_mpeg1_plugin =
{
  NULL,
  G_TYPE_NONE,
  "lavc-mpeg1",
  N_("Lavc Mpeg-1"),
  OGMRIP_FORMAT_MPEG1,
  G_MAXINT,
  8
};

OGMRipVideoPlugin *
ogmrip_init_plugin (GError **error)
{
  gchar *output;
  gboolean match;

  g_return_val_if_fail (error == NULL || *error == NULL, NULL);

#ifdef ENABLE_NLS
  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);
#endif /* ENABLE_NLS */

  if (!g_spawn_command_line_sync ("mencoder -ovc help", &output, NULL, NULL, NULL))
  {
    g_set_error (error, OGMRIP_PLUGIN_ERROR, OGMRIP_PLUGIN_ERROR_REQ, _("MEncoder is missing"));
    return NULL;
  }

  match = g_regex_match_simple ("^ *lavc *- .*$", output, G_REGEX_MULTILINE, 0);
  g_free (output);

  if (!match)
  {
    g_set_error (error, OGMRIP_PLUGIN_ERROR, OGMRIP_PLUGIN_ERROR_REQ, _("MEncoder is build without lavc support"));
    return NULL;
  }

  ogmrip_init_lavc_plugin ();

  lavc_mpeg1_plugin.type = OGMRIP_TYPE_LAVC_MPEG1;

  return &lavc_mpeg1_plugin;
}

