// Copyright (c) 1997-2003  Utrecht University (The Netherlands),
// ETH Zurich (Switzerland), Freie Universitaet Berlin (Germany),
// INRIA Sophia-Antipolis (France), Martin-Luther-University Halle-Wittenberg
// (Germany), Max-Planck-Institute Saarbruecken (Germany), RISC Linz (Austria),
// and Tel-Aviv University (Israel).  All rights reserved.
//
// This file is part of CGAL (www.cgal.org); you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; version 2.1 of the License.
// See the file LICENSE.LGPL distributed with CGAL.
//
// Licensees holding a valid commercial license may use this file in
// accordance with the commercial license agreement provided with the software.
//
// This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
// WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
//
// $Source: /opt/cvs/multisdfDIST/CGAL-3.1/include/CGAL/Arithmetic_filter/predicates/Regular_triangulation_rtH2.h,v $
// $Revision: 1.1.1.1 $ $Date: 2010/03/05 22:18:41 $
// $Name:  $
//
// Author(s)     : Sylvain Pion

// This file is automatically generated by
// scripts/filtered_predicates_generator.pl

#ifndef CGAL_ARITHMETIC_FILTER_REGULAR_TRIANGULATION_RTH2_H
#define CGAL_ARITHMETIC_FILTER_REGULAR_TRIANGULATION_RTH2_H

#include <CGAL/Profile_counter.h>

CGAL_BEGIN_NAMESPACE
template <class ET> class Lazy_exact_nt;
CGAL_END_NAMESPACE

CGAL_BEGIN_NAMESPACE

template < class CT, class ET, bool Protected, class Cache >
/*  */
Oriented_side
power_testH2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pwt,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qwt,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rhx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rhy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rhw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &rwt,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &twt)
{
  try
  {
    CGAL_PROFILER("IA power_testH2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return power_testH2(
		phx.interval(),
		phy.interval(),
		phw.interval(),
		pwt.interval(),
		qhx.interval(),
		qhy.interval(),
		qhw.interval(),
		qwt.interval(),
		rhx.interval(),
		rhy.interval(),
		rhw.interval(),
		rwt.interval(),
		thx.interval(),
		thy.interval(),
		thw.interval(),
		twt.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA power_testH2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return power_testH2(
		phx.exact(),
		phy.exact(),
		phw.exact(),
		pwt.exact(),
		qhx.exact(),
		qhy.exact(),
		qhw.exact(),
		qwt.exact(),
		rhx.exact(),
		rhy.exact(),
		rhw.exact(),
		rwt.exact(),
		thx.exact(),
		thy.exact(),
		thw.exact(),
		twt.exact());
  }
}

template < class ET >
/*  */
Oriented_side
power_testH2(
    const Lazy_exact_nt<ET> &phx,
    const Lazy_exact_nt<ET> &phy,
    const Lazy_exact_nt<ET> &phw,
    const Lazy_exact_nt<ET> &pwt,
    const Lazy_exact_nt<ET> &qhx,
    const Lazy_exact_nt<ET> &qhy,
    const Lazy_exact_nt<ET> &qhw,
    const Lazy_exact_nt<ET> &qwt,
    const Lazy_exact_nt<ET> &rhx,
    const Lazy_exact_nt<ET> &rhy,
    const Lazy_exact_nt<ET> &rhw,
    const Lazy_exact_nt<ET> &rwt,
    const Lazy_exact_nt<ET> &thx,
    const Lazy_exact_nt<ET> &thy,
    const Lazy_exact_nt<ET> &thw,
    const Lazy_exact_nt<ET> &twt)
{
  try
  {
    CGAL_PROFILER("Lazy IA power_testH2 calls");
    Protect_FPU_rounding<true> Protection;
    return power_testH2(
		phx.interval(),
		phy.interval(),
		phw.interval(),
		pwt.interval(),
		qhx.interval(),
		qhy.interval(),
		qhw.interval(),
		qwt.interval(),
		rhx.interval(),
		rhy.interval(),
		rhw.interval(),
		rwt.interval(),
		thx.interval(),
		thy.interval(),
		thw.interval(),
		twt.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA power_testH2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return power_testH2(
		phx.exact(),
		phy.exact(),
		phw.exact(),
		pwt.exact(),
		qhx.exact(),
		qhy.exact(),
		qhw.exact(),
		qwt.exact(),
		rhx.exact(),
		rhy.exact(),
		rhw.exact(),
		rwt.exact(),
		thx.exact(),
		thy.exact(),
		thw.exact(),
		twt.exact());
  }
}

template < class CT, class ET, bool Protected, class Cache >
/*  */
Oriented_side
power_testH2(
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &phw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &pwt,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qhw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &qwt,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thx,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thy,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &thw,
    const Filtered_exact <CT, ET, Dynamic, Protected, Cache> &twt)
{
  try
  {
    CGAL_PROFILER("IA power_testH2 calls");
    Protect_FPU_rounding<Protected> Protection;
    return power_testH2(
		phx.interval(),
		phy.interval(),
		phw.interval(),
		pwt.interval(),
		qhx.interval(),
		qhy.interval(),
		qhw.interval(),
		qwt.interval(),
		thx.interval(),
		thy.interval(),
		thw.interval(),
		twt.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("IA power_testH2 failures");
    Protect_FPU_rounding<!Protected> Protection(CGAL_FE_TONEAREST);
    return power_testH2(
		phx.exact(),
		phy.exact(),
		phw.exact(),
		pwt.exact(),
		qhx.exact(),
		qhy.exact(),
		qhw.exact(),
		qwt.exact(),
		thx.exact(),
		thy.exact(),
		thw.exact(),
		twt.exact());
  }
}

template < class ET >
/*  */
Oriented_side
power_testH2(
    const Lazy_exact_nt<ET> &phx,
    const Lazy_exact_nt<ET> &phy,
    const Lazy_exact_nt<ET> &phw,
    const Lazy_exact_nt<ET> &pwt,
    const Lazy_exact_nt<ET> &qhx,
    const Lazy_exact_nt<ET> &qhy,
    const Lazy_exact_nt<ET> &qhw,
    const Lazy_exact_nt<ET> &qwt,
    const Lazy_exact_nt<ET> &thx,
    const Lazy_exact_nt<ET> &thy,
    const Lazy_exact_nt<ET> &thw,
    const Lazy_exact_nt<ET> &twt)
{
  try
  {
    CGAL_PROFILER("Lazy IA power_testH2 calls");
    Protect_FPU_rounding<true> Protection;
    return power_testH2(
		phx.interval(),
		phy.interval(),
		phw.interval(),
		pwt.interval(),
		qhx.interval(),
		qhy.interval(),
		qhw.interval(),
		qwt.interval(),
		thx.interval(),
		thy.interval(),
		thw.interval(),
		twt.interval());
  } 
  catch (Interval_nt_advanced::unsafe_comparison)
  {
    CGAL_PROFILER("Lazy IA power_testH2 failures");
    Protect_FPU_rounding<false> Protection(CGAL_FE_TONEAREST);
    return power_testH2(
		phx.exact(),
		phy.exact(),
		phw.exact(),
		pwt.exact(),
		qhx.exact(),
		qhy.exact(),
		qhw.exact(),
		qwt.exact(),
		thx.exact(),
		thy.exact(),
		thw.exact(),
		twt.exact());
  }
}

CGAL_END_NAMESPACE

#endif // CGAL_ARITHMETIC_FILTER_REGULAR_TRIANGULATION_RTH2_H
