const char cgGLHollowCylinderFragmentShader[] = 
"// this is the fragment program\n"
"\n"
"\n"
"struct inputs\n"
"{\n"
"	float4 HPOS : POSITION;\n"
"	float4 texcoord : TEXCOORD0;\n"
"	float4 texcoord1 : TEXCOORD1;	// duplicate of HPOS to read it\n"
"	float4 texcoord2 : TEXCOORD2;\n"
"	float4 texcoord3 : TEXCOORD3;\n"
"	float4 primarycolor : COLOR0;\n"
"	float3 secondarycolor : COLOR1;\n"
"};\n"
"\n"
"float3 expand(float3 vector)\n"
"{\n"
"    return 2.0 * (vector - 0.5);\n"
"}\n"
"\n"
"// register combiner vector normalization function\n"
"float3 normalize(float3 vector)\n"
"{\n"
"    float3 VdotV = dot(expand(vector), expand(vector));\n"
"    return (1-saturate(VdotV)) * (vector-0.5) + expand(vector);\n"
"}\n"
"\n"
"float getOpacity(uniform float4x4 ModelViewProjInverse,\n"
"				 float4 ndcPos,\n"
"				 uniform float4 endPoint1,\n"
"				 uniform float3 cylinderDCs,\n"
"				 uniform float lengthOfCylinder)\n"
"{\n"
"	// 1. Get obj pos of point P\n"
"	float4 P = mul(ModelViewProjInverse,ndcPos);\n"
"\n"
"	// 2. t = (DCs . (P-P1)) / 1  ( 1 = DC.DC if DCs is normalized )\n"
"	float3 PminusP1 = (P-endPoint1).rgb;\n"
"	float y = dot(cylinderDCs, PminusP1);\n"
"\n"
"	float opacity = 0.0;\n"
"\n"
"	if( y >= 0 ) \n"
"	{\n"
"		if( y <= lengthOfCylinder )\n"
"		{\n"
"			opacity = 1.0;\n"
"		}\n"
"	}\n"
"\n"
"	return opacity;\n"
"}\n"
"\n"
"float4 main(inputs IN, out float depth: DEPTH,\n"
"			uniform float4 maincolor,\n"
"			uniform sampler1D normalmap,\n"
"			uniform sampler2D depthmap,\n"
"			uniform float4x4 ModelViewProjInverse,\n"
"			uniform float3 cylinderDCs,\n"
"			uniform float4 endPoint1,\n"
"			uniform float lengthOfCylinder) : COLOR\n"
"{\n"
"	float4 normal = 2.0 * (tex1D(normalmap, IN.texcoord.x) - 0.5);\n"
"	\n"
"	IN.secondarycolor.rgb = normalize(IN.secondarycolor.rgb);\n"
"\n"
"	float3 NdotL = dot(normal.rgb, IN.secondarycolor);\n"
"	float3 color = IN.primarycolor.rgb*(saturate(NdotL) + IN.primarycolor.w);\n"
"\n"
"    // calculate reflection vector\n"
"    // R = 2 * (N * (N dot L) - L/2)\n"
"    //   = 2 * N * (N dot L) - L\n"
"    float3 reflectVec = ((NdotL * normal.rgb) + (-0.5 * IN.secondarycolor)) * 2.0;\n"
"\n"
"    // eye vector E = (0, 0, 1)\n"
"    // R dot E = (R.r*0 + R.g*0 + 1*R.b) = R.b\n"
"    float RdotE = saturate(reflectVec.b);   // max(0, RdotE);\n"
"\n"
"    // calculate specular as pow(RdotE, 16)\n"
"	float specular = pow(RdotE, 16); \n"
"    // add specular light contribution to final color\n"
"	color += specular;\n"
"	\n"
"	float3 depthVal;\n"
"	float z;\n"
"	float w;\n"
"	float4 ndcPos;\n"
"\n"
"\n"
"	depthVal = tex2D(depthmap, IN.texcoord.xy).rgb;\n"
"	// this endPoint.a is totally overloaded !\n"
"	if( endPoint1.a < 0.0 ) \n"
"	{\n"
"		depthVal.r = -1.0 * depthVal.r;\n"
"		endPoint1.a = -1.0 * endPoint1.a;\n"
"		color = color*0.5;\n"
"	}\n"
"	endPoint1.a = 1.0;\n"
"\n"
"    z = dot(IN.texcoord2.xyz, depthVal);\n"
"    w = dot(IN.texcoord3.xyz, depthVal);\n"
"    depth = (z / w);\n"
"	ndcPos = float4( IN.texcoord1.x, IN.texcoord1.y, depth, 1.0 );\n"
"\n"
"	float opacity = getOpacity(ModelViewProjInverse,\n"
"				 ndcPos,\n"
"				 endPoint1,\n"
"				 cylinderDCs,\n"
"				 lengthOfCylinder);\n"
"	\n"
"	depth = depth*0.5 + 0.5;\n"
"	return float4(color, opacity);\n"
"}\n"
"\n"
"\n"
"// obtain the fragments rotation and offset on cylinder\n"
"// get a mod of the offset\n";

